//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"

//@import "CFG_2KJ_BREMSE_Model.js"


function Bestimme_Schutzart(oData)
{	
    //Schutzart
    var awhere = new Array();
    awhere.push({SCHUTZART_M3:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({SCHUTZART_M3:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({SCHUTZART_M3:"MOTTYP",Value:oData.oRow.MOTTYP});
    //awhere.push({SCHUTZART_M3:"CDROM_REL",Value:'1'});
    awhere.push({SCHUTZART_M3:"EINZELGETR",Value:'1'});
    awhere.push({SCHUTZART_M3:"MOTOR",Value:'1'});
    awhere.push({SCHUTZART_M3:"AKTIV",Value:"1"});
    awhere.push({SCHUTZART_M3:"G110M",Value:"0"});
    awhere.push({SCHUTZART_M3:"G115M",Value:"0"});
    awhere.push({SCHUTZART_M3:"G115D",Value:"0"});
    awhere.push({SCHUTZART_M3:"SONDER",Value:"-"});
    awhere.push({SCHUTZART_M3:"SCHUTZART",Value:"IP55;IP56;IP65"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        awhere.push({SCHUTZART_M3:"SCHUTZART",Value:'IP55'});
    }	
    else if( ECL_ValueSelected("ECSI_SPEZIFIKATION_CHECK", "ULR_CSA") || (ECL_ValueSelected("MIT_GEBER", "T") && ECL_GetValue("GEBER_FUNKT_SICHERHEIT") != "-") )
    {
        awhere.push({SCHUTZART_M3:"SCHUTZART",Value:'IP55;IP65'});
    }
    
    if(ECL_ValueSelected("MIT_BREMSE", "T"))
	{
		if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
		{
			awhere.push({SCHUTZART_M3:"KONSTAFS_BRE",Value:'Kauf'});
		}
		else
		{
			awhere.push({SCHUTZART_M3:"KONSTAFS_BRE",Value:'-'});
		}
	}
	else
	{
		awhere.push({SCHUTZART_M3:"KONSTAFS_BRE",Value:'-'});
	}

    var aAttributes = new Array();
    aAttributes.push({IDENT:"SCHUTZART",DB:"SCHUTZART"});
    ExecSQL_Standard("2KJ_DB", "SCHUTZART_M3", aAttributes, awhere);
    
    var aDefaultSQL = " AND DEFLT='1'";
    ExecSQL_GetDefaultStandard("2KJ_DB", "SCHUTZART_M3", aAttributes, awhere, aDefaultSQL);
}

function Bestimme_MotorSaeureschutz(oData)
{
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        ECL_DeselectValue("SAEURESCHUTZ_OPTION", "T");
        ECL_DisableAttribute("SAEURESCHUTZ_OPTION");
    }
    else
    {
        ECL_EnableValue("SAEURESCHUTZ_OPTION", "T");
        ECL_EnableAttribute("SAEURESCHUTZ_OPTION");
    }
}


function Bestimme_Belueftung(oData)
{
    
    // SIZER Vorgabe
    // 0 bedeutet voreingestellt Kunststofflüfter, Metalllüfter und Schwundradlüfter auswählbar
    // 1 bedeutet Fremdlüftung vorgeschrieben
    // 2,3,4 sind nur für Umrichter und dürfen hier nicht kommen.
    
    //ATEX Motorkenner bestimmen
    var strATEXKNZ_MOTFHT="";
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        var strATEXZone=ECL_GetValue("ATEX_ZONE");
        var strATEXExplosionsgruppe=ECL_GetValue("ATEX_EXPLOSIONSGRUPPE");
        var strATEXUmrichter=ECL_GetValue("ATEX_Umrichter");
        
        var strSelectATEX="";
        
        strSelectATEX="Select DISTINCT EX_SCHUTZ FROM ATEXKNZMOTOR WHERE ZONE='"+strATEXZone+"' AND ATEXKATEGORIE='"+strATEXExplosionsgruppe+"' AND M3='1' AND INFO_MOTTYP='MB' AND AKTIV='1' ";
        var aResult =  Object.fromDatabase( '2KJ_DB', strSelectATEX );
    
        if(aResult.length>0)
            strATEXKNZ_MOTFHT=left(aResult[0].EX_SCHUTZ,20)+"%";
        else
            logtraceln("Fehler beim Generieren der Motor MLFB ATEX; EX_SCHUTZ!");
        
    }
    
    var strSpecString=  createSpecString(oData);	
    
    var strSelect = "SELECT DISTINCT BELLUEFT FROM MOLUEFTER,MOTYPX WHERE ";
    strSelect = strSelect + "(MOLUEFTER.MOTTYP = '"+oData.oRow.MOTTYP+"' OR MOLUEFTER.MOTTYP='ALL') AND ";
    strSelect = strSelect + "MOLUEFTER.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOLUEFTER.MOBSANB = '"+Bestimme_MobsAnb(oData)+"' AND ";
    strSelect = strSelect + "MOLUEFTER.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "(MOLUEFTER.MOTELAUSF = '"+strSpecString+"' OR MOLUEFTER.MOTELAUSF = 'ALL') AND ";
    
    strSelect = strSelect + "MOLUEFTER.BELART = MOTYPX.BELART AND ";
    strSelect = strSelect + "MOLUEFTER.SHWG = MOTYPX.SHWG AND ";
    strSelect = strSelect + "MOLUEFTER.REGION = 'S' AND ";
    strSelect = strSelect + "MOLUEFTER.G115D = '0' AND MOLUEFTER.G115M='0' AND MOLUEFTER.SONDER='-' AND ";
    
    if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '1' AND ";
	}
	else
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '0' AND ";
	}

    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOLUEFTER.ATEX = '1' AND ";
        strSelect = strSelect + "(MOLUEFTER.EX_SCHUTZ like '"+strATEXKNZ_MOTFHT+"' OR MOLUEFTER.EX_SCHUTZ = 'ALL') AND ";
    }
    else
    {
        strSelect = strSelect + "MOLUEFTER.ATEX = '0' AND ";
        strSelect = strSelect + "MOLUEFTER.EX_SCHUTZ = 'ALL' AND ";
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CAST(MOLUEFTER.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
    
    strSelect = strSelect + Bestimme_MOTYPXFilter(oData);
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
    {
        var strBaseTypeMLFB=ECL_GetValue("ECSI_MLFB_BASE_TYPE");
        strBaseTypeMLFB=replace(strBaseTypeMLFB,"-","");
        strBaseTypeMLFB=replace(strBaseTypeMLFB,strBaseTypeMLFB.left(16),"");
        
        var ForcedVentilationMandatory=find(strBaseTypeMLFB, "M23") > -1;
        var SelfVentilatedMandatory=find(strBaseTypeMLFB, "M23") < 0;
        
        if(oData.oRow.SIZER_CoolingMethod==0 || SelfVentilatedMandatory)
            strSelect = strSelect + "MOLUEFTER.BELLUEFT <> 'Zugeordneter Luefter' AND ";
        else if(oData.oRow.SIZER_CoolingMethod==1 || ForcedVentilationMandatory)
            strSelect = strSelect + "MOLUEFTER.BELLUEFT = 'Zugeordneter Luefter' AND ";
    }
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "MOLUEFTER.M3 = '"+oData.oRow.M3+"' ";
    strSelect = strSelect + "AND MOLUEFTER.GM3 = '"+oData.oRow.GM3+"' ";
    
    //MOTYPX_UNDEF mit abfragen
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
    
    strSelect = strSelect + "AND MOTYPX.ZUSBEZ NOT IN (SELECT DISTINCT ZUSBEZ FROM MOTYPX_UNDEF WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "(POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL")+"' OR POLZAHL = '-') AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"' AND ";
    
    if(ECL_ValueSelected("MIT_BREMSE", "T"))
    {
        strSelect = strSelect + "(KONSTBREM='Kauf' OR KONSTBREM='ALL')) ";
    }
    else
    {
        strSelect = strSelect + "KONSTBREM='ALL') ";
    }
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("BELUEFTUNG");
	if(aResult.length>0)
	{
		for(var i=0;i<aResult.length;i++)
		{
			if(aResult[i].BELLUEFT == "Schwungradluefter" && (!ECL_ValueSelected("MIT_GEBER", "T") || ECL_GetValue("GEBER_FUNKT_SICHERHEIT")=="-") )
				ECL_ActivateValue("BELUEFTUNG",aResult[i].BELLUEFT);
			else if(aResult[i].BELLUEFT == "Metall")
				ECL_ActivateValue("BELUEFTUNG",aResult[i].BELLUEFT);
			else if(aResult[i].BELLUEFT == "Metall (Standard_ATEX)")
				ECL_ActivateValue("BELUEFTUNG",aResult[i].BELLUEFT);
			else if(aResult[i].BELLUEFT == "Zugeordneter Luefter")
				ECL_ActivateValue("BELUEFTUNG",aResult[i].BELLUEFT);
			else if(aResult[i].BELLUEFT == "Kunststoff")
				ECL_ActivateValue("BELUEFTUNG",aResult[i].BELLUEFT);	
			else if(aResult[i].BELLUEFT == "Standard" && ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
				ECL_ActivateValue("BELUEFTUNG",aResult[i].BELLUEFT);
			else if(aResult[i].BELLUEFT == "Standard (Metall)" && (ECL_GetValue("ECSI_WMFU_KENNER")=="ja" || ECL_ValueSelected("ECSI_SPEZIFIKATION_CHECK", "ULR_CSA")))
				ECL_ActivateValue("BELUEFTUNG",aResult[i].BELLUEFT);
		}
	}
	else
		logtraceln("Fehler bei Bestimmung Befüftungsart!, SQL="+strSelect);
	
	//Default Wert bestimmen
	if(isnewDefaultnecessary("BELUEFTUNG"))
	{
		if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
			ExecSetStandardifValueEmpty("BELUEFTUNG", "Standard");
		else if( (ECL_GetValue("ECSI_WMFU_KENNER")=="ja" || ECL_ValueSelected("ECSI_SPEZIFIKATION_CHECK", "ULR_CSA")) && (oData.oRow.MOTDIM=="132" || oData.oRow.MOTDIM=="160"))
			ExecSetStandardifValueEmpty("BELUEFTUNG", "Standard (Metall)");
		else
			ExecSetStandardifValueEmpty("BELUEFTUNG", "Kunststoff");
	}
}

function Check_Fremdbelueftung(oData)
{
    
    // SIZER Vorgabe
    // 0 bedeutet voreingestellt Kunststofflüfter, Metalllüfter und Schwundradlüfter auswählbar
    // 1 bedeutet Fremdlüftung vorgeschrieben
    // 2,3,4 sind nur für Umrichter und dürfen hier nicht kommen.
    
    //ATEX Motorkenner bestimmen
    var strATEXKNZ_MOTFHT="";
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        var strATEXZone=ECL_GetValue("ATEX_ZONE");
        var strATEXExplosionsgruppe=ECL_GetValue("ATEX_EXPLOSIONSGRUPPE");
        var strATEXUmrichter=ECL_GetValue("ATEX_Umrichter");
        
        var strSelectATEX="";
        
        strSelectATEX="Select DISTINCT EX_SCHUTZ FROM ATEXKNZMOTOR WHERE ZONE='"+strATEXZone+"' AND ATEXKATEGORIE='"+strATEXExplosionsgruppe+"' AND M3='1' AND INFO_MOTTYP='MB' AND AKTIV='1' ";
        var aResult =  Object.fromDatabase( '2KJ_DB', strSelectATEX );
    
        if(aResult.length>0)
            strATEXKNZ_MOTFHT=aResult[0].EX_SCHUTZ;
        else
            logtraceln("Fehler beim Generieren der Motor MLFB ATEX; EX_SCHUTZ!");
        
    }
    
    var strSpecString=  createSpecString(oData);	
    
    var strSelect = "SELECT DISTINCT BELLUEFT FROM MOLUEFTER,MOTYPX WHERE ";
    strSelect = strSelect + "(MOLUEFTER.MOTTYP = '"+oData.oRow.MOTTYP+"' OR MOLUEFTER.MOTTYP='ALL') AND ";
    strSelect = strSelect + "MOLUEFTER.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOLUEFTER.MOBSANB = '"+Bestimme_MobsAnb(oData)+"' AND ";
    strSelect = strSelect + "MOLUEFTER.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "(MOLUEFTER.MOTELAUSF = '"+strSpecString+"' OR MOLUEFTER.MOTELAUSF = 'ALL') AND ";
    
    strSelect = strSelect + "MOLUEFTER.BELART = MOTYPX.BELART AND ";
    strSelect = strSelect + "MOLUEFTER.SHWG = MOTYPX.SHWG AND ";
    strSelect = strSelect + "MOLUEFTER.REGION = 'S' AND ";
    strSelect = strSelect + "MOLUEFTER.G115D = '0' AND MOLUEFTER.G115M='0' AND MOLUEFTER.SONDER='-' AND ";
    strSelect = strSelect + "MOLUEFTER.BELLUEFT = 'Zugeordneter Luefter' AND ";
    
    if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '1' AND ";
	}
	else
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '0' AND ";
	}

    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOLUEFTER.ATEX = '1' AND ";
        strSelect = strSelect + "(MOLUEFTER.EX_SCHUTZ = '"+strATEXKNZ_MOTFHT+"' OR MOLUEFTER.EX_SCHUTZ = 'ALL') AND ";
    }
    else
    {
        strSelect = strSelect + "MOLUEFTER.ATEX = '0' AND ";
        strSelect = strSelect + "MOLUEFTER.EX_SCHUTZ = 'ALL' AND ";
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CAST(MOLUEFTER.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
    
    strSelect = strSelect + Bestimme_MOTYPXFilter(oData);
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
    {
        if(oData.oRow.SIZER_CoolingMethod==0)
            strSelect = strSelect + "MOLUEFTER.BELLUEFT <> 'Zugeordneter Luefter' AND ";
        else if(oData.oRow.SIZER_CoolingMethod==1)
            strSelect = strSelect + "MOLUEFTER.BELLUEFT = 'Zugeordneter Luefter' AND ";
    }
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "MOLUEFTER.M3 = '"+oData.oRow.M3+"' ";
    strSelect = strSelect + "AND MOLUEFTER.GM3 = '"+oData.oRow.GM3+"' ";
    
    //MOTYPX_UNDEF mit abfragen
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
    
    strSelect = strSelect + "AND MOTYPX.ZUSBEZ NOT IN (SELECT DISTINCT ZUSBEZ FROM MOTYPX_UNDEF WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "(POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL")+"' OR POLZAHL = '-') AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"' AND ";
    
    if(ECL_ValueSelected("MIT_BREMSE", "T"))
    {
        strSelect = strSelect + "(KONSTBREM='Kauf' OR KONSTBREM='ALL')) ";
    }
    else
    {
        strSelect = strSelect + "KONSTBREM='ALL') ";
    }
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    //logtraceln("SQL für Fremdbelüftung, SQL="+strSelect);
    
    if(aResult.length>0)
        return true;
    else
        return false;
    
}

function Bestimme_MOTYPXFilter(oData)
{
    var strSelect="";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION", "T"))
        strSelect = strSelect + "MOTYPX.BELSDACH = 'W' AND ";
    else
        strSelect = strSelect + "MOTYPX.BELSDACH = '-' AND ";
        
    strSelect = strSelect + "MOTYPX.UNBELUEFT = '-' AND ";
    
    if(ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION", "T"))
        strSelect = strSelect + "MOTYPX.MOTRLSP = 'X' AND ";
    else
        strSelect = strSelect + "MOTYPX.MOTRLSP = '-' AND ";
    
    if(ECL_ValueSelected("HANDRAD_OPTION", "T"))
        strSelect = strSelect + "MOTYPX.HANDRAD = 'D' AND ";
    else
        strSelect = strSelect + "MOTYPX.HANDRAD = '-' AND ";
        
    strSelect = strSelect + "MOTYPX.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOTYPX.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
    strSelect = strSelect + "MOTYPX.BRANCHE IN ('"+oData.oRow.ANWTYP+"','ALL') AND ";

    if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '1' AND ";
	}
	else
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '0' AND ";
	}
    
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOTYPX.ATEX = '1' AND ";
    }
    else
    {
        strSelect = strSelect + "MOTYPX.ATEX = '0' AND ";
    }
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "MOTYPX.M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "MOTYPX.GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "MOTYPX.G110M ='-' AND ";
    strSelect = strSelect + "MOTYPX.AKTIV IN ('1','2') AND ";
	strSelect = strSelect + "MOTYPX.REGION IN ('SA','SAC','SACM','SACMR','SACR','SAM','SAMC','SAMCI','SAMCIR','SAMCR','SAMR') AND ";    
    var strHEMOTOR="-";
    var strMotbez=oData.oRow.MOT_BZ_LANG;
    if(oData.oRow.VSDMOTOR=="V")
    {
        strMotbez=trimright(strMotbez,"V");
        if(strMotbez.right(1)=="S"){
            strHEMOTOR="S";
        }
        else if(strMotbez.right(1)=="P"){
			strHEMOTOR="P";
        }
    }
    else
    {
        if(strMotbez.right(1) == "E")
            strHEMOTOR = 'E';
        else if(strMotbez.right(1) == "P")
            strHEMOTOR = 'P';
    }
    
    strSelect = strSelect + "MOTYPX.HEMOTOR = '"+strHEMOTOR+"' AND ";
        
    return (strSelect);
}

function Bestimme_MobsAnb(oData)
{
    if( ECL_ValueSelected("MIT_BREMSE", "T")  && ECL_ValueSelected("ZWEITES_WELLENENDE_OPTION", "T") )
    {
        return ("BR_2WE");
    }
    else if(ECL_ValueSelected("MIT_BREMSE", "T"))
    {
        return ("BR");
    }
    else if(ECL_ValueSelected("ZWEITES_WELLENENDE_OPTION", "T"))
    {
        return ("2WE");
    }
    else
        return ("-");

}

function Bestimme_Klemmkastenlage(oData)
{
    
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    
    var strSelect = "SELECT DISTINCT KKLAGE FROM MOKKLPOS_M3 WHERE ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "(EGANFLDM = '"+oData.oRow.EGANFLDM+"' OR EGANFLDM = 'ALL') AND ";
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        strSelect = strSelect + "ATEX = '1' AND ";
    }
    else
    {
        strSelect = strSelect + "ATEX = '0' AND ";
    }
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "CDROM_REL = '1' AND ";
    strSelect = strSelect + "G110M='0' AND G115D='0' AND G115M='0' AND SONDER='-' AND ";
    strSelect = strSelect + "REGION IN ('S','SN') AND ";
    
    strSelect = strSelect + "KKLAGE NOT IN (";
    strSelect = strSelect + "SELECT DISTINCT KKLAGE FROM MOKKLPOS_UNDEF6 WHERE ";
    
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    strSelect = strSelect + "MOABSSART='"+strMOABSSART+"' AND ";
    strSelect = strSelect + "MECH_ZUB = '"+ECL_GetValue("GEBER_ZUB_KABEL")+"') AND ";
    
    strSelect = strSelect + "KKLAGE NOT IN (";
    strSelect = strSelect + "SELECT DISTINCT KKLAGE FROM MOKKLPOS_UNDEF5 WHERE ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
    strSelect = strSelect + "EGPOSHL='"+ECL_GetValue("BAUFORM")+"' AND ";
    strSelect = strSelect + "MOTDIM='"+oData.oRow.MOTDIM+"') ";
    
    if(ECL_GetValue("MOTORSTECKER") != "M" && ECL_GetValue("MOTORSTECKER") != "NPT")
    {
        var strPAKZUS = Bestimme_PAKZUS(oData);
            
        strSelect = strSelect + "AND KKLAGE NOT IN (";
        strSelect = strSelect + "SELECT DISTINCT KKLAGE FROM MOKKLPOS_UNDEF8 WHERE ";
        strSelect = strSelect + "PAKZUS='"+strPAKZUS+"' AND ";
        strSelect = strSelect + "EGANFLDM='"+oData.oRow.EGANFLDM+"' AND ";
        strSelect = strSelect + "MOTDIM='"+oData.oRow.MOTDIM+"') ";
    }
    
    strSelect = strSelect + "ORDER BY KKLAGE ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("KLEMMKASTENLAGE");
    
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("KLEMMKASTENLAGE",aResult[i].KKLAGE);
            
            var strImage="2KJ3\\%LANG%\\motoroptionen\\Anschlusskasten\\"+aResult[i].KKLAGE+"_"+oData.oRow.EGBEZTYP+".png";
            ECL_SetValueImage ("KLEMMKASTENLAGE", aResult[i].KKLAGE, strImage);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Klemmkastenlage!, SQL="+strSelect);
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("KLEMMKASTENLAGE"))
    {
        ExecSetStandardifValueEmpty("KLEMMKASTENLAGE","1A");
    }
}

function Bestimme_PAKZUS(oData)
{
    var strMOTBEZ = oData.oRow.MOT_BZ_LANG;
    if(find(strMOTBEZ,"Z") > -1)
        return "Z";
    else
        return "-";	
}

function Bestimme_Kabelverschraubung(oData)
{
    var strMotorstecker="";
    var strGegenstecker="";
    
    if(ECL_GetValue("MOTORSTECKER") != "M" && ECL_GetValue("MOTORSTECKER") != "NPT")
    {
        strMotorstecker = ECL_GetValue("MOTORSTECKER");
        
        strGegenstecker = ECL_GetValue("GEGENSTECKER");
    }
    else
    {
        if(parseInt(oData.oRow.MOTDIM) > 160)
            strMotorstecker = "GG";
        else
            strMotorstecker = "Aluminium";
        strGegenstecker = "ohne";
    }
    
    var strSelect = "SELECT DISTINCT KKVS FROM KKVS_M3 WHERE ";

    var strSpecString=  createSpecString(oData);	
    
    strSelect = strSelect + "MOTELAUSF = '"+strSpecString+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        strSelect = strSelect + "ATEX = '1' AND ";
    }
    else
    {
        strSelect = strSelect + "ATEX = '0' AND ";
    }
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "G110M='0' AND ";
    strSelect = strSelect + "G115D='0' AND ";
    strSelect = strSelect + "G115M='0' AND ";
    
    strSelect = strSelect + "KKMAT = '"+strMotorstecker+"' AND ";
    strSelect = strSelect + "KKMAT_ZUB = '"+strGegenstecker+"' AND ";
    
    strSelect = strSelect + "REGION IN ('S','SC','SCI','SI') AND ";
    strSelect = strSelect + "AKTIV = '1' ";
    
    ECL_DeactivateAllAttributeValues("KABELVERSCHRAUBUNG");
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    if ( aResult.length > 0 )
    {	
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("KABELVERSCHRAUBUNG", aResult[i].KKVS);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Kabelverschraubung! SQL="+strSelect);
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("KABELVERSCHRAUBUNG"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT = '1'");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("KABELVERSCHRAUBUNG", aResultDefault[0].KKVS);
        }
        else
        {
            ECL_SelectValue("KABELVERSCHRAUBUNG", aResult[0].KKVS);
        }
    }
}

function istErdung_moeglich(oData)
{
    //Tabelle MOTERD
    //0 = nicht möglich 1 = möglich 2 = vorgeschrieben
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
    
    var strSelect = "SELECT DISTINCT MOTERD FROM MOTERD WHERE ";
    
    strSelect = strSelect + "MOTTYP='"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL='"+strMOEINKL+"' AND ";
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "REGION = 'S' AND ";
    strSelect = strSelect + "G115M='0' AND G115D='0' AND ";
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        strSelect = strSelect + "ATEX = '1' AND ";
    }
    else
    {
        strSelect = strSelect + "ATEX = '0' AND ";
    }
        
    strSelect = strSelect + "AKTIV = '1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    //Es sollte nur ein Ergebnis geben
    if ( aResult.length == 1 )
    {
        if(aResult[0].MOTERD == "0")
        {
            ECL_DeselectValue("ERDUNGSSCHRAUBE_OPTION", "T");
            ECL_DisableAttribute("ERDUNGSSCHRAUBE_OPTION");
        }
        else if(aResult[0].MOTERD == "1")
        {
            ECL_EnableValue("ERDUNGSSCHRAUBE_OPTION", "T");
            ECL_EnableAttribute("ERDUNGSSCHRAUBE_OPTION");
        }
        else if(aResult[0].MOTERD == "2")
        {
            ECL_EnableValue("ERDUNGSSCHRAUBE_OPTION", "T");
            ECL_SelectValue("ERDUNGSSCHRAUBE_OPTION", "T");
            ECL_DisableAttribute("ERDUNGSSCHRAUBE_OPTION");
        }
        else
        {
            logtraceln("Fehler Bestimmung äußere Erdungsschraube! SQL="+strSelect);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung äußere Erdungsschraube! SQL="+strSelect);
    }
}

function istAnschlusskastenNeutral_moeglich(oData)
{
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        ECL_DeselectValue("ANSCHLUSSKASTEN_NEUTRAL_OPTION", "T");
        ECL_DisableAttribute("ANSCHLUSSKASTEN_NEUTRAL_OPTION");
    }
    else
    {
        ECL_EnableValue("ANSCHLUSSKASTEN_NEUTRAL_OPTION", "T");
        ECL_EnableAttribute("ANSCHLUSSKASTEN_NEUTRAL_OPTION");
    }
}

function istAnschlusskastenVergossen_moeglich(oData)
{
    var strSpecString=  createSpecString(oData);	
    
    var strSelect = "SELECT DISTINCT KKABDICH FROM KKABDICH_M3 WHERE ";
    strSelect = strSelect + "ANWTYP = '"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "SCHUTZART = '"+ECL_GetValue("SCHUTZART")+"' AND ";
    strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOTELAUSF = '"+strSpecString+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "CDROM_REL = '1' AND ";
    strSelect = strSelect + "AKTIV = '1' AND ";
    strSelect = strSelect + "REGION = 'S' AND ";
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        strSelect = strSelect + "ATEX = '1' ";
    }
    else
    {
        strSelect = strSelect + "ATEX = '0' ";
    }
    
    var bohneAnschlusskasten_vergossen_moeglich=false;
    var bmitAnschlusskasten_vergossen_moeglich=false;
    ECL_EnableAttribute("ANSCHLUSSKASTEN_VERGOSSEN_OPTION");
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            if(aResult[i].KKABDICH=="ohne" || aResult[i].KKABDICH=="Standard")
            {
                bohneAnschlusskasten_vergossen_moeglich=true;
            }
            else if(aResult[i].KKABDICH=="vergossen")
            {
                bmitAnschlusskasten_vergossen_moeglich=true;
            }
        }
    }
    else
    {
        logtraceln("Fehler bei Bestimmung des Anschlusskastens vergossen! SQL="+strSelect);
    } 
    
    if(!bohneAnschlusskasten_vergossen_moeglich && bmitAnschlusskasten_vergossen_moeglich)
    {
        ECL_SelectValue("ANSCHLUSSKASTEN_VERGOSSEN_OPTION", "T");
        ECL_DisableAttribute("ANSCHLUSSKASTEN_VERGOSSEN_OPTION");
    }
    else if(bohneAnschlusskasten_vergossen_moeglich && !bmitAnschlusskasten_vergossen_moeglich)
    {
        ECL_DeselectValue("ANSCHLUSSKASTEN_VERGOSSEN_OPTION", "T");
        ECL_DisableAttribute("ANSCHLUSSKASTEN_VERGOSSEN_OPTION");
    }
}

function Bestimme_Motorstecker(oData,oDataBremse)
{
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        var strSelect = "SELECT DISTINCT KKMAT_ATEX.KKMAT FROM KKMAT_ATEX WHERE ";
        strSelect = strSelect + "KKMAT_ATEX.MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
        strSelect = strSelect + "KKMAT_ATEX.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
        strSelect = strSelect + "KKMAT_ATEX.AKTIV = '1' AND ";
        strSelect = strSelect + "KKMAT_ATEX.REGION = 'S' ";
        
        ECL_DeactivateAllAttributeValues("MOTORSTECKER");
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
                
        if(aResult.length>0)
        {
            for(var i=0;i<aResult.length;i++)
            {
                var strKKMAT=aResult[i].KKMAT;
                ECL_ActivateValue("MOTORSTECKER",strKKMAT);
            }
        }
        else
            logtraceln("Fehler bei Bestimmung Motorstecker!, SQL="+strSelect);
            

        ExecSetStandardifValueEmpty("MOTORSTECKER","Standard");
    }
    else
    {
		var strMOEINKL = oData.oRow.MOT_BZ_LANG;
		strMOEINKL = strMOEINKL.left(3);
		if(strMOEINKL.right(1) == "N"){
			strMOEINKL = "N";
        }
		else if(strMOEINKL.right(1) == "S"){
			strMOEINKL = "S";
        }
		else{
			strMOEINKL = "-";
        }
		var strSelect = "SELECT DISTINCT KKMAT_M3.KKMAT FROM KKMAT_M3,KKMAT_BRANCHE_M3 WHERE ";
		strSelect = strSelect + "KKMAT_M3.MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
		strSelect = strSelect + "KKMAT_M3.MOEINKL IN ('"+strMOEINKL+"','ALL') AND ";
		strSelect = strSelect + "KKMAT_M3.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
		strSelect = strSelect + "KKMAT_M3.KKMAT NOT IN ('Aluminium','GG','Verschl.stopfen M25','Verschl.stopfen G110M','Verschl.stopfen', 'X15','Quickon','Standard','ohne') AND ";
		strSelect = strSelect + "KKMAT_M3.MECH_ZUB = '"+ECL_GetValue("GEBER_ZUB_KABEL")+"' AND ";
		strSelect = strSelect + "KKMAT_M3.S09 = '"+oData.oRow.S09+"' AND ";
		strSelect = strSelect + "KKMAT_M3.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
		strSelect = strSelect + "KKMAT_M3.REGION IN ('S','SCE','SCEN','SCN','SN') AND ";
		strSelect = strSelect + "KKMAT_M3.CDROM_REL = '1' AND ";
		strSelect = strSelect + "KKMAT_M3.G110M = '0' AND ";
		strSelect = strSelect + "KKMAT_M3.G115M='0' AND KKMAT_M3.G115D='0' AND ";
		strSelect = strSelect + "KKMAT_M3.KKMAT=KKMAT_BRANCHE_M3.KKMAT AND ";
		strSelect = strSelect + "KKMAT_BRANCHE_M3.BRANCHE = '"+oData.oRow.ANWTYP+"' AND ";
		strSelect = strSelect + "KKMAT_BRANCHE_M3.SONDER = '-' AND ";
		strSelect = strSelect + "KKMAT_M3.AKTIV = '1' AND ";
		strSelect = strSelect + "KKMAT_BRANCHE_M3.AKTIV = '1' AND ";
		
		if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
		{
			strSelect = strSelect + "KKMAT_M3.WM_FU IN ('1','ALL') ";
		}
		else
		{
			strSelect = strSelect + "KKMAT_M3.WM_FU IN ('0','ALL') ";
		}
		
		
        //weitere UNDEF KKMAT_M3_UNDEF
        var strWIELART = ECL_GetValue("MOTORSCHUTZ");
        
        var strHeizung = "-";
        if(ECL_GetValue("STILLSTANDSHEIZUNG") != "ohne"){
            strHeizung =  "mit";
        }
        
        var strBREAUS = "";
        var strBrakeMonitoring = "";
        var strKONSTBREM;
        if(ECL_ValueSelected("MIT_BREMSE", "T"))
        {
            strBREAUS = ECL_GetValue("BREMSE_AUSFUEHRUNG");
            
            //gekapselte Bremse ist "-" in der Tabelle
            if(strBREAUS == "G" || strBREAUS == "GK")
                strBREAUS = "-";
            
            strBrakeMonitoring = ECL_GetValue("BREMSE_UEBERWACHUNG");
            if(strBrakeMonitoring == "MS fuer Luefterkontrolle")
                strBREAUS = "M";
                
            strKONSTBREM = "Kauf";
        }
        else
        {
            strBREAUS = "-";
            strKONSTBREM = "-";
        }
        
        strSelect = strSelect + "AND KKMAT_M3.KKMAT NOT IN ( SELECT KKMAT_M3_UNDEF.KKMAT FROM KKMAT_M3_UNDEF WHERE WIELART = '"+strWIELART+"' AND HEIZUNG = '"+strHeizung+"' AND BREAUS = '"+strBREAUS+"' AND KONSTBREM = '"+strKONSTBREM+"') ";
        
        var KKMAT_KKBRETTBO = Bestimme_GrenzwerteStromundSpannung(oData,oDataBremse);
        strSelect = strSelect +  "AND KKMAT_M3.KKMAT IN "+KKMAT_KKBRETTBO+" ";
        
        ECL_DeactivateAllAttributeValues("MOTORSTECKER");
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        
        if(!ECL_ValueSelected("SCHUTZART", "IP56"))
        {
            if(aResult.length>0)
            {
                for(var i=0;i<aResult.length;i++)
                {
                    var strKKMAT=aResult[i].KKMAT;
                    ECL_ActivateValue("MOTORSTECKER",strKKMAT);
                }
            }
            else
                logtraceln("Fehler bei Bestimmung Motorstecker!, SQL="+strSelect);
        }
        else
            logtraceln("Motorstecker nicht nmöglich (IP56)!, SQL="+strSelect);
        
        
        //Jetzt Kabelverschraubung
        var strSelect2 = "SELECT DISTINCT KKVS FROM KKVS_M3 WHERE ";

        var strSpecString=  createSpecString(oData);	
        
        strSelect2 = strSelect2 + "MOTELAUSF = '"+strSpecString+"' AND ";
        strSelect2 = strSelect2 + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
        strSelect2 = strSelect2 + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
        strSelect2 = strSelect2 + "G110M='0' AND ";
        strSelect2 = strSelect2 + "G115M='0' AND G115D='0' AND ";
        
        if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
        {
            strSelect2 = strSelect2 + "ATEX = '1' AND ";
        }
        else
        {
            strSelect2 = strSelect2 + "ATEX = '0' AND ";
        }
        
        strSelect2 = strSelect2 + "KKMAT IN ('Verschl.stopfen M25','Aluminium','GG') AND ";
        strSelect2 = strSelect2 + "KKMAT_ZUB = 'ohne' AND ";
        
        //bisher gibt es nur S und SI
        strSelect2 = strSelect2 + "REGION IN ('S','SI','SC','SCI') AND ";
        strSelect2 = strSelect2 + "AKTIV = '1' ";
        
        var aResult2 = ExecSQL_Standard_SO("2KJ_DB", strSelect2);
        if ( aResult2.length > 0 )
        {	
            for(var i=0;i<aResult2.length;i++)
            {
                ECL_ActivateValue("MOTORSTECKER", aResult2[i].KKVS);
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Kabelverschraubung! SQL="+strSelect2);
        }
        
        //Default Wert bestimmen
        if(isnewDefaultnecessary("MOTORSTECKER"))
        {
            var aResultDefault2 = ExecSQL_Standard_SO("2KJ_DB", strSelect2+" AND DEFLT = '1'");
            if(aResultDefault2.length>0)
            {
                ECL_SelectValue("MOTORSTECKER", aResultDefault2[0].KKVS);
            }
            else
            {
                var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT = '1'");
                if(aResultDefault.length>0)
                {
                    var strKKMAT=aResultDefault[0].KKMAT;
                    ECL_SelectValue("MOTORSTECKER", strKKMAT);
                }
                else if(aResult.length>0)
                {
                    var strKKMAT=aResult[0].KKMAT;
                    ECL_SelectValue("MOTORSTECKER", strKKMAT);
                }
                else
                {
                    ECL_SelectValue("MOTORSTECKER", aResult2[0].KKVS);
                }
            }
        }
    }
}

function Bestimme_Motorstecker_Gegenstecker(oData,oDataBremse)
{
    var strKKMAT=ECL_GetValue("MOTORSTECKER");
    
    var strSelect = "SELECT DISTINCT KKMAT_ZUB FROM KKMAT_M3 WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "KKMAT <> 'Aluminium' AND ";
    strSelect = strSelect + "MECH_ZUB = '"+ECL_GetValue("GEBER_ZUB_KABEL")+"' AND ";
    strSelect = strSelect + "KKMAT_M3.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "KKMAT_M3.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
	strSelect = strSelect + "KKMAT_M3.REGION IN ('S','SCE','SCEN','SCN','SN') AND ";
	strSelect = strSelect + "CDROM_REL = '1' AND ";
	strSelect = strSelect + "KKMAT = '"+strKKMAT+"' AND ";
	strSelect = strSelect + "G110M = '0' AND ";
	strSelect = strSelect + "KKMAT_M3.G115M='0' AND KKMAT_M3.G115D='0' AND ";
	
    if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
	{
		strSelect = strSelect + "KKMAT_M3.WM_FU IN ('1','ALL') ";
	}
	else
	{
		strSelect = strSelect + "KKMAT_M3.WM_FU IN ('0','ALL') ";
	}

    //weitere UNDEF KKMAT_M3_UNDEF
    var strWIELART = ECL_GetValue("MOTORSCHUTZ");
    
    var strHeizung = "-";
    if(ECL_GetValue("STILLSTANDSHEIZUNG") != "ohne")
        strHeizung =  "mit";
    
    var strBREAUS = "";
    var strBrakeMonitoring = "";
    var strKONSTBREM;
    if(ECL_ValueSelected("MIT_BREMSE", "T"))
    {
        strBREAUS = ECL_GetValue("BREMSE_AUSFUEHRUNG");
        
        //gekapselte Bremse ist "-" in der Tabelle
        if(strBREAUS == "G" || strBREAUS == "GK")
            strBREAUS = "-";
        
        strBrakeMonitoring = ECL_GetValue("BREMSE_UEBERWACHUNG");
        if(strBrakeMonitoring == "MS fuer Luefterkontrolle")
            strBREAUS = "M";
            
        strKONSTBREM = "Kauf";
    }
    else
    {
        strBREAUS = "-";
        strKONSTBREM = "-";
    }
    
    strSelect = strSelect + "AND KKMAT NOT IN ( SELECT KKMAT FROM KKMAT_M3_UNDEF WHERE WIELART = '"+strWIELART+"' AND HEIZUNG = '"+strHeizung+"' AND BREAUS = '"+strBREAUS+"' AND KONSTBREM = '"+strKONSTBREM+"') ";
    
    var KKMAT_KKBRETTBO = Bestimme_GrenzwerteStromundSpannung(oData,oDataBremse);
    strSelect = strSelect +  "AND KKMAT IN "+KKMAT_KKBRETTBO+" ";
    
    ECL_DeactivateAllAttributeValues("GEGENSTECKER");
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if(!ECL_ValueSelected("SCHUTZART", "IP56"))
    {
        if(aResult.length>0)
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("GEGENSTECKER",aResult[i].KKMAT_ZUB);
            }
        }
        else
            logtraceln("Fehler bei Bestimmung Motorstecker Gegenstecker!, SQL="+strSelect);
    }
    else
        logtraceln("Motorstecker Gegenstecker nicht möglich (IP56)!, SQL="+strSelect);
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("GEGENSTECKER"))
    {
        ExecSetStandardifValueEmpty("GEGENSTECKER","ohne");
    }
}

function Bestimme_GrenzwerteStromundSpannung(oData,oDataBremse)
{
    var strSpecString=  createSpecString(oData);	
    var Motorspannung = ECL_GetValue ("MOTORSPANNUNG");
    var strFrequency = ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL"); 
    
    var erhoehteLeistung="";
    var berhoehteLeistung = ECL_ValueSelected ("ERHOEHTE_LEISTUNG_OPTION", "T");
    if(berhoehteLeistung)
        erhoehteLeistung = "Ja";
    else
        erhoehteLeistung = "Nein";
        
    var	SpannungsTol="";
    var bSpannungsTol = ECL_ValueSelected ("SPANNUNGSTOLERANZ_OPTION", "T");
    if(bSpannungsTol)
        SpannungsTol = "+-10";
    else
        SpannungsTol = "-";
    
    var strSelect="SELECT DISTINCT MOT_KEY,MOT_SCHALTUNG FROM TMP_MOT_DATEN WHERE ";
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG='"+strSpecString+"' AND ";
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ='"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MOT_POLZAHL='"+ECL_GetValue("ECSI_POLZAHL")+"' AND ";

    if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
    {
        if(strFrequency == "50")
        {
            strSelect = strSelect + "MOT_FREQUENZ IN ('50.4','50.5','50.7','50.8','50.9','51','51.3','51.5','51.6','51.7','52.1','52.3','52.7')  AND ";
        }
        else if(strFrequency == "60")
        {
            strSelect = strSelect + "MOT_FREQUENZ IN ('59','59.1','59.2','59.3','59.4','59.5','59.6','59.7','60.2','60.7','61.7') AND ";
        }
        else if(strFrequency == "87")
        {
            strSelect = strSelect + "MOT_FREQUENZ IN ('87.4','87.6','87.7','87.8','87.9','88','88.3','88.4','88.6','88.8','89','89.1','89.6') AND ";
        }
        else if(strFrequency == "104")
        {
            strSelect = strSelect + "MOT_FREQUENZ IN ('100.7','100.9','101','101.1','101.3','101.5','101.8','101.9','102.5','103.2') AND ";
        }

        var strElectronics = ECL_GetValue("GEBER_ELEKTRONIK");
		if(strElectronics=="DRIVE-CLIQ")
            strSelect = strSelect + "MOT_GEB_IA_DQ_TF='Ja' AND ";
        else
            strSelect = strSelect + "MOT_GEB_IA_DQ_TF='Nein' AND ";
    }
    else
    {
        strSelect = strSelect + "MOT_FREQUENZ='"+ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL")+"' AND ";
    }
    
   
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG='"+oData.oRow.LEISTUNG+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_BETRIEBSART_KEY='"+ECL_GetValue("BETRIEBSART")+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_UI='"+Motorspannung+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG_ERH_TF='"+erhoehteLeistung+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_TOL='"+SpannungsTol+"' AND ";
    strSelect = strSelect + "MOT_WAERMEKLASSE_KEY='"+ECL_GetValue("WAERMEKLASSE")+"' AND ";
    strSelect = strSelect + "MLFB_13_KA='"+ECL_GetValue("ECSI_MOTORSPANNUNG_SPG_KA")+"' ";
    
    var minSpannung=99999;
    var maxSpannung=0;
    var minStrom=99999;
    var maxStrom=0;

    strMLFB13="";
    strMLFB13_KA="";
    
    var aResultTable = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    var strMOT_KEY="";
    var strMOT_Schaltung="";
    if(aResultTable.length>0)
    {
        strMOT_KEY=aResultTable[0].MOT_KEY;
        strMOT_Schaltung=aResultTable[0].MOT_SCHALTUNG;
        var strSelect="SELECT DISTINCT MLFB_13,MLFB_13_KA,MOT_SPANNUNG1,MOT_SPANNUNG2,MOT_BSTROM1,MOT_BSTROM2 FROM TMP_MOT_DATEN WHERE ";
        strSelect = strSelect + "MOT_KEY = '"+strMOT_KEY+"' ";
        
        if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
        {
            var strFrequency = ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL"); 
            if(strFrequency == "50")
            {
                strSelect = strSelect + "AND MOT_FREQUENZ IN ('50.4','50.5','50.7','50.8','50.9','51','51.3','51.5','51.6','51.7','52.1','52.3','52.7') ";
            }
            else if(strFrequency == "60")
            {
                strSelect = strSelect + "AND MOT_FREQUENZ IN ('59','59.1','59.2','59.3','59.4','59.5','59.6','59.7','60.2','60.7','61.7') ";
            }
            else if(strFrequency == "87")
            {
                strSelect = strSelect + "AND MOT_FREQUENZ IN ('87.4','87.6','87.7','87.8','87.9','88','88.3','88.4','88.6','88.8','89','89.1','89.6') ";
            }
            else if(strFrequency == "104")
            {
                strSelect = strSelect + "AND MOT_FREQUENZ IN ('100.7','100.9','101','101.1','101.3','101.5','101.8','101.9','102.5','103.2') ";
            }
        }

        var aResultTable = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        if(aResultTable.length>0)
        {
            //Bestimmung von Min und Max Strom und Spannung
            for(var i=0;i<aResultTable.length;i++)
            {
                if(minStrom > parseFloat(aResultTable[i].MOT_BSTROM1) && parseFloat(aResultTable[i].MOT_BSTROM1) != 0 )
                    minStrom = parseFloat(aResultTable[i].MOT_BSTROM1);
                
                if(maxStrom < parseFloat(aResultTable[i].MOT_BSTROM1))
                    maxStrom = parseFloat(aResultTable[i].MOT_BSTROM1);
                
                if( minStrom > parseFloat(aResultTable[i].MOT_BSTROM2) && parseFloat(aResultTable[i].MOT_BSTROM2) != 0)
                    minStrom = parseFloat(aResultTable[i].MOT_BSTROM2);
                    
                if(maxStrom < parseFloat(aResultTable[i].MOT_BSTROM2))
                    maxStrom = parseFloat(aResultTable[i].MOT_BSTROM2);
                    
                if( minSpannung > parseFloat(aResultTable[i].MOT_SPANNUNG1) && parseFloat(aResultTable[i].MOT_SPANNUNG1) != 0)
                    minSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG1);
                
                if(maxSpannung < parseFloat(aResultTable[i].MOT_SPANNUNG1))
                    maxSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG1);
                
                if( minSpannung > parseFloat(aResultTable[i].MOT_SPANNUNG2) && parseFloat(aResultTable[i].MOT_SPANNUNG2) != 0)
                    minSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG2);
                    
                if(maxSpannung < parseFloat(aResultTable[i].MOT_SPANNUNG2))
                    maxSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG2);
                    
            }

            strMLFB13=aResultTable[0].MLFB_13;
            strMLFB13_KA=aResultTable[0].MLFB_13_KA;
        }
    }
    
    logtraceln("min Spannung="+minSpannung+",max Spannung="+maxSpannung+",min Strom="+minStrom+",max Strom="+maxStrom);
    
    //mögliche KKMAT aus KKBRETTBO
    
    var strBRESHT="ALL";
    var strBremse="-";
    if(ECL_ValueSelected("MIT_BREMSE", "T"))
    {
        strBremse="KAUF";
        strBRESHT = Bestimme_BREMSE_BRESHLT(oData,oDataBremse);
    }
    
    var strSelect = "SELECT DISTINCT KKMAT FROM KKBRETTBO WHERE ";
    strSelect = strSelect + "KKMAT <> 'Aluminium' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "(BRESHLT = '"+strBRESHT+"' OR BRESHLT='ALL') AND ";
    strSelect = strSelect + "(KONSTABREM = '"+strBremse+"' OR KONSTABREM='ALL') AND ";
    strSelect = strSelect + "(MOTSHLT = '"+strMOT_Schaltung+"' OR MOTSHLT='ALL') AND ";
    strSelect = strSelect + "REGION = 'S' AND ";
    strSelect = strSelect + "G115M = '0' AND ";
    strSelect = strSelect + "POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL")+"' AND ";
    strSelect = strSelect + "CAST(MOTSPG_BMIN AS FLOAT) <= '"+minSpannung+"' AND ";
    strSelect = strSelect + "CAST(MOTSPG_BMAX AS FLOAT) >= '"+maxSpannung+"' AND ";
    strSelect = strSelect + "CAST(MIN_BSTROM AS FLOAT) <= '"+minStrom+"' AND ";
    strSelect = strSelect + "CAST(MAX_BSTROM AS FLOAT) >= '"+maxStrom+"' ";
    
    var aResultTable = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    var strKKMATMENGE="(";
    if(aResultTable.length>0)
    {
        //Bestimmung von Min und Max Strom und Spannung
        for(var i=0;i<aResultTable.length;i++)
        {
            strKKMATMENGE = strKKMATMENGE + "'"+aResultTable[i].KKMAT+"',";
        }
    }
    else
    {
        logtraceln("SQL für KKMAT Überprüfung Strom und Spannung, SQL="+strSelect);
    }


    // Sonderlogik für HAN10E
    // Bei bestimmten Spannungen ist HAN10E auch bis 27,7 A möglich mit einer Hinweismeldung

    //Gibt es schon HAN10E in der Liste?
    bhan10E = false;
    ECL_SetValue("MOTORSTECKER_INFOTEXT_KENNER","");
    
    if(strKKMATMENGE.lastIndexOf("HAN10E")>=0)
    {
        bhand10E = true;
    }

    var maxStrom_Orig = maxStrom;
    var bHAN10Sonder=false;

    if(!bhan10E)
    {
        if((strFrequency=="87" && strMLFB13=="9" && (strMLFB13_KA=="N3C" ||strMLFB13_KA=="N3A" || strMLFB13_KA=="N1T")) || (strFrequency=="87" && strMLFB13=="4" && strMLFB13_KA=="-"))
        {
            bHAN10Sonder=true;
        }
        else if((strFrequency=="50" && strMLFB13=="9" && (strMLFB13_KA=="N1K" ||strMLFB13_KA=="N3C" || strMLFB13_KA=="N1T" || strMLFB13_KA=="N3A")) || (strFrequency=="50" && strMLFB13=="4" && strMLFB13_KA=="-"))
        {
            bHAN10Sonder=true;
        }
        else if((strFrequency=="60" && strMLFB13=="9" && (strMLFB13_KA=="N3A" ||strMLFB13_KA=="N3C")) || (strFrequency=="60" && strMLFB13=="4" && strMLFB13_KA=="-"))
        {
            bHAN10Sonder=true;
        }
        else if((strFrequency=="104" && strMLFB13=="9" && (strMLFB13_KA=="N3A" ||strMLFB13_KA=="N3C")) || (strFrequency=="104" && strMLFB13=="4" && strMLFB13_KA=="-"))
        {
            bHAN10Sonder=true;
        }
        else if(strFrequency=="50" && strMLFB13=="9" && strMLFB13_KA=="N1D") 
        {
            bHAN10Sonder=true;
        }

        if(bHAN10Sonder)
        {
            var strSelect_HAN = "SELECT DISTINCT KKMAT FROM KKBRETTBO WHERE ";
            strSelect_HAN = strSelect_HAN + "KKMAT <> 'Aluminium' AND ";
            strSelect_HAN = strSelect_HAN + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
            strSelect_HAN = strSelect_HAN + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
            strSelect_HAN = strSelect_HAN + "(BRESHLT = '"+strBRESHT+"' OR BRESHLT='ALL') AND ";
            strSelect_HAN = strSelect_HAN + "(KONSTABREM = '"+strBremse+"' OR KONSTABREM='ALL') AND ";
            strSelect_HAN = strSelect_HAN + "(MOTSHLT = '"+strMOT_Schaltung+"' OR MOTSHLT='ALL') AND ";
            strSelect_HAN = strSelect_HAN + "REGION = 'S' AND ";
            strSelect_HAN = strSelect_HAN + "G115M = '0' AND ";
            strSelect_HAN = strSelect_HAN + "POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL")+"' AND ";
            strSelect_HAN = strSelect_HAN + "KKMAT IN ('HAN10-1Buegel','HAN10-1Buegel+EMV','HAN10-2Buegel','HAN10-2Buegel+EMV') ";
            
            var aResultTable_HAN = ExecSQL_Standard_SO("2KJ_DB", strSelect_HAN);
            if(aResultTable_HAN.length>0)
            {
                if(maxStrom_Orig > 16 && maxStrom_Orig < 27.7)
                {
                    // Hier Sondermeldung
                    //Die Strombelastung am gewähltem Motorstecker ("Elektrischer Anschluss am Klemmkasten"), darf je Pin nicht mehr als 16 A betragen. Um die Strombelastung zu reduzieren, ist die Schaltung kundenseitig im Gegenstecker oder per Schützschaltung vorzunehmen!
                    //The current load on the selected motor plug ("Electrical connection at terminal box") must not exceed 16 A per pin. In order to reduce the current load, the customer must carry out switching in the mating connector or by means of a contactor circuit!
                    
                    logtraceln("Achtung! HAN10E Sondermeldung!");
                    ECL_SetValue("MOTORSTECKER_INFOTEXT_KENNER","TRUE");
                    for(var i=0;i<aResultTable_HAN.length;i++)
                    {
                        strKKMATMENGE = strKKMATMENGE + "'"+aResultTable_HAN[i].KKMAT+"',";
                    }
                }
            }
            else
            {
                logtraceln("SQL für KKMAT Überprüfung Strom und Spannung (HAN10E), SQL="+strSelect_HAN);
            }
        }
    }
    
    strKKMATMENGE = trimright(strKKMATMENGE,",");
    strKKMATMENGE = strKKMATMENGE+")";
    
    logtraceln("KKMAT MENGE="+strKKMATMENGE);
    return strKKMATMENGE;
}

function Bestimme_MotorConsequences_Schutzart(oData)
{
    var strSchutzart=ECL_GetValue("SCHUTZART");
    strSchutzart = replace(strSchutzart,"IP","")
        
    ECL_SetValue("ECSI_CC_IpProtectionLevelMotor", strSchutzart);
}

function Bestimme_Versandschaltung_neue_logik(oData,oDataBremse)
{
    var strMotorstecker = ECL_GetValue("MOTORSTECKER");

    if(find(ECL_GetValue("MOTORSTECKER"),"K4/4")<0 && find(ECL_GetValue("MOTORSTECKER"),"Q8")<0)
    {
        ECL_DeactivateAllAttributeValues("VERSANDSCHALTUNG");
        ECL_ActivateValue("VERSANDSCHALTUNG",'-');
        ECL_SetValue("VERSANDSCHALTUNG",'-');

        //Default Wert bestimmen
        if(isnewDefaultnecessary("VERSANDSCHALTUNG"))
        {
            ExecSetStandardifValueEmpty("VERSANDSCHALTUNG","-");
        }
    }
    else
    { 
        ECL_DeactivateAllAttributeValues("VERSANDSCHALTUNG");
        
        // Neue Logik von Torsten Engfer
        // 09.01.2024 

        ECL_DeactivateAllAttributeValues("VERSANDSCHALTUNG");

        var strFrequency = ECL_GetValue("ECSI_CX_MotorFrequency");
        
        if(strFrequency==""){
            strFrequency = "50";
        }


        if((strFrequency == "50" || strFrequency == "60" || strFrequency == "6050") && find(ECL_GetValue("MOTORSTECKER"),"K4/4") > -1)
        {
            ECL_ActivateValue("VERSANDSCHALTUNG","Dreieck");
            ECL_ActivateValue("VERSANDSCHALTUNG","Stern");
        }
        else if ((strFrequency == "87" || strFrequency == "104") && find(ECL_GetValue("MOTORSTECKER"),"K4/4") > -1)
        {
            ECL_ActivateValue("VERSANDSCHALTUNG","Dreieck");
        }
        else if ((strFrequency == "50" || strFrequency == "60" || strFrequency == "6050") && find(ECL_GetValue("MOTORSTECKER"),"Q8") > -1)
        {
            ECL_ActivateValue("VERSANDSCHALTUNG","Dreieck");
            ECL_ActivateValue("VERSANDSCHALTUNG","Stern");
        }
        else if ((strFrequency == "87" || strFrequency == "104") && find(ECL_GetValue("MOTORSTECKER"),"Q8") > -1)
        {
            ECL_ActivateValue("VERSANDSCHALTUNG","Dreieck");
        }
        else
        {
            logtraceln("Error bei der Logik Versandschaltung!");
            
            ECL_ActivateValue("VERSANDSCHALTUNG",'-');
            ECL_SetValue("VERSANDSCHALTUNG",'-');
        }

          //Default Wert bestimmen
          if(isnewDefaultnecessary("VERSANDSCHALTUNG"))
          {
              ExecSetStandardifValueEmpty("VERSANDSCHALTUNG","Dreieck");
          }
    }
    
}

function Bestimme_Versandschaltung(oData,oDataBremse)
{
    if(ECL_GetValue("MOTORSTECKER") =="M" || ECL_GetValue("MOTORSTECKER")=="NPT" || find(ECL_GetValue("MOTORSTECKER"),"K4/4")<0)
    {
        ECL_DeactivateAllAttributeValues("VERSANDSCHALTUNG");
        ECL_ActivateValue("VERSANDSCHALTUNG",'-');
        ECL_SetValue("VERSANDSCHALTUNG",'-');
    }
    else
    {
        ECL_DeactivateAllAttributeValues("VERSANDSCHALTUNG");
        
        //geht immer? noch unklar
        //ECL_ActivateValue("VERSANDSCHALTUNG",'-');
        
        var strBRESHT="ALL";
        var strBremse="-";
        if(ECL_ValueSelected("MIT_BREMSE", "T"))
        {
            strBremse="KAUF";
            strBRESHT = Bestimme_BREMSE_BRESHLT(oData,oDataBremse);
        }
        
        var strSelect = "SELECT DISTINCT MOTSHLT_VSHLT_AWAHL_ANZ FROM MOTFHT_VSPGSHLTFRQ,KKBRETTBO WHERE ";
        strSelect = strSelect+"MOTOX_N = '0' AND ";

        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSHLT1 = '"+oData.oRow.ORIG_MOTFHT_MOTSHLT1+"' AND ";
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSHLT12 = '"+oData.oRow.ORIG_MOTFHT_MOTSHLT12+"' AND ";
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSHLT2 = '"+oData.oRow.ORIG_MOTFHT_MOTSHLT2+"' AND ";
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSHLT22 = '"+oData.oRow.ORIG_MOTFHT_MOTSHLT22+"' AND ";
        
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.FREQUENZ_1 = '"+oData.oRow.ORIG_MOTFHT_FREQUENZ_1+"' AND ";
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.FREQUENZ_2 = '"+oData.oRow.ORIG_MOTFHT_FREQUENZ_2+"' AND ";
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.FREQUENZ2_1 = '"+oData.oRow.ORIG_MOTFHT_FREQUENZ2_1+"' AND ";
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.FREQUENZ2_2 = '"+oData.oRow.ORIG_MOTFHT_FREQUENZ2_2+"' AND ";
        
        if(oData.oRow.ORIG_MOTFHT_MOTSPG_1)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG_1 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG_1+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG_2)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG_2 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG_2+"' AND ";
        
        if(oData.oRow.ORIG_MOTFHT_MOTSPG_3)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG_3 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG_3+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG_4)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG_4 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG_4+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG_5)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG_5 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG_5+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG_6)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG_6 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG_6+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG_7)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG_7 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG_7+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG_8)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG_8 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG_8+"' AND ";
            
        
        
        if(oData.oRow.ORIG_MOTFHT_MOTSPG2_1)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG2_1 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG2_1+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG2_2)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG2_2 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG2_2+"' AND ";
        
        if(oData.oRow.ORIG_MOTFHT_MOTSPG2_3)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG2_3 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG2_3+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG2_4)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG2_4 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG2_4+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG2_5)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG2_5 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG2_5+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG2_6)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG2_6 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG2_6+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG2_7)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG2_7 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG2_7+"' AND ";
            
        if(oData.oRow.ORIG_MOTFHT_MOTSPG2_8)
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTSPG2_8 = '"+oData.oRow.ORIG_MOTFHT_MOTSPG2_8+"' AND ";
        

        if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
            strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.ATEX = 'ALL' AND ";
        
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.M3 = '"+oData.oRow.M3+"' AND ";
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.GM3 = '"+oData.oRow.GM3+"' AND ";
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.AKTIV = '1' AND ";
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.S09 = '"+oData.oRow.S09+"' AND ";
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.SONDER = '-' AND ";
        strSelect = strSelect + "MOTFHT_VSPGSHLTFRQ.MOTOX_N = '0' ";
        
        /*
        strSelect = strSelect + "((KKBRETTBO.MOTSHLT_VSHLT_AWAHL_S = MOTFHT_VSPGSHLTFRQ.MOTSHLT_VSHLT_AWAHL_S) OR KKBRETTBO.MOTSHLT_VSHLT_AWAHL_S='ALL') AND ";
        strSelect = strSelect + "((KKBRETTBO.MOTSPG_VSPG_MAX = MOTFHT_VSPGSHLTFRQ.MOTSPG_VSPG_MAX) OR KKBRETTBO.MOTSPG_VSPG_MAX='ALL') AND ";
        
        strSelect = strSelect + "KKBRETTBO.MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
        strSelect = strSelect + "KKBRETTBO.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
        strSelect = strSelect + "(KKBRETTBO.MOTSHLT = '"+oData.oRow.ORIG_MOTFHT_MOTSHLT1+"' OR KKBRETTBO.MOTSHLT = 'ALL') AND ";
        strSelect = strSelect + "(KKBRETTBO.MOTSHLT2 = '"+oData.oRow.ORIG_MOTFHT_MOTSHLT2+"' OR KKBRETTBO.MOTSHLT2 = 'ALL') AND ";
        strSelect = strSelect + "KKBRETTBO.POLZAHL = '4' AND ";
        strSelect = strSelect + "(KKBRETTBO.BRESHLT = '"+strBRESHT+"' OR KKBRETTBO.BRESHLT = 'ALL') AND ";
        strSelect = strSelect + "(KKBRETTBO.KONSTABREM = '"+strBremse+"' OR KKBRETTBO.KONSTABREM='ALL') AND ";
        strSelect = strSelect + "KKBRETTBO.KKMAT = '"+ECL_GetValue("MOTORSTECKER")+"' AND ";
        strSelect = strSelect + "KKBRETTBO.G115M = '0' AND ";
        strSelect = strSelect + "KKBRETTBO.AKTIV = '1' ";
        */
            
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

        if(aResult.length>0)
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("VERSANDSCHALTUNG",aResult[i].MOTSHLT_VSHLT_AWAHL_ANZ);
            }
        }      
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("VERSANDSCHALTUNG"))
    {
        ExecSetStandardifValueEmpty("VERSANDSCHALTUNG","-");
    }
    
}