//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"


function BestimmeSpezifikation_SIZER(oData, Spez)
{
    
    if(oData.oRow.VSDMOTOR=="V" && Spez=="CHINA")
        return false;
    
    var strSelect = "SELECT * FROM MOTELAUSF WHERE ";
    
    strSelect = strSelect + "MOTELAUSF IN "+oData.oRow.SPEC_STRING+" AND ";
    strSelect = strSelect + "AKTIV = '1' AND ";
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOTOR = '1' AND ";
    strSelect = strSelect + "G110M = '0' AND ";
    strSelect = strSelect + "GGM = '0' AND ";
    strSelect = strSelect + "REGION IN ('S') AND ";
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
        strSelect = strSelect + "ATEX = '1' AND ";
    else
        strSelect = strSelect + "ATEX = '0' AND ";
    
    if(Spez=="CHINA")
        strSelect = strSelect + "MOTELAUSF_CEL='CHINA' ";
    
    if(Spez=="CCC_Ex")
        strSelect = strSelect + "MOTELAUSF_CEL='CCC_Ex' ";
        
    if(Spez=="EAC")
        strSelect = strSelect + "MOTELAUSF_EAC='EAC' ";
        
    if(Spez=="UL")
        strSelect = strSelect + "MOTELAUSF_UL='UL-R/CSA' ";

    if(Spez=="BIS")
        strSelect = strSelect + "MOTELAUSF_BIS='BIS' ";

    if(Spez=="KEMCO")
        strSelect = strSelect + "MOTELAUSF_KEMCO='KEMCO' ";
    
    var aResult=Object.fromDatabase( '2KJ_DB', strSelect );
    if ( aResult.length > 0 )
    {
        return true;
    }
    else
    {
        return false;
    }
}

function Bestimme_CE_EXPORT_SIZER(oData)
{
    // CE geht immer, kein Export
    ECL_DeactivateAllAttributeValues("SPEZIFIKATION_CE_EXPORT");
    ECL_ActivateValue ("SPEZIFIKATION_CE_EXPORT", "CE");
    ExecSetStandardifValueEmpty("SPEZIFIKATION_CE_EXPORT","CE");	
    ECL_DisableAttribute ("SPEZIFIKATION_CE_EXPORT");
}

function Bestimme_Spezifikation_SIZER(oData)
{
    var bEXCHINASpec = BestimmeSpezifikation_SIZER(oData, 'CCC_Ex');
    var bCHINASpec = BestimmeSpezifikation_SIZER(oData, 'CHINA');
    var bEACSpec= BestimmeSpezifikation_SIZER(oData, 'EAC');
    var bCSA_UL_RSpec = BestimmeSpezifikation_SIZER(oData, 'UL');
    var bbisSpec = BestimmeSpezifikation_SIZER(oData, 'BIS');
    var bkemcoSpec = BestimmeSpezifikation_SIZER(oData, 'KEMCO');
    
    var bChinaSonder=Sonderlogik_China_Cert(oData);

    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        // China disabled for ATEX 
        // 09.01.2024
         bEXCHINASpec = false;
        
        if( bEXCHINASpec )
        {
            ECL_EnableValue ("SPEZIFIKATION_CHINA_EX", "T");
            ECL_EnableAttribute ("SPEZIFIKATION_CHINA_EX");
        }
        else 
        {
            ECL_DeselectValue("SPEZIFIKATION_CHINA_EX", "T");
            ECL_DisableAttribute ("SPEZIFIKATION_CHINA_EX");
            //ECL_DeactivateAttribute ("SPEZIFIKATION_CHINA_EX");
        }
        
        ECL_DeselectValue("SPEZIFIKATION_CHINA", "T");
        ECL_DisableAttribute ("SPEZIFIKATION_CHINA");
        ECL_DeactivateAttribute ("SPEZIFIKATION_CHINA");
    }
    else
    {
        if( bCHINASpec && bChinaSonder )
        {
            ECL_EnableValue ("SPEZIFIKATION_CHINA", "T");
            ECL_EnableAttribute ("SPEZIFIKATION_CHINA");
        }
        else 
        {
            ECL_DeselectValue("SPEZIFIKATION_CHINA", "T");
            ECL_DisableAttribute ("SPEZIFIKATION_CHINA");
        }
        
        ECL_DeselectValue("SPEZIFIKATION_CHINA_EX", "T");
        ECL_DisableAttribute ("SPEZIFIKATION_CHINA_EX");
        ECL_DeactivateAttribute ("SPEZIFIKATION_CHINA_EX");
    }
    
    if( bEACSpec )
    {
        ECL_EnableValue ("SPEZIFIKATION_EAC", "T");
        ECL_EnableAttribute ("SPEZIFIKATION_EAC");
    }
    else 
    {
        ECL_DeselectValue("SPEZIFIKATION_EAC", "T");
        ECL_DisableAttribute ("SPEZIFIKATION_EAC");
    }
    
    if( bCSA_UL_RSpec )
    {
        ECL_EnableValue ("SPEZIFIKATION_ULR_CSA", "T");
        ECL_EnableAttribute ("SPEZIFIKATION_ULR_CSA");
    }
    else 
    {
        ECL_DeselectValue("SPEZIFIKATION_ULR_CSA", "T");
        ECL_DisableAttribute ("SPEZIFIKATION_ULR_CSA");
    }

    if( bbisSpec )
    {
        ECL_EnableValue ("SPEZIFIKATION_BIS", "T");
        ECL_EnableAttribute ("SPEZIFIKATION_BIS");
    }
    else 
    {
        ECL_DeselectValue("SPEZIFIKATION_BIS", "T");
        ECL_DisableAttribute ("SPEZIFIKATION_BIS");
    }

    if( bkemcoSpec )
    {
        ECL_EnableValue ("SPEZIFIKATION_KEMCO", "T");
        ECL_EnableAttribute ("SPEZIFIKATION_KEMCO");
    }
    else 
    {
        ECL_DeselectValue("SPEZIFIKATION_KEMCO", "T");
        ECL_DisableAttribute ("SPEZIFIKATION_KEMCO");
    }


}

function ZertifikateausSIZERsperren()
{
    //Zertifikate aus SIZER |-getrennt
    //Empty|CE|UL-R/CSA|CCC/CEL|EAC|KC

    var strCertificates=ECL_GetValue("ECSI_CX_Certificates");
    var bChinaSonder=Sonderlogik_China_Cert();
    
    //strCertificates="CCC/CEL|CE|EAC";
    if(strCertificates==""){
		strCertificates="CE";
    }
    //immer disabled
    ECL_DisableAttribute ("SPEZIFIKATION_ULR_CSA");
    
    if(strCertificates != "")
    {
        var aCertificates=strCertificates.split("|");
        
        for(var i=0;i<aCertificates.length;i++)
        {
            if(aCertificates[i]=="CCC_CEL" && bChinaSonder)
            {
                ECL_SelectValue("SPEZIFIKATION_CHINA", "T");
                ECL_DisableAttribute ("SPEZIFIKATION_CHINA");
            }
            else if(aCertificates[i]=="EAC")
            {
                ECL_SelectValue("SPEZIFIKATION_EAC", "T");
                ECL_DisableAttribute ("SPEZIFIKATION_EAC");
            }
        }
    }
}

function Sonderlogik_VSD_MOTOREN(oData)
{
	if(oData.oRow.VSDMOTOR=="V" && ECL_GetValue("ECSI_WMFU_KENNER")!="ja")
	{
		// Bei Reluktanzmotoren wird CCC immer gesetzt, da die Motoren das immer haben
		// allerdings darf die KA nicht gesetzt werden!
	
		ECL_EnableValue ("SPEZIFIKATION_CHINA", "T");
		ECL_EnableAttribute ("SPEZIFIKATION_CHINA");
		ECL_SelectValue("SPEZIFIKATION_CHINA", "T");
		ECL_DisableAttribute ("SPEZIFIKATION_CHINA");
	}
	else if(oData.oRow.VSDMOTOR=="V" && ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
	{
		//Weltmotor hat alle Zertifikate
		
		ECL_EnableValue ("SPEZIFIKATION_CHINA", "T");
		ECL_EnableAttribute ("SPEZIFIKATION_CHINA");
		ECL_SelectValue("SPEZIFIKATION_CHINA", "T");
		ECL_DisableAttribute ("SPEZIFIKATION_CHINA");
		
		ECL_EnableValue ("SPEZIFIKATION_ULR_CSA", "T");
		ECL_EnableAttribute ("SPEZIFIKATION_ULR_CSA");
		ECL_SelectValue("SPEZIFIKATION_ULR_CSA", "T");
		ECL_DisableAttribute ("SPEZIFIKATION_ULR_CSA");
		
		ECL_EnableValue ("SPEZIFIKATION_EAC", "T");
		ECL_EnableAttribute ("SPEZIFIKATION_EAC");
		ECL_SelectValue("SPEZIFIKATION_EAC", "T");
		ECL_DisableAttribute ("SPEZIFIKATION_EAC");

        ECL_EnableValue ("SPEZIFIKATION_BIS", "T");
		ECL_EnableAttribute ("SPEZIFIKATION_BIS");
		ECL_SelectValue("SPEZIFIKATION_BIS", "T");
		ECL_DisableAttribute ("SPEZIFIKATION_BIS");

        ECL_EnableValue ("SPEZIFIKATION_KEMCO", "T");
		ECL_EnableAttribute ("SPEZIFIKATION_KEMCO");
		ECL_SelectValue("SPEZIFIKATION_KEMCO", "T");
		ECL_DisableAttribute ("SPEZIFIKATION_KEMCO");
	}
}

function Sonderlogik_China_Cert(oData)
{
    // IE2 0,12 bis 0,55 kW N67 (China) nicht möglich
    // IE2 >= 0,75 kW N67 (China) nicht möglich
    // IE1 0,12 bis 0,55 kW N67 (China) nicht möglich
    if(oData!==undefined){
        if(oData.oRow.MOTFHT_HEMOTOR=="E" && (parseFloat(oData.oRow.LEISTUNG) >= 0.12 && parseFloat(oData.oRow.LEISTUNG) <= 0.55)){
            return false;
        }
        else if(oData.oRow.MOTFHT_HEMOTOR=="-" && (parseFloat(oData.oRow.LEISTUNG) >= 0.12 && parseFloat(oData.oRow.LEISTUNG) <= 0.55)){
            return false;
        }
        else if(oData.oRow.MOTFHT_HEMOTOR=="E" && parseFloat(oData.oRow.LEISTUNG) >= 0.75 ){
                return false;
        }
        else{
            return true;
        }
    }
    //Fall object ist undefined
    else{
        return true;
    }
    
}