//@legacy
//#mode(full-ecma)


//@import "MLFB.MOTOX.base.js"

//@import "MLFB.MOTOX.ShortDescriptions.js"

//@import "MLFB.common.js"


/**
 * @constructor
 * build a fully specified MLFB (with/wo short descriptions) from the the geared motor object
 *
 * @param oGear - geared motor object
 *
 * @return object - strBaseMLFB - base MLFB
 *                  strStrippedShortDescriptions - filtered short descriptions where all clear texts for Yxx- descriptions have been stripped
 *                  strFormattedShortDescriptions - clear texts for Yxx- descriptions that have been formatted to {<SHORT_DESCRIPTION>: <TEXT>}
 *                  strYDescription - clear texts for Y descriptions, one per row, rows are separated with #
 *                  strFullShortDescriptions - filtered short descriptions where all clear texts for Yxx- descriptions have been stripped
 */
function buildFormattedMLFB( oGear, bFull )
{
    vtTimeStart	= Date.getTime();
    
    var oMLFB = {
        strBaseMLFB : '',
        strStrippedShortDescriptions : '',
        strFormattedShortDescriptions : '',
        strYDescription : '',
        strFullShortDescriptions: '',
        strSpecificationSD: '',
        strBetriebsartSD: '',
        strVentilationSD: '',
        strATEXZoneSD: ''
    };

    // base MLFB
    var oBase = buildBaseMLFB( oGear );
    oMLFB.strBaseMLFB = oBase.strMLFB;
    
    // short descriptions
    var aShortDescriptions = getShortDescriptions( oGear );
    preventDoubledShortDescription( oBase.strSDShaft, aShortDescriptions );
    preventDoubledShortDescription( oBase.strSDVoltage, aShortDescriptions );
    preventDoubledShortDescription( oBase.strSDFastening, aShortDescriptions );
    preventDoubledShortDescription( oBase.strSDPower, aShortDescriptions );
    preventDoubledShortDescription( oBase.strCHINA, aShortDescriptions );
    preventDoubledShortDescription( oBase.strCCC_Ex, aShortDescriptions );
    preventDoubledShortDescription( oBase.strEAC, aShortDescriptions );
    preventDoubledShortDescription( oBase.strULR_CSA, aShortDescriptions );
    preventDoubledShortDescription( oBase.strCE, aShortDescriptions );
    preventDoubledShortDescription( oBase.strEXPORT, aShortDescriptions );
    preventDoubledShortDescription( oBase.strBIS, aShortDescriptions );
    preventDoubledShortDescription( oBase.strKEMCO, aShortDescriptions );
    preventDoubledShortDescription( oBase.strSDSPGTOL, aShortDescriptions );
    preventDoubledShortDescription( oBase.strSDBART, aShortDescriptions );
    
    if(ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
        preventDoubledShortDescription( oBase.strSDATEXZone, aShortDescriptions );
    
    // before filtering, we must save all possible short descriptions for printout and overview
    if ( aShortDescriptions.length > 0 )
    {
        // since the function MLFB.buildFormattedShortDescriptions modifies the original array parameter, we must construct a copy of the array and use this as parameter to the function
        var aCopy = [];
        var nLen = aShortDescriptions.length;
        for ( var i = 0; i < nLen; ++i )
        {
            if(aShortDescriptions[i]=='+M23')
                oMLFB.strVentilationSD="M23";
                
            aCopy.push( aShortDescriptions[i] );
        }	
        var oSD = buildFormattedShortDescriptions( aCopy, 'MOTOX_' );
        oMLFB.strFullShortDescriptions = oSD.strStrippedShortDescriptions;
    }

    // now filter the descriptions
    if ( bFull )
        aShortDescriptions = filterShortDescriptions( oGear, oBase.strMLFB, aShortDescriptions );
        
    if ( aShortDescriptions.length > 0 )
    {
        // build textual descriptions for short descriptions
        aShortDescriptions.sort();
        
        var oSD = buildFormattedShortDescriptions( aShortDescriptions, 'MOTOX_' );
        oMLFB.strStrippedShortDescriptions = oSD.strStrippedShortDescriptions;
        oMLFB.strFormattedShortDescriptions = oSD.strFormattedShortDescriptions;
        oMLFB.strYDescription = oSD.strYDescription;
        oMLFB.strVoltageSD = oBase.strSDVoltage;
        oMLFB.strPowerSD = oBase.strSDPower;
        oMLFB.strBetriebsartSD = oBase.strSDBART;
        
        if(ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
            oMLFB.strATEXZoneSD=oBase.strSDATEXZone;
        else
            oMLFB.strATEXZoneSD="";
            
        //Zur Zeit nur UL-R/CSA aus SIZER
        oMLFB.strSpecificationSD = oBase.strULR_CSA;
        oMLFB.strShaftSD = oBase.strSDShaft;
    }
    
    vtTimeStop	= Date.getTime();
    vtTime		= (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* MLFB-Generate - Time: "+vtTime+" sec"+"\n");
    
    return( oMLFB );
}


/**
 * @constructor
 * build base MLFB for a configured gear 
 *
 * @param oGear - geared motor object
 *
 * @return object: strMLFB - base MLFB for geared motor
 *                 strSDShaft - necessary short description for shaft (only nonempty if the shaft part of the MLFB is 9)
 *                 strSDVoltage: necessary short description for motor voltage (only nonempty if the motor voltage part of the MLFB is 9)
 *                 strSDPower: additional short description for motor power (may be empty)
 *                 strSDFastening: necessary short description for fastening (only nonempty if the fastening part of the MLFB is Z)
 */
function buildBaseMLFB ( oGear )
{
    //--------------------------------------------------------------------------------------------------------
    // assemble base MLFB
    //--------------------------------------------------------------------------------------------------------
    var strMLFB = '';
    
    // digits 1 - 4: product area and generation digit
    strMLFB += getPraefixMLFB();
    
    // digits 5-7: gear type
    strMLFB += getGearMLFB( oGear.oRow.EGBEZTYP, oGear.oRow.EGBEZUEBS, oGear.oRow.EGBEZEI, oGear.oRow.EGBEZDIM, oGear.oRow.ZGBEZDIM, oGear.oRow.ZGBEZEI, oGear.oRow.ZGBEZUEBS, oGear.oRow.EGBEZBRA );
    strMLFB += '-'
    
    // digit 8: shaft
    var oShaft = getShaftMLFB( oGear, ECL_GetValue("ABTRIEBSWELLENMASS"));
    strMLFB += oShaft.strMLFBPart;
    
    var oMotor_Adapter = new Object();
    
    // digits 9-13: motor size, power, type and voltage
    if(ECL_GetValue("ECSI_2KJ_TYPE") == "GETRIEBEMOTOR")
    {
        oMotor_Adapter = getMotorMLFB( oGear );
        strMLFB += oMotor_Adapter.strMLFBPart.substring( 0, 4 ) + '-' + oMotor_Adapter.strMLFBPart.substring( 4 );
    }
    else if(ECL_GetValue("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
    {
        // digits 9-13: motor size, power, type and voltage
        oMotor_Adapter = getAdapterMLFB( oGear );
        strMLFB += oMotor_Adapter.strMLFBPart.substring( 0, 4 ) + '-' + oMotor_Adapter.strMLFBPart.substring( 4 );
    }
    /*
    else if(oGear.strProduct == "GETRIEBE.ADAPTER.ATEX" || oGear.strProduct == "GETRIEBE.ADAPTER.ATEX_SIP")
    {
        // digits 9-13: motor size, power, type and voltage
        oMotor_Adapter = getAdapterMLFB( oGear );
        strMLFB += oMotor_Adapter.strMLFBPart.substring( 0, 4 ) + '-' + oMotor_Adapter.strMLFBPart.substring( 4 );
    }
    */
    
    // digit 14: fastening
    var oFastening = new Object();
    //Nur bei Drehmomentstütze wird der Wert EGABDMSTFIG in der MLFB Tabelle abgefragt
    
    if(ECL_GetValue("BEFESTIGUNGSART") == "D")
        oFastening = getFasteningMLFB( ECL_GetValue("BEFESTIGUNGSART"), ECL_GetValue("FIGUR"), oGear.oRow.EGBEZTYP );
    else
        oFastening = getFasteningMLFB( ECL_GetValue("BEFESTIGUNGSART"), "-", oGear.oRow.EGBEZTYP );
    
    strMLFB += oFastening.strMLFBPart;
    
    // digits 15+16: gear ratio
    
	strMLFB += getRatioMLFB( oGear.oRow.EGBEZTYP, oGear.oRow.EGBEZUEBS, oGear.oRow.EGBEZEI, oGear.oRow.EGBEZDIM, oGear.oRow.EGUEB, oGear.oRow.ZGBEZDIM, oGear.oRow.ZGBEZEI, oGear.oRow.ZGBEZUEBS, oGear.oRow.ZGUEB, oGear.oRow.EGBEZBRA );
    
    if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBEMOTOR")
    {
        return( {
            strMLFB: strMLFB,
            strSDShaft: oShaft.strShortDescription,
            strSDVoltage: oMotor_Adapter.strSDVoltage,
            strSDFastening: oFastening.strShortDescription, 
            strSDPower: oMotor_Adapter.strSDPower,
            strSDATEXZone: oMotor_Adapter.strATEXZoneSD,
            strSDSpecification: oMotor_Adapter.strSDSpecification,
            strSDSPGTOL: oMotor_Adapter.strSDSPGTOL,
            strSDBART: oMotor_Adapter.strSDBART,
            strCHINA: oMotor_Adapter.strCHINA,
            strCCC_Ex: oMotor_Adapter.strCCC_Ex,
            strEAC: oMotor_Adapter.strEAC,
            strULR_CSA: oMotor_Adapter.strULR_CSA,
            strCE: oMotor_Adapter.strCE,
            strEXPORT: oMotor_Adapter.strEXPORT,
            strBIS: oMotor_Adapter.strBIS,
            strKEMCO: oMotor_Adapter.strKEMCO
        } );
    }
    else if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
    {
        return( {
            strMLFB: strMLFB,
            strSDShaft: oShaft.strShortDescription,
            strSDVoltage: '',
            strSDFastening: oFastening.strShortDescription, 
            strSDPower: '',
            strSDSpecification: '',
            strSDSPGTOL: '',
            strSDBART: '',
            strCHINA: '',
            strCCC_Ex: '',
            strEAC: '',
            strULR_CSA: '',
            strCE: '',
            strEXPORT: '',
            strBIS: '',
            strKEMCO: ''
        } );
    }
}

