//@legacy
//#mode(full-ecma)


//@import "MLFB.MOTOX.SD.common.js"

/**
 * @category   MOTOX MLFB generation
 * @package    product logic
 * @copyright  Copyright (c) 2012 Plan Software GmbH (http://www.plansoft.de)
 */


/**
 * @constructor
 * get short descriptions for the brake attributes
 * 
 * @param oGear - geared motor object
 *
 * @return array - short descriptions for the brake attributes,
 *                 each index contains a string with one short description (may be empty)
 */
function getBrakeDescriptions( oGear )
{
    var aShortDescriptions = [];
    
    if ( ECL_ValueSelected("MIT_BREMSE","T") )
    {
        /*
        if(ECL_GetValue ("ECSI_2KJ_MODE") == "EASYKAT_CONFIG")
        {
            sCurrentCfgObject        = ECL_GetCurrentCfgObject();
            EKCfgTable.initCfgTable(sCurrentCfgObject, "ECSI_TABLE_BREMSE", oCfgTables2KJ);
            EKCfgTable.refreshTable("ECSI_TABLE_BREMSE");
            
            var aResult_Bremse = EKCfgTable.getAllSelectedRows(sCurrentCfgObject,"ECSI_TABLE_BREMSE");
            if (aResult_Bremse.length > 0){
                var sSelected   =  aResult_Bremse[0];

                var sContext				= _oBBHandler.getAttributeCFGContext("ECSI_TABLE_BREMSE");
                var oBBTable				= _oBBHandler.getCfgTable(sContext);
                var oDataBremse = oBBTable.getTableRowObjByIdent(sSelected);
            
                _addBrakeTypeDescriptions( oGear, oDataBremse, aShortDescriptions, sSelected );
                _addBrakeControlDescriptions( oGear, oDataBremse, aShortDescriptions );
                _addBrakeOptionsDescriptions( oGear, oDataBremse, aShortDescriptions );
            }
        }*/
        if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        {
            var oDataBremse = {};
            oDataBremse.oRow = {};
            oDataBremse.oRow = splitSelectedBrake(ECL_GetValue("BREMSENTYP"));
            
            
            // Safety Brake
            if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
            {
                aShortDescriptions.push('+C09');
            }
            
            _addBrakeTypeDescriptions( oGear, oDataBremse, aShortDescriptions, ECL_GetValue("BREMSENTYP") );
            _addBrakeControlDescriptions( oGear, oDataBremse, aShortDescriptions );
            _addBrakeOptionsDescriptions( oGear, oDataBremse, aShortDescriptions );
        }
        
    }
    
    return( aShortDescriptions );
}


/**
 * @constructor
 * add short descriptions for the brake type to the array of short descriptions
 * 
 * @param oGear - geared motor object
 * @param aShortDescriptions - array with short descriptions that should be enhanced for brake type descriptions
 */
function _addBrakeTypeDescriptions( oGear, oDataBremse, aShortDescriptions, strBrake )
{
    var oData = splitSelectedBrake( strBrake );
    if ( oData )
    {
        addShortDescription( aShortDescriptions, 'BREART', oData.BREART, 'BRENENMO', oData.BRENENMO, 'BREREDMO', oData.BREREDMO );
    }
}


/**
 * @constructor
 * add short descriptions for brake control options to the array of short descriptions
 * 
 * @param oGear - geared motor object
 * @param aShortDescriptions - arary with short descriptions that should be enhanced for brake control descriptions
 */
function _addBrakeControlDescriptions( oGear, oDataBremse, aShortDescriptions )
{
    // control voltage
    var strVoltage = ECL_GetValue("BREMSE_STEUERSPANNUNG");
    var nFirstDigitPos = findFirstNumber( strVoltage );
    if ( nFirstDigitPos > -1 )
    {
        strVoltage = strVoltage.substr( nFirstDigitPos, strVoltage.length - nFirstDigitPos );
        var strRectifier = ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER");
        
        if(strVoltage == "230-230" || strVoltage == "460-460")
        {
            if(strRectifier == "Uebererreg.+DC-Absch.Spgerf." || strRectifier == "Uebererreg.+DC-Absch.Stromerf.")
                addShortDescription( aShortDescriptions, 'BREEINBER', strVoltage, 'BRENETZ', 'Wechselstromnetz', 'BREVORB', 'nein', 'BREFKTGLRKNZ', '1');
            else
                addShortDescription( aShortDescriptions, 'BREEINBER', strVoltage, 'BRENETZ', 'Wechselstromnetz', 'BREVORB', 'nein', 'BREFKTGLRKNZ', '0');
        }
        else
            addShortDescription( aShortDescriptions, 'BREEINBER', strVoltage );
    }
    
    // function rectifier
    var strRectifier = ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER");
    if ( strRectifier !== 'ohne' )
        addShortDescription( aShortDescriptions, 'BREGLR', strRectifier );

    // for a special rectifier, we also have to create an additional short description for 'brake on terminal board'
    var strBRESHT = Bestimme_BREMSE_BRESHLT(oGear,oDataBremse)
    if ( strBRESHT == "am Klemmbrett" )
    {
        //Kurzangabe C20 wird nur ausgegeben, wenn Kenner aus BREDAT ungleich 1 ist
        addShortDescription( aShortDescriptions, 'BRESHLT', 'am Klemmbrett' );
    }
    
}


/**
 * @constructor
 * add short descriptions for other brake options to the array of short descriptions
 * 
 * @param oGear - geared motor object
 * @param aShortDescriptions - arary with short descriptions that should be enhanced for other brake options descriptions
 */
function _addBrakeOptionsDescriptions( oGear, oDataBremse, aShortDescriptions )
{
    // brake design
    var strDesign = ECL_GetValue("BREMSE_AUSFUEHRUNG");
    if ( strDesign === 'N' )
        addShortDescription( aShortDescriptions, 'BREAUS', 'N' );
    else if ( strDesign === 'G' )
        addShortDescription( aShortDescriptions, 'BREKAPS', 'G', 'BREKONDBOH', '-' );
    else if ( strDesign === 'GK' )
        addShortDescription( aShortDescriptions, 'BREKAPS', 'G', 'BREKONDBOH', 'mit' );
        
    // corrosion protection
    var strCorrosionProtection = ECL_GetValue("BREMSE_KORROSIONSSCHUTZ");
    if ( strCorrosionProtection === 'erhoehter Korrosionsschutz' )
        addShortDescription( aShortDescriptions, 'BREKORR', 'erhoehter Korrosionsschutz' );
        
    // wear
    var strWear = ECL_GetValue("BREMSE_REIBBELAG");
    if ( strWear === 'verschl.armer Belag' )
        addShortDescription( aShortDescriptions, 'BREGERRED', 'verschl.armer Belag' );
    
    // manual brake release
    var strRelease = ECL_GetValue("BREMSE_HANDLUEFTUNG");
    if ( strRelease !== '-' )
    {
        addShortDescription( aShortDescriptions, 'BREHLART', strRelease );
        
        // location of manual brake release
        addShortDescription( aShortDescriptions, 'BREHLAG', ECL_GetValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL") );
    }
    
    // monitoring
    var strMonitor = ECL_GetValue("BREMSE_UEBERWACHUNG");
    if ( strMonitor !== 'ohne' )
    {
        // in table MLFB_OPTIONEN_MERKMALE_NGEN is noted that we should not generate short descriptions for all sorts of micro switches
        addShortDescription( aShortDescriptions, 'BREAUS', 'M', 'BREUEB', strMonitor );
    }
    
    // cable protection
    if ( ECL_ValueSelected("BREMSE_BREMSKABELSCHUTZ_OPTION","T") )
        addShortDescription( aShortDescriptions, 'BREKSHTZ', 'mit' );
}

