//@legacy
//#mode(full-ecma)


//@import "MLFB.MOTOX.SD.common.js"


/**
 * @category   MOTOX MLFB generation
 * @package    product logic
 * @copyright  Copyright (c) 2012 Plan Software GmbH (http://www.plansoft.de)
 */

/**
 * @constructor
 * get short descriptions for the encoder attributes
 * 
 * @param oGear - geared motor object
 *
 * @return array - short descriptions for the encoder attributes,
 *                 each index contains a string with one short description (may be empty)
 */
function getEncoderDescriptions( oGear )
{
    var aShortDescriptions = [];
    
    if(ECL_ValueSelected("MIT_GEBER", "T"))
    {
        // encoder type
        _addEncoderTypeDescription( oGear, aShortDescriptions );
        
        // encoder options
        _addEncoderOptionsDescription( oGear, aShortDescriptions );
        
        // encoder mechanical protection
        if (ECL_GetValue("GEBER_MECHSCHUTZ") === 'UNTER_HAUBE' )
            addShortDescription( aShortDescriptions, 'GEBHAUBE', 'mit' );
        
        // encoder gateway
        var strGateway = ECL_GetValue("GEBER_ZUB_GATEWAYS");
        if ( ( strGateway !== '-' ) && ( strGateway !== '' ) )
            addShortDescription( aShortDescriptions, 'GEBELZUB', strGateway );
    }
    
    return( aShortDescriptions );
}


/**
 * @constructor
 * add short description for the encoder type to the array of short descriptions
 * 
 * @param oGear - geared motor object
 * @param aShortDescriptions - arary with short descriptions that should be enhanced for encoder descriptions
 */
function _addEncoderTypeDescription( oGear, aShortDescriptions )
{
    var strDesign = ECL_GetValue("GEBER_AUSFUEHRUNG");
    strDesign=replace(strDesign,"_MT","");
    strDesign=replace(strDesign,"_ST","");
    
    var strType = ECL_GetValue("GEBER_DIREKTAUSWAHL");
    strType=replace(strType,"|-","");
    strType=replace(strType,"|Kauf","");
    
    var strMechanics = ECL_GetValue("GEBER_MECH_VAR");
    var strElectronics = ECL_GetValue("GEBER_ELEKTRONIK");
    var strKONSTAFS = ECL_GetValue("GEBER_FUNKT_SICHERHEIT");
    
    if ( ( strType !== '' ) )
    {
        if(strElectronics=="DRIVE-CLIQ")
        {
            var strFKTSicherheit="-";
            if(strKONSTAFS=="Kauf")
                strFKTSicherheit="ja";
                
            addShortDescription( aShortDescriptions, 'GEBTYP', "IA_DQ", 'GEBBEZ', strType, 'FKTSICHERHEIT', strFKTSicherheit );
        }
        else
            addShortDescription( aShortDescriptions, 'GEBTYP', strDesign, 'GEBBEZ', strType );
    }
}


/**
 * @constructor
 * add short description for the encoder options to the array of short descriptions
 * 
 * @param oGear - geared motor object
 * @param aShortDescriptions - arary with short descriptions that should be enhanced for encoder descriptions
 */
function _addEncoderOptionsDescription( oGear, aShortDescriptions )
{
    var strOptions = ECL_GetValue("GEBER_ZUB_KABEL");
    var strMechanics = ECL_GetValue("GEBER_MECH_VAR");

    if ( ( strOptions !== 'OHNE' ) && ( strOptions !== '' ) )
    {
        if ( strMechanics === 'Kabelkasten' )
            addShortDescription( aShortDescriptions, 'GEBMECHMLFB', 'Kabelkasten', 'GEBMECHZUB', strOptions );
        else if ( ( strMechanics === 'Flanschdose' ) || ( strMechanics === '1m Kabel+Kupplungsdose' ) || ( strMechanics === 'Kabel+Kupplungsdose' ) || ( strMechanics === '0,3m Kabel+Kupplungsdose' ) )
            addShortDescription( aShortDescriptions, 'GEBMECHMLFB', 'Flanschdose', 'GEBMECHZUB', strOptions );
    }	
}

