//@legacy
//#mode(full-ecma)


//@import "Parser.ShortDescriptions.js"


/**
 * @category   SimoGear Parser
 * @package    Parser
 * @copyright  Copyright (c) 2012 Plan Software GmbH (http://www.plansoft.de)
 */


/**
 * @constructor
 * checks if a partial MLFB encodes a valid generation digit
 *
 * @param strGenerationDigitMLFB - partial MLFB for generation digit (MUST contain only one character)
 *
 * @return boolean - false: mlfb invalid
 *                   true: mlfb valid
 */
function checkGenerationDigit( strGenerationDigitMLFB )
{
    // must be 3 for SimoGear
    if(strGenerationDigitMLFB === '3' || strGenerationDigitMLFB === '4')
        return (true);
    else
        return (false);
}


/**
 * @constructor
 * checks if the gear type decoding of a MLFB part is valid for SimoGear
 *
 * @param strGearTypeMLFB - partial mlfb for the gear type (contains three digits)
 *
 * @return object - null, if MLFB part is invalid
 *                  attributes MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI if MLFB part is valid
 */
function checkGearType( strGearTypeMLFB, strRegion )
{
    // build select statement
    var strDigit5 = strGearTypeMLFB.charAt( 0 );
    var strDigit6 = strGearTypeMLFB.charAt( 1 );
    var strDigit7 = strGearTypeMLFB.charAt( 2 );
    
    var strSelect;
    if(strRegion == "CHINA")
    {
        strSelect = "SELECT MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, EGBEZEI, EGBEZBRA, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI FROM MLFB4_EGTYP WHERE MLFB_2KJ_5 = '" + 
            strDigit5 + "' AND MLFB_2KJ_6='" + strDigit6 + "' AND MLFB_2KJ_7='" + strDigit7 + "' ";
    }
    else
    {
        strSelect = "SELECT MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, EGBEZEI, EGBEZBRA, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI FROM MLFB3_EGTYP WHERE MLFB_2KJ_5 = '" + 
            strDigit5 + "' AND MLFB_2KJ_6='" + strDigit6 + "' AND MLFB_2KJ_7='" + strDigit7 + "' ";
    }

    var aResult = Object.fromDatabase( '2KJ_DB', strSelect );
    if ( aResult.length > 0 )
    {
        var strCheckSelect = "SELECT DISTINCT * FROM CD_GETRIEBE_BEZEICHNUNGEN WHERE EGBEZTYP='"+aResult[0].EGBEZTYP+"' AND EGBEZUEBS='"+aResult[0].EGBEZUEBS+"' AND EGBEZDIM='"+aResult[0].EGBEZDIM+"' AND EGBEZEI='"+aResult[0].EGBEZEI+"' AND EGBEZBRA='"+aResult[0].EGBEZBRA+"' AND ZGBEZUEBS='"+aResult[0].ZGBEZUEBS+"' AND ZGBEZDIM='"+aResult[0].ZGBEZDIM+"' AND ZGBEZEI='"+aResult[0].ZGBEZEI+"' ";
        //strCheckSelect = strCheckSelect + "AND REGION='"+strRegion+"' ";
        
        var acheckResult = Object.fromDatabase( '2KJ_DB', strCheckSelect );
        if(acheckResult.length > 0)
        {
            aResult[0].ANWTYP = acheckResult[0].ANWTYP;
            aResult[0].EGTYP = acheckResult[0].GETRIEBE_BEZ;
            aResult[0].EGBEZBRA = acheckResult[0].EGBEZBRA;
            return( aResult[0] );
        }
        else
            return( null );
    }
    
    return( null );
}


/**
 * @constructor
 * checks if the fastening decoding of a MLFB part is valid for SimoGear
 *
 * @param strFasteningMLFB - partial mlfb for the fastening (contains one digit)
 *
 * @return object - null, if MLFB part is invalid
 *                  attributes MLFB_2KJ_14, MLFB_2KJ_14_KA, EGBEZBEF if MLFB part is valid
 */
 function checkFastening( strFasteningMLFB, strRegion, strEGBEZTYP, strEGBEZDIM, strEGBEZBRA, KeepConfiguration )
{
    var strSelect = "";
    if(strRegion =="CHINA")
        strSelect = "SELECT DISTINCT EGBEZBEF, EGABDMSTFIG, MLFB_2KJ_14, MLFB_2KJ_14_KA FROM MLFB4_EGBEF WHERE MLFB_2KJ_14 = '" + strFasteningMLFB + "' AND EGBEZTYP = '"+strEGBEZTYP+"' ";
    else
        strSelect = "SELECT DISTINCT EGBEZBEF, EGABDMSTFIG, MLFB_2KJ_14, MLFB_2KJ_14_KA FROM MLFB3_EGBEF WHERE MLFB_2KJ_14 = '" + strFasteningMLFB + "' AND EGBEZTYP = '"+strEGBEZTYP+"' ";
    
    var aResult = Object.fromDatabase( '2KJ_DB', strSelect );
    if (KeepConfiguration)
    {

		//Bei Keep Configuration muss im Fall der Fälle die nicht funktionierende Befestigungsart mit der Default Bfestigungsart überschrieben werden.
		if ( aResult.length > 0 )
		{
			//Erweiterte Überprüfung, ob die Befetigungsart wirklich valide ist
			var strSelect_EGTYP = "SELECT EGBEZBEF FROM EGTYP WHERE EGBEZTYP='"+strEGBEZTYP+"' AND EGBEZDIM='"+strEGBEZDIM+"' AND EGBEZBRA='"+strEGBEZBRA+"' AND EGBEZBEF= '"+aResult[0].EGBEZBEF+"'AND REGION IN ('S','SA','SACE') " ;
			var aResult_EGYTP = Object.fromDatabase( '2KJ_DB', strSelect_EGTYP );
			if(aResult_EGYTP.length>0)
			{
				aResult[0].KeepConfiguration="ok";
				return( aResult[0] );
			}
			else
			{
				//Befestigungsart nicht möglich; Neue bestimmen!
				var strSelect_EGTYP = "SELECT EGBEZBEF FROM EGTYP WHERE EGBEZTYP='"+strEGBEZTYP+"' AND EGBEZDIM='"+strEGBEZDIM+"' AND EGBEZBRA='"+strEGBEZBRA+"' AND REGION IN ('S','SA','SACE') " ;
				var aResult_EGYTP = Object.fromDatabase( '2KJ_DB', strSelect_EGTYP );
				if(aResult_EGYTP.length>0)
				{
					strSelect = "SELECT DISTINCT EGBEZBEF, EGABDMSTFIG, MLFB_2KJ_14, MLFB_2KJ_14_KA FROM MLFB3_EGBEF WHERE EGBEZBEF = '" + aResult_EGYTP[0].EGBEZBEF + "' AND EGBEZTYP = '"+strEGBEZTYP+"' ";
					aResult = Object.fromDatabase( '2KJ_DB', strSelect );
					aResult[0].KeepConfiguration="error"; // damit die neue Rumpf MLFB übernommen wird
					return( aResult[0] );
				}
				else
				{
					//neuer Default Wert muss bestimmt werden
					//neue MLFB geht zurück
					aResult.push({"KeepConfiguration": "error", "MLFB_2KJ_14" : "A", "EGBEZBEF" : "-"});
					return( aResult[0] );
				}
			}
        }
        else
        {
            //neuer Default Wert muss bestimmt werden
            //neue MLFB geht zurück
            aResult.push({"KeepConfiguration": "error", "MLFB_2KJ_14" : "A", "EGBEZBEF" : "-"});
            return( aResult[0] );
        }		
    }
    else if ( aResult.length > 0 )
    {
        return( aResult[0] );
    }
    
    return( null );
}


/**
 * @constructor
 * checks if the shaft decoding of a MLFB part is valid for SimoGear
 *
 * @param strShaftMLFB - partial mlfb for the shaft (contains one digit)
 * @param strShaftSD - necessary short description for shaft (only valid if strShaftMLFB is 9)
 * @param oGearType - object that describes the gear type attributes:
 *                    MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI, M3
 * @param oFastening - object that describes the fastening, attributes:
 *                     MLFB_2KJ_14, MLFB_2KJ_14_KA, EGBEZBEF
 * @param oShortDescriptions - object with short description information
 *                             each attribute name is a short description
 *                             each attribute value is an object with attributes group and freetext
 *
 * @return object - null, if MLFB part is invalid
 *                  attributes EGTYP, EGABW, EGBEZAWTYP, EGBEZWNV, EGBEZBRA, ANWTYP, EGBEZSO if MLFB part is valid
 */
function checkShaft( strShaftMLFB, strShaftSD, oGearType, oFastening, oShortDescriptions, strRegion, KeepConfiguration )
{
    // the feature for gear industrial sector must be calculated from short descriptions at this poin
    
    // build select statement
    
    var strSelect
    if(strRegion == "CHINA")
    {
        strSelect = "SELECT DISTINCT EGTYP.TYPBEZ AS EGTYP, EGABKD_M3.EGABW AS EGABW, EGABKD_M3.EGABKDBEZ AS EGABKDBEZ,EGABKD_M3.WELLE_BDS AS WELLE_BDS,EGABKD_M3.WELLE_O_PF AS WELLE_O_PF,EGABKD_M3.EGABAUSF AS EGABAUSF, EGTYP.EGBEZAWTYP AS EGBEZAWTYP, EGTYP.EGBEZWNV AS EGBEZWNV, " + 
            "EGTYP.EGBEZBRA AS EGBEZBRA, EGTYP.ANWTYP AS ANWTYP, EGTYP.EGBEZSO AS EGBEZSO FROM MLFB4_EGTYP, EGTYP, EGABKD_M3 WHERE ";
    }
    else
    {
        strSelect = "SELECT DISTINCT EGTYP.TYPBEZ AS EGTYP, EGABKD_M3.EGABW AS EGABW, EGABKD_M3.EGABKDBEZ AS EGABKDBEZ,EGABKD_M3.WELLE_BDS AS WELLE_BDS,EGABKD_M3.WELLE_O_PF AS WELLE_O_PF,EGABKD_M3.EGABAUSF AS EGABAUSF, EGTYP.EGBEZAWTYP AS EGBEZAWTYP, EGTYP.EGBEZWNV AS EGBEZWNV, " + 
            "EGTYP.EGBEZBRA AS EGBEZBRA, EGTYP.ANWTYP AS ANWTYP, EGTYP.EGBEZSO AS EGBEZSO FROM MLFB3_EGTYP, EGTYP, EGABKD_M3 WHERE ";
    }
    
    
    strSelect = strSelect + "EGTYP.CDROM_REL = '1' AND EGABKD_M3.G115='0' AND EGABKD_M3.REGION='S' AND ";
    
    
    if(strRegion == "CHINA")
    {
        strSelect = strSelect + "MLFB4_EGTYP.MLFB_2KJ_5 = '" + oGearType.MLFB_2KJ_5 +
                    "' AND MLFB4_EGTYP.MLFB_2KJ_6 = '" + oGearType.MLFB_2KJ_6 + 
                    "' AND MLFB4_EGTYP.MLFB_2KJ_7 = '" + oGearType.MLFB_2KJ_7 + 
                    "' AND EGABKD_M3.MLFB_2KJ_8 = '" + strShaftMLFB + 
                    "' AND EGTYP.EGBEZBEF = '" + oFastening.EGBEZBEF + 
                    "' AND EGTYP.EGBEZBRA = '" + oGearType.EGBEZBRA +
                    "' AND MLFB4_EGTYP.EGBEZTYP = EGTYP.EGBEZTYP AND MLFB4_EGTYP.EGBEZUEBS = EGTYP.EGBEZUEBS AND MLFB4_EGTYP.EGBEZDIM = EGTYP.EGBEZDIM AND " + 
                    "MLFB4_EGTYP.EGBEZEI = EGTYP.EGBEZEI AND EGTYP.TYPBEZ = EGABKD_M3.EGTYP ";
    }
    else
    {
        strSelect = strSelect + "MLFB3_EGTYP.MLFB_2KJ_5 = '" + oGearType.MLFB_2KJ_5 +
                    "' AND MLFB3_EGTYP.MLFB_2KJ_6 = '" + oGearType.MLFB_2KJ_6 + 
                    "' AND MLFB3_EGTYP.MLFB_2KJ_7 = '" + oGearType.MLFB_2KJ_7 + 
                    "' AND EGABKD_M3.MLFB_2KJ_8 = '" + strShaftMLFB + 
                    "' AND EGTYP.EGBEZBEF = '" + oFastening.EGBEZBEF + 
                    "' AND EGTYP.EGBEZBRA = '" + oGearType.EGBEZBRA +
                    "' AND MLFB3_EGTYP.EGBEZTYP = EGTYP.EGBEZTYP AND MLFB3_EGTYP.EGBEZUEBS = EGTYP.EGBEZUEBS AND MLFB3_EGTYP.EGBEZDIM = EGTYP.EGBEZDIM AND " + 
                    "MLFB3_EGTYP.EGBEZEI = EGTYP.EGBEZEI AND EGTYP.TYPBEZ = EGABKD_M3.EGTYP ";
    }
    
    if ( strShaftMLFB === '9' )
    {
        // necessary short description needed
        strSelect += " AND MLFB_2KJ_8_KA = '" + strShaftSD + "' ";
    }
    // we also must distinguish if a backstop or backlash design is present for the gear or not
    if ( 'G72' in oShortDescriptions )
        strSelect += " AND EGTYP.EGBEZSO = 'X' ";
    else if ( 'G99' in oShortDescriptions )
        strSelect += " AND EGTYP.EGBEZSO = 'W' ";
    else strSelect += " AND EGTYP.EGBEZSO = '-' ";
    
    //strSelect = strSelect + "AND EGTYP.S09 = '0' ";

    var aResult = Object.fromDatabase( '2KJ_DB', strSelect );
    if (KeepConfiguration)
    {
        //Bei Keep Configuration muss im Fall der Fälle die nicht funktionierende Welle mit der Default Welle überschrieben werden.
        if ( aResult.length > 0 )
        {
            aResult[0].KeepConfiguration="ok";
            return( aResult[0] );
        }
        else
        {
            //neuer Default Wert muss bestimmt werden
            //neue MLFB geht zurück
            aResult[0] = Bestimme_AbtriebswellenmassforKeepConfiguration( oGearType, oFastening, oShortDescriptions);
            aResult[0].KeepConfiguration="error";
            return( aResult[0] );
        }		
    }
    else if ( aResult.length > 0 )
    {
        return( aResult[0] );
    }
    
    return( null );
}


/**
 * @constructor
 * checks if the gear ratio decoding of a MLFB part is valid for SimoGear
 *
 * @param strRatioMLFB - partial mlfb for the gear ratio (contains two digits)
 * @param oGearType - object that describes the gear type attributes:
 *                    MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI, M3
 *
 * @return object - null, if MLFB part is invalid
 *                  attributes DGUEB, ZGUEB, EGUEB, ETA, T2FB1, N2 if MLFB part is valid
 */
function checkRatio( strRatioMLFB, oGearType, strRegion )
{
    var c15 = strRatioMLFB.charAt( 0 );
    var c16 = strRatioMLFB.charAt( 1 );
    
    var strSelect;
    if(strRegion == "CHINA")
    {
        strSelect = "SELECT IGES.DGUEB AS DGUEB, IGES.EGUEB AS EGUEB, IGES.ZGUEB AS ZGUEB, IGES.ETA AS ETA, IGES.T2FB1 AS T2FB1, IGES.N2 AS N2 " + 
                    "FROM MLFB4_EGTYP, IGES WHERE MLFB4_EGTYP.MLFB_2KJ_5 = '" + oGearType.MLFB_2KJ_5 +
                    "' AND MLFB4_EGTYP.MLFB_2KJ_6 = '" + oGearType.MLFB_2KJ_6 + 
                    "' AND MLFB4_EGTYP.MLFB_2KJ_7 = '" + oGearType.MLFB_2KJ_7 +
                    "' AND MLFB4_EGTYP.EGBEZTYP = IGES.EGBEZTYP AND MLFB4_EGTYP.EGBEZUEBS = IGES.EGBEZUEBS AND MLFB4_EGTYP.EGBEZDIM = IGES.EGBEZDIM AND MLFB4_EGTYP.EGBEZEI = IGES.EGBEZEI AND " +
                    "MLFB4_EGTYP.ZGBEZUEBS = IGES.ZGBEZUEBS AND MLFB4_EGTYP.ZGBEZDIM = IGES.ZGBEZDIM AND MLFB4_EGTYP.ZGBEZEI = IGES.ZGBEZEI AND IGES.MLFB_2KJ_15 = '" + c15 + 
                    "' AND IGES.MLFB_2KJ_16 = '" + c16 +
                    "' AND IGES.EGBEZBRA = '" + oGearType.EGBEZBRA + "' ";
    }
    else
    {
        strSelect = "SELECT IGES_M3.DGUEB AS DGUEB, IGES_M3.EGUEB AS EGUEB, IGES_M3.ZGUEB AS ZGUEB, IGES_M3.ETA AS ETA, IGES_M3.T2FB1 AS T2FB1, IGES_M3.N2 AS N2 " + 
                    "FROM MLFB3_EGTYP, IGES_M3 WHERE MLFB3_EGTYP.MLFB_2KJ_5 = '" + oGearType.MLFB_2KJ_5 +
                    "' AND MLFB3_EGTYP.MLFB_2KJ_6 = '" + oGearType.MLFB_2KJ_6 + 
                    "' AND MLFB3_EGTYP.MLFB_2KJ_7 = '" + oGearType.MLFB_2KJ_7 +
                    "' AND MLFB3_EGTYP.EGBEZTYP = IGES_M3.EGBEZTYP AND MLFB3_EGTYP.EGBEZUEBS = IGES_M3.EGBEZUEBS AND MLFB3_EGTYP.EGBEZDIM = IGES_M3.EGBEZDIM AND MLFB3_EGTYP.EGBEZEI = IGES_M3.EGBEZEI AND " +
                    "MLFB3_EGTYP.ZGBEZUEBS = IGES_M3.ZGBEZUEBS AND MLFB3_EGTYP.ZGBEZDIM = IGES_M3.ZGBEZDIM AND MLFB3_EGTYP.ZGBEZEI = IGES_M3.ZGBEZEI AND IGES_M3.MLFB_2KJ_15 = '" + c15 + 
                    "' AND IGES_M3.MLFB_2KJ_16 = '" + c16 +
                    "' AND IGES_M3.EGBEZBRA = '" + oGearType.EGBEZBRA + "' " +
                    " AND IGES_M3.SONDER = '-' " +
                    " AND IGES_M3.REGION IN ('SACE','SACEN') ";
    }

    var aResult = Object.fromDatabase( '2KJ_DB', strSelect );
    if ( aResult.length > 0 )
        return( aResult[0] );
    
    return( null );
}


/**
 * @constructor
 * checks if the motor decoding of a MLFB part is valid for SimoGear
 *
 * @param strMotorMLFB - partial mlfb for the motor (contains five digits)
 * @param strVoltageSD - necessary short description for voltage (only valid if last digit of strMotorMLFB is 9)
 * @param oGearType - object that describes the gear type attributes:
 *                    MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI, M3
 * @param oShortDescriptions - object with short description information
 *                             each attribute name is a short description
 *                             each attribute value is an object with attributes group and freetext
 *
 * @return object - null, if MLFB part is invalid
 *                  attributes MLFB_2KJ_9, MLFB_2KJ_10, MLFB_2KJ_11, MLFB_2KJ_12, MLFB_2KJ_13, MLFB_2KJ_P_KA, MLFB_2KJ_13_KA, SO_NEMA_KA, SO_NEMA, SO_CSA_UL_R_KA, SO_CSA_UL_R, 
 *                  SO_GOST_KA, SO_GOST, SO_CHINA_KA, SO_CHINA, SO_CE_KA, SO_CE, WARMEKL, WIBLNR, WIBLAUSLG, POLZAHL, FREQUENZ, MOTDIM, FU, NETZ, SUCHTYP etc.
 *                  (all columns of table CD_MOTOREN) if MLFB part is valid
 */
function checkMotor( strMotorMLFB, strVoltageSD, strWIBLARTATEXSD, oGearType, oShortDescriptions, strRegion, incompleteSizerMLFB )
{
    //ATEX Verarbeitung
    var strATEX_EP_GAS = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionGas");
    var strATEX_EP_STAUB = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionDust");
        
    if( (strATEX_EP_GAS != "" || strATEX_EP_STAUB != "") && strWIBLARTATEXSD != "") 
        ECL_SetValue("ECSI_ATEX_KENNER", "ATEX_INTEGRATED");
    else
        ECL_SetValue("ECSI_ATEX_KENNER", "");
            
    if(incompleteSizerMLFB && ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        var strATEXZoneSD=getSDFromGroup( oShortDescriptions, 'ATEX_ZONE' );
        
        //Prüfung
        if(strATEXZoneSD != "")
        {
            if(strATEX_EP_GAS=="2" && strATEXZoneSD=="K74")
            {
                //Unterschiede bei Context und MLFB
                return( null );
            }
            else if(strATEX_EP_STAUB=="22" && strATEXZoneSD=="K72")
            {
                //Unterschiede bei Context und MLFB
                return( null );
            }
        }
        
        if(strATEX_EP_GAS == "1")
            ECL_SetValue("ECSI_ATEX_ZONE", "1");
        else if(strATEX_EP_GAS == "2")
            ECL_SetValue("ECSI_ATEX_ZONE", "2");
        else if(strATEX_EP_STAUB == "21")
            ECL_SetValue("ECSI_ATEX_ZONE", "21");
        else if(strATEX_EP_STAUB == "22")
            ECL_SetValue("ECSI_ATEX_ZONE", "22");
        else
            ECL_SetValue("ECSI_ATEX_ZONE", "");
            
        if(ECL_GetValue("ECSI_ATEX_ZONE") == "2")
        {
            ECL_SetValue("ECSI_ATEX_EGRUPPE","IIC");
        }
        else if(ECL_GetValue("ECSI_ATEX_ZONE") == "22")
        {
            ECL_SetValue("ECSI_ATEX_EGRUPPE","IIIB");
        }
        else
            ECL_SetValue("ECSI_ATEX_EGRUPPE","");
            
        if(ECL_GetValue("ECSI_ATEX_ZONE") == "1" || ECL_GetValue("ECSI_ATEX_ZONE") == "2")
        {
            ECL_SetValue("ECSI_ATEX_TCLASS","T3"); //K77
        }
        else if(ECL_GetValue("ECSI_ATEX_ZONE") == "21" || ECL_GetValue("ECSI_ATEX_ZONE") == "22")
        {
            ECL_SetValue("ECSI_ATEX_TCLASS","120"); //K75
        }
    }	
    else if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        // kommt aus MLFB
        
        var strATEXZoneSD=getSDFromGroup( oShortDescriptions, 'ATEX_ZONE' );
        
        //Prüfung
        if(strATEX_EP_GAS=="2" && strATEXZoneSD=="K74")
        {
            //Unterschiede bei Context und MLFB
            return( null );
        }
        else if(strATEX_EP_STAUB=="22" && strATEXZoneSD=="K72")
        {
            //Unterschiede bei Context und MLFB
            return( null );
        }
        
        if(strATEXZoneSD=="K71")
            ECL_SetValue("ECSI_ATEX_ZONE", "1")
        else if(strATEXZoneSD=="K72")
            ECL_SetValue("ECSI_ATEX_ZONE", "2")
        else if(strATEXZoneSD=="K73")
            ECL_SetValue("ECSI_ATEX_ZONE", "21")
        else if(strATEXZoneSD=="K74")
            ECL_SetValue("ECSI_ATEX_ZONE", "22")
                
        var strATEXGetriebeSD=getSDFromGroup( oShortDescriptions, 'ATEX_GETRIEBE' );
        var strSelect="SELECT DISTINCT WERT_1 FROM MLFB_OPTIONEN WHERE MLFB_OPTION='"+strATEXGetriebeSD+"' ";
        var aResult =  Object.fromDatabase( '2KJ_DB', strSelect );
        if(aResult.length>0)
        {
            var strSelect="SELECT ATEXKATEGORIE FROM ATEXKNZGETR WHERE MOTOX_N='0' AND CDROM_REL='1' AND AKTIV='1' AND ATEXKNZGETR='"+aResult[0].WERT_1+"' AND ZONE='"+ECL_GetValue("ECSI_ATEX_ZONE")+"' ";
            var aResult2 =  Object.fromDatabase( '2KJ_DB', strSelect );
            if(aResult2.length>0)
            {
                ECL_SetValue("ECSI_ATEX_EGRUPPE",aResult2[0].ATEXKATEGORIE);
            }
        }
        else
            logtraceln("Fehler beim Motorcheck Parser, Bestimung der Kategorie!");
        
        var strATEXTKSD=getSDFromGroup( oShortDescriptions, 'ATEX_TK' );
        if(strATEXTKSD=="K75")
        {
            ECL_SetValue("ECSI_ATEX_TCLASS","120"); //K75
        }
        else if (strATEXTKSD=="K77")
        {
            ECL_SetValue("ECSI_ATEX_TCLASS","T3"); //K77
        }
    }
    
    //Werte ATEX in Attribute setzen
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        ECL_SetValue("ATEX_ZONE", ECL_GetValue("ECSI_ATEX_ZONE"));
        ECL_SetValue("ATEX_EXPLOSIONSGRUPPE", ECL_GetValue("ECSI_ATEX_EGRUPPE"));
    }
    
    var c9 = strMotorMLFB.charAt( 0 );		// motor size part 1
    var c10 = strMotorMLFB.charAt( 1 );		// motor size part 2
    var c11 = strMotorMLFB.charAt( 2 );		// motor type
    var c12 = strMotorMLFB.charAt( 3 );		// motor generation
    var c13 = strMotorMLFB.charAt( 4 );		// motor voltage

    //Weltmotor ( Stelle 13 ist "6" oder "7")
	if(c13 == "6" || c13 == "7"){
        ECL_SetValue("ECSI_WMFU_KENNER","ja");
    }
    else{
        ECL_SetValue("ECSI_WMFU_KENNER","");
    }
    
    //Frequenz wird aus Sizer übergeben
    var strFrequency = ECL_GetValue("ECSI_CX_MotorFrequency");
    logtraceln("Motor Frequency from SIZER="+strFrequency)
    
    //test
    if(strFrequency==""){
        strFrequency = "50";
    }
    
    if(strFrequency  == "6050"){
        strFrequency = "60";
    }
    
    var strPowerSD = getSDFromGroup( oShortDescriptions, 'MOTORLEISTUNG' );
    var strSPGTOLSD = getSDFromGroup( oShortDescriptions, 'MOTORSPGTOL' );
    
    if ( strPowerSD === '' )
        strPowerSD = '-';
        
    if ( strSPGTOLSD === '' )
        strSPGTOLSD = '-';
    
    //Bestimmung des Spezifikationsstrings in der MOTELAUSF
    var strMOTELAUSF_CE_MLFB = "";
    var strMOTELAUSF_UL_MLFB = "";
    var strMOTELAUSF_CEL_MLFB = "";
    var strMOTELAUSF_EAC_MLFB = "";
    var strMOTELAUSF_EXP_MLFB = "";
    var strMOTELAUSF_EX_CEL_MLFB = "";
    var strMOTELAUSF_WM_FU_MLFB = "";
    var strMOTELAUSF_BIS_MLFB = "";
    var strMOTELAUSF_KEMCO_MLFB = "";

    var strSpecString="";
    
    if(!incompleteSizerMLFB)
    {
        if ( 'N38' in oShortDescriptions )
        {
            // specification ULR/CSA
            strMOTELAUSF_UL_MLFB = "UL-R/CSA";
            ECL_SelectValue("ECSI_SPEZIFIKATION_CHECK", "ULR_CSA");
            ECL_SelectValue("SPEZIFIKATION_ULR_CSA", "T");
        }
        else
        {
            strMOTELAUSF_UL_MLFB = "-";
            ECL_SelectValue("SPEZIFIKATION_ULR_CSA", "F");
        }
        
        if ( 'N67' in oShortDescriptions )
        {
            // specification CHINA	
            strMOTELAUSF_CEL_MLFB = "CHINA";
            ECL_SelectValue("ECSI_SPEZIFIKATION_CHECK", "CHINA");
            ECL_SelectValue("SPEZIFIKATION_CHINA", "T");
        }
        else
        {
            //strMOTELAUSF_CEL_MLFB = "-";
            ECL_SelectValue("SPEZIFIKATION_CHINA", "F");
        }
        
        
        if ( 'N30' in oShortDescriptions )
        {
            // specification EAC
            strMOTELAUSF_EAC_MLFB = "EAC";
            ECL_SelectValue("ECSI_SPEZIFIKATION_CHECK", "EAC");
            ECL_SelectValue("SPEZIFIKATION_EAC", "T");
        }
        else
        {
            //strMOTELAUSF_EAC_MLFB = "-";
            ECL_SelectValue("SPEZIFIKATION_EAC", "F");
        }
        
        if ( 'N32' in oShortDescriptions )
        {
            // specification CHINA	EX
            strMOTELAUSF_EX_CEL_MLFB = "CCC_Ex";
            ECL_SelectValue("ECSI_SPEZIFIKATION_CHECK", "CCC_Ex");
            ECL_SelectValue("SPEZIFIKATION_CHINA_EX", "T");
        }
        else
        {
            //strMOTELAUSF_CEL_MLFB = "-";
            ECL_SelectValue("SPEZIFIKATION_CHINA_EX", "F");
        }

        if ('N27' in oShortDescriptions) 
        {
            // specification BIS India
            strMOTELAUSF_BIS_MLFB = "BIS";
            ECL_SelectValue("ECSI_SPEZIFIKATION_CHECK", "BIS");
            ECL_SelectValue("SPEZIFIKATION_BIS", "T");
        }
        else 
        {
            ECL_SelectValue("SPEZIFIKATION_BIS", "F");
        }

        if ('N33' in oShortDescriptions) 
        {
            // specification KEMCO South Korea
            strMOTELAUSF_KEMCO_MLFB = "KEMCO";
            ECL_SelectValue("ECSI_SPEZIFIKATION_CHECK", "KEMCO");
            ECL_SelectValue("SPEZIFIKATION_KEMCO", "T");
        }
        else 
        {
            ECL_SelectValue("SPEZIFIKATION_KEMCO", "F");
        }
        
        strMOTELAUSF_EXP_MLFB = "-";
		
		if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
		{
			ECL_SelectValue("SPEZIFIKATION_CE_EXPORT", "CE");
			strMOTELAUSF_CE_MLFB = "-";
			strMOTELAUSF_WM_FU_MLFB = "-";
		}
		else
		{
			ECL_SelectValue("SPEZIFIKATION_CE_EXPORT", "CE");
			strMOTELAUSF_CE_MLFB = "-";
			strMOTELAUSF_WM_FU_MLFB = "-";
		}
		
		strSpecString = createSpecStringforParser(strRegion,oGearType,strMOTELAUSF_CE_MLFB,strMOTELAUSF_UL_MLFB,strMOTELAUSF_CEL_MLFB,strMOTELAUSF_EAC_MLFB,strMOTELAUSF_EXP_MLFB,strMOTELAUSF_EX_CEL_MLFB,strMOTELAUSF_WM_FU_MLFB,strMOTELAUSF_BIS_MLFB,strMOTELAUSF_KEMCO_MLFB);
    }    
    else
    {
        // Nur N38 kommt bei nicht kompletter MLFB
        if ( 'N38' in oShortDescriptions )
        {
            // specification ULR/CSA
            strMOTELAUSF_UL_MLFB = "UL-R/CSA";
            ECL_SelectValue("ECSI_SPEZIFIKATION_CHECK", "ULR_CSA");
            ECL_SelectValue("SPEZIFIKATION_ULR_CSA", "T");
        }
        else
        {
            strMOTELAUSF_UL_MLFB = "-";
            ECL_SelectValue("SPEZIFIKATION_ULR_CSA", "");
        }
        
        strMOTELAUSF_EXP_MLFB = "-";
		
		if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
		{
			ECL_SelectValue("SPEZIFIKATION_CE_EXPORT", "CE");
			strMOTELAUSF_CE_MLFB = "-";
			strMOTELAUSF_WM_FU_MLFB = "-";
		}
		else
		{
			ECL_SelectValue("SPEZIFIKATION_CE_EXPORT", "CE");
			strMOTELAUSF_CE_MLFB = "-";
			strMOTELAUSF_WM_FU_MLFB = "-";
		}
		
		strSpecString = createSpecStringforParser(strRegion,oGearType,strMOTELAUSF_CE_MLFB,strMOTELAUSF_UL_MLFB,strMOTELAUSF_CEL_MLFB,strMOTELAUSF_EAC_MLFB,strMOTELAUSF_EXP_MLFB,strMOTELAUSF_EX_CEL_MLFB,strMOTELAUSF_WM_FU_MLFB,strMOTELAUSF_BIS_MLFB,strMOTELAUSF_KEMCO_MLFB);
	}    
    var strBaseSelect="";
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        //Zone kann auch eingeschränkt werden
        if(ECL_GetValue("ECSI_CX_MinimalExplosionProtectionGas")=="2")
            strBaseSelect = "SELECT DISTINCT * FROM CD_MOTOREN WHERE MLFB_2KJ_9 = '" + c9 + "' AND MLFB_2KJ_10 = '" + c10 + "' AND MLFB_2KJ_11 = '" + c11 + "' AND MLFB_2KJ_12 = '" + c12 + "' AND MLFB_2KJ_13 = '" + c13 +	"' AND MLFB_2KJ_P_KA = '" + strPowerSD + "' AND MLFB_2KJ_13_KA_SPGTOL = '" + strSPGTOLSD  + "' AND MLFB_2KJ_BART_KA ='"+strWIBLARTATEXSD+"' AND EX_SCHUTZ IN ('Ex II 3G Ex ec IIC T3 Gc','Ex II 3G Ex ec IIB T3 Gc') ";
        else if(ECL_GetValue("ECSI_CX_MinimalExplosionProtectionDust")=="22")
            strBaseSelect = "SELECT DISTINCT * FROM CD_MOTOREN WHERE MLFB_2KJ_9 = '" + c9 + "' AND MLFB_2KJ_10 = '" + c10 + "' AND MLFB_2KJ_11 = '" + c11 + "' AND MLFB_2KJ_12 = '" + c12 + "' AND MLFB_2KJ_13 = '" + c13 +	"' AND MLFB_2KJ_P_KA = '" + strPowerSD + "' AND MLFB_2KJ_13_KA_SPGTOL = '" + strSPGTOLSD  + "' AND MLFB_2KJ_BART_KA ='"+strWIBLARTATEXSD+"' AND EX_SCHUTZ LIKE '"+ utf8toansi('Ex II 3D Ex tc IIIB T120_C Dc')+"'";
        else
            logtraceln("Error Motorsuche!, Nur ATEX Zone 2 und 22 erlaubt!");
    }
    else
    {
		strBaseSelect = "SELECT DISTINCT * FROM CD_MOTOREN WHERE MLFB_2KJ_9 = '" + c9 + "' AND MLFB_2KJ_10 = '" + c10 + "' AND MLFB_2KJ_11 = '" + c11 + "' AND MLFB_2KJ_12 = '" + c12 + "' AND MLFB_2KJ_13 = '" + c13 +	"' AND MLFB_2KJ_P_KA = '" + strPowerSD + "' AND MLFB_2KJ_13_KA_SPGTOL = '" + strSPGTOLSD  + "' AND MLFB_2KJ_BART_KA IN ('-','P91','P92') ";
	}
    
    if ( c13 === '9' )
    {
        // necessary short description needed
        strBaseSelect += " AND MLFB_2KJ_13_KA = '" + strVoltageSD + "' ";
    }
    else
    {
        // necessary short description not needed
        strBaseSelect += " AND MLFB_2KJ_13_KA = '-' ";
    }
    
    if(strSpecString != "")
        strBaseSelect += " AND MOTELAUSF IN "+strSpecString+" ";
    
    var strBremseSD = getSDFromGroup( oShortDescriptions, 'BREMSE_TYP' );
    if(strBremseSD != "")
    {
        strBaseSelect = strBaseSelect + "AND (KONSTABREM='Kauf' OR KONSTABREM='ALL') "
    }
    
    if(oGearType.ANWTYP=="KleinSchnecke")
        strBaseSelect = strBaseSelect + "AND S09='1' ";
    else
        strBaseSelect = strBaseSelect + "AND S09='0' ";
    
    if(ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        if(strFrequency == "50")
        {
            strBaseSelect = strBaseSelect + "AND FREQUENZ IN ('50','50/60') ";
        }
        else if(strFrequency == "60")
        {
            strBaseSelect = strBaseSelect + "AND FREQUENZ IN ('60','50/60') ";
        }
        else if(strFrequency == "87")
        {
            strBaseSelect = strBaseSelect + "AND FREQUENZ = '87' ";
        }
    }
    else if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
    {
        // Der Weltmotor hat keine genauen Frequenzen
        if(strFrequency == "50")
        {
            strBaseSelect = strBaseSelect + "AND FREQUENZ_1 IN ('50.4','50.5','50.7','50.8','50.9','51','51.3','51.5','51.6','51.7','52.1','52.3','52.7')  ";
        }
        else if(strFrequency == "60")
        {
            strBaseSelect = strBaseSelect + "AND FREQUENZ_2 IN ('59','59.1','59.2','59.3','59.4','59.5','59.6','59.7','60.2','60.7','61.7') ";
        }
        else if(strFrequency == "87")
        {
            strBaseSelect = strBaseSelect + "AND FREQUENZ_1 IN ('87.4','87.6','87.7','87.8','87.9','88','88.3','88.4','88.6','88.8','89','89.1','89.6') ";
        }
        else if(strFrequency == "104")
        {
            strBaseSelect = strBaseSelect + "AND FREQUENZ_2 IN ('100.7','100.9','101','101.1','101.3','101.5','101.8','101.9','102.5','103.2') ";
        }
    }
    else
    {
        if(strFrequency == "50")
        {
            strBaseSelect = strBaseSelect + "AND (FREQUENZ IN ('50','50/60','50/50','50/87') OR FREQUENZ2 = '50/104') ";
        }
        else if(strFrequency == "60")
        {
            strBaseSelect = strBaseSelect + "AND (FREQUENZ IN ('60','50/60','60/60','60/87') OR FREQUENZ2 = '60/104') ";
        }
        else if(strFrequency == "87")
        {
            strBaseSelect = strBaseSelect + "AND (FREQUENZ IN ('87','50/87') OR FREQUENZ2 IN ('50','87','87/104')) ";
        }
        else if(strFrequency == "104")
        {
            strBaseSelect = strBaseSelect + "AND (FREQUENZ2 = '87/104') ";
        }
    }
    
    // the poles must also be used
    var strPolesSD = getSDFromGroup( oShortDescriptions, 'MOTORPOLZAHL' );
    var strPoles = '4';
    if ( strPolesSD !== '' )
    {
        var strPolesSelect = "select PROPERTY_VALUE from OPTION_VALUES where KURZANGABE = '" + strPolesSD + "' ";
        var strDBResult = 'POLES_DESCRIPTION';
        if ( dbselect( 'MOTOX_KURZANGABEN_DB', strPolesSelect, strDBResult ) > 0 )
            strPoles = dbgetstring( strDBResult, 'PROPERTY_VALUE' );
    }
    strBaseSelect += " AND POLZAHL = '" + strPoles + "' ";
    
    if(!incompleteSizerMLFB)
    {
        if ( 'M08' in oShortDescriptions )
            strBaseSelect += " AND MOTWK = 'H' ";
        else strBaseSelect += " AND MOTWK = 'F' ";
    }
    
    var strSelect = strBaseSelect;
    
    strSelect += " ORDER BY MOTWK ASC,SAP_DOK_STATUS DESC,SAP_DOK_STATUS2 DESC,LEISTUNG24,MOTELAUSF ASC "; //Hack wegen fehlender H Motoren in der DTK Datenbank
    
    var aResult = Object.fromDatabase( '2KJ_DB', strSelect );
    if ( aResult.length > 0 )
    {
        var strSpecStringIst=BestimmeMoeglicheZertifikate(aResult);
        
        aResult[0].SpecString=strSpecStringIst;
        aResult[0].strFrequency=strFrequency;
    
        var strSelectTest="";
        strSelectTest="SELECT * FROM TMP_MOT_DATEN WHERE ";
        strSelectTest=strSelectTest+"MOT_EL_AUSFUEHRUNG = '"+aResult[0].MOTELAUSF+"' AND ";
        strSelectTest=strSelectTest+"MOT_POLZAHL = '"+aResult[0].POLZAHL+"' AND ";
		
        if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
		{
			if(strFrequency == "50")
			{
				strSelectTest=strSelectTest+"MOT_FREQUENZ = '"+aResult[0].FREQUENZ_1+"' AND ";
			}
			else if(strFrequency == "60")
			{
				strSelectTest=strSelectTest+"MOT_FREQUENZ = '"+aResult[0].FREQUENZ_2+"' AND ";
			}
			else if(strFrequency == "87")
			{
				strSelectTest=strSelectTest+"MOT_FREQUENZ = '"+aResult[0].FREQUENZ_1+"' AND ";
			}
			else if(strFrequency == "104")
			{
				strSelectTest=strSelectTest+"MOT_FREQUENZ = '"+aResult[0].FREQUENZ_2+"' AND ";
			}
		}
		else
		{
			strSelectTest=strSelectTest+"MOT_FREQUENZ = '"+strFrequency+"' AND ";
		}
		
        var strVSDMotor=aResult[0].VSDMOTOR;
        
        var strEFFKlasse="";
        if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
		{
			strEFFKlasse = 'IE3';	
		}
		else
		{
			if(aResult[0].strFrequency=="50")
			{
				strEFFKlasse = aResult[0].EFFKLASSE_1;	
			}
			else if(aResult[0].strFrequency=="60")
			{
				if(aResult[0].FREQUENZ_1=="60"){
					strEFFKlasse = aResult[0].EFFKLASSE_1;	
                }
                else if(aResult[0].FREQUENZ_2=="60"){
					strEFFKlasse = aResult[0].EFFKLASSE_2;	
                }
            }
			else if(aResult[0].strFrequency=="87")
			{
				if(aResult[0].FREQUENZ_2=="87"){
					strEFFKlasse = aResult[0].EFFKLASSE_2;	
                }
                else if(aResult[0].FREQUENZ2_1=="87"){
					strEFFKlasse = aResult[0].EFFKLASSE2_1;	
                }
                else if(aResult[0].FREQUENZ2_2=="87"){
					strEFFKlasse = aResult[0].EFFKLASSE2_2;	
                }
                else if(aResult[0].FREQUENZ_1=="87"){
					strEFFKlasse = aResult[0].EFFKLASSE_1;	
                }
            }
			else if(aResult[0].strFrequency=="104")
			{
				if(aResult[0].FREQUENZ2_1=="104"){
					strEFFKlasse = aResult[0].EFFKLASSE2_1;	
                }
                else if(aResult[0].FREQUENZ2_2=="104"){
					strEFFKlasse = aResult[0].EFFKLASSE2_2;	
                }
            }
		}
	
        if(strVSDMotor!="V"){
            strSelectTest=strSelectTest+"MOT_EFFIZIENZKL_KNZ = '"+strEFFKlasse.left(3)+"' AND ";
        }

        var strMOTBEZ="";
        if(oGearType.ANWTYP=="KleinSchnecke"){
            strMOTBEZ = replace((aResult[0].MOTTYP+aResult[0].MOEINKL+"I"+aResult[0].MOTDIM+aResult[0].PAKZUS+aResult[0].PAKLGE+aResult[0].POLZAHL+aResult[0].HEMOTOR+aResult[0].VSDMOTOR),"-","");
        }
        else{
            strMOTBEZ = replace((aResult[0].MOTTYP+aResult[0].MOEINKL+aResult[0].MOTDIM+aResult[0].PAKZUS+aResult[0].PAKLGE+aResult[0].POLZAHL+aResult[0].HEMOTOR+aResult[0].VSDMOTOR),"-","");
        }
        
        strSelectTest=strSelectTest+"MOT_BZ_LANG = '"+strMOTBEZ+"' AND ";
        
        
        var strMOTBART="";
        
        if(ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
        {
            if(aResult[0].strFrequency == "50"){
                strMOTBART = aResult[0].MOTBART11;
            }
            else if(aResult[0].strFrequency == "60")
            {
                if(aResult[0].MOTBART12 == "-"){
                    strMOTBART = aResult[0].MOTBART11;
                }
                else{
                    strMOTBART = aResult[0].MOTBART12;
                }
            }
            else if(aResult[0].strFrequency == "87"){
                strMOTBART = aResult[0].MOTBART11;
            }
        }
        else if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
		{
			strMOTBART = 'INV.DUTY';
        }
        else
        {
            if(aResult[0].strFrequency == "50"){
                strMOTBART = aResult[0].MOTBART11;
            }
            else if(aResult[0].strFrequency == "60")
            {
                if(aResult[0].MOTBART12 == "-"){
                    strMOTBART = aResult[0].MOTBART11;
                }
                else{
                    strMOTBART = aResult[0].MOTBART12;
                }
            }
            else if(aResult[0].strFrequency == "87"){
                strMOTBART = aResult[0].MOTBART21;
            }
            else if(aResult[0].strFrequency == "104"){
                strMOTBART = aResult[0].MOTBART22;
            }
        }
        
        strSelectTest=strSelectTest+"MOT_BETRIEBSART_KEY = '"+strMOTBART+"' AND ";
        
        
        var P50_P1="";
        var P60_P1="";        
        var P87_P1="";	
		var P104_P1="";
		if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
		{
			if(strFrequency == "50")
			{
				P50_P1 = aResult[0].LEISTUNG1;
			}
			else if(strFrequency == "60")
			{
				P60_P1 = aResult[0].LEISTUNG4;
			}
			else if(strFrequency == "87")
			{
				P87_P1 = aResult[0].LEISTUNG1;
			}
			else if(strFrequency == "104")
			{
				P104_P1 = aResult[0].LEISTUNG4;
			}
		}
		else
		{
			if(aResult[0].FREQUENZ_1=="50"){
				P50_P1 = aResult[0].LEISTUNG1;
            }
            
			if(aResult[0].FREQUENZ_1=="60")
			{
				P60_P1 = aResult[0].LEISTUNG1;
			}
			else if(aResult[0].FREQUENZ_2=="60")
			{
				P60_P1 = aResult[0].LEISTUNG4;
			}
			
			if(aResult[0].FREQUENZ_1=="87")
			{
				P87_P1 = aResult[0].LEISTUNG1;
			}
			else if(aResult[0].FREQUENZ_2=="87")
			{
				P87_P1 = aResult[0].LEISTUNG4;
			}
			else if(aResult[0].FREQUENZ2_1=="87")
			{
				P87_P1 = aResult[0].LEISTUNG21;
			}
			else if(aResult[0].FREQUENZ2_2=="87")
			{
				P87_P1 = aResult[0].LEISTUNG24;
			}
			
			if(aResult[0].FREQUENZ_1=="104")
			{
				P104_P1 = aResult[0].LEISTUNG1;
			}
			else if(aResult[0].FREQUENZ_2=="104")
			{
				P104_P1 = aResult[0].LEISTUNG4;
			}
			else if(aResult[0].FREQUENZ2_1=="104")
			{
				P104_P1 = aResult[0].LEISTUNG21;
			}
			else if(aResult[0].FREQUENZ2_2=="104")
			{
				P104_P1 = aResult[0].LEISTUNG24;
			}
		}
		
		
        var BDRHZAHL_50_P1, BDRHZAHL_60_P1, BDRHZAHL_87_P1, BDRHZAHL_104_P1;
        // filter them according to the current motor frequency and poles
        var DatenArray = [
            BDRHZAHL_50_P1,
            BDRHZAHL_60_P1,
            BDRHZAHL_87_P1,
            BDRHZAHL_104_P1,
            P50_P1,
            P60_P1,
            P87_P1,
            P104_P1
        ];
        
        var oMotoxTest = {
            ECSI_FREQUENZ_VORAUSWAHL: aResult[0].strFrequency
        };
        var ErgArray = Bestimme_LeistungDrehzahl_Motor(oMotoxTest,DatenArray);
        var dDBPower = parseFloat(ErgArray[4]);
    
        strSelectTest=strSelectTest+"MOT_LEISTUNG = '"+dDBPower+"' AND ";
        strSelectTest=strSelectTest+"MLFB_13_KA = '"+aResult[0].MLFB_2KJ_13_KA+"' AND ";
        strSelectTest=strSelectTest+"MOT_BETRIEBSART = '"+aResult[0].MLFB_2KJ_BART_KA+"' ";
        
        var aResult2 = Object.fromDatabase( '2KJ_DB', strSelectTest );
        if(aResult2.length>0)
        {
            aResult[0].EFFIZIENZKL_TMP_MOT_DATEN=aResult2[0].MOT_EFFIZIENZKL_KNZ;
            aResult[0].MOT_SCHALTUNG_TMP_MOT_DATEN=aResult2[0].MOT_SCHALTUNG;
            return( aResult[0] );
            
        }
        else
        {
            
            var strSelect = strBaseSelect;
    
            strSelect += " ORDER BY MOTWK ASC,SAP_DOK_STATUS DESC,SAP_DOK_STATUS2 DESC,LEISTUNG24 DESC "; //Hack wegen fehlender H Motoren in der DTK Datenbank
        
            var aResult = Object.fromDatabase( '2KJ_DB', strSelect );
            if ( aResult.length > 0 )
            {
                aResult[0].SpecString=strSpecString;
                aResult[0].strFrequency = strFrequency;
                
                var strSelectTest="";
                strSelectTest="SELECT * FROM TMP_MOT_DATEN WHERE ";
                strSelectTest=strSelectTest+"MOT_EL_AUSFUEHRUNG = '"+aResult[0].MOTELAUSF+"' AND ";
                strSelectTest=strSelectTest+"MOT_POLZAHL = '"+aResult[0].POLZAHL+"' AND ";
                strSelectTest=strSelectTest+"MOT_FREQUENZ = '"+strFrequency+"' AND ";
                
                var strEFFKlasse="";
                if(aResult[0].strFrequency=="50")
                {
                    strEFFKlasse = aResult[0].EFFKLASSE_1;	
                }
                else if(aResult[0].strFrequency=="60")
                {
                    if(aResult[0].FREQUENZ_1=="60")
                        strEFFKlasse = aResult[0].EFFKLASSE_1;	
                    else if(aResult[0].FREQUENZ_2=="60")
                        strEFFKlasse = aResult[0].EFFKLASSE_2;	
                }
                else if(aResult[0].strFrequency=="87")
                {
                    if(aResult[0].FREQUENZ_2=="87")
                        strEFFKlasse = aResult[0].EFFKLASSE_2;	
                    else if(aResult[0].FREQUENZ2_1=="87")
                        strEFFKlasse = aResult[0].EFFKLASSE2_1;	
                    else if(aResult[0].FREQUENZ2_2=="87")
                        strEFFKlasse = aResult[0].EFFKLASSE2_2;	
                }
                else if(aResult[0].strFrequency=="104")
                {
                    if(aResult[0].FREQUENZ2_1=="104")
                        strEFFKlasse = aResult[0].EFFKLASSE2_1;	
                    else if(aResult[0].FREQUENZ2_2=="104")
                        strEFFKlasse = aResult[0].EFFKLASSE2_2;	
                }
            
                strSelectTest=strSelectTest+"MOT_EFFIZIENZKL_KNZ = '"+strEFFKlasse.left(3)+"' AND ";
                
                var strMOTBEZ="";
                if(oGearType.ANWTYP=="KleinSchnecke")
                    strMOTBEZ = replace((aResult[0].MOTTYP+aResult[0].MOEINKL+"I"+aResult[0].MOTDIM+aResult[0].PAKZUS+aResult[0].PAKLGE+aResult[0].POLZAHL+aResult[0].HEMOTOR+aResult[0].VSDMOTOR),"-","");
                else
                    strMOTBEZ = replace((aResult[0].MOTTYP+aResult[0].MOEINKL+aResult[0].MOTDIM+aResult[0].PAKZUS+aResult[0].PAKLGE+aResult[0].POLZAHL+aResult[0].HEMOTOR+aResult[0].VSDMOTOR),"-","");

                strSelectTest=strSelectTest+"MOT_BZ_LANG = '"+strMOTBEZ+"' AND ";
                
                
                var strMOTBART="";
                if(aResult[0].strFrequency == "50")
                    strMOTBART = aResult[0].MOTBART11;
                else if(aResult[0].strFrequency == "60")
                {
                    if(aResult[0].MOTBART12 == "-")
                        strMOTBART = aResult[0].MOTBART11;
                    else
                        strMOTBART = aResult[0].MOTBART12;
                }
                else if(aResult[0].strFrequency == "87")
                    strMOTBART = aResult[0].MOTBART21;
                else if(aResult[0].strFrequency == "104")
                    strMOTBART = aResult[0].MOTBART22;
                
                strSelectTest=strSelectTest+"MOT_BETRIEBSART_KEY = '"+strMOTBART+"' AND ";
                
                
                var P50_P1="";
                if(aResult[0].FREQUENZ_1=="50")
                    P50_P1 = aResult[0].LEISTUNG1;
                
                var P60_P1="";
                if(aResult[0].FREQUENZ_1=="60")
                {
                    P60_P1 = aResult[0].LEISTUNG1;
                }
                else if(aResult[0].FREQUENZ_2=="60")
                {
                    P60_P1 = aResult[0].LEISTUNG4;
                }
                
                var P87_P1="";
                if(aResult[0].FREQUENZ_1=="87")
                {
                    P87_P1 = aResult[0].LEISTUNG1;
                }
                else if(aResult[0].FREQUENZ_2=="87")
                {
                    P87_P1 = aResult[0].LEISTUNG4;
                }
                else if(aResult[0].FREQUENZ2_1=="87")
                {
                    P87_P1 = aResult[0].LEISTUNG21;
                }
                else if(aResult[0].FREQUENZ2_2=="87")
                {
                    P87_P1 = aResult[0].LEISTUNG24;
                }
                
                var P104_P1="";
                if(aResult[0].FREQUENZ_1=="104")
                {
                    P104_P1 = aResult[0].LEISTUNG1;
                }
                else if(aResult[0].FREQUENZ_2=="104")
                {
                    P104_P1 = aResult[0].LEISTUNG4;
                }
                else if(aResult[0].FREQUENZ2_1=="104")
                {
                    P104_P1 = aResult[0].LEISTUNG21;
                }
                else if(aResult[0].FREQUENZ2_2=="104")
                {
                    P104_P1 = aResult[0].LEISTUNG24;
                }
                
                var BDRHZAHL_50_P1, BDRHZAHL_60_P1, BDRHZAHL_87_P1, BDRHZAHL_104_P1;
                // filter them according to the current motor frequency and poles
                var DatenArray = [
                    BDRHZAHL_50_P1,
                    BDRHZAHL_60_P1,
                    BDRHZAHL_87_P1,
                    BDRHZAHL_104_P1,
                    P50_P1,
                    P60_P1,
                    P87_P1,
                    P104_P1
                ];
                
                var oMotoxTest = {
                    ECSI_FREQUENZ_VORAUSWAHL: aResult[0].strFrequency
                };
                var ErgArray = Bestimme_LeistungDrehzahl_Motor(oMotoxTest,DatenArray);
                var dDBPower = parseFloat(ErgArray[4]);
            
                strSelectTest=strSelectTest+"MOT_LEISTUNG = '"+dDBPower+"' AND ";
                strSelectTest=strSelectTest+"MLFB_13_KA = '"+aResult[0].MLFB_2KJ_13_KA+"' AND ";
                strSelectTest=strSelectTest+"MOT_BETRIEBSART = '"+aResult[0].MLFB_2KJ_BART_KA+"' ";
    
                var aResult2 = Object.fromDatabase( '2KJ_DB', strSelectTest );
                if(aResult2.length>0)
                {
                    aResult[0].EFFIZIENZKL_TMP_MOT_DATEN=aResult2[0].MOT_EFFIZIENZKL_KNZ;
                    aResult[0].MOT_SCHALTUNG_TMP_MOT_DATEN=aResult2[0].MOT_SCHALTUNG;
                    return( aResult[0] );
                }
                else
                {
                    //Motorsuche in Tiegel Tabellen fehlgeschlagen
                    logtraceln("*************************************************");
                    logtraceln("Motorsuche in Tiegel Tabellen fehlgeschlagen");
                    logtraceln("Motor-MLFB:"+strMotorMLFB);
                    logtraceln("Frequenz:"+aResult[0].strFrequency);
                    logtraceln("Leistung:"+dDBPower);
                    logtraceln("MLFB_13_KA:"+aResult[0].MLFB_2KJ_13_KA);
                    logtraceln("MOT_BETRIEBSART:"+aResult[0].MLFB_2KJ_BART_KA);
                    logtraceln("Motorbezeichung:"+strMOTBEZ);
                    logtraceln("Effizienzklasse:"+strEFFKlasse);
                    logtraceln("*************************************************");
                    
                    return( null );
                }
            }
            else
            {
                //Motorsuche in Tiegel Tabellen fehlgeschlagen
                logtraceln("*************************************************");
                logtraceln("Motorsuche in Tiegel Tabellen fehlgeschlagen");
                logtraceln("Motor-MLFB:"+strMotorMLFB);
                logtraceln("Frequenz:"+aResult[0].strFrequency);
                logtraceln("Leistung:"+dDBPower);
                logtraceln("MLFB_13_KA:"+aResult[0].MLFB_2KJ_13_KA);
                logtraceln("MOT_BETRIEBSART:"+aResult[0].MLFB_2KJ_BART_KA);
                logtraceln("Motorbezeichung:"+strMOTBEZ);
                logtraceln("Effizienzklasse:"+strEFFKlasse);
                logtraceln("*************************************************");
            return( null );
            }
        }
        
    }
    else
        return( null );
}

function checkBaubarkeitAdapter( oResult, oAntriebsgruppe, strRegion )
{
    // TEST: 2KJ3102-1FA09-0AC1-Z D01+K06+L00+M2A
    //  2KJ3102.......C1
     //Überprüfung ob Motor und Getriebe mit Übersetzung zusammenpasst
    
     
     var strAV_TYPBEZ = oAntriebsgruppe.AV_TYP_KZ;
     if( oAntriebsgruppe.AV_RLSP == "1")
     {
        strAV_TYPBEZ=strAV_TYPBEZ+"X";
     }
    
     var strSelect = "";
     strSelect = "SELECT DISTINCT * FROM KONFIG_UNDEF2 WHERE ";
     strSelect += "EGBEZTYP='" + oResult.oParsingData.oGearType.EGBEZTYP + "' AND ";
     strSelect += "EGBEZUEBS='" + oResult.oParsingData.oGearType.EGBEZUEBS + "' AND ";
     strSelect += "EGBEZBRA='" + oResult.oParsingData.oGearType.EGBEZBRA + "' AND ";
     strSelect += "EGBEZDIM='" + oResult.oParsingData.oGearType.EGBEZDIM + "' AND ";
     strSelect += "EGBEZEI='" + oResult.oParsingData.oGearType.EGBEZEI + "' AND ";
     strSelect += "ZGBEZUEBS='" + oResult.oParsingData.oGearType.ZGBEZUEBS + "' AND ";
     strSelect += "ZGBEZDIM='" + oResult.oParsingData.oGearType.ZGBEZDIM + "' AND ";
     strSelect += "ZGBEZEI='" + oResult.oParsingData.oGearType.ZGBEZEI + "' AND ";
     strSelect += "AV_TYPBEZ='" + strAV_TYPBEZ + "' AND ";
     strSelect += "MOTDIM='" + oAntriebsgruppe.AVTYPDIM + "' AND ";

     strSelect += "REGION ='SCAE' and SOTEC ='-' AND AKTIV='1' ";
 
     var strDBName = "2KJ_DB"; 
     var strDBResult = "CHECKADAPTERBAUBARKEIT";
     
     if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
     {
        //Baubarkeit Adapter-Getriebe fehlgeschlagen
       
        logtraceln("*************************************************");
        logtraceln("Baubarkeit Getiebe-Adapter fehlgeschlagen");
        logtraceln("Getriebe:"+oResult.oParsingData.oGearType.EGTYP);
        logtraceln("Übersetzung:"+oResult.oParsingData.oRatio.EGUEB);
        logtraceln("Adapterbezeichung:"+strAV_TYPBEZ);
        logtraceln("*************************************************");
        
        return (false);
     }
     else
     {
         return (true);
     }
}

function checkAntriebsgruppe( strMotorMLFB, strVoltageSD, oGearType, oShortDescriptions, strRegion, oRatio )
{
    /*
    Stelle 9: Baugröße des Adapters
    Stelle 10: Kenner für die Zolltarifnummer. Bei Getriebe ohne Motor ist das immer A (Stelle 11 = 0).
    Stelle 11: Bei Getriebe ohne Motor immer die 0. Die 8 benötigen wir später für den angebauten Motor.
    Stelle 12 definiert den Adaptertyp.
    Der Vollständigkeit halber: Stelle 13 ist immer 0, wir haben ja keine Spannung
    */
    
    var c9 = strMotorMLFB.charAt( 0 );		
    var c10 = strMotorMLFB.charAt( 1 );		
    var c11 = strMotorMLFB.charAt( 2 );		
    var c12 = strMotorMLFB.charAt( 3 );		
    var c13 = strMotorMLFB.charAt( 4 );	
    
    //Neuerung, Stellen 9 bis 12 kommen nicht mehr aus SIZER, nur noch "."
    
    var strStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    if(strStartConfiguration=="" && find(strMotorMLFB, ".") >= 0)
        strStartConfiguration="1" ;
    
    if(c9 == "." && c10 == "." && c11 == "." && c12 == "." && strStartConfiguration=="1")
    {
        //Wir nehmen den Default Adapter aus dem Context
        
        var strDefaultAdapter = ECL_GetValue("ECSI_CX_DefaultGearboxAdapter");
        
        if(!strDefaultAdapter)
            return( null );
            
        //Jetzt aus dem String die Stelle 9 bis 12 extrahieren
        // Beispiel 2KJ3....FA02....
        c9 = strDefaultAdapter.charAt( 8 );		
        c10 = strDefaultAdapter.charAt( 9 );		
        c11 = strDefaultAdapter.charAt( 10 );		
        c12 = strDefaultAdapter.charAt( 11 );		
        c13 = "0";

        // set default value for KU Options
        var strECSI_CX_DefaultGearboxAdapter_SD = "";
        if (strDefaultAdapter.length > 16) {
            strECSI_CX_DefaultGearboxAdapter_SD = strDefaultAdapter.substring(16, strDefaultAdapter.length);
        }

        var bA35 = false;
        var bA36 = false;

        if (strECSI_CX_DefaultGearboxAdapter_SD != "") {
            if (strECSI_CX_DefaultGearboxAdapter_SD.search("A35") != -1) {
                bA35 = true;
            }
            if (strECSI_CX_DefaultGearboxAdapter_SD.search("A36") != -1) {
                bA36 = true;
            }
        }

        if (bA35) {
            ECL_SelectValue("ANTRIEBSGRUPPE_DICHTUNG", "FKM");
        }
        else if (bA36) {
            ECL_SelectValue("ANTRIEBSGRUPPE_DICHTUNG", "MSS1-HS");
        }
        else {
            ECL_SelectValue("ANTRIEBSGRUPPE_DICHTUNG", "-");
        }

        var bA30 = false;

        if (strECSI_CX_DefaultGearboxAdapter_SD != "") {
            if (strECSI_CX_DefaultGearboxAdapter_SD.search("A30") != -1) {
                bA30 = true;
            }
        }

        if (bA30) {
            ECL_SelectValue("ANTRIEBSGRUPPE_LAGERUNG", "Zylinderrollenlager");
        }
        else {
            ECL_SelectValue("ANTRIEBSGRUPPE_LAGERUNG", "-");
        }
    }
    
    var strMLFB_AVTYP = "MLFB_AVTYP";
    if(strRegion == "CHINA")
        strMLFB_AVTYP = "MLFB4_AVTYP";
    
    var strBaseSelect = "SELECT * FROM CD_AVEINHEITEN,"+strMLFB_AVTYP+",CD_GETRIEBE, CD_GETRIEBE_BEZEICHNUNGEN WHERE " + 
                        " MLFB_2KJ_9 = '" + c9 + 
                        "' AND MLFB_2KJ_10 = '" + c10 + 
                        "' AND MLFB_2KJ_11 = '" + c11 + 
                        "' AND MLFB_2KJ_12 = '" + c12 + "' ";
    if ( 'A08' in oShortDescriptions )
    {
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_OPTION = 'A08' ";
    }
    else
    {
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_OPTION = '-' ";
    }
    
    if ( 'M1A' in oShortDescriptions )
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_2KJ_12_KA = 'M1A' ";
    else if ( 'M1B' in oShortDescriptions )
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_2KJ_12_KA = 'M1B' ";
    
    
    strBaseSelect += " AND LKB = '-' ";
    strBaseSelect += " AND CD_AVEINHEITEN.AVTYPDIM = "+strMLFB_AVTYP+".AVTYPDIM ";
    strBaseSelect += " AND CD_AVEINHEITEN.AV_TYP_KZ = "+strMLFB_AVTYP+".AVMLFBTYP ";
    
    if ( 'A17' in oShortDescriptions )
        strBaseSelect += " AND CD_AVEINHEITEN.KUEINHEIT = 'Rutschkupplung' ";
    else
        strBaseSelect += " AND CD_AVEINHEITEN.KUEINHEIT <> 'Rutschkupplung' ";
    
    if ( 'A15' in oShortDescriptions )
        strBaseSelect += " AND CD_AVEINHEITEN.AV_RLSP = '1' ";
    else
        strBaseSelect += " AND CD_AVEINHEITEN.AV_RLSP = '0' ";
        
    if ( 'G99' in oShortDescriptions )
        strBaseSelect += " AND CD_GETRIEBE_BEZEICHNUNGEN.EGBEZSO = 'W' ";
    else
        strBaseSelect += " AND CD_GETRIEBE_BEZEICHNUNGEN.EGBEZSO = '-' ";
    
    strBaseSelect += " AND CD_GETRIEBE.EGBEZTYP = '"+oGearType.EGBEZTYP+"' ";
    strBaseSelect += " AND CD_GETRIEBE.EGBEZUEBS = '"+oGearType.EGBEZUEBS+"' ";
    strBaseSelect += " AND CD_GETRIEBE.EGBEZDIM = '"+oGearType.EGBEZDIM+"' ";
    strBaseSelect += " AND CD_GETRIEBE.EGBEZEI = '"+oGearType.EGBEZEI+"' ";
    strBaseSelect += " AND CD_GETRIEBE.ZGBEZUEBS = '"+oGearType.ZGBEZUEBS+"' ";
    strBaseSelect += " AND CD_GETRIEBE.ZGBEZDIM = '"+oGearType.ZGBEZDIM+"' ";
    strBaseSelect += " AND CD_GETRIEBE.ZGBEZEI = '"+oGearType.ZGBEZEI+"' ";
    strBaseSelect += " AND CD_GETRIEBE.EGUEB = '"+oRatio.EGUEB+"' ";
    
    strBaseSelect += " AND CD_GETRIEBE.AVMOKDBEZ = CD_AVEINHEITEN.MAVABKD ";
    strBaseSelect += " AND CD_GETRIEBE.GETRIEBE_BEZ = CD_GETRIEBE_BEZEICHNUNGEN.GETRIEBE_BEZ ";
    strBaseSelect += " AND CD_AVEINHEITEN.AVABFLD = CD_GETRIEBE_BEZEICHNUNGEN.EGANFLDM ";
    strBaseSelect += " AND CD_AVEINHEITEN.AVABSSAR = CD_GETRIEBE_BEZEICHNUNGEN.EGANSSART ";
    strBaseSelect += " AND CD_AVEINHEITEN.BRANCHE = '"+oGearType.ANWTYP+"' ";
    
    var aResult = Object.fromDatabase( '2KJ_DB', strBaseSelect );
    if ( aResult.length > 0 )
    {
        var strPolzahl=ECL_GetValue("ECSI_CX_MotorPoleCount");
        
        if(strPolzahl=="")
        {
            if ( 'P20' in oShortDescriptions )
                strPolzahl="2";
            else
                strPolzahl="4";
                
            ECL_SetValue("ECSI_CX_MotorPoleCount",strPolzahl);
        }
        
        var strAVTYP = aResult[0].AV_TYP_KZ;
        var iAVDIM = parseInt(aResult[0].AV_GROESSE_KZ);
        
        //K4 Laterne geht mit Polzahl 2 nur bis BG 200
        if(strPolzahl=="2" && (strAVTYP=="K4" && iAVDIM >=225) )
            return( null );
        else
            return( aResult[0] );
    }
    
    return( null );
}

function checkSpannungMotorsteckerFktglr(oDlg,oMOTOX,oMOTOXHandler,strRegion)
{
    var strDBName = "2KJ_DB";
    var aSpannung = [];
    var strSpannung;
    var strFrequenz;
    var strWIBLAUSLG_DUMMY;
    var strMotorschaltung;
    
    var strDBResult = "SPANNUNG_CHECK";
    
    var strMotorstecker = oMOTOX.oConfig.strMotorConnector;
    
    if(strMotorstecker == "M" || strMotorstecker == "NPT")
    {
        if(parseInt(oMOTOX.GearData.MOTDIM) > 160)
            strMotorstecker = "GG";
        else
            strMotorstecker = "Aluminium";
    }
    
    var MMSystem = oMOTOX.MMSystem;
    var strMotortabelle = Controller.Dlg.Motox.BaseFunctions.getSQLStatementforRegionParser(strRegion);
    
    var strSelect = "SELECT DISTINCT "+strMotortabelle+".MLFB_2KJ_13,"+strMotortabelle+".MLFB_2KJ_13_KA,"+strMotortabelle+".MLFB_2KJ_13_SPGTOL,CD_SPANNUNGEN_AUSGABE.MOTSPG,CD_SPANNUNGEN_AUSGABE.FREQUENZ,CD_SPANNUNGEN_AUSGABE.FREQUENZ_TOL,"+strMotortabelle+".SCHALTUNG_S,CD_SPANNUNGEN_AUSGABE.WIBLAUSLG_DUMMY,"+strMotortabelle+".WARMEKL FROM "+strMotortabelle+",CD_SPANNUNGEN_AUSGABE,EKAT_WIBLAUSLG_FUER_SPANNUNG WHERE ";
    
    strSelect = strSelect + "MOTELAUSF_AUSG = '"+oMOTOX.strSpecification+"' AND ";
    
    
    if(oMOTOX.strFrequency == "50")
    {	
        if(oMOTOXHandler.strProduct == "GETRIEBEMOTOR.G110M" || oMOTOXHandler.strProduct == "GETRIEBEMOTOR.G110M_SIP" || oMOTOXHandler.strProduct == "SIZER.G110M" || ((oMOTOXHandler.strProduct == 'ARCHIMEDES') && oMOTOXHandler.getDriveConfigurationHandler().bG110M))
        {
            strSelect += "("+strMotortabelle+".FREQUENZ = '50') AND ";
        }
        else
        {
            strSelect += "("+strMotortabelle+".FREQUENZ = '50' OR "+strMotortabelle+".FREQUENZ = '50 // 60' OR "+strMotortabelle+".FREQUENZ = '50 // 87') AND ";
        }
        
        if(oMOTOX.strEfficiencyClass == "IE1")
            strSelect += "(IE1_OHNE_BEM = '1' OR IE1_OHNE_NETZ_50 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE2")
            strSelect += "(IE2_BEM = '1' OR IE2_NETZ_50 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE3")
            strSelect += "(IE3_BEM = '1' OR IE3_NETZ_50 = '1') AND ";
    }
    else if(oMOTOX.strFrequency == "60" || oMOTOX.strFrequency == "60_L50")
    {
        strSelect += "("+strMotortabelle+".FREQUENZ = '60' OR "+strMotortabelle+".FREQUENZ = '50 // 60') AND ";
        if(oMOTOX.strEfficiencyClass == "IE1")
            strSelect += "(IE1_OHNE_BEM = '1' OR IE1_OHNE_NETZ_60 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE2")
            strSelect += "(IE2_BEM = '1' OR IE2_NETZ_60 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE3")
            strSelect += "(IE3_BEM = '1' OR IE3_NETZ_60 = '1') AND ";
    }
    else if(oMOTOX.strFrequency == "87")
    {
        strSelect += "("+strMotortabelle+".FREQUENZ = '87' OR "+strMotortabelle+".FREQUENZ = '50 // 87') AND ";
        if(oMOTOX.strEfficiencyClass == "IE1")
            strSelect += "(IE1_OHNE_BEM = '1' OR IE1_OHNE_NETZ_87 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE2")
            strSelect += "(IE2_BEM = '1' OR IE2_NETZ_87 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE3")
            strSelect += "(IE3_BEM = '1' OR IE3_NETZ_87 = '1') AND ";
    }
    
    strSelect += strMotortabelle+".POLZAHL = '"+oMOTOX.strPoles+"' AND ";
    strSelect += strMotortabelle+".MOTDIM = '"+oMOTOX.GearData.MOTDIM+"' AND ";
    
    if(oMOTOX.oConfig.bWithBrake)
        strSelect = strSelect + "(BRE_KENNER='1' OR BRE_KENNER='2') AND "
    else
        strSelect = strSelect + "(BRE_KENNER='0' OR BRE_KENNER='2') AND "
    
    if(MMSystem == "SI")
    {
        if(oMOTOX.strFrequency == "50")
        {	
            strSelect = strSelect +  "P50_P1 = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
        else if(oMOTOX.strFrequency == "60" || oMOTOX.strFrequency == "60_L50")
        {
            strSelect = strSelect +  "P60_P1 = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
        else if(oMOTOX.strFrequency == "87")
        {
            strSelect = strSelect +  "P87_P1 = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
    }
    else if(MMSystem == "US")
    {
        if(oMOTOX.strFrequency == "50")
        {	
            strSelect = strSelect +  "P50_P1_IMP = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
        else if(oMOTOX.strFrequency == "60" || oMOTOX.strFrequency == "60_L50")
        {
            strSelect = strSelect +  "P60_P1_IMP = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
        else if(oMOTOX.strFrequency == "87")
        {
            strSelect = strSelect +  "P87_P1_IMP = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
    }
    
    strSelect += strMotortabelle+".WIBLAUSLG_DUMMY = CD_SPANNUNGEN_AUSGABE.WIBLAUSLG_DUMMY AND ";
    strSelect += strMotortabelle+".ATEX = '0' AND ";
    strSelect += strMotortabelle+".SUCHTYP = '"+oMOTOX.GearData.MOTBEZ+"' AND ";
    
    if(oMOTOX.oConfig.strBrakeFunctionRectifier == "ohne")
        strSelect = strSelect + "EKAT_WIBLAUSLG_FUER_SPANNUNG.FKTGLR_KNZ = '0' AND ";
    else
        strSelect = strSelect + "EKAT_WIBLAUSLG_FUER_SPANNUNG.FKTGLR_KNZ = '1' AND ";
    
    strSelect = strSelect + "EKAT_WIBLAUSLG_FUER_SPANNUNG.WIBLAUSLG_DUMMY = CD_SPANNUNGEN_AUSGABE.WIBLAUSLG_DUMMY "
    
    if(oMOTOX.strFrequency == "50")
        strSelect = strSelect + "AND FAKTOR_LEISTUNG_50 = 'P(50)' ";
    else if(oMOTOX.strFrequency == "60")
        strSelect = strSelect + "AND FAKTOR_LEISTUNG_60 = '1,2xP(50)' ";
    else if(oMOTOX.strFrequency == "60_L50")
        strSelect = strSelect + "AND FAKTOR_LEISTUNG_60 = 'P(50)' ";
    else if(oMOTOX.strFrequency == "87")
        strSelect = strSelect + "AND FAKTOR_LEISTUNG_87 = 'P(87)' ";
        
    strSelect = strSelect + "AND "+strMotortabelle+".BETR_ART_P1 = '"+oDlg.strOperatingMode+"' ";
    
    if(oMOTOX.BrakeData.BRESHLT != "")
        strSelect = strSelect + "AND "+strMotortabelle+".BRESHLT = '"+oMOTOX.BrakeData.BRESHLT+"' ";
        
    strSelect = strSelect + "AND "+strMotortabelle+".WARMEKL = '"+oDlg.strWindingTemperatureClass+"' ";	
    strSelect = strSelect + "AND EKAT_WIBLAUSLG_FUER_SPANNUNG.KKMAT = '"+strMotorstecker+"' ";
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        logtraceln("Spannung Parser OK! SQL="+strSelect);
        return (true);
    }
    else
    {
        logtraceln("Spannung Parser ERROR! SQL="+strSelect);
        return(false);
    }
    
}

function checkMotorGetriebeBaubarkeit( oResult, strRegion )
{
    //Überprüfung ob Motor und Getriebe mit Übersetzung zusammenpasst
    var strMotortabelle = "CD_MOTOREN_ANBAU";
    
    var strSelect = "";
    strSelect = "SELECT DISTINCT * ";
    strSelect = strSelect + "FROM CD_GETRIEBE,"+strMotortabelle+",CD_GETRIEBE_BEZEICHNUNGEN WHERE ";
    strSelect = strSelect + "CD_GETRIEBE.AVMOKDBEZ = "+strMotortabelle+".MOABKDBEZ AND ";	
    strSelect = strSelect + "CD_GETRIEBE.GETRIEBE_BEZ = CD_GETRIEBE_BEZEICHNUNGEN.GETRIEBE_BEZ AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGANSSART = "+strMotortabelle+".MOABSSAR AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGANFLDM = "+strMotortabelle+".MOABFLDM AND ";
    strSelect = strSelect + strMotortabelle+".MOTDIM='"+oResult.oParsingData.oMotor.MOTDIM+"' AND ";
    strSelect = strSelect + strMotortabelle+".MOTTYP='"+oResult.oParsingData.oMotor.MOTTYP+"' AND ";
    
    
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZTYP = '"+oResult.oParsingData.oGearType.EGBEZTYP+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZUEBS = '"+oResult.oParsingData.oGearType.EGBEZUEBS+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZBRA = '"+oResult.oParsingData.oGearType.EGBEZBRA+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZDIM = '"+oResult.oParsingData.oGearType.EGBEZDIM+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZEI = '"+oResult.oParsingData.oGearType.EGBEZEI+"' AND ";
    
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.ZGBEZUEBS = '"+oResult.oParsingData.oGearType.ZGBEZUEBS+"' AND ";
	strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.ZGBEZDIM = '"+oResult.oParsingData.oGearType.ZGBEZDIM+"' AND ";
	strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.ZGBEZEI = '"+oResult.oParsingData.oGearType.ZGBEZEI+"' AND ";

    strSelect = strSelect + "CD_GETRIEBE.EGBEZTYP = '"+oResult.oParsingData.oGearType.EGBEZTYP+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE.EGBEZUEBS = '"+oResult.oParsingData.oGearType.EGBEZUEBS+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE.EGBEZBRA = '"+oResult.oParsingData.oGearType.EGBEZBRA+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE.EGBEZDIM = '"+oResult.oParsingData.oGearType.EGBEZDIM+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE.EGBEZEI = '"+oResult.oParsingData.oGearType.EGBEZEI+"' AND ";
    
    strSelect = strSelect + "CD_GETRIEBE.ZGBEZUEBS = '"+oResult.oParsingData.oGearType.ZGBEZUEBS+"' AND ";
	strSelect = strSelect + "CD_GETRIEBE.ZGBEZDIM = '"+oResult.oParsingData.oGearType.ZGBEZDIM+"' AND ";
	strSelect = strSelect + "CD_GETRIEBE.ZGBEZEI = '"+oResult.oParsingData.oGearType.ZGBEZEI+"' AND ";
	
	strSelect = strSelect + "CD_GETRIEBE.EGUEB = '"+oResult.oParsingData.oRatio.EGUEB+"' AND ";
	strSelect = strSelect + "CD_GETRIEBE.ZGUEB = '"+oResult.oParsingData.oRatio.ZGUEB+"' ";
	
    //bestimmte Getriebemotoren rauswerfen!
    strRegionAbfrage = " WHERE (REGION = 'S' OR REGION = 'SC') ";
        
    strSelect = strSelect + "AND CD_GETRIEBE.EGBEZTYP||CD_GETRIEBE.EGBEZUEBS||CD_GETRIEBE.EGBEZBRA||CD_GETRIEBE.EGBEZDIM||CD_GETRIEBE.EGBEZEI||CD_GETRIEBE.ZGBEZUEBS||CD_GETRIEBE.ZGBEZDIM||CD_GETRIEBE.ZGBEZEI||'LE'||"+strMotortabelle+".MOTDIM NOT IN (";
	strSelect = strSelect + "SELECT EGBEZTYP||EGBEZUEBS||EGBEZBRA||EGBEZDIM||EGBEZEI||ZGBEZUEBS||ZGBEZDIM||ZGBEZEI||MOTTYP||MOTDIM FROM KONFIG_UNDEF2 "+strRegionAbfrage+") ";
    
    strSelect = strSelect + "AND CD_GETRIEBE_BEZEICHNUNGEN.REGION = 'EUR' ";
    strSelect = strSelect + "AND CD_GETRIEBE.REGION = 'EUR' ";

    var strDBName = "2KJ_DB"; 
    var strDBResult = "CHECKGEARMOTOR";
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        if(oResult.oParsingData.oGearType.EGBEZBRA == "K" && (oResult.oParsingData.oMotor.MOTDIM=="225" || oResult.oParsingData.oMotor.MOTDIM=="250") && oResult.oParsingData.oMotor.SpecString.indexOf("UL-R/CSA")>-1)
            return false;
        
        return (true);
    }
    else
    {
        //Baubarkeit Motor-Getriebe fehlgeschlagen
        var strMOTBEZ="";
        if(oResult.oParsingData.oGearType.ANWTYP=="KleinSchnecke")
            strMOTBEZ = replace((oResult.oParsingData.oMotor.MOTTYP+oResult.oParsingData.oMotor.MOEINKL+"I"+oResult.oParsingData.oMotor.MOTDIM+oResult.oParsingData.oMotor.PAKZUS+oResult.oParsingData.oMotor.PAKLGE+oResult.oParsingData.oMotor.POLZAHL+oResult.oParsingData.oMotor.HEMOTOR+oResult.oParsingData.oMotor.VSDMOTOR),"-","");
        else
            strMOTBEZ = replace((oResult.oParsingData.oMotor.MOTTYP+oResult.oParsingData.oMotor.MOEINKL+oResult.oParsingData.oMotor.MOTDIM+oResult.oParsingData.oMotor.PAKZUS+oResult.oParsingData.oMotor.PAKLGE+oResult.oParsingData.oMotor.POLZAHL+oResult.oParsingData.oMotor.HEMOTOR+oResult.oParsingData.oMotor.VSDMOTOR),"-","");

        logtraceln("*************************************************");
        logtraceln("Baubarkeit Motor-Getriebe fehlgeschlagen");
        logtraceln("Getriebe:"+oResult.oParsingData.oGearType.EGTYP);
        logtraceln("Übersetzung:"+oResult.oParsingData.oRatio.EGUEB);
        logtraceln("Motorbezeichung:"+strMOTBEZ);
        logtraceln("*************************************************");
        
        return (false);
    }
}

function checkMotorGetriebeBaubarkeit2( oResult, strRegion )
{
	//Zweite Abfrage über KONFIG_UNDEF6
	var strSelect = "";
	strSelect = "SELECT DISTINCT * ";
	strSelect = strSelect + "FROM KONFIG_UNDEF6 WHERE ";
	
	strSelect = strSelect + "EGBEZTYP = '"+oResult.oParsingData.oGearType.EGBEZTYP+"' AND ";
	strSelect = strSelect + "EGBEZUEBS = '"+oResult.oParsingData.oGearType.EGBEZUEBS+"' AND ";
	strSelect = strSelect + "EGBEZDIM = '"+oResult.oParsingData.oGearType.EGBEZDIM+"' AND ";
	strSelect = strSelect + "MOTDIM = '"+oResult.oParsingData.oMotor.MOTDIM+"' AND ";
	strSelect = strSelect + "MOTTYP = '"+oResult.oParsingData.oMotor.MOTTYP+"' AND ";
	
	strSelect = strSelect + "G115D = '0' AND ";
	strSelect = strSelect + "G115M = '0' AND ";
	
	if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
	{
		strSelect = strSelect + "WM_FU = '1' ";
	}
	else
	{
		strSelect = strSelect + "WM_FU = '0' ";
	}
	
	
	var strDBName = "2KJ_DB"; 
	var strDBResult = "CHECKGEARMOTOR2";
	
	if ( dbselect( strDBName, strSelect, strDBResult ) == 0 )
	{
		return (true);
	}
	else
	{
		//Baubarkeit Motor-Getriebe fehlgeschlagen
		var strMOTBEZ="";
		if(oResult.oParsingData.oGearType.ANWTYP=="KleinSchnecke")
			strMOTBEZ = replace((oResult.oParsingData.oMotor.MOTTYP+oResult.oParsingData.oMotor.MOEINKL+"I"+oResult.oParsingData.oMotor.MOTDIM+oResult.oParsingData.oMotor.PAKZUS+oResult.oParsingData.oMotor.PAKLGE+oResult.oParsingData.oMotor.POLZAHL+oResult.oParsingData.oMotor.HEMOTOR+oResult.oParsingData.oMotor.VSDMOTOR),"-","");
		else
			strMOTBEZ = replace((oResult.oParsingData.oMotor.MOTTYP+oResult.oParsingData.oMotor.MOEINKL+oResult.oParsingData.oMotor.MOTDIM+oResult.oParsingData.oMotor.PAKZUS+oResult.oParsingData.oMotor.PAKLGE+oResult.oParsingData.oMotor.POLZAHL+oResult.oParsingData.oMotor.HEMOTOR+oResult.oParsingData.oMotor.VSDMOTOR),"-","");

		logtraceln("*************************************************");
		logtraceln("Baubarkeit Motor-Getriebe fehlgeschlagen (KONFIG_UNDEF6");
		logtraceln("Getriebe:"+oResult.oParsingData.oGearType.EGTYP);
		logtraceln("Übersetzung:"+oResult.oParsingData.oRatio.EGUEB);
		logtraceln("Motorbezeichung:"+strMOTBEZ);
		logtraceln("*************************************************");
		
		return (false);
	}
}


function checkChinaKranAntrieb( strBaseMLFB, strMotorMLFB, oGearType, oShortDescriptions, strRegion)
{
    var strDBName = "2KJ_DB";
    
    if(strBaseMLFB.left(4) == "2KJ3")
        return (false);
        
    var strDBResult = "KRAN_CHECK";
    
    var strMotortabelle = "MOTFHT";
    
    
    var strMLFB_9 = strMotorMLFB.left(1);
    var strMLFB_10 = strMotorMLFB.substring(1,2);
    var strMLFB_11 = strMotorMLFB.substring(2,3);
    var strMLFB_12 = strMotorMLFB.substring(3,4);
    var strMLFB_13 = strMotorMLFB.right(1);
    
    var strSelect = "SELECT DISTINCT HEMOTOR,BETR_ART_P1,MOTTYP FROM "+strMotortabelle+" WHERE MLFB_2KJ_9='"+strMLFB_9+"' AND MLFB_2KJ_10='"+strMLFB_10+"' AND MLFB_2KJ_11='"+strMLFB_11+"' AND MLFB_2KJ_12='"+strMLFB_12+"' AND MLFB_2KJ_13='"+strMLFB_13+"' ";
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        var strHEMOTOR = dbgetstring( strDBResult, 'HEMOTOR' );
        var strMOTTYP = dbgetstring( strDBResult, 'MOTTYP' );
        var strBETR_ART_P1 = dbgetstring( strDBResult, 'BETR_ART_P1' );
        
        
        if(strHEMOTOR == "-" && strBETR_ART_P1 == "S3-75%" && strMOTTYP == "LH")
        {
            logtraceln("Kranantrieb CHINA!");
            return (true);
        }
        else
            return (false);
    }
    else
    {
        logtraceln("Kranantrieb China ERROR! SQL="+strSelect);
        return(false);
    }
}

function Bestimme_AbtriebswellenmassforKeepConfiguration( oGearType, oFastening, oShortDescriptions)
{
    //Abtriebswellenmass
    
    var Abtriebswellentyp = "-"; //Default
    var Verbindungsart = "-"; //Default
        
    
    var strEGTYP = oGearType.EGBEZTYP+oGearType.EGBEZUEBS+oGearType.EGBEZBRA+Abtriebswellentyp+oFastening.EGBEZBEF+Verbindungsart+oGearType.EGBEZDIM+oGearType.EGBEZEI;
    strEGTYP = replace(strEGTYP, "-", "");
    
    
    var strWELLE_BDS = "0"; //Default
    
    var strWELLE_O_PF = "0"; //Default
    
    var strSelect = "SELECT DISTINCT MLFB_2KJ_8, MLFB_2KJ_8_KA FROM EGABKD_M3 WHERE ";
    strSelect = strSelect + "EGTYP='"+strEGTYP+"' AND ";
    strSelect = strSelect + "WELLE_BDS='"+strWELLE_BDS+"' AND ";
    strSelect = strSelect + "WELLE_O_PF='"+strWELLE_O_PF+"' AND ";
    strSelect = strSelect + "SONDER='-' AND ";
    strSelect = strSelect + "ZOLLWELLE='0' AND ";
    strSelect = strSelect + "G115='0' ";
    
    var aResult = Object.fromDatabase("2KJ_DB", strSelect);
    
    if(aResult.length>0)
    {
        return aResult[0];
    }
    else
    {
		//Es kann sein, dass auch die Befestigungsart noch angepasst werden muss
		logtraceln("Fehler Keep Configuration Abtriebswelle!");
	}
}

function checkAntriebsgruppeforKeepConfiguration( strGearTypeMLFB, strFasteningMLFB, strShaftMLFB, strRatioMLFB, strMotorMLFB, strVoltageSD, oGearType, oShortDescriptions, strRegion, oRatio )
{
    /*
    Stelle 9: Baugröße des Adapters
    Stelle 10: Kenner für die Zolltarifnummer. Bei Getriebe ohne Motor ist das immer A (Stelle 11 = 0).
    Stelle 11: Bei Getriebe ohne Motor immer die 0. Die 8 benötigen wir später für den angebauten Motor.
    Stelle 12 definiert den Adaptertyp.
    Der Vollständigkeit halber: Stelle 13 ist immer 0, wir haben ja keine Spannung
    */
    
    var strShaftSD = getSDFromGroup( oShortDescriptions, 'ABTRIEBSWELLE' );
    
    var oGearType = checkGearType( strGearTypeMLFB, strRegion );
    var oFastening = checkFastening( strFasteningMLFB, strRegion, oGearType.EGBEZTYP, true );
    var oShaft = checkShaft( strShaftMLFB, strShaftSD, oGearType, oFastening, oShortDescriptions, strRegion, true );
    var oRatio = checkRatio( strRatioMLFB, oGearType, oShaft, strRegion );
    
    var c9 = strMotorMLFB.charAt( 0 );		
    var c10 = strMotorMLFB.charAt( 1 );		
    var c11 = strMotorMLFB.charAt( 2 );		
    var c12 = strMotorMLFB.charAt( 3 );		
    var c13 = strMotorMLFB.charAt( 4 );	
    
    //Neuerung, Stellen 9 bis 12 kommen nicht mehr aus SIZER, nur noch "."
    
    var strStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    if(strStartConfiguration=="" && find(strMotorMLFB, ".") >= 0)
        strStartConfiguration="1" ;
        
    var strMLFB_AVTYP = "MLFB_AVTYP";
    if(strRegion == "CHINA")
        strMLFB_AVTYP = "MLFB4_AVTYP";
    
    var strBaseSelect = "SELECT * FROM CD_AVEINHEITEN,"+strMLFB_AVTYP+",CD_GETRIEBE, CD_GETRIEBE_BEZEICHNUNGEN WHERE " + 
                        " MLFB_2KJ_9 = '" + c9 + 
                        "' AND MLFB_2KJ_10 = '" + c10 + 
                        "' AND MLFB_2KJ_11 = '" + c11 + 
                        "' AND MLFB_2KJ_12 = '" + c12 + "' ";
    if ( 'A08' in oShortDescriptions )
    {
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_OPTION = 'A08' ";
    }
    else
    {
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_OPTION = '-' ";
    }
    
    if ( 'M1A' in oShortDescriptions )
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_2KJ_12_KA = 'M1A' ";
    else if ( 'M1B' in oShortDescriptions )
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_2KJ_12_KA = 'M1B' ";
    
    
    strBaseSelect += " AND LKB = '-' ";
    strBaseSelect += " AND CD_AVEINHEITEN.AVTYPDIM = "+strMLFB_AVTYP+".AVTYPDIM ";
    strBaseSelect += " AND CD_AVEINHEITEN.AV_TYP_KZ = "+strMLFB_AVTYP+".AVMLFBTYP ";
    
    if ( 'A17' in oShortDescriptions )
        strBaseSelect += " AND CD_AVEINHEITEN.KUEINHEIT = 'Rutschkupplung' ";
    else
        strBaseSelect += " AND CD_AVEINHEITEN.KUEINHEIT <> 'Rutschkupplung' ";
    
    if ( 'A15' in oShortDescriptions )
        strBaseSelect += " AND CD_AVEINHEITEN.AV_RLSP = '1' ";
    else
        strBaseSelect += " AND CD_AVEINHEITEN.AV_RLSP = '0' ";
        
    if ( 'G99' in oShortDescriptions )
        strBaseSelect += " AND CD_GETRIEBE_BEZEICHNUNGEN.EGBEZSO = 'W' ";
    else
        strBaseSelect += " AND CD_GETRIEBE_BEZEICHNUNGEN.EGBEZSO = '-' ";
    
    strBaseSelect += " AND CD_GETRIEBE.EGBEZTYP = '"+oGearType.EGBEZTYP+"' ";
    strBaseSelect += " AND CD_GETRIEBE.EGBEZUEBS = '"+oGearType.EGBEZUEBS+"' ";
    strBaseSelect += " AND CD_GETRIEBE.EGBEZDIM = '"+oGearType.EGBEZDIM+"' ";
    strBaseSelect += " AND CD_GETRIEBE.EGBEZEI = '"+oGearType.EGBEZEI+"' ";
    strBaseSelect += " AND CD_GETRIEBE.ZGBEZUEBS = '-' ";
    strBaseSelect += " AND CD_GETRIEBE.ZGBEZDIM = '-' ";
    strBaseSelect += " AND CD_GETRIEBE.ZGBEZEI = '-' ";
    strBaseSelect += " AND CD_GETRIEBE.EGUEB = '"+oRatio.EGUEB+"' ";
    
    strBaseSelect += " AND CD_GETRIEBE.AVMOKDBEZ = CD_AVEINHEITEN.MAVABKD ";
    strBaseSelect += " AND CD_GETRIEBE.GETRIEBE_BEZ = CD_GETRIEBE_BEZEICHNUNGEN.GETRIEBE_BEZ ";
    strBaseSelect += " AND CD_AVEINHEITEN.AVABFLD = CD_GETRIEBE_BEZEICHNUNGEN.EGANFLDM ";
    strBaseSelect += " AND CD_AVEINHEITEN.AVABSSAR = CD_GETRIEBE_BEZEICHNUNGEN.EGANSSART ";
    strBaseSelect += " AND CD_AVEINHEITEN.BRANCHE = '"+oGearType.ANWTYP+"' ";
    
    var aResult = Object.fromDatabase( '2KJ_DB', strBaseSelect );
    if ( aResult.length > 0 )
    {
        return ( true );
    }
    
    return ( false );
}

function checkEncoderSelectionforKeepConfiguration(strMotorMLFB, oShortDescriptions, strKA_Encoder)
{
    // Testen ob der alte Geber auch mit dem neuen Motor verfügbar ist
    // Motorbaugröße auf Motor MLFB extrahieren
    
    var c9 = strMotorMLFB.charAt( 0 );		// motor size part 1
    var c10 = strMotorMLFB.charAt( 1 );		// motor size part 2
    var c11 = strMotorMLFB.charAt( 2 );		// motor type
    var c12 = strMotorMLFB.charAt( 3 );		// motor generation
    
    var strSelect = "SELECT DISTINCT MOTDIM FROM CD_MOTOREN WHERE MLFB_2KJ_9 = '" + c9 + "' AND MLFB_2KJ_10 = '" + c10 + "' AND MLFB_2KJ_11 = '" + c11 + "' AND MLFB_2KJ_12 = '" + c12 + "' ";
    var aResult = Object.fromDatabase( '2KJ_DB', strSelect );
    
    if(aResult.length == 1)
    {
        var strMOTDIM = aResult[0].MOTDIM;
        
        // Test, ob der Geber noch verfügbar ist
        
        var strSelect = "SELECT DISTINCT WERT_1,WERT_2,WERT_3 FROM MLFB_OPTIONEN WHERE MLFB_OPTION='"+strKA_Encoder+"' ";
        var aResult = Object.fromDatabase( '2KJ_DB', strSelect );
        
        if(aResult.length == 1)
        {
            var strEncoder_GEBTYP_old = aResult[0].WERT_1;
            var strEncoder_GEBBEZ_old = aResult[0].WERT_2;
            var strEncoder_FKTSICHERHEIT_old = aResult[0].WERT_3;
            
            var strSelect = "SELECT * FROM CD_GEBER WHERE GEBER='"+strEncoder_GEBBEZ_old+"' AND MOTDIM='"+strMOTDIM+"' ";
            var aResult = Object.fromDatabase( '2KJ_DB', strSelect );
            
                if(aResult.length > 0)
                {
                    // Geber geht auch bei neuen Motor noch!
                    return ("");
                }
                else
                {
                    // Geber geht nicht mehr und muss ersetzt werden durch neuen Geber
                    
                    var strSelect = "SELECT DISTINCT GEBER FROM CD_GEBER WHERE MOTDIM='"+strMOTDIM+"' AND IMPULSZAHL='2048' AND MECH_VAR='Flanschdose' AND GEBTYP='IA' ";
                    var aResult = Object.fromDatabase( '2KJ_DB', strSelect );
            
                    if(aResult.length == 1)
                    {
                        // KA für neuen Default Encoder bestimmen
                        
                        var strSelect="SELECT DISTINCT MLFB_OPTION FROM MLFB_OPTIONEN WHERE MERKMAL_1='GEBTYP' AND WERT_1='IA' AND MERKMAL_2='GEBBEZ' AND WERT_2='"+aResult[0].GEBER+"' ";
                        var aResult = Object.fromDatabase( '2KJ_DB', strSelect );
            
                        if(aResult.length == 1)
                        {
                            return (aResult[0].MLFB_OPTION);
                        }
                        else
                        {
                            logtraceln("Error generating new Default Encoder KA for KC Encoder Check; SQL="+strSelect);	
                        }
                    }
                    else
                    {
                        logtraceln("Error generating new Default Encoder for KC Encoder Check; SQL="+strSelect);	
                    }
                    
                }
            
        }
        else
        {
            logtraceln("Error generating Encoder from KA for KC Encoder Check; SQL="+strSelect);	
        }
    }
    else
    {
        logtraceln("Error generating Motor Size for KC Encoder Check; SQL="+strSelect);	
    }
    
    return ("");
}