//@legacy
//#mode(full-ecma)


//@import "../2KJ_CONFIG/utils.js"

//@import "Parser.common.js"

//@import "../2KJ_CONFIG/2KJ_Functions.js"

//@import "../2KJ_CONFIG/models/CFG_2KJ_GEBER_Model.js"


/**
 * @category   SimoGear Parser
 * @package    Parser
 * @copyright  Copyright (c) 2012 Plan Software GmbH (http://www.plansoft.de)
 */

/**
 * @constructor
 * the encoder type ID encodes design, number of pulses, electronical variant, mechanical variant, output signals, and (of course) the type id.
 * these attributes will be set to the motox geared motor object
 *
 * @param oMotox: motox geared motor object whose encoder attributes should be modified
 * @param strSD - short description for encoder type
 * @param oParsingData - parsing data object: contains parsing data results from different parsing stages (not all subobjects may be present due to parsing errors)
 *                       oGearType: parsing results for MLFB gear type part, contains attributes MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, 
 *								    EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI
 *                       oShaft: parsing results for MLFB gear output shaft part, contains attributes EGTYP, EGABW, EGBEZAWTYP, EGBEZWNV, EGBEZBRA, ANWTYP, EGBEZSO
 *                       oFastening: parsing results for MLFB gear fastening part, contains attributes MLFB_2KJ_14, MLFB_2KJ_14_KA, EGBEZBEF
 *                       oRatio: parsing results for MLFB gear ratio part, contains attributes DGUEB, ZGUEB, EGUEB, ETA, T2FB1, N2
 *                       oMotor: parsing results for MLFB motor part, contains attributes MLFB_2KJ_9, MLFB_2KJ_10, MLFB_2KJ_11, MLFB_2KJ_12, MLFB_2KJ_13, MLFB_2KJ_P_KA, 
 *         					     MLFB_2KJ_13_KA, SO_NEMA_KA, SO_NEMA, SO_CSA_UL_R_KA, SO_CSA_UL_R, SO_GOST_KA, SO_GOST, SO_CHINA_KA, SO_CHINA, SO_CE_KA, SO_CE, WARMEKL, 
 *                               WIBLNR, WIBLAUSLG, POLZAHL, FREQUENZ, MOTDIM, FU, NETZ, SUCHTYP etc. (all columns of table CD_MOTOREN)
 * @param oShortDescriptions - object with short description information
 *                             each attribute name is a short description
 *                             each attribute value is an object with attributes group and freetext
 */
function _addAttributesForEncoderType( oMotox, strSD, oParsingData, oShortDescriptions, strRegion )
{
    var strSelect = "SELECT PROPERTY_VALUE FROM OPTION_VALUES WHERE KURZANGABE = '" + strSD + "' ";
    var strDBResult = 'GEBER_TYPE_DESCRIPTION';
    if ( dbselect( 'MOTOX_KURZANGABEN_DB', strSelect, strDBResult ) > 0 )
    {
        var strEncoderDirectSelection = dbgetstring( strDBResult, 'PROPERTY_VALUE' );
        // get detailed encoder data for this encoder type ID
        var strMotorSize = oParsingData.oMotor.MOTDIM;
        var strVenting = '-';
        if ( 'M23' in oShortDescriptions )
            strVenting = 'F';
        else
            strVenting = '-';
        var bProtectionCover = ( 'N22' in oShortDescriptions );
        
        var strSpecString =  oParsingData.oMotor.MOTELAUSF;
        
        var strKONSTAFS="-";
        if(strSD=="Q22" || strSD=="Q23" || strSD=="Q42" || strSD=="Q43" || strSD=="Q77" || strSD=="Q78")
            strKONSTAFS="Kauf";
        
        var oData = getValuesForEncoderDirectSelection( strEncoderDirectSelection, strMotorSize, strVenting, bProtectionCover, strSpecString, strKONSTAFS );
        if ( oData )
            applyValues( oMotox.oConfig, oData );
    }
    
    //mechanischer Schutz
    if(( 'Q95' in oShortDescriptions ))
    {
        //wird über Tabelle mit KA gesetzt
    }
    else
    {
        if(parseInt(oParsingData.oMotor.MOTDIM) <= 90)
            oMotox.oConfig.GEBER_MECHSCHUTZ="SCHUTZBLECH";
        else
            oMotox.oConfig.GEBER_MECHSCHUTZ="SCHUTZDACH";
    }
}


/**
 * @constructor
 * set the values of all short descriptions to the geared motor or geared motor configuration
 *
 * @param oShortDescriptions - object for short descriptions (and optional corresponding freetext)
 *                             each attribute name is a short description
 *                             each attribute value is an object with attributes group and freetext (the freetext string may be empty)
 * @param oMotox - geared motor object to adjust
 * @param oParsingData - parsing data object: contains parsing data results from different parsing stages (not all subobjects may be present due to parsing errors)
 *                       oGearType: parsing results for MLFB gear type part, contains attributes MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, 
 *									EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI
 *                       oShaft: parsing results for MLFB gear output shaft part, contains attributes EGTYP, EGABW, EGBEZAWTYP, EGBEZWNV, EGBEZBRA, ANWTYP, EGBEZSO
 *                       oFastening: parsing results for MLFB gear fastening part, contains attributes MLFB_2KJ_14, MLFB_2KJ_14_KA, EGBEZBEF
 *                       oRatio: parsing results for MLFB gear ratio part, contains attributes DGUEB, ZGUEB, EGUEB, ETA, T2FB1, N2
 *                       oMotor: parsing results for MLFB motor part, contains attributes MLFB_2KJ_9, MLFB_2KJ_10, MLFB_2KJ_11, MLFB_2KJ_12, MLFB_2KJ_13, MLFB_2KJ_P_KA, 
 *                  			 MLFB_2KJ_13_KA, SO_NEMA_KA, SO_NEMA, SO_CSA_UL_R_KA, SO_CSA_UL_R, SO_GOST_KA, SO_GOST, SO_CHINA_KA, SO_CHINA, SO_CE_KA, SO_CE, WARMEKL, 
 *                               WIBLNR, WIBLAUSLG, POLZAHL, FREQUENZ, MOTDIM, FU, NETZ, MOTSPG, SUCHTYP etc. (all columns of table CD_MOTOREN)
 */
function _adjustGearedMotorWithShortDescriptions( oShortDescriptions, oMotox, oParsingData, strRegion  )
{
    //--------------------------------------------------------------------------------------------------------
    // process all short descriptions
    //--------------------------------------------------------------------------------------------------------
    var strGroup;
    var strRotatingDirectionPresent = '';
    for ( var strSD in oShortDescriptions )
    {
        //--------------------------------------------------------------------------------------------------------
        // the easy part - the automatic processing
        //--------------------------------------------------------------------------------------------------------
        setShortDescriptionToGear( strSD, oMotox, 'MOTOX_KURZANGABEN_DB' );
        
        //--------------------------------------------------------------------------------------------------------
        // the heavy parts: exceptions and additions
        //--------------------------------------------------------------------------------------------------------
        strGroup = oShortDescriptions[strSD].group;
        if ( strGroup === 'G110M_TYP' )
        {
            Parser.MOTOX._addAttributesforG110M_TYP ( oMotox, strSD, oParsingData, oShortDescriptions )
        }
        else if ( strGroup === 'G110M_CU' )
        {
            Parser.MOTOX._addAttributesforG110M_CU ( oMotox, strSD, oParsingData, oShortDescriptions )
        }
        else if ( strGroup === 'G110M_INTBRE' )
        {
            Parser.MOTOX._addAttributesforG110M_INTBRE ( oMotox, strSD, oParsingData, oShortDescriptions )
        }
        else if ( strGroup === 'G110M_EXTANB' )
        {
            Parser.MOTOX._addAttributesforG110M_EXTANB ( oMotox, strSD, oParsingData, oShortDescriptions )
        }
        else if ( strGroup === 'GEBER_TYP' )
        {
            // for encoder type: for a single description, we have to add six lines of text, because the encoder type ID encodes design, number of pulses, electronical variant, 
            //                   mechanical variant, output signals and (of course) the type id must also be mentioned
            _addAttributesForEncoderType( oMotox, strSD, oParsingData, oShortDescriptions, strRegion );
            oMotox.oConfig.MIT_GEBER = "T";
        }
        else if ( strGroup === 'BREMSE_TYP' )
        {
            // if we have a brake type, we also want a brake
            oMotox.oConfig.MIT_BREMSE = "T";
            
            //Ausnahme Safety Brake
            if( "C09" in oShortDescriptions)
            {
                //hier muss das "S" in die Bezeichnung
                var oData = splitSelectedBrake( oMotox.oConfig.BREMSENTYP );
                
                if(oData.BREREDMO == "-")
                    oMotox.oConfig.BREMSENTYP=oData.BREART+"S"+oData.BRENENMO;
                else
                    oMotox.oConfig.BREMSENTYP=oData.BREART+"S"+oData.BRENENMO+"/"+oData.BREREDMO;
            }
            
        }
        else if ( strGroup === 'GETRIEBE_BAUFORM' )
        {
            // the gear output side is also encoded in the short description for the mounting position
            var strSide = strSD.substring( 0, 2 );
            if ( strSide === 'D0' )
                oMotox.oConfig.ABTRIEBSSEITE = '-';
            else if ( strSide === 'D1' )
                oMotox.oConfig.ABTRIEBSSEITE = 'A';
            else if ( strSide === 'D2' )
                oMotox.oConfig.ABTRIEBSSEITE = 'B';
            else if ( strSide === 'D3' )
                oMotox.oConfig.ABTRIEBSSEITE = 'AB';
            else if ( strSide === 'D4' )
                oMotox.oConfig.ABTRIEBSSEITE = 'BA';			
            // else bad luck dude - other output sides not defined yet
        }
        else if ( strGroup === 'GETRIEBE_SONDEREINBAULAGE' )
        {
            //Sondereinbaulage 2KJ3308-5LM32-4FF1-Z D04+E16+G23+G60+H09+K01+K08+L02+L75+M55+P90
            var strSE = strSD.left(1);
            var iSE = parseInt(strSD.right(2));
            
            if(strSE == "E")
            {
                ECL_SetValue("SONDEREINBAULAGE_OPTION", "T");
                var strWinkel = "";
                var strAchse = "";
                
                var strSelect = "SELECT DISTINCT WERT_1, MERKMAL_1 FROM MLFB_OPTIONEN WHERE ";
                strSelect = strSelect + "MLFB_OPTION = '"+strSD+"' AND Aktiv='1'";
                
                var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
                if ( aResult.length == 1 )
                {
                    strWinkel = aResult[0].WERT_1;
                    strAchse = aResult[0].MERKMAL_1;
                }
                else
                {
                    logtraceln("Fehler beim Bestimmen des Winkels und der Rotationsachse im Parser bei Sondereinbaulage; SQL="+strSelect);
                    ECL_DeselectAttribute ("SONDEREINBAULAGE_OPTION");
                }
                
                ECL_SetValue("SE_ACHSE_WAHL",strAchse.left(1));
                ECL_SetValue("SE_ROTATIONSWINKEL",strAchse+"_"+strWinkel);
                
                var iMountingPosition = parseInt(ECL_GetValue("ECSI_CX_MountingPosition"));
                if(isNaN(iMountingPosition))
                {
                    if(oMotox.GearData.ANWTYP=="Kuehlturm")
                        iMountingPosition = 2;
                    else
                        iMountingPosition = 1;
                }

                if(iMountingPosition >= 7)
                {
                    iMountingPosition=iMountingPosition-6;
                }
                
                var strBild;
                var strGetriebetyp = oMotox.GearData.EGBEZTYP+oMotox.GearData.EGBEZUEBS;
                strGetriebetyp = replace(strGetriebetyp, "-", "");
                strGetriebetyp = left(strGetriebetyp,1);

                var strSelect = "SELECT DISTINCT BILD FROM BILDER_SONDEREINBAULAGEN_NEW WHERE ";
                strSelect = strSelect + "Rotationsachse = '"+strAchse.left(1)+"' AND ";
                strSelect = strSelect + "EGPOSHL = 'M"+iMountingPosition+"' AND ";
                strSelect = strSelect + "Getriebetyp = '"+strGetriebetyp+"' ";
                
                var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
                if ( aResult.length == 1 )
                {
                    strBild = aResult[0].BILD;
                }
                else
                {
                    logtraceln("Fehler beim Bestimmen der Zielposition im Parser bei Sondereinbaulage; SQL="+strSelect);
                    ECL_DeselectAttribute ("SONDEREINBAULAGE_OPTION");
                }
                
                ECL_SetValue("SE_ZIELPOSITION",strBild);
            }	
        }
        else if ( strGroup === 'GETRIEBE_DREHRICHTUNG_ABTRIEBSWELLE' )
            strRotatingDirectionPresent = strSD;
        else if ( ( strSD === 'G72' ) || ( strSD === 'N23' ) || ( strSD === 'A15' ) )
            oMotox.oConfig.RUECKLAUFSPERRE_MOTOR_OPTION = "T";
        else if ( strGroup === 'UMGEBUNG' )
        {
            //vorerst entfernt
            /*
            if(strSD === "N43")
                oMotox.strAmbient = "FTU";
            else if(strSD === "N44" )
                oMotox.strAmbient = "SL";
            else
            */
                oMotox.strAmbient = "NORMAL";
        }
/* -og- 120402 mating have its own short descriptions that are independent of the connector			
        // mating of motor connectors depend to the connector itself
        else if ( strSD === 'N18' )
        {
            if ( ( 'N00' in oShortDescriptions ) || ( 'N01' in oShortDescriptions ) )
                oMotox.oConfig.strMating = 'MAK_HAN10_2';
            else if ( ( 'N04' in oShortDescriptions ) || ( 'N06' in oShortDescriptions ) )
                oMotox.oConfig.strMating = 'MAK_HAN10_1';
            // else bad luck dude - combination not specified at the time of this writing
        }
        else if ( strSD === 'N19' )
        {
            if ( ( 'N08' in oShortDescriptions ) || ( 'N09' in oShortDescriptions ) )
                oMotox.oConfig.strMating = 'MAK_K4/4_1';
            else if ( ( 'N10' in oShortDescriptions ) || ( 'N11' in oShortDescriptions ) )
                oMotox.oConfig.strMating = 'MAK_K4/4_2';
            // else bad luck dude - combination not specified at the time of this writing
        }
*/		
        // the conservation also determines the lacquer type
        else if (left(strSD,1) == "L" && strSD != "L19" && strSD != "L11" && strSD != "L12" && strSD != "L27")
        {
            if( strSD === 'L00' )
                oMotox.oConfig.OBERFLAECHENBEHANDLUNG = 'UNLACKIERT';
            else if ( ( strSD === 'L01' ) || ( strSD === 'L08' ) || ( strSD === 'L09' ) || ( strSD === 'L10' ) || ( strSD === 'L22' ) || ( strSD === 'L24' ) || ( strSD === 'L26' ) || ( strSD === 'L28' ) )
                oMotox.oConfig.OBERFLAECHENBEHANDLUNG = 'GRUNDIERT';
            else oMotox.oConfig.OBERFLAECHENBEHANDLUNG = 'LACKIERT';
        }
        else if ( strGroup === 'MOTORSPEZIFIKATION_CHINA' )
        {
            oMotox.ECSI_SPEZIFIKATION_CHECK = "CHINA";
        }
        else if ( strGroup === 'MOTORSPEZIFIKATION_EAC' )
        {
            oMotox.ECSI_SPEZIFIKATION_CHECK = "EAC";
        }
        else if ( strGroup === 'MOTORSPEZIFIKATION_CSA_UL_R' )
        {
            oMotox.ECSI_SPEZIFIKATION_CHECK = "ULR_CSA";
        }
    }
    
    //--------------------------------------------------------------------------------------------------------
    // special handling for backstop
    //--------------------------------------------------------------------------------------------------------
    if ( oMotox.ECSI_2KJ_TYPE=="GETRIEBEMOTOR" )
    {
        if ( strRotatingDirectionPresent != '' )
        {
            ECL_EnableValue("DREHRICHTUNG_MOTOR_OPTION", "T");
            ECL_SelectValue("DREHRICHTUNG_MOTOR_OPTION", "T");
            
            var strEGTYP = oParsingData.oGearType.EGBEZTYP+oParsingData.oGearType.EGBEZUEBS;
            strEGTYP=replace(strEGTYP,"-","");
            
            var strSelect = "SELECT DISTINCT ANTRIEBSDREHRICHTUNG_MOTOR,ABTRIEBSDREHRICHTUNG_GETRIEBE FROM ABTRIEBSDREHRICHTUNGEN WHERE ";
            strSelect = strSelect + "GETRIEBE = '"+strEGTYP+"' AND ";
            
            strSelect = strSelect + "ABTRIEBSSEITE = '"+oMotox.oConfig.ABTRIEBSSEITE+"' AND ";
            
            strSelect = strSelect + "KA_RLSP='"+strRotatingDirectionPresent+"' ";
            
            
            var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
            if(aResult.length==1)
            {
                var strRichtungMotor = aResult[0].ANTRIEBSDREHRICHTUNG_MOTOR;
                var strRichtungGetriebe = aResult[0].ABTRIEBSDREHRICHTUNG_GETRIEBE;
                
                if(strRichtungMotor == "CW")
                {
                    ECL_ActivateValue("DREHRICHTUNG_MOTOR", "links");
                    ECL_ActivateValue("DREHRICHTUNG_MOTOR", "rechts");
                    ECL_SelectValue("DREHRICHTUNG_MOTOR", "rechts");
                }
                else
                {
                    ECL_ActivateValue("DREHRICHTUNG_MOTOR", "links");
                    ECL_ActivateValue("DREHRICHTUNG_MOTOR", "rechts");
                    ECL_SelectValue("DREHRICHTUNG_MOTOR", "links");
                }
                
                if(strRichtungGetriebe == "CW")
                {
                    ECL_ActivateValue("DREHRICHTUNG_ABTRIEBSSEITE", "links");
                    ECL_ActivateValue("DREHRICHTUNG_ABTRIEBSSEITE", "rechts");
                    ECL_SelectValue("DREHRICHTUNG_ABTRIEBSSEITE", "rechts");
                }
                else
                {
                    ECL_ActivateValue("DREHRICHTUNG_ABTRIEBSSEITE", "links");
                    ECL_ActivateValue("DREHRICHTUNG_ABTRIEBSSEITE", "rechts");
                    ECL_SelectValue("DREHRICHTUNG_ABTRIEBSSEITE", "links");
                }
            }
            else
                logtraceln("Fehler Bestimmung Abtriebsdrehrichtung Motor und Getriebe, SQL="+strSelect);
        
        }
        else
        {
            ECL_EnableValue("DREHRICHTUNG_MOTOR_OPTION", "T");
            ECL_DeselectValue("DREHRICHTUNG_MOTOR_OPTION", "T");
        }
    }
    else if ( oMotox.ECSI_2KJ_TYPE=="GETRIEBE.ADAPTER" )
    {
        if ( strRotatingDirectionPresent != '' )
        {
            ECL_EnableValue("DREHRICHTUNG_ADAPTER_OPTION", "T");
            ECL_SelectValue("DREHRICHTUNG_ADAPTER_OPTION", "T");
            
            var strEGTYP = oParsingData.oGearType.EGBEZTYP+oParsingData.oGearType.EGBEZUEBS;
            strEGTYP=replace(strEGTYP,"-","");
            
            var strSelect = "SELECT DISTINCT ANTRIEBSDREHRICHTUNG_MOTOR,ABTRIEBSDREHRICHTUNG_GETRIEBE FROM ABTRIEBSDREHRICHTUNGEN WHERE ";
            strSelect = strSelect + "GETRIEBE = '"+strEGTYP+"' AND ";
            
            strSelect = strSelect + "ABTRIEBSSEITE = '"+oMotox.oConfig.ABTRIEBSSEITE+"' AND ";
            
            strSelect = strSelect + "KA_RLSP='"+strRotatingDirectionPresent+"' ";
            
            
            var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
            if(aResult.length==1)
            {
                var strRichtungMotor = aResult[0].ANTRIEBSDREHRICHTUNG_MOTOR;
                var strRichtungGetriebe = aResult[0].ABTRIEBSDREHRICHTUNG_GETRIEBE;
                
                if(strRichtungMotor == "CW")
                {
                    ECL_ActivateValue("DREHRICHTUNG_MOTOR_ADAPTER", "links");
                    ECL_ActivateValue("DREHRICHTUNG_MOTOR_ADAPTER", "rechts");
                    ECL_SelectValue("DREHRICHTUNG_MOTOR_ADAPTER", "rechts");
                }
                else
                {
                    ECL_ActivateValue("DREHRICHTUNG_MOTOR_ADAPTER", "links");
                    ECL_ActivateValue("DREHRICHTUNG_MOTOR_ADAPTER", "rechts");
                    ECL_SelectValue("DREHRICHTUNG_MOTOR_ADAPTER", "links");
                }
                
                if(strRichtungGetriebe == "CW")
                {
                    ECL_ActivateValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER", "links");
                    ECL_ActivateValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER", "rechts");
                    ECL_SelectValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER", "rechts");
                }
                else
                {
                    ECL_ActivateValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER", "links");
                    ECL_ActivateValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER", "rechts");
                    ECL_SelectValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER", "links");
                }
            }
            else
                logtraceln("Fehler Bestimmung Abtriebsdrehrichtung Motor und Getriebe, SQL="+strSelect);
        
        }
        else
        {
            ECL_EnableValue("DREHRICHTUNG_ADAPTER_OPTION", "T");
            ECL_DeselectValue("DREHRICHTUNG_ADAPTER_OPTION", "T");
        }
    
    }

    //--------------------------------------------------------------------------------------------------------
    // transfer freetext from special short descriptions to their proper location
    //--------------------------------------------------------------------------------------------------------
    if ( 'Y00' in oShortDescriptions )
    {
        // rating plate free text and/or rating plate customer number
        var oTextData = decodeY00( getFreetextValue( oShortDescriptions.Y00.freetext ) );
        if ( oTextData )
        {
            if ( "bDocumentationCustomerNumberPresent" in oTextData){
                oMotox.oConfig.LEISTUNGSSCHILD_ZUS_KUNDENNR = oTextData.strDocumentationCustomerNumber;
            }
            if ( "strDocumentationFreetext" in oTextData){
                oMotox.oConfig.LEISTUNGSSCHILD_ZUS_FREITEXT = oTextData.strDocumentationFreetext;
            }
            if ("strAdapterRutschkupplung_Drehmomenteingestellt" in oTextData){
                oMotox.oConfig.RUTSCHKUPPLUNG_MOMENT = oTextData.strAdapterRutschkupplung_Drehmomenteingestellt;
            }
        }
    }
    if ( 'Y80' in oShortDescriptions )
    {
        // special coloring
        var strColorID = replace( trimright( trimleft( getFreetextValue( oShortDescriptions.Y80.freetext ), ' ' ), ' ' ), '*ral@', '' );
        var strColorID = replace( trimright( trimleft( strColorID, ' ' ), ' ' ), '*RAL@', '' );
        if ( strColorID !== '' )
            oMotox.oConfig.FARBE = replace( strColorID, '*', '' );
    }
    
    //Setzen der Bauform Attribute
    var strEGPOS_BAUFORM=oMotox.oConfig.BAUFORM;
    if(strEGPOS_BAUFORM)
    {
        if(oMotox.oConfig.ABTRIEBSSEITE != "-")
            strEGPOS_BAUFORM=strEGPOS_BAUFORM+"-"+oMotox.oConfig.ABTRIEBSSEITE;
        
        oMotox.oConfig.ECSI_BAUFORM_EGPOS=strEGPOS_BAUFORM;
    }
}


/**
 * @constructor
 * adjust technical data of a partially constructed geared motor object
 *
 * @param oMotox - geared motor object whose technical data should be adjusted
 * @param oParsingData - results from the parsing process
 *                       oGearType: parsing results for MLFB gear type part, contains attributes MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, 
 *								    EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI
 *                       oShaft: parsing results for MLFB gear output shaft part, contains attributes EGTYP, EGABW, EGBEZAWTYP, EGBEZWNV, EGBEZBRA, ANWTYP, EGBEZSO
 *                       oFastening: parsing results for MLFB gear fastening part, contains attributes MLFB_2KJ_14, MLFB_2KJ_14_KA, EGBEZBEF
 *                       oRatio: parsing results for MLFB gear ratio part, contains attributes DGUEB, ZGUEB, EGUEB, ETA, T2FB1, N2
 *                       oMotor: parsing results for MLFB motor part, contains attributes MLFB_2KJ_9, MLFB_2KJ_10, MLFB_2KJ_11, MLFB_2KJ_12, MLFB_2KJ_13, MLFB_2KJ_P_KA, 
 *         					     MLFB_2KJ_13_KA, SO_NEMA_KA, SO_NEMA, SO_CSA_UL_R_KA, SO_CSA_UL_R, SO_GOST_KA, SO_GOST, SO_CHINA_KA, SO_CHINA, SO_CE_KA, SO_CE, WARMEKL, 
 *                               WIBLNR, WIBLAUSLG, POLZAHL, FREQUENZ, MOTDIM, FU, NETZ, SUCHTYP etc. (all columns of table CD_MOTOREN)
 */
function _adjustTechnicalData( oMotox, oParsingData, strRegion )
{
    var strMotortabelle = "CD_MOTOREN";
    var strDBResult = "MOTFHT_DATA";
    // gear data from parsing
    var dDBRatio = oParsingData.oRatio.DGUEB;
    var dDBNominalTorque = oParsingData.oRatio.T2FB1;
    var MMSystem = "SI";
    var strFrequency = 	oMotox.ECSI_FREQUENZ_VORAUSWAHL;
    
    // technical data to calculate
    var dDBInputSpeed,dDBOutputSpeed,dDBPower,dDBOutputTorque;
    
    // speeds for all frequencies
    var BDRHZAHL_50_P1="";
	var BDRHZAHL_60_P1 = ""; 
	var BDRHZAHL_87_P1 = ""; 
	var BDRHZAHL_104_P1 = "";
	var P50_P1="";
	var P60_P1="";
	var P87_P1="";
	var P104_P1="";
	
	if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
	{
		BDRHZAHL_50_P1 = oParsingData.oMotor.BDRHZAHL_1;
		BDRHZAHL_87_P1 = oParsingData.oMotor.BDRHZAHL_1;
		BDRHZAHL_60_P1 = oParsingData.oMotor.BDRHZAHL_4;
		BDRHZAHL_104_P1 = oParsingData.oMotor.BDRHZAHL_4;
		
		P50_P1 = oParsingData.oMotor.LEISTUNG1;
		P60_P1 = oParsingData.oMotor.LEISTUNG4;
		P87_P1 = oParsingData.oMotor.LEISTUNG1;
		P104_P1 = oParsingData.oMotor.LEISTUNG4;
	}
	else
	{
		
		if(oParsingData.oMotor.FREQUENZ_1 =="50")
			BDRHZAHL_50_P1 = oParsingData.oMotor.BDRHZAHL_1;
		
		
		if(oParsingData.oMotor.FREQUENZ_1 =="60")
		{
			BDRHZAHL_60_P1 = oParsingData.oMotor.BDRHZAHL_1;
		}
		else if(oParsingData.oMotor.FREQUENZ_2=="60")
		{
			BDRHZAHL_60_P1 = oParsingData.oMotor.BDRHZAHL_4;
		}
		
		if(oParsingData.oMotor.FREQUENZ_1 =="87")
		{
			BDRHZAHL_87_P1 = oParsingData.oMotor.BDRHZAHL_1;
		}
		else if(oParsingData.oMotor.FREQUENZ_2=="87")
		{
			BDRHZAHL_87_P1 = oParsingData.oMotor.BDRHZAHL_4;
		}
		else if(oParsingData.oMotor.FREQUENZ2_1=="87")
		{
			BDRHZAHL_87_P1 = oParsingData.oMotor.BDRHZAHL2_1;
		}
		else if(oParsingData.oMotor.FREQUENZ2_2=="87")
		{
			BDRHZAHL_87_P1 = oParsingData.oMotor.BDRHZAHL2_4;
		}
		
		if(oParsingData.oMotor.FREQUENZ_1 =="104")
		{
			BDRHZAHL_104_P1 = oParsingData.oMotor.BDRHZAHL_1;
		}
		else if(oParsingData.oMotor.FREQUENZ_2=="104")
		{
			BDRHZAHL_104_P1 = oParsingData.oMotor.BDRHZAHL_4;
		}
		else if(oParsingData.oMotor.FREQUENZ2_1=="104")
		{
			BDRHZAHL_104_P1 = oParsingData.oMotor.BDRHZAHL2_1;
		}
		else if(oParsingData.oMotor.FREQUENZ2_2=="104")
		{
			BDRHZAHL_104_P1 = oParsingData.oMotor.BDRHZAHL2_4;
		}
		
		if(oParsingData.oMotor.FREQUENZ_1=="50")
			P50_P1 = oParsingData.oMotor.LEISTUNG1;
		
		if(oParsingData.oMotor.FREQUENZ_1=="60")
		{
			P60_P1 = oParsingData.oMotor.LEISTUNG1;
		}
		else if(oParsingData.oMotor.FREQUENZ_2=="60")
		{
			P60_P1 = oParsingData.oMotor.LEISTUNG4;
		}
		
		if(oParsingData.oMotor.FREQUENZ_1=="87")
		{
			P87_P1 = oParsingData.oMotor.LEISTUNG1;
		}
		else if(oParsingData.oMotor.FREQUENZ_2=="87")
		{
			P87_P1 = oParsingData.oMotor.LEISTUNG4;
		}
		else if(oParsingData.oMotor.FREQUENZ2_1=="87")
		{
			P87_P1 = oParsingData.oMotor.LEISTUNG21;
		}
		else if(oParsingData.oMotor.FREQUENZ2_2=="87")
		{
			P87_P1 = oParsingData.oMotor.LEISTUNG24;
		}
		
		if(oParsingData.oMotor.FREQUENZ_1=="104")
		{
			P104_P1 = oParsingData.oMotor.LEISTUNG1;
		}
		else if(oParsingData.oMotor.FREQUENZ_2=="104")
		{
			P104_P1 = oParsingData.oMotor.LEISTUNG4;
		}
		else if(oParsingData.oMotor.FREQUENZ2_1=="104")
		{
			P104_P1 = oParsingData.oMotor.LEISTUNG21;
		}
		else if(oParsingData.oMotor.FREQUENZ2_2=="104")
		{
			P104_P1 = oParsingData.oMotor.LEISTUNG24;
		}
	}
	
    // filter them according to the current motor frequency and poles
    var DatenArray = [
        BDRHZAHL_50_P1,
        BDRHZAHL_60_P1,
        BDRHZAHL_87_P1,
        BDRHZAHL_104_P1,
        P50_P1,
        P60_P1,
        P87_P1,
        P104_P1
    ];
    
    var ErgArray = Bestimme_LeistungDrehzahl_Motor(oMotox,DatenArray);
    var dDBPower = parseFloat(ErgArray[4]);
    var strLeistung = replace(ErgArray[4],".", ",");
    
    // calculate technical data
    dDBInputSpeed = ErgArray[0];
    dDBOutputSpeed = dDBInputSpeed / dDBRatio;

    var nStufenFaktor    = 1.0;
    var nVerlustLeistung = 0;
    var etaPab = 1.0;
    
    //Bei Schneckenstirnradgetrieben wird Wirkungsgrad gesondert berechnet
    if(oMotox.GearData.EGBEZTYP == "C")
    {
        etaPab = getWirkungsgradSchneckengetriebe( oMotox.GearData.EGBEZTYP, oMotox.GearData.EGBEZBRA, oMotox.GearData.EGBEZUEBS, oMotox.GearData.EGBEZEI, oMotox.GearData.EGBEZDIM, "-", "-", "-", dDBRatio, dDBInputSpeed, MMSystem);
    }
    
    var pAB = (dDBPower - nVerlustLeistung) * nStufenFaktor * etaPab;
    
    dDBOutputTorque = ( 9550.0 * pAB ) / dDBOutputSpeed;
    
    //Bei Schneckenstirnradgetrieben wird das Nennmoment gesondert berechnet
    if(oMotox.GearData.EGBEZTYP == "C")
    {
        dDBNominalTorque = getNennmomentSchneckengetriebe( -1, oMotox.GearData.EGBEZTYP, oMotox.GearData.EGBEZBRA, oMotox.GearData.EGBEZUEBS, oMotox.GearData.EGBEZEI, oMotox.GearData.EGBEZDIM, "-", "-", "-", dDBRatio, dDBInputSpeed, MMSystem);
    }
    
    // actual geared motor technical data

    oMotox.GearData.LEISTUNG =  dDBPower;
    
    var strNennmoment_Ausgabe;
    strNennmoment_Ausgabe = RoundMotox( dDBNominalTorque,MMSystem,"DREHMOMENT" );
    
    oMotox.GearData.BDRHZAHL_MOTOR = RoundMotox( dDBInputSpeed, MMSystem, 'DREHZAHL' );
    oMotox.GearData.ABTRIEBSDREHZAHL = RoundMotox( dDBOutputSpeed, MMSystem, 'DREHZAHL' );
        
    oMotox.GearData.NENNMOMENT = parseFloat(dDBNominalTorque);
    oMotox.GearData.NENNMOMENT_2 = parseFloat(dDBNominalTorque);
    oMotox.GearData.UEBERSETZUNG = dDBRatio;
    oMotox.GearData.ABTRIEBSDREHMOMENT = dDBOutputTorque;
    oMotox.GearData.BETRIEBSFAKTOR = dDBNominalTorque / dDBOutputTorque;
    oMotox.GearData.EGUEB = oParsingData.oRatio.EGUEB;
	oMotox.GearData.ZGUEB = oParsingData.oRatio.ZGUEB;
    
    // motor input power
    oMotox.strMotorPower = '' + dDBPower;	
    oMotox.dRatio = dDBRatio;
    oMotox.strInputSpeedGear = RoundMotox( dDBInputSpeed, MMSystem, 'DREHZAHL' );
    oMotox.dOutputSpeed = oMotox.GearData.ABTRIEBSDREHZAHL - 0;
    oMotox.dServiceFactor = oMotox.GearData.BETRIEBSFAKTOR - 0;
}

function _adjustTechnicalData_Adapter( oMotox, oParsingData, oShortDescriptions )
{
    // gear data from parsing
    var dDBRatio = oParsingData.oRatio.EGUEB;
    var dDBNominalTorque = oParsingData.oRatio.T2FB1;
    var MMSystem = "SI";
    
    // technical data to calculate
    //hier Berechnung der Antriebs/Abtriebswerte
    
    var nStufenFaktor    = 1.0;
    var nVerlustLeistung = 0;
    var etaPab = 1.0;
    
    var dDBInputSpeed, dDBOutputSpeed, dDBPower, dDBOutputTorque;
    
    dDBInputSpeed = oMotox.dInputSpeed;
    dDBOutputSpeed = dDBInputSpeed/dDBRatio;
    
    var dDBPower = oMotox.strMotorPowerGA;
    
    //Bei Schneckenstirnradgetrieben wird Wirkungsgrad gesondert berechnet
    if(oMotox.GearData.EGBEZTYP == "C")
    {
        etaPab = getWirkungsgradSchneckengetriebe( oMotox.GearData.EGBEZTYP, oMotox.GearData.EGBEZBRA, oMotox.GearData.EGBEZUEBS, oMotox.GearData.EGBEZEI, oMotox.GearData.EGBEZDIM, "-", "-", "-", dDBRatio, dDBOutputSpeed, MMSystem);
    }
    
    var pAB = (dDBPower - nVerlustLeistung) * nStufenFaktor * etaPab;
    
    dDBOutputTorque = ( 9550.0 * pAB ) / dDBOutputSpeed;
    
    //Bei Schneckenstirnradgetrieben wird das Nennmoment gesondert berechnet
    if(oMotox.GearData.EGBEZTYP == "C")
    {
        dDBNominalTorque = getNennmomentSchneckengetriebe( -1, oMotox.GearData.EGBEZTYP, oMotox.GearData.EGBEZBRA, oMotox.GearData.EGBEZUEBS, oMotox.GearData.EGBEZEI, oMotox.GearData.EGBEZDIM, "-", "-", "-", dDBRatio, dDBOutputSpeed, MMSystem);
    }
    
    // actual geared motor technical data
    //var strMMSystem = Settings.getMeasurementSystem();

    //Leistung kommt immer in KW
    
    // Wenn Context vorhanden ist, dann nehmen wir den
    var strMotorRatedPower = ECL_GetValue("ECSI_CX_MotorRatedPower");
    var strMotorRatedSpeed = ECL_GetValue("ECSI_CX_MotorRatedSpeed");
    
    //for Testing only
    if(!strMotorRatedPower)
    {
        strMotorRatedPower = "1,5";
        ECL_SetValue("ECSI_CX_MotorRatedPower",strMotorRatedPower);
    }
    
    if(!strMotorRatedSpeed)
    {
        strMotorRatedSpeed = "1250";
        ECL_SetValue("ECSI_CX_MotorRatedSpeed",strMotorRatedSpeed);
    }

    if(strMotorRatedPower && strMotorRatedSpeed)
    {
        oMotox.GearData.LEISTUNG = strMotorRatedPower;
        oMotox.GearData.ANTRIEBSDREHZAHL = strMotorRatedSpeed;
    }
    else
    {
        oMotox.GearData.LEISTUNG = dDBPower;
        oMotox.GearData.ANTRIEBSDREHZAHL = dDBInputSpeed;
    }

    var oLeistungAusgabe = createEmptyTechval();
    oLeistungAusgabe = checkObject( null, 'LEISTUNG', replace( dDBPower, ',', '.' ), 'kW', false );
    
    var strLeistung_Ausgabe;
    if(MMSystem=="SI")
        strLeistung_Ausgabe = getValueFormatted (oLeistungAusgabe, "kW", false, false);
    else
        strLeistung_Ausgabe = getValueFormatted (oLeistungAusgabe, "hp", false, false);
    
    oMotox.GearData.LEISTUNG_AUSGABE = strLeistung_Ausgabe;
    
    
    var strNennmoment_Ausgabe;
    strNennmoment_Ausgabe = RoundMotox( dDBNominalTorque,MMSystem,"DREHMOMENT" );
    
    oMotox.GearData.BDRHZAHL_MOTOR = RoundMotox( dDBInputSpeed, MMSystem, 'DREHZAHL' );
    oMotox.GearData.ABTRIEBSDREHZAHL = RoundMotox( dDBOutputSpeed, MMSystem, 'DREHZAHL' );
    oMotox.GearData.ABTRIEBSDREHZAHL_AUSGABE = replace( oMotox.GearData.ABTRIEBSDREHZAHL, '.', ',' );
    oMotox.GearData.NENNMOMENT = parseFloat(dDBNominalTorque);
    oMotox.GearData.NENNMOMENT_2 = parseFloat(dDBNominalTorque);
    oMotox.GearData.NENNMOMENT_AUSGABE = strNennmoment_Ausgabe;
    
    oMotox.GearData.UEBERSETZUNG = dDBRatio;
    oMotox.GearData.ABTRIEBSDREHMOMENT = RoundMotox( dDBOutputTorque, MMSystem, 'DREHMOMENT' );
    
    oMotox.GearData.EGUEB = oParsingData.oRatio.EGUEB;
	oMotox.GearData.ZGUEB = oParsingData.oRatio.ZGUEB;
        
    var Abtriebsdrehmoment_Ausgabe;
    Abtriebsdrehmoment_Ausgabe = RoundMotox( dDBOutputTorque,MMSystem,"DREHMOMENT" );
    
    if(MMSystem=="SI")
        oMotox.GearData.ABTRIEBSDREHMOMENT_AUSGABE = replace( Abtriebsdrehmoment_Ausgabe, '.', ',' );
    else
        oMotox.GearData.ABTRIEBSDREHMOMENT_AUSGABE = replace( Abtriebsdrehmoment_Ausgabe, ',', '.' );
    
    oMotox.GearData.BETRIEBSFAKTOR = RoundMotox( dDBNominalTorque / dDBOutputTorque, MMSystem, 'BETRIEBSFAKTOR' );
    
    if(MMSystem=="SI")
        oMotox.GearData.BETRIEBSFAKTOR_AUSGABE = replace( oMotox.GearData.BETRIEBSFAKTOR, '.', ',' );
    else
        oMotox.GearData.BETRIEBSFAKTOR_AUSGABE = replace( oMotox.GearData.BETRIEBSFAKTOR, ',', '.' );


    // we set the input values for the geared motor on the actual technical values; with this settings, the geared motor will be found as a possible result in a subseqent search 
    // gear input torque
    oMotox.bMotorPowerOrOutputTorque = true;
    
    // dDBTorque war undefined, um dies zu umgehen wurde es auf 0 gesetzt. Kein rückschluss woher die Variable kommen
    // könnte, da in der alten engine auch undefined ist
    var dDBTorque = 0;
              
    if ( !oMotox.oOutputTorque )
    {
        oMotox.oOutputTorque = createEmptyTechval();
        oMotox.oOutputTorque = checkObject( null, 'DREHMOMENT', dDBTorque, 'Nm',false );
    }
    else setValueAsNumber( oMotox.oOutputTorque, dDBTorque, 'Nm', true );
    if ( !oMotox.oGearNominalTorque )
    {
        oMotox.oGearNominalTorque = createEmptyTechval();
        oMotox.oGearNominalTorque = checkObject( null, 'DREHMOMENT', dDBNominalTorque, 'Nm',false );
    }
    else setValueAsNumber( oMotox.oGearNominalTorque, dDBNominalTorque, 'Nm', true );

    // motor input power
    oMotox.strMotorPower = '' + dDBPower;
    if ( !oMotox.oMotorPower )
    {
        oMotox.oMotorPower = createEmptyTechval();
        oMotox.oMotorPower = checkObject( null, 'LEISTUNG', replace( oMotox.strMotorPower, ',', '.' ), 'kW',false );
    }
    else setValueAsNumber( oMotox.oMotorPower, replace( oMotox.strMotorPower, ',', '.' ), 'kW', true );
    
    oMotox.dRatio = dDBRatio;
    oMotox.strInputSpeedGear = RoundMotox( dDBInputSpeed, MMSystem, 'DREHZAHL' );
    oMotox.dOutputSpeed = oMotox.GearData.ABTRIEBSDREHZAHL - 0;
    oMotox.dServiceFactor = oMotox.GearData.BETRIEBSFAKTOR - 0;
}


/**
 * @constructor
 * build a geared motor object from parsing data
 *
 * @param oParsingData - results from the parsing process
 *                       oGearType: parsing results for MLFB gear type part, contains attributes MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, 
 *								    EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI
 *                       oShaft: parsing results for MLFB gear output shaft part, contains attributes EGTYP, EGABW, EGBEZAWTYP, EGBEZWNV, EGBEZBRA, ANWTYP, EGBEZSO
 *                       oFastening: parsing results for MLFB gear fastening part, contains attributes MLFB_2KJ_14, MLFB_2KJ_14_KA, EGBEZBEF
 *                       oRatio: parsing results for MLFB gear ratio part, contains attributes DGUEB, ZGUEB, EGUEB, ETA, T2FB1, N2
 *                       oMotor: parsing results for MLFB motor part, contains attributes MLFB_2KJ_9, MLFB_2KJ_10, MLFB_2KJ_11, MLFB_2KJ_12, MLFB_2KJ_13, MLFB_2KJ_P_KA, 
 *         					     MLFB_2KJ_13_KA, SO_NEMA_KA, SO_NEMA, SO_CSA_UL_R_KA, SO_CSA_UL_R, SO_GOST_KA, SO_GOST, SO_CHINA_KA, SO_CHINA, SO_CE_KA, SO_CE, WARMEKL, 
 *                               WIBLNR, WIBLAUSLG, POLZAHL, FREQUENZ, MOTDIM, FU, NETZ, SUCHTYP etc. (all columns of table CD_MOTOREN)
 * @param oShortDescriptions - object for short descriptions (and optional corresponding freetext)
 *                             each attribute name is a short description
 *                             each attribute value is an object with attributes group and freetext (the freetext string may be empty)
 * @param strBaseMLFB - base MLFB
 *
 * @return object - constructed geared motor object
 */
function buildGearedMotor( oParsingData, oShortDescriptions, strBaseMLFB, strRegion )
{
    var oMotox = {};
    
    oMotox.GearData = {};
    oMotox.oConfig = {};
    oMotox.BrakeData = {};
    //--------------------------------------------------------------------------------------------------------
    // base geared motor data
    //--------------------------------------------------------------------------------------------------------
    
    // base gear and motor stuff
    oMotox.EGTYP = oParsingData.oGearType.EGTYP;
    
    if(oParsingData.oGearType.ANWTYP=="KleinSchnecke"){
        oMotox.strMotor = replace((oParsingData.oMotor.MOTTYP+oParsingData.oMotor.MOEINKL+"I"+oParsingData.oMotor.MOTDIM+oParsingData.oMotor.PAKZUS+oParsingData.oMotor.PAKLGE+oParsingData.oMotor.POLZAHL+oParsingData.oMotor.HEMOTOR+oParsingData.oMotor.VSDMOTOR),"-","");
    }
    else{
        oMotox.strMotor = replace((oParsingData.oMotor.MOTTYP+oParsingData.oMotor.MOEINKL+oParsingData.oMotor.MOTDIM+oParsingData.oMotor.PAKZUS+oParsingData.oMotor.PAKLGE+oParsingData.oMotor.POLZAHL+oParsingData.oMotor.HEMOTOR+oParsingData.oMotor.VSDMOTOR),"-","");
    }

    oMotox.strProduct = oParsingData.strProduct;
    oMotox.ECSI_2KJ_TYPE = oParsingData.strProduct;
    
    // the frequency in the parsing results sets the net frequency of the motor; the gear attribut is the motor frequency
    oMotox.ECSI_FREQUENZ_VORAUSWAHL	= oParsingData.oMotor.strFrequency;
    
    if ( oParsingData.oGearType.EGBEZTYP === '-' )
        oMotox.ECSI_GETRIEBETYP = 'Stirnradgetriebe';
    else if ( oParsingData.oGearType.EGBEZTYP === 'F' )
        oMotox.ECSI_GETRIEBETYP = 'Flachgetriebe';
    else if ( ( oParsingData.oGearType.EGBEZTYP === 'K' ) || ( oParsingData.oGearType.EGBEZTYP === 'B' ) )
        oMotox.ECSI_GETRIEBETYP = 'Kegelradgetriebe';
    else if ( oParsingData.oGearType.EGBEZTYP === 'C' )
        oMotox.ECSI_GETRIEBETYP = 'Schneckenstirnradgetriebe';
    else if ( oParsingData.oGearType.EGBEZTYP === 'S' )
        oMotox.ECSI_GETRIEBETYP = 'Schneckengetriebe';
    
    oMotox.strMotorType = '1' + oMotox.strMotor.substring( 0, 2 );
    oMotox.strMotorSize	= oParsingData.oMotor.MOTDIM;
    oMotox.strPoles = oParsingData.oMotor.POLZAHL; 		// take care: motor poles may be overridden by a short description
    oMotox.bWelle2Polig = ( oMotox.strPoles === '2' );
    
    oMotox.GearData.WIBLNR=oParsingData.oMotor.WIBLNR;
    oMotox.GearData.WIBLAUSLG=oParsingData.oMotor.WIBLAUSLG;
    oMotox.GearData.MOT_SCHALTUNG_TMP_MOT_DATEN=oParsingData.oMotor.MOT_SCHALTUNG_TMP_MOT_DATEN;
    
    if(oParsingData.oMotor.VSDMOTOR=="V")
    {
        oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFIZIENZKL_TMP_MOT_DATEN;	
    }
    else if(ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        if(oParsingData.oMotor.strFrequency=="50")
        {
            oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE_1;	
        }
        else if(oParsingData.oMotor.strFrequency=="60")
        {
            if(oParsingData.oMotor.FREQUENZ_1=="60")
                oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE_1;	
            else if(oParsingData.oMotor.FREQUENZ_2=="60")
                oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE_2;	
        }
        else if(oParsingData.oMotor.strFrequency=="87")
        {
            if(oParsingData.oMotor.FREQUENZ_1=="87")
                oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE_1;	
        }
    
        oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oMotox.GearData.MOT_EFFIZIENZKL_KNZ.replace("_grade2","");
        oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oMotox.GearData.MOT_EFFIZIENZKL_KNZ.replace("_grade3","");
    }
    else
    {
        if(oParsingData.oMotor.strFrequency=="50")
        {
            oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE_1;	
        }
        else if(oParsingData.oMotor.strFrequency=="60")
        {
            if(oParsingData.oMotor.FREQUENZ_1=="60")
                oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE_1;	
            else if(oParsingData.oMotor.FREQUENZ_2=="60")
                oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE_2;	
        }
        else if(oParsingData.oMotor.strFrequency=="87")
        {
            if(oParsingData.oMotor.FREQUENZ_2=="87")
                oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE_2;	
            else if(oParsingData.oMotor.FREQUENZ2_1=="87")
                oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE2_1;	
            else if(oParsingData.oMotor.FREQUENZ2_2=="87")
                oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE2_2;	
        }
        else if(oParsingData.oMotor.strFrequency=="104")
        {
            if(oParsingData.oMotor.FREQUENZ2_1=="104")
                oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE2_1;	
            else if(oParsingData.oMotor.FREQUENZ2_2=="104")
                oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oParsingData.oMotor.EFFKLASSE2_2;	
        }
        
        oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oMotox.GearData.MOT_EFFIZIENZKL_KNZ.replace("_grade2","");
        oMotox.GearData.MOT_EFFIZIENZKL_KNZ = oMotox.GearData.MOT_EFFIZIENZKL_KNZ.replace("_grade3","");
    }	
    
    oMotox.strSelectedGearID = beautifyMLFB16( strBaseMLFB );
    
    
    //Originaldaten aus MOTFHT für Versandschaltung
    oMotox.GearData.ORIG_MOTFHT_MOTSHLT1=oParsingData.oMotor.MOTSHLT1;
    oMotox.GearData.ORIG_MOTFHT_MOTSHLT12=oParsingData.oMotor.MOTSHLT12;
    oMotox.GearData.ORIG_MOTFHT_MOTSHLT2=oParsingData.oMotor.MOTSHLT2;
    oMotox.GearData.ORIG_MOTFHT_MOTSHLT22=oParsingData.oMotor.MOTSHLT22;
    
    oMotox.GearData.ORIG_MOTFHT_MOTSHLT1_1=oParsingData.oMotor.MOTSHLT1_1;
	oMotox.GearData.ORIG_MOTFHT_MOTSHLT12_1=oParsingData.oMotor.MOTSHLT12_1;

    oMotox.GearData.ORIG_MOTFHT_FREQUENZ_1=oParsingData.oMotor.FREQUENZ_1;
    oMotox.GearData.ORIG_MOTFHT_FREQUENZ_2=oParsingData.oMotor.FREQUENZ_2;
    oMotox.GearData.ORIG_MOTFHT_FREQUENZ2_1=oParsingData.oMotor.FREQUENZ2_1;
    oMotox.GearData.ORIG_MOTFHT_FREQUENZ2_2=oParsingData.oMotor.FREQUENZ2_2;
    
    
    
    oMotox.GearData.ORIG_MOTFHT_MOTSPG_1=oParsingData.oMotor.MOTSPG_1;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG_2=oParsingData.oMotor.MOTSPG_2;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG_3=oParsingData.oMotor.MOTSPG_3;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG_4=oParsingData.oMotor.MOTSPG_4;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG_5=oParsingData.oMotor.MOTSPG_5;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG_6=oParsingData.oMotor.MOTSPG_6;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG_7=oParsingData.oMotor.MOTSPG_7;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG_8=oParsingData.oMotor.MOTSPG_8;
    
    oMotox.GearData.ORIG_MOTFHT_MOTSPG2_1=oParsingData.oMotor.MOTSPG2_1;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG2_2=oParsingData.oMotor.MOTSPG2_2;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG2_3=oParsingData.oMotor.MOTSPG2_3;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG2_4=oParsingData.oMotor.MOTSPG2_4;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG2_5=oParsingData.oMotor.MOTSPG2_5;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG2_6=oParsingData.oMotor.MOTSPG2_6;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG2_7=oParsingData.oMotor.MOTSPG2_7;
    oMotox.GearData.ORIG_MOTFHT_MOTSPG2_8=oParsingData.oMotor.MOTSPG2_8;
    
    
    //End Datum für Optionen
    oMotox.GearData.DATUM_ENDE='20201030';
    
    //Antriebsflanschdurchmnesser bestimmen
    var strMOABFLDM;
    
    var strGetriebe_Bez = oParsingData.oGearType.EGBEZTYP+oParsingData.oGearType.EGBEZUEBS+oParsingData.oGearType.EGBEZDIM+oParsingData.oGearType.ZGBEZUEBS+oParsingData.oGearType.ZGBEZDIM+oParsingData.oGearType.ZGBEZEI;
    strGetriebe_Bez = replace(strGetriebe_Bez, "-", "");
    
    var strSelect = "SELECT EGANFLDM FROM CD_GETRIEBE_BEZEICHNUNGEN WHERE ";
    strSelect = strSelect + "GETRIEBE_BEZ = '"+strGetriebe_Bez+"' ";
    
    strSelect = strSelect + "AND CD_GETRIEBE_BEZEICHNUNGEN.REGION = 'EUR' ";
    
    var strDBResult = 'PARSER_GETRIEBEDATA';
    if ( dbselect( '2KJ_DB', strSelect, strDBResult ) > 0 )
    {
        strMOABFLDM = dbgetstring( strDBResult, 'EGANFLDM' );
    }
    else
    {
        strMOABFLDM = "";
    }
    
    
    // pegasus attributes
    if("EGBEZTYP"      in oParsingData.oGearType ){oMotox.GearData.EGBEZTYP     = oParsingData.oGearType.EGBEZTYP;}
    if("EGBEZUEBS"      in oParsingData.oGearType){oMotox.GearData.EGBEZUEBS    = oParsingData.oGearType.EGBEZUEBS;}
    if("EGBEZBRA"       in oParsingData.oGearType){oMotox.GearData.EGBEZBRA     = oParsingData.oGearType.EGBEZBRA;}
    if("ANWTYP"         in oParsingData.oGearType){oMotox.GearData.ANWTYP       = oParsingData.oGearType.ANWTYP;}
    if("EGBEZDIM"       in oParsingData.oGearType){oMotox.GearData.EGBEZDIM     = oParsingData.oGearType.EGBEZDIM;}
    if("EGBEZEI"        in oParsingData.oGearType){oMotox.GearData.EGBEZEI      = oParsingData.oGearType.EGBEZEI;}
    if("ZGBEZUEBS"      in oParsingData.oGearType){oMotox.GearData.ZGBEZUEBS    = oParsingData.oGearType.ZGBEZUEBS;}
    if("ZGBEZDIM"       in oParsingData.oGearType){oMotox.GearData.ZGBEZDIM     = oParsingData.oGearType.ZGBEZDIM;}
    if("ZGBEZEI"        in oParsingData.oGearType){oMotox.GearData.ZGBEZEI      = oParsingData.oGearType.ZGBEZEI;}
    
    if("oShaft"         in oParsingData){
        oMotox.GearData.EGBEZAWTYP   = oParsingData.oShaft.EGBEZAWTYP;
        oMotox.GearData.EGBEZWNV     = oParsingData.oShaft.EGBEZWNV;
        oMotox.GearData.EGTYP        = oParsingData.oShaft.EGTYP;
    }
    
    if("PAKLGE"         in oParsingData.oMotor   ){oMotox.GearData.PAKLGE       = oParsingData.oMotor.PAKLGE};
    if("EGTYP"          in oMotox                ){oMotox.GearData.BEZEICHNUNG  = oMotox.EGTYP + '-' + oMotox.strMotor;}
    if("MOTDIM"         in oParsingData.oMotor   ){oMotox.GearData.MOTDIM       = oParsingData.oMotor.MOTDIM;}
    if("MOTDIM"         in oParsingData.oMotor   ){oMotox.GearData.MOTDIM_IEC       = oParsingData.oMotor.MOTDIM;}
    if("SCHALTUNG_S"    in oParsingData.oMotor   ){oMotox.GearData.MOSHLT       = oParsingData.oMotor.SCHALTUNG_S;}
    if("PAKLGE"         in oParsingData.oMotor   ){oMotox.GearData.PAKLGE       = oParsingData.oMotor.PAKLGE;}
    if("MOTWK"          in oParsingData.oMotor   ){oMotox.oConfig.WAERMEKLASSE  = oParsingData.oMotor.MOTWK;}
    
    oMotox.GearData.FREQUENZ = oParsingData.oMotor.strFrequency
    oMotox.GearData.EGANFLDM = strMOABFLDM;
    oMotox.GearData.MOABFLDM = strMOABFLDM;
    oMotox.GearData.MOTTYP = oMotox.strMotor.substring( 0, 2 );
    oMotox.GearData.MOT_BZ_LANG = oMotox.strMotor;
    oMotox.GearData.MOTBEZ = oMotox.strMotor;
    
    //Zusatzdaten, um die MLFB des Motors zu bestimmen
    if("FREQUENZ"       in oParsingData.oMotor){oMotox.GearData.MOTFHT_FREQUENZ     = oParsingData.oMotor.FREQUENZ;}
    if("FREQUENZ2"      in oParsingData.oMotor){oMotox.GearData.MOTFHT_FREQUENZ2    = oParsingData.oMotor.FREQUENZ2;}
    if("LEISTUNG1"      in oParsingData.oMotor){oMotox.GearData.MOTFHT_LEISTUNG1    = oParsingData.oMotor.LEISTUNG1;}
    if("LEISTUNG4"      in oParsingData.oMotor){oMotox.GearData.MOTFHT_LEISTUNG4    = oParsingData.oMotor.LEISTUNG4;}
    if("LEISTUNG21"     in oParsingData.oMotor){oMotox.GearData.MOTFHT_LEISTUNG21   = oParsingData.oMotor.LEISTUNG21;}
    if("LEISTUNG24"     in oParsingData.oMotor){oMotox.GearData.MOTFHT_LEISTUNG24   = oParsingData.oMotor.LEISTUNG24;}
    if("EFFKLASSE"      in oParsingData.oMotor){oMotox.GearData.MOTFHT_EFFKLASSE    = oParsingData.oMotor.EFFKLASSE;}
    if("HEMOTOR"        in oParsingData.oMotor){oMotox.GearData.MOTFHT_HEMOTOR      = oParsingData.oMotor.HEMOTOR;}
    if("MOTELAUSF"      in oParsingData.oMotor){oMotox.GearData.MOTELAUSF           = oParsingData.oMotor.MOTELAUSF;}
    oMotox.GearData.SPEC_STRING= oParsingData.oMotor.SpecString;
    
    if(oParsingData.oGearType.ANWTYP=="KleinSchnecke")
        oMotox.GearData.S09="1";
    else
        oMotox.GearData.S09="0";
    
    oMotox.GearData.VSDMOTOR=oParsingData.oMotor.VSDMOTOR;
    
    if(oMotox.GearData.VSDMOTOR=="V")
        oMotox.oConfig.ECSI_VSD_MOTOREN="VSD_4000";
        
    if(oMotox.GearData.EGBEZBRA == "H")
        oMotox.oConfig.ECSI_BRANCHENANTRIEBE="HAENGEBAHN";
    
    oMotox.GearData.M3 = oParsingData.oMotor.M3;
    if(parseInt(oMotox.GearData.MOTDIM) >= 225){
        oMotox.GearData.GM3 = "1";
    }
    else{
        oMotox.GearData.GM3 = "0";
    }
    oMotox.GearData.BRE_DEFAULT = oParsingData.oMotor.BRE_DEFAULT;
    if("oFastening" in oParsingData){oMotox.oConfig.FIGUR = oParsingData.oFastening.EGABDMSTFIG;}
    
    
    // technical data
    _adjustTechnicalData( oMotox, oParsingData, strRegion );
    
    //--------------------------------------------------------------------------------------------------------
    // configuration
    //--------------------------------------------------------------------------------------------------------	
    if(ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
    
        if(oParsingData.oMotor.strFrequency == "50")
            oMotox.oConfig.BETRIEBSART = oParsingData.oMotor.MOTBART11;
        else if(oParsingData.oMotor.strFrequency == "60")
        {
            if(oParsingData.oMotor.MOTBART12 == "-")
                oMotox.oConfig.BETRIEBSART = oParsingData.oMotor.MOTBART11;
            else
                oMotox.oConfig.BETRIEBSART = oParsingData.oMotor.MOTBART12;
        }
        else if(oParsingData.oMotor.strFrequency == "87")
            oMotox.oConfig.BETRIEBSART = oParsingData.oMotor.MOTBART11;
    }
    else if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
	{
		oMotox.oConfig.BETRIEBSART = 'INV.DUTY';
	}
    else
    {
    
        if(oParsingData.oMotor.strFrequency == "50")
            oMotox.oConfig.BETRIEBSART = oParsingData.oMotor.MOTBART11;
        else if(oParsingData.oMotor.strFrequency == "60")
        {
            if(oParsingData.oMotor.MOTBART12 == "-")
                oMotox.oConfig.BETRIEBSART = oParsingData.oMotor.MOTBART11;
            else
                oMotox.oConfig.BETRIEBSART = oParsingData.oMotor.MOTBART12;
        }
        else if(oParsingData.oMotor.strFrequency == "87")
            oMotox.oConfig.BETRIEBSART = oParsingData.oMotor.MOTBART21;
        else if(oParsingData.oMotor.strFrequency == "104")
            oMotox.oConfig.BETRIEBSART = oParsingData.oMotor.MOTBART22;
    }
    
    oMotox.oConfig.ECSI_MOTORSPANNUNG_SPGTOL_KA = oParsingData.oMotor.MLFB_2KJ_13_KA_SPGTOL;
    oMotox.oConfig.ECSI_MOTORSPANNUNG_SPG_KA = oParsingData.oMotor.MLFB_2KJ_13_KA;
    oMotox.oConfig.ECSI_MOTORSPANNUNG_BART_KA = oParsingData.oMotor.MLFB_2KJ_BART_KA;
    oMotox.oConfig.ECSI_MOTORSPANNUNG_P_KA = oParsingData.oMotor.MLFB_2KJ_P_KA;
    
    //Spannung zusammenbauen
    
    var outputSpannung="";
    
    var strSpannung1 = oParsingData.oMotor.MOTSPG_1;
    var strSpannung2 = oParsingData.oMotor.MOTSPG_3;
    var strSpannung3 = oParsingData.oMotor.MOTSPG_5;
    var strSpannung4 = oParsingData.oMotor.MOTSPG_7;
    
    var strSpannung21 = oParsingData.oMotor.MOTSPG2_1;
    var strSpannung22 = oParsingData.oMotor.MOTSPG2_3;
    var strSpannung23 = oParsingData.oMotor.MOTSPG2_5;
    var strSpannung24 = oParsingData.oMotor.MOTSPG2_7;
    
    var strSchaltung11 = oParsingData.oMotor.MOTSHLT1_1;
    var strSchaltung12 = oParsingData.oMotor.MOTSHLT12_1;
    var strSchaltung21 = oParsingData.oMotor.MOTSHLT2_1;
    var strSchaltung22 = oParsingData.oMotor.MOTSHLT22_1;
    
    var teilschaltung11a="";
    var teilschaltung11b="";
    
    var teilschaltung12a="";
    var teilschaltung12b="";
    
    var teilschaltung21a="";
    var teilschaltung21b="";
    
    var teilschaltung22a="";
    var teilschaltung22b="";
    
	
	if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
	{
		outputSpannung = strSpannung1+ " V"+strSchaltung11+ " / " + strSpannung3+ " V"+strSchaltung12;
	}
	else
	{
		var i = find(strSchaltung11, "/");
		if(i > -1)
		{
			teilschaltung11a = strSchaltung11.left(i-1);
			teilschaltung11b = strSchaltung11.right(strSchaltung11.length-i);
		}
		
		var i = find(strSchaltung12, "/");
		if(i > -1)
		{
			teilschaltung12a = strSchaltung12.left(i-1);
			teilschaltung12b = strSchaltung12.right(strSchaltung12.length-i);
		}
		
		var i = find(strSchaltung21, "/");
		if(i > -1)
		{
			teilschaltung21a = strSchaltung21.left(i-1);
			teilschaltung21b = strSchaltung21.right(strSchaltung21.length-i);
		}
		
		var i = find(strSchaltung22, "/");
		if(i > -1)
		{
			teilschaltung22a = strSchaltung22.left(i-1);
			teilschaltung22b = strSchaltung22.right(strSchaltung22.length-i);
		}
		
		if(oParsingData.oMotor.strFrequency == "50")
		{
			if(oParsingData.oMotor.FREQUENZ_1 == "50")
			{
				if(strSpannung2 != "-")
				{
					outputSpannung = strSpannung1+ " V"+teilschaltung11a+ " / " + strSpannung2 + " V"+teilschaltung11b;
				}
				else	
					outputSpannung = strSpannung1+ " V"+strSchaltung11;
			}
		}
		else if(oParsingData.oMotor.strFrequency == "60")
		{
			if(oParsingData.oMotor.FREQUENZ_1 == "60")
			{
				if(strSpannung2 != "-")
				{
					outputSpannung = strSpannung1+ " V"+teilschaltung11a+ " / " + strSpannung2 + " V"+teilschaltung11b;
				}
				else	
					outputSpannung = strSpannung1+ " V"+strSchaltung11;
			}
			else if(oParsingData.oMotor.FREQUENZ_2 == "60")
			{
				if(strSpannung4 != "-")
				{
					outputSpannung = strSpannung3+ " V"+teilschaltung12a+ " / " + strSpannung4 + " V"+teilschaltung12b;
				}
				else	
					outputSpannung = strSpannung3+ " V"+strSchaltung12;
			}
		}
		else if(oParsingData.oMotor.strFrequency == "87")
		{
			if(oParsingData.oMotor.FREQUENZ_2 == "87")
			{
				if(strSpannung4 != "-")
				{
					outputSpannung = strSpannung3+ " V"+teilschaltung12a+ " / " + strSpannung4 + " V"+teilschaltung12b;
				}
				else	
					outputSpannung = strSpannung3+ " V"+strSchaltung12;
			}
			else if(oParsingData.oMotor.FREQUENZ2_1 == "87")
			{
				if(strSpannung22 != "-")
				{
					outputSpannung = strSpannung21+ " V"+teilschaltung21a+ " / " + strSpannung22 + " V"+teilschaltung21b;
				}
				else	
					outputSpannung = strSpannung21+ " V"+strSchaltung21;
			}
		}
		else if(oParsingData.oMotor.strFrequency == "104")
		{
			if(oParsingData.oMotor.FREQUENZ2_2 == "104")
			{
				if(strSpannung24 != "-")
				{
					outputSpannung = strSpannung23+ " V"+teilschaltung22a+ " / " + strSpannung24 + " V"+teilschaltung22b;
				}
				else	
					outputSpannung = strSpannung23+ " V"+strSchaltung22;
			}
		}
	}

    oMotox.oConfig.MOTORSPANNUNG = outputSpannung;
    oMotox.oConfig.WIBLAUSLG = oParsingData.oMotor.WIBLAUSLG;
    
    //Feststellen, ob erhöhte Leistung vorliegt, über DTK Tabellen
    var strERHL_Select="";
    strERHL_Select = "SELECT DISTINCT MOT_LEISTUNG_ERH_TF FROM TMP_MOT_DATEN WHERE ";
    strERHL_Select = strERHL_Select + "MOT_FREQUENZ='"+oParsingData.oMotor.strFrequency+"' AND ";
    strERHL_Select = strERHL_Select + "MOT_SPANNUNG_UI='"+outputSpannung+"' AND ";
    strERHL_Select = strERHL_Select + "MOT_BETRIEBSART='"+oParsingData.oMotor.MLFB_2KJ_BART_KA+"' AND ";
    
    strERHL_Select = strERHL_Select + "MLFB_10='"+oParsingData.oMotor.MLFB_2KJ_10+"' AND ";
    strERHL_Select = strERHL_Select + "MLFB_13='"+oParsingData.oMotor.MLFB_2KJ_13+"' AND ";
    strERHL_Select = strERHL_Select + "MLFB_13_KA='"+oParsingData.oMotor.MLFB_2KJ_13_KA+"' AND ";
    strERHL_Select = strERHL_Select + "MOT_EL_AUSFUEHRUNG='"+oParsingData.oMotor.MOTELAUSF+"' AND ";
    strERHL_Select = strERHL_Select + "MOT_EFFIZIENZKL_KNZ='"+oMotox.GearData.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strERHL_Select = strERHL_Select + "MOT_LEISTUNG='"+oMotox.GearData.LEISTUNG+"' ";
    var aResultERHL_Leistung = Object.fromDatabase( '2KJ_DB', strERHL_Select );	
    if(aResultERHL_Leistung.length == 1)
    {
        if(aResultERHL_Leistung[0].MOT_LEISTUNG_ERH_TF == "Nein")
            oMotox.oConfig.ERHOEHTE_LEISTUNG_OPTION = "F";
        else if(aResultERHL_Leistung[0].MOT_LEISTUNG_ERH_TF == "Ja")
            oMotox.oConfig.ERHOEHTE_LEISTUNG_OPTION = "T";
    }
    else{
        logtraceln("Fehler Bestimmung erhöhte Leistung!");
    }
        //Abtriebswellenart setzen
    var strWelle = null;
    var strWelle_WELLE_O_PF = null;
    var strWelle_EGABAUSF   = null;
    var strWelle_WELLE_BDS  = null;
    
    oMotox.oConfig.ABTRIEBSWELLENMASS = null;
    
    if("oShaft" in oParsingData){
        strWelle = oParsingData.oShaft.EGABKDBEZ;
        strWelle_EGABAUSF = oParsingData.oShaft.EGABAUSF;
        strWelle_WELLE_BDS = oParsingData.oShaft.WELLE_BDS;
        strWelle_WELLE_O_PF =oParsingData.oShaft.WELLE_O_PF;
        oMotox.oConfig.ABTRIEBSWELLENMASS	= replace(oParsingData.oShaft.EGABW,'"','ZOLL');
    }

    if(strWelle){
        strWelle = strWelle.replace(/[^a-zA-Z]/g, '');
    }
    
    if(strWelle=="H" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle";
    
    if(strWelle=="HF" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle_mit_SIMOLOC";
    
    if(strWelle=="HM" && strWelle_EGABAUSF=="VLplus" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle";
    
    if(strWelle=="HS" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle_mit_Schrumpfscheibe";
        
    if(strWelle=="HX" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle_Edelstahl";
        
    if(strWelle=="N" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle_mit_Vielkeilverzahnung";
        
    if(strWelle=="V" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_mit_Passfeder";
        
    if(strWelle=="VC" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_fuer_Kuehlturmantriebe";
        
    if(strWelle=="VD" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="1" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_beidseitig";
        
    if(strWelle=="VDG" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="1" && strWelle_WELLE_O_PF=="1")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_beidseitig_ohne_Passfeder";
        
    if(strWelle=="VE" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Einsteckwelle";
    
    if(strWelle=="VG" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="1")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_ohne_Passfeder";
        
    if(strWelle=="VM" && (strWelle_EGABAUSF=="VLplus" || strWelle_EGABAUSF=="XLplus") && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_mit_Passfeder";
    
    if(strWelle=="W" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Welle_fuer_SIP";
    
    if("oFastening" in oParsingData){
        oMotox.oConfig.BEFESTIGUNGSART = oParsingData.oFastening.EGBEZBEF;
    }
    var strFlangeSD = getSDFromGroup( oShortDescriptions, 'FLANSCHDURCHMESSER' );
    // for an empty short description, we get the default for this gear, if the fastening fits
    if("oShaft" in oParsingData && "oFastening" in oParsingData ){
        var strFlangeDiameter = getFlangeDiameter( strFlangeSD, oParsingData.oGearType.EGBEZTYP, oParsingData.oGearType.EGBEZUEBS, oParsingData.oShaft.EGBEZBRA,oParsingData.oGearType.EGBEZDIM, oParsingData.oGearType.EGBEZEI, oParsingData.oFastening.EGBEZBEF );
    }
    if ( strFlangeDiameter !== '' ){
        oMotox.oConfig.BEFESTIGUNGSMASS = strFlangeDiameter;
    }
    if("oShaft" in oParsingData && "oFastening" in oParsingData ){
        var strFlangeFigur=getFlangeFigur( strFlangeSD, oParsingData.oGearType.EGBEZTYP, oParsingData.oGearType.EGBEZUEBS, oParsingData.oShaft.EGBEZBRA,oParsingData.oGearType.EGBEZDIM, oParsingData.oGearType.EGBEZEI, oParsingData.oFastening.EGBEZBEF );
    }
    if ( strFlangeFigur !== '' )
        oMotox.oConfig.FIGUR = strFlangeFigur;
    
    //Drive Train
    oMotox.oConfig.ISDRIVETRAIN_OPTION = "";	
    
    _adjustGearedMotorWithShortDescriptions( oShortDescriptions, oMotox, oParsingData, strRegion  );	
    
    /*
    if ( oMotox.oConfig.bWithEncoder )
    {
        // the type of standard encoder protection (the one without short description!) differs with some motor attributes
        var strSpecString =  oParsingData.oMotor.MOTELAUSF;
        var aProtection = Product.MOTOX.Config.Encoder.getCombo_GeberMechSchutz( oMotox.oConfig, oMotox, {strProduct: oParsingData.strProduct}, strRegion );
        if ( !Base.hasConfigurationOption( aProtection, oMotox.oConfig.strEncoderMechanicalProtection ) )
        {
            if ( ( oMotox.oConfig.strEncoderMechanicalProtection === 'SCHUTZBLECH' ) && Base.hasConfigurationOption( aProtection, 'SCHUTZDACH' ) )
                oMotox.oConfig.strEncoderMechanicalProtection = 'SCHUTZDACH';
            else if ( ( oMotox.oConfig.strEncoderMechanicalProtection === 'SCHUTZDACH' ) && Base.hasConfigurationOption( aProtection, 'SCHUTZBLECH' ) )
                oMotox.oConfig.strEncoderMechanicalProtection = 'SCHUTZBLECH';
        }
    }
    */
    
    // synchronize gear brake data with brake data from configuration object
    if ( oMotox.oConfig.MIT_BREMSE == "T" )
    {
        var oData = splitSelectedBrake( oMotox.oConfig.BREMSENTYP );
        if ( oData )
        {
            oMotox.BrakeData.BREART = oData.BREART;
            oMotox.BrakeData.BRENENMO = oData.BRENENMO;
            oMotox.BrakeData.BREREDMO = oData.BREREDMO;
            // it would be nonsense to set brake power or voltage without a valid brake type
            oMotox.BrakeData.BRELSTG = getBRELSTG( oMotox );
            if ( 'C20' in oShortDescriptions && (oMotox.strProduct != "GETRIEBEMOTOR.G110M" && oMotox.strProduct != "GETRIEBEMOTOR.G110M_SIP"))
                oMotox.BrakeData.BRESHLT = 'am Klemmbrett';
            else // if ( 'C21' in oShortDescriptions ) // is also the default
                oMotox.BrakeData.BRESHLT = 'nicht am Klemmbrett';
        }
    }
    
    oMotox.ECSI_POLZAHL = oParsingData.oMotor.POLZAHL; 		// motor poles may be overridden by a short description
    
    	
	// Sonderlogik 
	if(oMotox.oConfig.ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION == "T")
	{
		if(oMotox.GearData.EGBEZTYP=="B" || oMotox.GearData.EGBEZTYP=="K")
		{
			if(oMotox.oConfig.BAUFORM=="M4")
			{
				if(!oMotox.oConfig.OELSTANDSKONTROLLE || oMotox.oConfig.OELSTANDSKONTROLLE=="ohne" || oMotox.oConfig.OELSTANDSKONTROLLE=="-")
				{
					oMotox.oConfig.ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL= "Y_20";
				}
				else
				{
					oMotox.oConfig.ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL= "Y_20-0";
				}
			}
			else
			{
					oMotox.oConfig.ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL= "Y_20";
			}
		}
		else
		{
			oMotox.oConfig.ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL= "X_20";
		}
	}
	
    return( oMotox );
}

function buildGear_ADAPTER( oParsingData, oShortDescriptions, strBaseMLFB, strRegion )
{
    var MMSystem="SI";
    
    var oMotox = {};
    
    oMotox.GearData = {};
    oMotox.oConfig = {};
    oMotox.BrakeData = {};
    
    //--------------------------------------------------------------------------------------------------------
    // base geared motor data
    //--------------------------------------------------------------------------------------------------------
    
    // base gear and motor stuff
    if("oShaft" in oParsingData){
        oMotox.strGear = oParsingData.oShaft.EGTYP;
    }
    oMotox.EGTYP = oParsingData.oGearType.EGTYP;
    oMotox.strProduct = oParsingData.strProduct;
    oMotox.ECSI_2KJ_TYPE = oParsingData.strProduct;
    
    // the frequency in the parsing results sets the net frequenc<y of the motor; the gear attribut is the motor frequency
    oMotox.strFrequency	= '';	
    oMotox.strAdapter = oParsingData.oMotor.AV_TYP_KZ;
    oMotox.strDriveGroup = oParsingData.oMotor.AV_BEZ;
    oMotox.strShaftHeight = oParsingData.oMotor.AV_GROESSE_KZ;
    
    if ( oParsingData.oGearType.EGBEZTYP === '-' )
        oMotox.ECSI_GETRIEBETYP = 'Stirnradgetriebe';
    else if ( oParsingData.oGearType.EGBEZTYP === 'F' )
        oMotox.ECSI_GETRIEBETYP = 'Flachgetriebe';
    else if ( ( oParsingData.oGearType.EGBEZTYP === 'K' ) || ( oParsingData.oGearType.EGBEZTYP === 'B' ) )
        oMotox.ECSI_GETRIEBETYP = 'Kegelradgetriebe';
    else if ( oParsingData.oGearType.EGBEZTYP === 'C' )
        oMotox.ECSI_GETRIEBETYP = 'Schneckenstirnradgetriebe';
    else if ( oParsingData.oGearType.EGBEZTYP === 'S' )
        oMotox.ECSI_GETRIEBETYP = 'Schneckengetriebe';

    if ( 'N30' in oShortDescriptions )
    {
        // specification EAC
        oMotox.strSpecification = 'EAC';
    }
    else 
        oMotox.strSpecification = 'CE';
    
    var strGA_Bez;
    if(oParsingData.oMotor.AV_RLSP == '1' && (oParsingData.oMotor.AV_TYP_KZ == "K2" || oParsingData.oMotor.AV_TYP_KZ == "K3"))
    {
        strGA_Bez = oParsingData.oMotor.AV_TYP_KZ+"X-"+oParsingData.oMotor.AVTYPDIM;
    }
    else
        strGA_Bez = oParsingData.oMotor.AV_TYP_KZ+"-"+oParsingData.oMotor.AVTYPDIM;
    
    oMotox.strMotorType = '';
    oMotox.strMotor = strGA_Bez;
    oMotox.strMotorSize	= oParsingData.oMotor.AVTYPDIM;
    oMotox.strPoles = '';
    oMotox.bWelle2Polig = '';
    oParsingData.oMotor.SUCHTYP = strGA_Bez;
    
    oMotox.strEfficiencyClass = '';
    
    oMotox.strSelectedGearID = beautifyMLFB16( strBaseMLFB );
    
    
    var strGetriebe_Bez = oParsingData.oGearType.EGBEZTYP+oParsingData.oGearType.EGBEZUEBS+oParsingData.oGearType.EGBEZDIM;
    strGetriebe_Bez = replace(strGetriebe_Bez, "-", "");
    
    var strAVABFLD;
	if(oParsingData.oGearType.ZGBEZUEBS != "-")
	{
		var strSelect = "SELECT DISTINCT EGANFLDM FROM EGANBEF WHERE ";
		strSelect = strSelect + "EGANBEF.EGBEZTYP = '-' AND ";
		strSelect = strSelect + "EGANBEF.EGBEZUEBS = '"+oParsingData.oGearType.ZGBEZUEBS+"' AND ";
		strSelect = strSelect + "EGANBEF.EGBEZBRA = '-' AND ";
		strSelect = strSelect + "EGANBEF.EGBEZDIM = '"+oParsingData.oGearType.ZGBEZDIM+"' AND ";
		strSelect = strSelect + "EGANBEF.EGBEZEI = '"+oParsingData.oGearType.ZGBEZEI+"' ";
		
		var strDBResult = 'PARSER_GETRIEBEDATA_AVMOKDBEZ2';
		var strAVMOKDBEZ;
		
		if ( dbselect( '2KJ_DB', strSelect, strDBResult ) > 0 )
		{
			strAVABFLD = dbgetstring( strDBResult, 'EGANFLDM' );
		}
		else
		{
			strAVABFLD = "";
		}
	}
	else
	{
		var strSelect = "SELECT DISTINCT EGANFLDM FROM EGANBEF WHERE ";
		strSelect = strSelect + "EGANBEF.EGBEZTYP = '"+oParsingData.oGearType.EGBEZTYP+"' AND ";
		strSelect = strSelect + "EGANBEF.EGBEZUEBS = '"+oParsingData.oGearType.EGBEZUEBS+"' AND ";
		strSelect = strSelect + "EGANBEF.EGBEZBRA = '"+oParsingData.oGearType.EGBEZBRA+"' AND ";
		strSelect = strSelect + "EGANBEF.EGBEZDIM = '"+oParsingData.oGearType.EGBEZDIM+"' AND ";
		strSelect = strSelect + "EGANBEF.EGBEZEI = '"+oParsingData.oGearType.EGBEZEI+"' ";
		
		var strDBResult = 'PARSER_GETRIEBEDATA_AVMOKDBEZ';
		var strAVMOKDBEZ;
		
		if ( dbselect( '2KJ_DB', strSelect, strDBResult ) > 0 )
		{
			strAVABFLD = dbgetstring( strDBResult, 'EGANFLDM' );
		}
		else
		{
			strAVABFLD = "";
		}
	}

	
    var strSelect = "SELECT DISTINCT AVANSSAR, AVABFLD FROM CD_AVEINHEITEN WHERE ";
    strSelect = strSelect + "AV_BEZ = '"+oParsingData.oMotor.AV_BEZ+"' AND ";
    strSelect = strSelect + "AVABFLD = '"+strAVABFLD+"' ";
    
    /*
    if(strRegion == "CHINA")
        strSelect = strSelect + "AND CD_AVEINHEITEN.REGION = 'CHINA' ";
    else if(strRegion == "USA")
        strSelect = strSelect + "AND CD_AVEINHEITEN.REGION = 'USA' ";
    else
        strSelect = strSelect + "AND CD_AVEINHEITEN.REGION = 'EUR' ";
    */
    
    var strAVANSSAR;
    var strDBResult = 'PARSER_GETRIEBEDATA';
    if ( dbselect( '2KJ_DB', strSelect, strDBResult ) > 0 )
    {
        strAVANSSAR = dbgetstring( strDBResult, 'AVANSSAR' );
    }
    else
    {
        strAVANSSAR = "";
    }
    
    
    // pegasus attributes
    oMotox.GearData.EGBEZTYP = oParsingData.oGearType.EGBEZTYP;
    oMotox.GearData.EGBEZUEBS = oParsingData.oGearType.EGBEZUEBS;
    oMotox.GearData.EGBEZBRA = oParsingData.oGearType.EGBEZBRA;
    oMotox.GearData.ANWTYP = oParsingData.oGearType.ANWTYP;
    oMotox.GearData.EGBEZDIM = oParsingData.oGearType.EGBEZDIM;
    oMotox.GearData.EGBEZEI = oParsingData.oGearType.EGBEZEI;
    oMotox.GearData.ZGBEZUEBS = oParsingData.oGearType.ZGBEZUEBS;
    oMotox.GearData.ZGBEZDIM = oParsingData.oGearType.ZGBEZDIM;
    oMotox.GearData.ZGBEZEI = oParsingData.oGearType.ZGBEZEI;
    
    if("oShaft" in oParsingData){
        oMotox.GearData.EGBEZAWTYP = oParsingData.oShaft.EGBEZAWTYP;
        oMotox.GearData.EGBEZWNV = oParsingData.oShaft.EGBEZWNV;
    }
    
    oMotox.GearData.EGTYP = oParsingData.oGearType.EGTYP;
    oMotox.GearData.BEZEICHNUNG = oParsingData.oGearType.EGTYP + '-' + strGA_Bez;
    oMotox.GearData.MOTDIM = oParsingData.oMotor.AVTYPDIM;
    oMotox.GearData.MOTDIM_IEC = oParsingData.oMotor.AVTYPDIM_IEC;
    oMotox.GearData.MOTBEZ = strGA_Bez;
    oMotox.GearData.MOTTYP = oParsingData.oMotor.AV_TYP_KZ;
    oMotox.GearData.MOSHLT = '';
    oMotox.GearData.MOABSSAR = strAVANSSAR;
    oMotox.GearData.MOABFLDM = strAVABFLD;
    oMotox.GearData.PAKLGE = '';
    
    if("oFastening" in oParsingData ){
        oMotox.oConfig.strFigur = oParsingData.oFastening.EGABDMSTFIG;
    }

    oMotox.ANTRIEBSGRUPPE_TYP = oParsingData.oMotor.AV_TYP_KZ;
    oMotox.ANTRIEBSGRUPPE_SIZE = oParsingData.oMotor.AV_GROESSE_KZ;
    

    var oTextData = {};
    if("Y00" in oShortDescriptions){
        oTextData = decodeY00( getFreetextValue( oShortDescriptions.Y00.freetext ) );
    }

    //Daten aus Klartextangaben in Object schreiben
    if("strAdapterAntriebsdrehzahl" in oTextData){
        oMotox.dInputSpeed = oTextData.strAdapterAntriebsdrehzahl;
    }
    else{
        oMotox.dInputSpeed = "1400";
    }
    if(oParsingData.oGearType.ANWTYP=="KleinSchnecke"){
        oMotox.GearData.S09="1";
    }
    else{
        oMotox.GearData.S09="0";
    }
    /*
    var oAdapterleistung = createEmptyTechval();
    if(oTextData.strAdapterAntriebsleistung != null)
        oAdapterleistung = checkObject( null, 'LEISTUNG', replace( oTextData.strAdapterAntriebsleistung, ',', '.' ), 'kW', false );
    else
        oAdapterleistung = checkObject( null, 'LEISTUNG', replace( '1.5', ',', '.' ), 'kW', false );
        
    var strAdapterLeistung;
    if(MMSystem=="SI")
        strAdapterLeistung = getValueFormatted (oAdapterleistung, "kW", false, false);
    else	
        strAdapterLeistung = getValueFormatted (oAdapterleistung, "hp", false, false);
    
    oMotox.strMotorPowerGA = strAdapterLeistung;
    */
    
    //Daten aus Klartextangaben in Object schreiben
    if("strAdapterAntriebsleistung" in oTextData ){
        oMotox.strMotorPowerGA = oTextData.strAdapterAntriebsleistung;
    }
    else{
        oMotox.strMotorPowerGA = "1.5";
    }
    
    var dRutschmoment;
    if("strAdapterRutschkupplung_Drehmomenteingestellt" in oTextData){ 
        dRutschmoment =  parseFloat(oTextData.strAdapterRutschkupplung_Drehmomenteingestellt);
    }
    oMotox.oConfig.oDriveGroupUserSlipTorque =  checkObject(null, 'DREHMOMENT',dRutschmoment, 'Nm', false );
    
    //ATEX Angaben aus Klartext
    /*
    if(oTextData.strAdapterMaxAntriebsleistungATEX != null)
        oMotox.oAtex.oMotorPower = checkObject( null, 'LEISTUNG', replace( oTextData.strAdapterMaxAntriebsleistungATEX, ',', '.' ), 'kW', false );
    else
        oMotox.oAtex.oMotorPower = checkObject( null, 'LEISTUNG', '1.5', 'kW', false );
        
    if(oTextData.strAdapterMaxAntriebsDrehzahlATEX != null)
        oMotox.oAtex.oMaxDrehzahl = checkObject( null, 'DREHZAHL', replace( oTextData.strAdapterMaxAntriebsDrehzahlATEX, ',', '.' ), '1/min', false );
    else
        oMotox.oAtex.oMaxDrehzahl = checkObject( null, 'DREHZAHL', '1500', '1/min', false );
        
    if(oTextData.strAdapterMinAntriebsDrehzahlATEX != null)
        oMotox.oAtex.oMinDrehzahl = checkObject( null, 'DREHZAHL', replace( oTextData.strAdapterMinAntriebsDrehzahlATEX, ',', '.' ), '1/min', false );
    else
        oMotox.oAtex.oMinDrehzahl = checkObject( null, 'DREHZAHL', '1500', '1/min', false );
    */
    
    if("oFastening" in oParsingData){
        oMotox.oConfig.FIGUR = oParsingData.oFastening.EGABDMSTFIG;
    }
    // technical data
    _adjustTechnicalData_Adapter( oMotox, oParsingData, oShortDescriptions );
    
    //--------------------------------------------------------------------------------------------------------
    // configuration
    //--------------------------------------------------------------------------------------------------------	
    oMotox.oConfig.strOperatingMode = '';
    oMotox.oConfig.strVoltage = '';
    
    var strWelle_EGABAUSF  = null;
    var strWelle_WELLE_BDS = null;
    var strWelle_WELLE_O_PF= null;

    if("oShaft" in oParsingData){
        oMotox.oConfig.ABTRIEBSWELLENMASS	= replace(oParsingData.oShaft.EGABW,'"','ZOLL');
        //Abtriebswellenart setzen
        var strWelle = oParsingData.oShaft.EGABKDBEZ;
    
        if(strWelle){
            strWelle = strWelle.replace(/[^a-zA-Z]/g, '');
        }
        strWelle_EGABAUSF  = oParsingData.oShaft.EGABAUSF;
        strWelle_WELLE_BDS = oParsingData.oShaft.WELLE_BDS;
        strWelle_WELLE_O_PF =oParsingData.oShaft.WELLE_O_PF;
    }

    if(strWelle=="H" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle";
    
    if(strWelle=="HF" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle_mit_SIMOLOC";
    
    if(strWelle=="HM" && strWelle_EGABAUSF=="VLplus" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle";
    
    if(strWelle=="HS" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle_mit_Schrumpfscheibe";
        
    if(strWelle=="HX" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle_Edelstahl";
        
    if(strWelle=="N" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Hohlwelle_mit_Vielkeilverzahnung";
        
    if(strWelle=="V" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_mit_Passfeder";
        
    if(strWelle=="VC" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_fuer_Kuehlturmantriebe";
        
    if(strWelle=="VD" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="1" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_beidseitig";
        
    if(strWelle=="VDG" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="1" && strWelle_WELLE_O_PF=="1")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_beidseitig_ohne_Passfeder";
        
    if(strWelle=="VE" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Einsteckwelle";
    
    if(strWelle=="VG" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="1")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_ohne_Passfeder";
        
    if(strWelle=="VM" && (strWelle_EGABAUSF=="VLplus" || strWelle_EGABAUSF=="XLplus") && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Vollwelle_mit_Passfeder";
    
    if(strWelle=="W" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
        oMotox.oConfig.ABTRIEBSWELLENART = "Welle_fuer_SIP";
    
    if("oFastening" in oParsingData){
        oMotox.oConfig.BEFESTIGUNGSART = oParsingData.oFastening.EGBEZBEF;
    }
    var strFlangeSD = getSDFromGroup( oShortDescriptions, 'FLANSCHDURCHMESSER' );
    // for an empty short description, we get the default for this gear, if the fastening fits
    if("oShaft" in oParsingData && "oFastening" in oParsingData ){
        var strFlangeDiameter = getFlangeDiameter( strFlangeSD, oParsingData.oGearType.EGBEZTYP, oParsingData.oGearType.EGBEZUEBS, oParsingData.oShaft.EGBEZBRA,oParsingData.oGearType.EGBEZDIM, oParsingData.oGearType.EGBEZEI, oParsingData.oFastening.EGBEZBEF );
    }

    if ( strFlangeDiameter !== '' ){
        oMotox.oConfig.BEFESTIGUNGSMASS = strFlangeDiameter;
    }
    if("oShaft" in oParsingData && "oFastening" in oParsingData ){
        var strFlangeFigur=getFlangeFigur( strFlangeSD, oParsingData.oGearType.EGBEZTYP, oParsingData.oGearType.EGBEZUEBS, oParsingData.oShaft.EGBEZBRA,oParsingData.oGearType.EGBEZDIM, oParsingData.oGearType.EGBEZEI, oParsingData.oFastening.EGBEZBEF );
    }

    if ( strFlangeFigur !== '' ){
        oMotox.oConfig.FIGUR = strFlangeFigur;
    }

    if(oMotox.strAdapter=="K2")
    {
        var strPolzahl=ECL_GetValue("ECSI_CX_MotorPoleCount");
        if(parseInt(oMotox.strShaftHeight )>=225 && strPolzahl=="2")
        {
            oMotox.oConfig.ECSI_2POL_MOTORABTRIEBSWELLE = "T";
        }
    }
    
    //Drive Train
    if(( 'T01' in oShortDescriptions ) || ( 'T02' in oShortDescriptions ) || ( 'T03' in oShortDescriptions ) || ( 'T04' in oShortDescriptions )){
        oMotox.oConfig.ISDRIVETRAIN_OPTION = "T";
    }
    else{
        oMotox.oConfig.ISDRIVETRAIN_OPTION = "";	
    }
    _adjustGearedMotorWithShortDescriptions( oShortDescriptions, oMotox, oParsingData, strRegion  );	

    
    oMotox.strPoles = ''; 		// motor poles may be overridden by a short description
    oMotox.bWelle2Polig = '';

    //ATEX Verarbeitung
    //Bei StartConfigurationkommen die Daten aus dem Context
        
    var strATEX_EP_GAS = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionGas");
    var strATEX_EP_STAUB = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionDust");
    var str1MB1_Motor = ECL_GetValue("ECSI_CX_MotorBaseTypeOrderNumber");
    
    //Relevant ist die 6. Stelle der 1MB MLFB
    var str1MB_Stelle6=str1MB1_Motor.charAt(5);
        
    if( (strATEX_EP_GAS != "" || strATEX_EP_STAUB != "") && str1MB1_Motor.left(3)=="1MB") 
        ECL_SetValue("ECSI_ATEX_KENNER", "ATEX_ADAPTER");
    else
        ECL_SetValue("ECSI_ATEX_KENNER", "");
    
    if(strATEX_EP_GAS == "1")
        ECL_SetValue("ECSI_ATEX_ZONE", "1");
    else if(strATEX_EP_GAS == "2")
        ECL_SetValue("ECSI_ATEX_ZONE", "2");
    else if(strATEX_EP_STAUB == "21")
        ECL_SetValue("ECSI_ATEX_ZONE", "21");
    else if(strATEX_EP_STAUB == "22")
        ECL_SetValue("ECSI_ATEX_ZONE", "22");
    else
        ECL_SetValue("ECSI_ATEX_ZONE", "");
        
    if(ECL_GetValue("ECSI_ATEX_ZONE") == "1")
    {
        if(str1MB_Stelle6=="6")
            ECL_SetValue("ECSI_ATEX_EGRUPPE","IIB");
        else
            ECL_SetValue("ECSI_ATEX_EGRUPPE","IIC");
    }
    else if(ECL_GetValue("ECSI_ATEX_ZONE") == "2")
    {
        ECL_SetValue("ECSI_ATEX_EGRUPPE","IIC");
    }
    else if(ECL_GetValue("ECSI_ATEX_ZONE") == "21")
    {
        ECL_SetValue("ECSI_ATEX_EGRUPPE","IIIC");
    }
    else if(ECL_GetValue("ECSI_ATEX_ZONE") == "22")
    {
        ECL_SetValue("ECSI_ATEX_EGRUPPE","IIIB");
    }
    else
        ECL_SetValue("ECSI_ATEX_EGRUPPE","");
        
    if(ECL_GetValue("ECSI_ATEX_ZONE") == "1" || ECL_GetValue("ECSI_ATEX_ZONE") == "2")
    {
        ECL_SetValue("ECSI_ATEX_TCLASS","T4"); //K78
    }
    else if(ECL_GetValue("ECSI_ATEX_ZONE") == "21" || ECL_GetValue("ECSI_ATEX_ZONE") == "22")
    {
        ECL_SetValue("ECSI_ATEX_TCLASS","120"); //K75
    }

    // Sonderlogik 
	if(oMotox.oConfig.ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION == "T")
	{
		if(oMotox.GearData.EGBEZTYP=="B" || oMotox.GearData.EGBEZTYP=="K")
		{
			if(oMotox.oConfig.BAUFORM=="M4")
			{
				if(!oMotox.oConfig.OELSTANDSKONTROLLE || oMotox.oConfig.OELSTANDSKONTROLLE=="ohne" || oMotox.oConfig.OELSTANDSKONTROLLE=="-")
				{
					oMotox.oConfig.ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL= "Y_20";
				}
				else
				{
					oMotox.oConfig.ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL= "Y_20-0";
				}
			}
			else
			{
					oMotox.oConfig.ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL= "Y_20";
			}
		}
		else
		{
			oMotox.oConfig.ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL= "X_20";
		}
	}
	
    
    return( oMotox );
}


function _addAttributesforG110M_TYP( oMotox, strSD, oParsingData, oShortDescriptions )
{
    var strSelect = "SELECT DISTINCT WERT_1,WERT_2,WERT_3 FROM MLFB_OPTIONEN WHERE MLFB_OPTION = '" + strSD + "' ";
    var strDBResult = 'G110M_TYP';
    
    var strG110M_ADAPTGR_KNZ="";
    
    if ( dbselect( 'SIMOGEAR_DB', strSelect, strDBResult ) == 1 )
    {
        oMotox.oConfig.strRatedPower = dbgetstring( strDBResult, 'WERT_1' );
        strG110M_ADAPTGR_KNZ = dbgetstring( strDBResult, 'WERT_2' );
        oMotox.oConfig.strMotorControl = dbgetstring( strDBResult, 'WERT_3' );
        
        oMotox.oConfig.strVoltageNetwork = "400";
    }
}

function _addAttributesforG110M_CU( oMotox, strSD, oParsingData, oShortDescriptions )
{
    var strSelect = "SELECT DISTINCT WERT_1,WERT_2,WERT_3 FROM MLFB_OPTIONEN WHERE MLFB_OPTION = '" + strSD + "' ";
    var strDBResult = 'G110M_CU';
    
    var strG110M_KKMAT_ZUB="";
    
    if ( dbselect( 'SIMOGEAR_DB', strSelect, strDBResult ) == 1 )
    {
        oMotox.oConfig.strConnection = dbgetstring( strDBResult, 'WERT_2' );
        strG110M_KKMAT_ZUB = dbgetstring( strDBResult, 'WERT_1' );
        oMotox.oConfig.strCommunictaion = dbgetstring( strDBResult, 'WERT_3' );
    }
}

function _addAttributesforG110M_INTBRE( oMotox, strSD, oParsingData, oShortDescriptions )
{
    var strSelect = "SELECT DISTINCT WERT_1 FROM MLFB_OPTIONEN WHERE MLFB_OPTION = '" + strSD + "' ";
    var strDBResult = 'G110M_INTBRE';
    
    if ( dbselect( 'SIMOGEAR_DB', strSelect, strDBResult ) == 1 )
    {
        oMotox.oConfig.bIBw = true;
    }
    else
    {
        oMotox.oConfig.bIBw = false;
    }
    
}

function _addAttributesforG110M_EXTANB( oMotox, strSD, oParsingData, oShortDescriptions )
{
    var strSelect = "SELECT DISTINCT WERT_1 FROM MLFB_OPTIONEN WHERE MLFB_OPTION = '" + strSD + "' ";
    var strDBResult = 'G110M_EXTANB';
    
    if ( dbselect( 'SIMOGEAR_DB', strSelect, strDBResult ) == 1 )
    {
        var strG110M_extAnb = dbgetstring( strDBResult, 'WERT_1' );
        oMotox.oConfig.strExternalAdditions = strG110M_extAnb;
    }
    else
    {
        oMotox.oConfig.strExternalAdditions = "ohne"
    }
}