//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1FE1
// 	Date: 2022-08-04
// 	User: Administrator
// ---------------------------------------------------------

//#mode(full-ecma)


// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class
//@import "1FE1_CONFIG/CFG_1FE1_CONSEQUENCES.js"
//@import "1FE1_CONFIG/CFG_1FE1_PRODUKTLOGIK.js"
//@import "1FE1_CONFIG/VT_1FE1.js"
//@import "1FE1_CONFIG/CFG_1FE1_MOTOR.js"
//@import "1FE1_CONFIG/CFG_1FE1_GENERIERE_KAG.js"
//@import "1FE1_PARSER/Parser.1FE1.parse.js"

// include new Variant Tables
var sError;
VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables

//  sDB_Version = "21426";  		// DB-Version	// 6.32
//  sDB_Version = "23670";			// DB-Version	// 6.34
//  sDB_Version = "26551";			// DB-Version	// 6.39 for TST Release 03/2025
var sDB_Version = "27036";			// DB-Version	// 6.41 for TST Release 10/2025
var sDB_Suffix = "_" + sDB_Version;	// DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {
    // Derive evaluation of ECSI attributes from primary MLFB
    SetAttributesFromMlfb();

    ECL_Trace("DT-K database-version: " + sDB_Version);
    ECL_Trace("Script-version: 2025.10.0_250905");
    /*
    MLFB-Schema
    MLFB1-10 fix
    
    MLFB01	1FE1
    MLFB05	Baugröße	{04,05,06,07,08,09,10,11,12,14}
    MLFB07	Baulänge 	HMK_BAULAENGE_1FE1	{1,2,3,4,5,6,7}
    MLFB08	Motor-Polpaarzahl	PMD_ACF149_001_000_1FE1		{4,6,8}
    MLFB09 	(8+9) Motortyp	PMD_AAA259_001_000_1FE1	{4H,4W,6W,8W}
    MLFB10	{C,N,Y,D,E,F,G,H,J,K,L,M,P,Q,R,S,T,U,V,W,X}
    MLFB11	. Motorschutz		PMD_AAA863_001_000_1FE1 {1,3,5} {0,2,4} für Motoren ohne Kühlmantel (Sondervarianten)
    MLFB12	. VPM-Modul		HMK_VPM_MODUL_1FE1		{0,1}
    MLFB13	. (6) Ausführung der Temperaturüberwachung	PMD_AAA717_001_000_1FE1 {1,2,3,6,7}		{Konfigtyp="KONFIG": 3,6,7}
                  Lieferumfang							PMD_ABW070_001_000_1FE1 {1,2,3,6,7}
    MLFB14	. (B) Ausführung des Ständers (Stator) 		PMD_ACF212_001_000_1FE1 {A,B,W} + N + V00-V99
    MLFB15	. Ausführung des Läufers					PMD_ACF213_001_000_1FE1 {A,B,C,D,E,R,W} + N + T00-T99
    MLFB16	. Kabelabgang								PMD_AAA759_001_000_1FE1 {0,1,2,3,8} bei 8 Xxx KAG
    
    SeriesID: 361
    
    Synchron 1FE1	361	1FE	SIMOTICS M - 1FE Einbaumotor

    
    Test:
    1FE10534HH......
    1FE10534HH116BA8-Z X35
    
    
    */

    // Defaults, wird ggf. von der Fehlerbehandlung geändert
    ECL_SelectValue("ECSI_STATUS", "OK");		// Status für MLFB-Übergabe
    ECL_SetValue("ECSI_STATUS_MESSAGE", "");	// Statusmeldung für MLFB-Übergabe

    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");

    var strchangedAttribute = ECL_GetCurrentAttribute();

    // Dummy Aufrufe von SIZER unterdrücken
    /*	if (strchangedAttribute == '')
            return;
    */
    if (strchangedAttribute.left(7) == "ECSI_CX")
        return;

    if (strchangedAttribute == "@INIT@") {
        //Initialisierung
        SetConfiguration_1FE1_Init();
        return;
    }
    //var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    if (strchangedAttribute == "ECSI_MLFB") {

        var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
        if (ECSI_IS_START_CONFIGURATION != 1) {
            var sStatus = checkContextValues();

            if (sStatus != "") {
                ECL_SelectValue("ECSI_STATUS", "E");
                ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
                return;
            }
        }

        var sStatus = analyzePrimaryMLFB();
        if (sStatus != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
            return;
        }
        var sMLFB = ECL_GetValue("ECSI_MLFB");
    }




    // #############################################################################################################
    // Context-Attributes
    // #############################################################################################################
    /*
        CONTEXT-ATTRIBUTES
        gerneral:
            MotorSolution
                0	Standard asynchonous motor solution
                1	Servo motor solution
                2	Reluctance motor solution
            
            MinimalExplosionProtectionGas
                Null	None
                2	Ex ec (Zone 2)
                1	Ex db (Zone 1)
                
            MinimalExplosionProtectionDust
                Null	None
                22	Ex tc (Zone 22)
                21	Ex tb (Zone 21)
            
        motors:
            MountingPosition
                Null	No value, if selected motor is a std. asynchron. Motor or a servo motor
                    1	M1, Output side A (geared motors)
                    2	M2, Output side A (geared motors)
                    3	M3, Output side A (geared motors)
                    4	M4, Output side A (geared motors)
                    5	M5, Output side A (geared motors)
                    6	M6, Output side A (geared motors)
                    7	M1, Output side B (geared motors)
                    8	M2, Output side B (geared motors)
                    9	M3, Output side B (geared motors)
                    10	M4, Output side B (geared motors)
                    11	M5, Output side B (geared motors)
                    12	M6, Output side B (geared motors)

            (MotorFrequency)
                Null	No value, if selected motor is a servo motor
                50	50 Hz
                60	60 Hz
                87	87 Hz
                104	104 Hz
                6050	60 Hz with 50 Hz power (also called "60p50")

            CoolingMethodMotor
                0	Self-ventilated
                1	Forced ventilation
                2	Water cooling
                3	Self-cooling
                4	Push-through ventilation

            EncoderTypeRough
                Null	Any (nothing specific set by the user)
                0	Incremental
                1	Absolute
            MotorConnection
                0	Motor dimensioned with delta circuit
                1	Motor dimensioned with star circuit
            
            ? DefaultGearboxAdapter
            ? MotorRatedPower
            ? MotorRatedSpeed
            
            MotorBrakeRequired
                True
                False
            ? MotorPoleCount
    */
    /*ECSI_CX_CoolingMethodMotor	
  0	Self-ventilated
  1	Forced ventilation			
  2	Water cooling				only 2
  3	Self-cooling				
  4	Push-through ventilation
*/
    var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
    var CoolingMethodMotor = parseInt(CoolingMethodMotor);
    if (CoolingMethodMotor != 9999) {

        if (CoolingMethodMotor != 2) {
            //Fehler
            sError = "ERRORMSG_MLFB_1FE1___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            return sError;
        }
    }
    // #############################################################################################################


    // #############################################################################################################
    // Konfiguration anwerfen
    // #############################################################################################################
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
    if (sECSI_MLFB == "") {
        return;
    }
    var sMLFB16 = sECSI_MLFB.left(16);
    // ###################################################################################################################################
    // LOGIK
    // ###################################################################################################################################
    if (sMLFB16.indexOf(".") < 0) {
        var sStatus = ExecProductLogic(strchangedAttribute);
        if (sStatus != "OK") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
            return;
        }
    }

    // ###################################################################################################################################
    // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
    // ###################################################################################################################################
    var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// diese kann sich durch die Konfiguration geändert haben, insbes. in den ersten 16 Stellen

    var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
    ECL_SetValue("ECSI_MLFB", full_mlfb);



    // ###################################################################################################################################
    // Consequence-Attributes
    // ###################################################################################################################################

    //sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// frisch besorgen, kann überall geändert worden sein
    //var oConsequences = determineConsequences(sECSI_MLFB);

    /* zur Info:
    var oConsequences = {
        VPM							: getVPM(sECSI_MLFB),
        Error_Message				: strErr
    }
    * /
    if (oConsequences.Error_Message != ""){
        ECL_SelectValue ("ECSI_STATUS", "E");
        ECL_SetValue ("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FE1___CONSEQUENCES"));
        return;
    }
    */
    if (ECL_GetValue("HMK_VPM_MODUL_1FE1") == "00002") {
        ECL_SetValue("ECSI_CC_Selected_VPM", "True");
    } else {
        ECL_SetValue("ECSI_CC_Selected_VPM", "False");
    }


    var PMD_ABP635_001_000_1FE1 = ECL_GetValue("PMD_ABP635_001_000_1FE1");

    ECL_SetValue("ECSI_CC_MaxRotationSpeedLimit", PMD_ABP635_001_000_1FE1);
    // ###################################################################################################################################



    // ###################################################################################################################################	
    // Deaktiviere Hilfsattribute

    ECL_DeactivateAttribute("HMK_VALUE_VALID_1FE1");
    ECL_DeactivateAttribute("O_X35_X36_1FE1");
    ECL_DeactivateAttribute("MLFB_RUMPF_01_10_1FE1");
    ECL_DeactivateAttribute("MLFB12_1FE1");
    ECL_DeactivateAttribute("MLFB13_1FE1");
    ECL_DeactivateAttribute("MLFB14_1FE1");
    ECL_DeactivateAttribute("MLFB15_1FE1");

    // Info-Attribute
    ECL_DisableAttribute("PMD_AAA259_001_000_1FE1");	// Motortyp
    ECL_DeactivateAttribute("PMD_AAE020_001_000_1FE1");	// Bemessungsdrehzahl
    ECL_DeactivateAttribute("PMD_ABJ544_001_000_1FE1");	// Bemessungsdrehmoment
    ECL_DeactivateAttribute("PMD_ABP615_001_000_1FE1");	// Bemessungsleistung
    ECL_DeactivateAttribute("PMD_ABP635_001_000_1FE1");	// maximal zul. Drehzahl (mech)


    // disable Attribute, die ggf. in Basetype belegt sind:

    if (sBaseTypeMLFB.charAt(10) != ".") {
        ECL_DisableAttribute("PMD_AAA863_001_000_1FE1");
    } else {
        ECL_EnableAttribute("PMD_AAA863_001_000_1FE1");
    }

    if (sBaseTypeMLFB.charAt(11) != ".") {
        ECL_DisableAttribute("HMK_VPM_MODUL_1FE1");
    } else {
        ECL_EnableAttribute("HMK_VPM_MODUL_1FE1");
    }
}


function SetConfiguration_1FE1_Init() {
    var oData = {};
    /* MLFB-Schema
            MLFB1-10 fix
    	
        MLFB01	1FE1
        MLFB05	Baugröße	{04,05,06,07,08,09,10,11,12,14}
        MLFB07	Baulänge 	HMK_BAULAENGE_1FE1	{1,2,3,4,5,6,7}
        MLFB08	Motor-Polpaarzahl	PMD_ACF149_001_000_1FE1		{4,6,8}
        MLFB09 	(8+9) Motortyp	PMD_AAA259_001_000_1FE1	{4H,4W,6W,8W}
        MLFB10	{C,N,Y,D,E,F,G,H,J,K,L,M,P,Q,R,S,T,U,V,W,X}
        MLFB11	. Motorschutz		PMD_AAA863_001_000_1FE1 {1,3,5}
        MLFB12	. VPM-Modul		HMK_VPM_MODUL_1FE1		{0,1}
        MLFB13	. (6) Ausführung der Temperaturüberwachung	PMD_AAA717_001_000_1FE1 {1,2,3,6,7}		{Konfigtyp="KONFIG": 3,6,7}
                      Lieferumfang							PMD_ABW070_001_000_1FE1 {1,2,3,6,7}
        MLFB14	. (B) Ausführung des Ständers (Stator) 		PMD_ACF212_001_000_1FE1 {B,W}
        MLFB15	. Ausführung des Läufers					PMD_ACF213_001_000_1FE1 {A,B,C,D,E,R,W}
        MLFB16	. Kabelabgang								PMD_AAA759_001_000_1FE1 {0,1,2,3,8}
    */

    SetMotor_Init(oData);

}

function analyzePrimaryMLFB() {
    // ----------------------------------------------------------------------------------------------------------------
    // MLFB parsen
    // ----------------------------------------------------------------------------------------------------------------
    var oParse = parse_init(ECL_GetValue("ECSI_MLFB"));
    if (oParse.strError != "") {
        return oParse.strError;
    }

    // ----------------------------------------------------------------------------------------------------------------

    if (oParse.strError == "") {

        SetMotor_Init(oParse);

        //SetFREETEXTS(oParse);
        if (oParse.strError != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", oParse.strError);
            return oParse.strError;
        }
    }
    else {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oParse.strError));
        return oParse.strError;
    }
    return "";
}


function checkContextValues() {
    /*ECSI_CX_CoolingMethodMotor	
        0	Self-ventilated
        1	Forced ventilation			
        2	Water cooling				only 2
        3	Self-cooling				
        4	Push-through ventilation
    */
    var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
    var CoolingMethodMotor = parseInt(CoolingMethodMotor);
    if (CoolingMethodMotor != 9999) {

        if (CoolingMethodMotor != 2) {
            //Fehler
            sError = "ERRORMSG_MLFB_1FE1___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            return sError;
        }
    }

    return "";
}