//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1FE2
// 	Date: 2024-12-03
// 	User: Administrator
// ---------------------------------------------------------

//#mode(full-ecma)


// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class
//@import "1FE2_CONFIG/CFG_1FE2_CONSEQUENCES.js"
//@import "1FE2_CONFIG/CFG_1FE2_PRODUKTLOGIK.js"
//@import "1FE2_CONFIG/VT_1FE2.js"
//@import "1FE2_CONFIG/CFG_1FE2_MOTOR.js"
//@import "1FE2_CONFIG/CFG_1FE2_GENERIERE_KAG.js"
//@import "1FE2_PARSER/Parser.1FE2.parse.js"


// include new Variant Tables
VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables

// database version (table suffix)
var sDB_Version = "26897";			// DB-Version	// 3.97
var sDB_Suffix = "_" + sDB_Version;	// DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {

    // Derive evaluation of ECSI attributes from primary MLFB
    SetAttributesFromMlfb();


    ECL_Trace("DT-K database-version: " + sDB_Version);
    ECL_Trace("Script-version: 2025.08.0_250711");
    /*
    MLFB-Schema
    
    MLFB01	1FE2
    MLFB05	Baugröße 			{07,09,11,1214,18}
    MLFB07	Baulänge			{2,3,4,5,6,7}
    MLFB08	8 Polpaarzahl		{4,8}
    MLFB09	Motorprinzip / Ausführung	{A,C,L}
    MLFB10	Wicklungsvariante (Bemessungsdrehzahl)	{C,E,G,H,J,K,L,M,N,P,Q,R,S,T,W}
    MLFB11	. Motorschutz		{1,3,5}
    MLFB12	n/. Kabelabgang		{0,1,2,3}		// bei Async teils Wildcard, teils fest
    MLFB13	. Lieferumfang		{1,2,3(,4,5)}
    // Asynchron
    MLFB14	. Statorausführung (Kühlmantel)		{A,B,C,D,E,W}
    MLFB15	. Läuferausführung	{A,C,D,W}
    MLFB16	. Versionsstand		{0,1,2}
    // Synchron:
    MLFB14	C Statorausführung (Kühlmantel)		{A,B,E,C} B obsolet ==> E since 3.53
    MLFB15	C Läuferausführung	{A,C,D,W}
    MLFB16	1 Versionsstand		{0,1,2}
    
    SeriesID: 362 / 363
    Synchron 1FE2	362	1FE	SIMOTICS M - 1FE Einbaumotor
    Asynchron 1FE2	363	1FE	SIMOTICS M - 1FE Einbaumotor

    1FE21458CC......
    1FE21868LN......
    
    */

    // Defaults, wird ggf. von der Fehlerbehandlung geändert
    ECL_SelectValue("ECSI_STATUS", "OK");		// Status für MLFB-Übergabe
    ECL_SetValue("ECSI_STATUS_MESSAGE", "");	// Statusmeldung für MLFB-Übergabe

    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");

    var strchangedAttribute = ECL_GetCurrentAttribute();

    // Dummy Aufrufe von SIZER unterdrücken
    /*	if (strchangedAttribute == '')
            return;
    */
    if (strchangedAttribute.left(7) == "ECSI_CX") {
        return;
    }

    if (strchangedAttribute == "@INIT@") {
        //Initialisierung
        SetConfiguration_1FE2_Init();
        return;
    }

    var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    var strMLFB = ECL_GetValue("ECSI_MLFB");

    //var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    if (strchangedAttribute == "ECSI_MLFB") {

        var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
        if (ECSI_IS_START_CONFIGURATION != 1) {
            var sStatus = checkContextValues_1FE2();

            if (sStatus != "") {
                ECL_SelectValue("ECSI_STATUS", "E");
                ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
                return;
            }
        }


        var sStatus = analyzePrimaryMLFB_1FE2();
        if (sStatus != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
            return;
        }
        var sMLFB = ECL_GetValue("ECSI_MLFB");
    }


    // #############################################################################################################
    // Context-Attributes
    // #############################################################################################################
    /*
        CONTEXT-ATTRIBUTES
        gerneral:
            MotorSolution
                0	Standard asynchonous motor solution
                1	Servo motor solution
                2	Reluctance motor solution
            
            MinimalExplosionProtectionGas
                Null	None
                2	Ex ec (Zone 2)
                1	Ex db (Zone 1)
                
            MinimalExplosionProtectionDust
                Null	None
                22	Ex tc (Zone 22)
                21	Ex tb (Zone 21)
            
        motors:
            
            (MotorFrequency)
                Null	No value, if selected motor is a servo motor
                50	50 Hz
                60	60 Hz
                87	87 Hz
                104	104 Hz
                6050	60 Hz with 50 Hz power (also called "60p50")
            
            CoolingMethodMotor
                0	Self-ventilated
                1	Forced ventilation
                2	Water cooling
                3	Self-cooling
                4	Push-through ventilation
            
            MotorConnection
                0	Motor dimensioned with delta circuit
                1	Motor dimensioned with star circuit
            
            
            ? MotorRatedPower
            ? MotorRatedSpeed
            
            ? MotorPoleCount
    */
    var ECSI_CX_MotorRatedPower = ECL_GetValue("ECSI_CX_MotorRatedPower");
    var ECSI_CX_MotorConnection = ECL_GetValue("ECSI_CX_MotorConnection");

    var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
    var CoolingMethodMotor = parseInt(CoolingMethodMotor);
    if (CoolingMethodMotor != 9999) {

        if (CoolingMethodMotor != 2) {
            //Fehler
            sError = "ERRORMSG_MLFB_1FE2___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            return sError;
        }
    }
    // #############################################################################################################


    // #############################################################################################################
    // Konfiguration anwerfen
    // #############################################################################################################
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
    if (sECSI_MLFB == "") {
        return;
    }
    var sMLFB16 = sECSI_MLFB.left(16);
    // ###################################################################################################################################
    // LOGIK
    // ###################################################################################################################################
    if (sMLFB16.indexOf(".") < 0) {
        var sStatus = ExecProductLogic_1FE2(strchangedAttribute);
        if (sStatus != "OK") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
            return;
        }
    }

    // ###################################################################################################################################
    // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
    // ###################################################################################################################################
    var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// diese kann sich durch die Konfiguration geändert haben, insbes. in den ersten 16 Stellen

    var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
    ECL_SetValue("ECSI_MLFB", full_mlfb);

    // ###################################################################################################################################
    // Lieferumfang
    // ###################################################################################################################################
    /*	Wenn PMD_ABW070_001_000_1FE2 == 'S_R' MLFB13: '1' (Stator und Rotor-BG), keine Sekundär-MLFB
        Wenn PMD_ABW070_001_000_1FE2 ==	'ET_S' MLFB13 = "2", keine Sekundär-MLFB
        Wenn PMD_ABW070_001_000_1FE2 ==	'ET_S_R' MLFB13 = "2", mit Sekundär-MLFB (Kopie mit MLFB13 = '3')       Aktuell nicht gültig in SPC!
        Wenn PMD_ABW070_001_000_1FE2 ==	'ET_R' MLFB13 = "3", keine Sekundär-MLFB
        
    */
    var PMD_ABW070_001_000_1FE2 = ECL_GetValue("PMD_ABW070_001_000_1FE2");
    var ECSI_MLFB_SEC = "";

    if (PMD_ABW070_001_000_1FE2 == "ET_S_R") {
        // Es muss eine Sekundär-MLFB generiert werden:

        ECSI_MLFB_SEC = sECSI_MLFB;

        ECSI_MLFB_SEC = replaceAt(ECSI_MLFB_SEC, 12, "3");
    }
    SetMlfbSec(ECSI_MLFB_SEC); // ECL_SetValue("ECSI_MLFB_SEC", ECSI_MLFB_SEC);
    // ###################################################################################################################################



    // ###################################################################################################################################
    // Consequence-Attributes
    // ###################################################################################################################################
    /*
        sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// frisch besorgen, kann überall geändert worden sein
        var oConsequences = determineConsequences(sECSI_MLFB);
        
    
        
        if (oConsequences.Error_Message != ""){
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FE2___CONSEQUENCES"));
            return;
        }
        /* zur Info:
        var oConsequences = {
            //AdditionalInertia 		: getAdditionalInertia(sECSI_MLFB),
            //MinPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
            //MaxPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MaxPulseFrequency', 		'max'),
            IpProtectionLevelMotor  	: getIpProtectionLevelMotor(),
            BrakeID						: getBrakeID(sECSI_MLFB),
            Error_Message				: strErr
        }
        */
    /*	
        //ECL_SetValue("ECSI_CC_AdditionalInertia", 			oConsequences.AdditionalInertia);
        ECL_SetValue("ECSI_CC_IpProtectionLevelMotor", 		oConsequences.IpProtectionLevelMotor);
        ECL_SetValue("ECSI_CC_BrakeID", 					oConsequences.BrakeID);
        
        ECL_SetValue("ECSI_CC_MaxRotationSpeedLimit", ECL_GetValue("PMD_ABP635_001_000_1FE2"));
    */
    ECL_SetValue("ECSI_CC_MaxRotationSpeedLimit", ECL_GetValue("PMD_ABP635_001_000_1FE2"));
    // ###################################################################################################################################


    // ###################################################################################################################################	
    // Deaktiviere Hilfsattribute
    ECL_DeactivateAttribute("HMK_VALUE_VALID_1FE2");
    ECL_DeactivateAttribute("MLFB12_1FE2");
    ECL_DeactivateAttribute("MLFB14_1FE2");
    ECL_DeactivateAttribute("MLFB15_1FE2");
    ECL_DeactivateAttribute("MLFB16_1FE2");
    ECL_DeactivateAttribute("HMK_W_AUSFUEHRUNG_1FE2");
    ECL_DeactivateAttribute("HMK_PRODNAM_SLEEVE_1FE2");

    // Disable Info-Attribute
    ECL_DeactivateAttribute("PMD_ABP635_001_000_1FE2");	// maximal zul. Drehzahl (mech)
    ECL_DeactivateAttribute("PMD_AAE020_001_000_1FE2");	// Bemessungsdrehzahl
    ECL_DeactivateAttribute("PMD_ABJ544_001_000_1FE2");	// Bemessungsdrehmoment
    ECL_DeactivateAttribute("PMD_ABP615_001_000_1FE2");	// Bemessungsleistung
    ECL_DeactivateAttribute("PMD_ABP663_001_000_1FE2"); // Achshöhe

    // ###################################################################################################################################
}
// #######################################################################################################################################

function SetConfiguration_1FE2_Init() {
    var oData = {};

    SetMotor_Init_1FE2(oData);

}

function analyzePrimaryMLFB_1FE2() {
    // ----------------------------------------------------------------------------------------------------------------
    // MLFB parsen
    // ----------------------------------------------------------------------------------------------------------------
    var oParse = parse_init_1FE2(ECL_GetValue("ECSI_MLFB"));
    if (oParse.strError != "") {
        return oParse.strError;
    }

    // ----------------------------------------------------------------------------------------------------------------

    if (oParse.strError == "") {

        SetMotor_Init_1FE2(oParse);

        //SetFREETEXTS(oParse);
        if (oParse.strError != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", oParse.strError);
            return oParse.strError;
        }
    }
    else {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oParse.strError));
        return oParse.strError;
    }
    return "";
}

function checkContextValues_1FE2() {
    /*ECSI_CX_CoolingMethodMotor	
        0	Self-ventilated
        1	Forced ventilation			
        2	Water cooling				only 2
        3	Self-cooling				
        4	Push-through ventilation
    */
    var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
    var CoolingMethodMotor = parseInt(CoolingMethodMotor);
    if (CoolingMethodMotor != 9999) {

        if (CoolingMethodMotor != 2) {
            //Fehler
            sError = "ERRORMSG_MLFB_1FE2___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            return sError;
        }
    }

    return "";
}    