//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1FG1
// 	Date: 2021-07-01
// 	User: Administrator
// ---------------------------------------------------------
//#mode(full-ecma)


// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "1FG1_CONFIG/VT_1FG1.js"

//@import "1FG1_CONFIG/CFG_1FG1_CONSEQUENCES.js"

//@import "1FG1_CONFIG/CFG_1FG1_CHECKBOX.js"

//@import "1FG1_CONFIG/CFG_1FG1_PRODUKTLOGIK.js"

//@import "1FG1_CONFIG/CFG_1FG1_UMRICHTER.js"

//@import "1FG1_CONFIG/CFG_1FG1_GETRIEBE.js"

//@import "1FG1_CONFIG/CFG_1FG1_BEFESTIGUNG.js"

//@import "1FG1_CONFIG/CFG_1FG1_MOTOR.js"

//@import "1FG1_CONFIG/CFG_1FG1_GEBER.js"

//@import "1FG1_CONFIG/CFG_1FG1_FARBE.js"

//@import "1FG1_CONFIG/CFG_1FG1_EINBAULAGE.js"

//@import "1FG1_CONFIG/CFG_1FG1_SCHMIERUNG.js"

//@import "1FG1_CONFIG/CFG_1FG1_BREMSE.js"

//@import "1FG1_CONFIG/CFG_1FG1_SONSTIGES.js"

//@import "1FG1_CONFIG/CFG_1FG1_GENERIERE_KAG.js"

//@import "1FG1_PARSER/Parser.1FG1.parse.js"

// include new Variant Tables
/*
history
DB-Stand: 21567 neu 2021.04
DB-Stand: 21609 neu 2021.06
DB-Stand: 22151 neu 2021.07
DB-Stand: 23484 neu 2021.08 > DTK: 23.60
09.09.2021 Bugfix mounting position - restore project
08.04.2022 Bugfix mounting position - also by GetStatus (IsStartConfig = 0)
27.04.2022 Bugfix braking moment
16.12.2022 Bugfix Bug 47291: 1FG1 Federdruckbremsen N3X, K82 Handlüfthebel, wählbare Stecker- und Handlüfthebellagen (Konfigurierbarkeit)
2024/10 SPC Update to 27.25 (DB-Stand: 26374)
2025/07 SPC-Update to 31.1 (DB-Stand: 26875)
2025/09 SPC-Update to 32.9 (DB-Stand: 26939)
*/

var sDB_Version = "26939";			// DB-Version
var sDB_Suffix = "_" + sDB_Version;	// DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {
    // Derive evaluation of ECSI attributes from primary MLFB
    SetAttributesFromMlfb();

    var deltaTime = new Date().getTime();
    ECL_Trace("DT-K database-version: " + sDB_Version);
    ECL_Trace("Script-version: 2025.09.0_2500808");
    /*	MLFB-Schema
    MLFB01	1FG1
    MLFB05	Getriebestufen {1, 2, 3, 4, 5}		1: 2-stufig, 2: 3-stufig 	bzw bei anderen Getrieben 3, 4, 5
    MLFB06	Getriebebaugröße 6+7:	{01, 02, 03, 04, 05, 06, 07, 08, 10,  11, 12, 13 }
    MLFB07	Getriebebaugröße   --> 	 19, 29, 39, 49, 59, 69, 79, 89, 109, 129, 149 
    MLFB08	. Wellenausführung	{1, 2, 3, 9} Vollwelle mit Passfedernut Ausführung 1, 2, 3, Sonder
    MLFB09	. Gebersystem für Motoren mit Drive CLiQ {Q, R, P, U, Z} Z: Sonder mit KAG
    MLFB10	Achshöhe 	{C, D, E, F, G} entspricht 36, 48, 63, 80, 100 mm 	PMD_ABP663
    MLFB11	Baulänge	{0, 1, 2, 3, 4, 5, 6}								TAK_ABU212
    MLFB12	Synchrondrehzahl	{2, 3, 4, 6} --> PMD_AAE020
    MLFB13	Motortyp {1, 2, 3, 4} 1, 2: Compact | 3, 4: High Dynamic; Zwischenkreisspannung 1, 3: 300 | 2, 4: 600
    MLFB14	. Befestigungsart	{A, B, C, D, F, H} --> Fuß-, Fuß/Flansch-, Flansch-, Gehäuseflanschausführung (D: Drehmomentstütze + G10)
    MLFB15	Getriebeübersetzung (15+16)	A1......X1-A2.....N2
    MLFB16	Getriebeübersetzung (15+16)	{1, 2}
    
    Getriebebaugröße und Stufen:
    Servo-Stirnradgetriebe:
    1FG1...
        .
        1 - 2-stufig
        2 - 3-stufig
         ..
         01 -  19
         02 -  29
         03 -  39
         04 -  49
         05 -  59
         06 -  69
         07 -  79
         08 -  89
         10 - 109
         11 - 129
    
    Servo-Flachgetriebemotoren:
    1FG1...
        .
        3 - 2-stufig
        4 - 3-stufig
         ..
         01 -  29
         02 -  39
         03 -  49
         04 -  69
         05 -  79
         06 -  89
         07 - 109
         08 - 129
    
    Servo-Kegelradgetriebemotoren
    1FG1...
        .
        5 - 2-stufig/3-stufig abhängig von Baugröße
         ..
        500 - 2-stufig  19
        501 - 2-stufig  29
        502 - 2-stufig  39
        503 - 2-stufig  49
        504 - 3-stufig  39
        505 - 3-stufig  49
        507 - 3-stufig  69
        508 - 3-stufig  79
        510 - 3-stufig  89
        511 - 3-stufig 109
        512 - 3-stufig 129
        513 - 3-stufig 149
    
    Servo-Stirnradschneckengetriebemotoren
    1FG1...
        .
        6 - 2-stufig/3-stufig abhängig von Baugröße
         ..
        601 - 2-stufig 29
        602 - 2-stufig 39
        603 - 2-stufig 49
        604 - 2-stufig 69
        605 - 2-stufig 89
    
    // -------------------------------------------------------------------------------
    // Hilfsmerkmale
    // -------------------------------------------------------------------------------
    H_FLANSCH_DURCHM_1FG1S
    H_KEY_GETRIEBE_1FG1S
    M_RUMPF_1FG1S
    M_RUMPF_TYP_1FG1S
    
    // -------------------------------------------------------------------------------
    KAG bestimmen aus Auswahl-Attributen
    // -------------------------------------------------------------------------------
    Option Schrägeinbaulagen
    O_E01_BIS_E37_1FG1S
    VT_1FG1S_M00085
        HMK_O_EXX_ACHSE_1FG1S	HMK_O_EXX_WINKEL_1FG1S	O_E01_BIS_E37_1FG1S
    
    // -------------------------------------------------------------------------------
    Flanschdurchmesser H01	Option Getriebe-Flansch-Durchmesser
    O_H01_BIS_H20_1FG1S
    VT_1FG1S_M00039
        PMD_ABV410_001_000_1FG1S	H_FLANSCH_DURCHM_1FG1S	O_H01_BIS_H20_1FG1S	HMK_VALUE_VALID_1FG1S

    H_FLANSCH_DURCHM_1FG1S
    aus UI_FLANSCH_DURCHM_1FG1S übersetzen
    // -------------------------------------------------------------------------------
    */

    // Datenbank

    // Defaults, wird ggf. von der Fehlerbehandlung geändert
    ECL_SelectValue("ECSI_STATUS", "OK");		// Status für MLFB-Übergabe
    ECL_SetValue("ECSI_STATUS_MESSAGE", "");	// Statusmeldung für MLFB-Übergabe

    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");

    var strchangedAttribute = ECL_GetCurrentAttribute();

    // Dummy Aufrufe von SIZER unterdrücken
    if (strchangedAttribute == '') {
        return;
    }

    if (strchangedAttribute.left(7) == "ECSI_CX") {
        return;
    }

    if (strchangedAttribute === "@INIT@") {
        //Initialisierung
        SetConfiguration_1FG1_Init();

        //ECL_SetValue("ECSI_MLFB", "1FG15021RC231AW1"); // 1FG14011PF042AA1-Z D01 +K06

        return;
    }
    getCheckBoxAttributes(strchangedAttribute);

    if (strchangedAttribute == "ECSI_MLFB") {
        var ECSI_IS_START_CONFIGURATION = parseInt(ECL_GetValue("ECSI_IS_START_CONFIGURATION"));

        var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
        if (sECSI_MLFB == "") {
            return;
        }
        // #############################################################################################################
        // Context-Attributes
        // #############################################################################################################
        /*
        CONTEXT-ATTRIBUTES
        gerneral:
            MotorSolution
                0	Standard asynchonous motor solution
                1	Servo motor solution
                2	Reluctance motor solution
            
            MinimalExplosionProtectionGas
                Null	None
                2	Ex ec (Zone 2)
                1	Ex db (Zone 1)
                
            MinimalExplosionProtectionDust
                Null	None
                22	Ex tc (Zone 22)
                21	Ex tb (Zone 21)
            
        motors:
            MountingPosition
                Null	No value, if selected motor is a std. asynchron. Motor or a servo motor
                    1	M1, Output side A (geared motors)
                    2	M2, Output side A (geared motors)
                    3	M3, Output side A (geared motors)
                    4	M4, Output side A (geared motors)
                    5	M5, Output side A (geared motors)
                    6	M6, Output side A (geared motors)
                    7	M1, Output side B (geared motors)
                    8	M2, Output side B (geared motors)
                    9	M3, Output side B (geared motors)
                    10	M4, Output side B (geared motors)
                    11	M5, Output side B (geared motors)
                    12	M6, Output side B (geared motors)
                
            (MotorFrequency)
                Null	No value, if selected motor is a servo motor
                50	50 Hz
                60	60 Hz
                87	87 Hz
                104	104 Hz
                6050	60 Hz with 50 Hz power (also called "60p50")
                
            CoolingMethodMotor
                0	Self-ventilated
                1	Forced ventilation
                2	Water cooling
                3	Self-cooling
                4	Push-through ventilation
                
            EncoderTypeRough
                Null	Any (nothing specific set by the user)
                0	Incremental
                1	Absolute
            MotorConnection
                0	Motor dimensioned with delta circuit
                1	Motor dimensioned with star circuit
            
            ? DefaultGearboxAdapter
            ? MotorRatedPower
            ? MotorRatedSpeed
            
            MotorBrakeRequired
                True
                False
            ? MotorPoleCount
        */

        if (ECSI_IS_START_CONFIGURATION != 1) {
            var sStatus = checkContextValues();

            if (sStatus != "") {
                ECL_SelectValue("ECSI_STATUS", "E");
                ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
                return;
            }
        }

        var sStatus = analyzePrimaryMLFB();
        if (sStatus != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
            return;
        }
    }

    getCheckBoxAttributes(strchangedAttribute);

    //	ECL_SetValue("ECSI_MLFB", "1FG15021RC231AW1");


    //Konfiguration anwerfen
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
    if (sECSI_MLFB == "") {
        return;
    }
    // ###################################################################################################################################
    // LOGIK
    // ###################################################################################################################################
    var sStatus = ExecProductLogic(strchangedAttribute);
    if (sStatus != "OK") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
        return;
    }
    setCheckBoxAttributes();

    // ###################################################################################################################################
    // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
    // ###################################################################################################################################
    var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// diese kann sich durch die Konfiguration geändert haben, insbes. in den ersten 16 Stellen

    var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
    ECL_SetValue("ECSI_MLFB", full_mlfb);

    // ###################################################################################################################################

    // ###################################################################################################################################
    // Consequence-Attributes
    // ###################################################################################################################################

    // ECSI_CC_AdditionalInertia
    // IpProtectionLevelMotor
    // ECSI_CC_BrakeID
    // GearboxOil
    // OutputShaftLength
    // GearboxOutputShaftType
    // GearboxOutputShaftDiameter	Double [mm]	Diameter of the output shaft in mm
    // GearboxMountingType
    // GearboxReinforcedBearing
    // SelectedGearboxAdapterID ????

    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// frisch besorgen, kann überall geändert worden sein
    var oConsequences = determineConsequences(sECSI_MLFB);

    if (oConsequences.AdditionalInertia == "ERROR") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FG1___CC_ADDITIONAL_INERTIA"));
        return;
    }

    if (oConsequences.BrakeID.left(5) == "ERROR") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FG1___BRAKEID"));
        return;
    }
    if (oConsequences.Error_Message != "") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FG1___CONSEQUENCES"));
        return;
    }

    /* Info:
    var oConsequences = {
        AdditionalInertia 			: getAdditionalInertia(sECSI_MLFB),
        //MinPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
        //MaxPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MaxPulseFrequency', 		'max'),
        //AllowedControlModes		: getAllowedControlModes,
        IpProtectionLevelMotor  	: "65",
    //	SensorModule				: getSensorModule(),
        GearboxOil					: getGearboxOil(),
        OutputShaftLength			: aShaftParams[2],
        GearboxOutputShaftType		: aShaftParams[0],
        GearboxOutputShaftDiameter	: aShaftParams[1],
        GearboxMountingType			: getGearboxMountingType(),
        BrakeID						: getBrakeID(sECSI_MLFB),
        GearboxReinforcedBearing	: getGearboxReinforcedBearing(),
        Error_Message				: strErr
    }
    */
    ECL_SetValue("ECSI_CC_AdditionalInertia", oConsequences.AdditionalInertia);
    ECL_SetValue("ECSI_CC_IpProtectionLevelMotor", oConsequences.IpProtectionLevelMotor);

    ECL_SetValue("ECSI_CC_GearboxOil", oConsequences.GearboxOil);
    ECL_SetValue("ECSI_CC_OutputShaftLength", oConsequences.OutputShaftLength);
    ECL_SetValue("ECSI_CC_GearboxOutputShaftType", oConsequences.GearboxOutputShaftType);
    ECL_SetValue("ECSI_CC_GearboxOutputShaftDiameter", oConsequences.GearboxOutputShaftDiameter);
    ECL_SetValue("ECSI_CC_GearboxMountingType", oConsequences.GearboxMountingType);
    ECL_SetValue("ECSI_CC_BrakeID", oConsequences.BrakeID);
    ECL_SetValue("ECSI_CC_GearboxReinforcedBearing", oConsequences.GearboxReinforcedBearing);
    // ###################################################################################################################################

    // ###################################################################################################################################
    ECL_DisableAttribute("PMD_ABU278_001_000_1FG1S");
    ECL_DisableAttribute("M_RUMPF_TYP_1FG1S");
    ECL_DisableAttribute("M_RUMPF_1FG1S");

    ECL_DisableAttribute("PMD_ABP663_001_000_1FG1S"); // Achshöhe
    ECL_DisableAttribute("TAK_ABU212_001_000_1FG1S"); // Baulänge
    ECL_DisableAttribute("PMD_AAA259_001_000_1FG1S"); // Motortyp
    ECL_DisableAttribute("PMD_AAE020_001_000_1FG1S"); // Drehzahl

    ECL_DisableAttribute("PMD_AAA566_001_000_1FG1S"); // Einbaulage

    ECL_DisableAttribute("HMK_ZWK_SPANNUNG_1FG1S"); // Zwischenkreisspannung

    // Getriebe-Parameter nur INFO
    ECL_DisableAttribute("PMD_ABV517_001_000_1FG1S"); // Art des Getriebes
    ECL_DisableAttribute("PMD_ABV410_001_000_1FG1S"); // Bezeichnung


    ECL_DeactivateAttribute("O_J4R_1FG1S"); // 
    ECL_DeactivateAttribute("H_FLANSCH_DURCHM_1FG1S"); // Flanschdurchmesser HMK
    ECL_DeactivateAttribute("O_H01_BIS_H20_1FG1S"); // KAG Flanschdurchmesser
    ECL_DeactivateAttribute("O_H1G_BIS_H7A_1FG1S"); // KAG Wellenende
    ECL_DeactivateAttribute("H_EINBAULAGE_KLASSE_1FG1S"); //  H_EINBAULAGE_KLASSE_1FG1S
    ECL_DeactivateAttribute("O_E01_BIS_E37_1FG1S"); //  O_E01_BIS_E37_1FG1S

    ECL_DisableAttribute("O_K82_1FG1S"); //  Handlüftung (nur bei Arbeitsbremse)
    ECL_DisableAttribute("O_N30_BIS_N34_1006470"); //  Optionen Federkraftbremse


    ECL_DeactivateAttribute("HMK_VALUE_VALID_1FG1S"); //  HMK_VALUE_VALID_1FG1S

    // Checkbox-Attribute ausblenden
    ECL_DeactivateAttribute("O_G10_1FG1S"); // O_G10_1FG1S	Drehmomentstütze Figur 2
    ECL_DeactivateAttribute("O_G34_1FG1S"); // O_G34_1FG1S	Ölschauglas
    ECL_DeactivateAttribute("O_G53_1FG1S"); // O_G53_1FG1S	Ölablassschraube magnetisch
    ECL_DeactivateAttribute("O_G47_1FG1S"); // O_G47_1FG1S	Ölausgleichsbehälter
    ECL_DeactivateAttribute("O_G20_1FG1S"); // O_G20_1FG1S	Radial verstärkte Abtriebswellenlagerung
    ECL_DeactivateAttribute("O_B02_1FG1S"); // O_B02_1FG1S	Prüfbescheinigung (für bestellten Motor)
    ECL_DeactivateAttribute("O_K82_1FG1S"); // O_K82_1FG1S	Handlüftung (nur bei Arbeitsbremse)
    ECL_DeactivateAttribute("O_Y84_1FG1S"); // O_Y84_1FG1S	Kundenangabe auf dem Leistungsschild
    ECL_DeactivateAttribute("UI_O_Y84_1FG1S"); // O_Y84_1FG1S	Kundenangabe auf dem Leistungsschild
    ECL_DeactivateAttribute("O_N16_1FG1S"); // O_N16_1FG1S	Ausführung für erhöhte chemische Beständigkeit
    ECL_DeactivateAttribute("O_G99_1FG1S"); // O_G99_1FG1S	Spielreduzierte Ausführung
    ECL_DeactivateAttribute("O_G97_1FG1S"); // O_G97_1FG1S	Geklebtes Endstufenrad
    ECL_DeactivateAttribute("O_G60_1FG1S"); // O_G60_1FG1S	Schutzhaube	Protective cover
    ECL_DeactivateAttribute("O_W50_1FG1S"); // O_W50_1FG1S	Motor Schnellieferservice - Fast lane

    deltaTime = new Date().getTime() - deltaTime;

    ECL_Trace("1FG1 full circle time: " + deltaTime + "ms");

}


function SetConfiguration_1FG1_Init() {
    var oData = {};

    SetUMR_Init(oData);
    SetMotor_Init(oData);
    SetGetriebe_Init(oData);
    SetBefestigung_Init(oData);
    SetBremse_Init(oData);
    SetEinbaulage_Init(oData);
    SetGeber_Init(oData);

    SetFarbe_Init(oData);
    SetSchmierung_Init(oData);
    SetSonstiges_Init(oData);

    setCheckBoxAttributes();
    /*
    ECL_ExpandAttributeGroup("CFG_GROUP___GENERAL");
    ECL_ExpandAttributeGroup("CFG_GROUP___GENERAL_UMR_1FG1");
    ECL_ExpandAttributeGroup("CFG_GROUP___GENERAL_GEAR_1FG1");
    ECL_ExpandAttributeGroup("CFG_GROUP___MOUNTING");
    ECL_ExpandAttributeGroup("CFG_GROUP___GENERAL_MOTOR_1FG1");
    ECL_ExpandAttributeGroup("CFG_GROUP___ENCODER");
    ECL_ExpandAttributeGroup("CFG_GROUP___GENERAL_PAINT_1FG1");
    ECL_ExpandAttributeGroup("CFG_GROUP___GENERAL_EINBAULAGE_1FG1");
    ECL_ExpandAttributeGroup("CFG_GROUP___GENERAL_EINBAULAGE_SPEZ_1FG1");
    ECL_ExpandAttributeGroup("CFG_GROUP___LUBRICATION");
    ECL_ExpandAttributeGroup("CFG_GROUP___VENTILATION_1FG1");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_LAGERUNG_1FG1");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_PRUEFBESCH_1FG1");
    ECL_ExpandAttributeGroup("CFG_GROUP___BRAKE_1FG1");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_ADD_1FG1");
    */

    ECL_DeactivateAttribute("HMK_VALUE_VALID_1FG1"); // HMK_VALUE_VALID_1FG1
    ECL_DeactivateAttribute("M_RUMPF_TYP_1FG1S"); // M_RUMPF_TYP_1FG1S
    ECL_DeactivateAttribute("M_RUMPF_1FG1S"); // M_RUMPF_1FG1S
    ECL_DeactivateAttribute("H_KEY_GETRIEBE_1FG1S"); // H_KEY_GETRIEBE_1FG1S
    ECL_DeactivateAttribute("MLFB08_1FG1S"); // MLFB08_1FG1S
    ECL_DeactivateAttribute("MLFB09_1FG1S"); // MLFB09_1FG1S
    ECL_DeactivateAttribute("MLFB14_1FG1S"); // MLFB14_1FG1S
    ECL_DeactivateAttribute("HMK_AAA566_KOMBI_1FG1S"); // HMK_AAA566_KOMBI_1FG1S
    ECL_DeactivateAttribute("HMK_E01_E37_KOMBI_1FG1S"); // HMK_E01_E37_KOMBI_1FG1S
    ECL_DeactivateAttribute("HMK_ADAPT_SCREW_TYPE_1FG1S"); // HMK_ADAPT_SCREW_TYPE_1FG1S
    ECL_DeactivateAttribute("HMK_HOUSING_TYPE_1FG1S"); // HMK_HOUSING_TYPE_1FG1S
    ECL_DeactivateAttribute("HMK_GEAR_GRP_HOUSING_1FG1S"); // HMK_GEAR_GRP_HOUSING_1FG1S

}

function analyzePrimaryMLFB() {
    // ----------------------------------------------------------------------------------------------------------------
    // MLFB parsen
    // ----------------------------------------------------------------------------------------------------------------
    var oParse = parse_init(ECL_GetValue("ECSI_MLFB"));
    if (oParse.strError != "") {
        return oParse.strError;
    }

    // ----------------------------------------------------------------------------------------------------------------

    if (oParse.strError == "") {
        SetUMR_Init(oParse);
        SetMotor_Init(oParse);
        SetGetriebe_Init(oParse);
        SetBefestigung_Init(oParse);
        SetBremse_Init(oParse);
        SetEinbaulage_Init(oParse);
        SetGeber_Init(oParse);
        SetFarbe_Init(oParse);

        SetSchmierung_Init(oParse);

        SetSonstiges_Init(oParse);

        SetFREETEXTS(oParse);

        setCheckBoxAttributes();
    } else {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oParse.strError));
        return oParse.strError;
    }
    return "";
}


function checkContextValues() {
    var sMLFB = ECL_GetValue("ECSI_MLFB");

    // ECSI_CX_InstallationAltituteMotor  bis 3000 erlaubt, keine Prüfung erforderlich

    // ECSI_CX_MotorFrequency nur 50Hz
    /*	var MotorFrequency = ECL_GetValue("ECSI_CX_MotorFrequency");
        if (MotorFrequency != "50"){
            //Fehler
            sError = "ERRORMSG_MLFB_1FG1___MOTOR_FREQUENCY_OUT_OF_RANGE";
            return sError;
        }
    */	// ECSI_CX_AmbientTemperatureMotor <= 50°C
    //var AmbientTemperatureMotor = ECL_GetValue("ECSI_CX_AmbientTemperatureMotor");
    var AmbientTemperatureMotor = parseInt(ECL_GetValue("ECSI_CX_AmbientTemperatureMotor"));
    if (AmbientTemperatureMotor > 50) {
        //Fehler
        sError = "ERRORMSG_MLFB_1FG1___MOTOR_AMBIENT_TEMP_OUT_OF_RANGE";
        return sError;
    }


    /*/ECSI_CX_MotorBrakeRequired
    var ECSI_CX_MotorBrakeRequired = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    var UI_HALTEBREMSE_1FG1S = ECL_GetValue("UI_HALTEBREMSE_1FG1S");
    
    if ((ECSI_CX_MotorBrakeRequired == "True" || ECSI_CX_MotorBrakeRequired == "1") && UI_HALTEBREMSE_1FG1S == "OHNE"){
        sError = "ERRORMSG_MLFB_1FG1___CX_CHANGE_BRAKE";
        return sError;
    }
    if ((ECSI_CX_MotorBrakeRequired != "True" && ECSI_CX_MotorBrakeRequired != "1") && (sMLFB.indexOf("N23") > -1 || sMLFB.indexOf("N24") > -1 || 
        sMLFB.indexOf("N30") > -1 || sMLFB.indexOf("N31") > -1 || sMLFB.indexOf("N32") > -1 || sMLFB.indexOf("N33") > -1 || sMLFB.indexOf("N34") > -1)){
        sError = "ERRORMSG_MLFB_1FG1___CX_CHANGE_BRAKE";
        return sError;
    }
    */
    /*ECSI_CX_DirectMachineEncoderNeeded
        Null	Any (nothing specific set by the user)
        0		No											
        1		Yes											---> nicht zulässig
    */
    var ECSI_CX_DirectMachineEncoderNeeded = ECL_GetValue("ECSI_CX_DirectMachineEncoderNeeded");
    if (ECSI_CX_DirectMachineEncoderNeeded == "1") {
        //Fehler
        sError = "ERRORMSG_MLFB_1FG1___MOTOR_DOES_NOT_FIT_CX";
        return sError;
    }

    /*ECSI_CX_EncoderTypeRough
        Null	Any (nothing specific set by the user)
        0		Incremental									UI_GEBER_1FK7M == OHNEU
        1		Absolute
        
        MITU	Absolutwertgebermultiturn (mit Umdrehungszähler)
        OHNEU	Inkremental / Absolutwertgeber Singleturn / Resolver (kein Umdrehungszähler)
        OHNE	Ohne
        
    UI_GEBER_1FK7M 
    */

    /*ECSI_CX_CoolingMethodMotor		<--- wird nicht übergeben????
        0	Self-ventilated
        1	Forced ventilation			
        2	Water cooling
        3	Self-cooling				nur Selbstkühlung!
        4	Push-through ventilation
    */
    var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
    var CoolingMethodMotor = parseInt(CoolingMethodMotor);
    if (CoolingMethodMotor != 9999) {

        if (CoolingMethodMotor != 3) {
            //Fehler
            sError = "ERRORMSG_MLFB_1FG1___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            return sError;
        }
    }
    /*ECSI_CX_MinimalExplosionProtectionGas
    /*ECSI_CX_MinimalExplosionProtectionDust
        nur NULL zulässig
    */
    var ECSI_CX_MinimalExplosionProtectionGas = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionGas") || "";
    if (ECSI_CX_MinimalExplosionProtectionGas != "") {
        //Fehler
        sError = "ERRORMSG_MLFB_1FG1___MOTOR_DOES_NOT_FIT_CX_EX";
        return sError;
    }
    var ECSI_CX_MinimalExplosionProtectionDust = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionDust") || "";
    if (ECSI_CX_MinimalExplosionProtectionDust != "") {
        //Fehler
        sError = "ERRORMSG_MLFB_1FG1___MOTOR_DOES_NOT_FIT_CX_EX";
        return sError;
    }


    // GearboxMotorCoupling muss == 0 sein

    //--------------------------------------------------------------------------------------------------------------------------
    // MountingPosition
    //--------------------------------------------------------------------------------------------------------------------------
    // 
    /* VT_1FG1S_M00100	Drehmomentenstütze-Bild <---- keine Einschränkung der Einbaulaage aus MLFB567 erkennbar, nur O_EXX
        MLFB_05_06_07_1FG1S	HMK_O_EXX_ACHSE_1FG1S	PMD_AAA566_001_000_1FG1S	HMK_DMST_POS_BILD_1FG1S
    * /
    Null	No value, if selected motor is a std. asynchron. Motor or a servo motor
    1		M1, Output side A (geared motors)
    2		M2, Output side A (geared motors)
    3		M3, Output side A (geared motors)
    4		M4, Output side A (geared motors)
    5		M5, Output side A (geared motors)
    6		M6, Output side A (geared motors)
    7		M1, Output side B (geared motors)
    8		M2, Output side B (geared motors)
    9		M3, Output side B (geared motors)
    10		M4, Output side B (geared motors)
    11		M5, Output side B (geared motors)
    12		M6, Output side B (geared motors)

    PMD_AAA566_001_000_1FG1S 
    D01...D26
    
    Einbaulage						Getriebeart
    PMD_AAA566_001_000_1FG1S		PMD_ABV517_001_000_1FG1S
    D01...D06 	==> M1...M6			Z0002, Z0006
    D11...D16	==> M1-A...M6-A		Z0003, STSCHG
    D21...D26	==> M1-B...M6-B		Z0003, STSCHG    
    */
    var MLFB_05_06_07_1FG1S = sMLFB.charAt(4) + sMLFB.charAt(5) + sMLFB.charAt(6);
    var ECSI_CX_MountingPosition = parseInt(ECL_GetValue("ECSI_CX_MountingPosition")) || "";
    var PMD_AAA566_001_000_1FG1S = ECL_GetValue("PMD_AAA566_001_000_1FG1S") || "";

    // Einbaulage aus KAG-Liste herauslesen
    var sTargetAttribute = "PMD_AAA566_001_000_1FG1S";

    var sValue = "NON";
    var aResult = Object.fromDatabase("1FG1_ADD_DATA", "select distinct Wert_ID from DATA WHERE IsKAG = 'x' AND Attribute = '" + sTargetAttribute + "'");
    var sKAG_String = sMLFB.substr(16) || "";
    if (aResult.length > 0 && sKAG_String != "") {
        for (var i = 0; i < aResult.length; i++) {
            var sKAG = aResult[i].WERT_ID;
            if (sKAG_String.indexOf(sKAG) > -1) {
                sValue = sKAG;
                break;
            }
        }
    }
    if (sValue != "NON") {
        PMD_AAA566_001_000_1FG1S = sValue;
    } else {
        PMD_AAA566_001_000_1FG1S = ECL_GetValue("PMD_AAA566_001_000_1FG1S") || "";
    }


    //var HMK_O_EXX_ACHSE_1FG1S = ECL_GetValue("HMK_O_EXX_ACHSE_1FG1S") || "";
    if (ECSI_CX_MountingPosition > 6) {
        ECSI_CX_MountingPosition = ECSI_CX_MountingPosition - 6;
    }
    // letzte Stelle Einbaulage tauschen gegen neue MountingPosition
    var PMD_AAA566_001_000_1FG1S_NEU = PMD_AAA566_001_000_1FG1S.left(2) + ECSI_CX_MountingPosition;

    if (PMD_AAA566_001_000_1FG1S_NEU != PMD_AAA566_001_000_1FG1S) {
        sError = "ERRORMSG_MLFB_1FG1___CX_MountingPosition_Change";
        return sError;
    }
    /*	var sTargetAttribute = "O_E01_BIS_E37_1FG1S";
        var sKAG_List = sMLFB.substring(16);
        
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sValue = "NON";
        var aResult = Object.fromDatabase("1FG1_ADD_DATA", "select distinct Wert_ID from DATA WHERE IsKAG = 'x' AND Attribute = '" + sTargetAttribute + "'");
        
        if (aResult.length > 0 && (sKAG_List != "") ){
            for(var i=0;i<aResult.length;i++)
            {
                var sKAG = aResult[i].WERT_ID;
                if (sKAG_List.indexOf(sKAG) > -1){
                    sValue = sKAG;
                    break;
                }
            }
        }
        
        var sTable = "VT_1FG1S_M00085" + sDB_Suffix;
        var sSQL = "SELECT DISTINCT * FROM " + sTable + " WHERE " +
                    "O_E01_BIS_E37_1FG1S = '" + sValue + "';";
        
        var aResult = GetDBDataSetEXT(sSQL, sTable + "_CX");
        if (aResult.length > 0){
            var HMK_O_EXX_ACHSE_1FG1S = aResult[0].HMK_O_EXX_ACHSE_1FG1S;
        }else{
            sError = "ERRORMSG_MLFB_1FG1___MOTOR_DOES_NOT_FIT_CX_MountingPosition";
            return sError;
        }
        //var HMK_O_EXX_ACHSE_1FG1S = sValue;
        
        if (ECSI_CX_MountingPosition != "") && (PMD_AAA566_001_000_1FG1S != ""){
            var sTable = "VT_1FG1S_M00100" + sDB_Suffix;
            var sSQL = "SELECT * FROM "+sTable+" WHERE " +
                        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
                        "HMK_O_EXX_ACHSE_1FG1S = '" + HMK_O_EXX_ACHSE_1FG1S + "' AND " +
                        "PMD_AAA566_001_000_1FG1S = '" + PMD_AAA566_001_000_1FG1S + "';";
            
            var aResult = GetDBDataSetEXT(sSQL, sTable + "_CX");
            
            if (aResult.length < 1){
                // Fehler, die Mounting-Psition passt nicht zur Konfiguration!
                sError = "ERRORMSG_MLFB_1FG1___MOTOR_DOES_NOT_FIT_CX_MountingPosition";
                return sError;
            }
        }
    */	//--------------------------------------------------------------------------------------------------------------------------
    // MotorConnection
    // GearboxType???

    return "";
}