//@legacy
/**
*		Script for configuration object CFG_SIEMENS_1FK2

* 	Date: 2019-01-17
* 	User: Hans Martin Bauer, Plan Software GmbH
*		Mod:	2019-02-14 mb	Namenskonventionen umgesetzt
*					A_ --> ECSI_
*		Mod:	2019-02-27 mb	Namenskonventionen korrigiert
*		Mod:	2019-03-26 mb	Abhängigkeiten überarbeitet
*												ECSI_CC_MaxRotationSpeedLimit, ECSI_CC_AdditionalInertia
*		Mod:	2019-04-01 mb	Abhängigkeiten überarbeitet
*												ECSI_CX_StandardSupplySystem, ECSI_CX_EncoderTypeRough, ECSI_CC_MinPulseFrequency
*		Mod:	2019-04-02 mb	Änderung Werte für ECSI_CC_AdditionalInertia gem. Excel Dokument
*		Mod:	2019-04-08 mb	MLFB immer mit A0 am Ende besetzen wenn "."
*		Mod:	2019-05-15 mb	MLFB Aufbau wurde erweitert
*												Eingabe sperren wenn durch MLFB bestimmt
*/


//@import "SIZER_simplecfg_utils.js"

//@import "SIZER_general_functions.js"



//#mode(full-ecma)


/*
    Positionen 0 - 15
    1FK2													1FK2
    Trägheit											{1;2}
    Achshöhe (2)									{0}	{2;3;4}
    Baulänge											{0;1;2;3;4;5;6;7;8}
    A
    Wicklung/Bemessungsdrehzahl		{G;F;K}
    Bremse												{0;1}
    Schutzart											{0;1}
    Wellenende/Passfeder					{0;1;2}
    Geber													{S;M}
    A
    0
    
    SIZER liefert				xxxxxxxxxx....xx

    V_WELLENENDE_GLATT_ALTERNATIV_1FK2	wenn	1FK2.03.A..0..A0
    

    // erlaubte MLFBs
    1FK21021AG111MA0
    1FK21021AG111SA0
    1FK21032AG000MA0
    1FK21032AG000SA0
    1FK21044AK001MA0
    1FK21044AK001SA0
    1FK21044AK010MA0
    1FK21045AK111SA0
    1FK22032AG000MA0
    1FK22032AG000SA0

    // Basis MLFBs aus TIA Selection Tool
    1FK21020AG......
    1FK21021AG......
    1FK21032AG......
    1FK22032AG......
    1FK21034AG......
    1FK21044AK......
    1FK22034AG......
    1FK21045AK......
    
    NEU 15.05.19
    1FK22083AG......
    1FK23083AG......
    1FK22103AK......
    
    1FK21034AG002MA0
    
    mit Getriebe
    1FK2104-4AF..-....-Z A21 R03
*/


globalThis.OnChangeConfiguration = function main() {
    SetAttributesFromMlfb();

    // RegEx für eine Mindestanforderung an eine evt. gültige MLFB
    // vesch. Kombinationen sind dennoch falsch
    var s_regMlfb = "1FK2{1;2}{0;1;2}{0;2;3;4;5;6;8}{0;1;2;3;4;5;6;7;8}A{C;F;G;K}{0;1}{0;1}{0;1;2}{S;M}{A;B}0";
    var ek_status = {
        "s_OK": "OK",
        "s_ERR": "E",
        "s_PAT": ECL_Translate("MLFB_PATTERN_INVALID"),
        "s_POS": ECL_Translate("MLFB_POS_INVALID"),
        "s_LEN": ECL_Translate("MLFB_LENGTH_INVALID"),
        "s_SER": ECL_Translate("MLFB_SERIES_INVALID"),
        "s_INC": ECL_Translate("MLFB_INCOMPLETE"),
        "s_DEFAULT_POS15": "0"
    }

    var ca = ECL_GetCurrentAttribute();
    var v  = ECL_GetValue(ca);

    var s_mlfb = ECL_GetValue("ECSI_MLFB");
    
    if ((s_mlfb === '') && (ca != "@INIT@"))
        return;
    
    s_mlfb = s_mlfb.replace("?", ".").toUpperCase();
    
    var bfullMLFB=true;
    if(find(s_mlfb, ".")>-1)
        bfullMLFB=false;
    
    s_mlfb=manageKeepconfig(s_mlfb);
    
    //Bei Getriebeanbau kommen auch Kurzangaben mit
    s_mlfb = normalizeMLFB(s_mlfb);
    var aTokens=[];
    var aShortdescriptions=[];
    var aGearSD=[];
    
    if(find(s_mlfb, "-Z")>-1)
    {
        aTokens = tokenize(s_mlfb,true);
        s_mlfb=aTokens[0];
        
        for(var i=1;i<aTokens.length;i++)
            aShortdescriptions.push(aTokens[i]);
        
        for(var i=1;i<aTokens.length;i++)
        {
            var strSD=aTokens[i];
            if(strSD.left(1)!="M")
                aGearSD.push(aTokens[i]);
        }
    }
    
    var bmitGetriebe=false;
    if(aTokens.length>1)
        bmitGetriebe=true;
    
    // die Original einmal MLFB speichern
    saveMlfb(s_mlfb);

    if(ca === "@INIT@")
    {
        ECL_SetUserVariable("ORIGINAL_MLFB", "");

        ECL_DisableAttribute("ECSI_STATUS");
        ECL_DisableAttribute("ECSI_MLFB_BASE_TYPE");
        ECL_DeactivateAttribute("ECSI_MLFB_BASE_TYPE");
        ECL_DisableAttribute("ECSI_STATUS_MESSAGE");
        ECL_DisableAttribute("ECSI_MLFB_SEC");
        ECL_SetValue("ECSI_CC_MinPulseFrequency", "");
        ECL_DisableAttribute("ECSI_CC_MinPulseFrequency");

        // DEFAULTS
        ECL_SelectValue("A_BREMSE_1FK2", "V_BREMSE_OHNE_1FK2");
        ECL_SelectValue("A_SCHUTZART_1FK2", "V_SCHUTZART_IP64_1FK2");
        ECL_SelectValue("A_WELLENENDE_TYP_1FK2", "V_WELLENENDE_GLATT_1FK2");
        ECL_SelectValue("A_GEBER_1FK2", "V_GEBER_SINGLE_1FK2");
        
        ECL_SelectValue("A_FARBE_1FK2", "V_FARBE_A_1FK2");
        ECL_SelectValue("A_BAUFORM_1FK2", "V_BAUFORM_IMB5_1FK2");
        ECL_SelectValue("A_SCHWINGS_1FK2", "V_SCHWINGS_A_1FK2");
        ECL_DisableAttribute("A_FARBE_1FK2");
        ECL_DisableAttribute("A_BAUFORM_1FK2");
        ECL_DisableAttribute("A_SCHWINGS_1FK2");
    }
    
    if(!bmitGetriebe)
    {
        ECL_DeactivateAttributeGroup("CFG_GROUP___GETRIEBE_OPTIONS");
        ECL_DisableAttribute("A_GETRIEBE_WELLENENDE_1FK2");
        ECL_DisableAttribute("A_GETRIEBE_SCHMIERUNG_1FK2");
    }
    else
    {
        //Ausblenden, da intern bei Getriebanbau
        ECL_DeactivateAttribute("A_WELLENENDE_MASS_1FK2");
        ECL_DeactivateAttribute("A_WELLENENDE_TYP_1FK2");
    }
        
    //Default abhängig von der Installation
    if(ECL_GetValue("A_ANSCHLUSSTECHNIK_1FK2")=="")
    {
        var strInstallation=ECL_GetValue("ECSI_CX_Installation");
        if(strInstallation=="3")
            ECL_SelectValue("A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_2CC_1FK2");
        else if(strInstallation=="0" || strInstallation=="1" || strInstallation=="2")
            ECL_SelectValue("A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_OCC_1FK2");
    }
    
    // immer MLFB
    //------------------------------
    if(s_mlfb !== "")
    {
        if(isValidChar(s_mlfb, ".", 15))
            s_mlfb = replaceChar(s_mlfb, ek_status.s_DEFAULT_POS15, 15);
        ECL_SetUserVariable("MLFB", s_mlfb);
    }

    // MLFB ist FALSCH
    //------------------------------
    ECL_SelectValue("ECSI_STATUS", ek_status.s_ERR);
    ECL_ResetAttribute("ECSI_STATUS_MESSAGE");
    ECL_ResetAttribute("ECSI_MLFB_SEC");

    if(s_mlfb.length != 16)
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ek_status.s_LEN);
        ECL_SelectValue("ECSI_STATUS", "E");
        return;
    }
    if(s_mlfb.left(4) != "1FK2")
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ek_status.s_SER);
        ECL_SelectValue("ECSI_STATUS", "E");
        return;
    }
    
    if(bmitGetriebe)
    {
        if(ECL_GetValue("A_GETRIEBE_WELLENENDE_1FK2") == "")
            ECL_SelectValue("A_GETRIEBE_WELLENENDE_1FK2", "V_WELLENENDE_GETRIEBE_GLATT_1FK2");
        
        if(ECL_GetValue("A_GETRIEBE_SCHMIERUNG_1FK2") == "")
            ECL_SelectValue("A_GETRIEBE_SCHMIERUNG_1FK2", "V_GETRIEBE_SCHMIERUNG_STANDARD_1FK2");
    }

    // Auswahllisten auswerten
    if(ca === "ECSI_MLFB" && s_mlfb !== "")
    {
        filterValues(s_mlfb);
    }
    
    //Eventuell Default für Anschlusstechnik anpassen
    var strAnschlusstechnik = ECL_GetValue("A_ANSCHLUSSTECHNIK_1FK2")
    if(strAnschlusstechnik=="V_ANSCHLUSS_OCC_1FK2" && !ECL_ValueEnabled("A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_OCC_1FK2"))
    {
        ECL_SelectValue("A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_2CC_1FK2");
    }
    else if(strAnschlusstechnik=="V_ANSCHLUSS_2CC_1FK2" && !ECL_ValueEnabled("A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_2CC_1FK2"))
    {
        ECL_SelectValue("A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_OCC_1FK2");
    }
    else if(!ECL_ValueEnabled("A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_OCC_1FK2") && !ECL_ValueEnabled("A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_2CC_1FK2"))
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate("ERROR_1FK2___CONFIG_ANSCHUSSTECHNIK"));
        ECL_SelectValue("ECSI_STATUS", "E");
        return;
    }

    // Haupt MLFB - Anpassungen Dialog : Werte und Auswahllisten setzen
    if(ca === "ECSI_MLFB" && s_mlfb !== "")
    {
        s_mlfb = dlgSettings(s_mlfb);
        
        if(bmitGetriebe)
            dlgSettingsforSD(aShortdescriptions);

        ECL_SetUserVariable("MLFB", s_mlfb);
    }
        
    // evtl. geändert
    s_mlfb = ECL_GetUserVariable("MLFB");

    // Auswahllisten auswerten
    var bremse 	= ECL_GetValue("A_BREMSE_1FK2");
    var ip 		= ECL_GetValue("A_SCHUTZART_1FK2");
    var geber	= ECL_GetValue("A_GEBER_1FK2");
    var welle 	= ECL_GetValue("A_WELLENENDE_TYP_1FK2");
    var wellenmass = ECL_GetValue("A_WELLENENDE_MASS_1FK2");
    var anschlusstechnik = ECL_GetValue("A_ANSCHLUSSTECHNIK_1FK2");

    ECL_ResetAttribute("ECSI_STATUS");
    ECL_ResetAttribute("ECSI_STATUS_MESSAGE");

    // Bremse
    if(ca == "ECSI_MLFB" || ca == "A_BREMSE_1FK2")
    {
        if(bremse == "V_BREMSE_OHNE_1FK2")
        {
            s_mlfb = replaceChar(s_mlfb, "0", 10);
        }
        else if(bremse == "V_BREMSE_MIT_1FK2")
        {
            s_mlfb = replaceChar(s_mlfb, "1", 10);
        }
        else
        {
            s_mlfb = replaceChar(s_mlfb, ".", 10);
        }
        ECL_SetUserVariable("MLFB", s_mlfb);
    }

    // Schutzart
    if(ca == "ECSI_MLFB" || ca == "A_SCHUTZART_1FK2")
    {
        if(ip == "V_SCHUTZART_IP64_1FK2")
        {
            s_mlfb = replaceChar(s_mlfb, "0", 11);
        }
        else if(ip == "V_SCHUTZART_IP65_1FK2")
        {
            s_mlfb = replaceChar(s_mlfb, "1", 11);
        }
        ECL_SetUserVariable("MLFB", s_mlfb);
        welle = ECL_GetValue("A_WELLENENDE_TYP_1FK2");
        wellenmass = ECL_GetValue("A_WELLENENDE_MASS_1FK2");
    }
    
    //Achshöhe bestimmen aus MLFB
    var strAchshoehe="";
    var strSelect = "SELECT Achshoehe FROM Motor_Baugroesse WHERE MLFB_Pattern='"+s_mlfb.left(7)+"?????????"+"' ";
    var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
    if ( aResult.length == 1 )
    {
        strAchshoehe=aResult[0].ACHSHOEHE;
    }
    else
    {
        logtraceln("Fehler bei der Bestimmung der Achshöhe, SQL="+strSelect);
    }
    
    //mögliche Wellenendentypen und Masse bestimmen
    
    ECL_DeactivateAllAttributeValues("A_WELLENENDE_TYP_1FK2");
    if(bmitGetriebe)
    {
        var aResult = checkmoeglicheMotorwellen_TypbeiGetriebeanbau(strAchshoehe, aGearSD);
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
                ECL_ActivateValue("A_WELLENENDE_TYP_1FK2", aResult[i]);
        }
        else
        {
            logtraceln("Fehler bei der Bestimmung des Wellentyps bei Getriebeanbau");
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_1FK2___MOTORSHAFT_TYPE_ERROR"));
            return;
        }
    }
    else
    {
        var strSelect="SELECT Wellenende_Typ from Wellenende_Motor WHERE Achshoehe='"+strAchshoehe+"' ";
        var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
                ECL_ActivateValue("A_WELLENENDE_TYP_1FK2", aResult[i].WELLENENDE_TYP);
        }
        else
        {
            logtraceln("Fehler bei der Bestimmung des Wellentyps, SQL="+strSelect);
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_1FK2___MOTORSHAFT_TYPE_ERROR"));
            return;
        }
    }
    
    
    ECL_DeactivateAllAttributeValues("A_WELLENENDE_MASS_1FK2");
    if(bmitGetriebe)
    {
        var aResult = checkmoeglicheMotorwellen_MassbeiGetriebeanbau(strAchshoehe, aGearSD);
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("A_WELLENENDE_MASS_1FK2", aResult[i]);
            }
            
            var btest=false;
            for(var i=0;i<aResult.length;i++)
            {
                if(aResult[i]==ECL_GetValue("A_WELLENENDE_MASS_1FK2"))
                    btest=true;
            }
    
            if(ECL_GetValue("A_WELLENENDE_MASS_1FK2") == "" || !btest)
            {
                ECL_SetValue("A_WELLENENDE_MASS_1FK2",aResult[0] );
            }
        }
        else
        {
            logtraceln("Fehler bei der Bestimmung des Wellenmass bei Getriebeanbau");
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_1FK2___MOTORSHAFT_MASS_ERROR"));
            return;
        }
    }
    else
    {
        var strSelect="SELECT Wellenende_Mass from Wellenende_Motor WHERE Achshoehe='"+strAchshoehe+"' AND Wellenende_Typ='"+welle+"' ";
        var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("A_WELLENENDE_MASS_1FK2", aResult[i].WELLENENDE_MASS);
            }
            
            if(ECL_GetValue("A_WELLENENDE_MASS_1FK2") == "")
            {
                ECL_SetValue("A_WELLENENDE_MASS_1FK2",aResult[0].WELLENENDE_MASS );
            }
            
            //Bei BG 30, 40 und IP65 ist die alternative, kleinere Welle nicht möglich	
            if(strAchshoehe=="30" && ip == "V_SCHUTZART_IP65_1FK2")
            {
                ECL_DeactivateValue("A_WELLENENDE_MASS_1FK2", "V_11x32_1FK2");
                if(ECL_ValueSelected("A_WELLENENDE_MASS_1FK2", "V_11x32_1FK2"))
                    ECL_SelectValue("A_WELLENENDE_MASS_1FK2", "V_14x30_1FK2")
            }
            else if(strAchshoehe=="40" && ip == "V_SCHUTZART_IP65_1FK2")
            {
                ECL_DeactivateValue("A_WELLENENDE_MASS_1FK2", "V_14x30_1FK2");
                if(ECL_ValueSelected("A_WELLENENDE_MASS_1FK2", "V_14x30_1FK2"))
                    ECL_SelectValue("A_WELLENENDE_MASS_1FK2", "V_19x40_1FK2")
            }
        }
        else
        {
            logtraceln("Fehler bei der Bestimmung des Wellenmass, SQL="+strSelect);
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_1FK2___MOTORSHAFT_MASS_ERROR"));
            return;
        }
    }
    
    // Welle
    if(ca == "ECSI_MLFB" || ca == "A_WELLENENDE_TYP_1FK2" || ca == "A_WELLENENDE_MASS_1FK2" || ca == "A_SCHUTZART_1FK2")
    {
        ECL_ActivateValue("A_SCHUTZART_1FK2", "V_SCHUTZART_IP65_1FK2");
        
        if(ca == "A_WELLENENDE_TYP_1FK2")
        {
            //alternative Wellengeometrie nur bei glatter Welle möglich
            if(welle=="V_WELLENENDE_P_1FK2")
            {
                var amoeglichewellenmasse=ECL_GetAllActiveAttributeValues ("A_WELLENENDE_MASS_1FK2");
                ECL_SetValue("A_WELLENENDE_MASS_1FK2",amoeglichewellenmasse[0]);
            }
        }
        
        welle 	= ECL_GetValue("A_WELLENENDE_TYP_1FK2");
        wellenmass = ECL_GetValue("A_WELLENENDE_MASS_1FK2");
        
        //MLFB Bestimmung
        var strSelect = "SELECT MLFB_STELLE_13 FROM Wellenende_Motor WHERE Achshoehe='"+strAchshoehe+"' AND Wellenende_Typ='"+welle+"' AND Wellenende_Mass='"+wellenmass+"'";
        var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
        if ( aResult.length == 1 )
        {
            s_mlfb = replaceChar(s_mlfb, aResult[0].MLFB_STELLE_13, 12);
        }
        else
        {
            logtraceln("Fehler bei der MLFB für Welle, SQL="+strSelect);
        }
        
        ECL_SetUserVariable("MLFB", s_mlfb);
        ip = ECL_GetValue("A_SCHUTZART_1FK2");
    }

    // Geber
    if(ca == "ECSI_MLFB" || ca == "A_GEBER_1FK2")
    {
        if(geber == "V_GEBER_SINGLE_1FK2")
            s_mlfb = replaceChar(s_mlfb, "S", 13);
        else if(geber == "V_GEBER_MULTI_1FK2")
            s_mlfb = replaceChar(s_mlfb, "M", 13);
        else if(ca == "ECSI_MLFB")
            s_mlfb = replaceChar(s_mlfb, ".", 13);
        ECL_SetUserVariable("MLFB", s_mlfb);
    }
    
    //Anschlusstechnik
    if(ca == "ECSI_MLFB" || ca == "A_ANSCHLUSSTECHNIK_1FK2")
    {
        if(anschlusstechnik=="V_ANSCHLUSS_OCC_1FK2")
        {
            s_mlfb = replaceChar(s_mlfb, "A", 14);
        }
        else if(anschlusstechnik=="V_ANSCHLUSS_2CC_1FK2")
        {
            s_mlfb = replaceChar(s_mlfb, "B", 14);
        }
    }
    
    //Getriebe
    //Keine Abhängigkeiten
    //nur MLFB Bestimmung
    
    var strSDGetriebeOption="";
    if(bmitGetriebe)
    {
        ECL_ActivateAttributeGroup("CFG_GROUP___GETRIEBE_OPTIONS");
        ECL_EnableAttribute("A_GETRIEBE_WELLENENDE_1FK2");
        ECL_EnableAttribute("A_GETRIEBE_SCHMIERUNG_1FK2");
    }
    
    if(ca == "ECSI_MLFB" || ca == "A_GETRIEBE_WELLENENDE_1FK2" || ca == "A_GETRIEBE_SCHMIERUNG_1FK2")
    {
        if(ECL_ValueSelected("A_GETRIEBE_WELLENENDE_1FK2","V_WELLENENDE_GETRIEBE_GLATT_1FK2") && ECL_ValueSelected("A_GETRIEBE_SCHMIERUNG_1FK2","V_GETRIEBE_SCHMIERUNG_STANDARD_1FK2"))
            strSDGetriebeOption="M00";
        else if(ECL_ValueSelected("A_GETRIEBE_WELLENENDE_1FK2","V_WELLENENDE_GETRIEBE_GLATT_1FK2") && ECL_ValueSelected("A_GETRIEBE_SCHMIERUNG_1FK2","V_GETRIEBE_SCHMIERUNG_LEBENSMITTELFETT_1FK2"))
            strSDGetriebeOption="M10";
        else if(ECL_ValueSelected("A_GETRIEBE_WELLENENDE_1FK2","V_WELLENENDE_GETRIEBE_PASSFEDER_1FK2") && ECL_ValueSelected("A_GETRIEBE_SCHMIERUNG_1FK2","V_GETRIEBE_SCHMIERUNG_STANDARD_1FK2"))
            strSDGetriebeOption="M01";
        else if(ECL_ValueSelected("A_GETRIEBE_WELLENENDE_1FK2","V_WELLENENDE_GETRIEBE_PASSFEDER_1FK2") && ECL_ValueSelected("A_GETRIEBE_SCHMIERUNG_1FK2","V_GETRIEBE_SCHMIERUNG_LEBENSMITTELFETT_1FK2"))
            strSDGetriebeOption="M11";
            
            
        var aSD=[];
        for(var i=0;i<aShortdescriptions.length;i++)
        {
            var strSD=aShortdescriptions[i];
            if(strSD.left(1) != "M")
                aSD.push(aShortdescriptions[i]);
        }
        
        aSD.push(strSDGetriebeOption);
        aSD.sort();
        
        aShortdescriptions=aSD;
    }
    
    //Überprüfung BremsenContext
    var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    if(strwithBrake=="1")
    {
        if(bfullMLFB)
        {
            /*
            if(ECL_ValueSelected("A_BREMSE_1FK2","V_BREMSE_OHNE_1FK2"))
            {
                ECL_SelectValue("ECSI_STATUS", "E");
                ECL_SetValue("ECSI_STATUS_MESSAGE", translate("ERROR_1FK2___CX_CONTEXT_ATTRIBUTES_BRAKE"));
                return;
            }
            else
            {
                ECL_DisableAttribute("A_BREMSE_1FK2");
            }
            */
            
            // Bremsecontext jetzt änderbar Release 2021.04
            ECL_SelectValue("A_BREMSE_1FK2", "V_BREMSE_MIT_1FK2");
            ECL_DisableAttribute("A_BREMSE_1FK2");
    
            if(ECL_GetValue("A_BREMSE_1FK2") == "V_BREMSE_OHNE_1FK2")
            {
                s_mlfb = replaceChar(s_mlfb, "0", 10);
            }
            else if(ECL_GetValue("A_BREMSE_1FK2") == "V_BREMSE_MIT_1FK2")
            {
                s_mlfb = replaceChar(s_mlfb, "1", 10);
            }
            else
            {
                s_mlfb = replaceChar(s_mlfb, ".", 10);
            }
            
            ECL_SetUserVariable("MLFB", s_mlfb);
        }
        else
        {
            ECL_SelectValue("A_BREMSE_1FK2", "V_BREMSE_MIT_1FK2");
            ECL_DisableAttribute("A_BREMSE_1FK2");
    
            if(ECL_GetValue("A_BREMSE_1FK2") == "V_BREMSE_OHNE_1FK2")
            {
                s_mlfb = replaceChar(s_mlfb, "0", 10);
            }
            else if(ECL_GetValue("A_BREMSE_1FK2") == "V_BREMSE_MIT_1FK2")
            {
                s_mlfb = replaceChar(s_mlfb, "1", 10);
            }
            else
            {
                s_mlfb = replaceChar(s_mlfb, ".", 10);
            }
            
            ECL_SetUserVariable("MLFB", s_mlfb);
        }
    }
    else if(strwithBrake=="0")
    {
        ECL_EnableAttribute("A_BREMSE_1FK2");
        
        //tfreichel Bremsencontex 4.07 deaktiviert / wieder aktiviert für release 2021.04
        if(bfullMLFB)
        {
            /*
            if(ECL_ValueSelected("A_BREMSE_1FK2","V_BREMSE_MIT_1FK2"))
            {
                ECL_SelectValue("ECSI_STATUS", "E");
                ECL_SetValue("ECSI_STATUS_MESSAGE", translate("ERROR_1FK2___CX_CONTEXT_ATTRIBUTES_BRAKE"));
                return;
            }
            else
            {
                ECL_DisableAttribute("A_BREMSE_1FK2");
            }
            */
            
            // Bremsecontext jetzt änderbar Release 2021.04
            ECL_SelectValue("A_BREMSE_1FK2", "V_BREMSE_OHNE_1FK2");
            ECL_DisableAttribute("A_BREMSE_1FK2");
    
            if(ECL_GetValue("A_BREMSE_1FK2") == "V_BREMSE_OHNE_1FK2")
            {
                s_mlfb = replaceChar(s_mlfb, "0", 10);
            }
            else if(ECL_GetValue("A_BREMSE_1FK2") == "V_BREMSE_MIT_1FK2")
            {
                s_mlfb = replaceChar(s_mlfb, "1", 10);
            }
            else
            {
                s_mlfb = replaceChar(s_mlfb, ".", 10);
            }
            
            ECL_SetUserVariable("MLFB", s_mlfb);
        }
        else
        {
            ECL_SelectValue("A_BREMSE_1FK2", "V_BREMSE_OHNE_1FK2");
            ECL_DisableAttribute("A_BREMSE_1FK2");
    
            if(ECL_GetValue("A_BREMSE_1FK2") == "V_BREMSE_OHNE_1FK2")
            {
                s_mlfb = replaceChar(s_mlfb, "0", 10);
            }
            else if(ECL_GetValue("A_BREMSE_1FK2") == "V_BREMSE_MIT_1FK2")
            {
                s_mlfb = replaceChar(s_mlfb, "1", 10);
            }
            else
            {
                s_mlfb = replaceChar(s_mlfb, ".", 10);
            }
            
            ECL_SetUserVariable("MLFB", s_mlfb);
        }
    }
    
    if(s_mlfb.indexOf(".") > -1)
    {
        ECL_SetValue("ECSI_MLFB", s_mlfb);
        ECL_SetValue("ECSI_STATUS_MESSAGE", ek_status.s_INC);
        return;
    }
    
    ECL_SelectValue("ECSI_STATUS", ek_status.s_OK);
    ECL_ResetAttribute("ECSI_STATUS_MESSAGE");
    
    // CONSEQUENCES
    //------------------------------
    ECL_SetValue("ECSI_CC_BrakeID","");
    evalCC(s_mlfb);
    
    //Dependencies for Adapter Coupling
    var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
    if(strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1)
    {
        //1FK21044AF......
        //Abhägigkeit zur Schutzart
        ECL_DeactivateValue("A_SCHUTZART_1FK2","V_SCHUTZART_IP65_1FK2");
        ECL_SelectValue("A_SCHUTZART_1FK2","V_SCHUTZART_IP64_1FK2");
        s_mlfb = replaceChar(s_mlfb, "0", 11);
        ECL_DisableAttribute("A_SCHUTZART_1FK2");
        
        //Abhänigkeit zur Welle
        ECL_DeactivateValue("A_WELLENENDE_TYP_1FK2","V_WELLENENDE_P_1FK2");
        ECL_SelectValue("A_WELLENENDE_TYP_1FK2","V_WELLENENDE_GLATT_1FK2");
        ECL_DisableAttribute("A_WELLENENDE_TYP_1FK2");
        
        welle 	= ECL_GetValue("A_WELLENENDE_TYP_1FK2");
        
        //Abhängigkeit Wellenmass
        //Bei BG 30, 40 und IP65 ist die alternative, kleinere Welle nicht möglich	
        if(strAchshoehe=="30")
        {
            ECL_DeactivateValue("A_WELLENENDE_MASS_1FK2", "V_11x32_1FK2");
            if(ECL_ValueSelected("A_WELLENENDE_MASS_1FK2", "V_11x32_1FK2"))
                ECL_SelectValue("A_WELLENENDE_MASS_1FK2", "V_14x30_1FK2")
        }
        else if(strAchshoehe=="40")
        {
            ECL_DeactivateValue("A_WELLENENDE_MASS_1FK2", "V_14x30_1FK2");
            if(ECL_ValueSelected("A_WELLENENDE_MASS_1FK2", "V_14x30_1FK2"))
                ECL_SelectValue("A_WELLENENDE_MASS_1FK2", "V_19x40_1FK2")
        }
        wellenmass = ECL_GetValue("A_WELLENENDE_MASS_1FK2");
        
        //MLFB Bestimmung
        var strSelect = "SELECT MLFB_STELLE_13 FROM Wellenende_Motor WHERE Achshoehe='"+strAchshoehe+"' AND Wellenende_Typ='"+welle+"' AND Wellenende_Mass='"+wellenmass+"'";
        var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
        if ( aResult.length == 1 )
        {
            s_mlfb = replaceChar(s_mlfb, aResult[0].MLFB_STELLE_13, 12);
        }
        else
        {
            logtraceln("Fehler bei der MLFB für Welle, SQL="+strSelect);
        }
    }
    
    //Dependencies for Drive Train
    var strECSI_CX_DriveTrain = ECL_GetValue("ECSI_CX_IsDriveTrain");
    if(strECSI_CX_DriveTrain && parseInt(strECSI_CX_DriveTrain) == "1")
    {
        //Abhängigkeit zur Welle
        ECL_DeactivateValue("A_WELLENENDE_TYP_1FK2","V_WELLENENDE_P_1FK2");
        ECL_SelectValue("A_WELLENENDE_TYP_1FK2","V_WELLENENDE_GLATT_1FK2");
        s_mlfb = replaceChar(s_mlfb, "0", 12);
        ECL_DisableAttribute("A_WELLENENDE_TYP_1FK2");
        
        //Bei BG 30, 40 und IP65 ist die alternative, kleinere Welle nicht möglich	
        if(strAchshoehe=="30")
        {
            ECL_DeactivateValue("A_WELLENENDE_MASS_1FK2", "V_11x32_1FK2");
            if(ECL_ValueSelected("A_WELLENENDE_MASS_1FK2", "V_11x32_1FK2"))
                ECL_SelectValue("A_WELLENENDE_MASS_1FK2", "V_14x30_1FK2")
        }
        else if(strAchshoehe=="40")
        {
            ECL_DeactivateValue("A_WELLENENDE_MASS_1FK2", "V_14x30_1FK2");
            if(ECL_ValueSelected("A_WELLENENDE_MASS_1FK2", "V_14x30_1FK2"))
                ECL_SelectValue("A_WELLENENDE_MASS_1FK2", "V_19x40_1FK2")
        }
        
        welle 	= ECL_GetValue("A_WELLENENDE_TYP_1FK2");
        wellenmass = ECL_GetValue("A_WELLENENDE_MASS_1FK2");
        
        //MLFB Bestimmung
        var strSelect = "SELECT MLFB_STELLE_13 FROM Wellenende_Motor WHERE Achshoehe='"+strAchshoehe+"' AND Wellenende_Typ='"+welle+"' AND Wellenende_Mass='"+wellenmass+"'";
        var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
        if ( aResult.length == 1 )
        {
            s_mlfb = replaceChar(s_mlfb, aResult[0].MLFB_STELLE_13, 12);
        }
        else
        {
            logtraceln("Fehler bei der MLFB für Welle, SQL="+strSelect);
        }
    }
    
    //Dependecies for cable
    var strAnschlusstechnik = ECL_GetValue("A_ANSCHLUSSTECHNIK_1FK2")
    if(strAnschlusstechnik=="V_ANSCHLUSS_OCC_1FK2")
    {
        ECL_SelectValue("ECSI_CC_NoPhysicalDQConnectionNeeded", "true");
    }
    else if(strAnschlusstechnik=="V_ANSCHLUSS_2CC_1FK2")
    {
        ECL_SelectValue("ECSI_CC_NoPhysicalDQConnectionNeeded", "false");
    }
    
    //Kurzangaben ergänzen
    if(bmitGetriebe)
    {
        s_mlfb = s_mlfb+"-Z "+ aShortdescriptions[0]+"+"+aShortdescriptions[1]+"+"+aShortdescriptions[2];
    }
    
    ECL_SetValue("ECSI_MLFB", s_mlfb);
}

//------------------------------
//------------------------------


/**
    Anpassungen Dialog abh. von MLFB
    geänderte MLFB zurückliefern
*/
function dlgSettings(mlfb)
{
    ECL_ActivateValue("A_SCHUTZART_1FK2", "V_SCHUTZART_IP65_1FK2");

    if(isValidChar(mlfb, "0", 10))
    {
        ECL_SelectValue("A_BREMSE_1FK2", "V_BREMSE_OHNE_1FK2");
    }
    else if(isValidChar(mlfb, "1", 10))
    {
        ECL_SelectValue("A_BREMSE_1FK2", "V_BREMSE_MIT_1FK2");
    }

    if(isValidChar(mlfb, "0", 11)) 
    {
        ECL_SelectValue("A_SCHUTZART_1FK2", "V_SCHUTZART_IP64_1FK2");
    }
    else if(isValidChar(mlfb, "1", 11)) 
    {
        ECL_SelectValue("A_SCHUTZART_1FK2", "V_SCHUTZART_IP65_1FK2");
    }

    
    //Aus Stelle 13 die Attribute bestimmen
    //Achshöhe bestimmen aus MLFB
    var strAchshoehe="";
    var strSelect = "SELECT Achshoehe FROM Motor_Baugroesse WHERE MLFB_Pattern='"+mlfb.left(7)+"?????????"+"' ";
    var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
    if ( aResult.length == 1 )
    {
        strAchshoehe=aResult[0].ACHSHOEHE;
    }
    else
    {
        logtraceln("Fehler bei der Bestimmung der Achshöhe, SQL="+strSelect);
    }
    
    var strSelect = "SELECT Wellenende_Typ,Wellenende_Mass FROM Wellenende_Motor WHERE Achshoehe='"+strAchshoehe+"' AND MLFB_STELLE_13='"+mlfb.charAt(12)+"' ";
    var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
    if ( aResult.length == 1 )
    {
        ECL_SetValue("A_WELLENENDE_TYP_1FK2", aResult[0].WELLENENDE_TYP);
        ECL_SetValue("A_WELLENENDE_MASS_1FK2", aResult[0].WELLENENDE_MASS);
    }
    else
    {
        logtraceln("Fehler bei der MLFB für Welle, SQL="+strSelect);
    }
    
    if(isValidChar(mlfb, "S", 13)) 
    {
        ECL_SelectValue("A_GEBER_1FK2", "V_GEBER_SINGLE_1FK2");
    }
    else if(isValidChar(mlfb, "M", 13)) 
    {
        ECL_SelectValue("A_GEBER_1FK2", "V_GEBER_MULTI_1FK2");
    }
    
    if(isValidChar(mlfb, "A", 14)) 
    {
        ECL_SelectValue("A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_OCC_1FK2");
    }
    else if(isValidChar(mlfb, "B", 14)) 
    {
        ECL_SelectValue("A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_2CC_1FK2");
    }

    return mlfb;
}

function dlgSettingsforSD(aShortdescriptions)
{
    
    for(var i=0;i<aShortdescriptions.length;i++)
    {
        var strSD = aShortdescriptions[i];
        if(strSD.left(1)=="M")
        {
            if(strSD=="M00")
            {
                ECL_SetValue("A_GETRIEBE_WELLENENDE_1FK2","V_WELLENENDE_GETRIEBE_GLATT_1FK2");
                ECL_SetValue("A_GETRIEBE_SCHMIERUNG_1FK2","V_GETRIEBE_SCHMIERUNG_STANDARD_1FK2");
            }
            else if(strSD=="M01")
            {
                ECL_SetValue("A_GETRIEBE_WELLENENDE_1FK2","V_WELLENENDE_GETRIEBE_PASSFEDER_1FK2");
                ECL_SetValue("A_GETRIEBE_SCHMIERUNG_1FK2","V_GETRIEBE_SCHMIERUNG_STANDARD_1FK2");
            }
            else if(strSD=="M10")
            {
                ECL_SetValue("A_GETRIEBE_WELLENENDE_1FK2","V_WELLENENDE_GETRIEBE_GLATT_1FK2");
                ECL_SetValue("A_GETRIEBE_SCHMIERUNG_1FK2","V_GETRIEBE_SCHMIERUNG_LEBENSMITTELFETT_1FK2");
            }
            else if(strSD=="M11")
            {
                ECL_SetValue("A_GETRIEBE_WELLENENDE_1FK2","V_WELLENENDE_GETRIEBE_PASSFEDER_1FK2");
                ECL_SetValue("A_GETRIEBE_SCHMIERUNG_1FK2","V_GETRIEBE_SCHMIERUNG_LEBENSMITTELFETT_1FK2");
            }
        }
    }
}

/**
    zulässige Werte bei MLFB Positionen prüfen
*/
function isMlfbValid(mlfb)
{
    return true;
}


/**
    zulässige Werte bei MLFB Positionen prüfen
*/
function isMlfbPosValid(value, pos)
{
    // diese MLFB Position darf geändert werden
    if(! isMlfbPosFix())
        return true;
    // keine Änderung erlaubt, aber der neue Wert muss identisch mit aktuellem sein
    var mlfb = ECL_GetUserVariable("ORIGINAL_MLFB");
    if(isValidChar(mlfb, "."+value, pos))
        return true;
    // Fehlerstatus setzen
    ECL_SelectValue("ECSI_STATUS", ek_status.s_ERR);
    ECL_SetValue("ECSI_STATUS_MESSAGE", ek_status.s_POS);
    return false;
}

/**
    Consequences setzen abh. von Bremse
*/
function evalCC(mlfb)
{
    ECL_SetValue("ECSI_CC_MinPulseFrequency", "");

    if(EK_regFound(mlfb, "1FK2?04?AK?????"))
    {
        var str_CxSSS = ECL_GetValue("ECSI_CX_StandardSupplySystem");
        str_CxSSS = str_CxSSS.replace(" ", "");
        if(str_CxSSS.length == 1 && isValidChar(str_CxSSS, "278", 0))
            ECL_SetValue("ECSI_CC_MinPulseFrequency", "8");
    }
    
    /*
        weitere Werte aus Excel für die 3 MLFBs (falls benötigt)
    
        Spannung:					immer 24

        Strombedarf:			0.317647058823529 / 0.411764705882353 / 0.635294117647059

        Verlustleistung:	0.00162	/ 0.0021 / 0.00324

        Spannung_Bremse:
        Erster Wert: Max Spannung bei S210 | Zweiter Wert klassische Schaltung bei S120
        33 | 24 / 33 | 24 / 33 | 24
    
        Strombedarf_Bremse:
        Erster Wert = Strombelastung der 24V Versorgung bei klassuscher Ansteuerung | Zweiter Wert = Strombelastung der 24V Versorgung bei Übererregung (für 0,5 Sekunden)
        0,6 | 0,32 / 0,78 | 0,41 / 1,2 | 0,64

        Verlustleistung_Bremse:
        Erster Wert Wert ist für die innovierte Bremsenansteuerung im S210 | Zweiter Wert ist für die Verlustleistung bei klasssicher Ansteuerung mit 24V z.B. am S120 
        0,22 | 1,75 / 0,37 | 2,92 / 0,87 | 7,00
    */
    
    //BrakeID Consequence
    
    // DC3_* für S210
    // DC_* für S120
    
    
    var strBrakeID="";
    
    if(ECL_ValueSelected("A_ANSCHLUSSTECHNIK_1FK2","V_ANSCHLUSS_OCC_1FK2"))
    {
    
        if(EK_regFound(mlfb, "1FK21020..1...A."))
        {
            strBrakeID="DC3_1FK2102-0";
        }
        else if(EK_regFound(mlfb, "1FK21021..1...A."))
        {
            strBrakeID="DC3_1FK2102-1";
        }
        else if(EK_regFound(mlfb, "1FK21032..1...A."))
        {
            strBrakeID="DC3_1FK2103-2";
        }
        else if(EK_regFound(mlfb, "1FK21034..1...A."))
        {
            strBrakeID="DC3_1FK2103-4";
        }
        else if(EK_regFound(mlfb, "1FK22032..1...A."))
        {
            strBrakeID="DC3_1FK2203-2";
        }
        else if(EK_regFound(mlfb, "1FK22034..1...A."))
        {
            strBrakeID="DC3_1FK2203-4";
        }
        else if(EK_regFound(mlfb, "1FK21044..1...A."))
        {
            strBrakeID="DC3_1FK2104-4";
        }
        else if(EK_regFound(mlfb, "1FK21045..1...A."))
        {
            strBrakeID="DC3_1FK2104-5";
        }
        else if(EK_regFound(mlfb, "1FK21046..1...A."))
        {
            strBrakeID="DC3_1FK2104-6";
        }
        else if(EK_regFound(mlfb, "1FK22045..1...A."))
        {
            strBrakeID="DC3_1FK2204-5";
        }
        else if(EK_regFound(mlfb, "1FK22046..1...A."))
        {
            strBrakeID="DC3_1FK2204-6";
        }
        else if(EK_regFound(mlfb, "1FK21054..1...A."))
        {
            strBrakeID="DC3_1FK2105-4";
        }
        else if(EK_regFound(mlfb, "1FK21056..1...A."))
        {
            strBrakeID="DC3_1FK2105-6";
        }
        else if(EK_regFound(mlfb, "1FK22052..1...A."))
        {
            strBrakeID="DC3_1FK2205-2";
        }
        else if(EK_regFound(mlfb, "1FK22054..1...A."))
        {
            strBrakeID="DC3_1FK2205-4";
        }
        else if(EK_regFound(mlfb, "1FK21063..1...A."))
        {
            strBrakeID="DC3_1FK2106-3";
        }
        else if(EK_regFound(mlfb, "1FK21064..1...A."))
        {
            strBrakeID="DC3_1FK2106-4";
        }
        else if(EK_regFound(mlfb, "1FK21066..1...A."))
        {
            strBrakeID="DC3_1FK2106-6";
        }
        else if(EK_regFound(mlfb, "1FK22062..1...A."))
        {
            strBrakeID="DC3_1FK2206-2";
        }
        else if(EK_regFound(mlfb, "1FK22064..1...A."))
        {
            strBrakeID="DC3_1FK2206-4";
        }
        else if(EK_regFound(mlfb, "1FK23062..1...A."))
        {
            strBrakeID="DC3_1FK2306-2";
        }
        else if(EK_regFound(mlfb, "1FK23064..1...A."))
        {
            strBrakeID="DC3_1FK2306-4";
        }
        else if(EK_regFound(mlfb, "1FK22083..1...A."))
        {
            strBrakeID="DC3_1FK2208-3";
        }
        else if(EK_regFound(mlfb, "1FK23083..1...A."))
        {
            strBrakeID="DC3_1FK2308-3";
        }
        else if(EK_regFound(mlfb, "1FK23084..1...A."))
        {
            strBrakeID="DC3_1FK2308-4";
        }
        else if(EK_regFound(mlfb, "1FK22084..1...A."))
        {
            strBrakeID="DC3_1FK2208-4";
        }
        else if(EK_regFound(mlfb, "1FK22085..1...A."))
        {
            strBrakeID="DC3_1FK2208-5";
        }
        else if(EK_regFound(mlfb, "1FK22103..1...A."))
        {
            strBrakeID="DC3_1FK2210-3";
        }
        else if(EK_regFound(mlfb, "1FK22104..1...A."))
        {
            strBrakeID="DC3_1FK2210-4";
        }
        else if(EK_regFound(mlfb, "1FK22105..1...A."))
        {
            strBrakeID="DC3_1FK2210-5";
        }
    }
    else
    {
        //DC
        if(EK_regFound(mlfb, "1FK21020..1...B."))
        {
            strBrakeID="DC_1FK2102-0";
        }
        else if(EK_regFound(mlfb, "1FK21021..1...B."))
        {
            strBrakeID="DC_1FK2102-1";
        }
        else if(EK_regFound(mlfb, "1FK21032..1...B."))
        {
            strBrakeID="DC_1FK2103-2";
        }
        else if(EK_regFound(mlfb, "1FK21034..1...B."))
        {
            strBrakeID="DC_1FK2103-4";
        }
        else if(EK_regFound(mlfb, "1FK22032..1...B."))
        {
            strBrakeID="DC_1FK2203-2";
        }
        else if(EK_regFound(mlfb, "1FK22034..1...B."))
        {
            strBrakeID="DC_1FK2203-4";
        }
        else if(EK_regFound(mlfb, "1FK21044..1...B."))
        {
            strBrakeID="DC_1FK2104-4";
        }
        else if(EK_regFound(mlfb, "1FK21045..1...B."))
        {
            strBrakeID="DC_1FK2104-5";
        }
        else if(EK_regFound(mlfb, "1FK21046..1...B."))
        {
            strBrakeID="DC_1FK2104-6";
        }
        else if(EK_regFound(mlfb, "1FK22045..1...B."))
        {
            strBrakeID="DC_1FK2204-5";
        }
        else if(EK_regFound(mlfb, "1FK22046..1...B."))
        {
            strBrakeID="DC_1FK2204-6";
        }
        else if(EK_regFound(mlfb, "1FK21054..1...B."))
        {
            strBrakeID="DC_1FK2105-4";
        }
        else if(EK_regFound(mlfb, "1FK21056..1...B."))
        {
            strBrakeID="DC_1FK2105-6";
        }
        else if(EK_regFound(mlfb, "1FK22052..1...B."))
        {
            strBrakeID="DC_1FK2205-2";
        }
        else if(EK_regFound(mlfb, "1FK22054..1...B."))
        {
            strBrakeID="DC_1FK2205-4";
        }
        else if(EK_regFound(mlfb, "1FK21063..1...B."))
        {
            strBrakeID="DC_1FK2106-3";
        }
        else if(EK_regFound(mlfb, "1FK21064..1...B."))
        {
            strBrakeID="DC_1FK2106-4";
        }
        else if(EK_regFound(mlfb, "1FK21066..1...B."))
        {
            strBrakeID="DC_1FK2106-6";
        }
        else if(EK_regFound(mlfb, "1FK22062..1...B."))
        {
            strBrakeID="DC_1FK2206-2";
        }
        else if(EK_regFound(mlfb, "1FK22064..1...B."))
        {
            strBrakeID="DC_1FK2206-4";
        }
        else if(EK_regFound(mlfb, "1FK23062..1...B."))
        {
            strBrakeID="DC_1FK2306-2";
        }
        else if(EK_regFound(mlfb, "1FK23064..1...B."))
        {
            strBrakeID="DC_1FK2306-4";
        }
        else if(EK_regFound(mlfb, "1FK22083..1...B."))
        {
            strBrakeID="DC_1FK2208-3";
        }
        else if(EK_regFound(mlfb, "1FK23083..1...B."))
        {
            strBrakeID="DC_1FK2308-3";
        }
        else if(EK_regFound(mlfb, "1FK23084..1...B."))
        {
            strBrakeID="DC_1FK2308-4";
        }
        else if(EK_regFound(mlfb, "1FK22084..1...B."))
        {
            strBrakeID="DC_1FK2208-4";
        }
        else if(EK_regFound(mlfb, "1FK22085..1...B."))
        {
            strBrakeID="DC_1FK2208-5";
        }
        else if(EK_regFound(mlfb, "1FK22103..1...B."))
        {
            strBrakeID="DC_1FK2210-3";
        }
        else if(EK_regFound(mlfb, "1FK22104..1...B."))
        {
            strBrakeID="DC_1FK2210-4";
        }
        else if(EK_regFound(mlfb, "1FK22105..1...B."))
        {
            strBrakeID="DC_1FK2210-5";
        }
    }
        
    ECL_SetValue("ECSI_CC_BrakeID",strBrakeID);
    
    //Gibt nur einen Typ
    ECL_SetValue("ECSI_CC_SelectedEncoder","1");
}

/**
    die Bedingungen für Einträge in den Auswahllisten

    Array mit den Zeilen
    [
        RegEx einer gültigen MLFB ( ! die Daten aus der Excel_Datei konvertieren ),
        [ Attribut, Value ]
    ]
*/
function getAttributValueConditions()
{
    return [
        [	"1FK2............",
            ["A_WELLENENDE_TYP_1FK2", "V_WELLENENDE_GLATT_1FK2"]
        ],
        [	"1FK2............",
            ["A_WELLENENDE_TYP_1FK2", "V_WELLENENDE_P_1FK2"]
        ],
        [	"1FK2(1020AG|1021AG|1032AG|1034AG|1032AH|1034AH|1044AF|1044AK|1045AF|1045AK|1046AF|1054AF|1056AF|1063AF|1064AF|1066AF|2032AG|2034AG|2032AK|2034AK|2045AF|2045AK|2046AF|2052AF|2054AF|2062AF|2064AF|2083AC|2084AC|2085AC|2103AB|2103AC|2104AB|2104AC)......",
            ["A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_OCC_1FK2"]
        ],
        [	"1FK2(1032AH|1034AH|1044AF|1044AK|1045AF|1045AK|1046AF|1054AF|1056AF|1063AF|1064AF|1066AF|2032AK|2034AK|2045AF|2045AK|2046AF|2052AF|2054AF|2062AF|2064AF|2083AC|2084AC|2085AC|2103AB|2103AC|2104AB|2104AC|2105AC|3062AC|3064AC|3083AB|3084AB)......",
            ["A_ANSCHLUSSTECHNIK_1FK2", "V_ANSCHLUSS_2CC_1FK2"]
        ]
    ];
}

/**
    die Bestimmungen zusätzlicher MLFBs
*/
function getAccConditions()
{
    var a_cond = [];
    return a_cond;
}

/**
    die Bestimmungen von MLFBs, welche die aktuelle MLFB mit einem Zusatz erweitern
*/
function getAccConditionsMlfb(mlfb)
{
    var a_cond = [];
    return a_cond;
}

function normalizeMLFB( strMLFB )
{
    // trim spaces and adjust to upper case
    strMLFB = toupper( trimright( trimleft( strMLFB, ' ' ), ' ' ) );
    
    // add additional spaces between plusses if necessary
    strMLFB = replace( strMLFB, '-Z', '-Z ' );
    strMLFB = replace( strMLFB, '+', ' +' );
    
    // delete surplus tabs and spaces
    strMLFB = replace( strMLFB, '\t', ' ' );
    while ( strMLFB.indexOf( '  ' ) > -1 )
        strMLFB = replace( strMLFB, '  ', ' ' );
    
    return( strMLFB );
}

function tokenize( strMLFB, bStripFreeText )
{
    var nMLFBLen = strMLFB.length;
    var bMasked = false, bStripText = false, bBaseMLFBFinished = false;
    var strToken = '';
    var cToken = '';
    var aTokens = [];
    
    var i = 0;
    while ( i <= nMLFBLen )
    {
        cToken = strMLFB.charAt( i );
        if ( ( cToken === ' ' ) && !bMasked )					// not a space in quotes
        {
            if ( strToken === ' ' )								// clear multiple spaces
                strToken = '';
            else if ( strToken !== '' )							// a single space is a separator between tokens
            {
                aTokens.push( strToken );
                strToken = '';
            }
            // now we are handling blocks of mlfbs - but the MLFB must always be sparated by a space from the short descriptions
            if ( !bBaseMLFBFinished )
                bBaseMLFBFinished = true;
        }
        else if ( _isQuoteChar( cToken ) && !bMasked )	// text (in double or single quotes) started
        {
            // if we don't want the freetext to be included, we must not add a starting double quote
            // and we must prevent following chars to be added to the token until a closing double quote
            bMasked = true;
            if ( !bStripFreeText )
                strToken += cToken;
            else bStripText = true;
        }
        else if ( _isQuoteChar( cToken ) && bMasked )		// text (in double or single quotes) ended
        {
            // } of quote means } of token
            if ( !bStripFreeText )
                strToken += cToken;
            else bStripText = false;
            // if we don't want the freetext to be included, we must not add a starting double quote
            // and we must prevent following chars to be added to the token until a closing double quote
            if ( strToken !== '' )
            {
                aTokens.push( strToken );
                strToken = '';
            }
            bMasked = false;
        }
        else
        {
            if ( !bStripText )
            {
                if ( !_isSpecialChar( cToken, bMasked ) )
                {
                    // the lexer now must accept blocks of short descriptions and must break them into pieces of 3 chars
                    strToken += cToken;
                    if ( bBaseMLFBFinished && !bMasked && ( strToken.length == 3 ) )	// base mlfb is lexed and string is not masked
                    {						
                        if ( ( i + 1 ) <= nMLFBLen )
                            cToken = strMLFB.charAt( i + 1 );
                        if ( !_isQuoteChar( cToken ) )		// don't split a MLFB and quoted freetext
                        {
                            aTokens.push( strToken );
                            strToken = '';
                        }
                    }					
                }
            }
        }	
        ++i;
    } 
    
    if ( strToken !== '' )
    {
        // push the remaining string as token
        aTokens.push( strToken );
    }
        
    return( aTokens );
}


/**
 * determines if a character is a special char, i.e. a character that should not be included in a token
 *
 * @param cChar - char to examin
 * @param bInQuotes - are we just in double quotes?
 *
 * @return boolean - false - not a special character
 *                   true - a special character
 */
function _isSpecialChar( cChar, bInQuotes )
{
    var bIsSpecial = false;
    if ( !bInQuotes )
    {
        if ( ( cChar === '-' ) ||
             ( cChar === ',' ) ||
             ( cChar === 'Z' ) ||
             ( cChar === ';' ) ||
             ( cChar === ':' ) ||
             ( cChar === '_' ) ||
             ( cChar === '//' ) ||
             ( cChar === '?' ) ||
             ( cChar === '*' ) ||
             ( cChar === '+' ) ||
             ( cChar === "'" ) ||
             ( cChar === '/' ) ||
             ( cChar === '(' ) ||
             ( cChar === ')' ) ||
             ( cChar === '[' ) ||
             ( cChar === ']' ) ||
             ( cChar === '\t' ) )
            bIsSpecial = true;
    }
    // else characters that are in quotes are never special
    
    return( bIsSpecial );
}


/**
 * determines if a character is a quotation character in a token
 *
 * @param cChar - char to examin
 *
 * @return boolean - false - not a quotation character
 *                   true - a quotation character
 */
function _isQuoteChar( cChar )
{
    return( ( cChar === '\"' ) || ( cChar === "'" ) );
}

function checkmoeglicheMotorwellen_TypbeiGetriebeanbau(Achshoehe, aGearSD)
{

    var aMLFB_PatternGetriebe=[];
    var strSelect = "SELECT MLFB_PATTERN FROM Wellenende_Motor_Pattern WHERE MLFB_OPTION='"+ aGearSD[0]+" "+aGearSD[1]+"' "; 
    var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
    var s_mlfb = ECL_GetValue("ECSI_MLFB");
    if ( aResult.length > 0 )
    {
        //gültige Patterns bestimmen
        for(var i=0; i<aResult.length;i++)
        {
            var testPattern=replaceChar(aResult[i].MLFB_PATTERN, "?", 12);
            if(EK_regFound(s_mlfb, testPattern))
            {
                aMLFB_PatternGetriebe.push(aResult[i].MLFB_PATTERN);
            }
        }
    }
    else
        logtraceln("Fehler bei der Bestimmung des MLFB Pattern für das Getriebe SQL="+strSelect);
            
    
    var aRet=[];
    for(var i=0;i<aMLFB_PatternGetriebe.length;i++)
    {
        var strStelle13=aMLFB_PatternGetriebe[i].charAt(12);
        var strSelect = "SELECT Wellenende_Typ FROM WELLENENDE_MOTOR WHERE Achshoehe='"+Achshoehe+"' AND MLFB_STELLE_13='"+strStelle13+"' ";
        var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
        if ( aResult.length > 0 )
        {
            aRet.push(aResult[i].WELLENENDE_TYP);
        }
    }
    
    return aRet;
}

function checkmoeglicheMotorwellen_MassbeiGetriebeanbau(Achshoehe,aGearSD)
{

    var aMLFB_PatternGetriebe=[];		
    var strSelect = "SELECT MLFB_PATTERN FROM Wellenende_Motor_Pattern WHERE MLFB_OPTION='"+ aGearSD[0]+" "+aGearSD[1]+"' "; 
    var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
    var s_mlfb = ECL_GetValue("ECSI_MLFB");

    if ( aResult.length > 0 )
    {
        //gültige Patterns bestimmen
        for(var i=0; i<aResult.length;i++)
        {
            var testPattern=replaceChar(aResult[i].MLFB_PATTERN, "?", 12);
            if(EK_regFound(s_mlfb, testPattern))
            {
                aMLFB_PatternGetriebe.push(aResult[i].MLFB_PATTERN);
            }
        }
    }
    else
        logtraceln("Fehler bei der Bestimmung des MLFB Pattern für das Getriebe SQL="+strSelect);
        

    var aRet=[];
    for(var i=0;i<aMLFB_PatternGetriebe.length;i++)
    {
        var strStelle13=aMLFB_PatternGetriebe[i].charAt(12);
        var strSelect = "SELECT Wellenende_Mass FROM WELLENENDE_MOTOR WHERE Achshoehe='"+Achshoehe+"' AND MLFB_STELLE_13='"+strStelle13+"' ";
        var aResult = Object.fromDatabase("1FK2_GETRIEBE_DB", strSelect);
        if ( aResult.length > 0 )
        {
            aRet.push(aResult[i].WELLENENDE_MASS);
        }
    }
    
    return aRet;
}

function manageKeepconfig(s_mlfb)
{
    var isStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    var strBaseTypeMLFB=ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    
    if(isStartConfiguration=="1" && s_mlfb!=strBaseTypeMLFB && find(s_mlfb,".")<0)
    {
        //Keep Configuration
        if(find(s_mlfb, "-Z")>-1)
        {
            //mit Getriebe
            var strSD="";
            var aTokens=[];
            var aShortdescriptions=[];
            var aGearSD=[];
            
            
            aTokens = tokenize(s_mlfb,true);
            s_mlfb=aTokens[0];
            
            for(var i=1;i<aTokens.length;i++)
                aShortdescriptions.push(aTokens[i]);
            
            for(var i=1;i<aTokens.length;i++)
            {
                var strSD=aTokens[i];
                if(strSD.left(1)!="M")
                    aGearSD.push(aTokens[i]);
            }
            
            var aTokensBase=[];
            var aShortdescriptionsBase=[];
            var aGearSDBase=[];
            
            aTokensBase = tokenize(strBaseTypeMLFB,true);
            strBaseTypeMLFB=aTokensBase[0];
            
            for(var i=1;i<aTokensBase.length;i++)
                aShortdescriptionsBase.push(aTokensBase[i]);
            
            for(var i=1;i<aTokensBase.length;i++)
            {
                var strSD=aTokensBase[i];
                if(strSD.left(1)!="M")
                    aGearSDBase.push(aTokensBase[i]);
            }
            
            var strBasePart=strBaseTypeMLFB.substring( 0, 10 );
            var strMLFBPart=s_mlfb.substring(10,16);
            
            s_mlfb=strBasePart+strMLFBPart;
            
            var strCompleteMLFB=s_mlfb+"-Z "+aGearSDBase[0]+aTokens[2]+aGearSDBase[1];
            
            return strCompleteMLFB;
            
        }
        else
        {
            //ohne Getriebe
            var strBasePart=strBaseTypeMLFB.substring( 0, 10 );
            var strMLFBPart=s_mlfb.substring(10,16);
            
            s_mlfb=strBasePart+strMLFBPart;
            
            return s_mlfb;
            
        }
        
        
    }
    else if(isStartConfiguration=="1")
        return s_mlfb;
    else
        return s_mlfb;
}