//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1FK7
// 	Date: 2022-12-08
// 	User: Administrator
// ---------------------------------------------------------

//#mode(full-ecma)


// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class

//@import "1FK7_CONFIG/CFG_1FK7_CONSEQUENCES.js"

//@import "1FK7_CONFIG/CFG_1FK7_CHECKBOX.js"

//@import "1FK7_CONFIG/VT_1FK7.js"

//@import "1FK7_CONFIG/CFG_1FK7_KONFIG_ZIEL.js"

//@import "1FK7_CONFIG/CFG_1FK7_PRODUKTLOGIK.js"

//@import "1FK7_CONFIG/CFG_1FK7_GETRIEBE.js"

//@import "1FK7_CONFIG/CFG_1FK7_MOTOR.js"

//@import "1FK7_CONFIG/CFG_1FK7_GEBER.js"

//@import "1FK7_CONFIG/CFG_1FK7_FARBE.js"

//@import "1FK7_CONFIG/CFG_1FK7_EX.js"


//@import "1FK7_CONFIG/CFG_1FK7_OPTIONEN_1.js"

//@import "1FK7_CONFIG/CFG_1FK7_OPTIONEN_2.js"


//@import "1FK7_CONFIG/CFG_1FK7_GENERIERE_KAG.js"

//@import "1FK7_PARSER/Parser.1FK7.parse.js"


// 	sDB_Version = "24169";			// DB-Version 31.29 - evosoft
// 	sDB_Version = "25759";			// DB-Version  - evosoft
//  sDB_Version = "26606";		    // DB-Version 31.48	- Plan Software for Release 2025/03
var sDB_Version = "26606";			// DB-Version 31.48	- Plan Software 
var sDB_Suffix = "_" + sDB_Version;	// DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {
    // Derive evaluation of ECSI attributes from primary MLFB
    SetAttributesFromMlfb();

    ECL_Trace("DT-K database-version: " + sDB_Version);
    ECL_Trace("Script-version: 2025.03.01_250207");
    /*
    MLFB-Schema
    
    MLFB01	1
    MLFB02	F
    MLFB03	K
    MLFB04	7
    MLFB05	Achshhe 1	
    MLFB06	Achshhe 2	
    MLFB07	Baulnge 
    MLFB08	Motortyp (Merkmal) 
    MLFB09	Khlung  Selbstkhlung, Fremsbelftung
    MLFB10	Bemessungsdrehzahl	
    MLFB11	Zwischenkreisspannung {7} 510...720V
    MLFB12	. Bauform	{1, 4} IM B5
    MLFB13	. Anschlusstechnik
    MLFB14	. Geber 
    MLFB15	. Wellenende / Haltebremse	
    MLFB16	. Schutzart 
    
    1FK70115AK7.....
    
    SeriesID ohne Planetengetriebe 300
    SeriesID mit Planetengetriebe 302
    
    */

    // Datenbank
    //ECL_VTSetDatabase("EXTERNAL_DATA");

    // Defaults, wird ggf. von der Fehlerbehandlung gendert
    ECL_SelectValue("ECSI_STATUS", "OK");		// Status fr MLFB-bergabe
    ECL_SetValue("ECSI_STATUS_MESSAGE", "");	// Statusmeldung fr MLFB-bergabe

    //ECL_DisableAttribute("ECSI_TYPBEZEICHNUNG"); // gibt es nicht?!
    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");

    /*
    var sEvent = getstring("EVENT", "ENGINE");
    var nStep = getint("STEP", "ENGINE");
    if (nStep < 1 || sEvent == "IDC_LINK_CONFIGURATION" || (sEvent == "INIT" && nStep > 1))
        return;
    */
    var strchangedAttribute = ECL_GetCurrentAttribute();
    //ECL_SelectValue("O_Y84_1FK7M", "F");
    // Dummy Aufrufe von SIZER unterdrcken
    /*	if (strchangedAttribute == '')
            return;
    */
    if (strchangedAttribute.left(7) == "ECSI_CX") {
        return;
    }

    if (strchangedAttribute === "@INIT@") {
        //Initialisierung

        SetConfiguration_1FK7_Init();

        return;
    }
    //var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    if (strchangedAttribute == "ECSI_MLFB") {

        var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
        if (ECSI_IS_START_CONFIGURATION != 1) {
            var sStatus = checkContextValues();


            if (sStatus != "") {
                ECL_SelectValue("ECSI_STATUS", "E");
                ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
                return;
            }
        }

        var sStatus = analyzePrimaryMLFB();
        if (sStatus != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
            return;
        }

        var sMLFB = ECL_GetValue("ECSI_MLFB");
        var MLFB01_1LE1X = sMLFB.left(4);
    }
    getCheckBoxAttributes(strchangedAttribute);

    var ECSI_CX_IsDriveTrain = ECL_GetValue("ECSI_CX_IsDriveTrain");
    if (ECSI_CX_IsDriveTrain == "1") {
        var sMLFB = ECL_GetValue("ECSI_MLFB");
        var sTypVorbidden = sMLFB.left(11);
        if (sTypVorbidden == "1FK70864SF7") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate("DICT1_ERR_1FK7___MOTOR_NOT_SUPPORTED_FOR_DRIVETRAIN"));
            return;
        }
    }

    // #############################################################################################################
    // Context-Attributes
    // #############################################################################################################
    /*
        CONTEXT-ATTRIBUTES
        gerneral:
            MotorSolution
                0	Standard asynchonous motor solution
                1	Servo motor solution
                2	Reluctance motor solution
            
            MinimalExplosionProtectionGas
                Null	None
                2	Ex ec (Zone 2)
                1	Ex db (Zone 1)
                
            MinimalExplosionProtectionDust
                Null	None
                22	Ex tc (Zone 22)
                21	Ex tb (Zone 21)
            
        motors:
            MountingPosition
                Null	No value, if selected motor is a std. asynchron. Motor or a servo motor
                    1	M1, Output side A (geared motors)
                    2	M2, Output side A (geared motors)
                    3	M3, Output side A (geared motors)
                    4	M4, Output side A (geared motors)
                    5	M5, Output side A (geared motors)
                    6	M6, Output side A (geared motors)
                    7	M1, Output side B (geared motors)
                    8	M2, Output side B (geared motors)
                    9	M3, Output side B (geared motors)
                    10	M4, Output side B (geared motors)
                    11	M5, Output side B (geared motors)
                    12	M6, Output side B (geared motors)

            (MotorFrequency)
                Null	No value, if selected motor is a servo motor
                50	50 Hz
                60	60 Hz
                87	87 Hz
                104	104 Hz
                6050	60 Hz with 50 Hz power (also called "60p50")

            CoolingMethodMotor
                0	Self-ventilated
                1	Forced ventilation
                2	Water cooling
                3	Self-cooling
                4	Push-through ventilation

            EncoderTypeRough
                Null	Any (nothing specific set by the user)
                0	Incremental
                1	Absolute
            MotorConnection
                0	Motor dimensioned with delta circuit
                1	Motor dimensioned with star circuit
            
            ? DefaultGearboxAdapter
            ? MotorRatedPower
            ? MotorRatedSpeed
            
            MotorBrakeRequired
                True
                False
            ? MotorPoleCount
    */
    // Protection Ex-Schutz
    /**
        Gas
            Null	None			SAFE
            2	Ex ec (Zone 2)		EXN			M03		<---O_M03_M39_1FK7M
            1	Ex db (Zone 1)		EXE, EXD
        Dust
            Null	None			SAFE
            22	Ex tc (Zone 22)		EXTC		M39		<---O_M03_M39_1FK7M
            21	Ex tb (Zone 21)		EXTB
    */
    var ECSI_CX_MinimalExplosionProtectionGas = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionGas") || "";
    var ECSI_CX_MinimalExplosionProtectionDust = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionDust") || "";
    if (ECSI_CX_MinimalExplosionProtectionGas != "" && ECSI_CX_MinimalExplosionProtectionDust != "") {
        // nicht zulssig
        var sError = "ERRORMSG_MLFB_1FK7___CX_PROTECTION_ONLY_ONE";
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sError));
        return;
    }

    // #############################################################################################################


    // #############################################################################################################
    // Konfiguration anwerfen
    // #############################################################################################################
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
    if (sECSI_MLFB == "") {
        return;
    }
    var sMLFB16 = sECSI_MLFB.left(16);
    // ###################################################################################################################################
    // LOGIK
    // ###################################################################################################################################
    if (sMLFB16.indexOf(".") < 0) {
        var sStatus = ExecProductLogic(strchangedAttribute);
        if (sStatus != "OK") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
            return;
        }
    }
    setCheckBoxAttributes();

    // ###################################################################################################################################
    // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
    // ###################################################################################################################################
    var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// diese kann sich durch die Konfiguration gendert haben, insbes. in den ersten 16 Stellen

    var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
    ECL_SetValue("ECSI_MLFB", full_mlfb);


    // ###################################################################################################################################
    // Consequence-Attributes
    // ###################################################################################################################################

    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// frisch besorgen, kann berall gendert worden sein
    var oConsequences = determineConsequences(sECSI_MLFB);

    if (oConsequences.AdditionalInertia == "ERROR") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FK7___CC_ADDITIONAL_INERTIA"));
        return;
    }

    if (oConsequences.BrakeID.left(5) == "ERROR") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FK7___BRAKEID"));
        return;
    }

    if (oConsequences.Error_Message != "") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FK7___CONSEQUENCES"));
        return;
    }
    /*
    var oConsequences = {
        AdditionalInertia 			: getAdditionalInertia(sECSI_MLFB),
        //MinPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
        //MaxPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MaxPulseFrequency', 		'max'),
        //AllowedControlModes		: getAllowedControlModes,
        IpProtectionLevelMotor  	: getIpProtectionLevelMotor(),
    //	SensorModule				: getSensorModule(),
        BrakeID						: getBrakeID(sECSI_MLFB),
    //	GearboxOil					: getGearboxOil(),
        GearboxOutputShaftType		: aShaftParams[0],
        GearboxOutputShaftDiameter	: aShaftParams[1],
        OutputShaftLength			: aShaftParams[2],
        GearboxMountingType			: "P",
    //	GearboxReinforcedBearing	: getGearboxReinforcedBearing(),
        //SelectedGearboxAdapterID	: getSelectedGearboxAdapterID(),
        Error_Message				: strErr
    }
    */

    ECL_SetValue("ECSI_CC_AdditionalInertia", oConsequences.AdditionalInertia);
    //ECL_SetValue("ECSI_CC_MinPulseFrequency", 		oConsequences.MinPulseFrequency);
    //ECL_SetValue("ECSI_CC_MaxPulseFrequency", 		oConsequences.MaxPulseFrequency);
    //ECL_SetValue("ECSI_CC_AllowedControlModes", 	"");	// 
    ECL_SetValue("ECSI_CC_IpProtectionLevelMotor", oConsequences.IpProtectionLevelMotor);
    ECL_SetValue("ECSI_CC_BrakeID", oConsequences.BrakeID);
    //ECL_SetValue("ECSI_CC_GearboxOil", 				oConsequences.GearboxOil);
    ECL_SetValue("ECSI_CC_GearboxOutputShaftType", oConsequences.GearboxOutputShaftType);
    ECL_SetValue("ECSI_CC_GearboxOutputShaftDiameter", oConsequences.GearboxOutputShaftDiameter);
    ECL_SetValue("ECSI_CC_OutputShaftLength", oConsequences.OutputShaftLength);
    ECL_SetValue("ECSI_CC_GearboxMountingType", oConsequences.GearboxMountingType);

    // ###################################################################################################################################



    // ###################################################################################################################################
    ECL_DisableAttribute("PMD_AAE020_001_000_1FK7M"); // Bemessungsdrehzahl
    ECL_DisableAttribute("PMD_AAA259_001_000_1FK7M"); // Motortyp
    ECL_DisableAttribute("PMD_ACH516_001_000_1FK7M"); // Achshhe
    ECL_DisableAttribute("TAK_ABU212_001_000_1FK7M"); // Baulnge
    ECL_DisableAttribute("PMD_AAC949_001_000_1FK7M"); // Bauform
    ECL_DisableAttribute("PMD_AAA136_001_000_1FK7M"); // Khlart
    ECL_DisableAttribute("PMD_AAB047_001_000_1FK7M"); // Stecker / Elektrischer Anschluss
    ECL_DisableAttribute("PMD_AAD427_001_000_1FK7M"); // Wellenausfhrung gesteuert ber UI-merkmal
    ECL_DisableAttribute("PMD_AAA506_001_000_1FK7M"); // Ausfhrung Wellenende
    ECL_DisableAttribute("UI_WELLENMASZ_1FK7M"); 	  // Wellenabmessungen

    //ECL_DisableAttribute("PMD_ABU278_001_000_1FK7M"); // Geber

    // Getriebe HMK ausblenden
    ECL_DeactivateAttribute("PMD_ABV413_001_000_1006091"); // Übersetzung
    ECL_DeactivateAttribute("PMD_ABV417_001_000_1FK7M"); // Stufen
    ECL_DeactivateAttribute("PMD_ABV517_001_000_1FK7M"); // Art des Getriebes
    //ECL_DisableAttribute("PMD_ABV517_001_000_1FK7M"); // Art des Getriebes
    ECL_DeactivateAttribute("HMK_OPT_GETRIEBE_1FK7M"); // Hilfsmerkmal Optionen Getriebe


    ECL_DeactivateAttribute("PMD_ABJ558_001_000_1FK7M"); // Zwischenkreisspannung
    ECL_DeactivateAttribute("HMK_KONFIG_ZIEL_1FK7M"); 	  // Konfigurationsziel

    // Deaktiviere Hilfsattribute
    ECL_DeactivateAttribute("HMK_VALUE_VALID_1FK7");
    ECL_DeactivateAttribute("HMK_KONFIG_TYP_1FK7M");
    ECL_DeactivateAttribute("HMK_GENERATION_1FK7M");
    ECL_DeactivateAttribute("MLFB08_1FK7M");
    ECL_DeactivateAttribute("MLFB09_1FK7M");
    //ECL_DeactivateAttribute("MLFB10_1FK7M");
    //ECL_DeactivateAttribute("MLFB11_1FK7M");
    //ECL_DeactivateAttribute("MLFB12_1FK7M");
    //ECL_DeactivateAttribute("MLFB13_1FK7M");
    ECL_DeactivateAttribute("MLFB14_1FK7M");
    ECL_DeactivateAttribute("MLFB15_1FK7M");
    ECL_DeactivateAttribute("MLFB16_1FK7M");
    // Produktiv deaktiviert:
    //ECL_DisableAttribute("HMK_RUMPF_1FK7"); // Rumpf
    ECL_DeactivateAttribute("HMK_BAUGROESSE_1FK7M"); // Baugre (HMK) AH+Baulnge
    ECL_DeactivateAttribute("PMD_ABV400_001_000_1FK7M"); // Baugre Stecker (HMK)

    // Checkbox-Attribute ausblenden
    ECL_DeactivateAttribute("UI_PASSFEDER_1FK7M"); // Passfeder
    ECL_DeactivateAttribute("UI_WELLENAUSF_1FK7M"); // Wellenausfhrung / N05 alternatives Wellenende
    ECL_DeactivateAttribute("PMD_AAA506_001_000_1FK7M"); // Ausfhrung Wellenende
    ECL_DeactivateAttribute("PMD_AAD427_001_000_1FK7M"); // Wellenausfhrung / N05 alternatives Wellenende
    ECL_DeactivateAttribute("PMD_ABU209_001_000_1FK7M"); // Drive-CLiQ
    ECL_DeactivateAttribute("O_B02_1FK7M"); // Werksprfzeugnis
    ECL_DeactivateAttribute("O_R06_1FK7M"); // Referenzmarke auf Motorwelle
    ECL_DeactivateAttribute("O_R72_1FK7M"); // Sondergeber
    ECL_DeactivateAttribute("O_Q30_Q31_1FK7M"); // Metall-Leistungsschild am Motor
    ECL_DeactivateAttribute("O_N16_1006091"); // Ausfhrung fr erhhte chemische Bestndigkeit
    ECL_DeactivateAttribute("O_Y84_1FK7M"); // Kundenangabe auf dem Leistungsschild
    ECL_DeactivateAttribute("CB_O_Y84_1FK7M"); // Kundenangabe auf dem Leistungsschild
    ECL_DeactivateAttribute("O_L13_1FK7M"); // usserer Erdungsanschluss
    ECL_DeactivateAttribute("O_Q20_1FK7M"); // Anschluss zum Druckausgleich

    // EDIT 2021.06 TFS 5601046	1FK7 - hide ex Option M03/M39	in newer DTK-databases it is avaiable
    //ECL_DeactivateAttribute("O_M03_M39_1FK7M");

    // EDIT 20221016 R72 not configurable
    ECL_DeactivateAttribute("CB_O_R72_1FK7M"); // Sondergeber

    // Edit 02.2023 no ATEX options 48952 - Remove 1FK7 ATEX options until the related feature is done
    ECL_DeactivateAttribute("O_M03_M39_1FK7M"); // ExSchutz ATEX-Options 

}


function SetConfiguration_1FK7_Init() {
    var oData = {};

    // Hilfsattribute ausblenden:
    SetKonfigZiel_Init(oData);
    SetMotor_Init(oData);
    SetGeber_Init(oData);
    SetFarbe_Init(oData);
    SetEX_Schutz_Init(oData);
    SetOptionen_1_Init(oData);
    SetOptionen_2_Init(oData);
    SetGetriebe_Init(oData);

    setCheckBoxAttributes();

    // EDIT 20221016 R72 not configurable
    ECL_DeactivateAttribute("CB_O_R72_1FK7M"); // Sondergeber
}

function analyzePrimaryMLFB() {
    // ----------------------------------------------------------------------------------------------------------------
    // MLFB parsen
    // ----------------------------------------------------------------------------------------------------------------
    var oParse = parse_init(ECL_GetValue("ECSI_MLFB"));
    if (oParse.strError != "") {
        return oParse.strError;
    }

    // ----------------------------------------------------------------------------------------------------------------

    if (oParse.strError == "") {

        SetMotor_Init(oParse);
        SetGeber_Init(oParse);
        SetFarbe_Init(oParse);
        SetEX_Schutz_Init(oParse);
        SetOptionen_1_Init(oParse);
        SetOptionen_2_Init(oParse);
        SetGetriebe_Init(oParse);

        SetFREETEXTS(oParse);

        setCheckBoxAttributes();
    } else {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oParse.strError));
        return oParse.strError;
    }
    return "";
}



function checkContextValues() {
    // ECSI_CX_InstallationAltituteMotor  bis 3000 erlaubt, keine Prfung erforderlich

    // ECSI_CX_MotorFrequency nur 50Hz
    var MotorFrequency = ECL_GetValue("ECSI_CX_MotorFrequency") || "";
    if (MotorFrequency != "50" && MotorFrequency != "") {
        //Fehler
        sError = "ERRORMSG_MLFB_1FK7___MOTOR_FREQUENCY_OUT_OF_RANGE";
        return sError;
    }
    // ECSI_CX_AmbientTemperatureMotor <= 50C
    var AmbientTemperatureMotor = parseInt(ECL_GetValue("ECSI_CX_AmbientTemperatureMotor"));
    if (AmbientTemperatureMotor > 50) {
        //Fehler
        sError = "ERRORMSG_MLFB_1FK7___MOTOR_AMBIENT_TEMP_OUT_OF_RANGE";
        return sError;
    }



    /*/ECSI_CX_MotorBrakeRequired
    var ECSI_CX_MotorBrakeRequired = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    var sMLFB = ECL_GetValue("ECSI_MLFB");
    var MLFB15_1FK7M = sMLFB.charAt(14);
    
    if ((ECSI_CX_MotorBrakeRequired == "True" || ECSI_CX_MotorBrakeRequired == "1") && (MLFB15_1FK7M != "B" && MLFB15_1FK7M != "H" && MLFB15_1FK7M != "V")){
        sError = "ERRORMSG_MLFB_1FK7___CX_CHANGE_BRAKE";
        return sError;
    }
    if ((ECSI_CX_MotorBrakeRequired != "True" && ECSI_CX_MotorBrakeRequired != "1") && (MLFB15_1FK7M == "B" || MLFB15_1FK7M == "H" || MLFB15_1FK7M == "V")){
        sError = "ERRORMSG_MLFB_1FK7___CX_CHANGE_BRAKE";
        return sError;
    }
    */
    /*ECSI_CX_DirectMachineEncoderNeeded
        Null	Any (nothing specific set by the user)
        0		No											
        1		Yes											---> nicht zulssig
    */
    var ECSI_CX_DirectMachineEncoderNeeded = ECL_GetValue("ECSI_CX_DirectMachineEncoderNeeded");
    if (ECSI_CX_DirectMachineEncoderNeeded == "1") {
        //Fehler
        sError = "ERRORMSG_MLFB_1FK7___MOTOR_DOES_NOT_FIT_CX";
        return sError;
    }

    /*ECSI_CX_EncoderTypeRough
        Null	Any (nothing specific set by the user)
        0		Incremental									UI_GEBER_1FK7M == OHNEU
        1		Absolute
        
        MITU	Absolutwertgebermultiturn (mit Umdrehungszhler)
        OHNEU	Inkremental / Absolutwertgeber Singleturn / Resolver (kein Umdrehungszhler)
        OHNE	Ohne
        
    UI_GEBER_1FK7M 
    */

    /*ECSI_CX_CoolingMethodMotor		<--- wird nicht bergeben????
        0	Self-ventilated
        1	Forced ventilation			MLFB09 == S
        2	Water cooling
        3	Self-cooling				MLFB09 == {A, B, C}
        4	Push-through ventilation
    */
    var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
    var CoolingMethodMotor = parseInt(CoolingMethodMotor);
    if (CoolingMethodMotor != 9999) {
        var sMLFB = ECL_GetValue("ECSI_MLFB");
        var MLFB09_1FK7M = sMLFB.charAt(8);
        if (MLFB09_1FK7M == "S" && CoolingMethodMotor != 1) {
            //Fehler
            sError = "ERRORMSG_MLFB_1FK7___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            return sError;
        }
        if ((MLFB09_1FK7M == "A" || MLFB09_1FK7M == "B" || MLFB09_1FK7M == "C") && CoolingMethodMotor != 3) {
            //Fehler
            sError = "ERRORMSG_MLFB_1FK7___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            return sError;
        }
    }
    /*ECSI_CX_MinimalExplosionProtectionGas			todo check
     /*ECSI_CX_MinimalExplosionProtectionDust
         nur NULL zulssig
     */
    var ECSI_CX_MinimalExplosionProtectionGas = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionGas") || "";
    if (ECSI_CX_MinimalExplosionProtectionGas != "") {
        //Fehler
        sError = "ERRORMSG_MLFB_1FK7___MOTOR_DOES_NOT_FIT_CX_EX";
        return sError;
    }
    var ECSI_CX_MinimalExplosionProtectionDust = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionDust") || "";
    if (ECSI_CX_MinimalExplosionProtectionDust != "") {
        //Fehler
        sError = "ERRORMSG_MLFB_1FK7___MOTOR_DOES_NOT_FIT_CX_EX";
        return sError;
    }
    return "";
}