//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1FL6
// 	Date: 2021-05-07
// 	User: Administrator
// ---------------------------------------------------------


//@import "SIZER_general_functions.js"

//@import "SIZER_simplecfg_utils.js"


// sets values of context into attributes - e.x.: mlfb, breakrequired, etc...
// 1FL60222.F2....1
// 	       A  1

// SHAFT_END_1FL6
// position 15
// You can always select either plain shaft or feather key
// Depending on the brake MLFB position 15 may be different (A,B) or (G,H)
// MLFB position 15:
// no brake + Plain shaft= G
// brake + plain shaft = H
// no brake + feather key = A
// brake + feather key = B

// Brake Type
// no brake is always possible
// holding brake is possible when the following regular expressions are matched:
// 1FL602{2;4}2????????
// 1FL603{2;4}2????????
// 1FL604{2;4}2????????
// 1FL605{2;4}2????????
// 1FL604{2;4}1????????
// 1FL606{1;2;4;6;7}1????????
// 1FL609{0;2;4;6}1????????
// 1FL6092-1....-...1
// with holding: 1FL6092-1AC61-2AH1
// without holding: 1FL6092-1AC61-2AH1
// 1FL60232........

// Connection Type
// position 13
// 1FL6{02;03;04}{2;4}2????????		CABLE_OUTLET		1
// 1FL6???1?????A??					ANGULAR_CONNECTOR	2	A=encoder
// 1FL6???1?????L??					ANGULAR_CONNECTOR	2	L=encoder
// 1FL605{2;4}2????????				ANGULAR_CONNECTOR	2	
// VT_1FL6_M00028_24609 MLFBs: 5-6, 8-9
// VT_1FL6_M00058_24609 has correlation between shaft height and conn. type

// seems to depend on PMD_ACH516_001_000_1FL6 from DTK "Shaft height"
// not in sizer cx so probably configurable(?)
// 1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16
// ---------------------------------------------------------------
// 1	F	L	6	0	2	2	2	.	F	2	.	.	.	.	.
//

// regex usage
// SIZER_simplecfg_utils
// EK_regound
// EK_regPrep


// encoder type depends on position 8 of MLFB
// only position 14
// 1FL6???????????? 00019 		A
// 1FL6???1???????? 00020		L
// 1FL6???2???????? 00005		M

// Protection class
// postion 16
// always IP65	1

// Position 9 and 12 are constant
// position 9 	A
// position 12	1

// VIBRATION_SEVERITY_GRADE_1FL6	A

// DESIGN_1FL6						IM_B5

// COLOR_1FL6						DEEP_BLACK

//VERSION SUFFIX
var VERSION_SUFFIX = "_24609";

// ATTRIBUTE CONSTANTS
var SHAFT_HEIGHT_ATTRIBUTE_ID = "PMD_ACH516_001_000_1FL6";
var SHAFT_END_ATTRIBUTE_ID = "PMD_AAA506_001_000_1FL6";
var ENCODER_SYSTEM_ATTRIBUTE_ID = "PMD_ABU278_001_000_1FL6";
var CONNECTION_TYPE_ATTRIBUTE_ID = "PMD_AAB047_001_000_1FL6";
var HOLDING_BRAKE_ATTRIBUTE_ID = "PMD_ABU276_001_000_1FL6";
var COLOR_ATTRIBUTE_ID = "COLOR_1FL6";
var DEGREE_OF_PROTECTION_ATTRIBUTE_ID = "PMD_ABJ176_001_000_1FL6";
var CONSTRUCTION_TYPE_ATTRIBUTE_ID = "DESIGN_1FL6";
var VIBRATION_SEVERITY_GRADE_ATTRIBUTE_ID = "VIBRATION_SEVERITY_GRADE_1FL6";

// CONTEXTS
var ENCODER_CONTEXT_ID = "ECSI_CX_EncoderTypeRough";
var BRAKE_CONTEXT_ID = "ECSI_CX_MotorBrakeRequired";
var GEARBOX_CONTEXT_ID = "ECSI_CX_GearboxMotorCoupling";

// CONSEQUENCES
var BRAKE_CONSEQUENCE_ID = "ECSI_CC_BrakeID";

// DEFAULT ATTRIBUTE VALUES
var DEFAULT_COLOR_VALUE = "DEEP_BLACK";
var DEFAULT_CONSTRUCTION_TYPE_VALUE = "IM_B5";
var DEFAULT_VIBRATION_SEVERITY_VALUE = "A";
var DEFAULT_PROTECTION_VALUE = "Z0023";
var DEFAULT_SHAFT_END_VALUE = "00002";
var DEFAULT_ENCODER_SYSTEM_VALUE = "00019";
var DEFAULT_CONNECTION_TYPE_VALUE = "00007";
var DEFAULT_BRAKE_VALUE = "T";

// OTHER (internal ids)
var MLFB_ATTRIBUTE_ID = "ECSI_MLFB";
var STATUS_ATTRIBUTE_ID = "ECSI_STATUS";
var STATUS_MSG_ATTRIBUTE_ID = "ECSI_STATUS_MESSAGE";
var KEEP_CONFIGURATION = "ECSI_IS_START_CONFIGURATION";

// VARIANT TABLES
var VT_1FL6_M00077 = "VT_1FL6_M00077" + VERSION_SUFFIX;
var VT_1FL6_M00074 = "VT_1FL6_M00074" + VERSION_SUFFIX;
var VT_1FL6_M00005 = "VT_1FL6_M00005" + VERSION_SUFFIX;
var VT_1FL6_M00028 = "VT_1FL6_M00028" + VERSION_SUFFIX;
var VT_1FL6_M00058 = "VT_1FL6_M00058" + VERSION_SUFFIX;

// main function (this function inst called if you do "function(){...}" so it has to stay simply "{...}")

globalThis.OnChangeConfiguration = function main() {
    SetAttributesFromMlfb();
    var strMlfb = ECL_GetValue(MLFB_ATTRIBUTE_ID);
    var mlfbChanged = false;                                  //gibt an ob die MLFB geparst werden muss
    mlfbChanged = manageKeepConfiguration(strMlfb);

    var strMlfb = ECL_GetValue(MLFB_ATTRIBUTE_ID);
    logtraceln("mlfb.." + strMlfb);
    if (strMlfb === "") {
        return;
    }

    // set defaults
    var currentAttr = ECL_GetCurrentAttribute();

    /*Date: 2022
    wird nicht mehr benötigt
    if(currentAttr == '@INIT@')
    {
        setDefaults(strMlfb);
    }
    
    */

    // apply encoder context
    enableEncoderFromContext();
    //Check if MLFB is correct
    if (strMlfb.substring(0, 4) !== "1FL6") {
        ECL_SelectValue(STATUS_ATTRIBUTE_ID, "E");
        ECL_SetValue(STATUS_MSG_ATTRIBUTE_ID, translate("ERRORMSG_1FL6_WRONG_CONFIGURATOR"));
        return;
    }
    else {
        ECL_SelectValue(STATUS_ATTRIBUTE_ID, "OK");
        ECL_SetValue(STATUS_MSG_ATTRIBUTE_ID, translate(""));
    }

    // parsing mlfb
    if (currentAttr === MLFB_ATTRIBUTE_ID || mlfbChanged == true) {
        parseMlfb(strMlfb);

        if (ECL_GetValue(STATUS_ATTRIBUTE_ID) && ECL_GetValue(STATUS_ATTRIBUTE_ID) !== "OK") {
            return;
        }
    }

    // apply brake context
    setBrakeFromContext();
    if (ECL_GetValue(STATUS_ATTRIBUTE_ID) && ECL_GetValue(STATUS_ATTRIBUTE_ID) !== "OK") {
        return;
    }

    var strECSI_CX_GearboxMotorCoupling = ECL_GetValue(GEARBOX_CONTEXT_ID);
    if (strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1) {
        //Abhnigkeit zur Welle
        ECL_DeactivateValue(SHAFT_END_ATTRIBUTE_ID, "00004");
        ECL_SelectValue(SHAFT_END_ATTRIBUTE_ID, "00002");
        ECL_DisableAttribute(SHAFT_END_ATTRIBUTE_ID);

        var mlfbChar = ".";	// default
        //var brake 			= ECL_GetValue(HOLDING_BRAKE_ATTRIBUTE_ID);
        var shaftEnd = ECL_GetValue(SHAFT_END_ATTRIBUTE_ID);
        //if(bremse == "V_BREMSE_OHNE_1FL6")------------------------------------
        if (!ECL_ValueSelected(HOLDING_BRAKE_ATTRIBUTE_ID, "T")) {
            if (shaftEnd == "00004")
                mlfbChar = "A";
            else if (shaftEnd == "00002")
                mlfbChar = "G";
        }
        else if (ECL_ValueSelected(HOLDING_BRAKE_ATTRIBUTE_ID, "T")) {
            if (shaftEnd == "00004")
                mlfbChar = "B";
            else if (shaftEnd == "00002")
                mlfbChar = "H";
        }
        // kann nicht auf diesen Wert gendert werden
        if (isMlfbPosValid(mlfbChar, 14)) {
            strMlfb = replaceChar(strMlfb, mlfbChar, 14);
        }
    }
    else {
        ECL_ActivateValue(SHAFT_END_ATTRIBUTE_ID, "00004");
        ECL_EnableAttribute(SHAFT_END_ATTRIBUTE_ID);
    }

    //if empty Value is set than recover disabled value
    if (ECL_GetValue(currentAttr) == "") {
        recoverDisabledValue(currentAttr);
    }

    evalCC(strMlfb);

    createMlfb(strMlfb);

    return;
}

/*Date: 1.10.2022
Die Funktion wird in der neuen Engine nicht mehr benötigt 
function setDefaults(strMlfb){
        if(find(strMlfb, ".") > -1){
            ECL_SelectValue(COLOR_ATTRIBUTE_ID, DEFAULT_COLOR_VALUE);
            ECL_SelectValue(CONSTRUCTION_TYPE_ATTRIBUTE_ID, DEFAULT_CONSTRUCTION_TYPE_VALUE);
            ECL_SelectValue(VIBRATION_SEVERITY_GRADE_ATTRIBUTE_ID, DEFAULT_VIBRATION_SEVERITY_VALUE);
            
            ECL_SelectValue(DEGREE_OF_PROTECTION_ATTRIBUTE_ID, DEFAULT_PROTECTION_VALUE);
            ECL_SelectValue(SHAFT_END_ATTRIBUTE_ID, DEFAULT_SHAFT_END_VALUE);
            ECL_SelectValue(ENCODER_SYSTEM_ATTRIBUTE_ID, DEFAULT_ENCODER_SYSTEM_VALUE);
            ECL_SelectValue(CONNECTION_TYPE_ATTRIBUTE_ID, DEFAULT_CONNECTION_TYPE_VALUE);
            ECL_SelectValue(HOLDING_BRAKE_ATTRIBUTE_ID, DEFAULT_BRAKE_VALUE);
        }
    }
*/

function findAttrsAndValuesByMlfb(character, position, table) {
    position = String(parseInt(position) + 1) // array 0
    if (position.length === 1) {
        position = "0" + position;
    }
    var sQuery = "SELECT * FROM " + table + " WHERE MLFB" + position + "_1FL6='" + character + "';";
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery);
    return aDbResult[0];
}

function selectValuesFromConfigObject(configObject) {
    for (attribute in configObject) {
        if (configObject[attribute] === "F") {
            ECL_DeselectValue(attribute, ECL_GetValue(attribute));
        }
        else {
            ECL_ActivateValue(attribute, configObject[attribute]);
            ECL_SelectValue(attribute, configObject[attribute]);
        }
    }

}

function setConnectionType() {
    var shaftHeight = ECL_GetValue(SHAFT_HEIGHT_ATTRIBUTE_ID);
    var sQuery = "SELECT " + CONNECTION_TYPE_ATTRIBUTE_ID + " FROM " + VT_1FL6_M00077 + " WHERE " + SHAFT_HEIGHT_ATTRIBUTE_ID + "='" + shaftHeight + "' AND " + CONNECTION_TYPE_ATTRIBUTE_ID + " !='00008';";
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery);
    var attrValue = aDbResult[0][CONNECTION_TYPE_ATTRIBUTE_ID];
    ECL_DeactivateValue(CONNECTION_TYPE_ATTRIBUTE_ID, "00007");
    ECL_DisableAttribute(CONNECTION_TYPE_ATTRIBUTE_ID);
    ECL_DeactivateAttribute(SHAFT_HEIGHT_ATTRIBUTE_ID);
    ECL_SetValue(CONNECTION_TYPE_ATTRIBUTE_ID, attrValue);
}

function enableEncoders(mlfb) {
    var selectedEncoder = ECL_GetValue(ENCODER_SYSTEM_ATTRIBUTE_ID);
    var relevantChar = mlfb[7];
    var sQuery = "SELECT DISTINCT " + ENCODER_SYSTEM_ATTRIBUTE_ID + " FROM " + VT_1FL6_M00074 + " WHERE MLFB08_1FL6 LIKE '%" + relevantChar + "%' order by rowid;";
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery);
    var lastValue = ECL_GetValue(ENCODER_SYSTEM_ATTRIBUTE_ID);
    ECL_DeactivateAllAttributeValues(ENCODER_SYSTEM_ATTRIBUTE_ID); // deactivate all encoders

    var i = 0;// index der später gebrauht wird
    for (; i < aDbResult.length; i++) {
        // activate relevant ones
        ECL_ActivateValue(ENCODER_SYSTEM_ATTRIBUTE_ID, aDbResult[i][ENCODER_SYSTEM_ATTRIBUTE_ID]);
    }
    //ECL_SelectValue(ENCODER_SYSTEM_ATTRIBUTE_ID, lastValue); 15.07.2022 auskommentiert, da vielleicht gefixt (toDO)

    var activeOptions = ECL_GetAllActiveAttributeValues(ENCODER_SYSTEM_ATTRIBUTE_ID)
    if (!isValueInArray(selectedEncoder, activeOptions)) {
        ECL_SelectValue(ENCODER_SYSTEM_ATTRIBUTE_ID, activeOptions[0]);
    }
}

function isValueInArray(value, array) {
    for (var i = 0; i < array.length; i++) {
        if (value == array[i]) {
            return true;
        }
    }
    return false;
}

function parseMlfb(strMlfb) {

    var arrMlfb = strMlfb.split("");

    ECL_SelectValue(COLOR_ATTRIBUTE_ID, "DEEP_BLACK");
    ECL_DisableAttribute(COLOR_ATTRIBUTE_ID);

    ECL_SelectValue(CONSTRUCTION_TYPE_ATTRIBUTE_ID, "IM_B5");
    ECL_DisableAttribute(CONSTRUCTION_TYPE_ATTRIBUTE_ID);

    ECL_SelectValue(VIBRATION_SEVERITY_GRADE_ATTRIBUTE_ID, "A");
    ECL_DisableAttribute(VIBRATION_SEVERITY_GRADE_ATTRIBUTE_ID);

    // set protection class
    ECL_SelectValue(DEGREE_OF_PROTECTION_ATTRIBUTE_ID, "Z0023"); // IP 65 protection class
    ECL_DisableAttribute(DEGREE_OF_PROTECTION_ATTRIBUTE_ID);

    // set attributes: Shaft end and brake from mlfb pos 14 (actual: 15)
    if (arrMlfb[14] != ".") {
        var configObject = findAttrsAndValuesByMlfb(arrMlfb[14], "14", VT_1FL6_M00005);
        selectValuesFromConfigObject(configObject);
    }
    else {
        ECL_DeselectValue(HOLDING_BRAKE_ATTRIBUTE_ID, "T");
        var possibilities = ECL_GetAllActiveAttributeValues(SHAFT_END_ATTRIBUTE_ID);

        ECL_SetValue(SHAFT_END_ATTRIBUTE_ID, possibilities[0]);
    }

    // set attribute: encoder type
    if (arrMlfb[13] != ".") {
        var configObject = findAttrsAndValuesByMlfb(arrMlfb[13], "13", VT_1FL6_M00074);
        selectValuesFromConfigObject(configObject);
    }
    else {
        var possibilities = ECL_GetAllActiveAttributeValues(ENCODER_SYSTEM_ATTRIBUTE_ID);
        ECL_SetValue(ENCODER_SYSTEM_ATTRIBUTE_ID, possibilities[0]);
    }

    // get shaft height position 5-6
    // and set connection type accordingly
    if (arrMlfb[4] != "." &&
        arrMlfb[5] != "." &&
        arrMlfb[7] != "." &&
        arrMlfb[8] != "."
    ) {
        var mlfbSubstring1 = arrMlfb[4] + arrMlfb[5]; // in the DTK this column defines pos 5 and 6
        var mlfbSubstring2 = arrMlfb[7] + arrMlfb[8]; // could modify shaft height attribute


        var sQuery = "SELECT * FROM " + VT_1FL6_M00028 + " WHERE MLFB05_1FL6 LIKE '%" + mlfbSubstring1 + "%' AND MLFB08_1FL6 LIKE '%" + mlfbSubstring2 + "%';";
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery);

        //var configObject = findAttrsAndValuesByMlfb(mlfbSubstring1, "4", "VT_1FL6_M00028_24609");
        selectValuesFromConfigObject(aDbResult[0]);
        setConnectionType();
        ECL_DisableAttribute(CONNECTION_TYPE_ATTRIBUTE_ID);
    }

    enableEncoders(arrMlfb)


}

function createMlfb(strMlfb) {
    // 1FL60222.F2
    var currentAttr = ECL_GetCurrentAttribute();
    var mlfb = strMlfb.substring(0, 8);
    mlfb += 'A';
    mlfb += strMlfb.substring(9, 11);
    mlfb += '1';

    // generating position 13 TODO
    var connectionType = ECL_GetValue(CONNECTION_TYPE_ATTRIBUTE_ID);
    var sQuery = "SELECT MLFB11_1FL6 FROM " + VT_1FL6_M00058 + " WHERE " + CONNECTION_TYPE_ATTRIBUTE_ID + "='" + connectionType + "';";
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery);
    var mlfb11 = aDbResult.length == 0 ? "0" : aDbResult[0]["MLFB11_1FL6"];
    var mlfbFragment = mlfb11.right(1);
    mlfb += mlfbFragment;

    // generating position 14
    var encoderType = ECL_GetValue(ENCODER_SYSTEM_ATTRIBUTE_ID);
    var sQuery = "SELECT DISTINCT MLFB14_1FL6 FROM " + VT_1FL6_M00074 + " WHERE " + ENCODER_SYSTEM_ATTRIBUTE_ID + "='" + encoderType + "';";
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery);
    var mlfb14 = aDbResult.length == 0 ? "0" : aDbResult[0]["MLFB14_1FL6"];
    mlfb += mlfb14; // we dont split it any further as this is a single character MLFB column

    // generating position 15, needs brake value
    var shaftEnd = ECL_GetValue(SHAFT_END_ATTRIBUTE_ID);
    var holdingBrake = ECL_GetValue(HOLDING_BRAKE_ATTRIBUTE_ID);
    if (holdingBrake !== "T") {
        holdingBrake = "F";
    }
    var sQuery = "SELECT DISTINCT MLFB15_1FL6 FROM " + VT_1FL6_M00005 + " WHERE " + SHAFT_END_ATTRIBUTE_ID + "='" + shaftEnd + "' AND " + HOLDING_BRAKE_ATTRIBUTE_ID + "='" + holdingBrake + "';";
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery);
    var mlfb15 = aDbResult.length == 0 ? "0" : aDbResult[0]["MLFB15_1FL6"];
    mlfb += mlfb15;

    // generating position 16
    // there is no table in the dtk delivery specifying this
    var protectionClass = ECL_GetValue(DEGREE_OF_PROTECTION_ATTRIBUTE_ID);
    if (protectionClass === 'Z0023') {
        mlfb += '1';
    }
    ECL_ResetAttribute(MLFB_ATTRIBUTE_ID);
    ECL_SetValue(MLFB_ATTRIBUTE_ID, mlfb);

    if (!ECL_GetValue(STATUS_ATTRIBUTE_ID)) {
        ECL_SelectValue(STATUS_ATTRIBUTE_ID, "OK");
        ECL_SelectValue(STATUS_MSG_ATTRIBUTE_ID, "");
    }
}

function setBrakeFromContext() {
    var brakeRequired = ECL_GetValue(BRAKE_CONTEXT_ID);

    if (parseInt(brakeRequired) === 1) {
        ECL_SelectValue(HOLDING_BRAKE_ATTRIBUTE_ID, "T");
    }
    else if (parseInt(brakeRequired) === 0 || brakeRequired === '') {
        ECL_DeselectValue(HOLDING_BRAKE_ATTRIBUTE_ID, "T");
    }
    else {
        ECL_SelectValue(STATUS_ATTRIBUTE_ID, "E")
        ECL_SetValue(STATUS_MSG_ATTRIBUTE_ID, translate("ERRORMSG_1FL6_BRAKE_CONTEXT_INVALID"));
        return;
    }
    ECL_DisableAttribute(HOLDING_BRAKE_ATTRIBUTE_ID);
}

function enableEncoderFromContext() {
    var encoderContext = ECL_GetValue(ENCODER_CONTEXT_ID);
    if (encoderContext === "1") {
        ECL_DisableValue(ENCODER_SYSTEM_ATTRIBUTE_ID, "00019");
        ECL_EnableValue(ENCODER_SYSTEM_ATTRIBUTE_ID, "00020");
        ECL_EnableValue(ENCODER_SYSTEM_ATTRIBUTE_ID, "00005");
    }
    else if (encoderContext === "0") {
        ECL_EnableValue(ENCODER_SYSTEM_ATTRIBUTE_ID, "00019");
        ECL_DisableValue(ENCODER_SYSTEM_ATTRIBUTE_ID, "00020");
        ECL_DisableValue(ENCODER_SYSTEM_ATTRIBUTE_ID, "00005");
    }
    else if (!encoderContext) {
        ECL_EnableValue(ENCODER_SYSTEM_ATTRIBUTE_ID, "00019");
        ECL_EnableValue(ENCODER_SYSTEM_ATTRIBUTE_ID, "00020");
        ECL_EnableValue(ENCODER_SYSTEM_ATTRIBUTE_ID, "00005");
    }
    else {
        ECL_SelectValue(STATUS_ATTRIBUTE_ID, "E")
        ECL_SetValue(STATUS_MSG_ATTRIBUTE_ID, translate("ERRORMSG_1FL6_ENCODER_CONTEXT_INVALID"));
        return;
    }
}

function evalCC(mlfb) {
    var strBrakeID = "";

    if (ECL_ValueSelected("PMD_ABU276_001_000_1FL6", "T")) {
        if (EK_regFound(mlfb, "1FL604.1A.6....1")) {
            strBrakeID = "1FL604_1A_6";
        }
        else if (EK_regFound(mlfb, "1FL606.1A.6....1")) {
            strBrakeID = "1FL606_1A_6";
        }
        else if (EK_regFound(mlfb, "1FL609.1A.6....1")) {
            strBrakeID = "1FL609_1A_6";
        }
        else if (EK_regFound(mlfb, "1FL602.2AF21...1")) {
            strBrakeID = "1FL602_2AF21";
        }
        else if (EK_regFound(mlfb, "1FL603.2AF21...1")) {
            strBrakeID = "1FL603_2AF21";
        }
        else if (EK_regFound(mlfb, "1FL604.2AF21...1")) {
            strBrakeID = "1FL604_2AF21";
        }
        else if (EK_regFound(mlfb, "1FL605.2AF21...1")) {
            strBrakeID = "1FL605_2AF21";
        }
    }
    ECL_SetValue(BRAKE_CONSEQUENCE_ID, strBrakeID);

}

function isMlfbPosValid(value, pos) {
    // diese MLFB Position darf gendert werden
    if (!isMlfbPosFix(pos))
        return true;
    // keine nderung erlaubt, aber der neue Wert muss identisch mit aktuellem sein
    var mlfb = ECL_GetUserVariable("ORIGINAL_MLFB");
    if (isValidChar(mlfb, "." + value, pos))
        return true;
    // Fehlerstatus setzen
    ECL_SelectValue("ECSI_STATUS", ek_status.s_ERR);
    ECL_SetValue("ECSI_STATUS_MESSAGE", ek_status.s_POS);
    return false;
}

//Set part of MLFB with basetype
function manageKeepConfiguration(strMlfb) {
    var keepConfig = ECL_GetValue(KEEP_CONFIGURATION);
    var mlfbChanged = false;                                            //bool ob die MLFB sich änderte
    if (keepConfig === "1" && ECL_GetValue("ECSI_MLFB_BASE_TYPE") != "") {
        var strBaseTypeMlfb = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
        var strNewMlfb = "";

        //Falls keine MLFB dann basetype einfach komplett übernehmen
        if (strMlfb == "") {
            strNewMlfb = strBaseTypeMlfb;
        }
        else {//Sonst Basetype übernehmen und reste von alter MLFB
            for (i = 0; i < strBaseTypeMlfb.length; i++) {
                if (strBaseTypeMlfb[i] !== ".") {
                    var character = strBaseTypeMlfb[i];
                    strNewMlfb += character;
                }
                else {
                    var character = strMlfb[i];
                    strNewMlfb += character;
                }
            }
        }
        ECL_SetValue(MLFB_ATTRIBUTE_ID, strNewMlfb);
        ECL_SetValue(KEEP_CONFIGURATION, 0);
        mlfbChanged = true;
    }
    return mlfbChanged;
}

//date: 1.10.2021
//Some attributes are changeable in to a empty value althought they are disabled.
//this function recovers their value and make the attribut like disabled.
function recoverDisabledValue(attribut) {

    switch (attribut) {

        case COLOR_ATTRIBUTE_ID:
            ECL_SelectValue(COLOR_ATTRIBUTE_ID, "DEEP_BLACK");
            CL_DisableAttribute(COLOR_ATTRIBUTE_ID);
            break;

        case CONSTRUCTION_TYPE_ATTRIBUTE_ID:
            ECL_SelectValue(CONSTRUCTION_TYPE_ATTRIBUTE_ID, "IM_B5");
            ECL_DisableAttribute(CONSTRUCTION_TYPE_ATTRIBUTE_ID);
            break;

        case VIBRATION_SEVERITY_GRADE_ATTRIBUTE_ID:
            ECL_SelectValue(VIBRATION_SEVERITY_GRADE_ATTRIBUTE_ID, "A");
            ECL_DisableAttribute(VIBRATION_SEVERITY_GRADE_ATTRIBUTE_ID);
            break;

        case DEGREE_OF_PROTECTION_ATTRIBUTE_ID:
            ECL_SelectValue(DEGREE_OF_PROTECTION_ATTRIBUTE_ID, "Z0023"); // IP 65 protection class
            ECL_DisableAttribute(DEGREE_OF_PROTECTION_ATTRIBUTE_ID);
            break;

        case CONNECTION_TYPE_ATTRIBUTE_ID:

            //Only value 00009 should exists
            ECL_SetValue(CONNECTION_TYPE_ATTRIBUTE_ID, "00009");
            ECL_DisableAttribute(CONNECTION_TYPE_ATTRIBUTE_ID);

    }
}