//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1FN3
// 	Date: 2023-06-19
// 	User: Plan Software GmbH
// ---------------------------------------------------------
//#mode(full-ecma)

// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class

//@import "1FN3_CONFIG/VT_1FN3.js"

//@import "1FN3_CONFIG/CFG_1FN3_PRODUKTLOGIK.js"

//@import "1FN3_CONFIG/CFG_1FN3_PRIM_PART.js"

//@import "1FN3_CONFIG/CFG_1FN3_SEC_PART.js"

//@import "1FN3_CONFIG/CFG_1FN3_PREC_COOLER.js"

//@import "1FN3_CONFIG/CFG_1FN3_GENERIERE_KAG.js"

//@import "1FN3_CONFIG/CFG_1FN3_GENERATE_MLFB_SEC.js"

//@import "1FN3_CONFIG/CFG_1FN3_CONSEQUENCES.js"

// # include "1FN3_CONFIG/CFG_1FN3_CHECKS_DEFAULTS.es"
//@import "1FN3_PARSER/Parser.1FN3.parse.js"

//@import "1FN3_MLFB/Base.misc.js"

// include new Variant Tables

VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables

//var sDB_Version = "xxxxx";		// DB-Version		NO DT-K data source
// Edit 06.2023: 51418 - Natural cooled linear motors should get “no cover” as default
// Edit 06.2024: 56562 - Config - 1FN3 - Extend configuration for additional variants
var sDB_Suffix = ""; //"_" + sDB_Version;	// DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {
  // Derive evaluation of ECSI attributes from primary MLFB
  SetAttributesFromMlfb();

  //ECL_Trace("DT-K database-version: " + sDB_Version);
  ECL_Trace("Script-version: 2024.06.0_240503");

  /*
    MLFB Struktur Primärteil
    MLFB.MLFB01 { 1FN3 }
    MLFB.MLFB05 
    MLFB.MLFB07 
    MLFB.MLFB08 
    MLFB.MLFB09 Cooling method: [N,W,K] new 05.2023: 'K' natural cooling
    MLFB.MLFB10 
    MLFB.MLFB11 
    MLFB.MLFB12 
    MLFB.MLFB13 
    MLFB.MLFB14 .|A|B|E|F Anschlussart {A, B, E, F} 	A_POWER_SIGNAL_CONNECTION_1FN3
                            Motoren 1FN3100 bis 1FN3900 
                                A: Anschluss von Leistung und Signal in einer Leitung Klemmenkastendeckel für eine PG-Verschraubung vorbereitet
                                B: Anschluss von Leistung und Signal getrennt Klemmenkastendeckel für metrische Verschraubung vorbereitet
                            Motoren 1FN3050
                                E: Anschluss von Leistung und Signal getrennt, fest angeschlossen mit offenen Aderenden Länge: 2 m
                                F: Anschluss von Leistung und Signal getrennt, fest angeschlossen, konfektioniert, mit Steckern Länge: 0,5 m
                                H: Anschluss von Leistung und Signal mit einer gemeinsamen Leitung, fest angeschlossen mit offenen Aderenden
    MLFB.MLFB15 A
    MLFB.MLFB16 3
    
    MLFB_RUMPF_PRI_PART_1FN3 = MLFB01...09
    
    
    MLFB Struktur Sekundärteil
    
    SeriesID: 390
    
    
    // LIMITATIONS:
    S <= 100
    
    1FN30501ND000FA3
    1FN31001WC000.A3
    1FN33004WB000.A3
    1FN34503WA500.A3
    1FN36004WB500.A3
    1FN39004NB200BA3
    */

  var sECSI_MLFB = "";

  // Defaults, wird ggf. von der Fehlerbehandlung gendert
  ECL_SelectValue("ECSI_STATUS", "OK"); // Status fr MLFB-bergabe
  ECL_SetValue("ECSI_STATUS_MESSAGE", ""); // Statusmeldung fr MLFB-bergabe

  ECL_DisableAttribute("ECSI_STATUS");
  ECL_DisableAttribute("ECSI_STATUS_MESSAGE");

  var strchangedAttribute = ECL_GetCurrentAttribute();
  var ECSI_IS_START_CONFIGURATION = parseInt(
    ECL_GetValue("ECSI_IS_START_CONFIGURATION")
  );

  /*	// Dummy Aufrufe von SIZER unterdrcken
    if (strchangedAttribute == '')
        return;
*/
  if (strchangedAttribute.left(7) == "ECSI_CX") return;

  // ###########################################################################################################
  // INIT
  // ###########################################################################################################
  if (strchangedAttribute == "@INIT@") {
    //Initialisierung
    SetConfiguration_1FN3_Init();

    return;
  }
  // ###########################################################################################################

  // ###########################################################################################################
  if (strchangedAttribute == "ECSI_MLFB") {
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
    if (sECSI_MLFB == "") {
      return;
    }

    var sStatus = analyzePrimaryMLFB();
    if (sStatus != "") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
      return;
    }
  }

  // ###################################################################################################################################
  // INPUT-Parameter verarbeiten
  // ###################################################################################################################################
  /* 
        ECSI_CX_PrecisionCooler						Yes | No										NEU: 0,1
        ECSI_CX_SecondaryTrackCount					first only 1, later 1,2 int	
        
        ECSI_CX_PrimaryPerTrackCount				first only 1, later 1,2
        ECSI_CX_SecondarySectionType				Standard | StandardAnd1StandardExtended			NEU: 0,1
        ECSI_CX_SecondarySectionCount 				first only 1, later 1,2
        
        ECSI_CX_HeatsinkProfiles					True | False
    */
  /*ECL_SelectValueDefault ("ECSI_CX_SecondarySectionCount", 1);
    ECL_SelectValueDefault ("ECSI_CX_PrimaryPerTrackCount", 1);
    ECL_SelectValueDefault ("ECSI_CX_SecondarySectionType", 0);
    ECL_SelectValueDefault ("ECSI_CX_SecondaryTrackCount", 1);
    */
  // ###################################################################################################################################

  // ###################################################################################################################################
  //Konfiguration anwerfen
  // ###################################################################################################################################
  var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
  if (sECSI_MLFB == "") {
    return;
  }
  // ###################################################################################################################################
  // LOGIK
  // ###################################################################################################################################
  var sStatus = ExecProductLogic(strchangedAttribute);
  if (sStatus != "OK") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
    return;
  }

  // ###################################################################################################################################
  // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
  // ###################################################################################################################################
  var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB");

  //		var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
  //		var sSekMLFB = GenSekMLFB(sBaseTypeMLFB, sECSI_MLFB);

  //		ECL_SetValue("ECSI_MLFB", full_mlfb);

  // ###################################################################################################################################
  // ###################################################################################################################################
  var ECSI_MLFB_SEC = generateMLFB_SEC(sECSI_MLFB);
  if (ECSI_MLFB_SEC.left(5) == "ERROR") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue(
      "ECSI_STATUS_MESSAGE",
      ECL_Translate("DICT1_ERR_1FN3___DETERMINING_SEC_MLFB")
    );
    return;
  }
  SetMlfbSec(ECSI_MLFB_SEC);
  //ECL_SetValue("ECSI_MLFB_SEC", ECSI_MLFB_SEC);

  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // frisch besorgen, kann berall gendert worden sein
  var oConsequences = determineConsequences(sECSI_MLFB);

  /*	ECSI_CC_HeatsinkCountPerRow 	: getCountOfHeatsinkProfiles(),
    SecondaryCoolingSelected  	: getSecondaryCoolingSelected(),
    CoverSelected				: getCoverSelected()
    
    ECSI_CC_HeatsinkCountPerRow		Anzahl Kühlkanäle pro Profilreihe (ECL_GetValue("INT_COUNT_HEATSINK_PROFILES_PER_ROW");
    ECSI_CC_SecondaryCoolingType	None/Parallel/SingleSided			NEU: 0,1,2
    ECSI_CC_CoverType				None/Continuous/Segmented			
    
    if (oConsequences.CountOfHeatsinkProfiles == "ERROR"){
        ECL_SelectValue ("ECSI_STATUS", "E");
        ECL_SetValue ("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PH3___CC_SELECTED_ENCODER"));
        return;
    }
    if(oConsequences.SecondaryCoolingSelected.left(5) == "ERROR"){
        ECL_SelectValue ("ECSI_STATUS", "E");
        ECL_SetValue ("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PH3___CC_MAXROTATIONSPEEDLIMIT"));
        return;
    }
    if(oConsequences.CoverSelected.left(5) == "ERROR"){
        ECL_SelectValue ("ECSI_STATUS", "E");
        ECL_SetValue ("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PH3___CC_MAXROTATIONSPEEDLIMIT"));
        return;
    }
    */
  ECL_SetValue(
    "ECSI_CC_HeatsinkCountPerRow",
    oConsequences.CountOfHeatsinkProfiles
  );
  ECL_SetValue(
    "ECSI_CC_SecondaryCoolingType",
    oConsequences.SecondaryCoolingSelected
  );
  ECL_SetValue("ECSI_CC_CoverType", oConsequences.CoverSelected);

  // ##############################################################################################################################################
  // Fixe Attrbute aus MLFB disablen
  // ##############################################################################################################################################

  // Hilfsattribute ausblenden:

  ECL_DeactivateAttribute("HMK_VALUE_VALID__1FN3");
  ECL_DeactivateAttribute("MLFB_RUMPF_PRI_1FN3");
  ECL_DeactivateAttribute("MLFB_01_07_1FN3");
  ECL_DeactivateAttribute("MLFB14_1FN3");
  ECL_DeactivateAttribute("INT_COUNT_HEATSINK_PROFILES_PER_ROW");

  ECL_DeactivateAttribute("A_COOLING_METHOD");

  //    var stopper = 0;
};
// ENDE MAIN #########################################################################################################################################
// ENDE MAIN #########################################################################################################################################

// ---------------------------------------------------------------------------------
function SetConfiguration_1FN3_Init() {
  var oData = {};

  /*
    ECL_ExpandAttributeGroup("CFG_GROUP___GENERAL");
    */

  // ---------------------------------------------------------------------------------------------------------------

  SetMotorPrimPart_Init(oData);
  SetMotorSecPart_Init(oData);

  SetPrecCooler_Init(oData);
}

function analyzePrimaryMLFB() {
  // ----------------------------------------------------------------------------------------------------------------
  // MLFB parsen
  // ----------------------------------------------------------------------------------------------------------------
  var oData = parse_init(ECL_GetValue("ECSI_MLFB"));
  if (oData.strError != "") return oData.strError;
  // ----------------------------------------------------------------------------------------------------------------

  if (oData.strError == "") {
    //try{

    oData = SetMotorPrimPart_Init(oData);
    oData = SetMotorSecPart_Init(oData);

    oData = SetPrecCooler_Init(oData);

    //SetFREETEXTS(oData);
    if (oData.strError != "") return oData.strError;
    /*} catch(errorMessage){
            addToErrors(errorMessage);
        }*/
  } else {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oData.strError));
    return oData.strError;
  }
  return "";
}

function addToErrors(/**String*/ errorMessage) {
  ECL_SelectValue("ECSI_STATUS", "E");
  ECL_SetValue(
    "ECSI_STATUS_MESSAGE",
    ECL_GetValue("ECSI_STATUS_MESSAGE") + errorMessage
  );
}
