//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1FS2
// 	Date: 2022-02-24
// 	User: Administrator
// ---------------------------------------------------------

//#mode(full-ecma)


// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class
//@import "1FS2_CONFIG/CFG_1FS2_CONSEQUENCES.js"
//@import "1FS2_CONFIG/CFG_1FS2_PRODUKTLOGIK.js"
//@import "1FS2_CONFIG/VT_1FS2.js"
//@import "1FS2_CONFIG/CFG_1FS2_MOTOR.js"
//@import "1FS2_CONFIG/CFG_1FS2_GENERIERE_KAG.js"
//@import "1FS2_PARSER/Parser.1FS2.parse.js"

// include new Variant Tables
VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables

var sDB_Version = "26882";			// DB-Version		DTK 3.16
var sDB_Suffix = "_" + sDB_Version;	// DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {
    // Derive evaluation of ECSI attributes from primary MLFB
    SetAttributesFromMlfb();

    ECL_Trace("DT-K database-version: " + sDB_Version);
    ECL_Trace("Script-version: 2025.08.0_250711");
    /*
    MLFB-Schema
    
    MLFB01	1FS2
    MLFB05	Motortyp	{1,2}
    MLFB06	Achshhe 1	{04,05,06,08}	D-TK nur 04, 05, 06
    MLFB07	Achshhe 2 
    MLFB08	Baulnge/Drehmoment {5,6}
    MLFB09	A (.) Khlart {A, (B)} zunchst fix "A"
    MLFB10	Wicklung/Bemessungsdrehzahl {C,F}	D-TK zustzlich 'E', mit Bremse verknpft, das kann zu Problemen mit SIZER fhren
    MLFB11	. Bremse (0: ohne, 1: mit)	// fr AH 63 wird MLFB11 in der BaseType mit bergeben F0, E1
    MLFB12	7 Schutzart fix
    MLFB13	. Wellenende, Passfeder {0,1}	glatte Welle 0, Passfeder 1
    MLFB14	M (.) Geber {(S),M} zunchst fix "M"
    MLFB15	Z Anschlusstechnik	ber KAG Q{0,1}{A...Y} Stecker,Kabellnge
    MLFB16	0 (Version) 
    
    SeriesID: 330
    
    1FS21046AF.7.MZ0
    
    */

    // Defaults, wird ggf. von der Fehlerbehandlung gendert
    ECL_SelectValue("ECSI_STATUS", "OK");		// Status fr MLFB-bergabe
    ECL_SetValue("ECSI_STATUS_MESSAGE", "");	// Statusmeldung fr MLFB-bergabe

    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");


    var strchangedAttribute = ECL_GetCurrentAttribute();

    // Dummy Aufrufe von SIZER unterdrcken
    /*	if (strchangedAttribute == '')
            return;
    */
    if (strchangedAttribute.left(7) == "ECSI_CX") {
        return;
    }

    if (strchangedAttribute == "@INIT@") {
        //Initialisierung
        SetConfiguration_1FS2_Init();
        return;
    }
    //var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    if (strchangedAttribute == "ECSI_MLFB") {

        var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
        if (ECSI_IS_START_CONFIGURATION != 1) {
            var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired") || "";
            var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

            if ((sBaseTypeMLFB.charAt(10) == "1" && strwithBrake != "1") ||
                (sBaseTypeMLFB.charAt(10) == "0" && strwithBrake == "1")) {	// Fehler, Kontext passt sicht zur MLFB
                ECL_SelectValue("ECSI_STATUS", "E");
                ECL_SetValue("ECSI_STATUS_MESSAGE", translate('ERRORMSG_MLFB_1FS2___INVALID_CONTEXT_MLFB10_11'));
                return;
            }
            /*
            var sStatus = checkContextValues();
            
            if (sStatus != ""){
                ECL_SelectValue ("ECSI_STATUS", "E");
                ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(sStatus));
                return;
            }
            */
        }

        var sStatus = analyzePrimaryMLFB();
        if (sStatus != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
            return;
        }
        var sMLFB = ECL_GetValue("ECSI_MLFB");
    }




    // #############################################################################################################
    // Context-Attributes
    // #############################################################################################################
    /*
        CONTEXT-ATTRIBUTES
        gerneral:
            MotorSolution
                0	Standard asynchonous motor solution
                1	Servo motor solution
                2	Reluctance motor solution
            
            MinimalExplosionProtectionGas
                Null	None
                2	Ex ec (Zone 2)
                1	Ex db (Zone 1)
                
            MinimalExplosionProtectionDust
                Null	None
                22	Ex tc (Zone 22)
                21	Ex tb (Zone 21)
            
        motors:
            MountingPosition
                Null	No value, if selected motor is a std. asynchron. Motor or a servo motor
                    1	M1, Output side A (geared motors)
                    2	M2, Output side A (geared motors)
                    3	M3, Output side A (geared motors)
                    4	M4, Output side A (geared motors)
                    5	M5, Output side A (geared motors)
                    6	M6, Output side A (geared motors)
                    7	M1, Output side B (geared motors)
                    8	M2, Output side B (geared motors)
                    9	M3, Output side B (geared motors)
                    10	M4, Output side B (geared motors)
                    11	M5, Output side B (geared motors)
                    12	M6, Output side B (geared motors)

            (MotorFrequency)
                Null	No value, if selected motor is a servo motor
                50	50 Hz
                60	60 Hz
                87	87 Hz
                104	104 Hz
                6050	60 Hz with 50 Hz power (also called "60p50")

            CoolingMethodMotor
                0	Self-ventilated
                1	Forced ventilation
                2	Water cooling
                3	Self-cooling
                4	Push-through ventilation

            EncoderTypeRough
                Null	Any (nothing specific set by the user)
                0	Incremental
                1	Absolute
            MotorConnection
                0	Motor dimensioned with delta circuit
                1	Motor dimensioned with star circuit
            
            ? DefaultGearboxAdapter
            ? MotorRatedPower
            ? MotorRatedSpeed
            
            MotorBrakeRequired
                True
                False
            ? MotorPoleCount
    */

    // #############################################################################################################


    // #############################################################################################################
    // Konfiguration anwerfen
    // #############################################################################################################
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
    if (sECSI_MLFB == "") {
        return;
    }
    var sMLFB16 = sECSI_MLFB.left(16);
    // ###################################################################################################################################
    // LOGIK
    // ###################################################################################################################################
    if (sMLFB16.indexOf(".") < 0) {
        var sStatus = ExecProductLogic(strchangedAttribute);
        if (sStatus != "OK") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
            return;
        }
    }

    // ###################################################################################################################################
    // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
    // ###################################################################################################################################
    var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// diese kann sich durch die Konfiguration gendert haben, insbes. in den ersten 16 Stellen

    var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
    ECL_SetValue("ECSI_MLFB", full_mlfb);



    // ###################################################################################################################################
    // Consequence-Attributes
    // ###################################################################################################################################

    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// frisch besorgen, kann berall gendert worden sein
    var oConsequences = determineConsequences(sECSI_MLFB);

    /*	if(oConsequences.AdditionalInertia == "ERROR"){
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FS2___CC_ADDITIONAL_INERTIA"));
            return;
        }
    */
    if (oConsequences.BrakeID.left(5) == "ERROR") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FS2___BRAKEID"));
        return;
    }
    if (oConsequences.Error_Message != "") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FS2___CONSEQUENCES"));
        return;
    }
    /*if(oConsequences.NoCableDQ == "ERROR"){
        ECL_SelectValue ("ECSI_STATUS", "E");
        ECL_SetValue ("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FS2___NO_CABLE_DQ"));
        return;
    }*/

    /* zur Info:
    var oConsequences = {
        //AdditionalInertia 		: getAdditionalInertia(sECSI_MLFB),
        //MinPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
        //MaxPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MaxPulseFrequency', 		'max'),
        IpProtectionLevelMotor  	: getIpProtectionLevelMotor(),
        BrakeID						: getBrakeID(sECSI_MLFB),
        Error_Message				: strErr
    }
    */

    //ECL_SetValue("ECSI_CC_AdditionalInertia", 			oConsequences.AdditionalInertia);
    ECL_SetValue("ECSI_CC_IpProtectionLevelMotor", oConsequences.IpProtectionLevelMotor);
    ECL_SetValue("ECSI_CC_BrakeID", oConsequences.BrakeID);
    ECL_SetValue("ECSI_CC_NoPhysicalDQConnectionNeeded", oConsequences.NoCableDQ);

    // ###################################################################################################################################



    // ###################################################################################################################################	
    // Deaktiviere Hilfsattribute

    ECL_DeactivateAttribute("HMK_VALUE_VALID_1FS2");
    ECL_DeactivateAttribute("HMK_KABEL_KAG_1FS2");
    ECL_DeactivateAttribute("MLFB_RUMPF_01_10_1FS2");

    // Info-Attribute
    ECL_DisableAttribute("CB_HALTEBREMSE_1FS2");

}


function SetConfiguration_1FS2_Init() {
    var oData = {};
    /* MLFB-Schema
    
    MLFB01	1FS2
    MLFB05	Motortyp	{1,2}
    MLFB06	Achshhe 1	{04,05,06,08}
    MLFB07	Achshhe 2 
    MLFB08	Baulnge/Drehmoment {5,6}
    MLFB09	A (.) Khlart {A, (B)} zunchst fix "A"
    MLFB10	Wicklung/Bemessungsdrehzahl {C,F,E}	
    MLFB11	. Bremse (0: ohne, 1: mit)
    MLFB12	7 Schutzart fix
    MLFB13	. Wellenende, Passfeder {0,1}	glatte Welle 0, Passfeder 1
    MLFB14	M (.) Geber {(S),M} zunchst fix "M"
    MLFB15	Z Anschlusstechnik	ber KAG Q{0,1}{A...Y} Stecker,Kabellnge
    MLFB16	0 (Version) 
        
    */

    SetMotor_Init(oData);

}

function analyzePrimaryMLFB() {
    // ----------------------------------------------------------------------------------------------------------------
    // MLFB parsen
    // ----------------------------------------------------------------------------------------------------------------
    var oParse = parse_init(ECL_GetValue("ECSI_MLFB"));
    if (oParse.strError != "") {
        return oParse.strError;
    }

    // ----------------------------------------------------------------------------------------------------------------

    if (oParse.strError == "") {

        SetMotor_Init(oParse);

        //SetFREETEXTS(oParse);
        if (oParse.strError != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", oParse.strError);
            return oParse.strError;
        }
    }
    else {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oParse.strError));
        return oParse.strError;
    }
    return "";
}

