//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1FT2
// 	Date: 2022-05-12
// 	User: Administrator
// ---------------------------------------------------------

//#mode(full-ecma)

// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class
//@import "1FT2_CONFIG/CFG_1FT2_CONSEQUENCES.js"
//@import "1FT2_CONFIG/CFG_1FT2_CHECKBOX.js"
//@import "1FT2_CONFIG/CFG_1FT2_PRODUKTLOGIK.js"
//@import "1FT2_CONFIG/VT_1FT2.js"
//@import "1FT2_CONFIG/CFG_1FT2_MOTOR.js"
//@import "1FT2_CONFIG/CFG_1FT2_GETRIEBE.js"
//@import "1FT2_CONFIG/CFG_1FT2_OPTIONEN.js"
//@import "1FT2_CONFIG/CFG_1FT2_GENERIERE_KAG.js"
//@import "1FT2_PARSER/Parser.1FT2.parse.js"

// include new Variant Tables

VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables
/*
sDB_Version = "21570";			// DB-Version
sDB_Version = "21648";			// DB-Version
sDB_Version = "22026";			// DB-Version V2021.06 (DTK 26.26)
sDB_Version = "22201";			// DB-Version V2021.07 (DTK 26.34)
sDB_Version = "23302";			// DB-Version V2021.08 (DTK 30.04)
sDB_Version = "23461";			// DB-Version V2022.04 (DTK 33.11)
sDB_Version = "23935";			// DB-Version V2022.05 (DTK 36.3)
adding 1FK2 support				// TST-Version V2022.06 (DTK 36.3)
sDB_Version = "24168";			// DB-Version V2022.12 (DTK 36.10)
sDB_Version = "24369";			// DB-Version V2023.03 (DTK 36.26)
sDB_Version = "24719";			// DB-Version V2023.06 (DTK 36.26)
sDB_Version = "24841";			// DB-Version V2023.06 (DTK 42.14)
sDB_Version = "25201";			// DB-Version V2023.10 (DTK 42.17)
sDB_Version = "25488";			// DB-Version V2023.12 (DTK 42.20)
sDB_Version = "25573";			// DB-Version V2024.02 (DTK ???)
sDB_Version = "25615";			// DB-Version V2024.02 (DTK ???)
sDB_Version = "26159";			// DB-Version V2024.10 (DTK ???)
sDB_Version = "26405";			// DB-Version V2024.11 (DTK 44.21)
sDB_Version = "26492";			// DB-Version V2024.12 (DTK 44.23)
sDB_Version = "26519";			// DB-Version V2025.02 (DTK 44.27)
sDB_Version = "26611";      // DB-Version V2025.03 (SPC 44.29)
sDB_Version = "26697";      // DB-Version V2025.05 (SPC 44.31)
sDB_Version = "26762";      // DB-Version V2025.06 (SPC 44.33)
sDB_Version = "26898";      // DB-Version V2025.08 (SPC 44.40)
sDB_Version = "26930";      // DB-Version V2025.08 (SPC 44.47)
sDB_Version = "27057";      // DB-Version V2025.11 (SPC 44.54)
*/
var sDB_Version = "27057"; // DB-Version V2025.11 (SPC 44.54)
var sDB_Suffix = "_" + sDB_Version; // DB-TableSuffix

var count = 0;
globalThis.OnChangeConfiguration = function main() {
  // Derive evaluation of ECSI attributes from primary MLFB
  SetAttributesFromMlfb();

  ECL_Trace("DT-K database-version: " + sDB_Version);
  ECL_Trace("Script-version: 2025.11.00_251003");
  /*
    
    SeriesID:	1FT2: 312,313,314
                1FK2: 311,315,316
    
    MLFB-Schema
    1FT2:
    MLFB01	1FT2
    MLFB05	Trägheit (Motortyp)	
    MLFB06	Achshöhe 1	
    MLFB07	Achshöhe 2 
    MLFB08	Baulänge 
    MLFB09	A, S (Kühlart, Selbstkühlung A, Fremdbelüftet S) S nur 1FT2 ohne Getriebe
    MLFB10	Wicklung/Bemessungsdrehzahl (B, C, F, G, K)	+ H + E
    MLFB11	. Bremse (0: ohne, 1: mit, 2: verstärkt)
    MLFB12	. Schutzart
    MLFB13	. Wellenende, Passfeder
    MLFB14	. Geber 
    MLFB15	. Anschlusstechnik	
    MLFB16	0 (reserviert) 
    
    1FK2:
    Positionen 0 - 15
    1FK2								1FK2
    Trägheit							{1;2}
    Achshöhe (2)						{0}	{2;3;4}
    Baulänge							{0;1;2;3;4;5;6;7;8}
    A
    Wicklung/Bemessungsdrehzahl			{G;F;K}
    Bremse								{0;1}
    Schutzart							{0;1}
    Wellenende/Passfeder				{0;1;2}
    Geber								{S;M}
    A
    0
    
    SIZER liefert				xxxxxxxxxx....xx

    V_WELLENENDE_GLATT_ALTERNATIV_1FK2	wenn	1FK2.03.A..0..A0
    
    1FT21044AK.....0
    1FK21020AG.....0-Z A11+R07
    
    1FT21044AK.....0-Z A21+R04
    1FT22084AC.....0-Z C42+R20

    angled gears
    1FT21044AK.....0-Z A26+R04
    */

  // Defaults, wird ggf. von der Fehlerbehandlung geändert
  ECL_SelectValue("ECSI_STATUS", "OK"); // Status für MLFB-Übergabe
  ECL_SetValue("ECSI_STATUS_MESSAGE", ""); // Statusmeldung für MLFB-Übergabe

  ECL_DisableAttribute("ECSI_STATUS");
  ECL_DisableAttribute("ECSI_STATUS_MESSAGE");

  var strchangedAttribute = ECL_GetCurrentAttribute();
  // Dummy Aufrufe von SIZER unterdrücken
  /*	if (strchangedAttribute == '')
        return;
        */
  if (strchangedAttribute.left(7) == "ECSI_CX") {
    return;
  }

  if (strchangedAttribute == "@INIT@") {
    //Initialisierung
    SetConfiguration_1FT2_Init();

    //Default abhängig von der Installation
    //var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    var strInstallation = ECL_GetValue("ECSI_CX_Installation");
    if (strInstallation == "3") {
      ECL_SelectValue("PMD_AAA759_001_000_1FK2", "00004"); // Zweikabel für S120
    } else {
      ECL_SelectValue("PMD_AAA759_001_000_1FK2", "00003"); // OCC für S210
    }
    count++;
    return;
  }

  if (strchangedAttribute == "" && count == 1) {
    return;
  }
  // ############################################################################################
  // Produktunterscheidung
  // ############################################################################################
  var SeriesID = ECL_GetValue("ECSI_CX_SeriesID") || "";

  SeriesID = SeriesID.left(5);
  /*
    1FT2: 312,313,314
    1FK2: 311,315,316
    
    1020: 	CFG_SIEMENS_1FK2 mit NLC
    1005:	CFG_SIEMENS_1FK2 mit NRB
    1010:	CFG_SIEMENS_1FK2 mit NRK
    
    1021:   CFG_SIEMENS_1FK2 mit NLCW
    1006:   CFG_SIEMENS_1FK2 mit NRBW
    1011:   CFG_SIEMENS_1FK2 mit NRKW

    todo Winkelgetriebe 1FT2
  NLCW
  NRBW
  NRKW

    ???? 
    "312" CfgObject="CFG_SIEMENS_1FT2"
    "313" CfgObject="CFG_SIEMENS_1FT2"
    "314" CfgObject="CFG_SIEMENS_1FT2" 
    "315" CfgObject="CFG_SIEMENS_1FT2"
    "316" CfgObject="CFG_SIEMENS_1FT2"
    
    00002	NRB
    00003	NRK
    00001	NLC

    * /
    
    switch(SeriesID){
        //case "G120":
        case "312":
        case "313":
        case "314":
            var HMK_SYSTEM_TRIG_1FK2 = "1FK2";		// "1FK2"
            var HMK_TARGET_TRIGGER_1FK2 = "MOT";	// "MOT", "GMOT"
            var MLFB01_1FK2 = "1FT2";				// "1FK2", "1FT2"
            var sGetriebeTyp = "NON";
        break;
        
        case "311":
        case "315":
        case "316":
            var HMK_SYSTEM_TRIG_1FK2 = "1FK2";
            var HMK_TARGET_TRIGGER_1FK2 = "MOT";
            var MLFB01_1FK2 = "1FK2";
            var sGetriebeTyp = "NON";
        break;
        
        case "1005":
            var HMK_SYSTEM_TRIG_1FK2 = "1FK2";
            var HMK_TARGET_TRIGGER_1FK2 = "GMOT";
            var MLFB01_1FK2 = "1FK2";
            var sGetriebeTyp = "NRB";
            var UI_GETRIEBE_TYP_1FK2 = "00002";
        break;
        
        case "1010":
            var HMK_SYSTEM_TRIG_1FK2 = "1FK2";
            var HMK_TARGET_TRIGGER_1FK2 = "GMOT";
            var MLFB01_1FK2 = "1FK2";
            var sGetriebeTyp = "NRK";
            var UI_GETRIEBE_TYP_1FK2 = "00003";
        break;
        
        case "1020":
            var HMK_SYSTEM_TRIG_1FK2 = "1FK2";
            var HMK_TARGET_TRIGGER_1FK2 = "GMOT";
            var MLFB01_1FK2 = "1FK2";
            var sGetriebeTyp = "NLC";
            var UI_GETRIEBE_TYP_1FK2 = "00001";
        break;
    }
    */

  var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE") || "";

  var HMK_SYSTEM_TRIG_1FK2 = "1FK2"; // immer "1FK2" auch für 1FT2 !!!
  var HMK_TARGET_TRIGGER_1FK2 = "MOT"; // "MOT", "GMOT"
  var MLFB01_1FK2 = sBaseTypeMLFB.left(4); // "1FK2", "1FT2"
  var sGetriebeTyp = "NON";
  var sWinkelGetrFlag = "NON";

  if (sBaseTypeMLFB.length > 16) {
    var sBaseType_KAG = sBaseTypeMLFB.substring(15);
    // Prüfen, ob Getriebeoptionen übergeben wurden:
    //var HMK_TARGET_TRIGGER_1FK2 = "MOT";
    var aResult = Object.fromDatabase(
      "1FT2_ADD_DATA",
      "select distinct Wert_ID from DATA WHERE IsKAG = 'x' AND Attribute = 'O_A11_C42_1FK2'"
    );

    if (aResult.length > 0) {
      // && !isEmpty(aKAG_List) ){
      for (var i = 0; i < aResult.length; i++) {
        var sKAG = aResult[i].WERT_ID;
        if (sBaseType_KAG.indexOf(sKAG) > -1) {
          HMK_TARGET_TRIGGER_1FK2 = "GMOT";

          if (sKAG.left(1) == "A") {
            var sIndexRight = sKAG.right(1);
            if (
              sIndexRight == "1" ||
              sIndexRight == "2" ||
              sIndexRight == "3"
            ) {
              sGetriebeTyp = "NRB";
            } else {
              // 6,7,8 ==> Winkelgetriebe
              sGetriebeTyp = "NRBW";
              sWinkelGetrFlag = "YES";
            }
          }
          if (sKAG.left(1) == "B") {
            var sIndexRight = sKAG.right(1);
            if (
              sIndexRight == "1" ||
              sIndexRight == "2" ||
              sIndexRight == "3"
            ) {
              sGetriebeTyp = "NRK";
            } else {
              // 6,7 ==> Winkelgetriebe
              sGetriebeTyp = "NRKW";
              sWinkelGetrFlag = "YES";
            }
          }
          if (sKAG.left(1) == "C") {
            var sIndexRight = sKAG.right(1);
            if (
              sIndexRight == "1" ||
              sIndexRight == "2" ||
              sIndexRight == "3"
            ) {
              sGetriebeTyp = "NLC";
            } else {
              // 6,7 ==> Winkelgetriebe
              sGetriebeTyp = "NLCW";
              sWinkelGetrFlag = "YES";
            }
          }

          break;
        }
      }
    }
  }

  ECL_SelectValue("HMK_TARGET_TRIGGER_1FK2", HMK_TARGET_TRIGGER_1FK2);
  ECL_SelectValue("HMK_ANGLED_PLANETARY_GEAR_1FK2", sWinkelGetrFlag);

  // ############################################################################################
  // Attribute nach Produkt ein-/ausblenden
  setProductAttributes(MLFB01_1FK2);
  setGearboxAttributes(sGetriebeTyp);
  // ############################################################################################

  if (strchangedAttribute == "ECSI_MLFB") {
    var ECSI_IS_START_CONFIGURATION = ECL_GetValue(
      "ECSI_IS_START_CONFIGURATION"
    );
    if (ECSI_IS_START_CONFIGURATION != 1) {
      var sStatus = checkContextValues();

      if (sStatus != "") {
        ECL_SelectValue("ECSI_STATUS", "E");
        sStatus = sStatus.replace(" ", "");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
        return;
      }
    }
    var sStatus = analyzePrimaryMLFB();
    if (sStatus != "") {
      ECL_SelectValue("ECSI_STATUS", "E");
      sStatus = sStatus.replace(" ", "");
      ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
      var test = ECL_GetValue("ECSI_STATUS_MESSAGE");
      return;
    }
    var sMLFB = ECL_GetValue("ECSI_MLFB");
    var MLFB01_1LE1X = sMLFB.left(4);
  }

  getCheckBoxAttributes(strchangedAttribute);

  // #############################################################################################################
  // Context-Attributes
  // #############################################################################################################
  /*
        CONTEXT-ATTRIBUTES
        gerneral:
            MotorSolution
                0	Standard asynchonous motor solution
                1	Servo motor solution
                2	Reluctance motor solution
            
            MinimalExplosionProtectionGas
                Null	None
                2	Ex ec (Zone 2)
                1	Ex db (Zone 1)
                
            MinimalExplosionProtectionDust
                Null	None
                22	Ex tc (Zone 22)
                21	Ex tb (Zone 21)
            
        motors:
            MountingPosition
                Null	No value, if selected motor is a std. asynchron. Motor or a servo motor
                    1	M1, Output side A (geared motors)
                    2	M2, Output side A (geared motors)
                    3	M3, Output side A (geared motors)
                    4	M4, Output side A (geared motors)
                    5	M5, Output side A (geared motors)
                    6	M6, Output side A (geared motors)
                    7	M1, Output side B (geared motors)
                    8	M2, Output side B (geared motors)
                    9	M3, Output side B (geared motors)
                    10	M4, Output side B (geared motors)
                    11	M5, Output side B (geared motors)
                    12	M6, Output side B (geared motors)

            (MotorFrequency)
                Null	No value, if selected motor is a servo motor
                50	50 Hz
                60	60 Hz
                87	87 Hz
                104	104 Hz
                6050	60 Hz with 50 Hz power (also called "60p50")

            CoolingMethodMotor
                0	Self-ventilated
                1	Forced ventilation
                2	Water cooling
                3	Self-cooling
                4	Push-through ventilation

            EncoderTypeRough
                Null	Any (nothing specific set by the user)
                0	Incremental
                1	Absolute
            MotorConnection
                0	Motor dimensioned with delta circuit
                1	Motor dimensioned with star circuit
            
            ? DefaultGearboxAdapter
            ? MotorRatedPower
            ? MotorRatedSpeed
            
            MotorBrakeRequired
                True
                False
            ? MotorPoleCount
    */

  // #############################################################################################################

  // #############################################################################################################
  // Konfigurationslogik anwenden
  // #############################################################################################################
  var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
  if (sECSI_MLFB == "") {
    return;
  }
  var sMLFB16 = sECSI_MLFB.left(16);
  // ###################################################################################################################################
  // LOGIK
  // ###################################################################################################################################
  if (sMLFB16.indexOf(".") < 0) {
    var sStatus = ExecProductLogic(strchangedAttribute);
    if (sStatus != "OK") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
      return;
    }
  }
  setCheckBoxAttributes();

  // ###################################################################################################################################
  // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
  // ###################################################################################################################################
  var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // diese kann sich durch die Konfiguration geändert haben, insbes. in den ersten 16 Stellen

  var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
  ECL_SetValue("ECSI_MLFB", full_mlfb);

  // ###################################################################################################################################
  // Consequence-Attributes
  // ###################################################################################################################################

  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // frisch besorgen, kann überall geändert worden sein
  var oConsequences = determineConsequences(sECSI_MLFB);

  if (oConsequences.AdditionalInertia == "ERROR") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue(
      "ECSI_STATUS_MESSAGE",
      ECL_Translate("DICT1_ERR_1FT2___CC_ADDITIONAL_INERTIA")
    );
    return;
  }

  if (oConsequences.BrakeID.left(5) == "ERROR") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue(
      "ECSI_STATUS_MESSAGE",
      ECL_Translate("DICT1_ERR_1FT2___BRAKEID")
    );
    return;
  }

  if (oConsequences.Error_Message != "") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue(
      "ECSI_STATUS_MESSAGE",
      ECL_Translate("DICT1_ERR_1FT2___CONSEQUENCES")
    );
    return;
  }

  if (oConsequences.NoCableDQ == "ERROR") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue(
      "ECSI_STATUS_MESSAGE",
      ECL_Translate("DICT1_ERR_1FT2___NO_CABLE_DQ")
    );
    return;
  }
  /* zur Info:
    var oConsequences = {
        AdditionalInertia 			: getAdditionalInertia(sECSI_MLFB),
        //MinPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
        //MaxPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MaxPulseFrequency', 		'max'),
        //AllowedControlModes		: getAllowedControlModes,
        IpProtectionLevelMotor  	: getIpProtectionLevelMotor(),
    //	SensorModule				: getSensorModule(),
        BrakeID						: getBrakeID(sECSI_MLFB),
    //	GearboxOil					: getGearboxOil(),
        GearboxOutputShaftType		: aShaftParams[0],
        GearboxOutputShaftDiameter	: aShaftParams[1],
        OutputShaftLength			: aShaftParams[2],
        GearboxMountingType			: "P",									// P: Flange-mounted i2=l
    //	GearboxReinforcedBearing	: getGearboxReinforcedBearing(),		// 0 Standard
        //SelectedGearboxAdapterID	: getSelectedGearboxAdapterID(),
        Error_Message				: strErr
    }
    */

  ECL_SetValue("ECSI_CC_AdditionalInertia", oConsequences.AdditionalInertia);
  //ECL_SetValue("ECSI_CC_MinPulseFrequency", 		oConsequences.MinPulseFrequency);
  //ECL_SetValue("ECSI_CC_MaxPulseFrequency", 		oConsequences.MaxPulseFrequency);
  //ECL_SetValue("ECSI_CC_AllowedControlModes", 		"");	//
  ECL_SetValue(
    "ECSI_CC_IpProtectionLevelMotor",
    oConsequences.IpProtectionLevelMotor
  );
  ECL_SetValue("ECSI_CC_BrakeID", oConsequences.BrakeID);
  //ECL_SetValue("ECSI_CC_GearboxOil", 				oConsequences.GearboxOil);
  ECL_SetValue(
    "ECSI_CC_GearboxOutputShaftType",
    oConsequences.GearboxOutputShaftType
  );
  ECL_SetValue(
    "ECSI_CC_GearboxOutputShaftDiameter",
    oConsequences.GearboxOutputShaftDiameter
  );
  ECL_SetValue("ECSI_CC_OutputShaftLength", oConsequences.OutputShaftLength);
  ECL_SetValue(
    "ECSI_CC_GearboxMountingType",
    oConsequences.GearboxMountingType
  );

  ECL_SetValue("ECSI_CC_NoPhysicalDQConnectionNeeded", oConsequences.NoCableDQ);
  // ###################################################################################################################################

  // ###################################################################################################################################
  // Deaktiviere Hilfsattribute
  ECL_DeactivateAttribute("HMK_WELLENAUSF_1FK2"); // Alternative Wellengeometrie / Wellenende

  ECL_DeactivateAttribute("HMK_VALUE_VALID_1FK2");
  ECL_DeactivateAttribute("HMK_TARGET_TRIGGER_1FK2");
  ECL_DeactivateAttribute("HMK_SYSTEM_TRIG_1FK2");
  ECL_DeactivateAttribute("HMK_KONFIG_TYP_1FK2");
  ECL_DeactivateAttribute("HMK_DIREKT_FERTIG_1FK2");

  ECL_DeactivateAttribute("MLFB01_1FK2");
  ECL_DeactivateAttribute("MLFB05_1FK2");
  ECL_DeactivateAttribute("MLFB06_1FK2");
  ECL_DeactivateAttribute("MLFB07_1FK2");
  ECL_DeactivateAttribute("MLFB08_1FK2");
  ECL_DeactivateAttribute("MLFB09_1FK2");
  ECL_DeactivateAttribute("MLFB10_1FK2");
  ECL_DeactivateAttribute("MLFB11_1FK2");
  ECL_DeactivateAttribute("MLFB12_1FK2");
  ECL_DeactivateAttribute("MLFB13_1FK2");
  ECL_DeactivateAttribute("MLFB14_1FK2");
  ECL_DeactivateAttribute("MLFB15_1FK2");
  ECL_DeactivateAttribute("MLFB16_1FK2");

  ECL_DeactivateAttribute("MLFB_RUMPF_01_10_1FK2");
  ECL_DeactivateAttribute("HMK_ANGLED_PLANETARY_GEAR_1FK2");
  ECL_DeactivateAttribute("HMK_KEY_MOTOR_1FK2");
  ECL_DeactivateAttribute("HMK_KEY_GEARBOX_1FK2");

  // Info-Attribute
  ECL_DeactivateAttribute("PMD_AAA259_001_000_1FK2"); // Motortyp
  ECL_DeactivateAttribute("PMD_AAC949_001_000_1FK2"); // Bauform
  ECL_DeactivateAttribute("PMD_AAA136_001_000_1FK2"); // Art der Kühlung
  ECL_DeactivateAttribute("PMD_AAB007_001_000_1FK2"); // Schwinggrößenstufe

  //	ECL_DeactivateAttribute("PMD_ACH516_001_000_1FK2");	// Achshöhe
  ECL_DisableAttribute("PMD_ACH516_001_000_1FK2"); // Achshöhe
  ECL_DisableAttribute("HMK_ZENTRIERR_LOCHK_1FK2"); // Zentrierrand & Lochkreis
  ECL_DeactivateAttribute("PMD_ACB772_001_000_1FK2"); // Durchmesser N
  ECL_DeactivateAttribute("PMD_ACB789_001_000_1FK2"); // Lochkreisdurchmesser M

  // Checkbox-Attribute ausblenden
  ECL_DeactivateAttribute("CB_HALTEBREMSE_1FK2"); // Haltebremse  ==> Abbildung über HMK_HOLDING_BRAKE_1FK2
  ECL_DeactivateAttribute("PMD_ABU276_001_000_1FK2"); // Haltebremse

  ECL_DeactivateAttribute("O_N16_1FK2"); // Ausführung für erhöhte chemische Beständigkeit
  ECL_DeactivateAttribute("O_Q20_1FK2"); // Anschluss zum Druckausgleich
  ECL_DeactivateAttribute("O_Q30_1FK2"); // Eignung für Tieftemperatur bis -30°C
  ECL_DeactivateAttribute("O_Q31_1FK2"); // Metall-Leistungsschild am Motor
  ECL_DeactivateAttribute("O_Q40_1FK2"); // Kompatibilität Reinraum und Trockenraum
  ECL_DeactivateAttribute("O_Y84_1FK2"); // Kundenangabe auf dem Leistungsschild

  // Getriebeoptionen und Hilfsattribute ausblenden
  ECL_DeactivateAttribute("O_M00_M11_1FK2"); // Option Getriebe M00-M11
  ECL_DeactivateAttribute("O_A11_C42_1FK2"); // Option Getriebetyp ABC**
  ECL_DeactivateAttribute("O_R00_R80_1FK2"); // Option GetriebeÜbers R**

  ECL_DeactivateAttribute("PMD_ABV410_001_000_1FK2"); // Option GetriebeÜbers R**
  //ECL_DeactivateAttribute("PMD_ABY220_001_000_1FK2"); // Schutzart IP des Getriebes

  // Orientierung des Winkelgetriebes ein-/ausblenden
  if (sWinkelGetrFlag == "YES") {
    ECL_ActivateAttribute("O_Q91_Q93_1FK2");
  } else {
    ECL_DeactivateAttribute("O_Q91_Q93_1FK2");
  }
};

function SetConfiguration_1FT2_Init() {
  var oData = {};
  /* MLFB-Schema
        MLFB01	1FT2
        MLFB05	Trägheit (Motortyp)	
        MLFB06	Achshöhe 1	
        MLFB07	Achshöhe 2 
        MLFB08	Baulänge 
        MLFB09	A (reserviert)
        MLFB10	Wicklung/Bemessungsdrehzahl (B, C, E, F, G, H, K)	
        MLFB11	. Bremse (0: ohne, 1: mit)
        MLFB12	. Schutzart
        MLFB13	. Wellenende, Passfeder
        MLFB14	. Geber 
        MLFB15	. Anschlusstechnik	
        MLFB16	0 (reserviert) 
    */

  SetMotor_Init(oData);
  SetGetriebe_Init(oData);
  SetOptionen_Init(oData);

  setCheckBoxAttributes();
}

function analyzePrimaryMLFB() {
  // ----------------------------------------------------------------------------------------------------------------
  // MLFB parsen
  // ----------------------------------------------------------------------------------------------------------------
  var oParse = parse_init(ECL_GetValue("ECSI_MLFB"));
  if (oParse.strError != "") {
    return oParse.strError;
  }

  // ----------------------------------------------------------------------------------------------------------------

  if (oParse.strError == "") {
    SetMotor_Init(oParse);
    SetGetriebe_Init(oParse);
    if (oParse.oParsingData.MLFB.POS1 == "1FT2") {
      SetOptionen_Init(oParse);
    }
    SetFREETEXTS(oParse);

    setCheckBoxAttributes();
  } else {
    ECL_SelectValue("ECSI_STATUS", "E");
    var strError = oParse.strError.replace(" ", "");
    ECL_SetValue("ECSI_STATUS_MESSAGE", translate(strError));
    return oParse.strError;
  }

  return "";
}

function checkContextValues() {
  // ECSI_CX_InstallationAltituteMotor  bis 3000 erlaubt, keine Prüfung erforderlich

  // ECSI_CX_MotorFrequency nur 50Hz
  /*	var MotorFrequency = ECL_GetValue("ECSI_CX_MotorFrequency") || "";
    if (MotorFrequency != "50" && MotorFrequency != ""){
        //Fehler
        sError = "ERRORMSG_MLFB_1FT2___MOTOR_FREQUENCY_OUT_OF_RANGE";
        return sError;
    }
    // ECSI_CX_AmbientTemperatureMotor <= 50°C
    var AmbientTemperatureMotor = parseInt(ECL_GetValue("ECSI_CX_AmbientTemperatureMotor"));
    if (AmbientTemperatureMotor > 50){
        //Fehler
        sError = "ERRORMSG_MLFB_1FT2___MOTOR_AMBIENT_TEMP_OUT_OF_RANGE";
        return sError;
    }
*/

  /*/ECSI_CX_MotorBrakeRequired
    var ECSI_CX_MotorBrakeRequired = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    //var sMLFB = ECL_GetValue("ECSI_MLFB");
    var MLFB11_1FK2 = ECL_GetValue("MLFB11_1FK2");
    
    if ((ECSI_CX_MotorBrakeRequired == "True" || ECSI_CX_MotorBrakeRequired == "1") && (MLFB11_1FK2 != "1")){
        sError = "ERRORMSG_MLFB_1FT2___CX_CHANGE_BRAKE";
        return sError;
    }
    */

  /*ECSI_CX_DirectMachineEncoderNeeded
        Null	Any (nothing specific set by the user)
        0		No											
        1		Yes											---> nicht zulässig
    * /
    var ECSI_CX_DirectMachineEncoderNeeded = ECL_GetValue("ECSI_CX_DirectMachineEncoderNeeded");
    if (ECSI_CX_DirectMachineEncoderNeeded == "1"){
        //Fehler
        sError = "ERRORMSG_MLFB_1FT2___MOTOR_DOES_NOT_FIT_CX";
        return sError;
    }
    
    /*ECSI_CX_EncoderTypeRough
        Null	Any (nothing specific set by the user)
        0		Incremental									UI_GEBER_1FK7M == OHNEU
        1		Absolute
        
        MITU	Absolutwertgebermultiturn (mit Umdrehungszähler)
        OHNEU	Inkremental / Absolutwertgeber Singleturn / Resolver (kein Umdrehungszähler)
        OHNE	Ohne
        
    UI_GEBER_1FK7M 
    */

  /*ECSI_CX_CoolingMethodMotor		<--- wird nicht übergeben????
        0	Self-ventilated
        1	Forced ventilation			MLFB09 == S
        2	Water cooling
        3	Self-cooling				MLFB09 == {A, B, C}
        4	Push-through ventilation
    * /
    var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
    var CoolingMethodMotor = parseInt(CoolingMethodMotor);
    if (CoolingMethodMotor != 9999){
        var sMLFB = ECL_GetValue("ECSI_MLFB");
        var MLFB09_1FK7M = sMLFB.charAt(8);
        if (MLFB09_1FK7M == "S" && CoolingMethodMotor != 1){
            //Fehler
            sError = "ERRORMSG_MLFB_1FT2___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            return sError;
        }
        if ((MLFB09_1FK7M == "A" || MLFB09_1FK7M == "B" || MLFB09_1FK7M == "C") && CoolingMethodMotor != 3){
            //Fehler
            sError = "ERRORMSG_MLFB_1FT2___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            return sError;
        }
    }
    /*ECSI_CX_MinimalExplosionProtectionGas
    /*ECSI_CX_MinimalExplosionProtectionDust
        nur NULL zulässig
    */
  var ECSI_CX_MinimalExplosionProtectionGas =
    ECL_GetValue("ECSI_CX_MinimalExplosionProtectionGas") || "";
  if (ECSI_CX_MinimalExplosionProtectionGas != "") {
    //Fehler
    sError = "ERRORMSG_MLFB_1FT2___MOTOR_DOES_NOT_FIT_CX_EX";
    return sError;
  }
  var ECSI_CX_MinimalExplosionProtectionDust =
    ECL_GetValue("ECSI_CX_MinimalExplosionProtectionDust") || "";
  if (ECSI_CX_MinimalExplosionProtectionDust != "") {
    //Fehler
    sError = "ERRORMSG_MLFB_1FT2___MOTOR_DOES_NOT_FIT_CX_EX";
    return sError;
  }
  return "";
}

function setProductAttributes(MLFB01_1FK2) {
  if (MLFB01_1FK2 == "1FT2") {
    ECL_ActivateAttribute("CB_O_Q20_1FK2");
    //ECL_ActivateAllAttributeValues("O_Q20_1FK2");

    ECL_ActivateAttribute("CB_O_Q30_1FK2");

    ECL_ActivateAttribute("CB_O_Q31_1FK2");
    //ECL_ActivateAllAttributeValues("O_Q31_1FK2");

    ECL_ActivateAttribute("CB_O_Q40_1FK2");

    ECL_ActivateAttribute("CB_O_N16_1FK2");
    //ECL_ActivateAllAttributeValues("O_N16_1FK2");

    ECL_ActivateAttribute("O_X01_X08_1FK2");
    ECL_ActivateAllAttributeValues("O_X01_X08_1FK2");

    ECL_ActivateAttribute("HMK_FARBAUSFUEHRUNG_1FK2");
    ECL_ActivateAllAttributeValues("HMK_FARBAUSFUEHRUNG_1FK2");

    ECL_ActivateAttribute("O_Y84_TXT_1FK2");
    //ECL_ActivateAllAttributeValues("O_Y84_1FK2");
  } else {
    ECL_DeactivateAllAttributeValues("O_Q20_1FK2");
    ECL_ActivateValue("O_Q20_1FK2", "F");
    ECL_SelectValue("O_Q20_1FK2", "F");
    ECL_DeactivateAttribute("O_Q20_1FK2");

    ECL_DeactivateAllAttributeValues("O_Q30_1FK2");
    ECL_ActivateValue("O_Q30_1FK2", "F");
    ECL_SelectValue("O_Q30_1FK2", "F");
    ECL_DeactivateAttribute("O_Q30_1FK2");

    ECL_DeactivateAllAttributeValues("O_Q31_1FK2");
    ECL_ActivateValue("O_Q31_1FK2", "F");
    ECL_SelectValue("O_Q31_1FK2", "F");
    ECL_DeactivateAttribute("O_Q31_1FK2");

    ECL_DeactivateAllAttributeValues("O_Q40_1FK2");
    ECL_ActivateValue("O_Q40_1FK2", "F");
    ECL_SelectValue("O_Q40_1FK2", "F");
    ECL_DeactivateAttribute("O_Q40_1FK2");

    ECL_DeactivateAllAttributeValues("O_N16_1FK2");
    ECL_ActivateValue("O_N16_1FK2", "F");
    ECL_SelectValue("O_N16_1FK2", "F");
    ECL_DeactivateAttribute("O_N16_1FK2");

    ECL_DeactivateAllAttributeValues("O_X01_X08_1FK2");
    ECL_ActivateValue("O_X01_X08_1FK2", "STD");
    ECL_SelectValue("O_X01_X08_1FK2", "STD");
    ECL_DeactivateAttribute("O_X01_X08_1FK2");

    ECL_DeactivateAllAttributeValues("O_Y84_1FK2");
    ECL_ActivateValue("O_Y84_1FK2", "F");
    ECL_SelectValue("O_Y84_1FK2", "F");
    ECL_DeactivateAttribute("O_Y84_1FK2");

    ECL_DeactivateAllAttributeValues("HMK_FARBAUSFUEHRUNG_1FK2");
    ECL_ActivateValue("HMK_FARBAUSFUEHRUNG_1FK2", "00001");
    ECL_SelectValue("HMK_FARBAUSFUEHRUNG_1FK2", "00001");
    ECL_DeactivateAttribute("HMK_FARBAUSFUEHRUNG_1FK2");

    ECL_DeactivateAttribute("CB_O_Q20_1FK2");
    ECL_DeactivateAttribute("CB_O_Q30_1FK2");
    ECL_DeactivateAttribute("CB_O_Q31_1FK2");
    ECL_DeactivateAttribute("CB_O_Q40_1FK2");
    ECL_DeactivateAttribute("CB_O_N16_1FK2");
    ECL_DeactivateAttribute("O_Y84_TXT_1FK2");
  }
}

function setGearboxAttributes(sGetriebeTyp) {
  if (sGetriebeTyp == "NON") {
    ECL_ActivateAttribute("HMK_ZENTRIERR_LOCHK_1FK2"); // Zentrierrand & Lochkreis
    ECL_DeactivateAttribute("HMK_ZENTR_LOCHK_GETR_1FK2"); // Zentrierrand & Lochkreis des Getriebes

    ECL_ActivateAttribute("HMK_WELLENENDE_1FK2"); // Wellenende D x Länge
    ECL_DeactivateAttribute("HMK_WELLE_DXL_GETR_1FK2"); // Wellenende D x Länge des Getriebes

    ECL_ActivateAttribute("PMD_AAA506_001_000_1FK2"); // Wellenende
    ECL_DeactivateAttribute("PMD_ABV414_001_000_1FK2"); // Wellenende des Getriebes

    ECL_DeactivateAttribute("UI_GETRIEBE_TYP_1FK2"); // Getriebetyp
    ECL_DeactivateAttribute("UI_GETRIEBE_SIZE_1FK2"); // Getriebegröße
    //ECL_DeactivateAttribute("PMD_ABY220_001_000_1FK2");		// Schutzart IP / des Getriebes
    ECL_DeactivateAttribute("PMD_ABV413_001_000_1FK2"); // Übersetzung i
    ECL_DeactivateAttribute("PMD_ABV417_001_000_1FK2"); // Anzahl Getriebestufen z
    ECL_DeactivateAttribute("PMD_ACE728_001_000_1FK2"); // Schmierung des Getriebes

    ECL_ActivateAttribute("PMD_ABJ176_001_000_1FK2"); // Schutzart
    ECL_DeactivateAttribute("PMD_ABY220_001_000_1FK2"); // Schutzart des Getriebes
    ECL_DeactivateAttribute("HMK_MIN_SCHUART_GETR_1FK2"); // Mindestschutzart Getriebe
    ECL_DeactivateAttribute("HMK_SCHUART_MOTOR_1FK2"); // Schutzart Motor

    // Motor
    ECL_ActivateAttribute("HMK_NENNMOMENT_1FK2"); // Bemessungsdrehmoment
    ECL_ActivateAttribute("UI_VT_DREHMO_STILL_1FK2"); // Stillstandsdrehmoment
    ECL_ActivateAttribute("UI_DREHZAHL_MAX_1FK2"); // Maximaldrehzahl
    // Getr.Motor
    ECL_DeactivateAttribute("UI_MOM_GETR_DAUER_1FK2"); // Abtriebsmoment (Dauerfestigkeit)
    ECL_DeactivateAttribute("UI_MOM_GETR_KURZ_1FK2"); // Maximal zulässiges Abtriebsmoment (Kurzzeitfest)
    ECL_DeactivateAttribute("HMK_DREHZ_ABTRB_MAX_1FK2"); // Maximale Abtriebsdrehzahl GetriebeMotor
  } else {
    ECL_DeactivateAttribute("HMK_ZENTRIERR_LOCHK_1FK2"); // Zentrierrand & Lochkreis
    ECL_ActivateAttribute("HMK_ZENTR_LOCHK_GETR_1FK2"); // Zentrierrand & Lochkreis des Getriebes

    ECL_DeactivateAttribute("HMK_WELLENENDE_1FK2"); // Wellenende D x Länge
    ECL_ActivateAttribute("HMK_WELLE_DXL_GETR_1FK2"); // Wellenende D x Länge des Getriebes

    ECL_DeactivateAttribute("PMD_AAA506_001_000_1FK2"); // Wellenende
    ECL_ActivateAttribute("PMD_ABV414_001_000_1FK2"); // Wellenende des Getriebes

    ECL_ActivateAttribute("UI_GETRIEBE_TYP_1FK2"); // Getriebetyp
    ECL_ActivateAttribute("UI_GETRIEBE_SIZE_1FK2"); // Getriebegröße
    //ECL_ActivateAttribute("PMD_ABY220_001_000_1FK2");		// Schutzart IP / des Getriebes
    ECL_ActivateAttribute("PMD_ABV413_001_000_1FK2"); // Übersetzung i
    ECL_ActivateAttribute("PMD_ABV417_001_000_1FK2"); // Anzahl Getriebestufen z
    ECL_ActivateAttribute("PMD_ACE728_001_000_1FK2"); // Schmierung des Getriebes

    ECL_DeactivateAttribute("PMD_ABJ176_001_000_1FK2"); // Schutzart
    //ECL_ActivateAttribute("HMK_MIN_SCHUART_GETR_1FK2");		// Mindestschutzart Getriebe
    ECL_DeactivateAttribute("HMK_MIN_SCHUART_GETR_1FK2"); // Mindestschutzart Getriebe
    ECL_ActivateAttribute("PMD_ABY220_001_000_1FK2"); // Schutzart des Getriebes
    ECL_ActivateAttribute("HMK_SCHUART_MOTOR_1FK2"); // Schutzart Motor

    // Motor
    ECL_DeactivateAttribute("HMK_NENNMOMENT_1FK2"); // Bemessungsdrehmoment
    ECL_DeactivateAttribute("UI_VT_DREHMO_STILL_1FK2"); // Stillstandsdrehmoment
    ECL_DeactivateAttribute("UI_DREHZAHL_MAX_1FK2"); // Maximaldrehzahl
    // Getr.Motor
    ECL_ActivateAttribute("UI_MOM_GETR_DAUER_1FK2"); // Abtriebsmoment (Dauerfestigkeit)
    ECL_ActivateAttribute("UI_MOM_GETR_KURZ_1FK2"); // Maximal zulässiges Abtriebsmoment (Kurzzeitfest)
    ECL_ActivateAttribute("HMK_DREHZ_ABTRB_MAX_1FK2"); // Maximale Abtriebsdrehzahl GetriebeMotor
  }
}
