//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1FT7M
// 	Date: 2021-07-01
// 	User: Administrator
// ---------------------------------------------------------

//#mode(full-ecma)

// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class
//@import "1FT7_CONFIG/VT_1FT7.js"
//@import "1FT7_CONFIG/CFG_1FT7_CHECKBOX.js"
//@import "1FT7_CONFIG/CFG_1FT7_CONSEQUENCES.js"
//@import "1FT7_CONFIG/CFG_1FT7_PRODUKTLOGIK.js"
//@import "1FT7_CONFIG/CFG_1FT7_GETRIEBE.js"
//@import "1FT7_CONFIG/CFG_1FT7_MOTOR.js"
//@import "1FT7_CONFIG/CFG_1FT7_GEBER.js"
//@import "1FT7_CONFIG/CFG_1FT7_FARBE.js"
//@import "1FT7_CONFIG/CFG_1FT7_OPTIONS_MISC.js"
//@import "1FT7_CONFIG/CFG_1FT7_OPTIONEN_1.js"
//@import "1FT7_CONFIG/CFG_1FT7_OPTIONEN_2.js"
//@import "1FT7_CONFIG/CFG_1FT7_GENERIERE_KAG.js"
//@import "1FT7_PARSER/Parser.1FT7.parse.js"

/* DB history
DB-Stand: 20982 alt
DB-Stand: 21494 alt 2021.04
DB-Stand: 22016 alt 2021.06
DB-Stand: 22528 alt 2021.09 DT-K 2.22
DriveTrain added
DB-Stand: 23163 alt 2021.12 DT-K 2.27
DB-Stand: 24090 alt 2022.11 DT-K 2.38 (evosoft)
DB-Stand: 24137 alt 2022.12 DT-K 2.39 (evosoft)
DB-Stand: 24479 alt 2023.02 DT-K 2.42 (Plan Software)
DB-Stand: 24652 alt 2023.02 DT-K 2.48 (evosoft)
05.2023 DriveTrains modified (N16, K24)
DB-Stand: 25486 neu 2024.02 DT-K 2.50 (Plan Software)
DB-Stand: 26050 neu 2024.04 DT-K 2.51 (Plan Software)
DB-Stand: 26744 neu 2025.06 DT-K 2.60 (Plan Software)
*/
//VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
//var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables

var sDB_Version = "26744"; // DB-Version
var sDB_Suffix = "_" + sDB_Version; // DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {
  // Derive evaluation of ECSI attributes from primary MLFB
  SetAttributesFromMlfb();

  ECL_Trace("DT-K database-version: " + sDB_Version);
  ECL_Trace("Script-version: 2025.06.00_250425");
  /*
    MLFB-Schema
    
    MLFB01	1
  MLFB02	F
  MLFB03	T
  MLFB04	7
  MLFB05	Achshhe 1	{03, 04, 06, 08, 10, 13} entspr. AH 36, 48, 63, 80, 100, 132
  MLFB06	Achshhe 2	PMD_ABP663_001_000_1FT7M
  MLFB07	Baulnge {2,4,5,6,7,8}		TAK_ABU212_001_000_1FT7M
  MLFB08	Motortyp (Merkmal) {1, 5, 7, 9} Kerntyp, Compact, High Dynamic, Sonderausfhrung	PMD_AAA259_001_000_1FT7M
  MLFB09	Khlung {A, W, S} Selbstkhlung, Wasserkhlung, Fremsbelftung		PMD_AAA136_001_000_1FT7M
  MLFB10	Bemessungsdrehzahl	{B, C, F, H, K, Z} 
  MLFB11	Zwischenkreisspannung {7} 600...720V
  MLFB12	Flanschausfhrung	{0, 5, 1, 4} kompakt mit Drive CLiQ, ohne Drive CLiQ, klassisch mit, ohne
  MLFB13	Steckerabgangsrichtung / Klemmenkasten/Leitungseinfhrung 
  MLFB14	Geber 
  MLFB15	Wellenende / Wellen- und Flanschgenauigkeit / Haltebremse	
      PMD_AAA506_001_000_1FT7M		TAK_AAJ730_001_000_1FT7M		PMD_ABU276_001_000_1FT7M
  MLFB16	Schwinggrenstufe / Schutzart 		PMD_AAB007_001_000_1FT7M		PMD_ABJ176_001_000_1FT7M
	
    SeriesID ohne Planetengetriebe: 301
  SeriesID mit  Planetengetriebe: 303 
	
  1FT70345AK7.....
  1FT70345AK7..... -Z J02
    */

  // Defaults, wird ggf. von der Fehlerbehandlung gendert
  ECL_SelectValue("ECSI_STATUS", "OK"); // Status fr MLFB-bergabe
  ECL_SetValue("ECSI_STATUS_MESSAGE", ""); // Statusmeldung fr MLFB-bergabe

  //ECL_DisableAttribute("ECSI_TYPBEZEICHNUNG"); // gibt es nicht?!
  ECL_DisableAttribute("ECSI_STATUS");
  ECL_DisableAttribute("ECSI_STATUS_MESSAGE");

  /* 
    var sEvent = getstring("EVENT", "ENGINE");
    var nStep = getint("STEP", "ENGINE");
    if (nStep < 1 || sEvent == "IDC_LINK_CONFIGURATION" || (sEvent == "INIT" && nStep > 1))
        return;
    */
  var strchangedAttribute = ECL_GetCurrentAttribute();

  // Dummy Aufrufe von SIZER unterdrcken
  /*	if (strchangedAttribute == '')
        return;
*/
  if (strchangedAttribute.left(7) == "ECSI_CX") return;

  if (strchangedAttribute == "@INIT@") {
    //Initialisierung

    SetConfiguration_1FT7M_Init();

    //ECL_SetValue("ECSI_MLFB", "1FT70345AK7.....");

    //return;
  }
  //var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
  if (strchangedAttribute == "ECSI_MLFB") {
    var ECSI_IS_START_CONFIGURATION = ECL_GetValue(
      "ECSI_IS_START_CONFIGURATION"
    );
    /*
        // #############################################################################################################
        // Context-Attributes
        // #############################################################################################################
        /*
        CONTEXT-ATTRIBUTES
        gerneral:
            MotorSolution
                0	Standard asynchonous motor solution
                1	Servo motor solution
                2	Reluctance motor solution
            
            MinimalExplosionProtectionGas
                Null	None
                2	Ex ec (Zone 2)
                1	Ex db (Zone 1)
                
            MinimalExplosionProtectionDust
                Null	None
                22	Ex tc (Zone 22)
                21	Ex tb (Zone 21)
            
        motors:
            MountingPosition
                Null	No value, if selected motor is a std. asynchron. Motor or a servo motor
                    1	M1, Output side A (geared motors)
                    2	M2, Output side A (geared motors)
                    3	M3, Output side A (geared motors)
                    4	M4, Output side A (geared motors)
                    5	M5, Output side A (geared motors)
                    6	M6, Output side A (geared motors)
                    7	M1, Output side B (geared motors)
                    8	M2, Output side B (geared motors)
                    9	M3, Output side B (geared motors)
                    10	M4, Output side B (geared motors)
                    11	M5, Output side B (geared motors)
                    12	M6, Output side B (geared motors)

            (MotorFrequency)
                Null	No value, if selected motor is a servo motor
                50	50 Hz
                60	60 Hz
                87	87 Hz
                104	104 Hz
                6050	60 Hz with 50 Hz power (also called "60p50")

            CoolingMethodMotor
                0	Self-ventilated
                1	Forced ventilation
                2	Water cooling
                3	Self-cooling
                4	Push-through ventilation

            EncoderTypeRough
                Null	Any (nothing specific set by the user)
                0	Incremental
                1	Absolute
            MotorConnection
                0	Motor dimensioned with delta circuit
                1	Motor dimensioned with star circuit
            
            ? DefaultGearboxAdapter
            ? MotorRatedPower
            ? MotorRatedSpeed
            
            MotorBrakeRequired
                True
                False
            ? MotorPoleCount
        */

    if (ECSI_IS_START_CONFIGURATION != 1) {
      var sStatus = checkContextValues();

      if (sStatus != "") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
        return;
      }
    }
    var sStatus = analyzePrimaryMLFB();
    if (sStatus != "") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
      return;
    }

    var sMLFB = ECL_GetValue("ECSI_MLFB");
    var MLFB01_1LE1X = sMLFB.left(4);
  }

  getCheckBoxAttributes(strchangedAttribute);

  var ECSI_CX_IsDriveTrain = ECL_GetValue("ECSI_CX_IsDriveTrain");
  if (ECSI_CX_IsDriveTrain == "1") {
    var sMLFB = ECL_GetValue("ECSI_MLFB");
    var sTypVorbidden = sMLFB.left(7);
    if (sTypVorbidden == "1FT7117") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue(
        "ECSI_STATUS_MESSAGE",
        translate("DICT1_ERR_1FT7M___MOTOR_NOT_SUPPORTED_FOR_DRIVETRAIN")
      );
      return;
    }
    if (sMLFB.charAt(8) == "W" || sMLFB.charAt(8) == "S") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue(
        "ECSI_STATUS_MESSAGE",
        translate("DICT1_ERR_1FT7M___MOTOR_NOT_SUPPORTED_FOR_DRIVETRAIN")
      );
      return;
    }
  }

  //Konfiguration anwerfen

  var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
  if (sECSI_MLFB == "") {
    return;
  }
  // ###################################################################################################################################
  // LOGIK
  // ###################################################################################################################################
  var test = ECL_GetAllAttributeValues("MLFB12_1FT7M");
  var sStatus = ExecProductLogic(strchangedAttribute);
  if (sStatus != "OK") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
    return;
  }

  //Sonderlogik fr Adapteranbau
  /*	im PL-Skript und Parser
        var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
        if(strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1)
        {
            // nur mit klassischem Flansch, grundstzlich nur glatte Welle ohne Passfeder
            // MLFB12 nur 1, 4			(0, 5 deaktivieren)
            // MLFB15 nur G, H, K, L 	(A,B,D,E deaktivieren)
        }
        */

  setCheckBoxAttributes();
  /*	var sStatus = ExecProductLogicABAPCode(strchangedAttribute);
        if (sStatus != "OK"){
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", sStatus);
            return;
        }
    */
  // ###################################################################################################################################
  // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
  // ###################################################################################################################################
  var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // diese kann sich durch die Konfiguration gendert haben, insbes. in den ersten 16 Stellen

  var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
  ECL_SetValue("ECSI_MLFB", full_mlfb);
  // ###################################################################################################################################

  // ###################################################################################################################################
  // Consequence-Attributes
  // ###################################################################################################################################
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // frisch besorgen, kann berall gendert worden sein
  var oConsequences = determineConsequences(sECSI_MLFB);

  if (oConsequences.BrakeID.left(5) == "ERROR") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue(
      "ECSI_STATUS_MESSAGE",
      ECL_Translate("DICT1_ERR_1FT7M___BRAKEID")
    );
    return;
  }

  if (oConsequences.Error_Message != "") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue(
      "ECSI_STATUS_MESSAGE",
      ECL_Translate("DICT1_ERR_1FT7M___CONSEQUENCES")
    );
    return;
  }
  /*
    var oConsequences = {
        AdditionalInertia 			: getAdditionalInertia(sECSI_MLFB),
        //MinPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
        //MaxPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MaxPulseFrequency', 		'max'),
        //AllowedControlModes		: getAllowedControlModes,
        IpProtectionLevelMotor  	: getIpProtectionLevelMotor(),
        //SensorModule				: getSensorModule(),
        GearboxOil					: getGearboxOil(),
        OutputShaftLength			: aShaftParams[2],
        GearboxOutputShaftType		: aShaftParams[0],
        GearboxOutputShaftDiameter	: aShaftParams[1],
        GearboxMountingType			: "P",
        BrakeID						: getBrakeID(sECSI_MLFB),
        GearboxReinforcedBearing	: getGearboxReinforcedBearing(),
        Error_Message				: strErr
    }
    */

  ECL_SetValue("ECSI_CC_AdditionalInertia", oConsequences.AdditionalInertia);
  //ECL_SetValue("ECSI_CC_MinPulseFrequency", 		oConsequences.MinPulseFrequency);
  //ECL_SetValue("ECSI_CC_AllowedControlModes", 	"");	//
  ECL_SetValue("ECSI_CC_IpProtectionLevelMotor", oConsequences.IpProtectionLevelMotor);

  //ECL_SetValue("ECSI_CC_GearboxOil", 				oConsequences.GearboxOil);
  ECL_SetValue("ECSI_CC_OutputShaftLength", oConsequences.OutputShaftLength);
  ECL_SetValue("ECSI_CC_GearboxOutputShaftType", oConsequences.GearboxOutputShaftType);
  ECL_SetValue("ECSI_CC_GearboxOutputShaftDiameter", oConsequences.GearboxOutputShaftDiameter);
  ECL_SetValue("ECSI_CC_GearboxMountingType", oConsequences.GearboxMountingType);
  ECL_SetValue("ECSI_CC_BrakeID", oConsequences.BrakeID);
  ECL_SetValue("ECSI_CC_GearboxReinforcedBearing", oConsequences.GearboxReinforcedBearing);

  // ###################################################################################################################################

  // ###################################################################################################################################
  ECL_DeactivateAttribute("PMD_AAE020_001_000_1FT7M"); // Bemessungsdrehzahl
  ECL_DeactivateAttribute("PMD_AAA259_001_000_1FT7M"); // Motortyp
  ECL_DeactivateAttribute("PMD_ABP663_001_000_1FT7M"); // Achshhe
  ECL_DeactivateAttribute("TAK_ABU212_001_000_1FT7M"); // Baulnge
  ECL_DisableAttribute("HMK_AUFBAU_WELLE_1FT7M"); // Wellenabmessungen
  ECL_DeactivateAttribute("PMD_AAA136_001_000_1FT7M"); // Khlart

  ECL_EnableAttribute("PMD_ABU278_001_000_1FT7M"); // Gebersystem
  //ECL_DisableAttribute("PMD_ABU278_001_000_1FT7M"); // Gebersystem

  // Deaktiviere Hilfsattribute
  ECL_DeactivateAttribute("HMK_UMRICHTER_1FT7M");
  ECL_DeactivateAttribute("HMK_VALUE_VALID_1FT7M");
  ECL_DeactivateAttribute("MLFB08_1FT7M");
  ECL_DeactivateAttribute("MLFB09_1FT7M");
  ECL_DeactivateAttribute("MLFB10_1FT7M");
  ECL_DeactivateAttribute("MLFB11_1FT7M");
  ECL_DeactivateAttribute("MLFB12_1FT7M");
  ECL_DeactivateAttribute("MLFB13_1FT7M");
  ECL_DeactivateAttribute("MLFB14_1FT7M");
  ECL_DeactivateAttribute("MLFB15_1FT7M");
  ECL_DeactivateAttribute("MLFB16_1FT7M");

  ECL_DeactivateAttribute("HMK_KONFIG_ZIEL_1FT7M");

  // Getriebe HMK ausblenden todo
  ECL_DeactivateAttribute("PMD_ABV413_001_000_1FT7M"); // Übersetzung
  ECL_DeactivateAttribute("PMD_ABV417_001_000_1FT7M"); // Stufen
  ECL_DeactivateAttribute("HMK_OPT_PLANETGETR_1FT7M"); // Hilfsmerkmal Optionen Getriebe (KAG)

  // Produktiv deaktiviert:
  ECL_DeactivateAttribute("HMK_RUMPF_1FT7M"); // Rumpf
  ECL_DeactivateAttribute("HMK_BAUGROESSE_1FT7M"); // Baugrße (HMK) AH+Baulnge
  ECL_DeactivateAttribute("PMD_ABV400_001_000_1FT7M"); // Baugrße Stecker (HMK)
  ECL_DeactivateAttribute("HMK_OPT_PLANETGETR_1FT7M"); // KAG_Getriebe

  // Checkbox-Attribute ausblenden
  //ECL_DeactivateAttribute("PMD_AAA506_001_000_1FT7M"); // Passfeder
  ECL_DeactivateAttribute("UI_PASSFEDER_1FT7M"); // Passfeder

  ECL_DeactivateAttribute("PMD_ABU276_001_000_1FT7M"); // Haltebremse
  ECL_DeactivateAttribute("HMK_OPT_N27_1FT7M"); // Haltebremse mit reduziertem Trgheitsmoment
  ECL_DeactivateAttribute("PMD_ABU209_001_000_1FT7M"); // Drive-CLiQ
  ECL_DeactivateAttribute("HMK_OPT_B02_1FT7M"); // Abnahmeprfzeugnis
  ECL_DeactivateAttribute("HMK_OPT_K20_1FT7M"); // Verstrkte Lagerung
  ECL_DeactivateAttribute("HMK_OPT_R72_1FT7M"); // Inkrementalgeber
  ECL_DeactivateAttribute("HMK_OPT_CHEM_BEST_2_1FT7M"); // Ausfhrung fr erhhte chemische Bestndigkeit
  ECL_DeactivateAttribute("HMK_OPT_CHEM_BEST_1_1FT7M"); // Edelstahlwelle und Beschichtung fr erhhte chemische Bestndigkeit
  ECL_DeactivateAttribute("HMK_OPT_Y84_1FT7M"); // Kundenangabe auf dem Leistungsschild
  ECL_DeactivateAttribute("UI_OPT_Y84_1FT7M"); // Kundenangabe auf dem Leistungsschild
  ECL_DeactivateAttribute("HMK_OPT_L13_1FT7M"); // usserer Erdungsanschluss
  ECL_DeactivateAttribute("HMK_OPT_Q12_1FT7M"); // Sperrluftanschluss
  ECL_DeactivateAttribute("PMD_AAD427_001_000_1FT7M"); // Sonderausfhrung Wellenende: SIMOTICS S-1FT5 kompatibel
  ECL_DeactivateAttribute("HMK_OPT_Q13_1FT7M"); // Kundenspezifische Zusatzabdichtung

  // HMK_OPT_R72_1FT7M nicht in Konfiguration wälbar / ausgeblendet!
  ECL_DeactivateAttribute("UI_OPT_R72_1FT7M");
  var test = ECL_GetAllActiveAttributeValues("MLFB12_1FT7M");
};

function SetConfiguration_1FT7M_Init() {
  var oData = {};

  // Hilfsattribute ausblenden:

  SetMotor_Init(oData); //, true);
  SetGeber_Init(oData);
  SetFarbe_Init(oData);
  SetOptionen_1_Init(oData);
  SetOptionen_2_Init(oData);
  SetOptionsMisc_Init(oData);
  SetGetriebe_Init(oData);

  setCheckBoxAttributes();
}

function analyzePrimaryMLFB() {
  // ----------------------------------------------------------------------------------------------------------------
  // MLFB parsen
  // ----------------------------------------------------------------------------------------------------------------
  var oParse = parse_init(ECL_GetValue("ECSI_MLFB"));
  if (oParse.strError != "") {
    return oParse.strError;
  }

  // ----------------------------------------------------------------------------------------------------------------

  if (oParse.strError == "") {
    SetMotor_Init(oParse); //, false);
    SetGeber_Init(oParse);
    SetFarbe_Init(oParse);
    SetOptionen_1_Init(oParse);
    SetOptionen_2_Init(oParse);
    SetOptionsMisc_Init(oParse);
    SetGetriebe_Init(oParse);

    SetFREETEXTS(oParse);

    setCheckBoxAttributes();
  } else {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oParse.strError));
    return oParse.strError;
  }
  return "";
}

function checkContextValues() {
  // ECSI_CX_InstallationAltituteMotor  bis 3000 erlaubt, keine Prfung erforderlich

  // ECSI_CX_MotorFrequency nur 50Hz
  var MotorFrequency = ECL_GetValue("ECSI_CX_MotorFrequency") || "";
  if (MotorFrequency != "50" && MotorFrequency != "") {
    //Fehler
    sError = "ERRORMSG_MLFB_1FT7M___MOTOR_FREQUENCY_OUT_OF_RANGE";
    return sError;
  }
  // ECSI_CX_AmbientTemperatureMotor <= 50C
  var AmbientTemperatureMotor = parseInt(
    ECL_GetValue("ECSI_CX_AmbientTemperatureMotor")
  );
  if (AmbientTemperatureMotor > 50) {
    //Fehler
    sError = "ERRORMSG_MLFB_1FT7M___MOTOR_AMBIENT_TEMP_OUT_OF_RANGE";
    return sError;
  }

  /*/ECSI_CX_MotorBrakeRequired
    var ECSI_CX_MotorBrakeRequired = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    var sMLFB = ECL_GetValue("ECSI_MLFB");
    var MLFB15_1FT7M = sMLFB.charAt(14);
    
    if ((ECSI_CX_MotorBrakeRequired == "True" || ECSI_CX_MotorBrakeRequired == "1") && (MLFB15_1FT7M != "B" && MLFB15_1FT7M != "E" && MLFB15_1FT7M != "H" && MLFB15_1FT7M != "L")){
        sError = "ERRORMSG_MLFB_1FT7M___CX_CHANGE_BRAKE";
        return sError;
    }
    if ((ECSI_CX_MotorBrakeRequired != "True" && ECSI_CX_MotorBrakeRequired != "1") && (MLFB15_1FT7M == "B" || MLFB15_1FT7M == "E" || MLFB15_1FT7M == "H" || MLFB15_1FT7M == "L")){
        sError = "ERRORMSG_MLFB_1FT7M___CX_CHANGE_BRAKE";
        return sError;
    }
    */

  /*ECSI_CX_DirectMachineEncoderNeeded
        Null	Any (nothing specific set by the user)
        0		No											
        1		Yes											---> nicht zulssig
    */
  var ECSI_CX_DirectMachineEncoderNeeded = ECL_GetValue(
    "ECSI_CX_DirectMachineEncoderNeeded"
  );
  if (ECSI_CX_DirectMachineEncoderNeeded == "1") {
    //Fehler
    sError = "ERRORMSG_MLFB_1FT7M___MOTOR_DOES_NOT_FIT_CX";
    return sError;
  }

  /*ECSI_CX_EncoderTypeRough
        Null	Any (nothing specific set by the user)
        0		Incremental	
        1		Absolute
    */

  /*ECSI_CX_CoolingMethodMotor		<--- wird nicht bergeben????
        0	Self-ventilated
        1	Forced ventilation			MLFB09 == S
        2	Water cooling				MLFB09 == W
        3	Self-cooling				MLFB09 == A
        4	Push-through ventilation
    */
  var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
  var CoolingMethodMotor = parseInt(CoolingMethodMotor);
  if (CoolingMethodMotor != 9999) {
    var sMLFB = ECL_GetValue("ECSI_MLFB");
    var MLFB09_1FT7M = sMLFB.charAt(8);
    if (MLFB09_1FT7M == "S" && CoolingMethodMotor != 1) {
      //Fehler
      sError = "ERRORMSG_MLFB_1FT7M___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
      return sError;
    }
    if (MLFB09_1FT7M == "A" && CoolingMethodMotor != 3) {
      //Fehler
      sError = "ERRORMSG_MLFB_1FT7M___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
      return sError;
    }
    if (MLFB09_1FT7M == "W" && CoolingMethodMotor != 2) {
      //Fehler
      sError = "ERRORMSG_MLFB_1FT7M___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
      return sError;
    }
  }
  /*ECSI_CX_MinimalExplosionProtectionGas
    /*ECSI_CX_MinimalExplosionProtectionDust
        nur NULL zulssig
    */
  var ECSI_CX_MinimalExplosionProtectionGas =
    ECL_GetValue("ECSI_CX_MinimalExplosionProtectionGas") || "";
  if (ECSI_CX_MinimalExplosionProtectionGas != "") {
    //Fehler
    sError = "ERRORMSG_MLFB_1FT7M___MOTOR_DOES_NOT_FIT_CX_EX";
    return sError;
  }
  var ECSI_CX_MinimalExplosionProtectionDust =
    ECL_GetValue("ECSI_CX_MinimalExplosionProtectionDust") || "";
  if (ECSI_CX_MinimalExplosionProtectionDust != "") {
    //Fehler
    sError = "ERRORMSG_MLFB_1FT7M___MOTOR_DOES_NOT_FIT_CX_EX";
    return sError;
  }
  return "";
}
