//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1FW3
// 	Date: 2022-08-05
// 	User: Administrator
// ---------------------------------------------------------
//#mode(full-ecma)


// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class


//@import "1FW3_CONFIG/CFG_1FW3_PRODUKTLOGIK.js"

//@import "1FW3_CONFIG/VT_1FW3.js"


//@import "1FW3_CONFIG/CFG_1FW3_MOTOR.js"

//@import "1FW3_CONFIG/CFG_1FW3_ANSCHLUSSTECHNIK.js"

//@import "1FW3_CONFIG/CFG_1FW3_OPTIONEN.js"

//@import "1FW3_CONFIG/CFG_1FW3_CONSEQUENCES.js"


//@import "1FW3_CONFIG/CFG_1FW3_GENERIERE_KAG.js"

//@import "1FW3_PARSER/Parser.1FW3.parse.js"


// include new Variant Tables

VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables

//var sDB_Version = "21841";		// DB-Version	(12.10)
//var sDB_Version = "22902";		// DB-Version	(12.12)
var sDB_Version = "23799";			// DB-Version	(15.10)
var sDB_Suffix = "_" + sDB_Version;	// DB-TableSuffix


globalThis.OnChangeConfiguration = function main() {
    // Derive evaluation of ECSI attributes from primary MLFB
    SetAttributesFromMlfb();


    ECL_Trace("DT-K database-version: " + sDB_Version);
    ECL_Trace("Script-version: 2024.10.0_240905");

    /*
    MLFB-Schema
    
    MLFB01	1FW3
    MLFB05	Achshöhe	{15,20,28,(40)}
    MLFB07	Baulänge
    MLFB08	Kennziffer / Motortyp
    MLFB09	. Geber
    MLFB10	Wicklung/Drehzahl 
    MLFB11	. Spannungsfestigkeit, Geberanbau
    MLFB12	. Bauform
    MLFB13	. Anschlusstechnik
    MLFB14	. Motorversion
    MLFB15	. Mechanik Rotor
    MLFB16	. Lagerung
    
    SeriesIDs: 
    370: Standard
    371: High Torque
    372: High Speed
	
    1FW31501.H....H.
	
    */

    // Defaults, wird ggf. von der Fehlerbehandlung geändert
    ECL_SelectValue("ECSI_STATUS", "OK");		// Status für MLFB-Übergabe
    ECL_SetValue("ECSI_STATUS_MESSAGE", "");	// Statusmeldung für MLFB-Übergabe

    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");


    var strchangedAttribute = ECL_GetCurrentAttribute();

    if (strchangedAttribute.left(7) == "ECSI_CX")
        return;


    if (strchangedAttribute === "@INIT@") {
        //Initialisierung
        SetConfiguration_1FW3_Init();
        return;
    }

    if (strchangedAttribute == "ECSI_MLFB") {

        var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
        if (ECSI_IS_START_CONFIGURATION != 1) {
            var sStatus = checkContextValues();

            if (sStatus != "") {
                ECL_SelectValue("ECSI_STATUS", "E");
                ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
                return;
            }

        }

        var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
        if (sECSI_MLFB == "") {
            return;
        }

        var sStatus = analyzePrimaryMLFB();
        if (sStatus != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
            return;
        }
        var sMLFB = ECL_GetValue("ECSI_MLFB");
    }

    // #############################################################################################################
    // Context-Attributes
    // #############################################################################################################
    var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
    var CoolingMethodMotor = parseInt(CoolingMethodMotor);
    if (CoolingMethodMotor != 9999) {

        if (CoolingMethodMotor != 2) {
            //Fehler
            var sError = "ERRORMSG_MLFB_1FW3___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sError));
            return;
        }
    }


    // #############################################################################################################
    // Konfiguration anwerfen
    // #############################################################################################################
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
    if (sECSI_MLFB == "") {
        return;
    }


    // ###################################################################################################################################
    // LOGIK
    // ###################################################################################################################################

    var sStatus = ExecProductLogic(strchangedAttribute);
    if (sStatus != "OK") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
        return;
    }


    // ###################################################################################################################################
    // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
    // ###################################################################################################################################
    var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// diese kann sich durch die Konfiguration geändert haben, insbes. in den ersten 16 Stellen

    var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
    ECL_SetValue("ECSI_MLFB", full_mlfb);



    // ###################################################################################################################################
    // Consequence-Attributes
    // ###################################################################################################################################

    //sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// frisch besorgen, kann überall geändert worden sein
    var oConsequences = determineConsequences();

    if (oConsequences.AdditionalInertia == "ERROR") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FW3___CC_ADD_INERTIA"));
        return;
    }

    /* zur Info:
    var oConsequences = {
        MaxRotationSpeedLimit	  	: getN_Max(),
        AdditionalInertia			: getAdditionalInertia(),
        IpProtectionLevelMotor  	: getIpProtectionLevelMotor(),
    }
    */

    //ECL_SetValue("ECSI_CC_MaxRotationSpeedLimit", 		oConsequences.MaxRotationSpeedLimit);

    //Es gibt keine Option, die das SpeedLimit einschränkt, also muss hier nichts zurückgegeben werden
    ECL_SetValue("ECSI_CC_MaxRotationSpeedLimit", "");
    ECL_SetValue("ECSI_CC_AdditionalInertia", oConsequences.AdditionalInertia);
    ECL_SetValue("ECSI_CC_IpProtectionLevelMotor", oConsequences.IpProtectionLevelMotor);

    // ###################################################################################################################################



    // ###################################################################################################################################	
    // Deaktiviere Hilfsattribute
    /*	
        PMD_ABV876_001_000_1002782	Stillstandsdrehmoment
        UI_NENNMOMENT_1FW3			Bemessungsdrehmoment
        PMD_ABV871_001_000_1002782	Maximaldrehzahl			zunächst nur max-N
        
    */
    ECL_DeactivateAttribute("HMK_VALUE_VALID_1FW3");
    ECL_DeactivateAttribute("PMD_ABV876_001_000_1002782");
    ECL_DeactivateAttribute("UI_NENNMOMENT_1FW3");
    ECL_DeactivateAttribute("PMD_ABV871_001_000_1002782");
    ECL_DeactivateAttribute("HMK_RUMPF_1FW3");
    ECL_DeactivateAttribute("HMK_RUMPF_9_11_12_15_1FW3");
    ECL_DeactivateAttribute("HMK_RUMPF_16_1FW3");
    ECL_DeactivateAttribute("MLFB09_1FW3");
    ECL_DeactivateAttribute("MLFB11_1FW3");
    ECL_DeactivateAttribute("MLFB12_1FW3");
    ECL_DeactivateAttribute("MLFB13_1FW3");
    ECL_DeactivateAttribute("MLFB14_1FW3");
    ECL_DeactivateAttribute("MLFB15_1FW3");
    ECL_DeactivateAttribute("MLFB16_1FW3");

    ECL_DeactivateAttribute("HMK_Y84_1FW3");
    ECL_DeactivateAttribute("HMK_K24_1FW3");

}



function SetConfiguration_1FW3_Init() {
    var oData = {};
    /* MLFB-Schema
    
    MLFB01	1FW3
    MLFB05	Achshöhe	{15,20,28,(40)}
    MLFB07	Baulänge
    MLFB08	Kennziffer / Motortyp
    MLFB09	. Geber
    MLFB10	Wicklung/Drehzahl 
    MLFB11	. Spannungsfestigkeit, Geberanbau
    MLFB12	. Bauform
    MLFB13	. Anschlusstechnik
    MLFB14	. Motorversion
    MLFB15	. Mechanik Rotor
    MLFB16	. Lagerung
        
    */

    SetMotor_Init(oData);
    SetAnschlusstechnik_Init(oData);
    SetOptionen_Init(oData);
}

function analyzePrimaryMLFB() {
    // ----------------------------------------------------------------------------------------------------------------
    // MLFB parsen
    // ----------------------------------------------------------------------------------------------------------------
    var oParse = parse_init(ECL_GetValue("ECSI_MLFB"));
    if (oParse.strError != "") {
        return oParse.strError;
    }

    // ----------------------------------------------------------------------------------------------------------------

    if (oParse.strError == "") {

        SetMotor_Init(oParse);
        SetAnschlusstechnik_Init(oParse);
        SetOptionen_Init(oParse);

        SetFREETEXTS(oParse);
        if (oParse.strError != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oParse.strError));
            return oParse.strError;
        }
    }
    else {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oParse.strError));
        return oParse.strError;
    }
    return "";
}

function checkContextValues() {
    /*ECSI_CX_CoolingMethodMotor	
        0	Self-ventilated
        1	Forced ventilation			
        2	Water cooling				only 2
        3	Self-cooling				
        4	Push-through ventilation
    */
    var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
    var CoolingMethodMotor = parseInt(CoolingMethodMotor);
    if (CoolingMethodMotor != 9999) {

        if (CoolingMethodMotor != 2) {
            //Fehler
            sError = "ERRORMSG_MLFB_1FW3___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            return sError;
        }
    }

    return "";
}