//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1FW6
// 	Date: 2022-08-04
// 	User: Administrator
// ---------------------------------------------------------

//#mode(full-ecma)


// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class

//@import "1FW6_CONFIG/CFG_1FW6_PRODUKTLOGIK.js"

//@import "1FW6_CONFIG/VT_1FW6.js"


//@import "1FW6_CONFIG/CFG_1FW6_MOTOR.js"


//@import "1FW6_CONFIG/CFG_1FW6_GENERIERE_KAG.js"

//@import "1FW6_PARSER/Parser.1FW6.parse.js"


// include new Variant Tables

VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables

/*
2025/08: 67905 - Config - 1FW6 - Remove outdated articles from config
    All 1FW6 variants with a "2" in the 8th MLFB digit are not supported any longer.
    Therefore remove the Option "Rotor and stator not mounted" and keep only "Rotor and stator mounted" and "Rotor and stator as single components"
2025/10: 69756 - Config - 1FW6 - Update to 12.49 (DTK_1FW6_27020)
2025/11: 70255 - Config - 1FW6 - Update to 12.51 (DTK_1FW6_27060)
*/
var sDB_Version = "27060";			// DB-Version 12.51
var sDB_Suffix = "_" + sDB_Version;	// DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {
    // Derive evaluation of ECSI attributes from primary MLFB
    SetAttributesFromMlfb();

    ECL_Trace("DT-K database-version: " + sDB_Version);
    ECL_Trace("Script-version: 2025.11.0_20251003");
    /*
    MLFB-Schema
    
    MLFB01	1FW6
    MLFB05	Auendurchmesser	{05,06,09,13,15,16,19,23,29,72}
    MLFB07	Ausfhrung 			{0,2,3}
    MLFB08	. Auslieferzustand	{0,2,8}
    MLFB09 	. Leitungsabgang		{,K,L,N,P,Q,T,V,W,R}
    MLFB10	Version				{B,C}
    MLFB11	Baulnge			{03,05,07,10,11,15,20}
    MLFB12	Baulnge
    MLFB13	Wicklung			{0F,...,0W}
    MLFB14	Wicklung
    MLFB15	. Leitung			{A,B,C,D}
    MLFB16	. Tempsensor		{0,1,2,3}
    
    SeriesID: 
    380: Standard		MLFB10 = B
    381: High Speed		MLFB10 = C
    382: External Rotor	MLFB10 = B, MLFB05 = 7
    
    Test:

    */

    // Defaults, wird ggf. von der Fehlerbehandlung gendert
    ECL_SelectValue("ECSI_STATUS", "OK");		// Status fr MLFB-bergabe
    ECL_SetValue("ECSI_STATUS_MESSAGE", "");	// Statusmeldung fr MLFB-bergabe

    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");


    var strchangedAttribute = ECL_GetCurrentAttribute();

    // Dummy Aufrufe von SIZER unterdrcken
    /*	if (strchangedAttribute == '')
            return;
    */
    if (strchangedAttribute.left(7) == "ECSI_CX")
        return;

    if (strchangedAttribute == "@INIT@") {
        //Initialisierung
        SetConfiguration_1FW6_Init();
        return;
    }
    //var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    if (strchangedAttribute == "ECSI_MLFB") {

        var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
        if (ECSI_IS_START_CONFIGURATION != 1) {
            var sStatus = checkContextValues();

            if (sStatus != "") {
                ECL_SelectValue("ECSI_STATUS", "E");
                ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
                return;
            }
        }

        var sStatus = analyzePrimaryMLFB();
        if (sStatus != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
            return;
        }
        var sMLFB = ECL_GetValue("ECSI_MLFB");
    }




    // #############################################################################################################
    // Context-Attributes
    // #############################################################################################################
    /*
        CONTEXT-ATTRIBUTES
        gerneral:
            MotorSolution
                0	Standard asynchonous motor solution
                1	Servo motor solution
                2	Reluctance motor solution
            
        motors:
            
            CoolingMethodMotor
                0	Self-ventilated
                1	Forced ventilation
                2	Water cooling
                3	Self-cooling
                4	Push-through ventilation
    */
    var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
    var CoolingMethodMotor = parseInt(CoolingMethodMotor);
    if (CoolingMethodMotor != 9999) {
        var sMLFB = ECL_GetValue("ECSI_MLFB");
        var MLFB07_1FW6 = sMLFB.charAt(6);
        if ((MLFB07_1FW6 == "0" && CoolingMethodMotor != 2) ||
            (MLFB07_1FW6 == "2" && CoolingMethodMotor != 2) ||
            (MLFB07_1FW6 == "3" && CoolingMethodMotor != 3)) {
            //Fehler
            var sError = "ERRORMSG_MLFB_1FW6___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sError));
            return;
        }
    }
    // #############################################################################################################


    // #############################################################################################################
    // Konfiguration anwerfen
    // #############################################################################################################
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
    if (sECSI_MLFB == "") {
        return;
    }
    var sMLFB16 = sECSI_MLFB.left(16);
    // ###################################################################################################################################
    // LOGIK
    // ###################################################################################################################################
    if (sMLFB16.indexOf(".") < 0) {
        var sStatus = ExecProductLogic(strchangedAttribute);
        if (sStatus != "OK") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
            return;
        }
    }

    // ###################################################################################################################################
    // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
    // ###################################################################################################################################
    var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// diese kann sich durch die Konfiguration gendert haben, insbes. in den ersten 16 Stellen

    var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
    ECL_SetValue("ECSI_MLFB", full_mlfb);

    // ###################################################################################################################################
    // Lieferumfang
    // ###################################################################################################################################
    /*	Wenn PMD_ABW070_001_000_1FW6 == '00001' MLFB08 = "0" (Stator und Rotor im zusammen montierten Zustand), keine Sekundär-MLFB
        Wenn PMD_ABW070_001_000_1FW6 ==	'00003' MLFB08 = "2",Stator und Rotor nicht montiert keine Sekundär-MLFB
        Wenn PMD_ABW070_001_000_1FW6 ==	'00002' MLFB08 = "8", Stator und Rotor als Einzelkomponenten mit Sekundär-MLFB (Kopie mit MLFB08 = '8')
        
        MLFB Rotor setzen
        $self.MLFB_ROTOR_1FW6 =
          $root.MLFB01_1FW6 ||
          $root.MLFB05_1FW6 ||
          $root.MLFB06_1FW6 ||
          $root.MLFB07_1FW6 ||
          '8RA' ||
          $root.MLFB11_1FW6 ||
          $root.MLFB12_1FW6 ||
          '0AA0'
        if  $root.MLFB08_1FW6 EQ '8'
    */
    var PMD_ABW070_001_000_1FW6 = ECL_GetValue("PMD_ABW070_001_000_1FW6");
    var ECSI_MLFB_SEC = "";

    if (PMD_ABW070_001_000_1FW6 == "00002") {
        // Es muss eine Sekundär-MLFB generiert werden:

        ECSI_MLFB_SEC = sECSI_MLFB.left(7) + "8RA" + sECSI_MLFB.charAt(10) + sECSI_MLFB.charAt(11) + "0AA0";

    }
    ECL_SetValue("ECSI_MLFB_SEC", ECSI_MLFB_SEC);
    // ###################################################################################################################################


    // ###################################################################################################################################	
    // Deaktiviere Hilfsattribute

    ECL_DeactivateAttribute("HMK_VALUE_VALID_1FW6");
    ECL_DeactivateAttribute("HMK_MLFB_RUMPF_1FW6");
    ECL_DeactivateAttribute("MLFB09_1FW6");
    ECL_DeactivateAttribute("MLFB15_1FW6");

    // Info-Attribute
    ECL_DisableAttribute("HMK_MOTORTYP_1FW6");
    ECL_DisableAttribute("PMD_ABU210_001_000_1FW6");
    ECL_DisableAttribute("PMD_AAC310_001_000_1FW6");
    ECL_DisableAttribute("PMD_AAD612_001_000_1FW6");

    ECL_DisableAttribute("PMD_ABW068_001_000_1FW6");
    ECL_DisableAttribute("PMD_ABW069_001_000_1FW6");
    ECL_DisableAttribute("PMD_AAA136_001_000_1FW6");
}


function SetConfiguration_1FW6_Init() {
    var oData = {};
    /* MLFB-Schema
    
    MLFB01	1FW6
    MLFB05	Auendurchmesser	{05,06,09,13,15,16,19,23,29}
    MLFB07	Ausfhrung 			{0,2,3}
    MLFB08	. Auslieferzustand	{0,2,8}
    MLFB09 	. Leitungsabgang		{,K,L,N,P,Q,T,V,W,R}
    MLFB10	Version				{B,C}
    MLFB11	Baulnge			{03,05,07,10,11,15,20}
    MLFB12	Baulnge
    MLFB13	Wicklung			{0F,...,0W}
    MLFB14	Wicklung
    MLFB15	. Leitung			{A,B,C,D}
    MLFB16	. Tempsensor		{0,1,2,3}
    
    */

    SetMotor_Init(oData);

}

function analyzePrimaryMLFB() {
    // ----------------------------------------------------------------------------------------------------------------
    // MLFB parsen
    // ----------------------------------------------------------------------------------------------------------------
    var oParse = parse_init(ECL_GetValue("ECSI_MLFB"));
    if (oParse.strError != "") {
        return oParse.strError;
    }

    // ----------------------------------------------------------------------------------------------------------------

    if (oParse.strError == "") {

        SetMotor_Init(oParse);

        //SetFREETEXTS(oParse);
        if (oParse.strError != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", oParse.strError);
            return oParse.strError;
        }
    }
    else {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oParse.strError));
        return oParse.strError;
    }
    return "";
}


function checkContextValues() {
    /*ECSI_CX_CoolingMethodMotor	
        0	Self-ventilated
        1	Forced ventilation			
        2	Water cooling				MLFB07_1FW6 == [0,2]
        3	Self-cooling				MLFB07_1FW6 == [3]
        4	Push-through ventilation
    */
    var CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || 9999;
    var CoolingMethodMotor = parseInt(CoolingMethodMotor);
    if (CoolingMethodMotor != 9999) {
        var sMLFB = ECL_GetValue("ECSI_MLFB");
        var MLFB07_1FW6 = sMLFB.charAt(8);
        if ((MLFB07_1FW6 == "0" && CoolingMethodMotor != 2) ||
            (MLFB07_1FW6 == "2" && CoolingMethodMotor != 2) ||
            (MLFB07_1FW6 == "3" && CoolingMethodMotor != 3)) {
            //Fehler
            sError = "ERRORMSG_MLFB_1FW6___COOLING_METHOD_MOTOR_OUT_OF_RANGE";
            return sError;
        }
    }

    return "";
}   