//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1PC13
// 	Date: 2022-02-01
// 	User: Administrator
// ---------------------------------------------------------
//#mode(full-ecma)


// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class

//@import "1PC13_CONFIG/CFG_1PC13_PRODUKTLOGIK.js"

//@import "1PC13_CONFIG/VT_1PC13.js"

//@import "1PC13_CONFIG/CFG_1PC13_MOTOR.js"

//@import "1PC13_CONFIG/CFG_1PC13_OPTIONEN_1.js"

//@import "1PC13_CONFIG/CFG_1PC13_OPTIONEN_2.js"

//@import "1PC13_CONFIG/CFG_1PC13_CONSEQUENCES.js"

//@import "1PC13_CONFIG/CFG_1PC13_CHECKS_DEFAULTS.js"

//@import "1PC13_CONFIG/CFG_1PC13_GENERIERE_KAG.js"

//@import "1PC13_PARSER/Parser.1PC13.parse.js"


// include new Variant Tables

// initiale Umsetzung DB-Stand 22459 (1.189)
// edit 28.06.2022: use FF instead of FB or Y75 as fix value.
// edit 07.09.2022: DT-K update 23956 (1.196) for release 10/2022
// edit 24.01.2023: Bugfix H00 Canopy
// edit 25.06.2025: Update to SPC 1.259 (DB:_1738)

//var sDB_Version = "22459";			// DB-Version	(1.189)
//var sDB_Version = "23956";			// DB-Version	(1.196)
var sDB_Version = "1738";			// DB-Version	(1.259)
var sDB_Suffix = "_" + sDB_Version;	// DB-TableSuffix


globalThis.OnChangeConfiguration = function main() {
    // Derive evaluation of ECSI attributes from primary MLFB
    SetAttributesFromMlfb();


    ECL_Trace("DT-K database-version: " + sDB_Version);
    ECL_Trace("Script-version: 2025.07.1_250717");

    /*
    MLFB-Schema
    
    MLFB01	1PC13
    MLFB06	Kühlart 4: (self)/forced-ventilated (ab 3A nur forced), 6 non-ventilated
    MLFB07	1
    MLFB08	BG 1
    MLFB09	BG 2
    MLFB10	Polzahl/Drehzahl B: 4-polig 1500, C: 6 pol 1000, D: 8 pol 750
    MLFB11	Wicklung/Leistung?
    MLFB12	9 Wicklung 1	90 - KAG!
    MLFB13	0 Wicklung 2	0
    MLFB14	. Bauform		bei c,G H00 möglich		1:1 übersetzt in IN_BAUFORM_1PC13
    MLFB15	. Motorschutz	bei Z + KAG				1:1 außer Z, da direkt nur Q3A
    MLFB16	. Anschlusskasten	4,5,6 (4 top, 5 right, 6 left)	IN_KLK_LAGE_1PC13
    
    SeriesID: 550, 551 
    
    1PC13611CB090... M4B
    1PC13411CB290... -Z F70+M4B
    1PC13412CB690... -Z F70+M4B
    */

    // Defaults, wird ggf. von der Fehlerbehandlung geändert
    ECL_SelectValue("ECSI_STATUS", "OK");		// Status für MLFB-Übergabe
    ECL_SetValue("ECSI_STATUS_MESSAGE", "");	// Statusmeldung für MLFB-Übergabe

    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");

    var strchangedAttribute = ECL_GetCurrentAttribute();

    if (strchangedAttribute.left(7) == "ECSI_CX")
        return;

    if (strchangedAttribute == "@INIT@") {
        //Initialisierung
        SetConfiguration_1PC13_Init();
        return;
    }

    var ECSI_CX_InstallationAltituteMotor = ECL_GetValue("ECSI_CX_InstallationAltituteMotor");
    ECSI_CX_InstallationAltituteMotor = parseInt(ECSI_CX_InstallationAltituteMotor);
    var ECSI_CX_AmbientTemperatureMotor = ECL_GetValue("ECSI_CX_AmbientTemperatureMotor");
    ECSI_CX_AmbientTemperatureMotor = parseInt(ECSI_CX_AmbientTemperatureMotor);

    if (strchangedAttribute == "ECSI_MLFB") {
        var ECSI_IS_START_CONFIGURATION = parseInt(ECL_GetValue("ECSI_IS_START_CONFIGURATION"));
        if (ECSI_IS_START_CONFIGURATION != 1) {
            var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
            if (sECSI_MLFB == "") {
                return;
            }
            var sStatus = checkContextValues();

            if (sStatus != "") {
                ECL_SelectValue("ECSI_STATUS", "E");
                ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
                return;
            }
        } else {
            var tester;
        }

        // #####################################################################################################################################
        // INPUT-Parameter verarbeiten
        // #####################################################################################################################################
        //------------------------------------------------------------------------------------------------------------------------------------
        // Versorgungsspannung und Frequenz
        //------------------------------------------------------------------------------------------------------------------------------------
        // StandardSupplySystem
        /*	0	230V 1-phase AC, 50Hz 	
            1	230V 3-phase AC, 50Hz
            2	380V 3-phase AC, 50Hz
            3	400V 3-phase AC, 50Hz
            4	415V 3-phase AC, 50Hz
            5	500V 3-phase AC, 50Hz
            6	690V 3-phase AC, 50Hz
            7	240V 1-phase AC, 60Hz
            8	240V 3-phase AC, 60Hz
            9	380V 3-phase AC, 60Hz
            10	400V 3-phase AC, 60Hz
            11	440V 3-phase AC, 60Hz
            12	460V 3-phase AC, 60Hz
            13	480V 3-phase AC, 60Hz
            14	600V 3-phase AC, 60Hz
            15	690V 3-phase AC, 60Hz
        */
        //------------------------------------------------------------------------------------------------------------------------------------
        /*
        ECSI_CX_MotorFrequency
        //------------------------------------------------------------------------------------------------------------------------------------
        Null	No value, if selected motor is a servo motor
        50		50 Hz
        60		60 Hz
        87		87 Hz
        104		104 Hz
        6050	60 Hz with 50 Hz power (also called "60p50")
        */
        var sFrequenz = ECL_GetValue("ECSI_CX_MotorFrequency") || "";

        if (sFrequenz == "50") { // ==> 50Hz
            ECL_SelectValue("IN_FREQUENZ_1PC13", "50");
        } else if (sFrequenz == "60") { // ==> 60Hz
            ECL_SelectValue("IN_FREQUENZ_1PC13", "60");
        } else if (sFrequenz == "69") { // ==> 69Hz
            ECL_SelectValue("IN_FREQUENZ_1PC13", "69");
        } else if (sFrequenz == "87") { // ==> 87Hz
            ECL_SelectValue("IN_FREQUENZ_1PC13", "87");
        } else {
            // Fehler
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PC13___MOTORFREQUENCY_OUTOFRANGE"));
            return;
        }
        // TemperatureClassUtilization
        /** Edit 06.2022: 
            After consultation with M. Gilbert, TemperatureClassUtilization is to be ignored and the FF is to be used as a fixed value.
            The short options N05...N08 should still be applied.
        */
        /*var ECSI_CX_TemperatureClassUtilization = parseInt(ECL_GetValue("ECSI_CX_TemperatureClassUtilization"));
        
        if (ECSI_CX_TemperatureClassUtilization == 155){
            var IN_WKL_1PC13 = "HF"; // oder HH (H_HH)
            ECL_ActivateAllAttributeValues("IN_WKL_1PC13");
            ECL_DeactivateValue("IN_WKL_1PC13", "FB");
            ExecSetStandardifValueEmpty("IN_WKL_1PC13", "HF");
            
        }else if (ECSI_CX_TemperatureClassUtilization == 130){
            var IN_WKL_1PC13 = "FB";
            ECL_DeactivateAllAttributeValues("IN_WKL_1PC13");
            ECL_ActivateValue("IN_WKL_1PC13", IN_WKL_1PC13);
            ECL_SelectValue("IN_WKL_1PC13", IN_WKL_1PC13);
            
        }else{
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", ECL_Translate("ERRORMSG_MLFB_1PC13___TEMP_CLASS_OUT_OF_RANGE"));
            return;
        }
        */
        var IN_WKL_1PC13 = "FB";
        ECL_DeactivateAllAttributeValues("IN_WKL_1PC13");
        ECL_ActivateValue("IN_WKL_1PC13", IN_WKL_1PC13);
        ECL_SelectValue("IN_WKL_1PC13", IN_WKL_1PC13);
        ECL_DeactivateAttribute("IN_WKL_1PC13");

        // in "IN_WKL_GUI_1PC13" FF is shown, internal use is FB

        // #####################################################################################################################################

        var sStatus = analyzePrimaryMLFB();
        if (sStatus != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
            return;
        }
        var sMLFB = ECL_GetValue("ECSI_MLFB");
    }

    // #############################################################################################################
    // Konfiguration anwerfen
    // #############################################################################################################
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
    if (sECSI_MLFB == "") {
        return;
    }


    // ###################################################################################################################################
    // LOGIK
    // ###################################################################################################################################

    var sStatus = ExecProductLogic(strchangedAttribute);
    if (sStatus != "OK") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
        return;
    }


    // ###################################################################################################################################
    // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
    // ###################################################################################################################################
    var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// diese kann sich durch die Konfiguration geändert haben, insbes. in den ersten 16 Stellen

    var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
    ECL_SetValue("ECSI_MLFB", full_mlfb);



    // ###################################################################################################################################
    // Consequence-Attributes
    // ###################################################################################################################################

    //sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// frisch besorgen, kann überall geändert worden sein
    var oConsequences = determineConsequences();

    /* zur Info:
    var oConsequences = {
        //MaxRotationSpeedLimit	  	: getN_Max(),
        IpProtectionLevelMotor  	: getIpProtectionLevelMotor(),
    }
    */
    if (oConsequences.MaxRotationSpeedLimit.left(5) == "ERROR") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PC13___MAXROTATIONSPEEDLIMIT"));
        return;
    }
    if (oConsequences.BrakeID.left(5) == "ERROR") {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PC13___BRAKEID"));
        return;
    }
    ECL_SetValue("ECSI_CC_MaxRotationSpeedLimit", oConsequences.MaxRotationSpeedLimit);
    ECL_SetValue("ECSI_CC_IpProtectionLevelMotor", oConsequences.IpProtectionLevelMotor);
    ECL_SetValue("ECSI_CC_BrakeID", oConsequences.BrakeID);

    // ###################################################################################################################################



    // ###################################################################################################################################	
    // Deaktiviere Hilfsattribute
    /*	
        
        
    */
    ECL_DeactivateAttribute("HMK_VALUE_VALID_1PC13");

    ECL_DeactivateAttribute("H_KUEHLART_1PC13");
    ECL_DeactivateAttribute("IN_BETRIEBSART_1PC13");
    //ECL_DeactivateAttribute("O_FREMDL_DATEN_1PC13");
    ECL_DeactivateAttribute("IN_FREQUENZ_1PC13");
    ECL_DeactivateAttribute("IN_SPG_1PC13");
    ECL_DeactivateAttribute("H_WICKLUNG_1PC13");
    ECL_DeactivateAttribute("IN_DREHZAHL_1PC13");
    ECL_DeactivateAttribute("IN_BEDARF_LEI_DD_1PC13");
    ECL_DeactivateAttribute("IN_DREHZAHL_1PC13");
    //ECL_DeactivateAttribute("IN_LEISTUNG_1PC13");
    ECL_DeactivateAttribute("IN_BAUGROESSE_1PC13");
    ECL_DeactivateAttribute("H_BAUGROESSE_DYN_1PC13");
    ECL_DeactivateAttribute("IN_WUNSCH_BAUGROESSE_1PC13");

    ECL_DisableAttribute("IN_WKL_1PC13");
    ECL_DeactivateAttribute("O_WKL_KMT_AH_1PC13");

    ECL_DeactivateAttribute("H_KAG_FARBE_1PC13");

    ECL_DeactivateAttribute("O_ZUSATZSCHILD_1PC13");

    ECL_DeactivateAttribute("H_WWDEV_MLFB_1PC13");
    ECL_DeactivateAttribute("HMK_BG_1PC13");
    ECL_DeactivateAttribute("H_MLFB05_07_1PC13");

    ECL_DisableAttribute("H_L23_UI_NACHSCHMIER_1PC13");
    ECL_DisableAttribute("H_L25_UI_LAGER_63_1PC13");
}



function SetConfiguration_1PC13_Init() {
    var oData = {};
    /* MLFB-Schema
    
    MLFB01	1PC13
    MLFB06	Kühlart 4: (self)/forced-ventilated (ab 3A nur forced), 6 non-ventilated
    MLFB07	1
    MLFB08	BG 1
    MLFB09	BG 2
    MLFB10	Polzahl/Drehzahl A: 2 polig, B: 4-polig, C: 6, D: 8
    MLFB11	Wicklung
    MLFB12	9 Wicklung 1	90 - KAG!
    MLFB13	0 Wicklung 2	0
    MLFB14	. Bauform		bei c,G H00 möglich
    MLFB15	. Motorschutz	bei Z + KAG
    MLFB16	. Anschlusskasten	4,5,6 (top, right, left)
    
    */

    SetMotor_Init(oData);
    SetOptionen_1_Init(oData);
    SetOptionen_2_Init(oData);
}

function analyzePrimaryMLFB() {
    // ----------------------------------------------------------------------------------------------------------------
    // MLFB parsen
    // ----------------------------------------------------------------------------------------------------------------
    var oParse = parse_init(ECL_GetValue("ECSI_MLFB"));
    if (oParse.strError != "") {
        return oParse.strError;
    }

    // ----------------------------------------------------------------------------------------------------------------

    if (oParse.strError == "") {

        SetMotor_Init(oParse);
        SetOptionen_1_Init(oParse);
        SetOptionen_2_Init(oParse);

        SetFREETEXTS(oParse);

        if (oParse.strError != "") {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", oParse.strError);
            return oParse.strError;
        }
    }
    else {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oParse.strError));
        return oParse.strError;
    }
    return "";
}
