//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1PH1
// 	Date: 2019-11-10
// 	User: Administrator
// ---------------------------------------------------------
//#mode(full-ecma)


// easyKAT Configuration Library
//@import "CFG_SIEMENS_1PH1_DB.js"
// Class for 1PH1 DB functions
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class

//#mode(full-ecma)



globalThis.OnChangeConfiguration = function main() {

    // Remove (previous) status message
    ECL_ResetAttribute("ECSI_STATUS_MESSAGE");

    // Deactivate Type of construction permanently as value of this attribute can't be fully reconstructed by primary MLFB, yet
    // (no corresponding definition in exported DTK tables)
    ECL_DeactivateAttribute("PMD_AAC949_001_000_1PH1");

    // Derive evaluation of ECSI attributes from primary MLFB
    SetAttributesFromMlfb();

    // Check general validity of primary MLFB
    var primaryMlfbRaw = ECL_GetValue("ECSI_MLFB");
    var primaryMlfb = checkPrimaryMlfb(primaryMlfbRaw);

    var currentAttribute = ECL_GetCurrentAttribute();

    // Cancel further processing of configuration if MLFB passed by SIZER is invalid
    if (!primaryMlfb) {
        ECL_SelectValue("ECSI_STATUS", "E");
        return;
    }

    // Suppress "dummy" calls of SIZER
    if (currentAttribute == '')
        return;

    // Evaluate attributes by primary MLFB
    if (currentAttribute == "ECSI_MLFB") {
        // Keep config feature
        manageKeepConfiguration(primaryMlfb);

        // Get MLFB again after keep config modifying it
        var primaryMlfbRaw = ECL_GetValue("ECSI_MLFB");
        var primaryMlfb = checkPrimaryMlfb(primaryMlfbRaw);

        // Reset all existing values
        //ECL_ResetBelowAttribute("ECSI_MLFB");

        // Evaluate configuration from data provided by primary MLFB
        setRatedPower(primaryMlfb);
        setSyncSpeed(primaryMlfb);
        setShaftHeight(primaryMlfb);
        setMountingType(primaryMlfb);
        setShaftVersion(primaryMlfb);
        setEncoder(primaryMlfb);

        // Preselect default values for empty attributes (in order to get a fully qualified MLFB)
        preselectDefaultValues();

        // Currently not used as Type of construction can't be fully reconstructed by primary MLFB
        // (and hence is deactivated permanently at the start of configuration)
        //reduceOptionsForTypeOfConstruction(primaryMlfb);
    }

    // Build / fill up primary MLFB by user selections
    var syncSpeed = ECL_GetValue("PMD_AAE020_001_000_1PH1");
    var ratedPower = ECL_GetValue("PMD_ABP615_001_000_1PH1");
    var shaftHeight = ECL_GetValue("PMD_ACH516_001_000_1PH1");
    var mountingType = ECL_GetValue("PMD_ABV672_001_000_1PH1");
    var shaftVersion = ECL_GetValue("PMD_AAA506_001_000_1PH1");
    var encoder = ECL_GetValue("PMD_ABU278_001_000_1PH1");
    //var typeOfConstruction = ECL_GetValue("PMD_AAC949_001_000_1PH1");

    setPrimaryMlfbFromSyncSpeedRatedPower(syncSpeed, ratedPower);
    setPrimaryMlfbFromSyncSpeed(syncSpeed);
    setPrimaryMlfbFromShaftHeight(shaftHeight);
    setPrimaryMlfbFromMountingType(mountingType);
    setPrimaryMlfbFromShaftVersion(shaftVersion);
    setPrimaryMlfbFromEncoder(encoder);

    // Currently not used as Type of construction can't be fully reconstructed by primary MLFB
    // (and hence is deactivated permanently at the start of configuration)
    //setPrimaryMlfbFromTypeOfConstruction(typeOfConstruction);

    // Set static MLFB characters (currently also static in online DTK)
    setStaticMlfbChars(primaryMlfb);

    if (!ECL_GetValue("ECSI_STATUS_MESSAGE")) {
        // Set status to OK
        ECL_SelectValue("ECSI_STATUS", "OK");
    }
}

function manageKeepConfiguration(strMlfb) {
    var keepConfig = ECL_GetValue("ECSI_IS_START_CONFIGURATION");

    if (keepConfig === "1") {
        var strBaseTypeMlfb = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
        var strNewMlfb = "";
        for (i = 0; i < strBaseTypeMlfb.length; i++) {
            if (strBaseTypeMlfb[i] !== ".") {
                var character = strBaseTypeMlfb[i];
                strNewMlfb += character;
            }
            else {
                var character = strMlfb[i];
                strNewMlfb += character;
            }
        }
        ECL_SetValue("ECSI_MLFB", strNewMlfb);
    }
}
