//@legacy
/**
* 	Script for database functions 1PH1
*
* 	Date: 2019-11-13
* 	User: Andreas Hüller, Plan Software GmbH
*/

 // easyKAT Configuration Library
//#mode(full-ecma)


// Derive Shaft height from 5th and 6th character of primary MLFB
// VT_1PH1_M00001_21804
function setShaftHeight(primaryMlfb)
{
    var char5Mlfb = primaryMlfb.substr(4, 1);
    var char6Mlfb = primaryMlfb.substr(5, 1);
    
    if (char5Mlfb != "." && char6Mlfb != ".")
    {
        var sQuery = "select PMD_ACH516_001_000_1PH1 from VT_1PH1_M00001_21804 where MLFB05_1PH1 = ? and MLFB06_1PH1 = ?;";
        var aParam = [char5Mlfb, char6Mlfb];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            ECL_SelectValue("PMD_ACH516_001_000_1PH1", aDbResult[0].PMD_ACH516_001_000_1PH1);
            ECL_DisableAttribute("PMD_ACH516_001_000_1PH1");
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_PRIMARY_MLFB_PROVIDED_SHAFT_HEIGHT"));
        }
    }
}
// Set 5th and 6th character of primary MLFB from Shaft height
// VT_1PH1_M00001_21804
function setPrimaryMlfbFromShaftHeight(shaftHeight)
{
    if (shaftHeight)
    {
        var sQuery = "select MLFB05_1PH1, MLFB06_1PH1 from VT_1PH1_M00001_21804 where PMD_ACH516_001_000_1PH1 = ?;";
        var aParam = [shaftHeight];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            changePrimaryMlfb(aDbResult[0].MLFB05_1PH1, 5);
            changePrimaryMlfb(aDbResult[0].MLFB06_1PH1, 6);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_SHAFT_HEIGHT_PROVIDED"));
        }
    }
}


// Derive Rated power from 6th, 7th and 10th character of primary MLFB
// VT_1PH1_M00009_21804
function setRatedPower(primaryMlfb)
{
    var char6Mlfb = primaryMlfb.substr(5, 1);
    var char7Mlfb = primaryMlfb.substr(6, 1);
    var char10Mlfb = primaryMlfb.substr(9, 1);
    
    if (char6Mlfb != "." && char7Mlfb != "." && char10Mlfb != ".")
    {
        var sQuery = "select PMD_ABP615_001_000_1PH1 from VT_1PH1_M00009_21804 where MLFB06_1PH1 = ? and MLFB07_1PH1 = ? and MLFB10_1PH1 = ?;";
        var aParam = [char6Mlfb, char7Mlfb, char10Mlfb];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            ECL_SelectValue("PMD_ABP615_001_000_1PH1", aDbResult[0].PMD_ABP615_001_000_1PH1);
            ECL_DisableAttribute("PMD_ABP615_001_000_1PH1");
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_PRIMARY_MLFB_PROVIDED_RATED_POWER"));
        }
    }
}


// Set 7th character of primary MLFB from Synchronous speed & rated power
// VT_1PH1_M00002_21804
function setPrimaryMlfbFromSyncSpeedRatedPower(syncSpeed, ratedPower)
{
    if (syncSpeed && ratedPower)
    {
        var sQuery = "select MLFB07_1PH1 from VT_1PH1_M00002_21804 where PMD_AAE020_001_000_1PH1 = ? and PMD_ABP615_001_000_1PH1 = ?;";
        var aParam = [syncSpeed, ratedPower];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            changePrimaryMlfb(aDbResult[0].MLFB07_1PH1, 7);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_SYNC_SPEED_RATED_POWER_PROVIDED"));
        }
    }
}


// Derive Synchronous speed from 10th character of primary MLFB
// VT_1PH1_M00003_21804
function setSyncSpeed(primaryMlfb)
{
    var char10Mlfb = primaryMlfb.substr(9, 1);
    
    if (char10Mlfb != ".")
    {
        var sQuery = "select PMD_AAE020_001_000_1PH1 from VT_1PH1_M00003_21804 where MLFB10_1PH1 = ?;";
        var aParam = [char10Mlfb];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            ECL_SelectValue("PMD_AAE020_001_000_1PH1", aDbResult[0].PMD_AAE020_001_000_1PH1);
            ECL_DisableAttribute("PMD_AAE020_001_000_1PH1");
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_PRIMARY_MLFB_PROVIDED_SYNC_SPEED"));
        }
    }
}
// Set 10th character of primary MLFB from Synchronous speed
// VT_1PH1_M00003_21804
function setPrimaryMlfbFromSyncSpeed(syncSpeed)
{
    if (syncSpeed)
    {
        var sQuery = "select MLFB10_1PH1 from VT_1PH1_M00003_21804 where PMD_AAE020_001_000_1PH1 = ?;";
        var aParam = [syncSpeed];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            changePrimaryMlfb(aDbResult[0].MLFB10_1PH1, 10);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_SYNC_SPEED_PROVIDED"));
        }
    }
}


// Derive Encoder from 9th character of primary MLFB
// VT_1PH1_M00004_21804
function setEncoder(primaryMlfb)
{
    var char9Mlfb = primaryMlfb.substr(8, 1);
    
    if (char9Mlfb != ".")
    {
        var sQuery = "select PMD_ABU278_001_000_1PH1 from VT_1PH1_M00004_21804 where MLFB09_1PH1 = ?;";
        var aParam = [char9Mlfb];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            ECL_SelectValue("PMD_ABU278_001_000_1PH1", aDbResult[0].PMD_ABU278_001_000_1PH1);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_PRIMARY_MLFB_PROVIDED_ENCODER"));
        }
    }
}
// Set 9th character of primary MLFB from Encoder
// VT_1PH1_M00004_21804
function setPrimaryMlfbFromEncoder(encoder)
{
    if (encoder)
    {
        var sQuery = "select MLFB09_1PH1 from VT_1PH1_M00004_21804 where PMD_ABU278_001_000_1PH1 = ?;";
        var aParam = [encoder];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            changePrimaryMlfb(aDbResult[0].MLFB09_1PH1, 9);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_ENCODER_PROVIDED"));
        }
    }
}


// Derive Mounting type from 12th character of primary MLFB
// VT_1PH1_M00005_21804
function setMountingType(primaryMlfb)
{
    var char12Mlfb = primaryMlfb.substr(11, 1);
    
    if (char12Mlfb != ".")
    {
        var sQuery = "select PMD_ABV672_001_000_1PH1 from VT_1PH1_M00005_21804 where MLFB12_1PH1 = ?;";
        var aParam = [char12Mlfb];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 2 && aDbResult[0].MLFB12_1PH1 == aDbResult[1].MLFB12_1PH1)
        {
            ECL_SelectValue("PMD_ABV672_001_000_1PH1", aDbResult[0].PMD_ABV672_001_000_1PH1);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_PRIMARY_MLFB_PROVIDED_MOUNTING_TYPE"));
        }
    }
}
// Reduce options for Type of construction from 12th character of primary MLFB
// VT_1PH1_M00005_21804
function reduceOptionsForTypeOfConstruction(primaryMlfb)
{
    var char12Mlfb = primaryMlfb.substr(11, 1);
    
    if (char12Mlfb != ".")
    {
        var sQuery = "select PMD_AAC949_001_000_1PH1 from VT_1PH1_M00005_21804 where MLFB12_1PH1 = ?;";
        var aParam = [char12Mlfb];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        ECL_DeactivateAllAttributeValues("PMD_AAC949_001_000_1PH1");
        
        if (!aDbResult || aDbResult.length == 0)
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_PRIMARY_MLFB_PROVIDED_TYPE_OF_CONSTRUCTION"));
            return;
        }
        
        for (i = 0; i < aDbResult.length; i++)
        {
            ECL_ActivateValue("PMD_AAC949_001_000_1PH1", aDbResult[i].PMD_AAC949_001_000_1PH1);
        }
    }
}
// Set 12th character of primary MLFB from Mounting type
// VT_1PH1_M00005_21804
function setPrimaryMlfbFromMountingType(mountingType)
{
    if (mountingType)
    {
        var sQuery = "select MLFB12_1PH1 from VT_1PH1_M00005_21804 where PMD_ABV672_001_000_1PH1 = ?;";
        var aParam = [mountingType];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 2 && aDbResult[0].MLFB12_1PH1 == aDbResult[1].MLFB12_1PH1)
        {
            changePrimaryMlfb(aDbResult[0].MLFB12_1PH1, 12);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_MOUNTING_TYPE_PROVIDED"));
        }
    }
}
// Set 12th character of primary MLFB from Type of construction
// VT_1PH1_M00005_21804
function setPrimaryMlfbFromTypeOfConstruction(typeOfConstruction)
{
    if (typeOfConstruction)
    {
        var sQuery = "select MLFB12_1PH1 from VT_1PH1_M00005_21804 where PMD_AAC949_001_000_1PH1 = ?;";
        var aParam = [typeOfConstruction];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            changePrimaryMlfb(aDbResult[0].MLFB12_1PH1, 12);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_TYPE_OF_CONSTRUCTION_PROVIDED"));
        }
    }
}


// Derive Shaft version from 13th character of primary MLFB
// VT_1PH1_M00006_21804
function setShaftVersion(primaryMlfb)
{
    var char13Mlfb = primaryMlfb.substr(12, 1);
    
    if (char13Mlfb != ".")
    {
        var sQuery = "select PMD_AAA506_001_000_1PH1 from VT_1PH1_M00006_21804 where MLFB13_1PH1 = ?;";
        var aParam = [char13Mlfb];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            ECL_SelectValue("PMD_AAA506_001_000_1PH1", aDbResult[0].PMD_AAA506_001_000_1PH1);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_PRIMARY_MLFB_PROVIDED_SHAFT_VERSION"));
        }
    }
}
// Set 13th character of primary MLFB from Shaft version
// VT_1PH1_M00006_21804
function setPrimaryMlfbFromShaftVersion(shaftVersion)
{
    if (shaftVersion)
    {
        var sQuery = "select MLFB13_1PH1 from VT_1PH1_M00006_21804 where PMD_AAA506_001_000_1PH1 = ?;";
        var aParam = [shaftVersion];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            changePrimaryMlfb(aDbResult[0].MLFB13_1PH1, 13);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_INVALID_SHAFT_VERSION_PROVIDED"));
        }
    }
}


// Set static MLFB characters (currently also static in online DTK)
function setStaticMlfbChars(primaryMlfb)
{
    // Characters 11, 14, 15 & 16 are always static (they don't depend on any attribute in online DTK)
    changePrimaryMlfb("1", 11);
    changePrimaryMlfb("G", 14);
    changePrimaryMlfb("A", 15);
    changePrimaryMlfb("0", 16);
}


// Preselect default values for empty attributes (in order to get a fully qualified MLFB)
function preselectDefaultValues()
{
    // Set first option for each empty attribute
    if (!ECL_GetValue("PMD_ABV672_001_000_1PH1"))
        ECL_SelectValue("PMD_ABV672_001_000_1PH1", "Z0001");  // Mounting type
    if (!ECL_GetValue("PMD_AAA506_001_000_1PH1"))
        ECL_SelectValue("PMD_AAA506_001_000_1PH1", "Z0002");  // Shaft version
    if (!ECL_GetValue("PMD_ABU278_001_000_1PH1"))
        ECL_SelectValue("PMD_ABU278_001_000_1PH1", "00001");  // Encoder
    if (!ECL_GetValue("PMD_AAC949_001_000_1PH1"))
        ECL_SelectValue("PMD_AAC949_001_000_1PH1", "00009");  // Type of construction
}


// Auxiliary function for replacing a single character in primary MLFB string
function changePrimaryMlfb(char, charPos)
{
    var primaryMlfb   = ECL_GetValue("ECSI_MLFB").replace("-","");
    if (primaryMlfb)
    {
        var firstMlbfPart = primaryMlfb.substr(0, charPos-1);
        var lastMlfbPart  = primaryMlfb.substr(charPos, primaryMlfb.length);
        primaryMlfb = firstMlbfPart + char + lastMlfbPart;
        ECL_SetValue("ECSI_MLFB", primaryMlfb);
    }
}

// Check general validity of primary MLFB
function checkPrimaryMlfb(primaryMlfbRaw)
{
    // Harmonize MLFB
    var primaryMlfb = primaryMlfbRaw.toUpperCase().replace("-", "").replace("?", ".");
    
    // Check MLFB for illegal characters
    var illegalChars = primaryMlfb.match(/[^a-zA-Z0-9.]/g);
    
    // Diagnose MLFB errors & return them
    if (illegalChars && illegalChars.length > 0)
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_MLFB_CHAR_INVALID"));
        return false;
    }
    
    if (primaryMlfb.length != 16)
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___1PH1_MLFB_LENGTH_INVALID") + " " + primaryMlfb.length);
        return false;
    }
    
    // Return harmonized MLFB
    return primaryMlfb;
}