//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1PH3
// 	Date: 2022-06-08
// 	User: Plan Software GmbH
// ---------------------------------------------------------
//#mode(full-ecma)

// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class
//@import "1PH3_CONFIG/VT_1PH3.js"
//@import "1PH3_CONFIG/CFG_1PH3_MOTOR_BASISDATEN.js"
//@import "1PH3_CONFIG/CFG_1PH3_GEBER.js"
//@import "1PH3_CONFIG/CFG_1PH3_WELLENENDE.js"
//@import "1PH3_CONFIG/CFG_1PH3_PRODUKTLOGIK.js"
//@import "1PH3_CONFIG/CFG_1PH3_GENERIERE_KAG.js"
//@import "1PH3_CONFIG/CFG_1PH3_CONSEQUENCES.js"
//@import "1PH3_CONFIG/CFG_1PH3_CHECKS_DEFAULTS.js"
//@import "1PH3_PARSER/Parser.1PH3.parse.js"
//@import "1PH3_MLFB/Base.misc.js"

// include new Variant Tables
var sDB_Version = "26863"; // DB-Version	V2025.08 SPC:1.39
var sDB_Suffix = "_" + sDB_Version; // DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {
  // Derive evaluation of ECSI attributes from primary MLFB
  SetAttributesFromMlfb();

  ECL_Trace("DT-K database-version: " + sDB_Version);
  ECL_Trace("Script-version: 2025.08.0_110725");

  /*
    MLFB Struktur
    MLFB.MLFB01 { 1PH3 }
    MLFB.MLFB05 5+6 Achshhe { 10, 13}
    MLFB.MLFB07 Baulnge		{ 1, 2, 3, 5, 6, 7 }
    MLFB.MLFB08 1 Motortyp 	(Asynchron)
    MLFB.MLFB09 . Geber		{ A, D } (ohne, Inkrement 22 Bit)
    MLFB.MLFB10 . Synchrondrehzahl { D, E, F, G, S } (1000, 1200, 1500, 2000) bei S nicht eindeutig, abhängig von Schaltart, nicht reproduzierbar
    MLFB.MLFB11 0 Kühlung (Gebläsekühlung DE nach NDE
    MLFB.MLFB12 . Bauform 	{ 0, 2, 4 }	(Fußbefestigung, Flanschbefestigung, Flansch 1PH8-kompatibel)
    MLFB.MLFB13 . Wellenende (glatt/Welle mit Keil) 	{ 0, 2 }
    MLFB.MLFB14 . Lagerung + Schwinggrößenstufe	{ G, L, K } Standard/S, Performance/S, Performance/SR
    MLFB.MLFB15 A
    MLFB.MLFB16 0
    
    1PH31011.F0...A0
    1PH31031.D0...A0
    1PH31031.F0...A0
    
    1PH31361.D0...A0
    
    
    SeriesID: 
    
    */

  var sECSI_MLFB = "";

  // Defaults, wird ggf. von der Fehlerbehandlung gendert
  ECL_SelectValue("ECSI_STATUS", "OK"); // Status fr MLFB-bergabe
  ECL_SetValue("ECSI_STATUS_MESSAGE", ""); // Statusmeldung fr MLFB-bergabe

  ECL_DisableAttribute("ECSI_STATUS");
  ECL_DisableAttribute("ECSI_STATUS_MESSAGE");

  var strchangedAttribute = ECL_GetCurrentAttribute();
  var ECSI_IS_START_CONFIGURATION = parseInt(
    ECL_GetValue("ECSI_IS_START_CONFIGURATION")
  );

  /*	// Dummy Aufrufe von SIZER unterdrcken
    if (strchangedAttribute == '')
        return;
*/
  if (strchangedAttribute.left(7) == "ECSI_CX") return;

  // ###########################################################################################################
  // INIT
  // ###########################################################################################################
  if (strchangedAttribute == "@INIT@") {
    //Initialisierung
    SetConfiguration_1PH3_Init();

    return;
  }
  // ###########################################################################################################

  //var ECSI_CX_MotorSolution = ECL_GetValue("ECSI_CX_MotorSolution") || "";
  /*
    0	Standard asynchonous motor solution
    */

  /*
    Zuordnung:
    */
  // ###########################################################################################################

  // ###########################################################################################################
  if (strchangedAttribute == "ECSI_MLFB") {
    var sStatus = analyzePrimaryMLFB();
    if (sStatus != "") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
      return;
    }
  }
  var sECSI_MLFB = ECL_GetValue("ECSI_MLFB");

  // ###################################################################################################################################
  // INPUT-Parameter verarbeiten
  // ###################################################################################################################################
  /* 
        
        ECSI_CX_MotorBrakeRequired
        ECSI_CX_CoolingMethodMotor
        ECSI_CX_EncoderTypeRough
        ECSI_CX_GearboxMotorCoupling
        
    */
  //var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
  //var MLFB08_1PH3 = sECSI_MLFB.charAt(7);							// Motortyp (Sync/Async/Reluktanz) & mit/ohne Bremse
  /*
    if (strwithBrake == "1"){
        
        if (MLFB08_1PH8 == "5" || MLFB08_1PH8 == "7" /* || MLFB08_1PH8 == "1" || MLFB08_1PH8 == "2" * / ){
    /*		ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PH3___WRONG_MLFB_BRAKE"));
            return;
            
        }
    }else{
        if (MLFB08_1PH8 == "6" || MLFB08_1PH8 == "8" /* || MLFB08_1PH8 == "3" || MLFB08_1PH8 == "4" * / ){
    /*		ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PH3___WRONG_MLFB_NO_BRAKE"));
            return;
            
        }
        
    }
    */
  // ###################################################################################################################################

  //Konfiguration anwerfen

  sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
  if (sECSI_MLFB == "") {
    return;
  }
  // ###################################################################################################################################
  // LOGIK
  // ###################################################################################################################################
  var sStatus = ExecProductLogic(strchangedAttribute);
  if (sStatus != "OK") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
    return;
  }

  // ###################################################################################################################################
  // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
  // ###################################################################################################################################
  var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // diese kann sich durch die Konfiguration gendert haben, insbes. in den ersten 16 Stellen

  //		var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
  //		ECL_SetValue("ECSI_MLFB", full_mlfb);

  // ###################################################################################################################################
  // ###################################################################################################################################

  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // frisch besorgen, kann berall gendert worden sein
  var oConsequences = determineConsequences(sECSI_MLFB);

  if (typeof oConsequences.MaxRotationSpeedLimit != "number") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue(
      "ECSI_STATUS_MESSAGE",
      ECL_Translate("DICT1_ERR_1PH3___CC_MAXROTATIONSPEEDLIMIT")
    );
    return;
  }

  ECL_SetValue(
    "ECSI_CC_MaxRotationSpeedLimit",
    oConsequences.MaxRotationSpeedLimit
  );
  ECL_SetValue(
    "ECSI_CC_IpProtectionLevelMotor",
    oConsequences.IpProtectionLevelMotor
  );

  // ##############################################################################################################################################
  // Fixe Attrbute aus MLFB disablen
  // ##############################################################################################################################################

  // Hilfsattribute ausblenden:
  ECL_DeactivateAttribute("HMK_VALUE_VALID__1PH3");
  ECL_DeactivateAttribute("MLFB_0506_1PH3");
  ECL_DeactivateAttribute("HMK_TECHDATAKEY_1PH3");
  ECL_DeactivateAttribute("PMD_AAC949_001_000_1PH3"); //hat viewlevel0 und keine logik deswegen wird es deaktiviert

  var stopper = 0;
};
// ENDE MAIN #########################################################################################################################################
// ENDE MAIN #########################################################################################################################################

// ---------------------------------------------------------------------------------
function SetConfiguration_1PH3_Init() {
  var oData = {};

  /*
    ECL_ExpandAttributeGroup("CFG_GROUP___GENERAL");
    ECL_ExpandAttributeGroup("CFG_GROUP___ENCODER_1PH3");
    ECL_ExpandAttributeGroup("CFG_GROUP___SHAFTEND_1PH3");
    ECL_ExpandAttributeGroup("CFG_GROUP___BAUFORM_1PH3");
    
    */
  // Schattenattribute ausblenden:
  /* */

  // ---------------------------------------------------------------------------------------------------------------

  SetMotorBasisdaten_Init(oData);

  SetGeber_Init(oData);
  SetWellenende_Init(oData);
}

function analyzePrimaryMLFB() {
  // ----------------------------------------------------------------------------------------------------------------
  // MLFB parsen
  // ----------------------------------------------------------------------------------------------------------------
  var oData = parse_init(ECL_GetValue("ECSI_MLFB"));
  if (oData.strError != "") return oData.strError;
  // ----------------------------------------------------------------------------------------------------------------

  if (oData.strError == "") {
    //try{

    SetMotorBasisdaten_Init(oData);

    SetGeber_Init(oData);
    SetWellenende_Init(oData);

    //SetFREETEXTS(oData);

    /*} catch(errorMessage){
            addToErrors(errorMessage);
        }*/
  } else {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oData.strError));
    return oData.strError;
  }
  return "";
}

function addToErrors(/**String*/ errorMessage) {
  ECL_SelectValue("ECSI_STATUS", "E");
  ECL_SetValue(
    "ECSI_STATUS_MESSAGE",
    ECL_GetValue("ECSI_STATUS_MESSAGE") + errorMessage
  );
}
