//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_1PH8
// 	Date: 2022-08-04
// 	User: Plan Software GmbH
// ---------------------------------------------------------
//#mode(full-ecma)

// easyKAT Configuration Library
//@import "SIZER_general_functions.js"
// SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
// SIZER Utility Class

//@import "1PH8_CONFIG/VT_1PH8.js"

//@import "1PH8_CONFIG/CFG_1PH8_MOTOR_BASISDATEN.js"

//@import "1PH8_CONFIG/CFG_1PH8_BREMSE.js"

//@import "1PH8_CONFIG/CFG_1PH8_GEBERSYSTEM.js"

//@import "1PH8_CONFIG/CFG_1PH8_WELLENENDE.js"

//@import "1PH8_CONFIG/CFG_1PH8_BAUFORM.js"

//@import "1PH8_CONFIG/CFG_1PH8_ANSCHLUSSTECHNIK.js"

//@import "1PH8_CONFIG/CFG_1PH8_OPTIONEN_EX_SCHUTZ.js"

//@import "1PH8_CONFIG/CFG_1PH8_OPTIONEN_FREMDBELUEFTUNG.js"

//@import "1PH8_CONFIG/CFG_1PH8_OPTIONEN_GEBERSYSTEM.js"

//@import "1PH8_CONFIG/CFG_1PH8_OPTIONEN_GRUNDIERUNG.js"

//@import "1PH8_CONFIG/CFG_1PH8_OPTIONEN_LEISTUNGSCHILD.js"

//@import "1PH8_CONFIG/CFG_1PH8_OPTIONEN_PRUEFBESCHEINIGUNGEN.js"

//@import "1PH8_CONFIG/CFG_1PH8_OPTIONEN_SCHMIERUNG.js"

//@import "1PH8_CONFIG/CFG_1PH8_OPTIONEN_SONSTIGES.js"

//@import "1PH8_CONFIG/CFG_1PH8_OPTIONEN_WELLENENDE.js"

//@import "1PH8_CONFIG/CFG_1PH8_PRODUKTLOGIK.js"

//@import "1PH8_CONFIG/CFG_1PH8_GENERIERE_KAG.js"

//@import "1PH8_CONFIG/CFG_1PH8_CONSEQUENCES.js"

//@import "1PH8_CONFIG/CFG_1PH8_CHECKS_DEFAULTS.js"

//@import "1PH8_PARSER/Parser.1PH8.parse.js"

//@import "1PH8_MLFB/Base.misc.js"

// include new Variant Tables
VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables

//var sDB_Version = "22645";		// DB-Version	V2021.09	(DTK: 18.26)
//var sDB_Version = "23307";		// DB-Version	V2021.12	(DTK: 18.31)
//var sDB_Version = "23673";		// DB-Version	V2022.04	(DTK: 20.10)
//var sDB_Version = "24154";		// DB-Version	V2022.12	(DTK: 21.14)
//var sDB_Version = "24783";		// DB-Version	V2022.12	(DTK: 21.20)
//var sDB_Version = "25908"; // DB-Version	V2024.06	(DTK: 21.33)
//var sDB_Version = "26061"; // DB-Version	V2024.07	(DTK: 25.30)
//var sDB_Version = "26158"; // DB-Version	V2024.07	(DTK: 26.11)
//var sDB_Version = "26432"; // DB-Version	V2024.11	(DTK: 26.16)
//var sDB_Version = "27043"; // DB-Version	V2025.11	(DTK: 26.23)

var sDB_Version = "27043"; // DB-Version	V2025.11	(DTK: 26.23)
var sDB_Suffix = "_" + sDB_Version; // DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {
  // Derive evaluation of ECSI attributes from primary MLFB
  SetAttributesFromMlfb();

  ECL_Trace("DT-K database-version: " + sDB_Version);
  ECL_Trace("Script-version: 2025.11.00_251003");

  /*
    MLFB Struktur
    MLFB.MLFB01 { 1PH8 }
    MLFB.MLFB05 5+6 Achshhe 	{ 08, 10, 13, 16, 18, 22}							LEA {13,16}
    MLFB.MLFB07 Baulnge		{ 0, 1, 2, 3, 4, 5, 6, 7, 8 }						    LEA {138,165,167}
    MLFB.MLFB05_07 Baulnge															LEA {138,165,167}
    MLFB.MLFB08 Motortyp (Sync/Async) mit/ohne Bremse { 1, 2, 3, 4, (7) }		LEA {5,6,7,8}	5,6: Reluktanz effizienzgesteigert; 7,8: Reluktanz leistungsgesteigert
    MLFB.MLFB09 . Geber			{ A, C, D, E, F, G, H, J, K, M, S, T, U, W, Y }		LEA {A,E,H,J,M} mit MLFB16=1 (ohne DQ) || {F,D} mit MLFB16=2	(mit DQ)
    MLFB.MLFB10 Wicklungsausfhrung	{ B, C, D, F, G, H, K, L, M, N, Q, S, T, U, V, W }		LEA Wicklungsausf. {D,F,G}
    MLFB.MLFB11 Kuehlart		{ 0, 1, 2, 3, 4 }										LEA {0,1,2}
    MLFB.MLFB12 . Bauform (B3, B5, ...)	{ 0, 1, 2, 3, 5 }							LEA {0,2,3}
    MLFB.MLFB13 . Wellenende (glatt/Passfeder) 	{ 0, 1, 2, 3 }						LEA {0,1,2}
    MLFB.MLFB14 . Lagerung 	{ A, B, C, D, E, F, G, H, L, M, N, P, Q }				LEA {A,B,C,D,F}
    MLFB.MLFB15 . Leistungsanschluss { A, B, C, D, E, F, G, H, U, V, W, X }			LEA Leistungsanschluss {A,B,C,D}
    MLFB.MLFB16 . DriveCLiQ (mit=1, ohne=2)	{ 1, 2 }								LEA Version /DQ {1,2}
  */

  var sECSI_MLFB = "";

  // Defaults, wird ggf. von der Fehlerbehandlung gendert
  ECL_SelectValue("ECSI_STATUS", "OK"); // Status fr MLFB-bergabe
  ECL_SetValue("ECSI_STATUS_MESSAGE", ""); // Statusmeldung fr MLFB-bergabe

  ECL_DisableAttribute("ECSI_STATUS");
  ECL_DisableAttribute("ECSI_STATUS_MESSAGE");

  var strchangedAttribute = ECL_GetCurrentAttribute();
  var ECSI_IS_START_CONFIGURATION = parseInt(ECL_GetValue("ECSI_IS_START_CONFIGURATION"));

  /*	// Dummy Aufrufe von SIZER unterdrcken
  if (strchangedAttribute == '')
    return;
  */
  if (strchangedAttribute.left(7) == "ECSI_CX") return;

  // ###########################################################################################################
  // INIT
  // ###########################################################################################################
  if (strchangedAttribute == "@INIT@") {
    //Initialisierung
    SetConfiguration_1PH8_Init();

    //ECL_SetValue("ECSI_MLFB_BASE_TYPE", "1PH81385.D......"); //LEA
    //ECL_SetValue("ECSI_MLFB_BASE_TYPE", "1PH81311.S0.....");
    //ECL_SetValue("ECSI_MLFB_BASE_TYPE", "1PH81381.F0.....");
    //ECL_SetValue("ECSI_CX_SeriesID", "102");	//LEA
    //ECL_SetValue("ECSI_CX_SeriesID", "100");

    return;
  }
  // ###########################################################################################################

  // ###########################################################################################################
  // Produkttrigger
  // ###########################################################################################################

  var ECSI_CX_MotorSolution = ECL_GetValue("ECSI_CX_MotorSolution") || "";
  /*
    0	Standard asynchonous motor solution
    1	Servo motor solution
    2	Reluctance motor solution
  */

  var SeriesID = ECL_GetValue("ECSI_CX_SeriesID") || "";
  SeriesID = SeriesID.left(5);
  /*
    Zuordnung:
    100	SIMOTICS M - 1PH8, Asynchron
    101	SIMOTICS M - 1PH8, Synchron
    102 1PH8 LEA	
    ACHTUNG: Unterscheidung nur in Richtung asynchron/Synchron, nicht wie geplant in Baugre.
    Wenn 1PH8 relevant wird, ggf. prfen!
  */
  var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
  if (sECSI_MLFB != "") {
    var MLFB05_1PH8 = sECSI_MLFB.charAt(4) + sECSI_MLFB.charAt(5);
    var iMLFB05 = parseInt(MLFB05_1PH8);
    if (iMLFB05 > 16) {
      var HMK_PRODUKT_TRIG_1PH8 = "1PH8_L";
    } else {
      var HMK_PRODUKT_TRIG_1PH8 = "1PH8_S";
    }
  }
  switch (SeriesID) {
    //case "1PH8_AH_80-160":
    case "100":
      // Asychron
      ECL_SetValue("HMK_AUSFUEHRUNG_1002197", "00001");
      break;
    //case "1PH8_AH_180-280":
    case "101":
      // Synchron
      ECL_SetValue("HMK_AUSFUEHRUNG_1002197", "00002");
      break;
    //case "LEA":
    case "102":
      ECL_SetValue("HMK_AUSFUEHRUNG_1002197", "00003"); // Reluktanz // Unterscheidung Effizienz-/ Leistungsgesteigert ber MLFB08_1PH8
      // MLFB08_1PH8 == 5,6 ==> effizienzgesteigert
      // MLFB08_1PH8 == 7,8 ==> leistungsgesteigert
      HMK_PRODUKT_TRIG_1PH8 = "1PH8_LEA";
      break;
    //	default:
    //		HMK_PRODUKT_TRIG_1PH8 = "1PH8_LEA";
  }
  if (HMK_PRODUKT_TRIG_1PH8) {
    ECL_SetValue("HMK_PRODUKT_TRIG_1PH8", HMK_PRODUKT_TRIG_1PH8);
    fSwitchProduct(HMK_PRODUKT_TRIG_1PH8);
  } else {
    var HMK_PRODUKT_TRIG_1PH8 = ECL_GetValue("HMK_PRODUKT_TRIG_1PH8") || "";
    if (HMK_PRODUKT_TRIG_1PH8 == "") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PH8___PROD_TRIG_UNDEFINED"));
      return;
    }
  }
  // ###########################################################################################################

  var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");

  // ###########################################################################################################
  var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
  if (strchangedAttribute == "ECSI_MLFB") {
    // ###################################################################################################################################
    // INPUT-Parameter verarbeiten
    // ###################################################################################################################################
    /* 
      ECSI_CX_MotorSolution						<== LEA n.n.
      ECSI_CX_MotorBrakeRequired
      ECSI_CX_CoolingMethodMotor
      ECSI_CX_EncoderTypeRough
      ECSI_CX_GearboxMotorCoupling
      
      ECSI_CX_MinimalExplosionProtectionGas		<== nicht LEA
      ECSI_CX_MinimalExplosionProtectionDust		<== nicht LEA
    */

    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB");
    var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    var MLFB05_1PH8 = sBaseTypeMLFB.charAt(4) + sBaseTypeMLFB.charAt(5); // Achshhe MLFB 5+6
    var MLFB08_1PH8 = sBaseTypeMLFB.charAt(7); // Motortyp (Sync/Async/Reluktanz) & mit/ohne Bremse
    var MLFB11_1PH8 = sBaseTypeMLFB.charAt(10); // Motortyp (Sync/Async/Reluktanz) & mit/ohne Bremse

    if (strwithBrake == "1" || strwithBrake == "True") {
      ECL_SelectValue("CB_HALTEBREMSE_1PH8", "T");
      ECL_DisableAttribute("CB_HALTEBREMSE_1PH8");
      var sTable = "VT_1PH8_M00340" + sDB_Suffix;
      var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
        "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
        "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND O_U60_BIS_U68_1PH8 <> 'NON';";

      var aResult = GetDBDataSetEXT(sSQL);

      if (!aResult || aResult.length == 0) {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PH8___WRONG_MLFB_BRAKE"));
        return;
      }
    } else {
      ECL_DeselectAttribute("CB_HALTEBREMSE_1PH8");
      ECL_DisableAttribute("CB_HALTEBREMSE_1PH8");

      var sTable = "VT_1PH8_M00340" + sDB_Suffix;
      var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
        "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
        "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND O_U60_BIS_U68_1PH8 = 'NON';";

      var aResult = GetDBDataSetEXT(sSQL);

      if ((!aResult || aResult.length == 0) || (MLFB08_1PH8 == "3" || MLFB08_1PH8 == "4" || MLFB08_1PH8 == "6" || MLFB08_1PH8 == "8")) {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PH8___WRONG_MLFB_NO_BRAKE"));
        return;
      }
    }

    var ECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
    // Bauform nur B5 und B35

    // ###################################################################################################################################
    /*  //if (nStep > 1){
          var sStatus = ExecProductLogic(strchangedAttribute, HMK_PRODUKT_TRIG_1PH8);
          if (sStatus != "OK"){
              ECL_SelectValue ("ECSI_STATUS", "E");
              ECL_SetValue ("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
              return;
          }
          // ###################################################################################################################################
          // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
          // ###################################################################################################################################
          
          var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
          sECSI_MLFB = ECL_GetValue("ECSI_MLFB");		// diese kann sich durch die Konfiguration gendert haben, insbes. in den ersten 16 Stellen
          
          var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
          ECL_SetValue("ECSI_MLFB", full_mlfb);
      //}*/
    // ###################################################################################################################################
    /*		if (ECSI_IS_START_CONFIGURATION != 1)
        {
            var sStatus = checkContextValues();
        }
        if (sStatus != ""){
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(sStatus));
            return;
        }
    */
    var sStatus = analyzePrimaryMLFB(HMK_PRODUKT_TRIG_1PH8);

    if (sStatus != "") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
      return;
    }
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB");
    /*var MLFB01_1PH8 = sECSI_MLFB.left(4);							// 1PH8
      var MLFB05_1PH8 = sECSI_MLFB.charAt(4) + sECSI_MLFB.charAt(5);	// Achshhe MLFB 5+6
      var MLFB07_1PH8 = sECSI_MLFB.charAt(6);							// Baulnge
      var MLFB08_1PH8 = sECSI_MLFB.charAt(7);							// Motortyp (Sync/Async/Reluktanz) & mit/ohne Bremse
      var MLFB09_1PH8 = sECSI_MLFB.charAt(8);							// Geber
      var MLFB12_1PH8 = sECSI_MLFB.charAt(11);						// Bauform (B3, B5, ...)
      var MLFB13_1PH8 = sECSI_MLFB.charAt(12);						// Wellenende (glatt/Passfeder)
      var MLFB14_1PH8 = sECSI_MLFB.charAt(13);						// Lagerung
    */
  }


  sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
  if (sECSI_MLFB == "") {
    return;
  }
  // ###################################################################################################################################
  // LOGIK
  // ###################################################################################################################################
  if (find(sECSI_MLFB.left(16), ".") >= 0) {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERRORMSG_MLFB_1PH8___INCOMPLETE_MLFB"));
    return;
  }
  var sStatus = ExecProductLogic(strchangedAttribute);
  if (sStatus != "OK") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
    return;
  }

  // ###################################################################################################################################
  // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
  // ###################################################################################################################################
  var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // diese kann sich durch die Konfiguration gendert haben, insbes. in den ersten 16 Stellen

  var full_mlfb = GenKAG(sBaseTypeMLFB, sECSI_MLFB);
  ECL_SetValue("ECSI_MLFB", full_mlfb);

  // ###################################################################################################################################
  // ###################################################################################################################################

  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // frisch besorgen, kann berall gendert worden sein
  var oConsequences = determineConsequences_1PH8(sECSI_MLFB, HMK_PRODUKT_TRIG_1PH8);

  if (oConsequences.BrakeID.left(5) == "ERROR") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PH8___CC_BRAKEID"));
    return;
  }

  if (typeof oConsequences.MaxRotationSpeedLimit != "number") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1PH8___CC_MAXROTATIONSPEEDLIMIT"));
    return;
  }

  ECL_SetValue("ECSI_CC_MaxRotationSpeedLimit", oConsequences.MaxRotationSpeedLimit); // wieder relevant!
  //ECL_SetValue("ECSI_CC_AdditionalInertia", 		oConsequences.AdditionalInertia);
  //ECL_SetValue("ECSI_CC_MinPulseFrequency", 		oConsequences.MinPulseFrequency);
  ECL_SetValue("ECSI_CC_IpProtectionLevelMotor", oConsequences.IpProtectionLevelMotor);
  ECL_SetValue("ECSI_CC_BrakeID", oConsequences.BrakeID);

  // ##############################################################################################################################################
  // Fixe Attrbute aus MLFB disablen
  // ##############################################################################################################################################
  ECL_DisableAttribute("PMD_AAA717_001_000_1PH8"); // Ausfhrung Temperatursensor
  ECL_DisableAttribute("PMD_AAA271_001_000_1PH8"); // Ausfhrung Motor
  ECL_DisableAttribute("PMD_ABP663_001_000_1002197"); // Achshhe
  // immer disablen, weil Vorgabe SIZER
  ECL_DisableAttribute("CB_HALTEBREMSE_1PH8");
  // produktiv ausblenden:
  ECL_DeactivateAttribute("HMK_AUSFUEHRUNG_1002197"); // Ausfhrung Motor
  // Update 06/2024: Für Konfig nicht mehr wählbar
  ECL_DeactivateAttribute("CB_O_L75_1PH8");
  // Edit 11/2024 Q14 only for direct input
  ECL_DeactivateAttribute("CB_O_Q14_1PH8");
  // Schattenattribute ausblenden:
  ECL_DeactivateAttribute("O_K08_1PH8");
  ECL_DeactivateAttribute("O_K09_K10_1PH8");
  ECL_DeactivateAttribute("O_Y84_1PH8");
  ECL_DeactivateAttribute("O_U60_BIS_U68_1PH8");
  ECL_DeactivateAttribute("CB_O_K24_1PH8");

  // Hilfsattribute ausblenden:
  ECL_DeactivateAttribute("HMK_PRODUKT_TRIG_1PH8");
  ECL_DeactivateAttribute("HMK_KK_1PH8");
  ECL_DeactivateAttribute("HMK_KK_2_1PH8");
  ECL_DeactivateAttribute("HMK_REAL_KK_1PH8");
  ECL_DeactivateAttribute("MOTOR_RUMPF_1PH8");
  ECL_DeactivateAttribute("HMK_RUMPF_05_07_1PH8");
  ECL_DeactivateAttribute("HMK_RUMPF_05_07_10_1PH8");
  ECL_DeactivateAttribute("H_RUMPF_050710_0811_1PH8");
  ECL_DeactivateAttribute("HMK_VALUE_VALID_1PH8");
  ECL_DeactivateAttribute("HMK_AUSF_KUEHLUNG_1PH8");
  ECL_DeactivateAttribute("HMK_KONFIG_TYP_1PH8");
  ECL_DeactivateAttribute("HMK_PRODUKT_ALT_AKT_1PH8");
  ECL_DeactivateAttribute("HMK_LAGERG_PERF_1PH8");
  ECL_DeactivateAttribute("HMK_LAGERG_HPERF_1PH8");
  ECL_DeactivateAttribute("HMK_MLFB09_GRUPPE_1PH8");
  ECL_DeactivateAttribute("HMK_MLFB15_GRUPPE_1PH8");
  ECL_DeactivateAttribute("MLFB11_1PH8");
  ECL_DeactivateAttribute("MLFB12_1PH8");
  ECL_DeactivateAttribute("MLFB13_1PH8");
  ECL_DeactivateAttribute("MLFB14_1PH8");
  ECL_DeactivateAttribute("MLFB15_1PH8");
  ECL_DeactivateAttribute("O_Y82_1002197");
  ECL_DeactivateAttribute("H_O_Y82_1006333");

  // n max values disablen
  ECL_DisableAttribute("HMK_N_MAX_BR_1PH8");
  ECL_DisableAttribute("HMK_N_MAX_G_1PH8");
  ECL_DisableAttribute("HMK_N_MAX_M03_1PH8");
  ECL_DisableAttribute("HMK_N_MAX_B_1PH8");
  ECL_DisableAttribute("HMK_N_MAX_TC_1PH8");
  ECL_DisableAttribute("HMK_N_MAX_T_1PH8");

};
// ENDE MAIN #########################################################################################################################################
// ENDE MAIN #########################################################################################################################################

// ---------------------------------------------------------------------------------
function SetConfiguration_1PH8_Init() {
  var oData = {};

  /*
    ECL_ExpandAttributeGroup("CFG_GROUP___GENERAL");
    ECL_ExpandAttributeGroup("CFG_GROUP___ENCODER_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___SHAFTEND_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___BAUFORM_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___ANSCHLUSSTECHNIK_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___KLEMMKASTEN_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_LEISTUNGSSCHILD_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_HALTEBREMSE_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_EX_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_COLOR_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_FAN_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_CERTIFICATES_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_SENSOR_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_SHAFTEND_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_SCHMIERUNG_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___OPTIONS_SONSTIGES_1PH8");
    ECL_ExpandAttributeGroup("CFG_GROUP___PARAMETERS_1PH8");
    */
  // Schattenattribute ausblenden:
  /* */
  ECL_DeactivateAttribute("O_K08_1PH8");
  ECL_DeactivateAttribute("O_K09_K10_1PH8");
  ECL_DeactivateAttribute("O_Y84_1PH8");
  ECL_DeactivateAttribute("O_U60_BIS_U68_1PH8");
  ECL_DeactivateAttribute("CB_O_K24_1PH8");

  // Hilfsattribute ausblenden:
  ECL_DeactivateAttribute("HMK_PRODUKT_TRIG_1PH8");
  ECL_DeactivateAttribute("HMK_KK_1PH8");
  ECL_DeactivateAttribute("HMK_KK_2_1PH8");
  ECL_DeactivateAttribute("HMK_REAL_KK_1PH8");
  ECL_DeactivateAttribute("HMK_RUMPF_05_07_1PH8");
  ECL_DeactivateAttribute("HMK_RUMPF_05_07_10_1PH8");
  ECL_DeactivateAttribute("H_RUMPF_050710_0811_1PH8");
  ECL_DeactivateAttribute("HMK_VALUE_VALID_1PH8");
  ECL_DeactivateAttribute("HMK_AUSF_KUEHLUNG_1PH8");
  ECL_DeactivateAttribute("HMK_KONFIG_TYP_1PH8");
  ECL_DeactivateAttribute("HMK_PRODUKT_ALT_AKT_1PH8");
  ECL_DeactivateAttribute("HMK_LAGERG_PERF_1PH8");
  ECL_DeactivateAttribute("HMK_LAGERG_HPERF_1PH8");
  ECL_DeactivateAttribute("HMK_MLFB09_GRUPPE_1PH8");
  ECL_DeactivateAttribute("HMK_MLFB15_GRUPPE_1PH8");
  ECL_DeactivateAttribute("MLFB11_1PH8");
  ECL_DeactivateAttribute("MLFB12_1PH8");
  ECL_DeactivateAttribute("MLFB13_1PH8");
  ECL_DeactivateAttribute("MLFB14_1PH8");
  ECL_DeactivateAttribute("MLFB15_1PH8");
  /* */
  ECL_DeactivateAttribute("O_Y82_1002197");
  ECL_DeactivateAttribute("H_O_Y82_1006333");

  // ---------------------------------------------------------------------------------------------------------------
  SetBremse_Init(oData);

  SetMotorBasisdaten_Init(oData);

  SetGebersystem_Init(oData);
  SetWellenende_Init(oData);
  SetBauform_Init(oData);

  SetAnschlusstechnik_Init(oData);
  SetOptionenLeistungsschild_Init(oData);
  SetOptionenExSchutz_Init(oData);
  SetOptionenGrundierung_Init(oData);
  SetOptionenFremdbelueftung_Init(oData);
  SetOptionenPruefbescheinigungen_Init(oData);
  SetOptionenGebersystem_Init(oData);
  SetOptionenWellenende_Init(oData);
  SetOptionenSchmierung_Init(oData);
  SetOptionenSonstiges_Init(oData);
}

function analyzePrimaryMLFB(HMK_PRODUKT_TRIG_1PH8) {
  // ----------------------------------------------------------------------------------------------------------------
  // MLFB parsen
  // ----------------------------------------------------------------------------------------------------------------
  var ECSI_MLFB = ECL_GetValue("ECSI_MLFB");
  var oData = parse_init(ECSI_MLFB, HMK_PRODUKT_TRIG_1PH8);

  if (oData.strError != "") {
    return oData.strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  if (find(ECL_GetValue("ECSI_MLFB").left(16), ".") >= 0) {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERRORMSG_MLFB_1PH8___INCOMPLETE_MLFB"));
    return "ERRORMSG_MLFB_1PH8___INCOMPLETE_MLFB";
  }
  if (oData.strError == "") {
    //try{

    SetBremse_Init(oData);
    SetMotorBasisdaten_Init(oData);
    SetGebersystem_Init(oData);
    SetWellenende_Init(oData);
    SetBauform_Init(oData);
    SetAnschlusstechnik_Init(oData);
    SetOptionenLeistungsschild_Init(oData);
    SetOptionenExSchutz_Init(oData);
    SetOptionenGrundierung_Init(oData);
    SetOptionenFremdbelueftung_Init(oData);
    SetOptionenPruefbescheinigungen_Init(oData);
    SetOptionenGebersystem_Init(oData);
    SetOptionenWellenende_Init(oData);
    SetOptionenSchmierung_Init(oData);
    SetOptionenSonstiges_Init(oData);

    SetFREETEXTS(oData);

    /*} catch(errorMessage){
            addToErrors(errorMessage);
        }*/
  } else {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oData.strError));
    return oData.strError;
  }
  return "";
}

function addToErrors(/**String*/ errorMessage) {
  ECL_SelectValue("ECSI_STATUS", "E");
  ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_GetValue("ECSI_STATUS_MESSAGE") + errorMessage);
}

function fSwitchProduct(HMK_PRODUKT_TRIG_1PH8) {
  switch (HMK_PRODUKT_TRIG_1PH8) {
    case "1PH8_S":
      ECL_DeactivateAttribute("O_G80_H56_H75_1PH8"); // Anbau Gebersystem										* nur fr AH 280 mglich
      ECL_DeactivateAttribute("CB_O_L00_1PH8"); // Austausch Klemmenkasten durch den nchst Greren 		* nur fr AH 180, 225, 280 mglich
      ECL_DeactivateAttribute("O_K40_1PH8"); // Nachschmiereinrichtung
      ECL_DeactivateAttribute("CB_O_Q00_1PH8"); // Erhhte Anzahl von Erdungsklemmen im Klemmenkasten
      ECL_DeactivateAttribute("CB_O_L02_1PH8"); // Schraubensicherung mit Loctite und verstrkte Lfterausfhrung	* nur DI und AH280

      ECL_ActivateAttribute("CB_O_A72_1002197"); // 2 Widerstandsthermometer PT1000 zur Wlzlagertemperaturberwachung (DE und NDE)
      ECL_ActivateAttribute("O_G00_B_G11_1PH8"); // Lage des Fremdlfters
      ECL_ActivateAttribute("CB_O_G50_1PH8"); // Messnippel fr SPM, mit M8-Adapter

      ECL_ActivateAttribute("CB_O_K16_1PH8"); // Zweites Wellenende
      ECL_ActivateAttribute("CB_O_K17_1002197"); // Labyrinthdichtung DE fr Performance-Ausfhrung

      ECL_ActivateAttribute("CB_O_K45_1PH8"); // Stillstandsheizung AC 230 V

      ECL_ActivateAttribute("O_K83_K84_K85_1PH8"); // Drehen des Klemmenkastens
      ECL_ActivateAttribute("CB_O_K90_1PH8"); // Ausfhrung mit Flanschgre A400

      ECL_ActivateAttribute("CB_O_L03_1PH8"); // Erhhte Rttelbeanspruchung
      ECL_ActivateAttribute("CB_O_L12_1PH8"); // Kondenswasserbohrung
      ECL_ActivateAttribute("CB_O_L27_1PH8"); // NDE-Lager in isolierter Ausfhrung
      ECL_ActivateAttribute("CB_O_L72_1002197"); // Welle aus Sonderstahl
      ECL_ActivateAttribute("CB_O_L74_1PH8"); // Lfterausfhrung in Schutzart IP65
      ECL_ActivateAttribute("CB_O_L75_1PH8"); // Sonderlfter 3 AC 400 V in Schutzart IP65
      ECL_ActivateAttribute("CB_O_L76_1PH8"); // EC-Lfter 3 AC 400 V 50/60 Hz
      ECL_ActivateAttribute("O_M03_M39_1PH8"); // Ausfhrung fr explosionsgefhrdete Bereiche
      ECL_ActivateAttribute("CB_O_M83_1PH8"); // Zustzliche Abdrckgewinde an Motorfen

      ECL_ActivateAttribute("O_P00_BIS_P06_1PH8"); // Leitungseinfhrungsplatte

      // Update 11/2024: nur Direkteingabe: ECL_ActivateAttribute("CB_O_Q14_1PH8"); // Filter fr Sonderlfter
      ECL_ActivateAttribute("CB_O_Q25_1PH8"); // Lfteranschluss NDE / oben (M16 x 1,5)
      ECL_ActivateAttribute("CB_O_Y64_1PH8"); // Vorbereitung fr lagerlosen Drehverteiler
      ECL_ActivateAttribute("O_V90_V91_V92_1PH8"); // kompatible Wellenenden
      break;

    case "1PH8_LEA":
      ECL_DeactivateAttribute("CB_O_A72_1002197"); // 2 Widerstandsthermometer PT1000 zur Wlzlagertemperaturberwachung (DE und NDE)
      ECL_DeactivateAttribute("O_G00_B_G11_1PH8"); // Lage des Fremdlfters
      ECL_DeactivateAttribute("CB_O_G50_1PH8"); // Messnippel fr SPM, mit M8-Adapter
      ECL_DeactivateAttribute("O_G80_H56_H75_1PH8"); // Anbau Gebersystem
      ECL_DeactivateAttribute("CB_O_K16_1PH8"); // Zweites Wellenende
      ECL_DeactivateAttribute("CB_O_K17_1002197"); // Labyrinthdichtung DE fr Performance-Ausfhrung
      ECL_DeactivateAttribute("O_K40_1PH8"); // Nachschmiereinrichtung
      ECL_DeactivateAttribute("CB_O_K45_1PH8"); // Stillstandsheizung AC 230 V

      ECL_DeactivateAttribute("O_K83_K84_K85_1PH8"); // Drehen des Klemmenkastens
      ECL_DeactivateAttribute("CB_O_K90_1PH8"); // Ausfhrung mit Flanschgre A400
      ECL_DeactivateAttribute("CB_O_L00_1PH8"); // Austausch Klemmenkasten durch den nchst Greren
      ECL_DeactivateAttribute("CB_O_L02_1PH8"); // Schraubensicherung mit Loctite und verstrkte Lfterausfhrung
      ECL_DeactivateAttribute("CB_O_L03_1PH8"); // Erhhte Rttelbeanspruchung
      ECL_DeactivateAttribute("CB_O_L12_1PH8"); // Kondenswasserbohrung
      ECL_DeactivateAttribute("CB_O_L27_1PH8"); // NDE-Lager in isolierter Ausfhrung
      ECL_DeactivateAttribute("CB_O_L72_1002197"); // Welle aus Sonderstahl
      ECL_DeactivateAttribute("CB_O_L74_1PH8"); // Lfterausfhrung in Schutzart IP65
      ECL_DeactivateAttribute("CB_O_L75_1PH8"); // Sonderlfter 3 AC 400 V in Schutzart IP65
      ECL_DeactivateAttribute("CB_O_L76_1PH8"); // EC-Lfter 3 AC 400 V 50/60 Hz
      ECL_DeactivateAttribute("O_M03_M39_1PH8"); // Ausfhrung fr explosionsgefhrdete Bereiche
      ECL_DeactivateAttribute("CB_O_M83_1PH8"); // Zustzliche Abdrckgewinde an Motorfen

      ECL_DeactivateAttribute("O_P00_BIS_P06_1PH8"); // Leitungseinfhrungsplatte
      ECL_DeactivateAttribute("CB_O_Q00_1PH8"); // Erhhte Anzahl von Erdungsklemmen im Klemmenkasten
      ECL_DeactivateAttribute("CB_O_Q14_1PH8"); // Filter fr Sonderlfter
      ECL_DeactivateAttribute("CB_O_Q25_1PH8"); // Lfteranschluss NDE / oben (M16 x 1,5)
      ECL_DeactivateAttribute("CB_O_Y64_1PH8"); // Vorbereitung fr lagerlosen Drehverteiler
      ECL_DeactivateAttribute("O_V90_V91_V92_1PH8"); // kompatible Wellenenden
      break;

    case "1PH8_L":
      ECL_ActivateAttribute("CB_O_A72_1002197"); // 2 Widerstandsthermometer PT1000 zur Wlzlagertemperaturberwachung (DE und NDE)
      ECL_ActivateAttribute("O_G00_B_G11_1PH8"); // Lage des Fremdlfters
      ECL_ActivateAttribute("CB_O_G50_1PH8"); // Messnippel fr SPM, mit M8-Adapter
      ECL_ActivateAttribute("O_G80_H56_H75_1PH8"); // Anbau Gebersystem
      ECL_ActivateAttribute("CB_O_K16_1PH8"); // Zweites Wellenende
      ECL_ActivateAttribute("CB_O_K17_1002197"); // Labyrinthdichtung DE fr Performance-Ausfhrung
      ECL_ActivateAttribute("O_K40_1PH8"); // Nachschmiereinrichtung
      ECL_ActivateAttribute("CB_O_K45_1PH8"); // Stillstandsheizung AC 230 V

      ECL_ActivateAttribute("O_K83_K84_K85_1PH8"); // Drehen des Klemmenkastens
      ECL_ActivateAttribute("CB_O_K90_1PH8"); // Ausfhrung mit Flanschgre A400
      ECL_ActivateAttribute("CB_O_L00_1PH8"); // Austausch Klemmenkasten durch den nchst Greren
      ECL_ActivateAttribute("CB_O_L03_1PH8"); // Erhhte Rttelbeanspruchung
      ECL_ActivateAttribute("CB_O_L12_1PH8"); // Kondenswasserbohrung
      ECL_ActivateAttribute("CB_O_L27_1PH8"); // NDE-Lager in isolierter Ausfhrung
      ECL_ActivateAttribute("CB_O_L72_1002197"); // Welle aus Sonderstahl
      ECL_ActivateAttribute("CB_O_L74_1PH8"); // Lfterausfhrung in Schutzart IP65
      // Update 06/2024: nur Direkteingabe: ECL_ActivateAttribute("CB_O_L75_1PH8"); // Sonderlfter 3 AC 400 V in Schutzart IP65
      ECL_ActivateAttribute("CB_O_L76_1PH8"); // EC-Lfter 3 AC 400 V 50/60 Hz
      ECL_ActivateAttribute("O_M03_M39_1PH8"); // Ausfhrung fr explosionsgefhrdete Bereiche
      ECL_ActivateAttribute("CB_O_M83_1PH8"); // Zustzliche Abdrckgewinde an Motorfen

      // L02 nur bei DI und AH 280, da immer konfig, nicht mehr relevant!
      ECL_DeactivateAttribute("CB_O_L02_1PH8"); // Schraubensicherung mit Loctite und verstrkte Lfterausfhrung

      ECL_ActivateAttribute("O_P00_BIS_P06_1PH8"); // Leitungseinfhrungsplatte
      ECL_ActivateAttribute("CB_O_Q00_1PH8"); // Erhhte Anzahl von Erdungsklemmen im Klemmenkasten
      // Update 11/2024: nur Direkteingabe: ECL_ActivateAttribute("CB_O_Q14_1PH8"); // Filter fr Sonderlfter
      ECL_ActivateAttribute("CB_O_Q25_1PH8"); // Lfteranschluss NDE / oben (M16 x 1,5)
      ECL_ActivateAttribute("CB_O_Y64_1PH8"); // Vorbereitung fr lagerlosen Drehverteiler
      ECL_ActivateAttribute("O_V90_V91_V92_1PH8"); // kompatible Wellenenden
      break;
  }

  return 0;
}
