//@legacy
//#mode(full-ecma)

//@import "2KJ_CONFIG/VT_TF.js"

//@import "2KJ_CONFIG/CFG_2KJ_VORAUSWAHL.js"

//@import "2KJ_CONFIG/CFG_2KJ_BAUFORM.js"

//@import "2KJ_CONFIG/CFG_2KJ_BEFESTIGUNG.js"

//@import "2KJ_CONFIG/CFG_2KJ_GETRIEBE_OPTIONEN.js"

//@import "2KJ_CONFIG/CFG_2KJ_ADAPTER.js"

//@import "2KJ_CONFIG/CFG_2KJ_ELEKTRISCHE_AUSFUEHRUNG.js"

//@import "2KJ_CONFIG/CFG_2KJ_MECHANISCHE_AUSFUEHRUNG.js"

//@import "2KJ_CONFIG/CFG_2KJ_GEBER.js"

//@import "2KJ_CONFIG/CFG_2KJ_BREMSE.js"

//@import "2KJ_CONFIG/CFG_2KJ_MOTOR_ZUSATZOPTIONEN.js"

//@import "2KJ_CONFIG/CFG_2KJ_KONSERVIERUNG.js"

//@import "2KJ_CONFIG/CFG_2KJ_DOKUMENTATION.js"

//@import "2KJ_CONFIG/CFG_2KJ_SPEZIFIKATION.js"

//@import "2KJ_CONFIG/CFG_2KJ_DRIVETRAIN.js"


//@import "2KJ_MLFB/MLFB.MOTOX.construct.js"

//@import "2KJ_PARSER/Parser.MOTOX.parse.js"

//@import "2KJ_PARSER/Parser.common.js"

//@import "2KJ_PARSER/Parser.tokenizer.js"

//@import "2KJ_CONFIG/CFG_2KJ_CHECKS_DEFAULTS.js"


/*
#include "CfgTableData_inc.es"
#include "2KJ_CONFIG/CfgTables2KJ.ecl"
#include "CfgBlackboard.es"
*/

//@import "SIZER_general_functions.js"

globalThis.OnChangeConfiguration = function main()
{
    var strchangedAttribute = ECL_GetCurrentAttribute();
    logtraceln("Changed Attribute="+strchangedAttribute);


    if(strchangedAttribute.left(7) == "ECSI_CX")
        return;
    
    var vtTimeConfigStart	= Date.getTime();
    
    var bSizerMode = true;                  //wird auf true gesetzt, da man immer in sizermodus ist
    ECL_SetValue ("ECSI_2KJ_MODE", "SIZER_CONFIG");
    logtraceln("MODE="+ECL_GetValue ("ECSI_2KJ_MODE"));
    
    ECL_DisableAttribute("ECSI_TYPBEZEICHNUNG");
    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");
    
    var oDataGear = {};
    oDataGear.oInfo = {};
    oDataGear.oRow = {};
    
    var oDataBremse = {};
    oDataBremse.oInfo = {};
    oDataBremse.oRow = {};
    
    //Initialisierung
    if(ECL_GetCurrentAttribute() == "@INIT@")
    {
        ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
        
        /* wird nicht mehr gebraucht
        ECL_ExpandAttributeGroup("CFG_GROUP___VORAUSWAHL");
        ECL_ExpandAttributeGroup("CFG_GROUP___SUCHE");
        ECL_ExpandAttributeGroup("CFG_GROUP___DRIVETRAIN");
        ECL_ExpandAttributeGroup("CFG_GROUP___BAUFORM");
        ECL_ExpandAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
        ECL_ExpandAttributeGroup("CFG_GROUP___BEFESTIGUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
        ECL_ExpandAttributeGroup("CFG_GROUP___ADAPTER");
        ECL_ExpandAttributeGroup("CFG_GROUP___SPEZIFIKATION");
        ECL_ExpandAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE");
        ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2");
        ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE_SIZER");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEBER");
        ECL_ExpandAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
        ECL_ExpandAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
        ECL_ExpandAttributeGroup("CFG_GROUP___KONSERVIERUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
        ECL_ExpandAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___DOKUMENTATION");
        ECL_ExpandAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
        */
        
        ECL_DeactivateAttributeGroup("CFG_GROUP___DRIVETRAIN");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ADAPTER");
        ECL_DeactivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE_SIZER");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEBER");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
        ECL_DeactivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
        ECL_DeactivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
        ECL_DeactivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
        
        ECL_DeactivateAttribute("MIT_BREMSE");
        ECL_DeactivateAttribute("MIT_GEBER");
        
        //Setzen der Default Werte der Vorauswahl
        if(ECL_GetValue ("ECSI_2KJ_MODE") != "SIZER_CONFIG")
            SetVorauswahl_Init();
    }
    
    //Verschaltung Suche nach Abtriebsmoment oder Motorleistung
    if(ECL_GetValue ("ECSI_VORAUSWAHL") == "auswahl_motorleistung")
    {
        ECL_DisableAttribute ("ECSI_ABTRIEBSMOMENT_VON");
        ECL_DisableAttribute ("ECSI_ABTRIEBSMOMENT_BIS");
        
        ECL_DeactivateAttribute ("ECSI_CONTAINER_ABTRIEBSMOMENT");
        ECL_ActivateAttribute ("ECSI_CONTAINER_MOTORLEISTUNG");
        
        ECL_EnableAttribute ("ECSI_MOTORLEISTUNG_VON");
        ECL_EnableAttribute ("ECSI_MOTORLEISTUNG_BIS");
    
    }
    else
    {
        ECL_DisableAttribute ("ECSI_MOTORLEISTUNG_VON");
        ECL_DisableAttribute ("ECSI_MOTORLEISTUNG_BIS");
        
        ECL_ActivateAttribute ("ECSI_CONTAINER_ABTRIEBSMOMENT");
        ECL_DeactivateAttribute ("ECSI_CONTAINER_MOTORLEISTUNG");
        
        ECL_EnableAttribute ("ECSI_ABTRIEBSMOMENT_VON");
        ECL_EnableAttribute ("ECSI_ABTRIEBSMOMENT_BIS");
    
    }
    
    if(strchangedAttribute == "ECSI_MLFB")
    {
        
        //alle Daten aus dem SIZER werden in ein Attribut als JSON geladen und dann wieder in einzelne Attribute umgesetzt
        ///
        if(bSizerMode){
            SetAttributesFromMlfb();
        }
        //Adapter
        //2KJ3203.DA04..G1  //D39-K4-80
        //2KJ3107.FA01..X1 // KS
        //2KJ3408.HA02..H1 //K2-132
        //2KJ3401-5AA01-0DH1-Z D01 +K08 +L02 +L75 +Y00 {Y00:*ANL@2.0**AND@1200*}
        //2KJ3101.CA01..B1
        
        //Direktanbau
        //2KJ3102.BC222.B1
        //2KJ31021BC222AB1-Z D01+K01+K06+L00+M55+N33+P91
        //2KJ3103.GJ234.B1
        //2KJ31031DF239AB1-Z D01+E21+K01+K06+L00+M55+N3C+P91
        //2KJ3103.DF239.B1 N3C
        //2KJ31031DF239AB1-Z D01+K01+K06+L00+M55+N13+N27+N3C+P91
        //2KJ31031DF239AB1-Z D01+K01+K06+L00+M55+N13+N27+N30+N3C+N67+P91
        //2KJ3103.BB219.L1 N1R
		//2KJ3502.BB219.N1 N1R
	
		//Weltmotor
		//2KJ3102.CE136.B1
        //2KJ3105.HJ136.C1

        //2KJ3211-1HJ13-7AD1-Z B22+C02+C09+C26+C66+C80+D01+K01+K06+K41+L02+L75+M60+Q23+Q95
        //2KJ3211.HJ137.D1
        
        //2KJ3642.CE234.U1

        //VSD
        //2KJ3101.DD279.A1-Z N3C
        //2KJ3101.DD279.A1-Z N1N
        
        //ATEX
        // 2KJ3102.DC739.A1-Z N1C+P94+K72
        // 2KJ3104.GJ739.A1-Z N1C+P94
        
        
        // 2KJ3111.JR239.B1-Z N3A
        
        // 2KJ31031EA020AC1-Z D05+E32+K06+L00
        // 2KJ3103.EA02..C1
        
        //2KJ3730.BD222.K1 87Hz Schnecke IE2
	    //2KJ3731.CC234.K1 //IE3
		
		//2KJ31021DC739AA1-Z D01+K01+K06+K72+K77+K82+L00+M10+M39+M55+N1C+P94
		//2KJ3102.DC739.A1-Z N1C P94 K72
		
        //2KJ31011BC222AB1-Z D01+G25+K01+K13+L02+L75+M55+P91+Q82
		//2KJ3101.BC222.B1

        //2KJ33031BC224AE1-Z D01+K01+K06+L02+L75+M55+P91
		//2KJ3303.BC224.E1
		
		//Doppelgetriebe
		//2KJ32351BB214AC1-Z D01+K01+K06+L02+L75+M55+P91
		//2KJ3235.BB214.C1

        //2KJ34059FN234HA1-Z B10+C02+C06+C26+C53+D03+H5A+K01+K06+K68+L02+L55+M10+M64+N06+P91
		//2KJ3405.FN234.A1

        //2KJ3511-9JU23-9CH1-Z B28+C47+D11+G23+H3A+K01+K07+K41+L03+L75+M10+M64+N30+N38+N3A+N54+N67+P91+Q59+Q95
		//2KJ3511.JU239.H1 -Z N3A+N38
				
		// 2KJ3502.BB219.N1 N1R
		// 2KJ35021BB219AN1-Z D11+E24+K01+K07+L00+M55+N1R+P91
		
		// 2KJ3502.BB219.N1 -Z N1R
		// 2KJ35021BB219AN1-Z D09+D14+G24+G34+G97+K03+K07+K19+L00+M10+M21+M40+M65+N1R+N23+N41+P91+W13+W22+Y00 {Y00:*LSF@tst Z](_\'"*}
		
		//2KJ3235.DA02..C1

        // 2KJ3512-9JU23-9AQ1-Z B38+C02+C09+C27+C64+D11+H5A+K01+K06+K41+L02+L75+M02+M10+M21+M56+N09+N38+N39+N3A+P91
		// 2KJ3512.JU239.Q1 -Z N38+N3A
		
		// Doppelgetriebe mit Adapter
		// 2KJ3235-1GA02-0AD1-Z K06+L02+L75
		//	2KJ3235.GA020.D1
        
        // Doppelgetriebe ATEX
		// 2KJ3235.DC734.H1 P94 K72
		
		// 2KJ3511.DC734.V1 P94 K72

        // 2KJ3308.CA08..H1 //K8-

        // 2KJ3515-1NM13-7AJ1-Z B62+C45+D24+K01+K06+L02+L75+M55
        // 2KJ3515.NM137.J1

        // 2KJ3211-9HJ13-7AD1-Z B22+C02+C09+C26+C66+C80+D01+H1G+K01+K06+K41+L02+L75+M60+Q23+Q95
        // 2KJ3211.HJ137.D1

        // 2KJ3104.GJ739.A1-Z N1C+P94

        //2KJ3512.HJ239.V1 N38 N3A

        //2KJ3106-1HJ23-9AG1-Z D01+K01+K06+L02+L75+M55+N04+N3A+P91
        //2KJ3106.HJ239.G1 N3A

        //2KJ37311CC232AE1-Z D11+K01+K08+L00+M10+M55+P91+Q60
        //2KJ3731.CC232.E1

        //KU Adapter
        //2KJ3107.GA09..F1
        
        //2KJ31021BA090AA1-Z A30+A36+D01+K06+L00+M2A
        //2KJ3102.BA09..A1

        //2KJ3404.DC239.L1 N3C

        //2KJ3108.HJ239.Q1 N3C

        //2KJ34045CE239DL1-Z B57+C47+C60+D03+K01+K06+L02+L75+M67+N3C+N67+P91

        //2KJ31021DC234AT1-Z B57+C53+C80+D01+K01+K06+K41+L02+L75+M10+M23+M58+N06+N53+P91+Q48
        //2KJ3102.DC234.T1
        
        var strMLFB_for_Parser = ECL_GetValue("ECSI_MLFB");
        if(strMLFB_for_Parser != "")
        {	
            ECL_DeactivateAttributeGroup("CFG_GROUP___VORAUSWAHL");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SUCHE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___DRIVETRAIN");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ADAPTER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE_SIZER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEBER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
            ECL_DeactivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
            
            ECL_DeactivateAttribute("MIT_BREMSE");
            ECL_DeactivateAttribute("MIT_GEBER");
            
            //OriginalMLFB speichern
            //ECL_SetValue("ECSI_MLFB_ORIG", ECL_GETValue("ECSI_MLFB"));         
            var oParse = parse_init(strMLFB_for_Parser , "", true );

            if(oParse.strError == "")
            {
    
                ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "true");
                
                var bRet = parseSetValues(oParse, true);
                
                oDataGear.oRow = bRet.GearData.oRow;
                oDataBremse.oRow = bRet.BrakeData.oRow;

                setDefaultValues(oDataGear);

                var strRetContextValue="";
                if(find(strMLFB_for_Parser.left(16),".") >= 0)
                {
                    var strRetContextValue=checkContextValues(oDataGear, false);
                }
                else
                {
                    var strRetContextValue=checkContextValues(oDataGear, true);
                }
            
                if(strRetContextValue!="")
                {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(strRetContextValue));
                }
                else
                {
                
                    //Bei erfolgter Suche werden die Optionen aufgerufen
                    //Hier erst die Initialisierung

                    _2KJ3_config_Init(strchangedAttribute, oDataGear, oDataBremse);

                    //MLFB bestimmen
                    var oMLFB = buildFormattedMLFB( oDataGear, true);

                    checkMLFBandConfiguration(oMLFB);

                    //MLFB generieren
                    var strMLFB="";
                    if(oMLFB.strFormattedShortDescriptions!="")
                        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
                    else
                        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");
                    
                    ECL_SetValue("ECSI_MLFB",strMLFB);
                    logtraceln("MLFB="+strMLFB);
                    
                    var JSON_oDataGear = JSON.stringify(oDataGear);
                    ECL_SetValue("ECSI_GEARDATA",JSON_oDataGear);
                    
                    var JSON_oDataBremse = JSON.stringify(oDataBremse);
                    ECL_SetValue("ECSI_BRAKEDATA",JSON_oDataBremse);
                    
                    checkMLFBforWarningMessage(oMLFB.strBaseMLFB);
                    
                }
            }
            else
            {
                ECL_SelectValue ("ECSI_STATUS", "E");
                ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(oParse.strError));
            }
        }
        else if(strMLFB_for_Parser != "" && ECL_GetValue ("ECSI_STATUS_MESSAGE") == "")
        {	
            ECL_DeactivateAttributeGroup("CFG_GROUP___VORAUSWAHL");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SUCHE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___DRIVETRAIN");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ADAPTER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE_SIZER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEBER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
            ECL_DeactivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
            
            ECL_DeactivateAttribute("MIT_BREMSE");
            ECL_DeactivateAttribute("MIT_GEBER");
                    
            var JSON_oDataGear = ECL_GetValue ("ECSI_GEARDATA");
            var JSON_oDataBremse = ECL_GetValue ("ECSI_BRAKEDATA");
            
            if(JSON_oDataGear)
            {
                oDataGear = JSON.parse(JSON_oDataGear);
                oDataBremse = JSON.parse(JSON_oDataBremse);
            }
            else
            {
                var strMLFB_for_Parser = ECL_GetValue("ECSI_MLFB");
                if(strMLFB_for_Parser != "")
                {	var oParse = parse_init(strMLFB_for_Parser , "", true );
                    var bRet = parseSetValues(oParse, false);
                    
                    if(oParse.strError == "")
                    {
                        ECL_SelectValue ("ECSI_STATUS", "OK");
                    }
                    else
                    {
                        ECL_SelectValue ("ECSI_STATUS", "E");
                        ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(oParse.strError));
                    }
            
                    oDataGear.oRow = bRet.GearData.oRow;
                    oDataBremse.oRow = bRet.BrakeData.oRow;
                }
            }
            
            _2KJ3_config_Init(strchangedAttribute, oDataGear, oDataBremse);
            
            //MLFB bestimmen
            var oMLFB = buildFormattedMLFB( oDataGear, true);
            
            checkMLFBandConfiguration(oMLFB);
            
            //MLFB generieren
            var strMLFB="";
            if(oMLFB.strFormattedShortDescriptions!="")
                strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
            else
                strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");
                
            ECL_SetValue("ECSI_MLFB",strMLFB);
            logtraceln("MLFB="+strMLFB);
            
            var JSON_oDataGear = JSON.stringify(oDataGear);
            ECL_SetValue("ECSI_GEARDATA",JSON_oDataGear);
            
            var JSON_oDataBremse = JSON.stringify(oDataBremse);
            ECL_SetValue("ECSI_BRAKEDATA",JSON_oDataBremse);
            
            checkMLFBforWarningMessage(oMLFB.strBaseMLFB);
        }
        else
        {
            //nothing to do here 

            ECL_DeactivateAttributeGroup("CFG_GROUP___VORAUSWAHL");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SUCHE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE");
            
            var JSON_oDataGear = ECL_GetValue ("ECSI_GEARDATA");
            var JSON_oDataBremse = ECL_GetValue ("ECSI_BRAKEDATA");
            
            if(JSON_oDataGear)
            {
                oDataGear = JSON.parse(JSON_oDataGear);
                oDataBremse = JSON.parse(JSON_oDataBremse);
            
            
                if(ECL_ValueSelected("MIT_BREMSE", "T"))
                {		
                    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
                    {
                        ECL_ActivateAttribute("BREMSENTYP");
                        ECL_ActivateAttribute("BREMSE_SAFETY");
                        //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht mehr gebraucht
                    }
                }
                
                if(ECL_ValueSelected("MIT_GEBER", "T"))
                {
                    ECL_ActivateAttribute("GEBER_AUSFUEHRUNG");
                    ECL_ActivateAttribute("GEBER_FUNKT_SICHERHEIT");
                    ECL_ActivateAttribute("GEBER_IMPULSZAHL");
                    ECL_ActivateAttribute("GEBER_ELEKTRONIK");
                    ECL_ActivateAttribute("GEBER_EINGANGSFREQUENZ");
                    ECL_ActivateAttribute("GEBER_AUSGANGSSIGNALE");
                    ECL_ActivateAttribute("GEBER_MECH_VAR");
                    ECL_ActivateAttribute("GEBER_DIREKTAUSWAHL");
                    ECL_ActivateAttribute("GEBER_TECHNISCHEAUSWAHL");
                    ECL_ActivateAttribute("GEBER_MECHSCHUTZ");
                    ECL_ActivateAttribute("GEBER_ZUB_KABEL");
                    ECL_ActivateAttribute("GEBER_ZUB_GATEWAYS");
                }
                
                var JSON_oDataGear = JSON.stringify(oDataGear);
                ECL_SetValue("ECSI_GEARDATA",JSON_oDataGear);
                
                var JSON_oDataBremse = JSON.stringify(oDataBremse);
                ECL_SetValue("ECSI_BRAKEDATA",JSON_oDataBremse);
            }
        
        }
        
    }
    
    if(strchangedAttribute != "ECSI_MLFB" && ECL_GetValue ("ECSI_2KJ_MODE") != "SIZER_CONFIG")
    {
        SetVorauswahl(strchangedAttribute);
    }
    
    //ECSI_CFG_INIT_OPTIONS = false means, the INIT Process must be run
    if( (ECL_GetValue ("ECSI_CFG_INIT_OPTIONS") == "false" || strchangedAttribute=="ECSI_TABLE_SEARCH") && ECL_GetValue ("ECSI_2KJ_MODE") != "SIZER_CONFIG")
    {
        ECL_SetValue("ECSI_MLFB","");
        ECL_SetValue ("ECSI_2KJ_MODE", "EASYKAT_CONFIG");
        
        ECL_DeactivateAttributeGroup("CFG_GROUP___DRIVETRAIN");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ADAPTER");
        ECL_DeactivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE_SIZER");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEBER");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
        ECL_DeactivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
        ECL_DeactivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
        ECL_DeactivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
        
        ECL_DeactivateAttribute("MIT_BREMSE");
        ECL_DeactivateAttribute("MIT_GEBER");
        
        ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "true");
        /* könnte wegen der cfgTable gelöscht werden
        var sCurrentCfgObject        = ECL_GetCurrentCfgObject();
        
        EKCfgTable.initCfgTable(sCurrentCfgObject, "ECSI_TABLE_SEARCH", oCfgTables2KJ);
        EKCfgTable.refreshTable("ECSI_TABLE_SEARCH");
        
        
        var aResult        = EKCfgTable.getAllSelectedRows(sCurrentCfgObject,"ECSI_TABLE_SEARCH");
        
        // Gearbox has been selected
        if (aResult.length > 0){
            var sSelected   =  aResult[0];

            var sContext				= _oBBHandler.getAttributeCFGContext("ECSI_TABLE_SEARCH");
            var oBBTable				= _oBBHandler.getCfgTable(sContext);
            oDataGear = oBBTable.getTableRowObjByIdent(sSelected);
            
            //Bei erfolgter Suche werden die Optionen aufgerufen
            //Hier erst die Initialisierung
            
            _2KJ3_config_Init(strchangedAttribute, oDataGear, oDataBremse);
        
            //MLFB bestimmen
            var oMLFB = buildFormattedMLFB( oDataGear, true);
            
            checkMLFBandConfiguration(oMLFB);
            
            //MLFB generieren
            var strMLFB="";
            if(oMLFB.strFormattedShortDescriptions!="")
                strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
            else
                strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");
        
            ECL_SetValue("ECSI_MLFB",strMLFB);
            
            logtraceln("MLFB="+strMLFB);
            
            var JSON_oDataGear = JSON.stringify(oDataGear);
            ECL_SetValue("ECSI_GEARDATA",JSON_oDataGear);
            
            var JSON_oDataBremse = JSON.stringify(oDataBremse);
            ECL_SetValue("ECSI_BRAKEDATA",JSON_oDataBremse);
            
            checkMLFBforWarningMessage(oMLFB.strBaseMLFB);
        }*/
    }
    else if(strchangedAttribute != "ECSI_MLFB" && ECL_GetValue ("ECSI_CFG_INIT_OPTIONS") == "true")
    {
        if(ECL_GetValue ("ECSI_2KJ_MODE") == "EASYKAT_CONFIG")
        {
            ECL_DeactivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
            
            var JSON_oDataGear = ECL_GetValue ("ECSI_GEARDATA");
            var JSON_oDataBremse = ECL_GetValue ("ECSI_BRAKEDATA");
            
            
            if(JSON_oDataGear)
            {
                oDataGear = JSON.parse(JSON_oDataGear);
                oDataBremse = JSON.parse(JSON_oDataBremse);
                
                _2KJ3_config(strchangedAttribute, oDataGear, oDataBremse);
            }
            /*Könnte wegen cfgTable gelöscht werden
            else
            {
                
                sCurrentCfgObject        = ECL_GetCurrentCfgObject();

                EKCfgTable.initCfgTable(sCurrentCfgObject, "ECSI_TABLE_SEARCH", oCfgTables2KJ);
                EKCfgTable.refreshTable("ECSI_TABLE_SEARCH");
                
                var aResult        = EKCfgTable.getAllSelectedRows(sCurrentCfgObject,"ECSI_TABLE_SEARCH");
                
                // Gearbox has been selected
                if (aResult.length > 0)
                {
                    var sSelected   =  aResult[0];

                    var sContext				= _oBBHandler.getAttributeCFGContext("ECSI_TABLE_SEARCH");
                    var oBBTable				= _oBBHandler.getCfgTable(sContext);
                    oDataGear = oBBTable.getTableRowObjByIdent(sSelected);
                    
                    _2KJ3_config(strchangedAttribute, oDataGear, oDataBremse);
                }
            }
            */
        }
        else if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        {
            //ECL_CollapseAttributeGroup("CFG_GROUP___VORAUSWAHL"); wird nicht mehr benötigt
            //ECL_CollapseAttributeGroup("CFG_GROUP___SUCHE");      wird nicht mehr benötigt
            ECL_DeactivateAttributeGroup("CFG_GROUP___VORAUSWAHL");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SUCHE");
            
            var JSON_oDataGear = ECL_GetValue ("ECSI_GEARDATA");
            var JSON_oDataBremse = ECL_GetValue ("ECSI_BRAKEDATA");
            
            if(JSON_oDataGear)
            {
                oDataGear = JSON.parse(JSON_oDataGear);
                oDataBremse = JSON.parse(JSON_oDataBremse);
            }
            else
            {
                var strMLFB_for_Parser = ECL_GetValue("ECSI_MLFB");
                if(strMLFB_for_Parser != "")
                {	var oParse = parse_init(strMLFB_for_Parser , "", true );
                    var bRet = parseSetValues(oParse, false);
                    
                    if(oParse.strError == "")
                    {
                        ECL_SelectValue ("ECSI_STATUS", "OK");
                    }
                    else
                    {
                        ECL_SelectValue ("ECSI_STATUS", "E");
                        ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(oParse.strError));
                    }
            
                    oDataGear.oRow = bRet.GearData.oRow;
                    oDataBremse.oRow = bRet.BrakeData.oRow;
                }
            }
            
            _2KJ3_config(strchangedAttribute, oDataGear, oDataBremse);
        }
    }

    var vtTimeConfigStop	= Date.getTime();
    var vtConfigTime		= (vtTimeConfigStop - vtTimeConfigStart) / 1000;
    logtraceln("******* Configuration - Time: "+vtConfigTime+" sec"+"\n");
    
    logtraceln("ERROR:"+ECL_GetValue ("ECSI_STATUS_MESSAGE"));
}

function _2KJ3_config(strchangedAttribute, oDataGear, oDataBremse)
{
    
    SetDrivetrain(strchangedAttribute,oDataGear);
    SetBauform(strchangedAttribute,oDataGear);
    SetBefestigung(strchangedAttribute,oDataGear);
    SetGetriebeOptionen(strchangedAttribute,oDataGear);
    
    if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBEMOTOR")
    {
        setSpezifikation_SIZER(strchangedAttribute,oDataGear);
        SetElektrischeAusfuehrung(strchangedAttribute,oDataGear);
        SetMechanischeAusfuehrung(strchangedAttribute,oDataGear,oDataBremse);
        
        if(ECL_ValueSelected("MIT_BREMSE", "T") && (strchangedAttribute == "ECSI_TABLE_BREMSE" || strchangedAttribute == "BREMSENTYP"))
        {
           /*Kann wegen cfgTable gelöscht werden

            if(ECL_GetValue ("ECSI_2KJ_MODE") == "EASYKAT_CONFIG")
            {
                sCurrentCfgObject        = ECL_GetCurrentCfgObject();
                EKCfgTable.initCfgTable(sCurrentCfgObject, "ECSI_TABLE_BREMSE", oCfgTables2KJ);
                EKCfgTable.refreshTable("ECSI_TABLE_BREMSE");
                
                var aResult_Bremse = EKCfgTable.getAllSelectedRows(sCurrentCfgObject,"ECSI_TABLE_BREMSE");
                if (aResult_Bremse.length > 0){
                    var sSelected   =  aResult_Bremse[0];

                    var sContext				= _oBBHandler.getAttributeCFGContext("ECSI_TABLE_BREMSE");
                    var oBBTable				= _oBBHandler.getCfgTable(sContext);
                    oDataBremse = oBBTable.getTableRowObjByIdent(sSelected);
                    
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                    
                    SetBremse_InitOptions(strchangedAttribute,oDataGear,oDataBremse);
                }
            }
            */
            if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
            {
                ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht mehr gebraucht 
                
                SetBremse_InitOptions(strchangedAttribute,oDataGear,oDataBremse);
            }
        }
        else if(ECL_ValueSelected("MIT_BREMSE", "T"))
        {
            
            if(strchangedAttribute == "MIT_BREMSE")
            {
                /*kann wegen cfgTable gelöscht werden

                if(ECL_GetValue ("ECSI_2KJ_MODE") == "EASYKAT_CONFIG")
                {
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE");
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE");
                    
                    sCurrentCfgObject        = ECL_GetCurrentCfgObject();
                    EKCfgTable.initCfgTable(sCurrentCfgObject, "ECSI_TABLE_BREMSE", oCfgTables2KJ);
                    EKCfgTable.refreshTable("ECSI_TABLE_BREMSE");
                    
                    var aResult_Bremse = EKCfgTable.getAllSelectedRows(sCurrentCfgObject,"ECSI_TABLE_BREMSE");
                    if (aResult_Bremse.length > 0){
                        var sSelected   =  aResult_Bremse[0];

                        var sContext				= _oBBHandler.getAttributeCFGContext("ECSI_TABLE_BREMSE");
                        var oBBTable				= _oBBHandler.getCfgTable(sContext);
                        oDataBremse = oBBTable.getTableRowObjByIdent(sSelected);
                        
                        ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                        ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                        
                        SetBremse_InitOptions(strchangedAttribute,oDataGear,oDataBremse);
                    }
                }*/
                if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
                {
                    ECL_ActivateAttribute("BREMSENTYP");
                    ECL_ActivateAttribute("BREMSE_SAFETY");
                    
                    SetBremse_Init_Sizer(oDataGear,oDataBremse);
                    
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                    //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht mehr gebraucht
                    
                    SetBremse_InitOptions(strchangedAttribute,oDataGear,oDataBremse);
                }
            }
            else
            {
                /*kann wegen cfgTable gelöscht werden

                if(ECL_GetValue ("ECSI_2KJ_MODE") == "EASYKAT_CONFIG")
                {
                    sCurrentCfgObject        = ECL_GetCurrentCfgObject();
                    EKCfgTable.initCfgTable(sCurrentCfgObject, "ECSI_TABLE_BREMSE", oCfgTables2KJ);
                    EKCfgTable.refreshTable("ECSI_TABLE_BREMSE");
                    
                    var aResult_Bremse = EKCfgTable.getAllSelectedRows(sCurrentCfgObject,"ECSI_TABLE_BREMSE");
                    if (aResult_Bremse.length > 0){
                        var sSelected   =  aResult_Bremse[0];

                        var sContext				= _oBBHandler.getAttributeCFGContext("ECSI_TABLE_BREMSE");
                        var oBBTable				= _oBBHandler.getCfgTable(sContext);
                        oDataBremse = oBBTable.getTableRowObjByIdent(sSelected);
                        
                        ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                        ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                        
                        SetBremse(strchangedAttribute,oDataGear,oDataBremse);
                    }
                }*/
                if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
                {
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                    
                    SetBremse(strchangedAttribute,oDataGear,oDataBremse);
                }
            }
        }
        else if(!ECL_ValueSelected("MIT_BREMSE", "T"))
        {
            if(strchangedAttribute=="SCHUTZART")
                SetBremse_Init(strchangedAttribute,oDataGear,oDataBremse);
                
            if( ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED" && (strchangedAttribute == "MOTORSCHUTZ" || strchangedAttribute == "STILLSTANDSHEIZUNG"))
                SetBremse_Init(strchangedAttribute,oDataGear,oDataBremse);
            
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE");
            //ECL_CollapseAttributeGroup("CFG_GROUP___BREMSE"); wird nicht mehr benötigt
    
            ECL_DeactivateAttribute("BREMSENTYP");
            ECL_DeactivateAttribute("BREMSE_SAFETY");
            
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
            //ECL_CollapseAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht mehr benötigt
        }
        
        Bestimme_GEBER_AUSFUEHRUNG(oDataGear);
        if(ECL_ValueSelected("MIT_GEBER", "T"))
        {
            if(strchangedAttribute == "MIT_GEBER")
            {
                ECL_ActivateAttribute("GEBER_AUSFUEHRUNG");
                ECL_ActivateAttribute("GEBER_FUNKT_SICHERHEIT");
                ECL_ActivateAttribute("GEBER_IMPULSZAHL");
                ECL_ActivateAttribute("GEBER_ELEKTRONIK");
                ECL_ActivateAttribute("GEBER_EINGANGSFREQUENZ");
                ECL_ActivateAttribute("GEBER_AUSGANGSSIGNALE");
                ECL_ActivateAttribute("GEBER_MECH_VAR");
                ECL_ActivateAttribute("GEBER_DIREKTAUSWAHL");
                ECL_ActivateAttribute("GEBER_TECHNISCHEAUSWAHL");
                ECL_ActivateAttribute("GEBER_MECHSCHUTZ");
                ECL_ActivateAttribute("GEBER_ZUB_KABEL");
                ECL_ActivateAttribute("GEBER_ZUB_GATEWAYS");
                SetGeber_Init(strchangedAttribute,oDataGear);
            }
            else
                SetGeber(strchangedAttribute,oDataGear);
            
            //weitere Abhängigkeit
            SetElektrischeAusfuehrung(strchangedAttribute,oDataGear);
        }
        else if(!ECL_ValueSelected("MIT_GEBER", "T"))
        {
                ECL_DeactivateAttribute("GEBER_AUSFUEHRUNG");
                ECL_DeactivateAttribute("GEBER_FUNKT_SICHERHEIT");
                ECL_DeactivateAttribute("GEBER_IMPULSZAHL");
                ECL_DeactivateAttribute("GEBER_ELEKTRONIK");
                ECL_DeactivateAttribute("GEBER_EINGANGSFREQUENZ");
                ECL_DeactivateAttribute("GEBER_AUSGANGSSIGNALE");
                ECL_DeactivateAttribute("GEBER_MECH_VAR");
                ECL_DeactivateAttribute("GEBER_DIREKTAUSWAHL");
                ECL_DeactivateAttribute("GEBER_TECHNISCHEAUSWAHL");
                ECL_DeactivateAttribute("GEBER_MECHSCHUTZ");
                ECL_DeactivateAttribute("GEBER_ZUB_KABEL");
                ECL_DeactivateAttribute("GEBER_ZUB_GATEWAYS");
        }
        
        SetMotor_Zusatzoptionen(strchangedAttribute,oDataGear);
    }
    else if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
    {
        SetAdapter_Optionen(strchangedAttribute,oDataGear);
    }

    SetKonservierung(strchangedAttribute,oDataGear);
    SetDokumentation(strchangedAttribute,oDataGear);
    
    // geschweifte Klammer entfernen.
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR"),20));
    
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT"),20));
    
    
    //MLFB bestimmen
    var oMLFB = buildFormattedMLFB( oDataGear, true);
    
    checkMLFBandConfiguration(oMLFB);
    
    //MLFB generieren
    var strMLFB="";
    if(oMLFB.strFormattedShortDescriptions!="")
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
    else
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");
                        
    ECL_SetValue("ECSI_MLFB",strMLFB);
    
    logtraceln("MLFB="+strMLFB);
    
    Bestimme_Consequences_AdditionalInertia(oDataGear,oDataBremse);
    
    if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
    {
        Bestimme_Consequences_AdapterID(oDataGear);
    }
    
    var strGetriebemotorbezeichnung=BestimmeGetriebemotorbezeichnung(oDataGear,oDataBremse);
    logtraceln("Getriebemotor="+strGetriebemotorbezeichnung);
    ECL_SetValue("ECSI_TYPBEZEICHNUNG",strGetriebemotorbezeichnung+", "+oDataGear.oRow.LEISTUNG+" kW");
    ECL_SetValue("ECSI_CC_GearboxShortDescription",strGetriebemotorbezeichnung);
    
    var JSON_oDataGear = JSON.stringify(oDataGear);
    ECL_SetValue("ECSI_GEARDATA",JSON_oDataGear);
    
    var JSON_oDataBremse = JSON.stringify(oDataBremse);
    ECL_SetValue("ECSI_BRAKEDATA",JSON_oDataBremse);
    
    checkMLFBforWarningMessage(oMLFB.strBaseMLFB);
    HandleDefaultValuesHighlights();
}

function _2KJ3_config_Init(strchangedAttribute, oDataGear, oDataBremse)
{
    ECL_ActivateAttributeGroup("CFG_GROUP___DRIVETRAIN");
    ECL_ActivateAttributeGroup("CFG_GROUP___BAUFORM");
    
    ECL_ActivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
    
    ECL_ActivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
    

    if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBEMOTOR")
    {
        if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
            ECL_ActivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
    
        ECL_ActivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
        ECL_ActivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
    
        ECL_ActivateAttribute("MIT_BREMSE");
        ECL_ActivateAttribute("MIT_GEBER");
    }
    else if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
    {
        ECL_ActivateAttributeGroup("CFG_GROUP___ADAPTER");
    }
    
    SetDrivetrain_Init(strchangedAttribute,oDataGear);
    SetBauform_Init(strchangedAttribute,oDataGear);
    SetBefestigung_Init(strchangedAttribute,oDataGear);
    SetGetriebeOptionen_Init(strchangedAttribute,oDataGear);

    if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBEMOTOR")
    {
        setSpezifikation_SIZER(strchangedAttribute,oDataGear);
        SetElektrischeAusfuehrung_Init(strchangedAttribute,oDataGear);
        SetMechanischeAusfuehrung_Init(strchangedAttribute,oDataGear,oDataBremse);
        
        
        SetBremse_Init(strchangedAttribute,oDataGear,oDataBremse);
        ;
        if(ECL_ValueSelected("MIT_BREMSE", "T"))
        {		
            /*
            if(ECL_GetValue ("ECSI_2KJ_MODE") == "EASYKAT_CONFIG")
            {
                ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE");
                ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE");
                
                sCurrentCfgObject        = ECL_GetCurrentCfgObject();
                EKCfgTable.initCfgTable(sCurrentCfgObject, "ECSI_TABLE_BREMSE", oCfgTables2KJ);
                EKCfgTable.refreshTable("ECSI_TABLE_BREMSE");
            }
            */
            if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
            {
                ECL_ActivateAttribute("BREMSENTYP");
                ECL_ActivateAttribute("BREMSE_SAFETY");
                
                SetBremse_Init_Sizer(oDataGear,oDataBremse);
                
                ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht mehr benötigt  
                SetBremse_InitOptions(strchangedAttribute,oDataGear,oDataBremse);
            }
        }
        
        Bestimme_GEBER_AUSFUEHRUNG(oDataGear);
        ;
        if(ECL_ValueSelected("MIT_GEBER", "T"))
        {
            ECL_ActivateAttribute("GEBER_AUSFUEHRUNG");
            ECL_ActivateAttribute("GEBER_FUNKT_SICHERHEIT");
            ECL_ActivateAttribute("GEBER_IMPULSZAHL");
            ECL_ActivateAttribute("GEBER_ELEKTRONIK");
            ECL_ActivateAttribute("GEBER_EINGANGSFREQUENZ");
            ECL_ActivateAttribute("GEBER_AUSGANGSSIGNALE");
            ECL_ActivateAttribute("GEBER_MECH_VAR");
            ECL_ActivateAttribute("GEBER_DIREKTAUSWAHL");
            ECL_ActivateAttribute("GEBER_TECHNISCHEAUSWAHL");
            ECL_ActivateAttribute("GEBER_MECHSCHUTZ");
            ECL_ActivateAttribute("GEBER_ZUB_KABEL");
            ECL_ActivateAttribute("GEBER_ZUB_GATEWAYS");
            SetGeber_Init(strchangedAttribute,oDataGear);
        }
        
    
        ECL_ActivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
        ECL_ActivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
    
        SetMotor_Zusatzoptionen_Init(strchangedAttribute,oDataGear);
       
    }
    
    else if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
    {
        SetAdapter_Optionen_Init(strchangedAttribute,oDataGear);
    }
    
    ECL_ActivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
    ECL_ActivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
    ECL_ActivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
    
    
    SetKonservierung_Init(strchangedAttribute,oDataGear);
    SetDokumentation_Init(strchangedAttribute,oDataGear);

    // geschweifte Klammer entfernen.
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR"),20));
    
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT"),20));
    
    
    //MLFB bestimmen
    var oMLFB = buildFormattedMLFB( oDataGear, true);
    
    checkMLFBandConfiguration(oMLFB);
    
    
    //MLFB generieren
    var strMLFB="";
    if(oMLFB.strFormattedShortDescriptions!="")
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
    else
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");
                        
    ECL_SetValue("ECSI_MLFB",strMLFB);
    
    logtraceln("MLFB="+strMLFB);
    
    Bestimme_Consequences_AdditionalInertia(oDataGear,oDataBremse);
    
    if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
    {
        Bestimme_Consequences_AdapterID(oDataGear);
    }
    
    var strGetriebemotorbezeichnung=BestimmeGetriebemotorbezeichnung(oDataGear,oDataBremse);
    logtraceln("Getriebemotor="+strGetriebemotorbezeichnung);
    ECL_SetValue("ECSI_TYPBEZEICHNUNG",strGetriebemotorbezeichnung+", "+oDataGear.oRow.LEISTUNG+" kW");
    
    ECL_SetValue("ECSI_CC_GearboxShortDescription",strGetriebemotorbezeichnung);
    
    
    var JSON_oDataGear = JSON.stringify(oDataGear);
    ECL_SetValue("ECSI_GEARDATA",JSON_oDataGear);
    
    var JSON_oDataBremse = JSON.stringify(oDataBremse);
    ECL_SetValue("ECSI_BRAKEDATA",JSON_oDataBremse);
    
    checkMLFBforWarningMessage(oMLFB.strBaseMLFB);
    HandleDefaultValuesHighlights();
    
}

function Bestimme_Consequences_AdditionalInertia(oData,oDataBremse)
{
    //Consequences für Getriebe
    BestimmeGetriebeConsequences(oData);
    
    //Bei Schwungradlüfter Zusatz-Trägheitsmoment ausgeben
    var dAdditionalIneriaVentilation=0;
    
    var strBelueftung=ECL_GetValue("BELUEFTUNG");
    if(strBelueftung=="Schwungradluefter")
    {
        var strSelect = "SELECT DISTINCT BEL_J FROM MOLUEFTER WHERE ";
        strSelect = strSelect + "MOLUEFTER.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
        strSelect = strSelect + "MOLUEFTER.MOBSANB = '"+Bestimme_MobsAnb(oData)+"' AND ";
        strSelect = strSelect + "MOLUEFTER.REGION = 'S' AND ";
        
        if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        {
            //Abfrage Temperatur
            strSelect = strSelect + "CAST(MOLUEFTER.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
        }
        
        
        strSelect = strSelect + "MOLUEFTER.BELLUEFT = 'Schwungradluefter' AND ";
        
        
        //Unterscheidung Großmotor oder Normalmotor
        strSelect = strSelect + "MOLUEFTER.M3 = '"+oData.oRow.M3+"' ";
        strSelect = strSelect + "AND MOLUEFTER.GM3 = '"+oData.oRow.GM3+"' ";
        
        var strMOABSSART = "BK4";
        if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
            strMOABSSART = "Z19";
        
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        
        if(aResult.length==1)
        {
            dAdditionalIneriaVentilation=parseFloat(aResult[0].BEL_J);
        }
        else
            logtraceln("Fehler bei Bestimmung additional Intertia Befüftungsart!, SQL="+strSelect);
    }
    
    //Bremsen Consequences
    if(ECL_ValueSelected("MIT_BREMSE", "T"))
    {
        var strBremse= oDataBremse.oRow.BREART;
        
        if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
                strBremse=strBremse+"S";
                
        if ( oDataBremse.oRow.BREART === 'FDX' )
        {
            if(oDataBremse.oRow.BRENENMO == "500")
                strBremse = strBremse+"30"+"/"+oDataBremse.oRow.BREREDMO;
            else if(oDataBremse.oRow.BRENENMO == "1000")
                strBremse = strBremse+"40"+"/"+oDataBremse.oRow.BREREDMO;
        }
        else if(oDataBremse.oRow.BREREDMO == "-")
        {	
            strBremse = strBremse+oDataBremse.oRow.BRENENMO+"/"+oDataBremse.oRow.BRENENMO;
        }
        else
            strBremse = strBremse+oDataBremse.oRow.BRENENMO+"/"+oDataBremse.oRow.BREREDMO;
            
        strBremse = replace(strBremse,".",",");
                    
        //BrakeID generieren aus SIZER Table und zurückliefern
    
        var strSZ_MB_Supply_Voltage_Setup="";
        if(ECL_GetValue("BREMSE_STEUERSPANNUNG")=="24-24" || ECL_GetValue("BREMSE_STEUERSPANNUNG")=="103-103" || ECL_GetValue("BREMSE_STEUERSPANNUNG")=="180-180" || ECL_GetValue("BREMSE_STEUERSPANNUNG")=="205-205")
            strSZ_MB_Supply_Voltage_Setup="DC";
        else
            strSZ_MB_Supply_Voltage_Setup="AC";
            
        if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER")!="ohne")
            strSZ_MB_Supply_Voltage_Setup=strSZ_MB_Supply_Voltage_Setup+"_FR";
        
        var strSelect= "SELECT SZ_MB_BrakeId FROM _2KJ3_TMB_MECHANICALBRAKES_NEW7 WHERE ";
        strSelect = strSelect + "SZ_MB_NAME='"+strBremse+"' AND ";
        
        if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
            strSelect = strSelect + "SZ_MB_BRAKE_TYPE='1' AND ";
        else
            strSelect = strSelect + "SZ_MB_BRAKE_TYPE='3' AND ";
        
        strSelect = strSelect + "SZ_MB_SUPPLY_VOLTAGE_SETUP='"+strSZ_MB_Supply_Voltage_Setup+"' AND ";
        
        if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "Uebererreg.+DC-Absch.Stromerf.")
        {
            strSelect = strSelect + "SZ_MB_SHORTOPTIONS like '%C59%' AND ";
        }
        else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "Uebererreg.+DC-Absch.Spgerf.")
        {
            strSelect = strSelect + "SZ_MB_SHORTOPTIONS like '%C60%' AND ";
        }
        
        if(ECL_GetValue("BREMSE_REIBBELAG")=="verschl.armer Belag")
            strSelect = strSelect + "SZ_MB_FRICTION_LINING_WEAR_RESISTANT='-1' ";
        else
            strSelect = strSelect + "SZ_MB_FRICTION_LINING_WEAR_RESISTANT='0' ";
        
        
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        if(aResult.length == 1)
        {
            ECL_SetValue("ECSI_CC_BrakeID", aResult[0].SZ_MB_BRAKEID);
            logtraceln("BrakeID="+aResult[0].SZ_MB_BRAKEID);
        }
        else
        {
            logtraceln("Fehler bei der Bestimmung der MotorConsequences BremsenID!, SQL="+strSelect);
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERRORMSG_2KJ___BRAKEID"));
        }
    }
    else
    {
        ECL_SetValue("ECSI_CC_BrakeID", "");
    }
    
    var AdditionalInertia=dAdditionalIneriaVentilation;
    logtraceln("Additional Inertia="+AdditionalInertia);
    
    ECL_SetValue("ECSI_CC_AdditionalInertia", AdditionalInertia);
    
    logtraceln("Zusatzträgheitsmoment:"+AdditionalInertia);
    
    //Consequence für Geber
    //etwas aufgebohrt 2021.04.29
    /*
    if(ECL_ValueSelected("MIT_GEBER", "T"))
    {
        var strSelectedEncoder=ECL_GetValue("GEBER_DIREKTAUSWAHL");
        strSelectedEncoder=replace(strSelectedEncoder,"|-","");
        strSelectedEncoder=replace(strSelectedEncoder,"|Kauf","");
    
        var strSelect="SELECT DISTINCT SELECTED_ENCODER FROM GEBER_CONSEQUENCE WHERE GEBER ='"+strSelectedEncoder+"' ";
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        if(aResult.length==1)
            ECL_SetValue("ECSI_CC_SelectedEncoder", aResult[0].SELECTED_ENCODER);
    }
    else
        ECL_SetValue("ECSI_CC_SelectedEncoder", "0");
        
    */
     
    //Consequence für Abtriebswellendichtung	
    var strAbtriebswellendichtung=ECL_GetValue("ABTRIEBSWELLENABDICHTUNG");
    var Abtriebswellenabdichtung_Consequence="-";
    
    if(strAbtriebswellendichtung=="Standardabdichtung")
        Abtriebswellenabdichtung_Consequence="0";
    else if(strAbtriebswellendichtung=="Dichtung laengere Lebensdauer")
        Abtriebswellenabdichtung_Consequence="1";
    else if(strAbtriebswellendichtung=="Dichtung erhoehte Belastung")
        Abtriebswellenabdichtung_Consequence="2";
    else if(strAbtriebswellendichtung=="Hochtemperaturfest")
        Abtriebswellenabdichtung_Consequence="3";
    else
        Abtriebswellenabdichtung_Consequence="";
        
    ECL_SetValue("ECSI_CC_OutputShaftSealing", Abtriebswellenabdichtung_Consequence);
    
    logtraceln("ECSI_CC_OutputShaftSealing:"+Abtriebswellenabdichtung_Consequence);
    
    
    //Drive Train
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T"))
        ECL_SetValue("ECSI_CC_IsDriveTrain","True");
    else
        ECL_SetValue("ECSI_CC_IsDriveTrain","False");
    
    
}

function Bestimme_Consequences_AdapterID(oDataGear)
{
    //Bestimmung der Adapter ID aus der Tabelle TE_M_Adapter
    
    var strMLFB = ECL_GetValue("ECSI_MLFB");
    
    var strSearchString="2KJ3...."+strMLFB.substring( 8, 12 )+"....";

    // KU Adapter Options

    var strShortDescriptions = "";
     if (ECL_ValueSelected("ANTRIEBSGRUPPE_TYP", "KU")) {

        if (ECL_GetValue("ANTRIEBSGRUPPE_LAGERUNG") == "Zylinderrollenlager") {
            strShortDescriptions = strShortDescriptions + "A30 ";
        }

        if (ECL_GetValue("ANTRIEBSGRUPPE_DICHTUNG") == "FKM") {
            strShortDescriptions = strShortDescriptions + "A35";
        }
        else if (ECL_GetValue("ANTRIEBSGRUPPE_DICHTUNG") == "MSS1-HS") {
            strShortDescriptions = strShortDescriptions + "A36";
        }

        strShortDescriptions = strShortDescriptions.trim();
    }

    var strSelect = "SELECT DISTINCT SZ_MA_ID FROM TE_M_ADAPTER WHERE SZ_MA_OrderNumber='" + strSearchString + "' ";

    if (strShortDescriptions != "") {
        strSelect = strSelect + "AND SZ_MA_ShortOptions='" + strShortDescriptions + "' ";
    }
    else {
        strSelect = strSelect + "AND SZ_MA_ShortOptions='' ";
    }

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    if (aResult.length == 1) {
        ECL_SetValue("ECSI_CC_SelectedGearboxAdapterID", aResult[0].SZ_MA_ID);
        logtraceln("AdapterID=" + aResult[0].SZ_MA_ID);
    }
    else
        logtraceln("Fehler bei der Bestimmung der MotorConsequences AdapterID!, SQL="+strSelect);

    // additional consequences for adapters:
    if ((ECL_GetValue("ECSI_CX_MinimalExplosionProtectionGas")!="" || ECL_GetValue("ECSI_CX_MinimalExplosionProtectionDust")!="") && ECL_ValueSelected("ANTRIEBSGRUPPE_TYP", "KU"))
    {
        if( ECL_ValueSelected("ANTRIEBSGRUPPE_LAGERUNG", "Zylinderrollenlager"))
        {
            ECL_SetValue("ECSI_CC_MaxRotationSpeedLimit","2000");
            logtraceln("ECSI_CC_MaxRotationSpeedLimit=2000");
        }

    }  
}

function checkMLFBforWarningMessage(strMLFB)
{
    if(ECL_ValueSelected ("ECSI_STATUS", "E"))
    {
        return;
    }
    
    strMLFB=strMLFB.replace("-","");
    var strRegEx="2KJ3{1;2}03?G?{21;22;23;32;33;73}{4;9}???"
    
    if(EK_regFound(strMLFB, strRegEx))
    {
        ECL_SelectValue("ECSI_STATUS", "WARNING");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate("WARNINGMSG___MLFB_PM400"));
    }
    
    return;
}

function EK_regPrep(s_src)
{
    var s=s_src.replace("?", ".");
    s=s.replace("{", "(");
    s=s.replace("}", ")");
    s=s.replace(";", "|");
    return s;
}

function EK_regFound(s_src, s_reg)
{
    var regEx = new RegExp(EK_regPrep(s_reg));
    
    if(s_src && s_src !="")
    {
        var aM = s_src.match(regEx);
        if(aM == null)
            return false;
        if(aM.length == 0)
            return false;
        return true;
    }
    
    return false;
}
