//@legacy
//#mode(full-ecma)

//@import "2KJ4_CONFIG/VT_TF.js"

//@import "2KJ4_CONFIG/CFG_2KJ_BAUFORM.js"

//@import "2KJ4_CONFIG/CFG_2KJ_VORAUSWAHL.js"

//@import "2KJ4_CONFIG/CFG_2KJ_BEFESTIGUNG.js"

//@import "2KJ4_CONFIG/CFG_2KJ_GETRIEBE_OPTIONEN.js"

//@import "2KJ4_CONFIG/CFG_2KJ_ADAPTER.js"

//@import "2KJ4_CONFIG/CFG_2KJ_ELEKTRISCHE_AUSFUEHRUNG.js"

//@import "2KJ4_CONFIG/CFG_2KJ_MECHANISCHE_AUSFUEHRUNG.js"

//@import "2KJ4_CONFIG/CFG_2KJ_GEBER.js"

//@import "2KJ4_CONFIG/CFG_2KJ_BREMSE.js"

//@import "2KJ4_CONFIG/CFG_2KJ_MOTOR_ZUSATZOPTIONEN.js"

//@import "2KJ4_CONFIG/CFG_2KJ_KONSERVIERUNG.js"

//@import "2KJ4_CONFIG/CFG_2KJ_DOKUMENTATION.js"

//@import "2KJ4_CONFIG/CFG_2KJ_SPEZIFIKATION.js"

//@import "2KJ4_CONFIG/CFG_2KJ_DRIVETRAIN.js"


//@import "2KJ4_MLFB/MLFB.MOTOX.construct.js"

//@import "2KJ4_PARSER/Parser.MOTOX.parse.js"

//@import "2KJ4_PARSER/Parser.common.js"

//@import "2KJ4_PARSER/Parser.tokenizer.js"

//@import "2KJ4_CONFIG/CFG_2KJ_CHECKS_DEFAULTS.js"

//@import "SIZER_general_functions.js"

globalThis.OnChangeConfiguration = function main()
{
    var strchangedAttribute = ECL_GetCurrentAttribute();
    logtraceln("Changed Attribute="+strchangedAttribute);


    if(strchangedAttribute.left(7) == "ECSI_CX")
        return;
    
    var vtTimeConfigStart	= Date.getTime();
    
    var bSizerMode = true;                  //wird auf true gesetzt, da man immer in sizermodus ist
    ECL_SetValue("ECSI_2KJ_MODE_2KJ4", "SIZER_CONFIG");

    logtraceln("MODE="+ECL_GetValue ("ECSI_2KJ_MODE_2KJ4"));
    
    ECL_DisableAttribute("ECSI_TYPBEZEICHNUNG_2KJ4");
    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");
    
    var oDataGear = {};
    oDataGear.oInfo = {};
    oDataGear.oRow = {};
    
    var oDataBremse = {};
    oDataBremse.oInfo = {};
    oDataBremse.oRow = {};
    
    //Initialisierung
    if(ECL_GetCurrentAttribute() == "@INIT@")
    {
        ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
        
        /* wird nicht mehr gebraucht
        ECL_ExpandAttributeGroup("CFG_GROUP___VORAUSWAHL");
        ECL_ExpandAttributeGroup("CFG_GROUP___SUCHE");
        ECL_ExpandAttributeGroup("CFG_GROUP___DRIVETRAIN");
        ECL_ExpandAttributeGroup("CFG_GROUP___BAUFORM");
        ECL_ExpandAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
        ECL_ExpandAttributeGroup("CFG_GROUP___BEFESTIGUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
        ECL_ExpandAttributeGroup("CFG_GROUP___ADAPTER");
        ECL_ExpandAttributeGroup("CFG_GROUP___SPEZIFIKATION");
        ECL_ExpandAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE");
        ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2");
        ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE_SIZER");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEBER");
        ECL_ExpandAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
        ECL_ExpandAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
        ECL_ExpandAttributeGroup("CFG_GROUP___KONSERVIERUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
        ECL_ExpandAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___DOKUMENTATION");
        ECL_ExpandAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
        */
        
        ECL_DeactivateAttributeGroup("CFG_GROUP___DRIVETRAIN");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ADAPTER");
        ECL_DeactivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE_SIZER");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEBER");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
        ECL_DeactivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
        ECL_DeactivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
        ECL_DeactivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
        
        ECL_DeactivateAttribute("MIT_BREMSE_2KJ4");
        ECL_DeactivateAttribute("MIT_GEBER_2KJ4");
    }
    
    if(strchangedAttribute == "ECSI_MLFB")
    {
        
        //alle Daten aus dem SIZER werden in ein Attribut als JSON geladen und dann wieder in einzelne Attribute umgesetzt
        ///
        if(bSizerMode){
            SetAttributesFromMlfb();
        }
       
        //Test MLFB's
        // 2KJ4104-1CE23-9AG1-Z D01+K01+K06+L02+L75+M55+N6A+P91
        // 2KJ4104.CE239.G1 N6A

        // 2KJ4104-1DE44-9AC1-Z D01+K01+K06+L02+L75+M55+N6D+P91
        // 2KJ4104.DE449.C1 N6D

        // 2KJ4101.BD239.B1 N6D // 87 Hz


        
        var strMLFB_for_Parser = ECL_GetValue("ECSI_MLFB");
        if(strMLFB_for_Parser != "")
        {	
            ECL_DeactivateAttributeGroup("CFG_GROUP___VORAUSWAHL");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SUCHE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___DRIVETRAIN");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ADAPTER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE_SIZER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEBER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
            ECL_DeactivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
            
            ECL_DeactivateAttribute("MIT_BREMSE_2KJ4");
            ECL_DeactivateAttribute("MIT_GEBER_2KJ4");
            
            //OriginalMLFB speichern
            //ECL_SetValue("ECSI_MLFB_ORIG", ECL_GETValue("ECSI_MLFB"));         
            var oParse = parse_init(strMLFB_for_Parser , "", true );

            if(oParse.strError == "")
            {
    
                ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "true");
                
                var bRet = parseSetValues(oParse, true);
                
                oDataGear.oRow = bRet.GearData.oRow;
                oDataBremse.oRow = bRet.BrakeData.oRow;

                setDefaultValues(oDataGear);

                var strRetContextValue="";
                if(find(strMLFB_for_Parser.left(16),".") >= 0)
                {
                    var strRetContextValue=checkContextValues(oDataGear, false);
                }
                else
                {
                    var strRetContextValue=checkContextValues(oDataGear, true);
                }
            
                if(strRetContextValue!="")
                {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(strRetContextValue));
                }
                else
                {
                
                    //Bei erfolgter Suche werden die Optionen aufgerufen
                    //Hier erst die Initialisierung

                    _2KJ4_config_Init(strchangedAttribute, oDataGear, oDataBremse);

                    //MLFB bestimmen
                    var oMLFB = buildFormattedMLFB( oDataGear, true);

                    checkMLFBandConfiguration(oMLFB);

                    //MLFB generieren
                    var strMLFB="";
                    if(oMLFB.strFormattedShortDescriptions!="")
                        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
                    else
                        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");
                    
                    ECL_SetValue("ECSI_MLFB",strMLFB);
                    logtraceln("MLFB="+strMLFB);
                    
                    var JSON_oDataGear = JSON.stringify(oDataGear);
                    ECL_SetValue("ECSI_GEARDATA_2KJ4",JSON_oDataGear);
                    
                    var JSON_oDataBremse = JSON.stringify(oDataBremse);
                    ECL_SetValue("ECSI_BRAKEDATA_2KJ4",JSON_oDataBremse);
                    
                    checkMLFBforWarningMessage(oMLFB.strBaseMLFB);
                    
                }
            }
            else
            {
                ECL_SelectValue ("ECSI_STATUS", "E");
                ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(oParse.strError));
            }
        }
        else if(strMLFB_for_Parser != "" && ECL_GetValue ("ECSI_STATUS_MESSAGE") == "")
        {	
            ECL_DeactivateAttributeGroup("CFG_GROUP___VORAUSWAHL");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SUCHE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___DRIVETRAIN");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ADAPTER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE_SIZER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEBER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
            ECL_DeactivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
            
            ECL_DeactivateAttribute("MIT_BREMSE_2KJ4");
            ECL_DeactivateAttribute("MIT_GEBER_2KJ4");
                    
            var JSON_oDataGear = ECL_GetValue ("ECSI_GEARDATA_2KJ4");
            var JSON_oDataBremse = ECL_GetValue ("ECSI_BRAKEDATA_2KJ4");
            
            if(JSON_oDataGear)
            {
                oDataGear = JSON.parse(JSON_oDataGear);
                oDataBremse = JSON.parse(JSON_oDataBremse);
            }
            else
            {
                var strMLFB_for_Parser = ECL_GetValue("ECSI_MLFB");
                if(strMLFB_for_Parser != "")
                {	var oParse = parse_init(strMLFB_for_Parser , "", true );
                    var bRet = parseSetValues(oParse, false);
                    
                    if(oParse.strError == "")
                    {
                        ECL_SelectValue ("ECSI_STATUS", "OK");
                    }
                    else
                    {
                        ECL_SelectValue ("ECSI_STATUS", "E");
                        ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(oParse.strError));
                    }
            
                    oDataGear.oRow = bRet.GearData.oRow;
                    oDataBremse.oRow = bRet.BrakeData.oRow;
                }
            }
            
            _2KJ4_config_Init(strchangedAttribute, oDataGear, oDataBremse);
            
            //MLFB bestimmen
            var oMLFB = buildFormattedMLFB( oDataGear, true);
            
            checkMLFBandConfiguration(oMLFB);
            
            //MLFB generieren
            var strMLFB="";
            if(oMLFB.strFormattedShortDescriptions!="")
                strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
            else
                strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");
                
            ECL_SetValue("ECSI_MLFB",strMLFB);
            logtraceln("MLFB="+strMLFB);
            
            var JSON_oDataGear = JSON.stringify(oDataGear);
            ECL_SetValue("ECSI_GEARDATA_2KJ4",JSON_oDataGear);
            
            var JSON_oDataBremse = JSON.stringify(oDataBremse);
            ECL_SetValue("ECSI_BRAKEDATA_2KJ4",JSON_oDataBremse);
            
            checkMLFBforWarningMessage(oMLFB.strBaseMLFB);
        }
        else
        {
            //nothing to do here 

            ECL_DeactivateAttributeGroup("CFG_GROUP___VORAUSWAHL");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SUCHE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE");
            
            var JSON_oDataGear = ECL_GetValue ("ECSI_GEARDATA_2KJ4");
            var JSON_oDataBremse = ECL_GetValue ("ECSI_BRAKEDATA_2KJ4");
            
            if(JSON_oDataGear)
            {
                oDataGear = JSON.parse(JSON_oDataGear);
                oDataBremse = JSON.parse(JSON_oDataBremse);
            
            
                if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
                {		
                    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
                    {
                        ECL_ActivateAttribute("BREMSENTYP_2KJ4");
                        ECL_ActivateAttribute("BREMSE_SAFETY_2KJ4");
                        //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht mehr gebraucht
                    }
                }
                
                if(ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
                {
                    ECL_ActivateAttribute("GEBER_AUSFUEHRUNG_2KJ4");
                    ECL_ActivateAttribute("GEBER_FUNKT_SICHERHEIT_2KJ4");
                    ECL_ActivateAttribute("GEBER_IMPULSZAHL_2KJ4");
                    ECL_ActivateAttribute("GEBER_ELEKTRONIK_2KJ4");
                    ECL_ActivateAttribute("GEBER_EINGANGSFREQUENZ_2KJ4");
                    ECL_ActivateAttribute("GEBER_AUSGANGSSIGNALE_2KJ4");
                    ECL_ActivateAttribute("GEBER_MECH_VAR_2KJ4");
                    ECL_ActivateAttribute("GEBER_DIREKTAUSWAHL_2KJ4");
                    ECL_ActivateAttribute("GEBER_TECHNISCHEAUSWAHL_2KJ4");
                    ECL_ActivateAttribute("GEBER_MECHSCHUTZ_2KJ4");
                    ECL_ActivateAttribute("GEBER_ZUB_KABEL_2KJ4");
                    ECL_ActivateAttribute("GEBER_ZUB_GATEWAYS_2KJ4");
                }
                
                var JSON_oDataGear = JSON.stringify(oDataGear);
                ECL_SetValue("ECSI_GEARDATA_2KJ4",JSON_oDataGear);
                
                var JSON_oDataBremse = JSON.stringify(oDataBremse);
                ECL_SetValue("ECSI_BRAKEDATA_2KJ4",JSON_oDataBremse);
            }
        
        }
        
    }
    
    if(strchangedAttribute != "ECSI_MLFB" && ECL_GetValue ("ECSI_CFG_INIT_OPTIONS") == "true")
    {
       if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
        {
            //ECL_CollapseAttributeGroup("CFG_GROUP___VORAUSWAHL"); wird nicht mehr benötigt
            //ECL_CollapseAttributeGroup("CFG_GROUP___SUCHE");      wird nicht mehr benötigt
            ECL_DeactivateAttributeGroup("CFG_GROUP___VORAUSWAHL");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SUCHE");
            
            var JSON_oDataGear = ECL_GetValue ("ECSI_GEARDATA_2KJ4");
            var JSON_oDataBremse = ECL_GetValue ("ECSI_BRAKEDATA_2KJ4");
            
            if(JSON_oDataGear)
            {
                oDataGear = JSON.parse(JSON_oDataGear);
                oDataBremse = JSON.parse(JSON_oDataBremse);
            }
            else
            {
                var strMLFB_for_Parser = ECL_GetValue("ECSI_MLFB");
                if(strMLFB_for_Parser != "")
                {	var oParse = parse_init(strMLFB_for_Parser , "", true );
                    var bRet = parseSetValues(oParse, false);
                    
                    if(oParse.strError == "")
                    {
                        ECL_SelectValue ("ECSI_STATUS", "OK");
                    }
                    else
                    {
                        ECL_SelectValue ("ECSI_STATUS", "E");
                        ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(oParse.strError));
                    }
            
                    oDataGear.oRow = bRet.GearData.oRow;
                    oDataBremse.oRow = bRet.BrakeData.oRow;
                }
            }
            
            _2KJ4_config(strchangedAttribute, oDataGear, oDataBremse);
        }
    }

    var vtTimeConfigStop	= Date.getTime();
    var vtConfigTime		= (vtTimeConfigStop - vtTimeConfigStart) / 1000;
    logtraceln("******* Configuration - Time: "+vtConfigTime+" sec"+"\n");
    
    logtraceln("ERROR:"+ECL_GetValue ("ECSI_STATUS_MESSAGE"));
}

function _2KJ4_config(strchangedAttribute, oDataGear, oDataBremse)
{
    
    SetDrivetrain(strchangedAttribute,oDataGear);
    SetBauform(strchangedAttribute,oDataGear);
    SetBefestigung(strchangedAttribute,oDataGear);
    SetGetriebeOptionen(strchangedAttribute,oDataGear);
    
    if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBEMOTOR")
    {
        setSpezifikation_SIZER(strchangedAttribute,oDataGear);
        SetElektrischeAusfuehrung(strchangedAttribute,oDataGear);
        SetMechanischeAusfuehrung(strchangedAttribute,oDataGear,oDataBremse);
        
        if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T") && (strchangedAttribute == "ECSI_TABLE_BREMSE_2KJ4" || strchangedAttribute == "BREMSENTYP_2KJ4"))
        {
            if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
            {
                ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht mehr gebraucht 
                
                SetBremse_InitOptions(strchangedAttribute,oDataGear,oDataBremse);
            }
        }
        else if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
        {
            
            if(strchangedAttribute == "MIT_BREMSE_2KJ4")
            {
                if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
                {
                    ECL_ActivateAttribute("BREMSENTYP_2KJ4");
                    ECL_ActivateAttribute("BREMSE_SAFETY_2KJ4");
                    
                    SetBremse_Init_Sizer(oDataGear,oDataBremse);
                    
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                    //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht mehr gebraucht
                    
                    SetBremse_InitOptions(strchangedAttribute,oDataGear,oDataBremse);
                }
            }
            else
            {
                if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
                {
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                    
                    SetBremse(strchangedAttribute,oDataGear,oDataBremse);
                }
            }
        }
        else if(!ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
        {
            if(strchangedAttribute=="SCHUTZART_2KJ4")
                SetBremse_Init(strchangedAttribute,oDataGear,oDataBremse);
                
            if( ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED" && (strchangedAttribute == "MOTORSCHUTZ_2KJ4" || strchangedAttribute == "STILLSTANDSHEIZUNG_2KJ4"))
                SetBremse_Init(strchangedAttribute,oDataGear,oDataBremse);
            
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE");
            //ECL_CollapseAttributeGroup("CFG_GROUP___BREMSE"); wird nicht mehr benötigt
    
            ECL_DeactivateAttribute("BREMSENTYP_2KJ4");
            ECL_DeactivateAttribute("BREMSE_SAFETY_2KJ4");
            
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
            //ECL_CollapseAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht mehr benötigt
        }
        
        Bestimme_GEBER_AUSFUEHRUNG(oDataGear);
        if(ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
        {
            if(strchangedAttribute == "MIT_GEBER_2KJ4")
            {
                ECL_ActivateAttribute("GEBER_AUSFUEHRUNG_2KJ4");
                ECL_ActivateAttribute("GEBER_FUNKT_SICHERHEIT_2KJ4");
                ECL_ActivateAttribute("GEBER_IMPULSZAHL_2KJ4");
                ECL_ActivateAttribute("GEBER_ELEKTRONIK_2KJ4");
                ECL_ActivateAttribute("GEBER_EINGANGSFREQUENZ_2KJ4");
                ECL_ActivateAttribute("GEBER_AUSGANGSSIGNALE_2KJ4");
                ECL_ActivateAttribute("GEBER_MECH_VAR_2KJ4");
                ECL_ActivateAttribute("GEBER_DIREKTAUSWAHL_2KJ4");
                ECL_ActivateAttribute("GEBER_TECHNISCHEAUSWAHL_2KJ4");
                ECL_ActivateAttribute("GEBER_MECHSCHUTZ_2KJ4");
                ECL_ActivateAttribute("GEBER_ZUB_KABEL_2KJ4");
                ECL_ActivateAttribute("GEBER_ZUB_GATEWAYS_2KJ4");
                SetGeber_Init(strchangedAttribute,oDataGear);
            }
            else
                SetGeber(strchangedAttribute,oDataGear);
            
            //weitere Abhängigkeit
            SetElektrischeAusfuehrung(strchangedAttribute,oDataGear);
        }
        else if(!ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
        {
                ECL_DeactivateAttribute("GEBER_AUSFUEHRUNG_2KJ4");
                ECL_DeactivateAttribute("GEBER_FUNKT_SICHERHEIT_2KJ4");
                ECL_DeactivateAttribute("GEBER_IMPULSZAHL_2KJ4");
                ECL_DeactivateAttribute("GEBER_ELEKTRONIK_2KJ4");
                ECL_DeactivateAttribute("GEBER_EINGANGSFREQUENZ_2KJ4");
                ECL_DeactivateAttribute("GEBER_AUSGANGSSIGNALE_2KJ4");
                ECL_DeactivateAttribute("GEBER_MECH_VAR_2KJ4");
                ECL_DeactivateAttribute("GEBER_DIREKTAUSWAHL_2KJ4");
                ECL_DeactivateAttribute("GEBER_TECHNISCHEAUSWAHL_2KJ4");
                ECL_DeactivateAttribute("GEBER_MECHSCHUTZ_2KJ4");
                ECL_DeactivateAttribute("GEBER_ZUB_KABEL_2KJ4");
                ECL_DeactivateAttribute("GEBER_ZUB_GATEWAYS_2KJ4");
        }
        
        SetMotor_Zusatzoptionen(strchangedAttribute,oDataGear);
    }
    else if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBE.ADAPTER")
    {
        SetAdapter_Optionen(strchangedAttribute,oDataGear);
    }

    SetKonservierung(strchangedAttribute,oDataGear);
    SetDokumentation(strchangedAttribute,oDataGear);
    
    // geschweifte Klammer entfernen.
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4"),20));
    
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4"),20));
    
    
    //MLFB bestimmen
    var oMLFB = buildFormattedMLFB( oDataGear, true);
    
    checkMLFBandConfiguration(oMLFB);
    
    //MLFB generieren
    var strMLFB="";
    if(oMLFB.strFormattedShortDescriptions!="")
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
    else
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");
                        
    ECL_SetValue("ECSI_MLFB",strMLFB);
    
    logtraceln("MLFB="+strMLFB);
    
    Bestimme_Consequences_AdditionalInertia(oDataGear,oDataBremse);
    
    if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBE.ADAPTER")
    {
        Bestimme_Consequences_AdapterID(oDataGear);
    }
    
    var strGetriebemotorbezeichnung=BestimmeGetriebemotorbezeichnung(oDataGear,oDataBremse);
    logtraceln("Getriebemotor="+strGetriebemotorbezeichnung);
    ECL_SetValue("ECSI_TYPBEZEICHNUNG_2KJ4",strGetriebemotorbezeichnung+", "+oDataGear.oRow.LEISTUNG+" kW");
    ECL_SetValue("ECSI_CC_GearboxShortDescription",strGetriebemotorbezeichnung);
    
    var JSON_oDataGear = JSON.stringify(oDataGear);
    ECL_SetValue("ECSI_GEARDATA_2KJ4",JSON_oDataGear);
    
    var JSON_oDataBremse = JSON.stringify(oDataBremse);
    ECL_SetValue("ECSI_BRAKEDATA_2KJ4",JSON_oDataBremse);
    
    checkMLFBforWarningMessage(oMLFB.strBaseMLFB);
    HandleDefaultValuesHighlights();
}

function _2KJ4_config_Init(strchangedAttribute, oDataGear, oDataBremse)
{
    ECL_ActivateAttributeGroup("CFG_GROUP___DRIVETRAIN");
    ECL_ActivateAttributeGroup("CFG_GROUP___BAUFORM");
    
    ECL_ActivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
    
    ECL_ActivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
    

    if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBEMOTOR")
    {
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
            ECL_ActivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
    
        ECL_ActivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
        ECL_ActivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
    
        ECL_ActivateAttribute("MIT_BREMSE_2KJ4");
        ECL_ActivateAttribute("MIT_GEBER_2KJ4");
    }
    else if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBE.ADAPTER")
    {
        ECL_ActivateAttributeGroup("CFG_GROUP___ADAPTER");
    }
    
    SetDrivetrain_Init(strchangedAttribute,oDataGear);
    SetBauform_Init(strchangedAttribute,oDataGear);
    SetBefestigung_Init(strchangedAttribute,oDataGear);
    SetGetriebeOptionen_Init(strchangedAttribute,oDataGear);

    if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBEMOTOR")
    {
        setSpezifikation_SIZER(strchangedAttribute,oDataGear);
        SetElektrischeAusfuehrung_Init(strchangedAttribute,oDataGear);
        SetMechanischeAusfuehrung_Init(strchangedAttribute,oDataGear,oDataBremse);
        
        
        SetBremse_Init(strchangedAttribute,oDataGear,oDataBremse);
        ;
        if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
        {		
            if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
            {
                ECL_ActivateAttribute("BREMSENTYP_2KJ4");
                ECL_ActivateAttribute("BREMSE_SAFETY_2KJ4");
                
                SetBremse_Init_Sizer(oDataGear,oDataBremse);
                
                ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht mehr benötigt  
                SetBremse_InitOptions(strchangedAttribute,oDataGear,oDataBremse);
            }
        }
        
        Bestimme_GEBER_AUSFUEHRUNG(oDataGear);
        ;
        if(ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
        {
            ECL_ActivateAttribute("GEBER_AUSFUEHRUNG_2KJ4");
            ECL_ActivateAttribute("GEBER_FUNKT_SICHERHEIT_2KJ4");
            ECL_ActivateAttribute("GEBER_IMPULSZAHL_2KJ4");
            ECL_ActivateAttribute("GEBER_ELEKTRONIK_2KJ4");
            ECL_ActivateAttribute("GEBER_EINGANGSFREQUENZ_2KJ4");
            ECL_ActivateAttribute("GEBER_AUSGANGSSIGNALE_2KJ4");
            ECL_ActivateAttribute("GEBER_MECH_VAR_2KJ4");
            ECL_ActivateAttribute("GEBER_DIREKTAUSWAHL_2KJ4");
            ECL_ActivateAttribute("GEBER_TECHNISCHEAUSWAHL_2KJ4");
            ECL_ActivateAttribute("GEBER_MECHSCHUTZ_2KJ4");
            ECL_ActivateAttribute("GEBER_ZUB_KABEL_2KJ4");
            ECL_ActivateAttribute("GEBER_ZUB_GATEWAYS_2KJ4");
            SetGeber_Init(strchangedAttribute,oDataGear);
        }
        
    
        ECL_ActivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
        ECL_ActivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
    
        SetMotor_Zusatzoptionen_Init(strchangedAttribute,oDataGear);
       
    }
    
    else if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBE.ADAPTER")
    {
        SetAdapter_Optionen_Init(strchangedAttribute,oDataGear);
    }
    
    ECL_ActivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
    ECL_ActivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
    ECL_ActivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
    
    
    SetKonservierung_Init(strchangedAttribute,oDataGear);
    SetDokumentation_Init(strchangedAttribute,oDataGear);

    // geschweifte Klammer entfernen.
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ4"),20));
    
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ4"),20));
    
    
    //MLFB bestimmen
    var oMLFB = buildFormattedMLFB( oDataGear, true);
    
    checkMLFBandConfiguration(oMLFB);
    
    
    //MLFB generieren
    var strMLFB="";
    if(oMLFB.strFormattedShortDescriptions!="")
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
    else
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");
                        
    ECL_SetValue("ECSI_MLFB",strMLFB);
    
    logtraceln("MLFB="+strMLFB);
    
    Bestimme_Consequences_AdditionalInertia(oDataGear,oDataBremse);
    
    if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBE.ADAPTER")
    {
        Bestimme_Consequences_AdapterID(oDataGear);
    }
    
    var strGetriebemotorbezeichnung=BestimmeGetriebemotorbezeichnung(oDataGear,oDataBremse);
    logtraceln("Getriebemotor="+strGetriebemotorbezeichnung);
    ECL_SetValue("ECSI_TYPBEZEICHNUNG_2KJ4",strGetriebemotorbezeichnung+", "+oDataGear.oRow.LEISTUNG+" kW");
    
    ECL_SetValue("ECSI_CC_GearboxShortDescription",strGetriebemotorbezeichnung);
    
    
    var JSON_oDataGear = JSON.stringify(oDataGear);
    ECL_SetValue("ECSI_GEARDATA_2KJ4",JSON_oDataGear);
    
    var JSON_oDataBremse = JSON.stringify(oDataBremse);
    ECL_SetValue("ECSI_BRAKEDATA_2KJ4",JSON_oDataBremse);
    
    checkMLFBforWarningMessage(oMLFB.strBaseMLFB);
    HandleDefaultValuesHighlights();
    
}

function Bestimme_Consequences_AdditionalInertia(oData,oDataBremse)
{
    //Consequences für Getriebe
    BestimmeGetriebeConsequences(oData);
    
    //Bei Schwungradlüfter Zusatz-Trägheitsmoment ausgeben
    var dAdditionalIneriaVentilation=0;
    
    var strBelueftung=ECL_GetValue("BELUEFTUNG_2KJ4");
    if(strBelueftung=="Schwungradluefter")
    {
        var strSelect = "SELECT DISTINCT BEL_J FROM MOLUEFTER WHERE ";
        strSelect = strSelect + "MOLUEFTER.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
        strSelect = strSelect + "MOLUEFTER.MOBSANB = '"+Bestimme_MobsAnb(oData)+"' AND ";
        strSelect = strSelect + "MOLUEFTER.REGION = 'S' AND ";
        
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
        {
            //Abfrage Temperatur
            strSelect = strSelect + "CAST(MOLUEFTER.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
        }
        
        
        strSelect = strSelect + "MOLUEFTER.BELLUEFT = 'Schwungradluefter' AND ";
        
        
        //Unterscheidung Großmotor oder Normalmotor
        strSelect = strSelect + "MOLUEFTER.M3 = '"+oData.oRow.M3+"' ";
        strSelect = strSelect + "AND MOLUEFTER.GM3 = '"+oData.oRow.GM3+"' ";
        
        var strMOABSSART = "BK4";
        if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
            strMOABSSART = "Z19";
        
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        
        if(aResult.length==1)
        {
            dAdditionalIneriaVentilation=parseFloat(aResult[0].BEL_J);
        }
        else
            logtraceln("Fehler bei Bestimmung additional Intertia Befüftungsart!, SQL="+strSelect);
    }
    
    //Bremsen Consequences
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        var strBremse= oDataBremse.oRow.BREART;
        
        if(ECL_ValueSelected("BREMSE_SAFETY_2KJ4", "T"))
                strBremse=strBremse+"S";
                
        if ( oDataBremse.oRow.BREART === 'FDX' )
        {
            if(oDataBremse.oRow.BRENENMO == "500")
                strBremse = strBremse+"30"+"/"+oDataBremse.oRow.BREREDMO;
            else if(oDataBremse.oRow.BRENENMO == "1000")
                strBremse = strBremse+"40"+"/"+oDataBremse.oRow.BREREDMO;
        }
        else if(oDataBremse.oRow.BREREDMO == "-")
        {	
            strBremse = strBremse+oDataBremse.oRow.BRENENMO+"/"+oDataBremse.oRow.BRENENMO;
        }
        else
            strBremse = strBremse+oDataBremse.oRow.BRENENMO+"/"+oDataBremse.oRow.BREREDMO;
            
        strBremse = replace(strBremse,".",",");
                    
        //BrakeID generieren aus SIZER Table und zurückliefern
    
        var strSZ_MB_Supply_Voltage_Setup="";
        if(ECL_GetValue("BREMSE_STEUERSPANNUNG_2KJ4")=="24-24" || ECL_GetValue("BREMSE_STEUERSPANNUNG_2KJ4")=="103-103" || ECL_GetValue("BREMSE_STEUERSPANNUNG_2KJ4")=="180-180" || ECL_GetValue("BREMSE_STEUERSPANNUNG_2KJ4")=="205-205")
            strSZ_MB_Supply_Voltage_Setup="DC";
        else
            strSZ_MB_Supply_Voltage_Setup="AC";
            
        if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ4")!="ohne")
            strSZ_MB_Supply_Voltage_Setup=strSZ_MB_Supply_Voltage_Setup+"_FR";
        
        var strSelect= "SELECT SZ_MB_BrakeId FROM _2KJ3_TMB_MECHANICALBRAKES_NEW7 WHERE ";
        strSelect = strSelect + "SZ_MB_NAME='"+strBremse+"' AND ";
        
        if(ECL_ValueSelected("BREMSE_SAFETY_2KJ4", "T"))
            strSelect = strSelect + "SZ_MB_BRAKE_TYPE='1' AND ";
        else
            strSelect = strSelect + "SZ_MB_BRAKE_TYPE='3' AND ";
        
        strSelect = strSelect + "SZ_MB_SUPPLY_VOLTAGE_SETUP='"+strSZ_MB_Supply_Voltage_Setup+"' AND ";
        
        if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ4") == "Uebererreg.+DC-Absch.Stromerf.")
        {
            strSelect = strSelect + "SZ_MB_SHORTOPTIONS like '%C59%' AND ";
        }
        else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ4") == "Uebererreg.+DC-Absch.Spgerf.")
        {
            strSelect = strSelect + "SZ_MB_SHORTOPTIONS like '%C60%' AND ";
        }
        
        if(ECL_GetValue("BREMSE_REIBBELAG_2KJ4")=="verschl.armer Belag")
            strSelect = strSelect + "SZ_MB_FRICTION_LINING_WEAR_RESISTANT='-1' ";
        else
            strSelect = strSelect + "SZ_MB_FRICTION_LINING_WEAR_RESISTANT='0' ";
        
        
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        if(aResult.length == 1)
        {
            ECL_SetValue("ECSI_CC_BrakeID", aResult[0].SZ_MB_BRAKEID);
            logtraceln("BrakeID="+aResult[0].SZ_MB_BRAKEID);
        }
        else
        {
            logtraceln("Fehler bei der Bestimmung der MotorConsequences BremsenID!, SQL="+strSelect);
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERRORMSG_2KJ___BRAKEID"));
        }
    }
    else
    {
        ECL_SetValue("ECSI_CC_BrakeID", "");
    }
    
    var AdditionalInertia=dAdditionalIneriaVentilation;
    logtraceln("Additional Inertia="+AdditionalInertia);
    
    ECL_SetValue("ECSI_CC_AdditionalInertia", AdditionalInertia);
    
    logtraceln("Zusatzträgheitsmoment:"+AdditionalInertia);
    
    //Consequence für Geber
    //etwas aufgebohrt 2021.04.29
    /*
    if(ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
    {
        var strSelectedEncoder=ECL_GetValue("GEBER_DIREKTAUSWAHL_2KJ4");
        strSelectedEncoder=replace(strSelectedEncoder,"|-","");
        strSelectedEncoder=replace(strSelectedEncoder,"|Kauf","");
    
        var strSelect="SELECT DISTINCT SELECTED_ENCODER FROM GEBER_CONSEQUENCE WHERE GEBER ='"+strSelectedEncoder+"' ";
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        if(aResult.length==1)
            ECL_SetValue("ECSI_CC_SelectedEncoder", aResult[0].SELECTED_ENCODER);
    }
    else
        ECL_SetValue("ECSI_CC_SelectedEncoder", "0");
        
    */

    //Consequence für Abtriebswellendichtung	
    var strAbtriebswellendichtung=ECL_GetValue("ABTRIEBSWELLENABDICHTUNG_2KJ4");
    var Abtriebswellenabdichtung_Consequence="-";
    
    if(strAbtriebswellendichtung=="Standardabdichtung")
        Abtriebswellenabdichtung_Consequence="0";
    else if(strAbtriebswellendichtung=="Dichtung laengere Lebensdauer")
        Abtriebswellenabdichtung_Consequence="1";
    else if(strAbtriebswellendichtung=="Dichtung erhoehte Belastung")
        Abtriebswellenabdichtung_Consequence="2";
    else if(strAbtriebswellendichtung=="Hochtemperaturfest")
        Abtriebswellenabdichtung_Consequence="3";
    else
        Abtriebswellenabdichtung_Consequence="";
        
    ECL_SetValue("ECSI_CC_OutputShaftSealing", Abtriebswellenabdichtung_Consequence);
    
    logtraceln("ECSI_CC_OutputShaftSealing:"+Abtriebswellenabdichtung_Consequence);
    
    
    //Drive Train
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION_2KJ4", "T"))
        ECL_SetValue("ECSI_CC_IsDriveTrain","True");
    else
        ECL_SetValue("ECSI_CC_IsDriveTrain","False");
    
    
}

function Bestimme_Consequences_AdapterID(oDataGear)
{
    //Bestimmung der Adapter ID aus der Tabelle TE_M_Adapter
    
    var strMLFB = ECL_GetValue("ECSI_MLFB");
    
    var strSearchString="2KJ4...."+strMLFB.substring( 8, 12 )+"....";

    // KU Adapter Options

    var strShortDescriptions = "";
     if (ECL_ValueSelected("ANTRIEBSGRUPPE_TYP_2KJ4", "KU")) {

        if (ECL_GetValue("ANTRIEBSGRUPPE_LAGERUNG_2KJ4") == "Zylinderrollenlager") {
            strShortDescriptions = strShortDescriptions + "A30 ";
        }

        if (ECL_GetValue("ANTRIEBSGRUPPE_DICHTUNG_2KJ4") == "FKM") {
            strShortDescriptions = strShortDescriptions + "A35";
        }
        else if (ECL_GetValue("ANTRIEBSGRUPPE_DICHTUNG_2KJ4") == "MSS1-HS") {
            strShortDescriptions = strShortDescriptions + "A36";
        }

        strShortDescriptions = strShortDescriptions.trim();
    }

    var strSelect = "SELECT DISTINCT SZ_MA_ID FROM TE_M_ADAPTER WHERE SZ_MA_OrderNumber='" + strSearchString + "' ";

    if (strShortDescriptions != "") {
        strSelect = strSelect + "AND SZ_MA_ShortOptions='" + strShortDescriptions + "' ";
    }
    else {
        strSelect = strSelect + "AND SZ_MA_ShortOptions='' ";
    }

    var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
    if (aResult.length == 1) {
        ECL_SetValue("ECSI_CC_SelectedGearboxAdapterID", aResult[0].SZ_MA_ID);
        logtraceln("AdapterID=" + aResult[0].SZ_MA_ID);
    }
    else
        logtraceln("Fehler bei der Bestimmung der MotorConsequences AdapterID!, SQL="+strSelect);

    // additional consequences for adapters:
    if ((ECL_GetValue("ECSI_CX_MinimalExplosionProtectionGas")!="" || ECL_GetValue("ECSI_CX_MinimalExplosionProtectionDust")!="") && ECL_ValueSelected("ANTRIEBSGRUPPE_TYP_2KJ4", "KU"))
    {
        if( ECL_ValueSelected("ANTRIEBSGRUPPE_LAGERUNG_2KJ4", "Zylinderrollenlager"))
        {
            ECL_SetValue("ECSI_CC_MaxRotationSpeedLimit","2000");
            logtraceln("ECSI_CC_MaxRotationSpeedLimit=2000");
        }

    }  
}

function checkMLFBforWarningMessage(strMLFB)
{
    if(ECL_ValueSelected ("ECSI_STATUS", "E"))
    {
        return;
    }
    
    strMLFB=strMLFB.replace("-","");
    var strRegEx="2KJ4{1;2}03?G?{21;22;23;32;33;73}{4;9}???"
    
    if(EK_regFound(strMLFB, strRegEx))
    {
        ECL_SelectValue("ECSI_STATUS", "WARNING");
        ECL_SetValue("ECSI_STATUS_MESSAGE", translate("WARNINGMSG___MLFB_PM400"));
    }
    
    return;
}

function EK_regPrep(s_src)
{
    var s=s_src.replace("?", ".");
    s=s.replace("{", "(");
    s=s.replace("}", ")");
    s=s.replace(";", "|");
    return s;
}

function EK_regFound(s_src, s_reg)
{
    var regEx = new RegExp(EK_regPrep(s_reg));
    
    if(s_src && s_src !="")
    {
        var aM = s_src.match(regEx);
        if(aM == null)
            return false;
        if(aM.length == 0)
            return false;
        return true;
    }
    
    return false;
}
