//@legacy
//#mode(full-ecma)

//@import "2KJ8_CONFIG/VT_TF.js"

//@import "2KJ8_CONFIG/CFG_2KJ_BAUFORM.js"

//@import "2KJ8_CONFIG/CFG_2KJ_BEFESTIGUNG.js"

//@import "2KJ8_CONFIG/CFG_2KJ_GETRIEBE_OPTIONEN.js"

//@import "2KJ8_CONFIG/CFG_2KJ_ELEKTRISCHE_AUSFUEHRUNG.js"

//@import "2KJ8_CONFIG/CFG_2KJ_MECHANISCHE_AUSFUEHRUNG.js"

//@import "2KJ8_CONFIG/CFG_2KJ_UMRICHTER.js"

//@import "2KJ8_CONFIG/CFG_2KJ_BREMSE.js"

//@import "2KJ8_CONFIG/CFG_2KJ_MOTOR_ZUSATZOPTIONEN.js"

//@import "2KJ8_CONFIG/CFG_2KJ_ENVIRONMENT.js"

//@import "2KJ8_CONFIG/CFG_2KJ_KONSERVIERUNG.js"

//@import "2KJ8_CONFIG/CFG_2KJ_DOKUMENTATION.js"

//@import "2KJ8_CONFIG/CFG_2KJ_SPEZIFIKATION.js"


//@import "2KJ8_MLFB/MLFB.MOTOX.construct.js"

//@import "2KJ8_PARSER/Parser.MOTOX.parse.js"

//@import "2KJ8_PARSER/Parser.common.js"

//@import "2KJ8_PARSER/Parser.tokenizer.js"

//@import "2KJ8_CONFIG/CFG_2KJ_CHECKS_DEFAULTS.js"


//@import "SIZER_general_functions.js"

globalThis.OnChangeConfiguration = function main()
{
    var strchangedAttribute = ECL_GetCurrentAttribute();
    logtraceln("Changed Attribute="+strchangedAttribute);
    
    if(strchangedAttribute.left(7) == "ECSI_CX")
        return;
    
    var vtTimeConfigStart	= Date.getTime();
    ECL_SetValue ("ECSI_2KJ_MODE_2KJ8", "SIZER_CONFIG");
    logtraceln("MODE="+ECL_GetValue ("ECSI_2KJ_MODE_2KJ8"));
    
    ECL_DisableAttribute("ECSI_TYPBEZEICHNUNG_2KJ8");
    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");
    
    var oDataGear = {};
    oDataGear.oInfo = {};
    oDataGear.oRow = {};
    
    var oDataBremse = {};
    oDataBremse.oInfo = {};
    oDataBremse.oRow = {};
    
    //Initialisierung
    if(ECL_GetCurrentAttribute() === "@INIT@")
    {
        ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
        
        /* wird nicht gebraucht, kann gelöscht werden (TODO)
        ECL_ExpandAttributeGroup("CFG_GROUP___BAUFORM");
        ECL_ExpandAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
        ECL_ExpandAttributeGroup("CFG_GROUP___BEFESTIGUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
        ECL_ExpandAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
        ECL_ExpandAttributeGroup("CFG_GROUP___SPEZIFIKATION");
        ECL_ExpandAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___G115D");
        ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2");
        ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE_SIZER");
        ECL_ExpandAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
        ECL_ExpandAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
        ECL_ExpandAttributeGroup("CFG_GROUP___KONSERVIERUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
        ECL_ExpandAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
        ECL_ExpandAttributeGroup("CFG_GROUP___DOKUMENTATION");
        ECL_ExpandAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
        */
        
        ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
        ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
        ECL_DeactivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___G115D");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
        ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE_SIZER");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
        ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
        ECL_DeactivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
        ECL_DeactivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
        ECL_DeactivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
        ECL_DeactivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
        
        ECL_DeactivateAttribute("MIT_BREMSE_2KJ8");
        
        //Setzen der Default Werte der Vorauswahl
    }

    if(strchangedAttribute == "ECSI_MLFB_SEC")
    {
        //Secondary MLFB Handling for old Firmware version
        
        var strMLFB_SEC = GetMlfbSec();

        if(strMLFB_SEC!="")
        {
            handle_MLFB_SEC_Parsing(strMLFB_SEC);
        }

    }
    
    if(strchangedAttribute == "ECSI_MLFB")
    {
        
        //alle Daten aus dem SIZER werden in ein Attribut als JSON geladen und dann wieder in einzelne Attribute umgesetzt
        ///
        
        SetAttributesFromMlfb();
        
            
        //Test MLFB's
        /*
        //D39
        2KJ82032GB..4.K1
        2KJ82032GB004FK1-Z D01+H31+K01+K06+K97+L00+M55+V02

        2KJ82072JB..3.B1
        2KJ84044GC..4.C1
        2KJ84042EG..5.D1
        2KJ82052EG..5.G1
        2KJ80024LC..3.L1

        2KJ82032CG..4.K1  / Neu IE3
        
        2KJ80012LB..1.B1
        2KJ85572EA..0.A1
        
        2KJ81012CF..3.B1
        2KJ81012CF003FB1-Z D01+H31+K01+K08+L00+M55+V02
        
        2KJ8205-2EG..4.B1
        2KJ8205-2EG00-4GB1-Z D01 +H05 +H31 +H74 +K01 +K08 +L02 +L75 +M55 +V10
        2KJ8205-2EG00-4GB1-Z D01 +H05 +H31 +H74 +K01 +K06 +L02 +L75 +M55 +V10
        
        Wand Montiert
        2KJ84052GB..0.H1
        
        2KJ8202-2EG00-3DA1-Z D01+H31+K01+K06+L00+M55+V02
        2KJ8202-2EG00-3GA1-Z D01+H31+K01+K06+L00+M55+V14
        
        2KJ80012GF..5.R1

        2KJ85022EA115GQ1-Z C02+C27+D11+H53+H72+K01+K07+K41+L02+L75+M63+V22+V81
        2KJ85022EA..5.Q1
        
        
        */
        var strMLFB_for_Parser = ECL_GetValue("ECSI_MLFB");
        if(strMLFB_for_Parser != "")
        {	
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___G115D");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE_SIZER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
            ECL_DeactivateAttributeGroup("CFG_GROUP___AMBIENT_TEMPERATURE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
            
            ECL_DeactivateAttribute("MIT_BREMSE_2KJ8");
            
            var oParse = parse_init(strMLFB_for_Parser , "", true );

            var strMLFB_SEC = GetMlfbSec();
            var bParseMLFB_SEC = handle_MLFB_SEC_Parsing(strMLFB_SEC);
        
            if(oParse.strError == "" && bParseMLFB_SEC)
            {
    
                ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "true");
                
                var bRet = parseSetValues(oParse, true);
                
                oDataGear.oRow = bRet.GearData.oRow;
                oDataBremse.oRow = bRet.BrakeData.oRow;
                
                var strRetContextValue="";
                if(find(strMLFB_for_Parser.left(16),".") >= 0)
                {
                    var strRetContextValue=checkContextValues(oDataGear, false);
                }
                else
                {
                    var strRetContextValue=checkContextValues(oDataGear, true);
                }
            
                if(strRetContextValue!="")
                {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(strRetContextValue));
                }
                else
                {
                
                    //Bei erfolgter Suche werden die Optionen aufgerufen
                    //Hier erst die Initialisierung
                    
                    _2KJ8_config_Init(strchangedAttribute, oDataGear, oDataBremse);
                    
                    //MLFB bestimmen
                    var vtTimeMLFBStart	= Date.getTime();
                    var oMLFB = buildFormattedMLFB( oDataGear, true);
                    var vtTimeMLFBStop	= Date.getTime();
                    var vtMLFBTime		= (vtTimeMLFBStop - vtTimeMLFBStart) / 1000;
                    logtraceln("******* MLFB generate - Time: "+vtMLFBTime+" sec"+"\n");
                    
                    
                    checkMLFBandConfiguration(oMLFB);
                    

                    //MLFB generieren
                    var strMLFB="";
                    if(oMLFB.strFormattedShortDescriptions!="")
                        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
                    else
                        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");
                    
                    ECL_SetValue("ECSI_MLFB",strMLFB);
                    logtraceln("MLFB="+strMLFB);
                    
                    var JSON_oDataGear = JSON.stringify(oDataGear);
                    ECL_SetValue("ECSI_GEARDATA_2KJ8",JSON_oDataGear);
                    
                    var JSON_oDataBremse = JSON.stringify(oDataBremse);
                    ECL_SetValue("ECSI_BRAKEDATA_2KJ8",JSON_oDataBremse);
                }
            }
            else
            {
                if(!bParseMLFB_SEC)
                {
                    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___2KJ8_MLFB_SEC_CHAR_INVALID"));
                    ECL_SelectValue ("ECSI_STATUS", "E");
                }
                else
                {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(oParse.strError));
                }
            }
        }
        else if(strMLFB_for_Parser != "" && ECL_GetValue ("ECSI_STATUS_MESSAGE") == "")
        {	
            ECL_DeactivateAttributeGroup("CFG_GROUP___VORAUSWAHL");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SUCHE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___G115D");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE_SIZER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
            ECL_DeactivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
            ECL_DeactivateAttributeGroup("CFG_GROUP___AMBIENT_TEMPERATURE");
            ECL_DeactivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
            ECL_DeactivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
            ECL_DeactivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
            ECL_DeactivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
            
            ECL_DeactivateAttribute("MIT_BREMSE_2KJ8");
                    
            var JSON_oDataGear = ECL_GetValue ("ECSI_GEARDATA_2KJ8");
            var JSON_oDataBremse = ECL_GetValue ("ECSI_BRAKEDATA_2KJ8");
            
            if(JSON_oDataGear)
            {
                oDataGear = JSON.parse(JSON_oDataGear);
                oDataBremse = JSON.parse(JSON_oDataBremse);
            }
            else
            {
                var strMLFB_for_Parser = ECL_GetValue("ECSI_MLFB");
                if(strMLFB_for_Parser != "")
                {	
                    var oParse = parse_init(strMLFB_for_Parser , "", true );
                    
                    var strMLFB_SEC = GetMlfbSec();
                    var bParseMLFB_SEC = handle_MLFB_SEC_Parsing(strMLFB_SEC);
                    
                    var bRet = parseSetValues(oParse, false);
                    
                    if(oParse.strError == "" && bParseMLFB_SEC)
                    {
                        ECL_SelectValue ("ECSI_STATUS", "OK");
                    }
                    else
                    {
                        if(!bParseMLFB_SEC)
                        {
                            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___2KJ8_MLFB_SEC_CHAR_INVALID"));
                            ECL_SelectValue ("ECSI_STATUS", "E");
                        }
                        else
                        {
                            ECL_SelectValue ("ECSI_STATUS", "E");
                            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(oParse.strError));
                        }
                    }
            
                    oDataGear.oRow = bRet.GearData.oRow;
                    oDataBremse.oRow = bRet.BrakeData.oRow;
                }
            }
            
            _2KJ8_config_Init(strchangedAttribute, oDataGear, oDataBremse);
            
            //MLFB bestimmen
            var vtTimeMLFBStart	= Date.getTime();
            var oMLFB = buildFormattedMLFB( oDataGear, true);
            var vtTimeMLFBStop	= Date.getTime();
            var vtMLFBTime		= (vtTimeMLFBStop - vtTimeMLFBStart) / 1000;
            logtraceln("******* MLFB generate - Time: "+vtMLFBTime+" sec"+"\n");
            
            checkMLFBandConfiguration(oMLFB);
            
            //MLFB generieren
            var strMLFB="";
            if(oMLFB.strFormattedShortDescriptions!="")
                strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
            else
                strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");
                
            ECL_SetValue("ECSI_MLFB",strMLFB);
            logtraceln("MLFB="+strMLFB);
            
            var JSON_oDataGear = JSON.stringify(oDataGear);
            ECL_SetValue("ECSI_GEARDATA_2KJ8",JSON_oDataGear);
            
            var JSON_oDataBremse = JSON.stringify(oDataBremse);
            ECL_SetValue("ECSI_BRAKEDATA_2KJ8",JSON_oDataBremse);
        }
        else
        {
            var JSON_oDataGear = ECL_GetValue ("ECSI_GEARDATA_2KJ8");
            var JSON_oDataBremse = ECL_GetValue ("ECSI_BRAKEDATA_2KJ8");
            
            if(JSON_oDataGear)
            {
                oDataGear = JSON.parse(JSON_oDataGear);
                oDataBremse = JSON.parse(JSON_oDataBremse);
            
            
                if(ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
                {		
                    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
                    {
                        ECL_ActivateAttribute("BREMSENTYP_2KJ8");
                        //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht unterstützt
                    }
                }
                
                var JSON_oDataGear = JSON.stringify(oDataGear);
                ECL_SetValue("ECSI_GEARDATA_2KJ8",JSON_oDataGear);
                
                var JSON_oDataBremse = JSON.stringify(oDataBremse);
                ECL_SetValue("ECSI_BRAKEDATA_2KJ8",JSON_oDataBremse);
            }
        }
    }
    
    if(strchangedAttribute != "ECSI_MLFB" && ECL_GetValue ("ECSI_CFG_INIT_OPTIONS") == "true")
    {
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
        {
            var JSON_oDataGear = ECL_GetValue ("ECSI_GEARDATA_2KJ8");
            var JSON_oDataBremse = ECL_GetValue ("ECSI_BRAKEDATA_2KJ8");
            
            if(JSON_oDataGear)
            {
                oDataGear = JSON.parse(JSON_oDataGear);
                oDataBremse = JSON.parse(JSON_oDataBremse);
            }
            else
            {
                var strMLFB_for_Parser = ECL_GetValue("ECSI_MLFB");
                if(strMLFB_for_Parser != "")
                {	
                    var oParse = parse_init(strMLFB_for_Parser , "", true );

                    var strMLFB_SEC = GetMlfbSec();
                    var bParseMLFB_SEC = handle_MLFB_SEC_Parsing(strMLFB_SEC);
                   
                    var bRet = parseSetValues(oParse, false);
                    
                    if(oParse.strError == "" && bParseMLFB_SEC)
                    {
                        ECL_SelectValue ("ECSI_STATUS", "OK");
                    }
                    else
                    {
                        if(!bParseMLFB_SEC)
                        {
                            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___2KJ8_MLFB_SEC_CHAR_INVALID"));
                            ECL_SelectValue ("ECSI_STATUS", "E");
                        }
                        else
                        {
                            ECL_SelectValue ("ECSI_STATUS", "E");
                            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(oParse.strError));
                        }
                    }
            
                    oDataGear.oRow = bRet.GearData.oRow;
                    oDataBremse.oRow = bRet.BrakeData.oRow;
                }
            }
            
            _2KJ8_config(strchangedAttribute, oDataGear, oDataBremse);
        }
    }

    var vtTimeConfigStop	= Date.getTime();
    var vtConfigTime		= (vtTimeConfigStop - vtTimeConfigStart) / 1000;
    logtraceln("******* Configuration - Time: "+vtConfigTime+" sec"+"\n");
    logtraceln("ERROR: "+ECL_GetValue("ECSI_STATUS_MESSAGE")); 
}

function _2KJ8_config(strchangedAttribute, oDataGear, oDataBremse)
{
    
    SetBauform(strchangedAttribute,oDataGear);
    SetBefestigung(strchangedAttribute,oDataGear);
    SetGetriebeOptionen(strchangedAttribute,oDataGear);
    
    if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ8") == "GETRIEBEMOTOR")
    {
        setSpezifikation_SIZER(strchangedAttribute,oDataGear);
        SetElektrischeAusfuehrung(strchangedAttribute,oDataGear);
        SetMechanischeAusfuehrung(strchangedAttribute,oDataGear,oDataBremse);
        SetUmrichter(strchangedAttribute,oDataGear,oDataBremse);
        
        if(ECL_ValueSelected("MIT_BREMSE_2KJ8", "T") && strchangedAttribute == "BREMSENTYP_2KJ8")
        {
            if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
            {
                ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht unterstützt
                
                SetBremse_InitOptions(strchangedAttribute,oDataGear,oDataBremse);
            }
        }
        else if(ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
        {
            
            if(strchangedAttribute == "MIT_BREMSE_2KJ8")
            {
                if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
                {
                    ECL_ActivateAttribute("BREMSENTYP_2KJ8");
                    SetBremse_Init_Sizer(oDataGear);
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                    //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht unterstützt
                    
                    SetBremse_InitOptions(strchangedAttribute,oDataGear,oDataBremse);
                }
            }
            else
            {
                if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
                {
                    ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
                    //ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht unterstützt
                    SetBremse(strchangedAttribute,oDataGear,oDataBremse);
                }
            }
        }
        else if(!ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
        {
            if(strchangedAttribute=="SCHUTZART")
                SetBremse_Init(strchangedAttribute,oDataGear)
            
            ECL_DeactivateAttribute("BREMSENTYP_2KJ8");
            ECL_DeactivateAttributeGroup("CFG_GROUP___BREMSE2");
            ECL_CollapseAttributeGroup("CFG_GROUP___BREMSE2");
        }
        
        SetMotor_Zusatzoptionen(strchangedAttribute,oDataGear);
    }

    SetEnvironment(strchangedAttribute,oDataGear);
    SetKonservierung(strchangedAttribute,oDataGear);
    SetDokumentation(strchangedAttribute,oDataGear);
    
    // geschweifte Klammer entfernen.
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8"),20));
    
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8"),20));
    
    //MLFB bestimmen
    var vtTimeMLFBStart	= Date.getTime();
    var oMLFB = buildFormattedMLFB( oDataGear, true);
    var vtTimeMLFBStop	= Date.getTime();
    var vtMLFBTime		= (vtTimeMLFBStop - vtTimeMLFBStart) / 1000;
    logtraceln("******* MLFB generate - Time: "+vtMLFBTime+" sec"+"\n");
    
    checkMLFBandConfiguration(oMLFB);
    
    //MLFB generieren
    var strMLFB="";
    if(oMLFB.strFormattedShortDescriptions!="")
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
    else
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");

    ECL_SetValue("ECSI_MLFB",strMLFB);
    
    logtraceln("MLFB="+strMLFB);

    handle_MLFB_SEC_Generating();
    
    Bestimme_Consequences_AdditionalInertia(oDataGear,oDataBremse);

    var strGetriebemotorbezeichnung=BestimmeGetriebemotorbezeichnung(oDataGear,oDataBremse);
    logtraceln("Getriebemotor="+strGetriebemotorbezeichnung);
    ECL_SetValue("ECSI_TYPBEZEICHNUNG_2KJ8",strGetriebemotorbezeichnung+", "+oDataGear.oRow.LEISTUNG+" kW");
    ECL_SetValue("ECSI_CC_GearboxShortDescription",strGetriebemotorbezeichnung);
    
    var G115DMLFB=generateG115DMLFB(oDataGear);
    ECL_SetValue("ECSI_CC_FrequencyConverter",G115DMLFB);
    logtraceln("G115D MLFB="+G115DMLFB);
    
    var JSON_oDataGear = JSON.stringify(oDataGear);
    ECL_SetValue("ECSI_GEARDATA_2KJ8",JSON_oDataGear);
    
    var JSON_oDataBremse = JSON.stringify(oDataBremse);
    ECL_SetValue("ECSI_BRAKEDATA_2KJ8",JSON_oDataBremse);
    
    //ProcessCancellationToken();
}

function _2KJ8_config_Init(strchangedAttribute, oDataGear, oDataBremse)
{
    setDefaultValues(oDataGear);
    

    ECL_ActivateAttributeGroup("CFG_GROUP___BAUFORM");
    ECL_ActivateAttributeGroup("CFG_GROUP___BAUFORM_VISIBLE");
    ECL_ActivateAttributeGroup("CFG_GROUP___BEFESTIGUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_ABTRIEBSWELLENLAGERUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_SCHMIERUNG_DICHTUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_BELUEFTUNG_OELSTANDSKONTROLLE");
    ECL_ActivateAttributeGroup("CFG_GROUP___GEAR_OPTIONS");
    

    if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ8") == "GETRIEBEMOTOR")
    {
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
            ECL_ActivateAttributeGroup("CFG_GROUP___SPEZIFIKATION");
    
        ECL_ActivateAttributeGroup("CFG_GROUP___ELEKTRISCHE_AUSFUEHRUNG");
        ECL_ActivateAttributeGroup("CFG_GROUP___MECHANISCHE_AUSFUEHRUNG");
        ECL_ActivateAttributeGroup("CFG_GROUP___G115D");
    
        ECL_ActivateAttribute("MIT_BREMSE_2KJ8");
    }
    
    SetBauform_Init(strchangedAttribute,oDataGear);
    SetBefestigung_Init(strchangedAttribute,oDataGear);
    SetGetriebeOptionen_Init(strchangedAttribute,oDataGear);
    

    if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ8") == "GETRIEBEMOTOR")
    {
        setSpezifikation_SIZER(strchangedAttribute,oDataGear);
        SetElektrischeAusfuehrung_Init(strchangedAttribute,oDataGear);
        SetMechanischeAusfuehrung_Init(strchangedAttribute,oDataGear,oDataBremse);
        SetUmrichter_Init(strchangedAttribute,oDataGear,oDataBremse);
        SetBremse_Init(strchangedAttribute,oDataGear);

        if(ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
        {		
            if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
            {
                ECL_ActivateAttribute("BREMSENTYP_2KJ8");
                SetBremse_Init_Sizer(oDataGear);
                ECL_ActivateAttributeGroup("CFG_GROUP___BREMSE2");
               // ECL_ExpandAttributeGroup("CFG_GROUP___BREMSE2"); wird nicht unterstützt
                
                SetBremse_InitOptions(strchangedAttribute,oDataGear,oDataBremse);
            }
        }
        
        ECL_ActivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN");
        ECL_ActivateAttributeGroup("CFG_GROUP___ZUS_MOTOROPTIONEN_UMWELT");
    
        SetMotor_Zusatzoptionen_Init(strchangedAttribute,oDataGear);
        
    }
    
    ECL_ActivateAttributeGroup("CFG_GROUP___AMBIENT_TEMPERATURE");
    ECL_ActivateAttributeGroup("CFG_GROUP___KONSERVIERUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___LEISTUNGSSCHILD");
    ECL_ActivateAttributeGroup("CFG_GROUP___LIEFERUNG_VERPACKUNG");
    ECL_ActivateAttributeGroup("CFG_GROUP___DOKUMENTATION");
    ECL_ActivateAttributeGroup("CFG_GROUP___SCHNELLSCHIENE");
    
    SetEnvironment_Init(strchangedAttribute,oDataGear);
    SetKonservierung_Init(strchangedAttribute,oDataGear);
    SetDokumentation_Init(strchangedAttribute,oDataGear);
    
    
    // geschweifte Klammer entfernen.
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8"),20));
    
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8"),"}",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8"),"{",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8",replace(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8"),"*",""));
    ECL_SetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8",left(ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8"),20));

    //MLFB bestimmen
    var vtTimeMLFBStart	= Date.getTime();
    var oMLFB = buildFormattedMLFB( oDataGear, true);
    var vtTimeMLFBStop	= Date.getTime();
    var vtMLFBTime		= (vtTimeMLFBStop - vtTimeMLFBStart) / 1000;
    logtraceln("******* MLFB generate - Time: "+vtMLFBTime+" sec"+"\n");
    
    checkMLFBandConfiguration(oMLFB);
    
    //MLFB generieren
    var strMLFB="";
    if(oMLFB.strFormattedShortDescriptions!="")
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+ replace(oMLFB.strStrippedShortDescriptions," ","")+" "+oMLFB.strFormattedShortDescriptions;
    else
        strMLFB = replace(oMLFB.strBaseMLFB,"-","")+"-Z "+replace(oMLFB.strStrippedShortDescriptions," ","");

    ECL_SetValue("ECSI_MLFB",strMLFB);
    
    logtraceln("MLFB="+strMLFB);

    handle_MLFB_SEC_Generating();
    
    Bestimme_Consequences_AdditionalInertia(oDataGear,oDataBremse);
    
    var strGetriebemotorbezeichnung=BestimmeGetriebemotorbezeichnung(oDataGear,oDataBremse);
    logtraceln("Getriebemotor="+strGetriebemotorbezeichnung);
    ECL_SetValue("ECSI_TYPBEZEICHNUNG_2KJ8",strGetriebemotorbezeichnung+", "+oDataGear.oRow.LEISTUNG+" kW");
    ECL_SetValue("ECSI_CC_GearboxShortDescription",strGetriebemotorbezeichnung);
    
    var G115DMLFB=generateG115DMLFB(oDataGear);
    ECL_SetValue("ECSI_CC_FrequencyConverter",G115DMLFB);
    logtraceln("G115D MLFB="+G115DMLFB);
    
    var JSON_oDataGear = JSON.stringify(oDataGear);
    ECL_SetValue("ECSI_GEARDATA_2KJ8",JSON_oDataGear);
    
    var JSON_oDataBremse = JSON.stringify(oDataBremse);
    ECL_SetValue("ECSI_BRAKEDATA_2KJ8",JSON_oDataBremse);
}

function Bestimme_Consequences_AdditionalInertia(oData,oDataBremse)
{
    //Consequences für Getriebe
    BestimmeGetriebeConsequences(oData);
    
    //Bei Schwungradlüfter Zusatz-Trägheitsmoment ausgeben
    var dAdditionalIneriaVentilation=0;
    
    var strBelueftung=ECL_GetValue("BELUEFTUNG_2KJ8");
    if(strBelueftung=="Schwungradluefter")
    {
        var strSelect = "SELECT DISTINCT BEL_J FROM MOLUEFTER WHERE ";
        strSelect = strSelect + "MOLUEFTER.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
        strSelect = strSelect + "MOLUEFTER.MOBSANB = '"+Bestimme_MobsAnb(oData)+"' AND ";
        strSelect = strSelect + "MOLUEFTER.REGION = 'S' AND ";
        
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
        {
            //Abfrage Temperatur
            strSelect = strSelect + "CAST(MOLUEFTER.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
        }
        
        
        strSelect = strSelect + "MOLUEFTER.BELLUEFT = 'Schwungradluefter' AND ";
        
        
        //Unterscheidung Großmotor oder Normalmotor
        strSelect = strSelect + "MOLUEFTER.M3 = '"+oData.oRow.M3+"' ";
        strSelect = strSelect + "AND MOLUEFTER.GM3 = '"+oData.oRow.GM3+"' ";
        
        //MOTYPX_UNDEF mit abfragen
        var strMOABSSART = "BK4";
        if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
            strMOABSSART = "Z19";
        
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        
        if(aResult.length==1)
        {
            dAdditionalIneriaVentilation=parseFloat(aResult[0].BEL_J);
        }
        else
            logtraceln("Fehler bei Bestimmung additional Intertia Befüftungsart!, SQL="+strSelect);
    }
    
    //Bremsen Consequences
    if(ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
    {
        var strBremse= oDataBremse.oRow.BREART;
        if ( oDataBremse.oRow.BREART === 'FDX' )
        {
            if(oDataBremse.oRow.BRENENMO == "500")
                strBremse = strBremse+"30"+"/"+oDataBremse.oRow.BREREDMO;
            else if(strNominalTorque == "1000")
                strBremse = strBremse+"40"+"/"+oDataBremse.oRow.BREREDMO;
        }
        else if(oDataBremse.oRow.BREREDMO == "-")
        {	
            strBremse = strBremse+oDataBremse.oRow.BRENENMO+"/"+oDataBremse.oRow.BRENENMO;
        }
        else
            strBremse = strBremse+oDataBremse.oRow.BRENENMO+"/"+oDataBremse.oRow.BREREDMO;
            
        strBremse = replace(strBremse,".",",");
        
        var strSelect= "SELECT SZ_MB_BrakeId FROM MotorMechanicalBrakes_NEW WHERE SZ_MB_Name='"+strBremse+"' ";
                    
        //BrakeID generieren aus SIZER Table und zurückliefern
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        if(aResult.length == 1)
        {
            //var strBrakeID=aResult[0].SZ_MB_M_ORDERNUMBER+"|"+aResult[0].SZ_MB_M_SHORTOPTIONS+"|"+aResult[0].SZ_MB_ARTICLENUMBER+"|"+aResult[0].SZ_MB_SHORTOPTIONS+"|"+aResult[0].SZ_MB_NAME;
            ECL_SetValue("ECSI_CC_BrakeID", aResult[0].SZ_MB_BRAKEID);
            logtraceln("BrakeID="+aResult[0].SZ_MB_BRAKEID);
        }
        else
        {
            logtraceln("Fehler bei der Bestimmung der MotorConsequences BremsenID!, SQL="+strSelect);
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERRORMSG_2KJ___BRAKEID"));
        }
    }
    else
    {
        ECL_SetValue("ECSI_CC_BrakeID", "");
    }
    
    var AdditionalInertia=dAdditionalIneriaVentilation;
    logtraceln("Additional Inertia="+AdditionalInertia);

    ECL_SetValue("ECSI_CC_AdditionalInertia", AdditionalInertia);
    logtraceln("Zusatzträgheitsmoment:"+AdditionalInertia);
    
    //Consequence für Geber
    //ECL_SetValue("ECSI_CC_SelectedEncoder", "False");
        
        
    //Consequence für Abtriebswellendichtung	
    var strAbtriebswellendichtung=ECL_GetValue("ABTRIEBSWELLENABDICHTUNG_2KJ8");
    var Abtriebswellenabdichtung_Consequence="-";
    
    if(strAbtriebswellendichtung=="Standardabdichtung")
        Abtriebswellenabdichtung_Consequence="0";
    else if(strAbtriebswellendichtung=="Dichtung laengere Lebensdauer")
        Abtriebswellenabdichtung_Consequence="1";
    else if(strAbtriebswellendichtung=="Dichtung erhoehte Belastung")
        Abtriebswellenabdichtung_Consequence="2";
    else if(strAbtriebswellendichtung=="Hochtemperaturfest")
        Abtriebswellenabdichtung_Consequence="3";
    else
        Abtriebswellenabdichtung_Consequence="";
        
    ECL_SetValue("ECSI_CC_OutputShaftSealing", Abtriebswellenabdichtung_Consequence);
    
    logtraceln("ECSI_CC_OutputShaftSealing:"+Abtriebswellenabdichtung_Consequence);
}

function  handle_MLFB_SEC_Parsing(secondaryMlfbs)
{
    // MLFB_SEC Handling
   
   if(secondaryMlfbs == "")
    return true;

   secondaryMlfbs = trimright(secondaryMlfbs,";");
    
   var aSecondaryMlfb = secondaryMlfbs.split(";");
   var aSecondaryMlfbClean = [];
   
   for (var i = 0; aSecondaryMlfb && i < aSecondaryMlfb.length; i++)
   {
       // MLFB vereinheitlichen
       secondaryMlfb = aSecondaryMlfb[i].toUpperCase().replace("-Z", "");
       secondaryMlfb = secondaryMlfb.replace("-", "");
       
       // MLFB auf unzulssige Zeichen berprfen
       var illegalChars = secondaryMlfb.match(/[^a-zA-Z0-9.]/g);
       
       // MLFB-Fehler diagnostizieren & ausgeben
       if (illegalChars && illegalChars.length > 1)
       {
           return false;
       }
       
       aSecondaryMlfbClean.push(secondaryMlfb);

        // nur eine MLFB Sec erlaubt
       if(aSecondaryMlfbClean.length > 1)
            return false;
   }

   for (var i = 0; aSecondaryMlfbClean && i < aSecondaryMlfbClean.length; i++)
   {
        if(aSecondaryMlfb[i]=="6SL30547TG002BA0")
        {
            ECL_SetValue("G115_ADD_SPEICHERKARTE_2KJ8","VERSION_4_7_SP13");
        }
        else
        {
            return false;
        }
        
   }

   return true;

}

function  handle_MLFB_SEC_Generating()
{
    // MLFB_SEC Handling
    
    var strMLFB_SEC= "";
    
    if(ECL_ValueSelected( "G115_ADD_SPEICHERKARTE_2KJ8","VERSION_4_7_SP13"))
    {
        strMLFB_SEC="6SL30547TG002BA0";
    }
    
    SetMlfbSec(strMLFB_SEC);
}

