//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_ET200
// 	Date: 2019-10-01
// 	User: Administrator
// ---------------------------------------------------------
//#mode(full-ecma)


                     // easyKAT Configuration Library
//@import "SIZER_general_functions.js"
 // SIZER Function Library
//@import "SIZER_simplecfg_utils.js"
   // SIZER Utility Class

globalThis.OnChangeConfiguration = function main()
{
    // Derive evaluation of ECSI attributes from primary MLFB
    SetAttributesFromMlfb();
    
    var currentAttribute = ECL_GetCurrentAttribute();
    var secondaryMlfbs   = GetMlfbSec();
    
    // Suppress "dummy" calls of SIZER
    if (currentAttribute == '')
        return;
    
    // Set default for SD card
    ECL_SelectValueDefault("A_SD_CARD_ET200", "00001");
    ECL_DeactivateAttribute("A_FIRMWARE_ET200");
    
    // Process secondary MLFB (in case of undo of validity check in SIZER is performed)
    // Important: Only do this step when primary MLFB got passed from SIZER
    if (currentAttribute == "ECSI_MLFB" && secondaryMlfbs)
    {
        var secondaryMlfb = secondaryMlfbs.split(";");
        
        // Select SD card attribute
        if (secondaryMlfb[0] == "6SL30544AG002AA0")
        {
            ECL_SelectValue("A_SD_CARD_ET200", "00234");
        } else if (secondaryMlfb[0] == "6SL30547TH002BA0") {
            ECL_SelectValue("A_SD_CARD_ET200", "00235");
            ECL_SelectValue("A_FIRMWARE_ET200", "VERSION_4_7_SP14");
        }
        // Or cancel further processing in case of invalid secondary MLFB
        else
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___ET200_MLFB_SEC_CHAR_INVALID"));
            return;
        }
    }
    
    // Set secondary MLFB for SD card (if selected)
    if (ECL_GetValue("A_SD_CARD_ET200") == "00234")
    {
        SetMlfbSec("6SL30544AG002AA0");
    } else if (ECL_GetValue("A_SD_CARD_ET200") == "00235") {
        ECL_ActivateAttribute("A_FIRMWARE_ET200");
        ECL_SelectValue("A_FIRMWARE_ET200", getLatestFirmwareVersion());
        SetMlfbSec(getFirmwareVersion());
    }
    else
    {
        SetMlfbSec("");
    }
    
    //Consequences
    ECL_SetValue("ECSI_CC_ControlUnit", "");
    ECL_SetValue("ECSI_CC_BrakeRelays", "");
    ECL_SetValue("ECSI_CC_InputFilterType", "2");
    ECL_SetValue("ECSI_CC_ExternalFilterType", "0");
    
    // Set status to OK & remove (previous) status message
    ECL_SelectValue("ECSI_STATUS", "OK");
    ECL_ResetAttribute("ECSI_STATUS_MESSAGE");
}

function getFirmwareVersion() {
    var selectedFirmware = ECL_GetValue("A_FIRMWARE_ET200");
    var sQuery = "select MLFB from FIRMWARE where VERSION = ?";
    var version = [processVersion(selectedFirmware)];

    var aDbResult = Object.fromDatabase("ET200PRO_FIRMWARE", sQuery, version);

    return aDbResult[0].MLFB;
}

function getLatestFirmwareVersion() {
    var sQuery = "select VERSION from FIRMWARE where NEWEST is 'true'";
    var aDbResult = Object.fromDatabase("ET200PRO_FIRMWARE", sQuery);

    return processVersion(aDbResult[0].VERSION);
}

function processVersion(version) {
    if (version.includes("_")) {
        return processVersionFromUI(version);
    } else {
        return processVersionFromDB(version);
    }
}

function processVersionFromDB(versionFromDB) {
    var result = versionFromDB.replace(".", "_");
    result = result.replace(" ", "_");
    result = "VERSION_" + result.substr(1);

    return result;
}

function processVersionFromUI(versionFromUI) {
    var result = versionFromUI.split("VERSION_")[1];
    result = "V" + result;
    
    parts = result.split("_");
    result1 = "";
    for(var i = 0; i < parts.length; i++) {
        result1 += parts[i];
        
        if (i==0) {
            result1 += ".";
        } else {
            result1 += " ";
        }
    }

    return result1.trim();
}