//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_G110D
// 	Date: 2019-02-19
// 	User: Karina Demeisi
// ---------------------------------------------------------

/* ----------- MLFB Struktur ----------------------------------
Bsp Sekundr MLFBs 6SL32540AM000AA0;3RK19222BP00;6SL32550AA004HA1;6SL35550PA002AA0
Beispiel : 6SL3511-1PE24-0AM0
davon fix: 6SL3511-.PE..-.AM0 (Stelle 8 fr Wartungsschalter, Stellen 11, 12, 13 geben die Leistung an)

01  ...  07      08       09 ...   10      11       12       13       14       15       16
|                |        |                |        |        |        |        |        |
|                |        |                |        |        |        |        |        - 0 (statisch)
|                |        |                |        |        |        |        - M (statisch)
|                |        |                |        |        |        - A (statisch)
|                |        |                |        |        - Leistung 2. Stelle - 0 || 5
|                |        |                |        - Leistung 1. Stelle - 1 || 3 || 4 || 5 || 7
|                |        |                - Leistung Position Dezimaltrenner: 1 = 0,xx || 2 = x,x
|                |        |        
|                |        - PE (statisch)
|                - Wartungsschalter: 0 = Nein, 1 = Ja
|        
- 6SL3511(statisch)

*/

//Test MLFB's
// 6SL3511-.PE17-5AM0
// 6FC85055EX020AA0
// 6SL3511-XPE17-5AM0

 // include easyKAT Configuration Library
//@import "SIZER_general_functions.js"

//#mode(full-ecma)



globalThis.OnChangeConfiguration = function main() {
    // Bei einer neuen Konfiguration oder dem laden einer bestehenden wird nach 
    // wie vor mit einem oder mehreren @INIT@ Requests gestartet
    // Danach folgt dann EIN Aufruf mit ECSI_MLFB, als Value steht darin ein JSON String
    // der ECSI_MLFB, ECSI_MLFB_SEC und gegebenenfalls alle Kontextattribute beinhaltet
    // Die Funktion SetAttributesFromMlfb() setzt die Werte in die jeweiligen Attribute,
    // sodass man sie wie vorher auch benutzen kann.
    // Achtung: Wenn bisher auf Events reagiert wurde bei denen ein Kontextattribut gesetzt wurde
    //          muss dieser Code angepasst werden weil diese Events nicht mehr kommen
    // Ob man also fr eine neue oder bestehende Konfiguration aufgerufen wird, erkennt
    // man in Zukunft nur daran, dass bei einer neuen Konf ECSI_MLFB_SEC leer ist und ECSI_MLFB
    // gegebenenfallsnoch Wildcards enthlt.
    // Achtung: Es kann bei einer bestehenden Konfiguration jetzt passieren, dass sich
    // Kontextattribute ndern gegenber dem Zeitpunkt wo die Konfiguration erstellt wurde.
    // In dem Fall haben wir 2 Mglichkeiten:
    // a) Konfiguration anpassen; z.B. wenn eine Stelle der Primr-MLFB betroffen ist, knnen
    //    wir diese anpassen. Konkreter Fall: Bus-System wird als Preference gesetzt
    // b) Fehler generieren; der Anwender bekommt dann die Mglichkeit, die Konfiguration 
    //	  zurckzusetzen (Reset Knopf in der Konf, wird gerade eingefhrt)
    //	  Beispiel: Safety-Funktion - Anwender hat eine SD-Karte ohne Safety gewhlt, dadurch wird
    //				eine Zubehr-MLFB generiert. Dann ndert er die Preference auf "Safety". Wir knnen
    //				dann die Karte nicht einfach austauschen sondern checken das und generieren einen Fehler
    SetAttributesFromMlfb();

    /* ------------ Zubehr MLFBs als KONSTANTEN ---------------------------*/
    var mlfbConstants = new Object();
    mlfbConstants.sMLFB_HMK_SPEICHERKARTE_G110D_00001   = '6SL32540AM000AA0';
    mlfbConstants.sMLFB_HMK_SPEICHERKARTE_G110D_00002   = '6SL30544AG002AA0';
    mlfbConstants.sMLFB_HMK_IOP_HANDHELD_G110D   		= '6SL32550AA004HA1';
    mlfbConstants.sMLFB_HMK_RS232_KABEL_OPT_G110D   	= '3RK19222BP00';
    mlfbConstants.sMLFB_HMK_KABEL_USB_G110D   			= '6SL35550PA002AA0';
    mlfbConstants.sMLFB_HMK_SCHLUESSELSCHALT_G110D   	= '6SL35550PL002AA0';
    mlfbConstants.sMLFB_TAK_AAP266_001_000_G110D   		= '6SL35550PM000AA0';
    mlfbConstants.sMLFB_HMK_MONTAGEADAPTER_G110D   		= '6SL32631GA200GA0';
    mlfbConstants.sMLFB_HMK_TOOL_STARTER_G110D   		= '6SL30720AA000AG0';
    mlfbConstants.sMLFB_HMK_STECKERANSCHL_UL_G110D   	= '6SL35634UA000GA0';
    mlfbConstants.sMLFB_HMK_STECKER_BUEGEL_G110D_000012 = '6SL32631HA200GA0';
    mlfbConstants.sMLFB_HMK_STECKER_BUEGEL_G110D_00003  = '6SL32631HC200GA0';
    mlfbConstants.sMLFB_HMK_M12_BUCHSE_G110D   			= '3RK19024CA004AA0';
    mlfbConstants.sMLFB_HMK_M12_ABZWEIG_G110D_00001   	= '3RK19011NR21';
    mlfbConstants.sMLFB_HMK_M12_ABZWEIG_G110D_00002   	= '3RK19011NR22';
    mlfbConstants.sMLFB_HMK_STECKER_M12_G110D_00002   	= '3RK19024BA005AA0';
    mlfbConstants.sMLFB_HMK_STECKER_M12_G110D_00003   	= '3RK19024DA005AA0';
    mlfbConstants.sMLFB_HMK_M12_STECKLEITUNG_G110D_00001   = '3RK19024HB155AA0';
    mlfbConstants.sMLFB_HMK_M12_STECKLEITUNG_G110D_00002   = '3RK19024HB505AA0';
    mlfbConstants.sMLFB_HMK_M12_STECKLEITUNG_G110D_00003   = '3RK19024HC015AA0';
    mlfbConstants.sMLFB_HMK_STECKERANSCHL_BR_G110D   	= '6SL35634RA000GA0';
    mlfbConstants.sMLFB_HMK_STECKER_EINSPEIS_G110D_00001   = '3RK19112BE50';
    mlfbConstants.sMLFB_HMK_STECKER_EINSPEIS_G110D_00002   = '3RK19112BE10';
    mlfbConstants.sMLFB_HMK_STECKER_EINSPEIS_G110D_00003   = '3RK19112BE30';
    mlfbConstants.sMLFB_HMK_LEITUNG_KONFEKT_G110D_00001    = '3RK19110DB13';
    mlfbConstants.sMLFB_HMK_LEITUNG_KONFEKT_G110D_00002    = '3RK19110DB33';
    
    //Ergnzung Release 4 One Axis, 25112019 tfreichel
    mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00001    = '6FC85053EX020AA0';
    mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00002    = '6FC85055EX020AA0';
    mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00003    = '6FC85053EX030AA0';
    mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00004    = '6FC85055EX030AA0';
    
    /* -------------------------------------------------------------------*/

    // Datenbank
    
    // Defaults, wird ggf. von der Fehlerbehandlung gendert
    ECL_SelectValue("ECSI_STATUS", "OK");		// Status fr MLFB-bergabe
    ECL_SetValue("ECSI_STATUS_MESSAGE", "");	// Statusmeldung fr MLFB-bergabe
    
    var sDezimalkenner 				= "";		// Leistungsparameter aus MLFB
    var sLeistung1 						= "";		// Leistungsparameter aus MLFB
    var sLeistung2 						= "";		// Leistungsparameter aus MLFB
    var sLeistung 						= "";		// Gesamtwert (String)
    var sWartungsschalterKenner		= "";
    
    // Steuerung: Was wurde bergeben bzw. gendert?
    var sCurrentAttribute = ECL_GetCurrentAttribute();
    // unsinnige Aufrufe abwrgen
    if (sCurrentAttribute === '')	
        return;
    var sMlfb 		= ECL_GetValue("ECSI_MLFB");
    var sMlfb_sec 	= ECL_GetValue("ECSI_MLFB_SEC");
    if ((sMlfb === '') && (sCurrentAttribute != "@INIT@")){
        return;
    }
        
    switch(sCurrentAttribute) {
        case "@INIT@":
            initializeUI();
            break;
        case "ECSI_MLFB":
            analyzePrimaryMLFB();
        //	break;
        // case "ECSI_MLFB_SEC":
            if (sMlfb_sec != '')
                analyzeSecondaryMLFB(mlfbConstants);
            break;
        
        default: 
            analyzeUI(mlfbConstants,sMlfb);
    }
    
    // Consequences
    ECL_SetValue("ECSI_CC_OutputReactorOrFilter", "");
    ECL_SetValue("ECSI_CC_OutputReactorOrFilterType", "0");
    ECL_SetValue("ECSI_CC_InputFilterType", "2");
    ECL_SetValue("ECSI_CC_ExternalFilterType", "0");
    
}

/** Versetzt die Steuerelemente in den Anfangsstatus. 
Jedes Steuerelement soll vorbelegt sein mit "Nein" oder "leer"
*/
function initializeUI(){
    ECL_SetValue("ECSI_MLFB_SEC", "");
    // ECL_DisableAttribute("ECSI_MLFB_SEC");
    
    // Status Interface
    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");
    ECL_DisableAttribute("HMK_BEM_LEISTUNG_HO_G110D");
    
    // Consequences:
    ECL_SetValue("ECSI_CC_ControlUnit", "");
    ECL_DisableAttribute("ECSI_CC_ControlUnit");
    ECL_SetValue("ECSI_CC_BrakeRelays", "");	
    ECL_DisableAttribute("ECSI_CC_BrakeRelays");
    
    // Vorbelegungen
    ECL_SetValue("HMK_SPEICHERKARTE_G110D", "00003");
    //ECL_SetValue("HMK_IOP_HANDHELD_G110D", "F");
    //ECL_SetValue("HMK_RS232_KABEL_OPT_G110D", "F");
    //ECL_SetValue("HMK_KABEL_USB_G110D", "F");
    //ECL_SetValue("HMK_SCHLUESSELSCHALT_G110D", "F");
    //ECL_SetValue("TAK_AAP266_001_000_G110D", "F");
    //ECL_SetValue("HMK_MONTAGEADAPTER_G110D", "F");
    //ECL_SetValue("HMK_TOOL_STARTER_G110D", "F");
    //ECL_SetValue("HMK_STECKERANSCHL_UL_G110D", "F");
    //ECL_SetValue("HMK_STECKER_BUEGEL_G110D", "F");
    //ECL_SetValue("HMK_M12_BUCHSE_G110D", "F");
    ECL_SetValue("HMK_M12_ABZWEIG_G110D", "00003");
    ECL_SetValue("HMK_STECKER_M12_G110D", "00001");
    ECL_SetValue("HMK_M12_STECKLEITUNG_G110D", "00004");
    //ECL_SetValue("HMK_LEIST_SCHALTER_G110D", "F");
    //ECL_SetValue("PMD_AAC947_001_000_G110D", "F");
    //ECL_SetValue("PMD_ABU780_001_000_G110D", "F");
    //ECL_SetValue("HMK_STECKERANSCHL_BR_G110D", "F");
    ECL_SetValue("HMK_STECKER_EINSPEIS_G110D", "00004");
    ECL_SetValue("HMK_LEITUNG_KONFEKT_G110D", "00003");
    ECL_SetValue("HMK_STECKERSATZ_G110D", "F");
    ECL_SetValue("HMK_MLFB_DSEE_G110D", "OHNE");	
    
    ECL_SetValue("HMK_FIELDBUS_INTERFACE_G110D", "AS-i");	
    ECL_DisableAttribute("HMK_FIELDBUS_INTERFACE_G110D");
    
                
    // Als Checkbox:		
    ECL_DeselectAttribute("HMK_IOP_HANDHELD_G110D");	
    ECL_DeselectAttribute("HMK_RS232_KABEL_OPT_G110D");	
    ECL_DeselectAttribute("HMK_KABEL_USB_G110D");	
    ECL_DeselectAttribute("HMK_SCHLUESSELSCHALT_G110D");	
    ECL_DeselectAttribute("TAK_AAP266_001_000_G110D");	
    ECL_DeselectAttribute("HMK_MONTAGEADAPTER_G110D");	
    ECL_DeselectAttribute("HMK_TOOL_STARTER_G110D");	
    ECL_DeselectAttribute("HMK_STECKERANSCHL_UL_G110D");	
    ECL_DeselectAttribute("HMK_STECKER_BUEGEL_G110D");		
    ECL_DeselectAttribute("HMK_M12_BUCHSE_G110D");		
    ECL_DeselectAttribute("HMK_LEIST_SCHALTER_G110D");		
    ECL_DeselectAttribute("PMD_AAC947_001_000_G110D");	
    ECL_DeselectAttribute("PMD_ABU780_001_000_G110D");		
    ECL_DeselectAttribute("HMK_STECKERANSCHL_BR_G110D");	
    
    ECL_DeselectAttribute("PMD_ABN823_001_000_G110D");	
    
}

/** Analysiert die im Feld ECSI_MLFB eingetragene Primr-MLFB
    Ermittelt werden Leistungsdaten und Integrierter Wartungsschalter
*/
function analyzePrimaryMLFB(){
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB");
    if ( !(sECSI_MLFB == "") && !(sECSI_MLFB == undefined) ) {
        sECSI_MLFB = sECSI_MLFB.replace(/\s+/g, ""); 				// Leerzeichen entfernen
        var sMLFB_short = sECSI_MLFB.replace("-", ""); // Bindestriche entfernen
        ECL_SetValue("ECSI_MLFB", sMLFB_short);
        
        // Prfen, ob die Zeichenkette 16 Stellen hat
        if (sMLFB_short.length != 16)
        {
            // bergabefehler abfangen
            addToErrors(ECL_Translate("ERROR___WRONG_MLFB_G110D"));
        }
        if (sMLFB_short.indexOf("6SL3511") < 0)
        {
            // Falsches Produkt
            addToErrors(ECL_Translate("ERROR___WRONG_PRODUCT_G110D"));
        }

        // Leistungsdaten herauslesen
        sDezimalkenner = sMLFB_short.substr(10, 1); // wenn 1: 0,xx | wenn 2: x,x 
        var aValidValues1 = ["1", "2"]; // ggf. aus DB-VT holen?
        if (aValidValues1.indexOf(sDezimalkenner) < 0)
        {
            // Fehler
            addToErrors(ECL_Translate("ERROR___DECIMAL_IDENT_OUTOFRANGE_G110D"));
        }
        
        sLeistung1 = sMLFB_short.substr(11, 1);
        var aValidValues2 = ["1", "3", "4", "5", "7"]; // ggf. aus DB-VT holen?
        if (aValidValues2.indexOf(sLeistung1) < 0)
        {
            // Fehler
            addToErrors(ECL_Translate("ERROR___POWER_VALUE_1_OUTOFRANGE_G110D") + " '" + sLeistung1 + "' ");
        }
        
        sLeistung2 = sMLFB_short.substr(12, 1);
        var aValidValues3 = ["0", "5"]; // ggf. aus DB-VT holen?
        if (aValidValues3.indexOf(sLeistung2) < 0)
        {
            // Fehler
            addToErrors(ECL_Translate("ERROR___POWER_VALUE_2_OUTOFRANGE_G110D") + " '" + sLeistung2 + "' ");
        }
        //Leistungsdaten abfragen und setzen:
        var sSQL = "SELECT * FROM VT_G110D_M00001_26974 WHERE MLFB11_G110D = '" +  sDezimalkenner + "' AND MLFB12_G110D = '" 
                                +  sLeistung1 + "' AND MLFB13_G110D = '" +  sLeistung2 + "';"
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        
        if (aResult.length > 0)
        {
            ECL_SetValue("HMK_BEM_LEISTUNG_HO_G110D", aResult[0].HMK_BEM_LEISTUNG_HO_G110D); 	// Bemessungsleistung (kW)
        }
        else
        {
            // Fehler: fr Leistungsdaten kein Treffer in VT:
            if (sDezimalkenner == "1") 
            {
                sLeistung = "0," + sLeistung1 + sLeistung2 + "kW";
            }
            else
            {
                sLeistung = sLeistung1 + "," + sLeistung2 + "kW";
            }
            addToErrors(ECL_Translate("ERROR___NO_VALUE_VT_POWER_G110D") + " '" + sLeistung +"' ");
        }

        // Integrierter Wartungsschalter: 0 = Nein, 1 = Ja, . = nicht spezifiziert
        // Ist der IW spezifiziert, wird das Steuerelement ausgegraut, sonst bleibt es auswhlbar
        sWartungsschalterKenner = sMLFB_short.substr(7, 1);
        if (sWartungsschalterKenner == "0"){
            ECL_SetValue("PMD_ABN823_001_000_G110D", "F");	
            //ECL_DisableAttribute("PMD_ABN823_001_000_G110D");
        } else if (sWartungsschalterKenner == "1"){
            ECL_SetValue("PMD_ABN823_001_000_G110D", "T");	
            //ECL_DisableAttribute("PMD_ABN823_001_000_G110D");
        } else if (sWartungsschalterKenner == "."){
            ECL_SetValue("PMD_ABN823_001_000_G110D", "F");	
            var new_MLFB = sMLFB_short.substr(0, 7) + "0" + sMLFB_short.substr(8, 8);
            ECL_SetValue("ECSI_MLFB", new_MLFB);
            //ECL_EnableAttribute("PMD_ABN823_001_000_G110D");
        }
        else
        {
            addToErrors(ECL_Translate("ERROR___POWER_VALUE_8_OUTOFRANGE_G110D") + " '" + sWartungsschalterKenner +"' ");
        }
        
    }
    else
    {
        //Fehler bei MLFB bergabe
        addToErrors(ECL_Translate("ERROR___MLFB_UNDEFINED_G110D"));
    }
    
    // Regenerativer Betrieb
    var sRegenerativeModeContext = ECL_GetValue("ECSI_CX_RegenerativeMode");
    if (sRegenerativeModeContext && sRegenerativeModeContext != "0")
    {
        var iCxRegenerativeMode = parseInt(sRegenerativeModeContext);
        
        // Bremswiderstand nur bei Kontext 'Energie abfhren' aktivieren
        if (iCxRegenerativeMode == 2)
        {
            ECL_SetValue("PMD_ABU780_001_000_G110D","T");
            ECL_DisableAttribute("PMD_ABU780_001_000_G110D");
        }
        else
        {
            addToErrors(ECL_Translate("ERROR___REGENERATIVE_MODE_INVALID_G110D"));
        }
    }
    else
        ECL_EnableAttribute("PMD_ABU780_001_000_G110D");
}


/**
    Analysiert die im Feld ECSI_MLFB_SEC eingetragenen Sekundr (Zubehr) MLFBs
    und setzt entsprechend die Steuerelemente 
*/
function analyzeSecondaryMLFB(/**Object*/ mlfbConstants){
    var sECSI_MLFB_SEC = GetMlfbSec(); // EDIT bchrist 07/2023 for implementation of ECSI_CC_IsProtectiveDevice // ECL_GetValue("ECSI_MLFB_SEC");
    if (sECSI_MLFB_SEC == undefined) {
        sECSI_MLFB_SEC = "";
    }	
    
    sECSI_MLFB_SEC = sECSI_MLFB_SEC.replace(/\s+/g, ""); // Leerzeichen entfernen
    sECSI_MLFB_SEC = sECSI_MLFB_SEC.replace("-", ""); // Bindestriche entfernen
    
    // Vorgegebene Sekundr-MLFB wird gespeichert zum spteren Vergleichstest
    ECL_SetValue("ECSI_MLFB_SEC_INPUT", sECSI_MLFB_SEC);
    
    /** Speicherkarte
    MLFB				Easykat Feldwert
    6SL32540AM000AA0	00001
    6SL30544AG002AA0	00002
    ohne				00003
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_SPEICHERKARTE_G110D_00001) >= 0)
    {
        ECL_SetValue("HMK_SPEICHERKARTE_G110D", "00001");
    } else 
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_SPEICHERKARTE_G110D_00002) >= 0)
    {
        ECL_SetValue("HMK_SPEICHERKARTE_G110D", "00002");
    } else {
        ECL_SetValue("HMK_SPEICHERKARTE_G110D", "00003");
    }
    
    /** Bedienpanel / IOP Handheld
    MLFB				Easykat Feldwert
    6SL32550AA004HA1	T
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_IOP_HANDHELD_G110D) >= 0)
    {
        ECL_SetValue("HMK_IOP_HANDHELD_G110D", "T");
    } else {
        ECL_SetValue("HMK_IOP_HANDHELD_G110D", "F");
    }
    
    /** RS232-Verbindungskabel
    MLFB				Easykat Feldwert
    3RK19222BP00		T
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_RS232_KABEL_OPT_G110D) >= 0)
    {
        ECL_SetValue("HMK_RS232_KABEL_OPT_G110D", "T");
    } else {
        ECL_SetValue("HMK_RS232_KABEL_OPT_G110D", "F");
    }
    
    /** USB-Schnittstellenkabel
    MLFB				Easykat Feldwert
    6SL35550PA002AA0	T
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_KABEL_USB_G110D) >= 0)
    {
        ECL_SetValue("HMK_KABEL_USB_G110D", "T");
    } else {
        ECL_SetValue("HMK_KABEL_USB_G110D", "F");
    }
    
    /** Schlsselschalter 
    MLFB				Easykat Feldwert
    6SL35550PL002AA0	T
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_SCHLUESSELSCHALT_G110D) >= 0)
    {
        ECL_SetValue("HMK_SCHLUESSELSCHALT_G110D", "T");
    } else {
        ECL_SetValue("HMK_SCHLUESSELSCHALT_G110D", "F");
    }
    
    /** Kartenleser 
    MLFB				Easykat Feldwert
    6SL35550PM000AA0	T
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_TAK_AAP266_001_000_G110D) >= 0)
    {
        ECL_SetValue("TAK_AAP266_001_000_G110D", "T");
    } else {
        ECL_SetValue("TAK_AAP266_001_000_G110D", "F");
    }
    
    /** Montageadapter 
    MLFB				Easykat Feldwert
    6SL32631GA200GA0	T
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_MONTAGEADAPTER_G110D) >= 0)
    {
        ECL_SetValue("HMK_MONTAGEADAPTER_G110D", "T");
    } else {
        ECL_SetValue("HMK_MONTAGEADAPTER_G110D", "F");
    }
    
    /** Inbetriebnahme-Tool STARTER 
    MLFB				Easykat Feldwert
    6SL30720AA000AG0	T
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_TOOL_STARTER_G110D) >= 0)
    {
        ECL_SetValue("HMK_TOOL_STARTER_G110D", "T");
    } else {
        ECL_SetValue("HMK_TOOL_STARTER_G110D", "F");
    }
    
    /** UL-Steckeranschlusssatz 
    MLFB				Easykat Feldwert
    6SL35634UA000GA0	T
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_STECKERANSCHL_UL_G110D) >= 0)
    {
        ECL_SetValue("HMK_STECKERANSCHL_UL_G110D", "T");
    } else {
        ECL_SetValue("HMK_STECKERANSCHL_UL_G110D", "F");
    }
    
    /** Steckerschutzbgel
    MLFB				Easykat Feldwert Feld TAK_AAJ871_001_000_G110D in Tabelle M0001
    6SL32631HA200GA0	T				 '00001', '00002'
    6SL32631HC200GA0	T				 '00003'
    */
    if ( sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_STECKER_BUEGEL_G110D_000012) >= 0 || sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_STECKER_BUEGEL_G110D_00003) >= 0 )
    {
        ECL_SetValue("HMK_STECKER_BUEGEL_G110D", "T");
    } else {
        ECL_SetValue("HMK_STECKER_BUEGEL_G110D", "F");
    }
    
    /** M12-Anschluss-Buchse
    MLFB				Easykat Feldwert
    3RK19024CA004AA0	T
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_M12_BUCHSE_G110D) >= 0)
    {
        ECL_SetValue("HMK_M12_BUCHSE_G110D", "T");
    } else {
        ECL_SetValue("HMK_M12_BUCHSE_G110D", "F");
    }
    
    /** AS-Interface M12-Abzweig
    MLFB				Easykat Feldwert
    3RK19011NR21		00001
    3RK19011NR22		00002
    (keine)				00003
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_M12_ABZWEIG_G110D_00001) >= 0)
    {
        ECL_SetValue("HMK_M12_ABZWEIG_G110D", "00001");
    } 
    else if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_M12_ABZWEIG_G110D_00002) >= 0)
    {
        ECL_SetValue("HMK_M12_ABZWEIG_G110D", "00002");
    }
    else {
        ECL_SetValue("HMK_M12_ABZWEIG_G110D", "00003");
    }
    
    /** Drive System Service
    MLFB				Easykat Feldwert
    ohne				OHNE
    3 Jahre				DSEE3
    5 Jahre				DSEE5
    
    mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00001    = '6FC85053EX020AA0';
    mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00002    = '6FC85055EX020AA0';
    mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00003    = '6FC85053EX030AA0';
    mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00004    = '6FC85055EX030AA0';
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00001) >= 0 || sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00003) >= 0)
    {
        ECL_SetValue("HMK_MLFB_DSEE_G110D", "DSEE3");
    } 
    else if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00002) >= 0 || sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_MLFB_DSEE_G110D_00004) >= 0)
    {
        ECL_SetValue("HMK_MLFB_DSEE_G110D", "DSEE5");
    }
    else {
        ECL_SetValue("HMK_MLFB_DSEE_G110D", "OHNE");
    }
    
    /** M12-Stecker
    MLFB				Easykat Feldwert
    (keine)				00001
    3RK19024BA005AA0	00002
    3RK19024DA005AA0	00003
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_STECKER_M12_G110D_00002) >= 0)
    {
        ECL_SetValue("HMK_STECKER_M12_G110D", "00002");
    }
    else if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_STECKER_M12_G110D_00003) >= 0)
    {
        ECL_SetValue("HMK_STECKER_M12_G110D", "00003");
    } else {
        ECL_SetValue("HMK_STECKER_M12_G110D", "00001");
    }
    
    /** M12-Steckleitung
    MLFB				Easykat Feldwert
    3RK19024HB155AA0	00001
    3RK19024HB505AA0	00002
    3RK19024HC015AA0	00003
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_M12_STECKLEITUNG_G110D_00001) >= 0)
    {
        ECL_SetValue("HMK_M12_STECKLEITUNG_G110D", "00001");
    }
    else if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_M12_STECKLEITUNG_G110D_00002) >= 0)
    {
        ECL_SetValue("HMK_M12_STECKLEITUNG_G110D", "00002");
    }
    else if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_M12_STECKLEITUNG_G110D_00003) >= 0)
    {
        ECL_SetValue("HMK_M12_STECKLEITUNG_G110D", "00003");
    } else {
        ECL_SetValue("HMK_M12_STECKLEITUNG_G110D", "00004");
    }
    
    /** Leistungsschalter
    MLFB ist eine aus Tabelle VT_G110D_M00006_26974
    */
    var sSQL = "SELECT DISTINCT HMK_MLFB_L_SCHALTER_G110D FROM VT_G110D_M00006_26974;";
    var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
    var found = false;
    if (aResult.length > 0)
    {
        for (var i = 0; i < aResult.length; i++)
        {
            if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_L_SCHALTER_G110D) >= 0)
            {
                ECL_SetValue("HMK_LEIST_SCHALTER_G110D", "T");
                found = true;
                break;
            }
        }
    }
    if (found == false){
        ECL_SetValue("HMK_LEIST_SCHALTER_G110D", "F");
    }
    
    /** Sicherung
    MLFB ist eine aus Tabelle VT_G110D_M00004_26974
    */
    var sSQL = "SELECT DISTINCT HMK_MLFB_SICHERUNG_G110D FROM VT_G110D_M00004_26974;";
    var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
    found = false;
    if (aResult.length > 0)
    {
        for (var i = 0; i < aResult.length; i++)
        {
            if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_SICHERUNG_G110D) >= 0)
            {
                ECL_SetValue("PMD_AAC947_001_000_G110D", "T");
                found = true;
                break;
            }
        }
    }
    if (found == false){
        ECL_SetValue("PMD_AAC947_001_000_G110D", "F");
    }
    
    /** Bremswiderstand
    MLFB ist eine aus Tabelle VT_G110D_M00005_26974
    */
    var sSQL = "SELECT HMK_MLFB_BREMSWIDER_G110D FROM VT_G110D_M00005_26974 WHERE HMK_BEM_LEISTUNG_HO_G110D = '" + ECL_GetValue("HMK_BEM_LEISTUNG_HO_G110D")  + "';"; 
    var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
    found = false;
    if (aResult.length == 1)
    {
        for (var i = 0; i < aResult.length; i++)
        {
            if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_BREMSWIDER_G110D) >= 0)
            {
                ECL_SetValue("PMD_ABU780_001_000_G110D", "T");
                ECL_SetValue("ECSI_CC_BrakingResistorID", aResult[0].HMK_MLFB_BREMSWIDER_G110D);
                found = true;
                break;
            }
        }
    }
    if (found == false){
        ECL_SetValue("PMD_ABU780_001_000_G110D", "F");
        ECL_SetValue("ECSI_CC_BrakingResistorID", "");
    }
    
    /** Steckeranschlusssatz fr Bremswiderstand
    MLFB				Easykat Feldwert
    6SL35634RA000GA0	T
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_STECKERANSCHL_BR_G110D) >= 0)
    {
        ECL_SetValue("HMK_STECKERANSCHL_BR_G110D", "T");
    } else {
        ECL_SetValue("HMK_STECKERANSCHL_BR_G110D", "F");
    }
    
    /** Steckersatz fr Energieeinspeisung
    MLFB				Easykat Feldwert
    3RK19112BE50		00001
    3RK19112BE10		00002
    3RK19112BE30		00003
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_STECKER_EINSPEIS_G110D_00001) >= 0)
    {
        ECL_SetValue("HMK_STECKER_EINSPEIS_G110D", "00001");
    }
    else if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_STECKER_EINSPEIS_G110D_00002) >= 0)
    {
        ECL_SetValue("HMK_STECKER_EINSPEIS_G110D", "00002");
    }
    else if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_STECKER_EINSPEIS_G110D_00003) >= 0)
    {
        ECL_SetValue("HMK_STECKER_EINSPEIS_G110D", "00003");
    } else {
        ECL_SetValue("HMK_STECKER_EINSPEIS_G110D", "00004");
    }
    
    /** Vorkonfektionierte Anschlussleitung
    MLFB				Easykat Feldwert
    3RK19110DB13		00001
    3RK19110DB33		00002
    */
    if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_LEITUNG_KONFEKT_G110D_00001) >= 0)
    {
        ECL_SetValue("HMK_LEITUNG_KONFEKT_G110D", "00001");
    }
    else if (sECSI_MLFB_SEC.indexOf(mlfbConstants.sMLFB_HMK_LEITUNG_KONFEKT_G110D_00002) >= 0)
    {
        ECL_SetValue("HMK_LEITUNG_KONFEKT_G110D", "00002");
    } else {
        ECL_SetValue("HMK_LEITUNG_KONFEKT_G110D", "00003");
    }
    
}

/** Analysiert den Zustand der Steuerelemente und schreibt gefundene MLFBs 
    in das Feld ECSI_MLFB_SEC
*/
function analyzeUI(/**Object*/ mlfbConstants,sMlfb){
    sECSI_MLFB = ECL_GetValue("ECSI_MLFB");
    sECSI_MLFB_SEC = "";
    
    /** Integrierter Wartungsschalter 
        -> ndert die Haupt-MLFB (8. Stelle)
    */
    var sWartungsschalterKenner = sECSI_MLFB.substr(7, 1);
    var new_MLFB = "";
    if (ECL_GetValue("PMD_ABN823_001_000_G110D") == "T")
    {
        if (sWartungsschalterKenner != "1"){
            new_MLFB = sECSI_MLFB.substr(0, 7) + "1" + sECSI_MLFB.substr(8, 8);
        }
    } else if (ECL_GetValue("PMD_ABN823_001_000_G110D") == "F") 
    {
        if (sWartungsschalterKenner != "0"){
            new_MLFB = sECSI_MLFB.substr(0, 7) + "0" + sECSI_MLFB.substr(8, 8);
        }
    }
    
    if (new_MLFB != ""){
        ECL_SetValue("ECSI_MLFB", new_MLFB);
        //ECL_DisableAttribute("PMD_ABN823_001_000_G110D");
    }
        
    // -------------------- ZUBEHR -------------------------------------------------/
    /** Speicherkarte
    */
    if (ECL_GetValue("HMK_SPEICHERKARTE_G110D") == "00001")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_SPEICHERKARTE_G110D_00001); 
    }
    else if (ECL_GetValue("HMK_SPEICHERKARTE_G110D") == "00002")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_SPEICHERKARTE_G110D_00002); 
    }
    
    /** Bedienpanel / IOP Handheld 
    */
    if (ECL_GetValue("HMK_IOP_HANDHELD_G110D") == "T")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_IOP_HANDHELD_G110D); 
    }
    
    /** RS232-Verbindungskabel
    */
    if (ECL_GetValue("HMK_RS232_KABEL_OPT_G110D") == "T")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_RS232_KABEL_OPT_G110D); 
    }
    
    /** USB-Schnittstellenkabel
    */
    if (ECL_GetValue("HMK_KABEL_USB_G110D") == "T")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_KABEL_USB_G110D); 
    }
    
    /** Schlsselschalter
    */
    if (ECL_GetValue("HMK_SCHLUESSELSCHALT_G110D") == "T")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_SCHLUESSELSCHALT_G110D); 
    }
    
    /** Kartenleser
    */
    if (ECL_GetValue("TAK_AAP266_001_000_G110D") == "T")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_TAK_AAP266_001_000_G110D); 
    }
    
    /** Montageadapter
    */
    if (ECL_GetValue("HMK_MONTAGEADAPTER_G110D") == "T")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_MONTAGEADAPTER_G110D); 
    }
    
    /** Inbetriebnahme-Tool STARTER 
    */
    if (ECL_GetValue("HMK_TOOL_STARTER_G110D") == "T")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_TOOL_STARTER_G110D); 
    }
    
    /** UL-Steckeranschlusssatz 
    */
    if (ECL_GetValue("HMK_STECKERANSCHL_UL_G110D") == "T")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_STECKERANSCHL_UL_G110D); 
    }
    
    /** Steckerschutzbgel
    */
    if (ECL_GetValue("HMK_STECKER_BUEGEL_G110D") == "T")
    {
        var sSQL = "SELECT TAK_AAJ871_001_000_G110D FROM VT_G110D_M00001_26974 WHERE HMK_BEM_LEISTUNG_HO_G110D = '" + ECL_GetValue("HMK_BEM_LEISTUNG_HO_G110D")  + "';"; 
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length == 1)
        {
            var condition = aResult[0].TAK_AAJ871_001_000_G110D;
            if (condition == "00001" || condition == "00002"){
                sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_STECKER_BUEGEL_G110D_000012); 
            } else if (condition == "00003"){
                sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_STECKER_BUEGEL_G110D_00003); 
            }
        }
    }
    
    /** M12-Anschluss-Buchse
    */
    if (ECL_GetValue("HMK_M12_BUCHSE_G110D") == "T")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_M12_BUCHSE_G110D); 
    }
    
    /** AS-Interface M12-Abzweig
    */
    if (ECL_GetValue("HMK_M12_ABZWEIG_G110D") == "00001")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_M12_ABZWEIG_G110D_00001); 
    }
    else if (ECL_GetValue("HMK_M12_ABZWEIG_G110D") == "00002")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_M12_ABZWEIG_G110D_00002); 
    }
    
    /** M12-Stecker
    */
    if (ECL_GetValue("HMK_STECKER_M12_G110D") == "00002")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_STECKER_M12_G110D_00002); 
    }
    else if (ECL_GetValue("HMK_STECKER_M12_G110D") == "00003")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_STECKER_M12_G110D_00003); 
    }
    
    /** M12-Steckleitung
    */
    if (ECL_GetValue("HMK_M12_STECKLEITUNG_G110D") == "00001")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_M12_STECKLEITUNG_G110D_00001); 
    }
    else if (ECL_GetValue("HMK_M12_STECKLEITUNG_G110D") == "00002")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_M12_STECKLEITUNG_G110D_00002); 
    }
    else if (ECL_GetValue("HMK_M12_STECKLEITUNG_G110D") == "00003")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_M12_STECKLEITUNG_G110D_00003); 
    }
    
    /** Drive System Service
    */
    if (ECL_GetValue("HMK_MLFB_DSEE_G110D") != "OHNE")
    {
        var strMLFB_11=sMlfb.substring(10,11);
        var strMLFB_12=sMlfb.substring(11,12);
        
        var sSQL = "SELECT HMK_MLFB_DSEE_G110D FROM VT_G110D_M00021_26974 WHERE HMK_DSEE_G110D = '" + ECL_GetValue("HMK_MLFB_DSEE_G110D")  + "' AND ";
        sSQL = sSQL + "MLFB11_G110D='"+strMLFB_11+"' AND ";
        sSQL = sSQL + "MLFB12_G110D='"+strMLFB_12+"' ";
        
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length == 1)
        {
            sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, aResult[0].HMK_MLFB_DSEE_G110D); 
        } else {
            // Fehler
            addToErrors(ECL_Translate("ERROR___DSEE_MLFB_G110D"));
        }
    }
    
    /** Leistungsschalter
    */
    if (ECL_GetValue("HMK_LEIST_SCHALTER_G110D") == "T")
    {
        var sSQL = "SELECT HMK_MLFB_L_SCHALTER_G110D FROM VT_G110D_M00006_26974 WHERE HMK_BEM_LEISTUNG_HO_G110D = '" + ECL_GetValue("HMK_BEM_LEISTUNG_HO_G110D")  + "';"; 
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length == 1)
        {
            sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, aResult[0].HMK_MLFB_L_SCHALTER_G110D); 
        } else {
            // Fehler
            addToErrors(ECL_Translate("ERROR___CIRCUIT_BREAKER_MLFB_G110D"));
        }
    }
    
    /** Sicherung
    */
    if (ECL_GetValue("PMD_AAC947_001_000_G110D") == "T")
    {
        var sSQL = "SELECT HMK_MLFB_SICHERUNG_G110D FROM VT_G110D_M00004_26974 WHERE HMK_BEM_LEISTUNG_HO_G110D = '" + ECL_GetValue("HMK_BEM_LEISTUNG_HO_G110D")  + "';"; 
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length == 1)
        {
            var sMLFB_G110D_SICHERUNG = aResult[0].HMK_MLFB_SICHERUNG_G110D;
            // gefundene MLFB 3x bernehmen
            sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, sMLFB_G110D_SICHERUNG + ";" + sMLFB_G110D_SICHERUNG + ";" + sMLFB_G110D_SICHERUNG);
        
        } else {
            // Fehler
            addToErrors(ECL_Translate("ERROR___FUSE_MLFB_G110D"));
        }
    }
    
    /** Bremswiderstand
    */
    if (ECL_GetValue("PMD_ABU780_001_000_G110D") == "T")
    {
        var sSQL = "SELECT HMK_MLFB_BREMSWIDER_G110D FROM VT_G110D_M00005_26974 WHERE HMK_BEM_LEISTUNG_HO_G110D = '" + ECL_GetValue("HMK_BEM_LEISTUNG_HO_G110D")  + "';"; 
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length == 1)
        {
            sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, aResult[0].HMK_MLFB_BREMSWIDER_G110D);
            ECL_SetValue("ECSI_CC_BrakingResistorID", aResult[0].HMK_MLFB_BREMSWIDER_G110D);
        } else {
            // Fehler
            addToErrors(ECL_Translate("ERROR___BRAKING_RESISTOR_MLFB_G110D"));
        }
    }
    else
        ECL_SetValue("ECSI_CC_BrakingResistorID", "");
    
    /** Steckeranschlusssatz fr Bremswiderstand
    */
    if (ECL_GetValue("HMK_STECKERANSCHL_BR_G110D") == "T")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_STECKERANSCHL_BR_G110D); 
    }
    
    /** Steckersatz fr Energieeinspeisung
    */
    if (ECL_GetValue("HMK_STECKER_EINSPEIS_G110D") == "00001")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_STECKER_EINSPEIS_G110D_00001); 
    }
    else if (ECL_GetValue("HMK_STECKER_EINSPEIS_G110D") == "00002")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_STECKER_EINSPEIS_G110D_00002); 
    }
    else if (ECL_GetValue("HMK_STECKER_EINSPEIS_G110D") == "00003")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_STECKER_EINSPEIS_G110D_00003); 
    }
    
    /** Vorkonfektionierte Anschlussleitung
    */
    if (ECL_GetValue("HMK_LEITUNG_KONFEKT_G110D") == "00001")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_LEITUNG_KONFEKT_G110D_00001); 
    }
    else if (ECL_GetValue("HMK_LEITUNG_KONFEKT_G110D") == "00002")
    {
        sECSI_MLFB_SEC = addToList(sECSI_MLFB_SEC, mlfbConstants.sMLFB_HMK_LEITUNG_KONFEKT_G110D_00002); 
    }
    
    // ----------------------------------------------------------------
    // Sekundr-MLFBs setzen
    // // EDIT bchrist 07/2023 for implementation of ECSI_CC_IsProtectiveDevice // ECL_SetValue("ECSI_MLFB_SEC", sECSI_MLFB_SEC);
    SetMlfbSec(sECSI_MLFB_SEC); // EDIT bchrist 07/2023 for implementation of ECSI_CC_IsProtectiveDevice //
}


/** erweitert eine ";"-getrennte Liste um einen neuen Eintrag */
function addToList(/**String*/ sECSI_MLFB_SEC, /**String*/ newMLFB){
    if (sECSI_MLFB_SEC == ""){
        return newMLFB;
    } else {
        return sECSI_MLFB_SEC + ";" + newMLFB;
    }
}


function addToErrors(/**String*/ errorMessage){
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_GetValue("ECSI_STATUS_MESSAGE") + errorMessage + " ");
}
