//@legacy
/**
*   Main script for configuration object CFG_SIEMENS_G110M
*
* 	Date: 2019-06-03
* 	User: Andreas Hller, Plan Software GmbH
*/

// include easyKAT Configuration Library


// additional scripts
//@import "CFG_SIEMENS_G110M_DEP.js"

//@import "CFG_SIEMENS_G110M_DB.js"

//@import "CFG_SIEMENS_G110M_GLOBAL.js"

//@import "SIZER_general_functions.js"


//#mode(full-ecma)


globalThis.OnChangeConfiguration = function main()
{
    // Bei einer neuen Konfiguration oder dem laden einer bestehenden wird nach 
    // wie vor mit einem oder mehereren @INIT@ Requests gestartet
    // Danach folgt dann EIN Aufruf mit ECSI_MLFB, als Value steht darin ein JSON String
    // der ECSI_MLFB, ECSI_MLFB_SEC und gegebenenfalls alle Kontextattribute beinhaltet
    // Die Funktion SetAttributesFromMlfb() setzt die Werte in die jeweiligen Attribute,
    // sodass man sie wie vorher auch benutzen kann.
    // Achtung: Wenn bisher auf Events reagiert wurde bei denen ein Kontextattribut gesetzt wurde
    //          muss dieser Code angepasst werden weil diese Events nicht mehr kommen
    // Ob man also fr eine neue oder bestehende Konfiguration aufgerufen wird, erkennt
    // man in Zukunft nur daran, dass bei einer neuen Konf ECSI_MLFB_SEC leer ist und ECSI_MLFB
    // gegebenenfalls noch Wildcards enthlt.
    // Achtung: Es kann bei einer bestehenden Konfiguration jetzt passieren, dass sich
    // Kontextattribute ndern gegenber dem Zeitpunkt wo die Konfiguration erstellt wurde.
    // In dem Fall haben wir 2 Mglichkeiten:
    // a) Konfiguration anpassen; z.B. wenn eine Stelle der Primr-MLFB betroffen ist, knnen
    //    wir diese anpassen. Konkreter Fall: Bus-System wird als Preference gesetzt
    // b) Fehler generieren; der Anwender bekommt dann die Mglichkeit, die Konfiguration 
    //	  zurckzusetzen (Reset Knopf in der Konf, wird gerade eingefhrt)
    //	  Beispiel: Safety-Funktion - Anwender hat eine SD-Karte ohne Safety gewhlt, dadurch wird
    //				eine Zubehr-MLFB generiert. Dann ndert er die Preference auf "Safety". Wir knnen
    //				dann die Karte nicht einfach austauschen sondern checken das und generieren einen Fehler
    SetAttributesFromMlfb();

    /*
    DTK Tabellenbeschreibung
    VT_G110M_M00003   Leistung Min-Max                                          ==> IRRELEVANT (Bemessungsleistung wird immer durch voll qualifizierte Primr-MLFB aus SIZER bergeben)
    VT_G110M_M00005   Strom Min-Max                                             ==> IRRELEVANT (nur Bemessungsleistung ist relevant)
    VT_G110M_M00008   7/8_Stecker-Kommunikation                                 ==> IRRELEVANT (wird durch SIZER Kabelkonfigurator definiert)
    VT_G110M_M00009   7/8_Kabel-Kommunikation                                   ==> IRRELEVANT (wird durch SIZER Kabelkonfigurator definiert)
    VT_G110M_M00014   MLFB CU                                                   ==> OK
    VT_G110M_M00015   7-8-Stecker-Anschluss                                     ==> IRRELEVANT (wird durch SIZER Kabelkonfigurator definiert)
    VT_G110M_M00016   ZO 7/8-Kabel Lnge - Anschluss                            ==> IRRELEVANT (wird durch SIZER Kabelkonfigurator definiert)
    VT_G110M_M00017   Leistung (hp) Min-Max                                     ==> IRRELEVANT
    VT_G110M_M00018   MLFB Struktur                                             ==> OK
    VT_G110M_M00020   MLFB-MemoryCard                                           ==> OK (jedoch unlogisch, da fr 'ohne' zwei MLFBs gleichzeitig gelten sollen + Widerspruch zu ABAP-Code DEPID 60)
    VT_G110M_M00021   ZO Wandmontagesatz - Baugre                             ==> IRRELEVANT (da zunchst immer Wandmontagesatz & Baugre FS71 selektiert)
    VT_G110M_M00022   ZO Integrierter Wartungsschalter - 24V DC Stromversorgung ==> OK (jedoch mittels Script-Code umgesetzt, da reine CFG-Logik ohne Auswirkung auf MLFBs)
    VT_G110M_M00023   ZO Sicherung MLFB - Bauform                               ==> OK (jedoch unlogisch, da fr 'F' = ohne Sicherung gleiche MLFBs wie fr 'T' = mit Sicherung, daher mit zustzlichem Script-Code umgesetzt)
    VT_G110M_M00024   ZO Leistungsschalter MLFB - Bauform                       ==> OK (jedoch unlogisch, da fr 'F' = ohne Leistungsschalter gleiche MLFBs wie fr 'T' = mit Leistungsschalter, daher mit zustzlichem Script-Code umgesetzt)
    VT_G110M_M00025   MLFB 7/8'' Steckleitung                                   ==> IRRELEVANT (wird durch SIZER Kabelkonfigurator definiert)
    VT_G110M_M00026   MLFB Anschlussstecker                                     ==> IRRELEVANT (wird durch SIZER Kabelkonfigurator definiert)
    VT_G110M_M00027   MLFB Verbindungsleitung                                   ==> IRRELEVANT (wird durch SIZER Kabelkonfigurator definiert)
    VT_G110M_M00028   ZO 7/8-Kabel Abgang - Anschluss                           ==> IRRELEVANT (wird durch SIZER Kabelkonfigurator definiert)
    VT_G110M_M00029   ZO 7/8-Kabel Konfekt. - Anschluss                         ==> IRRELEVANT (wird durch SIZER Kabelkonfigurator definiert)
    
    // Test-MLFBs aus Online DTK:
    // 6SL3517-1BE12-3AM0
    // 6SL3517-1BE17-7AM0
    // 6SL3517-1BE21-0AM0
    */
    
    var currentAttribute = ECL_GetCurrentAttribute();
    var primaryMlfb      = ECL_GetValue("ECSI_MLFB");
    var secondaryMlfbs   = GetMlfbSec();
    
    // Dummy Aufrufe von SIZER unterdrcken
    if (currentAttribute == '')
        return;
    
    // Initialisierung: Vorbelegungen setzen
    if (currentAttribute == "@INIT@")
    {
        selectDefaults();
    }
    
    // Primr-MLFB verarbeiten
    if (currentAttribute == "ECSI_MLFB")
    {
        // Primr-MLFB berprfen
        primaryMlfb = checkPrimaryMlfb(primaryMlfb);
        
        // Abbruch, falls Primr-MLFB ungltig
        if (!primaryMlfb)
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            return;
        }
        
        // Bemessungsleistung & Bauform des Umrichters aus Primr-MLFB setzen (als einzige konfigurations-relevante Angaben hierin codiert)
        setRatedPowerConverterDesign(primaryMlfb);
        
        // Context Attributes setzen
        if (!setContextAttributes())
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            return;
        }
        
        // Falls Sekundr-MLFBs vom SIZER bergeben wurden
        if (secondaryMlfbs != "")
        {
            // Sekundr-MLFBs strukturell berprfen & in Array (statt String-Liste) umwandeln
            aSecondaryMlfbs = checkSecondaryMlfb(secondaryMlfbs);
            
            if (aSecondaryMlfbs && aSecondaryMlfbs.length > 0)
            {
                // zu whlendes Zubehr (AV-Liste) aus Sekundr-MLFBs ermitteln ("Rckwrts-Prfung")
                var aAccToSelect = getAccParts(aSecondaryMlfbs);
                
                // Sonder-Fehlerfall: Abweichender Kontext (hier: Kommunikation) von aktueller Konfigurationsbewertung
                if (aAccToSelect === false)
                {
                    ECL_SelectValue("ECSI_STATUS", "E");
                    return;
                }
                
                // aktuelle Konfigurationsbewertung gegen bergebene Sekundr-MLFBs prfen
                var aDeviations = checkAccToSelect(aAccToSelect);
                
                // Abweichungen ausgleichen (durch SIZER explizit bergebene Sekundr-MLFBs "gewinnen immer")
                applySecondaryMlfbs(aDeviations);
            }
            // Abbruch, falls Sekundr-MLFB ungltig
            else
            {
                ECL_SelectValue("ECSI_STATUS", "E");
                return;
            }
        }
    }
    
    // Abhngigkeiten zwischen Werten anwenden ("klassische" Konfigurationslogik)
    applyDependencies();
    
    // Sekundr-MLFBs aus CFG-Auswahlen ermitteln
    var aSecondaryMlfbsSelections = getSecondaryMlfbs();
    
    // Leeres Context-Attribut fr Bremsrelais setzen (da seitens SIZER immer erwartet)
    ECL_SetValue("ECSI_CC_BrakeRelays", "");
    
    //Filter
    ECL_SetValue("ECSI_CC_InputFilterType", "2");
    ECL_SetValue("ECSI_CC_ExternalFilterType", "0");
    
    // MLFB bergabestatus auf OK setzen & Statusmeldung (Fehlermeldung) lschen
    ECL_SelectValue("ECSI_STATUS", "OK");
    ECL_ResetAttribute("ECSI_STATUS_MESSAGE");
}