//@legacy
/**
* 	Script for database functions G110M
*
* 	Date: 2019-06-03
* 	User: Andreas Hller, Plan Software GmbH
*/

 // include easyKAT Configuration Library
//#mode(full-ecma)



// Bemessungsleistung & Bauform des Umrichters aus Primr-MLFB ermitteln
// VT_G110M_M00018_22853
function setRatedPowerConverterDesign(primaryMlfb)
{
    var sQuery = "select PMD_ABU793_001_000_G110M, PMD_ABW171_001_000_G110M from VT_G110M_M00018_22853 where MLFB11_G110M = ? and MLFB12_G110M = ? and MLFB13_G110M = ?;";
    var aParam = [primaryMlfb.substr(10, 1), primaryMlfb.substr(11, 1), primaryMlfb.substr(12, 1)];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    if (aDbResult && aDbResult.length == 1)
    {
        ECL_SelectValue("PMD_ABU793_001_000_G110M", aDbResult[0].PMD_ABU793_001_000_G110M); // Bemessungsleistung HO
        ECL_SelectValue("PMD_ABW171_001_000_G110M", aDbResult[0].PMD_ABW171_001_000_G110M); // Bauform des Umrichters
        ECL_DisableAttribute("PMD_ABW171_001_000_G110M");                                   // Bauform des Umrichters
    }
    else
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G110M_NO_VALID_RATED_POWER_FOUND_FOR_PRIMARY_MLFB"));
    }
}

// Control Unit MLFB
// VT_G110M_M00014_22853
function getContolUnit()
{
    var sQuery = "select HMK_MLFB_CU_G110M from VT_G110M_M00014_22853 where PMD_AAA726_001_000_G110M = ? and TAK_AAJ352_001_000_G110M = ? and HMK_ANSCHLUSSVARIANT_G110M = ?;";
    var aParam = [ECL_GetValue("PMD_AAA726_001_000_G110M"), ECL_GetValue("TAK_AAJ352_001_000_G110M"), ECL_GetValue("HMK_ANSCHLUSSVARIANT_G110M")];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    if (aDbResult && aDbResult.length == 1)
    {
        // Context-Attribute setzen
        ECL_SetValue("ECSI_CC_ControlUnit", aDbResult[0].HMK_MLFB_CU_G110M);
        
        return [aDbResult[0].HMK_MLFB_CU_G110M];  // MLFB Control Unit
    }
    else
    {
        // Context-Attribute leeren
        ECL_SetValue("ECSI_CC_ControlUnit", "");
        return [];
    }
}

// Sicherung MLFB
// VT_G110M_M00023_22853 (mit Einschrnkung, dass nur bei gewhlter Sicherung Auswertung der Tabelle erfolgt)
function getFuse()
{
    if (ECL_GetValue("HMK_SICHERUNG_G110M") == "T")
    {
        var sQuery = "select HMK_MLFB_SICHERUNG_G110M from VT_G110M_M00023_22853 where PMD_ABW171_001_000_G110M = ? and HMK_SICHERUNG_G110M = ?;";
        var aParam = [ECL_GetValue("PMD_ABW171_001_000_G110M"), ECL_GetValue("HMK_SICHERUNG_G110M")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            return [aDbResult[0].HMK_MLFB_SICHERUNG_G110M,
                    aDbResult[0].HMK_MLFB_SICHERUNG_G110M,
                    aDbResult[0].HMK_MLFB_SICHERUNG_G110M];  // 3x MLFB Sicherung (da Umrichter immer dreiphasig)
        }
        else
        {
            return [];
        }
    }
    else
    {
        return [];
    }
}

// Leistungsschalter MLFB
// VT_G110M_M00024_22853
function getCircuitBreaker()
{
    var sQuery = "select HMK_MLFB_LEISTSCHALT_G110M from VT_G110M_M00024_22853 where PMD_ABW171_001_000_G110M = ? and HMK_LEIST_SCHALTER_G110M = ?;";
    var aParam = [ECL_GetValue("PMD_ABW171_001_000_G110M"), ECL_GetValue("HMK_LEIST_SCHALTER_G110M")];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    if (aDbResult && aDbResult.length == 1)
    {
        return [aDbResult[0].HMK_MLFB_LEISTSCHALT_G110M];  // MLFB Leistungsschalter
    }
    else
    {
        return [];
    }
}

// Drive Service Agreement MLFB
// VT_G110M_M00030_22853
function getDSA()
{
    var sQuery = "select HMK_MLFB_DSA_G110M from VT_G110M_M00030_22853 where HMK_DSA_G110M = ?;";
    var aParam = [ECL_GetValue("HMK_DSA_G110M")];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    if (aDbResult && aDbResult.length == 1)
    {
        return [aDbResult[0].HMK_MLFB_DSA_G110M];  // MLFB Drive Service Agreement
    }
    else
    {
        return [];
    }
}

// Wandmontagesatz MLFB
// VT_G110M_M00032_22853
function getWallMountKit()
{
    var sQuery = "select HMK_MLFB_WANDMONTAGE_G110M from VT_G110M_M00032_22853 where HMK_WANDMONTAGESATZ__G110M = ?;";
    var aParam = [ECL_GetValue("HMK_WANDMONTAGESATZ_G110M")];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    if (aDbResult && aDbResult.length == 1)
    {
        return [aDbResult[0].HMK_MLFB_WANDMONTAGE_G110M];  // MLFB Wandmontagesatz
    }
    else
    {
        return [];
    }
}

// erforderliche Attributbewertung aus Sekundr-MLFB der Control Unit ermitteln
function getAvFromCuMlfb(secondaryMlfb)
{
    var sQuery = "select * from VT_G110M_M00014_22853 where HMK_MLFB_CU_G110M = ?;";
    var aParam = [secondaryMlfb];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    if (aDbResult && aDbResult.length == 1)
    {
        // berprfen, ob Control Unit mit bergebenem Kontext-Attribut bereinstimmt
        if (!checkCommContext(aDbResult[0]))
        {
            return false;
        }
        
        return [
                {A: "PMD_AAA726_001_000_G110M",   V: aDbResult[0].PMD_AAA726_001_000_G110M},
                {A: "TAK_AAJ352_001_000_G110M",   V: aDbResult[0].TAK_AAJ352_001_000_G110M},
                {A: "HMK_ANSCHLUSSVARIANT_G110M", V: aDbResult[0].HMK_ANSCHLUSSVARIANT_G110M}
               ];
    }
    else
    {
        return [];
    }
}