//@legacy
/**
* 	Script for applying dependencies G110M
*
* 	Date: 2019-06-03
* 	User: Andreas Hller, Plan Software GmbH
*/

 // include easyKAT Configuration Library
//#mode(full-ecma)


// Abhngigkeiten zwischen Werten anwenden ("klassische" Konfigurationslogik)
function applyDependencies()
{
    // nur entweder Wartungsschalter oder 24V DC Stromversorgung zulassen
    if (ECL_GetValue("HMK_WARTUNGSSCHALTER_G110M") == "T")
    {
        ECL_DeactivateValue("HMK_POWER_SUPPLY_G110M", "T");
        ECL_SelectValue("HMK_POWER_SUPPLY_G110M", "F");
    }
    else
    {
        ECL_ActivateValue("HMK_POWER_SUPPLY_G110M", "T");
    }
    
    if (ECL_GetValue("HMK_POWER_SUPPLY_G110M") == "T")
    {
        ECL_DeactivateValue("HMK_WARTUNGSSCHALTER_G110M", "T");
        ECL_SelectValue("HMK_WARTUNGSSCHALTER_G110M", "F");
    }
    else
    {
        ECL_ActivateValue("HMK_WARTUNGSSCHALTER_G110M", "T");
    }
    
    
    // Kommunikation USS nicht bei Anschlusstechnik = Stecktechnik zulssig
    if (ECL_GetValue("HMK_ANSCHLUSSVARIANT_G110M") == "STECK")
    {
        ECL_DeactivateValue("TAK_AAJ352_001_000_G110M", "USS");
        ECL_DeselectValue("TAK_AAJ352_001_000_G110M", "USS");
    }
    else
    {
        ECL_ActivateValue("TAK_AAJ352_001_000_G110M", "USS");
    }
    
    if (ECL_GetValue("TAK_AAJ352_001_000_G110M") == "USS")
    {
        ECL_DeactivateValue("HMK_ANSCHLUSSVARIANT_G110M", "STECK");
        ECL_DeselectValue("HMK_ANSCHLUSSVARIANT_G110M", "STECK");
    }
    else
    {
        ECL_ActivateValue("HMK_ANSCHLUSSVARIANT_G110M", "STECK");
    }
    
    // Wandmontagestze nur bei Motorbaugre FS71 zulssig
    if (ECL_GetValue("PMD_AAA726_001_000_G110M") == "FS71")
    {
        ECL_EnableAttribute("HMK_WANDMONTAGESATZ_G110M");
    }
    else
    {
        ECL_SelectValue("HMK_WANDMONTAGESATZ_G110M", "00003");    // ohne Wandmontagesatz
        ECL_DisableAttribute("HMK_WANDMONTAGESATZ_G110M");
    }
}

// Sekundr-MLFBs fr Zubehr ermitteln
function getSecondaryMlfbs()
{
    var aSecondaryMlfbsSelections = [];
    
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getContolUnit());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getMemoryCard());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getInstallationKit());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getIopHandheld());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getRs323Cable());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getUsbCable());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getRepairSwitch());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getFuse());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getCircuitBreaker());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getDSA());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getWallMountKit());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getDcPowerSupply());
    aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(getBrakingResistor());
    
    // Sekundr-MLFBs konkatenieren & ausgeben
    var sSecondaryMlfbsSelections = aSecondaryMlfbsSelections.join(";");
    
    SetMlfbSec(sSecondaryMlfbsSelections);
    
    return sSecondaryMlfbsSelections;
}

// Speicherkarte MLFB (nur 'Leer' im Online DTK)
// ABAP DEPID 60 (sowie VT_G110M_M00020 - jedoch unlogisch, da fr 'ohne' beide MLFBs gleichzeitig gelten sollen)
function getMemoryCard()
{
    if (ECL_GetValue("HMK_MEMORYCARD_ORG_G110M") == "00234")
    {
        return ["6SL30544AG002AA0"];
    }
    if (ECL_GetValue("HMK_MEMORYCARD_ORG_G110M") == "00235")
    {
        return ["6SL30547TF002BA0"];
    }
    else
    {
        return [];
    }
}

// Installations-Kit MLFB (nicht in Online DTK)
// (direkt aus CFG-Daten bernommen, da Wert-Identifier = MLFB in Wert-Identifier codiert)
function getInstallationKit()
{
    var sMlfb = ECL_GetValue("HMK_INSTALLATIONSKIT_G110M");
    
    if (sMlfb && sMlfb != "OHNE")
    {
        return [sMlfb];
    }
    else
    {
        return [];
    }
}

// Bedienpanel MLFB
// ABAP DEPID 53 + 54
function getIopHandheld()
{
    if (ECL_GetValue("HMK_IOP_HANDHELD_G110M") == "T")
    {
        return ["6SL32550AA004HA1"];
    }
    else
    {
        return [];
    }
}

// RS232-Verbindungskabel optisch MLFB (nicht in Online DTK)
// ABAP DEPID 55 + 56
function getRs323Cable()
{
    if (ECL_GetValue("HMK_RS232_KABEL_G110M") == "T")
    {
        return ["3RK19222BP00"];
    }
    else
    {
        return [];
    }
}

// USB-Schnittstellenkabel MLFB (nicht in Online DTK)
// ABAP DEPID 57 + 58
function getUsbCable()
{
    if (ECL_GetValue("TAK_ABU211_001_000_G110M") == "T")
    {
        return ["6SL35550PA002AA0"];
    }
    else
    {
        return [];
    }
}

// Integrierter Wartungsschalter MLFB
// ABAP DEPID 77 + 78
function getRepairSwitch()
{
    if (ECL_GetValue("HMK_WARTUNGSSCHALTER_G110M") == "T")
    {
        return ["6SL35550PR010AA0"];
    }
    else
    {
        return [];
    }
}

// 24V DC Stromversorgung MLFB
// ABAP DEPID 50 + 51
function getDcPowerSupply()
{
    if (ECL_GetValue("HMK_POWER_SUPPLY_G110M") == "T")
    {
        return ["6SL35550PV000AA0"];
    }
    else
    {
        return [];
    }
}

// Integrierter Bremswiderstand MLFB
// ABAP DEPID 73 + 74
function getBrakingResistor()
{
    if (ECL_GetValue("HMK_BREMSWIDERSTAND_G110M") == "T")
    {
        var sDesignOfConverter = ECL_GetValue("PMD_ABW171_001_000_G110M");
        
        if (sDesignOfConverter == "Z0001")
        {
            // Sekundr-MLFB des Bremswiderstands zustzlich als Consequence setzen
            ECL_SetValue("ECSI_CC_BrakingResistorID", "6SL35010BE188AA0");
            
            return ["6SL35010BE188AA0"];
        }
        if (sDesignOfConverter == "Z0002")
        {
            // Sekundr-MLFB des Bremswiderstands zustzlich als Consequence setzen
            ECL_SetValue("ECSI_CC_BrakingResistorID", "6SL35010BE220AA0");
            
            return ["6SL35010BE220AA0"];
        }
        else
        {
            // Sekundr-MLFB des Bremswiderstands aus Consequence-Attribut entfernen
            ECL_SetValue("ECSI_CC_BrakingResistorID", "");
            
            return [];
        }
    }
    else
    {
        // Sekundr-MLFB des Bremswiderstands aus Consequence-Attribut entfernen
        ECL_SetValue("ECSI_CC_BrakingResistorID", "");
        
        return [];
    }
}

// Zubehr aus Sekundr-MLFBs bestimmen (fr Prfung & "Rckwrts-Auflsung" bei bergabe aus SIZER)
function getAccParts(aSecondaryMlfbs)
{
    var aAccToSelect = [];
    var oMlfbToAvSelection = getAvFromSecMlfb();
    
    for (var i = 0; i < aSecondaryMlfbs.length; i++)
    {
        // Allgemeines Zubehr
        if (typeof oMlfbToAvSelection[aSecondaryMlfbs[i]] === "object")
        {
            for (var j = 0; j < oMlfbToAvSelection[aSecondaryMlfbs[i]].length; j++)
            {
                aAccToSelect.push(oMlfbToAvSelection[aSecondaryMlfbs[i]][j]);
            }
        }
        // Control Unit
        else
        {
            var aAvFromCuMlfb = getAvFromCuMlfb(aSecondaryMlfbs[i]);
            
            // Sonderfall abweichender Kontext (hier: Kommunikation) von aktueller Konfigurationsbewertung
            if (aAvFromCuMlfb === false)
            {
                return false;
            }
            else
            {
                aAccToSelect = aAccToSelect.concat(aAvFromCuMlfb);
            }
        }
    }
    
    return aAccToSelect;
}

// Datenobjekt mit Zuordnung von Sekundr-MLFBs zu Bewertung von Attributen bereitstellen
function getAvFromSecMlfb()
{
    var oMlfbToAvSelection = {
        "6SL30544AG002AA0": [{A: "HMK_MEMORYCARD_ORG_G110M",   V: "00234"}],
        "6SL30547TF002BA0": [{A: "HMK_MEMORYCARD_ORG_G110M",   V: "00235"}],
        "6SL35661GA000GA0": [{A: "HMK_WANDMONTAGESATZ_G110M",  V: "00001"}],                                            // aus VT_G110M_M00032_22853
        "6SL35661GC000GA0": [{A: "HMK_WANDMONTAGESATZ_G110M",  V: "00002"}],                                            // aus VT_G110M_M00032_22853
        "6SL35662LA000GA0": [{A: "HMK_INSTALLATIONSKIT_G110M", V: "6SL35662LA000GA0"}],
        "6SL35662VA000GA0": [{A: "HMK_INSTALLATIONSKIT_G110M", V: "6SL35662VA000GA0"}],
        "6SL32550AA004HA1": [{A: "HMK_IOP_HANDHELD_G110M",     V: "T"}],
        "3RK19222BP00":     [{A: "HMK_RS232_KABEL_G110M",      V: "T"}],
        "6SL35550PA002AA0": [{A: "TAK_ABU211_001_000_G110M",   V: "T"}],
        "6SL35550PR010AA0": [{A: "HMK_WARTUNGSSCHALTER_G110M", V: "T"}],
        "6SL35550PV000AA0": [{A: "HMK_POWER_SUPPLY_G110M",     V: "T"}],
        "6SL35010BE188AA0": [{A: "HMK_BREMSWIDERSTAND_G110M",  V: "T"}, {A: "PMD_ABW171_001_000_G110M", V: "Z0001"}],
        "6SL35010BE220AA0": [{A: "HMK_BREMSWIDERSTAND_G110M",  V: "T"}, {A: "PMD_ABW171_001_000_G110M", V: "Z0002"}],
        "3NA3803":          [{A: "PMD_ABW171_001_000_G110M",   V: "Z0001"}, {A: "HMK_SICHERUNG_G110M", V: "T"}],        // aus VT_G110M_M00023_22853
        "3NA3807":          [{A: "PMD_ABW171_001_000_G110M",   V: "Z0002"}, {A: "HMK_SICHERUNG_G110M", V: "T"}],        // aus VT_G110M_M00023_22853
        "3RV20111JA10":     [{A: "PMD_ABW171_001_000_G110M",   V: "Z0001"}, {A: "HMK_LEIST_SCHALTER_G110M", V: "T"}],   // aus VT_G110M_M00024_22853
        "3RV20214BA10":     [{A: "PMD_ABW171_001_000_G110M",   V: "Z0002"}, {A: "HMK_LEIST_SCHALTER_G110M", V: "T"}],   // aus VT_G110M_M00024_22853
        "9MC31108AM000AA0": [{A: "HMK_DSA_G110M",              V: "FUND"}],                                             // aus VT_G110M_M00030_22853
        "9MC31108AM000AA1": [{A: "HMK_DSA_G110M",              V: "EXT"}],                                              // aus VT_G110M_M00030_22853
    };
    
    return oMlfbToAvSelection;
}

// Abgleich aktueller Konfigurationsbewertung gegen ermittelte Bewertungen aus allen von SIZER bergebenen Sekundr-MLFBs
function checkAccToSelect(aAccToSelect)
{
    var aDeviations = [];
    
    for (var i = 0; aAccToSelect && i < aAccToSelect.length; i++)
    {
        var sCurrentCfgValue = ECL_GetValue(aAccToSelect[i].A)
        
        if (sCurrentCfgValue != aAccToSelect[i].V)
        {
            aDeviations.push({A: aAccToSelect[i].A, currentV: sCurrentCfgValue, expectedV: aAccToSelect[i].V});
        }
    }
    
    return aDeviations;
}

// Sonderfall Kommunikation: Prfung, ob Control Unit Sekundr-MLFB mit bergebenem Kontext-Attribut bereinstimmt
function checkCommContext(oControlUnitDbDataset)
{
    var sFieldbusInterfaceContext = ECL_GetValue("ECSI_CX_FieldbusInterface");
    
    if (sFieldbusInterfaceContext)
    {
        // Wert fr Feldbusschnittstelle aus Kontext-Attribut ermitteln
        var sFieldbusInterfaceValue = getFieldBusInterfaceValue(parseInt(sFieldbusInterfaceContext));
        
        // Attribut 'Kommunikation' passend bewerten & anschlieend sperren, um eine flschliche nderung zu verhindern
        ECL_SelectValue("TAK_AAJ352_001_000_G110M", sFieldbusInterfaceValue);
        ECL_DisableAttribute("TAK_AAJ352_001_000_G110M");
        
        // Wert fr Attribut 'Kommunikation' aus DB-Datensatz der vorliegenden Control Unit mit bergebener Feldbusschnittstelle abgleichen
        if (oControlUnitDbDataset.TAK_AAJ352_001_000_G110M != sFieldbusInterfaceValue)
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G110M_CONTEXT_TO_MLFB_MISMATCH"));
            return false;
        }
    }
    
    return true;
}