//@legacy
/**
* 	Script for global functions G110M
*
* 	Date: 2019-06-03
* 	User: Andreas Hller, Plan Software GmbH
*/

 // include easyKAT Configuration Library
//#mode(full-ecma)


// Vorbelegungen setzen
function selectDefaults()
{
    // Bemessungsleistung sperren (da immer ber Primr-MLFB von SIZER gesetzt)
    ECL_DisableAttribute("PMD_ABU793_001_000_G110M");
    
    // Immer Safety STO aktivieren & sperren (vgl. Online DTK)
    ECL_SelectValue("HMK_SAFETY_STO_G110M", "T");
    ECL_DisableAttribute("HMK_SAFETY_STO_G110M");
    
    // Standardmig Anschlusstechnik Schraubanschluss
    ECL_SelectValueDefault("HMK_ANSCHLUSSVARIANT_G110M", "SCHRAUB");
    
    // Standardmig Baugre des Motors FS71
    ECL_SelectValue("PMD_AAA726_001_000_G110M", "FS71");
    
    // Standardmig Lieferung ohne Wandmontagesatz
    ECL_SelectValue("HMK_WANDMONTAGESATZ_G110M", "00003");
    
    // Standardmig Lieferung ohne Speicherkarte
    ECL_SelectValueDefault("HMK_MEMORYCARD_ORG_G110M", "00001");
    
    // Standardmig Lieferung ohne Installations-Kit
    ECL_SelectValueDefault("HMK_INSTALLATIONSKIT_G110M", "OHNE");
    
    // Standardmig Lieferung ohne Bedienpanel
    ECL_SelectValueDefault("HMK_IOP_HANDHELD_G110M", "F");
    
    // Standardmig Lieferung ohne RS232-Verbindungskabel optisch
    ECL_SelectValueDefault("HMK_RS232_KABEL_G110M", "F");
    
    // Standardmig Lieferung ohne USB-Schnittstellenkabel
    ECL_SelectValueDefault("TAK_ABU211_001_000_G110M", "F");
    
    // Standardmig Lieferung ohne integrierten Wartungsschalter
    ECL_SelectValueDefault("HMK_WARTUNGSSCHALTER_G110M", "F");
    
    // Standardmig Lieferung ohne Leistungsschalter
    ECL_SelectValueDefault("HMK_LEIST_SCHALTER_G110M", "F");
    
    // Standardmig Lieferung ohne 24V DC Stromversorgung
    ECL_SelectValueDefault("HMK_SICHERUNG_G110M", "F");
    
    // Standardmig Lieferung ohne Sicherung
    ECL_SelectValueDefault("HMK_POWER_SUPPLY_G110M", "F");
    
    // Standardmig Lieferung ohne integrierten Bremswiderstand
    ECL_SelectValueDefault("HMK_BREMSWIDERSTAND_G110M", "F");
    
    // Standardmig Lieferung ohne Drive Service Agreement
    ECL_SelectValueDefault("HMK_DSA_G110M", "OHNE");
    
    // Interne (ECSI) read-only Attribute sperren
    ECL_DisableAttribute("ECSI_STATUS");
    ECL_DisableAttribute("ECSI_STATUS_MESSAGE");
}

// Primr-MLFB berprfen
function checkPrimaryMlfb(primaryMlfb)
{
    // RegEx fr eine Mindestanforderung an eine gltige Primr-MLFB
    var sRegExPowerModule = /6SL35171BE(113|123|133|143|163|177|210)AM0/g;
    var sRexExControlUnit = /6SL35440(L|M|N|P|T|Q)B021(B|F|M|P)A0/g;
    
    // MLFB vereinheitlichen
    primaryMlfb = primaryMlfb.toUpperCase().replace("-", "").replace("?", ".");
    
    // MLFB auf unzulssige Zeichen berprfen
    var illegalChars = primaryMlfb.match(/[^a-zA-Z0-9.]/g);
    
    // MLFB-Fehler diagnostizieren & ausgeben
    if (illegalChars && illegalChars.length > 1)
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G110M_MLFB_CHAR_INVALID"));
        return false;
    }
    
    if (primaryMlfb.length != 16)
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G110M_MLFB_LENGTH_INVALID") + " " + primaryMlfb.length);
        return false;
    }
    
    if (left(primaryMlfb, 10) !== "6SL35171BE")
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G110M_MLFB_SERIES_INVALID"));
        return false;
    }
    
    if (primaryMlfb.indexOf(".") == -1 && !primaryMlfb.match(sRegExPowerModule))
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G110M_MLFB_PATTERN_INVALID"));
        return false;
    }
    
    // vereinheitlichte (strukturell korrekte) MLFB zurckgeben
    return primaryMlfb;
}

// Sekundr-MLFBs berprfen
function checkSecondaryMlfb(secondaryMlfbs)
{
    var aSecondaryMlfb = secondaryMlfbs.split(";");
    
    var aSecondaryMlfbClean = [];
    
    for (var i = 0; aSecondaryMlfb && i < aSecondaryMlfb.length; i++)
    {
        // MLFB vereinheitlichen
        secondaryMlfb = aSecondaryMlfb[i].toUpperCase().replace("-", "");
        
        // MLFB auf unzulssige Zeichen berprfen
        var illegalChars = secondaryMlfb.match(/[^a-zA-Z0-9.]/g);
        
        // MLFB-Fehler diagnostizieren & ausgeben
        if (illegalChars && illegalChars.length > 1)
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G110M_MLFB_SEC_CHAR_INVALID"));
            return false;
        }
        
        aSecondaryMlfbClean.push(secondaryMlfb);
    }
    
    // vereinheitlichtes (strukturell korrektes) Array von Sekundr-MLFBs zurckgeben
    return aSecondaryMlfbClean;
}

// Context Attributes setzen, falls durch SIZER bergeben
function setContextAttributes()
{
    // Feldbusschnittstelle / Kommunikation
    var sFieldbusInterfaceContext = ECL_GetValue("ECSI_CX_FieldbusInterface");
    
    if (sFieldbusInterfaceContext)
    {
        var iCxFieldbusInterface = parseInt(sFieldbusInterfaceContext);
        var sFieldbusInterfaceValue = getFieldBusInterfaceValue(iCxFieldbusInterface);
        
        ECL_SelectValue("TAK_AAJ352_001_000_G110M", sFieldbusInterfaceValue);
        
        if (iCxFieldbusInterface < 0 || iCxFieldbusInterface > 3)
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G110M_CONTEXT_FIELDBUS_INTERFACE_INVALID") + " " + cxFieldbusInterface);
            return false;
        }
    }
    else
    {
        // Standardmig immer PROFINET fr Kommunikation vorbelegen
        // (z.B. falls alle Kommunikation- / Feldbusschnittstellen vom SIZER als zulssig gemeldet werden)
        ECL_SelectValue("TAK_AAJ352_001_000_G110M", "PROFINET");
    }
    
    
    // Regenerativer Betrieb
    var sRegenerativeModeContext = ECL_GetValue("ECSI_CX_RegenerativeMode");
    
    if (sRegenerativeModeContext && sRegenerativeModeContext != "0")
    {
        var iCxRegenerativeMode = parseInt(sRegenerativeModeContext);
        
        // Bremswiderstand nur bei Kontext 'Energie abfhren' aktivieren
        // und Attribut sperren (um nderung von SIZER-Vorgabe durch Anwender zu verhindern)
        if (iCxRegenerativeMode == 2)
        {
            ECL_SelectValue("HMK_BREMSWIDERSTAND_G110M", "T");
            ECL_DisableAttribute("HMK_BREMSWIDERSTAND_G110M");
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G110M_CONTEXT_REGENERATIVE_MODE_INVALID") + " " + cxRegenerativeMode);
            return false;
        }
    }
    
    return true;
}

// bergebenen Feldbus-Kontext in realen Konfigurationswert bersetzen
function getFieldBusInterfaceValue(cxFieldbusInterface)
{
    switch (cxFieldbusInterface)
    {
        case 0:
            return "PROFINET";
            break;
        case 1:
            return "PROFIBUS";
            break;
        case 2:
            return "ASI";
            break;
        case 3:
            return "USS";
            break;
        default:
            return false;
    };
}

// Konfigurationsbewertungszustand an durch SIZER bergebene Sekundr-MLFBs anpassen
function applySecondaryMlfbs(aDeviations)
{
    for (var i = 0; aDeviations && i < aDeviations.length; i++)
    {
        ECL_SelectValue(aDeviations[i].A, aDeviations[i].expectedV);
    }
}