//@legacy
/**
*   Main script for configuration object CFG_SIEMENS_G115D
*
* 	Date: 2020-06-14
* 	User: Andreas Hller, Plan Software GmbH
*/

// include easyKAT Configuration Library


// include additional scripts
//@import "CFG_SIEMENS_G115D_GLOBAL.js"

//@import "CFG_SIEMENS_G115D_DEP.js"

//@import "SIZER_general_functions.js"


//#mode(full-ecma)


/*
WM
6SL3520.X..11A.0
6SL3520.X..11A.0

[{"mlfb":"6SL30544AG002AA0-Z F01","manufacturer":"","articleText":"SINAMICS SD card 512 MB empty F01: 1 X SAFETY LICENSE DBSI"}]
6SL35200XA611AF0

MM
6SL35500XA415AF0
6SL35500XA415AF0
*/
globalThis.OnChangeConfiguration = function main()
{
    var strchangedAttribute = ECL_GetCurrentAttribute();
    logtraceln("Changed Attribute="+strchangedAttribute);
    if(strchangedAttribute.left(7) == "ECSI_CX"){
        return;
    }

    ECL_SelectValue("ECSI_STATUS", "OK");
    ECL_ResetAttribute("ECSI_STATUS_MESSAGE");
    
    // Use general function to extract (preselection) data provided by TST in attribute ECSI_MLFB
    SetAttributesFromMlfb();
    
    var currentAttribute = ECL_GetCurrentAttribute();
    var currentValue     = ECL_GetValue(currentAttribute);
    var primaryMlfb      = ECL_GetValue("ECSI_MLFB");
    var baseTypeMlfb     = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    var secondaryMlfbs   = GetMlfbSec();
    
    // Dummy Aufrufe von SIZER unterdrcken
    if (currentAttribute == ''){
        return;
    }
    
    // Vorverarbeitung
    primaryMlfb=manageKeepconfig(primaryMlfb);
    SetSystemVariables(primaryMlfb, baseTypeMlfb, secondaryMlfbs);
    //Nochmal Laden, da gegebenenfalls gendert
    var baseTypeMlfb     = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    
    // Initialisierung: Vorbelegungen setzen
    //var brakeValue = ECL_GetValue("UI_HMK_BREMSWIDERSTAND_G115D");
    //var brakeValues = ECL_GetAllSelectedAttributeValues("UI_HMK_BREMSWIDERSTAND_G115D");
    
    if (currentAttribute == "@INIT@")
    {
        selectDefaults();
    }
    else
    {
        // Context-Attribute setzen
        setContextAttributes();
        
        // Abhngigkeiten zwischen Werten anwenden ("klassische" Konfigurationslogik)
        applyDependencies(primaryMlfb);
        
        // Primr-MLFB & Rumpf-MLFB berprfen
        var checkedPrimaryMlfbs = checkPrimaryMlfb(primaryMlfb, baseTypeMlfb);
        primaryMlfb  = checkedPrimaryMlfbs[0];
        baseTypeMlfb = checkedPrimaryMlfbs[1];
        
        // Abbruch, falls Primr-MLFB ungltig
        if (!primaryMlfb)
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            return;
        }
        
        // Primr-MLFB initial vervollstndigen und anschlieend bei jeder 'echten' Bewertung aktualisieren
        if (currentAttribute != "ECSI_MLFB" || primaryMlfb.indexOf(".") > 0)
        {
            // Primr-MLFB auf Basis des aktuellen Konfigurationszustands aktualisieren
            primaryMlfb = updatePrimaryMlfb(primaryMlfb);
        }
        
        if ( currentAttribute === "UI_HMK_BREMSWIDERSTAND_G115D" )
        {
            var brakeValue = ECL_GetValue("UI_HMK_BREMSWIDERSTAND_G115D");
            var brakeValues = ECL_GetAllSelectedAttributeValues("UI_HMK_BREMSWIDERSTAND_G115D");
            if(brakeValue === "00001-00001" || brakeValue === "00001-00002")
            {
                brakeValue = "00001";
            }
            ECL_SelectValue("HMK_BREMSWIDERSTAND_G115D", brakeValue);
        }
        
        // 10 or 20 watt braking resistor
        setBrakingResistorUiFromDb();

        // Sekundr-MLFBs (fr Zubehr) auf Basis des aktuellen Konfigurationszustands aktualisieren
        updateSecondaryMlfbs(primaryMlfb);
        
        // Alle von Primr-MLFB abhngigen Attribute setzen
        setAttributesFromPrimaryMlfb(primaryMlfb, baseTypeMlfb);
        
        ECL_SetValue("ECSI_MLFB", primaryMlfb);
        
        // Sekundr-MLFBs strukturell berprfen & in Array (statt String-Liste) umwandeln
         var aSecondaryMlfbs = checkSecondaryMlfb(secondaryMlfbs);

        // Falls Sekundr-MLFBs vom SIZER bergeben wurden
        if (secondaryMlfbs != "")
        {
        
            
            if (aSecondaryMlfbs && aSecondaryMlfbs.length > 0)
            {
                // Sekundr-MLFBs nur bei MLFB-bergabeaufruf auswerten (NICHT bei einer 'echten' Bewertung!)
                if (currentAttribute == "ECSI_MLFB")
                {
                    // zu whlendes Zubehr (AV-Liste) aus Sekundr-MLFBs ermitteln ("Rckwrts-Prfung")
                    var aAccToSelect = getAccParts(aSecondaryMlfbs);
                    
                    // aktuelle Konfigurationsbewertung gegen AV-Liste (ermittelt auf Basis bergebener Sekundr-MLFBs) prfen
                    var aDeviations = checkAccToSelect(aAccToSelect);
                    
                    // Abweichungen ausgleichen (durch SIZER explizit bergebene Sekundr-MLFBs "gewinnen immer")
                    applySecondaryMlfbs(aDeviations);
                }
            }
            // Abbruch, falls Sekundr-MLFB ungltig
            else
            {
                ECL_SelectValue("ECSI_STATUS", "E");
                return;
            }
        }
        
        ECL_SetValue("ECSI_MLFB", primaryMlfb);
        
        // Consequence-Attribute setzen
        setConsequenceAttributes(primaryMlfb, aSecondaryMlfbs);
        
        var sError = ECL_GetValue("ECSI_STATUS_MESSAGE");
        
        if (!sError)
        {
            // MLFB bergabestatus auf OK setzen & Statusmeldung (Fehlermeldung) lschen
            ECL_SelectValue("ECSI_STATUS", "OK");
            ECL_ResetAttribute("ECSI_STATUS_MESSAGE");
        }
        else if (sError.includes("WARNING")) {
            ECL_SelectValue("ECSI_STATUS", "WARNING");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sError));
        }
        else
        {
            ECL_SelectValue("ECSI_STATUS", "E");
        }
    }
}