//@legacy
/**
* 	Script for database functions G115D
*
* 	Date: 2020-06-14
* 	User: Andreas Hller, Plan Software GmbH
*/

// include easyKAT Configuration Library


// include additional scripts
//@import "CFG_SIEMENS_G115D_GLOBAL.js"


//#mode(full-ecma)


/////////////////////////////////////
// LOGIK ATTRIBUTE AUS PRIMR-MLFB //
/////////////////////////////////////

// Schutzart IP & Einbaulage aus Rumpf-MLFB ermitteln
// VT_G115D_M00006_26350
function setIpProtectionClassMountingPosition(baseTypeMlfb)
{
    if (baseTypeMlfb.substr(5, 1) != ".")
    {
        var sQuery = "select * from VT_G115D_M00006_26350 where MLFB06_G115D = ?;";
        var aParam = [baseTypeMlfb.substr(5, 1)];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Schutzart IP & Einbaulage auswhlen und einfrieren (da derzeit hart durch Rumpf-MLFB vom SIZER vorgeben)
            ECL_FreezeSingleValue("PMD_ABJ176_001_000_G115D", aDbResult[0].PMD_ABJ176_001_000_G115D); // Schutzart IP
            ECL_FreezeSingleValue("PMD_AAA566_001_000_G115D", aDbResult[0].PMD_AAA566_001_000_G115D); // Einbaulage
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_IP_PROTECTION_CLASS_MOUNTING_POSITION_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}

// Bremsenspannung aus Primr-MLFB ermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00054_26350
function setBrakeVoltage(primaryMlfb)
{
    if (primaryMlfb.substr(6, 1) != ".")
    {
        var sQuery = "select * from VT_G115D_M00054_26350 where MLFB07_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [primaryMlfb.substr(6, 1), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            ECL_SelectValue("HMK_BREMSENSPANNUNG_G115D", aDbResult[0].HMK_BREMSENSPANNUNG_G115D); // Bremsenspannung
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_BRAKE_VOLTAGE_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}

// Bedienoption aus Primr-MLFB ermitteln
// VT_G115D_M00098_26350
function setInputOption(primaryMlfb)
{
    if (primaryMlfb.substr(7, 1) != ".")
    {
        var sQuery = "select * from VT_G115D_M00098_26350 where MLFB08_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [primaryMlfb.substr(7, 1)];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            ECL_SelectValue("HMK_BEDIENOPTION_G115D", aDbResult[0].HMK_BEDIENOPTION_G115D); // Bedienoption
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_INPUT_OPTION_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}

// EMV Kategorie aus Rumpf-MLFB ermitteln
// VT_G115D_M00011_26350
function setEmvCategory(baseTypeMlfb)
{
    if (baseTypeMlfb.substr(13, 1) != ".")
    {
        var sQuery = "select * from VT_G115D_M00011_26350 where MLFB14_G115D = ?;";
        var aParam = [baseTypeMlfb.substr(13, 1)];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // EMV Kategorie auswhlen und einfrieren (da derzeit nur ein gltiger Wert in VT_G115D_M00011_26350 verfgbar & hart durch Rumpf-MLFB vom SIZER vorgeben)
            ECL_FreezeSingleValue("HMK_FILTERKLASSE_G115D", aDbResult[0].HMK_FILTERKLASSE_G115D);     // EMV Kategorie
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_EMV_CATEGORY_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}

// Kommunikation aus Primr-MLFB ermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00053_26350
function setCommunication(primaryMlfb)
{
    if (primaryMlfb.substr(14, 1) != ".")
    {
        var sQuery = "select * from VT_G115D_M00053_26350 where MLFB15_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [primaryMlfb.substr(14, 1), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            ECL_SelectValue("HMK_KOMMUNIKATION_G115D", aDbResult[0].HMK_KOMMUNIKATION_G115D);   // Kommunikation
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_COMMUNICATION_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}

// Bauform des Umrichters aus Rumpf-MLFB ermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00052_26350
function setInverterDesign(baseTypeMlfb)
{
    if (baseTypeMlfb.substr(5, 1) != "." && baseTypeMlfb.substr(11, 1) != "." && baseTypeMlfb.substr(12, 1) != ".")
    {
        var sQuery = "select * from VT_G115D_M00052_26350 where MLFB06_G115D = ? and HMK_MLFB_12_13_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [baseTypeMlfb.substr(5, 1), baseTypeMlfb.substr(11, 1) + baseTypeMlfb.substr(12, 1), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Bauform des Umrichters auswhlen und einfrieren (da derzeit hart durch Rumpf-MLFB vom SIZER vorgeben)
            ECL_FreezeSingleValue("PMD_ABW171_001_000_G115D", aDbResult[0].PMD_ABW171_001_000_G115D); // Bauform des Umrichters
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_INVERTER_DESIGN_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}

// Wertepool fr Anschlussatz Kabelverschraubung aus Rumpf-MLFB ermitteln
// VT_G115D_M00038_26350
function restrictGlandInstallationKit(baseTypeMlfb)
{
    if (baseTypeMlfb.substr(5, 1) != ".")
    {
        var sQuery = "select distinct HMK_ANSCHLUSSS_KABEL_G115D from VT_G115D_M00038_26350 where MLFB06_G115D = ? and HMK_MLFB_10_11_G115D like ?;";
        var aParam = [baseTypeMlfb.substr(5, 1), "%" + baseTypeMlfb.substr(9, 1).replace(".","") + baseTypeMlfb.substr(10, 1).replace(".","") + "%"];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Checkbox-Attribut ausgrauen
            ECL_DisableAttribute("HMK_ANSCHLUSSS_KABEL_G115D");
            
            for (var i = 0; i < aDbResult.length; i++)
            {
                // Attribut wieder bewertbar machen, wenn einzig gltiger Wert 'T' in Resultset enthalten ist
                if (aDbResult[i].HMK_ANSCHLUSSS_KABEL_G115D == "T")
                {
                    ECL_EnableAttribute("HMK_ANSCHLUSSS_KABEL_G115D"); // Anschlussatz Kabelverschraubung
                }
            }
            
            // Falls Attribut nicht mehr enabled ist, eventuell bestehenden Wert lschen
            if (!ECL_AttributeEnabled("HMK_ANSCHLUSSS_KABEL_G115D"))
            {
                ECL_ResetAttribute("HMK_ANSCHLUSSS_KABEL_G115D");
            }
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_GLAND_INSTALLATION_KIT_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}

// Wertepool fr Quickon Mutter aus Primr-MLFB ermitteln
// VT_G115D_M00039_26350
function restrictQuickonNut(primaryMlfb)
{
    if (primaryMlfb.substr(9, 1) != ".")
    {
        var sQuery = "select distinct HMK_QUICKON_MUTTER_G115D from VT_G115D_M00039_26350 where MLFB10_G115D = ?;";
        var aParam = [primaryMlfb.substr(9, 1)];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Checkbox-Attribut ausgrauen
            ECL_DisableAttribute("HMK_QUICKON_MUTTER_G115D");
            
            for (var i = 0; i < aDbResult.length; i++)
            {
                // Attribut wieder bewertbar machen, wenn einzig gltiger Wert 'T' in Resultset enthalten ist
                if (aDbResult[i].HMK_QUICKON_MUTTER_G115D == "T")
                {
                    ECL_EnableAttribute("HMK_QUICKON_MUTTER_G115D"); // Quickon Mutter
                }
            }
            
            // Falls Attribut nicht mehr enabled ist, eventuell bestehenden Wert lschen
            if (!ECL_AttributeEnabled("HMK_QUICKON_MUTTER_G115D"))
            {
                ECL_ResetAttribute("HMK_QUICKON_MUTTER_G115D");
            }
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_QUICKON_NUT_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}

// Wertepool fr Quickon Steckverbinder aus Primr-MLFB ermitteln
// VT_G115D_M00040_26350
function restrictQuickonConnector(primaryMlfb)
{
    if (primaryMlfb.substr(9, 1) != ".")
    {
        var sQuery = "select distinct HMK_QUICKON_STECKVER_G115D from VT_G115D_M00040_26350 where MLFB10_G115D = ?;";
        var aParam = [primaryMlfb.substr(9, 1)];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Checkbox-Attribut ausgrauen
            ECL_DisableAttribute("HMK_QUICKON_STECKVER_G115D");
            
            for (var i = 0; i < aDbResult.length; i++)
            {
                // Attribut wieder bewertbar machen, wenn einzig gltiger Wert 'T' in Resultset enthalten ist
                if (aDbResult[i].HMK_QUICKON_STECKVER_G115D == "T")
                {
                    ECL_EnableAttribute("HMK_QUICKON_STECKVER_G115D"); // Quickon Steckverbinder
                }
            }
            
            // Falls Attribut nicht mehr enabled ist, eventuell bestehenden Wert lschen
            if (!ECL_AttributeEnabled("HMK_QUICKON_STECKVER_G115D"))
            {
                ECL_ResetAttribute("HMK_QUICKON_STECKVER_G115D");
            }
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_QUICKON_CONNECTOR_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}

// Schnittstellen (DC 24V-Versorgung, Anschlussart, 3AC 400V Anschluss, DC 24V Anschluss, Kommunikation, Ein- / Ausgnge & Motor) aus Primr-MLFB ermitteln
// VT_G115D_M00041_26350
function setInterfaces(primaryMlfb)
{
    if (primaryMlfb.substr(5, 1) != "." && primaryMlfb.substr(9, 1) != "." && primaryMlfb.substr(10, 1) != "." && primaryMlfb.substr(14, 1) != ".")
    {
        var sQuery = "select distinct HMK_DC_24V_VERSORG_G115D, HMK_ANSCHLUSSART_G115D, HMK_3AC_400V_ANSCHL_G115D, HMK_DC_24V_ANSCHL_G115D, HMK_ANSCHL_KOMM_G115D, HMK_IO_G115D, HMK_MOTOR_G115D from VT_G115D_M00041_26350 where MLFB06_G115D = ? and HMK_MLFB_10_11_G115D = ? and MLFB15_G115D = ?;";
        var aParam = [primaryMlfb.substr(5, 1), primaryMlfb.substr(9, 1) + primaryMlfb.substr(10, 1), primaryMlfb.substr(14, 1)];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Auswahl von DC 24V-Versorgung aktualisieren
            ECL_SelectValue("HMK_DC_24V_VERSORG_G115D", aDbResult[0].HMK_DC_24V_VERSORG_G115D);
            
            // Auswahl von Anschlussart aktualisieren
            ECL_SelectValue("HMK_ANSCHLUSSART_G115D", aDbResult[0].HMK_ANSCHLUSSART_G115D);
            
            // Auswahl von 3AC 400V Anschluss aktualisieren
            ECL_SelectValue("HMK_3AC_400V_ANSCHL_G115D", aDbResult[0].HMK_3AC_400V_ANSCHL_G115D);
            
            // Auswahl von DC 24V Anschluss aktualisieren
            ECL_SelectValue("HMK_DC_24V_ANSCHL_G115D", aDbResult[0].HMK_DC_24V_ANSCHL_G115D);
            
            // Auswahl von Kommunikation aktualisieren
            ECL_SelectValue("HMK_ANSCHL_KOMM_G115D", aDbResult[0].HMK_ANSCHL_KOMM_G115D);
            
            // Auswahl von Ein- / Ausgnge aktualisieren
            ECL_SelectValue("HMK_IO_G115D", aDbResult[0].HMK_IO_G115D);
            
            // Auswahl von Motor aktualisieren
            ECL_SelectValue("HMK_MOTOR_G115D", aDbResult[0].HMK_MOTOR_G115D);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_DATA_FOR_INTERFACES_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}

// Wertepool Service ermitteln
// VT_G115D_M00110_26350
function restrictService(primaryMlfb)
{
    if (find (primaryMlfb, ".") < 0)
    {
        var sQuery = "select distinct HMK_SVC_SCHUTZ_G115D from VT_G115D_M00115_26350 where HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            ECL_DeactivateAllAttributeValues("HMK_SVC_SCHUTZ_G115D");
         
            for (var i = 0; i < aDbResult.length; i++)
            {
                // Attribut wieder bewertbar machen, wenn einzig gltiger Wert 'T' in Resultset enthalten ist
               ECL_ActivateValue("HMK_SVC_SCHUTZ_G115D", aDbResult[i].HMK_SVC_SCHUTZ_G115D);
            }
        
            var currentValue = ECL_GetValue("HMK_SVC_SCHUTZ_G115D");
    
            if (!ECL_ValueEnabled("HMK_SVC_SCHUTZ_G115D", currentValue))
            {
                ECL_SelectValue("HMK_SVC_SCHUTZ_G115D", "OHNE");
            }
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_SERVICE_FOR_PRIMARY_MLFB"));
        }
    }
}

// Wertepool fr MindCon IOT ermitteln
// VT_G115D_M00109_26350
function restrictMindCon_IOT(primaryMlfb)
{
    if (primaryMlfb.substr(9, 1) != ".")
    {
        var sQuery = "select distinct HMK_MINDCON_IOT_G115D from VT_G115D_M00109_26350 where HMK_KOMMUNIKATION_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("HMK_KOMMUNIKATION_G115D"), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Checkbox-Attribut ausgrauen
            ECL_DisableAttribute("HMK_MINDCON_IOT_G115D");
            
            for (var i = 0; i < aDbResult.length; i++)
            {
                // Attribut wieder bewertbar machen, wenn einzig gltiger Wert 'T' in Resultset enthalten ist
                if (aDbResult[i].HMK_MINDCON_IOT_G115D == "T")
                {
                    ECL_EnableAttribute("HMK_MINDCON_IOT_G115D");
                }
            }
            
            // Falls Attribut nicht mehr enabled ist, eventuell bestehenden Wert lschen
            if (!ECL_AttributeEnabled("HMK_MINDCON_IOT_G115D"))
            {
                ECL_ResetAttribute("HMK_MINDCON_IOT_G115D");
            }
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_MINDCON_IOT_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}

// Wertepool fr MindCon Nano ermitteln
// VT_G115D_M00109_26350
function restrictMindCon_NANO(primaryMlfb)
{
    if (primaryMlfb.substr(9, 1) != ".")
    {
        var sQuery = "select distinct HMK_MINDCON_NANO_G115D from VT_G115D_M00109_26350 where HMK_KOMMUNIKATION_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("HMK_KOMMUNIKATION_G115D"), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Checkbox-Attribut ausgrauen
            ECL_DisableAttribute("HMK_MINDCON_NANO_G115D");
            
            for (var i = 0; i < aDbResult.length; i++)
            {
                // Attribut wieder bewertbar machen, wenn einzig gltiger Wert 'T' in Resultset enthalten ist
                if (aDbResult[i].HMK_MINDCON_NANO_G115D == "T")
                {
                    ECL_EnableAttribute("HMK_MINDCON_NANO_G115D");
                }
            }
            
            // Falls Attribut nicht mehr enabled ist, eventuell bestehenden Wert lschen
            if (!ECL_AttributeEnabled("HMK_MINDCON_NANO_G115D"))
            {
                ECL_ResetAttribute("HMK_MINDCON_NANO_G115D");
            }
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_NO_VALID_MINDCON_NANO_FOUND_FOR_PRIMARY_MLFB"));
        }
    }
}
//////////////////////////////////////
// LOGIK PRIMR-MLFB AUS ATTRIBUTEN //
//////////////////////////////////////

// Primr-MLFB Stelle 6 aus Schutzart IP & Einbaulage ermitteln
// VT_G115D_M00006_26350
function getMlfbPosFromIpProtectionClassMountingPosition(aPrimaryMlfb)
{
    if (ECL_GetValue("PMD_ABJ176_001_000_G115D") && ECL_GetValue("PMD_AAA566_001_000_G115D"))
    {
        var sQuery = "select MLFB06_G115D from VT_G115D_M00006_26350 where PMD_ABJ176_001_000_G115D = ? and PMD_AAA566_001_000_G115D = ?;";
        var aParam = [ECL_GetValue("PMD_ABJ176_001_000_G115D"), ECL_GetValue("PMD_AAA566_001_000_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            aPrimaryMlfb[5] = aDbResult[0].MLFB06_G115D;
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00006_26350'"));
        }
    }
    
    return aPrimaryMlfb;
}

function getValidValuesForMLFB06() {
    var sQuery = "select distinct MLFB06_G115D from VT_G115D_M00006_26350;";
    var aParam = [];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    return aDbResult.map(x => x.MLFB06_G115D);
}

// Primr-MLFB Stelle 7 aus Bremsenspannung ermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00054_26350
function getMlfbPosFromBrakeVoltage(aPrimaryMlfb)
{
    if (ECL_GetValue("HMK_BREMSENSPANNUNG_G115D"))
    {
        var sQuery = "select MLFB07_G115D from VT_G115D_M00054_26350 where HMK_BREMSENSPANNUNG_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("HMK_BREMSENSPANNUNG_G115D"), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            aPrimaryMlfb[6] = aDbResult[0].MLFB07_G115D;
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00054_26350'"));
        }
    }
    
    return aPrimaryMlfb;
}

function getValidValuesForMLFB07() {
    var sQuery = "select distinct MLFB07_G115D from VT_G115D_M00054_26350;";
    var aParam = [];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    return aDbResult.map(x => x.MLFB07_G115D);
}

// Primr-MLFB Stelle 8 aus Bedienoption ermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00098_26350
function getMlfbPosFromInputOption(aPrimaryMlfb)
{
    if (ECL_GetValue("HMK_BEDIENOPTION_G115D"))
    {
        var sQuery = "select MLFB08_G115D from VT_G115D_M00098_26350 where HMK_BEDIENOPTION_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("HMK_BEDIENOPTION_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            aPrimaryMlfb[7] = aDbResult[0].MLFB08_G115D;
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00098_26350'"));
        }
    }
    
    return aPrimaryMlfb;
}

function getValidValuesForMLFB08() {
    var sQuery = "select distinct MLFB08_G115D from VT_G115D_M00098_26350;";
    var aParam = [];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    return aDbResult.map(x => x.MLFB08_G115D);
}

// Primr-MLFB Stellen 10 & 11 aus DC 24V-Versorgung, Anschlussart, 3AC 400V Anschluss, DC 24V Anschluss, Kommunikation, Ein- / Ausgnge, Motor sowie Primr-MLFB Stellen 6 & 15 ermitteln
// VT_G115D_M00041_26350
function getMlfbPosFromInterfaces(aPrimaryMlfb)
{
    if (ECL_GetValue("HMK_DC_24V_VERSORG_G115D") && ECL_GetValue("HMK_ANSCHLUSSART_G115D") && ECL_GetValue("HMK_3AC_400V_ANSCHL_G115D") && ECL_GetValue("HMK_DC_24V_ANSCHL_G115D") && ECL_GetValue("HMK_ANSCHL_KOMM_G115D") && ECL_GetValue("HMK_IO_G115D") && ECL_GetValue("HMK_MOTOR_G115D") && aPrimaryMlfb[5] != ".")
    {
        var sQuery = "select distinct HMK_MLFB_10_11_G115D from VT_G115D_M00041_26350 where HMK_DC_24V_VERSORG_G115D = ? and HMK_ANSCHLUSSART_G115D = ? and HMK_3AC_400V_ANSCHL_G115D = ? and HMK_DC_24V_ANSCHL_G115D = ? and HMK_ANSCHL_KOMM_G115D = ? and HMK_IO_G115D = ? and HMK_MOTOR_G115D = ? and MLFB06_G115D = ? and MLFB15_G115D like ?;";
        var aParam = [ECL_GetValue("HMK_DC_24V_VERSORG_G115D"), ECL_GetValue("HMK_ANSCHLUSSART_G115D"), ECL_GetValue("HMK_3AC_400V_ANSCHL_G115D"), ECL_GetValue("HMK_DC_24V_ANSCHL_G115D"), ECL_GetValue("HMK_ANSCHL_KOMM_G115D"), ECL_GetValue("HMK_IO_G115D"), ECL_GetValue("HMK_MOTOR_G115D"), aPrimaryMlfb[5], "%" + aPrimaryMlfb[14].replace(".","") + "%"];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            aPrimaryMlfb[9] = aDbResult[0].HMK_MLFB_10_11_G115D.substr(0, 1);
            aPrimaryMlfb[10] = aDbResult[0].HMK_MLFB_10_11_G115D.substr(1, 1);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00098_26350'"));
        }
    }
    
    return aPrimaryMlfb;
}

function getValidValuesForMLFB10_11(aPrimaryMlfb) {
    var sQuery = "select distinct HMK_MLFB_10_11_G115D from VT_G115D_M00041_26350;";
    var aParam = [];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    return aDbResult.map(x => x.HMK_MLFB_10_11_G115D);
}

// Primr-MLFB Stelle 14 aus EMV Kategorie ermitteln
// VT_G115D_M00011_26350
function getMlfbPosFromEmvCategory(aPrimaryMlfb)
{
    if (ECL_GetValue("HMK_FILTERKLASSE_G115D"))
    {
        var sQuery = "select MLFB14_G115D from VT_G115D_M00011_26350 where HMK_FILTERKLASSE_G115D = ?;";
        var aParam = [ECL_GetValue("HMK_FILTERKLASSE_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            aPrimaryMlfb[13] = aDbResult[0].MLFB14_G115D;
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00011_26350'"));
        }
    }
    
    return aPrimaryMlfb;
}

function getValidValuesForMLFB14() {
    var sQuery = "select distinct MLFB14_G115D from VT_G115D_M00011_26350;";
    var aParam = [];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    return aDbResult.map(x => x.MLFB14_G115D);
}

// Primr-MLFB Stelle 15 aus Kommunikation ermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00053_26350
function getMlfbPosFromCommunication(aPrimaryMlfb)
{
    if (ECL_GetValue("HMK_KOMMUNIKATION_G115D"))
    {
        var sQuery = "select MLFB15_G115D from VT_G115D_M00053_26350 where HMK_KOMMUNIKATION_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("HMK_KOMMUNIKATION_G115D"), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            aPrimaryMlfb[14] = aDbResult[0].MLFB15_G115D;
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00053_26350'"));
        }
    }
    
    return aPrimaryMlfb;
}

function getValidValuesForMLFB15() {
    var sQuery = "select distinct MLFB15_G115D from VT_G115D_M00053_26350;";
    var aParam = [];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    return aDbResult.map(x => x.MLFB15_G115D);
}

/////////////////////////////////////////
// LOGIK SEKUNDR-MLFBs AUS ATTRIBUTEN //
/////////////////////////////////////////

// Sekundr-MLFBs des Leistungsschalters abhngig von Bauform des Umrichters & Leistungsschalter ermitteln
// VT_G115D_M00032_26350
function getPowerSwitch()
{
    if (ECL_GetValue("PMD_ABW171_001_000_G115D") && ECL_GetValue("HMK_LEISTUNGSSCHALT_G115D"))
    {
        var sQuery = "select distinct HMK_MLFB_LEISTUNGSSC_G115D from VT_G115D_M00032_26350 where PMD_ABW171_001_000_G115D = ? and HMK_LEISTUNGSSCHALT_G115D = ?;";
        var aParam = [ECL_GetValue("PMD_ABW171_001_000_G115D"), ECL_GetValue("HMK_LEISTUNGSSCHALT_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFBs des Leistungsschalters zurckgeben
            return aDbResult[0].HMK_MLFB_LEISTUNGSSC_G115D;
        }
    }
    
    return "NONE";
}

// Sekundr-MLFBs der Sicherung abhngig von Bauform des Umrichters & Art der Sicherung ermitteln
// VT_G115D_M00033_26350
function getFuseType()
{
    if (ECL_GetValue("PMD_ABW171_001_000_G115D") && ECL_GetValue("HMK_ART_SICHERUNG_G115D"))
    {
        var sQuery = "select distinct HMK_MLFB_SICHERUNG_G115D from VT_G115D_M00033_26350 where PMD_ABW171_001_000_G115D = ? and HMK_ART_SICHERUNG_G115D = ?;";
        var aParam = [ECL_GetValue("PMD_ABW171_001_000_G115D"), ECL_GetValue("HMK_ART_SICHERUNG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFBs der Sicherung zurckgeben
            // Sonderfall: 3x Sekundr-MLFB zurckgeben, da 3-phasiger Umrichter
            return [aDbResult[0].HMK_MLFB_SICHERUNG_G115D, aDbResult[0].HMK_MLFB_SICHERUNG_G115D, aDbResult[0].HMK_MLFB_SICHERUNG_G115D];
        }
    }
    
    return "NONE";
}

// Sekundr-MLFBs des Bremswiderstands abhngig von Bauform des Umrichters & Bremswiderstand ermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00058_26350
// >
function getBrakingResistor()
{
    var PMD_ABW171 = ECL_GetValue("PMD_ABW171_001_000_G115D");
    var brakingResistor = ECL_GetValue("HMK_BREMSWIDERSTAND_G115D");
    if (ECL_GetValue("PMD_ABW171_001_000_G115D") && ECL_GetValue("HMK_BREMSWIDERSTAND_G115D"))
    {
        var sQuery = "select distinct HMK_MLFB_BREMSWIDERS_G115D from VT_G115D_M00058_26350 where PMD_ABW171_001_000_G115D = ? and HMK_BREMSWIDERSTAND_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("PMD_ABW171_001_000_G115D"), ECL_GetValue("HMK_BREMSWIDERSTAND_G115D"), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // TODO update ui braking resistor
            setBrakingResistorUiFromDb();
            
            // Sekundr-MLFBs des Bremswiderstands zurckgeben
            return aDbResult[0].HMK_MLFB_BREMSWIDERS_G115D;
        }
    }
    
    return "NONE";
}

// Sekundr-MLFB der Speicherkarte ermitteln
// VT_G115D_M00050_26350
function getSdCard()
{
    var val1 = ECL_GetValue("PMD_AAA566_001_000_G115D");
    var val2 = ECL_GetValue("HMK_SPEICHERKARTE_G115D");

    if (val2 === "00002") 
    {
        ECL_ActivateAttribute("HMK_FIRMWARE_G115D");

        if (ECL_GetValue("HMK_FIRMWARE_G115D") === "") 
            ECL_SelectValue("HMK_FIRMWARE_G115D", getLatestFirmwareVersion());

        return "NONE";
    }

    ECL_DeactivateAttribute("HMK_FIRMWARE_G115D");

    if (ECL_GetValue("PMD_AAA566_001_000_G115D") && ECL_GetValue("HMK_SPEICHERKARTE_G115D"))
    {
        var strSLS="";
        if (ECL_GetValue("HMK_F01_G115D")=="T")
        {
            strSLS="F01";
        }
        else
        {
            strSLS="NON";
        }

        var sQuery = "select distinct HMK_MLFB_SPEICHERKAR_G115D from VT_G115D_M00117_26350 where PMD_AAA566_001_000_G115D = ? and HMK_SPEICHERKARTE_G115D = ? AND HMK_F01_G115D = ?;";
        var aParam = [ECL_GetValue("PMD_AAA566_001_000_G115D"), ECL_GetValue("HMK_SPEICHERKARTE_G115D"), strSLS];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFB der Speicherkarte zurckgeben
            var strSD = aDbResult[0].HMK_MLFB_SPEICHERKAR_G115D;
            if(strSLS=="F01")
                return strSD + "-Z F01";
            else
                return strSD;
        }
    }
    return "NONE";
}

function getFirmwareVersion() {
    if (ECL_GetValue("HMK_SPEICHERKARTE_G115D") === "00002") {
        var selectedFirmwareVersion = ECL_GetValue("HMK_FIRMWARE_G115D");
        
        if (selectedFirmwareVersion === "VERSION_4_7_SP13") {
            ECL_SetValue("ECSI_STATUS_MESSAGE", "WARNING_OUTDATED_FIRMWARE");
        } else if (selectedFirmwareVersion === "VERSION_4_7_SP14") {
            ECL_SetValue("ECSI_STATUS_MESSAGE", "");
        }

        var sls = "";
        if (ECL_GetValue("HMK_F01_G115D")=="T")
            sls = "F01";
        
        var mlfb = getFirmwareMLFB(ECL_GetValue("HMK_FIRMWARE_G115D"), sls);
        
        if (sls !== "") {
            return mlfb + "-Z " + sls;
        }

        return mlfb;
    }

    return "NONE";
}

function getDriveSimDesigner() {
    if (ECL_GetValue("HMK_DRIVESIM_DESIGNER_G115D"))
    {
        var sQuery = "select HMK_MLFB_DRV_SIM_DES_G115D from VT_G115D_M00121_26350 where HMK_DRV_SIM_DESIGNER_G115D like '%T%';";
        var aParam = [ECL_GetValue("HMK_DRIVESIM_DESIGNER_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFB des DriveSim Designer zurckgeben
            return aDbResult[0].HMK_MLFB_DRV_SIM_DES_G115D;
        }
    }

    return "NONE";
}

function getFirmwareMLFB(param, sls) {
    var sQuery = "select MLFB from FIRMWARE where VERSION = ?";
    var version = [processVersion(param)];

    if (sls !== "") {
        sQuery += " and SHORT_OPTIONS = ?";
        version.push(sls);
    }

    var aDbResult = Object.fromDatabase("G115D_FIRMWARE", sQuery, version);

    return aDbResult[0].MLFB;
}

function getLatestFirmwareVersion() {
    var sQuery = "select VERSION from FIRMWARE where NEWEST is 'true'";
    var aDbResult = Object.fromDatabase("G115D_FIRMWARE", sQuery);

    return processVersion(aDbResult[0].VERSION);
}

function processVersion(version) {
    if (version.includes("_")) {
        return processVersionFromUI(version);
    } else {
        return processVersionFromDB(version);
    }
}

function processVersionFromDB(versionFromDB) {
    var result = versionFromDB.replace(".", "_");
    result = result.replace(" ", "_");
    result = "VERSION_" + result.substr(1);

    return result;
}

function processVersionFromUI(versionFromUI) {
    var result = versionFromUI.split("VERSION_")[1];
    result = "V" + result;
    
    parts = result.split("_");
    result1 = "";
    for(var i = 0; i < parts.length; i++) {
        result1 += parts[i];
        
        if (i==0) {
            result1 += ".";
        } else {
            result1 += " ";
        }
    }

    return result1.trim();
}

// Sekundr-MLFB des Smart Access (Webservermoduls) ermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00056_26350
function getSmartAccessWebserverModule()
{
    if (ECL_GetValue("HMK_SMART_ACCESS_G115D"))
    {
        var sQuery = "select distinct HMK_MLFB_SAM_G115D from VT_G115D_M00056_26350 where HMK_SMART_ACCESS_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("HMK_SMART_ACCESS_G115D"), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFB des Smart Access (Webservermoduls) zurckgeben
            return aDbResult[0].HMK_MLFB_SAM_G115D;
        }
    }
    
    return "NONE";
}

// Sekundr-MLFB des Smart Access interface kits ermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00057_26350
function getSmartAccessInterfaceKit()
{
    if (ECL_GetValue("HMK_SMART_ACCESS_INT_G115D"))
    {
        var sQuery = "select distinct HMK_MLFB_SAM_KIT_G115D from VT_G115D_M00057_26350 where HMK_SMART_ACCESS_INT_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("HMK_SMART_ACCESS_INT_G115D"), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFB des Smart Access interface kits zurckgeben
            return aDbResult[0].HMK_MLFB_SAM_KIT_G115D;
        }
    }
    
    return "NONE";
}

// Sekundr-MLFB des MindCon IOT ermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00107_26350
function getMindConIOT()
{
    if (ECL_GetValue("HMK_MINDCON_IOT_G115D"))
    {
        var sQuery = "select distinct HMK_MLFB_MINDCON_IOT_G115D from VT_G115D_M00107_26350 where HMK_MINDCON_IOT_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("HMK_MINDCON_IOT_G115D"), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFB des Smart Access interface kits zurckgeben
            return aDbResult[0].HMK_MLFB_MINDCON_IOT_G115D;
        }
    }
    
    return "NONE";
}

// Sekundr-MLFB des MindCon Nanoermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00108_26350
function getMindConNano()
{
    if (ECL_GetValue("HMK_MINDCON_NANO_G115D"))
    {
        var sQuery = "select distinct HMK_MLFB_MINDCON_NAN_G115D from VT_G115D_M00108_26350 where HMK_MINDCON_NANO_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("HMK_MINDCON_NANO_G115D"), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFB des Smart Access interface kits zurckgeben
            return aDbResult[0].HMK_MLFB_MINDCON_NAN_G115D;
        }
    }
    
    return "NONE";
}

// Sekundr-MLFB des Anschlusssatz Kabelverschraubung ermitteln
// VT_G115D_M00038_26350
function getGlandInstallationKit(primaryMlfb)
{
    if (ECL_GetValue("HMK_ANSCHLUSSS_KABEL_G115D"))
    {
        var sQuery = "select distinct HMK_MLFB_ANSCH_KABEL_G115D from VT_G115D_M00038_26350 where MLFB06_G115D = ? and HMK_ANSCHLUSSS_KABEL_G115D = ?;";
        var aParam = [primaryMlfb.substr(5, 1), ECL_GetValue("HMK_ANSCHLUSSS_KABEL_G115D") == 'T' ? 'T' : 'F'];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFB des Anschlusssatz Kabelverschraubung zurckgeben
            return aDbResult[0].HMK_MLFB_ANSCH_KABEL_G115D;
        }
    }
    
    return "NONE";
}

// Sekundr-MLFB der Quickon Mutter aus Primr-MLFB & Benutzerauswahl ermitteln
// VT_G115D_M00039_26350
function getQuickonNut(primaryMlfb)
{
    if (ECL_GetValue("HMK_QUICKON_MUTTER_G115D"))
    {
        var sQuery = "select distinct HMK_MLFB_QUICKON_MUT_G115D from VT_G115D_M00039_26350 where MLFB10_G115D = ? and HMK_QUICKON_MUTTER_G115D = ?;";
        var aParam = [primaryMlfb.substr(9, 1), ECL_GetValue("HMK_QUICKON_MUTTER_G115D") == 'T' ? 'T' : 'F'];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFB der Quickon Mutter zurckgeben
            return aDbResult[0].HMK_MLFB_QUICKON_MUT_G115D;
        }
    }
    
    return "NONE";
}

// Sekundr-MLFB des Quickon Steckverbinders aus Primr-MLFB & Benutzerauswahl ermitteln
// VT_G115D_M00040_26350
function getQuickonConnector(primaryMlfb)
{
    if (ECL_GetValue("HMK_QUICKON_STECKVER_G115D"))
    {
        var sQuery = "select distinct HMK_MLFB_QUICKON_STE_G115D from VT_G115D_M00040_26350 where MLFB10_G115D = ? and HMK_QUICKON_STECKVER_G115D = ?;";
        var aParam = [primaryMlfb.substr(9, 1), ECL_GetValue("HMK_QUICKON_STECKVER_G115D") == 'T' ? 'T' : 'F'];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFB des Quickon Steckverbinders zurckgeben
            return aDbResult[0].HMK_MLFB_QUICKON_STE_G115D;
        }
    }
    
    return "NONE";
}

// Sekundr-MLFB des Service aus Primr-MLFB & Benutzerauswahl ermitteln
// VT_G115D_M00106_26350
function getService(primaryMlfb)
{
    if (ECL_GetValue("HMK_SVC_SCHUTZ_G115D"))
    {
        var sQuery = "select distinct HMK_SVC_SCHUTZ_MLFB_G115D from VT_G115D_M00106_26350 where MLFB07_G115D = ? and MLFB08_G115D = ? and HMK_MLFB_10_11_G115D = ? and HMK_MLFB_12_13_G115D = ? and MLFB15_G115D = ? and HMK_SVC_SCHUTZ_G115D = ?;";
        var aParam = [primaryMlfb.substr(6, 1),primaryMlfb.substr(7, 1),primaryMlfb.substr(9, 2),primaryMlfb.substr(11,2),primaryMlfb.substr(14,1),ECL_GetValue("HMK_SVC_SCHUTZ_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Sekundr-MLFB des Quickon Steckverbinders zurckgeben
            return aDbResult[0].HMK_SVC_SCHUTZ_MLFB_G115D;
        }
    }
    
    return "NONE";
}


////////////////////////////////////////
// LOGIK ATTRIBUTE AUS SEKUNDR-MLFBs //
////////////////////////////////////////

// Leistungsschalter aus Bauform des Umrichters & Sekundr-MLFBs ermitteln
// VT_G115D_M00032_26350
function setPowerSwitch(aSecondaryMlfbs)
{
    // Platzhalter-Liste fr Prepared Statement aufbauen
    var sSqlParamPlaceholder = "";
    
    for (var i = 0; i < aSecondaryMlfbs.length; i++)
    {
        sSqlParamPlaceholder += "?, ";
    }
    
    var sQuery = "select HMK_LEISTUNGSSCHALT_G115D from VT_G115D_M00032_26350 where HMK_LEISTUNGSSCHALT_G115D <> '00001' and PMD_ABW171_001_000_G115D = ? and HMK_MLFB_LEISTUNGSSC_G115D in (" + sSqlParamPlaceholder.slice(0, -2) + ");";
    var aParam = [ECL_GetValue("PMD_ABW171_001_000_G115D")];
    aParam = aParam.concat(aSecondaryMlfbs);
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    if (aDbResult && aDbResult.length == 1)
    {
        // Bewertung Leistungsschalter zurckgeben
        return {A: "HMK_LEISTUNGSSCHALT_G115D", V: aDbResult[0].HMK_LEISTUNGSSCHALT_G115D};
    }
}

// Art der Sicherung aus Bauform des Umrichters & Sekundr-MLFBs ermitteln
// VT_G115D_M00033_26350
function setFuseType(aSecondaryMlfbs)
{
    // Platzhalter-Liste fr Prepared Statement aufbauen
    var sSqlParamPlaceholder = "";
    
    for (var i = 0; i < aSecondaryMlfbs.length; i++)
    {
        sSqlParamPlaceholder += "?, ";
    }
    
    var sQuery = "select HMK_ART_SICHERUNG_G115D from VT_G115D_M00033_26350 where HMK_ART_SICHERUNG_G115D <> '00001' and PMD_ABW171_001_000_G115D = ? and HMK_MLFB_SICHERUNG_G115D in (" + sSqlParamPlaceholder.slice(0, -2) + ");";
    var aParam = [ECL_GetValue("PMD_ABW171_001_000_G115D")];
    aParam = aParam.concat(aSecondaryMlfbs);
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    if (aDbResult && aDbResult.length == 1)
    {
        // Bewertung Art der Sicherung zurckgeben
        return {A: "HMK_ART_SICHERUNG_G115D", V: aDbResult[0].HMK_ART_SICHERUNG_G115D};
    }
}

// Bremswiderstand aus Bauform des Umrichters & Sekundr-MLFBs ermitteln
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00058_26350
function setBrakingResistor(aSecondaryMlfbs)
{
    // Platzhalter-Liste fr Prepared Statement aufbauen
    var sSqlParamPlaceholder = "";
    
    for (var i = 0; i < aSecondaryMlfbs.length; i++)
    {
        sSqlParamPlaceholder += "?, ";
    }
    
    var sQuery = "select HMK_BREMSWIDERSTAND_G115D from VT_G115D_M00058_26350 where HMK_BREMSWIDERSTAND_G115D <> '00001' AND PMD_ABW171_001_000_G115D = ? and HMK_MLFB_BREMSWIDERS_G115D in (" + sSqlParamPlaceholder.slice(0, -2) + ") and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
    var aParam = [ECL_GetValue("PMD_ABW171_001_000_G115D")];
    aParam = aParam.concat(aSecondaryMlfbs);
    
    // Trigger-Attribut fr Anbau an 2KJ8-Motor hinzufgen
    aParam.push(ECL_GetValue("HMK_SYS_TRIG_G115D"))
    
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    if (aDbResult && aDbResult.length == 1)
    {
        // TODO update UI resistor
        setBrakingResistorUiFromDb();
        
        // Bewertung Art der Sicherung zurckgeben
        return {A: "HMK_BREMSWIDERSTAND_G115D", V: aDbResult[0].HMK_BREMSWIDERSTAND_G115D};
    }
}

// Service aus Sekundr-MLFBs ermitteln
// VT_G115D_M00106_26350
function setService(aSecondaryMlfbs)
{
    // Platzhalter-Liste fr Prepared Statement aufbauen
    var sSqlParamPlaceholder = "";
    
    for (var i = 0; i < aSecondaryMlfbs.length; i++)
    {
        sSqlParamPlaceholder += "?, ";
    }
    
    var sQuery = "select distinct HMK_SVC_SCHUTZ_G115D from VT_G115D_M00106_26350 where HMK_SVC_SCHUTZ_MLFB_G115D in (" + sSqlParamPlaceholder.slice(0, -2) + ") and HMK_VALUE_VALID_G115D = 'T';";
    var aParam = [];
    aParam = aParam.concat(aSecondaryMlfbs);
    
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    if (aDbResult && aDbResult.length == 1)
    {
        // Bewertung Art der Sicherung zurckgeben
        return {A: "HMK_SVC_SCHUTZ_G115D", V: aDbResult[0].HMK_SVC_SCHUTZ_G115D};
    }
}


//////////////////////////////////////////////////
// LOGIK WECHSELBEZIEHUNGEN ZWISCHEN ATTRIBUTEN //
//////////////////////////////////////////////////

// Abhngigkeit zwischen Schutzart IP & Einbaulage
// VT_G115D_M00006_26350
function dependencyIpProtectionClassMounting()
{
    // Gltige Einbaulagen nach Auswahl von Schutzart IP ermitteln
    if (ECL_GetValue("PMD_ABJ176_001_000_G115D"))
    {
        var sQuery = "select distinct PMD_AAA566_001_000_G115D from VT_G115D_M00006_26350 where PMD_ABJ176_001_000_G115D = ?;";
        var aParam = [ECL_GetValue("PMD_ABJ176_001_000_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Wertepool auf gltige Werte einschrnken
            ECL_DeactivateAllAttributeValues("PMD_AAA566_001_000_G115D");
                
            for (var i = 0; i < aDbResult.length; i++)
            {
                ECL_ActivateValue("PMD_AAA566_001_000_G115D", aDbResult[i].PMD_AAA566_001_000_G115D); // Einbaulage
            }
            
            // Vorbelegung aktualisieren
            updateDefaultValue("PMD_AAA566_001_000_G115D", aDbResult[0].PMD_AAA566_001_000_G115D);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00006_26350'"));
        }
    }
}

// Abhngigkeit zwischen Bauform des Umrichters & Leistungsschalter
// VT_G115D_M00032_26350
function dependencyInverterDesignPowerSwitch()
{
    // Gltige Leistungsschalter nach Auswahl von Bauform des Umrichters ermitteln
    if (ECL_GetValue("PMD_ABW171_001_000_G115D"))
    {
        var sQuery = "select distinct HMK_LEISTUNGSSCHALT_G115D from VT_G115D_M00032_26350 where PMD_ABW171_001_000_G115D = ?;";
        var aParam = [ECL_GetValue("PMD_ABW171_001_000_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Wertepool auf gltige Werte einschrnken
            ECL_DeactivateAllAttributeValues("HMK_LEISTUNGSSCHALT_G115D");
                
            for (var i = 0; i < aDbResult.length; i++)
            {
                ECL_ActivateValue("HMK_LEISTUNGSSCHALT_G115D", aDbResult[i].HMK_LEISTUNGSSCHALT_G115D); // Leistungsschalter
            }
            
            // Vorbelegung aktualisieren
            updateDefaultValue("HMK_LEISTUNGSSCHALT_G115D", aDbResult[0].HMK_LEISTUNGSSCHALT_G115D);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00032_26350'"));
        }
    }
}

// Abhngigkeit zwischen Bauform des Umrichters & Bremswiderstand
// (abhngig von Anbau an 2KJ8)
// VT_G115D_M00058_26350
function dependencyInverterDesignBrakingResistor()
{
    // Gltige Bremswiderstnde nach Auswahl von Bauform des Umrichters ermitteln
    if (ECL_GetValue("PMD_ABW171_001_000_G115D"))
    {
        var sQuery = "select distinct HMK_BREMSWIDERSTAND_G115D from VT_G115D_M00058_26350 where PMD_ABW171_001_000_G115D = ? and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aParam = [ECL_GetValue("PMD_ABW171_001_000_G115D"), ECL_GetValue("HMK_SYS_TRIG_G115D")];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Wertepool auf gltige Werte einschrnken
            ECL_DeactivateAllAttributeValues("HMK_BREMSWIDERSTAND_G115D");
            ECL_DeactivateAllAttributeValues("UI_HMK_BREMSWIDERSTAND_G115D");
                
            for (var i = 0; i < aDbResult.length; i++)
            {
                if(aDbResult[i].HMK_BREMSWIDERSTAND_G115D === "00001")
                {
                    ECL_ActivateValue("HMK_BREMSWIDERSTAND_G115D", aDbResult[i].HMK_BREMSWIDERSTAND_G115D); // Bremswiderstand
                    ECL_ActivateValue("UI_HMK_BREMSWIDERSTAND_G115D", "00001-00001"); // Bremswiderstand UI
                    ECL_ActivateValue("UI_HMK_BREMSWIDERSTAND_G115D", "00001-00002"); // Bremswiderstand UI
                }
                else
                {
                    ECL_ActivateValue("HMK_BREMSWIDERSTAND_G115D", aDbResult[i].HMK_BREMSWIDERSTAND_G115D); // Bremswiderstand
                    ECL_ActivateValue("UI_HMK_BREMSWIDERSTAND_G115D", aDbResult[i].HMK_BREMSWIDERSTAND_G115D); // Bremswiderstand
                }
            }
            
            //custom geht immer
            ECL_ActivateValue("HMK_BREMSWIDERSTAND_G115D","custom");
            
            
            // Vorbelegung aktualisieren
            updateDefaultValue("HMK_BREMSWIDERSTAND_G115D", aDbResult[0].HMK_BREMSWIDERSTAND_G115D);
            //setBrakingResistorUiFromDb();
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00058_26350'"));
        }
    }
}

// Abhngigkeit zwischen DC 24V-Versorgung, Anschlussart, 3AC 400V Anschluss, DC 24V Anschluss, Kommunikation, Ein- / Ausgnge & Motor (sowie Primr-MLFB Positionen 6 & 15)
// VT_G115D_M00041_26350
function dependencyInterfaces(primaryMlfb)
{
    // Auswertung erst durchfhren, wenn Primr-MLFB durch SIZER bergeben & DC 24V-Versorgung durch CFG-Logik ermittelt wurde
    if (primaryMlfb && primaryMlfb.substr(5, 1) != "." && ECL_GetValue("HMK_DC_24V_VERSORG_G115D"))
    {
        // Trigger-Attribut fr Anbau an 2KJ8-Motor hinzufgen
        var aParamCommunication=[ECL_GetValue("HMK_SYS_TRIG_G115D")];        
        
        // Gltige Kommunikationen (HMK_KOMMUNIKATION_G115D) in Abhngigkeit von mglichen Werten fr Primr-MLFB Position 15 ermitteln
        var sQueryCommunication = "select distinct HMK_KOMMUNIKATION_G115D from VT_G115D_M00053_26350 where MLFB15_G115D in ('A','B','F') and HMK_SYS_TRIG_G115D = ? and HMK_VALUE_VALID_G115D = 'T';";
        var aDbResultCommunication = Object.fromDatabase("EXTERNAL_DATA", sQueryCommunication, aParamCommunication);
        
        if (aDbResultCommunication && aDbResultCommunication.length >= 1)
        {
            // Wertepool auf gltige Werte einschrnken
            ECL_DeactivateAllAttributeValues("HMK_KOMMUNIKATION_G115D");
            
            for (var i = 0; i < aDbResultCommunication.length; i++)
            {
                ECL_ActivateValue("HMK_KOMMUNIKATION_G115D", aDbResultCommunication[i].HMK_KOMMUNIKATION_G115D); // Kommunikation (HMK_KOMMUNIKATION_G115D)
            }
            
            // Vorbelegung aktualisieren
            updateDefaultValue("HMK_KOMMUNIKATION_G115D", aDbResultCommunication[0].HMK_KOMMUNIKATION_G115D);
            
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00041_26350'"));
        }
        
        var strMLFB_Kommunikation="";
        if(ECL_GetValue("HMK_KOMMUNIKATION_G115D")=="00001")
            strMLFB_Kommunikation="F";
        else if(ECL_GetValue("HMK_KOMMUNIKATION_G115D")=="00002")
            strMLFB_Kommunikation="A";
        else if(ECL_GetValue("HMK_KOMMUNIKATION_G115D")=="00003")
            strMLFB_Kommunikation="B";
        
        // Gltige Anschlussarten in Abhngigkeit von DC 24V-Versorgung sowie Primr-MLFB Positionen 6 & 15 ermitteln
        var sQuery = "select distinct HMK_ANSCHLUSSART_G115D from VT_G115D_M00041_26350 where HMK_DC_24V_VERSORG_G115D = ? and MLFB06_G115D = ? and MLFB15_G115D = ?;";
        var aParam = [ECL_GetValue("HMK_DC_24V_VERSORG_G115D"), primaryMlfb.substr(5, 1), strMLFB_Kommunikation];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Wertepool auf gltige Werte einschrnken
            ECL_DeactivateAllAttributeValues("HMK_ANSCHLUSSART_G115D");
            
            for (var i = 0; i < aDbResult.length; i++)
            {
                ECL_ActivateValue("HMK_ANSCHLUSSART_G115D", aDbResult[i].HMK_ANSCHLUSSART_G115D); // Anschlussart
            }
            
            // Vorbelegung aktualisieren
            updateDefaultValue("HMK_ANSCHLUSSART_G115D", aDbResult[0].HMK_ANSCHLUSSART_G115D);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00041_26350'"));
        }
        
        // Gltige 3AC 400V Anschlsse in Abhngigkeit von DC 24V-Versorgung & Anschlussart sowie Primr-MLFB Positionen 6 & 15 ermitteln
        var sQuery = "select distinct HMK_3AC_400V_ANSCHL_G115D from VT_G115D_M00041_26350 where HMK_DC_24V_VERSORG_G115D = ? and HMK_ANSCHLUSSART_G115D = ? and MLFB06_G115D = ? and MLFB15_G115D = ?;";
        var aParam = [ECL_GetValue("HMK_DC_24V_VERSORG_G115D"), ECL_GetValue("HMK_ANSCHLUSSART_G115D"), primaryMlfb.substr(5, 1), strMLFB_Kommunikation];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Wertepool auf gltige Werte einschrnken
            ECL_DeactivateAllAttributeValues("HMK_3AC_400V_ANSCHL_G115D");
            
            for (var i = 0; i < aDbResult.length; i++)
            {
                ECL_ActivateValue("HMK_3AC_400V_ANSCHL_G115D", aDbResult[i].HMK_3AC_400V_ANSCHL_G115D); // 3AC 400V Anschluss
            }
            
            // Vorbelegung aktualisieren
            updateDefaultValue("HMK_3AC_400V_ANSCHL_G115D", aDbResult[0].HMK_3AC_400V_ANSCHL_G115D);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00041_26350'"));
        }
        
        // Gltige DC 24V Anschlsse in Abhngigkeit von DC 24V-Versorgung, Anschlussart & 3AC 400V Anschluss sowie Primr-MLFB Positionen 6 & 15 ermitteln
        var sQuery = "select distinct HMK_DC_24V_ANSCHL_G115D from VT_G115D_M00041_26350 where HMK_DC_24V_VERSORG_G115D = ? and HMK_ANSCHLUSSART_G115D = ? and HMK_3AC_400V_ANSCHL_G115D = ? and MLFB06_G115D = ? and MLFB15_G115D = ?;";
        var aParam = [ECL_GetValue("HMK_DC_24V_VERSORG_G115D"), ECL_GetValue("HMK_ANSCHLUSSART_G115D"), ECL_GetValue("HMK_3AC_400V_ANSCHL_G115D"), primaryMlfb.substr(5, 1), strMLFB_Kommunikation];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Wertepool auf gltige Werte einschrnken
            ECL_DeactivateAllAttributeValues("HMK_DC_24V_ANSCHL_G115D");
            
            for (var i = 0; i < aDbResult.length; i++)
            {
                ECL_ActivateValue("HMK_DC_24V_ANSCHL_G115D", aDbResult[i].HMK_DC_24V_ANSCHL_G115D); // DC 24V Anschluss
            }
            
            // Vorbelegung aktualisieren
            updateDefaultValue("HMK_DC_24V_ANSCHL_G115D", aDbResult[0].HMK_DC_24V_ANSCHL_G115D);
            
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00041_26350'"));
        }
        
        // Gltige Kommunikationen (HMK_ANSCHL_KOMM_G115D) in Abhngigkeit von DC 24V-Versorgung, Anschlussart, 3AC 400V Anschluss & DC 24V Anschluss sowie Primr-MLFB Positionen 6 & 15 ermitteln
        var sQuery = "select distinct HMK_ANSCHL_KOMM_G115D from VT_G115D_M00041_26350 where HMK_DC_24V_VERSORG_G115D = ? and HMK_ANSCHLUSSART_G115D = ? and HMK_3AC_400V_ANSCHL_G115D = ? and HMK_DC_24V_ANSCHL_G115D = ? and MLFB06_G115D = ? and MLFB15_G115D = ?;";
        var aParam = [ECL_GetValue("HMK_DC_24V_VERSORG_G115D"), ECL_GetValue("HMK_ANSCHLUSSART_G115D"), ECL_GetValue("HMK_3AC_400V_ANSCHL_G115D"), ECL_GetValue("HMK_DC_24V_ANSCHL_G115D"), primaryMlfb.substr(5, 1), strMLFB_Kommunikation];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Wertepool auf gltige Werte einschrnken
            ECL_DeactivateAllAttributeValues("HMK_ANSCHL_KOMM_G115D");
            
            for (var i = 0; i < aDbResult.length; i++)
            {
                ECL_ActivateValue("HMK_ANSCHL_KOMM_G115D", aDbResult[i].HMK_ANSCHL_KOMM_G115D); // Kommunikation (HMK_ANSCHL_KOMM_G115D)
            }
            
            // Vorbelegung aktualisieren
            updateDefaultValue("HMK_ANSCHL_KOMM_G115D", aDbResult[0].HMK_ANSCHL_KOMM_G115D);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00041_26350'"));
        }
        
        // Gltige Ein- / Ausgnge in Abhngigkeit von DC 24V-Versorgung, Anschlussart, 3AC 400V Anschluss, DC 24V Anschluss & Kommunikation sowie Primr-MLFB Positionen 6 & 15 ermitteln
        var sQuery = "select distinct HMK_IO_G115D from VT_G115D_M00041_26350 where HMK_DC_24V_VERSORG_G115D = ? and HMK_ANSCHLUSSART_G115D = ? and HMK_3AC_400V_ANSCHL_G115D = ? and HMK_DC_24V_ANSCHL_G115D = ? and HMK_ANSCHL_KOMM_G115D = ? and MLFB06_G115D = ? and MLFB15_G115D = ?;";
        var aParam = [ECL_GetValue("HMK_DC_24V_VERSORG_G115D"), ECL_GetValue("HMK_ANSCHLUSSART_G115D"), ECL_GetValue("HMK_3AC_400V_ANSCHL_G115D"), ECL_GetValue("HMK_DC_24V_ANSCHL_G115D"), ECL_GetValue("HMK_ANSCHL_KOMM_G115D"), primaryMlfb.substr(5, 1), strMLFB_Kommunikation];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Wertepool auf gltige Werte einschrnken
            ECL_DeactivateAllAttributeValues("HMK_IO_G115D");
            
            for (var i = 0; i < aDbResult.length; i++)
            {
                ECL_ActivateValue("HMK_IO_G115D", aDbResult[i].HMK_IO_G115D); // Ein- / Ausgnge
            }
            
            // Vorbelegung aktualisieren
            updateDefaultValue("HMK_IO_G115D", aDbResult[0].HMK_IO_G115D);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00041_26350'"));
        }
        
        // Gltige Motoren in Abhngigkeit von DC 24V-Versorgung, Anschlussart, 3AC 400V Anschluss, DC 24V Anschluss, Kommunikation & Ein- / Ausgngen sowie Primr-MLFB Positionen 6 & 15 ermitteln
        var sQuery = "select distinct HMK_MOTOR_G115D from VT_G115D_M00041_26350 where HMK_DC_24V_VERSORG_G115D = ? and HMK_ANSCHLUSSART_G115D = ? and HMK_3AC_400V_ANSCHL_G115D = ? and HMK_DC_24V_ANSCHL_G115D = ? and HMK_ANSCHL_KOMM_G115D = ? and HMK_IO_G115D = ? and MLFB06_G115D = ? and MLFB15_G115D = ?;";
        var aParam = [ECL_GetValue("HMK_DC_24V_VERSORG_G115D"), ECL_GetValue("HMK_ANSCHLUSSART_G115D"), ECL_GetValue("HMK_3AC_400V_ANSCHL_G115D"), ECL_GetValue("HMK_DC_24V_ANSCHL_G115D"), ECL_GetValue("HMK_ANSCHL_KOMM_G115D"), ECL_GetValue("HMK_IO_G115D"), primaryMlfb.substr(5, 1), strMLFB_Kommunikation];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length >= 1)
        {
            // Wertepool auf gltige Werte einschrnken
            ECL_DeactivateAllAttributeValues("HMK_MOTOR_G115D");
            
            for (var i = 0; i < aDbResult.length; i++)
            {
                ECL_ActivateValue("HMK_MOTOR_G115D", aDbResult[i].HMK_MOTOR_G115D); // Motor
            }
            
            // Vorbelegung aktualisieren
            updateDefaultValue("HMK_MOTOR_G115D", aDbResult[0].HMK_MOTOR_G115D);
        }
        else
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_AMBIGOUS_DATA_IN_DTK_TABLE" + " 'VT_G115D_M00041_26350'"));
        }
    }
}

function dependencySDCard_SLS()
{
    if (ECL_GetValue("PMD_AAA566_001_000_G115D") && ECL_GetValue("HMK_SPEICHERKARTE_G115D"))
    {
        var strSLS="";
        if (ECL_GetValue("HMK_F01_G115D")=="T")
        {
            strSLS="F01";
        }
        else
        {
            strSLS="NON";
        }

        var sQuery = "select distinct HMK_SPEICHERKARTE_G115D from VT_G115D_M00117_26350 where PMD_AAA566_001_000_G115D = ? AND HMK_F01_G115D = ?;";
        var aParam = [ECL_GetValue("PMD_AAA566_001_000_G115D"), strSLS];
        var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
        
        ECL_DeactivateAllAttributeValues("HMK_SPEICHERKARTE_G115D");
        if (aDbResult && aDbResult.length > 0)
        {
            for (var i = 0; i < aDbResult.length; i++)
            {
                ECL_ActivateValue("HMK_SPEICHERKARTE_G115D", aDbResult[i].HMK_SPEICHERKARTE_G115D); // Motor
            }
            
            // Vorbelegung aktualisieren
            updateDefaultValue("HMK_SPEICHERKARTE_G115D", aDbResult[0].HMK_SPEICHERKARTE_G115D);
        }
    }
    
    getSdCard();
}

////////////////////////
// LOGIK CONSEQUENCES //
////////////////////////

// Consequences fr Steuermodus & maximale Ausgangsfrequenz aus Primr-MLFB ermitteln
// TPF_U_PulseFrequencies
function getControlModeMaxOutputFrequencyConsequence(primaryMlfb)
{
    var result = {};
    var pulseFrequency = ECL_GetValue("ECSI_CX_PulseFrequency");
    
    // Datenbank-Abfrage nur sinnvoll, wenn Context fr Pulsfrequenz sowie Primr-MLFB durch SIZER bergeben wurde
    if (pulseFrequency && primaryMlfb)
    {
        // Primr-MLFB fr DB-Abfrage maskieren
        var maskedPrimaryMlfb = primaryMlfb.slice(0,6) + "..X.." + primaryMlfb.slice(11,14) + ".0";
        
        var sQuery = "select distinct SZ_UPF_ControlMethod, SZ_UPF_MaxOutputFrequency from TPF_U_PulseFrequencies where SZ_UPF_U_OrderNumber = ? and SZ_UPF_PulseFrequency = ?;";
        var aParam = [maskedPrimaryMlfb, pulseFrequency];
        var aDbResult = Object.fromDatabase("G115D_ADD_DATA", sQuery, aParam);
        
        if (aDbResult && aDbResult.length == 1)
        {
            // Consequences fr Steuermodus & maximale Ausgangsfrequenz zurckgeben
            result.controlMode = aDbResult[0].SZ_UPF_ControlMethod;
            result.maxOutputFrequencyLimit = aDbResult[0].SZ_UPF_MaxOutputFrequency;
        }
    }
    
    return result;
}

// Consequence Bremswiderstand aus Sekundr-MLFBs ermitteln
// TBR_BrakingResistors
function getBrakingResistorConsequence(primaryMlfb, aSecondaryMlfbs)
{
    
    // Es gibt internen und externen Bremswiderstand
    if(ECL_GetValue("HMK_BREMSWIDERSTAND_G115D")=="00001")
    {
        //interner Bremswiderstand
        var result = {};
        
        var strMLFB = primaryMlfb.substr(11,3);
        if(strMLFB=="03A" || strMLFB=="05A" || strMLFB=="07A" || strMLFB=="11A" || strMLFB=="15A")
            result.brakingResistorId="9";
        else if(strMLFB=="22A" || strMLFB=="30A" || strMLFB=="40A")
            result.brakingResistorId="10";
        else if(strMLFB=="55A" || strMLFB=="75A")
            result.brakingResistorId="11";
        else
            result.brakingResistorId="";
        
        return result;
    }
    else
    {
        //externer Bremswiderstand
    
        var result = {};
        
        // Datenbank-Abfrage nur sinnvoll, wenn mindestens eine Sekundr-MLFB durch SIZER bergeben wurde
        if (aSecondaryMlfbs && aSecondaryMlfbs.length > 0)
        {
            // Platzhalter-Liste fr Prepared Statement aufbauen
            var sSqlParamPlaceholder = "";
            
            for (var i = 0; i < aSecondaryMlfbs.length; i++)
            {
                sSqlParamPlaceholder += "?, ";
            }
            
            var sQuery = "select distinct SZ_BR_ID from TBR_BrakingResistors where SZ_BR_Artnum in (" + sSqlParamPlaceholder.slice(0, -2) + ");";
            var aParam = aSecondaryMlfbs;
            var aDbResult = Object.fromDatabase("G115D_ADD_DATA", sQuery, aParam);
            
            if (aDbResult && aDbResult.length == 1)
            {
                // Consequence fr Bremswiderstand zurckgeben
                result.brakingResistorId = aDbResult[0].SZ_BR_ID;
            }
        }
        
        return result;
    }
}

function setBrakingResistorUiFromDb()
{
    var primaryMlfb = ECL_GetValue("ECSI_MLFB");
    var brakingResistorValue = ECL_GetValue("HMK_BREMSWIDERSTAND_G115D");
    var basetype = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    
    // depending on 12 and 13, can the 10w or 20w resistor be determined
    var primaryMlfb_12_13 = primaryMlfb.substr(11,2);
    var sQuery = "SELECT HMK_INT_BREMSW_G115D FROM VT_G115D_M00113_26350 WHERE HMK_MLFB_12_13_G115D='" + primaryMlfb_12_13 + "' AND HMK_VALUE_VALID_G115D='T'";
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery);
    
    if(aDbResult && aDbResult.length == 1)
    {
        var uiValue = aDbResult[0].HMK_INT_BREMSW_G115D;
        
        if(brakingResistorValue === "00001") // if integrated braking resistor is chosen
        {
            ECL_SelectValue("UI_HMK_BREMSWIDERSTAND_G115D", "00001"+ "-" + uiValue);
        }
        else
        {
            ECL_SelectValue("UI_HMK_BREMSWIDERSTAND_G115D", brakingResistorValue);
        }
        deactivateIrrelevantResistor(uiValue);
    }	
}

function deactivateIrrelevantResistor(uiValue)
{
    if(uiValue === "00001")
    {
        ECL_DeactivateValue("UI_HMK_BREMSWIDERSTAND_G115D", "00001-00002"); // 00001-00002 : 20w resistor
    }
    else if(uiValue === "00002")
    {
        ECL_DeactivateValue("UI_HMK_BREMSWIDERSTAND_G115D", "00001-00001"); // 00001-00001 : 10w resistor
    }
}

function replaceCharacter(string, index, replacement) {
    return (
      string.slice(0, index) +
      replacement +
      string.slice(index + replacement.length)
    );
  }