//@legacy

/**
* 	Script for applying dependencies G115D
*
* 	Date: 2020-06-14
* 	User: Andreas Hller, Plan Software GmbH
*/

// include easyKAT Configuration Library


// include additional scripts
//@import "CFG_SIEMENS_G115D_DB.js"

 // new Variant Tables

//#mode(full-ecma)


// Abhngigkeiten zwischen Werten anwenden ("klassische" Konfigurationslogik)
function applyDependencies(primaryMlfb)
{
    dependencyIpProtectionClassMounting();
    dependencyInverterDesignPowerSwitch();
    // ahueller 2020-10-10: In SIZER-Release auf DTK-Datenbankstand 20836 wird kein Bremswiderstand angeboten
    // (Beschluss aus Web-Meeting mit Frau J. Nuphaus, Herr M. Maier vom 2020-10-05)
    // wird jetzt angeboten release 2021.04
    dependencyInverterDesignBrakingResistor();
    dependencyInterfaces(primaryMlfb);
    dependencySDCard_SLS();
}

// Zubehr aus Sekundr-MLFBs bestimmen (fr Prfung & "Rckwrts-Auflsung" bei bergabe aus SIZER)
function getAccParts(aSecondaryMlfbs)
{
    var aAccToSelect = [];
    
    // Einfache direkte Zuordnungen (simple 1:1 Logik)
    var aMlfbToAvSelection = getAvFromSecMlfb(aSecondaryMlfbs);
    
    for (var i = 0; aSecondaryMlfbs && i < aSecondaryMlfbs.length; i++)
    {
        for (var j = 0; j < aMlfbToAvSelection.length; j++)
        {
            if (aMlfbToAvSelection[j][aSecondaryMlfbs[i]])
            {
                aAccToSelect = aAccToSelect.concat(aMlfbToAvSelection[j][aSecondaryMlfbs[i]]);
            }
        }
    }
    
    // Komplexere Zuordnungen (Mehrfachabhngigkeiten)
    var oAccessory = {
        powerSwitch: setPowerSwitch(aSecondaryMlfbs),
        fuseType: setFuseType(aSecondaryMlfbs),
        // ahueller 2020-10-10: In SIZER-Release auf DTK-Datenbankstand 20836 wird kein Bremswiderstand angeboten
        // (Beschluss aus Web-Meeting mit Frau J. Nuphaus, Herr M. Maier vom 2020-10-05)
        // wird jetzt angeboten release 2021.04
        brakingResistor: setBrakingResistor(aSecondaryMlfbs),
        service: setService(aSecondaryMlfbs)
    }
    
    for (var aAccessory in oAccessory)
    {
        oAccessory[aAccessory] ? aAccToSelect.push(oAccessory[aAccessory]) : '';
    }
    
    return aAccToSelect;
}

// Datenobjekt mit direkten Zuordnungen (simple 1:1 Logik) von Sekundr-MLFBs zu Bewertung von Attributen bereitstellen
function getAvFromSecMlfb(aSecondaryMlfbs)
{
    var aMlfbToAvSelection = [
        {"6SL30544AG002AA0": [{A: "HMK_SPEICHERKARTE_G115D",     V: "00001"}]}, // aus VT_G115D_M00035_26350
        {"6SL30547TH002BA0": [{A: "HMK_SPEICHERKARTE_G115D",     V: "00002"}]}, // aus VT_G115D_M00035_26350
        {"6SL30547TG002BA0": [{A: "HMK_SPEICHERKARTE_G115D",     V: "00002"}]}, // aus VT_G115D_M00035_26350
        {"6SL30547TG002BA0": [{A: "HMK_FIRMWARE_G115D",     V: "VERSION_4_7_SP13"}]}, // aus VT_G115D_M00035_26350
        {"6SL30547TH002BA0": [{A: "HMK_FIRMWARE_G115D",     V: "VERSION_4_7_SP14"}]}, // aus VT_G115D_M00035_26350
        {"6SL30544AG002AA0 F01": [{A: "HMK_SPEICHERKARTE_G115D",     V: "00001"}]}, // aus VT_G115D_M00035_26350
        {"6SL30547TH002BA0 F01": [{A: "HMK_SPEICHERKARTE_G115D",     V: "00002"}]}, // aus VT_G115D_M00035_26350
        {"6SL30547TG002BA0 F01": [{A: "HMK_SPEICHERKARTE_G115D",     V: "00002"}]}, // aus VT_G115D_M00035_26350
        {"6SL30547TG002BA0 F01": [{A: "HMK_FIRMWARE_G115D",     V: "VERSION_4_7_SP13"}]}, // aus VT_G115D_M00035_26350
        {"6SL30547TH002BA0 F01": [{A: "HMK_FIRMWARE_G115D",     V: "VERSION_4_7_SP14"}]}, // aus VT_G115D_M00035_26350
        {"6SL30544AG002AA0 F01": [{A: "HMK_F01_G115D",     V: "T"}]}, // aus VT_G115D_M00035_26350
        {"6SL30547TH002BA0 F01": [{A: "HMK_F01_G115D",     V: "T"}]}, // aus VT_G115D_M00035_26350
        {"6SL30547TG002BA0 F01": [{A: "HMK_F01_G115D",     V: "T"}]}, // aus VT_G115D_M00035_26350
        {"6SL32550AA005AA0": [{A: "HMK_SMART_ACCESS_G115D",      V: "T"}]},     // aus VT_G115D_M00036_26350
        {"6SL35550XA000AA0": [{A: "HMK_SMART_ACCESS_INT_G115D",  V: "T"}]},     // aus VT_G115D_M00037_26350
        {"6SL35662GW000GA0": [{A: "HMK_ANSCHLUSSS_KABEL_G115D",  V: "T"}]},     // aus VT_G115D_M00038_26350
        {"9AC21120AA001YA2": [{A: "HMK_MINDCON_IOT_G115D",		 V: "T"}]},     // aus VT_G115D_M00107_26350
        {"9AC21128BA120KA1": [{A: "HMK_MINDCON_NANO_G115D",		 V: "T"}]},     // aus VT_G115D_M00108_26350
        {"6SL35662GM000GA0": [{A: "HMK_ANSCHLUSSS_KABEL_G115D",  V: "T"}]},     // aus VT_G115D_M00038_26350
        {"6SL35664NA000GA0": [{A: "HMK_QUICKON_MUTTER_G115D",    V: "T"}]},     // aus VT_G115D_M00039_26350
        {"6SL35664MA000GA0": [{A: "HMK_QUICKON_STECKVER_G115D",  V: "T"}]},      // aus VT_G115D_M00040_26350
        {"9SV11103AA000AA0": [{A: "HMK_DRIVESIM_DESIGNER_G115D",  V: "T"}]}      // aus VT_G115D_M00040_26350
    ];
    
    return aMlfbToAvSelection;
}

// Abgleich aktueller Konfigurationsbewertung gegen ermittelte Bewertungen aus allen von SIZER bergebenen Sekundr-MLFBs
function checkAccToSelect(aAccToSelect)
{
    var aDeviations = [];
    
    for (var i = 0; aAccToSelect && i < aAccToSelect.length; i++)
    {
        if (aAccToSelect[i].A)
        {
            var sCurrentCfgValue = ECL_GetValue(aAccToSelect[i].A)
            
            if (sCurrentCfgValue != aAccToSelect[i].V)
            {
                aDeviations.push({A: aAccToSelect[i].A, currentV: sCurrentCfgValue, expectedV: aAccToSelect[i].V});
            }
        }
    }
    
    return aDeviations;
}