//@legacy
/**
* 	Script for global functions G115D
*
* 	Date: 2020-06-14
* 	User: Andreas Hller, Plan Software GmbH
*/

// include easyKAT Configuration Library


// include additional scripts
//@import "CFG_SIEMENS_G115D_DB.js"


//#mode(full-ecma)


function SetSystemVariables(primaryMlfb, baseTypeMlfb, secondaryMlfbs)
{
    if(primaryMlfb!="")
    {
        if(baseTypeMlfb.substr(6, 1) == "0")
        {
            ECL_SelectValue("HMK_SYS_TRIG_G115D", "2KJ8"); // Trigger fr System
        }
        else
        {
            ECL_SelectValue("HMK_SYS_TRIG_G115D", "OHNE"); // Trigger fr Standalone
        }
        
        // Falls MotorMounted, alle Attribute der Gruppen 'Umrichterparameter' und 'Anschlsse' sperren
        if (ECL_GetValue("HMK_SYS_TRIG_G115D") == "2KJ8" && baseTypeMlfb.substr(5, 1) == "5")
        {
            ECL_DeactivateAttributeGroup("CFG_GROUP___CONVERTER_PARAMETER");
            ECL_DeactivateAttributeGroup("CFG_GROUP___INTERFACES");
            ECL_DeactivateAttributeGroup("CFG_GROUP___MEMORY_CARD");
        }
        
        
        //Sind jetzt freigegeben!
        // Falls Standalone, alle Attribute der Gruppe 'Ergnzende Systemkomponenten' sperren
        //if (ECL_GetValue("HMK_SYS_TRIG_G115D") == "OHNE" && baseTypeMlfb.substr(5, 1) == "2")
        //{
        //	ECL_DeactivateAttributeGroup("CFG_GROUP___SSC");
        //}
    }
}

// Vorbelegungen setzen
function selectDefaults()
{
    // Trigger fr Anbau an 2KJ8 = ohne (Standalone Umrichter)
    //ECL_SelectValueDefault("HMK_SYS_TRIG_G115D", "OHNE");
    
    // Bremsenspannung = DC 180V (Standard) - MLFB-Position 7
    ECL_SelectValue("HMK_BREMSENSPANNUNG_G115D", "00001");
    
    // Bedienoption = ohne - MLFB-Position 8
    ECL_SelectValue("HMK_BEDIENOPTION_G115D", "00001");
    
    // EMV Kategorie = Filter C2 - MLFB-Position 14
    ECL_SelectValue("HMK_FILTERKLASSE_G115D", "00001");
    
    // Leistungsschalter = ohne - Sekundr-MLFB
    ECL_SelectValue("HMK_LEISTUNGSSCHALT_G115D", "00001");
    
    // Art der Sicherung = ohne - Sekundr-MLFB
    ECL_SelectValue("HMK_ART_SICHERUNG_G115D", "00001");
    
    //Kommunikation 0001 Profinet
    ECL_SelectValue("HMK_KOMMUNIKATION_G115D", "00001");
    
    // Bremswiderstand = ohne - Sekundr-MLFB
    //Vorerst nur Standard und custom
    //ECL_DeactivateAllAttributeValues("HMK_BREMSWIDERSTAND_G115D");
    //ECL_ActivateValue("HMK_BREMSWIDERSTAND_G115D","00001");
    //ECL_ActivateValue("HMK_BREMSWIDERSTAND_G115D","custom");
    
    ECL_SelectValue("HMK_BREMSWIDERSTAND_G115D", "00001");
    
    // 10w or 20w shows in UI
    //setDefaultBrakingResistorUiFromDb();
    
    // Speicherkarte = ohne - Sekundr-MLFB
    ECL_SelectValue("HMK_SPEICHERKARTE_G115D", "00003");    
    //Service
    ECL_SelectValue("HMK_SVC_SCHUTZ_G115D", "OHNE");
    
    // Schnittstellen-Attribute - siehe Tabelle 'VT_G115D_M00041_20836'
    ECL_SelectValue("HMK_DC_24V_VERSORG_G115D", "00001");
    ECL_SelectValue("HMK_ANSCHLUSSART_G115D", "00001");
    ECL_SelectValue("HMK_3AC_400V_ANSCHL_G115D", "00001");
    ECL_SelectValue("HMK_DC_24V_ANSCHL_G115D", "00002");
    ECL_SelectValue("HMK_ANSCHL_KOMM_G115D", "00002");
    ECL_SelectValue("HMK_IO_G115D", "00002");
    ECL_SelectValue("HMK_MOTOR_G115D", "00001");

    ECL_DisableAttribute("HMK_SYS_TRIG_G115D");
    ECL_DeactivateAttribute("HMK_FIRMWARE_G115D");
}

// Primr-MLFBs berprfen
function checkPrimaryMlfb(primaryMlfb, baseTypeMlfb)
{
    // RegEx fr eine Mindestanforderung an eine gltige Primr-MLFB
    var sRegExPowerModule = /6SL352|5.|0.X[A-Z].[0-9]{2}A.0/g;
    var sRegExPowerModule_Full = /6SL352|50[0-9]X[A-Z][0-9]{3}A[A-Z]0/g;
    
    // MLFB vereinheitlichen
    primaryMlfb = primaryMlfb.toUpperCase().replace("-", "").replace("?", ".");
    baseTypeMlfb = baseTypeMlfb.toUpperCase().replace("-", "").replace("?", ".");
    
    // MLFB auf unzulssige Zeichen berprfen
    var illegalCharsPrimaryMlfb = primaryMlfb.match(/[^a-zA-Z0-9.]/g);
    var illegalCharsBaseTypeMlfb = baseTypeMlfb.match(/[^a-zA-Z0-9.]/g);
    
    // Fehler in Primr-MLFB diagnostizieren & ausgeben
    if (illegalCharsPrimaryMlfb && illegalCharsPrimaryMlfb.length > 1)
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_MLFB_CHAR_INVALID"));
        return false;
    }
    
    if (primaryMlfb.length != 16)
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_MLFB_LENGTH_INVALID") + " " + primaryMlfb.length);
        return false;
    }
    
    if (left(primaryMlfb, 5) !== "6SL35")
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_MLFB_SERIES_INVALID"));
        return false;
    }
    
    if (primaryMlfb.indexOf(".") == -1 && !primaryMlfb.match(sRegExPowerModule))
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_MLFB_PATTERN_INVALID"));
        return false;
    }
    
    // Fehler in Basistyp-MLFB diagnostizieren & ausgeben
    if (illegalCharsBaseTypeMlfb && illegalCharsBaseTypeMlfb.length > 1)
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_MLFB_BASE_TYPE_CHAR_INVALID"));
        return false;
    }
    
    if (baseTypeMlfb.length != 16)
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_MLFB_BASE_TYPE_LENGTH_INVALID") + " " + baseTypeMlfb.length);
        return false;
    }
    
    if (left(baseTypeMlfb, 5) !== "6SL35")
    {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_MLFB_BASE_TYPE_SERIES_INVALID"));
        return false;
    }
    
    // vereinheitlichte (strukturell korrekte) MLFBs zurckgeben
    return [primaryMlfb, baseTypeMlfb];
}

// Sekundr-MLFBs berprfen
function checkSecondaryMlfb(secondaryMlfbs)
{
    // Eventuell vorhandenes Trennzeichen (Semikolon) am Ende des Sekundr-MLFB-Strings entfernen
    // (um Leereintrge im Sekundr-MLFB-Array zu vermeiden)
    
    //secondaryMlfbs = secondaryMlfbs.substring(0, secondaryMlfbs.lastIndexOf(";"));
    secondaryMlfbs = trimright(secondaryMlfbs,";");
    
    var aSecondaryMlfb = secondaryMlfbs.split(";");
    var aSecondaryMlfbClean = [];
    
    for (var i = 0; aSecondaryMlfb && i < aSecondaryMlfb.length; i++)
    {
        // MLFB vereinheitlichen
        secondaryMlfb = aSecondaryMlfb[i].toUpperCase().replace("-Z", "");
        secondaryMlfb = secondaryMlfb.replace("-", "");
        
        // MLFB auf unzulssige Zeichen berprfen
        var illegalChars = secondaryMlfb.match(/[^a-zA-Z0-9.]/g);
        
        // MLFB-Fehler diagnostizieren & ausgeben
        if (illegalChars && illegalChars.length > 1)
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_MLFB_SEC_CHAR_INVALID"));
            return false;
        }
        
        aSecondaryMlfbClean.push(secondaryMlfb);
    }
    
    // vereinheitlichtes (strukturell korrektes) Array von Sekundr-MLFBs zurckgeben
    return aSecondaryMlfbClean;
}

// Von Primr-MLFB abhngige Attribute setzen
function setAttributesFromPrimaryMlfb(primaryMlfb, baseTypeMlfb)
{
    setIpProtectionClassMountingPosition(baseTypeMlfb);
    setBrakeVoltage(primaryMlfb);
    setInputOption(primaryMlfb);
    setEmvCategory(primaryMlfb);
    setCommunication(primaryMlfb);
    setInverterDesign(baseTypeMlfb);
    restrictGlandInstallationKit(baseTypeMlfb);
    restrictQuickonNut(primaryMlfb);
    restrictQuickonConnector(primaryMlfb);
    setInterfaces(primaryMlfb);
    restrictService(primaryMlfb);
    restrictMindCon_IOT(primaryMlfb);
    restrictMindCon_NANO(primaryMlfb);
}

// Primr-MLFB auf Basis des aktuellen Konfigurationszustands aktualisieren
function updatePrimaryMlfb(primaryMlfb)
{
    // Primr-MLFB in ein Array konvertieren (um einzelne Stelle leichte adressieren zu knnen)
    var aPrimaryMlfb = primaryMlfb.split("");
    
    aPrimaryMlfb = getMlfbPosFromIpProtectionClassMountingPosition(aPrimaryMlfb); //MLFB06_G115D
    aPrimaryMlfb = getMlfbPosFromBrakeVoltage(aPrimaryMlfb); //MLFB07_G115D
    aPrimaryMlfb = getMlfbPosFromInputOption(aPrimaryMlfb); //MLFB08_G115D
    aPrimaryMlfb = getMlfbPosFromInterfaces(aPrimaryMlfb); //HMK_MLFB_10_11_G115D
    aPrimaryMlfb = getMlfbPosFromEmvCategory(aPrimaryMlfb); //MLFB14_G115D
    aPrimaryMlfb = getMlfbPosFromCommunication(aPrimaryMlfb); //MLFB15_G115D
    
    var updatedPrimaryMlfb = aPrimaryMlfb.join("");
    
    return updatedPrimaryMlfb;
}

// Sekundr-MLFBs (fr Zubehr) auf Basis des aktuellen Konfigurationszustands aktualisieren
function updateSecondaryMlfbs(primaryMlfb)
{
    var aSecondaryMlfbsSelections = [];
    
    var oAccessory = {
        powerSwitch: getPowerSwitch(),
        fuseType: getFuseType(),
        // ahueller 2020-10-10: In SIZER-Release auf DTK-Datenbankstand 20836 wird kein Bremswiderstand angeboten
        // (Beschluss aus Web-Meeting mit Frau J. Nuphaus, Herr M. Maier vom 2020-10-05)
        brakingResistor: getBrakingResistor(),
        sdCard: getSdCard(),
        firmwareVersion: getFirmwareVersion(),
        smartAccessWebserverModule: getSmartAccessWebserverModule(),
        smartAccessInterfaceKit: getSmartAccessInterfaceKit(),
        MindConIOT: getMindConIOT(),
        MindConNano: getMindConNano(),
        glandInstallationKit: getGlandInstallationKit(primaryMlfb),
        quickonNut: getQuickonNut(primaryMlfb),
        quickonConnector: getQuickonConnector(primaryMlfb),
        service: getService(primaryMlfb),
        driveSimDesigner: getDriveSimDesigner(),
    };
    
    for (var aAccessory in oAccessory)
    {
        oAccessory[aAccessory] != "NONE" ? aSecondaryMlfbsSelections = aSecondaryMlfbsSelections.concat(oAccessory[aAccessory]) : '';
    }
    
    // Sekundr-MLFBs konkatenieren & ausgeben
    var sSecondaryMlfbsSelections = aSecondaryMlfbsSelections.join(";");
    
    SetMlfbSec(sSecondaryMlfbsSelections);
}

// Context-Attribute setzen
function setContextAttributes()
{
    var sFieldbusInterface = ECL_GetValue("ECSI_CX_FieldbusInterface");
    var sCurrentCommunication = ECL_GetValue("HMK_KOMMUNIKATION_G115D");
    
    if (sFieldbusInterface == "0" || sFieldbusInterface === 0)
    {
        // PROFINET
        // Falls bereits eine abweichende Kommunikation gewhlt ist (z.B. aus "alter" Konfiguration)
        if (sCurrentCommunication && sCurrentCommunication != "00001")
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_CONTEXT_TO_MLFB_MISMATCH"));
        }
        else
        {
            // PROFINET-PN, Ethernet IP vorbelegen & Attribut sperren
            ECL_SelectValue("HMK_KOMMUNIKATION_G115D", "00001");
            ECL_DisableAttribute("HMK_KOMMUNIKATION_G115D");
        }
    }
    else if (sFieldbusInterface == "2" || sFieldbusInterface == 2)
    {
        // AS-i
        // Falls bereits eine abweichende Kommunikation gewhlt ist (z.B. aus "alter" Konfiguration)
        if (sCurrentCommunication && sCurrentCommunication != "00002")
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_CONTEXT_TO_MLFB_MISMATCH"));
        }
        else
        {     
            // AS-Interface vorbelegen & Attribut sperren
            ECL_SelectValue("HMK_KOMMUNIKATION_G115D", "00002");
            ECL_DisableAttribute("HMK_KOMMUNIKATION_G115D");
        }
    }
    
    var CustomBrakingResistor = ECL_GetValue("ECSI_CX_CustomBrakingResistor");
    
    if(CustomBrakingResistor=="True" || CustomBrakingResistor=="1")
    {
        ECL_SetValue("HMK_BREMSWIDERSTAND_G115D", "custom");
    }

    var strSafetySLS = ECL_GetValue("ECSI_CX_SafetyFunctions");
    if(strSafetySLS=="2")
    {
        ECL_SelectValue("HMK_F01_G115D", "T");
        ECL_DisableAttribute("HMK_F01_G115D");
       
    }
    else
    {
        ECL_EnableAttribute("HMK_F01_G115D");
    }
    
}

// Consequence-Attribute setzen
function setConsequenceAttributes(primaryMlfb, aSecondaryMlfbs)
{
    var consequencesControlModeMaxOutputFrequency = getControlModeMaxOutputFrequencyConsequence(primaryMlfb);
    
    // Steuermodus
    if (consequencesControlModeMaxOutputFrequency.controlMode)
    {
        // Context-Attribut fr Steuermodus setzen
        ECL_SetValue("ECSI_CC_ControlMode", consequencesControlModeMaxOutputFrequency.controlMode);
    }
    else
    {
        ECL_SetValue("ECSI_CC_ControlMode", "");
    }
    
    // Schutzart IP
    var sIpProtectionLevel = ECL_GetValue("PMD_ABJ176_001_000_G115D");
    
    if (sIpProtectionLevel == "00057" || sIpProtectionLevel == "00058")
    {
        // Context-Attribut fr IP Schutzklasse setzen
        ECL_SetValue("ECSI_CC_IpProtectionLevelFrequencyConverter", 65);
    }
    else
    {
        ECL_SetValue("ECSI_CC_IpProtectionLevelFrequencyConverter", "");
    }
    
    // Context for Filter and Reactor Type Filters
    if (ECL_GetValue("HMK_SYS_TRIG_G115D") == "2KJ8")
    {
        ECL_SetValue("ECSI_CC_OutputReactorOrFilter", "");
        ECL_SetValue("ECSI_CC_OutputReactorOrFilterType", "0");
        ECL_SetValue("ECSI_CC_InputFilterType", "0");
        ECL_SetValue("ECSI_CC_ExternalFilterType", "0");
    }
    else
    {
        ECL_SetValue("ECSI_CC_OutputReactorOrFilter", "");
        ECL_SetValue("ECSI_CC_OutputReactorOrFilterType", "0");
        ECL_SetValue("ECSI_CC_InputFilterType", "2");
        ECL_SetValue("ECSI_CC_ExternalFilterType", "0");
    }
    
    ECL_SetValue("ECSI_CC_BrakeRelays", "");
    ECL_SetValue("ECSI_CC_ControlUnit", "");
    
    // Maximale Ausgangsfrequenz
    if (consequencesControlModeMaxOutputFrequency.maxOutputFrequencyLimit)
    {
        // Context-Attribut fr Maximale Ausgangsfrequenz setzen
        ECL_SetValue("ECSI_CC_MaxOutputFrequencyLimit", consequencesControlModeMaxOutputFrequency.maxOutputFrequencyLimit);
    }
    else
    {
        ECL_SetValue("ECSI_CC_MaxOutputFrequencyLimit", "");
    }
    
    // Weitere leere Context-Attribute fr bestimmte Kontexte setzen (da seitens SIZER immer erwartet)
    ECL_SetValue("ECSI_CC_Selected_VPM", "false");
    
    if(ECL_ValueSelected("HMK_BREMSWIDERSTAND_G115D","custom"))
    {
        ECL_SetValue("ECSI_CC_BrakingResistorID", "custom");	// hier soll die ID fr den Bremswiderstand rein
        ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "True");
    }
    else
    {
        //jetzt aktiv
        var consequenceBrakingResistor = getBrakingResistorConsequence(primaryMlfb, aSecondaryMlfbs);
        if(consequenceBrakingResistor)
            ECL_SetValue("ECSI_CC_BrakingResistorID", consequenceBrakingResistor.brakingResistorId);	// hier soll die ID fr den Bremswiderstand rein
        else
            ECL_SetValue("ECSI_CC_BrakingResistorID", "");	// hier soll die ID fr den Bremswiderstand rein
        
        ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "False");
    }
}

// Konfigurationsbewertungszustand an durch SIZER bergebene Sekundr-MLFBs anpassen
function applySecondaryMlfbs(aDeviations)
{
    for (var i = 0; aDeviations && i < aDeviations.length; i++)
    {
        ECL_SelectValue(aDeviations[i].A, aDeviations[i].expectedV);
        var valueOverwritten = ECL_GetValue(aDeviations[i].A);
        
        if (valueOverwritten !== aDeviations[i].expectedV)
        {
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___G115D_UNSOLVABLE_DEVIATION_BETWEEN_SECONDARY_MLFB_PASSED_AND_CFG_LOGIC"));
        }
    }
}

// Vorbelegung fr ein Attribut aktualisieren
function updateDefaultValue(sAttribute, sValue)
{
    var currentValue = ECL_GetValue(sAttribute);
    
    // Neuen Vorbelegungswert nur setzen, falls derzeit noch keiner oder ein nach aktueller Logik ungltiger Wert ausgewht ist
    if (!(currentValue && ECL_ValueActive(sAttribute, currentValue)))
    {
        ECL_SelectValue(sAttribute, sValue);
    }
}

function manageKeepconfig(s_mlfb)
{
    var isStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    var strBaseTypeMLFB=ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    
    if (ECL_GetValue("HMK_SYS_TRIG_G115D") == "2KJ8")
        return s_mlfb;
    
    if(isStartConfiguration=="1" && s_mlfb!=strBaseTypeMLFB && find(s_mlfb,".")<0)
    {	
        s_mlfb = repairConficuration(s_mlfb);	   
        var aBaseTypeMLFB=strBaseTypeMLFB.split('');
        var as_mlfb=s_mlfb.split('');
        for (var i=0;i<aBaseTypeMLFB.length;i++)
        {
            if(aBaseTypeMLFB[i] != ".")
            {
                as_mlfb[i]=aBaseTypeMLFB[i];
            }
        }
        
        s_mlfb="";
        for (var i=0;i<as_mlfb.length;i++)
            s_mlfb=s_mlfb+as_mlfb[i];
    
        return s_mlfb;
    }
    else if(isStartConfiguration=="1")
        return strBaseTypeMLFB;
    else
        return s_mlfb;
}

function repairConficuration(primaryMlfb) {
    if (primaryMlfb.length < 16) 
        return primaryMlfb;
    
    var aPrimaryMlfb = primaryMlfb.split('');

    var valuesForMLFB06 = getValidValuesForMLFB06();
    var valuesForMLFB07 = getValidValuesForMLFB07();
    var valuesForMLFB08 = getValidValuesForMLFB08();
    var valuesForMLFB10_11 = getValidValuesForMLFB10_11(aPrimaryMlfb);
    var valuesForMLFB14 = getValidValuesForMLFB14();
    var valuesForMLFB15 = getValidValuesForMLFB15();

    if (!valuesForMLFB06.includes(aPrimaryMlfb[5]))
        aPrimaryMlfb = getMlfbPosFromIpProtectionClassMountingPosition(aPrimaryMlfb);
    
    if (!valuesForMLFB07.includes(aPrimaryMlfb[6]))
        aPrimaryMlfb = getMlfbPosFromBrakeVoltage(aPrimaryMlfb);

    if (!valuesForMLFB08.includes(aPrimaryMlfb[7]))
        aPrimaryMlfb = getMlfbPosFromInputOption(aPrimaryMlfb);

    if (!valuesForMLFB10_11.includes(aPrimaryMlfb[9] + aPrimaryMlfb[10]) && valuesForMLFB10_11.length > 0)
        aPrimaryMlfb = getMlfbPosFromInterfaces(aPrimaryMlfb);
    
    if (!valuesForMLFB14.includes(aPrimaryMlfb[13]))
        aPrimaryMlfb = getMlfbPosFromEmvCategory(aPrimaryMlfb);

    if (!valuesForMLFB15.includes(aPrimaryMlfb[14]))
        aPrimaryMlfb = getMlfbPosFromCommunication(aPrimaryMlfb);

    return aPrimaryMlfb.join('');
}