//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_G120
// 	Date: 2021-07-08
// 	User: Benjamin Christ, Plan Software GmbH
// ---------------------------------------------------------


 // include easyKAT Configuration Library
 // include ES6-like array functions
//@import "SIZER_general_functions.js"

 // include new Variant Tables
//#mode(full-ecma)



VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables

var sDB_Version = "26830";			// DB-Version
var sDB_Suffix = "_" + sDB_Version;	// DB-TableSuffix
/*
ECL_DisableAttribute("HMK_E01_G120");
    ECL_DisableAttribute("HMK_F01_G120");
    ECL_DisableAttribute("HMK_J01_G120");
    ECL_DisableAttribute("HMK_U01_G120");
    ECL_DisableAttribute("UI_HMK_E01_G120");
    ECL_DisableAttribute("UI_HMK_F01_G120");
    ECL_DisableAttribute("UI_HMK_F01_S110_G120");
    ECL_DisableAttribute("UI_HMK_F01_S120_G120");
    ECL_DisableAttribute("UI_HMK_J01_G120");
    ECL_DisableAttribute("UI_HMK_U01_G120");
    ECL_DisableAttribute("CB_ADVANCED_SAFETY_G120");
*/
var ALL_SHORT_OPTIONS = ["A01", "E01", "F01", "J01", "U01"];
var ENCODER_EVALUATION_MAPPING = {
    "00001":"ENCODER_EVAL_G120_WITHOUT",
    "00002":"ENCODER_EVAL_G120_WITH",
    "00003":"ENCODER_EVAL_G120_WITH"
}

var count = 0;
globalThis.OnChangeConfiguration = function main()
{
    SetAttributesFromMlfb();
    ECL_Trace("DT-K database-version: " + sDB_Version);
    ECL_Trace("Script-version: 2021.08_01_210709");
    
    // Basisgerät besteht aus Powermodul, CU und Bedienpanel, jedoch Basis-MLFB nur PM
    // Powermodule:
    // 		 1234567 89012 3456
    // MLFB: 6SL32..-1P...-..L.
    // 00005	PM240-2 Standard		6SL3210 (10)		MLFB09: P
    // 00005	PM240-2 Push-Through	6SL3211	(11)		MLFB09: P
    // 00003	PM250					6SL3225	(25)		MLFB09: B
    
    // MLFB: 6SL32..-1T...-..L.		Chassis: MLFB09 = T
    // 00008	Chassis			6SL3210		S120	luftgefühlt		MLFB07 = 0
    // 00008	Chassis			6SL3215		S120	wassergekühlt	MLFB07 = 5
    
    // PM integrierter Filter A
    // MLFB: 6SL32..-1P...-..L.
    //						U - ungefiltert												
    //						A	- Filter Klasse A bzw. C2 bei FSG
    //						B	- Filter Klasse B <------- gibt es nicht für die G120-Auswahl
    //						C	- Filter Klasse C3 (nur für FSG) entspricht PMD_AAD146_001_000_G120 == 00007 (ungefiltert) oder == 00003 A je nach Typ siehe VT208 
    
    // Leistungsdaten
    // 		 1234567 89012 3456
    // MLFB: 6SL32..-1P...-..L.
    //									1 - Dezimalkenner (1, 2, 3)
    //									 x - 1. Leistungsstelle
    //									   x - 2. Leistungsstelle

    // MLFB CU
    // VT_G120_M00078
    /* VT_G120_M00078_24213
    HMK_MLFB_CONTROLUNIT_G120		HMK_TYPE_CU_G120
    6SL32430BB301PA3						00078	T    	CU230P‑2 DP		00001
    6SL32430BB301HA3						00079	T    	CU230P‑2 HVAC	00004, 00005, (00006, 00011 deaktiviert) --> USS, ModbusRTU, (Siemens FLN P1, BACnet MS/TP deaktiviert) 
    6SL32430BB301FA0						00080	T    	CU230P‑2 PN		00002
// Udpdate 21661 entfernt
    * 6SL32440BB001PA1						*00082	T    	*CU240B-2 DP
    6SL32440BB121BA1						00084	T    	CU240E‑2		00004, 00005 --> USS, ModbusRTU
    6SL32440BB121PA1						00085	T    	CU240E‑2 DP
    6SL32440BB131PA1						00086	T    	CU240E‑2 DP‑F
    6SL32440BB131BA1						00087	T    	CU240E‑2 F		00004, 00005 --> USS, ModbusRTU
    6SL32440BB121FA0						00088	T    	CU240E‑2 PN
    6SL32440BB131FA0						00089	T    	CU240E‑2 PN‑F
    6SL32460BA221BA0						00320	T    	CU250S‑2		00004, 00005 --> USS, ModbusRTU
    6SL32460BA221PA0						00321	T    	CU250S‑2 DP
    6SL32460BA221FA0						00322	T    	CU250S‑2 PN
    6SL32460BA221CA0						00323	T    	CU250S‑2 CAN	00003 --> CAN
    6SL30400JA010AA0						00324			CU305 PN			S110
    6SL30400JA000AA0						00325			CU305 DP			S110
    
    6SL30401LA010AA0						00994			CU310-2 PN			S120
    6SL30401LA000AA0						00995			CU310-2 DP			S120
    6SL30400PA000AA1						00996			CUA31, CU Adapter	S120
    6SL30400PA010AA0						00997			CUA32, CU Adapter	S120
    
    */
    // MLFB Panel
    // VT_G120_M00243
    /*
    PMD_ABU803_001_000_G120	HMK_MLFB_PANEL_G120
    00073					6SL32550AA004CA1	BOP2	G120
    00113					6SL32550AA004JA2	IOP2	G120
    00114					6SL32550AA004JA0	ohne	alle
    00114					6SL32550AA004JA1
    00115					----------------	<--- China IOP, nicht wählbar
    00116					6SL30550AA004BA0	BOP20	S110, S120
    */
    var sCurrentAttribute = ECL_GetCurrentAttribute();
    
    // Dummy Aufrufe von SIZER unterdrücken
    if (sCurrentAttribute == ''){
        return;
    }
    
    if(sCurrentAttribute.left(7) == "ECSI_CX"){
        return;
    }
    // ##############################################################################################
    // Variablen
    // ##############################################################################################
    var sECSI_MLFB				= "";		// Parameter für Basis-MLFB
    var sECSI_MLFB_SEC			= "";		// Parameter für zusätzliche MLFBs
    var sECSI_MLFB_BASE_TYPE 	= "";
    
    var sECSI_STATUS 			= "";		// Status für MLFB-Übergabe
    var sECSI_STATUS_MESSAGE 	= "";		// Statusmeldung für MLFB-Übergabe
    
    var sDezimalkenner 			= "";		// Leistungsparameter aus MLFB
    var sLeistung1 				= "";		// Leistungsparameter aus MLFB
    var sLeistung2 				= "";		// Leistungsparameter aus MLFB
    var sLeistung 				= "";		// Gesamtwert (String)
    
    var sFilter					= "";		// Filter aus MLFB14
    var sFilterParam			= ""; 	// Filterparameter (00003 - Klasse A, 00007 - ungefiltert)
    
    var sStatusBR				= "ohne";
    
    var aUserChangedAttributes = ECL_GetAllUserChangedAttributes();
    
    var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    
    // ##############################################################################################
    
    // ##############################################################################################
    // INIT
    // ##############################################################################################
    if(sCurrentAttribute === "@INIT@")
    {
        // Status Interface
        ECL_DisableAttribute("ECSI_STATUS");
        
        ECL_DisableAttribute("HMK_TYPE_PM_G120"); 			// Powermodul nur Info
        ECL_DisableAttribute("PMD_ABJ176_001_000_G120"); 	// IP-Schutzklasse nur Info
        ECL_DisableAttribute("HMK_PROFISAFE_G120"); 		// PROFISAFE nur Info
        
        ECL_DisableAttribute("TAK_AAJ871_001_000_G120"); 	// Bauform nur Info
        ECL_DeactivateAttribute("HMK_DRIVESIM_DESIGNER_G120"); 	// Bauform nur Info
        
        ECL_DeactivateAttribute("MLFB06_G120");
        ECL_DeactivateAttribute("MLFB07_G120");
        ECL_DeactivateAttribute("MLFB08_G120");
        ECL_DeactivateAttribute("MLFB09_G120");
        ECL_DeactivateAttribute("MLFB10_G120");
        ECL_DeactivateAttribute("MLFB11_G120");
        ECL_DeactivateAttribute("MLFB12_G120");
        ECL_DeactivateAttribute("MLFB13_G120");
        ECL_DeactivateAttribute("MLFB14_G120");
        ECL_DeactivateAttribute("MLFB15_G120");
        ECL_DeactivateAttribute("MLFB16_G120");
        ECL_DeactivateAttribute("MLFB_KEY_G120");
        
        ECL_DeactivateAttribute("HMK_RUECKSP_UEBERGAB_G120");
        
        ECL_DeactivateAttribute("ANZ_SICHERUNG_G120");
        ECL_DeactivateAttribute("SAFETY_INFO_SDI_G120");
        ECL_DeactivateAttribute("SAFETY_INFO_SLS_G120");
        ECL_DeactivateAttribute("SAFETY_INFO_SSM_G120");
        
        ECL_SelectValue("VPM_MODULE_S110_S120", "VPM_NONE_S110_S120");
        //ECL_DeactivateAttribute("VPM_MODULE_S110_S120");
        //ECL_DeactivateAllAttributeValues("VPM_MODULE_S110_S120");
        ECL_SelectValue("HMK_MEMORYCARD_G120", "");
        setCheckBoxAttributes("G120"); 
        return;
    }
    // ##############################################################################################
    
    
    // #####################################################################################################################################
    // MLFB-PARSER
    // #####################################################################################################################################
    sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
    sECSI_MLFB_BASE_TYPE = ECL_GetValue("ECSI_MLFB_BASE_TYPE") || "";
    if (sECSI_MLFB == ""){
        return;
    }
    sECSI_MLFB_SEC = GetMlfbSec() || "";
    
    // ##############################################################################################
    // Produkttrigger
    // ##############################################################################################
    
    var HMK_PRODUKT_TRIG_G120 = setSeriesID();

    /*
    71201 SINAMICS G120 PM240-2
    71207 SINAMICS G120 PM250 
    30120, 62200, 62201, 61202 SINAMICS S120 AC/AC 
    62300 SINAMICS S110
    */
    
    if (HMK_PRODUKT_TRIG_G120){
        ECL_SetValue("HMK_PRODUKT_TRIG_G120", HMK_PRODUKT_TRIG_G120);
    }else{
        var HMK_PRODUKT_TRIG_G120 = ECL_GetValue("HMK_PRODUKT_TRIG_G120") || "";
        if (HMK_PRODUKT_TRIG_G120 == ""){
            //HMK_PRODUKT_TRIG_G120 = "G120";
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___PROD_TRIG_UNDEFINED_G120") + " "; 
            ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
            ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
            return;
        }
    }

    if (HMK_PRODUKT_TRIG_G120 === "S120") {
        ExecSetStandardifValueEmpty("HMK_MEMORYCARD_G120", "00235");
    }

    if (HMK_PRODUKT_TRIG_G120 === "G120") {
        ECL_ActivateAttribute("HMK_DRIVESIM_DESIGNER_G120"); 	// Bauform nur Info
    }

    ExecSetStandardifValueEmpty("HMK_MEMORYCARD_G120", "00001");


    // Attribute nach Produkt ein-/ausblenden
    setProductAttributes(HMK_PRODUKT_TRIG_G120);
    
    // ##############################################################################################

    var sECSI_CX_SafetyFunctions 	 	= ECL_GetValue("ECSI_CX_SafetyFunctions");
    var sECSI_CX_RegenerativeBraking 	= ECL_GetValue("ECSI_CX_RegenerativeBraking");
    var sFieldbusInterface 			 	= ECL_GetValue("ECSI_CX_FieldbusInterface");
    var sMotionControlReq 			 	= ECL_GetValue("ECSI_CX_MotionControlRequirements");	// nur G120
    var sSpeedControlMode 			 	= ECL_GetValue("ECSI_CX_SpeedControlMode");	
    var ECSI_CX_RegenerativeMode 	 	= parseInt(ECL_GetValue("ECSI_CX_RegenerativeMode")) || 0;
    var ECSI_CX_CustomBrakingResistor 	= ECL_GetValue("ECSI_CX_CustomBrakingResistor");
    var ECSI_CX_Certificates 			= ECL_GetValue("ECSI_CX_Certificates") || "";
    
    if (ECSI_CX_Certificates && ECSI_CX_Certificates.indexOf("ULR_CSA") > -1){
        ECL_ActivateAttribute("UI_HMK_NEMA_KIT_G120");
    }else{
        ECL_DeactivateAttribute("UI_HMK_NEMA_KIT_G120");
        ECL_ResetAttribute("UI_HMK_NEMA_KIT_G120");
        ECL_SelectValue("HMK_NEMA_KIT_G120", "F");
    }
    
    // Check Safety
    if (sECSI_CX_SafetyFunctions && sECSI_CX_SafetyFunctions != "" && HMK_PRODUKT_TRIG_G120 != "S120"){
        var sStatusSupportedSafety = checkSafetyFunctions(sECSI_CX_SafetyFunctions, HMK_PRODUKT_TRIG_G120);
        if (sStatusSupportedSafety == "ERROR"){
            // SafetyFunction wird nicht unterstützt
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SAFETY_FUNCTION_NOT_SUPPORTED_G120") + " "; 
            ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
            ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
            return;
        }
    }
    
    if (ECSI_CX_RegenerativeMode == 2)
    {
        sStatusBR = "mit";
    }
    //#######################################################################################################################
    
    if (sCurrentAttribute == "ECSI_MLFB")
    {
        if (sECSI_MLFB !== "")
        {
            // MLFB normieren
            sECSI_MLFB = sECSI_MLFB.replace(/\s+/g, ""); 			// Leerzeichen entfernen
            sECSI_MLFB = sECSI_MLFB.replace("-", ""); 				// Bindestriche entfernen
            sECSI_MLFB= sECSI_MLFB.replace("?", ".").toUpperCase(); // Fragezeichen ersetzen
            ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
            // Prüfen, ob die Zeichenkette 16 Stellen hat
            if (sECSI_MLFB.length != 16)
            {
                // Übergabefehler abfangen
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MLFB_FAILURE_G120") + " "; //"MLFB zu kurz oder zu lang, ggf. unvollständig. ";
                ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
                ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                    return;
            }
            
            //#########################################################################################################################
            // Keep Configuration
            //#########################################################################################################################
            var sECSI_MLFB_fix = replaceAt(sECSI_MLFB, 13, ".");
            
            var bKeepConf = false;
            
            if( (sECSI_MLFB_BASE_TYPE!=sECSI_MLFB_fix) && find(sECSI_MLFB.left(16), ".") < 0 && sECSI_MLFB_BASE_TYPE != "")
            {
                //bKeepConf = true;
                
                if (sECSI_MLFB_BASE_TYPE.charAt(13) == "."){
                    var sFilterKC = sECSI_MLFB.charAt(13);
                    bKeepConf = true;
                }
                sECSI_MLFB = sECSI_MLFB_BASE_TYPE;
                ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
            }
            //#########################################################################################################################
            
            
            // Produkt prüfen						HMK_TYPE_PM_G120
            // PM240-2 Standard		6SL3210 (10)	00005			G120, S110 fix, S120 (generatorischer Betrieb: optionalem Bremswiderstand)
            // PM240-2 Push-Through	6SL3211	(11)	00005			
            // PM250				6SL3225	(25)	00003			G120 generatorischer Betrieb: Energierückspeisung
            // Chassis				6SL32 10/15		00008			S120 generatorischer Betrieb: reduziert (00003)
            if ((sECSI_MLFB.indexOf("6SL32101P") < 0) && (sECSI_MLFB.indexOf("6SL32111P") < 0) && (sECSI_MLFB.indexOf("6SL32250BE") < 0))
            { 
                // Falsches Produkt
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_PRODUCT_G120") + " "; //"Falsches Produkt übergeben. Nicht G120. ";
                ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
                ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                    return;
            }
            
            
            // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Powermodul setzen
            // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            var sPowerModul = "";
            var MLFB09_G120 = sECSI_MLFB.charAt(8);
            // Powermodul-Typ PM240-2 Standard
            if (MLFB09_G120 == "P")
            {
                sPowerModul = "PM240-2 Standard";
                ECL_SetValue("HMK_TYPE_PM_G120", "00005");
                ECL_SetValue("PMD_AAA136_001_000_1002980", "00019")
            }
            // PM250
            else if (sECSI_MLFB.indexOf("6SL3225") > -1)
            {
                sPowerModul = "PM250";
                ECL_SetValue("HMK_TYPE_PM_G120", "00003");
                ECL_SetValue("PMD_AAA136_001_000_1002980", "00019")
            }
            // Chassis luftgekühlt
            else if (sECSI_MLFB.indexOf("6SL3210") > -1 && MLFB09_G120 == "T")
            {
                sPowerModul = "Chassis luftgekühlt"; // luftgekühlt
                ECL_SetValue("HMK_TYPE_PM_G120", "00008");
                ECL_SetValue("PMD_AAA136_001_000_1002980", "00019"); // Kühlung
            }
            // Chassis wassergekühlt
            else if (sECSI_MLFB.indexOf("6SL3215") > -1 && MLFB09_G120 == "T")
            {
                sPowerModul = "Chassis wassergekühlt";
                ECL_SetValue("HMK_TYPE_PM_G120", "00008");
                ECL_SetValue("PMD_AAA136_001_000_1002980", "Z0009"); // Kühlung
            }
            else
            {
                // Powermodul nicht bestimmt, Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___PM_NOT_DEFINED_G120") + " "; //Power module from basic MLFB not defined.
                ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
                ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                    return;
            }
            
            // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Leistungsdaten herauslesen MLFB11
            // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            sDezimalkenner = sECSI_MLFB.charAt(10); // wenn 1: 0,xx | wenn 2: x,x | wenn 3: xx
            var aValidValues1 = ["1", "2", "3", "4"]; // ggf. aus DB-VT holen?
            if (aValidValues1.indexOf(sDezimalkenner) < 0)
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DECIMAL_IDENT_OUTOFRANGE_G120") + " ";//"Dezimalkenner für Leistungsangabe nicht im zulässigen Bereich. ";
            }
            
            sLeistung1 = sECSI_MLFB.charAt(11); //MLFB12
            var aValidValues2 = ["1", "2", "3", "4", "5", "6", "7", "8"]; // ggf. aus DB-VT holen?
            if (aValidValues2.indexOf(sLeistung1) < 0)
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___POWER_VALUE_1_OUTOFRANGE_G120") + " '" + sLeistung1 + "' ";
            }
            
            sLeistung2 = sECSI_MLFB.charAt(12); //MLFB13
            var aValidValues3 = ["0", "1", "2", "3", "4", "5", "6", "7", "8"]; // ggf. aus DB-VT holen?
            if (aValidValues3.indexOf(sLeistung2) < 0)
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___POWER_VALUE_2_OUTOFRANGE_G120") + " '" + sLeistung2 + "' ";
            }
            // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // StandardSupplySystem - Netzfrequenz auslesen, Spannung kommt aus MLFB-Zuordnung VT208
            // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            var bStatusSupplySystem = setStandardSupplySystem();
            if (!bStatusSupplySystem){
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___STANDARD_SUPPLY_SYSTEM_OOR_G120") + " '" + sLeistung2 + "' ";
            }
            // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            
            // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // MLFB-Daten in Abhängigkeit von Filterdaten herauslesen
            // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            sFilter = sECSI_MLFB.charAt(13); // MLFB14 wenn U: ungefiltert, wenn A: Filter A, ACHTUNG: wenn C je nach Fall ungefiltert oder A
            var aValidValues14 = ["U", "A", "C", "."]; // ggf. aus DB-VT holen?
            if (aValidValues14.indexOf(sFilter) < 0)
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FILTER_MLFB_OUTOFRANGE_G120") + " "; //"Merkmal in MLFB für Filter nicht im zulässigen Bereich. ";
            }
            else
            {
                if (bKeepConf){
                    // Prüfen, ob Filter noch passt:
                    //sFilterKC = sECSI_MLFB.charAt(13);
                    var sSQL = "SELECT * FROM VT_G120_M00272_" + sDB_Version + " WHERE " +
                                "MLFB06_G120 = " 	+  sECSI_MLFB.charAt(5) + " AND " +
                                "MLFB07_G120 = " 	+  sECSI_MLFB.charAt(6) + " AND " +
                                "MLFB08_G120 = " 	+  sECSI_MLFB.charAt(7) + " AND " +
                                "MLFB09_G120 = '"	+  sECSI_MLFB.charAt(8) + "' AND " +
                                "MLFB10_G120 = '"	+  sECSI_MLFB.charAt(9) + "' AND " +
                                "MLFB11_G120 = " 	+  sDezimalkenner 		+ " AND " +
                                "MLFB12_G120 = " 	+  sLeistung1 			+ " AND " + 
                                "MLFB13_G120 = " 	+  sLeistung2 			+ " AND " + 
                                "MLFB14_G120 = '" 	+  sFilterKC 			+ "' AND " + 
                                "MLFB15_G120 = '" 	+  sECSI_MLFB.charAt(14) + "' AND " +
                                "MLFB16_G120 = " 	+  sECSI_MLFB.charAt(15) + " AND " +
                                //"PMD_AAD146_001_000_G120 = '00007' AND " +
                                "HMK_VALUE_VALID_G120 = 'T';"; 
                    
                    var aResult = GetDBDataSetEXT(sSQL);
                    if (aResult.length > 0)
                    {
                        // Filter gültig
                        sFilter = sFilterKC;
                        ECL_SetValue("MLFB14_G120", sFilter);
                        ECL_SetValue("PMD_AAD146_001_000_G120", aResult[0].PMD_AAD146_001_000_G120);
                        sECSI_MLFB = replaceAt(sECSI_MLFB, 13, sFilter);
                        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                    }
                }
                if (sFilter == ".") // Wenn Platzhalter, dann durch Benutzer definieren <------- Default setzen auf "ungefiltert"
                {
                    // bestimmen, ob U oder C (FSG) bzw. ob fix Filter A
                    var sSQL = "SELECT * FROM VT_G120_M00272_" + sDB_Version + " WHERE " +
                                "MLFB06_G120 = " 	+  sECSI_MLFB.charAt(5) + " AND " +
                                "MLFB07_G120 = " 	+  sECSI_MLFB.charAt(6) + " AND " +
                                "MLFB08_G120 = " 	+  sECSI_MLFB.charAt(7) + " AND " +
                                "MLFB09_G120 = '"	+  sECSI_MLFB.charAt(8) + "' AND " +
                                "MLFB10_G120 = '"	+  sECSI_MLFB.charAt(9) + "' AND " +
                                "MLFB11_G120 = " 	+  sDezimalkenner 		+ " AND " +
                                "MLFB12_G120 = " 	+  sLeistung1 			+ " AND " + 
                                "MLFB13_G120 = " 	+  sLeistung2 			+ " AND " + 
                                "MLFB15_G120 = '" 	+  sECSI_MLFB.charAt(14) + "' AND " +
                                "MLFB16_G120 = " 	+  sECSI_MLFB.charAt(15) + " AND " +
                                "PMD_AAD146_001_000_G120 = '00007' AND " +
                                "HMK_VALUE_VALID_G120 = 'T';"; 
                    
                    var aResult = GetDBDataSetEXT(sSQL);
                    
                    if (aResult.length > 0)
                    {
                        // Ungefiltere Lösung vorhanden, C oder U
                        var sFilterUC = aResult[0].MLFB14_G120;
                        ECL_SetValue("MLFB14_G120", sFilterUC);
                        ECL_SetValue("PMD_AAD146_001_000_G120", "00007");
                        sECSI_MLFB = replaceAt(sECSI_MLFB, 13, sFilterUC);
                        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                    }
                    else // keine Lösung für "ungefiltert"
                    {
                        var sSQL = "SELECT * FROM VT_G120_M00272_" + sDB_Version + " WHERE " +
                                    "MLFB06_G120 = " +  sECSI_MLFB.charAt(5) + " AND " +
                                    "MLFB07_G120 = " +  sECSI_MLFB.charAt(6) + " AND " +
                                    "MLFB08_G120 = " +  sECSI_MLFB.charAt(7) + " AND " +
                                    "MLFB09_G120 = '" +  sECSI_MLFB.charAt(8) + "' AND " +
                                    "MLFB10_G120 = '" +  sECSI_MLFB.charAt(9) + "' AND " +
                                    "MLFB11_G120 = " +  sDezimalkenner + " AND " +
                                    "MLFB12_G120 = " +  sLeistung1 + " AND " + 
                                    "MLFB13_G120 = " +  sLeistung2 + " AND " + 
                                    "MLFB15_G120 = '" +  sECSI_MLFB.charAt(14) + "' AND " +
                                    "MLFB16_G120 = " +  sECSI_MLFB.charAt(15) + " AND " +
                                    "PMD_AAD146_001_000_G120 = '00003' AND " +
                                    "HMK_VALUE_VALID_G120 = 'T';"; 
                        
                        var aResult = GetDBDataSetEXT(sSQL);
                        
                        if (aResult.length > 0)
                        {
                            // Lösung nur mit Filter Klasse A
                            var sFilterUC = aResult[0].MLFB14_G120;
                            ECL_SetValue("MLFB14_G120", sFilterUC);
                            ECL_SetValue("PMD_AAD146_001_000_G120", "00003");
                            sECSI_MLFB = replaceAt(sECSI_MLFB, 13, sFilterUC);
                            ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                        }
                        /*else // keine Lösung{	}*/
                    }
                }
                else // sonst aus MLFB setzen	//{if (sFilter == "A" || sFilter == "B" || sFilter == "C" || sFilter == "U" )
                {
                    //Filter aus VT setzen																										<--------------- ToDo ... s.u.
                    
                }
                
                var sSQL = "SELECT * FROM VT_G120_M00272_" + sDB_Version + " " +
                            "INNER JOIN VT_G120_M00183_" + sDB_Version + " " +
                            "ON VT_G120_M00272_" + sDB_Version + ".MLFB_KEY_G120 = VT_G120_M00183_" + sDB_Version + ".MLFB_KEY_G120 " +
                            "WHERE VT_G120_M00183_" + sDB_Version + ".HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " +
                            "VT_G120_M00272_" + sDB_Version + ".MLFB06_G120 = "  +  sECSI_MLFB.charAt(5) + " AND " +
                            "VT_G120_M00272_" + sDB_Version + ".MLFB07_G120 = "  +  sECSI_MLFB.charAt(6) + " AND " +
                            "VT_G120_M00272_" + sDB_Version + ".MLFB08_G120 = "  +  sECSI_MLFB.charAt(7) + " AND " +
                            "VT_G120_M00272_" + sDB_Version + ".MLFB09_G120 = '" +  sECSI_MLFB.charAt(8) + "' AND " +
                            "VT_G120_M00272_" + sDB_Version + ".MLFB10_G120 = '" +  sECSI_MLFB.charAt(9) + "' AND " +
                            "VT_G120_M00272_" + sDB_Version + ".MLFB11_G120 = "  +  sDezimalkenner 		+ " AND " +
                            "VT_G120_M00272_" + sDB_Version + ".MLFB12_G120 = "  +  sLeistung1 			+ " AND " + 
                            "VT_G120_M00272_" + sDB_Version + ".MLFB13_G120 = "  +  sLeistung2 			+ " AND " + 
                            "VT_G120_M00272_" + sDB_Version + ".MLFB14_G120 = '" +  sECSI_MLFB.charAt(13) + "' AND " +
                            "VT_G120_M00272_" + sDB_Version + ".MLFB15_G120 = '" +  sECSI_MLFB.charAt(14) + "' AND " +
                            "VT_G120_M00272_" + sDB_Version + ".MLFB16_G120 = "  +  sECSI_MLFB.charAt(15) + " AND " +
                            "VT_G120_M00272_" + sDB_Version + ".HMK_VALUE_VALID_G120 = 'T' AND " +
                            "VT_G120_M00183_" + sDB_Version + ".HMK_VALUE_VALID_G120 = 'T';"; 
                            
                var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00272_" + sDB_Version );
                    
                if (aResult.length > 0)
                {
                    ECL_SetValue("MLFB_KEY_G120", 			aResult[0].MLFB_KEY_G120); 				// MLFB-Key
                    ECL_SetValue("HMK_TYPE_PM_G120", 		aResult[0].HMK_TYPE_PM_G120); 			// Powermodul Typ
                    ECL_SetValue("PMD_AAD146_001_000_G120", aResult[0].PMD_AAD146_001_000_G120); 	// Filter intern
                    //ECL_SetValue("PMD_ABU799_001_000_G120", aResult[0].PMD_ABU799_001_000_G120); 	// Netzspannung
                    ECL_SetValue("TAK_AAJ871_001_000_G120", aResult[0].TAK_AAJ871_001_000_G120); 	// Bauform
                    //ECL_SetValue("PMD_ABJ176_001_000_G120", aResult[0].PMD_ABJ176_001_000_G120); 	// Schutzart IP ---> immer IP20 bei G120, S110, S120 und PM 00003, 00005, 00008
                    
                    ECL_SetValue("MLFB06_G120", sECSI_MLFB.charAt(5));
                    ECL_SetValue("MLFB07_G120", sECSI_MLFB.charAt(6));
                    ECL_SetValue("MLFB08_G120", sECSI_MLFB.charAt(7));
                    ECL_SetValue("MLFB09_G120", sECSI_MLFB.charAt(8));
                    ECL_SetValue("MLFB10_G120", sECSI_MLFB.charAt(9));
                    ECL_SetValue("MLFB11_G120", sDezimalkenner);
                    ECL_SetValue("MLFB12_G120", sLeistung1);
                    ECL_SetValue("MLFB13_G120", sLeistung2);
                    ECL_SetValue("MLFB14_G120", sECSI_MLFB.charAt(13));
                    ECL_SetValue("MLFB15_G120", sECSI_MLFB.charAt(14));
                    ECL_SetValue("MLFB16_G120", sECSI_MLFB.charAt(15));
                    
                    //MLFB-KEY
                    var sMLFB_KEY = aResult[0].MLFB_KEY_G120;
                    
                }
                else
                {
                    // Fehler: für MLFB-Daten kein Treffer in VT:
                    sECSI_STATUS = "E"; 
                    sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___NO_VALUE_VT_BASIS_MLFB_G120") + " '" + sECSI_MLFB + "' ";
                    ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
                    ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                        return;
                }
                // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++				
            }
            // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        }
        else
        {
            //Fehler bei MLFB Übergabe
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MLFB_NOT_DEFINED_G120") + " "; //"MLFB nicht definiert. ";
            ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
            ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                return;
        } 
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Regenerativer Betrieb
        // VT_G120_M00173	Zubehör Bremswiderstand				VT_G120_M00173_24213
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        /*
        MLFB_KEY_G120	HMK_BRAKERESISTOR_G120	MLFB_BREMSWIDERSTAND_G120	HMK_VALUE_VALID_G120
        
        VT233:
        HMK_PRODUKT_TRIG_G120	HMK_RUECKSP_UEBERGAB_G120	HMK_DEFAULT_BRAKEBEH_G120	Default für Brakebehaviour
        G120				 	T    	1					00001						Energierückspeisung
        G120 					F    	2					00002						optionaler Bremswiderstand
        S120 					T    	1					00003						reduziert: kein...Rückspeisung
        S120 					F    	2					00002						optionaler Bremswiderstand
        S110 					F    	2					00002						optionaler Bremswiderstand
        
        RegenerativeMode
            0	Any
            1	FeedbackMainSupply
            2	DissipateBrakeResistor
        
        // PM240-2 Standard		6SL3210 (10)	00005			G120, S110 fix, S120 (generatorischer Betrieb: optionalem Bremswiderstand)
        // PM240-2 Push-Through	6SL3211	(11)	00005			
        // PM250				6SL3225	(25)	00003			G120 generatorischer Betrieb: Energierückspeisung
        // Chassis				6SL32 10/15		00008			S120 generatorischer Betrieb: reduziert (00003)
        */
        
        // s.o. var ECSI_CX_RegenerativeMode = ECL_GetValue("ECSI_CX_RegenerativeMode");
        if (ECSI_CX_RegenerativeMode > 0)
        {
            // Bremswiderstand nur bei Kontext 'Energie abführen' aktivieren
            if (ECSI_CX_RegenerativeMode == 1 || ECSI_CX_RegenerativeMode == 2)
            {
                var sPowerModule = ECL_GetValue("HMK_TYPE_PM_G120");
                // Unterscheidung 1 = Rückspeisung nur mit PM250, aber kein Bremswiderstand
                if (ECSI_CX_RegenerativeMode == 1 && (sPowerModule == "00005" || sPowerModule == "00008")){
                    // Fehler
                    sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___REG_MODE_PM_G120") + " "; 
                    // Übergabestatus setzen
                    ECL_SelectValue("ECSI_STATUS", "E");
                    ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                    return;
                }
                
                // 2 = Bremswiderstand mit PM240
                if (ECSI_CX_RegenerativeMode == 2 && ECL_GetValue("HMK_TYPE_PM_G120") == "00005"){
                    var MLFB_KEY_G120 = ECL_GetValue("MLFB_KEY_G120");
                    
                    var sSQL = "SELECT * FROM VT_G120_M00173_" + sDB_Version + " WHERE MLFB_KEY_G120 = '" + MLFB_KEY_G120 + "' AND HMK_BRAKERESISTOR_G120 = 'T';";	// Was ist mit Custom?
                    
                    var aResult = GetDBDataSetEXT(sSQL);
                    if (aResult.length > 0)
                    {
                        // Bremswiderstand vorgegeben:
                        // Behandlung "Custom" 
                        if (ECSI_CX_CustomBrakingResistor == "1" || ECSI_CX_CustomBrakingResistor == "True"){
                            ECL_SetValue("HMK_BRAKERESISTOR_G120","F");	
                            ECL_SetValue("UI_HMK_BRAKERESISTOR_G120","CUSTOM");	
                            ECL_DeactivateValue("UI_HMK_BRAKERESISTOR_G120","F");	
                        }else{
                            ECL_SetValue("UI_HMK_BRAKERESISTOR_G120","T");	
                            ECL_DeactivateValue("UI_HMK_BRAKERESISTOR_G120","F");	
                            ECL_SetValue("HMK_BRAKERESISTOR_G120","T");	
                            ECL_DeactivateValue("HMK_BRAKERESISTOR_G120","F");	
                        }
                        
                    }
                    else{
                        if (ECSI_CX_CustomBrakingResistor == "1" || ECSI_CX_CustomBrakingResistor == "True"){
                            ECL_SetValue("HMK_BRAKERESISTOR_G120","F");	
                            ECL_SetValue("UI_HMK_BRAKERESISTOR_G120","CUSTOM");	
                            ECL_DeactivateValue("UI_HMK_BRAKERESISTOR_G120","F");
                        }else{
                            // Fehler
                            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___BRAKE_RESISTOR_CX_G120") + " "; 
                            // Übergabestatus setzen
                            ECL_SelectValue("ECSI_STATUS", "E");
                            ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                            return;
                        }
                    }
                    sStatusBR = "mit";
                    // Behandlung "Custom" 
                    if (ECSI_CX_CustomBrakingResistor == "1" || ECSI_CX_CustomBrakingResistor == "True" ){
                        ECL_DeactivateValue("UI_HMK_BRAKERESISTOR_G120", "F");
                        ECL_EnableAttribute("UI_HMK_BRAKERESISTOR_G120");
                    }else{
                        ECL_DisableAttribute("UI_HMK_BRAKERESISTOR_G120");
                        //ECL_DisableAttribute("HMK_BRAKERESISTOR_G120");
                    }
                }
                
                if (ECSI_CX_RegenerativeMode == 2 && ECL_GetValue("HMK_TYPE_PM_G120") == "00003"){
                    // Fehler
                    sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___REG_MODE_PM_G120") + " "; 
                    // Übergabestatus setzen
                    ECL_SelectValue("ECSI_STATUS", "E");
                    ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                    return;
                }
            }
            else{
                // Fehler
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___REGENERATIVE_MODE_INVALID_G120") + " "; 
                // Übergabestatus setzen
                ECL_SelectValue("ECSI_STATUS", "E");
                ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                return;
            }
        }
        else{
            ECL_SetValue("ECSI_CC_BrakingResistorID", "");
            ECL_EnableAttribute("UI_HMK_BRAKERESISTOR_G120");
            ECL_ActivateValue("UI_HMK_BRAKERESISTOR_G120", "F");
            ECL_ActivateValue("HMK_BRAKERESISTOR_G120", "F");
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        setCheckBoxAttributes(HMK_PRODUKT_TRIG_G120);
    }
    
    
    // ##########################################################################################################################
    // Sekundäre MLFBs
    // ##########################################################################################################################
    
    if ( (sCurrentAttribute == "ECSI_MLFB") && (sECSI_MLFB_SEC !== "") ) 
    {
        var sMLFB14			= ECL_GetValue("MLFB14_G120");
        var sPM_Type		= ECL_GetValue("HMK_TYPE_PM_G120"); 
        var sBauform 		= ECL_GetValue("TAK_AAJ871_001_000_G120"); 
        var sMLFB_Key 		= ECL_GetValue("MLFB_KEY_G120");
        var sSchutzart 		= ECL_GetValue("PMD_ABJ176_001_000_G120");
        var sCU 			= ECL_GetValue("HMK_TYPE_CU_G120"); 
        var sFilterIntern	 = ECL_GetValue("PMD_AAD146_001_000_G120"); 
        
        // VPM parsing
        // "VPM_MODULE_S110_S120"
        // VPM_120_S110_S120			- 6SN11131AA001JA1
        // VPM_200_S110_S120			- 6SN11131AA001KA1
        // VPM_200_DYNAMIK_S110_S120	- 6SN11131AA001KC1
        
        var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");
        for(var i = 0; i < secondaryMlfbArray.length; i++)
        {
            if(secondaryMlfbArray[i] === "6SN11131AA001JA1")
            {
                ECL_SelectValue("VPM_MODULE_S110_S120", "VPM_120_S110_S120");
                break;
            }
            else if(secondaryMlfbArray[i] === "6SN11131AA001KA1")
            {
                ECL_SelectValue("VPM_MODULE_S110_S120", "VPM_200_S110_S120");
                break;
            }
            else if(secondaryMlfbArray[i] === "6SN11131AA001KC1")
            {
                ECL_SelectValue("VPM_MODULE_S110_S120", "VPM_200_DYNAMIK_S110_S120");
                break;
            }
            else
            {
                ECL_SelectValue("VPM_MODULE_S110_S120", "VPM_NONE_S110_S120");
            }
        }
        
        // übergebene MLFB_SEC parsen
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Control Unit
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        /* MLFBs CU VT_G120_M00078_24213 inner join VT188 
            HMK_MLFB_CONTROLUNIT_G120		HMK_TYPE_CU_G120					Kommunikation
            6SL32430BB301PA3				00078	T    	CU230P-2 DP		
            6SL32430BB301HA3				00079	T    	CU230P-2 HVAC	
            6SL32430BB301FA0				00080	T    	CU230P-2 PN		
            6SL32440BB121BA1				00084	T    	CU240E-2			
            6SL32440BB121PA1				00085	T    	CU240E-2 DP		
            6SL32440BB131PA1				00086	T    	CU240E-2 DP-F	
            6SL32440BB131BA1				00087	T    	CU240E-2 F		
            6SL32440BB121FA0				00088	T    	CU240E-2 PN		
            6SL32440BB131FA0				00089	T    	CU240E-2 PN-F	
            6SL32460BA221BA0				00320	T    	CU250S-2			
            6SL32460BA221PA0				00321	T    	CU250S-2 DP		
            6SL32460BA221FA0				00322	T    	CU250S-2 PN		
            6SL32460BA221CA0				00323	T    	CU250S-2 CAN	
            
                  30..3 - CU230P
                  40..1 - CU240E
                  60..2 - CU250S
                       0 - --
                       2 - --
                       3 - F
                         P - DP
                         H - HAVA
                         F - PN
                         B - -- USS/Modbus???
                         C - CAN
            6SL30400JA010AA0				00324			CU305 PN			S110
            6SL30400JA000AA0				00325			CU305 DP			S110
            6SL30401LA010AA0				00994			CU310-2 PN			S120
            6SL30401LA000AA0				00995			CU310-2 DP			S120
            6SL30400PA000AA1				00996			CUA31, CU Adapter	S120
            6SL30400PA010AA0				00997			CUA32, CU Adapter	S120
                       1 - PN
                       0 - DP
                    P  0 - CUA31
                    P  1 - CUA32
            */
        var sSQL = 	"SELECT VT_G120_M00078_" + sDB_Version + ".HMK_TYPE_CU_G120, VT_G120_M00078_" + sDB_Version + ".HMK_MLFB_CONTROLUNIT_G120 FROM VT_G120_M00078_" + sDB_Version + " " +
                    "INNER JOIN VT_G120_M00188_" + sDB_Version + " " +
                    "ON VT_G120_M00188_" + sDB_Version + ".HMK_TYPE_CU_G120 = VT_G120_M00078_" + sDB_Version + ".HMK_TYPE_CU_G120 "+
                    "WHERE VT_G120_M00188_" + sDB_Version + ".HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "';";
        var sHMK_MLFB_CONTROLUNIT_G120 = "";
        var aResult = GetDBDataSetEXT(sSQL, "CU_JOIN");
        if (aResult.length > 0)
        {
            for (var i = 0; i < aResult.length; i++)
            {
                if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_CONTROLUNIT_G120) >= 0)
                {
                    ECL_SelectValue("HMK_TYPE_CU_G120", aResult[i].HMK_TYPE_CU_G120);
                    
                    sHMK_MLFB_CONTROLUNIT_G120 = aResult[i].HMK_MLFB_CONTROLUNIT_G120;
                    
                    if (HMK_PRODUKT_TRIG_G120 == "G120"){
                        var sBusCU = aResult[i].HMK_MLFB_CONTROLUNIT_G120.charAt(13);
                        var sBus = "";
                        switch ( sBusCU
                        ) {
                            case "B":
                                sBus = "00004";
                            break;
                            case "C":
                                sBus = "00003";
                            break;
                            case "F":
                                sBus = "00002";
                            break;
                            case "H":
                                sBus = "00004";
                            break;
                            case "P":
                                sBus = "00001";
                            break;
                        }
                    }else{
                        var sBusCU_1 = aResult[i].HMK_MLFB_CONTROLUNIT_G120.charAt(8); // Stelle 9: J, L, P 
                        var sBusCU_2 = aResult[i].HMK_MLFB_CONTROLUNIT_G120.charAt(11);// Stelle 12: 0, 1
                        var sBus = "";
                        
                        if (sBusCU_1 == "P"){
                            sBus = "00012";
                        }else{
                            if (sBusCU_2 == 1){
                                sBus = "00002";	// PN
                            }else if(sBusCU_2 == 0){
                                sBus = "00001";	// DP
                            }
                        }
                    }
                    
                    ECL_SelectValue("PMD_ABU804_001_000_G120", sBus);
                    // VT-Auswertung außerhalb Parser
                    break;
                }
            } 
        }
        var sCU = ECL_GetValue("HMK_TYPE_CU_G120");
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Speicherkarte			VT_G120_M00185_24213
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        var sSQL = 	"SELECT * FROM VT_G120_M00185_" + sDB_Version + " WHERE (HMK_MEMORYCARD_G120 = '00234' OR HMK_MEMORYCARD_G120 = '00235') AND " + 
                    "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND HMK_VALUE_VALID_G120 = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00185_" + sDB_Version +"_PARSE");
        if (aResult.length > 0)
        {
            //Speicherkarte		leer: 			6SL30544AG002AA0	 	00234
            //Speicherkarte		mit Firmware: 	6SL30547TF002BA0		00235
            var sStatus = "ohne";
            for (var i = 0; i < aResult.length; i++)
            {
                if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_MEMORYCARD_G120) >= 0)
                {
                    // MLFB enthalten, also Attribute für übergebene MLFBs belegen 
                    ECL_SelectValue("HMK_MEMORYCARD_G120", aResult[i].HMK_MEMORYCARD_G120);
                    sStatus = "mit";
                }
            }
            var secMlfbs = sECSI_MLFB_SEC.split(";");
            for(i=0; i< secMlfbs.length; i++)
            {
                //todo get rid of short options for this condition as they are not handled in the DB like this: 6SL30540FC311BA0-Z F01
                // but as separate entities - 1: 6SL30540FC311BA0; 2: F01|otherOption|oneMoreOption|etc...
                var mlfbWithoutShortOptions = removeShortOptionsFromMlfb(secMlfbs[i]);
                if(mlfbInFwDb(mlfbWithoutShortOptions))
                {
                    determineFwVersionSpike(sECSI_MLFB_SEC);
                    determineshortOptionsState(secMlfbs[i]);
                    sStatus = "mit";
                    ECL_SelectValue("HMK_MEMORYCARD_G120", "00235");
                }
            }
        }
        
        if (sStatus == "mit")
        {
            // Steuerung Extensions E01/F01:
            if (sECSI_MLFB_SEC.indexOf("-Z E01") >= 0){
                // enthalten, also Attribute belegen 
                ECL_SelectValue("HMK_E01_G120", "E01");
            }else{
                ECL_SelectValue("HMK_E01_G120", "NON");
            }
            
            if ((sECSI_MLFB_SEC.indexOf("-Z A01") >= 0 || sECSI_MLFB_SEC.indexOf("+A01") >= 0) && HMK_PRODUKT_TRIG_G120 == "S120"){
                // enthalten, also Attribute belegen 
                ECL_SelectValue("HMK_F01_G120", "F01");
                ECL_SelectValue("CB_ADVANCED_SAFETY_G120", "T");
            }else{
                ECL_SelectValue("HMK_F01_G120", "NON");
                ECL_DeselectAttribute("CB_ADVANCED_SAFETY_G120");
            }
            
            if ((sECSI_MLFB_SEC.indexOf("-Z F01") >= 0) || sECSI_MLFB_SEC.indexOf("+F01") >= 0){
                // enthalten, also Attribute belegen 
                ECL_SelectValue("HMK_F01_G120", "F01");
            }/*else{
                ECL_SelectValue("HMK_F01_G120", "NON");
            }*/
            
            if (sECSI_MLFB_SEC.indexOf("-Z J01") >= 0){
                // enthalten, also Attribute belegen 
                ECL_SelectValue("HMK_J01_G120", "J01");
            }else{
                ECL_SelectValue("HMK_J01_G120", "F");
            }
            
            if (sECSI_MLFB_SEC.indexOf("-Z U01") >= 0){
                // enthalten, also Attribute belegen 
                ECL_SelectValue("HMK_U01_G120", "U01");
            }else{
                ECL_SelectValue("HMK_U01_G120", "F");
            }
        }else{
            // Ohne Speicherkarte
            ECL_SelectValue("HMK_MEMORYCARD_G120", "00001"); // ohne
            ECL_SelectValue("HMK_E01_G120", "NON");
            ECL_SelectValue("HMK_F01_G120", "NON");
            ECL_SelectValue("HMK_J01_G120", "F");
            ECL_SelectValue("HMK_U01_G120", "F");
        }
        
        var secMlfbs = sECSI_MLFB_SEC.split(";");
        for(i=0; i< secMlfbs.length; i++)
        {
            //todo get rid of short options for this condition as they are not handled in the DB like this: 6SL30540FC311BA0-Z F01
            // but as separate entities - 1: 6SL30540FC311BA0; 2: F01|otherOption|oneMoreOption|...
            var mlfbWithoutShortOptions = removeShortOptionsFromMlfb(secMlfbs[i]);
            if(mlfbInFwDb(mlfbWithoutShortOptions))
            {
                //determineshortOptionsState(secMlfbs[i]);
            }
        }
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // NEMA-Kit	   VT_G120_M00245_24213															nur PM 00005 PM240-2
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // HMK_TYPE_PM_G120	HMK_PUSH_THROUGH_G120	TAK_AAJ871_001_000_G120	HMK_MLFB_NEMA_KIT_1002980	HMK_NEMA_KIT_G120
        var bStatus = false;
        if (ECSI_CX_Certificates && ECSI_CX_Certificates.indexOf("ULR_CSA") > -1){
            var sSQL = "SELECT * FROM VT_G120_M00245_" + sDB_Version + " WHERE HMK_NEMA_KIT_G120 = 'T' AND HMK_TYPE_PM_G120 = '" + sPM_Type + "' AND TAK_AAJ871_001_000_G120 = '" + sBauform + "';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00245_" + sDB_Version +"_PARSE");
            if (aResult.length > 0){
                for (var i = 0; i < aResult.length; i++){
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_NEMA_KIT_1002980) >= 0){
                        ECL_SelectValue("HMK_NEMA_KIT_G120", "T");
                        bStatus = true;
                        break;
                    }
                }
            }
        }
        if (bStatus){
            ECL_SelectValue("HMK_NEMA_KIT_G120", "T"); // mit
        }else{
            // Kein NEMA-Kit zulässig oder nicht gewählt
            ECL_SelectValue("HMK_NEMA_KIT_G120", "F");
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Operator Panel
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // MLFB Panel aus VT_G120_M00243
            /*
            PMD_ABU803_001_000_G120	HMK_MLFB_PANEL_G120
            00073					6SL32550AA004CA1	BOP2			G120
            00113					6SL32550AA004JA2	IOP2			G120
            00114					6SL32550AA004JA0	ohne			alle
            00116					6SL30550AA004BA0	BOP20			S110, S120
            
            */
        if (HMK_PRODUKT_TRIG_G120 == "G120"){
            var sSQL = "SELECT * FROM VT_G120_M00243_" + sDB_Version + " WHERE (PMD_ABU803_001_000_G120 = '00073' OR PMD_ABU803_001_000_G120 = '00113') AND HMK_VALUE_VALID_G120 = 'T';";
        }else{
            var sSQL = "SELECT * FROM VT_G120_M00243_" + sDB_Version + " WHERE PMD_ABU803_001_000_G120 = '00116' AND HMK_VALUE_VALID_G120 = 'T';";
        }
        var bStatus = false;
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00243_" + sDB_Version +"_PARSE");
        if (aResult.length > 0){
            
            for (var i = 0; i < aResult.length; i++){
                if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_PANEL_G120) >= 0){
                    var PMD_ABU803_001_000_G120 = aResult[i].PMD_ABU803_001_000_G120;
                    bStatus = true;
                    break;
                }
            } 
        }
        if (bStatus){
            ECL_SelectValue("PMD_ABU803_001_000_G120", aResult[i].PMD_ABU803_001_000_G120);
            ECL_SelectValue("HMK_IOP_HANDHELD_G120", "F");
        }else{	
            ECL_SelectValue("PMD_ABU803_001_000_G120", "00114");
            ECL_SelectValue("HMK_IOP_HANDHELD_G120", "F");
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // folgendes nur für G120:
        if (HMK_PRODUKT_TRIG_G120 == "G120"){
        
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // IOP-Handheld																									nur G120
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // Wenn Handheld, dann wird IOP-2 gesetzt, MLFB nur Handheld!  --> Handheld übersteuert Bedienpanel
                /*
                HMK_IOP_HANDHELD_G120 = 'T'
                $self.MLFB_G120 = '6SL32550AA004HA1
                */
            if (sECSI_MLFB_SEC.indexOf("6SL32550AA004HA1") >= 0){
                ECL_SelectValue("PMD_ABU803_001_000_G120", "00113"); // IOP-2
                ECL_SelectValue("HMK_IOP_HANDHELD_G120", "T");
            }else{
                ECL_SelectValue("HMK_IOP_HANDHELD_G120", "F");
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // IOP Türmontagesatz																							nur G120
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                /*
                PMD_ABU776_001_000_G120 = 'T'
                MLFB_G120 = '6SL32560AP000JA0'
                */
            if (sECSI_MLFB_SEC.indexOf("6SL32560AP000JA0") >= 0)
            {
                //ECL_DisableValue("PMD_ABU803_001_000_G120", "00114"); // 'Ohne' nicht möglich / Bedienpanel Required --> VT???
                ECL_SelectValue("PMD_ABU776_001_000_G120", "T");
            }
            else
            {
                ECL_SelectValue("PMD_ABU776_001_000_G120", "F");
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // DigitalTwin																							nur G120
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            var sSQL = "SELECT * FROM VT_G120_M00293_" + sDB_Version + " WHERE HMK_DRV_SIM_DESIGNER_G120 like '%T%' AND HMK_PRODUKT_TRIG_G120 = 'G120';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00243_" + sDB_Version +"_PARSE");

            if (sECSI_MLFB_SEC.indexOf(aResult[0].HMK_MLFB_DRV_SIM_DES_G120.trim()) >= 0)
            {
                //ECL_DisableValue("PMD_ABU803_001_000_G120", "00114"); // 'Ohne' nicht möglich / Bedienpanel Required --> VT???
                ECL_SelectValue("HMK_DRIVESIM_DESIGNER_G120", "T");
            }
            else
            {
                ECL_SelectValue("HMK_DRIVESIM_DESIGNER_G120", "");
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Smart Access Modul 	VT_G120_M00225_24213																	nur G120
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            //HMK_SMART_ACCESS_G120	HMK_MLFB_SMARTACC_G120	HMK_VALUE_VALID_G120
            
            var sSQL = "SELECT HMK_MLFB_SMARTACC_G120 FROM VT_G120_M00225_" + sDB_Version + " WHERE HMK_SMART_ACCESS_G120 = 'T' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "HMK_MLFB_SMARTACC_G120"+"_PARSE");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_SMARTACC_G120) >= 0)
                    {
                        ECL_SelectValue("HMK_SMART_ACCESS_G120", "T");
                        sStatus = "mit";
                    }
                }
                // Ohne Webserver-Modul
                if (sStatus == "ohne")
                {
                    ECL_SelectValue("HMK_SMART_ACCESS_G120", "F"); // ohne
                }
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // SINAMICS CONNECT 300 IoT Gateway 	VT_G120_M00265_24213	HMK_CONNECT_300_G120
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            //   HMK_PRODUKT_TRIG_G120	HMK_TYPE_CU_G120	HMK_CONNECT_300_G120	MLFB_CONNECT_300_G120	HMK_VALUE_VALID_G120
            
            var sSQL = "SELECT DISTINCT MLFB_CONNECT_300_G120 FROM VT_G120_M00265_" + sDB_Version + " WHERE " + 
                        "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " +
                        "HMK_TYPE_CU_G120 = '" + sCU + "' AND " +
                        "HMK_CONNECT_300_G120 = 'T' AND " +
                        "HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL);
            var sStatus = "ohne";
            
            if (aResult.length > 0)
            {
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].MLFB_CONNECT_300_G120) >= 0)
                    {
                        ECL_SelectValue("HMK_CONNECT_300_G120", "T");
                        sStatus = "mit";
                        break;
                    }
                }
            }
            
            // Ohne Gateway
            if (sStatus == "ohne")
            {
                ECL_SelectValue("HMK_CONNECT_300_G120", "F"); // ohne
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Control Unit Adapter Kit CUA20 	HMK_ADAPT_KIT_CUA20_G120			 	VT_G120_M00261_24213				nur G120
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_TYPE_PM_G120	HMK_TYPE_CU_G120	HMK_ADAPT_KIT_CUA20_G120	HMK_MLFB_ADKIT_CUA20_G120	HMK_VALUE_VALID_G120
            
            var sSQL = "SELECT HMK_MLFB_ADKIT_CUA20_G120 FROM VT_G120_M00261_" + sDB_Version + " WHERE HMK_ADAPT_KIT_CUA20_G120 = 'T' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "HMK_MLFB_ADKIT_CUA20_G120"+"_PARSE");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_ADKIT_CUA20_G120) >= 0)
                    {
                        ECL_SelectValue("HMK_ADAPT_KIT_CUA20_G120", "T");
                        sStatus = "mit";
                    }
                }
                // Ohne CU-Adapter-Kit CUA20
                if (sStatus == "ohne")
                {
                    ECL_SelectValue("HMK_ADAPT_KIT_CUA20_G120", "F"); // ohne
                }
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Umrichter-Verbindungssatz (PC oder Handheld)																	nur G120
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            if (sECSI_MLFB_SEC.indexOf("6SL32550AA002CA0") >= 0)
            {
                // MLFB enthalten, also Attribute für übergebene MLFBs belegen
                ECL_SelectValue("PMD_ABU783_001_000_G120", "T");
            }
            else
            {
                ECL_SelectValue("PMD_ABU783_001_000_G120", "F");
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Schirmanschlusssatz Control Unit   HMK_SCHIRMANSCHL_CU_G120													nur G120
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_TYPE_CU_G120	HMK_SCHIRMANSCHL_CU_G120	HMK_MLFB_SCHIRM_CU_G120	HMK_VALUE_VALID_G120
            
            var sSQL = "SELECT * FROM VT_G120_M00142_" + sDB_Version + " WHERE HMK_SCHIRMANSCHL_CU_G120 = 'T' AND HMK_TYPE_CU_G120 = '" + sCU + "' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00142_" + sDB_Version +"_PARSE");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_SCHIRM_CU_G120) >= 0)
                    {
                        ECL_SelectValue("HMK_SCHIRMANSCHL_CU_G120", "T");
                        var sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SelectValue("HMK_SCHIRMANSCHL_CU_G120", "F"); // ohne
                }
            }			
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Schirmanschlusssatz Power Modul																				nur G120
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // MLFB_KEY_G120	PMD_ABU790_001_000_G120	HMK_MLFB_SCHIRM_PM_G120	HMK_VALUE_VALID_G120
            
            var sSQL = "SELECT * FROM VT_G120_M00162_" + sDB_Version + " WHERE PMD_ABU790_001_000_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00162_" + sDB_Version +"_PARSE");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_SCHIRM_PM_G120) >= 0)
                    {
                        ECL_SetValue("PMD_ABU790_001_000_G120", "T");
                        var sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SetValue("PMD_ABU790_001_000_G120", "F"); // ohne
                }
            }
            else
            {
                ECL_SetValue("PMD_ABU790_001_000_G120", "F"); // ohne
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // DSEE - Drive Service Extended Exchange für Power Modul		VT_G120_M00254_24213							nur G120
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            /*
            MLFB_KEY_G120	MLFB14_G120	HMK_DSEE_PM_G120	HMK_MLFB_DSEE_PM_G120	HMK_VALUE_VALID_G120
            */
            
            var sSQL = "SELECT * FROM VT_G120_M00254_" + sDB_Version + " WHERE " + 
                        "MLFB_KEY_G120 = '" + sMLFB_Key + "' AND " +
                        "MLFB14_G120 = '" + sMLFB14 + "' AND " +
                        "HMK_DSEE_PM_G120 != 'OHNE' AND HMK_VALUE_VALID_G120 = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00254_" + sDB_Version +"_PARSE");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_DSEE_PM_G120) >= 0)
                    {
                        ECL_SetValue("HMK_DSEE_PM_G120", aResult[i].HMK_DSEE_PM_G120);
                        sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SetValue("HMK_DSEE_PM_G120", "OHNE");
                }
            }
            else
            {
                ECL_SetValue("HMK_DSEE_PM_G120", "OHNE");
            }
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // DSEE - Drive Service Extended Exchange für Control Unit		VT_G120_M00255_24213							nur G120
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            /*
            HMK_MLFB_CONTROLUNIT_G120	HMK_DSEE_CU_G120	HMK_MLFB_DSEE_CU_G120	HMK_VALUE_VALID_G120
            */
            
            var sSQL = "SELECT * FROM VT_G120_M00255_" + sDB_Version + " WHERE HMK_MLFB_CONTROLUNIT_G120 = '" + sHMK_MLFB_CONTROLUNIT_G120 + "' AND HMK_DSEE_CU_G120 != 'OHNE' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00255_" + sDB_Version +"_PARSE");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_DSEE_CU_G120) >= 0)
                    {
                        ECL_SetValue("HMK_DSEE_CU_G120", aResult[i].HMK_DSEE_CU_G120);
                        sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SetValue("HMK_DSEE_CU_G120", "OHNE");
                }
            }
            else
            {
                ECL_SetValue("HMK_DSEE_CU_G120", "OHNE");
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // DSA - Drive Service Agreement 'DSA'		VT_G120C_M00086_17984
            /*
            HMK_DSA_G120	HMK_MLFB_DSA_G120	HMK_VALUE_VALID_G120C
            */
            /*	Keine Daten in DB
            
                var sSQL = "SELECT * FROM VT_G120C_M00086_17984 WHERE HMK_DSA_G120 != 'OHNE' AND HMK_VALUE_VALID_G120C = 'T';";
                var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
                if (aResult.length > 0)
                {
                    var sStatus = "ohne";
                    for (var i = 0; i < aResult.length; i++)
                    {
                        if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_DSA_G120) >= 0)
                        {
                            ECL_SetValue("HMK_DSA_G120", aResult[i].HMK_DSA_G120);
                            sStatus = "mit";
                        }
                    }
                    if (sStatus == "ohne")
                    {
                        ECL_SetValue("HMK_DSA_G120", "OHNE");
                    }
                }
                else
                {
                    ECL_SetValue("HMK_DSA_G120", "OHNE");
                }
                // ---------------------------------------------------------------------------
            */
        }else{
            
            ECL_SelectValue("HMK_IOP_HANDHELD_G120", "F");
            ECL_SelectValue("PMD_ABU776_001_000_G120", "F");	// IOP- Tür Montagesatz
            ECL_SelectValue("HMK_SMART_ACCESS_G120", "F"); // ohne
            ECL_SelectValue("HMK_ADAPT_KIT_CUA20_G120", "F"); // ohne
            ECL_SelectValue("PMD_ABU783_001_000_G120", "F");
            ECL_SelectValue("HMK_SCHIRMANSCHL_CU_G120", "F"); // ohne
            ECL_SetValue("PMD_ABU790_001_000_G120", "F"); // ohne
            ECL_SetValue("HMK_DSEE_PM_G120", "OHNE");
            ECL_SetValue("HMK_DSEE_CU_G120", "OHNE");
        }
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Brake Relay HMK_BRAKERELAY_G120  6SL32520BB000AA0   														nicht S110
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // VT_G120_M00240_24213
        // TAK_AAJ871_001_000_G120	HMK_MLFB_BRAKEREL_G120	HMK_BRAKERELAY_G120
        if (HMK_PRODUKT_TRIG_G120 != "S110"){
            if (sECSI_MLFB_SEC.indexOf("6SL32520BB000AA0") >= 0){
                ECL_SelectValue("HMK_BRAKERELAY_G120", "T");
            }else{
                ECL_SelectValue("HMK_BRAKERELAY_G120", "F"); // ohne
            }
        }else{
            ECL_SelectValue("HMK_BRAKERELAY_G120", "F"); // ohne
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Safe Brake Relay   VT_G120_M00237_24213 6SL32520BB010AA0, 6SL33552DX001AA0											alle
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // TAK_AAJ871_001_000_G120	HMK_MLFB_SAFEBRAKER_G120	HMK_SAFEBRAKERELAY_G120
        if (sECSI_MLFB_SEC.indexOf("6SL32520BB010AA0") >= 0 || sECSI_MLFB_SEC.indexOf("6SL33552DX001AA0") >= 0)
        {
            if (ECL_GetValue("HMK_BRAKERELAY_G120") == "F")
            {
            // nur wenn kein Standard-Bremsrelais gewählt, kann das Safebrake-Relais verwendet werden.
                ECL_SelectValue("HMK_SAFEBRAKERELAY_G120", "T");
            }
            else
            {
                ECL_SelectValue("HMK_SAFEBRAKERELAY_G120", "F"); // ohne
                // 
            }
        }
        else
        {
            ECL_SelectValue("HMK_SAFEBRAKERELAY_G120", "F"); // ohne
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Inbetriebnahme-Tool STARTER		6SL30720AA000AG0															nur S110
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        //HMK_TOOL_STARTER_G120
        if (HMK_PRODUKT_TRIG_G120 == "S110"){
            if (sECSI_MLFB_SEC.indexOf("6SL30720AA000AG0") >= 0){
                ECL_SelectValue("HMK_TOOL_STARTER_G120", "T");
            }else{
                ECL_SelectValue("HMK_TOOL_STARTER_G120", "F"); // ohne
            }
        }else{
            ECL_SelectValue("HMK_TOOL_STARTER_G120", "F"); // ohne
        }

        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // SINAMICS FSG Adapter Set 	VT_G120_M00266_24213
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // VT_G120_M00266_24213 ZO PM - Adapter Set
        //   MLFB_KEY_G120 	HMK_ADAPTER_SET_G120   HMK_MLFB_ADAPTER_SET_G120 	HMK_VALUE_VALID_G120
        
        var sSQL = "SELECT DISTINCT HMK_MLFB_ADAPTER_SET_G120 FROM VT_G120_M00266_" + sDB_Version + " WHERE " +
                    "MLFB_KEY_G120 = '" + sMLFB_Key + "' AND " +
                    "HMK_ADAPTER_SET_G120 = 'T' AND " +
                    "HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL);
        
        var sStatus = "ohne";
        
        if (aResult.length > 0){
            for (var i = 0; i < aResult.length; i++){
                if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_ADAPTER_SET_G120) >= 0){
                    ECL_SelectValue("HMK_ADAPTER_SET_G120", "T");
                    sStatus = "mit";
                    break;
                }
            }
        }
        // Ohne Adapter Set
        if (sStatus == "ohne"){
            ECL_SelectValue("HMK_ADAPTER_SET_G120", "F"); // ohne
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Sensor Module Cabinet-Mounted		HMK_SENSORMODULE_G120												nicht G120
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        /*
        $root.HMK_SENSORMODULE_G120 specified and
        $root.HMK_SENSORMODULE_G120 ne '00004'
        *MLFB
        $self.MLFB_G120 = '6SL30550AA005AA3'
           if $root.HMK_SENSORMODULE_G120 = '00001',
        $self.MLFB_G120 = '6SL30550AA005BA3'
           if $root.HMK_SENSORMODULE_G120 = '00002',
        $self.MLFB_G120 = '6SL30550AA005CA2'
           if $root.HMK_SENSORMODULE_G120 = '00003'
        * /
        EDIT 2021.06 TFS 5620128 Removesensor modules from FC
                                               
        if (HMK_PRODUKT_TRIG_G120 == "S110" || HMK_PRODUKT_TRIG_G120 == "S120"){
            
            if (sECSI_MLFB_SEC.indexOf("6SL30550AA005AA3") >= 0){
                var HMK_SENSORMODULE_G120 = "00001";
            }
            else if (sECSI_MLFB_SEC.indexOf("6SL30550AA005BA3") >= 0){
                var HMK_SENSORMODULE_G120 = "00002";
            }
            else if (sECSI_MLFB_SEC.indexOf("6SL30550AA005CA2") >= 0){
                var HMK_SENSORMODULE_G120 = "00003";
            }
            else{
                var HMK_SENSORMODULE_G120 = "00004"; // ohne
            }
            ECL_SelectValue("HMK_SENSORMODULE_G120", HMK_SENSORMODULE_G120);
            
        }else{
            ECL_SelectValue("HMK_SENSORMODULE_G120", "00004"); // ohne
        }
        */
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Bremswiderstand   VT_G120_M00173_24213																		alle
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // MLFB_KEY_G120	HMK_BRAKERESISTOR_G120	MLFB_BREMSWIDERSTAND_G120	HMK_VALUE_VALID_G120
        
        if (sStatusBR == "ohne"){
                
            var sSQL = "SELECT DISTINCT MLFB_BREMSWIDERSTAND_G120 FROM VT_G120_M00173_" + sDB_Version + " WHERE HMK_BRAKERESISTOR_G120 = 'T' AND " +
                        "MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00173_" + sDB_Version +"_PARSE");
            
            var bStatusBR_Sec = false;
            if (aResult.length > 0){
                for (var i = 0; i < aResult.length; i++){
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].MLFB_BREMSWIDERSTAND_G120) >= 0){
                        bStatusBR_Sec = true;
                        break;
                    }
                }
            }
            if (bStatusBR_Sec){
                ECL_SelectValue("HMK_BRAKERESISTOR_G120", "T"); // mit
                ECL_SelectValue("UI_HMK_BRAKERESISTOR_G120", "T"); // mit
            }else{
                if (ECSI_CX_CustomBrakingResistor == "1" || ECSI_CX_CustomBrakingResistor == "True"){
                    ECL_SetValue("HMK_BRAKERESISTOR_G120","F");	
                    ECL_SetValue("UI_HMK_BRAKERESISTOR_G120","CUSTOM");	
                }else{
                    ECL_SetValue("UI_HMK_BRAKERESISTOR_G120","F");	
                    ECL_SetValue("HMK_BRAKERESISTOR_G120","F");	
                }
            }
        }
        /*else{
            ECL_DisableAttribute("HMK_BRAKERESISTOR_G120");
        }*/
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Brakeing Module																								nur S120
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        if (HMK_PRODUKT_TRIG_G120 == "S120"){
            // VT_G120_M00247_24213
            // MLFB_KEY_G120	HMK_BRAKEMODULE_G120	MLFB_BREMSMODUL_G120	HMK_VALUE_VALID_G120
            var sSQL = "SELECT DISTINCT MLFB_BREMSMODUL_G120 FROM VT_G120_M00247_" + sDB_Version + " WHERE HMK_BRAKEMODULE_G120 = 'T' AND " + 
                        "MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00247_" + sDB_Version +"_PARSE");
            if (aResult.length > 0){
                var sStatusBM_Sec = "ohne";
                for (var i = 0; i < aResult.length; i++){
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].MLFB_BREMSMODUL_G120) >= 0){
                        ECL_SelectValue("HMK_BRAKEMODULE_G120", "T");
                        var sStatusBM_Sec = "mit";
                        break;
                    }
                }
                if (sStatusBM_Sec == "ohne"){
                    ECL_SelectValue("HMK_BRAKEMODULE_G120", "F"); // ohne
                }
            }else{
                ECL_SelectValue("HMK_BRAKEMODULE_G120", "F"); // ohne
            }
        }else{
            ECL_SelectValue("HMK_BRAKEMODULE_G120", "F"); // ohne
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Externer Netzfilter    VT_G120_M00158_24213																	alle
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // S120: zusätzlich Filter Klasse A, da bei PM Chassis kein interner Filter möglich
        
        // MLFB_KEY_G120	HMK_NETZFILTER_EXT_G120	HMK_MLFB_NETFILTER_G120	HMK_VALUE_VALID_G120
        if (sFilterIntern == '00007') //ohne, da wenn Filter A (00003) --> kein externer Netzfilter zugelassen!  PMD_AAD146_001_000_G120
        {
            var sSQL = "SELECT * FROM VT_G120_M00158_" + sDB_Version + " WHERE (HMK_NETZFILTER_EXT_G120 = '00149' OR HMK_NETZFILTER_EXT_G120 = '00150') AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00158_" + sDB_Version +"_PARSE");
            var bStatus = false;
            if (aResult.length > 0)
            {
                
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_NETFILTER_G120) >= 0)
                    {
                        var HMK_NETZFILTER_EXT_G120 = aResult[i].HMK_NETZFILTER_EXT_G120;
                        //ECL_SelectValue("HMK_NETZFILTER_EXT_G120", HMK_NETZFILTER_EXT_G120);
                        var bStatus = true;
                        break;
                    }
                }
            }
            if (bStatus)
            {
                ECL_SelectValue("HMK_NETZFILTER_EXT_G120", HMK_NETZFILTER_EXT_G120); // mit
            }else{
                ECL_SelectValue("HMK_NETZFILTER_EXT_G120", "00001"); // ohne
            }
        }else{
            ECL_SelectValue("HMK_NETZFILTER_EXT_G120", "00001"); // ohne
        }
        // else if (00003) und Treffer, dann Fehler!
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Netzdrossel   VT_G120_M00290_24213																			alle
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // MLFB_KEY_G120	PMD_ABU782_001_000_G120	HMK_MLFB_LINEREAC_G120	HMK_VALUE_VALID_G120
        
        if (sPM_Type == '00005' || sPM_Type == '00008') // PM == 00003 --> keine Netzdrossel! (siehe VT_G120_M00290_24213)
        {
            var sSQL = "SELECT * FROM VT_G120_M00290_" + sDB_Version + " WHERE PMD_ABU782_001_000_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00290_" + sDB_Version +"_PARSE");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_LINEREAC_G120) >= 0)
                    {
                        ECL_SetValue("PMD_ABU782_001_000_G120", "T");
                        var sStatus = "mit";
                        break;
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SetValue("PMD_ABU782_001_000_G120", "F"); // ohne
                }
            }		
            else
            {
                ECL_SetValue("PMD_ABU782_001_000_G120", "F"); // ohne
            }
        }
        else
        {
            ECL_SetValue("PMD_ABU782_001_000_G120", "F"); // ohne
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Ausgangsdrossel																								alle
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // MLFB_KEY_G120	HMK_A_DROSSEL_G120	HMK_MLFB_AUSG_DROSSL_G120	HMK_VALUE_VALID_G120
        
        var sSQL = "SELECT * FROM VT_G120_M00294_" + sDB_Version + " " +
            "WHERE HMK_A_DROSSEL_G120 = 'T' AND " +
            "MLFB_KEY_G120 = '" + sMLFB_Key + "' AND " +
            "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " + 
            "HMK_VALUE_VALID_G120 = 'T';";
        var aResult_t = GetDBDataSetEXT(sSQL, "VT_G120_M00294_" + sDB_Version +"_PARSE");
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length > 0)
        {
            for (var i = 0; i < aResult.length; i++)
            {
                var sStatus_A_DROSSEL_Count = sECSI_MLFB_SEC.split(aResult[i].HMK_MLFB_AUSG_DROSSL_G120).length - 1;
                if (sStatus_A_DROSSEL_Count > 0)
                {
                    ECL_SetValue("HMK_A_DROSSEL_G120", "T");
                    ECL_SetValue("HMK_QTY_A_DROSSEL_G120", sStatus_A_DROSSEL_Count.toString());
                    ECL_SetValue("UI_HMK_A_DROSSEL_G120", sStatus_A_DROSSEL_Count.toString());
                    break;
                }
            }

            if (sStatus_A_DROSSEL_Count == 0)
            {
                ECL_SetValue("HMK_A_DROSSEL_G120", "F"); // ohne
            }
        }		
        else
        {
            ECL_SetValue("HMK_A_DROSSEL_G120", "F"); // ohne
        }
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Du/dt-Filter plus VPL				VT_G120_M00264_24213 												nicht S110
        // Du/dt-Filter compact plus VPL		 																	nur G120P n.n.
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // MLFB_KEY_G120	HMK_FILTER_VPL_G120	HMK_MLFB_FIL_VPL_G120
        if (HMK_PRODUKT_TRIG_G120 != "S110"){
            var sSQL = "SELECT * FROM VT_G120_M00264_" + sDB_Version + " WHERE HMK_FILTER_VPL_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00264_" + sDB_Version );
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_FIL_VPL_G120) >= 0)
                    {
                        ECL_SetValue("HMK_FILTER_VPL_G120", "T");
                        var sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SetValue("HMK_FILTER_VPL_G120", "F"); // ohne
                }
            }
        }else{
            ECL_SetValue("HMK_FILTER_VPL_G120", "F"); // ohne
        }
        // ++++++++++++++++++++++++++++
        // Du/dt-Filter compact plus VPL	nicht für G120 mit Baugrößen FSA bis FSG								nur G120P n.n.	
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Sinusfilter   - VT_G120_M00215_24213																		nur G120
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // kein Sinusfilter, wenn schon Ausgangsdrossel == T
        // MLFB_KEY_G120	HMK_SINUSFILTER_G120	HMK_MLFB_SINUSFILTER_G120	HMK_VALUE_VALID_G120
        
        
        if (sStatus_A_DROSSEL_Count == 0 && HMK_PRODUKT_TRIG_G120 == "G120")
        {
            var sSQL = "SELECT * FROM VT_G120_M00215_" + sDB_Version + " WHERE HMK_SINUSFILTER_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00215_" + sDB_Version );
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_SINUSFILTER_G120) >= 0)
                    {
                        ECL_SetValue("HMK_SINUSFILTER_G120", "T");
                        var sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SetValue("HMK_SINUSFILTER_G120", "F"); // ohne
                }
            }		
            else
            {
                ECL_SetValue("HMK_SINUSFILTER_G120", "F"); // ohne
            }
        }
        else if (sStatus_A_DROSSEL_Count > 0)
        {
            ECL_SetValue("HMK_SINUSFILTER_G120", "F"); // ohne
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Leistungsschalter																							alle
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // MLFB_KEY_G120	HMK_MLFB_POWERSWITCH_G120	PMD_ABR230_001_000_G120	HMK_VALUE_VALID_G120
        
        var sSQL = "SELECT * FROM VT_G120_M00192_" + sDB_Version + " WHERE PMD_ABR230_001_000_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00192_" + sDB_Version );
        if (aResult.length > 0)
        {
            var sStatus = "ohne";
            for (var i = 0; i < aResult.length; i++)
            {
                if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_POWERSWITCH_G120) >= 0)
                {
                    ECL_SetValue("PMD_ABR230_001_000_G120", "T");
                    var sStatus = "mit";
                }
            }
            if (sStatus == "ohne")
            {
                ECL_SetValue("PMD_ABR230_001_000_G120", "F"); // ohne
            }
        }		
        else
        {
            ECL_SetValue("PMD_ABR230_001_000_G120", "F"); // ohne
        }

        if (sPowerModul === "PM250" && (sBauform === "FSD" || sBauform === "FSE" || sBauform === "FSF" || sBauform === "FSG"))
        {
            ECL_DeactivateAttribute("UI_PMD_ABR230_001_000_G120");
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Art der Sicherung     VT_G120_M00222_24213																	alle
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // MLFB_KEY_G120	HMK_MLFB_FUSE_G120	HMK_FUSE_TYPE_G120	ANZ_SICHERUNG_G120	HMK_VALUE_VALID_G120
        
        var sSQL = "SELECT * FROM VT_G120_M00222_" + sDB_Version + " WHERE HMK_FUSE_TYPE_G120 = '00318' OR HMK_FUSE_TYPE_G120 = '00319' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00222_" + sDB_Version);
        if (aResult.length > 0)
        {
            var sStatus = "ohne";
            for (var i = 0; i < aResult.length; i++)
            {
                if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_FUSE_G120) >= 0)
                {
                    ECL_SetValue("HMK_FUSE_TYPE_G120", aResult[i].HMK_FUSE_TYPE_G120);
                    ECL_SetValue("ANZ_SICHERUNG_G120", aResult[i].ANZ_SICHERUNG_G120);
                    var sStatus = "mit";
                }
            }
            if (sStatus == "ohne")
            {
                ECL_SetValue("HMK_FUSE_TYPE_G120", "00320"); // ohne
                ECL_SetValue("ANZ_SICHERUNG_G120", 0);
            }
        }		
        else
        {
            ECL_SetValue("HMK_FUSE_TYPE_G120", "00320"); // ohne
            ECL_SetValue("ANZ_SICHERUNG_G120", 0);
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // CB_ADVANCED_SAFETY_G120		Advanced Safty													nur S120
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        /* Abbildung über KAG A01 analog zu F01
        if (HMK_PRODUKT_TRIG_G120 == "S120"){
            
            if (sECSI_MLFB_SEC.indexOf("6SL30740AA200AA0") >= 0){
                ECL_SelectValue("CB_ADVANCED_SAFETY_G120", "T");
            }else{
                ECL_DeselectAttribute("CB_ADVANCED_SAFETY_G120"); // ohne
            }
        }else{
            ECL_DeselectAttribute("CB_ADVANCED_SAFETY_G120"); // ohne
        }*/
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        
        
        
        
        setCheckBoxAttributes(HMK_PRODUKT_TRIG_G120);
        //ECL_SetValue("ECSI_MLFB_SEC", "");		
    }
    // ##########################################################################################################################
    // ## ENDE SEK-MLFBs ########################################################################################################
    // ##########################################################################################################################
    
    // Übertragung der UI-Attributdaten in Original-Attribute:
/*	if(sCurrentAttribute != "@INIT@" && sCurrentAttribute != "ECSI_MLFB"){
        getCheckBoxAttributes(sCurrentAttribute, HMK_PRODUKT_TRIG_G120);
    }
*/	
    
    var sCU = ECL_GetValue("HMK_TYPE_CU_G120") || "";
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Safety Functions aus SIZER-Übergabe analysieren	
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //sECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions") || "";
    
    /*
    Control Unit	Basic Safety Funktionen		Extended Safety Funktionen
                    0		1		11			2		3		4
                    STO		SS1		SBC 1)		SLS		SDI		SSM
    CU230P-2		–		-		–			–		–		–
    CU240E-2		✓		–		–			–		–		–
    CU240E-2 F		✓ 		✓		–			✓		✓		✓ 2)
    CU250S-2		✓		✓		✓			✓ 3)	✓ 3)	✓ 3)
    _______________________________________________________________________________________________________________
    NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU 
    NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU 
    Context		0		1		5		6		11		12		2		4		3		7		9		8		10
                STO		SS1		SS2		SOS		SBC 1)	SBT		SLS		SSM		SDI		SLA		SLP		SP		SCA	
    ---------------------------------------------------------------------------------------------------------------
    CU230P-2	–		-		–		–		–		–		–		–		–		–		–		–		–
    CU240E-2	✓ 		-		–		–		–		–		–		–		–		–		–		–		–
    CU240E-2 F	✓ 		✓ 		–		–		–		–		✓ 		✓ 2)	✓ 		–		–		–		–
    CU250S-2	✓ 		✓ 		–		–		✓ 		–		✓ 3)	✓ 3)	✓ 3)	–		–		–		–
    _______________________________________________________________________________________________________________
    S110
    CU305		✓ 		✓ 		✓ 3)	✓ 3)	✓ 		–		✓ 3)	✓ 3)	✓ 3)	–		–		–		–
    _______________________________________________________________________________________________________________
    S120
    CU310-2		✓ 		✓ 		✓ 3)	✓ 3)	✓ 		✓ 3)	✓ 3)	✓ 3)	✓ 3)	✓ 3)	✓ 4)	✓ 4)	✓ 4)
    CU320-2		✓ 		✓ 		✓ 3)	✓ 3)	✓ 		✓ 3)	✓ 3)	✓ 3)	✓ 3)	✓ 3)	✓ 4)	✓ 4)	✓ 4)
    _______________________________________________________________________________________________________________
    NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU 
    NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU NEU 

    1) Für die Funktion SBC ist ein Safe Brake Relay erforderlich.
    2) SSM nur möglich für Control Units CU240E-2 DP-F / CU240E-2 PN-F mit PROFIsafe.
    3) Mit Lizenz Extended Safety Functions.
    4) Mit Safety Advanced Lizenz.
    _______________________________________________________________________________________________________________
    UI_HMK_F01_G120			F01 Lizenz Ext. Functions Safety (SLS, SSM, SDI)
    UI_HMK_F01_S110_G120	F01 Lizenz Ext. Functions Safety (SLS, SSM, SDI, SS2, SOS)
    UI_HMK_F01_S120_G120	F01 Lizenz Ext. Functions Safety (SLS, SSM, SDI, SS2, SOS, SLA, SBT (SLP, SP, SCA))
    
    
    Auswertung über VT VT_G120_M00268_24213
    
    ControlUnit			Kommunikation			STO					SS1					SLS					SDI					SSM					SBC	
    HMK_TYPE_CU_G120	PMD_ABU804_001_000_G120	HMK_SAFETY_STO_G120	HMK_SAFETY_SS1_G120	HMK_SAFETY_SLS_G120	HMK_SAFETY_SDI_G120	HMK_SAFETY_SSM_G120	HMK_SAFETY_SBC_G120	
    
    Fehlersichere DI	Anzahl Digitaleingänge		Anzahl Analogeingänge		Anzahl Digitalausgänge		Anzahl Analogausgänge		Digital Ein- / Ausgänge
    HMK_F_DI_G120		TAK_AAN259_001_000_G120		PMD_AAA274_001_000_G120		TAK_AAM785_001_000_G120		PMD_AAA310_001_000_G120		HMK_DI_DO_G120	
    
    Geberauswertung				Positionierfunktionalität	
    PMD_ABU278_001_000_G120		HMK_EPOS_G120				HMK_VALUE_VALID_G120
    */
    
    ECL_EnableAttribute("HMK_SAFEBRAKERELAY_G120");
    ECL_EnableAttribute("HMK_F01_G120");
    
    if ( (sECSI_CX_SafetyFunctions !== "" && sECSI_CX_SafetyFunctions !== undefined) && (sCurrentAttribute == "ECSI_MLFB")
    ) {
        // in Array aufsplitten
        aSafetyFunctionsSizer = sECSI_CX_SafetyFunctions.split(";");
        // sortieren
        aSafetyFunctionsSizer = aSafetyFunctionsSizer.sort();
        var sFehlerSafety = "keine";
        
        
        
        // SafetyFunctions rücksetzen
        ECL_SelectValue("HMK_SAFETY_STO_G120", "F");
        ECL_SelectValue("HMK_SAFETY_SS1_G120", "F");
        ECL_SelectValue("HMK_SAFETY_SLS_G120", "F");
        ECL_SelectValue("HMK_SAFETY_SDI_G120", "F");
        ECL_SelectValue("HMK_SAFETY_SSM_G120", "F");
        ECL_SelectValue("HMK_SAFETY_SBC_G120", "F");
        
        for (var i = 0; i < aSafetyFunctionsSizer.length; i++)
        {
            iSafetyFunction = parseInt(aSafetyFunctionsSizer[i]);
            
            var sFehler_SafetyReq = "OK";
            
            if (sCU.length == 0)
            {
                switch (iSafetyFunction)
                {
                    case 0: //STO
                        if ( ECL_ValueEnabled("HMK_SAFETY_STO_G120", "T")) {
                            ECL_SelectValue("HMK_SAFETY_STO_G120", "T");
                        }
                        else{
                            sFehler_SafetyReq = "ERROR";
                        }
                        break;
                    
                    case 13: //SS1
                    case 14:
                        if ( ECL_ValueEnabled("HMK_SAFETY_SS1_G120", "T")) {
                            ECL_SelectValue("HMK_SAFETY_SS1_G120", "T");
                        }
                        else{
                            sFehler_SafetyReq = "ERROR";
                        }
                        break;
                        
                    case 11: //SBC
                        if ( ECL_ValueEnabled("HMK_SAFETY_SBC_G120", "T")) {
                            ECL_SelectValue("HMK_SAFETY_SBC_G120", "T");
                        }
                        else{
                            sFehler_SafetyReq = "ERROR";
                        }
                        break;
                        
                    //Extended Safety
                    
                    case 2: //SLS
                        if ( ECL_ValueEnabled("HMK_SAFETY_SLS_G120", "T")) {
                            ECL_SelectValue("HMK_SAFETY_SLS_G120", "T");
                        }
                        else{
                            sFehler_SafetyReq = "ERROR";
                        }
                        break;
                        
                    case 3: //SDI
                        if ( ECL_ValueEnabled("HMK_SAFETY_SDI_G120", "T")) {
                            ECL_SelectValue("HMK_SAFETY_SDI_G120", "T");
                        }
                        else{
                            sFehler_SafetyReq = "ERROR";
                        }
                        break;
                        
                    case 4: //SSM
                        if ( ECL_ValueEnabled("HMK_SAFETY_SSM_G120", "T")) {
                            ECL_SelectValue("HMK_SAFETY_SSM_G120", "T");
                        }
                        else{
                            sFehler_SafetyReq = "ERROR";
                        }
                        break;
                    
                    
                    /*	default:
                        sFehlerSafety = "Fehler";
                        */
                }
            }
            else // CU vorbelegt
            {
                // SafetyFunctions gegen Unterstützung prüfen			// todo nur G120 ?
                switch (iSafetyFunction)
                {
                    case 0: //STO
                        var sSQL_Safety = "SELECT * FROM VT_G120_M00268_" + sDB_Version + " WHERE HMK_TYPE_CU_G120 = '" + sCU  + "' AND HMK_SAFETY_STO_G120 = 'T';";
                        var aResult_Safety = GetDBDataSetEXT(sSQL_Safety);
                        
                        if (aResult_Safety.length > 0)
                        {
                            if ( ECL_ValueEnabled("HMK_SAFETY_STO_G120", "T")) {
                                ECL_SelectValue("HMK_SAFETY_STO_G120", "T");
                            }
                            else{
                                sFehler_SafetyReq = "ERROR";
                            }
                        }
                        else
                        {
                            sFehlerSafety = "Fehler_CU";
                        }
                        break;
                    
                    case 13: //SS1
                    case 14:
                        var sSQL_Safety = "SELECT * FROM VT_G120_M00268_" + sDB_Version + " WHERE HMK_TYPE_CU_G120 = '" + sCU  + "' AND HMK_SAFETY_SS1_G120 = 'T';";
                        var aResult_Safety = GetDBDataSetEXT(sSQL_Safety);
                        
                        if (aResult_Safety.length > 0)
                        {
                            if ( ECL_ValueEnabled("HMK_SAFETY_SS1_G120", "T")) {
                                ECL_SelectValue("HMK_SAFETY_SS1_G120", "T");
                            }
                            else{
                                sFehler_SafetyReq = "ERROR";
                            }
                        }
                        else
                        {
                            sFehlerSafety = "Fehler_CU";
                        }
                        break;
                        
                    case 11: //SBC
                        var sSQL_Safety = "SELECT * FROM VT_G120_M00268_" + sDB_Version + " WHERE HMK_TYPE_CU_G120 = '" + sCU  + "' AND HMK_SAFETY_SBC_G120 = 'T';";
                        var aResult_Safety = GetDBDataSetEXT(sSQL_Safety);
                        
                        if (aResult_Safety.length > 0)
                        {
                            if ( ECL_ValueEnabled("HMK_SAFETY_SBC_G120", "T")) {
                                ECL_SelectValue("HMK_SAFETY_SBC_G120", "T");
                            }
                            else{
                                sFehler_SafetyReq = "ERROR";
                            }
                        }
                        else
                        {
                            sFehlerSafety = "Fehler_CU";
                        }
                        break;
                        
                    //Extended Safety
                    
                    case 2: //SLS
                        var sSQL_Safety = "SELECT * FROM VT_G120_M00268_" + sDB_Version + " WHERE HMK_TYPE_CU_G120 = '" + sCU  + "' AND HMK_SAFETY_SLS_G120 = 'T';";
                        var aResult_Safety = GetDBDataSetEXT(sSQL_Safety);
                        
                        if (aResult_Safety.length > 0)
                        {
                            if ( ECL_ValueEnabled("HMK_SAFETY_SLS_G120", "T")) {
                                ECL_SelectValue("HMK_SAFETY_SLS_G120", "T");
                            }
                            else{
                                sFehler_SafetyReq = "ERROR";
                            }
                        }
                        else
                        {
                            sFehlerSafety = "Fehler_CU";
                        }
                        break;
                    
                    case 3: //SDI
                        var sSQL_Safety = "SELECT * FROM VT_G120_M00268_" + sDB_Version + " WHERE HMK_TYPE_CU_G120 = '" + sCU  + "' AND HMK_SAFETY_SDI_G120 = 'T';";
                        var aResult_Safety = GetDBDataSetEXT(sSQL_Safety);
                        
                        if (aResult_Safety.length > 0)
                        {
                            if ( ECL_ValueEnabled("HMK_SAFETY_SDI_G120", "T")) {
                                ECL_SelectValue("HMK_SAFETY_SDI_G120", "T");
                            }
                            else{
                                sFehler_SafetyReq = "ERROR";
                            }
                        }
                        else
                        {
                            sFehlerSafety = "Fehler_CU";
                        }
                        break;
                    
                    case 4: //SSM
                        var sSQL_Safety = "SELECT * FROM VT_G120_M00268_" + sDB_Version + " WHERE HMK_TYPE_CU_G120 = '" + sCU  + "' AND HMK_SAFETY_SSM_G120 = 'T';";
                        var aResult_Safety = GetDBDataSetEXT(sSQL_Safety);
                        
                        if (aResult_Safety.length > 0)
                        {
                            if ( ECL_ValueEnabled("HMK_SAFETY_SSM_G120", "T")) {
                                ECL_SelectValue("HMK_SAFETY_SSM_G120", "T");
                            }
                            else{
                                sFehler_SafetyReq = "ERROR";
                            }
                        }
                        else
                        {
                            sFehlerSafety = "Fehler_CU";
                        }
                        break;
                    /*
                    default:
                        sFehlerSafety = "Fehler";
                    */
                }
            }
        }
            
        if (sFehlerSafety == "Fehler") 
        {
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SAFETY_G120") + " "; 
        }
        if (sFehlerSafety == "Fehler_CU") 
        {
            // Fehler:
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SAFETY_CU_G120") + " "; 
        }
        if (sFehler_SafetyReq == "ERROR") 
        {
            // Fehler:
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SAFETYFUNCTIONS_CHANGED_G120") + " "; 
        }
        /*
        Context		0		1		5		6		11		12		2		4		3		7		9		8		10
                    STO		SS1		SS2		SOS		SBC 1)	SBT		SLS		SSM		SDI		SLA		SLP		SP		SCA	
        ---------------------------------------------------------------------------------------------------------------
        CU230P-2	–		-		–		–		–		–		–		–		–		–		–		–		–
        CU240E-2	✓ 		-		–		–		–		–		–		–		–		–		–		–		–
        CU240E-2 F	✓ 		✓ 		–		–		–		–		✓ 		✓ 2)	✓ 		–		–		–		–
        CU250S-2	✓ 		✓ 		–		–		✓ 		–		✓ 3)	✓ 3)	✓ 3)	–		–		–		–
        _______________________________________________________________________________________________________________
        S110
        CU305		✓ 		✓ 		✓ 3)	✓ 3)	✓ 		–		✓ 3)	✓ 3)	✓ 3)	–		–		–		–
        _______________________________________________________________________________________________________________
        S120
        CU310-2		✓ 		✓ 		✓ 3)	✓ 3)	✓ 		✓ 3)	✓ 3)	✓ 3)	✓ 3)	✓ 3)	✓ 4)	✓ 4)	✓ 4)
        CU320-2		✓ 		✓ 		✓ 3)	✓ 3)	✓ 		✓ 3)	✓ 3)	✓ 3)	✓ 3)	✓ 3)	✓ 4)	✓ 4)	✓ 4)
        _______________________________________________________________________________________________________________
        1) Für die Funktion SBC ist ein Safe Brake Relay erforderlich.
        2) SSM nur möglich für Control Units CU240E-2 DP-F / CU240E-2 PN-F mit PROFIsafe.
        3) Mit Lizenz Extended Safety Functions.
        4) Mit Safety Advanced Lizenz.
        */
        
        
        // Advanced Safety
        
        //CB_ADVANCED_SAFETY_G120
    } 
    
    // gilt für alle Produkte
    var bSafeBrakeRelayMandatory = false;
    if (sECSI_CX_SafetyFunctions.indexOf("11") > -1){
        // SafeBarkeRelay setzen
        if (ECL_ValueEnabled("HMK_SAFEBRAKERELAY_G120", "T")){
            ECL_DeactivateValue("HMK_SAFEBRAKERELAY_G120", "F");
            ECL_SetValue("HMK_SAFEBRAKERELAY_G120", "T");
            bSafeBrakeRelayMandatory = true;
        }else{
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SAFE_BRAKE_RELAY_SBC_G120") + " "; 
        }
    }
    ECL_ActivateAllAttributeValues("HMK_F01_G120");
    // CU 250S-2, Extended Safety setzen, falls erforderlich
    var bF01_Mandatory = false;
    var bAdvancedSafety_Mandatory = false;
    var aSafetyFunctionsSizer = sECSI_CX_SafetyFunctions.split(";");
    if ((sCU == "00320" || sCU == "00321" || sCU == "00322" || sCU == "00323") &&		// G120
        (aSafetyFunctionsSizer.indexOf("2") > -1 || 
        aSafetyFunctionsSizer.indexOf("3") > -1 || 
        aSafetyFunctionsSizer.indexOf("4") > -1 ||
        aSafetyFunctionsSizer.indexOf("14") > -1)){
        // Lizenz Extended Safety setzen
        ECL_ActivateValue("HMK_F01_G120", "F01");
        ECL_DeactivateValue("HMK_F01_G120", "NON");
        ECL_SetValue("HMK_F01_G120", "F01");
        bF01_Mandatory = true;
    }else if ((sCU == "00324" || sCU == "00325") &&		// S110
        (aSafetyFunctionsSizer.indexOf("2") > -1 || 
         aSafetyFunctionsSizer.indexOf("3") > -1 || 
         aSafetyFunctionsSizer.indexOf("4") > -1 || 
         aSafetyFunctionsSizer.indexOf("5") > -1 || 
         aSafetyFunctionsSizer.indexOf("6") > -1 ||
         aSafetyFunctionsSizer.indexOf("14") > -1)){
        // Lizenz Extended Safety setzen
        ECL_ActivateValue("HMK_F01_G120", "F01");
        ECL_DeactivateValue("HMK_F01_G120", "NON");
        ECL_SetValue("HMK_F01_G120", "F01");
        bF01_Mandatory = true;
    }else if ((sCU == "00994" || sCU == "00995") &&		// S120
        (aSafetyFunctionsSizer.indexOf("2") > -1 || 
         aSafetyFunctionsSizer.indexOf("3") > -1 || 
         aSafetyFunctionsSizer.indexOf("4") > -1 || 
         aSafetyFunctionsSizer.indexOf("5") > -1 || 
         aSafetyFunctionsSizer.indexOf("6") > -1 || 
         aSafetyFunctionsSizer.indexOf("7") > -1 || 
         aSafetyFunctionsSizer.indexOf("12") > -1 ||
         aSafetyFunctionsSizer.indexOf("14") > -1)){
        // Lizenz Extended Safety setzen
        ECL_ActivateValue("HMK_F01_G120", "F01");
        ECL_DeactivateValue("HMK_F01_G120", "NON");
        ECL_SetValue("HMK_F01_G120", "F01");
        bF01_Mandatory = true;
    }else{
        ECL_ActivateValue("HMK_F01_G120", "NON");
        ExecSetStandardifValueEmpty("HMK_F01_G120", "NON");
        //ECL_SetValue("HMK_F01_G120", "NON");
        
    }
    if ((sCU == "00994" || sCU == "00995") &&		// S120
        (aSafetyFunctionsSizer.indexOf("8") > -1 || 
         aSafetyFunctionsSizer.indexOf("9") > -1 || 
         aSafetyFunctionsSizer.indexOf("10") > -1 )){
        // Lizenz Advanced Safety setzen
        ECL_SelectValue("CB_ADVANCED_SAFETY_G120", "T");
        ECL_SetValue("HMK_F01_G120", "F01");
        ECL_DeactivateValue("HMK_F01_G120", "NON");
        ECL_DeactivateValue("HMK_U01_G120", "U01");
        ECL_DeactivateValue("HMK_J01_G120", "J01");
        bAdvancedSafety_Mandatory = true;
        // todo zu klären: Wenn gewählt, dann darf keine U01 oder J01 und umgekehrt
    }
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Rückspeisung aus SIZER-Übergabe analysieren	
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //sECSI_CX_RegenerativeBraking = ECL_GetValue("ECSI_CX_RegenerativeBraking") || "";
    if ( (sECSI_CX_RegenerativeBraking !== "" && sECSI_CX_RegenerativeBraking !== undefined) && (sCurrentAttribute == "ECSI_MLFB") 
    ) {
        // Übergabe 0 oder 1
        var iRegenerativeBraking = parseInt(sECSI_CX_RegenerativeBraking);
        
        if (iRegenerativeBraking == 0) {
            if (ECL_ValueEnabled("HMK_RUECKSP_UEBERGAB_G120", "F")){
                ECL_SelectValue("HMK_RUECKSP_UEBERGAB_G120", "F");
                ECL_SelectValue("HMK_BRAKEBEHAVIOUR_G120", "00002"); 
            }
            else{
                // Vorgabe kann nicht erfüllt werden:
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___REGENERATIVEBRAKING_CHANGED_G120") + " "; 
                //	return;
            }
        }
        else if (iRegenerativeBraking == 1) {
            if (ECL_ValueEnabled("HMK_RUECKSP_UEBERGAB_G120", "T")){
                ECL_SelectValue("HMK_RUECKSP_UEBERGAB_G120", "T");
                ECL_SelectValue("HMK_BRAKEBEHAVIOUR_G120", "00001");
            }
            else{
                // Vorgabe kann nicht erfüllt werden:
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___REGENERATIVEBRAKING_CHANGED_G120") + " "; 
                //	return;
            }
        }
        else{
            // Fehler: 
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___REGENERATIVEBRAKING_G120") + " "; // ". ";
        }
    }
    else
    {
        /*
            Default Bremswiderstand	12	Proc	1	* Defaultsteuerung zum Bremswiderstand RM 7558
            Default Bremswiderstand	12	Proc	2	* Wenn PM definiert und Generatorischer Betrieb = optionaler Bremswiders
            Default Bremswiderstand	12	Proc	3	* dann belege Bremswiderstand mit T vor, ansonsten mit F
        */
        var sMLFB_Key = ECL_GetValue("MLFB_KEY_G120") || "";
        var sBrakebehaviour = ECL_GetValue("HMK_BRAKEBEHAVIOUR_G120") || ""; 
        var sECSI_MLFB_SEC = GetMlfbSec() || "";
        
        // Default nur setzen, wenn nicht durch Benutzer festgelegt:
        if (ECSI_IS_START_CONFIGURATION == 1 && !(aUserChangedAttributes.indexOf("UI_HMK_BRAKERESISTOR_G120") > -1) && (sECSI_MLFB_SEC == ""))
        {
            if ( (sMLFB_Key !== "") && (sBrakebehaviour == "00002") 
            ) {
                if (ECL_ValueEnabled("HMK_BRAKERESISTOR_G120", "T"))
                {
                    ECL_SelectValue("HMK_BRAKERESISTOR_G120", "T");
                }
                else
                {
                    if (sStatusBR == "ohne")
                        ECL_SelectValue("HMK_BRAKERESISTOR_G120", "F");
                }
            }
            else
            {
                if (sStatusBR == "ohne")
                    ECL_SelectValue("HMK_BRAKERESISTOR_G120", "F");
            }
        }
    }
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // FieldbusInterface aus SIZER-Übergabe analysieren	
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Kommunikationsprotokolle:
        // 00002	PROFINET / EtherNet/IP	0
        // 00001	PROFIBUS DP				1
        // 00003	CANopen					-	
        // 00004	USS	/ Modbus RTU		3
        // 00011	Siemens FLN P1			-	<--- deaktiviert, da bei Änderung keine MLFB-Änderung
        // 00012	Drive CLiQ				-
        // ersetzt 00005	Modbus RTU		3 Zusammenfassung mit 00004
        var bFieldbusPreference = false;
        var iFieldbusInterface  = -1;
        ECL_EnableAttribute("PMD_ABU804_001_000_G120");
        
        if ( (sFieldbusInterface !== "") && (sFieldbusInterface !== undefined) && (sCurrentAttribute == "ECSI_MLFB")
        ) {
            iFieldbusInterface = parseInt(sFieldbusInterface);
            
            if (iFieldbusInterface > -1) {
                bFieldbusPreference = true;
                ECL_DisableAttribute("PMD_ABU804_001_000_G120");
            }
            if (iFieldbusInterface < 0 || iFieldbusInterface == 2 || iFieldbusInterface > 3)
            {
                // Fehler: G120 kann kein AS-i oder weitere Bussysteme
                ECL_SelectValue("ECSI_STATUS", "E");
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_FIELDBUS_G120") + " "; //"Es wurden ein Feldbus vom Sizer übergeben, der vom G120 nicht unterstützt wird. ";
                ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                return;
            }
            
            var sFehlerBus = "OK";
            
            // wenn CU belegt, dann gegenprüfen
            
            if (ECL_AtLeastOneSelected("HMK_TYPE_CU_G120"))
            {
                var sBus = ECL_GetValue("PMD_ABU804_001_000_G120") || "";
                
                // if (  (iFieldbusInterface == 0 && sBus !== "00002") ||
                //     (iFieldbusInterface == 1 && sBus !== "00001") ||
                //     (iFieldbusInterface == 3 && sBus !== "00004") //|| (sBus !== "00005")) )
                // ) {
                //     // geänderter Fieldbus --> Fehler
                //     sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FIELDBUS_CHANGED_G120C") + " "; 
                //     // Übergabestatus setzen
                //     ECL_SelectValue("ECSI_STATUS", "E");
                //     ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                //         return;
                // }
            }
            
            switch(iFieldbusInterface)
            {
                case 0:
                    // 0 feste Auswahl von Profinet
                    if (ECL_ValueEnabled("PMD_ABU804_001_000_G120", "00002")){
                        ECL_SelectValue("PMD_ABU804_001_000_G120", "00002");
                    }
                    else{
                        sFehlerBus = "ERROR";
                    }
                    break;
                
                case 1:
                    // 1 feste Auswahl von Profibus
                    if (ECL_ValueEnabled("PMD_ABU804_001_000_G120", "00001")){
                        ECL_SelectValue("PMD_ABU804_001_000_G120", "00001");
                    }
                    else{
                        sFehlerBus = "ERROR";
                    }
                    break;
                
                case 3:
                    // 3: Feste Auswahl von USS/Modbus RTU (zusammengefasst)
                    if (ECL_ValueEnabled("PMD_ABU804_001_000_G120", "00004")){
                        ECL_SelectValue("PMD_ABU804_001_000_G120", "00004");
                    }
                    else{
                        sFehlerBus = "ERROR";
                    }
                    
                    break;
            }
            if (sFehlerBus == "ERROR"){
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FIELDBUS_CHANGED_G120") + " "; 
                //	return;
            }
        }
        else // keine Vorgabe aus Sizer
        {
            // Eingabe durch Benutzer möglich, jedoch Default Profinet
            ExecSetStandardifValueEmpty("PMD_ABU804_001_000_G120", "00002");
            
        }
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // MotionControlRequirements aus SIZER-Übergabe analysieren	
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        /*
            Null	Any (nothing specific set by the user)
            0	Speed-controlled
            1	Dive-based positioning via easy positioner (EPOS)
            2	PLC-based positioning via SIMATIC technology object						<-- nicht unterstützt!
            3	Drive-based motion control via SINAMICS TEC (technology extension)		<-- nicht unterstützt!
            4	PLC-based motion control via SIMATIC technology object					<-- nicht unterstützt!
            5	Numerical control via SINUMERIK											<-- nicht unterstützt!
        */
        
        if ( (sMotionControlReq !== "" && sMotionControlReq !== undefined) && (sCurrentAttribute == "ECSI_MLFB")
        ) {
            var iMotionControlReq = parseInt(sMotionControlReq);
            
            if (HMK_PRODUKT_TRIG_G120 === "G120" && (iMotionControlReq < 0 || iMotionControlReq > 2) ) 
            {
                // Fehler: G120 kann nur 0, 1 und 2
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_MOTIONCONTROLREQ_G120") + " "; //"Es wurden eine MotionControlRequirement vom Sizer übergeben, wlche vom G120 nicht unterstützt wird. ";
                //	return;
            }/*
            else if (HMK_PRODUKT_TRIG_G120 === "S110" && (iMotionControlReq < 0 || iMotionControlReq > 3) ) 
            {
                // Fehler: S110 kann 0, 1, 2
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_MOTIONCONTROLREQ_G120") + " "; //"Es wurden eine MotionControlRequirement vom Sizer übergeben, wlche vom G120 nicht unterstützt wird. ";
                //	return;
            }*/
            
            
            /*else if (iMotionControlReq == 1 && HMK_PRODUKT_TRIG_G120 != "G120"){
                // Fehler: nur G120 kann EPOS)
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___EPOS_S110_S120_G120") + " "; 
            }*/
            
            var sFehler_MC = "OK";
            
            // Wert aus ECSI_CX_MotionControlRequirements setzen
            switch (iMotionControlReq)
            {
                case 0:
                    // 0 kein EPOS?
                    if (ECL_ValueEnabled("HMK_EPOS_G120", "F") ){
                        ECL_SelectValue("HMK_EPOS_G120", "F");
                    }
                    else{
                        sFehler_MC = "ERROR";
                    }
                    break;
                
                case 1:
                    // 1 EPOS
                    // Prüfen, ob auch CU == 250D -F ist
                    if (ECL_ValueEnabled("HMK_EPOS_G120", "T") && HMK_PRODUKT_TRIG_G120 == "G120" ){
                        if (sCU == "00320" || sCU == "00321" || sCU == "00322" || sCU == "00323")	{
                            ECL_SelectValue("HMK_EPOS_G120", "T");
                            ECL_SelectValue("HMK_E01_G120", "E01");
                            ECL_DeactivateValue("HMK_E01_G120", "NON");
                        }
                        else{
                            //Fehler:
                            sECSI_STATUS = "E"; 
                            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MOTIONCONTROLREQ_CU_G120") + " ";
                            //	return;
                        }
                    }
                    else{
                        sFehler_MC = "ERROR";
                    }
                    break;
            }
            if (sFehler_MC == "ERROR" && HMK_PRODUKT_TRIG_G120 == "G120"){
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MOTIONCONTROLREQ_CHANGED_G120") + " "; 
                //	return;
            }
        }
        else{
            // keine Vorgabe
            ECL_SelectValue("HMK_EPOS_G120", "F");
        }
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
    // ## ENDE PARSER #################################################################################################################################################################
    // ## ENDE PARSER #################################################################################################################################################################
    // ## ENDE PARSER #################################################################################################################################################################
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Übertragung der UI-Attributdaten in Original-Attribute:
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //if(sCurrentAttribute != "@INIT@" && sCurrentAttribute != "ECSI_MLFB"){
        getCheckBoxAttributes(sCurrentAttribute, HMK_PRODUKT_TRIG_G120);
    //}
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    if (sCurrentAttribute == "UI_PMD_AAD146_001_000_G120"){
        var PMD_AAD146_001_000_G120 = ECL_GetValue("PMD_AAD146_001_000_G120");
        //Wenn sich der Interne Filter ändert, änder sich die MLFB und der MLFB_Key
        var sSQL = "SELECT * FROM VT_G120_M00272_" + sDB_Version + " WHERE " +
                    "MLFB06_G120 = " 	+  sECSI_MLFB.charAt(5) + " AND " +
                    "MLFB07_G120 = " 	+  sECSI_MLFB.charAt(6) + " AND " +
                    "MLFB08_G120 = " 	+  sECSI_MLFB.charAt(7) + " AND " +
                    "MLFB09_G120 = '"	+  sECSI_MLFB.charAt(8) + "' AND " +
                    "MLFB10_G120 = '"	+  sECSI_MLFB.charAt(9) + "' AND " +
                    "MLFB11_G120 = " 	+  sECSI_MLFB.charAt(10) + " AND " +
                    "MLFB12_G120 = " 	+  sECSI_MLFB.charAt(11) + " AND " + 
                    "MLFB13_G120 = " 	+  sECSI_MLFB.charAt(12) + " AND " + 
                    "MLFB15_G120 = '" 	+  sECSI_MLFB.charAt(14) + "' AND " +
                    "MLFB16_G120 = " 	+  sECSI_MLFB.charAt(15) + " AND " +
                    "PMD_AAD146_001_000_G120 = '" 	+  PMD_AAD146_001_000_G120 + "' AND " +
                    "HMK_VALUE_VALID_G120 = 'T';"; 
        
        var aResult = GetDBDataSetEXT(sSQL);
        
        if (aResult.length > 0)
        {	
            var sMLFB_Key = aResult[0].MLFB_KEY_G120;
            ECL_SetValue("MLFB_KEY_G120", sMLFB_Key);
            var sMLFB14 = aResult[0].MLFB14_G120;
            sECSI_MLFB = replaceAt(sECSI_MLFB, 13, sMLFB14);
            ECL_SetValue("MLFB14_G120", sMLFB14);
            ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
        }else{
            //Fehlersicher
            var sErrorFilter = "";
        }
        
    }else{	
        var sMLFB14 = ECL_GetValue("MLFB14_G120");
        var sMLFB_Key = ECL_GetValue("MLFB_KEY_G120");
    }
    
    ECL_SetValue("ECSI_MLFB_SEC", "");
    
    // SafetyFunctions 
    var bSafetySLS = false;
    var bSafetySSM = false;
    var bSafetySDI = false;
    
    if (sECSI_CX_SafetyFunctions !== "" && sECSI_CX_SafetyFunctions !== undefined)
    {
        // in Array aufsplitten
        aSafetyFunctionsSizer = sECSI_CX_SafetyFunctions.split(";");
        // sortieren
        aSafetyFunctionsSizer = aSafetyFunctionsSizer.sort();
        
        for (var i = 0; i < aSafetyFunctionsSizer.length; i++)
        {
            iSafetyFunction = parseInt(aSafetyFunctionsSizer[i]);
            
            switch (iSafetyFunction)
            {
                //Extended Safety
                case 2: //SLS
                    bSafetySLS = true;
                    break;
                case 3: //SDI
                    bSafetySDI = true;
                    break;
                case 4: //SSM
                    bSafetySSM = true;
                    break;
            }
        }
    }
    
    var motorTechnology = ECL_GetValue("ECSI_CX_MotorTechnology");
    if(motorTechnology == "0" || motorTechnology == "2")
	{
		ECL_SelectValue("VPM_MODULE_S110_S120", "VPM_NONE_S110_S120");
		ECL_DeactivateAttribute("VPM_MODULE_S110_S120");
        ECL_DeactivateAllAttributeValues("VPM_MODULE_S110_S120");
		ECL_ActivateAttribute("UI_HMK_A_DROSSEL_G120");
		ECL_EnableAttribute("UI_HMK_A_DROSSEL_G120");
		ECL_ActivateAttribute("HMK_A_DROSSEL_G120");
        ECL_ActivateAttribute("HMK_QTY_A_DROSSEL_G120");
	}
	if(motorTechnology == "1" || motorTechnology == "2")
	{
		ECL_DeactivateAttribute("UI_HMK_A_DROSSEL_G120");
		ECL_DeactivateAttribute("HMK_A_DROSSEL_G120");
        ECL_DeactivateAttribute("HMK_QTY_A_DROSSEL_G120");
		ECL_SelectValue("UI_HMK_A_DROSSEL_G120", "WITHOUT");
		
		ECL_DeactivateAttribute("UI_HMK_SINUSFILTER_G120");
		ECL_DeactivateAttribute("HMK_SINUSFILTER_G120");
		ECL_DeselectValue("UI_HMK_SINUSFILTER_G120", "T");
		
		ECL_DeactivateAttribute("UI_HMK_FILTER_VPL_G120");
		ECL_DeactivateAttribute("HMK_FILTER_VPL_G120");
		ECL_DeselectValue("UI_HMK_FILTER_VPL_G120", "T");
	}
    

    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Filter Steuerung
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    var sMLFB_FilterVorgabe = sECSI_MLFB.substr(14, 2);
    if (sMLFB_FilterVorgabe == "A1")
    {
        // Gefiltert vorgegeben, (AA1), keine Änderung zulässig!
        ECL_DeactivateValue("PMD_AAD146_001_000_G120", "00007");
        ECL_DisableAttribute("PMD_AAD146_001_000_G120");
        
        // VT_G120_M00106
        // PMD_AAD146_001_000_G120	HMK_NETZFILTER_EXT_G120	HMK_VALUE_VALID_G120
        simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00106" + sDB_Suffix,{
            inferenceType: VariantTables.Inference.RestrictNone,
            operators: {
                "HMK_NETZFILTER_EXT_G120": {
                inferenceType: VariantTables.Inference.RestrictAll
                }
            }
        });
    }
    else
    {
        // Prüfen, ob in der VT208 ein Pendant mit U oder A vorliegt, dann kann Filter gewechselt werden.
        // Wenn nicht, darf der Filter nicht vom User geändert werden.
        
        // bestimmen, ob U oder C (FSG) bzw. ob fix Filter A
        var sSQL = "SELECT * FROM VT_G120_M00272_" + sDB_Version + " WHERE " +
                    "MLFB06_G120 = " 	+  sECSI_MLFB.charAt(5) + " AND " +
                    "MLFB07_G120 = " 	+  sECSI_MLFB.charAt(6) + " AND " +
                    "MLFB08_G120 = " 	+  sECSI_MLFB.charAt(7) + " AND " +
                    "MLFB09_G120 = '"	+  sECSI_MLFB.charAt(8) + "' AND " +
                    "MLFB10_G120 = '"	+  sECSI_MLFB.charAt(9) + "' AND " +
                    "MLFB11_G120 = " 	+  sECSI_MLFB.charAt(10) + " AND " +
                    "MLFB12_G120 = " 	+  sECSI_MLFB.charAt(11) + " AND " + 
                    "MLFB13_G120 = " 	+  sECSI_MLFB.charAt(12) + " AND " + 
                    "MLFB15_G120 = '" 	+  sECSI_MLFB.charAt(14) + "' AND " +
                    "MLFB16_G120 = " 	+  sECSI_MLFB.charAt(15) + " AND " +
                    "HMK_VALUE_VALID_G120 = 'T';"; 
        
        var aResult = GetDBDataSetEXT(sSQL);
        
        if (aResult.length > 1)
        {
            // mehrere Lösungen vorhanden
            ECL_EnableAttribute("PMD_AAD146_001_000_G120");
            ECL_DeactivateAllAttributeValues("PMD_AAD146_001_000_G120");
            
            var sDSEE_PM = ECL_GetValue("HMK_DSEE_PM_G120");
            var sFUSE_Check = ECL_GetValue("HMK_FUSE_TYPE_G120");
            
            for (var i = 0; i < aResult.length; i++)
            {
                var bCheck_OK = true;
                if (sDSEE_PM != "OHNE"){
                    var sMLFB_Key_DSEE = aResult[i].MLFB_KEY_G120;
                    var sSQL =  "SELECT * FROM VT_G120_M00254_" + sDB_Version + " WHERE " +
                                "HMK_DSEE_PM_G120 = '" + sDSEE_PM + "' AND " +
                                "MLFB_KEY_G120 = '" + aResult[i].MLFB_KEY_G120 + "' AND " +
                                "MLFB14_G120 = '" + aResult[i].MLFB14_G120 + "' AND " +
                                "HMK_VALUE_VALID_G120 = 'T';";
                    var aResultDSEE = Object.fromDatabase("EXTERNAL_DATA", sSQL);
                    
                    if (aResultDSEE.length > 0){
                        bCheck_OK = true;
                    }else{
                        bCheck_OK = false;
                    }
                }
                if (bCheck_OK && sFUSE_Check != "00320"){
                    
                    var sSQL_FUSE = "SELECT * FROM VT_G120_M00222_" + sDB_Version + " WHERE " +
                                    "MLFB_KEY_G120 = '" + aResult[i].MLFB_KEY_G120 + "' AND " +
                                    "HMK_FUSE_TYPE_G120 = '" + sFUSE_Check + "' AND " +
                                    "HMK_VALUE_VALID_G120 = 'T';";
                                    
                    var aResultFUSE = Object.fromDatabase("EXTERNAL_DATA", sSQL_FUSE);
                    
                    if (aResultFUSE.length > 0){
                        bCheck_OK = true;
                    }else{
                        bCheck_OK = false;
                    }
                }
                if (bCheck_OK){
                    ECL_ActivateValue("PMD_AAD146_001_000_G120", aResult[i].PMD_AAD146_001_000_G120);
                }
            }
        }
        else if (aResult.length == 1)
        {
            // genau eine Lösung vorhanden
            ECL_DeactivateAllAttributeValues("PMD_AAD146_001_000_G120");
            ECL_ActivateValue("PMD_AAD146_001_000_G120", aResult[0].PMD_AAD146_001_000_G120);
            ECL_SetValue("PMD_AAD146_001_000_G120", aResult[0].PMD_AAD146_001_000_G120);
        }
        
        sFilterParam = ECL_GetValue("PMD_AAD146_001_000_G120");
        if (sFilterParam == "00003") // - Filter A
        {
            if (sMLFB_Key == "00616" || sMLFB_Key == "00617" || sMLFB_Key == "00618" )                  
            {
                var sFilterA_C = "C";
            }
            else
            {
                var sFilterA_C = "A";
            } 
            sECSI_MLFB = replaceAt(sECSI_MLFB, 13, sFilterA_C);
            ECL_SetValue("MLFB14_G120", sFilterA_C);
            // Kein externer Filter B zugelassen
            ECL_SetValue("HMK_NETZFILTER_EXT_G120", "00001");
            ECL_DisableAttribute("HMK_NETZFILTER_EXT_G120");
        }
        else if (sFilterParam == "00007") // - ungefiltert/ohne
        {
            if (sMLFB_Key == "00610" || sMLFB_Key == "00611" || sMLFB_Key == "00612" )                  
            {
                var sFilterU_C = "C";
            }
            else
            {
                var sFilterU_C = "U";
            }
            
            sECSI_MLFB = replaceAt(sECSI_MLFB, 13, sFilterU_C); // oder C bei FSG
            ECL_SetValue("MLFB14_G120", sFilterU_C);
            ECL_EnableAttribute("HMK_NETZFILTER_EXT_G120");
        }
        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
            
        // VT Filter intern (A) und Filter extern B: VT_G120_M00106_24213
        // PMD_AAD146_001_000_G120	HMK_NETZFILTER_EXT_G120	HMK_VALUE_VALID_G120
        //ECL_InferencePositiveMultipleAttributes("VT_G120_M00106_24213");
        
        var HMK_NETZFILTER_EXT_G120 = ECL_GetValue("HMK_NETZFILTER_EXT_G120");
        var sTable = "VT_G120_M00106_" + sDB_Version ;
        var sTargetAttribute = "PMD_AAD146_001_000_G120";
        var sWhere = "HMK_NETZFILTER_EXT_G120 = '" + HMK_NETZFILTER_EXT_G120 + "' AND " +
                        "HMK_VALUE_VALID_G120 = 'T';";
        
        SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere, "");
        
        var PMD_AAD146_001_000_G120 = ECL_GetValue("PMD_AAD146_001_000_G120");
        var sTargetAttribute = "HMK_NETZFILTER_EXT_G120";
        var sWhere = "PMD_AAD146_001_000_G120 = '" + PMD_AAD146_001_000_G120 + "' AND " +
                        "HMK_VALUE_VALID_G120 = 'T';";
        
        SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere, "");
        
    }	
    /* CONSEQUENCES
    InputFilterType
    Integer	
    This parameter defines, if an internal line filter was selected.	
        0	No internal line filter selected
        1	Internal line filter C1
        2	Internal line filter C2
        3	Internal line filter C3
    */
   var supplySystem = ECL_GetValue("ECSI_CX_StandardSupplySystem");
   var converterRatedPower = ECL_GetValue("ECSI_CX_ConverterRatedPower");
   var bauform = ECL_GetValue("TAK_AAJ871_001_000_G120");

   var InputFilterType="";
   var ExternalFilterType="";

    switch (ECL_GetValue("PMD_AAD146_001_000_G120")){
        case "00007": // ohne
            var InputFilterType = "0";
            if(160 <= converterRatedPower)
            {
                if(bauform === "FSG")
                {
                    if(
                        supplySystem === "2" || supplySystem === "3" || supplySystem === "4" || supplySystem === "9" ||
                        supplySystem === "10" || supplySystem === "11" || supplySystem === "12" || supplySystem === "13"
                    ) // 380...480V
                    {
                        InputFilterType = "3";
                    }
                }
            }
        break;
        case "00003": // mit
            if(converterRatedPower < 160)
            {
                if(bauform === "FSA" || bauform === "FSB" || bauform === "FSC" || bauform === "FSD" || bauform === "FSE" || bauform === "FSF")
                {
                    InputFilterType = "2";
                    ExternalFilterType = "";
                }
                else if (bauform === "FSG")
                {
                    
                }
            }
            else if(160 <= converterRatedPower)
            {
                if(bauform === "FSG")
                {
                    if(supplySystem === "5" || supplySystem === "6" || supplySystem === "14" || supplySystem === "15") // 500...690V
                    {
                        InputFilterType = "3";
                    }
                    else 
                    if(
                        supplySystem === "2" || supplySystem === "3" || supplySystem === "4" || supplySystem === "9" ||
                        supplySystem === "10" || supplySystem === "11" || supplySystem === "12" || supplySystem === "13"
                    ) // 380...480V
                    {
                        InputFilterType = "2";
                    }

                }

            }
            else
            {
                InputFilterType="2";
            }

        break;
        default:
            InputFilterType = "0";
    }
    ECL_SetValue("ECSI_CC_InputFilterType", InputFilterType);
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // PM - Rückspeisung
    // VT_G120_M00096
    //	 HMK_TYPE_PM_G120	HMK_BRAKEBEHAVIOUR_G120	TAK_AAK953_001_000_G120
    var oAttributesMapping = {"TAK_AAK953_001_000_G120": null};
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00096" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        mapping: oAttributesMapping,
        operators: {
            "HMK_BRAKEBEHAVIOUR_G120": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    
    // #########################################################################################################################
    // CU Config
    // #########################################################################################################################
    //ECL_InferencePositiveMultipleAttributes("VT_G120_M00272_24213");
    
    var HMK_TYPE_PM_G120 = ECL_GetValue("HMK_TYPE_PM_G120");
    
    // CU Auswahl in Abhängigkeit von Powermodul und Produkt
    var sSQL = "SELECT VT_G120_M00077_" + sDB_Version + ".HMK_TYPE_CU_G120 FROM VT_G120_M00077_" + sDB_Version + " " +
                "INNER JOIN VT_G120_M00188_" + sDB_Version + " " +
                "ON VT_G120_M00077_" + sDB_Version + ".HMK_TYPE_CU_G120 = VT_G120_M00188_" + sDB_Version + ".HMK_TYPE_CU_G120 " +
                "WHERE " +
                "VT_G120_M00188_" + sDB_Version + ".HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " +
                "VT_G120_M00188_" + sDB_Version + ".HMK_VALUE_VALID_G120 = 'T' AND " +
                "VT_G120_M00077_" + sDB_Version + ".HMK_TYPE_PM_G120 = '" + HMK_TYPE_PM_G120 + "' AND " +
                "VT_G120_M00077_" + sDB_Version + ".HMK_VALUE_VALID_G120 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL, "CU_JOIN_77_188");
    if (aResult.length > 0)
    {
        var motorTechnology = ECL_GetValue("ECSI_CX_MotorTechnology");
        ECL_DeactivateAllAttributeValues("HMK_TYPE_CU_G120");
        for (var i=0; i<aResult.length; i++){
            var HMK_TYPE_CU_G120 = aResult[i].HMK_TYPE_CU_G120;
            if(motorTechnology === "2")
            {
                if(HMK_TYPE_CU_G120 !== "00320" &&
                    HMK_TYPE_CU_G120 !== "00321" &&
                    HMK_TYPE_CU_G120 !== "00322" &&
                    HMK_TYPE_CU_G120 !== "00323" &&
                    HMK_TYPE_CU_G120 !== "00078" &&
                    HMK_TYPE_CU_G120 !== "00079" &&
                    HMK_TYPE_CU_G120 !== "00080"
                )
                {
                    ECL_ActivateValue("HMK_TYPE_CU_G120", HMK_TYPE_CU_G120);
                }
            }
            
            else
            {
                ECL_ActivateValue("HMK_TYPE_CU_G120", HMK_TYPE_CU_G120);
            }
        }

        if (HMK_PRODUKT_TRIG_G120 === "S110" && (ECL_GetValue("ECSI_CX_MotionControlRequirements") == 3)) {
            ECL_DeactivateValue("HMK_TYPE_CU_G120", "00325");
        } else if (HMK_PRODUKT_TRIG_G120 === "S120" && (ECL_GetValue("ECSI_CX_MotionControlRequirements") == 3)) { 
            ECL_DeactivateValue("HMK_TYPE_CU_G120", "00995");
        }

        ExecSetStandardifValueEmpty("HMK_TYPE_CU_G120", "00088");
    }else{
        // Error
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___CU_NO_VALUES_G120") + " ";
    }
    
    
    if (sCurrentAttribute == "PMD_ABU804_001_000_G120"){
        // Bus geändert, dann versuchen eine CU der gleichen Klasse 230er, 240er oder 250er zu wählen
        var sCU_old = ECL_GetValue("HMK_TYPE_CU_G120");
    }
    // CU von Safety abhängig
    // VT  VT_G120_M00268_24213	
/*	var aAttributesVT134 = ["HMK_TYPE_CU_G120",			// ControlUnit
                            "PMD_ABU804_001_000_G120",	// Kommunikation
                            "HMK_SAFETY_STO_G120",		// STO
                            "HMK_SAFETY_SS1_G120",	
                            "HMK_SAFETY_SLS_G120",	
                            "HMK_SAFETY_SDI_G120",	
                            "HMK_SAFETY_SSM_G120",	
                            "HMK_SAFETY_SBC_G120",
                            "HMK_EPOS_G120",			// Positionierfunktionalität
                            "HMK_VALUE_VALID_G120"];
    
    ECL_InferencePositiveValues("VT_G120_M00268_24213", "HMK_TYPE_CU_G120", aAttributesVT134);
*/	

/* EDIT 2021.06 keine Einschränkung, damit Umwahl in beiden Richtungen möglich bleibt
*/
    var sTarget = "HMK_TYPE_CU_G120";
    var sTable = "VT_G120_M00268_" + sDB_Version ;

    var sWhereBus = "";
    if ( (sFieldbusInterface !== "") && (sFieldbusInterface !== undefined)) {
        sWhereBus = "PMD_ABU804_001_000_G120 = '" + ECL_GetValue("PMD_ABU804_001_000_G120") + "' AND ";
    }
    
    var sWhere = 	"HMK_SAFETY_STO_G120 = '" + ECL_GetValue("HMK_SAFETY_STO_G120") + "' AND " +
                    "HMK_SAFETY_SS1_G120 = '" + ECL_GetValue("HMK_SAFETY_SS1_G120") + "' AND " +
                    "HMK_SAFETY_SLS_G120 = '" + ECL_GetValue("HMK_SAFETY_SLS_G120") + "' AND " +
                    "HMK_SAFETY_SDI_G120 = '" + ECL_GetValue("HMK_SAFETY_SDI_G120") + "' AND " +
                    "HMK_SAFETY_SSM_G120 = '" + ECL_GetValue("HMK_SAFETY_SSM_G120") + "' AND " +
                    "HMK_SAFETY_SBC_G120 = '" + ECL_GetValue("HMK_SAFETY_SBC_G120") + "' AND " +
                    "HMK_EPOS_G120 = '" + ECL_GetValue("HMK_EPOS_G120") + "' AND " +
                    sWhereBus +
                    "HMK_VALUE_VALID_G120 = 'T';";


    if (HMK_PRODUKT_TRIG_G120 === "S120") {
        if (ECL_GetValue("PMD_ABU804_001_000_G120") === "00002") {
            ECL_ActivateValue("HMK_TYPE_CU_G120", "00994");
            ECL_DeactivateValue("HMK_TYPE_CU_G120", "00995");
        }

        if (ECL_GetValue("PMD_ABU804_001_000_G120") === "00001") {
            ECL_ActivateValue("HMK_TYPE_CU_G120", "00995");
            ECL_DeactivateValue("HMK_TYPE_CU_G120", "00994");
        }

        ECL_ActivateValue("HMK_TYPE_CU_G120", "00996");
        ECL_ActivateValue("HMK_TYPE_CU_G120", "00997");
    } else {
        var sStatus = SetAttributeLogic2nd(sTable, sTarget, sWhere, "00088")
    }
    
    if (sStatus == "Error"){
        // Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___CU_NO_VALUES_G120") + " ";
    }
    
    if (sCU_old && count < 2){
        //es gibt eine Änderung des Bussystems und es soll versucht werden eine CU zu wählen, die der alten Klasse entspricht:
        var aCUselectable = ECL_GetAllActiveAttributeValues("HMK_TYPE_CU_G120");
        
        
        var PMD_ABU804_001_000_G120 = ECL_GetValue("PMD_ABU804_001_000_G120");
        
        var sSQL = "SELECT DISTINCT HMK_TYPE_CU_G120 FROM VT_G120_M00268_" + sDB_Version + " WHERE " + 
                    "PMD_ABU804_001_000_G120 = '" + PMD_ABU804_001_000_G120 + "'";
                    "HMK_VALUE_VALID_G120 = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00268_" + sDB_Version +"_COM");
        var aValidCUsForComunication = [];
        if (aResult.length > 0)
        {
            //var HMK_TYPE_CU_G120 = aResult[0].HMK_TYPE_CU_G120;
            for (var i=0; i<aResult.length; i++){
                var HMK_TYPE_CU_G120 = aResult[i].HMK_TYPE_CU_G120;
                
                if (aCUselectable.indexOf(aResult[i].HMK_TYPE_CU_G120) > -1){
                    aValidCUsForComunication.push(HMK_TYPE_CU_G120);
                }
            }
        }else{
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___CU_NO_DATA_G120") + " ";
        }
        
        
        
        
        /* MLFBs CU VT_G120_M00078_24213 inner join VT188 
            HMK_MLFB_CONTROLUNIT_G120		HMK_TYPE_CU_G120					Kommunikation
            6SL32430BB301PA3						00078	T    	CU230P-2 DP		
            6SL32430BB301HA3						00079	T    	CU230P-2 HVAC	
            6SL32430BB301FA0						00080	T    	CU230P-2 PN			
            6SL32440BB121BA1						00084	T    	CU240E-2			
            6SL32440BB121PA1						00085	T    	CU240E-2 DP		
            6SL32440BB131PA1						00086	T    	CU240E-2 DP-F	
            6SL32440BB131BA1						00087	T    	CU240E-2 F		
            6SL32440BB121FA0						00088	T    	CU240E-2 PN		
            6SL32440BB131FA0						00089	T    	CU240E-2 PN-F	
            6SL32460BA221BA0						00320	T    	CU250S-2			
            6SL32460BA221PA0						00321	T    	CU250S-2 DP		
            6SL32460BA221FA0						00322	T    	CU250S-2 PN		
            6SL32460BA221CA0						00323	T    	CU250S-2 CAN	
            
            6SL30400JA010AA0						00324		CU305 PN			S110
            6SL30400JA000AA0						00325		CU305 DP			S110
            
            6SL30401LA010AA0						00994		CU310-2 PN			S120
            6SL30401LA000AA0						00995		CU310-2 DP			S120
            6SL30400PA000AA1						00996		CUA31, CU Adapter	S120
            6SL30400PA010AA0						00997		CUA32, CU Adapter	S120
        */
        var aCU230 = ["00078", "00079", "00080"];
        var aCU240 = ["00084", "00085", "00086", "00087", "00088", "00089"];
        var aCU250 = ["00320", "00321", "00322", "00323"];
        // S110
        var aCU305 = ["00324", "00325"];
        // S120
        var aCU310 = ["00994", "00995"];
        var aCUA3X = ["00996", "00997"];
        
        var aCUnew = [];
        if (aCU230.indexOf(sCU_old) > -1){
            aCUnew = intersect(aValidCUsForComunication, aCU230);
        }
        if (aCU240.indexOf(sCU_old) > -1){
            aCUnew = intersect(aValidCUsForComunication, aCU240);
        }
        if (aCU250.indexOf(sCU_old) > -1){
            aCUnew = intersect(aValidCUsForComunication, aCU250);
        }
        if (aCU305.indexOf(sCU_old) > -1){
            aCUnew = intersect(aValidCUsForComunication, aCU305);
        }
        if (aCU310.indexOf(sCU_old) > -1){
            aCUnew = intersect(aValidCUsForComunication, aCU310);
        }
        if (aCUA3X.indexOf(sCU_old) > -1){
            aCUnew = intersect(aValidCUsForComunication, aCUA3X);
        }
        if (aCUnew.length == 0) {
            aCUnew = aValidCUsForComunication;
        }
        
        if ( aCUnew.length > 0) {
            if (sCU_old == "00086"){
                if (aCUnew.indexOf("00089") > -1){
                    ECL_SetValue("HMK_TYPE_CU_G120", "00089");
                }else{
                    ECL_SetValue("HMK_TYPE_CU_G120", aCUnew[0]);
                }
            }else if (sCU_old == "00089"){
                if (aCUnew.indexOf("00086") > -1){
                    ECL_SetValue("HMK_TYPE_CU_G120", "00086");
                }else{
                    ECL_SetValue("HMK_TYPE_CU_G120", aCUnew[0]);
                }
            }else{
                ECL_SetValue("HMK_TYPE_CU_G120", aCUnew[0]);
            }
        }
        /*else{
            // keine automatische Klassenumwahl möglich, es wird der verfügbare Wert gewählt
        }
        */
    }
    
    if (HMK_PRODUKT_TRIG_G120 == "G120")
    {	
        if(sCurrentAttribute === "UI_ENCODER_EVALUATION_G120")
        {
            var encoderEvalUi = ECL_GetValue("UI_ENCODER_EVALUATION_G120");
            var communication = ECL_GetValue("PMD_ABU804_001_000_G120");
            if(encoderEvalUi === "ENCODER_EVAL_G120_WITH")
            {
                ECL_SelectValue("PMD_ABU278_001_000_G120","00002");
                enableCu250Only();
                var pnDefault = "00322";
                var modbusDefault = "00320";
                var canDefault = "00323";
                var dpDefault = "00321";
                if(communication === "00002") // PROFINET
                {
                    ECL_SelectValue("HMK_TYPE_CU_G120", pnDefault);
                }
                else if(communication === "00001") // PROFIBUS DP
                {
                    ECL_SelectValue("HMK_TYPE_CU_G120", dpDefault); 
                }
                else if(communication === "00003") // CANopen
                {
                    ECL_SelectValue("HMK_TYPE_CU_G120", canDefault); 
                }
                else if(communication === "00004") // CANopen
                {
                    ECL_SelectValue("HMK_TYPE_CU_G120", modbusDefault); 
                }    
                //var active =  ECL_GetAllActiveAttributeValues("HMK_TYPE_CU_G120");
            }
            else if(encoderEvalUi === "ENCODER_EVAL_G120_WITHOUT")
            {
                ECL_SelectValue("PMD_ABU278_001_000_G120", "00001");
                var pnDefault = "00088";
                var modbusDefault = "00084";
                var canDefault = "00084";
                var dpDefault = "00085";
                if(communication === "00002") // PROFINET
                {
                    ECL_SelectValue("HMK_TYPE_CU_G120", pnDefault);
                }
                else if(communication === "00001") // PROFIBUS DP
                {
                    ECL_SelectValue("HMK_TYPE_CU_G120", dpDefault); 
                }
                else if(communication === "00003") // CANopen
                {
                    ECL_SelectValue("HMK_TYPE_CU_G120", canDefault); 
                }
                else if(communication === "00004") // CANopen
                {
                    ECL_SelectValue("HMK_TYPE_CU_G120", modbusDefault); 
                }    
                
                ECL_DeselectValue("UI_HMK_F01_G120", "T");
                ECL_SelectValue("HMK_F01_G120", "NON");
                
                ECL_DeselectValue("UI_HMK_E01_G120", "T");
                ECL_SelectValue("HMK_E01_G120", "NON");
            }
        }
        
        // Enable only cu250 and its variants when encoder evaluation is selected
        var encoderEvaluation = ECL_GetValue("PMD_ABU278_001_000_G120");
        if(encoderEvaluation === "00002" || encoderEvaluation === "00003")
        {
            enableCu250Only();
            // var pnDefault = "00322";
            // var modbusDefault = "00320";
            // var canDefault = "00323";
            // var dpDefault = "00321";
            // var communication = ECL_GetValue("PMD_ABU804_001_000_G120");
            // if(communication === "00002") // PROFINET
            // {
            //     ECL_SelectValue("HMK_TYPE_CU_G120", pnDefault);
            // }
            // else if(communication === "00001") // PROFIBUS DP
            // {
            //     ECL_SelectValue("HMK_TYPE_CU_G120", dpDefault); 
            // }
            // else if(communication === "00003") // CANopen
            // {
            //     ECL_SelectValue("HMK_TYPE_CU_G120", canDefault); 
            // }
            // else if(communication === "00004") // CANopen
            // {
            //     ECL_SelectValue("HMK_TYPE_CU_G120", modbusDefault); 
            // }    
        }
    }
        // #########################################################################################################################
        // EPOS Einschränkung von CU
        // #########################################################################################################################
        if (sMotionControlReq == "1" && HMK_PRODUKT_TRIG_G120 == "G120")//(ECL_GetValue("HMK_EPOS_G120") == "T") // bzw. ECSI_CX_MotionControlRequirements == 1 ???
        {
            // Nur noch CUs mit EPOS zulassen:
            var aCU_selectable = ECL_GetAllActiveAttributeValues("HMK_TYPE_CU_G120");
            var aValidCUs_for_EPOS = ["00320",  "00321",  "00322",  "00323"];
            if (aCU_selectable.length > 0)
            {
                ECL_DeactivateAllAttributeValues("HMK_TYPE_CU_G120");
                for (var i = 0; i < aCU_selectable.length; i++)
                {
                    var sCUcheck = aCU_selectable[i];
                    if (aValidCUs_for_EPOS.indexOf(aCU_selectable[i]) > -1)
                    {
                        ECL_ActivateValue("HMK_TYPE_CU_G120", sCUcheck);
                    }
                }
            }
        }
        // #########################################################################################################################
        
        // #########################################################################################################################
        // EPOS Steuerung in Abhängigkeit von Lizenz:
        // #########################################################################################################################
        
        var sEPOS_Lic = ECL_GetValue("HMK_E01_G120") || "";
        if (sEPOS_Lic == "E01")
        {
            ECL_SelectValue("HMK_EPOS_G120", "T");
            // Nur noch CUs mit EPOS zulassen:
            var aCU_valid = ECL_GetAllActiveAttributeValues("HMK_TYPE_CU_G120");
            if (aCU_valid.length > 0)
            {
                ECL_DeactivateAllAttributeValues("HMK_TYPE_CU_G120");
                for (var i = 0; i < aCU_valid.length; i++)
                {
                    var sCU_valid = aCU_valid[i];
                    if ( (sCU_valid == "00320") || (sCU_valid == "00321") || (sCU_valid == "00322") || (sCU_valid == "00323")
                    ) {
                        ECL_ActivateValue("HMK_TYPE_CU_G120", sCU_valid);
                    }
                }
            }
        }
        else
        {
            if (sMotionControlReq !== "" && sMotionControlReq !== undefined && HMK_PRODUKT_TRIG_G120 == "G120")
            {
                var iMotionControlReq = parseInt(sMotionControlReq);
                if (iMotionControlReq == 0 )
                    ECL_SelectValue("HMK_EPOS_G120", "F"); 
                if (iMotionControlReq == 1) 
                    ECL_SelectValue("HMK_EPOS_G120", "T"); 
            }
            else
            {
                ECL_SelectValue("HMK_EPOS_G120", "F"); 
            }
        }
        
        // #########################################################################################################################
        
    // #########################################################################################################################
    // Steuerung UI-Checkboxen, Info, welche Safety-Functions grundsätzlich unterstützt werden
    // #########################################################################################################################
    var HMK_TYPE_CU_G120 = ECL_GetValue("HMK_TYPE_CU_G120");
    var PMD_ABU804_001_000_G120 = ECL_GetValue("PMD_ABU804_001_000_G120");

    var sTable = "VT_G120_M00268_" + sDB_Version ;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "HMK_TYPE_CU_G120 = '" + HMK_TYPE_CU_G120 + "' AND " +	
                "PMD_ABU804_001_000_G120 = '" + PMD_ABU804_001_000_G120 + "' AND " +
                "HMK_VALUE_VALID_G120 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00268_" + sDB_Version +"_Safety");
    
    ECL_DeselectAttribute("UI_HMK_SAFETY_STO_G120");
    ECL_DeselectAttribute("UI_HMK_SAFETY_SS1_G120");
    ECL_DeselectAttribute("UI_HMK_SAFETY_SLS_G120");
    ECL_DeselectAttribute("UI_HMK_SAFETY_SDI_G120");
    ECL_DeselectAttribute("UI_HMK_SAFETY_SSM_G120");
    ECL_DeselectAttribute("UI_HMK_SAFETY_SBC_G120");
    
    if (aResult.length > 0){
        
        for (var i=0;i<aResult.length;i++){
            
            if (aResult[i].HMK_SAFETY_STO_G120 == "T"){
                ECL_SelectValue("UI_HMK_SAFETY_STO_G120", "T");
                break;
            }
        }
        for (var i=0;i<aResult.length;i++){
            if (aResult[i].HMK_SAFETY_SS1_G120 == "T"){
                ECL_SelectValue("UI_HMK_SAFETY_SS1_G120", "T");
                break;
            }
        }
        for (var i=0;i<aResult.length;i++){
            if (aResult[i].HMK_SAFETY_SLS_G120 == "T"){
                ECL_SelectValue("UI_HMK_SAFETY_SLS_G120", "T");
                break;
            }
        }
        for (var i=0;i<aResult.length;i++){
            if (aResult[i].HMK_SAFETY_SDI_G120 == "T"){
                ECL_SelectValue("UI_HMK_SAFETY_SDI_G120", "T");
                break;
            }
        }
        for (var i=0;i<aResult.length;i++){
            if (aResult[i].HMK_SAFETY_SSM_G120 == "T"){
                ECL_SelectValue("UI_HMK_SAFETY_SSM_G120", "T");
                break;
            }
        }
        for (var i=0;i<aResult.length;i++){
            if (aResult[i].HMK_SAFETY_SBC_G120 == "T"){
                ECL_SelectValue("UI_HMK_SAFETY_SBC_G120", "T");
                break;
            }
        }
    }
    
    // #########################################################################################################################
    
    var sU01_Lic = ECL_GetValue("HMK_U01_G120") || "";    
    var sJ01_Lic = ECL_GetValue("HMK_J01_G120") || "";
    var sF01_Lic = ECL_GetValue("HMK_F01_G120") || "";
    
    // ??? Kommunikation in Abängigkeit CU einschränken
    
    
    // #########################################################################################################################
    // Einschränkungen wegen Anbau an Reluktanzmotor
    // #########################################################################################################################
    var motorTechnology=ECL_GetValue("ECSI_CX_MotorTechnology"); 		// Was ist bei S110, S120 ACAC??? Todo
    if(motorTechnology)
    {
        var iMotorTechnology=parseInt(motorTechnology);
        if(iMotorTechnology==2)
        {
            // nicht erlaubt: CU250S-2, CU250S-2 DP, CU250S-2 PN, CU250S-2 CAN
            ECL_DeactivateValue("HMK_TYPE_CU_G120","00320"); // CU250S-2
            ECL_DeactivateValue("HMK_TYPE_CU_G120","00321"); // CU250S-2 DP
            ECL_DeactivateValue("HMK_TYPE_CU_G120","00322"); // CU250S-2 PN
            ECL_DeactivateValue("HMK_TYPE_CU_G120","00323"); // CU250S-2 CAN
        }
        else if(iMotorTechnology === 1)
        {
            var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
            var defaultVPM = ECL_GetValue("ECSI_CX_Default_VPM");
            if((product === "S110" || product === "S120"))
            {
                ECL_ActivateAttribute("VPM_MODULE_S110_S120");
                ECL_ActivateAllAttributeValues("VPM_MODULE_S110_S120");
                
				if(defaultVPM == "1" && ECL_GetValue("ECSI_IS_START_CONFIGURATION") == "1")
				{
					ECL_SelectValue("VPM_MODULE_S110_S120", "VPM_120_S110_S120");
				}
            }
            
        }
        else
        {
            var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
            if((product === "S110" || product === "S120"))
            {
                ECL_SelectValue("VPM_MODULE_S110_S120", "VPM_NONE_S110_S120");
            }
        }
    }
    
    
    // #########################################################################################################################
    
    
    ExecSetStandardifValueEmpty("HMK_TYPE_CU_G120", "00088");
    
    /*var aAttributesVT134a = ["HMK_TYPE_CU_G120",			// ControlUnit
                                "PMD_ABU804_001_000_G120",	// Kommunikation
                                "HMK_SAFETY_STO_G120",		// STO
                                "HMK_SAFETY_SS1_G120",	
                                "HMK_SAFETY_SLS_G120",	
                                "HMK_SAFETY_SDI_G120",	
                                "HMK_SAFETY_SSM_G120",	
                                "HMK_SAFETY_SBC_G120",
                                "HMK_F_DI_G120",			// Fehlersicher DI
                                "TAK_AAN259_001_000_G120",	// Anzahl Digitaleingänge
                                "PMD_AAA274_001_000_G120",	// Anzahl Analogeingänge
                                "TAK_AAM785_001_000_G120",	// Anzahl Digitalausgänge
                                "PMD_AAA310_001_000_G120",	// Anzahl Analogausgänge
                                "HMK_DI_DO_G120",			// Digital Ein- / Ausgänge
                                "PMD_ABU278_001_000_G120",	// Geberauswertung
                                "HMK_EPOS_G120",			// Positionierfunktionalität
                                "HMK_VALUE_VALID_G120"];
    */
    // IO-setzen
    
    var sSQL_CU_Config = "SELECT * FROM VT_G120_M00268_" + sDB_Version + " WHERE " +
                            "HMK_TYPE_CU_G120 = ? AND " + 			// ControlUnit
                            "PMD_ABU804_001_000_G120 = ? AND " +	// Kommunikation
                            "HMK_SAFETY_STO_G120 = ? AND " +		// STO
                            "HMK_SAFETY_SS1_G120 = ? AND " +	
                            "HMK_SAFETY_SLS_G120 = ? AND " +	
                            "HMK_SAFETY_SDI_G120 = ? AND " +	
                            "HMK_SAFETY_SSM_G120 = ? AND " +	
                            "HMK_SAFETY_SBC_G120 = ? AND " +
                            "HMK_EPOS_G120 = ? AND " +			// Positionierfunktionalität
                            "HMK_VALUE_VALID_G120 = 'T' ;";
    var aParam = [	ECL_GetValue("HMK_TYPE_CU_G120"), 
                    ECL_GetValue("PMD_ABU804_001_000_G120"),
                    ECL_GetValue("HMK_SAFETY_STO_G120"),
                    ECL_GetValue("HMK_SAFETY_SS1_G120"),
                    ECL_GetValue("HMK_SAFETY_SLS_G120"),
                    ECL_GetValue("HMK_SAFETY_SDI_G120"),
                    ECL_GetValue("HMK_SAFETY_SSM_G120"),
                    ECL_GetValue("HMK_SAFETY_SBC_G120"),
                    ECL_GetValue("HMK_EPOS_G120")];
                    
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sSQL_CU_Config, aParam);
    
    var sHMK_F_DI_G120			= "00001";
    var iTAK_AAN259_001_000_G120 = 0;
    var iPMD_AAA274_001_000_G120 = 0;
    var iTAK_AAM785_001_000_G120 = 0;
    var iPMD_AAA310_001_000_G120 = 0;
    var iHMK_DI_DO_G120 		= 0;
    var sPMD_ABU278_001_000_G120 = ECL_GetValue("PMD_ABU278_001_000_G120") || "00001";
    var encoderEvalUi = "ENCODER_EVAL_G120_WITHOUT";
    
    if (aDbResult.length > 0)
    {
        for (var i = 0; i < aDbResult.length; i++)
        {
            // Fehlersicher DI
            if (aDbResult[i].HMK_F_DI_G120 == "00002")
            {
                if ( sHMK_F_DI_G120 == "00001"
                ) {
                    sHMK_F_DI_G120 = aDbResult[i].HMK_F_DI_G120;
                }
            }
            else if (aDbResult[i].HMK_F_DI_G120 == "00003")
            {
                sHMK_F_DI_G120 = aDbResult[i].HMK_F_DI_G120;
            }
            // Anzahl Digitaleingänge
            if ( aDbResult[i].TAK_AAN259_001_000_G120 > iTAK_AAN259_001_000_G120
            ) {
                iTAK_AAN259_001_000_G120 = aDbResult[i].TAK_AAN259_001_000_G120;
            }
            // Anzahl Analogeingänge
            if ( aDbResult[i].PMD_AAA274_001_000_G120 > iPMD_AAA274_001_000_G120
            ) {
                iPMD_AAA274_001_000_G120 = aDbResult[i].PMD_AAA274_001_000_G120;
            }
            // Anzahl Digitalausgänge
            if ( aDbResult[i].TAK_AAM785_001_000_G120 > iTAK_AAM785_001_000_G120
            ) {
                iTAK_AAM785_001_000_G120 = aDbResult[i].TAK_AAM785_001_000_G120;
            }
            // Anzahl Analogausgänge
            if ( aDbResult[i].PMD_AAA310_001_000_G120 > iPMD_AAA310_001_000_G120
            ) {
                iPMD_AAA310_001_000_G120 = aDbResult[i].PMD_AAA310_001_000_G120;
            }
            // Anzahl Digital Ein- / Ausgänge
            if ( aDbResult[i].HMK_DI_DO_G120 > iHMK_DI_DO_G120
            ) {
                iHMK_DI_DO_G120 = aDbResult[i].HMK_DI_DO_G120;
            }
        }
        // Geberauswertung
        sPMD_ABU278_001_000_G120 = aDbResult[0].PMD_ABU278_001_000_G120;
        
        
    }else{
        // Fehler, keine gültige DB-Abfrage
        //var sErrTest = "";
    }
    
    ECL_SelectValue("HMK_F_DI_G120", sHMK_F_DI_G120);
    ECL_SelectValue("TAK_AAN259_001_000_G120", parseInt(iTAK_AAN259_001_000_G120));
    ECL_SelectValue("PMD_AAA274_001_000_G120", parseInt(iPMD_AAA274_001_000_G120));
    ECL_SelectValue("TAK_AAM785_001_000_G120", parseInt(iTAK_AAM785_001_000_G120));
    ECL_SelectValue("PMD_AAA310_001_000_G120", parseInt(iPMD_AAA310_001_000_G120));
    ECL_SelectValue("HMK_DI_DO_G120", parseInt(iHMK_DI_DO_G120));
    
    if (HMK_PRODUKT_TRIG_G120 == "G120")
    {
        var controlUnit = ECL_GetValue("HMK_TYPE_CU_G120");
        if(
            controlUnit === "00320" ||
            controlUnit === "00321" ||
            controlUnit === "00322"	||
            controlUnit === "00323"
        )
        {
            encoderEvalUi = "ENCODER_EVAL_G120_WITH";
            sPMD_ABU278_001_000_G120 = getEncoderEvaluationValue() === "00001" ? "00002" : getEncoderEvaluationValue();
        }
    }
    ECL_SelectValue("UI_ENCODER_EVALUATION_G120", encoderEvalUi);
    ECL_SelectValue("PMD_ABU278_001_000_G120", sPMD_ABU278_001_000_G120);

    // #########################################################################################################################
    
    
    // #########################################################################################################################
    // Kommunikation / Busprotokoll
    // #########################################################################################################################
    // HMK_PRODUKT_TRIG_G120	HMK_TYPE_CU_G120	HMK_VALUE_VALID_G120

    if (sJ01_Lic == "F" && sU01_Lic == "F" && sEPOS_Lic == "NON" /*&& sExtendedSafety_Lic == "NON" wird nicht gebraucht*/){
        var sSQL = "SELECT DISTINCT HMK_TYPE_CU_G120 FROM VT_G120_M00188_" + sDB_Version + " WHERE HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00188_" + sDB_Version +"_COM");
        
        var sWhere = "";
        
        if (aResult.length > 0){
            var sWhere = "(HMK_TYPE_CU_G120 = '" + aResult[0].HMK_TYPE_CU_G120 + "'";
            
            for (var i=1; i<aResult.length; i++){
                sWhere = sWhere + " OR HMK_TYPE_CU_G120 = '" + aResult[i].HMK_TYPE_CU_G120 + "'";
            }
            sWhere = sWhere + ") ";
            
            var sSQL = "SELECT DISTINCT PMD_ABU804_001_000_G120 FROM VT_G120_M00268_" + sDB_Version + " WHERE " + sWhere + "AND HMK_VALUE_VALID_G120 = 'T';";
            
            var aResult_COM = GetDBDataSetEXT(sSQL, "VT_G120_M00268_" + sDB_Version +"_COM");
                    
            if (aResult_COM.length > 0)
            {
                ECL_DeactivateAllAttributeValues("PMD_ABU804_001_000_G120");
                
                for (var j=0; j<aResult_COM.length; j++){
                    var PMD_ABU804_001_000_G120 = aResult_COM[j].PMD_ABU804_001_000_G120;
                    ECL_ActivateValue("PMD_ABU804_001_000_G120", PMD_ABU804_001_000_G120);
                }
                if (ECL_GetValue("ECSI_CX_MotionControlRequirements") == 3) {
                    ECL_DeactivateValue("PMD_ABU804_001_000_G120", "00001");
                }
                ExecSetStandardifValueEmpty("PMD_ABU804_001_000_G120", "00002"); //ProfiNet
            }else{
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___COM_NO_DATA_G120") + " ";
            }
        }else{
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___COM_NO_DATA_G120") + " ";
        }
    }else{
        var aValidCUsForComunication = ECL_GetAllActiveAttributeValues("HMK_TYPE_CU_G120");
        
        
        if (aValidCUsForComunication.length > 0){
            var sWhere = "(HMK_TYPE_CU_G120 = '" + aValidCUsForComunication[0] + "'";
            
            for (var i=1; i<aValidCUsForComunication.length; i++){
                sWhere = sWhere + " OR HMK_TYPE_CU_G120 = '" + aValidCUsForComunication[i] + "'";
            }
            sWhere = sWhere + ") ";
            
            var sSQL = "SELECT DISTINCT PMD_ABU804_001_000_G120 FROM VT_G120_M00268_" + sDB_Version + " WHERE " + sWhere + "AND HMK_VALUE_VALID_G120 = 'T';";
            
            var aResult_COM = GetDBDataSetEXT(sSQL, "VT_G120_M00268_" + sDB_Version +"_COM");
                    
            if (aResult_COM.length > 0)
            {
                ECL_DeactivateAllAttributeValues("PMD_ABU804_001_000_G120");
                
                for (var j=0; j<aResult_COM.length; j++){
                    var PMD_ABU804_001_000_G120 = aResult_COM[j].PMD_ABU804_001_000_G120;
                    ECL_ActivateValue("PMD_ABU804_001_000_G120", PMD_ABU804_001_000_G120);
                }
                ExecSetStandardifValueEmpty("PMD_ABU804_001_000_G120", "00002"); //ProfiNet
            }else{
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___COM_NO_DATA_G120") + " ";
            }
        }else{
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___COM_NO_DATA_G120") + " ";
        }
    }
    
    // Wenn SIZER-Vorgabe, dann disable, sonst enable
    if (sFieldbusInterface == "" || sFieldbusInterface == undefined) 
    {
        ECL_EnableAttribute("PMD_ABU804_001_000_G120");
    }
    else 
    {
        ECL_DisableAttribute("PMD_ABU804_001_000_G120");
    }
    
    // #########################################################################################################################
    
    if (HMK_PRODUKT_TRIG_G120 == "G120"){	
        // #########################################################################################################################
        // Steuerung F-DI - HMK_DI_BERECHNET_G120 - TAK_AAN259_001_000_G120
        // #########################################################################################################################
        
        //* Wenn F-DI > 0, dann werden die DI's berechnet und ein Hilfsmerkmal wird angezeigt. Bei F-DI = 0 bleibt das normale Merkmal sichtbar
        var sF_DI = ECL_GetValue("HMK_F_DI_G120") || "";
        if (sF_DI == "00002" || sF_DI == "00003")
        {
            // VT_G120_M00135
            // HMK_F_DI_G120	TAK_AAN259_001_000_G120	HMK_DI_BERECHNET_G120	HMK_VALUE_VALID_G120
            simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00135" + sDB_Suffix,{
                inferenceType: VariantTables.Inference.RestrictNone,
                operators: {
                    "HMK_DI_BERECHNET_G120": {
                    inferenceType: VariantTables.Inference.RestrictAll
                    }
                }
            });
        }
        else 
        {
            ECL_SelectValue("HMK_DI_BERECHNET_G120", 0);
            ECL_SelectValue("HMK_F_DI_G120", "00001");
        }
        
        // #########################################################################################################################
        
        // #########################################################################################################################
        // Steuerung fehlerfreie DOs
        // #########################################################################################################################
        // VT_G120_M00154
        // HMK_F_DO_G120	HMK_TYPE_CU_G120	HMK_VALUE_VALID_G120
        simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00154" + sDB_Suffix,{
            inferenceType: VariantTables.Inference.RestrictNone,
            operators: {
                "HMK_F_DO_G120": {
                inferenceType: VariantTables.Inference.RestrictAll
                }
            }
        });
        
        // #########################################################################################################################
        
        
        // #########################################################################################################################
        // ProfiSafe Steuerung:
        // #########################################################################################################################
        /*
          c.HMK_PROFISAFE_G120 = '00002' IF
            c.HMK_TYPE_CU_G120 EQ '00085'
            OR c.HMK_TYPE_CU_G120 EQ '00086'
            OR c.HMK_TYPE_CU_G120 EQ '00088'
            OR c.HMK_TYPE_CU_G120 EQ '00089'
            OR c.HMK_TYPE_CU_G120 EQ '00994'
            OR c.HMK_TYPE_CU_G120 EQ '00995'
        */
        if (sCU == "00085" ||
            sCU == "00086" ||
            sCU == "00088" ||
            sCU == "00089" ||
            sCU == "00994" ||
            sCU == "00995" )
        {
            ECL_SelectValue("UI_HMK_PROFISAFE_G120", "T");
        }
        else
        {
            ECL_DeselectAttribute("UI_HMK_PROFISAFE_G120");
        }
        // #########################################################################################################################
    }	
    
    if (sCurrentAttribute == "HMK_TYPE_CU_G120"){
        // Busprotokoll passend selektieren
        var HMK_TYPE_CU_G120 = ECL_GetValue("HMK_TYPE_CU_G120");
        var aValidComForCU = ECL_GetAllActiveAttributeValues("PMD_ABU804_001_000_G120");
        
        var sSQL = "SELECT DISTINCT PMD_ABU804_001_000_G120 FROM VT_G120_M00268_" + sDB_Version + " WHERE " + 
                    "HMK_TYPE_CU_G120 = '" + HMK_TYPE_CU_G120 + "'";
                    "HMK_VALUE_VALID_G120 = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00268_" + sDB_Version +"_COM");
                
        if (aResult.length > 0)
        {
            //var PMD_ABU804_001_000_G120 = aResult[0].PMD_ABU804_001_000_G120;
            //ECL_SetValue("PMD_ABU804_001_000_G120", PMD_ABU804_001_000_G120);
            for (var i=0; i<aResult.length; i++){
                var PMD_ABU804_001_000_G120 = aResult[i].PMD_ABU804_001_000_G120;
                if (aValidComForCU.indexOf(PMD_ABU804_001_000_G120) > -1){
                    ECL_SetValue("PMD_ABU804_001_000_G120", PMD_ABU804_001_000_G120);
                    //ExecSetStandardifValueEmpty("PMD_ABU804_001_000_G120", PMD_ABU804_001_000_G120);
                    break;
                }
            }
        }else{
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___COM_NO_DATA_G120") + " ";
        }
    }

    
    
    // #########################################################################################################################
    // Steuerung Memorycard und Lizenzen E01, F01 in Abhängigkeit der CU - VT_G120_M00281_24213
    // #########################################################################################################################
    /*
    MemCard Pflicht bei E01-F01	10	SelCon	1	$root.HMK_F01_G120 EQ 'F01'
    MemCard Pflicht bei E01-F01	10	SelCon	2	OR $root.HMK_E01_G120 EQ 'E01'
    
    Bei CU 310 (PN, DP) --> mit Firmware
    */
    
    

    if (sCU !== "")
    {
        // VT_G120_M00281
        // HMK_TYPE_CU_G120	HMK_MEMORYCARD_G120	HMK_E01_G120	HMK_F01_G120	HMK_J01_G120	HMK_U01_G120	HMK_VALUE_VALID_G120
        // einmal ganz ohne Memorycard, damit LLizenzen nicht zugeschnürt werden
        var oAttributesMapping = {"HMK_MEMORYCARD_G120": null};
        simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00281" + sDB_Suffix,{
            inferenceType: VariantTables.Inference.RestrictAll,
            mapping: oAttributesMapping,
            operators: {
                "HMK_TYPE_CU_G120": {
                inferenceType: VariantTables.Inference.RestrictNone
                },
                "HMK_F01_G120": {
                inferenceType: VariantTables.Inference.RestrictIntersect
                },
                "HMK_VALUE_VALID_G120": {
                inferenceType: VariantTables.Inference.RestrictNone
                }
            }
        });
        
        // 	2022.03.21.
        //	DTK would disable "with firmware" option if sCU === 00089
        //	Additional requirement: Make "with firmware" available
        //	See PBI: 40651 on TFS
        
        if(sCU !== "00089")
        {
            // jetzt noch für Memorycard
            simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00281" + sDB_Suffix,{
                inferenceType: VariantTables.Inference.RestrictNone,
                operators: {
                    "HMK_MEMORYCARD_G120": {
                    inferenceType: VariantTables.Inference.RestrictAll
                    }
                }
            });
        }

        ExecSetStandardifValueEmpty("HMK_MEMORYCARD_G120", "00001");
        
        if(sCU === "00089")
        {
            ECL_ActivateValue("HMK_MEMORYCARD_G120", "00235");
        }
    }
    
    // VT_G120_M00185
    // HMK_MEMORYCARD_G120	HMK_MLFB_MEMORYCARD_G120	HMK_PRODUKT_TRIG_G120	HMK_VALUE_VALID_G120
    var oAttributesMapping = {"HMK_MLFB_MEMORYCARD_G120": null};
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00185" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        mapping: oAttributesMapping,
        operators: {
            "HMK_MEMORYCARD_G120": {
            inferenceType: VariantTables.Inference.RestrictIntersect
            }
        }
    });
    
    /*
    var sTarget = "HMK_MEMORYCARD_G120";
    var sTable = "VT_G120_M00185_24213";
    var sWhere = "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " +
                    "HMK_VALUE_VALID_G120 = 'T';";
    var sStatus = SetAttributeLogic2nd(sTable, sTarget, sWhere, "00001")
    
    if (sStatus == "Error"){
        // Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MEMORYCARD_NO_VALUES_G120") + " ";
    }
    */
    // Wenn CU == 00994 oder 00995 ==> Mit Firmware
    var HMK_TYPE_CU_G120 = ECL_GetValue("HMK_TYPE_CU_G120");
    
    if (HMK_TYPE_CU_G120 == "00994" || HMK_TYPE_CU_G120 == "00995"){
        ECL_ActivateValue("HMK_MEMORYCARD_G120", "00235");
        // ????
        ECL_ActivateValue("HMK_MEMORYCARD_G120", "00001");
    }
    
    // Stückliste VT_G120_M00280_24213
    var sMemoryCard = ECL_GetValue("HMK_MEMORYCARD_G120");
    determineFwVersionSpike(sECSI_MLFB_SEC);
    if (sMemoryCard == '00234' || sMemoryCard == '00235')
    {
        // Extension für Lizenzen:
        var sE01 = ECL_GetValue("HMK_E01_G120");
        var sF01 = ECL_GetValue("HMK_F01_G120");
        var sJ01 = ECL_GetValue("HMK_J01_G120");
        var sU01 = ECL_GetValue("HMK_U01_G120");
        
        var sSQL = "SELECT * FROM VT_G120_M00185_" + sDB_Version + " WHERE HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND HMK_MEMORYCARD_G120 = '" + sMemoryCard + "' AND HMK_VALUE_VALID_G120 = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_Speicherkarte = aResult[0].HMK_MLFB_MEMORYCARD_G120; 
            
            var sSQL_LicExt = "SELECT * FROM VT_G120_M00280_" + sDB_Version + " WHERE HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND HMK_MLFB_MEMORYCARD_G120 = '" + sMLFB_Speicherkarte + 
                                "' AND HMK_E01_G120 = '" + sE01 + "' AND HMK_F01_G120 = '" + sF01 + "' AND HMK_J01_G120 = '" + sJ01 + "' AND HMK_U01_G120 = '" + sU01 + "';"; 
            var aResult_LicExt = GetDBDataSetEXT(sSQL_LicExt, "VT_G120_M00280_" + sDB_Version );
            
            if (aResult_LicExt.length > 0)
            {
                var sMLFB_Speicherkarte = aResult_LicExt[0].MLFB_EXT_MEMORYCARD_G120; 
            }
            else
            {
                //Fehler: Keine Daten aus DB
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MEMORYCARD_MLFB_EXT_G120") + " "; //"Extension für MLFB für 'Speicherkarte' nicht bestimmt, kein Treffer in DB. ";
            }
            
            var ver = ECL_GetValue("FIRMWARE_VERSION_G120");
            var secMlfb = sECSI_MLFB_SEC;
            var a01 = ECL_GetValue("CB_ADVANCED_SAFETY_G120");
            var memoryCardMlfb = getMemoryCardMlfb(); // here we get a good MLFB for performance options
            
            if (sECSI_MLFB_SEC !== "")
            {
                if(memoryCardMlfb != 0 && sCurrentAttribute != "FIRMWARE_VERSION_G120" && sMemoryCard === "00234")
                {
                    sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_Speicherkarte;
                }
                else if(memoryCardMlfb != 0)
                {
                    sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + memoryCardMlfb + "_" +sE01+ "_" +sF01+ "_" +sJ01+ "_" +sU01;
                }
                
                else
                {
                    sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_Speicherkarte;
                }
            }
            else
            {
                if(memoryCardMlfb != 0 && sCurrentAttribute == "FIRMWARE_VERSION_G120")
                {
                    sECSI_MLFB_SEC = memoryCardMlfb + "_" +sE01+ "_" +sF01+ "_" +sJ01+ "_" +sU01;
                }
                else if(memoryCardMlfb != 0 && sCurrentAttribute != "FIRMWARE_VERSION_G120")
                {
                    sECSI_MLFB_SEC = memoryCardMlfb + "_" +sE01+ "_" +sF01+ "_" +sJ01+ "_" +sU01;
                }
                else
                {
                    sECSI_MLFB_SEC = sMLFB_Speicherkarte;
                }
            }
            //ECL_SelectValue("HMK_MEMORYCARD_G120", "00235");
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MEMORYCARD_MLFB_G120") + " "; //"MLFB für 'Speicherkarte' nicht bestimmt, kein Treffer in DB. ";
        }
        
        //CU-Auswahl einschränken
        // VT 193
        //HMK_TYPE_CU_G120	HMK_MEMORYCARD_G120		HMK_E01_G120	HMK_F01_G120	HMK_J01_G120	HMK_U01_G120	HMK_VALUE_VALID_G120
    }
    
    // #########################################################################################################################
    
    
    // #########################################################################################################################
    // EPOS Steuerung in Abhängigkeit von Lizenz:
    // #########################################################################################################################
    // siehe CU-Config
    // #########################################################################################################################
    
    
    
    
    // #########################################################################################################################
    // Safety Steuerung in Abhängigkeit von Lizenz:
    // #########################################################################################################################
    // siehe CU-Config
    // #########################################################################################################################
    
    // <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    // <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    // Stückliste (Sekundär-MLFBs)
    // <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    // <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    var sMLFB14 = ECL_GetValue("MLFB14_G120");
    
    sECSI_MLFB_SEC = GetMlfbSec() || "";

    var sPM_Type = ECL_GetValue("HMK_TYPE_PM_G120"); 
    var sBauform = ECL_GetValue("TAK_AAJ871_001_000_G120"); 
    var sMLFB_Key = ECL_GetValue("MLFB_KEY_G120");
    var sSchutzart = ECL_GetValue("PMD_ABJ176_001_000_G120");
    var sCU = ECL_GetValue("HMK_TYPE_CU_G120"); 
    var sFilterIntern = ECL_GetValue("PMD_AAD146_001_000_G120"); 
    var dNetzspannung = ECL_GetValue("PMD_ABU799_001_000_G120"); 

    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Control Unit
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    /* MLFBs CU VT_G120_M00078_24213 inner join VT188 
        HMK_MLFB_CONTROLUNIT_G120		HMK_TYPE_CU_G120						Produkttrigger
        6SL32430BB301PA3						00078   	CU230P-2 DP			G120
        6SL32430BB301HA3						00079	  	CU230P-2 HVAC		G120
        6SL32430BB301FA0						00080	 	CU230P-2 PN			G120
        6SL32440BB121BA1						00084	  	CU240E-2			G120
        6SL32440BB121PA1						00085	  	CU240E-2 DP			G120
        6SL32440BB131PA1						00086	  	CU240E-2 DP-F		G120
        6SL32440BB131BA1						00087	  	CU240E-2 F			G120
        6SL32440BB121FA0						00088	  	CU240E-2 PN			G120
        6SL32440BB131FA0						00089	  	CU240E-2 PN-F		G120
        6SL32460BA221BA0						00320	 	CU250S-2			G120
        6SL32460BA221PA0						00321	 	CU250S-2 DP			G120
        6SL32460BA221FA0						00322	 	CU250S-2 PN			G120
        6SL32460BA221CA0						00323	   	CU250S-2 CAN		G120
        
        6SL30400JA010AA0						00324		CU305 PN			S110
        6SL30400JA000AA0						00325		CU305 DP			S110
        
        6SL30401LA010AA0						00994		CU310-2 PN			S120
        6SL30401LA000AA0						00995		CU310-2 DP			S120
        6SL30400PA000AA1						00996		CUA31, CU Adapter	S120
        6SL30400PA010AA0						00997		CUA32, CU Adapter	S120
        
    */
    // HMK_MLFB_CONTROLUNIT_G120	HMK_TYPE_CU_G120	HMK_VALUE_VALID_G120
    // Stückliste
    if (sCU !== "") 
    {
        var sSQL = "SELECT HMK_MLFB_CONTROLUNIT_G120 FROM VT_G120_M00078_" + sDB_Version + " WHERE HMK_TYPE_CU_G120 = '" + sCU + "' AND HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00078_" + sDB_Version );
        if (aResult.length > 0)
        {
            var sMLFB_CU = aResult[0].HMK_MLFB_CONTROLUNIT_G120; 
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_CU;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_CU;
            }
            ECL_SetValue("ECSI_CC_ControlUnit", sMLFB_CU);
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___CU_MLFB_G120") + " "; //"MLFB für 'Control Unit' nicht bestimmt, kein Treffer in DB. ";
        }
    }	
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    var bCUA_Adapter = false;
    if (sCU == "00996" || sCU == "00997"){
        bCUA_Adapter = true;
    }
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Operator Panel
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // MLFB Panel aus VT_G120_M00243
        /*
        PMD_ABU803_001_000_G120	HMK_MLFB_PANEL_G120
        00073					6SL32550AA004CA1	BOP2
        00113					6SL32550AA004JA2	IOP2
        00114					6SL32550AA004JA0	ohne
        00116					6SL30550AA004BA0	BOP20
        */
    
    if (ECL_GetValue("HMK_IOP_HANDHELD_G120") == 'F') // nur wenn kein Handheld gewählt
    {
        var sOperatorPanel = ECL_GetValue("PMD_ABU803_001_000_G120");
        
        if (sOperatorPanel == "00073" || sOperatorPanel == "00113" || sOperatorPanel == "00116")
        {
            var sSQL = "SELECT * FROM VT_G120_M00243_" + sDB_Version + " WHERE PMD_ABU803_001_000_G120 = '" + sOperatorPanel + "' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0)
            {
                var sMLFB_OP_PANEL = aResult[0].HMK_MLFB_PANEL_G120; 
                
                if (sECSI_MLFB_SEC !== "")
                {
                    sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_OP_PANEL;
                }
                else
                {
                    sECSI_MLFB_SEC = sMLFB_OP_PANEL;
                }
            }
            else
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___OP_PANEL_MLFB_G120") + " "; //"MLFB für 'Operator Panel' nicht bestimmt, kein Treffer in DB. ";
            }
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // DigitalTwin
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    if (ECL_GetValue("HMK_DRIVESIM_DESIGNER_G120") == 'T') // nur wenn kein Handheld gewählt
    {
        var sSQL = "SELECT * FROM VT_G120_M00293_" + sDB_Version + " WHERE HMK_DRV_SIM_DESIGNER_G120 like '%T%' AND HMK_PRODUKT_TRIG_G120 = 'G120';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var mlfb_drive_sim = aResult[0].HMK_MLFB_DRV_SIM_DES_G120.trim(); 
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + mlfb_drive_sim;
            }
            else
            {
                sECSI_MLFB_SEC = mlfb_drive_sim;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___OP_PANEL_MLFB_G120") + " "; //"MLFB für 'Operator Panel' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    // Logik Panel, Handheld, Montagesatz
    
    // VT_G120_M00244
    // HMK_TYPE_CU_G120	PMD_ABU803_001_000_G120	HMK_IOP_HANDHELD_G120	PMD_ABU776_001_000_G120	HMK_HINWEIS_IOP_G120	HMK_VALUE_VALID_G120
    var oAttributesMapping = {"HMK_HINWEIS_IOP_G120": null};
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00244" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictAll,
        mapping: oAttributesMapping,
        operators: {
            "HMK_TYPE_CU_G120": {
            inferenceType: VariantTables.Inference.RestrictNone
            },
            "HMK_VALUE_VALID_G120": {
            inferenceType: VariantTables.Inference.RestrictNone
            }
        }
    });
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // IOP-Handheld
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // Wenn Handheld, dann wird IOP-2 gesetzt, MLFB nur Handheld!  --> Handheld übersteuert Bedienpanel
        /*
        HMK_IOP_HANDHELD_G120 = 'T'
        $self.MLFB_G120 = '6SL32550AA004HA1
        */
    
    if (ECL_GetValue("HMK_IOP_HANDHELD_G120") == "T") 
    {
        var sMLFB_Handheld = "6SL32550AA004HA1"; 
        
        if (sECSI_MLFB_SEC !== "")
        {
            sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_Handheld;
        }
        else
        {
            sECSI_MLFB_SEC = sMLFB_Handheld;
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // IOP Türmontagesatz
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        /*
        PMD_ABU776_001_000_G120 = 'T'
        MLFB_G120 = '6SL32560AP000JA0'
        */
    
    // Stückliste
    if (ECL_GetValue("PMD_ABU776_001_000_G120") == "T") 
    {
        var sMLFB_IOP_MOUNTING = "6SL32560AP000JA0"; 
        
        if (sECSI_MLFB_SEC !== "")
        {
            sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_IOP_MOUNTING;
        }
        else
        {
            sECSI_MLFB_SEC = sMLFB_IOP_MOUNTING;
        }
    }	
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //Speicherkarte			VT_G120_M00185_24213
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Logik:
    /* VT_G120_M00185_24213
    HMK_MEMORYCARD_G120	HMK_MLFB_MEMORYCARD_G120	HMK_PRODUKT_TRIG_G120	HMK_VALUE_VALID_G120
    */
    // VT_G120_M00281
    // HMK_TYPE_CU_G120	HMK_MEMORYCARD_G120	HMK_E01_G120	HMK_F01_G120	HMK_J01_G120	HMK_U01_G120	HMK_VALUE_VALID_G120
/*	simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00281" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        operators: {
            "HMK_MEMORYCARD_G120": {
            inferenceType: VariantTables.Inference.Restrictintersect
            }
        }
    });
    ExecSetStandardifValueEmpty("HMK_MEMORYCARD_G120", "00001");
*/	// Stückliste
    var sMemoryCard_Value = ECL_GetValue("HMK_MEMORYCARD_G120");
    if (sMemoryCard_Value == "00234" || sMemoryCard_Value == "00235")
    {
        var sSQL = 	"SELECT * FROM VT_G120_M00185_" + sDB_Version + " WHERE HMK_MEMORYCARD_G120 = '" + sMemoryCard_Value + "' AND HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND	HMK_VALUE_VALID_G120 = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_MEMORYCARD = aResult[0].HMK_MLFB_MEMORYCARD_G120; 
            
            // HMK_PRODUKT_TRIG_G120	HMK_MLFB_MEMORYCARD_G120	HMK_E01_G120	HMK_F01_G120	HMK_J01_G120	HMK_U01_G120	MLFB_EXT_MEMORYCARD_G120
            
            // MLFB + Extensions aus VT_G120_M00280_24213
            var sSQL = "SELECT * FROM VT_G120_M00280_" + sDB_Version + " WHERE HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND HMK_MLFB_MEMORYCARD_G120 = '" + sMLFB_MEMORYCARD + 
                        "' AND HMK_E01_G120 = '" + ECL_GetValue("HMK_E01_G120") + "' AND HMK_F01_G120 = '" + ECL_GetValue("HMK_F01_G120") + "' AND " + 
                        "HMK_J01_G120 = '" + ECL_GetValue("HMK_J01_G120") + "' AND HMK_U01_G120 = '" + ECL_GetValue("HMK_U01_G120") + "' ;";
            var aResult = GetDBDataSetEXT(sSQL);
            
            if (aResult.length > 0)
            {
                var sMLFB_MEMORYCARD_EXT = aResult[0].MLFB_EXT_MEMORYCARD_G120;
                // Kurzangaben für MLFB generieren
                var sKAG_E01 = "";
                var sKAG_F01 = "";
                var sKAG_J01 = "";
                var sKAG_U01 = "";
                var sKAGs = "";
                
                if (aResult[0].HMK_E01_G120 == "E01"){
                    sKAG_E01 = "E01";
                    sKAGs = "-Z " + sKAG_E01;
                }
                
                if (aResult[0].HMK_F01_G120 == "F01"){
                    // bei S120 prüfen, ob Advanced Safety gewählt, dann "A01" anstelle von F01!
                    if (HMK_PRODUKT_TRIG_G120 == "S120" && ECL_ValueSelected("CB_ADVANCED_SAFETY_G120", "T")){
                        sKAG_F01 = "A01";
                    }
                    else
                    {
                        sKAG_F01 = "F01";
                    }	
                    if (sKAGs == "")
                    {
                        sKAGs = "-Z " + sKAG_F01;
                    }
                    else
                    {
                        sKAGs = sKAGs + "+" + sKAG_F01;
                    }
                }
                
                if (aResult[0].HMK_J01_G120 == "J01"){
                    sKAG_J01 = "J01";
                    if (sKAGs == ""){
                        sKAGs = "-Z " + sKAG_J01;
                    }else{
                        sKAGs = sKAGs + "+" + sKAG_J01;
                    }
                }
                
                if (aResult[0].HMK_U01_G120 == "U01"){
                    sKAG_U01 = "U01";
                    if (sKAGs == ""){
                        sKAGs = "-Z " + sKAG_U01;
                    }else{
                        sKAGs = sKAGs + "+" + sKAG_U01;
                    }
                }
                var sMLFB_MEMORYCARD_KAG = sMLFB_MEMORYCARD + sKAGs;
                var ver = ECL_GetValue("FIRMWARE_VERSION_G120");
                var memoryCardMlfb = getMemoryCardMlfb();
                
                if (sECSI_MLFB_SEC !== "")
                {
                    if(memoryCardMlfb != 0 && sCurrentAttribute != "FIRMWARE_VERSION_G120" && sMemoryCard_Value === "00234")
                    {
                        sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_MEMORYCARD_KAG;
                    }
                    else if(memoryCardMlfb != 0 && sCurrentAttribute != "FIRMWARE_VERSION_G120")
                    {
                        sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + memoryCardMlfb + sKAGs;
                    }
                    else if(memoryCardMlfb != 0)
                    {
                        sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + memoryCardMlfb + sKAGs;
                    }
                    else
                    {
                        sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_MEMORYCARD_KAG;
                    }
                }
                else
                {
                    if(memoryCardMlfb != 0 && sCurrentAttribute == "FIRMWARE_VERSION_G120")
                    {
                        sECSI_MLFB_SEC = memoryCardMlfb + sKAGs;
                    }
                    else if(memoryCardMlfb != 0 && sCurrentAttribute != "FIRMWARE_VERSION_G120")
                    {
                        sECSI_MLFB_SEC = memoryCardMlfb + sKAGs;
                    }
                    else
                    {
                        sECSI_MLFB_SEC = sMLFB_MEMORYCARD_KAG;
                    }
                }
            }
            else
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MEMORYCARD_EXT_MLFB_G120") + " "; //"MLFB mit Extensions für 'Speicherkarte' nicht bestimmt, kein Treffer in DB. ";
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MEMORYCARD_MLFB_G120") + " "; //"MLFB für 'Speicherkarte' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // Lizenzen:
    // VT_G120_M00280_24213
    // // HMK_PRODUKT_TRIG_G120	HMK_MLFB_MEMORYCARD_G120	HMK_E01_G120	HMK_F01_G120	HMK_J01_G120	HMK_U01_G120	MLFB_EXT_MEMORYCARD_G120
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // UI_HMK_E01_G120		EPOS
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Wenn MotionControl=EPos, dann zwangsweise gesetzt
    
    var HMK_F01_G120 = ECL_GetValue("HMK_F01_G120");
    var HMK_J01_G120 = ECL_GetValue("HMK_J01_G120");
    var HMK_U01_G120 = ECL_GetValue("HMK_U01_G120");
    
    var sWhere = "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " +
                    "HMK_F01_G120 = '" + HMK_F01_G120 + "' AND " +
                    "HMK_J01_G120 = '" + HMK_J01_G120 + "' AND " +
                    "HMK_U01_G120 = '" + HMK_U01_G120 + "';";
    
    SetAttributeLogic1st("VT_G120_M00280_" + sDB_Version , "HMK_E01_G120", sWhere, "NON");
    
    var HMK_MEMORYCARD_G120 = ECL_GetValue("HMK_MEMORYCARD_G120");
    var HMK_TYPE_CU_G120 = ECL_GetValue("HMK_TYPE_CU_G120");
    // VT_G120_M00281_24213
    // 	HMK_TYPE_CU_G120	HMK_MEMORYCARD_G120	HMK_E01_G120	HMK_F01_G120	HMK_J01_G120	HMK_U01_G120	HMK_VALUE_VALID_G120
    
    var sWhere = "HMK_TYPE_CU_G120 = '" + HMK_TYPE_CU_G120 + "' AND " +
                    //"HMK_MEMORYCARD_G120 = '" + HMK_MEMORYCARD_G120 + "' AND " +
                    "HMK_F01_G120 = '" + HMK_F01_G120 + "' AND " +
                    "HMK_J01_G120 = '" + HMK_J01_G120 + "' AND " +
                    "HMK_U01_G120 = '" + HMK_U01_G120 + "' AND " +
                    "HMK_VALUE_VALID_G120 = 'T';";
    
    var sStatus = SetAttributeLogic2nd("VT_G120_M00281_" + sDB_Version , "HMK_E01_G120", sWhere, "NON");
    if (sStatus == "Error"){
        // Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___E01_NO_VALUES_G120") + " ";
    }
    
    if (sMotionControlReq !== "" && sMotionControlReq !== undefined && parseInt(sMotionControlReq) == 1 && HMK_PRODUKT_TRIG_G120 == "G120")
    {
        ECL_DeactivateValue("HMK_E01_G120", "NON");
        ECL_SetValue("HMK_E01_G120", "E01");
    }else{
        ECL_ActivateValue("HMK_E01_G120", "NON");
        ExecSetStandardifValueEmpty("HMK_E01_G120", "NON");
    }
    
    var HMK_E01_G120 = ECL_GetValue("HMK_E01_G120");
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // HMK_F01_G120		Safty
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    var sWhere = "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " +
                    "HMK_E01_G120 = '" + HMK_E01_G120 + "' AND " +
                    "HMK_J01_G120 = '" + HMK_J01_G120 + "' AND " +
                    "HMK_U01_G120 = '" + HMK_U01_G120 + "';";
    
    var sStatus = SetAttributeLogic2nd("VT_G120_M00280_" + sDB_Version , "HMK_F01_G120", sWhere, "NON");
    if (sStatus == "Error"){
        // Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___F01_NO_VALUES_G120") + " ";
    }
    var HMK_F01_G120 = ECL_GetValue("HMK_F01_G120");
    var aTestValisVal = ECL_GetAllActiveAttributeValues("HMK_F01_G120");
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // HMK_U01_G120		DCB Extension
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    var sWhere = "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " +
                    "HMK_E01_G120 = '" + HMK_E01_G120 + "' AND " +
                    "HMK_F01_G120 = '" + HMK_F01_G120 + "' AND " +
                    "HMK_J01_G120 = '" + HMK_J01_G120 + "';";
    
    var sStatus = SetAttributeLogic2nd("VT_G120_M00280_" + sDB_Version , "HMK_U01_G120", sWhere, "F");
    if (sStatus == "Error"){
        // Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___U01_NO_VALUES_G120") + " ";
    }
    
    var HMK_U01_G120 = ECL_GetValue("HMK_U01_G120");
    //setProductLogicToUIAttribute("HMK_U01_G120", "UI_HMK_U01_G120", "U01", "F");
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // HMK_J01_G120		Lizenz hohe Ausgangsfrequenz
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    var sWhere = "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " +
                    "HMK_E01_G120 = '" + HMK_E01_G120 + "' AND " +
                    "HMK_F01_G120 = '" + HMK_F01_G120 + "' AND " +
                    "HMK_U01_G120 = '" + HMK_U01_G120 + "';";
    
    var sStatus = SetAttributeLogic2nd("VT_G120_M00280_" + sDB_Version , "HMK_J01_G120", sWhere, "F");
    if (sStatus == "Error"){
        // Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___J01_NO_VALUES_G120") + " ";
    }
    
    var HMK_J01_G120 = ECL_GetValue("HMK_J01_G120");
    //setProductLogicToUIAttribute("HMK_J01_G120", "UI_HMK_J01_G120", "J01", "F");
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // CB_ADVANCED_SAFETY_G120		Advanced Safty													nur S120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Wählbar, wenn auch F01 wählbar ist
    
    var bF01_enabled = ECL_ValueEnabled("HMK_F01_G120", "F01");
    
    if (bF01_enabled){
        ECL_EnableAttribute("CB_ADVANCED_SAFETY_G120");
    }else{
        ECL_DisableAttribute("CB_ADVANCED_SAFETY_G120");
    }
    // Stücliste	
    
    if (ECL_ValueSelected("CB_ADVANCED_SAFETY_G120", "T")){
        // J01/U01 nicht erlaubt
        ECL_DeactivateValue("HMK_F01_G120", "NON");
        ECL_SetValue("HMK_F01_G120", "F01");
        
    }else{
        
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Smart Access Modul 	VT_G120_M00225_24213, VT_G120_M00226_24213									nur G120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // VT_G120_M00225_24213		MLFB Auswahl Stüli
    // HMK_SMART_ACCESS_G120	HMK_MLFB_SMARTACC_G120	HMK_VALUE_VALID_G120
    
    // VT_G120_M00226
    // HMK_TYPE_CU_G120	HMK_SMART_ACCESS_G120	HMK_VALUE_VALID_G120
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00226" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        operators: {
            "HMK_SMART_ACCESS_G120": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    
    // Stückliste
    if (ECL_GetValue("HMK_SMART_ACCESS_G120") == "T") 
    {
        var sSQL = "SELECT HMK_MLFB_SMARTACC_G120 FROM VT_G120_M00225_" + sDB_Version + " WHERE HMK_SMART_ACCESS_G120 = 'T' AND HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_SMART_ACCESS = aResult[0].HMK_MLFB_SMARTACC_G120; 
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_SMART_ACCESS;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_SMART_ACCESS;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SMART_ACCESS_MLFB_G120") + " "; //"MLFB für 'Webserver-Modul' nicht bestimmt, kein Treffer in DB. ";
        }
    }	
  
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // SINAMICS CONNECT 300 IoT Gateway			VT_G120_M00265_24213	HMK_CONNECT_300_G120				nur G120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //   HMK_PRODUKT_TRIG_G120	HMK_TYPE_CU_G120	HMK_CONNECT_300_G120	MLFB_CONNECT_300_G120	HMK_VALUE_VALID_G120
    
    // nur für G120
    if (HMK_PRODUKT_TRIG_G120 == "G120"){
        ECL_ActivateAttribute("UI_HMK_CONNECT_300_G120");
    }else{
        ECL_SetValue("HMK_CONNECT_300_G120", "F");
        ECL_DeselectValue("UI_HMK_CONNECT_300_G120", "T");
        ECL_DeactivateAttribute("UI_HMK_CONNECT_300_G120");
    }
    
    // Logik 
    var sSQL = "SELECT DISTINCT MLFB_CONNECT_300_G120 FROM VT_G120_M00265_" + sDB_Version + " WHERE " +
                "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND "+ 
                "HMK_TYPE_CU_G120 = '" + sCU + "' AND "+ 
                "HMK_CONNECT_300_G120 = 'T' AND "+ 
                "HMK_VALUE_VALID_G120 = 'T';"; 
    var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00265_" + sDB_Version );
    
    if (aResult.length > 0){
        ECL_ActivateValue("HMK_CONNECT_300_G120", "T");
    }else{
        ECL_DeactivateValue("HMK_CONNECT_300_G120", "T");
        ECL_SetValue("HMK_CONNECT_300_G120", "F");
        ECL_DeselectValue("UI_HMK_CONNECT_300_G120", "T");
    }
    
    // Stückliste
    if (ECL_GetValue("HMK_CONNECT_300_G120") == "T") 
    {
        if (aResult.length > 0){
            var sMLFB_CONNECT_300 = aResult[0].MLFB_CONNECT_300_G120;
            
            // Sekundär-MLFB Eintrag
            if (sECSI_MLFB_SEC !== ""){
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_CONNECT_300;
            }else{
                sECSI_MLFB_SEC = sMLFB_CONNECT_300;
            }
        }else{
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___CONNECT_300_MLFB_G120") + " "; //"MLFB für 'Webserver-Modul' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Control Unit Adapter Kit CUA20 	HMK_ADAPT_KIT_CUA20_G120			 	VT_G120_M00261_24213
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // VT_G120_M00262
    // HMK_PRODUKT_TRIG_G120	HMK_ADAPT_KIT_CUA20_G120	HMK_VALUE_VALID_G120	
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00262" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        operators: {
            "HMK_ADAPT_KIT_CUA20_G120": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    
    // VT_G120_M00261
    // HMK_TYPE_PM_G120		HMK_TYPE_CU_G120	HMK_ADAPT_KIT_CUA20_G120	HMK_MLFB_ADKIT_CUA20_G120	HMK_VALUE_VALID_G120
    var oAttributesMapping = {"HMK_MLFB_ADKIT_CUA20_G120": null};
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00261" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        mapping: oAttributesMapping,
        operators: {
            "HMK_ADAPT_KIT_CUA20_G120": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    
    // Stückliste
    if (ECL_GetValue("HMK_ADAPT_KIT_CUA20_G120") == "T") 
    {
        
        
        var sSQL = "SELECT HMK_MLFB_ADKIT_CUA20_G120 FROM VT_G120_M00261_" + sDB_Version + " WHERE " +
                    "HMK_TYPE_PM_G120 = '" + ECL_GetValue("HMK_TYPE_PM_G120") + "' AND " +
                    "HMK_TYPE_CU_G120 = '" + ECL_GetValue("HMK_TYPE_CU_G120") + "' AND " +
                    "HMK_ADAPT_KIT_CUA20_G120 = 'T' AND HMK_VALUE_VALID_G120 = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, "HMK_MLFB_ADKIT_CUA20_G120");
        if (aResult.length > 0)
        {
            var HMK_MLFB_ADKIT_CUA20_G120 = aResult[0].HMK_MLFB_ADKIT_CUA20_G120; 
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + HMK_MLFB_ADKIT_CUA20_G120;
            }
            else
            {
                sECSI_MLFB_SEC = HMK_MLFB_ADKIT_CUA20_G120;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___CU_ADAPTER_KIT_MLFB_G120") + " "; //"MLFB für 'Control Unit Adapter Kit' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Umrichter-Verbindungssatz (PC oder Handheld)
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    if (ECL_GetValue("PMD_ABU783_001_000_G120") == "T") 
    {
        var sMLFB_UMRICHTER_SATZ = "6SL32550AA002CA0"; 
        
        if (sECSI_MLFB_SEC !== "")
        {
            sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_UMRICHTER_SATZ;
        }
        else
        {
            sECSI_MLFB_SEC = sMLFB_UMRICHTER_SATZ;
        }
    }	
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // NEMA-Kit	   VT_G120_M00245_24213
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // NEMA-Kit Logik: 
    // VT_G120_M00245 (ZO PM, Bauform, Push-Through
    //	HMK_TYPE_PM_G120	HMK_PUSH_THROUGH_G120	TAK_AAJ871_001_000_G120	HMK_MLFB_NEMA_KIT_1002980	HMK_NEMA_KIT_G120
    var oAttributesMapping = {"HMK_MLFB_NEMA_KIT_1002980": null};
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00245" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        mapping: oAttributesMapping,
        operators: {
            "HMK_NEMA_KIT_G120": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    
    // Stückliste
    if ( (ECL_GetValue("HMK_NEMA_KIT_G120") == "T") && (sPM_Type !== "")
    ) {
        var sSQL = "SELECT * FROM VT_G120_M00245_" + sDB_Version + " WHERE HMK_NEMA_KIT_G120 = 'T' AND HMK_TYPE_PM_G120 = '" + sPM_Type + "' AND TAK_AAJ871_001_000_G120 = '" + sBauform + "';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_NEMA_KIT = aResult[0].HMK_MLFB_NEMA_KIT_1002980; 
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_NEMA_KIT;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_NEMA_KIT;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___NEMA_KIT_MLFB_G120") + " "; //"MLFB für 'NEMA-Kit' nicht bestimmt, kein Treffer in DB. ";
        }
    }	
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Schirmanschlusssatz Control Unit   HMK_SCHIRMANSCHL_CU_G120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // HMK_TYPE_CU_G120	HMK_SCHIRMANSCHL_CU_G120	HMK_MLFB_SCHIRM_CU_G120	HMK_VALUE_VALID_G120
    
    // Stückliste
    if ( (ECL_GetValue("HMK_SCHIRMANSCHL_CU_G120") == "T") && (sCU !== "")
    ) {
        var sSQL = "SELECT * FROM VT_G120_M00142_" + sDB_Version + " WHERE HMK_SCHIRMANSCHL_CU_G120 = 'T' AND HMK_TYPE_CU_G120 = '" + sCU + "' AND HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_SCHIRMANSCHL_CU = aResult[0].HMK_MLFB_SCHIRM_CU_G120; 
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_SCHIRMANSCHL_CU;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_SCHIRMANSCHL_CU;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SCHIRMANSCHL_CU_MLFB_G120") + " "; //"MLFB für 'Schirmanschlusssatz Control Unit' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // DSEE - Drive Service Extended Exchange	PM	VT_G120_M00254_24213										nur G120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /**
    Logik
    VT254 ZO PM-DSEE
    VT255 ZO CU-DSEE
    VT256 ZO DSEE PM - Produkttrig			nicht nötig, keine Einschränkung für G120	Erweiterung S110, S120 nur OHNE
    VT257 ZO DSEE CU - Produkttrig			nicht nötig, keine Einschränkung für G120	Erweiterung S110, S120 nur OHNE
    */
    
    //Logik:
    if (HMK_PRODUKT_TRIG_G120 == "G120"){
        // VT_G120_M00254
        //	MLFB_KEY_G120	MLFB14_G120	HMK_DSEE_PM_G120	HMK_MLFB_DSEE_PM_G120	HMK_VALUE_VALID_G120
        var oAttributesMapping = {"HMK_MLFB_DSEE_PM_G120": null};
        simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00254" + sDB_Suffix,{
            inferenceType: VariantTables.Inference.RestrictNone,
            mapping: oAttributesMapping,
            operators: {
                "HMK_DSEE_PM_G120": {
                inferenceType: VariantTables.Inference.RestrictAll
                }
            }
        });
    }
    else{
        ECL_DeactivateAllAttributeValues("HMK_DSEE_PM_G120");
        ECL_ActivateValue("HMK_DSEE_PM_G120", "OHNE");
        ECL_SetValue("HMK_DSEE_PM_G120", "OHNE");
    }
    // Wenn Filter intern geändert, prüfen, ob DSEE noch verwendet werden darf
/*	if (sCurrentAttribute == "PMD_AAD146_001_000_G120"){
        // VT_G120_M00254_24213
        // MLFB_KEY_G120	MLFB14_G120	HMK_DSEE_PM_G120	HMK_MLFB_DSEE_PM_G120	HMK_VALUE_VALID_G120
        var MLFB14_G120 = sECSI_MLFB.charAt(13);
        var MLFB_KEY_G120 = ECL_GetValue("MLFB_KEY_G120");
        
        var sSQL =  "SELECT DISTINCT HMK_DSEE_PM_G120 FROM VT_G120_M00255_24213 WHERE " +
                    "MLFB_KEY_G120 = '" + MLFB_KEY_G120 + "' AND " +
                    "MLFB14_G120 = '" + MLFB14_G120 + "' AND " +
                    "HMK_VALUE_VALID_G120 = 'T';";
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length > 0){
        
        
    }
*/	
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // DSEE - Drive Service Extended Exchange CU		VT_G120_M00255_24213										nur G120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /**
    Logik
    VT254 ZO PM-DSEE
    VT255 ZO CU-DSEE
    VT256 ZO DSEE PM - Produkttrig
    VT257 ZO DSEE CU - Produkttrig
    */
    var HMK_MLFB_CONTROLUNIT_G120 = sMLFB_CU;
    
    //Logik:
    var sSQL =  "SELECT DISTINCT HMK_DSEE_CU_G120 FROM VT_G120_M00255_" + sDB_Version + " WHERE " +
                    "HMK_MLFB_CONTROLUNIT_G120 = '" + HMK_MLFB_CONTROLUNIT_G120 + "' AND " +
                    "HMK_VALUE_VALID_G120 = 'T';";
    
    ECL_DeactivateAllAttributeValues("HMK_DSEE_CU_G120");
    ECL_ActivateValue("HMK_DSEE_CU_G120", "OHNE");
    
    if (HMK_PRODUKT_TRIG_G120 == "G120"){
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length > 0){
            
            for(var i = 0; i < aResult.length; i++){
                var HMK_DSEE_CU_G120 = aResult[i].HMK_DSEE_CU_G120;
                ECL_ActivateValue("HMK_DSEE_CU_G120", HMK_DSEE_CU_G120);
            }
        }
        var aValidValues_DSEE_CU = ECL_GetAllActiveAttributeValues("HMK_DSEE_CU_G120");
        var aValidValues_DSEE_PM = ECL_GetAllActiveAttributeValues("HMK_DSEE_PM_G120");
        
        if (sCurrentAttribute == "HMK_DSEE_CU_G120"){
            var sDSEE = ECL_GetValue("HMK_DSEE_CU_G120");
            if (aValidValues_DSEE_PM.indexOf(sDSEE) > -1){
                ECL_SelectValue("HMK_DSEE_PM_G120", sDSEE);
            }
        }else if (sCurrentAttribute == "HMK_DSEE_PM_G120"){
            var sDSEE = ECL_GetValue("HMK_DSEE_PM_G120");
            if (aValidValues_DSEE_CU.indexOf(sDSEE) > -1){
                ECL_SelectValue("HMK_DSEE_CU_G120", sDSEE);
            }
        }
    }else{
        ECL_SetValue("HMK_DSEE_CU_G120", "OHNE");
    }
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // DSEE - Drive Service Extended Exchange	PM	VT_G120_M00254_24213											nur G120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Stückliste
    var sDSEE_PM = ECL_GetValue("HMK_DSEE_PM_G120");
    
    if ( (sDSEE_PM == "DSEE3") || (sDSEE_PM == "DSEE5") // nicht 'OHNE'
    ) {
        var MLFB14_G120 = sECSI_MLFB.charAt(13);
        var MLFB_KEY_G120 = ECL_GetValue("MLFB_KEY_G120");
        
        // VT_G120_M00254_24213
        // MLFB_KEY_G120	MLFB14_G120	HMK_DSEE_PM_G120	HMK_MLFB_DSEE_PM_G120	HMK_VALUE_VALID_G120
        
        var sSQL = "SELECT * FROM VT_G120_M00254_" + sDB_Version + " WHERE " +
                    "MLFB_KEY_G120 = '" + MLFB_KEY_G120 + "' AND " +
                    "MLFB14_G120 = '" + MLFB14_G120 + "' AND " +
                    "HMK_DSEE_PM_G120 = '" + sDSEE_PM + "' AND " +
                    "HMK_VALUE_VALID_G120 = 'T';";
        
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_DSEE_PM_G120 = aResult[0].HMK_MLFB_DSEE_PM_G120; 
            
            if (sECSI_MLFB_SEC.length > 0)
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_DSEE_PM_G120;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_DSEE_PM_G120;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DSEE_PM_MLFB_G120") + " "; // "MLFB für 'DSEE' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // DSEE - Drive Service Extended Exchange CU		VT_G120_M00255_24213									nur G120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Stückliste
    var sDSEE_CU = ECL_GetValue("HMK_DSEE_CU_G120");
    
    if ( (sDSEE_CU == "DSEE3") || (sDSEE_CU == "DSEE5") // nicht 'OHNE'
    ) {
        var sMLFB11 = sECSI_MLFB.charAt(10);
        var sMLFB12 = sECSI_MLFB.charAt(11);
        var sMLFB13 = sECSI_MLFB.charAt(12);
        var sMLFB15 = sECSI_MLFB.charAt(14);
        var sMLFB16 = sECSI_MLFB.charAt(15);
        
        // VT_G120_M00255_24213
        // HMK_MLFB_CONTROLUNIT_G120	HMK_DSEE_CU_G120	HMK_MLFB_DSEE_CU_G120	HMK_VALUE_VALID_G120
        
        var sSQL = "SELECT * FROM VT_G120_M00255_" + sDB_Version + " WHERE " +
                    "HMK_MLFB_CONTROLUNIT_G120 = '" + HMK_MLFB_CONTROLUNIT_G120 + "' AND " +
                    "HMK_DSEE_CU_G120 = '" + sDSEE_CU + "' AND " +
                    "HMK_VALUE_VALID_G120 = 'T';";
        
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_DSEE_CU_G120 = aResult[0].HMK_MLFB_DSEE_CU_G120; 
            
            if (sECSI_MLFB_SEC.length > 0)
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_DSEE_CU_G120;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_DSEE_CU_G120;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DSEE_CU_MLFB_G120") + " "; // "MLFB für 'DSEE' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // DSA - Drive Service Agreement 'DSA'		VT_G120C_M00086_17984											n.n.
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ECL_DeactivateAttribute("HMK_DSA_G120");
/*	Keine Daten in DB
    var sDSA		= ECL_GetValue("HMK_DSA_G120");
    
    if (sDSA == "FUND") || (sDSA == "EXTENDED") // nicht 'OHNE'
    {
        // HMK_DSA_G120	HMK_MLFB_DSA_G120	HMK_VALUE_VALID_G120C
        var sSQL = "SELECT * FROM VT_G120C_M00086_17984 WHERE " +
                    "HMK_DSA_G120 = '" + sDSA + "' AND " +
                    "HMK_VALUE_VALID_G120C = 'T';";
        
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_DSA_G120 = aResult[0].HMK_MLFB_DSA_G120; 
            
            if (sECSI_MLFB_SEC.length > 0)
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_DSA_G120;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_DSA_G120;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DSA_MLFB_G120") + " "; // "MLFB für 'DSA' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    */
 
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Inbetriebnahme-Tool STARTER		6SL30720AA000AG0															nur S110
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //HMK_TOOL_STARTER_G120	
    // Logik: keine
    if (HMK_PRODUKT_TRIG_G120 == "S110"){
        ECL_ActivateValue("HMK_TOOL_STARTER_G120", "T");
    }else{
        ECL_DeactivateValue("HMK_TOOL_STARTER_G120", "T");
        ECL_SetValue("HMK_TOOL_STARTER_G120", "F");
    }
    // Stückliste
    if (ECL_GetValue("HMK_TOOL_STARTER_G120") == "T") 
    {
        var sMLFB_TOOL_STARTER = "6SL30720AA000AG0"; 
        
        if (sECSI_MLFB_SEC !== "")
        {
            sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_TOOL_STARTER;
        }
        else
        {
            sECSI_MLFB_SEC = sMLFB_TOOL_STARTER;
        }
    }else{
        ECL_SetValue("HMK_TOOL_STARTER_G120", "F");
        // Deactivate s. unten.
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Sensor Module Cabinet-Mounted		HMK_SENSORMODULE_G120										nicht G120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /*
    $root.HMK_SENSORMODULE_G120 specified and
    $root.HMK_SENSORMODULE_G120 ne '00004'
    *MLFB
    $self.MLFB_G120 = '6SL30550AA005AA3'
       if $root.HMK_SENSORMODULE_G120 = '00001',
    $self.MLFB_G120 = '6SL30550AA005BA3'
       if $root.HMK_SENSORMODULE_G120 = '00002',
    $self.MLFB_G120 = '6SL30550AA005CA2'
       if $root.HMK_SENSORMODULE_G120 = '00003'

    
    * /
    EDIT 2021.06 TFS 5620128 Removesensor modules from FC												  
    if (HMK_PRODUKT_TRIG_G120 == "S110" || HMK_PRODUKT_TRIG_G120 == "S120"){
        // Logik:
        // keine!
        ECL_ActivateAllAttributeValues("HMK_SENSORMODULE_G120");
        
        // Stückliste
        var HMK_SENSORMODULE_G120 = ECL_GetValue("HMK_SENSORMODULE_G120");
        
        if (HMK_SENSORMODULE_G120 != "00004") // nicht 'OHNE'
        {
            switch (HMK_SENSORMODULE_G120){
                case "00001":
                    var sMLFB_SENSORMODULE = "6SL30550AA005AA3";
                break;
                case "00002":
                    var sMLFB_SENSORMODULE = "6SL30550AA005BA3";
                break;
                case "00003":
                    var sMLFB_SENSORMODULE = "6SL30550AA005CA2";
                break;
                
                default: 
                    var sMLFB_SENSORMODULE = "";
            }
            
            if (sMLFB_SENSORMODULE != ""){
                if (sECSI_MLFB_SEC.length > 0){
                    sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_SENSORMODULE;
                }else{
                    sECSI_MLFB_SEC = sMLFB_SENSORMODULE;
                }
            }else{
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SENSORMODULE_MLFB_G120") + " "; // "MLFB für 'DSEE' nicht bestimmt, kein Treffer in DB. ";
            }
        }
    }else{
        ECL_DeactivateAllAttributeValues("HMK_SENSORMODULE_G120");
        ECL_ActivateValue("HMK_SENSORMODULE_G120", "00004");
        ECL_SetValue("HMK_SENSORMODULE_G120", "00004");
        // Deactivate s. unten.
    }
    */
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    ECL_SetValue("ECSI_CC_BrakeRelays", "");
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Brake Relay HMK_BRAKERELAY_G120  6SL32520BB000AA0   														nicht S110
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // VT_G120_M00240_24213
    // TAK_AAJ871_001_000_G120	HMK_MLFB_BRAKEREL_G120	HMK_BRAKERELAY_G120
    
    if (HMK_PRODUKT_TRIG_G120 == "S110"){
        ECL_DeactivateValue("HMK_BRAKERELAY_G120", "T");
        ECL_SetValue("HMK_BRAKERELAY_G120", "F");
    }else{
        // VT_G120_M00240
        //	TAK_AAJ871_001_000_G120	HMK_MLFB_BRAKEREL_G120	HMK_BRAKERELAY_G120
        var oAttributesMapping = {"HMK_MLFB_BRAKEREL_G120": null};
        simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00240" + sDB_Suffix,{
            inferenceType: VariantTables.Inference.RestrictNone,
            mapping: oAttributesMapping,
            operators: {
                "HMK_BRAKERELAY_G120": {
                inferenceType: VariantTables.Inference.RestrictAll
                }
            }
        });
    }
    
    // Stückliste
    if (ECL_GetValue("HMK_BRAKERELAY_G120") == "T")       
    {
        var sMLFB_BRAKERELAY = "6SL32520BB000AA0"; 
        
        if (sECSI_MLFB_SEC !== "")
        {
            sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_BRAKERELAY;
        }
        else
        {
            sECSI_MLFB_SEC = sMLFB_BRAKERELAY;
        }
        ECL_SetValue("ECSI_CC_BrakeRelays", sMLFB_BRAKERELAY);
    }
    
    
    // ---------------------------------------------------------------------------------
    // CONSEQUENSES
    // ---------------------------------------------------------------------------------
    // BrakeRelays
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // Brake Relay vs Safe Brake Relay - entweder-oder
    
    // VT_G120_M00218
    //	HMK_BRAKERELAY_G120	HMK_SAFEBRAKERELAY_G120
    //var oAttributesMapping = {"MLFB_BREMSMODUL_G120": null};
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00218" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictALL
        //mapping: oAttributesMapping,
        /*operators: {
            "HMK_BRAKEMODULE_G120": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }*/
    });
        
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Safe Brake Relay   VT_G120_M00237_24213 6SL32520BB010AA0 												alle
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // TAK_AAJ871_001_000_G120	HMK_MLFB_SAFEBRAKER_G120	HMK_SAFEBRAKERELAY_G120

    // Stückliste
    if (ECL_GetValue("HMK_SAFEBRAKERELAY_G120") == "T") 
    {
        //var sMLFB_SAFEBRAKER = "6SL32520BB010AA0"; 
        // aus VT:
        var sSQL = "SELECT DISTINCT HMK_MLFB_SAFEBRAKER_G120 FROM VT_G120_M00237_" + sDB_Version + " WHERE " +
                    "TAK_AAJ871_001_000_G120 = '" + sBauform + "' AND " +
                    "HMK_SAFEBRAKERELAY_G120 = 'T';";
        
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_SAFEBRAKER = aResult[0].HMK_MLFB_SAFEBRAKER_G120; 
            
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_SAFEBRAKER;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_SAFEBRAKER;
            }
            ECL_SetValue("ECSI_CC_BrakeRelays", sMLFB_SAFEBRAKER);
        }else{
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SAFE_BRAKE_RELAY_MLFB_G120") + " "; 
        }
    }
    // ---------------------------------------------------------------------------------
    // CONSEQUENSES
    // ---------------------------------------------------------------------------------
    // BrakeRelays s.o.
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Bremswiderstand   VT_G120_M00173_24213																	alle
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // MLFB_KEY_G120	HMK_BRAKERESISTOR_G120	MLFB_BREMSWIDERSTAND_G120	HMK_VALUE_VALID_G120
    
    // Logik:
    /* EDIT 06.2020: Wert "CUSTOM" ergänzt
        UI_HMK_BRAKERESISTOR_G120
        Ja, Nein, Custom
        
        HMK_BRAKERESISTOR_G120
        ja, nein	custom = nein
    */
    // Custom Brake resistor only for G120, not for S110, S120!
    // Edit 10.2020: jetzt auch für S120, S110
    /*if (HMK_PRODUKT_TRIG_G120 == "G120"){
        ECL_ActivateValue("UI_HMK_BRAKERESISTOR_G120", "CUSTOM");
    }else
    {
        ECL_DeactivateValue("UI_HMK_BRAKERESISTOR_G120", "CUSTOM");
    }*/
    
    // VT_G120_M00220_24213 gibt es seit 24.07.2019 nicht mehr!
    // TAK_AAJ871_001_000_G120	PMD_ABU799_001_000_G120	HMK_BRAKERESISTOR_G120	HMK_BRAKEMODULE_G120	HMK_VALUE_VALID_G120
    if (sStatusBR == "ohne"){
        
        var sSQL = "SELECT * FROM VT_G120_M00173_" + sDB_Version + " WHERE HMK_BRAKERESISTOR_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            ECL_ActivateValue("HMK_BRAKERESISTOR_G120", "T");
            
        }
        else
        {
            ECL_DeactivateValue("HMK_BRAKERESISTOR_G120", "T");
            ECL_ActivateValue("HMK_BRAKERESISTOR_G120", "F");
            ECL_SelectValue("HMK_BRAKERESISTOR_G120", "F");
        }
    //}	
        
        //Übertragung UI-Merkmal in HMK und umgekehrt
        var aValidValuesBrakeResistor = ECL_GetAllActiveAttributeValues("HMK_BRAKERESISTOR_G120");
        var bValue_T_valid = false;
        var bValue_F_valid = false;
        
        if (aValidValuesBrakeResistor.length > 0){
            for (var i=0; i < aValidValuesBrakeResistor.length; i++){
                if (aValidValuesBrakeResistor[i] == "T"){
                    bValue_T_valid = true;
                }
                if (aValidValuesBrakeResistor[i] == "F"){
                    bValue_F_valid = true;
                }
            }
            
            if (bValue_T_valid){
                ECL_ActivateValue("UI_HMK_BRAKERESISTOR_G120", "T");
            }else{
                ECL_DeactivateValue("UI_HMK_BRAKERESISTOR_G120", "T");
            }
            if (bValue_F_valid){
                ECL_ActivateValue("UI_HMK_BRAKERESISTOR_G120", "F");
            }else{
                ECL_DeactivateValue("UI_HMK_BRAKERESISTOR_G120", "F");
            }
        }else{
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___BRAKERESISTOR_NO_VAL_G120") + " "; 
        }
    }
    var UI_HMK_BRAKERESISTOR_G120 = ECL_GetValue("UI_HMK_BRAKERESISTOR_G120");
    if (UI_HMK_BRAKERESISTOR_G120 == "T"){
        ECL_SetValue("HMK_BRAKERESISTOR_G120", "T");
    }else{
        ECL_SetValue("HMK_BRAKERESISTOR_G120", "F");
    }
    
    // Stückliste
    if (ECL_GetValue("HMK_BRAKERESISTOR_G120") == "T") 
    {
        var sSQL = "SELECT * FROM VT_G120_M00173_" + sDB_Version + " WHERE HMK_BRAKERESISTOR_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_BRAKERESISTOR = aResult[0].MLFB_BREMSWIDERSTAND_G120; 
            sMLFB_BRAKERESISTOR = sMLFB_BRAKERESISTOR.replace(/\s+/g, ""); // Leerzeichen entfernen
            sMLFB_BRAKERESISTOR = sMLFB_BRAKERESISTOR.replace("-", ""); // Bindestriche entfernen
            // Consequences
            ECL_SetValue("ECSI_CC_BrakingResistorID", sMLFB_BRAKERESISTOR);
            ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "False");
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_BRAKERESISTOR;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_BRAKERESISTOR;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___BRAKERESISTOR_MLFB_G120") + " "; //"MLFB für 'Bremswiderstand' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    else{
        var UI_HMK_BRAKERESISTOR_G120 = ECL_GetValue("UI_HMK_BRAKERESISTOR_G120");
        
        if (ECL_GetValue("UI_HMK_BRAKERESISTOR_G120") == "CUSTOM"){
            ECL_SetValue("ECSI_CC_BrakingResistorID", "Custom");
            ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "True");
        }else{
            ECL_SetValue("ECSI_CC_BrakingResistorID", "");
            ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "False");
        }
    }
    // ---------------------------------------------------------------------------------
    // CONSEQUENSES
    // ---------------------------------------------------------------------------------
    // BrakingResistorID s.o.
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Bremsmodul   																							nur S120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // todo
    // UI_HMK_BRAKEMODULE_G120		Bremsmodul
    //setProductLogicToUIAttribute("HMK_BRAKEMODULE_G120", "UI_HMK_BRAKEMODULE_G120", "T", "F");
    /* VT_G120_M00247_24213
        MLFB_KEY_G120	HMK_BRAKEMODULE_G120	MLFB_BREMSMODUL_G120	HMK_VALUE_VALID_G120

    */
    if (HMK_PRODUKT_TRIG_G120 == "S120"){
        
        // VT_G120_M00247
        //	MLFB_KEY_G120	HMK_BRAKEMODULE_G120	MLFB_BREMSMODUL_G120	HMK_VALUE_VALID_G120
        var oAttributesMapping = {"MLFB_BREMSMODUL_G120": null};
        simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00247" + sDB_Suffix,{
            inferenceType: VariantTables.Inference.RestrictNone,
            mapping: oAttributesMapping,
            operators: {
                "HMK_BRAKEMODULE_G120": {
                inferenceType: VariantTables.Inference.RestrictAll
                }
            }
        });
    }
    else{
        ECL_DeactivateValue("HMK_BRAKEMODULE_G120", "T");
        ECL_SetValue("HMK_BRAKEMODULE_G120", "F");
    }
    // Stückliste
    if (ECL_GetValue("HMK_BRAKEMODULE_G120") == "T") 
    {
        var sSQL = "SELECT DISTINCT MLFB_BREMSMODUL_G120 FROM VT_G120_M00247_" + sDB_Version + " WHERE HMK_BRAKEMODULE_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var MLFB_BREMSMODUL_G120 = aResult[0].MLFB_BREMSMODUL_G120; 
            //sMLFB_BRAKERESISTOR = sMLFB_BRAKERESISTOR.replace(/\s+/g, ""); // Leerzeichen entfernen
            //sMLFB_BRAKERESISTOR = sMLFB_BRAKERESISTOR.replace("-", ""); // Bindestriche entfernen
            // Consequences
            ECL_SetValue("ECSI_CC_BrakingModuleID", MLFB_BREMSMODUL_G120);
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + MLFB_BREMSMODUL_G120;
            }
            else
            {
                sECSI_MLFB_SEC = MLFB_BREMSMODUL_G120;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___BRAKEMODULE_MLFB_G120") + " "; //"MLFB für 'Bremsmodul' nicht bestimmt, kein Treffer in Datenbank. ";
        }
    }
    else{
        ECL_SetValue("ECSI_CC_BrakingModuleID", "");
    }
    
    // ---------------------------------------------------------------------------------
    // CONSEQUENSES
    // ---------------------------------------------------------------------------------
    // BrakingModuleID s.o.
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Externer Netzfilter    VT_G120_M00158_24213																	alle
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // zusätzlich Klasse A intern "00149" für PM = Chassis bei S120
    
    // MLFB_KEY_G120	HMK_NETZFILTER_EXT_G120	HMK_MLFB_NETFILTER_G120	HMK_VALUE_VALID_G120
    //var aAttributesVT158 = ["MLFB_KEY_G120", "HMK_NETZFILTER_EXT_G120",	"HMK_VALUE_VALID_G120"];
    //ECL_InferencePositiveValues("VT_G120_M00158_24213", "HMK_NETZFILTER_EXT_G120", aAttributesVT158);
    if (HMK_PRODUKT_TRIG_G120 == "S120"){
        var sSQL = "SELECT DISTINCT HMK_NETZFILTER_EXT_G120 FROM VT_G120_M00158_" + sDB_Version + " WHERE (HMK_NETZFILTER_EXT_G120 = '00149' OR HMK_NETZFILTER_EXT_G120 = '00150') AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
    }else{
        var sSQL = "SELECT DISTINCT HMK_NETZFILTER_EXT_G120 FROM VT_G120_M00158_" + sDB_Version + " WHERE HMK_NETZFILTER_EXT_G120 = '00150' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
    }
    var aResult = GetDBDataSetEXT(sSQL);
    if ((aResult.length > 0) && (ECL_GetValue("PMD_AAD146_001_000_G120") == "00007")) // Filter intern ohne
    {
        ECL_DeactivateAllAttributeValues("HMK_NETZFILTER_EXT_G120");
        ECL_ActivateValue("HMK_NETZFILTER_EXT_G120", "00001");
        if (HMK_PRODUKT_TRIG_G120 == "S120"){
            for (var i = 0; i < aResult.length; i++){
                ECL_ActivateValue("HMK_NETZFILTER_EXT_G120", aResult[i].HMK_NETZFILTER_EXT_G120);
            }
        }else{
        
            ECL_ActivateValue("HMK_NETZFILTER_EXT_G120", "00150");
        }
    }
    else
    {
        ECL_DeactivateValue("HMK_NETZFILTER_EXT_G120", "00149");
        ECL_DeactivateValue("HMK_NETZFILTER_EXT_G120", "00150");
    }
    
    // Stückliste
    var HMK_NETZFILTER_EXT_G120 = ECL_GetValue("HMK_NETZFILTER_EXT_G120");
    
    if (HMK_NETZFILTER_EXT_G120 == "00150" || HMK_NETZFILTER_EXT_G120 == "00149" ) 
    {
        var sSQL = "SELECT * FROM VT_G120_M00158_" + sDB_Version + " WHERE HMK_NETZFILTER_EXT_G120 = '" + HMK_NETZFILTER_EXT_G120 + "' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_NETZFILTER_EXT = aResult[0].HMK_MLFB_NETFILTER_G120; 
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_NETZFILTER_EXT;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_NETZFILTER_EXT;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___NETZFILTER_EXT_MLFB_G120") + " "; //"MLFB für 'Externer Netzfilter' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    
    // ---------------------------------------------------------------------------------
    // CONSEQUENCES
    // ---------------------------------------------------------------------------------
    // VPM module (voltage protection module) S110 S120
    // VPM 120 - 			6SN1113-1AA00-1JA1
    // VPM 200 -			6SN1113-1AA00-1KA1
    // VPM 200 DYNAMIK -	6SN1113-1AA00-1KC1
    //
    
    var vpmSelection = ECL_GetValue("VPM_MODULE_S110_S120");
    var vpmMlfb = "";
    var vpmSelected = false;
    
    switch(vpmSelection)
    {
        case "VPM_NONE_S110_S120":
            vpmMlfb = "";
            vpmSelected = false;
        break;
        case "VPM_120_S110_S120":
            vpmMlfb = "6SN11131AA001JA1";
            vpmSelected = true;
        break;
        case "VPM_200_S110_S120":
            vpmMlfb = "6SN11131AA001KA1";
            vpmSelected = true;
        break;
        case "VPM_200_DYNAMIK_S110_S120":
            vpmMlfb = "6SN11131AA001KC1";
            vpmSelected = true;
        break;
        default:
            vpmMlfb = "";
            vpmSelected = false;
        break;
    }
    ECL_SetValue("ECSI_CC_Selected_VPM", vpmSelected);
    ECL_SetValue("ECSI_CC_VPM", vpmMlfb);

    // VPM SEC MLFB
    var selectedVpm = ECL_GetValue("VPM_MODULE_S110_S120");
    if( selectedVpm !== "VPM_NONE_S110_S120")
    {
        var vpmMlfb = getVpmMlfbById(selectedVpm) || "";
        if (sECSI_MLFB_SEC !== "")
        {
            sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + vpmMlfb;
        }
        else
        {
            sECSI_MLFB_SEC = vpmMlfb;
        }
    }
    // ---------------------------------------------------------------------------------
    // CONSEQUENSES
    // ---------------------------------------------------------------------------------
    // ExternalFilterType
    /*	todo
    0	No external line filter selected
    1	External line filter C1
    2	External line filter C2
    3	External line filter C3
    */
    var converterPower = ECL_GetValue("ECSI_CX_ConverterRatedPower");
    var form = ECL_GetValue("TAK_AAJ871_001_000_G120");
    switch (HMK_NETZFILTER_EXT_G120){
        case "00001":
            var ExternalFilterType = "0";
        break;
        case "00149":
            if(converterPower <= 15)
            {
                if(form === "FSA" || form === "FSB" || form === "FSC")
                {
                    ExternalFilterType = "1";
                }
            }
            else
            {
                var ExternalFilterType = "1";// Klären!!! todo
            }
        break;
        case "00150":
            if(converterPower <= 15)
            {
                if(form === "FSA" || form === "FSB" || form === "FSC")
                {
                    ExternalFilterType = "1";
                }
            }
            else
            {
                var ExternalFilterType = "3";// Klären!!! todo
            }
        break;
        default:
            var ExternalFilterType = "0";
    }
    ECL_SetValue("ECSI_CC_ExternalFilterType", ExternalFilterType);
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Netzdrossel   VT_G120_M00290_24213																				alle
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // MLFB_KEY_G120	PMD_ABU782_001_000_G120	HMK_MLFB_LINEREAC_G120	HMK_VALUE_VALID_G120
    var sSQL = "SELECT * FROM VT_G120_M00290_" + sDB_Version + " WHERE PMD_ABU782_001_000_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0)
    {
        ECL_ActivateValue("PMD_ABU782_001_000_G120", "T");
    }
    else
    {
        ECL_DeactivateValue("PMD_ABU782_001_000_G120", "T");
    }
    // Stückliste
    if (ECL_GetValue("PMD_ABU782_001_000_G120") == "T") 
    {
        var phase = ECL_GetValue('HMK_ANZAHL_PHASEN_G120');
        var sSQL = `SELECT * FROM VT_G120_M00290_${sDB_Version} WHERE PMD_ABU782_001_000_G120 = 'T' AND MLFB_KEY_G120 = '${sMLFB_Key}' AND HMK_ANZAHL_PHASEN_G120 = '${phase}' AND HMK_VALUE_VALID_G120 = 'T';`;
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_NETZDROSSEL = aResult[0].HMK_MLFB_LINEREAC_G120; 
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_NETZDROSSEL;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_NETZDROSSEL;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___NETZDROSSEL_MLFB_G120") + " "; //"MLFB für 'NETZDROSSEL' nicht bestimmt, kein Treffer in DB. ";
        }
    }	
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // SINAMICS FSG Adapter Set	HMK_ADAPTER_SET_G120	UI_HMK_ADAPTER_SET_G120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // SINAMICS FSG Adapter Set	HMK_ADAPTER_SET_G120	UI_HMK_ADAPTER_SET_G120
    // nicht S110
    if (HMK_PRODUKT_TRIG_G120 == "S110"){
        ECL_DeactivateAttribute("UI_HMK_ADAPTER_SET_G120");
        ECL_DeselectValue("UI_HMK_ADAPTER_SET_G120", "T");
        ECL_SetValue("HMK_ADAPTER_SET_G120", "F");
    }else{
        ECL_ActivateAttribute("UI_HMK_ADAPTER_SET_G120");
    }
    
    // VT_G120_M00266_24213 ZO PM - Adapter Set
    //   MLFB_KEY_G120 	HMK_ADAPTER_SET_G120   HMK_MLFB_ADAPTER_SET_G120 	HMK_VALUE_VALID_G120
    
    var sSQL = "SELECT DISTINCT HMK_MLFB_ADAPTER_SET_G120 FROM VT_G120_M00266_" + sDB_Version + " WHERE " +
                "MLFB_KEY_G120 = '" + sMLFB_Key + "' AND " +
                "HMK_ADAPTER_SET_G120 = 'T' AND " +
                "HMK_VALUE_VALID_G120 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00266_" + sDB_Version );
    
    if (aResult.length > 0)
    {
        ECL_ActivateValue("HMK_ADAPTER_SET_G120", "T");
    }else{
        ECL_DeactivateValue("HMK_ADAPTER_SET_G120", "T");
    }
    ExecSetStandardifValueEmpty("HMK_ADAPTER_SET_G120", "F");
    
    // Stückliste
    if (ECL_GetValue("HMK_ADAPTER_SET_G120") == "T") 
    {
        if (aResult.length > 0)
        {
            var HMK_MLFB_ADAPTER_SET_G120 = aResult[0].HMK_MLFB_ADAPTER_SET_G120; 
            
            if (sECSI_MLFB_SEC !== ""){
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + HMK_MLFB_ADAPTER_SET_G120;
            }else{
                sECSI_MLFB_SEC = HMK_MLFB_ADAPTER_SET_G120;
            }
        }else{
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___ADAPTER_SET_MLFB_G120") + " "; //"MLFB für 'Push-Through-Einbaurahmen' nicht bestimmt, kein Treffer in DB. ";
        }
    }	
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Schirmanschlusssatz Power Modul																			nur G120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // VT_G120_M00162
    // MLFB_KEY_G120	PMD_ABU790_001_000_G120		HMK_MLFB_SCHIRM_PM_G120		HMK_VALUE_VALID_G120
    
    if (HMK_PRODUKT_TRIG_G120 == "G120"){
        
        var oAttributesMapping = {"HMK_MLFB_SCHIRM_PM_G120": null};
        simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00162" + sDB_Suffix,{
            inferenceType: VariantTables.Inference.RestrictNone,
            mapping: oAttributesMapping,
            operators: {
                "PMD_ABU790_001_000_G120": {
                inferenceType: VariantTables.Inference.RestrictAll
                }
            }
        });
        
        // Stückliste
        if (ECL_GetValue("PMD_ABU790_001_000_G120") == "T") 
        {
            var sSQL = "SELECT * FROM VT_G120_M00162_" + sDB_Version + " WHERE PMD_ABU790_001_000_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0)
            {
                var sMLFB_SCHIRM_PM = aResult[0].HMK_MLFB_SCHIRM_PM_G120; 
                
                if (sECSI_MLFB_SEC !== "")
                {
                    sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_SCHIRM_PM;
                }
                else
                {
                    sECSI_MLFB_SEC = sMLFB_SCHIRM_PM;
                }
            }
            else
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SCHIRM_PM_MLFB_G120") + " "; //"MLFB für 'Schirmanschlusssatz Power Modul' nicht bestimmt, kein Treffer in DB. ";
            }
        }
    }else{
        ECL_DeactivateValue("PMD_ABU790_001_000_G120", "T");
        ECL_SetValue("PMD_ABU790_001_000_G120", "F");
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    var OutputReactorOrFilter = "";
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Ausgangsdrossel																								alle
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // MLFB_KEY_G120	HMK_A_DROSSEL_G120	HMK_MLFB_AUSG_DROSSL_G120	HMK_VALUE_VALID_G120
    // keine Ausgangsdrossel, wenn Sinusfilter
    // keine Ausgangsdrossel, wenn Du/dt-Filter plus VPL
    // VT_G120_M00170_24213


    // Setting UI value to actual value
    var UI_HMK_A_DROSSEL_G120 = ECL_GetValue("UI_HMK_A_DROSSEL_G120");
    var HMK_PRODUKT_TRIG_G120 = ECL_GetValue("HMK_PRODUKT_TRIG_G120");

    if (UI_HMK_A_DROSSEL_G120 == "1") {
        ECL_SetValue("HMK_A_DROSSEL_G120", "T");
        ECL_SetValue("HMK_QTY_A_DROSSEL_G120", "1");
    }
    else if (UI_HMK_A_DROSSEL_G120 == "2") {
        ECL_SetValue("HMK_A_DROSSEL_G120", "T");
        ECL_SetValue("HMK_QTY_A_DROSSEL_G120", "2");
    }
    else {
        ECL_SetValue("HMK_A_DROSSEL_G120", "F");
        ECL_SetValue("HMK_QTY_A_DROSSEL_G120", "1");
    }
    
    // Filtering options
    var sSQL = "SELECT * FROM VT_G120_M00294_" + sDB_Version + " " +
        "WHERE HMK_A_DROSSEL_G120 = 'T' AND " + 
        "MLFB_KEY_G120 = '" + sMLFB_Key + "' AND " + 
        "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " + 
        "HMK_VALUE_VALID_G120 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0)
    {
        ECL_ActivateValue("HMK_A_DROSSEL_G120", "T");
    }
    else
    {
        ECL_DeactivateValue("HMK_A_DROSSEL_G120", "T");
    }
    
    if (ECL_GetValue("HMK_SINUSFILTER_G120") == "T")
    {
        ECL_DeactivateValue("HMK_A_DROSSEL_G120", "T");
    }
    
    if (ECL_GetValue("HMK_FILTER_VPL_G120") == "T")
    {
        ECL_DeactivateValue("HMK_A_DROSSEL_G120", "T");
    }

    var sSQL = "SELECT * FROM VT_G120_M00294_" + sDB_Version + " " +
        "WHERE HMK_A_DROSSEL_G120 = 'T' AND " + 
        "HMK_QTY_A_DROSSEL_G120 = '1' AND " + 
        "MLFB_KEY_G120 = '" + sMLFB_Key + "' AND " + 
        "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " + 
        "HMK_VALUE_VALID_G120 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        ECL_ActivateValue("HMK_QTY_A_DROSSEL_G120", "1");
    }
    else {
        ECL_DeactivateValue("HMK_QTY_A_DROSSEL_G120", "1");
    }

    var sSQL = "SELECT * FROM VT_G120_M00294_" + sDB_Version + " " +
        "WHERE HMK_A_DROSSEL_G120 = 'T' AND " + 
        "HMK_QTY_A_DROSSEL_G120 = '2' AND " + 
        "MLFB_KEY_G120 = '" + sMLFB_Key + "' AND " + 
        "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " + 
        "HMK_VALUE_VALID_G120 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        ECL_ActivateValue("HMK_QTY_A_DROSSEL_G120", "2");
    }
    else {
        ECL_DeactivateValue("HMK_QTY_A_DROSSEL_G120", "2");
    }

    // Restricting UI value based on deactivated values
    if (ECL_ValueActive("HMK_A_DROSSEL_G120", "T")) {
        ECL_ActivateValue("UI_HMK_A_DROSSEL_G120", "1");
        ECL_ActivateValue("UI_HMK_A_DROSSEL_G120", "2");
    }
    else {
        ECL_DeactivateValue("UI_HMK_A_DROSSEL_G120", "1");
        ECL_DeactivateValue("UI_HMK_A_DROSSEL_G120", "2");
    }

    if (ECL_ValueActive("HMK_QTY_A_DROSSEL_G120", "1")) {
        ECL_ActivateValue("UI_HMK_A_DROSSEL_G120", "1");
    }
    else {
        ECL_DeactivateValue("UI_HMK_A_DROSSEL_G120", "1");
    }

    if (ECL_ValueActive("HMK_QTY_A_DROSSEL_G120", "2")) {
        ECL_ActivateValue("UI_HMK_A_DROSSEL_G120", "2");
    }
    else {
        ECL_DeactivateValue("UI_HMK_A_DROSSEL_G120", "2");
    }

    
    // Stückliste
    if (ECL_GetValue("HMK_A_DROSSEL_G120") == "T") 
    {
        var HMK_QTY_A_DROSSEL_G120 = ECL_GetValue("HMK_QTY_A_DROSSEL_G120");

        var sSQL = "SELECT * FROM VT_G120_M00294_" + sDB_Version + " " + 
            "WHERE HMK_A_DROSSEL_G120 = 'T' AND " +
            "HMK_QTY_A_DROSSEL_G120 = '" + HMK_QTY_A_DROSSEL_G120 + "' AND " +
            "HMK_PRODUKT_TRIG_G120 = '" + HMK_PRODUKT_TRIG_G120 + "' AND " +
            "MLFB_KEY_G120 = '" + sMLFB_Key + "' AND " +
            "HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_A_DROSSEL = aResult[0].HMK_MLFB_AUSG_DROSSL_G120; 

            if (HMK_QTY_A_DROSSEL_G120 == "2") {
                sMLFB_A_DROSSEL += ";" + sMLFB_A_DROSSEL;
            }
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_A_DROSSEL;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_A_DROSSEL;
            }
            OutputReactorOrFilter = sMLFB_A_DROSSEL;
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___A_DROSSEL_MLFB_G120") + " "; //"MLFB für 'Ausgangsdrossel' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Du/dt-Filter plus VPL						VT_G120_M00264_24213											nicht S110
    // Du/dt-Filter compact plus VPL		 																		nur G120P n.n.
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // MLFB_KEY_G120	HMK_FILTER_VPL_G120	HMK_MLFB_FIL_VPL_G120
    /*var aAttributesVT264 = ["MLFB_KEY_G120",	
                            "HMK_FILTER_VPL_G120"];
    
    ECL_InferencePositiveValues("VT_G120_M00264_24213", "HMK_FILTER_VPL_G120", aAttributesVT264);
    */
    // Produkt-trigger VT_G120_M00250
    if (HMK_PRODUKT_TRIG_G120 != "S110"){
        
        var sSQL = "SELECT * FROM VT_G120_M00264_" + sDB_Version + " WHERE HMK_FILTER_VPL_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "';";
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00264_" + sDB_Version );
        if (aResult.length > 0)
        {
            ECL_ActivateValue("HMK_FILTER_VPL_G120", "T");
        }
        else
        {
            ECL_DeactivateValue("HMK_FILTER_VPL_G120", "T");
        }

        if (ECL_GetValue("HMK_A_DROSSEL_G120") == "T")
        {
            ECL_DeactivateValue("HMK_FILTER_VPL_G120", "T");
        }
        if (ECL_GetValue("HMK_SINUSFILTER_G120") == "T")
        {
            ECL_DeactivateValue("HMK_FILTER_VPL_G120", "T");
        }
    }else
    {
        ECL_DeactivateValue("HMK_FILTER_VPL_G120", "T");
        ECL_SetValue("HMK_FILTER_VPL_G120", "F");
    }
    // Stückliste
    if (ECL_GetValue("HMK_FILTER_VPL_G120") == "T") 
    {
        var sSQL = "SELECT * FROM VT_G120_M00264_" + sDB_Version + " WHERE HMK_FILTER_VPL_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "';";
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120_M00264_" + sDB_Version );
        if (aResult.length > 0)
        {
            var sMLFB_FIL_VPL = aResult[0].HMK_MLFB_FIL_VPL_G120; 
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_FIL_VPL;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_FIL_VPL;
            }
            OutputReactorOrFilter = sMLFB_FIL_VPL;
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FIL_VPL_MLFB_G120") + " "; //"MLFB für 'HMK_SINUSFILTER_G120' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++
    // Du/dt-Filter compact plus VPL	NUR G120P
    // ++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Sinusfilter   - VT_G120_M00215_24213																		nur G120
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // kein Sinusfilter, wenn schon Ausgangsdrossel == T
    // MLFB_KEY_G120	HMK_SINUSFILTER_G120	HMK_MLFB_SINUSFILTER_G120	HMK_VALUE_VALID_G120
    /*var aAttributesVT215 = ["MLFB_KEY_G120",	
                            "HMK_SINUSFILTER_G120",
                            "HMK_VALUE_VALID_G120"];
    
    ECL_InferencePositiveValues("VT_G120_M00215_24213", "HMK_SINUSFILTER_G120", aAttributesVT215);
    */
    
    if (HMK_PRODUKT_TRIG_G120 == "G120"){
        var sSQL = "SELECT * FROM VT_G120_M00215_" + sDB_Version + " WHERE HMK_SINUSFILTER_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            ECL_ActivateValue("HMK_SINUSFILTER_G120", "T");
        }
        else
        {
            ECL_DeactivateValue("HMK_SINUSFILTER_G120", "T");
            ECL_SetValue("HMK_SINUSFILTER_G120", "F");
        }
        
        if (ECL_GetValue("HMK_A_DROSSEL_G120") == "T")
        {
            ECL_DeactivateValue("HMK_SINUSFILTER_G120", "T");
            ECL_SetValue("HMK_SINUSFILTER_G120", "F");
        }
        if (ECL_GetValue("HMK_FILTER_VPL_G120") == "T")
        {
            ECL_DeactivateValue("HMK_SINUSFILTER_G120", "T");
            ECL_SetValue("HMK_SINUSFILTER_G120", "F");
        }
        // Stückliste
        if (ECL_GetValue("HMK_SINUSFILTER_G120") == "T") 
        {
            var sSQL = "SELECT * FROM VT_G120_M00215_" + sDB_Version + " WHERE HMK_SINUSFILTER_G120 = 'T' AND MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120 = 'T';";
            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0)
            {
                var sMLFB_SINUSFILTER = aResult[0].HMK_MLFB_SINUSFILTER_G120; 
                
                if (sECSI_MLFB_SEC !== "")
                {
                    sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_SINUSFILTER;
                }
                else
                {
                    sECSI_MLFB_SEC = sMLFB_SINUSFILTER;
                }
                OutputReactorOrFilter = sMLFB_SINUSFILTER;
            }
            else
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SINUSFILTER_MLFB_G120") + " "; //"MLFB für 'SINUSFILTER' nicht bestimmt, kein Treffer in DB. ";
            }
        }
    }else{
        ECL_DeactivateValue("HMK_SINUSFILTER_G120", "T");
        ECL_SetValue("HMK_SINUSFILTER_G120", "F");
    }
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ---------------------------------------------------------------------------------
    // Filter CONSEQUENCES
    // ---------------------------------------------------------------------------------
    /*   todo
    
    */
    
    
    // OutputReactorOrFilterType
    /* Integer
    0	No output reactor or filter selected
    1	Single motor reactor selected
    2	Two motor reactor in series selected
    3	Sinus filter selected
    4	du/dt filter selected
    
    OutputReactorOrFilter
    OutputReactorOrFilter	
    String	
    This parameter defines the order number for a selected output reactor or filter.	
        String.Empty	No output reactor or filter selected
        String			Order number as MLFB without separating "-"

    MLFB 
    
    todo
    */
    var OutputReactorOrFilterType = "0";
    var MaxOutputFrequencyLimit = "550"; //default
    var MaxPulseFrequency = "";
    var MinPulseFrequency = "";
    

    // Limitierung aus Lizenz J01
    //var sJ01_Lic = ECL_GetValue("HMK_J01_G120") || "";
    if (sJ01_Lic == "J01")
    {
        // Wenn Frequenz höher als 600Hz, ist die Lizenz erforderlich
        MaxOutputFrequencyLimit = "3200";
    }
    
    
    if (ECL_GetValue("HMK_A_DROSSEL_G120") == "T"){
        OutputReactorOrFilterType = "1";
        MaxOutputFrequencyLimit = "150";
        MaxPulseFrequency = "4";	// in [kHz] Limit 4 kHz
    }
    
    if (ECL_GetValue("HMK_SINUSFILTER_G120") == "T"){
        OutputReactorOrFilterType = "3";
        MaxOutputFrequencyLimit = "150";
        MaxPulseFrequency = "8";
        MinPulseFrequency = "4";
    }
    if (ECL_GetValue("HMK_FILTER_VPL_G120") == "T"){
        OutputReactorOrFilterType = "4";
        MaxOutputFrequencyLimit = "150";
        MaxPulseFrequency = "4";
    }
    ECL_SetValue("ECSI_CC_OutputReactorOrFilterType", OutputReactorOrFilterType);
    ECL_SetValue("ECSI_CC_OutputReactorOrFilter", OutputReactorOrFilter);
    
    ECL_SetValue("ECSI_CC_MaxPulseFrequency", MaxPulseFrequency);
    ECL_SetValue("ECSI_CC_MinPulseFrequency", MinPulseFrequency)
    
    if (bCUA_Adapter){
        ECL_SetValue("ECSI_CC_Selected_CUA", "1");
        if (parseInt(MaxOutputFrequencyLimit) < 550){
            ECL_SetValue("ECSI_CC_MaxOutputFrequencyLimit", MaxOutputFrequencyLimit);
        }else{
            ECL_SetValue("ECSI_CC_MaxOutputFrequencyLimit", "");
        }
    }else{
        ECL_SetValue("ECSI_CC_Selected_CUA", "0");
        ECL_SetValue("ECSI_CC_MaxOutputFrequencyLimit", MaxOutputFrequencyLimit);
    }
    
    //Output Reactor
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Auswahl Blindabdeckung																	NUR G120P		<---- nicht nötig!
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /*
    *Blindabdeckung
    $root.HMK_COVER_G120 = 'T'
    *Stückliste Blindabdeckung
    $self.MLFB_G120 = '6SL32561BA000AA0'

    VT_221_BlindabdeckungSchutzart
    
    */
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    
    
    // #########################################################################################################################
    // Leistungsschalter - VT_G120_M00192_24213
    // #########################################################################################################################
    
    // VT_G120_M00192
    //	MLFB_KEY_G120	HMK_MLFB_POWERSWITCH_G120	PMD_ABR230_001_000_G120	HMK_VALUE_VALID_G120

    var oAttributesMapping = {"HMK_MLFB_POWERSWITCH_G120": null};
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00192" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        mapping: oAttributesMapping,
        operators: {
            "PMD_ABR230_001_000_G120": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    
    // Stückliste
    if (ECL_GetValue("PMD_ABR230_001_000_G120") == "T") 
    {
        var sSQL = "SELECT * FROM VT_G120_M00192_" + sDB_Version + " WHERE MLFB_KEY_G120 = '" + sMLFB_Key + "' AND PMD_ABR230_001_000_G120 = 'T' AND HMK_VALUE_VALID_G120 = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_Leistungsschalter = aResult[0].HMK_MLFB_POWERSWITCH_G120; 
            
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_Leistungsschalter;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_Leistungsschalter;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___CIRCUIT_BREAKER_MLFB_G120") + " "; //"MLFB für 'Leistungsschalter' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    
    // #########################################################################################################################
    
    // #########################################################################################################################
    // Sicherung - VT_G120_M00222_24213
    // #########################################################################################################################
    /* VT_G120_M00222
        MLFB_KEY_G120	HMK_MLFB_FUSE_G120	HMK_FUSE_TYPE_G120	ANZ_SICHERUNG_G120	HMK_VALUE_VALID_G120 */
    var oAttributesMapping = {"HMK_MLFB_FUSE_G120": null, "ANZ_SICHERUNG_G120": null};
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120_M00222" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        mapping: oAttributesMapping,
        operators: {
            "HMK_FUSE_TYPE_G120": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    // Stückliste
    var sFuse = ECL_GetValue("HMK_FUSE_TYPE_G120");
    if ( (sFuse == "00318") || (sFuse == "00319" ) /* EU/US*/ ) {
        var sSQL = "SELECT * FROM VT_G120_M00222_" + sDB_Version + " WHERE MLFB_KEY_G120 = '" + sMLFB_Key + "' AND HMK_FUSE_TYPE_G120 = '" + sFuse + "' AND HMK_VALUE_VALID_G120 = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0)
        {
            //var iAnzahlSicherungen =  parseInt(aResult[0].ANZ_SICHERUNG_G120);
            var sAnzPhasen =  ECL_GetValue("HMK_ANZAHL_PHASEN_G120"); // 00001 1AC | 00002 3AC
            if (sAnzPhasen == "00001"){ 
                var iAnzahlSicherungen = 1;
            }

            if (sAnzPhasen == "00002"){ 
                var iAnzahlSicherungen = 3;
            }

            var sMLFB_Sicherung = aResult[0].HMK_MLFB_FUSE_G120;
            
            ECL_SetValue("ANZ_SICHERUNG_G120", iAnzahlSicherungen);
            
            if (iAnzahlSicherungen == 1)
            {
                if (sECSI_MLFB_SEC !== "")
                {
                    sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_Sicherung;
                }
                else
                {
                    sECSI_MLFB_SEC = sMLFB_Sicherung;
                }
            }
            if (iAnzahlSicherungen == 3)
            {
                if (sECSI_MLFB_SEC !== "")
                {
                    sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_Sicherung + ";" + sMLFB_Sicherung + ";" + sMLFB_Sicherung;
                }
                else
                {
                    sECSI_MLFB_SEC = sMLFB_Sicherung + ";" + sMLFB_Sicherung + ";" + sMLFB_Sicherung;
                }
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FUSE_MLFB_G120") + " "; 
        }
    }
    
    
    // Schutzart - Consequence 		sSchutzart = ECL_GetValue("PMD_ABJ176_001_000_G120");		todo
    /*
    IpProtectionLevelFrequencyConverter	
    Integer	
    This parameter define the IP protection level of the complete frequency converter solution.	
    0|20|21|22|23|41|42|43|54|55|56|64|65|66|67	
    Integer value of the protection level ("0" for "IP00" or "54" for "IP54")

    */
    ECL_SetValue("ECSI_CC_IpProtectionLevelFrequencyConverter", "20");
    // #########################################################################################################################
    // #########################################################################################################################
    
    // #########################################################################################################################
    // Übertragung der Logik in UI-Checkbox-Attribute:
    // #########################################################################################################################
    setCheckBoxAttributes(HMK_PRODUKT_TRIG_G120);
    // #########################################################################################################################
    
    // #########################################################################################################################
    // Zusätzliche MLFBs setzen
    // #########################################################################################################################
    SetMlfbSec(sECSI_MLFB_SEC);
    var ver = ECL_GetValue("FIRMWARE_VERSION_G120");
    
    // #########################################################################################################################
    // #########################################################################################################################
    
    if ( !(sECSI_STATUS == "E")
    ) {
        sECSI_STATUS = "OK";
    }
    // Übergabestatus setzen
    ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
    ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);

//var DebugStop;

    if (HMK_PRODUKT_TRIG_G120 === "S110"){
        ECL_SelectValue("ECSI_CC_Selected_CU", "CU305");
    } else if (HMK_PRODUKT_TRIG_G120 === "S120"){ 
        if (bCUA_Adapter) {
            ECL_SelectValue("ECSI_CC_Selected_CU", "");
        } else if (sCU === "00995" || sCU === "00994"){
            ECL_SelectValue("ECSI_CC_Selected_CU", "CU310-2");
        }
    } else if (HMK_PRODUKT_TRIG_G120 === "G120") {
        if (sCU === "00320" || sCU === "00321" || sCU === "00322" || sCU === "00323") {
            ECL_SelectValue("ECSI_CC_Selected_CU", "CU250S-2");
        } else {
            ECL_SelectValue("ECSI_CC_Selected_CU", "");
        }
    }

    // #########################################################################################################################
    // #########################################################################################################################
    // Visible-Steuerung
    // #########################################################################################################################
    ECL_DisableAttribute("HMK_TYPE_PM_G120"); 			// Powermodul nur Info
    ECL_DisableAttribute("PMD_ABJ176_001_000_G120"); 	// IP-Schutzklasse nur Info
    //ECL_DeactivateAttribute("HMK_PROFISAFE_G120"); 		// PROFISAFE nur Info
    ECL_DisableAttribute("UI_HMK_PROFISAFE_G120"); 		// PROFISAFE nur Info
    
    ECL_DeactivateAttribute("TAK_AAJ871_001_000_G120"); 	// Bauform nur Info
    
    ECL_DeactivateAttribute("PMD_ABU799_001_000_G120");	// Netzspannung
    ECL_DeactivateAttribute("HMK_NETZFREQUENZ_G120");	// Netzfrequenz
    ECL_DeactivateAttribute("HMK_ANZAHL_PHASEN_G120");	// Phasenzahl
    ECL_DisableAttribute("PMD_AAA136_001_000_1002980");	// Art der Kühlung
    
    disableShortOptionsForFirmware();
    
    // safety
    if (bF01_Mandatory){
        ECL_DisableAttribute("UI_HMK_F01_G120");
    }
    //bAdvancedSafety_Mandatory
    if (bAdvancedSafety_Mandatory){
        ECL_DisableAttribute("CB_ADVANCED_SAFETY_G120");
    }
    
    if (bSafeBrakeRelayMandatory){
        ECL_DisableAttribute("UI_HMK_SAFEBRAKERELAY_G120"); 
    }
    
    ECL_DeactivateAttribute("HMK_SAFETY_STO_G120");
    ECL_DeactivateAttribute("HMK_SAFETY_SS1_G120");
    ECL_DeactivateAttribute("HMK_SAFETY_SLS_G120");
    ECL_DeactivateAttribute("HMK_SAFETY_SDI_G120");
    ECL_DeactivateAttribute("HMK_SAFETY_SSM_G120");
    ECL_DeactivateAttribute("HMK_SAFETY_SBC_G120");
    
    ECL_DisableAttribute("UI_HMK_SAFETY_STO_G120");
    ECL_DisableAttribute("UI_HMK_SAFETY_SS1_G120");
    ECL_DisableAttribute("UI_HMK_SAFETY_SLS_G120");
    ECL_DisableAttribute("UI_HMK_SAFETY_SDI_G120");
    ECL_DisableAttribute("UI_HMK_SAFETY_SSM_G120");
    ECL_DisableAttribute("UI_HMK_SAFETY_SBC_G120");
    
    ECL_DisableAttribute("HMK_F_DI_G120");				// Fehlersicher DI
    ECL_DisableAttribute("TAK_AAN259_001_000_G120");	// Anzahl Digitaleingänge
    ECL_DisableAttribute("HMK_DI_BERECHNET_G120");		// Anzahl Digitaleingänge
    ECL_DisableAttribute("PMD_AAA274_001_000_G120");	// Anzahl Analogeingänge
    ECL_DisableAttribute("TAK_AAM785_001_000_G120");	// Anzahl Digitalausgänge
    ECL_DisableAttribute("PMD_AAA310_001_000_G120");	// Anzahl Analogausgänge
    ECL_DisableAttribute("HMK_DI_DO_G120");				// Digital Ein- / Ausgänge
    ECL_DeactivateAttribute("PMD_ABU278_001_000_G120");	// Geberauswertung
    ECL_DeactivateAttribute("HMK_EPOS_G120");			// Positionierfunktionalität
    ECL_DisableAttribute("UI_HMK_EPOS_G120");			// Positionierfunktionalität
    
    
    ECL_DeactivateAttribute("MLFB06_G120");
    ECL_DeactivateAttribute("MLFB07_G120");
    ECL_DeactivateAttribute("MLFB08_G120");
    ECL_DeactivateAttribute("MLFB09_G120");
    ECL_DeactivateAttribute("MLFB10_G120");
    ECL_DeactivateAttribute("MLFB11_G120");
    ECL_DeactivateAttribute("MLFB12_G120");
    ECL_DeactivateAttribute("MLFB13_G120");
    ECL_DeactivateAttribute("MLFB14_G120");
    ECL_DeactivateAttribute("MLFB15_G120");
    ECL_DeactivateAttribute("MLFB16_G120");
    ECL_DeactivateAttribute("MLFB_KEY_G120");
    
    ECL_DeactivateAttribute("UI_HMK_RUECKSP_UEBERGAB_G120");
    
    ECL_DeactivateAttribute("ANZ_SICHERUNG_G120");
    
    // EDIT 2021.06 TFS 5620128 Removesensor modules from FC
    ECL_DeactivateAttribute("HMK_SENSORMODULE_G120");	// Sensor Module Cabinet-Mounted
    // Deaktivieren der durch UI_Checkbox-Attribute behandelten Attribute
    ECL_DeactivateAttribute("HMK_RUECKSP_UEBERGAB_G120");	// UI_HMK_RUECKSP_UEBERGAB_G120		Generatorischer Betrieb Übergabe Sizer	
    ECL_DeactivateAttribute("HMK_NEMA_KIT_G120");			// UI_HMK_NEMA_KIT_G120				NEMA / UL type Kit
    ECL_DeactivateAttribute("HMK_E01_G120");				// UI_HMK_E01_G120					E01 Lizenz Extenden Functions Einfachpositionierung (EPos)
    ECL_DeactivateAttribute("HMK_F01_G120");				// UI_HMK_F01_G120					F01 Lizenz Extended Functions Safety (SLS, SSM, SDI)
    ECL_DeactivateAttribute("HMK_U01_G120");				// UI_HMK_U01_G120					DCB Extension
    ECL_DeactivateAttribute("HMK_J01_G120");				// UI_HMK_J01_G120					Lizenz hohe Ausgangsfrequenz
    ECL_DeactivateAttribute("HMK_SMART_ACCESS_G120");		// UI_HMK_SMART_ACCESS_G120			Webservermodul
    ECL_DeactivateAttribute("HMK_ADAPT_KIT_CUA20_G120");	// UI_HMK_ADAPT_KIT_CUA20_G120		Control Unit Adapter Kit CUA20
    ECL_DeactivateAttribute("HMK_IOP_HANDHELD_G120");		// UI_HMK_IOP_HANDHELD_G120			IOP-2 Handheld
    ECL_DeactivateAttribute("PMD_ABU776_001_000_G120");		// UI_PMD_ABU776_001_000_G120		Türmontagesatz für IOP-2/BOP-2
    ECL_DeactivateAttribute("PMD_ABU783_001_000_G120"); 	// UI_PMD_ABU783_001_000_G120		Umrichter-Verbindungssatz (PC oder Handheld)
    ECL_DeactivateAttribute("HMK_SCHIRMANSCHL_CU_G120");	// UI_HMK_SCHIRMANSCHL_CU_G120		Schirmanschlusssatz Control Unit
    ECL_DeactivateAttribute("HMK_BRAKERELAY_G120");			// UI_HMK_BRAKERELAY_G120			Brake Relay
    ECL_DeactivateAttribute("HMK_SAFEBRAKERELAY_G120");		// UI_HMK_SAFEBRAKERELAY_G120		Safe Brake Relay
    ECL_DeactivateAttribute("HMK_TOOL_STARTER_G120");		// UI_HMK_TOOL_STARTER_G120			Inbetriebnahme-Tool STARTER
    ECL_DeactivateAttribute("HMK_BRAKERESISTOR_G120");		// UI_HMK_BRAKERESISTOR_G120		Bremswiderstand
    ECL_DeactivateAttribute("HMK_BRAKEMODULE_G120");		// UI_HMK_BRAKEMODULE_G120			Bremsmodul
    ECL_DeactivateAttribute("PMD_AAD146_001_000_G120");		// UI_PMD_AAD146_001_000_G120		Interner Netzfilter
    ECL_DeactivateAttribute("HMK_ADAPTER_SET_G120");		// HMK_ADAPTER_SET_G120				SINAMICS FSG Adapter Set
    ECL_DeactivateAttribute("HMK_CONNECT_300_G120");		// HMK_CONNECT_300_G120				SINAMICS CONNECT 300 IoT Gateway
    
    if (HMK_PRODUKT_TRIG_G120 == "G120"){
        ECL_DeactivateAttribute("HMK_NETZFILTER_EXT_G120");		// UI_HMK_NETZFILTER_EXT_G120		Externer Netzfilter
        ECL_ActivateAttribute("UI_HMK_NETZFILTER_EXT_G120");	// UI_HMK_NETZFILTER_EXT_G120		Externer Netzfilter
        //ECL_ActivateAttribute("UI_HMK_CONNECT_300_G120");		// UI_HMK_CONNECT_300_G120			SINAMICS CONNECT 300 IoT Gateway
        //ECL_ActivateAttribute("UI_HMK_ADAPTER_SET_G120");		// UI_HMK_ADAPTER_SET_G120			SINAMICS FSG Adapter Set
    }else{
        ECL_ActivateAttribute("HMK_NETZFILTER_EXT_G120");		// UI_HMK_NETZFILTER_EXT_G120		Externer Netzfilter
        ECL_DeactivateAttribute("UI_HMK_NETZFILTER_EXT_G120");	// UI_HMK_NETZFILTER_EXT_G120		Externer Netzfilter
    }
    
    //if (HMK_PRODUKT_TRIG_G120 == "S120"){
    
    ECL_DeactivateAttribute("PMD_ABU782_001_000_G120");		// UI_PMD_ABU782_001_000_G120		Netzdrossel
    ECL_DeactivateAttribute("PMD_ABU790_001_000_G120");		// UI_PMD_ABU790_001_000_G120		Schirmanschlusssatz Power Modul
    ECL_DeactivateAttribute("HMK_A_DROSSEL_G120");			// UI_HMK_A_DROSSEL_G120			Ausgangsdrossel
    ECL_DeactivateAttribute("HMK_QTY_A_DROSSEL_G120");		// UI_HMK_A_DROSSEL_G120			Ausgangsdrossel Quantity
    ECL_DeactivateAttribute("HMK_SINUSFILTER_G120");		// UI_HMK_SINUSFILTER_G120			Sinusfilter
    ECL_DeactivateAttribute("HMK_FILTER_VPL_G120");			// UI_HMK_FILTER_VPL_G120			Du/dt-Filter plus VPL
    ECL_DeactivateAttribute("PMD_ABR230_001_000_G120");		// UI_PMD_ABR230_001_000_G120		Leistungsschalter
    
    
    var sFB = ECL_GetValue("ECSI_CX_FieldbusInterface");
    if ( (ECL_GetValue("ECSI_CX_FieldbusInterface") == "" || ECL_GetValue("ECSI_CX_FieldbusInterface") == undefined) && (sFB !== 0)
    ) {
        ECL_EnableAttribute("PMD_ABU804_001_000_G120");
    }
    else
    {
        ECL_DisableAttribute("PMD_ABU804_001_000_G120");
    }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // En-/Disable Bremswiderstand
    var UI_HMK_BRAKERESISTOR_G120 = ECL_GetValue("UI_HMK_BRAKERESISTOR_G120");
    // Wenn Bremswiderstand vorgegeben, dann 
    if (ECSI_CX_RegenerativeMode == 2){
        ECL_EnableAttribute("UI_HMK_BRAKERESISTOR_G120");
        ECL_DeactivateValue("UI_HMK_BRAKERESISTOR_G120", "F");
    }else{
        ECL_EnableAttribute("UI_HMK_BRAKERESISTOR_G120");
        //ECL_DisableAttribute("HMK_BRAKERESISTOR_G120");
    }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    enableProductRelevantFW();
    enablePerformanceOptionForS120();
    
    var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
    if(product === "G120")
    {
        var f01Enabled = ECL_AttributeEnabled("UI_HMK_F01_G120");
        if(!f01Enabled)
        {
            ECL_DeactivateValue("SAFETY_INFO_SSM_G120", "SSM_INFO_G120");
            ECL_DeactivateValue("SAFETY_INFO_SLS_G120", "SLS_INFO_G120");
            ECL_DeactivateValue("SAFETY_INFO_SDI_G120", "SDI_INFO_G120");
            ECL_DeactivateAttribute("SAFETY_INFO_SSM_G120");
            ECL_DeactivateAttribute("SAFETY_INFO_SLS_G120");
            ECL_DeactivateAttribute("SAFETY_INFO_SDI_G120");
        }
        else
        {
            ECL_ActivateValue("SAFETY_INFO_SSM_G120", "SSM_INFO_G120");
            ECL_ActivateValue("SAFETY_INFO_SLS_G120", "SLS_INFO_G120");
            ECL_ActivateValue("SAFETY_INFO_SDI_G120", "SDI_INFO_G120");
            ECL_ActivateAttribute("SAFETY_INFO_SSM_G120");
            ECL_ActivateAttribute("SAFETY_INFO_SLS_G120");
            ECL_ActivateAttribute("SAFETY_INFO_SDI_G120");
        }
    }

    //Nachträglich deactiviert, da es nur einen Wert speichert, aber nicht gesehen werden soll
    ECL_DeactivateAttribute("HMK_PRODUKT_TRIG_G120");
    ECL_DeactivateAttribute("HMK_VALUE_VALID_G120");
    count++;

}
// ENDE MAIN ############################################################################################################################
// ENDE MAIN ############################################################################################################################


function replaceAt(string, index, s_replace) {
  return string.substring(0, index) + s_replace + string.substring(index + 1);
}

// n_pos startet bei 0
function replaceChar(s_src, s_char, n_pos)
{
  if(s_src.length < n_pos)
    return s_src;
  var s=s_src.left(n_pos) + s_char + s_src.substring(n_pos + 1);
  return s;
}

function GetDBDataSetEXT(sSQL)
{
    return GetDBDataSetEXT(sSQL, null);
}

function GetDBDataSetEXT(sSQL, sDbRequestIdent){

    var aResult = [];

        aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
    
    return aResult;
}

function ExecSetStandardifValueEmpty(Attribute, strDefault)
{
    var strValue = ECL_GetValue(Attribute);
    if(strValue == ""){
        if(ECL_ValueActive(Attribute, strDefault)){
            ECL_SelectValue(Attribute, strDefault);
            return true;
        }else{
            var aselection = ECL_GetAllActiveAttributeValues(Attribute);
            if(aselection.length > 0 ){
                ECL_SelectValue(Attribute, aselection[0]);
                return true;
            }
        }
    }else{
        var aselection = ECL_GetAllActiveAttributeValues(Attribute);
        
        if(aselection.length > 0){
            for(var i=0;i<aselection.length;i++){	
                if(strValue == aselection[i])
                    return true;
            }
        }
        
        if(ECL_ValueActive(Attribute, strDefault)){
            ECL_SelectValue(Attribute, strDefault);
            return true;
        }else{
            var aselection = ECL_GetAllActiveAttributeValues(Attribute);
            if(aselection.length > 0){
                ECL_SelectValue(Attribute, aselection[0]);
                return true;
            }
        }
    }
}

function intersect(a, b) {
    var d = {};
    var results = [];
    for (var i = 0; i < b.length; i++) {
        d[b[i]] = true;
    }
    for (var j = 0; j < a.length; j++) {
        if (d[a[j]]) 
            results.push(a[j]);
    }
    return results;
}

function getCheckBoxAttributes(strChangedAttribute, HMK_PRODUKT_TRIG_G120)
{
    switch (strChangedAttribute){
        case "UI_HMK_RUECKSP_UEBERGAB_G120":
            // UI_HMK_RUECKSP_UEBERGAB_G120		Generatorischer Betrieb Übergabe Sizer	
            setAttributeFromUICheckbox("HMK_RUECKSP_UEBERGAB_G120", "UI_HMK_RUECKSP_UEBERGAB_G120", "T", "F");
        break;
        case "UI_HMK_NEMA_KIT_G120":
            // UI_HMK_NEMA_KIT_G120		NEMA / UL type Kit
            setAttributeFromUICheckbox("HMK_NEMA_KIT_G120", "UI_HMK_NEMA_KIT_G120", "T", "F");
        break;
        case "UI_HMK_EPOS_G120":
            // UI_HMK_EPOS_G120		Positionierfunktionalität
            setAttributeFromUICheckbox("HMK_EPOS_G120", "UI_HMK_EPOS_G120", "T", "F");
        break;
/*		case "UI_HMK_SAFETY_STO_G120":
            // UI_HMK_SAFETY_STO_G120		Safety STO
            setAttributeFromUICheckbox("HMK_SAFETY_STO_G120", "UI_HMK_SAFETY_STO_G120", "T", "F");
        break;
        case "UI_HMK_SAFETY_SS1_G120":
            // UI_HMK_SAFETY_SS1_G120		Safety SS1
            setAttributeFromUICheckbox("HMK_SAFETY_SS1_G120", "UI_HMK_SAFETY_SS1_G120", "T", "F");
        break;
        case "UI_HMK_SAFETY_SLS_G120":
            // UI_HMK_SAFETY_SLS_G120		Safety SLS
            setAttributeFromUICheckbox("HMK_SAFETY_SLS_G120", "UI_HMK_SAFETY_SLS_G120", "T", "F");
        break;
        case "UI_HMK_SAFETY_SDI_G120":
            // UI_HMK_SAFETY_SDI_G120		Safety SDI
            setAttributeFromUICheckbox("HMK_SAFETY_SDI_G120", "UI_HMK_SAFETY_SDI_G120", "T", "F");
        break;
        case "UI_HMK_SAFETY_SSM_G120":
            // UI_HMK_SAFETY_SSM_G120		Safety SSM
            setAttributeFromUICheckbox("HMK_SAFETY_SSM_G120", "UI_HMK_SAFETY_SSM_G120", "T", "F");
        break;
        case "UI_HMK_SAFETY_SBC_G120":
            // UI_HMK_SAFETY_SBC_G120		Safety SBC
            setAttributeFromUICheckbox("HMK_SAFETY_SBC_G120", "UI_HMK_SAFETY_SBC_G120", "T", "F");
        break;
        case "UI_HMK_PROFISAFE_G120":
            // UI_HMK_PROFISAFE_G120		PROFIsafe
            setAttributeFromUICheckbox("HMK_PROFISAFE_G120", "UI_HMK_PROFISAFE_G120", "00002", "00001");
        break;
*/		case "UI_HMK_E01_G120":
            // UI_HMK_E01_G120		E01 Lizenz Extenden Functions Einfachpositionierung (EPos)
            setAttributeFromUICheckbox("HMK_E01_G120", "UI_HMK_E01_G120", "E01", "NON");
        break;
        case "UI_HMK_F01_G120":
            // UI_HMK_F01_G120		F01 Lizenz Extended Functions Safety (SLS, SSM, SDI)
            setAttributeFromUICheckbox("HMK_F01_G120", "UI_HMK_F01_G120", "F01", "NON");
        break;
        case "UI_HMK_F01_S110_G120":
            // UI_HMK_F01_S110_G120		F01 Lizenz Ext. Functions Safety (SLS, SSM, SDI, SS2, SOS)
            setAttributeFromUICheckbox("HMK_F01_G120", "UI_HMK_F01_S110_G120", "F01", "NON");
        break;
        case "UI_HMK_F01_S120_G120":
            // UI_HMK_F01_S120_G120		F01 Lizenz Ext. Functions Safety (SLS, SSM, SDI, SS2, SOS, SLA, SBT (SLP, SP, SCA))
            setAttributeFromUICheckbox("HMK_F01_G120", "UI_HMK_F01_S120_G120", "F01", "NON");
        break;
        case "UI_HMK_U01_G120":
            // UI_HMK_U01_G120		DCB Extension
            setAttributeFromUICheckbox("HMK_U01_G120", "UI_HMK_U01_G120", "U01", "F");
        break;
        case "UI_HMK_J01_G120":
            // UI_HMK_J01_G120		Lizenz hohe Ausgangsfrequenz
            setAttributeFromUICheckbox("HMK_J01_G120", "UI_HMK_J01_G120", "J01", "F");
        break;
        case "UI_HMK_SMART_ACCESS_G120":
            // UI_HMK_SMART_ACCESS_G120		Webservermodul
            setAttributeFromUICheckbox("HMK_SMART_ACCESS_G120", "UI_HMK_SMART_ACCESS_G120", "T", "F");
        break;
        case "UI_HMK_ADAPT_KIT_CUA20_G120":
            // UI_HMK_ADAPT_KIT_CUA20_G120		Control Unit Adapter Kit CUA20
            setAttributeFromUICheckbox("HMK_ADAPT_KIT_CUA20_G120", "UI_HMK_ADAPT_KIT_CUA20_G120", "T", "F");
        break;
        case "UI_HMK_CONNECT_300_G120":
            // UI_HMK_CONNECT_300_G120		SINAMICS CONNECT 300 IoT Gateway
            setAttributeFromUICheckbox("HMK_CONNECT_300_G120", "UI_HMK_CONNECT_300_G120", "T", "F");
        break;
        case "UI_HMK_IOP_HANDHELD_G120":
            // UI_HMK_IOP_HANDHELD_G120		IOP-2 Handheld
            setAttributeFromUICheckbox("HMK_IOP_HANDHELD_G120", "UI_HMK_IOP_HANDHELD_G120", "T", "F");
        break;
        case "UI_PMD_ABU776_001_000_G120":
            // UI_PMD_ABU776_001_000_G120		Türmontagesatz für IOP-2/BOP-2
            setAttributeFromUICheckbox("PMD_ABU776_001_000_G120", "UI_PMD_ABU776_001_000_G120", "T", "F");
        break;
        case "UI_PMD_ABU783_001_000_G120":
            // UI_PMD_ABU783_001_000_G120		Umrichter-Verbindungssatz (PC oder Handheld)
            setAttributeFromUICheckbox("PMD_ABU783_001_000_G120", "UI_PMD_ABU783_001_000_G120", "T", "F");
        break;
        case "UI_HMK_SCHIRMANSCHL_CU_G120":
            // UI_HMK_SCHIRMANSCHL_CU_G120		Schirmanschlusssatz Control Unit
            setAttributeFromUICheckbox("HMK_SCHIRMANSCHL_CU_G120", "UI_HMK_SCHIRMANSCHL_CU_G120", "T", "F");
        break;
        case "UI_HMK_BRAKERELAY_G120":
            // UI_HMK_BRAKERELAY_G120		Brake Relay
            setAttributeFromUICheckbox("HMK_BRAKERELAY_G120", "UI_HMK_BRAKERELAY_G120", "T", "F");
        break;
        case "UI_HMK_SAFEBRAKERELAY_G120":
            // UI_HMK_SAFEBRAKERELAY_G120		Safe Brake Relay
            setAttributeFromUICheckbox("HMK_SAFEBRAKERELAY_G120", "UI_HMK_SAFEBRAKERELAY_G120", "T", "F");
        break;
        case "UI_HMK_TOOL_STARTER_G120":
            // UI_HMK_TOOL_STARTER_G120		Inbetriebnahme-Tool STARTER
            setAttributeFromUICheckbox("HMK_TOOL_STARTER_G120", "UI_HMK_TOOL_STARTER_G120", "T", "F");
        break;
        case "UI_HMK_BRAKEMODULE_G120":
            // UI_HMK_BRAKEMODULE_G120		Bremsmodul
            setAttributeFromUICheckbox("HMK_BRAKEMODULE_G120", "UI_HMK_BRAKEMODULE_G120", "T", "F");
        break;
        case "UI_PMD_AAD146_001_000_G120":
            // UI_PMD_AAD146_001_000_G120		Interner Netzfilter
            setAttributeFromUICheckbox("PMD_AAD146_001_000_G120", "UI_PMD_AAD146_001_000_G120", "00003", "00007");
        break;
        case "UI_HMK_NETZFILTER_EXT_G120":
            // UI_HMK_NETZFILTER_EXT_G120		Externer Netzfilter
            if (HMK_PRODUKT_TRIG_G120 == "G120"){
                setAttributeFromUICheckbox("HMK_NETZFILTER_EXT_G120", "UI_HMK_NETZFILTER_EXT_G120", "00150", "00001");
            }
        break;
        case "UI_PMD_ABU782_001_000_G120":
            // UI_PMD_ABU782_001_000_G120		Netzdrossel
            setAttributeFromUICheckbox("PMD_ABU782_001_000_G120", "UI_PMD_ABU782_001_000_G120", "T", "F");
        break;
        case "UI_HMK_ADAPTER_SET_G120":
            // UI_HMK_ADAPTER_SET_G120		SINAMICS FSG Adapter Set
            setAttributeFromUICheckbox("HMK_ADAPTER_SET_G120", "UI_HMK_ADAPTER_SET_G120", "T", "F");
        break;
        case "UI_PMD_ABU790_001_000_G120":
            // UI_PMD_ABU790_001_000_G120		Schirmanschlusssatz Power Modul
            setAttributeFromUICheckbox("PMD_ABU790_001_000_G120", "UI_PMD_ABU790_001_000_G120", "T", "F");
        break;
        case "UI_HMK_SINUSFILTER_G120":
            // UI_HMK_SINUSFILTER_G120		Sinusfilter
            setAttributeFromUICheckbox("HMK_SINUSFILTER_G120", "UI_HMK_SINUSFILTER_G120", "T", "F");
        break;
        case "UI_HMK_FILTER_VPL_G120":
            // UI_HMK_FILTER_VPL_G120		Du/dt-Filter plus VPL
            setAttributeFromUICheckbox("HMK_FILTER_VPL_G120", "UI_HMK_FILTER_VPL_G120", "T", "F");
        break;
        case "UI_PMD_ABR230_001_000_G120":
            // UI_PMD_ABR230_001_000_G120		Leistungsschalter
            setAttributeFromUICheckbox("PMD_ABR230_001_000_G120", "UI_PMD_ABR230_001_000_G120", "T", "F");
        break;
    }
}
function setCheckBoxAttributes(HMK_PRODUKT_TRIG_G120)
{
    // UI_HMK_RUECKSP_UEBERGAB_G120		Generatorischer Betrieb Übergabe Sizer	
    setProductLogicToUIAttribute("HMK_RUECKSP_UEBERGAB_G120", "UI_HMK_RUECKSP_UEBERGAB_G120", "T", "F");

    // UI_HMK_NEMA_KIT_G120		NEMA / UL type Kit
    setProductLogicToUIAttribute("HMK_NEMA_KIT_G120", "UI_HMK_NEMA_KIT_G120", "T", "F");

    // UI_HMK_EPOS_G120		Positionierfunktionalität
    setProductLogicToUIAttribute("HMK_EPOS_G120", "UI_HMK_EPOS_G120", "T", "F");
    
    // UI_HMK_SAFETY_STO_G120		Safety STO
//	setProductLogicToUIAttribute("HMK_SAFETY_STO_G120", "UI_HMK_SAFETY_STO_G120", "T", "F");
    // UI_HMK_SAFETY_SS1_G120		Safety SS1
//	setProductLogicToUIAttribute("HMK_SAFETY_SS1_G120", "UI_HMK_SAFETY_SS1_G120", "T", "F");
    // UI_HMK_SAFETY_SLS_G120		Safety SLS
//	setProductLogicToUIAttribute("HMK_SAFETY_SLS_G120", "UI_HMK_SAFETY_SLS_G120", "T", "F");
    // UI_HMK_SAFETY_SDI_G120		Safety SDI
//	setProductLogicToUIAttribute("HMK_SAFETY_SDI_G120", "UI_HMK_SAFETY_SDI_G120", "T", "F");
    // UI_HMK_SAFETY_SSM_G120		Safety SSM
//	setProductLogicToUIAttribute("HMK_SAFETY_SSM_G120", "UI_HMK_SAFETY_SSM_G120", "T", "F");
    // UI_HMK_SAFETY_SBC_G120		Safety SBC
//	setProductLogicToUIAttribute("HMK_SAFETY_SBC_G120", "UI_HMK_SAFETY_SBC_G120", "T", "F");
    // UI_HMK_PROFISAFE_G120		PROFIsafe
//	setProductLogicToUIAttribute("HMK_PROFISAFE_G120", "UI_HMK_PROFISAFE_G120", "00002", "00001");
    
    // UI_HMK_E01_G120		E01 Lizenz Extenden Functions Einfachpositionierung (EPos)
    setProductLogicToUIAttribute("HMK_E01_G120", "UI_HMK_E01_G120", "E01", "NON");
    
    // UI_HMK_F01_G120		F01 Lizenz Extended Functions Safety (SLS, SSM, SDI)
    if (HMK_PRODUKT_TRIG_G120 == "G120"){
        setProductLogicToUIAttribute("HMK_F01_G120", "UI_HMK_F01_G120", "F01", "NON");
    } else if (HMK_PRODUKT_TRIG_G120 == "S110"){
        setProductLogicToUIAttribute("HMK_F01_G120", "UI_HMK_F01_S110_G120", "F01", "NON");
    }else if (HMK_PRODUKT_TRIG_G120 == "S120"){
        setProductLogicToUIAttribute("HMK_F01_G120", "UI_HMK_F01_S120_G120", "F01", "NON");
    }
    // UI_HMK_U01_G120		DCB Extension
    setProductLogicToUIAttribute("HMK_U01_G120", "UI_HMK_U01_G120", "U01", "F");
    
    // UI_HMK_J01_G120		Lizenz hohe Ausgangsfrequenz
    setProductLogicToUIAttribute("HMK_J01_G120", "UI_HMK_J01_G120", "J01", "F");
    
    // UI_HMK_SMART_ACCESS_G120		Webservermodul
    setProductLogicToUIAttribute("HMK_SMART_ACCESS_G120", "UI_HMK_SMART_ACCESS_G120", "T", "F");
    
    // UI_HMK_ADAPT_KIT_CUA20_G120		Control Unit Adapter Kit CUA20
    setProductLogicToUIAttribute("HMK_ADAPT_KIT_CUA20_G120", "UI_HMK_ADAPT_KIT_CUA20_G120", "T", "F");
    
    if (HMK_PRODUKT_TRIG_G120 == "G120"){
        // UI_HMK_CONNECT_300_G120
        setProductLogicToUIAttribute("HMK_CONNECT_300_G120", "UI_HMK_CONNECT_300_G120", "T", "F");
    }
    
    // UI_HMK_IOP_HANDHELD_G120		IOP-2 Handheld
    setProductLogicToUIAttribute("HMK_IOP_HANDHELD_G120", "UI_HMK_IOP_HANDHELD_G120", "T", "F");
    
    // UI_PMD_ABU776_001_000_G120		Türmontagesatz für IOP-2/BOP-2
    setProductLogicToUIAttribute("PMD_ABU776_001_000_G120", "UI_PMD_ABU776_001_000_G120", "T", "F");
    
    // UI_PMD_ABU783_001_000_G120		Umrichter-Verbindungssatz (PC oder Handheld)
    setProductLogicToUIAttribute("PMD_ABU783_001_000_G120", "UI_PMD_ABU783_001_000_G120", "T", "F");
    
    // UI_HMK_SCHIRMANSCHL_CU_G120		Schirmanschlusssatz Control Unit
    setProductLogicToUIAttribute("HMK_SCHIRMANSCHL_CU_G120", "UI_HMK_SCHIRMANSCHL_CU_G120", "T", "F");
    
    // UI_HMK_BRAKERELAY_G120		Brake Relay
    setProductLogicToUIAttribute("HMK_BRAKERELAY_G120", "UI_HMK_BRAKERELAY_G120", "T", "F");
    
    // UI_HMK_SAFEBRAKERELAY_G120		Safe Brake Relay
    setProductLogicToUIAttribute("HMK_SAFEBRAKERELAY_G120", "UI_HMK_SAFEBRAKERELAY_G120", "T", "F");
    
    // UI_HMK_TOOL_STARTER_G120		Inbetriebnahme-Tool STARTER
    setProductLogicToUIAttribute("HMK_TOOL_STARTER_G120", "UI_HMK_TOOL_STARTER_G120", "T", "F");
    
    // UI_HMK_BRAKEMODULE_G120		Bremsmodul
    setProductLogicToUIAttribute("HMK_BRAKEMODULE_G120", "UI_HMK_BRAKEMODULE_G120", "T", "F");
        
    // UI_PMD_AAD146_001_000_G120		Interner Netzfilter
    setProductLogicToUIAttribute("PMD_AAD146_001_000_G120", "UI_PMD_AAD146_001_000_G120", "00003", "00007");
    
    // UI_HMK_NETZFILTER_EXT_G120		Externer Netzfilter
    if (HMK_PRODUKT_TRIG_G120 == "G120"){
        setProductLogicToUIAttribute("HMK_NETZFILTER_EXT_G120", "UI_HMK_NETZFILTER_EXT_G120", "00150", "00001");
    }
    // UI_PMD_ABU782_001_000_G120		Netzdrossel
    setProductLogicToUIAttribute("PMD_ABU782_001_000_G120", "UI_PMD_ABU782_001_000_G120", "T", "F");
    
    if (HMK_PRODUKT_TRIG_G120 == "G120" || HMK_PRODUKT_TRIG_G120 == "S120"){
        // UI_HMK_ADAPTER_SET_G120		SINAMICS FSG Adapter Set
        setProductLogicToUIAttribute("HMK_ADAPTER_SET_G120", "UI_HMK_ADAPTER_SET_G120", "T", "F");
    }		
    // UI_PMD_ABU790_001_000_G120		Schirmanschlusssatz Power Modul
    setProductLogicToUIAttribute("PMD_ABU790_001_000_G120", "UI_PMD_ABU790_001_000_G120", "T", "F");
    
    // UI_HMK_SINUSFILTER_G120		Sinusfilter
    setProductLogicToUIAttribute("HMK_SINUSFILTER_G120", "UI_HMK_SINUSFILTER_G120", "T", "F");
    
    // UI_HMK_FILTER_VPL_G120		Du/dt-Filter plus VPL
    setProductLogicToUIAttribute("HMK_FILTER_VPL_G120", "UI_HMK_FILTER_VPL_G120", "T", "F");
    
    // UI_PMD_ABR230_001_000_G120		Leistungsschalter
    setProductLogicToUIAttribute("PMD_ABR230_001_000_G120", "UI_PMD_ABR230_001_000_G120", "T", "F");
    
}

/**
Funktion zur Übertragung des Logik-Auswahl-Zustandes eines Attributes (eingeschränkt durch Produktlogik) auf ein UI-Checkbox Attribut.

*/
function setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute)
{
    return setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute, "T", "F");
}
function setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute, sValue_True, sValue_False)
{
    sVal_True  = sValue_True  || "T";
    sVal_False = sValue_False || "F";

    var aValidValues = ECL_GetAllActiveAttributeValues(sOrg_Attribute);
    var bValue_T_valid = false;
    var bValue_F_valid = false;
    
    if (aValidValues.length > 0){
        for (var i=0; i < aValidValues.length; i++){
            if (aValidValues[i] == sVal_True){
                bValue_T_valid = true;
            }
            if (aValidValues[i] == sVal_False){
                bValue_F_valid = true;
            }
        }
        
        if (bValue_T_valid && bValue_F_valid){
            ECL_EnableAttribute(sUI_Attribute);
            var sValue = ECL_GetValue(sOrg_Attribute);
            if (sValue == sVal_True){
                ECL_SelectValue(sUI_Attribute, "T");
            }else{
                ECL_DeselectValue(sUI_Attribute, sVal_True);
                ECL_SelectValue(sUI_Attribute, sVal_False);
                ECL_DeselectAttribute(sUI_Attribute);
            }
        }
        else if (bValue_T_valid && !bValue_F_valid){
            ECL_SelectValue(sUI_Attribute, "T");
            ECL_DisableAttribute(sUI_Attribute);
        }
        else if (!bValue_T_valid && bValue_F_valid){
            ECL_DeselectAttribute(sUI_Attribute);
            ECL_DisableAttribute(sUI_Attribute);
        }
    }else{
        ECL_DeselectAttribute(sUI_Attribute);
        ECL_DisableAttribute(sUI_Attribute);
        return 0;
    }
    return 1;
}

/**
Funktion zur Übertragung des Auswahl-Zustandes eines UI-Checkbox-Attributes auf das Original-Attribut.
sOrg_Attribute:	original Produkt-Attrubut, welches durch die Produktlogik gesteuert wird
sUI_Attribute:	UI-Attribut mit Checkbox, auf welches die Logik gespiegelt wird
sValue_True:	Wert 'Ja' des Original-Attributes, wenn er von "T" abweicht		(optional)
sValue_False:	Wert 'Nein' des Original-Attributes, wenn er von "F" abweicht	(optional)
*/
function setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute)
{
    return setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute, "T", "F");
}
function setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute, sValue_True, sValue_False)
{
    sVal_True  = sValue_True  || "T";
    sVal_False = sValue_False || "F";
    
    if (ECL_ValueSelected(sUI_Attribute, "T")){
        
        if (ECL_ValueEnabled(sOrg_Attribute, sVal_True)) {
            ECL_SetValue(sOrg_Attribute, sVal_True);
            
        }else{
            
            if (ECL_ValueEnabled(sOrg_Attribute, sVal_False)) {
                ECL_SetValue(sOrg_Attribute, sVal_False);
            }
            
            ECL_DeselectAttribute(sUI_Attribute);
            ECL_DisableAttribute(sUI_Attribute);
            return 0;
        }
    }else{
        
        if (ECL_ValueEnabled(sOrg_Attribute, sVal_False)) {
            ECL_SetValue(sOrg_Attribute, sVal_False);
        }else{
            return 0;
        }
    }
    
    return 1;
}

function setStandardSupplySystem()
{
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // StandardSupplySystem - Netzfrequenz auslesen, Spannung kommt aus MLFB-Zuordnung VT208
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /*	0	230V 1-phase AC, 50Hz 	
        1	230V 3-phase AC, 50Hz 	
        2	380V 3-phase AC, 50Hz
        3	400V 3-phase AC, 50Hz
        4	415V 3-phase AC, 50Hz
        5	500V 3-phase AC, 50Hz
        6	690V 3-phase AC, 50Hz
        7	240V 1-phase AC, 60Hz
        8	240V 3-phase AC, 60Hz
        9	380V 3-phase AC, 60Hz
        10	400V 3-phase AC, 60Hz
        11	440V 3-phase AC, 60Hz
        12	460V 3-phase AC, 60Hz
        13	480V 3-phase AC, 60Hz
        14	600V 3-phase AC, 60Hz
        15	690V 3-phase AC, 60Hz
    */
    var iVoltage = parseInt(ECL_GetValue("ECSI_CX_StandardSupplySystem"));
    
    switch(iVoltage)
    {
        case 0:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 230);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "50");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00001");
            break;
        case 1:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 230);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "50");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 2:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 380);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "50");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 3:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 400);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "50");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 4:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 415);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "50");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 5:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 500);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "50");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 6:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 690);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "50");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 7:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 240);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "60");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00001");
            break;
        case 8:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 240);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "60");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 9:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 380);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "60");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 10:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 400);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "60");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 11:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 440);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "60");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 12:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 460);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "60");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 13:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 480);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "60");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 14:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 600);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "60");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 15:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 690);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "60");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        case 18:
            ECL_SelectValue("PMD_ABU799_001_000_G120", 480);
            ECL_SelectValue("HMK_NETZFREQUENZ_G120", "50");
            ECL_SelectValue("HMK_ANZAHL_PHASEN_G120", "00002");
            break;
        default:
            return 0;
    }
    return 1;
}

function setProductAttributes(HMK_PRODUKT_TRIG_G120)
{
    // Attribute nach Produkt ein-/ausblenden
    // G120
    if (HMK_PRODUKT_TRIG_G120 == "G120"){
        
        ECL_ActivateAttribute("INFO_FILTER_G120");				// Hinweis interner Netzfilter
        ECL_ActivateAttribute("UI_HMK_EPOS_G120");				// Positionierfunktionalität
        ECL_ActivateAttribute("PMD_ABU278_001_000_G120");		// Geberauswertung
        ECL_ActivateAttribute("INFO_SAFETY_SIZER_G120");
        ECL_ActivateAttribute("UI_HMK_SAFETY_STO_G120");
        ECL_ActivateAttribute("UI_HMK_SAFETY_SS1_G120");
        ECL_ActivateAttribute("UI_HMK_SAFETY_SLS_G120");
        ECL_ActivateAttribute("UI_HMK_SAFETY_SDI_G120");
        ECL_ActivateAttribute("UI_HMK_SAFETY_SSM_G120");
        ECL_ActivateAttribute("UI_HMK_SAFETY_SBC_G120");
        ECL_ActivateAttribute("HMK_F_DI_G120");					// Fehlersichere Digitaleingänge
        ECL_ActivateAttribute("HMK_F_DO_G120");					// Fehlersichere Digitalausgänge
        ECL_ActivateAttribute("UI_HMK_PROFISAFE_G120");			// PROFIsafe
        ECL_ActivateAttribute("TAK_AAN259_001_000_G120");		// Anzahl Digitaleingänge
        ECL_ActivateAttribute("HMK_DI_BERECHNET_G120");			// Anzahl Digitaleingänge
        ECL_ActivateAttribute("PMD_AAA274_001_000_G120");		// Anzahl Analogeingänge
        ECL_ActivateAttribute("TAK_AAM785_001_000_G120");		// Anzahl Digitalausgänge
        ECL_ActivateAttribute("PMD_AAA310_001_000_G120");		// Anzahl Analogausgänge
        ECL_ActivateAttribute("HMK_DI_DO_G120");				// Digital Ein- / Ausgänge
        ECL_ActivateAttribute("UI_HMK_E01_G120");				// E01 Lizenz Extenden Functions Einfachpositionierung (EPos)
        ECL_ActivateAttribute("UI_HMK_SMART_ACCESS_G120");		// Webservermodul
        ECL_ActivateAttribute("UI_HMK_ADAPT_KIT_CUA20_G120");	// Control Unit Adapter Kit CUA20
        ECL_ActivateAttribute("UI_HMK_IOP_HANDHELD_G120");		// IOP-2 Handheld
        ECL_ActivateAttribute("UI_PMD_ABU776_001_000_G120");	// Türmontagesatz für IOP-2/BOP-2
        ECL_ActivateAttribute("UI_PMD_ABU783_001_000_G120");	// Umrichter-Verbindungssatz (PC oder Handheld)
        ECL_ActivateAttribute("UI_HMK_SCHIRMANSCHL_CU_G120");	// Schirmanschlusssatz Control Unit
        ECL_ActivateAttribute("HMK_DSEE_PM_G120");				// Drive Service 'Extended Exchange' für Power Module
        ECL_ActivateAttribute("HMK_DSEE_CU_G120");				// Drive Service 'Extended Exchange' für Control Unit
        //ECL_ActivateAttribute("HMK_DSA_G120");
        ECL_ActivateAttribute("UI_HMK_BRAKERELAY_G120");		// Brake Relay
        ECL_ActivateAttribute("UI_PMD_ABU790_001_000_G120");	// Schirmanschlusssatz Power Modul
        ECL_ActivateAttribute("UI_HMK_FILTER_VPL_G120");		// Du/dt-Filter plus VPL
        ECL_ActivateAttribute("UI_HMK_SINUSFILTER_G120");		// Sinusfilter
        
        ECL_ActivateAttribute("UI_HMK_F01_G120");				// F01 Lizenz Extended Safety
        
        ECL_DeactivateAttribute("UI_HMK_F01_S110_G120");		// F01 Lizenz Extended Safety
        ECL_DeactivateAttribute("UI_HMK_F01_S120_G120");		// F01 Lizenz Extended Safety
        
        ECL_DeselectAttribute("CB_ADVANCED_SAFETY_G120");		// Lizenz Advanced Safety
        ECL_DeactivateAttribute("CB_ADVANCED_SAFETY_G120");		// Lizenz Advanced Safety
        
        ECL_DeactivateAttribute("PMD_AAA136_001_000_1002980");	// Art der Kühlung
        ECL_DeactivateAttribute("UI_HMK_U01_G120");				// DCB Extension
        ECL_DeactivateAttribute("UI_HMK_J01_G120");				// Lizenz hohe Ausgangsfrequenz
        ECL_DeactivateAttribute("HMK_SENSORMODULE_G120");		// Sensor Module Cabinet-Mounted
        ECL_DeactivateAttribute("UI_HMK_BRAKEMODULE_G120");		// Bremsmodul
        ECL_DeactivateAttribute("UI_HMK_TOOL_STARTER_G120");	// Starter-Tool
        
    }else if (HMK_PRODUKT_TRIG_G120 == "S110"){
        ECL_DeactivateAttribute("INFO_FILTER_G120");			// Hinweis interner Netzfilter
        ECL_DeactivateAttribute("PMD_AAA136_001_000_1002980");	// Art der Kühlung
        ECL_DeactivateAttribute("UI_HMK_EPOS_G120");			// Positionierfunktionalität
        ECL_DeactivateAttribute("PMD_ABU278_001_000_G120");		// Geberauswertung
        ECL_DeactivateAttribute("UI_ENCODER_EVALUATION_G120");
        ECL_DeactivateAttribute("INFO_SAFETY_SIZER_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_STO_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_SS1_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_SLS_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_SDI_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_SSM_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_SBC_G120");
        ECL_DeactivateAttribute("HMK_F_DI_G120");				// Fehlersichere Digitaleingänge
        ECL_DeactivateAttribute("HMK_F_DO_G120");				// Fehlersichere Digitalausgänge
        ECL_DeactivateAttribute("UI_HMK_PROFISAFE_G120");		// PROFIsafe
        ECL_DeactivateAttribute("TAK_AAN259_001_000_G120");		// Anzahl Digitaleingänge
        ECL_DeactivateAttribute("HMK_DI_BERECHNET_G120");		// Anzahl Digitaleingänge
        ECL_DeactivateAttribute("PMD_AAA274_001_000_G120");		// Anzahl Analogeingänge
        ECL_DeactivateAttribute("TAK_AAM785_001_000_G120");		// Anzahl Digitalausgänge
        ECL_DeactivateAttribute("PMD_AAA310_001_000_G120");		// Anzahl Analogausgänge
        ECL_DeactivateAttribute("HMK_DI_DO_G120");				// Digital Ein- / Ausgänge
        ECL_DeactivateAttribute("UI_HMK_E01_G120");				// E01 Lizenz Extenden Functions Einfachpositionierung (EPos)
        ECL_DeactivateAttribute("UI_HMK_SMART_ACCESS_G120");	// Webservermodul
        ECL_DeactivateAttribute("UI_HMK_ADAPT_KIT_CUA20_G120");	// Control Unit Adapter Kit CUA20
        ECL_DeactivateAttribute("UI_HMK_IOP_HANDHELD_G120");	// IOP-2 Handheld
        ECL_DeactivateAttribute("UI_PMD_ABU776_001_000_G120");	// Türmontagesatz für IOP-2/BOP-2
        ECL_DeactivateAttribute("UI_PMD_ABU783_001_000_G120");	// Umrichter-Verbindungssatz (PC oder Handheld)
        ECL_DeactivateAttribute("UI_HMK_SCHIRMANSCHL_CU_G120");	// Schirmanschlusssatz Control Unit
        ECL_DeactivateAttribute("HMK_DSEE_PM_G120");			// Drive Service 'Extended Exchange' für Power Module
        ECL_DeactivateAttribute("HMK_DSEE_CU_G120");			// Drive Service 'Extended Exchange' für Control Unit
        //ECL_DeactivateAttribute("HMK_DSA_G120");
        ECL_DeactivateAttribute("UI_HMK_BRAKERELAY_G120");		// Brake Relay
        ECL_DeactivateAttribute("UI_PMD_ABU790_001_000_G120");	// Schirmanschlusssatz Power Modul
        ECL_DeactivateAttribute("UI_HMK_FILTER_VPL_G120");		// Du/dt-Filter plus VPL
        ECL_DeactivateAttribute("UI_HMK_SINUSFILTER_G120");		// Sinusfilter
        ECL_DeactivateAttribute("UI_HMK_U01_G120");				// DCB Extension
        ECL_DeactivateAttribute("UI_HMK_J01_G120");				// Lizenz hohe Ausgangsfrequenz
        ECL_DeactivateAttribute("UI_HMK_BRAKEMODULE_G120");		// Bremsmodul
        /* EDIT 2021.06 TFS 5620128 Removesensor modules from FC
        ECL_ActivateAttribute("HMK_SENSORMODULE_G120");			// Sensor Module Cabinet-Mounted
        */ECL_DeactivateAttribute("HMK_SENSORMODULE_G120");		// Sensor Module Cabinet-Mounted
        
        ECL_ActivateAttribute("UI_HMK_TOOL_STARTER_G120");		// Starter-Tool
        
        ECL_ActivateAttribute("UI_HMK_F01_S110_G120");			// F01 Lizenz Extended Safety
        ECL_DeactivateAttribute("UI_HMK_F01_G120");				// F01 Lizenz Extended Safety
        ECL_DeactivateAttribute("UI_HMK_F01_S120_G120");		// F01 Lizenz Extended Safety
        
        ECL_DeselectAttribute("CB_ADVANCED_SAFETY_G120");		// Lizenz Advanced Safety
        ECL_DeactivateAttribute("CB_ADVANCED_SAFETY_G120");		// Lizenz Advanced Safety
        
    }else if (HMK_PRODUKT_TRIG_G120 == "S120"){
        ECL_DeactivateAttribute("INFO_FILTER_G120");			// Hinweis interner Netzfilter
        ECL_DeactivateAttribute("UI_HMK_EPOS_G120");			// Positionierfunktionalität
        ECL_DeactivateAttribute("PMD_ABU278_001_000_G120");		// Geberauswertung
        ECL_DeactivateAttribute("UI_ENCODER_EVALUATION_G120");
        ECL_DeactivateAttribute("INFO_SAFETY_SIZER_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_STO_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_SS1_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_SLS_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_SDI_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_SSM_G120");
        ECL_DeactivateAttribute("UI_HMK_SAFETY_SBC_G120");
        ECL_DeactivateAttribute("HMK_F_DI_G120");				// Fehlersichere Digitaleingänge
        ECL_DeactivateAttribute("HMK_F_DO_G120");				// Fehlersichere Digitalausgänge
        ECL_DeactivateAttribute("UI_HMK_PROFISAFE_G120");		// PROFIsafe
        ECL_DeactivateAttribute("TAK_AAN259_001_000_G120");		// Anzahl Digitaleingänge
        ECL_DeactivateAttribute("HMK_DI_BERECHNET_G120");		// Anzahl Digitaleingänge
        ECL_DeactivateAttribute("PMD_AAA274_001_000_G120");		// Anzahl Analogeingänge
        ECL_DeactivateAttribute("TAK_AAM785_001_000_G120");		// Anzahl Digitalausgänge
        ECL_DeactivateAttribute("PMD_AAA310_001_000_G120");		// Anzahl Analogausgänge
        ECL_DeactivateAttribute("HMK_DI_DO_G120");				// Digital Ein- / Ausgänge
        ECL_DeactivateAttribute("UI_HMK_E01_G120");				// E01 Lizenz Extenden Functions Einfachpositionierung (EPos)
        ECL_DeactivateAttribute("UI_HMK_SMART_ACCESS_G120");	// Webservermodul
        ECL_DeactivateAttribute("UI_HMK_ADAPT_KIT_CUA20_G120");	// Control Unit Adapter Kit CUA20
        ECL_DeactivateAttribute("UI_HMK_IOP_HANDHELD_G120");	// IOP-2 Handheld
        ECL_DeactivateAttribute("UI_PMD_ABU776_001_000_G120");	// Türmontagesatz für IOP-2/BOP-2
        ECL_DeactivateAttribute("UI_PMD_ABU783_001_000_G120");	// Umrichter-Verbindungssatz (PC oder Handheld)
        ECL_DeactivateAttribute("UI_HMK_SCHIRMANSCHL_CU_G120");	// Schirmanschlusssatz Control Unit
        ECL_DeactivateAttribute("HMK_DSEE_PM_G120");			// Drive Service 'Extended Exchange' für Power Module
        ECL_DeactivateAttribute("HMK_DSEE_CU_G120");			// Drive Service 'Extended Exchange' für Control Unit
        //ECL_DeactivateAttribute("HMK_DSA_G120");
        ECL_DeactivateAttribute("UI_PMD_ABU790_001_000_G120");	// Schirmanschlusssatz Power Modul
        ECL_DeactivateAttribute("UI_HMK_SINUSFILTER_G120");		// Sinusfilter
        ECL_DeactivateAttribute("UI_HMK_TOOL_STARTER_G120");	// Starter-Tool
        
        ECL_ActivateAttribute("PMD_AAA136_001_000_1002980");	// Art der Kühlung
        ECL_ActivateAttribute("UI_HMK_BRAKERELAY_G120");		// Brake Relay
        /* EDIT 2021.06 TFS 5620128 Removesensor modules from FC
        ECL_ActivateAttribute("HMK_SENSORMODULE_G120");			// Sensor Module Cabinet-Mounted
        */ECL_DeactivateAttribute("HMK_SENSORMODULE_G120");		// Sensor Module Cabinet-Mounted
        
        ECL_ActivateAttribute("UI_HMK_U01_G120");				// DCB Extension
        ECL_ActivateAttribute("UI_HMK_J01_G120");				// Lizenz hohe Ausgangsfrequenz
        ECL_ActivateAttribute("UI_HMK_BRAKEMODULE_G120");		// Bremsmodul
        ECL_ActivateAttribute("UI_HMK_FILTER_VPL_G120");		// Du/dt-Filter plus VPL
        
        ECL_ActivateAttribute("UI_HMK_F01_S120_G120");			// F01 Lizenz Extended Safety
        ECL_DeactivateAttribute("UI_HMK_F01_G120");				// F01 Lizenz Extended Safety
        ECL_DeactivateAttribute("UI_HMK_F01_S110_G120");		// F01 Lizenz Extended Safety
        
        ECL_ActivateAttribute("CB_ADVANCED_SAFETY_G120");		// Lizenz Advanced Safety
        
    }
    // ##############################################################################################
}

function SetAttributeLogic1st(sTable, sTargetAttribute, sWhere, sDefault_x)
{
    return SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, false);
}
/**
Wertet eine Variantentabelle für das Zielattribut aus und deaktiviert die nicht gültigen Werte. 
Gültig für weitere Einschränkungen des Merkmals, wenn bereits eine Einschränkung stattgefunden hat.
*/
function SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere, sDefault_x) // bIntersect = true
{
    return SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, true);
}

function SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, bIntersect)// = true weiter einschränken n. Lauf, bei false, erster Lauf,
{
    var sDefault = sDefault_x || "";
    var sSQL = 	"SELECT DISTINCT " + sTargetAttribute + " FROM " + sTable + " WHERE " + sWhere;
    
    var aResult = GetDBDataSetEXT(sSQL, sTable+"_"+sTargetAttribute);
    
    if (aResult.length > 0){
        if (bIntersect){
            var aValidValues = ECL_GetAllActiveAttributeValues(sTargetAttribute);
        }
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
        
        for (var i = 0; i < aResult.length; i++){
            if (bIntersect){
                if (aValidValues.indexOf(aResult[i][sTargetAttribute]) > -1){
                    ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
                }
            }else{
                ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
            }
        } 
        
        if (aResult.length == 1){
            // ECL_SelectValue(sTargetAttribute, aResult[0][sTargetAttribute]);
        }
        else
        {
            ExecSetStandardifValueEmpty(sTargetAttribute, sDefault);
        }
    }
    else{
        // Fehler;
        return "Error";
    }
    return 0;
}


function checkSafetyFunctions(sECSI_CX_SafetyFunctions, HMK_PRODUKT_TRIG_G120)
{
        
    if (HMK_PRODUKT_TRIG_G120 == "G120" &&
        (sECSI_CX_SafetyFunctions.indexOf("5") > -1 || 
         sECSI_CX_SafetyFunctions.indexOf("6") > -1 || 
         sECSI_CX_SafetyFunctions.indexOf("7") > -1 || 
         sECSI_CX_SafetyFunctions.indexOf("8") > -1 || 
         sECSI_CX_SafetyFunctions.indexOf("9") > -1 || 
         sECSI_CX_SafetyFunctions.indexOf("10") > -1 || 
         sECSI_CX_SafetyFunctions.indexOf("12") > -1))
    {
        // SafetyFunction wird nicht unterstützt
        return "ERROR";
    }
    
    if (HMK_PRODUKT_TRIG_G120 == "S110" &&
        (sECSI_CX_SafetyFunctions.indexOf("7") > -1 || 
         sECSI_CX_SafetyFunctions.indexOf("8") > -1 || 
         sECSI_CX_SafetyFunctions.indexOf("9") > -1 || 
         sECSI_CX_SafetyFunctions.indexOf("10") > -1 || 
         sECSI_CX_SafetyFunctions.indexOf("12") > -1))
    {
        // SafetyFunction wird nicht unterstützt
        return "ERROR";
    }
    // S120 unterstützt alle
    
    return 1;
}

function enableProductRelevantFW()
{
    ECL_DeactivateAttribute("FIRMWARE_VERSION_G120");
    ECL_SetValue("FIRMWARE_VERSION_G120", "");
    var memoryCard = ECL_GetValue("HMK_MEMORYCARD_G120");
    if( memoryCard === "00235" )
    {
        // IDs like: G120_V4.6 SP3
        ECL_ActivateAttribute("FIRMWARE_VERSION_G120");
        var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
        ECL_DeactivateAllAttributeValues("FIRMWARE_VERSION_G120");
        var allValues = ECL_GetAllAttributeValues("FIRMWARE_VERSION_G120");
        
        for(var i = 0; i < allValues.length; i++)
        {
            var ident = allValues[i].left(4);
            if( ident === product)
            {
                ECL_ActivateValue("FIRMWARE_VERSION_G120", allValues[i]);
            }
        }
        determineFwVersion();
    }
}

function determineFwVersion()
{
    var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
    var keepConfigValue = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    ECL_SetUserVariable("lastDevice", product)
    if(keepConfigValue == 1)
    {
        var secondaryMlfbs = GetMlfbSec();
        var lastDevice = getLastDeviceFromSecondaryMlfbs(secondaryMlfbs);
        ECL_SetUserVariable("lastDevice", lastDevice)
    }
    
    var previousDevice = ECL_GetUserVariable("lastDevice");
    if(previousDevice !== product)
    {
        var firmwareIdentifier = getDefaultFirmwareVersionIdentifier();
        ECL_SelectValue("FIRMWARE_VERSION_G120", firmwareIdentifier);
        return;
    }
    
    var secondaryMlfbString = ECL_GetValue("ECSI_MLFB_SEC") || "";
    var sECSI_MLFB_SEC = GetMlfbSec();
    if(secondaryMlfbString !== "[]" && secondaryMlfbString !== "")
    {
        var secondaryMlfbs = JSON.parse(secondaryMlfbString);
        for(var i = 0; i < secondaryMlfbs.length; i++)
        {
            var mlfb = removeShortOptionsFromMlfb(secondaryMlfbs[i]["mlfb"]);
            if(mlfbInFwDb(mlfb))
            {
                var query = "SELECT * FROM FIRMWARE WHERE MLFB='" + mlfb + "';";
                var result = Object.fromDatabase("FIRMWARE_DATA", query);
                var firmwareIdentifier = product + "_" + result[0]["VERSION"];
                ECL_SelectValue("FIRMWARE_VERSION_G120", firmwareIdentifier);
            }
        }
    }
}

function determineFwVersionSpike(sECSI_MLFB_SEC)
{
    var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
    var memoryCard = ECL_GetValue("HMK_MEMORYCARD_G120");
    var keepConfigValue = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    ECL_SetUserVariable("lastDevice", product)
    if(keepConfigValue == 1)
    {
        var secondaryMlfbs = sECSI_MLFB_SEC;
        var lastDevice = getLastDeviceFromSecondaryMlfbs(secondaryMlfbs);
        ECL_SetUserVariable("lastDevice", lastDevice)
    }
    
    var previousDevice = ECL_GetUserVariable("lastDevice");
    if(previousDevice !== product && previousDevice != 0)
    {
        var firmwareIdentifier = getDefaultFirmwareVersionIdentifier();
        ECL_SelectValue("FIRMWARE_VERSION_G120", firmwareIdentifier);
        return;
    }
    
    var secondaryMlfbFragments = sECSI_MLFB_SEC.split(";");
    var values = ECL_GetAllSelectedAttributeValues("FIRMWARE_VERSION_G120");
    if(values.length == 1)
    {
        ECL_SelectValue("FIRMWARE_VERSION_G120", values[0]);
        return;
    }
    
    for(i=0; i<secondaryMlfbFragments.length;i++)
    {
        if(secondaryMlfbFragments[i].length > 1)
        {
            var mlfb = removeShortOptionsFromMlfb(secondaryMlfbFragments[i]);
            if(mlfbInFwDb(mlfb))
            {
                var query = "SELECT * FROM FIRMWARE WHERE MLFB='" + mlfb + "';";
                var result = Object.fromDatabase("FIRMWARE_DATA", query);
                var firmwareIdentifier = product + "_" + result[0]["VERSION"];
                ECL_SelectValue("FIRMWARE_VERSION_G120", firmwareIdentifier);
            }
        }
    }
}

function mlfbInFwDb(mlfb)
{
    var query = "SELECT * FROM FIRMWARE WHERE MLFB='" + mlfb + "';";
    var result = Object.fromDatabase("FIRMWARE_DATA", query);
    if(result.length > 0)
    {
        return true;
    }
    return false;
}

function disableShortOptionsForFirmware()
{
    // use: ALL_SHORT_OPTIONS
    var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
    var mlfb = getMemoryCardMlfb();
    var query = (
                    "SELECT SHORT_OPTIONS FROM FIRMWARE WHERE " +
                    "MLFB='"+ mlfb +"'"+
                    ";"	
                );
    var result = Object.fromDatabase("FIRMWARE_DATA", query);
    if(result.length == 1)
    {
        var shortOptionsString = result[0]["SHORT_OPTIONS"];
        var shortOptionsArray = shortOptionsString.split("|");
        var elementsToDisable = ALL_SHORT_OPTIONS.filter(function(element){
            var elementFound = shortOptionsArray.indexOf(element);
            if( elementFound > -1)
            {
                return false;
            }
            else
            {
                return true;
            }
        });
        for(i=0; i < elementsToDisable.length; i++)
        {
            if(elementsToDisable[i] === "A01")
            {
                ECL_DisableAttribute("CB_ADVANCED_SAFETY_G120");
                ECL_DeselectValue("CB_ADVANCED_SAFETY_G120", "T");
                continue;
            }
            
            var attribute = "HMK_" + elementsToDisable[i] + "_G120";
            var uiAttribute = "UI_" + attribute;
            if(product !== "G120" && elementsToDisable[i] === "F01")
            {
                uiAttribute = "UI_HMK_" + elementsToDisable[i] + "_" + product + "_G120";
            }
            
            var selectedValuesForAttribute = ECL_GetAllSelectedAttributeValues(attribute);
            selectedValuesForAttribute.forEach(function(element) {
                ECL_DeselectValue(attribute, element);
            });
            ECL_DisableAttribute(attribute);
            
            var selectedValuesForUiAttribute = ECL_GetAllSelectedAttributeValues(uiAttribute);
            selectedValuesForUiAttribute.forEach(function(element) {
                ECL_DeselectValue(uiAttribute, element);
            });
            ECL_DisableAttribute(uiAttribute);
        }
    }
}

function getMemoryCardMlfb()
{
    var versionIdentifier = ECL_GetValue("FIRMWARE_VERSION_G120");
    
    var secondaryMlfbString = ECL_GetValue("ECSI_MLFB_SEC") || "";
    var sECSI_MLFB_SEC = GetMlfbSec();
    
    var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
    var versionFragments = versionIdentifier.split("_");
    var version = versionFragments[1];
    var query = (
                    "SELECT MLFB, STATUS, NEWEST FROM FIRMWARE WHERE " +
                    "PLATFORM='"+ product +"' AND " +
                    "VERSION='"+ version +"' AND " +
                    "PERFORMANCE_VARIANT='false' " +
                    ";"	
                );
    var result = Object.fromDatabase("FIRMWARE_DATA", query);
    if(result.length === 1)
    {
        if(result[0]["STATUS"] == "410")
        {
            ECL_SelectValue("ECSI_STATUS", "WARNING");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate("STATUS_MSG_FIRMWARE_VERSION_UNAVAILABLE_G120"));
            ECL_DisableValue("FIRMWARE_VERSION_G120", versionIdentifier);
        }
        if(result[0]["STATUS"] != "410" && result[0]["NEWEST"] === "false")
        {
            ECL_SelectValue("ECSI_STATUS", "WARNING");
            ECL_SetValue("ECSI_STATUS_MESSAGE", translate("STATUS_MSG_FIRMWARE_VERSION_OUTDATED_G120"));
        }
        return result[0]["MLFB"];
    }

    return 0;    
}

function getSeparator(mlfb)
{
    var separator = mlfb.indexOf("-Z ") == -1 ? " " : "-Z ";
    return separator
}

function removeShortOptionsFromMlfb(mlfb)
{
    var shortOptionZIndex = mlfb.indexOf(getSeparator(mlfb)) == -1 ? mlfb.length : mlfb.indexOf("-Z ");
    return mlfb.substring(0, shortOptionZIndex);
}

function getShortOptions(mlfb)
{
    var shortOptionZIndex = mlfb.indexOf(getSeparator(mlfb)) == -1 ?  mlfb.length : mlfb.indexOf(getSeparator(mlfb));
    var shortOptionsString = mlfb.substring(shortOptionZIndex+3, mlfb.length);
    if(shortOptionsString == "")
    {
        return [];
    }
    var shortOptions = shortOptionsString.split("+");
    return shortOptions;
}

function hasPerformanceOption(mlfb)
{
    var versionIdentifier = ECL_GetValue("FIRMWARE_VERSION_G120");	
    var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
    var versionFragments = versionIdentifier.split("_");
    var version = versionFragments[1];
    var query = (
                    "SELECT * FROM FIRMWARE WHERE " +
                    "PLATFORM='"+ product +"' AND " +
                    "VERSION='"+ version +"' AND " +
                    "PERFORMANCE_VARIANT='false'" +
                    ";"	
                );
    var result = Object.fromDatabase("FIRMWARE_DATA", query);
    if(result.length > 0)
    {
        return true;
    }
    return false;
}

function isShortOptionAvailable(shortOption, mlfb)
{
    var sQuery = "SELECT SHORT_OPTIONS FROM FIRMWARE WHERE MLFB='" + mlfb + "';";
    var aDbResult = Object.fromDatabase("FIRMWARE_DATA", sQuery);
    if(aDbResult.length == 1)
    {
        var options = aDbResult[0]["SHORT_OPTIONS"];
        var possibleShortOptions = options.split("|");
        for(var i = 0; i < possibleShortOptions.length; i++)
        {
            if(possibleShortOptions[i] == shortOption)
            {
                return true;
            }
        }
    }
    return false;
}

function determineshortOptionsState(secMlfb)
{
    ECL_SelectValue("HMK_F01_G120", "NON");
    ECL_SelectValue("HMK_E01_G120", "NON");
    ECL_SelectValue("HMK_J01_G120", "F");
    ECL_SelectValue("HMK_U01_G120", "F");
    ECL_SelectValue("CB_ADVANCED_SAFETY_G120", "F");

    var mlfb = removeShortOptionsFromMlfb(secMlfb);
    var options = getShortOptions(secMlfb);
    for(var i = 0; i <options.length; i++)
    {
        if(options[i] === "A01" && isShortOptionAvailable("A01",mlfb))
        {
            ECL_SelectValue("CB_ADVANCED_SAFETY_G120", "T");
            continue;
        }
        else if(options[i] === "F01" && isShortOptionAvailable("F01",mlfb))
        {
            ECL_SelectValue("HMK_F01_G120", "F01");
            continue;
        }
        else if(options[i] === "E01" && isShortOptionAvailable("E01",mlfb))
        {
            ECL_SelectValue("HMK_F01_G120", "E01");
            continue;
        }
        else if(options[i] === "J01" && isShortOptionAvailable("J01",mlfb))
        {
            ECL_SelectValue("HMK_F01_G120", "T");
            continue;
        }
        else if(options[i] === "U01"  && isShortOptionAvailable("U01",mlfb))
        {
            ECL_SelectValue("HMK_F01_G120", "U01");
            continue;
        }
    }
    var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
    setCheckBoxAttributes(product);
}

function getDefaultFirmwareVersion()
{
    var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
    var sQuery = (
                    "SELECT VERSION FROM FIRMWARE WHERE " +
                    "PLATFORM='"+ product +"' AND " +
                    "NEWEST='true' AND " +
                    "PERFORMANCE_VARIANT='false'" +
                    ";"	
                );
    var aDbResult = Object.fromDatabase("FIRMWARE_DATA", sQuery);
    if(aDbResult.length == 1)
    {
        result = aDbResult[0];
        return result["VERSION"];
    }
}

function getDefaultFirmwareVersionIdentifier()
{
    var product = ECL_GetValue("HMK_PRODUKT_TRIG_G120");
    
    var defaultVersion = getDefaultFirmwareVersion();
    
    var firmwareIdentifier = product + "_" + defaultVersion;
    
    return firmwareIdentifier
}

function getLastDeviceFromSecondaryMlfbs(secondaryMlfbs)
{
    secMlfbArray = secondaryMlfbs.split(";");
    for(var i=0; i < secMlfbArray.length; i++)
    {
        var mlfbWithoutShortOptions = removeShortOptionsFromMlfb(secMlfbArray[i]);
        if(mlfbInFwDb(mlfbWithoutShortOptions))
        {
            var sQuery = (
                    "SELECT PLATFORM FROM FIRMWARE WHERE " +
                    "MLFB='"+ mlfbWithoutShortOptions +"' AND " +
                    "PERFORMANCE_VARIANT='false'" +
                    ";"	
                );
            var aDbResult = Object.fromDatabase("FIRMWARE_DATA", sQuery);
            if(aDbResult.length == 1)
            {
                result = aDbResult[0];
                return result["PLATFORM"]
            }
        }
    }
}

function getVpmMlfbById(choiceId)
{
    switch(choiceId)
    {
        case "VPM_NONE_S110_S120":
            var vpmMlfb = null;
        break;
        case "VPM_120_S110_S120":
            var vpmMlfb = "6SN11131AA001JA1";
        break;
        case "VPM_200_S110_S120":
            var vpmMlfb = "6SN11131AA001KA1";
        break;
        case "VPM_200_DYNAMIK_S110_S120":
            var vpmMlfb = "6SN11131AA001KC1";
        break;
        default:
            var vpmMlfb = null;
        break;
    }
    return vpmMlfb;
}

function getEncoderEvaluationValue()
{
    var cu = ECL_GetValue("HMK_TYPE_CU_G120");
    var safetySTO = ECL_GetValue("HMK_SAFETY_STO_G120");
    var safetySS1 = ECL_GetValue("HMK_SAFETY_SS1_G120");
    var safetySLS = ECL_GetValue("HMK_SAFETY_SLS_G120");
    var safetySDI = ECL_GetValue("HMK_SAFETY_SDI_G120");
    var safetySSM = ECL_GetValue("HMK_SAFETY_SSM_G120");
    var safetySBC = ECL_GetValue("HMK_SAFETY_SBC_G120");
    var digitalInputsSafe = ECL_GetValue("HMK_F_DI_G120");
    var digitalInOut = ECL_GetValue("HMK_DI_DO_G120");
    // enc eval
    var epos = ECL_GetValue("HMK_EPOS_G120");
    
    var query = "SELECT DISTINCT PMD_ABU278_001_000_G120 FROM VT_G120_M00268_" + sDB_Version + " WHERE " + 
                +"HMK_TYPE_CU_G120=? AND " + 
                +"PMD_ABU804_001_000_G120=? AND " + 
                +"HMK_SAFETY_STO_G120=? AND " +
                +"HMK_SAFETY_SS1_G120=? AND " +
                +"HMK_SAFETY_SLS_G120=? AND " +
                +"HMK_SAFETY_SDI_G120=? AND " +
                +"HMK_SAFETY_SSM_G120=? AND " +
                +"HMK_SAFETY_SBC_G120=? AND " +
                +"HMK_F_DI_G120=? AND " +
                +"TAK_AAN259_001_000_G120=? AND " + 
                +"PMD_AAA274_001_000_G120=? AND " + 
                +"TAK_AAM785_001_000_G120=? AND " +
                +"PMD_AAA310_001_000_G120=? AND " + 
                +"HMK_DI_DO_G120=? AND " +
                +"HMK_EPOS_G120=? AND " +
                +"HMK_VALUE_VALID_G120='T';";
                
    var params = [
        cu,
        ECL_GetValue("PMD_ABU804_001_000_G120"),
        safetySTO,
        safetySS1,
        safetySLS,
        safetySDI,
        safetySSM,
        safetySBC,
        digitalInputsSafe,
        ECL_GetValue("TAK_AAN259_001_000_G120"),
        ECL_GetValue("PMD_AAA274_001_000_G120"),
        ECL_GetValue("TAK_AAM785_001_000_G120"),
        ECL_GetValue("PMD_AAA310_001_000_G120"),
        digitalInOut,
        epos
    ];
    var result = Object.fromDatabase("EXTERNAL_DATA", query, params);
    if(result.length > 0)
    {
        for(var i=0; i < result.length; i++)
        {
            var value = result[i].PMD_ABU278_001_000_G120;
            if(value != "00001")
            {
                return value;
            }
        }
        //return "00001";
    }
    else
    {
        return "00001";
    }
}

function enableCu250Only()
{
    ECL_DeactivateAllAttributeValues("HMK_TYPE_CU_G120");

    var desiredOptions = ["00320", "00321", "00322", "00323"];

    for(var i = 0; i< desiredOptions.length; i++)
    {
        ECL_ActivateValue("HMK_TYPE_CU_G120", desiredOptions[i]);
    }
}

function setSeriesID() {
    var SeriesID = ECL_GetValue("ECSI_CX_SeriesID") || "";
    SeriesID = SeriesID.left(5);
    /*
    71201 SINAMICS G120 PM240-2
    71207 SINAMICS G120 PM250 
    30120, 62200, 62201, 61202 SINAMICS S120 AC/AC 
    62300 SINAMICS S110
    */
    
    switch(SeriesID){
        //case "G120":
        case "71201":
        case "71207":
            ECL_ActivateAttribute("SAFETY_INFO_SSM_G120");
            ECL_ActivateAttribute("SAFETY_INFO_SLS_G120");
            ECL_ActivateAttribute("SAFETY_INFO_SDI_G120");
            return "G120";	
        break;
        //case "S110":s
        case "62300":
            return "S110";
        break;
        //case "S120":
        case "30120":
        case "62200":
        case "62201":
        case "61202":
            return "S120";
        break;
    }
}
