//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_G120C
// 	Date: 2021-06-02
// 	User: Administrator
// ---------------------------------------------------------
//#mode(full-ecma)

 // include easyKAT Configuration Library
//@import "SIZER_general_functions.js"


 // include new Variant Tables

 VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
 var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables
 
 var sDB_Version = "27122";			// DB-Version
 var sDB_Suffix = "_" + sDB_Version;	// DB-TableSuffix
 globalThis.OnChangeConfiguration = function main()
 {
   /* MLFB-Struktur
   
     Aktuell sind im SIZER in der Primär-MLFB die Stellen 14 und 15 nicht belegt (Filterklasse und Bussystem)
     
     <------ Stelle 1 bis 10 fix --------->	
     MLFB01	MLFB07	MLFB08	MLFB09	MLFB10 	MLFB11	MLFB12	MLFB13	MLFB14	MLFB15 	MLFB16	MLFB_KEY		PMD_ABW171_001_000_G120C
     6SL321	0		1		K		E		1		7		5		.		.		1		00006			00001
     6SL321	0		1		K		E		1		8		8						1		00007			00001
     6SL321	0		1		K		E		2		1		3						1		00008			00002
     6SL321	0		1		K		E		2		1		7						1		00009			00002
     6SL321	0		1		K		E		2		2		6						1		00010			00003
     6SL321	0		1		K		E		2		3		2						1		00011			00003
     6SL321	0		1		K		E		2		3		8						1		00012			00003
     6SL321	0		1		K		E		1		1		8						2		00013			Z0005
     6SL321	0		1		K		E		1		2		3						2		00014			Z0005
     6SL321	0		1		K		E		1		3		2						2		00015			Z0005
     6SL321	0		1		K		E		1		4		3						2		00016			Z0005
     6SL321	0		1		K		E		1		5		8						2		00017			Z0005
     6SL321	0		1		K		E		2		4		4						1		00019			Z0004
     6SL321	0		1		K		E		2		6		0						1		00020			Z0004
     6SL321	0		1		K		E		2		7		0						1		00021			Z0004
     6SL321	0		1		K		E		2		8		4						1		00022			Z0004
     6SL321	0		1		K		E		3		1		1						1		00023			Z0009
     6SL321	0		1		K		E		3		1		4						1		00026			Z0010
     6SL321	0		1		K		E		3		1		7						1		00027			Z0010
     6SL321	0		1		K		E		3		2		1						1		00024			Z0010
     6SL321	0		1		K		E		3		2		4						1		00025			Z0010
     
     MLFB01-10: fix
     MLFB11: Kommastelle Leistung (1, 2, 3)
     MLFB12: Leistung 1 (1-8)	Zuordnung zu Attribut noch unklar! 
     MLFB13: Leistung 2 (0-8)	Zuordnung zu Attribut noch unklar!	--> SZ_U_I_Bem
     MLFB14: ZO Filterklasse (A, U) - PMD_AAD146_001_000_G120C
     MLFB15:	ZO Bussystem (B, P, F) - PMD_ABU804_001_000_G120C
     MLFB16:	(1, 2) - Bauform des Umrichters (FSAA: 2, FSA, FSB, FSC, FSD, FSE, FSF: 1) - PMD_ABW171_001_000_G120C
     
     MLFB11	MLFB12	MLFB13	MLFB16				SZ_U_I_Bem
     Komma	L1		L2		ggf. Bauform?
     1		1		8		2					1,8
     1		2		3		2					2,3
     1		3		2		2					3,2
     1		4		3		2					4,3
     1		5		8		2					5,8
     1		7		5		1					7,5
     1		8		8		1					9
     2		1		3		1					13
     2		1		7		1					17
     2		2		6		1					26
     2		3		2		1					32
     2		3		8		1					38
 
     MLFB16	SZ_U_Baugroesse
     2			FSAA
     1			FSA
     1			FSB
     1			FSC
     
     Safety: Nur STO
 
     Netzfilter 
     integriert: ungefiltert, A
     extern B, nur wenn nicht integriert!
 */
         
     SetAttributesFromMlfb();
     
     var sECSI_MLFB					= "";		// Parameter für Basis-MLFB
     var sECSI_MLFB_SEC				= "";		// Parameter für zusätzliche MLFBs
     var sECSI_MLFB_BASE_TYPE 		= "";
     
     var sECSI_STATUS 				= "";		// Status für MLFB-Übergabe
     var sECSI_STATUS_MESSAGE 		= "";		// Statusmeldung für MLFB-Übergabe
     
     var sDezimalkenner 				= "";		// Leistungsparameter aus MLFB
     var sLeistung1 					= "";		// Leistungsparameter aus MLFB
     var sLeistung2 					= "";		// Leistungsparameter aus MLFB
     var sLeistung 					= "";		// Gesamtwert (String)
     
     var sFilter						= "";		// Filter aus MLFB14
     var sFilterParam				= ""; 		// Filterparameter (Z0002 - A, 00004 - ungefiltert)
     
     var sBus						= "";		// Bussystem aus MLFB15 (B, P, F
     var sBusParam					= ""; 		// Bussystemparameter (00001 (P), 00002 (F), 00006, 00013 (B) )
     var sStatusBR 					= "ohne";	// Status Regenerativer Modus / Bremswiderstand
     
     var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
     
     var sCurrentAttribute = ECL_GetCurrentAttribute() || "";
 
     // Dummy Aufrufe von SIZER unterdrücken
     if (sCurrentAttribute == ''){
         return;
     }
     
     if(sCurrentAttribute.left(7) == "ECSI_CX")
         return;
     
     // ##############################################################################################
     // INIT
     // ##############################################################################################
     
     if(sCurrentAttribute === "@INIT@")
     {
         // Zusätzliche MLFBs
         //ECL_DisableAttribute("ECSI_MLFB_SEC");
         ECL_EnableAttribute("PMD_ABU804_001_000_G120C");
         // Status Interface
         ECL_DisableAttribute("ECSI_STATUS");
         ECL_DeactivateAttribute("ECSI_STATUS_MESSAGE");

         ECL_DeactivateAttribute("PMD_ABU778_001_000_G120C"); // Zusatzmerkmal für BOP
         ECL_DeactivateAttribute("PMD_ABU779_001_000_G120C"); // Zusatzmerkmal für IOP

         ECL_DeactivateAttribute("HMK_FIRMWARE_G120C");

         ECL_DeactivateAttribute("MLFB_KEY_G120C"); // 
         ECL_DeactivateAttribute("MLFB14_G120C"); // 
         ECL_DeactivateAttribute("MLFB15_G120C"); // 
         
         
         ECL_DisableAttribute("PMD_ABW171_001_000_G120C"); // Bauform
         
         return; 	// -mw- nach Init direkt return, denn ein separater Aufruf mit MLFB folgt ja noch 
     }
     
     var sRegenerativeModeContext = ECL_GetValue("ECSI_CX_RegenerativeMode");
     
     if (sRegenerativeModeContext > 0)
     {
         sStatusBR = "mit";
     }
     
     var ECSI_CX_CustomBrakingResistor = ECL_GetValue("ECSI_CX_CustomBrakingResistor");
     var ECSI_CX_Certificates 		  = ECL_GetValue("ECSI_CX_Certificates") || "";
     
     if (ECSI_CX_Certificates && ECSI_CX_Certificates.indexOf("ULR_CSA") > -1){
         ECL_ActivateAttribute("HMK_NEMAKIT_G120C");
     }else{
         ECL_DeactivateAttribute("HMK_NEMAKIT_G120C");
         ECL_SetValue("HMK_NEMAKIT_G120C", "F");
     }
     // ##############################################################################################
     
     // #####################################################################################################################################
     // MLFB-PARSER
     // #####################################################################################################################################
     sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
     if (sECSI_MLFB == "")
         return;
         
     if (sCurrentAttribute == "ECSI_MLFB")
     {
         sECSI_MLFB_BASE_TYPE = ECL_GetValue("ECSI_MLFB_BASE_TYPE") || "";
         if (sECSI_MLFB_BASE_TYPE == ""){
             return;
         }
         
         sECSI_MLFB = sECSI_MLFB.replace(/\s+/g, ""); 			// Leerzeichen entfernen
         sECSI_MLFB = sECSI_MLFB.replace("-", ""); 				// Bindestriche entfernen
         sECSI_MLFB= sECSI_MLFB.replace("?", ".").toUpperCase(); // Fragezeichen ersetzen
         ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
         
         // Prüfen, ob die Zeichenkette 16 Stellen hat
         if (sECSI_MLFB.length != 16)
         {
             // Übergabefehler abfangen
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MLFB_FAILURE_G120C") + " "; //"MLFB zu kurz oder zu lang, ggf. unvollständig. ";
         }
         if (sECSI_MLFB.indexOf("6SL32101KE") < 0)
         {
             // Falsches Produkt
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_PRODUCT_G120C") + " "; //"Falsches Produkt übergeben. Nicht G120C. ";
         }
         
         //#########################################################################################################################
         // Keep Configuration
         //#########################################################################################################################
         var sECSI_MLFB_fix = sECSI_MLFB;
         
         if (sECSI_MLFB_BASE_TYPE.charAt(13) == "."){
             sECSI_MLFB_fix = replaceAt(sECSI_MLFB_fix, 13, ".");
         }
         if (sECSI_MLFB_BASE_TYPE.charAt(14) == "."){
             sECSI_MLFB_fix = replaceAt(sECSI_MLFB_fix, 14, ".");
         }
         
         var bKeepConf = false;
         
         if( (sECSI_MLFB_BASE_TYPE!=sECSI_MLFB_fix) && find(sECSI_MLFB.left(16), ".") < 0 && sECSI_MLFB_BASE_TYPE != "")
         {
             //bKeepConf = true;
             
             if (sECSI_MLFB_BASE_TYPE.charAt(13) == "."){
                 var sFilterKC = sECSI_MLFB.charAt(13);
                 bKeepConf = true;
             }
             if (sECSI_MLFB_BASE_TYPE.charAt(14) == "."){
                 var sBusKC = sECSI_MLFB.charAt(14);
                 bKeepConf = true;
             }
             sECSI_MLFB = sECSI_MLFB_BASE_TYPE;
             ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
         }
         //#########################################################################################################################
             
         
         
         
         // Leistungsdaten herauslesen MLFB11
         sDezimalkenner = sECSI_MLFB.charAt(10); // wenn 1: 0,xx | wenn 2: x,x | wenn 3: xx
         var aValidValues1 = ["1", "2", "3"]; // ggf. aus DB-VT holen?
         if (aValidValues1.indexOf(sDezimalkenner) < 0)
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DECIMAL_IDENT_OUTOFRANGE_G120C") + " ";//"Dezimalkenner für Leistungsangabe nicht im zulässigen Bereich. ";
         }
         
         sLeistung1 = sECSI_MLFB.charAt(11); //MLFB12
         var aValidValues2 = ["1", "2", "3", "4", "5", "6", "7", "8"]; // ggf. aus DB-VT holen?
         if (aValidValues2.indexOf(sLeistung1) < 0)
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___POWER_VALUE_1_OUTOFRANGE_G120C") + " '" + sLeistung1 + "' ";
         }
         
         sLeistung2 = sECSI_MLFB.charAt(12); //MLFB13
         var aValidValues3 = ["0", "1", "2", "3", "4", "5", "6", "7", "8"]; // ggf. aus DB-VT holen?
         if (aValidValues3.indexOf(sLeistung2) < 0)
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___POWER_VALUE_2_OUTOFRANGE_G120C") + " '" + sLeistung2 + "' ";
         }
         //Leistungsdaten abfragen und setzen:
         var sSQL = "SELECT * FROM VT_G120C_M00101_27122 WHERE MLFB11_G120C = '" +  sDezimalkenner + "' AND MLFB12_G120C = '" 
                                 +  sLeistung1 + "' AND MLFB13_G120C = '" +  sLeistung2 + "' AND HMK_VALUE_VALID_G120C = 'T';"; 
         var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
         
         if (aResult.length > 0)
         {
             var MLFB_KEY_G120C = aResult[0].MLFB_KEY_G120C;
             ECL_SetValue("MLFB_KEY_G120C", MLFB_KEY_G120C); 						// MLFB-Key
             ECL_SetValue("PMD_ABW171_001_000_G120C", aResult[0].PMD_ABW171_001_000_G120C); 	// Bauform des Umrichters
         }
         else
         {
             // Fehler: für Leistungsdaten kein Treffer in VT:
             sECSI_STATUS = "E"; 
             if (sDezimalkenner == "1") 
             {
                 sLeistung = "0," + sLeistung1 + sLeistung2 + "A";
             }
             else if (sDezimalkenner == "2") 
             {
                 sLeistung = sLeistung1 + "," + sLeistung2 + "A";
             }
             else //"3"
             {
                 sLeistung = sLeistung1 + sLeistung2 + "A";
             }
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___NO_VALUE_VT_POWER_G120C") + " '" + sLeistung + "' ";
         }
         // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         // Filterdaten herauslesen
         // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         
         sFilter = sECSI_MLFB.charAt(13); // MLFB14 wenn U: ungefiltert, wenn A: Filter A
         var aValidValues14 = ["U", "A", "."]; // ggf. aus DB-VT holen?
         if (aValidValues14.indexOf(sFilter) < 0)
         {
             // Fehler
             sFilter = ".";
             var aECSI_MLFB = sECSI_MLFB.split('');
             aECSI_MLFB[13] = sFilter;
             sECSI_MLFB = aECSI_MLFB.join('');
         }
         else
         {
             if (sFilter == ".") // Wenn Platzhalter, dann Default 'U' 		//durch Benutzer definieren 
             {
                 // Wenn KeepConfiguration, prüfen, ob Wert übernommen werden kann
                 if (sFilterKC){
                     ECL_SetValue("MLFB14_G120C", sFilterKC);
                     sECSI_MLFB = replaceAt(sECSI_MLFB, 13, sFilterKC);
                     ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                     switch (sFilterKC){
                         case "U":
                             ECL_SetValue("PMD_AAD146_001_000_G120C", "00004");
                         break;
                         
                         case "A":
                             ECL_SetValue("PMD_AAD146_001_000_G120C", "Z0002");
                         break;
                     }
                 }else
                 {
                     ECL_SetValue("MLFB14_G120C", "U");
                     sECSI_MLFB = replaceAt(sECSI_MLFB, 13, "U");
                     ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                     ECL_SetValue("PMD_AAD146_001_000_G120C", "00004");
                 }
             }
             else // sonst aus MLFB setzen
             {
                 //Filter aus VT setzen
                 ECL_SetValue("MLFB14_G120C", sFilter); // alternativ direkte DB-Abfrage und MLFB14 weglassen!
                 if (sFilter == "A")
                 {
                     ECL_SetValue("PMD_AAD146_001_000_G120C", "Z0002");
                     ECL_DeselectAttribute("HMK_NETZFILTER_EXT_G_G120C");		// externen Netzfilter entsprechend anpassen
                     ECL_DisableAttribute("HMK_NETZFILTER_EXT_G_G120C");		// 
                 }
                 else if (sFilter == "U")
                 {
                     ECL_SetValue("PMD_AAD146_001_000_G120C", "00004");
                     ECL_EnableAttribute("HMK_NETZFILTER_EXT_G_G120C");		// externen Netzfilter entsprechend anpassen
                 }
             }
         }
         // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         
         
         // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         // Bussystemdaten herauslesen; hier können auch externe Preferences eine Rolle spielen
         // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         sBus = sECSI_MLFB.charAt(14); // MLFB15 (B, P, F) // F (ProfiNet) geht immer, P & B sind baugrößenabhängig VT_M00085
         var sFieldbusInterface = ECL_GetValue("ECSI_CX_FieldbusInterface");	
         var bFieldbusPreference = false;
         var iFieldbusInterface  = -1;
         ECL_EnableAttribute("PMD_ABU804_001_000_G120C");
                 
         // Fehler abfangen
         var aValidValues15 = ["B", "P", "F", "."]; // ggf. aus DB-VT holen?
         if (aValidValues15.indexOf(sBus) < 0)
         {
             // Fehler
            sBus = ".";
            var aECSI_MLFB = sECSI_MLFB.split('');
            aECSI_MLFB[14] = sBus;
            sECSI_MLFB = aECSI_MLFB.join('');
         }
         if (sFieldbusInterface !== "" && sFieldbusInterface !== undefined)
         {
             iFieldbusInterface = parseInt(sFieldbusInterface);
             if (iFieldbusInterface >= 0) {
                 bFieldbusPreference = true;
                 ECL_DisableAttribute("PMD_ABU804_001_000_G120C");
             }
             if (iFieldbusInterface < 0 || iFieldbusInterface == 2 || iFieldbusInterface > 3)
             {
                 // Fehler: G120C kann kein AS-i oder weitere Bussysteme
                 ECL_SelectValue("ECSI_STATUS", "E");
                 sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_FIELDBUS_G120C") + " "; //"Es wurden ein Feldbus vom Sizer übergeben, der vom G120C nicht unterstützt wird. ";
                 ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                 return;
             }
             //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
             // Prüfen, ob Bauform das Bussystem unterstützt VT_G120C_M00085_27122
             //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
             // Bussystem / integriert	Bauform des Umrichters		China-Regionstrigger (immer F!!!)
             // PMD_ABU804_001_000_G120C	PMD_ABW171_001_000_G120C	HMK_CN_TRIG_G120C
             var sBusParamReq = "00002";
             switch (iFieldbusInterface)
             {
                 case 0:
                     // 0 - Profinet
                     sBusParamReq = "00002";
                     break;
                 
                 case 1:
                     // 1 - Profibus
                     sBusParamReq = "00001";
                     break;
                 
                 case 3:
                     // 3: USS und Modbus RTU
                     sBusParamReq = "00006";
                     break;
             }
             var sSQL = "SELECT * FROM VT_G120C_M00085_27122 WHERE PMD_ABU804_001_000_G120C = '" + sBusParamReq + 
                         "' AND PMD_ABW171_001_000_G120C = '" + ECL_GetValue("PMD_ABW171_001_000_G120C") + 
                         "' AND HMK_CN_TRIG_G120C = 'F';";
             var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
             if (aResult.length > 0)
             {
                 // wird unterstützt
             }
             else
             {
                 // Fehler: Bussystem passt nicht zur Baugröße
                 ECL_SelectValue("ECSI_STATUS", "E");
                 sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FIELDBUS_FRAMESIZE_G120C") + " "; //"Die Vorgabe für den Feldbus passt nicht zur Baugröße. ";
                 ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                 return;
             }
             //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         }
         
         if ((sBus == ".") && !bFieldbusPreference)
         {
             // wenn Keep Configuration
             if (sBusKC){
                 
                 // todo
                 //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                 // Prüfen, ob Bauform das Bussystem unterstützt VT_G120C_M00085_27122
                 //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                 // Bussystem / integriert	Bauform des Umrichters		China-Regionstrigger (immer F!!!)
                 // PMD_ABU804_001_000_G120C	PMD_ABW171_001_000_G120C	HMK_CN_TRIG_G120C
                 var sBusParamReq = "00002";
                 switch (sBusKC)
                 {
                     case "F":
                         // 0 - Profinet
                         sBusParamReq = "00002";
                         break;
                     
                     case "P":
                         // 1 - Profibus
                         sBusParamReq = "00001";
                         break;
                     
                     case "B":
                         // 3: USS und Modbus RTU
                         sBusParamReq = "00006";
                         break;
                 }
                 var sSQL = "SELECT * FROM VT_G120C_M00085_27122 WHERE PMD_ABU804_001_000_G120C = '" + sBusParamReq + 
                             "' AND PMD_ABW171_001_000_G120C = '" + ECL_GetValue("PMD_ABW171_001_000_G120C") + 
                             "' AND HMK_CN_TRIG_G120C = 'F';";
                 var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
                 if (aResult.length > 0)
                 {
                     // wird unterstützt
                     ECL_SetValue("MLFB15_G120C", sBusKC);
                     sECSI_MLFB = replaceAt(sECSI_MLFB, 14, sBusKC);
                     ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                     ECL_SetValue("PMD_ABU804_001_000_G120C", sBusParamReq);
                 }
                 else
                 {
                     // Default setzen
                     ECL_SetValue("MLFB15_G120C", "F");
                     ECL_SetValue("PMD_ABU804_001_000_G120C", "00002");
                     sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "F");
                     ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                 }
             }else{
                 // MLFB war noch nicht vollständig spezifiziert und KEINE Vorgabe aus Sizer: Default Profinet setzen
                 // Default auf ProfiNet
                 ECL_SetValue("MLFB15_G120C", "F");
                 ECL_SetValue("PMD_ABU804_001_000_G120C", "00002");
                 sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "F");
                 ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
             }
         }
         else if ((sBus == ".") && bFieldbusPreference )
         {
             // MLFB war noch nicht vollständig spezifiziert und Vorgabe aus Sizer:
             switch (iFieldbusInterface)
             {
                 case 0:
                     // 0 feste Auswahl von Profinet
                     ECL_SetValue("MLFB15_G120C", "F");
                     ECL_SetValue("PMD_ABU804_001_000_G120C", "00002");
                     sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "F");
                     ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                     break;
                 
                 case 1:
                     // 1 feste Auswahl von Profibus
                     ECL_SetValue("MLFB15_G120C", "P");
                     ECL_SetValue("PMD_ABU804_001_000_G120C", "00001");
                     sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "P");
                     ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                     break;
                 
                 case 3:
                     // 3: Einschränken aus USS und Modbus RTU, Da aber damit nur eine MLFB verbunden ist, müssen wir die beiden Auswahl zusammenleben und dürfen den Benutzer nicht wählen lassen
                     ECL_SetValue("MLFB15_G120C", "B");
                     ECL_SetValue("PMD_ABU804_001_000_G120C", "00006");
                     sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "B");
                     ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                     // Schränkt mögliche Werte für die Bussysteme anhand der vorgegebenen MLFB - Stelle ein, nur relevant für USS / Modbus / RTU
                     break;
             }
             
         }
         else // (sBus !== ".")
         {
             // MLFB ist spezifiziert
             // Bus aus VT setzen
             ECL_SetValue("MLFB15_G120C", sBus);
             
             if (sBus == "F")
                 ECL_SetValue("PMD_ABU804_001_000_G120C", "00002");
             else if (sBus == "P")
                 ECL_SetValue("PMD_ABU804_001_000_G120C", "00001");
             else if (sBus == "B")
                 ECL_SetValue("PMD_ABU804_001_000_G120C", "00006");
             else
                 ECL_SetValue("PMD_ABU804_001_000_G120C", "00002");
             
             if (bFieldbusPreference)
             {
                 // Prüfen, ob Vorgabe zu MLFB passt
                 if ( (iFieldbusInterface == 0 && sBus !== "F") ||
                      (iFieldbusInterface == 1 && sBus !== "P") ||
                      (iFieldbusInterface == 3 && sBus !== "B") 
                 ) {
                     // geänderter Fieldbus --> Fehler
                     sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FIELDBUS_CHANGED_G120C") + " "; 
                     // Übergabestatus setzen
                     ECL_SelectValue("ECSI_STATUS", "E");
                     ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                     return;
                 }
             }
             
         }
         // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         
         // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         // Regenerativer Betrieb
         // VT_G120C_M00096	Zubehör Bremswiderstand				VT_G120C_M00096_27122
         // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         /*
         MLFB_KEY_G120C	MLFB					Bremswiderstand				Eintrag gültig/ungültig
         MLFB_KEY_G120C	HMK_MLFB_BR_RES_G120C	HMK_BREMSWIDERSTAND_G120C	HMK_VALUE_VALID_G120C
         Wenn der Wert 1 oder 2 ist, soll der Bremswiderstand vorausgewählt sein.
         (bei G120C <= 1.5 kW soll “Base Component” und bei G120C > 1.5 kW „Free-standing“ ausgewählt sein).
         Korrektur auf Wunsch Siemens: Unterbau ist nicht mehr verfügbar!
         */
         
         var sRegenerativeModeContext = ECL_GetValue("ECSI_CX_RegenerativeMode");
         
         if (sRegenerativeModeContext > 0)
         {
             var iCxRegenerativeMode = parseInt(sRegenerativeModeContext);
             
             // Bremswiderstand aktivieren
             if (iCxRegenerativeMode == 1 || iCxRegenerativeMode == 2)
             {
                 // Bremswiderstand vorgegeben:
                 // Behandlung "Custom" 
                 if (ECSI_CX_CustomBrakingResistor == "1" || ECSI_CX_CustomBrakingResistor == "True"){
                     ECL_SetValue("HMK_BREMSWIDERSTAND_G120C","CUSTOM");	
                 }else{
                     //Nur noch freistehend erlaubt
                     ECL_SetValue("HMK_BREMSWIDERSTAND_G120C","00002");	// freistehend
                 }
                 ECL_DeactivateValue("HMK_BREMSWIDERSTAND_G120C","00001"); // ohne
                 sStatusBR = "mit";
                 //ECL_DisableAttribute("HMK_BREMSWIDERSTAND_G120C");
             }
             else{
                 // Fehler
                 sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___REGENERATIVE_MODE_INVALID_G120C") + " "; 
                 // Übergabestatus setzen
                 ECL_SelectValue("ECSI_STATUS", "E");
                 ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                 return;
             }
         }
         else{
             ECL_SetValue("ECSI_CC_BrakingResistorID", "");
             ECL_ActivateValue("HMK_BREMSWIDERSTAND_G120C", "00001");
         }
         // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         
         // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         // Standard Umweltbed. / Lackierung
         // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         /* VT_G120C_M00103_27122
             MLFB_KEY_G120C	HMK_UMGEBUNGSBED_G120C	HMK_VALUE_VALID_G120C
         */
         var sSQL = "SELECT * FROM VT_G120C_M00103_27122 WHERE " +
                     "MLFB_KEY_G120C = '" + MLFB_KEY_G120C + "' AND " +
                     "HMK_VALUE_VALID_G120C = 'T';";
         
         var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
         if (aResult.length > 0)
         {
             var HMK_UMGEBUNGSBED_G120C = aResult[0].HMK_UMGEBUNGSBED_G120C
             ECL_DeactivateAllAttributeValues("HMK_UMGEBUNGSBED_G120C");
             ECL_ActivateValue("HMK_UMGEBUNGSBED_G120C", HMK_UMGEBUNGSBED_G120C);
             ECL_SetValue("HMK_UMGEBUNGSBED_G120C", HMK_UMGEBUNGSBED_G120C);
             
         }else{
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___UMWELT_G120C") + " ";
             ECL_SelectValue("ECSI_STATUS", "E");
             ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
             return;
         }
         
         
         // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
         
         // ##########################################################################################################################
         // Sekundäre MLFBs
         // ##########################################################################################################################
         
         var sMLFB14 = ECL_GetValue("MLFB14_G120C");
         
         sECSI_MLFB_SEC = GetMlfbSec() || "";
         
     
         if (sECSI_MLFB_SEC !== "") 
         {
             // übergebene MLFB_SEC parsen
             
             // mögliche MLFBs:
             /*
             // Speicherkarte VT_G120C_M00046_27122																	**check**
             // 00003 'ohne'					
             // 00234 'leer'			6SL30544AG002AA0
             // 00235 'mit Firmware'	6SL30547TF002BA0
             
             // Bedieneinheit - IOP-2 Handheld																		**check**
             // 00001 BOP-2			6SL32550AA004CA1
             // 00002 IOP			6SL32550AA004JA2	--> kein Handheld!
             
             // IOP Handheld																							**check**
             // sHandheld == "T"		6SL32550AA004HA1 --> nur wenn Bedieneinheit 00002, aber keine MLFB!
             
             // Smart Access Modul 	VT_G120C_M00077_27122															**check**
             
             // IOP-Türmontagesatz																					**check**
                 PMD_ABU776_001_000_G120C") == "T") 6SL32560AP000JA0
             
             // PC Verbindungssatz
                 PMD_ABU783_001_000_G120C") == "T") 6SL32550AA002CA0
             
             // NEMA-Kit				VT_G120C_M00076_27122															**check**
             
             // DSEE - Drive Service Extended Exchange		VT_G120C_M00084_27122									**check**
             
             // Leistungsschalter - VT_G120C_M00100_27122															**check**
             
             // Sicherung - VT_G120C_M00042_27122 																	**check**
             
             // externer Netzfilter Klasse B - VT_G120C_M00099_27122													**check**
             // Netzdrossel - VT_G120C_M00106_27122																	**check**																										
             // Bremswiderstand - VT_G120C_M00096_27122																**check**
             // Ausgangsdrossel - VT_G120C_M00107_27122																**check**
             */
             
             //var aMLFB_SEC_SIZER = sECSI_MLFB_SEC.split(';');
             
             // ---------------------------------------------------------------------------
             // Speicherkarte			leer: 6SL30544AG002AA0; 									00234
             
             var sSQL = 	"SELECT * FROM VT_G120C_M00046_27122 WHERE (HMK_SPEICHERKARTE_G120C = '00234' OR HMK_SPEICHERKARTE_G120C = '00235') AND " + 
                          "HMK_VALUE_VALID_G120C = 'T';";
              var sStatus = "ohne";
              
              var aResult = GetDBDataSetEXT(sSQL);
              if (sECSI_MLFB_SEC.indexOf("6SL30547TG002BA0") >= 0 || sECSI_MLFB_SEC.indexOf("6SL30547TH002BA0") >= 0 ) {
                 sStatus = "mit";
                 ECL_SelectValue("HMK_SPEICHERKARTE_G120C", "00235");
 
                 if (sECSI_MLFB_SEC.indexOf("6SL30547TG002BA0") >= 0) {
                     ECL_SelectValue("HMK_FIRMWARE_G120C", "VERSION_4_7_SP13");
                 } else if (sECSI_MLFB_SEC.indexOf("6SL30547TH002BA0") >= 0) {
                     ECL_SelectValue("HMK_FIRMWARE_G120C", "VERSION_4_7_SP14");
                 }
              
              
              } else if (aResult.length > 0)
              {
                  //Speicherkarte		leer: 			6SL30544AG002AA0	 	00234
                  //Speicherkarte		mit Firmware: 	6SL30547TF002BA0		00235
                  
                  for (var i = 0; i < aResult.length; i++)
                  {
                      if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_MEMORYCARD_G120C) >= 0)
                      {
                          // MLFB enthalten, also Attribute für übergebene MLFBs belegen 
                          ECL_SelectValue("HMK_SPEICHERKARTE_G120C", aResult[i].HMK_SPEICHERKARTE_G120C);
                          sStatus = "mit";
                          break;
                      }
                  } 
             }
             
             if (sStatus == "ohne")
             {
                 ECL_SelectValue("HMK_SPEICHERKARTE_G120C", "00003");
             }
             /*if (sECSI_MLFB_SEC.indexOf("6SL30544AG002AA0") >= 0)
             {
                 // MLFB enthalten, also Attribute für übergebene MLFBs belegen
                 ECL_SetValue("HMK_SPEICHERKARTE_G120C", "00234");
             }
             
             // Speicherkarte			mit Firmware: 6SL30547EH002BA0								00235		alte MLFB, ersetzt durch neue. Siehe nachfolgend
             else if (sECSI_MLFB_SEC.indexOf("6SL30547EH002BA0") >= 0)
             {
                 // MLFB enthalten, also Attribute für übergebene MLFBs belegen
                 ECL_SetValue("HMK_SPEICHERKARTE_G120C", "00235");
             }
             // Speicherkarte			mit Firmware: 6SL30547TF002BA0								00235		
             // neue MLFB, alte wird weiterhin erkannt, durch Stücklistenfunktion unten automatisch aktualisiert.
             else if (sECSI_MLFB_SEC.indexOf("6SL30547TF002BA0") >= 0)
             {
                 // MLFB enthalten, also Attribute für übergebene MLFBs belegen
                 ECL_SetValue("HMK_SPEICHERKARTE_G120C", "00235");
             }
             else
             {
                 ECL_SetValue("HMK_SPEICHERKARTE_G120C", "00003");
             }
             */
             
             // ---------------------------------------------------------------------------
             
             // Bedieneinheit - IOP-2 Handheld
             
             
             // ---------------------------------------------------------------------------
             //Bedieneinheit
             // 00001 BOP-2					6SL32550AA004CA1
             
             if (sECSI_MLFB_SEC.indexOf("6SL32550AA004CA1") >= 0)
             {
                 // MLFB enthalten, also Attribute für übergebene MLFBs belegen
                 ECL_SetValue("PMD_ABU803_001_000_G120C", "00001");
             }
             
             // 00002 IOP						6SL32550AA004JA2
             else if (sECSI_MLFB_SEC.indexOf("6SL32550AA004JA2") >= 0)
             {
                 // MLFB enthalten, also Attribute für übergebene MLFBs belegen
                 ECL_SetValue("PMD_ABU803_001_000_G120C", "00002");
             }
             else 
             {
                 ECL_SetValue("PMD_ABU803_001_000_G120C", "00003"); //ohne
             }
             // ---------------------------------------------------------------------------
             
             //IOP Handheld			6SL32550AA004HA1 																			T/F
             if (sECSI_MLFB_SEC.indexOf("6SL32550AA004HA1") >= 0)
             {
                 // MLFB enthalten, also Attribute für übergebene MLFBs belegen
                 ECL_SetValue("PMD_ABU803_001_000_G120C", "00002");
                 ECL_SelectValue("HMK_IOP_HANDHELD_G120C", "T");
                 
                 // ACHTUNG: Wenn Hendgheld, dann darf Bedieneinheit nicht BOP sein, auch darf keine MLFB für das IOP-Bedienpanel übergeben werden.
             }
             else
             {
                 ECL_DeselectAttribute("HMK_IOP_HANDHELD_G120C");
             }
             // ---------------------------------------------------------------------------
             
             // Smart Access Modul 	VT_G120C_M00077_27122
             var sSQL = "SELECT DISTINCT MLFB_SMART_ACCESS_G120C FROM VT_G120C_M00077_27122 WHERE HMK_SMART_ACCESS_G120C = 'T' AND HMK_VALUE_VALID_G120C = 'T';";
             var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
             if (aResult.length > 0)
             {
                 var sStatus = "ohne";
                 for (var i = 0; i < aResult.length; i++)
                 {
                     if (sECSI_MLFB_SEC.indexOf(aResult[i].MLFB_SMART_ACCESS_G120C) >= 0)
                     {
                         ECL_SelectValue("HMK_SMART_ACCESS_G120C", "T");
                         sStatus = "mit";
                     }
                 }
                 if (sStatus == "ohne")
                 {
                     ECL_DeselectAttribute("HMK_SMART_ACCESS_G120C");
                 }
             }
             // ---------------------------------------------------------------------------
             
             // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
             // SINAMICS CONNECT 300 IoT Gateway	HMK_CONNECT300_G120C
             // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
             
             if (sECSI_MLFB_SEC.indexOf("6SL32550AG300AA0") >= 0)
             {
                 ECL_SelectValue("HMK_CONNECT300_G120C", "T");
             }else{
                 ECL_DeselectAttribute("HMK_CONNECT300_G120C");
             }
             
             // ---------------------------------------------------------------------------
             
             // IOP-Türmontagesatz
             if (sECSI_MLFB_SEC.indexOf("6SL32560AP000JA0") >= 0)
             {
                 // MLFB enthalten, also Attribute für übergebene MLFBs belegen
                 ECL_SelectValue("PMD_ABU776_001_000_G120C", "T");
             }
             else
             {
                 ECL_DeselectAttribute("PMD_ABU776_001_000_G120C");
             }
             // ---------------------------------------------------------------------------
             
             // PC Verbindungssatz
             if (sECSI_MLFB_SEC.indexOf("6SL32550AA002CA0") >= 0)
             {
                 // MLFB enthalten, also Attribute für übergebene MLFBs belegen
                 ECL_SelectValue("PMD_ABU783_001_000_G120C", "T");
             }
             else
             {
                 ECL_DeselectAttribute("PMD_ABU783_001_000_G120C");
             }
             // ---------------------------------------------------------------------------
             
             // NEMA-Kit							VT_G120C_M00076_27122
             if (ECSI_CX_Certificates && ECSI_CX_Certificates.indexOf("ULR_CSA") > -1){
                 var bauformUmrichter = ECL_GetValue("PMD_ABW171_001_000_G120C");
                             // Die Prüfung muss erweitert werden: es kann hier mehrmals dieselbe Zubehör-MLFB für verschiedene Bauformen vorkommen
                 var sSQL = "SELECT * FROM VT_G120C_M00076_27122 WHERE HMK_NEMAKIT_G120C = 'T' AND HMK_VALUE_VALID_G120C = 'T' AND PMD_ABW171_001_000_G120C = '"+bauformUmrichter+"';";
                 var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
                 if (aResult.length > 0)
                 {
                     var sStatus = "ohne";
                     for (var i = 0; i < aResult.length; i++)
                     {
                         if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_NEMAKIT_G120C) >= 0)
                         {
                             ECL_SelectValue("HMK_NEMAKIT_G120C", "T");
                             sStatus = "mit";
                             break;
                         }
                     }
                     if ( sStatus == "ohne") {
                         ECL_DeselectAttribute("HMK_NEMAKIT_G120C");
                         // Fehler (aber nur vielleicht):
                         // sECSI_STATUS = "E"; 
                         // sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___NEMA_MLFB_SIZER_G120C") + " "; //"Die MLFB des vom SIZER übergebenen NEMA-Kits passt nicht zur Bauform des Umrichters. ";
                     }
                 }
                 else
                 {
                     ECL_DeselectAttribute("HMK_NEMAKIT_G120C");
                 }
             }else
             {
                 ECL_DeselectAttribute("HMK_NEMAKIT_G120C");
             }
             // ---------------------------------------------------------------------------
             
             // DSEE - Drive Service Extended Exchange		VT_G120C_M00084_27122
             /*
             MLFB11_G120C	MLFB12_G120C	MLFB13_G120C	MLFB14_G120C	MLFB15_G120C	MLFB16_G120C	Drive /.../Exchange		MLFB DSEE
             MLFB11_G120C	MLFB12_G120C	MLFB13_G120C	MLFB14_G120C	MLFB15_G120C	MLFB16_G120C	HMK_DSEE_G120C			HMK_MLFB_DSEE_G120C
             */
             
             var sSQL = "SELECT * FROM VT_G120C_M00108_27122 WHERE HMK_DSEE_G120C != 'OHNE';";
             var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
             if (aResult.length > 0)
             {
                 var sStatus = "ohne";
                 for (var i = 0; i < aResult.length; i++)
                 {
                     if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_DSEE_G120C) >= 0)
                     {
                         ECL_SetValue("HMK_DSEE_G120C", aResult[i].HMK_DSEE_G120C);
                         sStatus = "mit";
                     }
                 }
                 if (sStatus == "ohne")
                 {
                     ECL_SetValue("HMK_DSEE_G120C", "OHNE");
                 }
             }
             else
             {
                 ECL_SetValue("HMK_DSEE_G120C", "OHNE");
             }
             // ---------------------------------------------------------------------------
                 
             // Sicherung VT_G120C_M00042_27122
             var sSQL = "SELECT * FROM VT_G120C_M00102_27122 WHERE HMK_VALUE_VALID_G120C = 'T';";
             var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
             if (aResult.length > 0)
             {
                 var sStatus = "ohne";
                 for (var i = 0; i < aResult.length; i++)
                 {
                     if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_FUSE_G120C) >= 0)
                     {
                         ECL_SelectValue("PMD_AAC947_001_000_G120C", "T");
                         sStatus = "mit";
                     }
                 }
                 if (sStatus == "ohne")
                 {
                     ECL_DeselectAttribute("PMD_AAC947_001_000_G120C");
                 }
             }
             else
             {
                 ECL_DeselectAttribute("PMD_AAC947_001_000_G120C");
             }
             // ---------------------------------------------------------------------------
             
             // Leistungsschalter		VT_G120C_M00100_27122
             //var sSQL = "SELECT * FROM VT_G120C_M00100_27122 WHERE MLFB_KEY_G120C = '" + MLFB_KEY_G120C  + "' AND HMK_VALUE_VALID_G120C = 'T';";
             var sSQL = "SELECT * FROM VT_G120C_M00100_27122 WHERE HMK_VALUE_VALID_G120C = 'T';";
             var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
             if (aResult.length > 0)
             {
                 var sStatus = "ohne";
                 for (var i = 0; i < aResult.length; i++)
                 {
                     if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_POWERSWITCH_G120C) >= 0)
                     {
                         ECL_SelectValue("PMD_ABR230_001_000_G120C", "T");
                         sStatus = "mit";
                     }
                 }
                 if (sStatus == "ohne")
                 {
                     ECL_DeselectAttribute("PMD_ABR230_001_000_G120C");
                 }
             }
             else
             {
                 ECL_DeselectAttribute("PMD_ABR230_001_000_G120C");
             }
             // ---------------------------------------------------------------------------
             
             // externer Netzfilter Klasse B - VT_G120C_M00099_27122
             var sSQL = "SELECT * FROM VT_G120C_M00099_27122 WHERE HMK_NETZFILTER_EXT_G_G120C = 'T' AND HMK_VALUE_VALID_G120C = 'T';";
             var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
             if (aResult.length > 0)
             {
                 var sStatus = "ohne";
                 for (var i = 0; i < aResult.length; i++)
                 {
                     if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_NETZFILTER_G120C) >= 0)
                     {
                         ECL_SelectValue("HMK_NETZFILTER_EXT_G_G120C", "T");
                         sStatus = "mit";
                         //Prüfen, ob interner Filter passt:
                         if (ECL_GetValue("MLFB14_G120C") != aResult[i].MLFB14_G120C)
                         {
                             //Fehler:
                             sECSI_STATUS = "E"; 
                             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___EX_LINE_FILTER_G120C") + " "; //"Es wurde ein externer Netzfilter Klasse B übergeben, obwohl intern gefiltert wird (Filter A). Dies ist nicht zulässig. ";
                         }
                     }
                 }
                 if (sStatus == "ohne")
                 {	
                     ECL_DeselectAttribute("HMK_NETZFILTER_EXT_G_G120C");
                 }
             }
             else
             {
                 ECL_DeselectAttribute("HMK_NETZFILTER_EXT_G_G120C");
             }
             // ---------------------------------------------------------------------------
             
             // Netzdrossel - VT_G120C_M00106_27122
             var sSQL = "SELECT * FROM VT_G120C_M00106_27122 WHERE HMK_NETZDROSSEL_G120C != '00001' AND HMK_VALUE_VALID_G120C = 'T';";
             var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
             if (aResult.length > 0)
             {
                 var sStatus = "ohne";
                 for (var i = 0; i < aResult.length; i++)
                 {
                     if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_LINEREAC_G120C) >= 0)
                     {
                         ECL_SetValue("HMK_NETZDROSSEL_G120C", aResult[i].HMK_NETZDROSSEL_G120C);
                         sStatus = "mit";
                     }
                 }
                 if (sStatus == "ohne")
                 {	
                     ECL_SetValue("HMK_NETZDROSSEL_G120C", "00001");
                 }
             }
             else
             {
                 ECL_SetValue("HMK_NETZDROSSEL_G120C", "00001");
             }
             // ---------------------------------------------------------------------------
             
             // Bremswiderstand - VT_G120C_M00096_27122
             // nur ausführen, wenn nicht schon durch Context-Attribute vorgegeben
             if (sStatusBR == "ohne"){
                 
                 var sStatus = "ohne";
                 
                 if (ECSI_CX_CustomBrakingResistor != "1" || ECSI_CX_CustomBrakingResistor != "True"){
                     // Wenn nicht Custom, prüfen, ob MLFB für Bremswiderstand vorhanden:
                     var sSQL = "SELECT * FROM VT_G120C_M00096_27122 WHERE HMK_BREMSWIDERSTAND_G120C = '00002' AND HMK_VALUE_VALID_G120C = 'T';";
                     var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
                     if (aResult.length > 0)
                     {
                         for (var i = 0; i < aResult.length; i++)
                         {
                             if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_BR_RES_G120C) >= 0)
                             {
                                 ECL_SetValue("HMK_BREMSWIDERSTAND_G120C", aResult[i].HMK_BREMSWIDERSTAND_G120C);
                                 sStatus = "mit";
                                 break;
                             }
                         }
                         
                         if (sStatus == "ohne")
                         {	
                             ECL_SetValue("HMK_BREMSWIDERSTAND_G120C", "00001");
                         }
                     }
                     else
                     {
                         ECL_SetValue("HMK_BREMSWIDERSTAND_G120C", "00001");
                     }
                 }
             }
             /* kann jetzt auch Custom sein
             else{
                 ECL_DisableAttribute("HMK_BREMSWIDERSTAND_G120C");
             }*/
             // ---------------------------------------------------------------------------
             
             // Ausgangsdrossel - VT_G120C_M00107_27122
             var sSQL = "SELECT * FROM VT_G120C_M00107_27122 WHERE HMK_AUSG_DROSSEL_G120C != '00001' AND HMK_VALUE_VALID_G120C = 'T';";
             var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
             if (aResult.length > 0)
             {
                 var sStatus = "ohne";
                 for (var i = 0; i < aResult.length; i++)
                 {
                     if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_A_DROSSEL_G120C) >= 0)
                     {
                         ECL_SetValue("HMK_AUSG_DROSSEL_G120C", aResult[i].HMK_AUSG_DROSSEL_G120C);
                         sStatus = "mit";
                     }
                 }
                 if (sStatus == "ohne")
                 {	
                     ECL_SetValue("HMK_AUSG_DROSSEL_G120C", "00001");
                 }
             }
             else
             {
                 ECL_SetValue("HMK_AUSG_DROSSEL_G120C", "00001");
             }
             // ---------------------------------------------------------------------------

             // Digital Twin - DriveSim - VT_G120C_M00109_27122
             var sSQL = "SELECT * FROM VT_G120C_M00109_27122 WHERE HMK_DRV_SIM_DESIGNER_G120C like '%T%';";
             var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
             if (aResult.length > 0)
             {
                 var sStatus = "ohne";
                 for (var i = 0; i < aResult.length; i++)
                 {
                     if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_DRV_SIM_DES_G120C.trim()) >= 0)
                     {
                         ECL_SetValue("HMK_DRIVESIM_DESIGNER_G120C", "T");
                         sStatus = "mit";
                     }
                 }
                 if (sStatus == "ohne")
                 {	
                     ECL_SetValue("HMK_DRIVESIM_DESIGNER_G120C", "");
                 }
             }
             else
             {
                 ECL_SetValue("HMK_DRIVESIM_DESIGNER_G120C", "");
             }
             // ---------------------------------------------------------------------------
         }

         if (ECSI_CX_CustomBrakingResistor == "1" || ECSI_CX_CustomBrakingResistor == "True"){
         ECL_SetValue("HMK_BREMSWIDERSTAND_G120C", "CUSTOM");
         }

         // ## ENDE SEK-MLFBs ########################################################################################################
         // ## ENDE SEK-MLFBs ########################################################################################################
         
     }
     
     var motorTechnology = ECL_GetValue("ECSI_CX_MotorTechnology");
     if(motorTechnology == "1" || motorTechnology == "2")
     {
         ECL_DeselectValue("HMK_SINUSFILTER_G120C", "T");
         ECL_DeactivateAttribute("HMK_SINUSFILTER_G120C");
         
         ECL_SelectValue("HMK_AUSG_DROSSEL_G120C", "00001");
         ECL_DeactivateAttribute("HMK_AUSG_DROSSEL_G120C");
     }
     
     // ## ENDE PARSER #################################################################################################################################################################
     // ## ENDE PARSER #################################################################################################################################################################
     // ## ENDE PARSER #################################################################################################################################################################
     
     var MLFB_KEY_G120C = ECL_GetValue("MLFB_KEY_G120C");
     var sMLFB14 = ECL_GetValue("MLFB14_G120C");
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Filter Steuerung
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // VT Filter intern (A) und Filter extern B: VT_G120C_M00099_27122
     // Segment Merkmal MLFB14_G120C	MLFB /.../B	MLFB_KEY_G120C	Externer Netzfilter Klasse B	Eintrag gültig/ungültig
     // MLFB14_G120C	HMK_MLFB_NETZFILTER_G120C	MLFB_KEY_G120C	HMK_NETZFILTER_EXT_G_G120C	HMK_VALUE_VALID_G120C
     /*var aAttributesVT57 = [ "MLFB14_G120C",
                             "MLFB_KEY_G120C",
                             "HMK_NETZFILTER_EXT_G_G120C",
                             "HMK_VALUE_VALID_G120C"];
     ECL_InferencePositiveValues("VT_G120C_M00099_27122", "HMK_NETZFILTER_EXT_G_G120C", aAttributesVT57);		// todo
     */
     
     var sDTKAttribute = "HMK_NETZFILTER_EXT_G_G120C";
     var sCB_Attribute = sDTKAttribute;
     
     var sTable = "VT_G120C_M00099" + sDB_Suffix;
     var sWhere = 	"MLFB14_G120C = '" + sMLFB14 + "' AND " + 
                     "MLFB_KEY_G120C = '" + MLFB_KEY_G120C + "' AND " + 
                     "HMK_VALUE_VALID_G120C = 'T';";
     
     var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "T", "F", sWhere, false);
     if (sStatus == "Error"){
         // Fehler
         strError = "DICT1_ERR_G120C___PL_FILTER_LOGIKFEHLER_NO_DB_RESULT";
         return strError;
     }
     
     
     if (ECL_ValueSelected("HMK_NETZFILTER_EXT_G_G120C", "T"))
     {
         ECL_DeactivateValue("PMD_AAD146_001_000_G120C", "Z0002");
     }
     else
     {
         ECL_ActivateValue("PMD_AAD146_001_000_G120C", "Z0002");
     }
     
     sFilterParam = ECL_GetValue("PMD_AAD146_001_000_G120C");
     if (sFilterParam == "Z0002") // - Filter A
     {
         sECSI_MLFB = replaceAt(sECSI_MLFB, 13, "A");
         ECL_SetValue("MLFB14_G120C", "A");
         // Kein externer Filter B zugelassen
         ECL_DeselectAttribute("HMK_NETZFILTER_EXT_G_G120C");
         ECL_DisableAttribute("HMK_NETZFILTER_EXT_G_G120C");
     }
     else if (sFilterParam == "00004") // - ungefiltert
     {
         sECSI_MLFB = replaceAt(sECSI_MLFB, 13, "U");
         ECL_SetValue("MLFB14_G120C", "U");
         //ECL_EnableAttribute("HMK_NETZFILTER_EXT_G_G120C");
     }
     ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Bussystem Steuerung MLFB15:	ZO Bussystem (B, P, F) - PMD_ABU804_001_000_G120C
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     //if (ECL_GetUserVariable("BusUserSet") == "USER")
     // var sFieldbusInterface = ECL_GetValue("ECSI_CX_FieldbusInterface"); 
     //var iFieldbusInterface = parseInt(sFieldbusInterface);
 
     sBusParam = ECL_GetValue("PMD_ABU804_001_000_G120C");
     if (sBusParam == "00002") // PROFINET / EtherNet/IP
     {
         sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "F");
         ECL_SetValue("MLFB15_G120C", "F");
     }
     else if (sBusParam == "00001") // PROFIBUS
     {
         sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "P");
         ECL_SetValue("MLFB15_G120C", "P");
     }
     else if (sBusParam == "00006" || sBusParam == "00013") // USS oder Modbus RTU
     {
         sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "B");
         ECL_SetValue("MLFB15_G120C", "B");
     }
     ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
 
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     
     // ###############################################################################################################################################################################
     // Variantentabellen/Produktlogik:
     // ###############################################################################################################################################################################
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Bedieneinheit
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Bedienpanel:								VT_G120C_M00039_27122
     // Zuordnung von 'Ausführung des Bedienpanels' zu BOP oder IOP,
     // nur nötig, wenn die Einzelmerkmale benötigt werden?
     // Ausführung des Bedienpanels	Produktbestandt.../BOP-2	Produktbestandt.../V1.1	Eintrag gültig/ungültig
     // PMD_ABU803_001_000_G120C	PMD_ABU778_001_000_G120C	PMD_ABU779_001_000_G120C	HMK_VALUE_VALID_G120C
 
     var sBedieneinheit = ECL_GetValue("PMD_ABU803_001_000_G120C");
     if (sBedieneinheit == "00001") // BOP PMD_ABU778_001_000_G120C
     {
         ECL_SetValue("PMD_ABU778_001_000_G120C", "T");
         ECL_SetValue("PMD_ABU779_001_000_G120C", "F");
     }
     else if (sBedieneinheit == "00002") // IOP PMD_ABU779_001_000_G120C
     {
         ECL_SetValue("PMD_ABU778_001_000_G120C", "F");
         ECL_SetValue("PMD_ABU779_001_000_G120C", "T");
     }
     else  // "00003"
     {
         ECL_SetValue("PMD_ABU778_001_000_G120C", "F");
         ECL_SetValue("PMD_ABU779_001_000_G120C", "F");
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Bedieneinheit - IOP-2 Handheld
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // wenn Bedieneinheit (Ausführung des Bedienpanals PMD_ABU803_001_000_G120C == 00002 (IOP-2: Intellig...ator Panel-2),
     // dann ist eine optionale Wahl des IOP-Hendheld möglich, sonst nicht.
     
     if (sBedieneinheit == "00002")
     {
         ECL_EnableAttribute("HMK_IOP_HANDHELD_G120C");
     }
     else
     {
         ECL_DeselectAttribute("HMK_IOP_HANDHELD_G120C");
         ECL_DisableAttribute("HMK_IOP_HANDHELD_G120C");
     }
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // ZO Bussystem - Bauform (Framesize)		VT_G120C_M00085_27122 
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // PMD_ABU804_001_000_G120C	PMD_ABW171_001_000_G120C	HMK_CN_TRIG_G120C
     /*var aAttributesVT85 = [	"PMD_ABU804_001_000_G120C", 
                             "PMD_ABW171_001_000_G120C", 
                             "HMK_CN_TRIG_G120C"];
     
     ECL_InferencePositiveValues("VT_G120C_M00085_27122", "PMD_ABU804_001_000_G120C", aAttributesVT85);
     * /
     var PMD_ABW171_001_000_G120C = ECL_GetValue("PMD_ABW171_001_000_G120C");
     
     var sTable = "VT_G120C_M00085_27122";
     var sTargetAttribute = "PMD_ABU804_001_000_G120C";
     var sWhere = 	"PMD_ABW171_001_000_G120C = '" + PMD_ABW171_001_000_G120C + "' AND " + 
                     "HMK_CN_TRIG_G120C = 'F';";
     
     var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
     */
     simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120C_M00085" + sDB_Suffix,{
         inferenceType: VariantTables.Inference.RestrictNone,
         operators: {
             "PMD_ABU804_001_000_G120C": {
             inferenceType: VariantTables.Inference.RestrictAll
             }
         }
     });
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // Zubehör Netzdrossel				VT_G120C_M00106_27122
     /*
     MLFB_KEY_G120C		Netzdrossel					Eintrag gültig/ungültig
     MLFB_KEY_G120C		HMK_NETZDROSSEL_G120C		HMK_VALUE_VALID_G120C
     */
     /*var aAttributesVT62 = [	"MLFB_KEY_G120C", 
                             "HMK_NETZDROSSEL_G120C", 
                             "HMK_VALUE_VALID_G120C"];
     
     ECL_InferencePositiveValues("VT_G120C_M00106_27122", "HMK_NETZDROSSEL_G120C", aAttributesVT62);
     */
     simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120C_M00106" + sDB_Suffix,{
         inferenceType: VariantTables.Inference.RestrictNone,
         operators: {
             "HMK_NETZDROSSEL_G120C": {
             inferenceType: VariantTables.Inference.RestrictAll
             }
         }
     });
     
     // handle changes to linereactor selection
     var selectedLineReactor = ECL_GetValue("HMK_NETZDROSSEL_G120C");//ECL_GetUserVariable("SELECTED_LINE_REACTOR_G120C");
     if(selectedLineReactor !== "00001")
     {
         var activeValues = ECL_GetAllActiveAttributeValues("HMK_NETZDROSSEL_G120C");
         for(var i=0; i < activeValues.length; i++)
         {
             if(selectedLineReactor === activeValues[i])
             {
                 ECL_SetValue("HMK_NETZDROSSEL_G120C", activeValues[i]);
                 break;
             }
             else
             {
                 for(var j=0; j < activeValues.length; j++)
                 {
                     if(activeValues[j] !== "00001")
                     {
                         ECL_SetValue("HMK_NETZDROSSEL_G120C", activeValues[j]);
                     }
                 }
             }
         }
     }
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // MLFB Ausgangsdrossel			VT_G120C_M00107_27122
     /*
     MLFB_KEY_G120C		Ausgangsdrossel			Eintrag gültig/ungültig
     MLFB_KEY_G120C		HMK_AUSG_DROSSEL_G120C	HMK_VALUE_VALID_G120C
     */
     
     /*var aAttributesVT64 = [ "MLFB_KEY_G120C",
                             "HMK_AUSG_DROSSEL_G120C",
                             "HMK_VALUE_VALID_G120C"];
     ECL_InferencePositiveValues("VT_G120C_M00107_27122", "HMK_AUSG_DROSSEL_G120C", aAttributesVT64);
     */
     simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120C_M00107" + sDB_Suffix,{
         inferenceType: VariantTables.Inference.RestrictNone,
         operators: {
             "HMK_AUSG_DROSSEL_G120C": {
             inferenceType: VariantTables.Inference.RestrictAll
             }
         }
     });
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // VT_G120C_M00096_27122	Zubehör Bremswiderstand				VT_G120C_M00096_27122
     /*
     MLFB_KEY_G120C	Bremswiderstand						Eintrag gültig/ungültig
     MLFB_KEY_G120C		HMK_BREMSWIDERSTAND_G120C	HMK_VALUE_VALID_G120C
     */
     if (sStatusBR == "ohne"){
         var HMK_BREMSWIDERSTAND_G120C = ECL_GetValue("HMK_BREMSWIDERSTAND_G120C");
         /*var aAttributesVT68 = [ "MLFB_KEY_G120C",
                                 "HMK_BREMSWIDERSTAND_G120C",
                                 "HMK_VALUE_VALID_G120C"];
         ECL_InferencePositiveValues("VT_G120C_M00096_27122", "HMK_BREMSWIDERSTAND_G120C", aAttributesVT68);
         */
         simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120C_M00096" + sDB_Suffix,{
             inferenceType: VariantTables.Inference.RestrictNone,
             operators: {
                 "HMK_BREMSWIDERSTAND_G120C": {
                 inferenceType: VariantTables.Inference.RestrictAll
                 }
             }
         });
         
         
         ECL_ActivateValue("HMK_BREMSWIDERSTAND_G120C", "CUSTOM");
         if (HMK_BREMSWIDERSTAND_G120C == "CUSTOM")
         ECL_SetValue("HMK_BREMSWIDERSTAND_G120C", "CUSTOM");
     }

     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 
     // VT_G120C_M00084	ZO PM-DSEE		VT_G120C_M00084_27122
     /*
     MLFB11_G120C	MLFB12_G120C	MLFB13_G120C	MLFB14_G120C	MLFB15_G120C	MLFB16_G120C	Drive /.../Exchange'	MLFB DSEE
     MLFB11_G120C	MLFB12_G120C	MLFB13_G120C	MLFB14_G120C	MLFB15_G120C	MLFB16_G120C	HMK_DSEE_G120C			HMK_MLFB_DSEE_G120C
     */
     /*var aAttributesVT84 = [	"MLFB11_G120C", 
                             "MLFB12_G120C", 
                             "MLFB13_G120C", 
                             "MLFB14_G120C", 
                             "MLFB15_G120C", 
                             "MLFB16_G120C", 
                             "HMK_DSEE_G120C"];
     
     ECL_InferencePositiveValues ("VT_G120C_M00084_27122", "HMK_DSEE_G120C", aAttributesVT84);
     */
     simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_G120C_M00108" + sDB_Suffix,{
         inferenceType: VariantTables.Inference.RestrictNone,
         operators: {
             "HMK_DSEE_G120C": {
             inferenceType: VariantTables.Inference.RestrictAll
             }
         }
     });
     
     // #########################################################################################################################
     
     
     // #########################################################################################################################################################################
     // Zubehör Steuerung der Sek-MLFBs (Stückliste):
     // #########################################################################################################################################################################
     
     sECSI_MLFB_SEC = "";
     //VT SmartAccess, IOP, BOP
     //VT_G120C_M00083_27122 immer T und F gültig - keine Einschränkungen!		// todo prüfen
     /*
     Ausführung des Bedienpanels		Smart Access (Webservermodul)	Eintrag gültig/ungültig
     PMD_ABU803_001_000_G120C		HMK_SMART_ACCESS_G120C			HMK_VALUE_VALID_G120C
     */
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Speicherkarte
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Speicherkarte VT_G120C_M00046_27122
     // 00003 'ohne'					
     // 00234 'leer'				6SL30544AG002AA0
     // 00235 'mit Firmware'		6SL30547TF002BA0
     var HMK_SPEICHERKARTE_G120C = ECL_GetValue("HMK_SPEICHERKARTE_G120C");
      
      if (HMK_SPEICHERKARTE_G120C == "00234")
      {
          ECL_DeactivateAttribute("HMK_FIRMWARE_G120C");
          var sSQL = "SELECT * FROM VT_G120C_M00046_27122 WHERE HMK_SPEICHERKARTE_G120C = '" + HMK_SPEICHERKARTE_G120C + "' AND HMK_VALUE_VALID_G120C = 'T';"; 
          var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
          if (aResult.length > 0){
              var HMK_MLFB_MEMORYCARD_G120C = aResult[0].HMK_MLFB_MEMORYCARD_G120C; 
          
              if (sECSI_MLFB_SEC.length > 0)
              {
                  sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + HMK_MLFB_MEMORYCARD_G120C;
              }
              else
              {
                  sECSI_MLFB_SEC = HMK_MLFB_MEMORYCARD_G120C;
              }
          }else{
              // Fehler
              sECSI_STATUS = "E"; 
              sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SD_MLFB_G120C") + " "; //"MLFB für 'Speicherkarte' nicht bestimmt, kein Treffer in DB. ";
          }
      } else if (HMK_SPEICHERKARTE_G120C == "00235") {
         ECL_ActivateAttribute("HMK_FIRMWARE_G120C");
 
         if (ECL_GetValue("HMK_FIRMWARE_G120C") === "") 
             ECL_SelectValue("HMK_FIRMWARE_G120C", getLatestFirmwareVersion());
 
         //var sMLFB_G120D_HMK_MEMORYCARD = "6SL30547TE002BA0"; // <-- aus SourceCode vs. aus DB: 6SL30547EH002BA0
         //var sMLFB_G120D_HMK_MEMORYCARD = "6SL30547TF002BA0"; // <-- aus SourceCode vs. aus DB: 6SL30547EH002BA0
         if (sECSI_MLFB_SEC.length > 0)
         {
             sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + getFirmwareVersion();
         }
         else
         {
             sECSI_MLFB_SEC = getFirmwareVersion();
         }
      } else {
         ECL_DeactivateAttribute("HMK_FIRMWARE_G120C");
      }
      
      // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      // Firmware
      // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 
      var selectedFirmwareVersion = ECL_GetValue("HMK_FIRMWARE_G120C");
         
      if (selectedFirmwareVersion === "VERSION_4_7_SP13" && HMK_SPEICHERKARTE_G120C == "00235") {
          sECSI_STATUS = "WARNING";
          sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + "WARNING_OUTDATED_FIRMWARE";
      }

      // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      // DriveSim
      // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 
      var dirveSimSelected = ECL_GetValue("HMK_DRIVESIM_DESIGNER_G120C");
         
      if (dirveSimSelected) {
        var sql = "SELECT * FROM VT_G120C_M00109_27122 WHERE HMK_DRV_SIM_DESIGNER_G120C like '%T%';";
        sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + GetDBDataSetEXT(sql)[0].HMK_MLFB_DRV_SIM_DES_G120C.trim();
      }
     
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Bedieneinheit - Stückliste
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     if (((sBedieneinheit == "00001") || (sBedieneinheit == "00002")) && !(ECL_ValueSelected("HMK_IOP_HANDHELD_G120C", "T")))
     {
         if (sBedieneinheit == "00001") // BOP-2
         {
             var sMLFB_BEDIENPANEL_G120C = "6SL32550AA004CA1";
         }
         else if (sBedieneinheit == "00002") // IOP nur, wenn kein Handheld
         {
             var sMLFB_BEDIENPANEL_G120C = "6SL32550AA004JA2";
         }
         if (sECSI_MLFB_SEC.length > 0)
         {
             sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_BEDIENPANEL_G120C; 
         }
         else
         {
             sECSI_MLFB_SEC = sMLFB_BEDIENPANEL_G120C;
         }
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // IOP Handheld
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     if (ECL_ValueSelected("HMK_IOP_HANDHELD_G120C", "T"))
     {
         var sMLFB_HMK_IOP_HANDHELD_G120C = "6SL32550AA004HA1";
         
         if (sECSI_MLFB_SEC.length > 0)
         {
             sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_HMK_IOP_HANDHELD_G120C; 
         }
         else
         {
             sECSI_MLFB_SEC = sMLFB_HMK_IOP_HANDHELD_G120C;
         }
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Smart Access Modul - VT_G120C_M00077_27122			neu: Checkbox
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     if (ECL_ValueSelected("HMK_SMART_ACCESS_G120C", "T")) 
     {
         var sSQL = "SELECT * FROM VT_G120C_M00077_27122 WHERE HMK_SMART_ACCESS_G120C = 'T' AND HMK_VALUE_VALID_G120C = 'T';"; 
         var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
         if (aResult.length > 0)
         {
             var sMLFB_SMART_ACCESS_G120C = aResult[0].MLFB_SMART_ACCESS_G120C; 
             
             if (sECSI_MLFB_SEC.length > 0)
             {
                 sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_SMART_ACCESS_G120C;
             }
             else
             {
                 sECSI_MLFB_SEC = sMLFB_SMART_ACCESS_G120C;
             }
         }
         else
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SAM_MLFB_G120C") + " "; //"MLFB für 'Smart Access Modul' nicht bestimmt, kein Treffer in DB. ";
         }
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     
     // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // SINAMICS CONNECT 300 IoT Gateway	HMK_CONNECT300_G120C		neu: Checkbox
     // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Keine Einschränkungen
     if (ECL_ValueSelected("HMK_CONNECT300_G120C", "T")) 
     {
         var sMLFB_CONNECT_300 = "6SL32550AG300AA0";
             
         // Sekundär-MLFB Eintrag
         if (sECSI_MLFB_SEC !== ""){
             sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_CONNECT_300;
         }else{
             sECSI_MLFB_SEC = sMLFB_CONNECT_300;
         }
     }
     // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // IOP-Türmontagesatz								neu: Checkbox
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     if (ECL_ValueSelected("PMD_ABU776_001_000_G120C", "T"))
     {
         var sMLFB_IOP_MONTAGESATZ_G120C = "6SL32560AP000JA0";
         
         if (sECSI_MLFB_SEC.length > 0)
         {
             sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_IOP_MONTAGESATZ_G120C; 
         }
         else
         {
             sECSI_MLFB_SEC = sMLFB_IOP_MONTAGESATZ_G120C;
         }
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 
 
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // PC Verbindungssatz								neu: Checkbox
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     if (ECL_ValueSelected("PMD_ABU783_001_000_G120C", "T"))
     {
         var sMLFB_PC_VERBINDUNGSSATZ_G120C = "6SL32550AA002CA0";
         
         if (sECSI_MLFB_SEC.length > 0)
         {
             sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_PC_VERBINDUNGSSATZ_G120C; 
         }
         else
         {
             sECSI_MLFB_SEC = sMLFB_PC_VERBINDUNGSSATZ_G120C;
         }
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 
 
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // DSEE - Drive Service Extended Exchange		VT_G120C_M00084_27122
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     var sDSEE		= ECL_GetValue("HMK_DSEE_G120C");
     
     if ( (sDSEE == "DSEE3") || (sDSEE == "DSEE5") // nicht 'OHNE'
     ) {
         var sMLFB11 = sECSI_MLFB.charAt(10);
         var sMLFB12 = sECSI_MLFB.charAt(11);
         var sMLFB13 = sECSI_MLFB.charAt(12);
         var sMLFB15 = sECSI_MLFB.charAt(14);
         var sMLFB16 = sECSI_MLFB.charAt(15);
         
         var sSQL = "SELECT * FROM VT_G120C_M00108_27122 WHERE " +
                     "MLFB11_G120C = '" + sMLFB11 + "' AND " +
                     "MLFB12_G120C = '" + sMLFB12 + "' AND " +
                     "MLFB13_G120C = '" + sMLFB13 + "' AND " +
                     "MLFB14_G120C = '" + sMLFB14 + "' AND " +
                     "MLFB15_G120C = '" + sMLFB15 + "' AND " +
                     "MLFB16_G120C = '" + sMLFB16 + "' AND " +
                     "HMK_DSEE_G120C = '" + sDSEE + "';";
         
         var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
         if (aResult.length > 0)
         {
             var sMLFB_DSEE_G120C = aResult[0].HMK_MLFB_DSEE_G120C; 
             
             if (sECSI_MLFB_SEC.length > 0)
             {
                 sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_DSEE_G120C;
             }
             else
             {
                 sECSI_MLFB_SEC = sMLFB_DSEE_G120C;
             }
         }
         else
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DSEE_MLFB_G120C") + " "; // "MLFB für 'DSEE' nicht bestimmt, kein Treffer in DB. ";
         }
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Leistungsschalter - VT_G120C_M00100_27122	neu: Checkbox
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // Logik:
     /*
     var aAttributesVT100 = ["MLFB_KEY_G120C",
                             "PMD_ABR230_001_000_G120C", 
                             "HMK_VALUE_VALID_G120C"];
     
     ECL_InferencePositiveValues ("VT_G120C_M00100_27122", "PMD_ABR230_001_000_G120C", aAttributesVT100);	// todo mit CB
     */
     var sDTKAttribute = "PMD_ABR230_001_000_G120C";
     var sCB_Attribute = sDTKAttribute;
     
     var sTable = "VT_G120C_M00100" + sDB_Suffix;
     var sWhere = 	"MLFB_KEY_G120C = '" + MLFB_KEY_G120C + "' AND " + 
                     "HMK_VALUE_VALID_G120C = 'T';";
     
     var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "T", "F", sWhere, false);
     if (sStatus == "Error"){
         // Fehler
         strError = "DICT1_ERR_G120C___PL_POWER_SWITCH_LOGIKFEHLER_NO_DB_RESULT";
         return strError;
     }
     
     
     if (ECL_ValueSelected("PMD_ABR230_001_000_G120C", 'T'))
     {
         var sSQL = "SELECT * FROM VT_G120C_M00100_27122 WHERE MLFB_KEY_G120C = '" + MLFB_KEY_G120C + "' AND PMD_ABR230_001_000_G120C = 'T' AND HMK_VALUE_VALID_G120C = 'T';"; 
         var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
         if (aResult.length > 0)
         {
             var sMLFB_Leistungsschalter = aResult[0].HMK_MLFB_POWERSWITCH_G120C; 
             
             if (sECSI_MLFB_SEC.length > 0)
             {
                 sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_Leistungsschalter;
             }
             else
             {
                 sECSI_MLFB_SEC = sMLFB_Leistungsschalter;
             }
         }
         else
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___CIRCUIT_BREAKER_MLFB_G120C") + " "; //"MLFB für 'Leistungsschalter' nicht bestimmt, kein Treffer in DB. ";
         }
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Sicherung - VT_G120C_M00102_27122 	neu: Checkbox
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // MLFB_KEY_G120C	HMK_MLFB_FUSE_G120C	HMK_VALUE_VALID_G120C
     
     if (ECL_ValueSelected("PMD_AAC947_001_000_G120C", 'T')) 
     {
         var sSQL = "SELECT * FROM VT_G120C_M00102_27122 WHERE MLFB_KEY_G120C = '" + MLFB_KEY_G120C + "' AND HMK_VALUE_VALID_G120C = 'T';"; 
         var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
         if (aResult.length > 0)
         {
             var sMLFB_Sicherung = aResult[0].HMK_MLFB_FUSE_G120C; 
             
             if (sECSI_MLFB_SEC.length > 0)		// Sicherung bei 3 phasigem Netzanschluss immer 3 Stk
             {
                 sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_Sicherung + ";" + sMLFB_Sicherung + ";" + sMLFB_Sicherung;
             }
             else
             {
                 sECSI_MLFB_SEC = sMLFB_Sicherung + ";" + sMLFB_Sicherung + ";" + sMLFB_Sicherung;
             }
         }
         else
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FUSE_MLFB_G120C") + " "; //"MLFB für 'Sicherung' nicht bestimmt, kein Treffer in DB. ";
         }
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // externer Netzfilter Klasse B - VT_G120C_M00099_27122		neu: Checkbox
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     var ExternalFilterType = 0;
     if (ECL_ValueSelected("HMK_NETZFILTER_EXT_G_G120C", 'T')) 
     {
         var sSQL = "SELECT * FROM VT_G120C_M00099_27122 WHERE " +
                     "MLFB14_G120C = '" + sMLFB14 + "' AND " +
                     "MLFB_KEY_G120C = '" + MLFB_KEY_G120C + "' AND " + 
                     "HMK_NETZFILTER_EXT_G_G120C = 'T' AND " + 
                     "HMK_VALUE_VALID_G120C = 'T';"; 
         
         var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
         if (aResult.length > 0)
         {
             var sMLFB_NETZFILTER_G120C = aResult[0].HMK_MLFB_NETZFILTER_G120C; 
             
             if (sECSI_MLFB_SEC.length > 0)
             {
                 sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_NETZFILTER_G120C;
             }
             else
             {
                 sECSI_MLFB_SEC = sMLFB_NETZFILTER_G120C;
             }
         }
         else
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___EXT_LINE_FILTER_MLFB_G120C") + " "; // "MLFB für 'externer Netzfilter Klasse B' nicht bestimmt, kein Treffer in DB. ";
         }
         
         ExternalFilterType = 2; // 1, 2, 3???
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Netzdrossel - VT_G120C_M00106_27122
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // Stückliste
     var sHMK_NETZDROSSEL_G120C = ECL_GetValue("HMK_NETZDROSSEL_G120C");
     
     if (sHMK_NETZDROSSEL_G120C == '00002' || sHMK_NETZDROSSEL_G120C == '00003')  
     {
         var sSQL = "SELECT * FROM VT_G120C_M00106_27122 WHERE MLFB_KEY_G120C = '" + MLFB_KEY_G120C + "' AND HMK_NETZDROSSEL_G120C = '" + sHMK_NETZDROSSEL_G120C +"' AND HMK_VALUE_VALID_G120C = 'T';"; 
         var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
         if (aResult.length > 0)
         {
             var sMLFB_Netzdrossel = aResult[0].HMK_MLFB_LINEREAC_G120C; 
             
             if (sECSI_MLFB_SEC.length > 0)
             {
                 sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_Netzdrossel;
             }
             else
             {
                 sECSI_MLFB_SEC = sMLFB_Netzdrossel;
             }
         }
         else
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___LINE_REACTOR_MLFB_G120C") + " "; //"MLFB für 'NETZDROSSEL' nicht bestimmt, kein Treffer in DB. ";
         }
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Bremswiderstand - VT_G120C_M00096_27122
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // Stückliste
     var sHMK_BREMSWIDERSTAND_G120C = ECL_GetValue("HMK_BREMSWIDERSTAND_G120C");
     var BrakingResistorID = "";
     
     if (sHMK_BREMSWIDERSTAND_G120C == '00002') // || sHMK_BREMSWIDERSTAND_G120C == '00003') 
     {
         var sSQL = "SELECT * FROM VT_G120C_M00096_27122 WHERE MLFB_KEY_G120C = '" + MLFB_KEY_G120C + "' AND HMK_BREMSWIDERSTAND_G120C = '" + sHMK_BREMSWIDERSTAND_G120C +"' AND HMK_VALUE_VALID_G120C = 'T';"; 
         var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
         if (aResult.length > 0)
         {
             var sMLFB_Bremswiderstand = aResult[0].HMK_MLFB_BR_RES_G120C; 
             sMLFB_Bremswiderstand = sMLFB_Bremswiderstand.replace(/\s+/g, ""); // Leerzeichen entfernen
             sMLFB_Bremswiderstand = sMLFB_Bremswiderstand.replace("-", ""); // Bindestriche entfernen
             // Consequences
             ECL_SetValue("ECSI_CC_BrakingResistorID", sMLFB_Bremswiderstand);
             ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "False");
             
             if (sECSI_MLFB_SEC.length > 0)
             {
                 sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_Bremswiderstand;
             }
             else
             {
                 sECSI_MLFB_SEC = sMLFB_Bremswiderstand;
             }
             BrakingResistorID = sMLFB_Bremswiderstand;
         }
         else
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___BRAKE_RESISTOR_MLFB_G120C") + " "; //"MLFB für 'BREMSWIDERSTAND' nicht bestimmt, kein Treffer in DB. ";
         }
     }
     else{
         
         if (sHMK_BREMSWIDERSTAND_G120C == "CUSTOM"){
             ECL_SetValue("ECSI_CC_BrakingResistorID", "Custom");
             ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "True");
         }else{
             ECL_SetValue("ECSI_CC_BrakingResistorID", "");
             ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "False");
         }
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // MaxOutputFrequencyLimit setzen, wenn Ausgangsdrossel oder Sinusfilter
     var bLimitOutFrequency = false;
     var OutputReactorOrFilterType = 0;
     var OutputReactorOrFilter = "";
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // Ausgangsdrossel - VT_G120C_M00107_27122
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // Stückliste
     var sHMK_AUSG_DROSSEL_G120C = ECL_GetValue("HMK_AUSG_DROSSEL_G120C");
     
     if (sHMK_AUSG_DROSSEL_G120C == '00002' || sHMK_AUSG_DROSSEL_G120C == '00003') 
     {
         var sSQL = "SELECT * FROM VT_G120C_M00107_27122 WHERE " +
                     "MLFB_KEY_G120C = '" + MLFB_KEY_G120C + "' AND " +
                     "HMK_AUSG_DROSSEL_G120C = '" + sHMK_AUSG_DROSSEL_G120C +"' AND " + 
                     "HMK_VALUE_VALID_G120C = 'T';"; 
         
         var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
         if (aResult.length > 0)
         {
             var sMLFB_AUSG_DROSSEL = aResult[0].HMK_MLFB_A_DROSSEL_G120C; 
             
             if (sECSI_MLFB_SEC.length > 0)
             {
                 sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_AUSG_DROSSEL;
             }
             else
             {
                 sECSI_MLFB_SEC = sMLFB_AUSG_DROSSEL;
             }
             OutputReactorOrFilter = sMLFB_AUSG_DROSSEL;
         }
         else
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___OUTPUT_REACTOR_MLFB_G120C") + " "; // "MLFB für 'AUSGANGSDROSSEL' nicht bestimmt, kein Treffer in DB. ";
         }
         
         bLimitOutFrequency = true;
         OutputReactorOrFilterType = 1;
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     // NEMA- Kit - VT_G120C_M00076_27122
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     /*
         MLFB NEMA- Kit					NEMA / UL Type Kit		Bauform des Umrichters		Eintrag gültig/ungültig
         HMK_MLFB_NEMAKIT_G120C	HMK_NEMAKIT_G120C			PMD_ABW171_001_000_G120C	HMK_VALUE_VALID_G120C
     */
     // Stückliste
     var sBauform = ECL_GetValue("PMD_ABW171_001_000_G120C");
     
     if (ECL_ValueSelected("HMK_NEMAKIT_G120C", "T")) 
     {
         var sSQL = "SELECT * FROM VT_G120C_M00076_27122 WHERE " +
                     "HMK_NEMAKIT_G120C = 'T' AND " +
                     "PMD_ABW171_001_000_G120C = '" + sBauform + "' AND " + // Bauform
                     "HMK_VALUE_VALID_G120C = 'T';";
         
         var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
         if (aResult.length > 0)
         {
             var sMLFB_NEMA_KIT = aResult[0].HMK_MLFB_NEMAKIT_G120C; 
             
             if (sECSI_MLFB_SEC.length > 0)
             {
                 sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_NEMA_KIT;
             }
             else
             {
                 sECSI_MLFB_SEC = sMLFB_NEMA_KIT;
             }
         }
         else
         {
             // Fehler
             sECSI_STATUS = "E"; 
             sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___NEMA_MLFB_G120C") + " "; // "MLFB für 'NEMA KIT' nicht bestimmt, kein Treffer in DB. ";
         }
     }
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     // ENDE Zubehör
     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     
     
     var sECSI_MLFB_BASE_TYPE = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
     // Filter vor Bedienung sperren, wenn in BT defineirt
     var sFilterBT = sECSI_MLFB_BASE_TYPE.charAt(13); // MLFB14 wenn ".", dann darf umgewählt werden
     if (sFilterBT == "."){
         ECL_EnableAttribute("PMD_AAD146_001_000_G120C");
     }else{
         ECL_DisableAttribute("PMD_AAD146_001_000_G120C");
     }
     
     // Zusätzliche MLFBs setzen
     SetMlfbSec(sECSI_MLFB_SEC);
     
     // ###########################################################################################################
     // Consequences
     // ###########################################################################################################
     
     // MaxOutputFrequencyLimit
     var MaxOutputFrequencyLimit = "";
     var MaxPulseFrequency = "";
     var MinPulseFrequency = "";
     
     if (bLimitOutFrequency){
         MaxOutputFrequencyLimit = "150";
         MaxPulseFrequency = "4";
         var MinPulseFrequency = "4";
     }
     
     ECL_SetValue("ECSI_CC_MaxOutputFrequencyLimit", MaxOutputFrequencyLimit);
     ECL_SetValue("ECSI_CC_MaxPulseFrequency", MaxPulseFrequency);
     ECL_SetValue("ECSI_CC_MinPulseFrequency", MinPulseFrequency);
 
     // OutputReactorOrFilter	MLFB
     ECL_SetValue("ECSI_CC_OutputReactorOrFilter", OutputReactorOrFilter);
     
     
     // OutputReactorOrFilterType
     /* 	0	No output reactor or filter selected
         1	Single motor reactor selected
         2	Two motor reactor in series selected
         3	Sinus filter selected
         4	du/dt filter selected
     */
     ECL_SetValue("ECSI_CC_OutputReactorOrFilterType", OutputReactorOrFilterType);
     
     // InputFilterType
     /* 	0	No internal line filter selected
         1	Internal line filter C1
         2	Internal line filter C2
         3	Internal line filter C3
     */
     
     // ExternalFilterType
     /*	0	No external line filter selected
         1	External line filter C1
         2	External line filter C2
         3	External line filter C3
     */
     
     // BrakingResistorID
     // s.o. ECL_SetValue("ECSI_CC_BrakingResistorID", BrakingResistorID);
     
     // ###########################################################################################################
     // Fehlerstatus setzen
     if ( sECSI_STATUS != "E" && sECSI_STATUS != "WARNING") {
          sECSI_STATUS = "OK";
          sECSI_STATUS_MESSAGE = "";
      }
     // Übergabestatus setzen
     ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);

     if (sECSI_STATUS_MESSAGE.includes("WARNING")) {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sECSI_STATUS_MESSAGE));
    } else {
        ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
    }
     
     
     ECL_DeactivateAttribute("PMD_ABW171_001_000_G120C"); // 
     ECL_DeactivateAttribute("MLFB_KEY_G120C"); // 
     ECL_DeactivateAttribute("MLFB14_G120C"); // 
     ECL_DeactivateAttribute("MLFB15_G120C"); // 
 
     ECL_DeactivateValue("PMD_ABU804_001_000_G120C", "00013");
 
     //Attribute mit dem viewlevel 0 werden deactiviert
     ECL_DeactivateAttribute("HMK_VALUE_VALID_G120C");
     ECL_DeactivateAttribute("HMK_CN_TRIG_G120C");
     //ECL_DeactivateAttribute("HMK_REGION_G120C");
 
     
     
     var sFieldbusInterface = ECL_GetValue("ECSI_CX_FieldbusInterface");
     if (sFieldbusInterface !== "" && sFieldbusInterface !== undefined){
         iFieldbusInterface = parseInt(sFieldbusInterface);
         if (iFieldbusInterface >= 0) {
             ECL_DisableAttribute("PMD_ABU804_001_000_G120C");
         }
     }
 
 }
 
 function replaceAt(string, index, replace) {
   return string.substring(0, index) + replace + string.substring(index + 1);
 }
 
 // n_pos startet bei 0				aus 1FK2
 function replaceChar(s_src, s_char, n_pos)
 {
   if(s_src.length < n_pos)
     return s_src;
   var s=s_src.left(n_pos) + s_char + s_src.substring(n_pos + 1);
   return s;
 }
 
 
 
 /**
 Wertet eine Variantentabelle für das Zielattribut aus und deaktiviert die nicht gültigen Werte. 
 Gültig für die erste Einschränkung des Merkmals, weitere Einschränkungen mit der unteren Funktion.
 */
 function SetAttributeLogic1st(sTable, sTargetAttribute, sWhere, sDefault_x)
 {
     return SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, false);
 }
 /**
 Wertet eine Variantentabelle für das Zielattribut aus und deaktiviert die nicht gültigen Werte. 
 Gültig für weitere Einschränkungen des Merkmals, wenn bereits eine Einschränkung stattgefunden hat.
 */
 function SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere, sDefault_x) // bIntersect = true
 {
     return SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, true);
 }
 
 function SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, bIntersect)// = true weiter einschränken n. Lauf, bei false, erster Lauf,
 {
     var sDefault = sDefault_x || "";
     var sSQL = 	"SELECT DISTINCT " + sTargetAttribute + " FROM " + sTable + " WHERE " + sWhere;
     
     var aResult = GetDBDataSetEXT(sSQL);
     
     if (aResult.length > 0){
         if (bIntersect){
             var aValidValues = ECL_GetAllActiveAttributeValues(sTargetAttribute);
         }
         ECL_DeactivateAllAttributeValues(sTargetAttribute);
         //var test = ECL_GetAllActiveAttributeValues(sTargetAttribute);
         for (var i = 0; i < aResult.length; i++){
             if (bIntersect){
                 if (aValidValues.indexOf(aResult[i][sTargetAttribute]) > -1){
                     ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
                 }
             }else{
                 ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
             }
         } 
         //var test = ECL_GetAllActiveAttributeValues(sTargetAttribute);
         if (aResult.length == 1){
             ECL_SelectValue(sTargetAttribute, aResult[0][sTargetAttribute]);
         }
         else
         {
             ExecSetStandardifValueEmpty(sTargetAttribute, sDefault);
         }
     }
     else{
         // Fehler;
         return "Error";
     }
     return 0;
 }
 
 function SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sFalse, sWhere, bIntersect)// = true weiter einschränken n. Lauf, bei false, erster Lauf,
 {
     
     var sSQL = 	"SELECT DISTINCT " + sDTKAttribute + " FROM " + sTable + " WHERE " + sWhere;
     
     var aResult = GetDBDataSetEXT(sSQL);
     
     if (aResult.length > 0){
         if (bIntersect){
             var bEnabled = ECL_AttributeEnabled(sCB_Attribute);		// wenn true, dann kann noch gewählt werden, wenn false, dann ist schon auf KAG oder F eingeschränkt
             var bChecked = ECL_ValueSelected(sCB_Attribute, "T");	// KAG gesetzt?
         }
         
         var bValueTrueAviable = false;
         var bValueFalseAviable = false;
         // Prüfen, ob in der VT noch beide Werte erlaubt sind 
         for (var i = 0; i < aResult.length; i++){
             if (aResult[i][sDTKAttribute] == sKAG){
                     var bValueTrueAviable = true;
             }
             if (aResult[i][sDTKAttribute] == sFalse){
                     var bValueFalseAviable = true;
             }
         } 
         
         if (!bIntersect){ // Wenn vorbelegung relevant
             ECL_EnableAttribute(sCB_Attribute);
             bEnabled = true;
         }
         
         
         if (bEnabled && bValueTrueAviable && bValueFalseAviable)// wenn noch nicht eingeschränkt und beides möglich, tue nichts
         {
             // alles ok, nichts ändern
         }
         else if (bEnabled && bValueTrueAviable && !bValueFalseAviable)// wenn noch nicht eingeschränkt aber nur KAG erlaubt
         {
             ECL_SelectValue(sCB_Attribute, "T");
             ECL_DisableAttribute(sCB_Attribute);
         }
         else if (bEnabled && !bValueTrueAviable && bValueFalseAviable)// wenn noch nicht eingeschränkt aber nur F erlaubt
         {
             ECL_DeselectAttribute(sCB_Attribute);
             ECL_DisableAttribute(sCB_Attribute);
         }
         else{
             // nicht enabled, also schon eingeschränkt
             if (bChecked && !bValueTrueAviable){
                 // Fehler, nur noch KAG erlaubt, aber "F" gefordert
                 return "Error";
             }
             if (!bChecked && !bValueFalseAviable){
                 // Fehler, nur noch "F" erlaubt, aber KAG gefordert
                 return "Error";
             }
         }
         // unbewertet ist automatisch default "F" also unchecked
     }
     else{
         // Fehler;
         return "Error";
     }
     return 0;
 }
 
 function GetDBDataSetEXT(sSQL)
 {
     //return GetDBDataSetEXT(sSQL, null);
     
     var aResult = [];
     aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
     
     return aResult;
 }
 
 function isValueInArray(value, array)
 {
     for(var i=0; i < array.length; i++)
     {
         if(array[i] == value)
         {
             return true;
         }
     }
     return false;
 }
 
 function getFirmwareVersion() {
     var selectedFirmware = ECL_GetValue("HMK_FIRMWARE_G120C");
     var sQuery = "select MLFB from FIRMWARE where VERSION = ?";
     var version = [processVersion(selectedFirmware)];
 
     var aDbResult = Object.fromDatabase("G120C_FIRMWARE", sQuery, version);
 
     return aDbResult[0].MLFB;
 }
 
 function getLatestFirmwareVersion() {
     var sQuery = "select VERSION from FIRMWARE where NEWEST is 'true'";
     var aDbResult = Object.fromDatabase("G120C_FIRMWARE", sQuery);
 
     return processVersion(aDbResult[0].VERSION);
 }
 
 function processVersion(version) {
     if (version.includes("_")) {
         return processVersionFromUI(version);
     } else {
         return processVersionFromDB(version);
     }
 }
 
 function processVersionFromDB(versionFromDB) {
     var result = versionFromDB.replace(".", "_");
     result = result.replace(" ", "_");
     result = "VERSION_" + result.substr(1);
 
     return result;
 }
 
 function processVersionFromUI(versionFromUI) {
     var result = versionFromUI.split("VERSION_")[1];
     result = "V" + result;
     
     parts = result.split("_");
     result1 = "";
     for(var i = 0; i < parts.length; i++) {
         result1 += parts[i];
         
         if (i==0) {
             result1 += ".";
         } else {
             result1 += " ";
         }
     }
 
     return result1.trim();
 }
