//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_G120D
//     Date: 2019-03-26
//     User: Benjamin Christ, Plan Software GmbH
// ---------------------------------------------------------

                     // include easyKAT Configuration Library
//@import "SIZER_general_functions.js"

//#mode(full-ecma)


/*
Beispiel MLFBs
6SL35250PE175AA1 6SL35250PE275AA1  6SL35250PE240AA1
*/

globalThis.OnChangeConfiguration = function main()
{

    SetAttributesFromMlfb();
    
    // ------------------------------------------------------------------------------------------------------------------------------------------
    // Variablen
    var sECSI_MLFB               = ECL_GetValue("ECSI_MLFB");       	// Parameter fr Basis-MLFB
    var sECSI_MLFB_BASE_TYPE     = ECL_GetValue("ECSI_MLFB_BASE_TYPE"); // Parameter fr BaseType-MLFB
    var sECSI_MLFB_SEC           = GetMlfbSec();				   		// Parameter fr zustzliche MLFBs
    var sCurrentAttribute        = ECL_GetCurrentAttribute();      		 // aktuell bewertetes (oder durch SIZER bergebenes) Attribut
    
    var sECSI_CX_SafetyFunctions = "";  // Parameter mit einer Liste der bentigten Safety-Functions (0-12), untersttzt werden 0-4, ";" getrennt
    var aSafetyFunctionsSizer    = [];
    var iSafetyFunction          = 0;
    var sSafetyExtended          = ""   // Merker fr Safety-Level
    
    var sECSI_STATUS             = "";  // Status fr MLFB-bergabe
    var sECSI_STATUS_MESSAGE     = "";  // Statusmeldung fr MLFB-bergabe
    
    var sDezimalkenner           = "";  // Leistungsparameter aus MLFB
    var sLeistung1               = "";  // Leistungsparameter aus MLFB
    var sLeistung2               = "";  // Leistungsparameter aus MLFB
    var sLeistung                = "";  // Gesamtwert (String)
    
    var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    // ------------------------------------------------------------------------------------------------------------------------------------------

    // Dummy Aufrufe von SIZER unterdrcken
    if (sCurrentAttribute == '')
        return;
    
    if(sCurrentAttribute === "@INIT@")
    {
        //ECL_SetUserVariable("SafetyUserSet", "UserSet");
        // Status Interface
        ECL_DeactivateAttribute("ECSI_STATUS");
        ECL_DeactivateAttribute("ECSI_STATUS_MESSAGE");
        
        // Leistungsattribute nur zur Anzeige
        ECL_DeactivateAttribute("HMK_BEM_LEISTUNG_HO_G120D");
        ECL_DeactivateAttribute("TAK_AAP227_001_000_G120D");
        ECL_DeactivateAttribute("TAK_AAM458_001_000_G120D");
        ECL_DisableAttribute("HMK_NETZSPANNUNG_1003360");
        ECL_DisableAttribute("TAK_ABK776_001_000_G120D");
        
        ECL_DeactivateAttribute("HMK_FIRMWARE_G120D");

        // CU-Attribute nur Info
        ECL_DisableAttribute("HMK_SAFETY_LVL_3_G120D");
        ECL_DisableAttribute("HMK_PUSH_PULL_1003365");
        ECL_DisableAttribute("HMK_PUSH_PULL_LWL_G120D");
        ECL_DisableAttribute("HMK_EPOS_G120D");
        
        // Defaults setzen
        ECL_SetValue("HMK_NETZSPANNUNG_1003360", "00001");
        ECL_SetValue("TAK_ABK776_001_000_G120D", "00001");  // Phasenzahl
        ECL_SetValue("HMK_MEMORYCARD_G120D", "00001");
        ECL_DeselectValue("HMK_IOP_HANDHELD_G120D", "T");
        ECL_DeselectValue("HMK_RS232_KABEL_G120D", "T");
        ECL_DeselectValue("HMK_USB_KABEL_G120D", "T");
        ECL_DeselectValue("HMK_TOOL_STARTER_G120D", "T");
        ECL_DeselectValue("HMK_LEIST_SCHALTER_G120D", "T");
        ECL_DeselectValue("PMD_AAC947_001_000_G120D", "T");      // Sicherung
        
        // Fix connection selection to profinet, because no more profibus CUs are available
        ECL_SelectValue("PMD_ABU804_001_000_G120D", "00002");
        ECL_DisableAttribute("PMD_ABU804_001_000_G120D");

        return;
    }
    
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Hauptmodul (PowerModul)
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // MLFB
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // MLFB Aufbau z.B. 6SL3525-0PE17-5AA1
    // fix:                            6SL3525-0PE..-.AA1
    /*
    alles fix, nur Stellen 11, 12, 13 geben die Leistung an.
    01       06       07       08       09       10       11       12       13       14       15       16 - ID
    |        |        |        |        |        |        |        |        |        |        |        |
    |        |        |        |        |        |        |        |        |        |        |        - ? 1
    |        |        |        |        |        |        |        |        |        |        - ? A
    |        |        |        |        |        |        |        |        |        - ? A
    |        |        |        |        |        |        |        |        - Leistung 2. Stelle (0, 5)
    |        |        |        |        |        |        |        - Leistung 1. Stelle (1, 3, 4, 5, 7)
    |        |        |        |        |        |        - Leistung Dezimalstelle (1, 2): 1: 0,xx, 2: x,x
    |        |        |        |        |        - ? E 
    |        |        |        |        - ? P
    |        |        |        - ? 0        (ggf. Powermodul 250)
    |        |        - ? 5        (ggf. Powermodul 250)
    |        - ? 2        (ggf. Powermodul 250)
    - ? 6 (SL35)
    */
    
    
    // Fieldbusumwahl-check
    var sFieldbusInterface = ECL_GetValue("ECSI_CX_FieldbusInterface"); 
    var iFieldbusInterface = parseInt(sFieldbusInterface);
    
    if (sFieldbusInterface !== "" && sFieldbusInterface !== undefined) 
    {
        var iFieldbusInterface = parseInt(sFieldbusInterface);
        var sCU_Selected = ECL_GetValue("TAK_ABY576_001_000_G120D") || "";
        if (sCU_Selected !== "")
        {
            if ((iFieldbusInterface == 0) && !(
                (sCU_Selected == "00009") ||
                (sCU_Selected == "00014") ||
                (sCU_Selected == "00015") ||
                (sCU_Selected == "00010") ||
                (sCU_Selected == "00012") ||
                (sCU_Selected == "00016") ||
                (sCU_Selected == "00013") ))
            {
                //Fehler, Fieldbusvorgabe passt nicht zur CU
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE =  ECL_Translate("DICT1_ERR___FIELDBUS_CHANGED_G120D") + " "; 
                ECL_SetValue("ECSI_STATUS", sECSI_STATUS);
                ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                return;
            }
            else if ((iFieldbusInterface == 1) && !(
                     (sCU_Selected == "00007") ||
                     (sCU_Selected == "00008") ||
                     (sCU_Selected == "00011") ))
            {
                //Fehler, Fieldbusvorgabe passt nicht zur CU
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = ECL_Translate("DICT1_ERR___FIELDBUS_CHANGED_G120D") + " "; 
                ECL_SetValue("ECSI_STATUS", sECSI_STATUS);
                ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                return;
            }
            else if (iFieldbusInterface > 1) 
            {
            //Fehler, Fieldbusvorgabe passt nicht zur CU
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = ECL_Translate("DICT1_ERR___WRONG_FIELDBUS_G120D") + " "; 
                ECL_SetValue("ECSI_STATUS", sECSI_STATUS);
                ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                return;
            }
        }
    }
    
    // Motioncontrol-Umwahl-Check
    var sMotionControlReq = ECL_GetValue("ECSI_CX_MotionControlRequirements") || "";
    if (sMotionControlReq !== "" && sMotionControlReq !== "0") 
    {
        var sMotorTechnology = ECL_GetValue("ECSI_CX_MotorTechnology");
        var iMotionControlReq = parseInt(sMotionControlReq);

        if(sMotionControlReq === "2")
        {
            ECL_DeactivateValue("TAK_ABY576_001_000_G120D", "00011");
            ECL_DeactivateValue("TAK_ABY576_001_000_G120D", "00012");
            ECL_DeactivateValue("TAK_ABY576_001_000_G120D", "00013");
            ECL_DeactivateValue("TAK_ABY576_001_000_G120D", "00016");
        }
        
        if(sMotionControlReq === "1" && sMotorTechnology === "2")
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("MSG_ERR_CU_EPOS_RELUCTANCE_G120D"));
            return;
        }
        var sCU_Selected = ECL_GetValue("TAK_ABY576_001_000_G120D") || "";
        if (sCU_Selected == "")
        {
            var sSQL = "SELECT * FROM VT_G120D_M00002_26341 WHERE HMK_VALUE_VALID_G120D = 'T';";
            var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
            var sMLFB_CU_SIZER = "";
            if (aResult.length > 0)
            {
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_CU_G120D) >= 0)
                    {
                        var sMLFB_CU_SIZER = aResult[i].HMK_MLFB_CU_G120D;
                        break;
                    }
                }
                if ((sMLFB_CU_SIZER != "") && (iMotionControlReq == 1) && !(
                    (sMLFB_CU_SIZER == "6SL35460FB211PA0") ||
                    (sMLFB_CU_SIZER == "6SL35460FB211FA0") ||
                    (sMLFB_CU_SIZER == "6SL35460FB211FB0") ||
                    (sMLFB_CU_SIZER == "6SL35460FB211FC0") ))
                {
                    //Fehler, Motioncontrol-Vorgabe passt nicht zur CU
                    sECSI_STATUS = "E"; 
                    sECSI_STATUS_MESSAGE =  ECL_Translate("DICT1_ERR___MOTIONCONTROLREQ_CHANGED_G120D") + " "; 
                    ECL_SetValue("ECSI_STATUS", sECSI_STATUS);
                    ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                    return;
                }
            }
        }
        else
        {
            if ((iMotionControlReq == 1) && !(
                (sCU_Selected == "00011") ||
                (sCU_Selected == "00012") ||
                (sCU_Selected == "00013") ||
                (sCU_Selected == "00016") ))
            {
                //Fehler, Motioncontrol-Vorgabe passt nicht zur CU
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE =  ECL_Translate("DICT1_ERR___MOTIONCONTROLREQ_CHANGED_G120D") + " "; 
                ECL_SetValue("ECSI_STATUS", sECSI_STATUS);
                ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                return;
            }
        }
    }
    
    if (sCurrentAttribute == "ECSI_MLFB") // neu parsen        
    {
        if (sECSI_MLFB !== "")
        {
            sECSI_MLFB = sECSI_MLFB.replace(/\s+/g, "");             // Leerzeichen entfernen
            sECSI_MLFB = sECSI_MLFB.replace("-", "");             	 // Bindestriche entfernen
            sECSI_MLFB= sECSI_MLFB.replace("?", ".").toUpperCase();  // Fragezeichen ersetzen
            ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
            
            // Prfen, ob die Zeichenkette 16 Stellen hat
            if (sECSI_MLFB.length != 16)
            {
                // bergabefehler abfangen
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_PRODUCT_G120D") + " " + sECSI_MLFB.length; // "Ungltige MLFB-Lnge";
            }
            if (sECSI_MLFB.indexOf("6SL35250PE") < 0)
            {
                // Falsches Produkt
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_PRODUCT_G120D") + " "; // "Falsches Produkt bergeben. Nicht G120D. ";
            }
            
            // wenn Punkte im String enthalten sind, ist die MLFB nicht vollstndig spezifiziert.
            var iIndex = sECSI_MLFB.indexOf(".");
            if (iIndex >= 0)
            {   // Fehler 
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___PLACEHOLDER_MLFB_G120D") + " "; // "Platzhalter in MLFB, nicht vollstndig. ";
            }
            
            //#########################################################################################################################
            // Keep Configuration
            //#########################################################################################################################
            
            var bKeepConf = false;
            
            if( (sECSI_MLFB_BASE_TYPE!=sECSI_MLFB) && find(sECSI_MLFB.left(16), ".") < 0 && sECSI_MLFB_BASE_TYPE != "")
            {
                bKeepConf = true;
                
                sECSI_MLFB = sECSI_MLFB_BASE_TYPE;
                ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
            }
            //#########################################################################################################################
            
            
            // Leistungsdaten herauslesen
            sDezimalkenner = sECSI_MLFB.substr(10, 1); // wenn 1: 0,xx | wenn 2: x,x 
            var aValidValues1 = ["1", "2"]; // ggf. aus DB-VT holen?
            if (aValidValues1.indexOf(sDezimalkenner) < 0)
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DECIMAL_IDENT_OUTOFRANGE_G120D") + " "; //"Dezimalkenner fr Leistungsangabe nicht im zulssigen Bereich. ";
            }
            
            sLeistung1 = sECSI_MLFB.substr(11, 1);
            var aValidValues2 = ["1", "3", "4", "5", "7"]; // ggf. aus DB-VT holen?
            if (aValidValues2.indexOf(sLeistung1) < 0)
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___POWER_VALUE_1_OUTOFRANGE_G120D") + " '" + sLeistung1 + "' "; //"Leistungsparameter 1 nicht im zulssigen Bereich: '" + sLeistung1 + "' ";
            }
            
            sLeistung2 = sECSI_MLFB.substr(12, 1);
            var aValidValues3 = ["0", "5"]; // ggf. aus DB-VT holen?
            if (aValidValues3.indexOf(sLeistung2) < 0)
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___POWER_VALUE_2_OUTOFRANGE_G120D") + " '" + sLeistung2 + "' "; //"Leistungsparameter 2 nicht im zulssigen Bereich: '" + sLeistung2 + "' ";
            }
            
            if (sECSI_STATUS == "E")
            {
                // bergabestatus setzen
                ECL_SetValue("ECSI_STATUS", sECSI_STATUS);
                ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                    return;
            }
            
            //Leistungsdaten abfragen und setzen:
            var sSQL = "SELECT * FROM VT_G120D_M00001_26341 WHERE MLFB11_G120D = '" +  sDezimalkenner + "' AND MLFB12_G120D = '" 
                        +  sLeistung1 + "' AND MLFB13_G120D = '" +  sLeistung2 + "' AND HMK_VALUE_VALID_G120D = 'T';" 
            var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
            
            if (aResult && aResult.length == 1)
            {
                ECL_SetValue("HMK_BEM_LEISTUNG_HO_G120D", aResult[0].HMK_BEM_LEISTUNG_HO_G120D);   // Bemessungsleistung (kW)
                ECL_SetValue("TAK_AAP227_001_000_G120D",  aResult[0].TAK_AAP227_001_000_G120D);    // Bemessungsleistung/(HP)
                ECL_SetValue("TAK_AAM458_001_000_G120D",  aResult[0].TAK_AAM458_001_000_G120D);    // Bemessungsausgangsstrom/(HO)
            }
            else
            {
                // Fehler: fr Leistungsdaten kein Treffer in VT:
                sECSI_STATUS = "E"; 
                if (sDezimalkenner == "1") 
                {
                    sLeistung = "0," + sLeistung1 + sLeistung2 + "kW";
                }
                else
                {
                    sLeistung = sLeistung1 + "," + sLeistung2 + "kW";
                }
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___NO_VALUE_VT_POWER_G120D") + " '" + sLeistung + "' "; // "Kein Treffer in Variantentabelle fr Leistungswert: '" + sLeistung +"' ";
            }
        }
        else
        {
            //Fehler bei MLFB bergabe
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MLFB_NOT_DEFINED_G120D") + " "; //"MLFB nicht definiert. ";
            ECL_SetValue("ECSI_STATUS", sECSI_STATUS);
            ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                return;
        }
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // FieldbusInterface aus SIZER-bergabe analysieren    
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        /*
            Null    Any (nothing specific set by the user)
            0       PROFINET
            1       PROFIBUS
            2       AS-i            <-- derzeit fr G120D nicht untersttzt!
            3       USS/Modbus RTU  <-- derzeit fr G120D nicht untersttzt!
        */
        var sFieldbusInterface = ECL_GetValue("ECSI_CX_FieldbusInterface");
        var sErrBus = "OK";
        var sErrBus_Req = "OK";
        if (sFieldbusInterface !== "" && sFieldbusInterface !== undefined) 
        {
            var iFieldbusInterface = parseInt(sFieldbusInterface);
            
            if (iFieldbusInterface < 0 || iFieldbusInterface > 1)
            {
                // Fehler: G120D kann nur 0 und 1 (Profibus und Profinet)
                sErrBus = "Error";
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_FIELDBUS_G120D") + " "; //"Es wurden ein Feldbus vom Sizer bergeben, der vom G120D nicht untersttzt wird. ";
            }
            
            // Merker-Variable setzen, die anzeigt, dass Vorgabe durch SIZER
            // ECL_SetUserVariable("BusUserSet", "SIZER_FB"); 
            
            // Wert aus ECSI_CX_FieldbusInterface setzen
            switch (iFieldbusInterface)
            {
                case 0:
                    // 0 feste Auswahl von Profinet
                    if ( ECL_ValueEnabled("PMD_ABU804_001_000_G120D", "00002"))
                    {
                        ECL_SelectValue("PMD_ABU804_001_000_G120D", "00002");
                    }
                    else
                    {
                        sErrBus_Req = "ERROR";
                    }
                    break;
                
                case 1:
                    // 1 feste Auswahl von Profibus
                    if ( ECL_ValueEnabled("PMD_ABU804_001_000_G120D", "00001"))
                    {
                        ECL_SelectValue("PMD_ABU804_001_000_G120D", "00001");
                    }
                    else
                    {
                        sErrBus_Req = "ERROR";
                    }
                    break;
            }
            if (sErrBus_Req == "ERROR")
            {
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FIELDBUS_CHANGED_G120D") + " "; 
            }
        }
        else
        {
            // Default setzen
            ExecSetStandardifValueEmpty("PMD_ABU804_001_000_G120D", "00002");
        }
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // MotionControlRequirements aus SIZER-bergabe analysieren    
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        /*
            Null    Any (nothing specific set by the user)
            0    Speed-controlled
            1    Dive-based positioning via easy positioner (EPOS)
            2    PLC-based positioning via SIMATIC technology object                       <-- nicht untersttzt!
            3    Drive-based motion control via SINAMICS TEC (technology extension)        <-- nicht untersttzt!
            4    PLC-based motion control via SIMATIC technology object                    <-- nicht untersttzt!
            5    Numerical control via SINUMERIK                                           <-- nicht untersttzt!
            
        */
        var sMotionControlReq = ECL_GetValue("ECSI_CX_MotionControlRequirements") || "";
        if (sMotionControlReq !== "" && sMotionControlReq !== "0") 
        {
            var iMotionControlReq = parseInt(sMotionControlReq);
            if (iMotionControlReq < 0 || iMotionControlReq > 27) 
            {
                // Fehler: G120D kann nur 0 und 1 (Speed-Controlled oder EPOS)
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_MOTIONCONTROLREQ_G120D") + " "; //"Es wurden eine MotionControlRequirement vom Sizer bergeben, wlche vom G120D nicht untersttzt wird. ";
            }
            var sErrMotion_Req = "OK";
            // Wert aus ECSI_CX_MotionControlRequirements setzen
            switch (iMotionControlReq)
            {
                case 0:
                    // 0 kein EPOS?
                    if (!ECL_ValueEnabled("HMK_EPOS_G120D", "T")
                    ) {
                        ECL_ResetAttribute("HMK_EPOS_G120D"); //, "F");
                    }
                    else
                    {
                        sErrMotion_Req = "ERROR";
                    }
                    break;
                
                case 1:
                    // 1 EPOS
                    if ( ECL_ValueEnabled("HMK_EPOS_G120D", "T")
                    ) {
                        ECL_SetValue("HMK_EPOS_G120D", "T");
                    }
                    else
                    {
                        sErrMotion_Req = "ERROR";
                    }
                    break;
            }
            if (sErrMotion_Req == "ERROR")
            {
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MOTIONCONTROLREQ_CHANGED_G120D") + " "; 
            }
        }
        else
        {
            // Eingabe durch Benutzer
            // Merker-Variable setzen, die anzeigt, dass keine Vorgabe durch SIZER
            ECL_SetUserVariable("EPOSUserSet", "USER");
            ECL_ResetAttribute("HMK_EPOS_G120D");
            //ECL_DeselectValue("HMK_EPOS_G120D", "T");
        }
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Sekundre MLFBs analysieren
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        sECSI_MLFB_SEC = GetMlfbSec() || "";
        
        // Alle Vorbelegungen unterhalb lschen/Default setzen
        ECL_SetValue("HMK_NETZSPANNUNG_1003360", "00001");
        ECL_SetValue("TAK_ABK776_001_000_G120D", "00001");
        
        
        if (sECSI_MLFB_SEC !== "") 
        {
            // bergebene MLFB_SEC parsen
            
            // mgliche MLFBs:
            /*
            ControlUnit         VT_G120D_M00002_26341   HMK_MLFB_CU_G120D               00007...00016
            IOP Handheld        6SL32550AA004HA1                                        T/F
            Speicherkarte       leer: 6SL30544AG002AA0; mit Firmware: 6SL30547TE002BA0  00234, 00235
            RS232 Kabel         3RK19222BP00                                            T/F
            USB Kabel           6SL35550PA002AA0                                        T/F
            Starter DVD         6SL30720AA000AG0                                        T/F
            Sicherung           VT_G120D_M00005_26341   HMK_MLFB_SICHERUNG_G120D        T/F
            Leistungsschalter   VT_G120D_M00006_26341   MLFB_L_SCHALTER_G120D           T/F
            */
            
            var aMLFB_SEC_SIZER = sECSI_MLFB_SEC.split(';');
            
            //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // CU               VT_G120D_M00002_26341   HMK_MLFB_CU_G120D               00007...00016
            //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // CU setzen
            // Bussystem setzen, ggf. auto durch VT?
            // Safety setzen, ggf. auto durch VT?
            // Steckverbinder???, ggf. auto durch VT?
            // Positionierfunktionalitt, ggf. auto durch VT?
            
            sSafetyExtended = "";
            //ECL_ResetAttribute("HMK_SAFETY_LVL_3_G120D");
            // MLFBs aus DB abfragen
            var sSQL = "SELECT * FROM VT_G120D_M00002_26341 WHERE HMK_VALUE_VALID_G120D = 'T';";
            var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
            if (aResult.length > 0)
            {
                var sStatusCU = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_CU_G120D) >= 0)
                    {
                        var sMLFB_CU_SIZER = aResult[i].HMK_MLFB_CU_G120D;
                                                
                        sStatusCU = "mit";
                        
                        //Safety:
                        var sSafetyLevel_MLFB_CU = sMLFB_CU_SIZER.charAt(11);
                        
                        if (sSafetyLevel_MLFB_CU == "0")
                        {
                            sSafetyExtended = "basic";
                        }
                        else if (sSafetyLevel_MLFB_CU == "1")
                        {
                            sSafetyExtended = "extended";
                        }
                        /*else
                        {
                            //Fehler
                            var stopp;
                        }*/
                        
                        // Prfen, ob EPOS gefordert (ECSI_CX_MotionControlRequirements == 1)
                        if (sMotionControlReq !== "" && iMotionControlReq == 1)
                        {
                            //CU muss 250er sein mit extended safety
                            var sSQL_EPOS = "SELECT * FROM VT_G120D_M00007_26341 WHERE TAK_ABY576_001_000_G120D = '" + aResult[i].TAK_ABY576_001_000_G120D + "' AND HMK_EPOS_G120D = 'T';"; 
                            
                            var aResultEPOS = Object.fromDatabase("EXTERNAL_DATA", sSQL_EPOS);
                            if (aResultEPOS.length > 0)
                            {
                                // CU
                                ECL_SetValue("TAK_ABY576_001_000_G120D", aResult[i].TAK_ABY576_001_000_G120D);
                                // BUS-System
                                ECL_SelectValue("PMD_ABU804_001_000_G120D", aResult[i].PMD_ABU804_001_000_G120D);
                                // Steckverbindung Push-Pull
                                ECL_SetValue("HMK_PUSH_PULL_1003365", aResult[i].HMK_PUSH_PULL_1003365);
                                /*
                                MLFB: 6SL3544-0FB20-1PA0
                                      01234567890123456
                                      6SL354 - CU allgemein
                                           4 - CU240D
                                           6 - CU250D
                                              0FB2 fix
                                                  0 - Basic-Safety
                                                  1 - Extended Safety (-F)
                                                    0 - ggf. Fehler in der Vertriebsdoku
                                                    1 - immer 1
                                                     P - Profibus (PA)
                                                     F - Profinet (FA)
                                                      A - ohne PP ()
                                                      B - PushPull/AIDA Anschlusstechnik (PP)
                                                      C - LWL in PP (FO)
                                                       0 - fix, immer 0
                                */
                            }
                            else
                            {
                                //Fehler, CU aus SEC-MLFB passt nicht zu EPOS-Vorgabe
                                sECSI_STATUS = "E"; 
                                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___CU_EPOS_G120D") + " "; // "Die bergebenen CU-MLFB passt nicht zur Vorgabe 'EPOS'. ";
                            }
                        }
                        else // EPOS nicht gefordert
                        {
                            // Prfen, ob Extended Safety gefordert:
                            sECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
                            
                            // Wenn Vorgabe aus TST vorhanden ist:
                            if (sECSI_CX_SafetyFunctions !== "" && sECSI_CX_SafetyFunctions !== undefined)
                            {
                                // bergabe in sauberes Array aufsplitten
                                aSafetyFunctionsSizer = sECSI_CX_SafetyFunctions.split(";");
                                // Sortieren
                                aSafetyFunctionsSizer = aSafetyFunctionsSizer.sort();
                                var sSafetyExt_Req = "ohne"; 
                                var iSafetyLevel = 0;
                                for (var j = 0; j < aSafetyFunctionsSizer.length; j++)
                                {
                                    iSafetyLevel = parseInt(aSafetyFunctionsSizer[j]);
                                }
                                if (iSafetyLevel > 0 && sSafetyExtended == "basic")
                                {
                                    //Fehler, genderter Safty-Level
                                    // Fehler: Vorgabe aus CU-MLFB ist Basic, aber bergebene Safetyfunctions ergeben Extended!
                                    sECSI_STATUS = "E"; 
                                    sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SAFETYFUNCTIONS_CHANGED_G120D") + " "; 
                                    ECL_SetValue("ECSI_STATUS", sECSI_STATUS);
                                    ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                                    return;
                                }
                                else
                                {
                                    // CU
                                    ECL_SetValue("TAK_ABY576_001_000_G120D", aResult[i].TAK_ABY576_001_000_G120D);
                                    // BUS-System
                                    ECL_SelectValue("PMD_ABU804_001_000_G120D", aResult[i].PMD_ABU804_001_000_G120D);
                                    // Steckverbindung Push-Pull
                                    ECL_SetValue("HMK_PUSH_PULL_1003365", aResult[i].HMK_PUSH_PULL_1003365);
                                }
                            }
                            else
                            {
                                // CU
                                ECL_SetValue("TAK_ABY576_001_000_G120D", aResult[i].TAK_ABY576_001_000_G120D);
                                // BUS-System
                                ECL_SelectValue("PMD_ABU804_001_000_G120D", aResult[i].PMD_ABU804_001_000_G120D);
                                // Steckverbindung Push-Pull
                                ECL_SetValue("HMK_PUSH_PULL_1003365", aResult[i].HMK_PUSH_PULL_1003365);
                                
                            }
                        }
                    }
                } // end for
                if (sStatusCU == "ohne")
                {
                    // CU
                    ECL_ResetAttribute("TAK_ABY576_001_000_G120D");
                    // BUS-System
                    ECL_ResetAttribute("PMD_ABU804_001_000_G120D");
                    // Steckverbindung Push-Pull
                    ECL_ResetAttribute("HMK_PUSH_PULL_1003365");
                }
            }
            else
            {
                // CU
                ECL_ResetAttribute("TAK_ABY576_001_000_G120D");
                // BUS-System
                ECL_ResetAttribute("PMD_ABU804_001_000_G120D");
                // Steckverbindung Push-Pull
                ECL_ResetAttribute("HMK_PUSH_PULL_1003365");
            }
            //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ---------------------------------------------------------------------------
            //IOP Handheld      6SL32550AA004HA1                    T/F
            if (sECSI_MLFB_SEC.indexOf("6SL32550AA004HA1") >= 0)
            {
                // MLFB enthalten, also Attribute fr bergebene MLFBs belegen
                
                ECL_SetValue("HMK_IOP_HANDHELD_G120D", "T");
                //ECL_DisableAttribute("HMK_IOP_HANDHELD_G120D");
            }
            else
            {
                ECL_DeselectValue("HMK_IOP_HANDHELD_G120D", "T");
            }
            // ---------------------------------------------------------------------------
            
            // ---------------------------------------------------------------------------
            //DriveSim Designer      9SV11103AA000AA0                    T/F
            if (sECSI_MLFB_SEC.indexOf("9SV11103AA000AA0") >= 0)
                {
                    // MLFB enthalten, also Attribute fr bergebene MLFBs belegen
                    
                    ECL_SetValue("HMK_DRIVESIM_DESIGNER_G120D", "T");
                    //ECL_DisableAttribute("HMK_IOP_HANDHELD_G120D");
                }
                else
                {
                    ECL_DeselectValue("HMK_DRIVESIM_DESIGNER_G120D", "T");
                }
                // ---------------------------------------------------------------------------

            //Speicherkarte     leer: 6SL30544AG002AA0;             00234
            if (sECSI_MLFB_SEC.indexOf("6SL30544AG002AA0") >= 0)
            {
                // MLFB enthalten, also Attribute fr bergebene MLFBs belegen
                ECL_SetValue("HMK_MEMORYCARD_G120D", "00234");
            }
            //Speicherkarte     mit Firmware: 6SL30547TE002BA0      00235	alt
            //Speicherkarte     mit Firmware: 6SL30547TF002BA0      00235	neu
            else if (sECSI_MLFB_SEC.indexOf("6SL30547TF002BA0") >= 0 || sECSI_MLFB_SEC.indexOf("6SL30547TH002BA0") >= 0 || sECSI_MLFB_SEC.indexOf("6SL30547TE002BA0") >= 0 || sECSI_MLFB_SEC.indexOf("6SL30547TG002BA0") >= 0)	// abwrtskompatibilitt
            {
                // MLFB enthalten, also Attribute fr bergebene MLFBs belegen
                ECL_SetValue("HMK_MEMORYCARD_G120D", "00235");

                if (sECSI_MLFB_SEC.indexOf("6SL30547TF002BA0") >= 0){
                    ECL_SetValue("HMK_FIRMWARE_G120D", "VERSION_4_7_SP10_HF6");
                } else if(sECSI_MLFB_SEC.indexOf("6SL30547TG002BA0") >= 0){
                    ECL_SetValue("HMK_FIRMWARE_G120D", "VERSION_4_7_SP13");
                }
                else {
                    ECL_SetValue("HMK_FIRMWARE_G120D", "VERSION_4_7_SP14");
                }
            }
            else // ohne
            {
                ECL_SetValue("HMK_MEMORYCARD_G120D", "00001");
            }
            // ---------------------------------------------------------------------------
            
            //RS232 Kabel       3RK19222BP00                        T/F
            if (sECSI_MLFB_SEC.indexOf("3RK19222BP00") >= 0)
            {
                // MLFB enthalten, also Attribute fr bergebene MLFBs belegen
                ECL_SetValue("HMK_RS232_KABEL_G120D", "T");
            }
            else
            {
                ECL_DeselectValue("HMK_RS232_KABEL_G120D", "T");
            }
            // ---------------------------------------------------------------------------
            
            //USB Kabel         6SL35550PA002AA0                    T/F
            if (sECSI_MLFB_SEC.indexOf("6SL35550PA002AA0") >= 0)
            {
                // MLFB enthalten, also Attribute fr bergebene MLFBs belegen
                ECL_SetValue("HMK_USB_KABEL_G120D", "T");
            }
            else
            {
                ECL_DeselectValue("HMK_USB_KABEL_G120D", "T");
            }
            // ---------------------------------------------------------------------------
            
            //Starter DVD       6SL30720AA000AG0                    T/F
            if (sECSI_MLFB_SEC.indexOf("6SL30720AA000AG0") >= 0)
            {
                // MLFB enthalten, also Attribute fr bergebene MLFBs belegen
                ECL_SetValue("HMK_TOOL_STARTER_G120D", "T");
            }
            else
            {
                ECL_DeselectValue("HMK_TOOL_STARTER_G120D", "T");
            }
            // ---------------------------------------------------------------------------
            
            // Extended service protection
            if (aMLFB_SEC_SIZER.includes("9MC31104SE000AL7")){
                ECL_SetValue("HMK_DSEE_G120C", "DSEE3")
            }
            else if (aMLFB_SEC_SIZER.includes("9MC31104SE000AN4")) {
                ECL_SetValue("HMK_DSEE_G120C", "DSEE5")
            }
            else {
                ECL_SetValue("HMK_DSEE_G120C", "OHNE")
            }
            // ---------------------------------------------------------------------------

            //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Sicherung
            //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            var sSQL = "SELECT DISTINCT HMK_MLFB_SICHERUNG_G120D FROM VT_G120D_M00005_26341 WHERE HMK_VALUE_VALID_G120D = 'T';";
            var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_SICHERUNG_G120D) >= 0)
                    {
                        ECL_SetValue("PMD_AAC947_001_000_G120D", "T");
                        sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_DeselectValue("PMD_AAC947_001_000_G120D", "T");
                }
            }
            else
            {
                ECL_DeselectValue("PMD_AAC947_001_000_G120D", "T");
            }
            //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Leistungsschalter
            //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            var sSQL = "SELECT DISTINCT MLFB_L_SCHALTER_G120D FROM VT_G120D_M00006_26341 WHERE HMK_VALUE_VALID_G120D = 'T';";
            var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].MLFB_L_SCHALTER_G120D) >= 0)
                    {
                        ECL_SetValue("HMK_LEIST_SCHALTER_G120D", "T");
                        sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_DeselectValue("HMK_LEIST_SCHALTER_G120D", "T");
                }
            }
            else
            {
                ECL_DeselectValue("HMK_LEIST_SCHALTER_G120D", "T");
            }
            //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
        }
        else
        {
            // keine sekundr MLFBs 
            sSafetyExtended = "";
            ECL_ResetAttribute("HMK_SAFETY_LVL_3_G120D");
        }
        
        // ########################################################################################################################################
        // Ende Sec-MLFB
        // ########################################################################################################################################
        
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Safety Functions aus SIZER-bergabe analysieren    
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        sECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
        
        // Wenn Vorgabe aus TST vorhanden ist:
        if (sECSI_CX_SafetyFunctions !== "" && sECSI_CX_SafetyFunctions !== undefined)
        {
            // bergabe in sauberes Array aufsplitten
            aSafetyFunctionsSizer = sECSI_CX_SafetyFunctions.split(";");
            // Sortieren
            aSafetyFunctionsSizer = aSafetyFunctionsSizer.sort();
            
            //Prfen, ob bergabewert zu CU passt
            if (sSafetyExtended == "basic") // Wert aus CU, wenn nicht == "", dann ist eine CU aus Sekundr-MLFB vorbelegt 
            {
                var bErrSafety = false;
                for (var i = 0; i < aSafetyFunctionsSizer.length; i++)
                {
                    iSafetyFunction = parseInt(aSafetyFunctionsSizer[i]);
                    
                    // untersttzte Funktion:
                    if (iSafetyFunction == 0)
                    {
                        // Basic ist Vorgabe, passt
                    }
                    else if (iSafetyFunction > 0) 
                    {
                        // Fehler: Vorgabe aus CU-MLFB ist Basic, aber bergebene Safetyfunctions ergeben Extended!
                        bErrSafety = true;
                    }
                }
                if (bErrSafety)
                {
                    // Fehler: Vorgabe aus CU-MLFB ist Basic, aber bergebene Safetyfunctions ergeben Extended!
                        sECSI_STATUS = "E"; 
                        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SAFETY2_G120D") + " "; // "Die Vorgabe(n) fr Safety-Functions widersprechen der bergebenen CU-MLFB. ";
                }
            }
            else if (sSafetyExtended == "") // Keine Vorgabe aus CU
            {
                var bErrSafety = false;
                for (var i = 0; i < aSafetyFunctionsSizer.length; i++)
                {
                    iSafetyFunction = parseInt(aSafetyFunctionsSizer[i]);
                    if (iSafetyFunction < 5)
                    {
                        // untersttzte Funktion:
                        if (iSafetyFunction == 0)
                        {
                            // STO --> Basic
                            sSafetyExtended = "basic";
                        }
                        else if (iSafetyFunction > 0) 
                        {
                            // SS1, SLS, SSM, SDI --> Extended
                            sSafetyExtended = "extended";
                        }
                    }
                    else if ((iSafetyFunction == 13) || (iSafetyFunction == 14)) {
                        sSafetyExtended = "extended";
                    }
                    else
                    {
                        // nicht untersttzte Funktion:
                        bErrSafety = true;
                    }
                }
                if (bErrSafety)
                {
                    // nicht untersttzte Funktion:
                    sECSI_STATUS = "E"; 
                    sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SAFETY_G120D") + " "; //"Es wurden Safety-Functions vom Sizer bergeben, die nicht untersttzt werden.";
                }
                
            }
            
            // Safety setzen, wenn extended
            if (sSafetyExtended == "extended")
            {
                ECL_SelectValue("HMK_SAFETY_LVL_3_G120D", "T");
                // Nur CUs zulassen, die Safety_Extended untersttzen
            }
            else if (sSafetyExtended == "basic")
            {
                ECL_DeselectValue("HMK_SAFETY_LVL_3_G120D", "T");
            }
            
        }
        else // keine Vorgabe aus Sizer: sECSI_CX_SafetyFunctions == ""
        {
            // keine Einschrnkung fr CU
        }
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    }
    // ENDE Parser
    // ########################################################################################################################################################
    // ########################################################################################################################################################
    
    var fBemessungsleistungKW = ECL_GetValue("HMK_BEM_LEISTUNG_HO_G120D");
    
    if (sCurrentAttribute == "PMD_ABU804_001_000_G120D"){
            ECL_ActivateAllAttributeValues("TAK_ABY576_001_000_G120D");
    }
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Safety --> CU
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    var sSafetyLevel = "";
    var sECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
    if (sECSI_CX_SafetyFunctions !== "" && sECSI_CX_SafetyFunctions !== undefined)
    {
        
        // bergabe in sauberes Array aufsplitten
        aSafetyFunctionsSizer = sECSI_CX_SafetyFunctions.split(";");
        // Sortieren
        aSafetyFunctionsSizer = aSafetyFunctionsSizer.sort();
        var bErrSafety = false;
        for (var i = 0; i < aSafetyFunctionsSizer.length; i++)
        {
            iSafetyFunction = parseInt(aSafetyFunctionsSizer[i]);
            
            // untersttzte Funktion:
            if (iSafetyFunction == 0)
            {
                // Basic
                sSafetyLevel = "BASIC";
            }
            else if ( (iSafetyFunction > 0) && (iSafetyFunction < 5) || (iSafetyFunction == 13) || (iSafetyFunction == 14)
            ) {
                // Extended
                sSafetyLevel = "EXTENDED";
            }
            else
            {
                bErrSafety = true;
            }
        }
        
        if (bErrSafety)
        {
            // nicht untersttzte Funktion:
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SAFETY_G120D") + " "; //"Es wurden Safety-Functions vom Sizer bergeben, die nicht untersttzt werden.";
        }
        
        
        if (sSafetyLevel == "EXTENDED")
        {
            // 
            ECL_SelectValue("HMK_SAFETY_LVL_3_G120D", "T");
            
            var sBus = ECL_GetValue("PMD_ABU804_001_000_G120D"); 
            
            var sSQL_CU_Join = "SELECT DISTINCT VT_G120D_M00002_26341.TAK_ABY576_001_000_G120D FROM VT_G120D_M00002_26341 " +
                                "INNER JOIN VT_G120D_M00004_26341 " +
                                "ON VT_G120D_M00002_26341.TAK_ABY576_001_000_G120D = VT_G120D_M00004_26341.TAK_ABY576_001_000_G120D " +
                                "WHERE VT_G120D_M00004_26341.HMK_SAFETY_LVL_3_G120D = 'T' AND VT_G120D_M00002_26341.PMD_ABU804_001_000_G120D = '" + sBus + "';";
            
            var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL_CU_Join);
            if (aResult.length > 0)
            {
                ECL_DeactivateAllAttributeValues("TAK_ABY576_001_000_G120D");
                for (var i = 0; i < aResult.length; i++)
                {
                    ECL_ActivateValue("TAK_ABY576_001_000_G120D", aResult[i].TAK_ABY576_001_000_G120D);
                }
            }
        }
        else
        {
            ECL_DeselectValue("HMK_SAFETY_LVL_3_G120D", "T");
        }
        
    }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // EPOS --> Control Units
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    var sMotionControl = ECL_GetValue("ECSI_CX_MotionControlRequirements");
    if (sMotionControl !== "" || sMotionControl !== undefined)
    {
        if ( sMotionControl == "1"
        ) {
            ECL_SelectValue("HMK_EPOS_G120D", "T");
            // CU-Auswahl einschrnken:
            var aAttributesVT07 = ["HMK_EPOS_G120D"]; 
                
            setValuesFromDatabase("VT_G120D_M00007_26341", "TAK_ABY576_001_000_G120D", aAttributesVT07);
        }
        else
        {
            // Wenn CU noch nicht gewhlt wurde
            //ECL_SelectValue("HMK_EPOS_G120D", "F");
        }
    }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Control Units VT: VT_G120D_M00002_26341
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /*
    Control Units               TAK_ABY576_001_000_G120D    (00007, ..., 00016)
    Bussystem / integriert      PMD_ABU804_001_000_G120D    (00001, 00002)
    MLFB Control Units          HMK_MLFB_CU_G120D
    Steckverbindung Push-Pull   HMK_PUSH_PULL_1003365       (T, F)
    
    240D-2 fr Standard und Safety
    250D-2 bei Positionierung (EPos), immer mit Safety (-F)
    
    MLFB: 6SL3544-0FB20-1PA0
          6SL354 -CU allgemein
                4 - CU240D
                6 - CU250D
                  0FB2 fix
                      0 - Basic-Safety
                      1 - Extended Safety (-F)
                        0 - ggf. Fehler in der Vertriebsdoku
                        1 - immer 1
                         P - Profibus (PA)
                         F - Profinet (FA)
                          A - ohne PP ()
                          B - PushPull/AIDA Anschlusstechnik (PP)
                          C - LWL in PP (FO)
                           0 - fix, immer 0
    */
    
    var sBus = ECL_GetValue("PMD_ABU804_001_000_G120D"); 
    
    if (sSafetyLevel == "EXTENDED")
    {
        var sSQL_CU_Join = "SELECT DISTINCT VT_G120D_M00002_26341.TAK_ABY576_001_000_G120D FROM VT_G120D_M00002_26341 " +
                            "INNER JOIN VT_G120D_M00004_26341 " +
                            "ON VT_G120D_M00002_26341.TAK_ABY576_001_000_G120D = VT_G120D_M00004_26341.TAK_ABY576_001_000_G120D " +
                            "WHERE VT_G120D_M00004_26341.HMK_SAFETY_LVL_3_G120D = 'T' AND VT_G120D_M00002_26341.PMD_ABU804_001_000_G120D = '" + sBus + "';";
    }
    else
    {
        var sSQL_CU_Join = "SELECT DISTINCT VT_G120D_M00002_26341.TAK_ABY576_001_000_G120D FROM VT_G120D_M00002_26341 " +
                            "INNER JOIN VT_G120D_M00004_26341 " +
                            "ON VT_G120D_M00002_26341.TAK_ABY576_001_000_G120D = VT_G120D_M00004_26341.TAK_ABY576_001_000_G120D " +
                            "WHERE VT_G120D_M00002_26341.PMD_ABU804_001_000_G120D = '" + sBus + "';";
    }
    var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL_CU_Join);
    if (aResult.length > 0)
    {
        var aValidValuesCU = ECL_GetAllActiveAttributeValues("TAK_ABY576_001_000_G120D");
        ECL_DeactivateAllAttributeValues("TAK_ABY576_001_000_G120D");
        
        for (var i = 0; i < aResult.length; i++)
        {
            if (aValidValuesCU.indexOf(aResult[i].TAK_ABY576_001_000_G120D) > -1){
                ECL_ActivateValue("TAK_ABY576_001_000_G120D", aResult[i].TAK_ABY576_001_000_G120D);
            }
        }
    }
    else{
        //Fehler
    }
    
    var aAttributesVT02 = [ "TAK_ABY576_001_000_G120D",
                            "PMD_ABU804_001_000_G120D",
                            "HMK_PUSH_PULL_1003365",
                            "HMK_VALUE_VALID_G120D"];
    
    setValuesFromDatabase("VT_G120D_M00002_26341", "HMK_PUSH_PULL_1003365", aAttributesVT02);
    
    // CU - Default setzen
    if (sMotionControl == "1")
    {
        ExecSetStandardifValueEmpty("TAK_ABY576_001_000_G120D", "00012");
    }
    else
    {
        ExecSetStandardifValueEmpty("TAK_ABY576_001_000_G120D", "00009");
    }
    /**
    Wenn EPOS, dann CU 11, 12, 13, 16 (was soll default sein???)
    Control Units	Positionierfunktionalitt
    TAK_ABY576_001_000_G120D	HMK_EPOS_G120D
    00007						F
    00008	F
    00009	F
    00010	F
    00011						T
    00012						T
    00013						T
    00014	F
    00015	F
    00016						T

    */
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // ControlUnit abfragen
    var sCU = ECL_GetValue("TAK_ABY576_001_000_G120D");
    if (sCU != "")
    {
        var sSQL = "SELECT * FROM VT_G120D_M00002_26341 WHERE TAK_ABY576_001_000_G120D = '" + sCU  + "' AND HMK_VALUE_VALID_G120D = 'T';";
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length > 0)
        {
            var sHMK_MLFB_CU_G120D = aResult[0].HMK_MLFB_CU_G120D; // aus VT_G120D_M00002_26341 mit TAK_ABY576_001_000_G120D
            
            sECSI_MLFB_SEC = sHMK_MLFB_CU_G120D; 
            
            ECL_SetValue("ECSI_CC_ControlUnit", sHMK_MLFB_CU_G120D);
        }
        else
        {
            //Fehler, MLFB fr CU nicht bestimmt
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___CU_MLFB_G120D") + " "; // "MLFB fr CU nicht bestimmt, kein Treffer in DB. ";
        }
    }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Positionierfunktionalitt
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // aus VT_G120D_M00007_26341
        // NUR Info, d.h. keine Rckwrtseinschrnkung der CU
    var aAttributesVT07 = [ "TAK_ABY576_001_000_G120D"]; // ACHTUNG: Kein HMK_VALUE_VALID_G120D-Attribut!
    
    
    setValuesFromDatabase("VT_G120D_M00007_26341", "HMK_EPOS_G120D", aAttributesVT07);
    

    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Steckverbinder LWL: VT_G120D_M00021_26341
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // CU gegeben -> LWL T/F
    var aAttributesVT21 = [ "TAK_ABY576_001_000_G120D",
                            "HMK_VALUE_VALID_G120D"];
    
    setValuesFromDatabase("VT_G120D_M00021_26341", "HMK_PUSH_PULL_LWL_G120D", aAttributesVT21);    
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Safety 
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // aus VT_G120D_M00004_26341
    var aAttributesVT04 = [ "TAK_ABY576_001_000_G120D",
                            "HMK_VALUE_VALID_G120D"];
    
    setValuesFromDatabase("VT_G120D_M00004_26341", "HMK_SAFETY_LVL_3_G120D", aAttributesVT04);
    

    // ##################################################################################################################
    // Zubehr:
    // ##################################################################################################################
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // IOP Handheld
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    if (ECL_GetValue("HMK_IOP_HANDHELD_G120D") == "T")
    {
        var sMLFB_G120D_HMK_IOP_HANDHELD = "6SL32550AA004HA1";
        
        sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_G120D_HMK_IOP_HANDHELD; 
    }

     // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // DriveSim Designer
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    if (ECL_GetValue("HMK_DRIVESIM_DESIGNER_G120D") == "T")
        {
            var sMLFB_G120D_DRIVE_SIM_DESIGNER = "9SV11103AA000AA0";
            
            sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_G120D_DRIVE_SIM_DESIGNER; 
        }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Speicherkarte
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Speicherkarte VT_G120D_M00023_26341
    // 00001 'ohne'             in DB: zwei MLFBs angegeben ????
    // 00234 'leer'             6SL30544AG002AA0
    // 00235 'mit Firmware'     6SL30547TE002BA0 oder 6SL30547EH002BA0????
    // laut TIA gilt die Angabe im Code
    
    var actualMemoryCardSelection = ECL_GetValue("HMK_MEMORYCARD_G120D");

    if (actualMemoryCardSelection == "00234") //"Leer" ('00234')
    {
        ECL_DeactivateAttribute("HMK_FIRMWARE_G120D");
        var sMLFB_G120D_HMK_MEMORYCARD = "6SL30544AG002AA0";
    }
    else if (actualMemoryCardSelection == "00235") // Mit Firmware ('00235')
    {
        ECL_ActivateAttribute("HMK_FIRMWARE_G120D");
        
        if (ECL_GetValue("HMK_FIRMWARE_G120D") === "") 
            ECL_SelectValue("HMK_FIRMWARE_G120D", getLatestFirmwareVersion());

        //var sMLFB_G120D_HMK_MEMORYCARD = "6SL30547TE002BA0"; // <-- aus SourceCode vs. aus DB: 6SL30547EH002BA0
        //var sMLFB_G120D_HMK_MEMORYCARD = "6SL30547TF002BA0"; // <-- aus SourceCode vs. aus DB: 6SL30547EH002BA0
        var sMLFB_G120D_HMK_MEMORYCARD = getFirmwareVersion();
    } else if (actualMemoryCardSelection == "00001") {
        ECL_DeactivateAttribute("HMK_FIRMWARE_G120D");
    }

    if (sMLFB_G120D_HMK_MEMORYCARD)
    {
        sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_G120D_HMK_MEMORYCARD;
    }

    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Firmware
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // VERSION_4_7_SP10_HF6         6SL30547TF002BA0
    // VERSION_4_7_SP14             6SL30547TH002BA0
    
    // laut TIA gilt die Angabe im Code

    var selectedFirmwareVersion = ECL_GetValue("HMK_FIRMWARE_G120D");
        
    if (selectedFirmwareVersion.length > 0 && selectedFirmwareVersion !== "VERSION_4_7_SP14") {
        sECSI_STATUS = "WARNING";
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + "WARNING_OUTDATED_FIRMWARE";      
    } 
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // RS232 Kabel
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    if (ECL_GetValue("HMK_RS232_KABEL_G120D") == 'T')
    {
        var sMLFB_G120D_HMK_RS232_KABEL = "3RK19222BP00";
        
        sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_G120D_HMK_RS232_KABEL;
    }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // USB Kabel
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    if (ECL_GetValue("HMK_USB_KABEL_G120D") == 'T')
    {
        var sMLFB_G120D_HMK_USB_KABEL = "6SL35550PA002AA0";
        
        sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_G120D_HMK_USB_KABEL;
    }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Starter DVD
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    if (ECL_GetValue("HMK_TOOL_STARTER_G120D") == 'T')
    {
        var sMLFB_G120D_HMK_TOOL_STARTER = "6SL30720AA000AG0";
        
        sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_G120D_HMK_TOOL_STARTER;
    }
    

    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Leistungsschalter
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    if (ECL_GetValue("HMK_LEIST_SCHALTER_G120D") == 'T')
    {
        //SQL-Abfrage
        var sSQL = "SELECT * FROM VT_G120D_M00006_26341 WHERE HMK_BEM_LEISTUNG_HO_G120D = '" + fBemessungsleistungKW + "' AND HMK_VALUE_VALID_G120D = 'T';"; 
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_G120D_L_SCHALTER = aResult[0].MLFB_L_SCHALTER_G120D; // aus VT_G120D_M00006_26341 mit HMK_BEM_LEISTUNG_HO_G120D
            
            sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_G120D_L_SCHALTER;
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___CIRCUIT_BREAKER_MLFB_G120D") + " "; // "MLFB fr 'Leistungsschalter' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Auswahl Sicherung
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    if (ECL_GetValue("PMD_AAC947_001_000_G120D") == 'T')
    {
        var sSQL = "SELECT * FROM VT_G120D_M00005_26341 WHERE HMK_BEM_LEISTUNG_HO_G120D = '" + fBemessungsleistungKW  + "' AND HMK_VALUE_VALID_G120D = 'T';"; 
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_G120D_SICHERUNG = aResult[0].HMK_MLFB_SICHERUNG_G120D; // aus VT_G120D_M00005_26341 mit HMK_BEM_LEISTUNG_HO_G120D
            
            sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_G120D_SICHERUNG + ";" + sMLFB_G120D_SICHERUNG + ";" + sMLFB_G120D_SICHERUNG;
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FUSE_MLFB_G120D") + " "; // "MLFB fr 'Sicherung' nicht bestimmt, kein Treffer in DB. ";
        }
    }
        
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // FieldbusInterface aus SIZER-bergabe en/disablen    
    // (This feature is disabled, because the communication type selection is disabled)
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // var sFieldbus = ECL_GetValue("ECSI_CX_FieldbusInterface"); 
    // if ( (ECL_GetValue("ECSI_CX_FieldbusInterface") == "" || ECL_GetValue("ECSI_CX_FieldbusInterface") == undefined) && (sFieldbus !== 0)
    // ) {
    //     ECL_EnableAttribute("PMD_ABU804_001_000_G120D");
    // }
    // else
    // {
    //     ECL_DisableAttribute("PMD_ABU804_001_000_G120D");
    // }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //Einschrnkungen wegen Anbau an Reluktanzmotor
    var strReluktanzmotor=ECL_GetValue("ECSI_CX_MotorTechnology"); 
    if(strReluktanzmotor)
    {
        var iReluktanzmotor=parseInt(strReluktanzmotor);
        if(iReluktanzmotor==2)
        {
            ECL_DeactivateValue("TAK_ABY576_001_000_G120D","00011");
            ECL_DeactivateValue("TAK_ABY576_001_000_G120D","00012");
            ECL_DeactivateValue("TAK_ABY576_001_000_G120D","00016");
            ECL_DeactivateValue("TAK_ABY576_001_000_G120D","00013");
        }
    }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //Extended service protection
    var serviceProtection = ECL_GetValue("HMK_DSEE_G120C")
    if (serviceProtection === "DSEE3") {
        if (sECSI_MLFB_SEC === "")
            sECSI_MLFB_SEC = "9MC31104SE000AL7"
        else
            sECSI_MLFB_SEC += ";9MC31104SE000AL7"
    }
    if (serviceProtection === "DSEE5") {
        if (sECSI_MLFB_SEC === "")
            sECSI_MLFB_SEC = "9MC31104SE000AN4"
        else
            sECSI_MLFB_SEC += ";9MC31104SE000AN4"
    }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Zustzliche MLFBs setzen
    SetMlfbSec(sECSI_MLFB_SEC);
    
    if ( sECSI_STATUS != "E" && sECSI_STATUS != "WARNING") {
        sECSI_STATUS = "OK";
    }
    // bergabestatus setzen
    ECL_SetValue("ECSI_STATUS", sECSI_STATUS);

    if (sECSI_STATUS_MESSAGE.includes("WARNING")) {
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sECSI_STATUS_MESSAGE));
    } else {
        ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
    }
        
        
    // CU-Attribute nur Info
    ECL_DisableAttribute("HMK_SAFETY_LVL_3_G120D");
    ECL_DisableAttribute("HMK_PUSH_PULL_1003365");
    ECL_DisableAttribute("HMK_PUSH_PULL_LWL_G120D");
    ECL_DisableAttribute("HMK_EPOS_G120D");
        
    //var DebugStop;

    //Attribute mit viewlevel 0 deactivieren
    ECL_DeactivateAttribute("HMK_VALUE_VALID_G120D");
}

// #####################################################################################################################
// ## END OF SCRIPT#####################################################################################################
// #####################################################################################################################

function ExecSetStandardifValueEmpty(Attribute, strDefault)
{
    var strValue = ECL_GetValue(Attribute);
    if(strValue == "")
    {
        if(ECL_ValueActive(Attribute, strDefault))
        {
            ECL_SelectValue(Attribute, strDefault);
            return true;
        }
        else
        {
            var aselection = ECL_GetAllActiveAttributeValues(Attribute);
            if(aselection.length > 0 )
            {
                ECL_SelectValue(Attribute, aselection[0]);
                return true;
            }
        }
    }
    else
    {
        var aselection = ECL_GetAllActiveAttributeValues(Attribute);
        
        if(aselection.length > 0)
        {
            for(var i=0;i<aselection.length;i++)
            {	
                if(strValue == aselection[i])
                    return true;
            }
        }
        
        if(ECL_ValueActive(Attribute, strDefault))
        {
            ECL_SelectValue(Attribute, strDefault);
            return true;
        }
        else
        {
            var aselection = ECL_GetAllActiveAttributeValues(Attribute);
            if(aselection.length > 0)
            {
                ECL_SelectValue(Attribute, aselection[0]);
                return true;
            }
        }
        
    }
}

/**
 * Die function erstellt eine Query für die Datenbank
 * @param {*} DBtable                   Der name der tabelle der Datenbank
 * @param {*} sTargetAttribute          Zielattribut deren Werte aktiviert und deactiviert werden sollen
 * @param {*} whereClauselAttributes    Liste von Attributen die in der WhereClausel vorkommen
 */
function buildQuery(DBtable, sTargetAttribute, whereClauselAttributes){

    var first = true; 
    var query = "SELECT " + sTargetAttribute+" FROM " + DBtable;

    for(var i = 0; i< whereClauselAttributes.length; i++){

        var value = ECL_GetValue(whereClauselAttributes[i]);
        
        if(value !=""){
            if(first == true){
                query += " WHERE " + whereClauselAttributes[i]+ " = '" + value+"'";
                first = false;
            }
            else{
                query += " AND " + whereClauselAttributes[i]+ " = '" + value+"'";
            }
        }

        else{
            return ""     
        }
    }
    query += " GROUP BY " + sTargetAttribute;

    return query;
}

/**
 * Die Function aktiviert und deactiviert Werte eines Attributes
 * @param {*} sTargetAttribute  Zielattribute deren Werte aktiviert/deactiviert werden sollen
 * @param {*} DBresult          Liste der Datenbank ergebnisse 
 */
function setAttributeValues(sTargetAttribute, DBresult){
    
    ECL_DeactivateAllAttributeValues(sTargetAttribute);

    for(var i = 0; i < DBresult.length; i++){
    
        ECL_ActivateValue(sTargetAttribute, Object.values(DBresult[i])[0]);
    
    }

    if(DBresult.length ==1){
        ECL_SelectValue(sTargetAttribute, Object.values(DBresult[0])[0]);
    }
}
/**
 * Die function ruft weitere functionen auf, die eine Query bilden, Daten aus der Datenbank holen und damit
 * die Werte passend aktiviert und deactiviert
 * @param {*} DBtable                   Der name der tabelle der Datenbank
 * @param {*} sTargetAttribute          Zielattribut deren Werte aktiviert und deactiviert werden sollen
 * @param {*} whereClauselAttributes    Liste von Attributen die in der WhereClausel vorkommen
 * 
 * @return 0 oder 1 je nach dem ob erfolgreich oder fehler
 */
function setValuesFromDatabase(DBtable, sTargetAttribute, whereClauselAttributes){

    var query = buildQuery(DBtable, sTargetAttribute, whereClauselAttributes)
    
    if(query ==""){
        return false;
    }
    var result = Object.fromDatabase("EXTERNAL_DATA", query);
    
    setAttributeValues(sTargetAttribute, result);

    return true;
}

function getFirmwareVersion() {
    var selectedFirmware = ECL_GetValue("HMK_FIRMWARE_G120D");
    var sQuery = "select MLFB from FIRMWARE where VERSION = ?";
    var version = [processVersion(selectedFirmware)];

    var aDbResult = Object.fromDatabase("G120D_FIRMWARE", sQuery, version);

    return aDbResult[0].MLFB;
}

function getLatestFirmwareVersion() {
    var sQuery = "select VERSION from FIRMWARE where NEWEST is 'true'";
    var aDbResult = Object.fromDatabase("G120D_FIRMWARE", sQuery);

    return processVersion(aDbResult[0].VERSION);
}

function processVersion(version) {
    if (version.includes("_")) {
        return processVersionFromUI(version);
    } else {
        return processVersionFromDB(version);
    }
}

function processVersionFromDB(versionFromDB) {
    var result = versionFromDB.replace(".", "_");
    result = result.replace(" ", "_");
    result = "VERSION_" + result.substr(1);

    return result;
}

function processVersionFromUI(versionFromUI) {
    var result = versionFromUI.split("VERSION_")[1];
    result = "V" + result;
    
    parts = result.split("_");
    result1 = "";
    for(var i = 0; i < parts.length; i++) {
        result1 += parts[i];
        
        if (i==0) {
            result1 += ".";
        } else {
            result1 += " ";
        }
    }

    return result1.trim();
}