//@legacy
// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_120X
// 	Date: 2021-05-04
// 	User: Administrator
// ---------------------------------------------------------

// include easyKAT Configuration Library
//@import "SIZER_general_functions.js"

//#mode(full-ecma)


globalThis.OnChangeConfiguration = function main()
{
    
    SetAttributesFromMlfb();
    
    var sECSI_MLFB					= "";		// Parameter fr Basis-MLFB
    var sECSI_MLFB_SEC				= "";		// Parameter fr zustzliche MLFBs
    
    var sECSI_STATUS 				= "";		// Status fr MLFB-bergabe
    var sECSI_STATUS_MESSAGE 		= "";		// Statusmeldung fr MLFB-bergabe
    
    var sVoltageClass 				= "";		// Voltage class aus MLFB
    var sPowerRange1 				= "";		// Leistungsparameter aus MLFB
    var sPowerRange2 				= "";		// Leistungsparameter aus MLFB
    var sLeistung 					= "";		// Gesamtwert (String)
    var sMLFB_Key					= "";
    
    var sFilter						= "";		// Filter aus MLFB14
    var sFilterParam				= ""; 		// Filterparameter ( A, C, ungefiltert)
    var sBedienpanel				= "";
    var sBus						= "";		// Bussystem aus MLFB15 (B, F) // G120X nur F
    var sBusParam					= ""; 		// Bussystemparameter (00001 (B), 00002 (F))
    
    var sCurrentAttribute = ECL_GetCurrentAttribute() || "";

    // Dummy Aufrufe von SIZER unterdrcken
    if (sCurrentAttribute == '')
        return;
    
    if(sCurrentAttribute.left(7) == "ECSI_CX")
        return;
    
    
    // ##############################################################################################
    // INIT
    // ##############################################################################################
    if(sCurrentAttribute === "@INIT@")
    {
        ECL_DeactivateAttribute("HMK_PRODUKT_TRIG_G120X"); //  
        ECL_DeactivateAttribute("HMK_VALUE_VALID_G120X"); //
        ECL_DeactivateAttribute("HMK_MLFB_KEY_G120X"); // 
        ECL_DeactivateAttribute("MLFB06_G120X"); // 
        ECL_DeactivateAttribute("MLFB07_G120X"); // 
        ECL_DeactivateAttribute("MLFB08_G120X"); // 
        ECL_DeactivateAttribute("MLFB10_G120X"); // 
        ECL_DeactivateAttribute("MLFB11_G120X"); // 
        ECL_DeactivateAttribute("MLFB12_G120X"); // 
        ECL_DeactivateAttribute("HMK_MLFB_11_12_G120X"); // 
        ECL_DeactivateAttribute("MLFB13_G120X"); // 
        ECL_DeactivateAttribute("MLFB14_G120X"); // 
        ECL_DeactivateAttribute("MLFB15_G120X"); // 
        ECL_DeactivateAttribute("PMD_ABJ176_001_000_G120X"); // IP-Schutzklasse
        ECL_DeactivateAttribute("PMD_ABW171_001_000_G120X"); // Bauform
        
        ECL_DeactivateAttribute("HMK_UEBERLAST_G120X"); // 

        ECL_DeactivateAttribute("HMK_ANZ_LINE_HARMONI_G120X"); // 
        ECL_DeactivateAttribute("HMK_ANZ_SICHERUNG_G120X"); // 
        ECL_DeactivateAttribute("MESSAGE_SMARTACCESS_G120X");
        ECL_DeactivateAttribute("MESSAGE_HANDHELD1_G120X");
        ECL_DeactivateAttribute("MESSAGE_HANDHELD2_G120X");
        
        // SIPLUS entfernt Jan 2020 DTK-DB Stand 19047
        ECL_DeactivateAttribute("HMK_IOP2_SIPLUS_G120X");
        ECL_DeactivateAttribute("MESSAGE_IOP2_SIPLUS_G120X");
        
        setCheckBoxAttributes();
        
        return; 	// nach Init direkt return, denn ein separater Aufruf mit MLFB folgt ja noch 
    }
    // ##############################################################################################
    
    sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
    var sECSI_MLFB_BASE_TYPE = ECL_GetValue("ECSI_MLFB_BASE_TYPE") || "";
    if (sECSI_MLFB == "")
        return;
    
    var ECSI_IS_START_CONFIGURATION = parseInt(ECL_GetValue("ECSI_IS_START_CONFIGURATION"));
    
    var sECSI_CX_SafetyFunctions 	 	= ECL_GetValue("ECSI_CX_SafetyFunctions");
    var bMeldungSTO = false;
    // bei "STO" eine Meldung generieren
    if (sECSI_CX_SafetyFunctions != ""){
        var aSafetyFunctionsSizer = sECSI_CX_SafetyFunctions.split(";");
        // sortieren
        aSafetyFunctionsSizer = aSafetyFunctionsSizer.sort();
        
        for (var i = 0; i < aSafetyFunctionsSizer.length; i++){
            
            if (aSafetyFunctionsSizer[i] == "0"){
                bMeldungSTO = true;
                break;
            }
        }
    }
    if (bMeldungSTO){
        ECL_ActivateAttribute("INFO_STO_G120X");
    }else{
        ECL_DeactivateAttribute("INFO_STO_G120X");
    }
    /*if (ECSI_IS_START_CONFIGURATION != 1)
    {
        var sStatus = checkContextValues();
    }
    if (sStatus != ""){
        ECL_SelectValue ("ECSI_STATUS", "E");
        ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(sStatus));
        return;
    }*/
    
    // ##############################################################################################
    // Portfolio-SelectionChange abfangen
    // ##############################################################################################
    // mit Line Harmonics filter gegenprfen!!!
    // StandardSupplySystem
    var iVoltage = parseInt(ECL_GetValue("ECSI_CX_StandardSupplySystem"));
    sVoltageClass = sECSI_MLFB_BASE_TYPE.charAt(9); 	// wenn E: 380-480V | wenn H: 500-690V	| C: 200...240V	// 
    if ( (sVoltageClass == "E" && (iVoltage == 5 || iVoltage == 6 || iVoltage == 14 || iVoltage == 15)) || 
        (sVoltageClass == "C" && !(iVoltage == 1 || iVoltage == 8 )) ||
        (sVoltageClass == "H" && (iVoltage == 2 || iVoltage == 3 || iVoltage == 4 || iVoltage == 9 || iVoltage == 10 || iVoltage == 11 || iVoltage == 12 || iVoltage == 13 || iVoltage == 18))
    ) {
        //Fehler, vorgegebene Spannung passt nicht zur MLFB
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___STANDARDSUPPLYSYSTEM_NOT_MATCH_G120X") + " ";
        ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
        ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
        return;
    }
    
    sECSI_MLFB_SEC = GetMlfbSec() || "";
    if (sECSI_MLFB_SEC !== "") 
    {
        var sSQL = "SELECT DISTINCT HMK_MLFB_LINE_HARMON_G120X FROM VT_G120X_M00114_26587 WHERE " +
                    "HMK_LINE_HARMONICS_G120X = 'T' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
                    
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00114_26587_Portfolio");
        if (aResult.length > 0)
        {
            var sStatus = "ohne";
            for (var i = 0; i < aResult.length; i++)
            {
                if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_LINE_HARMON_G120X) >= 0)
                {
                    var sStatus = "mit";
                }
            }
            if (sStatus == "mit")
            {
                // Prfen, ob Vorgaben zu Spannung passen:
                if (iVoltage != 2 && iVoltage != 3 && iVoltage != 4)
                {
                    // Fehler: Spannung passt nicht zu gewhltem Line harmonics filter
                    sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___STANDARDSUPPLYSYSTEM_CHANGE_G120X") + " ";
                    ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
                    ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                    return;
                }
            }
        }		
    }
    // ##############################################################################################
    
    
    // Netzdrossel-Default 
    if (ECSI_IS_START_CONFIGURATION == 1 && sECSI_MLFB.charAt(14) == "." && sECSI_MLFB_SEC == "") {
        ECL_SelectValue("HMK_NETZDROSSEL_G120X", "T");
    }
    
    // #####################################################################################################################################
    // MLFB-PARSER
    // #####################################################################################################################################
    
    if (sCurrentAttribute == "ECSI_MLFB")
    {
        // Allgemeine Normierung und Prfung
        sECSI_MLFB = sECSI_MLFB.replace(/\s+/g, ""); 			// Leerzeichen entfernen
        sECSI_MLFB = sECSI_MLFB.replace("-", ""); 				// Bindestriche entfernen
        sECSI_MLFB= sECSI_MLFB.replace("?", ".").toUpperCase(); // Fragezeichen ersetzen
        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
        
        // Prfen, ob die Zeichenkette 16 Stellen hat
        if (sECSI_MLFB.length != 16)
        {
            // bergabefehler abfangen
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MLFB_FAILURE_G120X") + " "; //"MLFB zu kurz oder zu lang, ggf. unvollstndig. ";
        }
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        /*
        MLFB-Struktur G120X
        0000000 00111 1111
        1234567 89012 3456
        6SL32x0-xYxxx-xxx.
             || | ||| ||| - 0-without/ 6-with DCP/DCN 
             || | ||| ||| 15 Bussystem 
             || | ||| || -F Default und nur G120X
             || | ||| || -B 
             || | ||| || -P 
             || | ||| || 14 EMC-Class
             || | ||| | -U ungefiltert
             || | ||| | -A Filter C2
             || | ||| | -C Filter C3
             || | ||| | 13 I/O Extension
             || | |||  - 0 ohne
             || | |||  - 1 mit
             || | ||| 11 - 12 Power Range
             || | |  -10 ... 68 (0,75 - 630 kW)
             || | | 10 Voltage Class
             || |  -E 380-480V
             || |  -H 500-690V
             || |  -D 380-440V
             || | 08 User Interface
             ||  -1 ohne
             ||  -2 BOP-2
             ||  -3 IOP-2
             || 07 Protection Class
             | -0 IP20
             | -5 IP00
             | 06 Board Coating Type
              -2 Standard 3C2
              -3 3C3 coating
        */
        
        // NEU: 6. MLFB-Stelle "." Default = 2 und wenn '.', dann whlbar
        if (sECSI_MLFB.indexOf("6SL3220") < 0 && sECSI_MLFB.indexOf("6SL3230") < 0 && sECSI_MLFB.indexOf("6SL32.0") < 0 )
        {
            // Falsches Produkt
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_PRODUCT_G120X") + " "; //"Falsches Produkt bergeben. Nicht G120X. ";
        }
        
        
        //#########################################################################################################################
        // Keep Configuration
        //#########################################################################################################################
        var sECSI_MLFB_fix = sECSI_MLFB;
        
        // Umgebungsbedingungen
        if (sECSI_MLFB_BASE_TYPE.charAt(5) == "."){
            sECSI_MLFB_fix = replaceAt(sECSI_MLFB_fix, 5, ".");
        }
        // Bedienpanel = sECSI_MLFB.charAt(7); // MLFB08 
        if (sECSI_MLFB_BASE_TYPE.charAt(7) == "."){
            sECSI_MLFB_fix = replaceAt(sECSI_MLFB_fix, 7, ".");
        }
        
        // IO_EXT = sECSI_MLFB.charAt(12); //MLFB13
        if (sECSI_MLFB_BASE_TYPE.charAt(12) == "."){
            sECSI_MLFB_fix = replaceAt(sECSI_MLFB_fix, 12, ".");
        }
        // Filter
        if (sECSI_MLFB_BASE_TYPE.charAt(13) == "."){
            sECSI_MLFB_fix = replaceAt(sECSI_MLFB_fix, 13, ".");
        }
        // Bus
        if (sECSI_MLFB_BASE_TYPE.charAt(14) == "."){
            sECSI_MLFB_fix = replaceAt(sECSI_MLFB_fix, 14, ".");
        }
        // DCP/DCN
        if (sECSI_MLFB_BASE_TYPE.charAt(15) == "."){
            sECSI_MLFB_fix = replaceAt(sECSI_MLFB_fix, 15, ".");
        }
        
        var bKeepConf = false;
        
        if( (sECSI_MLFB_BASE_TYPE!=sECSI_MLFB_fix) && find(sECSI_MLFB.left(16), ".") < 0 && sECSI_MLFB_BASE_TYPE != "")
        {
            //bKeepConf = true;
            
            if (sECSI_MLFB_BASE_TYPE.charAt(5) == "."){
                var sUmgebungKC = sECSI_MLFB.charAt(5);
                bKeepConf = true;
            }
            
            if (sECSI_MLFB_BASE_TYPE.charAt(7) == "."){
                var sBedienpanelKC = sECSI_MLFB.charAt(7);
                bKeepConf = true;
            }
            
            if (sECSI_MLFB_BASE_TYPE.charAt(12) == "."){
                var sIO_ExtKC = sECSI_MLFB.charAt(12);
                bKeepConf = true;
            }
            
            if (sECSI_MLFB_BASE_TYPE.charAt(13) == "."){
                var sFilterKC = sECSI_MLFB.charAt(13);
                bKeepConf = true;
            }
            if (sECSI_MLFB_BASE_TYPE.charAt(14) == "."){
                var sBusKC = sECSI_MLFB.charAt(14);
                bKeepConf = true;
            }
            if (sECSI_MLFB_BASE_TYPE.charAt(15) == "."){
                var sDCP_KC = sECSI_MLFB.charAt(15);
                bKeepConf = true;
            }
            sECSI_MLFB = sECSI_MLFB_BASE_TYPE;
            ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
        }
        //#########################################################################################################################
        
        
        
        // Leistungsdaten herauslesen MLFB10 - Voltage Class
        sVoltageClass = sECSI_MLFB.charAt(9); 	// wenn E: 380-480V | wenn H: 500-690V | C: 200...240V
        var aValidValues1 = ["C", "E", "H"]; 		// Edit 2021_04_20 "C" freigeschaltet
        if (aValidValues1.indexOf(sVoltageClass) < 0)
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___VOLTAGECLASS_OUTOFRANGE_G120X") + " ";//"Angabe fr den Spannungsbereich in Basis-MLFB nicht im zulssigen Bereich. ";
        }
        else
        {
            ECL_SelectValue("MLFB10_G120X", sVoltageClass);
        }
        ECL_ActivateAllAttributeValues("HMK_DSA_G120X");
        // StandardSupplySystem
        /*	0	230V 1-phase AC, 50Hz nicht G120X	
            1	230V 3-phase AC, 50Hz doch erlaubt?	Edit 2021_04_20 freigeschaltet
            2	380V 3-phase AC, 50Hz	Class E Line harmonics filter possible
            3	400V 3-phase AC, 50Hz	Class E Line harmonics filter possible
            4	415V 3-phase AC, 50Hz	Class E Line harmonics filter possible
            5	500V 3-phase AC, 50Hz	Class H no Line harmonics filter
            6	690V 3-phase AC, 50Hz	Class H no Line harmonics filter
            7	240V 1-phase AC, 60Hz 	nicht G120X	
            8	240V 3-phase AC, 60Hz 	Class C	no Line harmonics filter
            9	380V 3-phase AC, 60Hz	Class E no Line harmonics filter
            10	400V 3-phase AC, 60Hz	Class E no Line harmonics filter
            11	440V 3-phase AC, 60Hz	Class E no Line harmonics filter
            12	460V 3-phase AC, 60Hz	Class E no Line harmonics filter
            13	480V 3-phase AC, 60Hz	Class E no Line harmonics filter
            14	600V 3-phase AC, 60Hz	Class H no Line harmonics filter
            15	690V 3-phase AC, 60Hz 	Class H no Line harmonics filter
        */
        var iVoltage = parseInt(ECL_GetValue("ECSI_CX_StandardSupplySystem"));
        if (iVoltage == 0 || iVoltage == 7)
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___VOLTAGE_STD_SUP_SYS_OUTOFRANGE_G120X") + " ";
        }
        else
        {
            if (((iVoltage == 5 || iVoltage == 6 || iVoltage == 14 || iVoltage == 15) && sVoltageClass != "H") || 
                ((iVoltage == 1 || iVoltage == 8) && sVoltageClass != "C") ||
                ((iVoltage == 2 || iVoltage == 3 || iVoltage == 4 || iVoltage == 9 || iVoltage == 10 || iVoltage == 11 || iVoltage == 12 || iVoltage == 13) && sVoltageClass != "E")  )
            {
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___VOLTAGECLASS_STD_SUP_SYS_G120X") + " ";
                // return;
            }
            
            switch(iVoltage)
            {
                case 1:	// Edit 2021_04_20 freigeschaltet
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 230);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "50");
                    ECL_DeactivateValue("HMK_DSA_G120X", "FUND");
					ECL_DeactivateValue("HMK_DSA_G120X", "EXT");
					ECL_SelectValue("HMK_DSA_G120X","OHNE");
                    break;
                case 2:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 380);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "50");
                    break;
                case 3:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 400);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "50");
                    break;
                case 4:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 415);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "50");
                    break;
                case 5:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 500);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "50");
                    break;
                case 6:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 690);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "50");
                    break;
                case 8:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 240);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "60");
                    ECL_DeactivateValue("HMK_DSA_G120X", "FUND");
					ECL_DeactivateValue("HMK_DSA_G120X", "EXT");
					ECL_SelectValue("HMK_DSA_G120X","OHNE");
                    break;
                case 9:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 380);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "60");
                    break;
                case 10:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 400);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "60");
                    break;
                case 11:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 440);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "60");
                    break;
                case 12:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 460);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "60");
                    break;
                case 13:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 480);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "60");
                    break;
                case 14:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 600);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "60");
                    break;
                case 15:
                    ECL_SelectValue("HMK_NETZSPANNUNG_G120X", 690);
                    ECL_SelectValue("HMK_NETZFREQUENZ_G120X", "60");
                    break;
            }
        }
        
        // Leistungsdaten herauslesen MLFB11 - PowerRange 1
        sPowerRange1 = sECSI_MLFB.charAt(10); //MLFB11
        var aValidValues2 = ["1", "2", "3", "4", "5", "6"]; //
        if (aValidValues2.indexOf(sPowerRange1) < 0)
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___POWERRANGE_VALUE_1_OUTOFRANGE_G120X") + " '" + sPowerRange1 + "' ";
        }
        else
        {
            ECL_SelectValue("MLFB11_G120X", sPowerRange1);
        }
        // Leistungsdaten herauslesen MLFB12 - PowerRange 2
        sPowerRange2 = sECSI_MLFB.charAt(11); //MLFB12
        var aValidValues3 = ["0", "2", "4", "6", "8"]; 
        if (aValidValues3.indexOf(sPowerRange2) < 0)
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___POWERRANGE_VALUE_2_OUTOFRANGE_G120X") + " '" + sPowerRange2 + "' ";
        }
        else
        {
            ECL_SelectValue("MLFB12_G120X", sPowerRange2);
        }
        // Zusammenfassung aus 11 und 12 (alternativ aus VT_G120X_M00003_26587, VT-Lsung nur mit expliziter Werteliste und nicht Edit-Feld)
        // MLFB11_G120X		MLFB12_G120X	HMK_MLFB_11_12_G120X	HMK_VALUE_VALID_G120X
        ECL_SetValue("HMK_MLFB_11_12_G120X", '' + sPowerRange1 + sPowerRange2);
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // IO-Extension MLFB13
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        sIO_EXT = sECSI_MLFB.charAt(12); //MLFB13
        if (sIO_EXT !== "0" && sIO_EXT !== "1" && sIO_EXT != ".")
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___IO_EXTENSION_OUTOFRANGE_G120X") + " ";
        }
        if (sIO_EXT == ".")
        {
            if (sIO_ExtKC){
                // Keep Configuration
                sECSI_MLFB = replaceAt(sECSI_MLFB, 12, sIO_ExtKC);
                ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                if (sIO_ExtKC == "1"){
                    ECL_SetValue("HMK_IO_EXT_G120X", "T");
                }else{
                    ECL_SetValue("HMK_IO_EXT_G120X", "F");
                }
            }else{
                sECSI_MLFB = replaceAt(sECSI_MLFB, 12, "0");
                ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                ECL_SetValue("HMK_IO_EXT_G120X", "F");
            }
        }else if (sIO_EXT == "0"){
            ECL_SetValue("HMK_IO_EXT_G120X", "F");
        }else if (sIO_EXT == "1"){
            ECL_SetValue("HMK_IO_EXT_G120X", "T");
        }
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Umgebungsbedingungen herauslesen VT_G120X_M00007_26587
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        /*
        Segment Merkmal MLFB06_G120X	Standard /.../Lackierung
        MLFB06_G120X	HMK_UMGEBUNGSBED_G120X
        2				C2   
        3				C3   
        */
        
        //var aValidValues06 = [".", "2", "3"]; // 
        if (sECSI_MLFB.charAt(5) == ".") 
        {
            // in VT 00008 prfen, ob fr die Leistung beide erlaubt sind
            // VT_G120X_M00008
            // MLFB06_G120X	HMK_MLFB_11_12_G120X	HMK_VALUE_VALID_G120X
            
            var HMK_MLFB_11_12_G120X = ECL_GetValue("HMK_MLFB_11_12_G120X");
            var sSQL = "SELECT DISTINCT MLFB06_G120X FROM VT_G120X_M00008_26587 WHERE " +
                    "HMK_MLFB_11_12_G120X = '" + HMK_MLFB_11_12_G120X + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00008_26587_Default");
            if (aResult.length > 0){
                ECL_DeactivateAllAttributeValues("MLFB06_G120X");
                ECL_DeactivateAllAttributeValues("HMK_UMGEBUNGSBED_G120X");
                for (var i = 0; i < aResult.length; i++){
                    ECL_ActivateValue("MLFB06_G120X", aResult[i].MLFB06_G120X);
                    ECL_ActivateValue("HMK_UMGEBUNGSBED_G120X", "C" + aResult[i].MLFB06_G120X);
                    
                    // Keep Configuration
                    if (sUmgebungKC && sUmgebungKC == aResult[i].MLFB06_G120X){
                        sECSI_MLFB = replaceAt(sECSI_MLFB, 5, sUmgebungKC);
                        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                        ECL_SetValue("MLFB06_G120X", sUmgebungKC);
                    }
                }
            }
            
            ExecSetStandardifValueEmpty("MLFB06_G120X", "2");
            var MLFB06_G120X = ECL_GetValue("MLFB06_G120X");
            sECSI_MLFB = replaceAt(sECSI_MLFB, 5, MLFB06_G120X);
            ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
            
        }
        
        var sUmgebung = sECSI_MLFB.charAt(5); // MLFB06
        
        if (sUmgebung == "2") 
        {
            ECL_SetValue("MLFB06_G120X", "2");
            ECL_SetValue("HMK_UMGEBUNGSBED_G120X", "C2");
        }
        else if (sUmgebung == "3") 
        {
            ECL_SetValue("MLFB06_G120X", "3");
            ECL_SetValue("HMK_UMGEBUNGSBED_G120X", "C3");
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___UMGEBUNG_MLFB_OUTOFRANGE_G120X") + " "; //
        }
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Schutzklasse herauslesen  VT_G120X_M00001_26587
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        /*															nicht in VT:
        Segment Merkmal MLFB07_G120X	Schutzart IP				Schutzart IP
        MLFB07_G120X					PMD_ABJ176_001_000_G120X	HMK_SCHUTZART_G120X
        0								Z0043						00001				IP20 / UL open type
        5								Z0001						00002				IP00
        */
        var sIP = sECSI_MLFB.charAt(6); // MLFB07
        //var aValidValues06 = ["0", "5"]; // 
        if (sIP == "0") 
        {
            ECL_SetValue("MLFB07_G120X", "0");
            ECL_SetValue("PMD_ABJ176_001_000_G120X", "Z0043");
            ECL_SetValue("HMK_SCHUTZART_G120X", "00001");
        }
        else if (sIP == "5") 
        {
            ECL_SetValue("MLFB06_G120X", "5");
            ECL_SetValue("PMD_ABJ176_001_000_G120X", "Z0001");
            ECL_SetValue("HMK_SCHUTZART_G120X", "00002");
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SCHUTZKLASSE_MLFB_OUTOFRANGE_G120X") + " "; //"Merkmal in MLFB fr Filter nicht im zulssigen Bereich. ";
        }
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        // ##########################################################################################################################
        // Umrichterdaten auswerten - Bauform, MLFB-Key
        // ##########################################################################################################################
        // VT_G120X_M00174_26587
        /*
        MLFB07_G120X	 MLFB10_G120X	MLFB- Verbund 11-12		MLFB Key			Baugre			Eintrag gltig/ungltig
        MLFB07_G120X	MLFB10_G120X	HMK_MLFB_11_12_G120X	HMK_MLFB_KEY_G120X	HMK_BAUFORM_G120X	HMK_VALUE_VALID_G120X
        */
        var sSQL = 	"SELECT * FROM VT_G120X_M00174_26587 WHERE " +
                        "MLFB07_G120X = '" 			+ ECL_GetValue("MLFB07_G120X") 			+ "' AND " +
                        "MLFB10_G120X = '" 			+ ECL_GetValue("MLFB10_G120X") 			+ "' AND " +
                        "HMK_MLFB_11_12_G120X = '"	+ ECL_GetValue("HMK_MLFB_11_12_G120X")  + "' AND " +
                        "HMK_VALUE_VALID_G120X = 'T';";
            
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00174_26587");
        if (aResult.length > 0)
        {
            ECL_SetValue("HMK_MLFB_KEY_G120X", 			aResult[0].HMK_MLFB_KEY_G120X);
            sMLFB_Key = aResult[0].HMK_MLFB_KEY_G120X;
            ECL_SetValue("HMK_BAUFORM_G120X", 			aResult[0].HMK_BAUFORM_G120X);
        }
        
        
        // ##########################################################################################################################
        
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Bedieneinheit herauslesen VT_G120X_M00004_26587
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        /*
        Segment Merkmal MLFB08_G120X	Bedieneinheit
        MLFB08_G120X	HMK_BEDIENEINHEIT_G120X
        1				00001					ohne
        2				00003					IOP-2
        3				00002					BOP-2
        */
        var sBedienpanel = sECSI_MLFB.charAt(7); // MLFB08 
        
        if (sBedienpanel == "1") // ohne/Leer
        {
            ECL_SetValue("MLFB08_G120X", "1");
            ECL_SetValue("HMK_BEDIENEINHEIT_G120X", "00001");
        }
        else if (sBedienpanel == "3") // IOP-2
        {
            ECL_SetValue("MLFB08_G120X", "3");
            ECL_SetValue("HMK_BEDIENEINHEIT_G120X", "00003");
        }
        else if (sBedienpanel == "2") // BOP-2
        {
            ECL_SetValue("MLFB08_G120X", "2");
            ECL_SetValue("HMK_BEDIENEINHEIT_G120X", "00002");
        }
        else if (sBedienpanel == ".") // Default IOP-2, auer MLFB06 == '3', dann BOP
        {
            if (sUmgebung == "3"){
                ECL_SetValue("MLFB08_G120X", "2");
                ECL_SetValue("HMK_BEDIENEINHEIT_G120X", "00002");
                sECSI_MLFB = replaceAt(sECSI_MLFB, 7, "2");
                ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
            }
            else{
                // Keep Configuration
                if (sBedienpanelKC){
                    ECL_SetValue("MLFB08_G120X", sBedienpanelKC);
                    ECL_SetValue("HMK_BEDIENEINHEIT_G120X", "0000"+ sBedienpanelKC);
                    sECSI_MLFB = replaceAt(sECSI_MLFB, 7, sBedienpanelKC);
                    ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                    
                }else{
                    
                    ECL_SetValue("MLFB08_G120X", "3");
                    ECL_SetValue("HMK_BEDIENEINHEIT_G120X", "00003");
                    sECSI_MLFB = replaceAt(sECSI_MLFB, 7, "3");
                    ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                }
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___BEDIENPANEL_MLFB_OUTOFRANGE_G120X") + " "; //"Merkmal in MLFB fr Filter nicht im zulssigen Bereich. ";
        }
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Filterdaten herauslesen
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        sFilter = sECSI_MLFB.charAt(13); // MLFB14 wenn U: ungefiltert, wenn A: Filter A (C2), C Filter C3
        var aValidValues14 = ["U", "A", "C", "."]; // ggf. aus DB-VT holen?
        if (aValidValues14.indexOf(sFilter) < 0)
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FILTER_MLFB_OUTOFRANGE_G120X") + " "; //"Merkmal in MLFB fr Filter nicht im zulssigen Bereich. ";
        }
        else
        {
            // Prfen, welche Filterklassen mglich sind
            var sSQL = "SELECT DISTINCT MLFB14_G120X FROM VT_G120X_M00103_26587 " +
                        "WHERE HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120X = 'T';"; 
            
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00103_26587");
            if (aResult.length > 0)
            {
                var bFilterU = false;
                var bFilterA = false;
                var bFilterC = false;
                ECL_DeactivateAllAttributeValues("MLFB14_G120X");
                for (var i = 0; i < aResult.length; i++)
                {
                    if (aResult[i].MLFB14_G120X == "U")
                    {
                        bFilterU = true;
                        ECL_ActivateValue("MLFB14_G120X", "U");
                    }
                    if (aResult[i].MLFB14_G120X == "A")
                    {
                        bFilterA = true;
                        ECL_ActivateValue("MLFB14_G120X", "A");
                    }
                    if (aResult[i].MLFB14_G120X == "C")
                    {
                        bFilterC = true;
                        ECL_ActivateValue("MLFB14_G120X", "C");
                    }
                }
            }else{
                // Fehler
                sECSI_STATUS = "E"; 
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_ERROR_FILTER_G120X") + " "; 
            }
            // ##############################################################################################################
            
            if (sFilter == ".") // Wenn Platzhalter, dann Default 'U' 		//durch Benutzer definieren 
            {
                if (sFilterKC){
                    if (bFilterU && sFilterKC == "U")
                    {
                        ECL_SetValue("MLFB14_G120X", "U");
                        sECSI_MLFB = replaceAt(sECSI_MLFB, 13, "U");
                        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                        ECL_SetValue("HMK_FILTERKLASSE_G120X", "00001");
                    }
                    else if (bFilterA && sFilterKC == "A")
                    {
                        ECL_SetValue("MLFB14_G120X", "A");
                        ECL_SetValue("HMK_FILTERKLASSE_G120X", "00002");
                        sECSI_MLFB = replaceAt(sECSI_MLFB, 13, "A");
                        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                    }
                    else if (bFilterC && sFilterKC == "C")
                    {
                        ECL_SetValue("MLFB14_G120X", "C");
                        ECL_SetValue("HMK_FILTERKLASSE_G120X", "00004");
                        sECSI_MLFB = replaceAt(sECSI_MLFB, 13, "C");
                        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                    }
                    else
                    {
                        // Default: U oder C
                        if (bFilterU){
                            var sDefaultFilter = "U";
                        }else{
                            if (bFilterC){
                                var sDefaultFilter = "C";
                            }
                        }
                        ExecSetStandardifValueEmpty("MLFB14_G120X", sDefaultFilter);
                        var sFilter = ECL_GetValue("MLFB14_G120X");
                        sECSI_MLFB = replaceAt(sECSI_MLFB, 13, sFilter);
                        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                        
                        switch (sFilter){
                            case "U":
                                ECL_SetValue("HMK_FILTERKLASSE_G120X", "00001");
                            break;
                            case "A":
                                ECL_SetValue("HMK_FILTERKLASSE_G120X", "00002");
                            break;
                            case "C":
                                ECL_SetValue("HMK_FILTERKLASSE_G120X", "00004");
                            break;
                        }
                    }
                    
                }else{
                    // Default: U oder C
                    if (bFilterU){
                        var sDefaultFilter = "U";
                    }else{
                        if (bFilterC){
                            var sDefaultFilter = "C";
                        }
                    }
                    ExecSetStandardifValueEmpty("MLFB14_G120X", sDefaultFilter);
                    var sFilter = ECL_GetValue("MLFB14_G120X");
                    sECSI_MLFB = replaceAt(sECSI_MLFB, 13, sFilter);
                    ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                    
                    switch (sFilter){
                        case "U":
                            ECL_SetValue("HMK_FILTERKLASSE_G120X", "00001");
                        break;
                        case "A":
                            ECL_SetValue("HMK_FILTERKLASSE_G120X", "00002");
                        break;
                        case "C":
                            ECL_SetValue("HMK_FILTERKLASSE_G120X", "00004");
                        break;
                    }
                }
            }
            else // sonst aus MLFB setzen
            {
                ECL_SelectValue("MLFB14_G120X", sFilter); // 
                if (sFilter == "A" && bFilterA)
                {
                    ECL_SetValue("HMK_FILTERKLASSE_G120X", "00002");
                }
                else if (sFilter == "C" && bFilterC)
                {
                    ECL_SetValue("HMK_FILTERKLASSE_G120X", "00004");
                }
                else if (sFilter == "U" && bFilterU)
                {
                    ECL_SetValue("HMK_FILTERKLASSE_G120X", "00001");
                }
                else
                {
                    // Fehler
                    sECSI_STATUS = "E"; 
                    sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FILTER_FROM_MLFB_NOT_POSSIBLE_G120X") + " "; 
                }
            }
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Externer Netzfilter		VT_G120X_M00049			MLFB Externer Netzfilter
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // HMK_MLFB_KEY_G120X	MLFB14_G120X	HMK_EXT_NETZFILTER_G120X	HMK_MLFB_NETZFILTER_G120X	HMK_VALUE_VALID_G120X
        var sFilter = ECL_GetValue("MLFB14_G120X");
        
        var sSQL = "SELECT * FROM VT_G120X_M00049_26587 WHERE " +
                    "MLFB14_G120X = '" + sFilter + "' AND " +
                    "(HMK_EXT_NETZFILTER_G120X = '00003' OR HMK_EXT_NETZFILTER_G120X = '00004') AND " +
                    "HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00049_26587");
        if (aResult.length > 0){
            var sStatus = "ohne";
            for (var i = 0; i < aResult.length; i++)
            {
                if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_NETZFILTER_G120X) >= 0){
                    // Unterscheidung B/C2 (00003/00004)
                    var HMK_EXT_NETZFILTER_G120X = aResult[i].HMK_EXT_NETZFILTER_G120X;
                    ECL_SelectValue("HMK_EXT_NETZFILTER_G120X", HMK_EXT_NETZFILTER_G120X);
                    var sStatus = "mit";
                }
            }
            if (sStatus == "ohne"){
                ECL_SelectValue("HMK_EXT_NETZFILTER_G120X", "00001"); // ohne
            }
        }else{
            ECL_SelectValue("HMK_EXT_NETZFILTER_G120X", "00001"); // ohne
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // UI_FILTERKLASSE_G120X bestimmen
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        var HMK_FILTERKLASSE_G120X = ECL_GetValue("HMK_FILTERKLASSE_G120X");
        var HMK_EXT_NETZFILTER_G120X = ECL_GetValue("HMK_EXT_NETZFILTER_G120X");
        
        var HMK_DEF_EXT_FILTER_G120X = "00001";
        
        var sSQL = "SELECT DISTINCT UI_FILTERKLASSE_G120X FROM VT_G120X_M00162_26587 WHERE " +
                    "HMK_FILTERKLASSE_G120X = '" + HMK_FILTERKLASSE_G120X + "' AND " +
                    "HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND " +
                    "HMK_DEF_EXT_FILTER_G120X = '" + HMK_EXT_NETZFILTER_G120X + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00162_26587_PARSE");
        if (aResult.length > 0)
        {
            var UI_FILTERKLASSE_G120X = aResult[0].UI_FILTERKLASSE_G120X;
            ECL_SetValue("UI_FILTERKLASSE_G120X", UI_FILTERKLASSE_G120X);
        }else{
            // Fehler
            ECL_SelectValue("ECSI_STATUS", "E");
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FILTER_OUTOFRANGE_G120X") + " "; 
            ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
            return;
        }
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Bussystemdaten herauslesen; hier knnen auch externe Preferences eine Rolle spielen
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        sBus = sECSI_MLFB.charAt(14); // MLFB15 (B, P, F) 
        var sFieldbusInterface = ECL_GetValue("ECSI_CX_FieldbusInterface");	
        var bFieldbusPreference = false;
        var iFieldbusInterface  = -1;
        ECL_EnableAttribute("HMK_KOMMUNIKATION_G120X");
                
        // Fehler abfangen
        var aValidValues15 = ["B", "P", "F", "."]; 
        if (aValidValues15.indexOf(sBus) < 0)
        {
            sBus = ".";
            var aECSI_MLFB = sECSI_MLFB.split('');
            aECSI_MLFB[14] = sBus;
            sECSI_MLFB = aECSI_MLFB.join('');
        }
        if (sFieldbusInterface !== "" && sFieldbusInterface !== undefined)
        {
            iFieldbusInterface = parseInt(sFieldbusInterface);
            if (iFieldbusInterface >= 0) {
                bFieldbusPreference = true;
               ECL_DisableAttribute("HMK_KOMMUNIKATION_G120X");
            }
            if (iFieldbusInterface < 0 || iFieldbusInterface == 2 || iFieldbusInterface > 3)
            {
                // Fehler: G120C kann kein AS-i oder weitere Bussysteme
                ECL_SelectValue("ECSI_STATUS", "E");
                sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___WRONG_FIELDBUS_G120X") + " "; //"Es wurden ein Feldbus vom Sizer bergeben, der vom G120C nicht untersttzt wird. ";
                ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                return;
            }
            //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        }
        
        if ((sBus == ".") && !bFieldbusPreference)
        {
            // Keep Configuration
            if (sBusKC){
                ECL_SetValue("MLFB15_G120X", sBusKC);
                switch (sBusKC){
                    case "F":
                        ECL_SetValue("HMK_KOMMUNIKATION_G120X", "00002");
                    break;
                    case "P":
                        ECL_SetValue("HMK_KOMMUNIKATION_G120X", "00003");
                    break;
                    case "B":
                        ECL_SetValue("HMK_KOMMUNIKATION_G120X", "00001");
                    break;
                }
                sECSI_MLFB = replaceAt(sECSI_MLFB, 14, sBusKC);
                ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                
            }else{
                // MLFB war noch nicht vollstndig spezifiziert und KEINE Vorgabe aus Sizer: Default Profinet setzen
                // Default auf ProfiNet
                ECL_SetValue("MLFB15_G120X", "F");
                ECL_SetValue("HMK_KOMMUNIKATION_G120X", "00002");
                sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "F");
                ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
            }
        }
        else if ((sBus == ".") && bFieldbusPreference )
        {
            // MLFB war noch nicht vollstndig spezifiziert und Vorgabe aus Sizer:
            switch (iFieldbusInterface)
            {
                case 0:
                    // 0 feste Auswahl von Profinet
                    ECL_SetValue("MLFB15_G120X", "F");
                    ECL_SetValue("HMK_KOMMUNIKATION_G120X", "00002");
                    sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "F");
                    ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                    break;
                
                case 1:
                    // 1 feste Auswahl von Profibus
                    ECL_SetValue("MLFB15_G120X", "P");
                    ECL_SetValue("HMK_KOMMUNIKATION_G120X", "00003");
                    sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "P");
                    ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                    break;
                
                case 3:
                    // 3: USS/Modbus
                    ECL_SetValue("MLFB15_G120X", "B");
                    ECL_SetValue("HMK_KOMMUNIKATION_G120X", "00001");
                    sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "B");
                    ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
                    break;
            }
            
        }
        else // (sBus !== ".")
        {
            // MLFB ist spezifiziert
            // Bus aus VT setzen
            ECL_SetValue("MLFB15_G120X", sBus);
            
            if (sBus == "F")
                ECL_SetValue("HMK_KOMMUNIKATION_G120X", "00002");
            else if (sBus == "P")
                ECL_SetValue("HMK_KOMMUNIKATION_G120X", "00003");
            else if (sBus == "B")
                ECL_SetValue("HMK_KOMMUNIKATION_G120X", "00001");
            else
                ECL_SetValue("HMK_KOMMUNIKATION_G120X", "00002");
            
            if (bFieldbusPreference)
            {
                // Prfen, ob Vorgabe zu MLFB passt
                if ( (iFieldbusInterface == 0 && sBus !== "F") ||
                     (iFieldbusInterface == 1 && sBus !== "P") ||
                     (iFieldbusInterface == 3 && sBus !== "B") 
                ) {
                    // genderter Fieldbus --> Fehler
                    sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FIELDBUS_CHANGED_G120X") + " "; 
                    // bergabestatus setzen
                    ECL_SelectValue("ECSI_STATUS", "E");
                    ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
                    return;
                }
            }
            
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // DCP/DCN
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        var MLFB16_G120X = sECSI_MLFB.charAt(15); // {".","0","6"}
        var aValidValues16 = ["0", "6", "."]; 
        if (aValidValues16.indexOf(MLFB16_G120X) < 0)
        {
            // Fehler
            ECL_SelectValue("ECSI_STATUS", "E");
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MLFB16_OUTOFRANGE_G120X") + " "; 
            ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
            return;
        }
        
        if (MLFB16_G120X == ".")
        {
            
            // Keep Configuration
            /* fr sptere Freischaltung
            if (sDCP_KC){
                switch (sDCP_KC){
                    case "0":
                        ECL_DeselectAttribute("CB_DCP_G120X");
                    break;
                    case "6":
                        ECL_SelectValue("CB_DCP_G120X", "T");
                    break;
                }
                sECSI_MLFB = replaceAt(sECSI_MLFB, 15, sDCP_KC);
                ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
            }else{
                sECSI_MLFB = replaceAt(sECSI_MLFB, 15, "0");
                ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
            }
            nachfolgende 2 Zeilen entfernen */
            sECSI_MLFB = replaceAt(sECSI_MLFB, 15, "0");
            ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
        }
        /* fr sptere Freischaltung
        else{
            if (MLFB16_G120X == "0"){
                ECL_DeselectAttribute("CB_DCP_G120X");
            }
            if (MLFB16_G120X == "6"){
                ECL_SelectValue("CB_DCP_G120X", "T");
            }
        }
        */
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
        // ##########################################################################################################################
        // Bauform-Baugre bersetzen
        // ##########################################################################################################################
        // VT_G120X_M00015_26587
        // HMK_BAUFORM_G120X	PMD_ABW171_001_000_G120X	HMK_VALUE_VALID_G120X
        //ECL_InferencePositiveValues("VT_G120X_M00015_26587", "PMD_ABW171_001_000_G120X");
        
        var sSQL = 	"SELECT * FROM VT_G120X_M00015_26587 WHERE " +
                        "HMK_BAUFORM_G120X = '" + ECL_GetValue("HMK_BAUFORM_G120X") + "' AND HMK_VALUE_VALID_G120X = 'T';";
            
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00015_26587");
        if (aResult.length > 0)
        {
            ECL_SelectValue("PMD_ABW171_001_000_G120X", aResult[0].PMD_ABW171_001_000_G120X);
        }
        // ##########################################################################################################################
        // ##########################################################################################################################
        
        
        // ##########################################################################################################################
        // Sekundre MLFBs
        // ##########################################################################################################################
        
        var sMLFB14		 	= ECL_GetValue("MLFB14_G120X");
        sMLFB_Key	 		= ECL_GetValue("HMK_MLFB_KEY_G120X");
        var sFilterIntern	= ECL_GetValue("HMK_FILTERKLASSE_G120X"); 
        
        sECSI_MLFB_SEC = GetMlfbSec() || "";
        
        
        if (sECSI_MLFB_SEC !== "") 
        {
            // bergebene MLFB_SEC parsen
            
            /* Mgliche Artikel
            Speicherkarte					ohne, leer, (mit Firmware - gibt es derzeut nicht)
            Webservermodul (Smart Access)	mit, ohne
        NEU	SINAMICS CONNECT 300 IoT Gateway
            IOP-2 Handheld
            Trmontagesatz IOP-2/BOP-2
                weg: SILPUS IOP-2
            IP21 Top Cover
            Push-Through Einbaurahmen
        NEU	SINAMICS FSG Adapter Set
            neu: DSEE
            neu: DSA
            Sicherung (Menge =3)
            Externer Netzfilter
            Line Harmonics Filter (Menge 1, 2)
            Netzdrossel
            Ausgangsdrossel
            dU/dt-Filter plus VPL
            Sinusfilter
            */
            
            // Speicherkarte
            // LEER 	6SL30544AG002AA0
            // ohne
            // FRIM gibt es derzeit nicht
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Speicherkarte			VT_G120X_M00074_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_SPEICHERKARTE_G120X	HMK_MLFB_SPEICHERK_G120X	HMK_VALUE_VALID_G120X
            
            var sSQL = 	"SELECT * FROM VT_G120X_M00074_26587 WHERE HMK_SPEICHERKARTE_G120X = 'LEER' AND HMK_VALUE_VALID_G120X = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00074_26587");
            if (aResult.length > 0)
            {
                //Speicherkarte		leer: 			6SL30544AG002AA0	 	LEER
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_SPEICHERK_G120X) >= 0)
                    {
                        // MLFB enthalten, also Attribute fr bergebene MLFBs belegen 
                        ECL_SelectValue("HMK_SPEICHERKARTE_G120X", aResult[i].HMK_SPEICHERKARTE_G120X);
                        sStatus = "mit";
                    }
                }
            }
            
            if (sStatus == "ohne")
            {
                // Ohne Speicherkarte
                ECL_SelectValue("HMK_SPEICHERKARTE_G120X", "OHNE"); // ohne
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Smart Access Modul 	VT_G120X_M00146_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_SMART_ACCESS_G120X	HMK_MLFB_SMARTACC_G120X	HMK_VALUE_VALID_G120X
            
            var sSQL = "SELECT HMK_MLFB_SMARTACC_G120X FROM VT_G120X_M00146_26587 WHERE HMK_SMART_ACCESS_G120X = 'T' AND HMK_VALUE_VALID_G120X = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "HMK_MLFB_SMARTACC_G120X");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_SMARTACC_G120X) >= 0)
                    {
                        ECL_SelectValue("HMK_SMART_ACCESS_G120X", "T");
                        sStatus = "mit";
                    }
                }
                // Ohne Webserver-Modul
                if (sStatus == "ohne")
                {
                    ECL_SelectValue("HMK_SMART_ACCESS_G120X", "F"); // ohne
                }
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // DriveSim 	VT_G120X_M00189_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_DRIVESIM_DESIGNER_G120X
            
            var sSQL = "SELECT HMK_MLFB_DRV_SIM_DES_G120X FROM VT_G120X_M00189_26587 WHERE HMK_PRODUKT_TRIG_G120X = 'G120X' AND HMK_DRV_SIM_DESIGNER_G120X = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "HMK_MLFB_SMARTACC_G120X");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_DRV_SIM_DES_G120X) >= 0)
                    {
                        ECL_SelectValue("HMK_DRIVESIM_DESIGNER_G120X", "T");
                        sStatus = "mit";
                    }
                }
                // Ohne Webserver-Modul
                if (sStatus == "ohne")
                {
                    ECL_SelectValue("HMK_DRIVESIM_DESIGNER_G120X", "F"); // ohne
                }
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // IOP-Handheld				VT_G120X_M00076_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_IOPHANDHELD_G120X	HMK_MLFB_IOPHANDHELD_G120X	HMK_VALUE_VALID_G120X
            // T    	6SL32550AA004HA1
            
            // Wenn Handheld, dann wird Bedieneinheit nicht bersteuert!!!
            if (sECSI_MLFB_SEC.indexOf("6SL32550AA004HA1") >= 0)
            {
                // Hendheld "mit"
                ECL_SelectValue("HMK_IOPHANDHELD_G120X", "T");
            }
            else
            {
                ECL_SelectValue("HMK_IOPHANDHELD_G120X", "F");
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // IOP Trmontagesatz			VT_G120X_M00075_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                /*
                HMK_TUERMONTAGE_G120X	HMK_MLFB_TUERMONTAGE_G120X	HMK_VALUE_VALID_G120X
                T				    	6SL32560AP000JA0			T    
                */
            if (sECSI_MLFB_SEC.indexOf("6SL32560AP000JA0") >= 0)
            {
                ECL_SelectValue("HMK_TUERMONTAGE_G120X", "T");
            }
            else
            {
                ECL_SelectValue("HMK_TUERMONTAGE_G120X", "F");
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
    /* DB-Update Jan 2020 SIPLUS wieder entfernt (DTK DB-Stand 19047)
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // SIPLUS IOP2				VT_G120X_M00119_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_IOP2_SIPLUS_G120X	HMK_PRODUKT_TRIG_G120X	HMK_IOP2_SIPLUS_MLFB_G120X	HMK_VALUE_VALID_G120X
            // T    					G120X                   6AG12550AA002JA2			T    
            
            // Wenn SIPLUS IOP2, dann wird Bedieneinheit nicht bersteuert!!!
            if (sECSI_MLFB_SEC.indexOf("6AG12550AA002JA2") >= 0)
            {
                // SIPLUS IOP2 "mit"
                ECL_SelectValue("HMK_IOP2_SIPLUS_G120X", "T");
            }
            else
            {
                ECL_SelectValue("HMK_IOP2_SIPLUS_G120X", "F");
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    */		
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_IP21_TOP_COVER_G120X	
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            //setProductLogicToUIAttribute("HMK_IP21_TOP_COVER_G120X", "UI_IP21_TOP_COVER_G120X", "T", "F");
            // VT_G120X_M00148_26587	MLFB IP21 Top Cover + CAD
            //	HMK_MLFB_KEY_G120X	HMK_MOTORNORM_G120X	HMK_IP21_TOP_COVER_G120X	HMK_MLFB_IP21_TC_G120X	MLFB_IP21_TC_CAD_G120X	HMK_VALUE_VALID_G120X
            var HMK_MOTORNORM_G120X = ECL_GetValue("HMK_MOTORNORM_G120X");
            
            var sSQL = "SELECT * FROM VT_G120X_M00148_26587 WHERE "+
                        "HMK_IP21_TOP_COVER_G120X = 'T' AND " + 
                        "HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND " + 
                        "HMK_MOTORNORM_G120X = '" + HMK_MOTORNORM_G120X + "' AND " + 
                        "HMK_VALUE_VALID_G120X = 'T';"; 
            var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_IP21_TC_G120X) >= 0)
                    {
                        ECL_SetValue("HMK_IP21_TOP_COVER_G120X", "T");
                        sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SetValue("HMK_IP21_TOP_COVER_G120X", "F");
                }
            }
            else
            {
                ECL_SetValue("HMK_IP21_TOP_COVER_G120X", "F");
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_PUSH_THROUGH_G120X
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            //setProductLogicToUIAttribute("HMK_PUSH_THROUGH_G120X", "UI_PUSH_THROUGH_G120X", "T", "F");
            // VT_G120X_M00147_26587	Baugre - Push Through
            //	PMD_ABW171_001_000_G120X	HMK_PUSH_THROUGH_G120X	HMK_MLFB_PUSHTHROUGH_G120X	HMK_VALUE_VALID_G120X
            
            var PMD_ABW171_001_000_G120X = ECL_GetValue("PMD_ABW171_001_000_G120X");
            
            var sSQL = "SELECT * FROM VT_G120X_M00147_26587 WHERE "+
                        "HMK_PUSH_THROUGH_G120X = 'T' AND " + 
                        "PMD_ABW171_001_000_G120X = '" + PMD_ABW171_001_000_G120X + "' AND " + 
                        "HMK_VALUE_VALID_G120X = 'T';"; 
            var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_PUSHTHROUGH_G120X) >= 0)
                    {
                        ECL_SetValue("HMK_PUSH_THROUGH_G120X", "T");
                        sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SetValue("HMK_PUSH_THROUGH_G120X", "F");
                }
            }
            else
            {
                ECL_SetValue("HMK_PUSH_THROUGH_G120X", "F");
            }
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // SINAMICS FSG Adapter Set 	VT_G120X_M00165_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_MLFB_KEY_G120X	HMK_ADAPTER_SET_G120X	HMK_MLFB_ADAPTER_SET_G120X	HMK_VALUE_VALID_G120X
            
            var sSQL = "SELECT HMK_MLFB_ADAPTER_SET_G120X FROM VT_G120X_M00165_26587 WHERE " +
                        "HMK_ADAPTER_SET_G120X = 'T' AND " +
                        "HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND " + 
                        "HMK_VALUE_VALID_G120X = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "HMK_MLFB_ADAPTER_SET_G120X");
            var sStatus = "ohne";
            
            if (aResult.length > 0){
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_ADAPTER_SET_G120X) >= 0)
                    {
                        ECL_SelectValue("HMK_ADAPTER_SET_G120X", "T");
                        sStatus = "mit";
                        break;
                    }
                }
            }
            // Ohne Adpter Set
            if (sStatus == "ohne")
            {
                ECL_SelectValue("HMK_ADAPTER_SET_G120X", "F"); // ohne
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // DSEE - Drive Service Extended Exchange		VT_G120X_M00128_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            /*
            HMK_MLFB_G120X	HMK_DSEE_G120X	HMK_MLFB_DSEE_G120X	HMK_VALUE_VALID_G120X
            */
            var sSQL = "SELECT * FROM VT_G120X_M00128_26587 WHERE HMK_MLFB_G120X = '" + sECSI_MLFB + "'  AND HMK_VALUE_VALID_G120X = 'T';";
            var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_DSEE_G120X) >= 0)
                    {
                        ECL_SetValue("HMK_DSEE_G120X", aResult[i].HMK_DSEE_G120X);
                        sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SetValue("HMK_DSEE_G120X", "OHNE");
                }
            }
            else
            {
                ECL_SetValue("HMK_DSEE_G120X", "OHNE");
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Sicherung (Menge =3)		VT_G120X_M00141_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_MLFB_KEY_G120X	HMK_SICHERUNG_G120X	HMK_MLFB_SICHERUNG_G120X	HMK_VALUE_VALID_G120X
            
            var sSQL = "SELECT * FROM VT_G120X_M00141_26587 WHERE (HMK_SICHERUNG_G120X = '00002' OR HMK_SICHERUNG_G120X = '00003') " +
                        "AND HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND HMK_VALUE_VALID_G120X = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00141_26587");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_SICHERUNG_G120X) >= 0)
                    {
                        ECL_SetValue("HMK_SICHERUNG_G120X", aResult[i].HMK_SICHERUNG_G120X);
                        
                        ECL_SetValue("HMK_ANZ_SICHERUNG_G120X", aResult[i].HMK_ANZ_SICHERUNG_G120X);
                        var sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SetValue("HMK_SICHERUNG_G120X", "00001"); // ohne
                    ECL_SetValue("HMK_ANZ_SICHERUNG_G120X", 0);
                }
            }		
            else
            {
                ECL_SetValue("HMK_SICHERUNG_G120X", "00001"); // ohne
                ECL_SetValue("HMK_ANZ_SICHERUNG_G120X", 0);
            }
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Externer Netzfilter		VT_G120X_M00049			MLFB Externer Netzfilter
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ===> verschoben nach oben zu internem Filter
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Line Harmonics Filter			VT_G120X_M00114_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_MLFB_KEY_G120X	HMK_NETZSPANNUNG_G120X	HMK_NETZFREQUENZ_G120X	HMK_LINE_HARMONICS_G120X	HMK_MLFB_LINE_HARMON_G120X	HMK_ANZ_LINE_HARMONI_G120X	HMK_VALUE_VALID_G120X
            
            var sSQL = "SELECT * FROM VT_G120X_M00114_26587 WHERE " +
                        "HMK_NETZSPANNUNG_G120X = '" + ECL_GetValue("HMK_NETZSPANNUNG_G120X") + "' AND " +
                        "HMK_NETZFREQUENZ_G120X = '" + ECL_GetValue("HMK_NETZFREQUENZ_G120X") + "' AND " +
                        "HMK_LINE_HARMONICS_G120X = 'T' AND " +
                        "HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND " +
                        "HMK_VALUE_VALID_G120X = 'T';";
                        
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00114_26587");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_LINE_HARMON_G120X) >= 0)
                    {
                        ECL_SelectValue("HMK_LINE_HARMONICS_G120X", "T");
                        ECL_SelectValue("HMK_ANZ_LINE_HARMONI_G120X", parseInt(aResult[i].HMK_ANZ_LINE_HARMONI_G120X));
                        var sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SelectValue("HMK_LINE_HARMONICS_G120X", "F"); // ohne
                    ECL_SelectValue("HMK_ANZ_LINE_HARMONI_G120X", 0); // ohne
                }
            }		
            else
            {
                ECL_SelectValue("HMK_LINE_HARMONICS_G120X", "F"); // ohne
                ECL_SelectValue("HMK_ANZ_LINE_HARMONI_G120X", 0); // ohne
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Netzdrossel			VT_G120X_M00045_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_MLFB_KEY_G120X	HMK_NETZDROSSEL_G120X	HMK_MLFB_NETZDROSSEL_G120X	HMK_VALUE_VALID_G120X
            
            var sSQL = "SELECT * FROM VT_G120X_M00045_26587 WHERE HMK_NETZDROSSEL_G120X = 'T' AND HMK_MLFB_KEY_G120X = '" + sMLFB_Key + 
                        "' AND HMK_VALUE_VALID_G120X = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00045_26587");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_NETZDROSSEL_G120X) >= 0)
                    {
                        ECL_SelectValue("HMK_NETZDROSSEL_G120X", "T");
                        var sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SelectValue("HMK_NETZDROSSEL_G120X", "F"); // ohne
                }
            }		
            else
            {
                ECL_SelectValue("HMK_NETZDROSSEL_G120X", "F"); // ohne
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Ausgangsdrossel				VT_G120X_M00051_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_MLFB_KEY_G120X	HMK_A_DROSSEL_G120X	HMK_MLFB_A_DROSSEL_G120X	HMK_VALUE_VALID_G120X
            
            var sSQL = "SELECT * FROM VT_G120X_M00051_26587 WHERE HMK_A_DROSSEL_G120X = 'T' AND HMK_MLFB_KEY_G120X = '" + sMLFB_Key + 
                        "' AND HMK_VALUE_VALID_G120X = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00051_26587");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_A_DROSSEL_G120X) >= 0)
                    {
                        ECL_SelectValue("HMK_A_DROSSEL_G120X", "T");
                        var sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SelectValue("HMK_A_DROSSEL_G120X", "F"); // ohne
                }
            }		
            else
            {
                ECL_SelectValue("HMK_A_DROSSEL_G120X", "F"); // ohne
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // dU/dt-Filter plus VPL			VT_G120X_M00052_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_MLFB_KEY_G120X	HMK_FILTER_VPL_G120X	HMK_MLFB_FIL_VPL_G120X	HMK_VALUE_VALID_G120X
            
            var sSQL = "SELECT * FROM VT_G120X_M00052_26587 WHERE HMK_FILTER_VPL_G120X = 'T' AND HMK_MLFB_KEY_G120X = '" + sMLFB_Key + 
                        "' AND HMK_VALUE_VALID_G120X = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00052_26587");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_FIL_VPL_G120X) >= 0)
                    {
                        ECL_SelectValue("HMK_FILTER_VPL_G120X", "T");
                        var sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SelectValue("HMK_FILTER_VPL_G120X", "F"); // ohne
                }
            }		
            else
            {
                ECL_SelectValue("HMK_FILTER_VPL_G120X", "F"); // ohne
            }
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // Sinusfilter			VT_G120X_M00155_26587
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // HMK_MLFB_KEY_G120X	HMK_SINUSFILTER_G120X	HMK_MLFB_SINUSFILTER_G120X	HMK_VALUE_VALID_G120X
            
            var sSQL = "SELECT * FROM VT_G120X_M00155_26587 WHERE HMK_SINUSFILTER_G120X = 'T' AND HMK_MLFB_KEY_G120X = '" + sMLFB_Key + 
                        "' AND HMK_VALUE_VALID_G120X = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00155_26587");
            if (aResult.length > 0)
            {
                var sStatus = "ohne";
                for (var i = 0; i < aResult.length; i++)
                {
                    if (sECSI_MLFB_SEC.indexOf(aResult[i].HMK_MLFB_SINUSFILTER_G120X) >= 0)
                    {
                        ECL_SelectValue("HMK_SINUSFILTER_G120X", "T");
                        var sStatus = "mit";
                    }
                }
                if (sStatus == "ohne")
                {
                    ECL_SelectValue("HMK_SINUSFILTER_G120X", "F"); // ohne
                }
            }		
            else
            {
                ECL_SelectValue("HMK_SINUSFILTER_G120X", "F"); // ohne
            }
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        }
        // ## ENDE SEK-MLFBs ########################################################################################################
        // ## ENDE SEK-MLFBs ########################################################################################################
        setCheckBoxAttributes();
    }
    // ## ENDE PARSER #################################################################################################################################################################
    // ## ENDE PARSER #################################################################################################################################################################
    // ## ENDE PARSER #################################################################################################################################################################
    
    getCheckBoxAttributes(sCurrentAttribute);
    
    var sMLFB14 = ECL_GetValue("MLFB14_G120X");
    var sMLFB_Key = ECL_GetValue("HMK_MLFB_KEY_G120X");
    var sSpannung = ECL_GetValue("HMK_NETZSPANNUNG_G120X");
    var HMK_NETZSPANNUNG_G120X = sSpannung;
    var sFrequenz = ECL_GetValue("HMK_NETZFREQUENZ_G120X");
    
    
    sECSI_MLFB_SEC = "";
    // ## Logik #################################################################################################################################################################
    // ## Logik #################################################################################################################################################################
    // ## Logik #################################################################################################################################################################
    /*
    Bussystem
    */
    
    // ----------------------------------------------------------------------------------------------------------------------------------
    // HMK_UMGEBUNGSBED_G120X
    // ----------------------------------------------------------------------------------------------------------------------------------
    if (sCurrentAttribute == "HMK_UMGEBUNGSBED_G120X"){
        var sUmgebBed = ECL_GetValue("HMK_UMGEBUNGSBED_G120X");
        
        if (sUmgebBed == "C2") 
        {
            ECL_SetValue("MLFB06_G120X", "2");
            sECSI_MLFB = replaceAt(sECSI_MLFB, 5, "2");
        }
        else if (sUmgebBed == "C3") 
        {
            ECL_SetValue("MLFB06_G120X", "3");
            sECSI_MLFB = replaceAt(sECSI_MLFB, 5, "3");
        }
        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
    }
    // ----------------------------------------------------------------------------------------------------------------------------------
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // IO-Extension MLFB13
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    if (sCurrentAttribute == "UI_IO_EXT_G120X"){
        
        if (ECL_ValueSelected("UI_IO_EXT_G120X", "T")){
            sECSI_MLFB = replaceAt(sECSI_MLFB, 12, "1");
        }else{
            sECSI_MLFB = replaceAt(sECSI_MLFB, 12, "0");
        }
        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
    }
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    /*
    Zubehr
    OK	Speicherkarte		ohne, leer, (mit Firmware - gibt es derzeut nicht)
    OK	Webservermodul (Smart Access)		mit, ohne
NEU		SINAMICS CONNECT 300 IoT Gateway	HMK_CONNECT_300_G120X
    OK	IOP-2 Handheld
    OK	Trmontagesatz IOP-2/BOP-2
    weg	SIPLUS IOP2
NEU		SINAMICS FSG Adapter Set			HMK_ADAPTER_SET_G120X
    OK	DSEE
    OK	DSA
    OK	Sicherung (Menge =3)
    OK	Externer Netzfilter
    OK	Line Harmonics Filter (Menge 1, 2)
    OK	Netzdrossel
    OK	Ausgangsdrossel
    OK	dU/dt-Filter plus VPL
    OK	Sinusfilter
        
        VT_G120X_M00001	MLFB07-Schutzart
        VT_G120X_M00003	MLFB 11-12
        VT_G120X_M00004	MLFB08-Bedeineinheit
        VT_G120X_M00007	MLFB06-Umgeb.Beding.
        VT_G120X_M00008	MLFB06-11-12
        VT_G120X_M00144	MLFB13-IO Extension			
        VT_G120X_M00010	MLFB14-Filterklasse-int
        VT_G120X_M00011	MLFB15-Kommunikation
        VT_G120X_M00015	Bauform HMK-PMD
        VT_G120X_M00174	MLFB-07_10-12 Key FS Strom 
        
    OK	VT_G120X_M00045_26587 MLFB Netzdrossel in Abhngigkeit von MLFB_KEY
    OK	VT_G120X_M00155_26587	MLFB Sinusfilter
        VT_G120X_M00048	MLFB Schirmanschlusssatz	Nur G120XA
    OK	VT_G120X_M00049	MLFB Externer Netzfilter
    OK	VT_G120X_M00050	MLFB Sicherung
    OK	VT_G120X_M00051	MLFB Ausgangsdrossel
    OK	VT_G120X_M00052	MLFB Du/dt-Filter
        
        
    NN	VT_G120X_M00063	Tech. Daten 3C3
    NN	VT_G120X_M00073	MLFB10-Netzspannung			nicht ntig, Spannung nicht vom Benutzer whlbar, bergabe aus PortfolioSelection TST
    OK	VT_G120X_M00074	MLFB Speicherkarte
    OK	VT_G120X_M00075	MLFB Trmontagesatz
    OK	VT_G120X_M00076	MLFB IOP Handheld
    ok	VT_G120X_M00103 EMV-Steuerung
    OK	VT_G120X_M00112	Ausgangsd., dU/dt- und Sinusfilter 					ersetzt durch VT 133
    NN	VT_G120X_M00162	Filterklasse MMe		Steuerung UI-Filterklasse
    OK	VT_G120X_M00114	MLFB Line Harmonics Filter
    OK	VT_G120X_M00146_26587	MLFB Smart Access
neu:
    ok	VT_G120X_M00117	MLFB06  <> MLFB08	im Code abgebildet
    ok	VT_G120X_M00119	MLFB IOP-2 SIPLUS	neu
    nn	VT_G120X_M00120	EDZ G120X/XA Grundgerte + Macrobox	eplan
    nn	VT_G120X_M00121	EDZ Filter	eplan
    nn	VT_G120X_M00122	EDZ Kommunikation	eplan
    nn	VT_G120X_M00124	EDZ Bedieneinheit	eplan
    ok	VT_G120X_M00128	MLFB DSEE	neu
    nn	VT_G120X_M00129	Tech. Daten Base MLFB	nn
    nn	VT_G120X_M00132	Tech. Daten Cable Length	nn
NEU		VT_G120X_M00157	Ausgangsd., dU/dt- und Sinusfilter + Ext.-Netzfilter	Ersatz fr VT 133

    */	
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Bussystem Steuerung MLFB15:	ZO Bussystem (B, P, F) - HMK_KOMMUNIKATION_G120X
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //if (ECL_GetUserVariable("BusUserSet") == "USER")
    // var sFieldbusInterface = ECL_GetValue("ECSI_CX_FieldbusInterface"); 
    //var iFieldbusInterface = parseInt(sFieldbusInterface);

    var sBusParam = ECL_GetValue("HMK_KOMMUNIKATION_G120X");
    if (sBusParam == "00002") // PROFINET / EtherNet/IP
    {
        sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "F");
        ECL_SetValue("MLFB15_G120X", "F");
    }
    else if (sBusParam == "00003") // PROFIBUS
    {
        sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "P");
        ECL_SetValue("MLFB15_G120X", "P");
    }
    else if (sBusParam == "00001") // USS/Modbus
    {
        sECSI_MLFB = replaceAt(sECSI_MLFB, 14, "B");
        ECL_SetValue("MLFB15_G120X", "B");
    }
    ECL_SetValue("ECSI_MLFB", sECSI_MLFB);

    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Bedieneinheit	
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Wenn MLFB06 == 2, alle erlaubt, wenn 3, dann nur Leer und BOP
    if (ECL_SetValue("HMK_UMGEBUNGSBED_G120X" == "C3")){
        // IOP-2 ausblenden
        ECL_DeactivateValue("HMK_BEDIENEINHEIT_G120X", "00003");
    }else{
        ECL_ActivateValue("HMK_BEDIENEINHEIT_G120X", "00003");
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Speicherkarte	VT_G120X_M00074_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // VT_G120X_M00074_26587 - keine Einschrnkungen, nur Stckliste
    // HMK_SPEICHERKARTE_G120X	HMK_MLFB_SPEICHERK_G120X	HMK_VALUE_VALID_G120X
    
    if (ECL_GetValue("HMK_SPEICHERKARTE_G120X") == "LEER") // || == "FIRM"
    {
        var sSQL = "SELECT * FROM VT_G120X_M00074_26587 WHERE HMK_SPEICHERKARTE_G120X = 'LEER' AND HMK_VALUE_VALID_G120X = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00074_26587");
        if (aResult.length > 0)
        {
            var sMLFB_SPEICHERKARTE = aResult[0].HMK_MLFB_SPEICHERK_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_SPEICHERKARTE;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_SPEICHERKARTE;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___MEMORYCARD_MLFB_G120X") + " "; //"MLFB fr 'Speicherkarte' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Webservermodul (Smart Access)			VT_G120X_M00146_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Keine Einschrnkungen
    // HMK_SMART_ACCESS_G120X	HMK_MLFB_SMARTACC_G120X	HMK_VALUE_VALID_G120X
    if (ECL_GetValue("HMK_SMART_ACCESS_G120X") == "T") 
    {
        var sSQL = "SELECT * FROM VT_G120X_M00146_26587 WHERE HMK_SMART_ACCESS_G120X = 'T' AND HMK_VALUE_VALID_G120X = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00146_26587");
        if (aResult.length > 0)
        {
            var sMLFB_SMART_ACCESS = aResult[0].HMK_MLFB_SMARTACC_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_SMART_ACCESS;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_SMART_ACCESS;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SMART_ACCESS_MLFB_G120X") + " "; //"MLFB fr 'Webserver-Modul' nicht bestimmt, kein Treffer in DB. ";
        }
        if (ECL_GetValue("HMK_BEDIENEINHEIT_G120X") == "00002" || ECL_GetValue("HMK_BEDIENEINHEIT_G120X") == "00003")
        {
            // Zeige Hinweis:
            ECL_ActivateAttribute("MESSAGE_SMARTACCESS_G120X");
        }
        else
        {
            ECL_DeactivateAttribute("MESSAGE_SMARTACCESS_G120X");
        }
    }
    else
    {
        ECL_DeactivateAttribute("MESSAGE_SMARTACCESS_G120X");
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // DriveSim
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    if (ECL_GetValue("HMK_DRIVESIM_DESIGNER_G120X") === "T")
    {
        var sSQL = "SELECT * FROM VT_G120X_M00189_26587 WHERE HMK_DRV_SIM_DESIGNER_G120X = 'T' AND HMK_PRODUKT_TRIG_G120X = 'G120X';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00189_26587");
        if (aResult.length > 0)
        {
            var sMLFB_DRIVE_SIM_DESIGNER = aResult[0].HMK_MLFB_DRV_SIM_DES_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_DRIVE_SIM_DESIGNER;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_DRIVE_SIM_DESIGNER;
            }
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Bedieneinheit
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Bedieneinheit in Basis-MLFB setzen
    if  (sCurrentAttribute == "HMK_BEDIENEINHEIT_G120X")
    {
        sBedienpanel = ECL_GetValue("HMK_BEDIENEINHEIT_G120X");
        
        var sBedienpanel_Param = sBedienpanel.right(1);
        ECL_SetValue("MLFB08_G120X", sBedienpanel_Param);
        sECSI_MLFB = replaceAt(sECSI_MLFB, 7, sBedienpanel_Param);
        ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // IOP-2 Handheld			VT_G120X_M00076_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Wenn Handheld, dann Bedienpanel auf Leer setzen, aber trotzdem Umwahl auf IOP-2 mglich
    // BOP-2 mit Handheld geht grundstzlich
    // HMK_IOPHANDHELD_G120X	HMK_MLFB_IOPHANDHELD_G120X	HMK_VALUE_VALID_G120X
    if ( (ECL_GetValue("HMK_IOPHANDHELD_G120X") == "T") && (ECL_GetValue("HMK_BEDIENEINHEIT_G120X") == "00003") // IOP
    ) {
        ECL_ActivateAttribute("MESSAGE_HANDHELD1_G120X");
    }
    
    if (sCurrentAttribute == "HMK_IOPHANDHELD_G120X")
    {
        if ( (ECL_GetValue("HMK_IOPHANDHELD_G120X") == "T") && (ECL_GetValue("HMK_BEDIENEINHEIT_G120X") == "00003") // IOP
        ) {
            ECL_SelectValue("HMK_BEDIENEINHEIT_G120X", "00001");
            ECL_SelectValue("MLFB08_G120X", "1");
            sECSI_MLFB = replaceAt(sECSI_MLFB, 7, "1");
            ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
            // Zeige Hinweis:
            ECL_ActivateAttribute("MESSAGE_HANDHELD2_G120X");
            ECL_DeactivateAttribute("MESSAGE_HANDHELD1_G120X");
        }
        if (ECL_GetValue("HMK_IOPHANDHELD_G120X") == "F") 
        {
            ECL_DeactivateAttribute("MESSAGE_HANDHELD1_G120X");
            ECL_DeactivateAttribute("MESSAGE_HANDHELD2_G120X");
        }
        // Wenn BOP-2 keine Aktion
    }
    
    if (sCurrentAttribute == "HMK_BEDIENEINHEIT_G120X")
    {
        if ( (ECL_GetValue("HMK_IOPHANDHELD_G120X") == "T") && (ECL_GetValue("HMK_BEDIENEINHEIT_G120X") == "00003") // IOP
        ) {
            ECL_DeactivateAttribute("MESSAGE_HANDHELD2_G120X");
            ECL_ActivateAttribute("MESSAGE_HANDHELD1_G120X");
        }
        if ( (ECL_GetValue("HMK_IOPHANDHELD_G120X") == "T") && ((ECL_GetValue("HMK_BEDIENEINHEIT_G120X") == "00002") || (ECL_GetValue("HMK_BEDIENEINHEIT_G120X") == "00001"))// BOP oder leer
        ) {
            ECL_DeactivateAttribute("MESSAGE_HANDHELD1_G120X");
            ECL_DeactivateAttribute("MESSAGE_HANDHELD2_G120X");
        }
        if (ECL_GetValue("HMK_IOPHANDHELD_G120X") == "F") 
        {
            ECL_DeactivateAttribute("MESSAGE_HANDHELD1_G120X");
            ECL_DeactivateAttribute("MESSAGE_HANDHELD2_G120X");
        }
    }
    // Stckliste
    if (ECL_GetValue("HMK_IOPHANDHELD_G120X") == "T") 
    {
        var sSQL = "SELECT * FROM VT_G120X_M00076_26587 WHERE HMK_IOPHANDHELD_G120X = 'T' AND HMK_VALUE_VALID_G120X = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00076_26587");
        if (aResult.length > 0)
        {
            var sMLFB_IOP_HANDHELD = aResult[0].HMK_MLFB_IOPHANDHELD_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_IOP_HANDHELD;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_IOP_HANDHELD;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___IOP_HANDHELD_MLFB_G120X") + " "; //"MLFB fr 'IOP-2 Handheld' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Trmontagesatz IOP-2/BOP-2			VT_G120X_M00075_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // NEU Okt 2020
    /* VT_G120X_M00160_26587
        MLFB13_G120X	HMK_TUERMONTAGE_G120X	HMK_VALUE_VALID_G120X
        Abhngig von MLFB13 (IO-EXT), nur wenn MLFB13 == 0
    * /
    2021.02 wieder deaktiviert, VT160 gibt es nicht mehr!
    
    if (ECL_ValueSelected("UI_IO_EXT_G120X", "T")){
        ECL_DeactivateValue("HMK_TUERMONTAGE_G120X", "T");
        ECL_SetValue("HMK_TUERMONTAGE_G120X", "F");
    }else{
        ECL_ActivateValue("HMK_TUERMONTAGE_G120X", "T");
    }
    */
    
    // HMK_TUERMONTAGE_G120X	HMK_MLFB_TUERMONTAGE_G120X	HMK_VALUE_VALID_G120X
    if (ECL_GetValue("HMK_TUERMONTAGE_G120X") == "T") 
    {
        var sSQL = "SELECT * FROM VT_G120X_M00075_26587 WHERE HMK_TUERMONTAGE_G120X = 'T' AND HMK_VALUE_VALID_G120X = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00075_26587");
        if (aResult.length > 0)
        {
            var sMLFB_TUER_MONTAGE = aResult[0].HMK_MLFB_TUERMONTAGE_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_TUER_MONTAGE;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_TUER_MONTAGE;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___TUER_MONTAGE_MLFB_G120X") + " "; //"MLFB fr 'Tr-Montagesatz' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // HMK_IP21_TOP_COVER_G120X	
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //setProductLogicToUIAttribute("HMK_IP21_TOP_COVER_G120X", "UI_IP21_TOP_COVER_G120X", "T", "F");
    // VT_G120X_M00148_26587	MLFB IP21 Top Cover + CAD
    //	HMK_MLFB_KEY_G120X	HMK_MOTORNORM_G120X	HMK_IP21_TOP_COVER_G120X	HMK_MLFB_IP21_TC_G120X	MLFB_IP21_TC_CAD_G120X	HMK_VALUE_VALID_G120X
    
    var aAttributesVT148 = ["HMK_MLFB_KEY_G120X",
                            "HMK_MOTORNORM_G120X",
                            "HMK_VALUE_VALID_G120X"];
    setValuesFromDatabase("VT_G120X_M00148_26587", "HMK_IP21_TOP_COVER_G120X", aAttributesVT148);
    
    //var HMK_MLFB_KEY_G120X = ECL_GetValue("HMK_MLFB_KEY_G120X");
    var HMK_MOTORNORM_G120X = ECL_GetValue("HMK_MOTORNORM_G120X");
    //Stckliste
    if (ECL_GetValue("HMK_IP21_TOP_COVER_G120X") == "T") 
    {
        var sSQL = "SELECT * FROM VT_G120X_M00148_26587 WHERE "+
                    "HMK_IP21_TOP_COVER_G120X = 'T' AND " + 
                    "HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND " + 
                    "HMK_MOTORNORM_G120X = '" + HMK_MOTORNORM_G120X + "' AND " + 
                    "HMK_VALUE_VALID_G120X = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00148_26587");
        if (aResult.length > 0)
        {
            var HMK_MLFB_IP21_TC_G120X = aResult[0].HMK_MLFB_IP21_TC_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + HMK_MLFB_IP21_TC_G120X;
            }
            else
            {
                sECSI_MLFB_SEC = HMK_MLFB_IP21_TC_G120X;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___IP21_TOP_COVER_MLFB_G120X") + " "; 
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // HMK_PUSH_THROUGH_G120X
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //setProductLogicToUIAttribute("HMK_PUSH_THROUGH_G120X", "UI_PUSH_THROUGH_G120X", "T", "F");
    // VT_G120X_M00147_26587	Baugre - Push Through
    //	PMD_ABW171_001_000_G120X	HMK_PUSH_THROUGH_G120X	HMK_MLFB_PUSHTHROUGH_G120X	HMK_VALUE_VALID_G120X
    
    var aAttributesVT147 = ["PMD_ABW171_001_000_G120X",
                            "HMK_VALUE_VALID_G120X"];
    setValuesFromDatabase("VT_G120X_M00147_26587", "HMK_PUSH_THROUGH_G120X", aAttributesVT147);
    

    //Stckliste
    if (ECL_GetValue("HMK_PUSH_THROUGH_G120X") == "T") 
    {
        var PMD_ABW171_001_000_G120X = ECL_GetValue("PMD_ABW171_001_000_G120X");
        
        var sSQL = "SELECT * FROM VT_G120X_M00147_26587 WHERE "+
                    "HMK_PUSH_THROUGH_G120X = 'T' AND " + 
                    "PMD_ABW171_001_000_G120X = '" + PMD_ABW171_001_000_G120X + "' AND " + 
                    "HMK_VALUE_VALID_G120X = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00147_26587");
        if (aResult.length > 0)
        {
            var HMK_MLFB_PUSHTHROUGH_G120X = aResult[0].HMK_MLFB_PUSHTHROUGH_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + HMK_MLFB_PUSHTHROUGH_G120X;
            }
            else
            {
                sECSI_MLFB_SEC = HMK_MLFB_PUSHTHROUGH_G120X;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___PUSH_THROUGH_EB_MLFB_G120X") + " "; 
        }
    }
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // 	SINAMICS FSG Adapter Set						VT_G120X_M00165_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //setProductLogicToUIAttribute("HMK_PUSH_THROUGH_G120X", "UI_PUSH_THROUGH_G120X", "T", "F");
    // VT_G120X_M00165_26587	
    //	HMK_MLFB_KEY_G120X	HMK_ADAPTER_SET_G120X	HMK_MLFB_ADAPTER_SET_G120X	HMK_VALUE_VALID_G120X
    
    /*var aAttributesVT165 = ["HMK_MLFB_KEY_G120X",
                            "HMK_ADAPTER_SET_G120X",
                            "HMK_VALUE_VALID_G120X"];
    ECL_InferencePositiveValues("VT_G120X_M00165_26587", "HMK_ADAPTER_SET_G120X", aAttributesVT165);
    */
    var sSQL = "SELECT * FROM VT_G120X_M00165_26587 WHERE " +
                "HMK_ADAPTER_SET_G120X = 'T' AND " + 
                "HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND " + 
                "HMK_VALUE_VALID_G120X = 'T';"; 
    var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00165_26587");
    if (aResult.length > 0){
        ECL_ActivateValue("HMK_ADAPTER_SET_G120X", "T");
    }else{
        ECL_DeactivateValue("HMK_ADAPTER_SET_G120X", "T");
        ECL_SetValue("HMK_ADAPTER_SET_G120X", "F");
    }
    //Stckliste
    if ( (ECL_GetValue("HMK_ADAPTER_SET_G120X") == "T") && (aResult.length > 0)) {
        if (aResult.length > 0){
            var HMK_MLFB_ADAPTER_SET_G120X = aResult[0].HMK_MLFB_ADAPTER_SET_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== ""){
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + HMK_MLFB_ADAPTER_SET_G120X;
            }else{
                sECSI_MLFB_SEC = HMK_MLFB_ADAPTER_SET_G120X;
            }
        }else{
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___ADAPTER_SET_MLFB_G120X") + " "; 
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // SIPLUS IOP2				VT_G120X_M00119_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // HMK_IOP2_SIPLUS_G120X	HMK_PRODUKT_TRIG_G120X	HMK_IOP2_SIPLUS_MLFB_G120X	HMK_VALUE_VALID_G120X
    // T    					G120X                   6AG12550AA002JA2			T    
    
    // es ist nur ein Bedienteil zugelassen, bzw. hinweismeldung, dass man mehrere gewhlt hat.
    
/*	if ((ECL_GetValue("HMK_IOP2_SIPLUS_G120X") == "T") &&
        ((ECL_GetValue("HMK_BEDIENEINHEIT_G120X") == "00002") || 
        (ECL_GetValue("HMK_BEDIENEINHEIT_G120X") == "00003") ||
        (ECL_GetValue("HMK_IOPHANDHELD_G120X") == "T")	) )
    {	
        ECL_ActivateAttribute("MESSAGE_IOP2_SIPLUS_G120X");
    }
    else
    {
        ECL_DeactivateAttribute("MESSAGE_IOP2_SIPLUS_G120X");
    }
    
    
    // Stckliste
    if (ECL_GetValue("HMK_IOP2_SIPLUS_G120X") == "T") 
    {
        var sSQL = "SELECT * FROM VT_G120X_M00119_26587 WHERE HMK_IOP2_SIPLUS_G120X = 'T' AND HMK_PRODUKT_TRIG_G120X = 'G120X' AND HMK_VALUE_VALID_G120X = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00119_26587");
        if (aResult.length > 0)
        {
            var sMLFB_SIPLUS_IOP = aResult[0].HMK_IOP2_SIPLUS_MLFB_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_SIPLUS_IOP;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_SIPLUS_IOP;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___SIPLUS_IOP_MLFB_G120X") + " "; //"MLFB fr 'SIPLUS IOP-2' nicht bestimmt, kein Treffer in DB. ";
        }
    }
*/	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // DSEE - Drive Service Extended Exchange		VT_G120X_M00128_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    var sDSEE = ECL_GetValue("HMK_DSEE_G120X");
    
    if ( (sDSEE == "DSEE3") || (sDSEE == "DSEE5") // nicht 'OHNE'
    ) {
        // HMK_MLFB_G120X	HMK_DSEE_G120X	HMK_MLFB_DSEE_G120X	HMK_VALUE_VALID_G120X
        var sSQL = "SELECT * FROM VT_G120X_M00128_26587 WHERE HMK_MLFB_G120X = '" + sECSI_MLFB + "' AND HMK_DSEE_G120X = '" + sDSEE + "' AND HMK_VALUE_VALID_G120X = 'T';";
        
        var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
        if (aResult.length > 0)
        {
            var sMLFB_DSEE_G120X = aResult[0].HMK_MLFB_DSEE_G120X; 
            
            if (sECSI_MLFB_SEC.length > 0)
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_DSEE_G120X;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_DSEE_G120X;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DSEE_MLFB_G120X") + " "; // "MLFB fr 'DSEE' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Netzdrossel	VT_G120X_M00045_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Wenn MLFB-Key spezifiziert, Default auf 'T', also mit Netzdrossel, daher im DataManager als Default definiert.
    // VT_G120X_M00045_26587 Netzdrossel in Abhngigkeit von MLFB_KEY
    // HMK_MLFB_KEY_G120X	HMK_NETZDROSSEL_G120X	HMK_MLFB_NETZDROSSEL_G120X	HMK_VALUE_VALID_G120X
    var sSQL = "SELECT * FROM VT_G120X_M00045_26587 WHERE HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND HMK_NETZDROSSEL_G120X = 'T' AND HMK_VALUE_VALID_G120X = 'T';"; 
    var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00045_26587");
    if (aResult.length > 0)
    {
        // Whlbar
        ECL_ActivateValue("HMK_NETZDROSSEL_G120X", "T"); // keine weiteren Einschrnkungen
        if (ECL_GetValue("HMK_NETZDROSSEL_G120X") == "T")
        {
            var sMLFB_NETZDROSSEL = aResult[0].HMK_MLFB_NETZDROSSEL_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_NETZDROSSEL;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_NETZDROSSEL;
            }
        }
    }
    else
    {
        ECL_DeactivateValue("HMK_NETZDROSSEL_G120X", "T");
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Interner Netzfilter			VT_G120X_M00010_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    /* 
    UI_FILTERKLASSE_G120X (EMV-Kategorie) ist das Benutzerattribut, 
    welches in HMK_FILTERKLASSE_G120X und damit in MLFB14_G120X bersetzt wird.
    
    Dazu VT_G120X_M00162_26587
    UI_FILTERKLASSE_G120X	HMK_FILTERKLASSE_G120X	HMK_MLFB_KEY_G120X	HMK_DEF_EXT_FILTER_G120X	HMK_VALUE_VALID_G120X
    */
    
    // Umwahl in HMK-Attribut bertragen:
    if (sCurrentAttribute == "UI_FILTERKLASSE_G120X"){
        var UI_FILTERKLASSE_G120X = ECL_GetValue("UI_FILTERKLASSE_G120X");
        
        var HMK_FILTERKLASSE_G120X = UI_FILTERKLASSE_G120X;
        if (UI_FILTERKLASSE_G120X == "00003") {
            if (sMLFB_Key == "00019") {
                HMK_FILTERKLASSE_G120X = "00002";
            }
            else {
                HMK_FILTERKLASSE_G120X = "00001";
            }
        }
        ECL_SetValue("HMK_FILTERKLASSE_G120X", HMK_FILTERKLASSE_G120X);
    }
    
    // ---------------------------------------------------------------------------------------------------------------------
    // VT_G120X_M00103_26587	
    // HMK_MLFB_KEY_G120X	MLFB14_G120X	HMK_VALUE_VALID_G120X
    var sTable = "VT_G120X_M00103_26587";
    var sTargetAttribute = "MLFB14_G120X";
    
    var sWhere = 	"HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_G120X") + " "; 
    }
    // ---------------------------------------------------------------------------------------------------------------------
    // HMK_MLFB_KEY_G120X	MLFB14_G120X	HMK_EXT_NETZFILTER_G120X	HMK_MLFB_NETZFILTER_G120X	HMK_VALUE_VALID_G120X
/*	var sTable = "VT_G120X_M00049_26587";
    var sTargetAttribute = "MLFB14_G120X";
    
    var HMK_EXT_NETZFILTER_G120X = ECL_GetValue("HMK_EXT_NETZFILTER_G120X");
    
    var sWhere = 	"HMK_EXT_NETZFILTER_G120X = '"  + HMK_EXT_NETZFILTER_G120X  + "' AND " +
                    "HMK_MLFB_KEY_G120X = '"		+ sMLFB_Key					+ "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_G120X") + " "; 
    }
*/	// ---------------------------------------------------------------------------------------------------------------------
    // HMK_MLFB_KEY_G120X	MLFB14_G120X	HMK_EXT_NETZFILTER_G120X	HMK_SINUSFILTER_G120X	HMK_FILTERKL_GESAMT_G120X	HMK_HINW_FSC_C3_G120X	HMK_VALUE_VALID_G120X
/*	Fr Umwahl deaktiviert
    var HMK_EXT_NETZFILTER_G120X = ECL_GetValue("HMK_EXT_NETZFILTER_G120X");
    
    var sTable = "VT_G120X_M00156_26587";
    var sTargetAttribute = "MLFB14_G120X";
    
    var sWhere = 	"HMK_EXT_NETZFILTER_G120X = '" + HMK_EXT_NETZFILTER_G120X + "' AND " +
                    "HMK_MLFB_KEY_G120X = '"	+ sMLFB_Key				+ "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
//	var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_G120X") + " "; 
    }
*/	// ---------------------------------------------------------------------------------------------------------------------
    
    sMLFB14 = ECL_GetValue("MLFB14_G120X");
    // ---------------------------------------------------------------------------------------------------------------------
    //bertragen der Einschnkungen aus MLFB14 auf HMK_FILTERKLASSE_G120X
    var sTable = "VT_G120X_M00010_26587";
    var sTarget = "HMK_FILTERKLASSE_G120X";
    var sMLFB_NAME = "MLFB14_G120X";
    
    var sStatus = SetAttributeLogicFromMLFB(sTarget, sMLFB_NAME, sTable);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_G120X") + " "; 
    }
    // ---------------------------------------------------------------------------------------------------------------------
    
    // ---------------------------------------------------------------------------------------------------------------------
    
    // UI_FILTERKLASSE_G120X anhand HMK_FILTERKLASSE_G120X einschrnken ber VT_G120X_M00162_26587
    //		UI_FILTERKLASSE_G120X	HMK_FILTERKLASSE_G120X	HMK_MLFB_KEY_G120X	HMK_DEF_EXT_FILTER_G120X	HMK_VALUE_VALID_G120X
    var HMK_FILTERKLASSE_G120X = ECL_GetValue("HMK_FILTERKLASSE_G120X");
    
    var sTable = "VT_G120X_M00162_26587";
    var sTargetAttribute = "UI_FILTERKLASSE_G120X";
    var sWhereFilter = "(HMK_FILTERKLASSE_G120X = '" + HMK_FILTERKLASSE_G120X + "'";
    
    var aValidFilter_HMK = ECL_GetAllActiveAttributeValues("HMK_FILTERKLASSE_G120X");
    
    if (aValidFilter_HMK.length > 0){
        sWhereFilter =  "(HMK_FILTERKLASSE_G120X = '" + aValidFilter_HMK[0] + "'";
    }
    if (aValidFilter_HMK.length > 1){
        for (var iHMK_Filter = 1; iHMK_Filter < aValidFilter_HMK.length; iHMK_Filter++){
            sWhereFilter = sWhereFilter + " OR HMK_FILTERKLASSE_G120X = '" + aValidFilter_HMK[iHMK_Filter] + "'";
        }
        
    }
    sWhereFilter = sWhereFilter + ") AND ";
    
    var sWhere = 	sWhereFilter +
                    //"HMK_FILTERKLASSE_G120X = '" + HMK_FILTERKLASSE_G120X + "' AND " +
                    "HMK_MLFB_KEY_G120X = '"	+ sMLFB_Key				+ "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
                    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_G120X") + " "; 
    }
    // ---------------------------------------------------------------------------------------------------------------------
    
    // ---------------------------------------------------------------------------------------------------------------------
    // HMK_FILTERKLASSE_G120X sollte jetzt eindeutig sein
    // ---------------------------------------------------------------------------------------------------------------------
    // Aktualisieren der MLFB14_G120X
    // VT_G120X_M00010_26587 - bersetzung Filter-MLFB14
    // MLFB14_G120X	HMK_FILTERKLASSE_G120X	HMK_VALUE_VALID_G120X
    
    var sFilterIntern = ECL_GetValue("HMK_FILTERKLASSE_G120X");
    switch (sFilterIntern)
    {
        case "00001": // ungefiltert
            ECL_SetValue("MLFB14_G120X", "U");
            sECSI_MLFB = replaceAt(sECSI_MLFB, 13, "U");
            ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
        break;
        case "00002": // C2 - A
            ECL_SetValue("MLFB14_G120X", "A");
            sECSI_MLFB = replaceAt(sECSI_MLFB, 13, "A");
            ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
        break;
        case "00004": // C3 - C
            ECL_SetValue("MLFB14_G120X", "C");
            sECSI_MLFB = replaceAt(sECSI_MLFB, 13, "C");
            ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
        break;
    }
    sMLFB14 = ECL_GetValue("MLFB14_G120X");
    
    // ---------------------------------------------------------------------------------------------------------------------
    // Bestimmung Default Ext-Filter
    /*	VT_G120X_M00162_26587
            UI_FILTERKLASSE_G120X	HMK_FILTERKLASSE_G120X	HMK_MLFB_KEY_G120X	HMK_DEF_EXT_FILTER_G120X	HMK_VALUE_VALID_G120X
    */
    var sTable = "VT_G120X_M00162_26587";
    var sTargetAttribute = "HMK_DEF_EXT_FILTER_G120X";
    
    var UI_FILTERKLASSE_G120X = ECL_GetValue("UI_FILTERKLASSE_G120X");
    var HMK_FILTERKLASSE_G120X = ECL_GetValue("HMK_FILTERKLASSE_G120X");
    
    var sWhere = 	"UI_FILTERKLASSE_G120X = '" + UI_FILTERKLASSE_G120X  + "' AND " +
                    "HMK_FILTERKLASSE_G120X = '"+ HMK_FILTERKLASSE_G120X + "' AND " +
                    "HMK_MLFB_KEY_G120X = '"	+ sMLFB_Key				 + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_G120X") + " "; 
    }
    
    // mit Ext-Filter kann Gesamtfilterklasse HMK_FILTERKL_GESAMT_G120X bestimmt werden.
    
    // ---------------------------------------------------------------------------------------------------------------------
    
    /* CONSEQUENCES
    InputFilterType
    Integer	
    This parameter defines, if an internal line filter was selected.	
        0	No internal line filter selected
        1	Internal line filter C1
        2	Internal line filter C2
        3	Internal line filter C3
    */
    switch (ECL_GetValue("UI_FILTERKLASSE_G120X")){
        case "00001": // ohne
            var InputFilterType = "0";
        break;
        case "00002": // C2
            var InputFilterType = "2";	// 
        break;
        case "00003": // C1
            var InputFilterType = "1";	//
        break;
        case "00004": // C3
            var InputFilterType = "3";	// 
        break;
        default:
            var InputFilterType = "0";
    }
    ECL_SetValue("ECSI_CC_InputFilterType", InputFilterType);
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Wenn interner Filter neu bewertet, dann ggf. Defaultwert fr externen Filter setzen
    // ansonsten Meldung anzeigen
/*	var HMK_DEF_EXT_FILTER_G120X = ECL_GetValue("HMK_DEF_EXT_FILTER_G120X");
    var HMK_EXT_NETZFILTER_G120X = ECL_GetValue("HMK_EXT_NETZFILTER_G120X");
    if (HMK_EXT_NETZFILTER_G120X != HMK_DEF_EXT_FILTER_G120X){
        if (sCurrentAttribute == "UI_FILTERKLASSE_G120X"){
            ECL_SetValue("HMK_EXT_NETZFILTER_G120X", HMK_DEF_EXT_FILTER_G120X);
            ECL_DeactivateAttribute("INFO_FILTERKL_GESAMT_G120X");
        }else{
            ECL_ActivateAttribute("INFO_FILTERKL_GESAMT_G120X");
        }
    }else{
        ECL_DeactivateAttribute("INFO_FILTERKL_GESAMT_G120X");
    }
*/	ECL_DeactivateAttribute("INFO_FILTERKL_GESAMT_G120X");

    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
    // Externer Netzfilter			VT_G120X_M00049_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Entgegen smtlicher anderer Umrichter, kann hier in bestimmten Fllen sowohl intern als auch extern gefiltert werden!!! fr C1
    // todo HMK_DEF_EXT_FILTER_G120X???
    // VT_G120X_M00162_26587 --> UI-Filterklasse vs. HMK_FILTERKLASSE_G120X + MLFB_KEY + HMK_DEF_EXT_FILTER_G120X
    // bei UI_Klasse == 00003 --> HMK_FILTERKLASSE_G120X 00001 fr MLFB_Key 00001...00018 (U)
    // bei UI_Klasse == 00003 --> HMK_FILTERKLASSE_G120X 00002 fr MLFB_Key 00019 (A)
    // 
    // VT_G120X_M00049_26587
    // HMK_MLFB_KEY_G120X	MLFB14_G120X	HMK_EXT_NETZFILTER_G120X	HMK_MLFB_NETZFILTER_G120X	HMK_VALUE_VALID_G120X
    
    /*
    VT_G120X_M00049_26587	MLFB Externer Netzfilter
    VT_G120X_M00156_26587	ZO Gesamt-Filterklasse	
    VT_G120X_M00157_26587	Ausgangsd., dU/dt- und Sinusfilter		Zusammenspiel andere Komponenten
    nn	VT_G120X_M00158_26587	Tech. Daten Cable Length
    nn	VT_G120X_M00163_26587	Hinweis Default Filterklasse
    */
    
    
    
    // VT_162 Zuord. UI-Filterklasse
    /* UI_FILTERKLASSE_G120X	Filterklasse (integriert)
        00001	ohne			00001				U
        00003	Filter C1 		00001 oder 00002	U/A		MLFB_KEY 00001 bis 00018 == U, 00001 ; fr MLFB_KEY 00019 == A, 00002
        00002	Filter C2		00002 oder 00004	A/C		nicht eindeutig???
        00004	Filter C3		00004				C
    */
    
    // ----------------------------
    // bernahme der Daten aus Default-ExtFilter, da sonst Fehler entstehen
    
    var sTable = "VT_G120X_M00162_26587";
    var sTarget = "HMK_EXT_NETZFILTER_G120X";
    var sMLFB_NAME = "HMK_DEF_EXT_FILTER_G120X"; 
    
    var aValidValuesDefaultExtFilter = ECL_GetAllActiveAttributeValues("HMK_DEF_EXT_FILTER_G120X");
    
    if (sCurrentAttribute == "UI_FILTERKLASSE_G120X"){
        var HMK_DEF_EXT_FILTER_G120X = ECL_GetValue("HMK_DEF_EXT_FILTER_G120X");
        ECL_SetValue("HMK_EXT_NETZFILTER_G120X", HMK_DEF_EXT_FILTER_G120X);
        
    }
    
    // ----------------------------
    var sTable = "VT_G120X_M00156_26587";
    // HMK_MLFB_KEY_G120X	MLFB14_G120X	HMK_EXT_NETZFILTER_G120X	HMK_SINUSFILTER_G120X	HMK_FILTERKL_GESAMT_G120X	HMK_HINW_FSC_C3_G120X	HMK_VALUE_VALID_G120X

    var sTargetAttribute = "HMK_EXT_NETZFILTER_G120X";
    
    var MLFB14_G120X = ECL_GetValue("MLFB14_G120X");
    var HMK_SINUSFILTER_G120X = ECL_GetValue("HMK_SINUSFILTER_G120X");
    
    var sWhere = 	"HMK_MLFB_KEY_G120X = '"	+ sMLFB_Key				 + "' AND " +
                    "MLFB14_G120X = '" 			+ MLFB14_G120X  + "' AND " +
                    "HMK_SINUSFILTER_G120X = '" + HMK_SINUSFILTER_G120X + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
//	var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_EXT_G120X") + " "; 
    }
    
    // ----------------------------
    var sTable = "VT_G120X_M00049_26587";
    // HMK_MLFB_KEY_G120X	MLFB14_G120X	HMK_EXT_NETZFILTER_G120X	HMK_MLFB_NETZFILTER_G120X	HMK_VALUE_VALID_G120X
    
    var sTargetAttribute = "HMK_EXT_NETZFILTER_G120X";
    
    var UI_FILTERKLASSE_G120X = ECL_GetValue("UI_FILTERKLASSE_G120X");
    var HMK_FILTERKLASSE_G120X = ECL_GetValue("HMK_FILTERKLASSE_G120X");
    
    var sWhere = 	"HMK_MLFB_KEY_G120X = '"	+ sMLFB_Key				 + "' AND " +
                    "MLFB14_G120X = '" 			+ MLFB14_G120X  + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_EXT_G120X") + " "; 
    }
    // ----------------------------
    var sTable = "VT_G120X_M00157_26587";
    // HMK_A_DROSSEL_G120X	HMK_FILTER_VPL_G120X	HMK_SINUSFILTER_G120X	HMK_EXT_NETZFILTER_G120X	HMK_FUSSN_AUSG_LEIST_G120X	HMK_VALUE_VALID_G120X
    
    var sTargetAttribute = "HMK_EXT_NETZFILTER_G120X";
    
    var HMK_A_DROSSEL_G120X = ECL_GetValue("HMK_A_DROSSEL_G120X");
    var HMK_FILTER_VPL_G120X = ECL_GetValue("HMK_FILTER_VPL_G120X");
    var HMK_SINUSFILTER_G120X = ECL_GetValue("HMK_SINUSFILTER_G120X");
    
    var sWhere = 	"HMK_A_DROSSEL_G120X = '"	+ HMK_A_DROSSEL_G120X 	+ "' AND " +
                    "HMK_FILTER_VPL_G120X = '" 	+ HMK_FILTER_VPL_G120X  + "' AND " +
                    "HMK_SINUSFILTER_G120X = '" + HMK_SINUSFILTER_G120X + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_EXT_G120X") + " "; 
    }
    // ----------------------------

    // Stckliste
    var sFilterExtern = ECL_GetValue("HMK_EXT_NETZFILTER_G120X");
    if (sFilterExtern == "00003" || sFilterExtern == "00004")
    {
        //HMK_MLFB_KEY_G120X	MLFB14_G120X	HMK_EXT_NETZFILTER_G120X	HMK_MLFB_NETZFILTER_G120X	HMK_VALUE_VALID_G120X
        var sSQL = "SELECT HMK_MLFB_NETZFILTER_G120X FROM VT_G120X_M00049_26587 WHERE " +
                    "HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND " +
                    "MLFB14_G120X = '" + sMLFB14 + "' AND " +
                    "HMK_EXT_NETZFILTER_G120X = '" + sFilterExtern + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00049_26587_BOM");
        if (aResult.length > 0){
            var sMLFB_ExternalFilter = aResult[0].HMK_MLFB_NETZFILTER_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== ""){
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_ExternalFilter;
            }else{
                sECSI_MLFB_SEC = sMLFB_ExternalFilter;
            }
        }else{
            //Fehler, Kein Ergebnis fr externen Netzfilter in DB.
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_EXT_G120X") + " "; 
        }
    }
    // ---------------------------------------------------------------------------------
    // CONSEQUENSES
    // ---------------------------------------------------------------------------------
    // ExternalFilterType
    /*	todo
    0	No external line filter selected
    1	External line filter C1
    2	External line filter C2
    3	External line filter C3
    */
    switch (HMK_EXT_NETZFILTER_G120X){
        case "00001": // ohne
            var ExternalFilterType = "0";
        break;
        case "00003":
            var ExternalFilterType = "3";// Klasse B Klren!!! todo
        break;
        case "00004":
            var ExternalFilterType = "2";// Klasse C2 
        break;
        default:
            var ExternalFilterType = "0";
    }
    ECL_SetValue("ECSI_CC_ExternalFilterType", ExternalFilterType);
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
    // Gesamtfilterklasse bestimmen
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // HMK_FILTERKL_GESAMT_G120X 
    /* aus VT_G120X_M00156_26587
        HMK_MLFB_KEY_G120X	MLFB14_G120X	HMK_EXT_NETZFILTER_G120X	HMK_SINUSFILTER_G120X	HMK_FILTERKL_GESAMT_G120X	HMK_HINW_FSC_C3_G120X	HMK_VALUE_VALID_G120X
    */
    var HMK_EXT_NETZFILTER_G120X = ECL_GetValue("HMK_EXT_NETZFILTER_G120X");
    var HMK_SINUSFILTER_G120X = ECL_GetValue("HMK_SINUSFILTER_G120X");
    
    var sSQL = "SELECT HMK_FILTERKL_GESAMT_G120X FROM VT_G120X_M00156_26587 WHERE " +
                "HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND " +
                "MLFB14_G120X = '" + sMLFB14 + "' AND " +
                "HMK_EXT_NETZFILTER_G120X = '" + HMK_EXT_NETZFILTER_G120X + "' AND " +
                "HMK_SINUSFILTER_G120X = '" + HMK_SINUSFILTER_G120X + "' AND " +
                "HMK_VALUE_VALID_G120X = 'T';"; 
                
    var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00156_26587");
    if (aResult.length > 0){
        var HMK_FILTERKL_GESAMT_G120X = aResult[0].HMK_FILTERKL_GESAMT_G120X;
        ECL_SetValue("HMK_FILTERKL_GESAMT_G120X", HMK_FILTERKL_GESAMT_G120X);
    }else{
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___GESAMTFILTER_UNDEFINED_G120X") + " "; 
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // UI-FilterMerkmal bestimmen, wenn Ext-Netzfilter gendert
    /* VT_G120X_M00162_26587
        UI_FILTERKLASSE_G120X	HMK_FILTERKLASSE_G120X	HMK_MLFB_KEY_G120X	HMK_DEF_EXT_FILTER_G120X	HMK_VALUE_VALID_G120X
    */
    if (sCurrentAttribute == "HMK_EXT_NETZFILTER_G120X"){
        var HMK_FILTERKLASSE_G120X = ECL_GetValue("HMK_FILTERKLASSE_G120X");
        var HMK_EXT_NETZFILTER_G120X = ECL_GetValue("HMK_EXT_NETZFILTER_G120X");
        
        var sSQL = "SELECT UI_FILTERKLASSE_G120X FROM VT_G120X_M00162_26587 WHERE " +
                "HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND " +
                "HMK_FILTERKLASSE_G120X = '" + HMK_FILTERKLASSE_G120X + "' AND " +
                "HMK_DEF_EXT_FILTER_G120X = '" + HMK_EXT_NETZFILTER_G120X + "' AND " +
                "HMK_VALUE_VALID_G120X = 'T';"; 
                
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00162_26587_CHNG");
        if (aResult.length > 0){
            var UI_FILTERKLASSE_G120X = aResult[0].UI_FILTERKLASSE_G120X;
            ECL_SetValue("UI_FILTERKLASSE_G120X", UI_FILTERKLASSE_G120X);
        }else{
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_G120X") + " "; 
        }
    }
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    var OutputReactorOrFilter = "";
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Sinusfilter
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // weitere Einschrnkung durch MLFB_KEY
    // HMK_MLFB_KEY_G120X	HMK_SINUSFILTER_G120X	HMK_MLFB_SINUSFILTER_G120X	HMK_HINW_SINUSFILTER_G120X HMK_VALUE_VALID_G120X
    
    // ----------------------------
    var sTable = "VT_G120X_M00157_26587";
    // HMK_A_DROSSEL_G120X	HMK_FILTER_VPL_G120X	HMK_SINUSFILTER_G120X	HMK_EXT_NETZFILTER_G120X	HMK_FUSSN_AUSG_LEIST_G120X	HMK_VALUE_VALID_G120X
    
    var sTargetAttribute = "HMK_SINUSFILTER_G120X";
    
    var HMK_A_DROSSEL_G120X = ECL_GetValue("HMK_A_DROSSEL_G120X");
    var HMK_FILTER_VPL_G120X = ECL_GetValue("HMK_FILTER_VPL_G120X");
    var HMK_EXT_NETZFILTER_G120X = ECL_GetValue("HMK_EXT_NETZFILTER_G120X");
    
    var sWhere = 	"HMK_A_DROSSEL_G120X = '"	+ HMK_A_DROSSEL_G120X 	+ "' AND " +
                    "HMK_FILTER_VPL_G120X = '" 	+ HMK_FILTER_VPL_G120X  + "' AND " +
                    "HMK_EXT_NETZFILTER_G120X = '" + HMK_EXT_NETZFILTER_G120X + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_SINUS_G120X") + " "; 
    }
    // ------------------------------------------------------------------------------------------------------------------
    var sTable = "VT_G120X_M00155_26587";
    // HMK_MLFB_KEY_G120X	HMK_SINUSFILTER_G120X	HMK_MLFB_SINUSFILTER_G120X	HMK_HINW_SINUSFILTER_G120X HMK_VALUE_VALID_G120X
    var sTargetAttribute = "HMK_SINUSFILTER_G120X";
    
    var sWhere = 	"HMK_MLFB_KEY_G120X = '"	+ sMLFB_Key 	+ "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_SINUS_G120X") + " "; 
    }
    // ------------------------------------------------------------------------------------------------------------------
    // Stckliste
    if (ECL_ValueActive("HMK_SINUSFILTER_G120X", "T"))
    {
        // Whlbar
        if (ECL_GetValue("HMK_SINUSFILTER_G120X") == "T")
        {
            var sSQL = "SELECT * FROM VT_G120X_M00155_26587 WHERE HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND HMK_SINUSFILTER_G120X = 'T' AND HMK_VALUE_VALID_G120X = 'T';"; 
            var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00155_26587");
            if (aResult.length > 0)
            {
                var sMLFB_SINUS = aResult[0].HMK_MLFB_SINUSFILTER_G120X;
                var HMK_HINW_SINUSFILTER_G120X = aResult[0].HMK_HINW_SINUSFILTER_G120X;
                //ECL_SetValue("HMK_HINW_SINUSFILTER_G120X", HMK_HINW_SINUSFILTER_G120X);
                if (HMK_HINW_SINUSFILTER_G120X == "OHNE"){
                    ECL_SetValue("HMK_HINW_SINUSFILTER_G120X", HMK_HINW_SINUSFILTER_G120X);
                    ECL_DeactivateAttribute("HMK_HINW_SINUSFILTER_G120X");
                }else{
                    ECL_ActivateAttribute("HMK_HINW_SINUSFILTER_G120X");
                    ECL_DeactivateAllAttributeValues("HMK_HINW_SINUSFILTER_G120X");
                    ECL_ActivateValue("HMK_HINW_SINUSFILTER_G120X", HMK_HINW_SINUSFILTER_G120X);
                    ECL_SetValue("HMK_HINW_SINUSFILTER_G120X", HMK_HINW_SINUSFILTER_G120X);
                   ECL_DisableAttribute("HMK_HINW_SINUSFILTER_G120X");
                }
                // Sekundr-MLFB Eintrag
                if (sECSI_MLFB_SEC !== "")
                {
                    sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_SINUS;
                }else{
                    sECSI_MLFB_SEC = sMLFB_SINUS;
                }
                OutputReactorOrFilter = sMLFB_SINUS;
            }
        }else{
            ECL_SetValue("HMK_HINW_SINUSFILTER_G120X", "OHNE");
            ECL_DeactivateAttribute("HMK_HINW_SINUSFILTER_G120X");
        }
    }else{
        ECL_DeactivateValue("HMK_SINUSFILTER_G120X", "T");
        ECL_SetValue("HMK_HINW_SINUSFILTER_G120X", "OHNE");
        ECL_DeactivateAttribute("HMK_HINW_SINUSFILTER_G120X");
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Ausgangsdrossel			VT_G120X_M00051_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // weitere Einschrnkung durch MLFB_KEY
    // ----------------------------
    var sTable = "VT_G120X_M00157_26587";
    // HMK_A_DROSSEL_G120X	HMK_FILTER_VPL_G120X	HMK_SINUSFILTER_G120X	HMK_EXT_NETZFILTER_G120X	HMK_FUSSN_AUSG_LEIST_G120X	HMK_VALUE_VALID_G120X
    
    var sTargetAttribute = "HMK_A_DROSSEL_G120X";
    
    var HMK_SINUSFILTER_G120X = ECL_GetValue("HMK_SINUSFILTER_G120X");
    var HMK_FILTER_VPL_G120X = ECL_GetValue("HMK_FILTER_VPL_G120X");
    var HMK_EXT_NETZFILTER_G120X = ECL_GetValue("HMK_EXT_NETZFILTER_G120X");
    
    var sWhere = 	"HMK_SINUSFILTER_G120X = '"	+ HMK_SINUSFILTER_G120X + "' AND " +
                    "HMK_FILTER_VPL_G120X = '" 	+ HMK_FILTER_VPL_G120X  + "' AND " +
                    "HMK_EXT_NETZFILTER_G120X = '" + HMK_EXT_NETZFILTER_G120X + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_A_DROSSEL_G120X") + " "; 
    }
    // ------------------------------------------------------------------------------------------------------------------
    var sTable = "VT_G120X_M00051_26587";
    // HMK_MLFB_KEY_G120X	HMK_A_DROSSEL_G120X	HMK_MLFB_A_DROSSEL_G120X	HMK_VALUE_VALID_G120X
    var sTargetAttribute = "HMK_A_DROSSEL_G120X";
    
    var sWhere = 	"HMK_MLFB_KEY_G120X = '"	+ sMLFB_Key 	+ "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_A_DROSSEL_G120X") + " "; 
    }
    // ------------------------------------------------------------------------------------------------------------------
    // Stckliste
    if (ECL_GetValue("HMK_A_DROSSEL_G120X") == "T")
    {
        var sSQL = "SELECT * FROM VT_G120X_M00051_26587 WHERE HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND HMK_A_DROSSEL_G120X = 'T' AND HMK_VALUE_VALID_G120X = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00051_26587");
        if (aResult.length > 0)
        {
            var sMLFB_A_DROSSEL = aResult[0].HMK_MLFB_A_DROSSEL_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_A_DROSSEL;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_A_DROSSEL;
            }
            OutputReactorOrFilter = sMLFB_A_DROSSEL;
        }
    }
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Du/dt-Filter				VT_G120X_M00052_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // weitere Einschrnkung durch MLFB_KEY
    var sTable = "VT_G120X_M00157_26587";
    // HMK_A_DROSSEL_G120X	HMK_FILTER_VPL_G120X	HMK_SINUSFILTER_G120X	HMK_EXT_NETZFILTER_G120X	HMK_FUSSN_AUSG_LEIST_G120X	HMK_VALUE_VALID_G120X
    
    var sTargetAttribute = "HMK_FILTER_VPL_G120X";
    
    var HMK_SINUSFILTER_G120X = ECL_GetValue("HMK_SINUSFILTER_G120X");
    var HMK_FILTER_VPL_G120X = ECL_GetValue("HMK_FILTER_VPL_G120X");
    var HMK_EXT_NETZFILTER_G120X = ECL_GetValue("HMK_EXT_NETZFILTER_G120X");
    
    var sWhere = 	"HMK_SINUSFILTER_G120X = '"	+ HMK_SINUSFILTER_G120X 	+ "' AND " +
                    "HMK_A_DROSSEL_G120X = '" 	+ HMK_A_DROSSEL_G120X  + "' AND " +
                    "HMK_EXT_NETZFILTER_G120X = '" + HMK_EXT_NETZFILTER_G120X + "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_VPL_G120X") + " "; 
    }
    // ------------------------------------------------------------------------------------------------------------------
    var sTable = "VT_G120X_M00052_26587";
    // HMK_MLFB_KEY_G120X	HMK_FILTER_VPL_G120X	HMK_MLFB_FIL_VPL_G120X	HMK_VALUE_VALID_G120X
    var sTargetAttribute = "HMK_FILTER_VPL_G120X";
    
    var sWhere = 	"HMK_MLFB_KEY_G120X = '"	+ sMLFB_Key 	+ "' AND " +
                    "HMK_VALUE_VALID_G120X = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        //Fehler
        sECSI_STATUS = "E"; 
        sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___DB_SELECT_FILTER_VPL_G120X") + " "; 
    }
    // ------------------------------------------------------------------------------------------------------------------
    // Stckliste
    if (ECL_GetValue("HMK_FILTER_VPL_G120X") == "T")
    {
        var sSQL = "SELECT * FROM VT_G120X_M00052_26587 WHERE HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND HMK_FILTER_VPL_G120X = 'T' AND HMK_VALUE_VALID_G120X = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00052_26587");
        if (aResult.length > 0)
        {
            var sMLFB_FILTER_VPL = aResult[0].HMK_MLFB_FIL_VPL_G120X;
            
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_FILTER_VPL;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_FILTER_VPL;
            }
            OutputReactorOrFilter = sMLFB_FILTER_VPL;
        }
    }
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Abhngigkeit Sinusfilter - Ausgangsdrossel - Du/dt-Filter | neu einer geht
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // VT_G120X_M00157_26587	Ausgangsd., dU/dt- und Sinusfilter
    // alt:	HMK_A_DROSSEL_G120X	HMK_FILTER_VPL_G120X	HMK_SINUSFILTER_G120X	HMK_VALUE_VALID_G120X
    // neu:	HMK_A_DROSSEL_G120X	HMK_FILTER_VPL_G120X	HMK_SINUSFILTER_G120X	HMK_EXT_NETZFILTER_G120X	HMK_FUSSN_AUSG_LEIST_G120X	HMK_VALUE_VALID_G120X

//	ECL_InferencePositiveMultipleAttributes("VT_G120X_M00157_26587");	// todo VT-Funktion
    
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Sicherung			VT_G120X_M00141_26587
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /* HMK_MLFB_KEY_G120X	HMK_SICHERUNG_G120X	HMK_MLFB_SICHERUNG_G120X	HMK_VALUE_VALID_G120X */
    var aAttributesVT141 = ["HMK_MLFB_KEY_G120X",
                            "HMK_VALUE_VALID_G120X"];
    setValuesFromDatabase("VT_G120X_M00141_26587", "HMK_SICHERUNG_G120X", aAttributesVT141);
    
    // Stckliste
    var sFuse = ECL_GetValue("HMK_SICHERUNG_G120X");
    if ( (sFuse == "00002") || (sFuse == "00003" ) // EU/US 
    ) {
        
        var sSQL = "SELECT * FROM VT_G120X_M00141_26587 WHERE HMK_MLFB_KEY_G120X = '" + sMLFB_Key + "' AND HMK_SICHERUNG_G120X = '" + sFuse + "' AND HMK_VALUE_VALID_G120X = 'T';"; 
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00141_26587");
        if (aResult.length > 0)
        {
            var sMLFB_Sicherung = aResult[0].HMK_MLFB_SICHERUNG_G120X;
            var HMK_ANZ_SICHERUNG_G120X = aResult[0].HMK_ANZ_SICHERUNG_G120X;
            ECL_SelectValue("HMK_ANZ_SICHERUNG_G120X", HMK_ANZ_SICHERUNG_G120X);
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_Sicherung + ";" + sMLFB_Sicherung + ";" + sMLFB_Sicherung;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_Sicherung + ";" + sMLFB_Sicherung + ";" + sMLFB_Sicherung;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___FUSE_MLFB_G120X") + " "; 
        }
    }
    else
    {
        ECL_SelectValue("HMK_ANZ_SICHERUNG_G120X", 0);
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Line Harmonics Filter			VT_G120X_M00114_26587	MLFB 
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // nur Whlbar, wenn Spannung 380, 400 oder 415V und 50Hz (Bei derzeitiger Auswahl im TST (siehe StandardSupplySystem) Class E und 50Hz
    // HMK_MLFB_KEY_G120X	HMK_NETZSPANNUNG_G120X	HMK_NETZFREQUENZ_G120X	HMK_LINE_HARMONICS_G120X	HMK_MLFB_LINE_HARMON_G120X	HMK_ANZ_LINE_HARMONI_G120X	HMK_VALUE_VALID_G120X
    var aAttributesVT114 = ["HMK_MLFB_KEY_G120X", 
                        "HMK_NETZSPANNUNG_G120X", 
                        "HMK_NETZFREQUENZ_G120X", 
                        "HMK_VALUE_VALID_G120X"];
    setValuesFromDatabase("VT_G120X_M00114_26587", "HMK_LINE_HARMONICS_G120X", aAttributesVT114);
   
    if (ECL_GetValue("HMK_LINE_HARMONICS_G120X") == "T")
    {
        var sSQL = "SELECT * FROM VT_G120X_M00114_26587 WHERE " +
                        "HMK_LINE_HARMONICS_G120X = 'T' AND " +
                        "HMK_MLFB_KEY_G120X = '" 		+ sMLFB_Key + "' AND " +
                        "HMK_NETZSPANNUNG_G120X = '" 	+ sSpannung + "' AND " +
                        "HMK_NETZFREQUENZ_G120X = '" 	+ sFrequenz + "' AND " +
                        "HMK_VALUE_VALID_G120X = 'T';";
        var aResult = GetDBDataSetEXT(sSQL, "VT_G120X_M00114_26587");
        if (aResult.length > 0)
        {
            var iMengeLineHamonic = parseInt(aResult[0].HMK_ANZ_LINE_HARMONI_G120X);
            ECL_SelectValue("HMK_ANZ_LINE_HARMONI_G120X", iMengeLineHamonic);
            
            //Stckliste
            var sMLFB_LINE_HARMONI = aResult[0].HMK_MLFB_LINE_HARMON_G120X;
            // Menge bercksichtigen
            if (iMengeLineHamonic == 2)
            {
                sMLFB_LINE_HARMONI = sMLFB_LINE_HARMONI + ";" + sMLFB_LINE_HARMONI;
            }
            // Sekundr-MLFB Eintrag
            if (sECSI_MLFB_SEC !== "")
            {
                sECSI_MLFB_SEC = sECSI_MLFB_SEC + ";" + sMLFB_LINE_HARMONI;
            }
            else
            {
                sECSI_MLFB_SEC = sMLFB_LINE_HARMONI;
            }
        }
        else
        {
            // Fehler
            sECSI_STATUS = "E"; 
            sECSI_STATUS_MESSAGE = sECSI_STATUS_MESSAGE + ECL_Translate("DICT1_ERR___LINE_HARMONI_MLFB_G120X") + " "; //"MLFB fr 'Line harmonics filter' nicht bestimmt, kein Treffer in DB. ";
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ---------------------------------------------------------------------------------
    // Filter CONSEQUENCES
    // ---------------------------------------------------------------------------------
    // OutputReactorOrFilterType
    /* Integer
    0	No output reactor or filter selected
    1	Single motor reactor selected
    2	Two motor reactor in series selected
    3	Sinus filter selected
    4	du/dt filter selected
    
    OutputReactorOrFilter
    OutputReactorOrFilter	
    String	
    This parameter defines the order number for a selected output reactor or filter.	
        String.Empty	No output reactor or filter selected
        String			Order number as MLFB without separating "-"

    MLFB 
    
    todo
    */
    var OutputReactorOrFilterType = "0";
    var bLimitOutFrequency = false;
    
    if (ECL_GetValue("HMK_A_DROSSEL_G120X") == "T"){
        OutputReactorOrFilterType = "1";
        bLimitOutFrequency = true;
    }
    
    if (ECL_GetValue("HMK_SINUSFILTER_G120X") == "T"){
        OutputReactorOrFilterType = "3";
        bLimitOutFrequency = true;
    }
    if (ECL_GetValue("HMK_FILTER_VPL_G120X") == "T"){
        OutputReactorOrFilterType = "4";
        bLimitOutFrequency = true;
    }
    
    // MaxOutputFrequencyLimit
    var MaxOutputFrequencyLimit = "";
    var MaxPulseFrequency = "";
    var MinPulseFrequency = "";
    
    var converterRatedPower = ECL_GetValue("ECSI_CX_ConverterRatedPower");
	if (bLimitOutFrequency){
        MaxOutputFrequencyLimit = "150";
        if(converterRatedPower <= 90)
        {
            MinPulseFrequency = "";
            MaxPulseFrequency = "8";
        }
        else if (90 < converterRatedPower)
        {
            MinPulseFrequency = "4";
            MaxPulseFrequency = "4";
        }
    }

    if (ECL_GetValue("HMK_FILTER_VPL_G120X") == "T" || ECL_GetValue("HMK_A_DROSSEL_G120X") == "T") MinPulseFrequency = "";

    ECL_SetValue("ECSI_CC_MinPulseFrequency", MinPulseFrequency);
    ECL_SetValue("ECSI_CC_MaxOutputFrequencyLimit", MaxOutputFrequencyLimit);
    ECL_SetValue("ECSI_CC_MaxPulseFrequency", MaxPulseFrequency);
    ECL_SetValue("ECSI_CC_OutputReactorOrFilterType", OutputReactorOrFilterType);
    ECL_SetValue("ECSI_CC_OutputReactorOrFilter", OutputReactorOrFilter);
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Schutzart - Consequence 		sSchutzart = ECL_GetValue("PMD_ABJ176_001_000_G120");		
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /*
    IpProtectionLevelFrequencyConverter	
    Integer	
    This parameter define the IP protection level of the complete frequency converter solution.	
    0|20|21|22|23|41|42|43|54|55|56|64|65|66|67	
    Integer value of the protection level ("0" for "IP00" or "54" for "IP54")

    */
    var sIP = sECSI_MLFB.charAt(6); // MLFB07
    //var aValidValues06 = ["0", "5"]; // 
    var sIP_CC = "0";
    if (sIP == "0") 
    {
        var sIP_CC = "20";
    }
    
    ECL_SetValue("ECSI_CC_IpProtectionLevelFrequencyConverter", sIP_CC);
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    var HMK_MLFB_11_12_G120X = ECL_GetValue("HMK_MLFB_11_12_G120X");
    if (HMK_MLFB_11_12_G120X === "56") {
        // ECL_DeactivateValue("HMK_BEDIENEINHEIT_G120X", "00003");
        ECL_DeactivateValue("HMK_UMGEBUNGSBED_G120X", "C3");
        
    }

    
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // DCP/DCN 												Aktivierung, wenn freigegeben
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/*	if (ECL_ValueSelected("CB_DCP_G120X", "T"){
        var sMLFB16 = "6";
    }else{
        var sMLFB16 = "0";
    }
    sECSI_MLFB = replaceAt(sECSI_MLFB, 15, sMLFB16);
    
    ECL_SetValue("ECSI_MLFB", sECSI_MLFB);
*/	
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ## ENDE LOGIK #################################################################################################################################################################
    // ## ENDE LOGIK #################################################################################################################################################################
    // ## ENDE LOGIK #################################################################################################################################################################
    
    // #########################################################################################################################
    // bertragung der Logik in UI-Checkbox-Attribute:
    // #########################################################################################################################
    setCheckBoxAttributes();
    // #########################################################################################################################
    
    
    // ###############################################################################################################
    // Zustzliche MLFBs setzen
    // ###############################################################################################################
    SetMlfbSec(sECSI_MLFB_SEC);
    // ###############################################################################################################
    
    // ###############################################################################################################
    // Fehlerstatus setzen
    // ###############################################################################################################
    if ( !(sECSI_STATUS == "E")
    ) {
        sECSI_STATUS = "OK";
    }
    // bergabestatus setzen
    ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
    ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);
    // ###############################################################################################################
    
    
    // ###############################################################################################################
    // Anzeigestatus Info-Merkmale
    // ###############################################################################################################
    //ECL_DeactivateAttribute(""); // 
    //ECL_DeactivateAttribute(""); // 
   ECL_DisableAttribute("HMK_ANZAHL_PHASEN_G120X");
   ECL_DisableAttribute("HMK_NETZSPANNUNG_G120X");
   ECL_DisableAttribute("HMK_NETZFREQUENZ_G120X");
    ECL_DeactivateAttribute("PMD_ABJ176_001_000_G120X");	//Schutzart IP
   ECL_DisableAttribute("HMK_SCHUTZART_G120X");			//Schutzart IP
   ECL_DisableAttribute("HMK_BAUFORM_G120X");				//Bauform
   ECL_DisableAttribute("HMK_FILTERKL_GESAMT_G120X");		//Gesamt-Filterklasse
    //ECL_DeactivateAttribute("PMD_ABW171_001_000_G120X");	//Bauform
    
    if (sECSI_MLFB_BASE_TYPE.charAt(5) == "."){
        ECL_EnableAttribute("HMK_UMGEBUNGSBED_G120X");
    } else{
       ECL_DisableAttribute("HMK_UMGEBUNGSBED_G120X");			//Standard Umweltbedingungen
    }
    
   ECL_DisableAttribute("HMK_MOTORNORM_G120X");			//
    
    
    //ECL_DeactivateAttribute("HMK_UEBERLAST_G120X");		//
    
    //ECL_DisableAttribute("HMK_KOMMUNIKATION_G120X");		//Kommunikation /Bus
    //ECL_DisableAttribute("HMK_ANZ_LINE_HARMONI_G120X");	//
    //ECL_DisableAttribute("HMK_ANZ_SICHERUNG_G120X");		//
    if (sECSI_MLFB_BASE_TYPE.charAt(13) != "."){
       ECL_DisableAttribute("UI_FILTERKLASSE_G120X");
    }else{
        ECL_EnableAttribute("UI_FILTERKLASSE_G120X");
    }
    // ###############################################################################################################
    ECL_DeactivateAttribute("HMK_PRODUKT_TRIG_G120X"); //  
    ECL_DeactivateAttribute("HMK_VALUE_VALID_G120X"); //
    
    ECL_DeactivateAttribute("HMK_FILTERKLASSE_G120X");			// UI-Merkmal ist UI_FILTERKLASSE_G120X
    ECL_DeactivateAttribute("HMK_DEF_EXT_FILTER_G120X");		// Default fr externen Filter
    
    ECL_DeactivateAttribute("HMK_MLFB_KEY_G120X"); // 
    ECL_DeactivateAttribute("MLFB06_G120X"); // 
    ECL_DeactivateAttribute("MLFB07_G120X"); // 
    ECL_DeactivateAttribute("MLFB08_G120X"); // 
    ECL_DeactivateAttribute("MLFB10_G120X"); // 
    ECL_DeactivateAttribute("MLFB11_G120X"); // 
    ECL_DeactivateAttribute("MLFB12_G120X"); // 
    ECL_DeactivateAttribute("HMK_MLFB_11_12_G120X"); // 
    ECL_DeactivateAttribute("MLFB13_G120X"); // 
    ECL_DeactivateAttribute("MLFB14_G120X"); // 
    ECL_DeactivateAttribute("MLFB15_G120X"); // 
    ECL_DeactivateAttribute("PMD_ABJ176_001_000_G120X"); // IP-Schutzklasse
    ECL_DeactivateAttribute("PMD_ABW171_001_000_G120X"); // Bauform
    
    ECL_DeactivateAttribute("HMK_ANZ_LINE_HARMONI_G120X"); // 
    ECL_DeactivateAttribute("HMK_ANZ_SICHERUNG_G120X"); // 
    
    // ###############################################################################################################
    // Checkbox-Attribute deaktivieren
    
    ECL_DeactivateAttribute("HMK_SPEICHERKARTE_G120X");
    ECL_DeactivateAttribute("HMK_SMART_ACCESS_G120X");
    ECL_DeactivateAttribute("HMK_IO_EXT_G120X");
    ECL_DeactivateAttribute("HMK_IOPHANDHELD_G120X");
    ECL_DeactivateAttribute("HMK_TUERMONTAGE_G120X");
    ECL_DeactivateAttribute("HMK_IP21_TOP_COVER_G120X");
    ECL_DeactivateAttribute("HMK_PUSH_THROUGH_G120X");
    ECL_DeactivateAttribute("HMK_LINE_HARMONICS_G120X");
    ECL_DeactivateAttribute("HMK_NETZDROSSEL_G120X");
    ECL_DeactivateAttribute("HMK_A_DROSSEL_G120X");
    ECL_DeactivateAttribute("HMK_FILTER_VPL_G120X");
    ECL_DeactivateAttribute("HMK_SINUSFILTER_G120X");
    ECL_DeactivateAttribute("HMK_CONNECT_300_G120X");
    ECL_DeactivateAttribute("HMK_ADAPTER_SET_G120X");
    // todo deactivate-delesect options if motortechnology isnt 0

    var motorTechnology = ECL_GetValue("ECSI_CX_MotorTechnology");
    if(motorTechnology == "1" || motorTechnology == "2")
    {
        //UI_A_DROSSEL_G120X (deselect)
        //HMK_A_DROSSEL_G120X (F)
        ECL_DeselectValue("UI_A_DROSSEL_G120X", "T");
        ECL_SetValue("HMK_A_DROSSEL_G120X", "F");
        ECL_DeactivateAttribute("UI_A_DROSSEL_G120X");
        ECL_DeactivateAttribute("HMK_A_DROSSEL_G120X");

        //UI_FILTER_VPL_G120X (deselect)
        //HMK_FILTER_VPL_G120X(F)
        ECL_DeselectValue("UI_FILTER_VPL_G120X", "T");
        ECL_SetValue("HMK_FILTER_VPL_G120X", "F");
        ECL_DeactivateAttribute("UI_FILTER_VPL_G120X");
        ECL_DeactivateAttribute("HMK_FILTER_VPL_G120X");
        
        //UI_SINUSFILTER_G120X (deselect)
        //HMK_SINUSFILTER_G120X (F)
        ECL_DeselectValue("UI_SINUSFILTER_G120X", "T");
        ECL_SetValue("HMK_SINUSFILTER_G120X", "F");
        ECL_DeactivateAttribute("UI_SINUSFILTER_G120X");
        ECL_DeactivateAttribute("HMK_SINUSFILTER_G120X");
    }
    
    
    // ## ENDE #################################################################################################################################################################
}


//------------------------------------------------------------------------------------------------------------------------------
// Funktionen
//------------------------------------------------------------------------------------------------------------------------------

function replaceAt(string, index, replace) {
  return string.substring(0, index) + replace + string.substring(index + 1);
}

// n_pos startet bei 0				aus 1FK2
function replaceChar(s_src, s_char, n_pos)
{
  if(s_src.length < n_pos)
    return s_src;
  var s=s_src.left(n_pos) + s_char + s_src.substring(n_pos + 1);
  return s;
}

function GetDBDataSetEXT(sSQL)
{
    return GetDBDataSetEXT(sSQL, null);
}

function GetDBDataSetEXT(sSQL, sDbRequestIdent){

    var  aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);

    return aResult;
}

function ExecSetStandardifValueEmpty(Attribute, strDefault)
{
    var strValue = ECL_GetValue(Attribute);
    if(strValue == "")
    {
        if(ECL_ValueActive(Attribute, strDefault))
        {
            ECL_SelectValue(Attribute, strDefault);
            return true;
        }
        else
        {
            var aselection = ECL_GetAllActiveAttributeValues(Attribute);
            if(aselection.length > 0 )
            {
                ECL_SelectValue(Attribute, aselection[0]);
                return true;
            }
        }
    }
    else
    {
        var aselection = ECL_GetAllActiveAttributeValues(Attribute);
        
        if(aselection.length > 0)
        {
            for(var i=0;i<aselection.length;i++)
            {	
                if(strValue == aselection[i])
                    return true;
            }
        }
        
        if(ECL_ValueActive(Attribute, strDefault))
        {
            ECL_SelectValue(Attribute, strDefault);
            return true;
        }
        else
        {
            var aselection = ECL_GetAllActiveAttributeValues(Attribute);
            if(aselection.length > 0)
            {
                ECL_SelectValue(Attribute, aselection[0]);
                return true;
            }
        }
        
    }
}

function intersect(a, b) {
    var d = {};
    var results = [];
    for (var i = 0; i < b.length; i++) {
        d[b[i]] = true;
    }
    for (var j = 0; j < a.length; j++) {
        if (d[a[j]]) 
            results.push(a[j]);
    }
    return results;
}



/*
Checkbox-Attribute

UI_SPEICHERKARTE_G120X		T		
HMK_SPEICHERKARTE_G120X		LEER,	Ohne

UI_SMART_ACCESS_G120X
HMK_SMART_ACCESS_G120X	T/F

UI_IO_EXT_G120X
HMK_IO_EXT_G120X	T/F

UI_CONNECT_300_G120X
HMK_CONNECT_300_G120X	T/F

UI_IOPHANDHELD_G120X
HMK_IOPHANDHELD_G120X	T/F

UI_TUERMONTAGE_G120X
HMK_TUERMONTAGE_G120X	T/F

UI_IP21_TOP_COVER_G120X
HMK_IP21_TOP_COVER_G120X	T/F

UI_PUSH_THROUGH_G120X
HMK_PUSH_THROUGH_G120X	T/F

UI_ADAPTER_SET_G120X
HMK_ADAPTER_SET_G120X	T/F

UI_LINE_HARMONICS_G120X
HMK_LINE_HARMONICS_G120X	T/F

UI_NETZDROSSEL_G120X
HMK_NETZDROSSEL_G120X	T/F

UI_A_DROSSEL_G120X
HMK_A_DROSSEL_G120X	T/F

UI_FILTER_VPL_G120X
HMK_FILTER_VPL_G120X	T/F

UI_SINUSFILTER_G120X
HMK_SINUSFILTER_G120X	T/F
*/

function getCheckBoxAttributes(strChangedAttribute)
{
    switch (strChangedAttribute){
        case "UI_SPEICHERKARTE_G120X":
            // HMK_SPEICHERKARTE_G120X		
            setAttributeFromUICheckbox("HMK_SPEICHERKARTE_G120X", "UI_SPEICHERKARTE_G120X", "LEER", "OHNE");
        break;
        case "UI_SMART_ACCESS_G120X":
            // HMK_SMART_ACCESS_G120X		Webservermodul
            setAttributeFromUICheckbox("HMK_SMART_ACCESS_G120X", "UI_SMART_ACCESS_G120X", "T", "F");
        break;
        case "UI_IO_EXT_G120X":
            // HMK_IO_EXT_G120X		
            setAttributeFromUICheckbox("HMK_IO_EXT_G120X", "UI_IO_EXT_G120X", "T", "F");
        break;
        case "UI_CONNECT_300_G120X":
            // HMK_CONNECT_300_G120X		
            setAttributeFromUICheckbox("HMK_CONNECT_300_G120X", "UI_CONNECT_300_G120X", "T", "F");
        break;
        case "UI_IOPHANDHELD_G120X":
            // HMK_IOPHANDHELD_G120X		IOP-2 Handheld
            setAttributeFromUICheckbox("HMK_IOPHANDHELD_G120X", "UI_IOPHANDHELD_G120X", "T", "F");
        break;
        case "UI_TUERMONTAGE_G120X":
            // HMK_TUERMONTAGE_G120X		Trmontagesatz fr IOP-2/BOP-2
            setAttributeFromUICheckbox("HMK_TUERMONTAGE_G120X", "UI_TUERMONTAGE_G120X", "T", "F");
        break;
        case "UI_IP21_TOP_COVER_G120X":
            // HMK_IP21_TOP_COVER_G120X		
            setAttributeFromUICheckbox("HMK_IP21_TOP_COVER_G120X", "UI_IP21_TOP_COVER_G120X", "T", "F");
        break;
        case "UI_PUSH_THROUGH_G120X":
            // HMK_PUSH_THROUGH_G120X		
            setAttributeFromUICheckbox("HMK_PUSH_THROUGH_G120X", "UI_PUSH_THROUGH_G120X", "T", "F");
        break;
        case "UI_ADAPTER_SET_G120X":
            // HMK_ADAPTER_SET_G120X		
            setAttributeFromUICheckbox("HMK_ADAPTER_SET_G120X", "UI_ADAPTER_SET_G120X", "T", "F");
        break;
        case "UI_LINE_HARMONICS_G120X":
            // HMK_LINE_HARMONICS_G120X		
            setAttributeFromUICheckbox("HMK_LINE_HARMONICS_G120X", "UI_LINE_HARMONICS_G120X", "T", "F");
        break;
        case "UI_NETZDROSSEL_G120X":
            // HMK_NETZDROSSEL_G120X		Netzdrossel
            setAttributeFromUICheckbox("HMK_NETZDROSSEL_G120X", "UI_NETZDROSSEL_G120X", "T", "F");
        break;
        case "UI_A_DROSSEL_G120X":
            // HMK_A_DROSSEL_G120X		Ausgangsdrossel
            setAttributeFromUICheckbox("HMK_A_DROSSEL_G120X", "UI_A_DROSSEL_G120X", "T", "F");
        break;
        case "UI_FILTER_VPL_G120X":
            // HMK_FILTER_VPL_G120X		Du/dt-Filter plus VPL
            setAttributeFromUICheckbox("HMK_FILTER_VPL_G120X", "UI_FILTER_VPL_G120X", "T", "F");
        break;
        case "UI_SINUSFILTER_G120X":
            // HMK_SINUSFILTER_G120X		Sinusfilter
            setAttributeFromUICheckbox("HMK_SINUSFILTER_G120X", "UI_SINUSFILTER_G120X", "T", "F");
        break;
    }
}
function setCheckBoxAttributes()
{
    // HMK_SPEICHERKARTE_G120X		
    setProductLogicToUIAttribute("HMK_SPEICHERKARTE_G120X", "UI_SPEICHERKARTE_G120X", "LEER", "OHNE");

    // HMK_SMART_ACCESS_G120X		Webservermodul
    setProductLogicToUIAttribute("HMK_SMART_ACCESS_G120X", "UI_SMART_ACCESS_G120X", "T", "F");

    // HMK_IO_EXT_G120X		
    setProductLogicToUIAttribute("HMK_IO_EXT_G120X", "UI_IO_EXT_G120X", "T", "F");

    // HMK_CONNECT_300_G120X		
    setProductLogicToUIAttribute("HMK_CONNECT_300_G120X", "UI_CONNECT_300_G120X", "T", "F");
    
    // HMK_IOPHANDHELD_G120X		IOP-2 Handheld
    setProductLogicToUIAttribute("HMK_IOPHANDHELD_G120X", "UI_IOPHANDHELD_G120X", "T", "F");

    // HMK_TUERMONTAGE_G120X		Trmontagesatz fr IOP-2/BOP-2
    setProductLogicToUIAttribute("HMK_TUERMONTAGE_G120X", "UI_TUERMONTAGE_G120X", "T", "F");

    // HMK_IP21_TOP_COVER_G120X		
    setProductLogicToUIAttribute("HMK_IP21_TOP_COVER_G120X", "UI_IP21_TOP_COVER_G120X", "T", "F");

    // HMK_PUSH_THROUGH_G120X		
    setProductLogicToUIAttribute("HMK_PUSH_THROUGH_G120X", "UI_PUSH_THROUGH_G120X", "T", "F");

    // HMK_ADAPTER_SET_G120X		
    setProductLogicToUIAttribute("HMK_ADAPTER_SET_G120X", "UI_ADAPTER_SET_G120X", "T", "F");

    // HMK_LINE_HARMONICS_G120X		
    setProductLogicToUIAttribute("HMK_LINE_HARMONICS_G120X", "UI_LINE_HARMONICS_G120X", "T", "F");

    // HMK_NETZDROSSEL_G120X		Netzdrossel
    setProductLogicToUIAttribute("HMK_NETZDROSSEL_G120X", "UI_NETZDROSSEL_G120X", "T", "F");

    // HMK_A_DROSSEL_G120X		Ausgangsdrossel
    setProductLogicToUIAttribute("HMK_A_DROSSEL_G120X", "UI_A_DROSSEL_G120X", "T", "F");

    // HMK_FILTER_VPL_G120X		Du/dt-Filter plus VPL
    setProductLogicToUIAttribute("HMK_FILTER_VPL_G120X", "UI_FILTER_VPL_G120X", "T", "F");

    // UI_SINUSFILTER_G120X		Sinusfilter
    setProductLogicToUIAttribute("HMK_SINUSFILTER_G120X", "UI_SINUSFILTER_G120X", "T", "F");
    
}

/**
Funktion zur bertragung des Logik-Auswahl-Zustandes eines Attributes (eingeschrnkt durch Produktlogik) auf ein UI-Checkbox Attribut.

*/
function setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute)
{
    return setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute, "T", "F");
}
function setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute, sValue_True, sValue_False)
{
    sVal_True  = sValue_True  || "T";
    sVal_False = sValue_False || "F";
    
    var aValidValues = ECL_GetAllActiveAttributeValues(sOrg_Attribute);
    var bValue_T_valid = false;
    var bValue_F_valid = false;
    
    if (aValidValues.length > 0){
        for (var i=0; i < aValidValues.length; i++){
            if (aValidValues[i] == sVal_True){
                bValue_T_valid = true;
            }
            if (aValidValues[i] == sVal_False){
                bValue_F_valid = true;
            }
        }
        
        if (bValue_T_valid && bValue_F_valid){
            ECL_EnableAttribute(sUI_Attribute);
            var sValue = ECL_GetValue(sOrg_Attribute);
            if (sValue == sVal_True){
                ECL_SelectValue(sUI_Attribute, "T");
            }else{
                ECL_DeselectAttribute(sUI_Attribute);
            }
        }
        else if (bValue_T_valid && !bValue_F_valid){
            ECL_SelectValue(sUI_Attribute, "T");
           ECL_DisableAttribute(sUI_Attribute);
        }
        else if (!bValue_T_valid && bValue_F_valid){
            ECL_DeselectAttribute(sUI_Attribute);
           ECL_DisableAttribute(sUI_Attribute);
        }
    }else{
        ECL_DeselectAttribute(sUI_Attribute);
       ECL_DisableAttribute(sUI_Attribute);
        return 0;
    }
    return 1;
}

/**
Funktion zur bertragung des Auswahl-Zustandes eines UI-Checkbox-Attributes auf das Original-Attribut.
sOrg_Attribute:	original Produkt-Attrubut, welches durch die Produktlogik gesteuert wird
sUI_Attribute:	UI-Attribut mit Checkbox, auf welches die Logik gespiegelt wird
sValue_True:	Wert 'Ja' des Original-Attributes, wenn er von "T" abweicht		(optional)
sValue_False:	Wert 'Nein' des Original-Attributes, wenn er von "F" abweicht	(optional)
*/
function setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute)
{
    return setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute, "T", "F");
}
function setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute, sValue_True, sValue_False)
{
    sVal_True  = sValue_True  || "T";
    sVal_False = sValue_False || "F";
    
    if (ECL_ValueSelected(sUI_Attribute, "T")){
        
        if (ECL_ValueEnabled(sOrg_Attribute, sVal_True)) {
            ECL_SetValue(sOrg_Attribute, sVal_True);
            
        }else{
            
            if (ECL_ValueEnabled(sOrg_Attribute, sVal_False)) {
                ECL_SetValue(sOrg_Attribute, sVal_False);
            }
            
            ECL_DeselectAttribute(sUI_Attribute);
           ECL_DisableAttribute(sUI_Attribute);
            return 0;
        }
    }else{
        
        if (ECL_ValueEnabled(sOrg_Attribute, sVal_False)) {
            ECL_SetValue(sOrg_Attribute, sVal_False);
        }else{
            return 0;
        }
    }
    
    return 1;
}


/**
Wertet eine Variantentabelle fr das Zielattribut aus und deaktiviert die nicht gltigen Werte. 
Gltig fr die erste Einschrnkung des Merkmals, weitere Einschrnkungen mit der unteren Funktion.
*/
function SetAttributeLogic1st(sTable, sTargetAttribute, sWhere, sDefault_x)
{
    return SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, false);
}
/**
Wertet eine Variantentabelle fr das Zielattribut aus und deaktiviert die nicht gltigen Werte. 
Gltig fr weitere Einschrnkungen des Merkmals, wenn bereits eine Einschrnkung stattgefunden hat.
*/
function SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere, sDefault_x) // bIntersect = true
{
    return SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, true);
}

function SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, bIntersect)// = true weiter einschrnken n. Lauf, bei false, erster Lauf,
{
    var sDefault = sDefault_x || "";
    var sSQL = 	"SELECT DISTINCT " + sTargetAttribute + " FROM " + sTable + " WHERE " + sWhere;
    
    var aResult = GetDBDataSetEXT(sSQL, sTable+"_"+sTargetAttribute);
    
    if (aResult.length > 0){
        if (bIntersect){
            var aValidValues = ECL_GetAllActiveAttributeValues(sTargetAttribute);
        }
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
        //var test = ECL_GetAllActiveAttributeValues(sTargetAttribute);
        for (var i = 0; i < aResult.length; i++){
            if (bIntersect){
                if (aValidValues.indexOf(aResult[i][sTargetAttribute]) > -1){
                    ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
                }
            }else{
                ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
            }
        } 
        //var test = ECL_GetAllActiveAttributeValues(sTargetAttribute);
        if (aResult.length == 1){
            ECL_SelectValue(sTargetAttribute, aResult[0][sTargetAttribute]);
        }
        else
        {
            ExecSetStandardifValueEmpty(sTargetAttribute, sDefault);
        }
    }
    else{
        // Fehler;
        return "Error";
    }
    return 0;
}

/**
Funktion zur Einschrnkung eines Attributes in Abhngigkeit der MLFB 
MLFB-Attribut wird von Produktlogik eingeschrnkt. 
Der verbleibende Wertepool wird dann genutzt, um das Zielattribut einzuschrnken mit einer bersetzung ber eine bersetzungstabelle

sTarget: 	Zielattribut, welches eingeschrnkt werden soll
sMLFB_NAME: ID des MLFB-Attributs
sTable: 	bersetzungstabelle in der MLFB und Zielattribut enthalten sind.
*/

function SetAttributeLogicFromMLFB(sTarget, sMLFB_NAME, sTable)
{
    return SetAttributeLogicFromMLFB(sTarget, sMLFB_NAME, sTable, "");
}

function SetAttributeLogicFromMLFB(sTarget, sMLFB_NAME, sTable, addWhere)
{
    var aValidValuesMLFB = ECL_GetAllActiveAttributeValues(sMLFB_NAME);
    
    addWhere = addWhere || "";
    if (addWhere != ""){
        addWhere = addWhere + " AND ";
    }
    ECL_DeactivateAllAttributeValues(sTarget);
    
    var sWhere = sMLFB_NAME + " = '" + aValidValuesMLFB[0] + "'";
    
    if (aValidValuesMLFB.length > 1){
        
        for (var i = 1; i < aValidValuesMLFB.length; i++){
            
            sWhere = sWhere + " OR " + sMLFB_NAME + " = '" + aValidValuesMLFB[i] + "'";
            
        }
    }
    
    var sSQL = "SELECT DISTINCT * FROM " + sTable + " WHERE " + addWhere + "(" + sWhere + ");";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_" + sMLFB_NAME );
    
    if (aResult.length > 0){
        for (var j = 0; j < aResult.length; j++){
            ECL_ActivateValue(sTarget, aResult[j][sTarget]);
        }
    }else{
        return "Error";
    }
    
    if (aResult.length == 1){
        ECL_SelectValue(sTarget, aResult[0][sTarget]);
    }
    else
    {
        ExecSetStandardifValueEmpty(sTarget, "");
    }
    
    return 0;
}


/**
 * Die function erstellt eine Query f�r die Datenbank
 * @param {*} DBtable                   Der name der tabelle der Datenbank
 * @param {*} sTargetAttribute          Zielattribut deren Werte aktiviert und deactiviert werden sollen
 * @param {*} whereClauselAttributes    Liste von Attributen die in der WhereClausel vorkommen
 */
 function buildQuery(DBtable, sTargetAttribute, whereClauselAttributes){

    var first = true; 
    var query = "SELECT " + sTargetAttribute+" FROM " + DBtable;

    for(var i = 0; i< whereClauselAttributes.length; i++){

        var value = ECL_GetValue(whereClauselAttributes[i]);
        
        if(value !=""){
            if(first == true){
                query += " WHERE " + whereClauselAttributes[i]+ " = '" + value+"'";
                first = false;
            }
            else{
                query += " AND " + whereClauselAttributes[i]+ " = '" + value+"'";
            }
        }

        else{
            return ""     
        }
    }
    query += " GROUP BY " + sTargetAttribute;

    return query;
}

/**
 * Die Function aktiviert und deactiviert Werte eines Attributes
 * @param {*} sTargetAttribute  Zielattribute deren Werte aktiviert/deactiviert werden sollen
 * @param {*} DBresult          Liste der Datenbank ergebnisse 
 */
function setAttributeValues(sTargetAttribute, DBresult){
    
    ECL_DeactivateAllAttributeValues(sTargetAttribute);

    for(var i = 0; i < DBresult.length; i++){
    
        ECL_ActivateValue(sTargetAttribute, Object.values(DBresult[i])[0]);
    
    }

    if(DBresult.length ==1){
        ECL_SelectValue(sTargetAttribute, Object.values(DBresult[0])[0]);
    }
}
/**
 * Die function ruft weitere functionen auf, die eine Query bilden, Daten aus der Datenbank holen und damit
 * die Werte passend aktiviert und deactiviert
 * @param {*} DBtable                   Der name der tabelle der Datenbank
 * @param {*} sTargetAttribute          Zielattribut deren Werte aktiviert und deactiviert werden sollen
 * @param {*} whereClauselAttributes    Liste von Attributen die in der WhereClausel vorkommen
 * 
 * @return 0 oder 1 je nach dem ob erfolgreich oder fehler
 */
function setValuesFromDatabase(DBtable, sTargetAttribute, whereClauselAttributes){

    var query = buildQuery(DBtable, sTargetAttribute, whereClauselAttributes)
    
    if(query ==""){
        return false;
    }
    var result = Object.fromDatabase("EXTERNAL_DATA", query);
    
    setAttributeValues(sTargetAttribute, result);

    return true;
}

