//@legacy
/**
*   Main script for configuration object CFG_SIEMENS_G130
*
* 	Date: 2019-08-29
* 	User: Jochen Rather, Plan Software GmbH
*/


// include easyKAT Configuration Library

//@import "SIZER_general_functions.js"


//#mode(full-ecma)


/**
* Checks which of these two attributes has a value other than empty ("") or "FALSE" and disables the other.
* @param {String} attr1		Name of the first attribute.
* @param {String} attr2		Name of the second attribute.
*/
function toggleAttributePairDisable(attr1, attr2){
    if (ECL_GetValue(attr1) !== "" && ECL_GetValue(attr1) !== "FALSE" ) {			
        ECL_DisableAttribute(attr2);
    } else if (ECL_GetValue(attr2) !== "" && ECL_GetValue(attr2) !== "FALSE" ) {			
        ECL_DisableAttribute(attr1);
    } else {
        ECL_EnableAttribute(attr1);
        ECL_EnableAttribute(attr2);
    }
}

/**
* Checks which attribute in a "group" is neither empty ("") nor "FALSE" and disables all others.
* If no attribute matches this criteria all attributes are enabled.
* @param {array} attrArray	An array that contains the names of the attributes in the desired group.
*/
function toggleAttributeGroupDisable(attrArray){
    var selectedAtts = [];
    //Checking all attributes in the group if they have a value other than "" or "FALSE". 
    //This should result in an array with a length of 0 or 1
    for (var i = 0; i < attrArray.length; i++){	
        if (ECL_GetValue(attrArray[i]) !== "" && ECL_GetValue(attrArray[i]) !== "FALSE" ) {	
            selectedAtts.push(i);
        }
    }
    
    if (selectedAtts.length === 1) { //One attribute selected. Disabling all that are not selected.
        for (var i = 0; i < attrArray.length; i++){	
            if (i !== selectedAtts[0]) {	
                ECL_DisableAttribute(attrArray[i]);
            }
        }
    } else if (selectedAtts.length === 0) { //No attribute selected. Enabling all.
        for (var i = 0; i < attrArray.length; i++){	
            ECL_EnableAttribute(attrArray[i]);		
        }
    } else { //More than one attribute selected. Resetting the whole group. This should not happen. 
        for (var i = 0; i < attrArray.length; i++){	
            ECL_EnableAttribute(attrArray[i]);
            ECL_SetValue(attrArray[i], "FALSE");			
        }
    }
}

// Global config related variables
var VT_G130_M00032 = "VT_G130_M00032_26840";
var MLFB10_13_ATTRIBUTE_ID = "H_MLFB10_13_G130";
var FRAME_SIZE_ATTRIBUTE_ID = "PMD_ABW171_001_000_G130";
var MAX_BRAKING_MODULE_COUNT_PER_FRAME_SIZE = {
                                                "FX":"1", 
                                                "GX":"1", 
                                                "HX":"2", 
                                                "JX":"3"
                                                };
var SECOND_BRAKING_MODULE_ATTRIBUTE_ID = "CUSTOM_BRAKINGMODULE_2_G130";
var THIRD_BRAKING_MODULE_ATTRIBUTE_ID = "CUSTOM_BRAKINGMODULE_3_G130";
var STATUS_MESSAGE_ATTRIBUTE_ID = "ECSI_STATUS_MESSAGE";
var STATUS_ATTRIBUTE_ID = "ECSI_STATUS";
var SAFETY_FUNCTION_CONTEXT = "ECSI_CX_SafetyFunctions";
var SAFE_BRAKE_ADAPTER_ATTRIBUTE_ID = "SAFE_BRAKE_ADAPTER_G130";
var SAFE_BRAKE_ADAPTER_MLFB = "6SL33552DX001AA0";
var SAFE_BRAKE_ADAPTER_CABLE_ATTRIBUTE_ID = "SAFE_BRAKE_ADAPTER_CABLE_G130";
var SAFE_BRAKE_ADAPTER_CABLE_MLFB = "6SL30604DX040AA0";

var SAFETY_LICENSE_ATTRIBUTE_ID = "SAFETY_LICENSE_G130";
var SAFETY_LICENSE_MLFB = "6SL30740AA100AH0";
var SAFETY_FUNCTION_SLS = "2";
var SAFETY_FUNCTION_SDI = "3";
var SAFETY_FUNCTION_SSM = "4";
var SAFETY_FUNCTION_SLA = "7";
var SAFETY_FUNCTION_SBC = "11";
var SAFETY_FUNCTION_SBT = "12";
var SAFETY_FUNCTION_SS1T = "13";
var SAFETY_FUNCTION_SS1R = "14";

globalThis.OnChangeConfiguration = function main()
{
    //6SL3310-1GE32-1AA3
    
    var strchangedAttribute = ECL_GetCurrentAttribute();
    logtraceln("Changed Attribute="+strchangedAttribute)
    if(strchangedAttribute.left(7) == "ECSI_CX" || strchangedAttribute=="ECSI_MLFB_SEC")
        return;
    
    if(strchangedAttribute === SAFETY_LICENSE_ATTRIBUTE_ID)
    {
        var valueSelected = ECL_ValueSelected(SAFETY_LICENSE_ATTRIBUTE_ID, "T");
        if(valueSelected == 1)
        {
            ECL_SelectValue(SAFETY_LICENSE_ATTRIBUTE_ID, "T");
        }
        else if(valueSelected == 0)
        {
            ECL_DeselectValue(SAFETY_LICENSE_ATTRIBUTE_ID, "T");
            ECL_SetValue(SAFETY_LICENSE_ATTRIBUTE_ID, "F");
        }
    }
        
    if(ECL_GetValue("ECSI_MLFB")=="")
        return;
    
    
    SetAttributesFromMlfb();
    manageKeepconfig();
    //Parsen der MLFB_SEC
    var strMLFB_SEC = GetMlfbSec();
    var aMLFB_SEC = strMLFB_SEC.split(";");
    
    if(ECL_GetValue("ECSI_CX_AmbientTemperatureFrequencyConverter")=="")
        ECL_SetValue("ECSI_CX_AmbientTemperatureFrequencyConverter","40");
        
    if(ECL_GetValue("ECSI_CX_InstallationAltituteFrequencyConverter")=="")
        ECL_SetValue("ECSI_CX_InstallationAltituteFrequencyConverter","1000");
        
    if(ECL_GetValue("ECSI_CX_StandardSupplySystem")=="")
        ECL_SetValue("ECSI_CX_StandardSupplySystem","3");
    
    // Variables vor ECSI parameters
    var ECSI_CX_InstallationAltituteFrequencyConverter = ECL_GetValue("ECSI_CX_InstallationAltituteFrequencyConverter");
    var ECSI_CX_AmbientTemperatureFrequencyConverter = ECL_GetValue("ECSI_CX_AmbientTemperatureFrequencyConverter");
    var ECSI_CX_StandardSupplySystem = ECL_GetValue("ECSI_CX_StandardSupplySystem");
    var ECSI_IS_START_CONFIGURATION = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    var ECSI_CX_FieldbusInterface = ECL_GetValue("ECSI_CX_FieldbusInterface");
    
    var strConextError="";
    if(ECSI_CX_FieldbusInterface=="2" || ECSI_CX_FieldbusInterface=="3")
    {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SelectValue("ECSI_STATUS_MESSAGE", translate("ERRORMSG_CONTEXT___G130_FIELDBUSNOTSUPPORTED"));
        return;
    }
    
    //Zuerst Conext Check!
    for(var i=0;i<aMLFB_SEC.length;i++)
    {
        if(aMLFB_SEC[i]=="6SL30401GA001AA0" && ECSI_CX_FieldbusInterface=="0")
        {
            // Fehler! Context passt nicht
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SelectValue("ECSI_STATUS_MESSAGE", translate("ERRORMSG_CONTEXT___G130_CHANGED"));
            strConextError="True";
            return;
        }
        
        if(aMLFB_SEC[i]=="6SL30401GA011AA0" && ECSI_CX_FieldbusInterface=="1")
        {
            // Fehler! Context passt nicht
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SelectValue("ECSI_STATUS_MESSAGE", translate("ERRORMSG_CONTEXT___G130_CHANGED"));
            strConextError="True";
            return;
        }
        
        var safetyContext = parseContext(ECL_GetValue(SAFETY_FUNCTION_CONTEXT));
        if(aMLFB_SEC[i]==SAFE_BRAKE_ADAPTER_CABLE_MLFB && !isValueInContext(SAFETY_FUNCTION_SBC, safetyContext))
        {
            // Fehler! Context passt nicht
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SelectValue("ECSI_STATUS_MESSAGE", translate("ERRORMSG_CONTEXT___G130_CHANGED"));
            strConextError="True";
            return;
        }
        
        if(aMLFB_SEC[i]==SAFE_BRAKE_ADAPTER_MLFB && !isValueInContext(SAFETY_FUNCTION_SBC, safetyContext))
        {
            // Fehler! Context passt nicht
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SelectValue("ECSI_STATUS_MESSAGE", translate("ERRORMSG_CONTEXT___G130_CHANGED"));
            strConextError="True";
            return;
        }
    }
    
    
    //Disabling
    ECL_DisableAttribute("OZ_CONTROL_UNIT_G130");
    ECL_DisableAttribute("IN_AUFSTELLUNGSHOEHE_G130");
    ECL_DisableAttribute("IN_UMGEBUNGSTEMP_G130");
    ECL_DisableAttribute("IN_FREQUENZ_G130");
    ECL_DisableAttribute("PMD_ABJ189_001_000_G130");
    ECL_DisableAttribute(SAFE_BRAKE_ADAPTER_ATTRIBUTE_ID);
    ECL_DisableAttribute(SAFE_BRAKE_ADAPTER_CABLE_ATTRIBUTE_ID);
    if (ECL_GetValue("CABLE_FOR_AOP_G130") !== "FALSE" && ECL_GetValue("CABLE_FOR_AOP_G130") !== "" && ECL_GetValue("OZ_AOP30_G130") === "FALSE") 
        ECL_SelectValue("CABLE_FOR_AOP_G130", "FALSE");
    ECL_DisableAttribute("CABLE_FOR_AOP_G130");
    
    //Deactivating & disabling braking module related
    //ECL_DeactivateAttribute(SECOND_BRAKING_MODULE_ATTRIBUTE_ID);
    ECL_DisableAttribute(SECOND_BRAKING_MODULE_ATTRIBUTE_ID);
    //ECL_DeactivateAttribute(THIRD_BRAKING_MODULE_ATTRIBUTE_ID);
    ECL_DisableAttribute(THIRD_BRAKING_MODULE_ATTRIBUTE_ID);
        
    //Preselection 	
    if (ECSI_CX_InstallationAltituteFrequencyConverter){ //Attr desc: Aufstellungshöhe
        ECL_SetValue("IN_AUFSTELLUNGSHOEHE_G130", ECSI_CX_InstallationAltituteFrequencyConverter);
    } else {	
        ECL_SetValue("IN_AUFSTELLUNGSHOEHE_G130", "1000");
    }
    if (ECSI_CX_AmbientTemperatureFrequencyConverter){ //Attr desc: Umgebungstemperatur
        ECL_SetValue("IN_UMGEBUNGSTEMP_G130", ECSI_CX_AmbientTemperatureFrequencyConverter);
    } else {	
        ECL_SetValue("IN_UMGEBUNGSTEMP_G130", "40");
    }
    if ( //Attr desc: Netzspannung and Netzfrequenz
        (ECSI_CX_StandardSupplySystem || ECSI_CX_StandardSupplySystem == "0") &&
        (ECL_GetValue("IN_FREQUENZ_G130") === "" || ECL_GetValue("PMD_ABJ189_001_000_G130") === "")
    ) {
        var iSSS = parseInt(ECSI_CX_StandardSupplySystem);
        
        //Setting Netzfrequenz.
        if(iSSS >= 0 && iSSS <= 6 || iSSS == 18){
            ECL_SetValue("IN_FREQUENZ_G130", "50");
        } else if (iSSS >= 7 && iSSS <= 15) {
            ECL_SetValue("IN_FREQUENZ_G130", "60");			
        } else { //ECSI_CX_StandardSupplySystem unknown value. Setting DTK default value.
            ECL_SetValue("IN_FREQUENZ_G130", "50");	
        }
        
        //If-chain to set Netzspannung. Ordered by voltage (asc)
        if (iSSS === 0 || iSSS === 1) {		// !!! 575V and 660V have no corresponding StandardSupplySystem value !!!
            ECL_SetValue("PMD_ABJ189_001_000_G130", "Standard Supply System not supported"); //230
        } else if (iSSS === 7 || iSSS === 8) {		
            ECL_SetValue("PMD_ABJ189_001_000_G130", "Standard Supply System not supported"); //240
        } else if (iSSS === 2 || iSSS === 9) {		
            ECL_SetValue("PMD_ABJ189_001_000_G130", "380");
        } else if (iSSS === 3 || iSSS === 10) {		
            ECL_SetValue("PMD_ABJ189_001_000_G130", "400");
        } else if (iSSS === 4 ) {		
            ECL_SetValue("PMD_ABJ189_001_000_G130", "Standard Supply System not supported"); //415
        } else if (iSSS === 11) {		
            ECL_SetValue("PMD_ABJ189_001_000_G130", "440");
        } else if (iSSS === 12) {		
            ECL_SetValue("PMD_ABJ189_001_000_G130", "460");
        } else if (iSSS === 13 || iSSS === 18) {		
            ECL_SetValue("PMD_ABJ189_001_000_G130", "480");
        } else if (iSSS === 5) {		
            ECL_SetValue("PMD_ABJ189_001_000_G130", "500");
        } else if (iSSS === 14) {		
            ECL_SetValue("PMD_ABJ189_001_000_G130", "600");
        } else if (iSSS === 6 || iSSS === 15) {		
            ECL_SetValue("PMD_ABJ189_001_000_G130", "690");
        } else { //ECSI_CX_StandardSupplySystem unknown value. Setting DTK default value.
            ECL_SetValue("PMD_ABJ189_001_000_G130", "380");
        }
    } else if ( ECL_GetValue("IN_FREQUENZ_G130") === "" || ECL_GetValue("PMD_ABJ189_001_000_G130") === "" ) { // Setting default values according to the DTK if ECSI_CX_StandardSupplySystem is unset.
        ECL_SetValue("IN_FREQUENZ_G130", "50");		
        ECL_SetValue("PMD_ABJ189_001_000_G130", "380");
    }
        
    if(ECSI_CX_FieldbusInterface=="0")
    {
        ECL_SetValue("PMD_ABU804_001_000_G130", "PN");
        ECL_SetValue("OZ_CONTROL_UNIT_BEZ_G130", "CU_PN");
        ECL_DisableAttribute("PMD_ABU804_001_000_G130"); 
        ECL_DisableAttribute("OZ_CONTROL_UNIT_BEZ_G130");
        ECL_SelectValue("OZ_CONTROL_UNIT_G130", "6SL30401GA011AA0");
        ECL_SelectValue("ECSI_CC_ControlUnit", "6SL30401GA011AA0");
    }
    else if(ECSI_CX_FieldbusInterface=="1")
    {
        ECL_SetValue("PMD_ABU804_001_000_G130", "DP");
        ECL_SetValue("OZ_CONTROL_UNIT_BEZ_G130", "CU_DP");
        ECL_DisableAttribute("PMD_ABU804_001_000_G130"); 
        ECL_DisableAttribute("OZ_CONTROL_UNIT_BEZ_G130");
        
        ECL_SelectValue("OZ_CONTROL_UNIT_G130", "6SL30401GA001AA0");
        ECL_SelectValue("ECSI_CC_ControlUnit", "6SL30401GA001AA0");
    }
    else
    {
        ECL_EnableAttribute("PMD_ABU804_001_000_G130");
        if (!ECL_GetValue("PMD_ABU804_001_000_G130"))
        {
            ECL_SetValue("PMD_ABU804_001_000_G130", "DP");
        }
        
        ECL_EnableAttribute("OZ_CONTROL_UNIT_BEZ_G130");
        if (!ECL_GetValue("OZ_CONTROL_UNIT_BEZ_G130"))
        {
            ECL_SetValue("OZ_CONTROL_UNIT_BEZ_G130", "CU_DP");		
        }
    }

    // Preselection End
        
    //The free fields of the primary mlfb depend only on combinations from "Ausgangsstrom" and "Netzspannung". 
    //Netzspannung should be set by default by the sizer using ECSI_CX_StandardSupplySystem.
    var primaryMlfb = ECL_GetValue("ECSI_MLFB");	
    var primaryMlfbCleaned = primaryMlfb.replace("-", "");
    if (primaryMlfbCleaned.length !== 16) {
        return false; //Invalid MLFB.
    } 
    var mlfb10 = primaryMlfbCleaned.substring(9,10)
    var mlfb10_13 = primaryMlfbCleaned.substring(9,13)
    var mlfb11_13 = primaryMlfbCleaned.substring(10,13)
    
    ECL_SetValue("MLFB10_G130", mlfb10);
    ECL_SetValue("H_MLFB10_13_G130", mlfb10_13);
    ECL_SetValue("H_MLFB11_13_G130", mlfb11_13);
    
    // Setting and locking OZ_NETZDROSSELN_G130 if OZ_LINEHARMFILTER_G130 is set by the user.
    var lineHarmFilter = ECL_GetValue("OZ_LINEHARMFILTER_G130");
    if ( lineHarmFilter !== "FALSE" && lineHarmFilter !== "")
    {
        var sqlQueryNetzDrosseln = 
            "select OZ_NETZDROSSELN_G130 " + 
            "from 'VT_G130_M00021_26840' " +
            "where H_MLFB10_13_G130 = ? " +
            "and OZ_NETZDROSSELN_G130 <> 'FALSE'";
        var sqlArgsNetzDrosseln = [mlfb10_13];		
        var sqlResultNetzDrosseln = Object.fromDatabase("EXTERNAL_DATA", sqlQueryNetzDrosseln, sqlArgsNetzDrosseln);
        var netzDrossel = sqlResultNetzDrosseln[0]["OZ_NETZDROSSELN_G130"];
        
        ECL_DisableAttribute("OZ_NETZDROSSELN_G130");
        ECL_SetValue("OZ_NETZDROSSELN_G130", netzDrossel);
    } 
    else
    {	
        ECL_EnableAttribute("OZ_NETZDROSSELN_G130");
    }
    
    // Determinate the values of OZ_BREMSWIDERSTAEN25_G130 and OZ_BREMSWIDERSTAEN50_G130 according to the primary MLFB.
    // Only one attribute can have a value other than "FALSE" for each MLFB. The other attribute gets locked.
    ECL_DeactivateAllAttributeValues("OZ_BREMSWIDERSTAEN25_G130");
    ECL_DeactivateAllAttributeValues("OZ_BREMSWIDERSTAEN50_G130");	
    ECL_ActivateValue("OZ_BREMSWIDERSTAEN25_G130","FALSE");
    ECL_ActivateValue("OZ_BREMSWIDERSTAEN50_G130","FALSE");
    
    if (mlfb10_13.indexOf(".") === -1) 
    {		
        var sqlQueryBremsWiderst = 
            "select bremsmlfb.OZ_BRAKINGMODULES_G130, OZ_BREMSWIDERSTAEN25_G130, OZ_BREMSWIDERSTAEN50_G130 " + 
            "from 'VT_G130_M00022_26840' bremsmlfb " +
            "join 'VT_G130_M00043_26840' bremswiderst on bremsmlfb.OZ_BRAKINGMODULES_G130 = bremswiderst.OZ_BRAKINGMODULES_G130 " +
            "where H_MLFB10_13_G130 = ? " +
            "and OZ_BREMSWIDERSTAEN25_G130 <> OZ_BREMSWIDERSTAEN50_G130 ";
        var sqlArgsBremsWiderst = [mlfb10_13];		
        var sqlResultBremsWiderst = Object.fromDatabase("EXTERNAL_DATA", sqlQueryBremsWiderst, sqlArgsBremsWiderst);
        var brakingModule = sqlResultBremsWiderst[0]["OZ_BRAKINGMODULES_G130"];
        var bremsWiderst25 = sqlResultBremsWiderst[0]["OZ_BREMSWIDERSTAEN25_G130"];
        var bremsWiderst50 = sqlResultBremsWiderst[0]["OZ_BREMSWIDERSTAEN50_G130"];
        
        if (bremsWiderst25 === "FALSE")
        { 
            ECL_DisableAttribute("OZ_BREMSWIDERSTAEN25_G130"); 
        } 
        else 
        { 
            ECL_EnableAttribute("OZ_BREMSWIDERSTAEN25_G130");
            ECL_ActivateValue("OZ_BREMSWIDERSTAEN25_G130", bremsWiderst25); 
        }
        
        if (bremsWiderst50 === "FALSE")
        { 
            ECL_DisableAttribute("OZ_BREMSWIDERSTAEN50_G130"); 
        }
        else
        { 		
            ECL_EnableAttribute("OZ_BREMSWIDERSTAEN50_G130");
            ECL_ActivateValue("OZ_BREMSWIDERSTAEN50_G130", bremsWiderst50); 
        }
        
        // Regenerativer Betrieb
        var sRegenerativeModeContext = ECL_GetValue("ECSI_CX_RegenerativeMode");
        
        if (sRegenerativeModeContext && sRegenerativeModeContext != "0")
        {
            var iCxRegenerativeMode = parseInt(sRegenerativeModeContext);
            
            // Bremswiderstand nur bei Kontext 'Energie abführen' aktivieren
            if (iCxRegenerativeMode == 2)
            {
                if (bremsWiderst25 != "FALSE")
                {
                    ECL_SelectValue("OZ_BREMSWIDERSTAEN25_G130", bremsWiderst25);
                    ECL_DisableAttribute("OZ_BREMSWIDERSTAEN25_G130");
                    ECL_SetValue("ECSI_CC_BrakingResistorID", bremsWiderst25);
                }
                else if (bremsWiderst50 != "FALSE")
                {
                    ECL_SelectValue("OZ_BREMSWIDERSTAEN50_G130", bremsWiderst50);
                    ECL_DisableAttribute("OZ_BREMSWIDERSTAEN50_G130"); 
                    ECL_SetValue("ECSI_CC_BrakingResistorID", bremsWiderst50);
                }
            }
            else
            {
                ECL_SelectValue("ECSI_STATUS_MESSAGE", "ERROR___REGENERATIVE_MODE_INVALID_G110D");
            }
        }
        
        // BrakeRelayss
        ECL_DisableAttribute("ECSI_CC_BrakeRelays");
        ECL_SetValue("ECSI_CC_BrakeRelays", "");
        
        //Filter
        if(ECL_GetValue("OZ_NETZFILTER_G130") != "FALSE")
        {
            ECL_SetValue("ECSI_CC_InputFilterType", "0");
            ECL_SetValue("ECSI_CC_ExternalFilterType", "2");
        }
        else
        {
            ECL_SetValue("ECSI_CC_InputFilterType", "3");
            ECL_SetValue("ECSI_CC_ExternalFilterType", "0");
        }
    
        //set safety function from context
        setSafetyFunctionFromContext();
        
        // set safety license if context requires that
        setSafetyLicenseAttribute();
        
        // Multiple braking modules related stuff 
        
        // determine Frame Size - mlfb10_13
        determineFrameSizeFromMlfbFragment(mlfb10_13);
        
        // determine if multiple braking modules are possible and if yes, how many
        var possibleBrakingModules = getMaxBrakingModuleCount();
        
        // handle extra braking module values
        //setExtraBrakingModuleValues();
        
        // enable extra braking modules if possible
        //enableExtraBrakingModules(possibleBrakingModules);
    }
    
    // Variant tables for simple filtering of attribute values.
    activateMultipleAttributeValues("VT_G130_M00013_26840"); //HOEHE_TEMP_DERATING
    activateMultipleAttributeValues("VT_G130_M00019_26840"); //OZ_NETZFILTER_G130
    activateMultipleAttributeValues("VT_G130_M00020_26840"); //OZ_LINEHARMFILTER_G130
    activateMultipleAttributeValues("VT_G130_M00021_26840"); //OZ_NETZDROSSELN_G130
    activateMultipleAttributeValues("VT_G130_M00022_26840"); //OZ_BRAKINGMODULES_G130
    activateMultipleAttributeValues("VT_G130_M00024_26840"); //OZ_MOTORDROSSELN_G130
    activateMultipleAttributeValues("VT_G130_M00025_26840"); //OZ_DUDTFILTERPLUSVPL_G130
    activateMultipleAttributeValues("VT_G130_M00026_26840"); //OZ_DUDTFILTERCOMPACT_G130
    activateMultipleAttributeValues("VT_G130_M00027_26840"); //OZ_SINUSFILTER_G130
    //activateMultipleAttributeValues("VT_G130_M00029_26840"); //IN_FREQUENZ_G130   DB gibts nicht mehr
    //activateMultipleAttributeValues("VT_G130_M00030_26840"); //IN_SPANNUNG_G130   DB gibts nicht mehr
    activateMultipleAttributeValues("VT_G130_M00045_26840"); //Terminal Modules
    

    var accessoryNameArray = [
        "OZ_NETZFILTER_G130",
        "OZ_LINEHARMFILTER_G130",
        "OZ_NETZDROSSELN_G130",
        "OZ_MOTORDROSSELN_G130",
        "OZ_DUDTFILTERPLUSVPL_G130",
        "OZ_DUDTFILTERCOMPACT_G130",
        "OZ_SINUSFILTER_G130",
        "OZ_BRAKINGMODULES_G130",
        "OZ_BREMSWIDERSTAEN25_G130",
        "OZ_BREMSWIDERSTAEN50_G130",
        "OZ_BOP20_G130",
        "OZ_AOP30_G130",
        "OZ_CBC10_G130",
        "OZ_CBE20_G130",
        "OZ_TB30_G130",
        "OZ_TM150_G130",
        "OZ_TM150_2_G130",
        "OZ_TM31_G130",
        "OZ_TM31_2_G130",
        "OZ_VSM10_G130",
        "OZ_SMC30_G130",
        "OZ_SMC30_2_G130",
        "CABLE_FOR_AOP_G130",
        SAFE_BRAKE_ADAPTER_ATTRIBUTE_ID,
        SAFETY_LICENSE_ATTRIBUTE_ID
    ];
    
    if(strchangedAttribute == "ECSI_MLFB")
    {
        var bOZ_SMC30_G130=false;
        var bOZ_TM31_G130=false;
        var bOZ_TM150_G130=false;
        

        for(var i=0;i<aMLFB_SEC.length;i++)
        {
            if(aMLFB_SEC[i]=="6SL30401GA001AA0" || aMLFB_SEC[i]=="6SL30401GA011AA0")
            {
                //OZ_CONTROL_UNIT_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_CONTROL_UNIT_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                    ECL_SetValue("OZ_CONTROL_UNIT_G130",aMLFB_SEC[i]);
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_CONTROL_UNIT_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
                    
                if (ECL_GetValue("OZ_CONTROL_UNIT_G130")=="6SL30401GA001AA0")
                {
                    ECL_SelectValue("OZ_CONTROL_UNIT_BEZ_G130", "CU_DP");
                    ECL_SelectValue("PMD_ABU804_001_000_G130", "DP");
                }
                else if (ECL_GetValue("OZ_CONTROL_UNIT_G130") == "6SL30401GA011AA0")
                {					
                    ECL_SelectValue("OZ_CONTROL_UNIT_BEZ_G130", "CU_PN");
                    ECL_SelectValue("PMD_ABU804_001_000_G130", "PN");
                }
            }
            else if(aMLFB_SEC[i].left(9)=="6SL30000B")
            {
                //OZ_NETZFILTER_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_NETZFILTER_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i])){
                    ECL_SetValue("OZ_NETZFILTER_G130",aMLFB_SEC[i]);
                }
                else{
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_NETZFILTER_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i].left(9)=="6SL30000J")
            {
                //OZ_LINEHARMFILTER_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_LINEHARMFILTER_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i])){
                    ECL_SetValue("OZ_LINEHARMFILTER_G130",aMLFB_SEC[i]);
                }
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_LINEHARMFILTER_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i].left(9)=="6SL30000C")
            {
                //OZ_NETZDROSSELN_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_NETZDROSSELN_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i])){
                    ECL_SetValue("OZ_NETZDROSSELN_G130",aMLFB_SEC[i]);
                }
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_NETZDROSSELN_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i].left(9)=="6SL30002A" || aMLFB_SEC[i].left(9)=="6SL30002B")
            {
                //OZ_MOTORDROSSELN_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_MOTORDROSSELN_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i])){
                    ECL_SetValue("OZ_MOTORDROSSELN_G130",aMLFB_SEC[i]);
                }
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_MOTORDROSSELN_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i].left(10)=="6SL30002DH" || aMLFB_SEC[i]=="6SL30002DE326AA0" || aMLFB_SEC[i]=="6SL30002DE350AA0" || aMLFB_SEC[i]=="6SL30002DE384AA0" || aMLFB_SEC[i]=="6SL30002DE414AA0")
            {
                //OZ_DUDTFILTERPLUSVPL_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_DUDTFILTERPLUSVPL_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i])){
                    ECL_SetValue("OZ_DUDTFILTERPLUSVPL_G130",aMLFB_SEC[i]);
                }
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_DUDTFILTERPLUSVPL_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i].left(10)=="6SL30002DG" || aMLFB_SEC[i]=="6SL30002DE326EA0" || aMLFB_SEC[i]=="6SL30002DE350EA0" || aMLFB_SEC[i]=="6SL30002DE384EA0" || aMLFB_SEC[i]=="6SL30002DE414EA0")
            {
                //OZ_DUDTFILTERCOMPACT_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_DUDTFILTERCOMPACT_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i])){
                    ECL_SetValue("OZ_DUDTFILTERCOMPACT_G130",aMLFB_SEC[i]);
                }
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_DUDTFILTERCOMPACT_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i].left(9)=="6SL30002C")
            {
                //OZ_SINUSFILTER_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_SINUSFILTER_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i])){
                    ECL_SetValue("OZ_SINUSFILTER_G130",aMLFB_SEC[i]);
                }
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_SINUSFILTER_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i].left(9)=="6SL33001A")
            {
                //OZ_BRAKINGMODULES_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_BRAKINGMODULES_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i])){
                    ECL_SetValue("OZ_BRAKINGMODULES_G130",aMLFB_SEC[i]);
                }
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_BRAKINGMODULES_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i]=="6SL30001BE313AA0" || aMLFB_SEC[i]=="6SL30001BH313AA0")
            {
                //OZ_BREMSWIDERSTAEN25_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_BREMSWIDERSTAEN25_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i])){
                    ECL_SetValue("OZ_BREMSWIDERSTAEN25_G130",aMLFB_SEC[i]);
                }
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_BREMSWIDERSTAEN25_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i]=="6SL30001BE325AA0" || aMLFB_SEC[i]=="6SL30001BF325AA0" || aMLFB_SEC[i]=="6SL30001BH325AA0")
            {
                //OZ_BREMSWIDERSTAEN50_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_BREMSWIDERSTAEN50_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i])){
                    ECL_SetValue("OZ_BREMSWIDERSTAEN50_G130",aMLFB_SEC[i]);
                }
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_BREMSWIDERSTAEN50_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i]=="6SL30550AA004BA0")
            {
                //OZ_BOP20_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_BOP20_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                    ECL_SetValue("OZ_BOP20_G130",aMLFB_SEC[i]);
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_BOP20_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i]=="6SL30550AA004CA5")
            {
                //OZ_AOP30_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_AOP30_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i])) {
                    ECL_SetValue("OZ_AOP30_G130",aMLFB_SEC[i]);
                    ECL_EnableAttribute("CABLE_FOR_AOP_G130");
                }
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_AOP30_G130","F");
                        ECL_SetValue("CABLE_FOR_AOP_G130", "FALSE");
                        ECL_DisableAttribute("CABLE_FOR_AOP_G130");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i]=="6SL30550AA002CA0")
            {
                //OZ_CBC10_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_CBC10_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                    ECL_SetValue("OZ_CBC10_G130",aMLFB_SEC[i]);
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_CBC10_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i]=="6SL30550AA002EB0")
            {
                //OZ_CBE20_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_CBE20_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                    ECL_SetValue("OZ_CBE20_G130",aMLFB_SEC[i]);
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_CBE20_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i]=="6SL30550AA002TA0")
            {
                //OZ_TB30_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_TB30_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                    ECL_SetValue("OZ_TB30_G130",aMLFB_SEC[i]);
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_TB30_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i]=="6SL30550AA003LA0" && !bOZ_TM150_G130)
            {
                //OZ_TM150_G130
                //OZ_TM150_2_G130
                //eins oder zwei
                
                bOZ_TM150_G130=true;
                
                var bdouble=false;
                for(var j=i+1;j<aMLFB_SEC.length;j++)
                {
                    if(aMLFB_SEC[j]==aMLFB_SEC[i])
                    {
                        bdouble=true;
                    }
                }
                
                if(bdouble)
                {
                    //MLFB kommt nochmal vor
                    ECL_SetValue("OZ_TM150_G130","FALSE");
                    var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_TM150_2_G130");
                    if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                        ECL_SetValue("OZ_TM150_2_G130",aMLFB_SEC[i]);
                    else {
                        if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                            ECL_SetValue("OZ_TM150_2_G130","F");
                            aMLFB_SEC.splice(i,1);
                        } else {
                            ECL_SelectValue("ECSI_STATUS", "E");
                        }
                    }
                }
                else
                {
                    var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_TM150_G130");
                    if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                        ECL_SetValue("OZ_TM150_G130",aMLFB_SEC[i]);
                    else {
                        if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                            ECL_SetValue("OZ_TM150_G130","F");
                            aMLFB_SEC.splice(i,1);
                        } else {
                            ECL_SelectValue("ECSI_STATUS", "E");
                        }
                    }
                }
            }
            else if(aMLFB_SEC[i]=="6SL30550AA003AA1" && !bOZ_TM31_G130)
            {
                //OZ_TM31_G130
                //OZ_TM31_2_G130
                //eins oder zwei
                
                bOZ_TM31_G130=true;
                
                var bdouble=false;
                for(var j=i+1;j<aMLFB_SEC.length;j++)
                {
                    if(aMLFB_SEC[j]==aMLFB_SEC[i])
                    {
                        bdouble=true;
                    }
                }
                
                if(bdouble)
                {
                    //MLFB kommt nochmal vor
                    ECL_SetValue("OZ_TM31_G130","FALSE");
                    var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_TM31_2_G130");
                    if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                        ECL_SetValue("OZ_TM31_2_G130",aMLFB_SEC[i]);
                    else {
                        if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                            ECL_SetValue("OZ_TM31_2_G130","F");
                            aMLFB_SEC.splice(i,1);
                        } else {
                            ECL_SelectValue("ECSI_STATUS", "E");
                        }
                    }
                }
                else
                {
                    var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_TM31_G130");
                    if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                        ECL_SetValue("OZ_TM31_G130",aMLFB_SEC[i]);
                    else {
                        if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                            ECL_SetValue("OZ_TM31_G130","F");
                            aMLFB_SEC.splice(i,1);
                        } else {
                            ECL_SelectValue("ECSI_STATUS", "E");
                        }
                    }
                }
            }
            else if(aMLFB_SEC[i]=="6SL30530AA003AA1")
            {
                //OZ_VSM10_G130
                var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_VSM10_G130");
                if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                    ECL_SetValue("OZ_VSM10_G130",aMLFB_SEC[i]);
                else {
                    if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                        ECL_SetValue("OZ_VSM10_G130","F");
                        aMLFB_SEC.splice(i,1);
                    } else {
                        ECL_SelectValue("ECSI_STATUS", "E");
                    }
                }
            }
            else if(aMLFB_SEC[i]=="6SL30550AA005CA2" && !bOZ_SMC30_G130)
            {
                //OZ_SMC30_G130
                //OZ_SMC30_2_G130
                //eins oder zwei
                bOZ_SMC30_G130=true;
                
                var bdouble=false;
                for(var j=i+1;j<aMLFB_SEC.length;j++)
                {
                    if(aMLFB_SEC[j]==aMLFB_SEC[i])
                    {
                        bdouble=true;
                    }
                }
                
                if(bdouble)
                {
                    //MLFB kommt nochmal vor
                    ECL_SetValue("OZ_SMC30_G130","FALSE");
                    var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_SMC30_2_G130");
                    if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                        ECL_SetValue("OZ_SMC30_2_G130",aMLFB_SEC[i]);
                    else {
                        if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                            ECL_SetValue("OZ_SMC30_2_G130","F");
                            aMLFB_SEC.splice(i,1);
                        } else {
                            ECL_SelectValue("ECSI_STATUS", "E");
                        }
                    }
                }
                else
                {
                    var aActiveValues = ECL_GetAllActiveAttributeValues("OZ_SMC30_G130");
                    if(aActiveValues.length==2 && (aActiveValues[0]==aMLFB_SEC[i] || aActiveValues[1]==aMLFB_SEC[i]))
                        ECL_SetValue("OZ_SMC30_G130",aMLFB_SEC[i]);
                    else {
                        if (ECL_GetValue("ECSI_IS_START_CONFIGURATION")) {
                            ECL_SetValue("OZ_SMC30_G130","F");
                            aMLFB_SEC.splice(i,1);
                        } else {
                            ECL_SelectValue("ECSI_STATUS", "E");
                        }
                    }
                }
            }
            else if(aMLFB_SEC[i]==SAFETY_LICENSE_MLFB)
            {
                ECL_SelectValue(SAFETY_LICENSE_ATTRIBUTE_ID, "T");
            }
            else if (aMLFB_SEC[i] === "9SV11103AA000AA0") 
            {
                ECL_SelectValue("DRIVE_SIM_DESIGNER_G130", "T");
            }
            else if (
                aMLFB_SEC[i] === "6FX80021AA011AB0" || 
                aMLFB_SEC[i] === "6FX80021AA011AC0" || 
                aMLFB_SEC[i] === "6FX80021AA011AD0" || 
                aMLFB_SEC[i] === "6FX80021AA011AE0" || 
                aMLFB_SEC[i] === "6FX80021AA011AF0" || 
                aMLFB_SEC[i] === "6FX80021AA011AG0" || 
                aMLFB_SEC[i] === "6FX80021AA011AH0" || 
                aMLFB_SEC[i] === "6FX80021AA011AJ0" || 
                aMLFB_SEC[i] === "6FX80021AA011AK0" || 
                aMLFB_SEC[i] === "6FX80021AA011BA0"
            )
            {
                if (ECL_GetValue("OZ_AOP30_G130") === "FALSE")
                    ECL_SelectValue("CABLE_FOR_AOP_G130", "FALSE");
                
                ECL_SelectValue("CABLE_FOR_AOP_G130", aMLFB_SEC[i]);
            }
        }
    }
    
    if ( ECL_GetCurrentAttribute() === "OZ_CONTROL_UNIT_BEZ_G130" ) 
    {	
        if (ECL_GetValue("OZ_CONTROL_UNIT_BEZ_G130") == "CU_DP")
        {
            ECL_SelectValue("PMD_ABU804_001_000_G130", "DP");
        }
        else if (ECL_GetValue("OZ_CONTROL_UNIT_BEZ_G130") == "CU_PN")
        {
            ECL_SelectValue("PMD_ABU804_001_000_G130", "PN");
        } 
    } 
    else if ( ECL_GetCurrentAttribute() === "PMD_ABU804_001_000_G130" )
    {	
        if (ECL_GetValue("PMD_ABU804_001_000_G130") == "DP") 
        {
            ECL_SelectValue("OZ_CONTROL_UNIT_BEZ_G130", "CU_DP");
        } 
        else if (ECL_GetValue("PMD_ABU804_001_000_G130") == "PN")
        {
            ECL_SelectValue("OZ_CONTROL_UNIT_BEZ_G130", "CU_PN");
        }
    }
    
    // Setting OZ_CONTROL_UNIT_G130 (Control Unit Kit MLFB) according to OZ_CONTROL_UNIT_BEZ_G130 (Control Unit Kit)
    if (ECL_GetValue("OZ_CONTROL_UNIT_BEZ_G130") == "CU_DP" || ECL_GetValue("PMD_ABU804_001_000_G130") == "DP") 
    {
        ECL_SelectValue("OZ_CONTROL_UNIT_G130", "6SL30401GA001AA0");
        ECL_SelectValue("ECSI_CC_ControlUnit", "6SL30401GA001AA0");
        
    } 
    else if (ECL_GetValue("OZ_CONTROL_UNIT_BEZ_G130") == "CU_PN" || ECL_GetValue("PMD_ABU804_001_000_G130") == "PN")	
    {
        ECL_SelectValue("OZ_CONTROL_UNIT_G130", "6SL30401GA011AA0");
        ECL_SelectValue("ECSI_CC_ControlUnit", "6SL30401GA011AA0");
    }
    
    ECL_DisableAttribute("OZ_CONTROL_UNIT_G130");
    
    toggleAttributeGroupDisable([
        "OZ_MOTORDROSSELN_G130",
        "OZ_DUDTFILTERPLUSVPL_G130",
        "OZ_DUDTFILTERCOMPACT_G130",
        "OZ_SINUSFILTER_G130"
    ]);
    toggleAttributeGroupDisable([
        "OZ_CBC10_G130",
        "OZ_CBE20_G130",
        "OZ_TB30_G130"
    ]);
    
    toggleAttributePairDisable("OZ_TM150_G130", "OZ_TM150_2_G130");
    toggleAttributePairDisable("OZ_TM31_G130", "OZ_TM31_2_G130");
    toggleAttributePairDisable("OZ_TM150_2_G130", "OZ_TM31_2_G130");
    toggleAttributePairDisable("OZ_SMC30_G130", "OZ_SMC30_2_G130");
    
    if ((ECL_GetValue("OZ_BREMSWIDERSTAEN25_G130") != "" && ECL_GetValue("OZ_BREMSWIDERSTAEN25_G130") != "FALSE") || (ECL_GetValue("OZ_BREMSWIDERSTAEN50_G130") != "" && ECL_GetValue("OZ_BREMSWIDERSTAEN50_G130") != "FALSE")) 
    {
        ECL_SetValue("OZ_BRAKINGMODULES_G130", brakingModule);			
        ECL_DisableAttribute("OZ_BRAKINGMODULES_G130"); 
    } 
    else 
    {			
        ECL_EnableAttribute("OZ_BRAKINGMODULES_G130"); 
    }
    
    var lineHarmFilter = ECL_GetValue("OZ_LINEHARMFILTER_G130");
    if ( lineHarmFilter !== "FALSE" && lineHarmFilter !== "")
    {
        ECL_DisableAttribute("OZ_NETZDROSSELN_G130");
    } 
    else
    {	
        ECL_EnableAttribute("OZ_NETZDROSSELN_G130");
    }
    
    var motorTechnology = ECL_GetValue("ECSI_CX_MotorTechnology");
    if(motorTechnology == "1" || motorTechnology == "2")
    {
        //OZ_MOTORDROSSELN_G130 (select FALSE)
        ECL_SelectValue("OZ_MOTORDROSSELN_G130", "FALSE");
        ECL_DeactivateAttribute("OZ_MOTORDROSSELN_G130");
        
        //OZ_DUDTFILTERPLUSVPL_G130 (select FALSE)
        ECL_SelectValue("OZ_DUDTFILTERPLUSVPL_G130", "FALSE");
        ECL_DeactivateAttribute("OZ_DUDTFILTERPLUSVPL_G130");
        
        //OZ_DUDTFILTERCOMPACT_G130 (select FALSE)
        ECL_SelectValue("OZ_DUDTFILTERCOMPACT_G130", "FALSE");
        ECL_DeactivateAttribute("OZ_DUDTFILTERCOMPACT_G130");
        
        //OZ_SINUSFILTER_G130 (select FALSE)
        ECL_SelectValue("OZ_SINUSFILTER_G130", "FALSE");
        ECL_DeactivateAttribute("OZ_SINUSFILTER_G130");
    }
    
    var sinusFilter = ECL_GetValue("OZ_SINUSFILTER_G130");
	if(sinusFilter != "FALSE" && sinusFilter != "")
	{
		var MinPulseFrequency = "";
		var MaxPulseFrequency = "";
		var MaxOutputFrequencyLimit = "";
		
		var voltage = parseInt(ECL_GetValue("PMD_ABJ189_001_000_G130"));
		
		if(voltage !== 0 || voltage !== -1)
		{
			if(voltage >= 380 && voltage <= 480)
			{
				MinPulseFrequency = "4";
				MaxPulseFrequency = "4";
				MaxOutputFrequencyLimit = "150";
			}
			
			else
			if(voltage >= 500 && voltage <= 600)
			{
				MinPulseFrequency = "2.5";
				MaxPulseFrequency = "2.5";
				MaxOutputFrequencyLimit = "150";
			}
			
			ECL_SetValue("ECSI_CC_MinPulseFrequency", MinPulseFrequency);
			ECL_SetValue("ECSI_CC_MaxPulseFrequency", MaxPulseFrequency);
			ECL_SetValue("ECSI_CC_MaxOutputFrequencyLimit", MaxOutputFrequencyLimit);
		}
	}
    
    // Deactivate these as per PBI: 43249
    ECL_SelectValue("OZ_SMC30_G130", "FALSE");
    ECL_SelectValue("OZ_SMC30_2_G130", "FALSE");
    ECL_DeactivateAttribute("OZ_SMC30_G130");
    ECL_DeactivateAttribute("OZ_SMC30_2_G130");
    
    
    var secondaryMlfbsObj = {};
    
    for (var i = 0; i < accessoryNameArray.length; i++)
    {
        if (ECL_GetValue(accessoryNameArray[i]) === "") 
        {
            ECL_SetValue(accessoryNameArray[i], "FALSE");
        }
        
        var attrValue = ECL_GetValue(accessoryNameArray[i]);
        if (ECL_GetValue(accessoryNameArray[i]) !== "" && ECL_GetValue(accessoryNameArray[i]) !== "FALSE" && ECL_GetValue(accessoryNameArray[i]) !== "F")
        {
            if(accessoryNameArray[i] === SAFE_BRAKE_ADAPTER_ATTRIBUTE_ID && ECL_GetValue(SAFE_BRAKE_ADAPTER_ATTRIBUTE_ID) === "T")
            {
                secondaryMlfbsObj[accessoryNameArray[i]] = SAFE_BRAKE_ADAPTER_MLFB;
                secondaryMlfbsObj[SAFE_BRAKE_ADAPTER_CABLE_ATTRIBUTE_ID] = SAFE_BRAKE_ADAPTER_CABLE_MLFB;
            }
            else if(accessoryNameArray[i] === SAFETY_LICENSE_ATTRIBUTE_ID && ECL_ValueSelected(SAFETY_LICENSE_ATTRIBUTE_ID, "T") == 1)
            {
                secondaryMlfbsObj[accessoryNameArray[i]] = SAFETY_LICENSE_MLFB;
            }
            else //in any other case (F now) it is added as F which is not great at all
            {
                secondaryMlfbsObj[accessoryNameArray[i]] = ECL_GetValue(accessoryNameArray[i]);
            }
        }
    }
    
    var secondaryMlfbsString = "";
    for (var prop in secondaryMlfbsObj) 
    {
        if (secondaryMlfbsString.length > 0) 
        { 
            secondaryMlfbsString += ";";
        }
        
        if(find(prop,"_2_")>-1)
            secondaryMlfbsString += secondaryMlfbsObj[prop]+";"+secondaryMlfbsObj[prop];
        else
            secondaryMlfbsString += secondaryMlfbsObj[prop];
    }
    
    // Braking Resistor ID
    if(ECL_GetValue("OZ_BREMSWIDERSTAEN25_G130") != "FALSE")
        ECL_SetValue("ECSI_CC_BrakingResistorID", ECL_GetValue("OZ_BREMSWIDERSTAEN25_G130"));
    else if(ECL_GetValue("OZ_BREMSWIDERSTAEN50_G130") != "FALSE")
        ECL_SetValue("ECSI_CC_BrakingResistorID",  ECL_GetValue("OZ_BREMSWIDERSTAEN50_G130"));

    ECL_SetValue("ECSI_CC_Selected_CU", "G130");
    ECL_SetValue("ECSI_CC_Selected_PMs", "CIM_1");
    
    if (ECL_GetValue("OZ_VSM10_G130") !== "FALSE")
        ECL_SetValue("ECSI_CC_VSM4Motor", "VSM10");
    else 
        ECL_SetValue("ECSI_CC_VSM4Motor", "");

    if (ECL_GetValue("OZ_TM31_G130") !== "FALSE")
        ECL_SetValue("ECSI_CC_Selected_TM31_1", "TM31_1");
    else 
        ECL_SetValue("ECSI_CC_Selected_TM31_1", "");

    if (ECL_GetValue("OZ_TM31_2_G130") !== "FALSE") {
        ECL_SetValue("ECSI_CC_Selected_TM31_1", "TM31_1");
        ECL_SetValue("ECSI_CC_Selected_TM31_2", "TM31_2");
    }
    else {
        ECL_SetValue("ECSI_CC_Selected_TM31_2", "");
    } 

    if (ECL_GetValue("OZ_TM150_G130") !== "FALSE")
        ECL_SetValue("ECSI_CC_Selected_TM150_1", "TM150_1");
    else 
        ECL_SetValue("ECSI_CC_Selected_TM150_1", "");

    if (ECL_GetValue("OZ_TM150_2_G130") !== "FALSE") {
        ECL_SetValue("ECSI_CC_Selected_TM150_1", "TM150_1");
        ECL_SetValue("ECSI_CC_Selected_TM150_2", "TM150_2");
    }
    else {
        ECL_SetValue("ECSI_CC_Selected_TM150_2", "");
    }
        
        
    // secondary MLFB special case for OZ_CONTROL_UNIT_G130. Works differently than the accessories.
    var controlUnitMLFB = ECL_GetValue("OZ_CONTROL_UNIT_G130");
    if (controlUnitMLFB.length === 16) 
    {		
        if (secondaryMlfbsString.length > 0) 
        { 
            secondaryMlfbsString += ";";
        }
        secondaryMlfbsString += controlUnitMLFB;
    }
    
    if (ECL_GetValue("DRIVE_SIM_DESIGNER_G130") === "T") {
        if (secondaryMlfbsString.length > 0) 
        { 
            secondaryMlfbsString += ";";
        }
        secondaryMlfbsString += "9SV11103AA000AA0";
    }

    setOutputreactorOrFilter();
    SetMlfbSec(secondaryMlfbsString);
    
    if(ECL_GetValue("ECSI_STATUS") != "E"){
        ECL_SelectValue("ECSI_STATUS", "OK")
    } 
    
        
    logtraceln("ControlUnit="+ECL_GetValue("ECSI_CC_ControlUnit"));
}

function determineFrameSizeFromMlfbFragment(mlfb10_13)
{
    var sQuery = "SELECT " + FRAME_SIZE_ATTRIBUTE_ID + " FROM " + VT_G130_M00032 + " WHERE " + MLFB10_13_ATTRIBUTE_ID + " = '" + mlfb10_13 + "'";
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery);
    if(aDbResult.length === 1)
    {
        ECL_SelectValue(FRAME_SIZE_ATTRIBUTE_ID, aDbResult[0][FRAME_SIZE_ATTRIBUTE_ID]);
        return aDbResult[0][FRAME_SIZE_ATTRIBUTE_ID];
    }
}

function getMaxBrakingModuleCount()
{
    var frameSize = ECL_GetValue(FRAME_SIZE_ATTRIBUTE_ID);
    var maxCount = MAX_BRAKING_MODULE_COUNT_PER_FRAME_SIZE[frameSize];
    return maxCount;
}

function enableExtraBrakingModules(possibleBrakingModules)
{
    var brakingModule = ECL_GetValue("OZ_BRAKINGMODULES_G130");
    switch(possibleBrakingModules)
    {
        case "1":
            break;
        case "2":
            if(
            typeof brakingModule !== "undefined" 
            && brakingModule !== ""
            && brakingModule !== "FALSE"
            )
            {
                //ECL_ActivateAttribute(SECOND_BRAKING_MODULE_ATTRIBUTE_ID);
                ECL_EnableAttribute(SECOND_BRAKING_MODULE_ATTRIBUTE_ID);
            }
            break;
        case "3":
            if(
                typeof brakingModule !== "undefined" 
                && brakingModule !== ""
                && brakingModule !== "FALSE"
            )
            {
                //ECL_ActivateAttribute(SECOND_BRAKING_MODULE_ATTRIBUTE_ID);
                ECL_EnableAttribute(SECOND_BRAKING_MODULE_ATTRIBUTE_ID);
                var secondBrakingModule = ECL_GetValue(SECOND_BRAKING_MODULE_ATTRIBUTE_ID);
                if( secondBrakingModule === "T")
                {
                    //ECL_ActivateAttribute(THIRD_BRAKING_MODULE_ATTRIBUTE_ID);
                    ECL_EnableAttribute(THIRD_BRAKING_MODULE_ATTRIBUTE_ID);
                }
            }
            break;
        default:
            ECL_SetValue(STATUS_MESSAGE_ATTRIBUTE_ID, translate("BRAKING_MODULE_COUNT_UNSUPPORTED")); // Unsupported number of braking modules
            ECL_SelectValue(STATUS_ATTRIBUTE_ID, "E");
            break;
    }
    
}

function setExtraBrakingModuleValues()
{
    var currentAttribute = ECL_GetCurrentAttribute();
    if(currentAttribute === SECOND_BRAKING_MODULE_ATTRIBUTE_ID)
    {
        var secondModule = ECL_GetValue(SECOND_BRAKING_MODULE_ATTRIBUTE_ID);
        if(secondModule === "T")
        {
            ECL_SetValue(SECOND_BRAKING_MODULE_ATTRIBUTE_ID, "");
        }
        else if(secondModule !== "T")
        {
            ECL_SetValue(SECOND_BRAKING_MODULE_ATTRIBUTE_ID, "T");
        }
    }
    
    else if(currentAttribute === THIRD_BRAKING_MODULE_ATTRIBUTE_ID)
    {
        var thirdModule = ECL_GetValue(THIRD_BRAKING_MODULE_ATTRIBUTE_ID);
        if(thirdModule === "T")
        {
            ECL_SetValue(THIRD_BRAKING_MODULE_ATTRIBUTE_ID, "");
        }
        else if(thirdModule !== "T")
        {
            ECL_SetValue(THIRD_BRAKING_MODULE_ATTRIBUTE_ID, "T");
        }
    }
}

function setSafetyFunctionFromContext()
{
    var safetyFunctionContext = parseContext(ECL_GetValue(SAFETY_FUNCTION_CONTEXT));
    if(isValueInContext(SAFETY_FUNCTION_SBC, safetyFunctionContext)) // if SBC
    {
        ECL_SelectValue(SAFE_BRAKE_ADAPTER_ATTRIBUTE_ID, "T");
        ECL_SelectValue(SAFE_BRAKE_ADAPTER_CABLE_ATTRIBUTE_ID, "T");
        ECL_SetValue("ECSI_CC_BrakeRelays", SAFE_BRAKE_ADAPTER_MLFB);
    }
    else
    {
        ECL_DeselectValue(SAFE_BRAKE_ADAPTER_ATTRIBUTE_ID, "T");
        ECL_DeselectValue(SAFE_BRAKE_ADAPTER_CABLE_ATTRIBUTE_ID, "T");
        ECL_SetValue("ECSI_CC_BrakeRelays", "");
    }
}

function setSafetyLicenseAttribute()
{
    /*
        SAFETY_FUNCTION_SLS
        SAFETY_FUNCTION_SDI
        SAFETY_FUNCTION_SSM
        SAFETY_FUNCTION_SLA
        SAFETY_FUNCTION_SBT
        SAFETY_LICENSE_ATTRIBUTE_ID
        SAFETY_LICENSE_MLFB
    */
    var safetyFunctionContext = parseContext(ECL_GetValue(SAFETY_FUNCTION_CONTEXT));
    
    if(
        isValueInContext(SAFETY_FUNCTION_SLS, safetyFunctionContext) ||
        isValueInContext(SAFETY_FUNCTION_SDI, safetyFunctionContext) || 
        isValueInContext(SAFETY_FUNCTION_SSM, safetyFunctionContext) || 
        isValueInContext(SAFETY_FUNCTION_SBT, safetyFunctionContext) || 
        isValueInContext(SAFETY_FUNCTION_SS1R, safetyFunctionContext)
    )
    {
        ECL_SetValue(SAFETY_LICENSE_ATTRIBUTE_ID, "T");
        ECL_DisableAttribute(SAFETY_LICENSE_ATTRIBUTE_ID);
    }
    else
    {
        ECL_EnableAttribute(SAFETY_LICENSE_ATTRIBUTE_ID);
    }
}

function parseContext(contextValue)
{
    // 2;11
    var contextIdentifiers = contextValue.split(";");
    return contextIdentifiers;
}

function isValueInContext(value, context)
{
    // 2 in [2, 11,...] ?
    for(i = 0; i< context.length; i++)
    {
        if(value == context[i])
        {
            return true;
        }
    }
    return false;
}

/** Function um eine Query zu bilden zu bilden. Hier ist die whereClausel nur mit AND verknüpft
 * 
 * 
 * @param {*} sTargetAttribute          Das Attribut nachdem selektiert wird
 * @param {*} whereClauselAttributes    Liste von Attributen die in der WhereClausel vor kommen
 * @param {*} DBtable                   Tabelle der Datenbank
 * 
 * @return String vom Query 
 */
 function buildQuery(sTargetAttribute, whereClauselAttributes, DBtable){
    
    var query = "";
    var first = true;
    var groupBy = false;
    if(ECL_GetValue(sTargetAttribute) != ""){
        query += "SELECT DISTINCT "+sTargetAttribute+" FROM ["+DBtable+"]";
        groupBy = true;
    }
    else{
        query += "SELECT DISTINCT * FROM ["+DBtable+"]"
    }

     for(var i =0; i < whereClauselAttributes.length; i++){
         
         if(whereClauselAttributes[i] != sTargetAttribute && ECL_GetValue(whereClauselAttributes[i]) != ""){
             
             if(first == true){
                query += " where " + whereClauselAttributes[i]+ " like '"+ECL_GetValue(whereClauselAttributes[i])+"'";
                first = false;
                continue;
            }

            if(first == false){
                query += " AND " + whereClauselAttributes[i]+ " like '"+ECL_GetValue(whereClauselAttributes[i])+"'";
                continue;
            }
        }
    }

    if(first == true){
        return "";
    }

    if(groupBy == true){
        query += " GROUP BY " + sTargetAttribute;
    }

    return query;

}

/**
 * 
 * @param {*} sTargetAttribute  Das Zielattribut um das es geht
 * @param {*} DBresult          Die gefundenen Werte aus der Datenbank
 */
function activateAndSelectAttributeValues(sTargetAttribute, DBresult){

    var controlType = ECL_GetControlType(sTargetAttribute);
    var autoSelected = ECL_AttributeAutoSelected(sTargetAttribute);
    var activatedValues = [];
    ECL_DeactivateAllAttributeValues(sTargetAttribute);

    //Werte Aktivieren
    for(var i = 0; i < DBresult.length; i++){
        
        var valueActive = false; 
        for(var j = 0; j < activatedValues.length; j++ ){
            
            if(DBresult[i][sTargetAttribute] == activatedValues[j]){// Kontrolle ob der Wert schon aktiviert ist
                valueActive = true;
                break;
            }
        }

        if(valueActive == false){
            ECL_ActivateValue(sTargetAttribute, DBresult[i][sTargetAttribute]);
            activatedValues.push(DBresult[i][sTargetAttribute]);
        }
    }

    //Werte Setzen
    if(activatedValues.length ==1 && autoSelected == true){

        if(controlType != "EDIT"){
            ECL_SelectValue(sTargetAttribute, DBresult[0][sTargetAttribute]);
        }
        else{
            ECL_SetValue(sTargetAttribute, DBresult[0][sTargetAttribute]);
        }
    }
    
    if(activatedValues.length !=1 && autoSelected == true && controlType == "EDIT"){
        var found = false;
        for(var i = 0; i< activatedValues.length; i++){
            if(ECL_GetValue(sTargetAttribute) == activatedValues[i] ){
                found = true;
                break;
            }
        }

        if(found == false){
            ECL_SetValue(sTargetAttribute, "");
        }
    }

}

/**
 * Die function aktiviert von allen Attributen aus der gegebenen tabelle die gefundenen Werte 
 * @param {} DBtable Die tabelle aus er Datenbank
 */
function activateMultipleAttributeValues(DBtable){
    var attributes = Object.fromDatabase("EXTERNAL_DATA","PRAGMA table_info("+DBtable+")").map(x => x.NAME);
    var query;
    for(var i =0; i<attributes.length; i++){
        query = buildQuery(attributes[i], attributes, DBtable);

        if(query == ""){
            ECL_ActivateAllAttributeValues(attributes[i]);
            ECL_EnableAllAttributeValues(attributes[i]);
        }
        else{
            var result = Object.fromDatabase("EXTERNAL_DATA", query);
            activateAndSelectAttributeValues(attributes[i], result);
        }
    }
}

function setOutputreactorOrFilter() {
    var motorReactor = ECL_GetValue("OZ_MOTORDROSSELN_G130");
    var dudtFilter = ECL_GetValue("OZ_DUDTFILTERPLUSVPL_G130");
    var dudtCompactFilter = ECL_GetValue("OZ_DUDTFILTERCOMPACT_G130");
    var sinusFilter = ECL_GetValue("OZ_SINUSFILTER_G130");

    if (motorReactor !== "FALSE") {
        ECL_SetValue("ECSI_CC_OutputReactorOrFilter", motorReactor);
        ECL_SetValue("ECSI_CC_OutputReactorOrFilterType", 1);
    } else if (dudtFilter !== "FALSE") {
        ECL_SetValue("ECSI_CC_OutputReactorOrFilter", dudtFilter);
        ECL_SetValue("ECSI_CC_OutputReactorOrFilterType", 4);
    } else if (dudtCompactFilter !== "FALSE") {
        ECL_SetValue("ECSI_CC_OutputReactorOrFilter", dudtCompactFilter);
        ECL_SetValue("ECSI_CC_OutputReactorOrFilterType", 5);
    } else if (sinusFilter !== "FALSE") {
        ECL_SetValue("ECSI_CC_OutputReactorOrFilter", sinusFilter);
        ECL_SetValue("ECSI_CC_OutputReactorOrFilterType", 3);
    } else {
        ECL_SetValue("ECSI_CC_OutputReactorOrFilter", "");
        ECL_SetValue("ECSI_CC_OutputReactorOrFilterType", 0);
    }
}

function manageKeepconfig()
{
    var s_mlfb =    ECL_GetValue("ECSI_MLFB");
    var isStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    var strBaseTypeMLFB=ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    
    if(isStartConfiguration=="1" && s_mlfb!=strBaseTypeMLFB && find(s_mlfb,".")<0)
    {	
        s_mlfb = repairConfiguration(s_mlfb);	   
        var aBaseTypeMLFB=strBaseTypeMLFB.split('');
        var as_mlfb=s_mlfb.split('');
        for (var i=0;i<aBaseTypeMLFB.length;i++)
        {
            if(aBaseTypeMLFB[i] != ".")
            {
                as_mlfb[i]=aBaseTypeMLFB[i];
            }
        }
        
        s_mlfb="";
        for (var i=0;i<as_mlfb.length;i++)
            s_mlfb=s_mlfb+as_mlfb[i];
    
        ECL_SetValue("ECSI_MLFB", s_mlfb);
    }
    else if(isStartConfiguration=="1")
        ECL_SetValue("ECSI_MLFB", strBaseTypeMLFB);
    else
        ECL_SetValue("ECSI_MLFB", s_mlfb);
}

function repairConfiguration(primaryMlfb) {
    if (primaryMlfb.length < 16) 
        return primaryMlfb;
    
    var aPrimaryMlfb = primaryMlfb.split('');
    var validValuesForMLFB10_13 = getValidValuesForMLFB10_13();

    if (!validValuesForMLFB10_13.has(aPrimaryMlfb[9] + aPrimaryMlfb[10] + aPrimaryMlfb[11] + aPrimaryMlfb[12])) {
        var validValue = determineFrameSizeFromMlfbFragment();
        aPrimaryMlfb[9] = validValue[0];
        aPrimaryMlfb[10] = validValue[1];
        aPrimaryMlfb[11] = validValue[2];
        aPrimaryMlfb[12] = validValue[3];
    }

    return aPrimaryMlfb.join('');
}

function getValidValuesForMLFB10_13() {
    var result = new Set();
    var relevanttables = ["VT_G130_M00019_26840", "VT_G130_M00020_26840", "VT_G130_M00021_26840", "VT_G130_M00022_26840", "VT_G130_M00024_26840", 
    "VT_G130_M00025_26840", "VT_G130_M00026_26840", "VT_G130_M00027_26840", "VT_G130_M00032_26840"];

    relevanttables.forEach(table => {
        getAttributesFromTable(table, "H_MLFB10_13_G130").forEach(element => {
            result.add(element);
        });
    });

    return result;
}


function getAttributesFromTable(DBtable, attribute){
    var query = `SELECT DISTINCT ${attribute} FROM [${DBtable}]`;
    return Object.fromDatabase("EXTERNAL_DATA", query).map(x => x[attribute]);
}
