//@legacy
//#mode(full-ecma)

// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_G220
// 	Date: 2024-08-31
// 	User: Administrator
// ---------------------------------------------------------

//@import "G220_CONFIG/CFG_G220_VT.js"
//@import "G220_CONFIG/CFG_G220_INIT_FC.js"
//@import "G220_CONFIG/CFG_G220_INIT_ACCESSORIES.js"
//@import "G220_CONFIG/CFG_G220_PRODUCT_LOGIC.js"
//@import "G220_CONFIG/CFG_G220_GENERIERE_KAG.js"
//@import "G220_CONFIG/CFG_G220_CONSEQUENCES.js"
//@import "G220_PARSER/Parser.G220.parse.js"

//@import "SIZER_general_functions.js"

VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables

var sDB_Version = "27042"; // DB-Version (SPC-version 40.13)
var sDB_Suffix = "_" + sDB_Version; // DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {
  // Derive evaluation of ECSI attributes from primary MLFB
  SetAttributesFromMlfb();

  //checkDB
  var sTable = "VT_G220_M00389" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + ";";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", "ERROR no db connection");
    return;
  }
  // #####################################################################################################################
  /* MLFB-Struktur
  // #####################################################################################################################
  MLFB01-5: 6SL41
  MLFB06: 1 CU 						HMK_CU_TYPE_G220	VT240 MLFB1_5 + 6
  MLFB07: Spannung	 				HMK_VOLTAGE_G220
  MLFB08: Topologie					HMK_TOPOLOGY_G220	[GPD, RGD, LHD, CPD] Werte 00001...00004
  MLFB09: (.) Schutzart IP				PMD_ABJ176_001_000_G220	Schutzart IP, 3C2/3C3, repair switch
  MLFB10: . Hardware Option				HMK_HW_OPTION_G220 (J: J=Braking chopper internal 50%Ed-100% Pnenn, A: A=No configuration / Not used, P: P=IEC-Type Gland plate by IP21/IP55, Q: Q=NEC-Type Gland plate by UL type 1/12)
  MLFB11: Leistung 1 (0-5: 0,55kW)	HMK_RATED_POWER_G220	Bemessungsleistung
  MLFB12: Leistung 2 (0-5: 0,55kW)	
  MLFB13: . EMC-Filterklassee			HMK_EMC_TYPE_G220	
  MLFB14: . Hardware options (A=No additional HW-options or short option (KAG), B=DQ-Module, E=IOT-Module, F=Atex-Module)
  MLFB15:	. Feldbus						HMK_FIELDB_TYPE_G220
  MLFB16:	1 Version / Production release
	
  SeriesID
    72020	GPD		SINAMICS G220 Standard		IP20		G220GPDIP20
    72050	GPD		SINAMICS G220 Standard		IP55		G220GPDIP55
    72220	CPD		SINAMICS G220 Clean Power	IP20		G220CPDIP20
    72250	CPD		SINAMICS G220 Clean Power	IP55		G220CPDIP55
	
  Powermodule
  SeriesID	PM_ID		Series_Des_ID	CX_Installation		AmbientTemperatureMax
  72020		102020		G220GPDIP20		Cabinet				60
  72020		102021		G220GPDIP20		Cabinet				60
  72020		102022		G220GPDIP20		Cabinet				60
  72220		102221		G220CPDIP20		Cabinet				60
	
  72050		102050		G220GPDIP55		Decentral			50
  72050		102051		G220GPDIP55		Decentral			50
  72050		102052		G220GPDIP55		Decentral			50
  72250		102251		G220CPDIP55		Decentral			50

  6SL41120..05...0
	
  */

  var sECSI_MLFB = ""; // Parameter für Basis-MLFB
  var sECSI_MLFB_SEC = ""; // Parameter für zusätzliche MLFBs
  var sECSI_MLFB_BASE_TYPE = ""; // Parameter für BaseType-MLFB

  var sECSI_STATUS = ""; // Status für MLFB-Übergabe
  var sECSI_STATUS_MESSAGE = ""; // Statusmeldung für MLFB-Übergabe

  var sCurrentAttribute = ECL_GetCurrentAttribute() || "";

  // Dummy Aufrufe von SIZER unterdrücken
  //	if (sCurrentAttribute == "")
  //		return;

  if (sCurrentAttribute.left(7) == "ECSI_CX") return;

  // ##############################################################################################
  // INIT
  // ##############################################################################################

  if (sCurrentAttribute === "@INIT@") {
    //Initialisierung
    SetConfiguration_Init();
    return; // nach Init direkt return, ein separater Aufruf mit MLFB folgt noch
  }

  // ##############################################################################################
  // PARAMS
  // ##############################################################################################

  var ECSI_IS_START_CONFIGURATION = parseInt(
    ECL_GetValue("ECSI_IS_START_CONFIGURATION")
  );

  // Context attributes
  var ECSI_CX_FieldbusInterface =
    ECL_GetValue("ECSI_CX_FieldbusInterface") || "";
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions") || "";
  var ECSI_CX_RegenerativeMode = ECL_GetValue("ECSI_CX_RegenerativeMode") || "";
  var ECSI_CX_CustomBrakingResistor =
    ECL_GetValue("ECSI_CX_CustomBrakingResistor") || "";
  var ECSI_CX_MotorTechnology = ECL_GetValue("ECSI_CX_MotorTechnology") || "";
  var ECSI_CX_Certificates = ECL_GetValue("ECSI_CX_Certificates") || "";
  var ECSI_CX_FrequencyConverterDefaultIpProtectionLevel =
    ECL_GetValue("ECSI_CX_FrequencyConverterDefaultIpProtectionLevel") || "";

  // ##############################################################################################

  // ##############################################################################################
  // SeriesID
  // ##############################################################################################
  /**
  72020	GPD		SINAMICS G220 Standard		IP20		G220GPDIP20
  72050	GPD		SINAMICS G220 Standard		IP55		G220GPDIP55
  72220	CPD		SINAMICS G220 Clean Power	IP20		G220CPDIP20
  72250	CPD		SINAMICS G220 Clean Power	IP55		G220CPDIP55
  */

  var strSeriesID = ECL_GetValue("ECSI_CX_SeriesID");

  switch (strSeriesID) {
    case "72020":
      // Gerätetyp			PMD_ABJ177_001_000_G220
      var PMD_ABJ177_001_000_G220 = "00001"; // G220 Standard (GPD)
      // Topologie			HMK_TOPOLOGY_G220
      var HMK_TOPOLOGY_G220 = "00001"; // GPD
      // Schutzart IP 		PMD_ABJ176_001_000_G220
      var PMD_ABJ176_001_000_G220 = "Z0012"; // IP20
      // Schutzart NEMA	 	PMD_ABM455_001_000_G220
      var PMD_ABM455_001_000_G220 = "00003"; // UL open
      // Schutzart			HMK_SCHUTZART_1011410
      var HMK_SCHUTZART_1011410 = "00016"; // UL open/ IP20
      if (ECSI_CX_FrequencyConverterDefaultIpProtectionLevel !== "20") {
        var sErrorCX = "DICT1_ERR_G220___CX_IP_SERIES_ID";
      }
      break;
    case "72050":
      // Gerätetyp	PMD_ABJ177_001_000_G220
      var PMD_ABJ177_001_000_G220 = "00001"; // G220 Standard (GPD)
      var HMK_TOPOLOGY_G220 = "00001"; // GPD
      var PMD_ABJ176_001_000_G220 = "Z0003"; // IP55
      var PMD_ABM455_001_000_G220 = "00002"; // UL 12
      var HMK_SCHUTZART_1011410 = "00014"; // UL 12/ IP55
      if (ECSI_CX_FrequencyConverterDefaultIpProtectionLevel !== "55") {
        var sErrorCX = "DICT1_ERR_G220___CX_IP_SERIES_ID";
      }
      break;
    case "72220":
      // Gerätetyp	PMD_ABJ177_001_000_G220
      var PMD_ABJ177_001_000_G220 = "00002"; // G220 Clean Power (CPD)
      var HMK_TOPOLOGY_G220 = "00004"; // CPD
      var PMD_ABJ176_001_000_G220 = "Z0012"; // IP20
      var PMD_ABM455_001_000_G220 = "00003"; // UL open
      var HMK_SCHUTZART_1011410 = "00016"; // UL open/ IP20
      if (ECSI_CX_FrequencyConverterDefaultIpProtectionLevel !== "20") {
        var sErrorCX = "DICT1_ERR_G220___CX_IP_SERIES_ID";
      }
      break;
    case "72250":
      // Gerätetyp	PMD_ABJ177_001_000_G220
      var PMD_ABJ177_001_000_G220 = "00002"; // G220 Clean Power (CPD)
      var HMK_TOPOLOGY_G220 = "00004"; // CPD
      var PMD_ABJ176_001_000_G220 = "Z0003"; // IP55
      var PMD_ABM455_001_000_G220 = "00002"; // UL 12
      var HMK_SCHUTZART_1011410 = "00014"; // UL 12/ IP55
      if (ECSI_CX_FrequencyConverterDefaultIpProtectionLevel !== "55") {
        var sErrorCX = "DICT1_ERR_G220___CX_IP_SERIES_ID";
      }
      break;
    default:
      var PMD_ABJ177_001_000_G220 = "00001"; // G220 Standard (GPD)
      var HMK_TOPOLOGY_G220 = "00001"; // GPD
      var PMD_ABJ176_001_000_G220 = "Z0012"; // IP20
      var PMD_ABM455_001_000_G220 = "00003"; // UL open
      var HMK_SCHUTZART_1011410 = "00016"; // UL open/ IP20
  }
  if (sErrorCX) {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sErrorCX));
    return;
  }
  ECL_DeactivateAllAttributeValues("PMD_ABJ177_001_000_G220");
  ECL_DeactivateAllAttributeValues("HMK_TOPOLOGY_G220");
  ECL_DeactivateAllAttributeValues("PMD_ABJ176_001_000_G220");
  ECL_DeactivateAllAttributeValues("PMD_ABM455_001_000_G220");
  ECL_DeactivateAllAttributeValues("HMK_SCHUTZART_1011410");

  ECL_ActivateValue("PMD_ABJ177_001_000_G220", PMD_ABJ177_001_000_G220);
  ECL_ActivateValue("HMK_TOPOLOGY_G220", HMK_TOPOLOGY_G220);
  ECL_ActivateValue("PMD_ABJ176_001_000_G220", PMD_ABJ176_001_000_G220);
  ECL_ActivateValue("PMD_ABM455_001_000_G220", PMD_ABM455_001_000_G220);
  ECL_ActivateValue("HMK_SCHUTZART_1011410", HMK_SCHUTZART_1011410);

  ECL_SelectValue("PMD_ABJ177_001_000_G220", PMD_ABJ177_001_000_G220);
  ECL_SelectValue("HMK_TOPOLOGY_G220", HMK_TOPOLOGY_G220);
  ECL_SelectValue("PMD_ABJ176_001_000_G220", PMD_ABJ176_001_000_G220);
  ECL_SelectValue("PMD_ABM455_001_000_G220", PMD_ABM455_001_000_G220);
  ECL_SelectValue("HMK_SCHUTZART_1011410", HMK_SCHUTZART_1011410);

  // ##############################################################################################

  // #####################################################################################################################################
  // MLFB-PARSER
  // #####################################################################################################################################
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
  if (sECSI_MLFB == "") return;


  if (sCurrentAttribute == "ECSI_MLFB") {
    sECSI_MLFB_BASE_TYPE = ECL_GetValue("ECSI_MLFB_BASE_TYPE") || "";
    if (sECSI_MLFB_BASE_TYPE == "") {
      return;
    }

    var sStatus = analyzePrimaryMLFB();
    if (sStatus != "") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
      return;
    }
  }

  // #############################################################################################################
  // Context-Attributes
  // #############################################################################################################
  /**
  var sECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  */
  var sECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");

  // #############################################################################################################
  // Konfigurationslogik anwenden
  // #############################################################################################################
  var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
  if (sECSI_MLFB == "") {
    return;
  }

  // ###################################################################################################################################
  // LOGIK
  // ###################################################################################################################################
  var sMLFB16 = sECSI_MLFB.left(16);

  if (sMLFB16.indexOf(".") < 0) {
    var sStatus = ExecProductLogicG220(sCurrentAttribute);
    if (sStatus != "OK") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
      return;
    }

    // Zusätzliche MLFBs setzen
    // SetMlfbSec(sECSI_MLFB_SEC);
  } else {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue(
      "ECSI_STATUS_MESSAGE",
      ECL_Translate("DICT1_ERR_G220___INCOMPLETE_MLFB")
    );
    return;
  }

  // ###################################################################################################################################
  // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
  // ###################################################################################################################################
  var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // diese kann sich durch die Konfiguration geändert haben, insbes. in den ersten 16 Stellen

  var full_mlfb = GenKAG_G220(sBaseTypeMLFB, sECSI_MLFB);
  ECL_SetValue("ECSI_MLFB", full_mlfb);

  // ###################################################################################################################################
  // Sek-MLFB erzeugen
  // ###################################################################################################################################
  sECSI_MLFB_SEC = genMlfbSec();
  SetMlfbSec(sECSI_MLFB_SEC);
  // ###########################################################################################################
  // Consequences
  // ###########################################################################################################
  /**
   * ControlUnit
   * BrakingResistorID
   * SelectedCustomBrakingResistor
   * BrakeRelays
   *
   * InputFilterType
   * ExternalFilterType
   *
   * MaxOutputFrequencyLimit
   * MaxPulseFrequency
   * MinPulseFrequency
   * OutputReactorOrFilter
   * OutputReactorOrFilterType
   *
   */
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // frisch besorgen, kann überall geändert worden sein
  var oConsequences = determineConsequencesG220(sECSI_MLFB);

  /*    if(oConsequences.MaxOutputFrequencyLimit == "ERROR"){
        ECL_SelectValue ("ECSI_STATUS", "E");
        ECL_SetValue ("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_G220___CC_XXXXXXXXX"));
        return;
    }

  // MaxOutputFrequencyLimit
  var MaxOutputFrequencyLimit = "";
  var MaxPulseFrequency = "";
  var MinPulseFrequency = "";
	
  if (bLimitOutFrequency){
    MaxOutputFrequencyLimit = "150";
    MaxPulseFrequency = "4";
    MinPulseFrequency = "4";
  }
  */
  //	ECL_SelectValue("ECSI_CC_ControlUnit", oConsequences.ControlUnit);
  ECL_SelectValue("ECSI_CC_InputFilterType", oConsequences.InputFilterType);
  ECL_SelectValue("ECSI_CC_ExternalFilterType", oConsequences.ExternalFilterType);
  //    ECL_SelectValue("ECSI_CC_MinPulseFrequency", oConsequences.MinPulseFrequency);
  //    ECL_SelectValue("ECSI_CC_MaxOutputFrequencyLimit", oConsequences.MaxOutputFrequencyLimit);
  //    ECL_SelectValue("ECSI_CC_MaxPulseFrequency", oConsequences.MaxPulseFrequency);
  ECL_SelectValue("ECSI_CC_OutputReactorOrFilterType", oConsequences.OutputReactorOrFilterType);
  ECL_SelectValue("ECSI_CC_OutputReactorOrFilter", oConsequences.OutputReactorOrFilter);
  ECL_SelectValue("ECSI_CC_IpProtectionLevelFrequencyConverter", oConsequences.IpProtectionLevelFrequencyConverter);

  // BrakingResistorID
  if (oConsequences.BrakingResistorID == "ERROR") {
    ECL_SelectValue("ECSI_CC_BrakingResistorID", "");
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_1FT2___NO_CABLE_DQ"));
    return;
  }
  ECL_SelectValue("ECSI_CC_BrakingResistorID", oConsequences.BrakingResistorID);
  ECL_SelectValue("ECSI_CC_SelectedCustomBrakingResistor", oConsequences.SelectedCustomBrakingResistor);

  /// ###########################################################################################################
  if (ECL_GetValue("CB_HMK_SC_OM_DQ_G220") === "T")
    ECL_SetValue("ECSI_CC_Selected_CU", "G220");
  else {
    ECL_SetValue("ECSI_CC_Selected_CU", "");
  }

  // ###########################################################################################################
  // Fehlerstatus setzen
  if (sECSI_STATUS !== "E") {
    sECSI_STATUS = "OK";
  }
  // Übergabestatus setzen
  ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
  ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);

  ECL_DeactivateAttribute("PMD_ACS927_001_000_G220"); // Ausgangsstrom
  ECL_DisableAttribute("HMK_RATED_CURRENT_UI_1011270"); // Ausgangsstrom
  ECL_DisableAttribute("HMK_CB_UL_VOLTAGE_R_1011270"); // Betriebsspannung
  ECL_DisableAttribute("HMK_MS_UL_VOLTAGE_R_1011270"); // Betriebsspannung
  ECL_DeactivateAttribute("PMD_ACU384_001_000_G220_X"); // Bemessungsleistung NEC
  ECL_DeactivateAttribute("HMK_NETZFREQUENZ_1011270"); // Netzfrequenz
  ECL_DeactivateAttribute("PMD_ABM455_001_000_G220"); // Schutzart NEMA
  ECL_DeactivateAttribute("HMK_SCHUTZART_1011410"); // HMK_SCHUTZART_1011410
  ECL_DeactivateAttribute("HMK_PROTECTION_G220"); // HMK_PROTECTION_G220
  ECL_DeactivateAttribute("PMD_ABY445_001_000_G220"); // EMC Filter (PMD)
  ECL_DeactivateAttribute("HMK_BRAKERESISTOR_G220"); // UI_HMK_BRAKERESISTOR_G220 Bremswiderstand
  ECL_DeactivateAttribute("HMK_TOPOLOGY_G220");
  //ECL_DeactivateAttribute("HMK_HW_OPTION_G220");
  ECL_DeactivateAttribute("HMK_OM_SMT_1011270");
  ECL_DeactivateAttribute("HMK_OM_DQ_1011270");
  ECL_DeactivateAttribute("HMK_OM_IIOT_1011270");

  // No SMC in 11/2023 reactivated in update kb-version 18.18 (db-version 25320)
  ECL_SelectValue("HMK_SENSORMODULE_1011270", "00001");
  ECL_DeactivateAttribute("HMK_SENSORMODULE_1011270");
  // No DQ_Cable for Release 08/23024 HMK_DQ_LEITUNG_1011270_X
  ECL_SelectValue("HMK_DQ_LEITUNG_1011270_X", ".");
  ECL_DeactivateAttribute("HMK_DQ_LEITUNG_1011270_X");

  ECL_DeactivateAttribute("HMK_CU_TYPE_G220");
  ECL_DeactivateAttribute("HMK_CU_ID_G220");
  ECL_DeactivateAttribute("HMK_FIELDB_TYPE_G220");
  ECL_DeactivateAttribute("PMD_ACJ913_001_000_G220");
  ECL_DeactivateAttribute("HMK_FRAMESIZE_G220");
  ECL_DeactivateAttribute("HMK_FS_HELPER_G220");
  ECL_DeactivateAttribute("HMK_RUNTIME_VER_G220");
  ECL_DeactivateAttribute("HMK_DQ_SUPPORTED__G220");
  ECL_DeactivateAttribute("HMK_VOLTAGE_PW_KEY_1011270");

  ECL_DeactivateAttribute("TC_05_1011270");
  ECL_DeactivateAttribute("TC_06_1011530");
  ECL_DeactivateAttribute("TC_07_1011270");
  ECL_DeactivateAttribute("TC_08_1011270");
  ECL_DeactivateAttribute("TC_09_1011270");
  ECL_DeactivateAttribute("TC_10_1011270");
  ECL_DeactivateAttribute("TC_11_1011410");
  ECL_DeactivateAttribute("TC_13_1011270");
  ECL_DeactivateAttribute("TC_14_1011270");
  ECL_DeactivateAttribute("TC_15_1011270");
  ECL_DeactivateAttribute("TC_16_1011270");

  ECL_DeactivateAttribute("MLFB05_G220");
  ECL_DeactivateAttribute("MLFB06_G220");
  ECL_DeactivateAttribute("MLFB07_G220");
  ECL_DeactivateAttribute("MLFB08_G220");
  ECL_DeactivateAttribute("MLFB09_G220");
  ECL_DeactivateAttribute("MLFB10_G220");
  ECL_DeactivateAttribute("MLFB11_G220");
  ECL_DeactivateAttribute("MLFB12_G220");
  ECL_DeactivateAttribute("MLFB13_G220");
  ECL_DeactivateAttribute("MLFB14_G220");
  ECL_DeactivateAttribute("MLFB15_G220");
  ECL_DeactivateAttribute("MLFB16_G220");

  ECL_DeactivateAttribute("HMK_MOD_CAPACITY__G220");

  // MLFB-Attribute ausblenden
  ECL_DeactivateAttribute("HMK_CB_IEC_MLFB_CPL_1011270"); // MLFB Leistungsschalter IEC
  ECL_DeactivateAttribute("HMK_CB_UL_MLFB_CPL_1011270"); // MLFB Leistungsschalter UL
  ECL_DeactivateAttribute("HMK_MS_IEC_MLFB_CPL_1011270"); // MLFB Motorschutzschalter IEC
  ECL_DeactivateAttribute("HMK_MS_UL_MLFB_CPL_1011270"); // MLFB Motorschutzschalter UL
  ECL_DeactivateAttribute("HMK_SCFUSE_IEC_MLFB_1011270"); // MLFB Halbleitersicherung IEC
  ECL_DeactivateAttribute("HMK_SCFUSE_UL_MLFB_1011270"); // MLFB Halbleitersicherung UL
  ECL_DeactivateAttribute("HMK_FUSE_IEC_MLFB_1011270"); // MLFB Standardsicherung
  ECL_DeactivateAttribute("HMK_ACC_BRAKING_G220"); // MLFB Bremswiderstand

  // Hilfsspannungen ausblenden
  ECL_DeactivateAttribute("HMK_DISCR_VOLTAGE_G220");
  ECL_DeactivateAttribute("HMK_CB_IEC_ICC_V_1011270");
  ECL_DeactivateAttribute("HMK_MS_IEC_ICC_V_1011270_X");
  ECL_DeactivateAttribute("HMK_SCFUSE_IEC_ICC_V_1011270");
  ECL_DeactivateAttribute("HMK_FUSE_IEC_ICC_V_1011270");
};

function SetConfiguration_Init() {
  var oData = {};

  SetInverter_Init(oData);
  SetAccessories_Init(oData);
}

function analyzePrimaryMLFB() {
  // ----------------------------------------------------------------------------------------------------------------
  // MLFB parsen
  // ----------------------------------------------------------------------------------------------------------------
  var oData = parse_Init_G220(ECL_GetValue("ECSI_MLFB"));
  if (oData.strError != "") {
    return oData.strError;
  }
  // ----------------------------------------------------------------------------------------------------------------

  if (oData.strError == "") {
    SetInverter_Init(oData); // Set Attributes from MLFB
    SetAccessories_Init(oData);
  } else {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oData.strError));
    return oData.strError;
  }
  if (oData.strError != "") {
    return oData.strError;
  }
  return "";
}
