//@legacy
//#mode(full-ecma)


// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_S150
// 	Date: 2024-11-12
// 	User: Administrator
// ---------------------------------------------------------

//@import "S150_CONFIG/CFG_S150_VT.js"
//@import "S150_CONFIG/CFG_S150_INIT_FC.js"
//@import "S150_CONFIG/CFG_S150_SecMLFB.js"
//@import "S150_CONFIG/CFG_S150_OPTIONEN_1.js"
//@import "S150_CONFIG/CFG_S150_OPTIONEN_2.js"
//@import "S150_CONFIG/CFG_S150_OPTIONEN_4.js"
//@import "S150_CONFIG/CFG_S150_PRODUCT_LOGIC.js"
//@import "S150_CONFIG/CFG_S150_GENERIERE_KAG.js"
//@import "S150_CONFIG/CFG_S150_CONSEQUENCES.js"
//@import "S150_PARSER/Parser.S150.parse.js"

//@import "SIZER_general_functions.js"

VariantTables.Logger.setLevel(VariantTables.LogLevel.Trace); // Enable tracing of Variant Table calls (for debugging)
var simpleInference = new VariantTables.SimpleInference(); // Instanciate Variant Tables

// var sDB_Version = "25568";		// Init-Release DB-Version 40.27
// var sDB_Version = "26357"; // DB-Version 40.30 for TST 11/2024
// var sDB_Version = "26573"; // DB-Version 40.31 for TST 12/2024
var sDB_Version = "27048"; // DB-Version 40.36 for TST 12/2024
var sDB_Suffix = "_" + sDB_Version; // DB-TableSuffix

globalThis.OnChangeConfiguration = function main() {
  // Derive evaluation of ECSI attributes from primary MLFB
  SetAttributesFromMlfb();

  // #####################################################################################################################
  /* MLFB-Struktur
  // #####################################################################################################################
  MLFB01: 6SL3
  MLFB05: 7
  MLFB06: 1
  MLFB07: 0
  MLFB08: 7 
  MLFB09: L
  MLFB10: Spannungsbereich [E,G]	==>	IN_SPANNUNG_S150, HMK_SPANNUNG_BEREICH_S150
  MLFB11: Leistung 123 	HMK_MLFB10_13_S150 4 digits! (MLFB10...13)
  MLFB12: Leistung 2 
  MLFB13: Leistung 3 
  MLFB14: A
  MLFB15:	A 
  MLFB16:	3 
	
  HMK_MLFB10_13_S150 

  SeriesID
  32150	SINAMICS S150	
  */

  var sECSI_MLFB = ""; // Parameter für Basis-MLFB
  var sECSI_MLFB_SEC = ""; // Parameter für zusätzliche MLFBs
  var sECSI_MLFB_BASE_TYPE = ""; // Parameter für BaseType-MLFB

  var sECSI_STATUS = ""; // Status für MLFB-Übergabe
  var sECSI_STATUS_MESSAGE = ""; // Statusmeldung für MLFB-Übergabe

  var sCurrentAttribute = ECL_GetCurrentAttribute() || "";

  // Dummy Aufrufe von SIZER unterdrücken
  //	if (sCurrentAttribute == "")
  //		return;

  if (sCurrentAttribute.left(7) == "ECSI_CX") return;

  // ##############################################################################################
  // INIT
  // ##############################################################################################

  if (sCurrentAttribute === "@INIT@") {
    //Initialisierung
    SetConfiguration_Init();
    return; // nach Init direkt return, ein separater Aufruf mit MLFB folgt noch
  }

  // ##############################################################################################
  // PARAMS
  // ##############################################################################################

  var ECSI_IS_START_CONFIGURATION = parseInt(ECL_GetValue("ECSI_IS_START_CONFIGURATION"));

  // Context attributes
  var ECSI_CX_FieldbusInterface = ECL_GetValue("ECSI_CX_FieldbusInterface") || "";
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions") || "";
  var ECSI_CX_RegenerativeMode = ECL_GetValue("ECSI_CX_RegenerativeMode") || "";
  var ECSI_CX_CustomBrakingResistor = ECL_GetValue("ECSI_CX_CustomBrakingResistor") || "";
  var ECSI_CX_MotorTechnology = ECL_GetValue("ECSI_CX_MotorTechnology") || "";
  var ECSI_CX_Certificates = ECL_GetValue("ECSI_CX_Certificates") || "";

  var ECSI_CX_AmbientTemperatureFrequencyConverter = ECL_GetValue("ECSI_CX_AmbientTemperatureFrequencyConverter") || "";
  if (ECSI_CX_AmbientTemperatureFrequencyConverter !== "") {
    var IN_UMGEB_TEMP_S150 = ECSI_CX_AmbientTemperatureFrequencyConverter;
    ECL_SetValue("IN_UMGEB_TEMP_S150", IN_UMGEB_TEMP_S150);
  }

  var ECSI_CX_InstallationAltituteFrequencyConverter = ECL_GetValue("ECSI_CX_InstallationAltituteFrequencyConverter") || "";
  if (ECSI_CX_InstallationAltituteFrequencyConverter !== "") {
    var IN_AUSTELLHOEHE_S150 = ECSI_CX_InstallationAltituteFrequencyConverter;
    ECL_SetValue("IN_AUSTELLHOEHE_S150", IN_AUSTELLHOEHE_S150);
  }
  // ##############################################################################################

  // ##############################################################################################
  // SeriesID   30150  SINAMICS S150
  // ##############################################################################################
  /**
   * 
   */
  var strSeriesID = ECL_GetValue("ECSI_CX_SeriesID");

  // ##############################################################################################

  // #####################################################################################################################################
  // MLFB-PARSER
  // #####################################################################################################################################
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
  if (sECSI_MLFB == "") return;

  if (sCurrentAttribute == "ECSI_MLFB") {
    sECSI_MLFB_BASE_TYPE = ECL_GetValue("ECSI_MLFB_BASE_TYPE") || "";
    if (sECSI_MLFB_BASE_TYPE == "") {
      return;
    }

    var sStatus = analyzePrimaryMLFB();
    if (sStatus != "") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue("ECSI_STATUS_MESSAGE", translate(sStatus));
      return;
    }
  }

  /*var aMlfbSec = ECL_GetValue("ECSI_MLFB_SEC").split(";");
  if (aMlfbSec.length > 0) {
    if (aMlfbSec.includes("9SV11103AA000AA0")) {
      ECL_SelectValue("DRIVE_SIM_DESIGNER_S150", "T");
    }
  }
  */

  // #############################################################################################################
  // Context-Attributes
  // #############################################################################################################
  /**
  var sECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  ECSI_CX_StandardSupplySystem
  ECSI_CX_FieldbusInterface
  ECSI_CX_SafetyFunctions
  ECSI_CX_MotionControlRequirements
  ECSI_CX_SpeedControlMode
  ECSI_CX_RegenerativeMode
  ECSI_CX_CustomBrakingResistor	???
  ECSI_CX_MotorTechnology
  ECSI_CX_Certificates

  ECSI_CX_ConverterRatedPower

  ECSI_CX_InstallationAltituteFrequencyConverter
  ECSI_CX_AmbientTemperatureFrequencyConverter

  ECSI_CX_FrequencyConverterDefaultIpProtectionLevel 	O_SCHUTZART_S150

  */
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");

  // IN_AUSTELLHOEHE_S150
  var ECSI_CX_InstallationAltituteFrequencyConverter = ECL_GetValue("ECSI_CX_InstallationAltituteFrequencyConverter");
  ECL_DeactivateAllAttributeValues("IN_UMGEB_TEMP_S150");
  ECL_ActivateValue("IN_UMGEB_TEMP_S150", ECSI_CX_InstallationAltituteFrequencyConverter);
  ECL_SetValue("IN_AUSTELLHOEHE_S150", ECSI_CX_InstallationAltituteFrequencyConverter);

  // IN_UMGEB_TEMP_S150
  var ECSI_CX_AmbientTemperatureFrequencyConverter = ECL_GetValue("ECSI_CX_AmbientTemperatureFrequencyConverter");
  ECL_DeactivateAllAttributeValues("IN_UMGEB_TEMP_S150");
  ECL_ActivateValue("IN_UMGEB_TEMP_S150", ECSI_CX_AmbientTemperatureFrequencyConverter);
  ECL_SetValue("IN_UMGEB_TEMP_S150", ECSI_CX_AmbientTemperatureFrequencyConverter);

  //var ECSI_CX_StandardSupplySystem = ECL_GetValue("ECSI_CX_StandardSupplySystem");

  // HMK_SPANNUNG_BEREICH_S150	abgebildet über HMK_FALLNUMMER_S150 bzw MLFB10_S150
  /*	HMK_SPANNUNG_BEREICH_S150	HMK_FALLNUMMER_S150		MLFB10_S150
    400		380…480 V			00004	S380_480		E
    600		500…600 V			00005	S500_600		F
    690		660…690 V			00006	S660_690		H

  * /

  IN_SPANNUNG_S150
  IN_NETZFREQUENZ_S150
	
  IN_AUSTELLHOEHE_S150
  IN_UMGEB_TEMP_S150
  */

  // #############################################################################################################
  // Konfigurationslogik anwenden
  // #############################################################################################################
  var sECSI_MLFB = ECL_GetValue("ECSI_MLFB") || "";
  if (sECSI_MLFB == "") {
    return;
  }

  // ###################################################################################################################################
  // LOGIK
  // ###################################################################################################################################
  var sMLFB16 = sECSI_MLFB.left(16);

  if (sMLFB16.indexOf(".") < 0) {
    var sStatus = ExecProductLogicS150(sCurrentAttribute);
    if (sStatus != "OK") {
      ECL_SelectValue("ECSI_STATUS", "E");
      ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate(sStatus));
      return;
    }
  } else {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_S150___INCOMPLETE_MLFB"));
    return;
  }

  // ###################################################################################################################################
  // Basis-MLFB erzeugen und Kurzangaben an die MLFB generieren:
  // ###################################################################################################################################
  var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // diese kann sich durch die Konfiguration geändert haben, insbes. in den ersten 16 Stellen

  var full_mlfb = GenKAG_S150(sBaseTypeMLFB, sECSI_MLFB);
  ECL_SetValue("ECSI_MLFB", full_mlfb);

  // ###################################################################################################################################
  // Sekundär-MLFB erzeugen
  // ###################################################################################################################################
  // EDIT 11/2024 SEC-MLFB neccessary for DriveSimDesigner
  var sECSI_MLFB_SEC = genSecMLFB();
  if (sECSI_MLFB_SEC == "ERROR") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_S150___GEN_SEC_MLFB"));
    return;
  }

  // Zusätzliche MLFBs setzen
  SetMlfbSec(sECSI_MLFB_SEC);
  // ###########################################################################################################
  // Consequences
  // ###########################################################################################################
  /**
   * ControlUnit
   * FieldbusInterface - PROFINET / PROFIBUS
   * BrakingResistorID
   * SelectedCustomBrakingResistor
   * BrakeRelays
   *
   * DQ Endpoint - true
   *
   * InputFilterType		- If Line Filter selected 0, by default 3		LineFilter L00
   * ExternalFilterType	 	- If Line Filter selected 2, by default 0		LineFilter L00
   *
   * MaxOutputFrequencyLimit
   * 		- Sine-wave filter: The output frequency is limited to max. 115 Hz (at 500 ... 600 V) and 150 Hz (at 380 ... 480 V)
   *		- dv/dt filter: max 150 Hz
   * MaxPulseFrequency
   * 		- Sine-wave filter: Double of the default pulse frequency
   *  		- dv/dt filter: 380-480V  && "<= 250 kW", 4kHz; other cases: 2,5 kHz
   * MinPulseFrequency
   * 		- Sine-wave filter: Double of the default pulse frequency [Add image]
   * 		kW				default pulse freq [kHz]	Max output freq [Hz]
   * 		110...250		3AC 380...480V: 2				160
   * 		315...900		3AC 380...480V: 1.25			100
   * 		110...1000		3AC 500...600V: 1.25			100
   * 		 75...1500		3AC 660...690V: 1.25			100
   *
   * OutputReactorOrFilter
   * OutputReactorOrFilterType	 - 1,3,4,5 - Based on the selection
   *
   * IpProtectionLevelFrequencyConverter - Based on the selection
   *
   * IsProtectedDevice - If L26 selected
   */
  sECSI_MLFB = ECL_GetValue("ECSI_MLFB"); // frisch besorgen, kann überall geändert worden sein
  var oConsequences = determineConsequencesS150(sECSI_MLFB);

  if (oConsequences.MaxOutputFrequencyLimit == "ERROR") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_S150___CC_MAXOUTPUTFREQUENCYLIMIT"));
    return;
  }
  ECL_SelectValue("ECSI_CC_MaxOutputFrequencyLimit", oConsequences.MaxOutputFrequencyLimit);

  if (oConsequences.MaxPulseFrequency == "ERROR") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_S150___CC_MAXPULSEFREQUENCY"));
    return;
  }
  ECL_SelectValue("ECSI_CC_MaxPulseFrequency", oConsequences.MaxPulseFrequency);

  if (oConsequences.MinPulseFrequency == "ERROR") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_S150___CC_MINPULSEFREQUENCY"));
    return;
  }
  ECL_SelectValue("ECSI_CC_MinPulseFrequency", oConsequences.MinPulseFrequency);

  ECL_SelectValue("ECSI_CC_OutputReactorOrFilterType", oConsequences.OutputReactorOrFilterType);
  ECL_SelectValue("ECSI_CC_OutputReactorOrFilter", oConsequences.OutputReactorOrFilter);
  ECL_SelectValue("ECSI_CC_IpProtectionLevelFrequencyConverter", oConsequences.IpProtectionLevelFrequencyConverter);

  ECL_SelectValue("ECSI_CC_InputFilterType", oConsequences.InputFilterType);
  ECL_SelectValue("ECSI_CC_ExternalFilterType", oConsequences.ExternalFilterType);

  ECL_SelectValue("ECSI_CC_IsProtectiveDevice", oConsequences.IsProtectiveDevice);
  ECL_SelectValue("ECSI_CC_DQEndpoint", oConsequences.DQEndpoint);

  ECL_SelectValue("ECSI_CC_FieldbusInterface", oConsequences.FieldbusInterface);

  ECL_SelectValue("ECSI_CC_Selected_CU", oConsequences.Selected_CU);
  ECL_SelectValue("ECSI_CC_Selected_PMs", oConsequences.Selected_PMs);
  ECL_SelectValue("ECSI_CC_VSM4Motor", oConsequences.VSM4Motor);
  ECL_SelectValue("ECSI_CC_Selected_TM31_1", oConsequences.Selected_TM31_1);
  ECL_SelectValue("ECSI_CC_Selected_TM31_2", oConsequences.Selected_TM31_2);
  ECL_SelectValue("ECSI_CC_Selected_TM150_1", oConsequences.Selected_TM150_1);
  ECL_SelectValue("ECSI_CC_Selected_TM54F", oConsequences.Selected_TM54F);
  ECL_SelectValue("ECSI_CC_Selected_SMC10", oConsequences.Selected_SMC10);
  ECL_SelectValue("ECSI_CC_Selected_SMC20", oConsequences.Selected_SMC20);
  ECL_SelectValue("ECSI_CC_Selected_SMC30_1", oConsequences.Selected_SMC30_1);
  ECL_SelectValue("ECSI_CC_Selected_SMC30_2", oConsequences.Selected_SMC30_2);

  /*	ECL_SelectValue("ECSI_CC_ControlUnit", oConsequences.ControlUnit);
   */

  // BrakingResistorID
  if (oConsequences.BrakingResistorID == "ERROR") {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("DICT1_ERR_S150___CC_BRAKINGRESISTORID"));
    return;
  }
  ECL_SelectValue("ECSI_CC_BrakingResistorID", oConsequences.BrakingResistorID);

  // ###########################################################################################################
  // Fehlerstatus setzen
  if (sECSI_STATUS !== "E") {
    sECSI_STATUS = "OK";
  }
  // Übergabestatus setzen
  ECL_SelectValue("ECSI_STATUS", sECSI_STATUS);
  ECL_SetValue("ECSI_STATUS_MESSAGE", sECSI_STATUS_MESSAGE);

  if (sECSI_STATUS == "E") {
    var stopper = 0;
  }

  ECL_DeactivateAttribute("IN_AUSTELLHOEHE_S150");
  ECL_DeactivateAttribute("IN_UMGEB_TEMP_S150");
  ECL_DeactivateAttribute("IN_SPANNUNG_S150");
  ECL_DeactivateAttribute("IN_FREQUENZ_S150");

  ECL_DeactivateAttribute("O_SONDERLACKIERUNG_S150"); // Freitext

  ECL_DeactivateAttribute("MLFB01_S150");
  ECL_DeactivateAttribute("MLFB05_S150");
  ECL_DeactivateAttribute("MLFB06_S150");
  ECL_DeactivateAttribute("MLFB07_S150");
  ECL_DeactivateAttribute("MLFB08_S150");
  ECL_DeactivateAttribute("MLFB09_S150");
  ECL_DeactivateAttribute("MLFB10_S150");
  ECL_DeactivateAttribute("MLFB11_S150");
  ECL_DeactivateAttribute("MLFB12_S150");
  ECL_DeactivateAttribute("MLFB13_S150");
  ECL_DeactivateAttribute("MLFB14_S150");
  ECL_DeactivateAttribute("MLFB15_S150");
  ECL_DeactivateAttribute("MLFB16_S150");
  ECL_DeactivateAttribute("HMK_MLFB10_13_S150");
  ECL_DeactivateAttribute("IN_SAFETY_S150");
  ECL_DeactivateAttribute("PMD_ABJ176_001_000_S150");
  //ECL_DeactivateAttribute("H_KONFIG_TYP_S150");
  ECL_DeactivateAttribute("H_TRIGGER_IP_M66_S150");
};

function SetConfiguration_Init() {
  var oData = {};

  SetInverter_Init(oData);
  SetOptions1_Init(oData); // Set Attributes from short options (KAG)
  SetOptions2_Init(oData); // Set Attributes from short options (KAG)
  SetOptions4_Init(oData); // Set Attributes from short options (KAG) Doku & Prüfung

  // EDIT 11/2024 SEC-MLFBs neccessary for DriveSimDesigner
  SetOptionsSecMLFB_Init(oData);	// Set Attributes from SEC-MLFB

}

function analyzePrimaryMLFB() {
  // ----------------------------------------------------------------------------------------------------------------
  // MLFB parsen
  // ----------------------------------------------------------------------------------------------------------------
  var oData = parse_Init_S150(ECL_GetValue("ECSI_MLFB"));
  if (oData.strError != "") {
    return oData.strError;
  }
  // ----------------------------------------------------------------------------------------------------------------

  if (oData.strError == "") {
    SetInverter_Init_S150(oData); // Set Attributes from MLFB
    SetOptions1_Init_S150(oData); // Set Attributes from short options (KAG)
    SetOptions2_Init_S150(oData); // Set Attributes from short options (KAG)
    SetOptions4_Init_S150(oData); // Set Attributes from short options (KAG)

    // EDIT 11/2024 SEC-MLFBs neccessary for DriveSimDesigner
    SetOptionsSecMLFB_Init(oData);	// Set Attributes from SEC-MLFB

    SetFREETEXTS(oData);
    if (oData.strError != "") {
      return oData.strError;
    }
  } else {
    ECL_SelectValue("ECSI_STATUS", "E");
    ECL_SetValue("ECSI_STATUS_MESSAGE", translate(oData.strError));
    return oData.strError;
  }
  return "";
}
