//@legacy
//#mode(full-ecma)
//@import "SIZER_simplecfg_utils.js"
//@import "SIZER_general_functions.js"

var PRODUCT_TYPE = "";

var S_REG_MLFB = "6SL5{5;6}101B{B;E}{101;102;104;108;110;115;125;135;150;170}A{A;C;F}0"; 

var MLFB_ATTRIBUTE = "ECSI_MLFB";
var SECONDARY_MLFBS_ATTRIBUTE = "ECSI_MLFB_SEC";
var BASETYPE_MLFB_ATTRIBUTE = "ECSI_MLFB_BASE_TYPE";
var CONFIG_STATUS = "ECSI_STATUS";
var CONFIG_STATUS_ERROR = "E";
var CONFIG_STATUS_OK = "OK";
var CONFIG_STATUS_MESSAGE = "ECSI_STATUS_MESSAGE";

var ECSI_MLFB_CHECK_SEC = "ECSI_MLFB_CHECK_SEC";

var CX_StandardSupplySystem = "ECSI_CX_StandardSupplySystem";
var CX_CustomBrakingResistor = "ECSI_CX_CustomBrakingResistor";
var CX_FieldbusInterface = "ECSI_CX_FieldbusInterface";
var CX_SeriesId = "ECSI_CX_SeriesID";
var CX_MotionControlRequirements = "ECSI_CX_MotionControlRequirements";

var CC_ControlUnit = "ECSI_CC_ControlUnit";
var CC_BrakingResistorID = "ECSI_CC_BrakingResistorID";
var CC_ExternalFilterType = "ECSI_CC_ExternalFilterType";
var CC_SelectedCustomBrakingResistor = "ECSI_CC_SelectedCustomBrakingResistor";

var FIELDBUS_INTERFACE = "A_FIELDBUS_INTERFACE_S200";
    var PROFINET = "V_PROFINET_S200";
    var PULSE_TRAIN_INPUT = "V_PULSE_TRAIN_INPUT_S200";
    var FI_NONE = "V_FI_NONE_S200";

var MEMORY_CARD = "A_MEMORY_CARD_S200";
    var EMPTY_8 = "V_8GB_EMPTY_S200";
    var FW64_8 = "V_8GB_FW64_S200";
    var MC_NONE = "V_MC_NONE_S200";
    var MEMORY_CARD_EMPTY_MLFB = "6SL59700AA000AA0";
    var MEMORY_CARD_FW64_MLFB = "6SL55700GE000AA0";

var OPC_UA_SINGLE_EXTENDED = "A_OPC_UA_SINGLE_EXTENDED_S200";
    var OPC_UA_SINGLE_EXTENDED_SHORT_OPTION = "H80";

var CIRCUIT_BREAKER = "A_CIRCUIT_BREAKER_S200";
    var CB_WITH = "V_WITH_S200";
    var CB_WITHOUT = "V_CB_WITHOUT_S200";

var EXTERNAL_LINE_FILTER="A_EXTERNAL_LINE_FILTER_S200";
    var CATEGORY_C2 = "V_KAT_C2_S200";
    var ELF_WITHOUT = "V_ELF_WITHOUT_S200";

var FUSE = "A_FUSE_S200";
    var IEC = "V_IEC_S200";
    var IEC_WITHOUT = "V_IEC_WITHOUT_S200";

var BRAKING_RESISTOR_ATTRIBUTE = "A_BRAKING_RESISTOR_S200";
    var INTEGRATED_BR = "V_BR_INTEGRATED_S200";
    var CUSTOM_BR = "V_BR_CUSTOM_S200";

var SETPOINT = "A_SETPOINT_S200_PTI";
    var SETPOINT_MLFB = "6SL32604NA001VB0";

var SETPOINT_TERMINAL = "A_SETPOINT_TERMINAL_S200_PTI";
    var SETPOINT_TERMINAL_MLFB = "6SL55620XX000AD0";

var SETPOINT_CONNECTOR = "A_SETPOINT_CONNECTOR_S200_PTI";
    var SETPOINT_CONNECTOR_MLFB = "6SL32602NA000VA0";

var IO_CABLE = "A_IO_CABLE_S200_PN";
    var IO_CABLE_MLFB = "6SL55621XX000AC0";

var IO_CABLE_ADAPTER = "A_IO_CABLE_ADAPTER_S200_PN";
    var IO_CABLE_ADAPTER_MLFB ="6SL55621XX000AD0";

var IO_CABLE_CONNECTOR = "A_IO_CABLE_CONNECTOR_S200_PN";
    var IO_CABLE_CONNECTOR_MLFB = "6SL32602MA000VA0";

var SERVICE_PROTECT = "A_SERVICE_PROTECT_S200";
    var SERVICE_PROTECT_WITHOUT = "V_WITHOUT";
    var SERVICE_PROTECT_3_YEARS = "V_3_YEARS";
    var SERVICE_PROTECT_5_YEARS = "V_5_YEARS";

    var SERVICE_PROTECT_3_YEARS_MLFB = "9MC31104SE000AL8";
    var SERVICE_PROTECT_5_YEARS_MLFB = "9MC31104SE000AN5";
  
var DRIVESIM_DESIGNER = "A_DRIVESIM_DESIGNER_S200";
    var DRIVESIM_DESIGNER_MLFB = "9SV11103AA000AA0";

var ERRORS = [];
var ERROR___S200_MLFB_LENGTH_INVALID = "ERROR___S200_MLFB_LENGTH_INVALID";
var ERROR___S200_MLFB_SERIES_INVALID = "ERROR___S200_MLFB_SERIES_INVALID";
var ERROR___S200_MLFB_PATTERN_INVALID = "ERROR___S200_MLFB_PATTERN_INVALID";
var ERROR___S200_BRAKINGRESISTOR_MANY = "ERROR___S200_BRAKINGRESISTOR_MANY";
var ERROR___S200_BRAKINGRESISTOR_ZERO = "ERROR___S200_BRAKINGRESISTOR_ZERO";

globalThis.OnChangeConfiguration = function main()
{
    ERRORS = [];
    
    /*
        6SL5510-1BE10-2AF0
    */
    
    SetAttributesFromMlfb();

	var ca = ECL_GetCurrentAttribute();
	var v  = ECL_GetValue(ca);

    if(ca === "ECSI_MLFB_CHECK_SEC" && v === "")
		return;

    var currentSecondaryMlfbs = GetMlfbSec();
    var currentMlfb = ECL_GetValue(MLFB_ATTRIBUTE);

    if ((currentMlfb === '') && (ca != "@INIT@"))
    {
		return;
    }

    if(ca === "@INIT@")
    {
        setDefaultValues();
        return;
    }

    currentMlfb=manageKeepconfig(currentMlfb);
    var startConfig = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    
    if(ca === MLFB_ATTRIBUTE)
    {
        parseMlfb();
        if(startConfig != 1)
        {
            validateMlfb(v);
        }
    }

    handleContext();
    handleCommunicationChanges();
    handleCableSelection();
    handleMemoryCardLicenses();

    if(ca === MLFB_ATTRIBUTE || ca === SECONDARY_MLFBS_ATTRIBUTE)
    {
        parseSecondaryMlfbs();
    }

    var createdMlfb = createMlfb(currentMlfb);
    ECL_SetValue(MLFB_ATTRIBUTE, createdMlfb);
    SetMlfbSec(createSecondaryMlfbs(createdMlfb));
    
    createConsequences(createdMlfb);

    if(ERRORS.length > 0)
    {
        ECL_SetValue(CONFIG_STATUS, CONFIG_STATUS_ERROR);
        ECL_SetValue(CONFIG_STATUS_MESSAGE, expandStatus(ERRORS));
    }
    else
    {
        ECL_SetValue(CONFIG_STATUS, CONFIG_STATUS_OK);
    }
}

function setDefaultValues()
{
    ECL_SelectValue(FUSE, IEC_WITHOUT);

    ECL_SelectValue(MEMORY_CARD, MC_NONE);
    ECL_SelectValue(CIRCUIT_BREAKER, CB_WITHOUT);
    ECL_SelectValue(EXTERNAL_LINE_FILTER, ELF_WITHOUT);
    
    ECL_SelectValue(FIELDBUS_INTERFACE, PROFINET);
    //ECL_DisableAttribute(FIELDBUS_INTERFACE);

    ECL_SelectValue(BRAKING_RESISTOR_ATTRIBUTE, INTEGRATED_BR);

    ECL_SelectValue(SERVICE_PROTECT, SERVICE_PROTECT_WITHOUT);
}

function handleContext()
{
    // is product S200 Basic?
    var seriesId = ECL_GetValue(CX_SeriesId);
    if(isBasic(seriesId))
    {
        PRODUCT_TYPE = "BASIC";
    }
    else
    {
        PRODUCT_TYPE = "NONE";
    }

    // FieldbusInterface
    var fieldbusInterface = ECL_GetValue(CX_FieldbusInterface);
    if(PRODUCT_TYPE === "BASIC")
    {
        //ECL_SelectValue(FIELDBUS_INTERFACE, PROFINET);
        if (fieldbusInterface === "0") // 0 PROFINET
        {
            ECL_SelectValue(FIELDBUS_INTERFACE, PROFINET);
            ECL_DisableAttribute(FIELDBUS_INTERFACE);
        }
        ECL_DeactivateValue(FIELDBUS_INTERFACE, PULSE_TRAIN_INPUT);
    }
    else
    {
        if (fieldbusInterface === "0") // 0 PROFINET
        {
            ECL_SelectValue(FIELDBUS_INTERFACE, PROFINET);
            ECL_DisableAttribute(FIELDBUS_INTERFACE);
        }
        if(fieldbusInterface === "3") // Pulse Train Input (PTI)
        {
            ECL_SelectValue(FIELDBUS_INTERFACE, PULSE_TRAIN_INPUT);
            ECL_DisableAttribute(FIELDBUS_INTERFACE);
        }
        ECL_DeactivateValue(FIELDBUS_INTERFACE, FI_NONE);
    }

    // MotionControlRequirements
    var motionControlReq = ECL_GetValue(CX_MotionControlRequirements);
    if(PRODUCT_TYPE === "BASIC")
    {
        if(motionControlReq === "1" || motionControlReq === "2") // Drive Controlled (1) or PLC-based motion control (2) 
        {
            ECL_SelectValue(FIELDBUS_INTERFACE,PROFINET);
            ECL_DisableAttribute(FIELDBUS_INTERFACE);
        }
    }

    //custom braking resistor
    var customBrakingResistor = ECL_GetValue("ECSI_CX_CustomBrakingResistor");
    if( (customBrakingResistor === "True" || customBrakingResistor === "1") && ECL_GetCurrentAttribute()!="A_BRAKING_RESISTOR_S200")
    {
        ECL_SelectValue("A_BRAKING_RESISTOR_S200", "V_BR_CUSTOM_S200");
    }  
}

function expandStatus(errors)
{
    var expandedString = "";
    for( var i = 0; i < errors.length; i++ )
    {
        expandedString += (ECL_Translate(errors[i]) + "; ");
    }
    return expandedString;
}

function validateMlfb(candidate)
{
    if(candidate.length < 16)
    {
        ERRORS.push(ERROR___S200_MLFB_LENGTH_INVALID);
    }

    
    if(!EK_regFound(left(candidate, 6), left(S_REG_MLFB, 9))) // "6SL5{5;6}"
    {
        ERRORS.push(ERROR___S200_MLFB_SERIES_INVALID);
        return;
    }

    if(candidate.indexOf(".") == -1 && !EK_regFound(candidate, S_REG_MLFB))
    {
        ERRORS.push(ERROR___S200_MLFB_PATTERN_INVALID);
        return;
    }
}

function createMlfb(current)
{
    var currentMlfb = current;//ECL_GetValue(MLFB_ATTRIBUTE);
    var communication = ECL_GetValue(FIELDBUS_INTERFACE);
    var characters = [];
    for(var i=0; i < currentMlfb.length; i++)
    {
        if(i === 14)
        {
            if(PRODUCT_TYPE === "BASIC")
            {
                if(communication === PROFINET)
                {
                    characters.push("F");
                }
                else
                {
                    characters.push("A");
                }  
            }
            else
            {
                if(communication === PROFINET)
                {
                    characters.push("F");
                }
                else if (communication === PULSE_TRAIN_INPUT)
                {
                    characters.push("A");
                }
            }
        }
        else
        {
            characters.push((currentMlfb[i]).toString());
        }
    }
    return characters.join(""); 
}

function createSecondaryMlfbs(primaryMlfb)
{
    var secondaryMlfbs = [];
    var supplySystem = ECL_GetValue(CX_StandardSupplySystem);

    var setpoint = ECL_GetValue(SETPOINT);
    var setpointTerminal = ECL_GetValue(SETPOINT_TERMINAL);
    var setpointConnector = ECL_GetValue(SETPOINT_CONNECTOR);
    var ioCable = ECL_GetValue(IO_CABLE);
    var ioCableAdapter = ECL_GetValue(IO_CABLE_ADAPTER);
    var ioCableConnector = ECL_GetValue(IO_CABLE_CONNECTOR);

    // Cables
    if(setpoint === "T")
    {
        secondaryMlfbs.push(SETPOINT_MLFB);
    }
    else if(setpointTerminal === "T")
    {
        secondaryMlfbs.push(SETPOINT_TERMINAL_MLFB);
    }
    else if(ioCable === "T")
    {
        secondaryMlfbs.push(IO_CABLE_MLFB);
    }
    else if(ioCableAdapter === "T")
    {
        secondaryMlfbs.push(IO_CABLE_ADAPTER_MLFB);
    }

    if(setpointConnector === "T")
    {
        secondaryMlfbs.push(SETPOINT_CONNECTOR_MLFB);
    }
    else if(ioCableConnector === "T")
    {
        secondaryMlfbs.push(IO_CABLE_CONNECTOR_MLFB);
    }

    // Service Protect
    var serviceProtect = ECL_GetValue(SERVICE_PROTECT);

    if(serviceProtect === SERVICE_PROTECT_3_YEARS)
    {
        secondaryMlfbs.push(SERVICE_PROTECT_3_YEARS_MLFB);
    }
    else if (serviceProtect === SERVICE_PROTECT_5_YEARS)
    {
        secondaryMlfbs.push(SERVICE_PROTECT_5_YEARS_MLFB);
    }

    // DriveSim Designer
    var drivesimDesigner = ECL_GetValue(DRIVESIM_DESIGNER);
    if(drivesimDesigner === "T")
    {
        secondaryMlfbs.push(DRIVESIM_DESIGNER_MLFB);
    }

    // phase-independent 
    var memoryCardMlfb = createMemoryCardMlfb();
    if (memoryCardMlfb !== undefined) {
      secondaryMlfbs.push(memoryCardMlfb);
    }

    if (supplySystem == '0' || supplySystem == '7')//1phase
    {
        //Circuit Breaker
        var circuitBreaker = ECL_GetValue(CIRCUIT_BREAKER);
        if(circuitBreaker === CB_WITH)
        {
            if(EK_regFound(primaryMlfb, "6SL5?101BB{101;102}A?0"))
            {
                secondaryMlfbs.push("3RV20111EA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL5?101BB104A?0"))
            {
                secondaryMlfbs.push("3RV20111HA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL5?101BB{108;110}A?0"))
            {
                secondaryMlfbs.push("3RV20111KA10");
            }
        }
        // External Filter
        var externalFilter = ECL_GetValue(EXTERNAL_LINE_FILTER);
        if(externalFilter === CATEGORY_C2)
        {
            if(EK_regFound(primaryMlfb, "6SL5?101BB{101;102;104;108;110}???"))
            {
                secondaryMlfbs.push("6SL55500XB218CA0"); 
            }          
        }
        // Fuse
        var fuseSelection = ECL_GetValue(FUSE)
        if(fuseSelection === IEC)
        {
            if(EK_regFound(primaryMlfb, "6SL55101BB{101;102}A?0"))
            {
                secondaryMlfbs.push("3NA3801"); 
            }
            else if(EK_regFound(primaryMlfb, "6SL5?101BB104A?0"))
            {
                secondaryMlfbs.push("3NA3803"); 
            }
            else if(EK_regFound(primaryMlfb, "6SL5?101BB{108;110}A?0"))
            {
                secondaryMlfbs.push("3NA3805"); 
            }
           
        }
    }

    else//3phase
    {
        //Circuit Breaker
        var circuitBreaker = ECL_GetValue(CIRCUIT_BREAKER);
        if(circuitBreaker === CB_WITH)
        {
            if(EK_regFound(primaryMlfb, "6SL5?101BB{101;102}A?0"))
            {
                secondaryMlfbs.push("3RV20111EA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL5?101BB104A?0"))
            {
                secondaryMlfbs.push("3RV20111EA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL5?101BB108A?0"))
            {
                secondaryMlfbs.push("3RV20111HA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL5?101BB110A?0"))
            {
                secondaryMlfbs.push("3RV20111JA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE102A?0"))
            {
                secondaryMlfbs.push("3RV20211CA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE104A?0"))
            {
                secondaryMlfbs.push("3RV20211DA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE108A?0"))
            {
                secondaryMlfbs.push("3RV20211EA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE108A?0"))
            {
                secondaryMlfbs.push("3RV20211EA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE110A?0"))
            {
                secondaryMlfbs.push("3RV20211FA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE{115;125}A?0"))
            {
                secondaryMlfbs.push("3RV20214AA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE{135;150}A?0"))
            {
                secondaryMlfbs.push("3RV20214BA10");
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE170A?0"))
            {
                secondaryMlfbs.push("3RV20214DA10");
            }
        }
        // External Filter
        var externalFilter = ECL_GetValue(EXTERNAL_LINE_FILTER);
        if(externalFilter === CATEGORY_C2)
        {
            if(EK_regFound(primaryMlfb, "6SL55101BE{115;125}???"))
            {
                secondaryMlfbs.push("6SL55500XE212CA0");
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE{135;150;170}???"))
            {
                secondaryMlfbs.push("6SL55500XE220CA0");
            }
            else if(EK_regFound(primaryMlfb, "6SL5?101BB{101;102;104;108;110}???"))
            {
                secondaryMlfbs.push("6SL32030BE150VA0");
            }
            else if(EK_regFound(primaryMlfb, "6SL5?101BE{101;102;104;108;110}???"))
            {
                secondaryMlfbs.push("6SL55500XE205CA0");
            }
        }
        // Fuse
        var fuseSelection = ECL_GetValue(FUSE)
        if(fuseSelection === IEC)
        {
            if(EK_regFound(primaryMlfb, "6SL55101BB{101;102}A?0"))
            {
                secondaryMlfbs.push("3NA3801");
                secondaryMlfbs.push("3NA3801");
                secondaryMlfbs.push("3NA3801");
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE{102;104;108}A?0"))
            {
                secondaryMlfbs.push("3NA3801");
                secondaryMlfbs.push("3NA3801");
                secondaryMlfbs.push("3NA3801"); 
            }
            else if(EK_regFound(primaryMlfb, "6SL5?101BB104A?0"))
            {
                secondaryMlfbs.push("3NA3803");
                secondaryMlfbs.push("3NA3803");
                secondaryMlfbs.push("3NA3803"); 
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE110A?0"))
            {
                secondaryMlfbs.push("3NA3803");
                secondaryMlfbs.push("3NA3803");
                secondaryMlfbs.push("3NA3803"); 
            }
            else if(EK_regFound(primaryMlfb, "6SL5?101BB{108;110}A?0"))
            {
                secondaryMlfbs.push("3NA3805");
                secondaryMlfbs.push("3NA3805");
                secondaryMlfbs.push("3NA3805"); 
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE{115;125}A?0"))
            {
                secondaryMlfbs.push("3NA3805");
                secondaryMlfbs.push("3NA3805");
                secondaryMlfbs.push("3NA3805"); 
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE{135;150}A?0"))
            {
                secondaryMlfbs.push("3NA3807");
                secondaryMlfbs.push("3NA3807");
                secondaryMlfbs.push("3NA3807"); 
            }
            else if(EK_regFound(primaryMlfb, "6SL55101BE170A?0"))
            {
                secondaryMlfbs.push("3NA3810");
                secondaryMlfbs.push("3NA3810");
                secondaryMlfbs.push("3NA3810"); 
            }
            
        }  
    }

    return secondaryMlfbs.join(";");
}

function createConsequences(mlfb)
{
    // CC_ExternalFilterType
    var externalFilterSelection = ECL_GetValue(EXTERNAL_LINE_FILTER);
    if(externalFilterSelection === CATEGORY_C2)
    {
        ECL_SetValue(CC_ExternalFilterType, "2");
    }

    // CC_SelectedCustomBrakingResistor
    if(ECL_ValueSelected("A_BRAKING_RESISTOR_S200","V_BR_CUSTOM_S200"))
    {
        ECL_SetValue("ECSI_CC_BrakingResistorID", "custom");
        ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "True");
    }
    else
    { 
        ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "False");
       
        var consequenceBrakingResistor = getBrakingResistorId(mlfb);
        if(consequenceBrakingResistor !== "")
            ECL_SetValue("ECSI_CC_BrakingResistorID", getBrakingResistorId(mlfb));
        else
            ECL_SetValue("ECSI_CC_BrakingResistorID", "");
    }


   
}

function getBrakingResistorId(createdMlfb)
{
    var query = "SELECT * FROM TBR_BrakingResistors WHERE OrderNumber='"+ createdMlfb +"'; ";
    var result = Object.fromDatabase("S200_BR_DB", query);
    
    if(result.length === 1)
    {
        return result[0]["BRAKEID"];   
    }
    else if(result.length > 1)
    {
        logtraceln("Found multiple matches for ordernubmer; SQL="+query);
		ECL_SelectValue(CONFIG_STATUS, CONFIG_STATUS_ERROR);
		ERRORS.push(ERROR___S200_BRAKINGRESISTOR_MANY);
        return "";
    }
    else if(result.length === 0)
    {
        logtraceln("Found no matches for ordernubmer; SQL="+query);
		ECL_SelectValue(CONFIG_STATUS, CONFIG_STATUS_ERROR);
		ERRORS.push(ERROR___S200_BRAKINGRESISTOR_ZERO);
        return "";
    }
    else
        return "";
}

function parseMlfb()
{
    var mlfb = ECL_GetValue(MLFB_ATTRIBUTE);
    if(PRODUCT_TYPE === "BASIC")
    {
        if(mlfb[14] !== ".")
        {
            if(mlfb[14] === "A")
            {
                ECL_SelectValue(FIELDBUS_INTERFACE, FI_NONE);
            }
            else if(mlfb[14] === "F") // PN PROFINET
            {
                ECL_SelectValue(FIELDBUS_INTERFACE, PROFINET);
            }
        }
    }
    else
    {
        if(mlfb[14] !== ".")
        {
            if(mlfb[14] === "F") // PN PROFINET
            {
                ECL_SelectValue(FIELDBUS_INTERFACE, PROFINET);
            }
            else
            {
                ECL_SelectValue(FIELDBUS_INTERFACE, PULSE_TRAIN_INPUT);
            }
        }   
    }
    
}

function parseSecondaryMlfbs()
{
    var secondaries = ECL_GetValue(SECONDARY_MLFBS_ATTRIBUTE);
    var secondaryMlfbs = secondaries.split(";");
    for( var i = 0; i < secondaryMlfbs.length; i++)
    {
        var memoryCardSelections = getMemoryCardSelections(secondaryMlfbs[i]);
        if (memoryCardSelections[0] !== undefined) {
            ECL_SelectValue(MEMORY_CARD, memoryCardSelections[0]);

          if (memoryCardSelections[1]) {
            ECL_SelectValue(OPC_UA_SINGLE_EXTENDED, "T");
          }
          else {
            ECL_DeselectValue(OPC_UA_SINGLE_EXTENDED, "T");
          }
        }

        if(isFuse(secondaryMlfbs[i]))
            ECL_SelectValue(FUSE, IEC);

        if(isCircuitBreaker(secondaryMlfbs[i]))
            ECL_SelectValue(CIRCUIT_BREAKER, CB_WITH);

        if(isExternalFilter(secondaryMlfbs[i]))
            ECL_SelectValue(EXTERNAL_LINE_FILTER, CATEGORY_C2);
        
        // Cables
        if(secondaryMlfbs[i] === SETPOINT_MLFB) // Setpoint cable for SINAMICS S200 PTI
            ECL_SelectValue(SETPOINT, "T");
        if(secondaryMlfbs[i] === SETPOINT_TERMINAL_MLFB) // Setpoint cable with terminal block for SINAMICS S200 PTI
            ECL_SelectValue(SETPOINT_TERMINAL, "T");
        if(secondaryMlfbs[i] === SETPOINT_CONNECTOR_MLFB) // Setpoint connector for SINAMICS S200 PTI
            ECL_SelectValue(SETPOINT_CONNECTOR, "T");
        if(secondaryMlfbs[i] === IO_CABLE_MLFB) // I/O cable for SINAMICS S200 PN
            ECL_SelectValue(IO_CABLE, "T");
        if(secondaryMlfbs[i] === IO_CABLE_ADAPTER_MLFB) // I/O adapter for SINAMICS S200 PN
            ECL_SelectValue(IO_CABLE_ADAPTER, "T");  
        if(secondaryMlfbs[i] === IO_CABLE_CONNECTOR_MLFB) // I/O connector for SINAMICS S200 PN
            ECL_SelectValue(IO_CABLE_CONNECTOR, "T");

        // Service Protect
        if(secondaryMlfbs[i] === SERVICE_PROTECT_3_YEARS_MLFB)
            ECL_SelectValue(SERVICE_PROTECT, SERVICE_PROTECT_3_YEARS);
        else if(secondaryMlfbs[i] === SERVICE_PROTECT_5_YEARS_MLFB)
            ECL_SelectValue(SERVICE_PROTECT, SERVICE_PROTECT_5_YEARS);

        // DriveSim Designer
        if(secondaryMlfbs[i] === DRIVESIM_DESIGNER_MLFB)
            ECL_SelectValue(DRIVESIM_DESIGNER, "T");
    }
}

function getMemoryCardSelections(candidate)
{
  var memoryCardSelection = undefined;
  if (candidate.startsWith(MEMORY_CARD_EMPTY_MLFB)) {
    memoryCardSelection = EMPTY_8;
  }
  else if (candidate.startsWith(MEMORY_CARD_FW64_MLFB)) {
    memoryCardSelection = FW64_8;
  }

  var opcUaSelected = false;

  var shortOptionsString = candidate.split('-Z')[1];

  if (shortOptionsString !== undefined && shortOptionsString.includes(OPC_UA_SINGLE_EXTENDED_SHORT_OPTION)) {
    opcUaSelected = true;
  }

  return [memoryCardSelection, opcUaSelected];
}

function isFuse(candidate)
{
   var fuseMlfbs = [
    "3NA3801",
    "3NA3803",
    "3NA3805",
    "3NA3807",
    "3NA3810"
   ];

   return fuseMlfbs.includes(candidate);
}

function isCircuitBreaker(candidate)
{
    var circuitBreakers = [
        "3RV20111EA10",
        "3RV20111HA10",
        "3RV20111KA10",
        "3RV20111JA10",
        "3RV20211CA10",
        "3RV20211DA10",
        "3RV20211EA10",
        "3RV20211FA10",
        "3RV20214AA10",
        "3RV20214BA10",
        "3RV20214DA10",
    ];

    return circuitBreakers.includes(candidate);
}

function isExternalFilter(candidate)
{
    var filters = [
        "6SL55500XB218CA0",
        "6SL32030BE150VA0",
        "6SL55500XE205CA0",
        "6SL55500XE212CA0",
        "6SL55500XE220CA0",
    ];

    return filters.includes(candidate);
}

function manageKeepconfig(s_mlfb)
{
    var isStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    var strBaseTypeMLFB=ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    
    if(isStartConfiguration=="1" && s_mlfb!=strBaseTypeMLFB)
    {		
        var aBaseTypeMLFB=strBaseTypeMLFB.split('');
        var as_mlfb=s_mlfb.split('');
        for (var i=0;i<aBaseTypeMLFB.length;i++)
        {
            if(aBaseTypeMLFB[i] != ".")
            {
                as_mlfb[i]=aBaseTypeMLFB[i];
            }
        }
        
        s_mlfb="";
        for (var i=0;i<as_mlfb.length;i++)
            s_mlfb=s_mlfb+as_mlfb[i];
        
        return s_mlfb;
    }
    else if(isStartConfiguration=="1")
        return strBaseTypeMLFB;
    else
        return s_mlfb;
}

function isBasic(seriesId)
{
    var basicSeriesIds = [ "81910", "81911"];
    if(basicSeriesIds.includes(seriesId))
    {
        return true;
    }
    else
    {
        return false;
    }

}

function handleCommunicationChanges()
{
    var communication = ECL_GetValue(FIELDBUS_INTERFACE);
    if(communication === PULSE_TRAIN_INPUT || communication === FI_NONE)
    {
        ECL_EnableAttribute(SETPOINT);
        ECL_EnableAttribute(SETPOINT_TERMINAL);
        ECL_EnableAttribute(SETPOINT_CONNECTOR);
        ECL_DisableAttribute(IO_CABLE);
        ECL_DisableAttribute(IO_CABLE_ADAPTER);
        ECL_DisableAttribute(IO_CABLE_CONNECTOR);
        ECL_DeselectValue(IO_CABLE, "T");
        ECL_DeselectValue(IO_CABLE_ADAPTER, "T");
        ECL_DeselectValue(IO_CABLE_CONNECTOR, "T");
    }
    else if (communication === PROFINET)
    {
        ECL_EnableAttribute(IO_CABLE);
        ECL_EnableAttribute(IO_CABLE_ADAPTER);
        ECL_EnableAttribute(IO_CABLE_CONNECTOR);
        ECL_DisableAttribute(SETPOINT);
        ECL_DisableAttribute(SETPOINT_TERMINAL);
        ECL_DisableAttribute(SETPOINT_CONNECTOR);
        ECL_DeselectValue(SETPOINT, "T");
        ECL_DeselectValue(SETPOINT_TERMINAL, "T");
        ECL_DeselectValue(SETPOINT_CONNECTOR, "T");
    }
}

function handleCableSelection()
{
    var ca = ECL_GetCurrentAttribute();
    var setpoint = ECL_GetValue(SETPOINT);
    var setpointTerminal = ECL_GetValue(SETPOINT_TERMINAL);
    var ioCable = ECL_GetValue(IO_CABLE);
    var ioCableAdapter = ECL_GetValue(IO_CABLE_ADAPTER);
    
    if(ca === SETPOINT && setpoint === "T")
    {
        ECL_DeselectValue(SETPOINT_TERMINAL, "T");
    }
    if (ca === SETPOINT_TERMINAL && setpointTerminal === "T")
    {
        ECL_DeselectValue(SETPOINT, "T");
    }
    if(ca === IO_CABLE && ioCable === "T")
    {
        ECL_DeselectValue(IO_CABLE_ADAPTER, "T");
    }
    if(ca === IO_CABLE_ADAPTER && ioCableAdapter === "T")
    {
        ECL_DeselectValue(IO_CABLE, "T");
    }
}

function createMemoryCardMlfb() {
  var memorycardSelection = ECL_GetValue(MEMORY_CARD);
  var opcUaSelected = ECL_ValueSelected(OPC_UA_SINGLE_EXTENDED, "T");

  var memoryCardMlfb = undefined;

  if (memorycardSelection === EMPTY_8) {
    memoryCardMlfb = MEMORY_CARD_EMPTY_MLFB;
  }
  else if (memorycardSelection === FW64_8) {
    memoryCardMlfb = MEMORY_CARD_FW64_MLFB;
  }

  if (memoryCardMlfb === MEMORY_CARD_FW64_MLFB && opcUaSelected) {
    memoryCardMlfb += "-Z " + OPC_UA_SINGLE_EXTENDED_SHORT_OPTION;
  }

  return memoryCardMlfb;
}

function handleMemoryCardLicenses() {
  var currentAttribute = ECL_GetCurrentAttribute();
  var opcSelected = ECL_ValueSelected(OPC_UA_SINGLE_EXTENDED, "T");
  var selectedMemoryCard = ECL_GetValue(MEMORY_CARD);

  if (currentAttribute == OPC_UA_SINGLE_EXTENDED && opcSelected) {
      ECL_SelectValue(MEMORY_CARD, FW64_8);
  }
  if (currentAttribute == MEMORY_CARD && selectedMemoryCard != FW64_8) {
      ECL_DeselectValue(OPC_UA_SINGLE_EXTENDED, "T");
  }
}
