//@legacy
/**
*		Script for configuration object CFG_SIEMENS_S210
*
*		Achtung
*! 		MLFB die ersten 9 Stellen sind fix
*					 !		MLFB Positionen werden im script von 0 bis 15 nummeriert
*					 !		ECSI_MLFB wird immer als letztes bei Initialisierung durch SIZER gesetzt
*
* 	Date:	2019-02-22
* 	User:	Hans Martin Bauer, Plan Software GmbH
*   Mod:	2019-02-25 mb	Namenskonventionen umgesetzt Suffix _S210
*                       in der MLFB "." statt "?" setzen
*                       "feste" Werte
*		Mod:	2019-02-26 mb	Analyse Zubehör bei Fortsetzung der Konfiguration
*													Übergabe in ECSI_MLFB_CHECK_SEC
*												MLFB wird nur in Großbuchstaben gewandelt, ansonsten muss sie korrekt sein (Länge!)
*		Mod:	2019-02-27 mb	Namenskonventionen korrigiert
*		Mod:	2019-02-28 mb	ECSI_CX_StandardSupplySystem liefert den kodierten Wert der Phasen -> ECSI_CX_NP_S210
*												ECSI_CX_NP_S210 nicht ändern bei Validierung
*												ECSI_CX_ANZ_S210 -> Anzahl des jeweiligen Zubehörteils, MLFB wird entsprechend oft in ECSI_MLFB_SEC aufgenommen
*		Mod:	2019-03-01 mb	Mindestanforderung an eine evt. gültige MLFB
*		Mod:	2019-04-02 mb	RegExp für MLFB geändert
*												Optionen wurden überarbeitet
*												ECSI_CC_ControlMode, ECSI_CC_IpProtectionLevelFrequencyConverter, ECSI_CC_InternalFilterType, ECSI_CC_ExternalFilterType
*		Mod:	2019-04-03 mb	Fehler bei IDs
*												[MLFB Position 9 (B oder E) und Netzphasen (1 oder 3) prüfen]
*		Mod:	2019-05-13 mb	MLFB mit Zusatz bei Sicherheit
*												Auswahllisten filtern : abh. von MLFB nur mögliche Werte anzeigen
*		Mod:	2019-05-16 mb	StandardSupplySystem : Werteliste wurde geändert aus 5=1AC wurde 7=1AC
*!												s_1ac anpassen bei Änderung
*												Netzphasen werden aus MLFB(9)=B|E gesetzt
*/
//#mode(full-ecma)
//@import "SIZER_simplecfg_utils.js"

//@import "SIZER_general_functions.js"

var PRODUCT_GENERATION = ""; // need to be global

globalThis.OnChangeConfiguration = function main() {
    /*
    6SL3210-5HE10-4UF0
    */

	SetAttributesFromMlfb();

	var ca = ECL_GetCurrentAttribute();
	var v  = ECL_GetValue(ca);

	// Daten wurden zum Test in das Feld geschrieben
	if(ca === "ECSI_MLFB_CHECK_SEC" && v === "")
		return;
	var s_mlfb 		= ECL_GetValue("ECSI_MLFB");
	var s_mlfb_sec 	= GetMlfbSec();
	if ((s_mlfb === '') && (ca != "@INIT@"))
		return;
	s_mlfb = s_mlfb.replace("?", ".").toUpperCase();
	
	// RegEx für eine Mindestanforderung an eine evt. gültige MLFB // regex for a minimum requirement for a possibly valid MLFB
	// vesch. Kombinationen sind dennoch falsch
	
	// todo gen2 gen3 6SL53101B.... | 0-8
	var baseTypeMlfb = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
	var identifier = baseTypeMlfb.left(9);

	var s_regMlfb = "";
	
	switch(identifier)
	{
		// "old" / Gen2
		case "6SL32105H":
			ECL_SelectValue("ECSI_STATUS", "E");
			ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_OUTDATED"));
			return;
		
		// Gen3
		case "6SL53101B":
			PRODUCT_GENERATION = "S210_3";
			var ending = "{CF0;DF1}" // TODO : Unsure, excel data suggests "UF0", while Sizer TestVersion data indicates "DF1" and "CF0"
			s_regMlfb = "6SL53101B{B;E}{101;102;104;108;110;115;120;135;150;170}" + ending;
			break;
	}
	
	if(ca !== "@INIT@")
	{
		if(PRODUCT_GENERATION === "" || s_regMlfb === "")
		{
			return;
		}
	}
	
	// die Original einmal MLFB speichern
	saveMlfb(s_mlfb);
	
	s_mlfb=manageKeepconfig(s_mlfb);
	
	ECL_SetValue("ECSI_MLFB_CHECK_SEC", s_mlfb_sec);	

	ECL_SelectValue("ECSI_STATUS", "OK");
	ECL_ResetAttribute("ECSI_STATUS_MESSAGE");
	
	var supplySystem = ECL_GetValue("ECSI_CX_StandardSupplySystem");
	
	//Leistungsschalter und Sicherung gehen nicht zusammen. Kann immer nur eins gewählt werden.
	if(ECL_GetValue("A_EO_LS_S210") != "V_OHNE")
	{
		ECL_SetValue("A_EO_SS_S210", "V_OHNE");
		ECL_DisableAttribute("A_EO_SS_S210");
	}
	else
	{
		ECL_EnableAttribute("A_EO_SS_S210");
	}
	
	
	if(ECL_GetValue("A_EO_SS_S210") != "V_OHNE")
	{
		ECL_SetValue("A_EO_LS_S210", "V_OHNE");
		ECL_DisableAttribute("A_EO_LS_S210");
	}
	else
	{
		ECL_EnableAttribute("A_EO_LS_S210");
	}
	
	if(ca === "@INIT@")		// erstmalige Initialisierung vor allem anderen
	{
		ECL_DisableAttribute("ECSI_STATUS");
		ECL_DisableAttribute("ECSI_STATUS_MESSAGE");
		SetMlfbSec("");
		ECL_DisableAttribute("ECSI_MLFB_SEC");

		// Consequences:
		ECL_DisableAttribute("ECSI_CC_ControlUnit");
		ECL_DisableAttribute("ECSI_CC_BrakeRelays");	
		ECL_DisableAttribute("ECSI_CC_ControlMode");	
		ECL_DisableAttribute("ECSI_CC_IpProtectionLevelFrequencyConverter");
		ECL_DisableAttribute("ECSI_CC_InternalFilterType");
		ECL_DisableAttribute("ECSI_CC_ExternalFilterType");

		// DEFAULTS
		ECL_SetValue("ECSI_CC_ControlUnit", "");
		ECL_SetValue("ECSI_CC_BrakeRelays", "");
		ECL_SetValue("ECSI_CC_Selected_CU", "");
		ECL_SetValue("A_CU_FS_S210", "V_CU_FS_PROFINET_S210");
		ECL_DisableAttribute("A_CU_FS_S210");
		
		//ECL_SetValue("A_ZKK_BW_S210", "V_ZKK_BW_INT_S210");
		//ECL_DisableAttribute("A_ZKK_BW_S210");
		
		ECL_SetValue("A_SA_SA_S210", "V_SA_SA_IP20_S210");
		ECL_DisableAttribute("A_SA_SA_S210");
		
		// keine Wahlmöglichkeit
		ECL_DisableAttribute("A_NETZFILTER_INT_S210");

		ECL_SetValue("A_CU_SD_S210", "V_OHNE");
		ECL_SetValue("A_EO_LS_S210", "V_OHNE");
		ECL_SetValue("A_NETZFILTER_EXT_S210", "V_OHNE");
		ECL_SetValue("A_EO_SS_S210", "V_OHNE");
		ECL_SetValue("A_AT_ZKP_S210", "V_OHNE");
		
		//Voltage Protection Modul
		//Gibt es vorerst im S210 nicht
		var strDefault_VPM = ECL_GetValue("ECSI_CX_Default_VPM");
		ECL_SetValue("ECSI_CC_Selected_VPM", "False");		
		return;
	}
	else if(ca === "ECSI_MLFB")	// Übergabe Kontext, Primär und Sekundär-MLFB in einem Schritt
	{
		// MLFB auf Korrektheit prüfen:
		if(s_mlfb.length < 16)	// es können jetzt auch Kurzangaben an der Primär-MLFB hängen
		{
			ECL_SelectValue("ECSI_STATUS", "E");
			ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_MLFB_LENGTH_INVALID"));
			return;
		}

		if(left(s_mlfb, 9) !== "6SL32105H" && left(s_mlfb, 9) !== "6SL53101B")
		{
			ECL_SelectValue("ECSI_STATUS", "E");
			ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_MLFB_SERIES_INVALID"));
			return;
		}

		if(s_mlfb.indexOf(".") == -1 && ! EK_regFound(s_mlfb, s_regMlfb))
		{
			ECL_SelectValue("ECSI_STATUS", "E");
			ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_MLFB_PATTERN_INVALID"));
			return;
		}

		// einzelne MLFB Positionen prüfen
		if(! isMlfbPosValid(s_mlfb))
		{
			ECL_SelectValue("ECSI_STATUS", "E");
			ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_MLFB_POS_INVALID"));
			return;
		}
		
		//------------------------------
		// Kontext-Information auswerten:

		// Netzphasen ableiten aus ID (Wert V ist egal)
		// B= 1AC 230V , 240V ; 1-phase AC ; 50Hz , 60Hz
		// E= 3AC	230V - 690V ; 3-phase AC ; 50Hz , 60Hz
		// Übergabe StandardSupplySystem : welche Werte stehen für 1AC Motoren
		var s_1ac 		 = "0#5#";
		// var supplySystem = ECL_GetValue("ECSI_CX_StandardSupplySystem");
		var netzPhaseFromContext = "3";
		if(find(s_1ac, supplySystem + "#") != -1)
			netzPhaseFromContext = "1";
		
		//*****
		// 3 verschiedenen Spannungen
		// 0 und 7       			=1AC230V
		// 1 und 8 					=3AC240V
		// 2;3;4;9;10;11;12;13 	=3AC400V
		//*****
		
		ECL_DeactivateAllAttributeValues("A_ZKK_BW_S210");
		ECL_DeactivateAllAttributeValues("A_ZKK_BW_EXTERN_S210");
		ECL_ActivateValue("A_ZKK_BW_S210","custom"); //geht immer
		if (supplySystem == '0' || supplySystem == '7') 
		{
			// 1AC 200-240V
			
			if (EK_regFound(s_mlfb, '6SL53101BB(101|102|104|108|110|115|120)(CF0|DF1)'))
			{
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_INT_S210");
			}
			
			if (EK_regFound(s_mlfb, '6SL53101BB(101|102|104|108)(CF0|DF1)'))
			{
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_EXT_S210");
			}
		}
		else if (supplySystem == '1' || supplySystem == '8')
		{
			// 3AC 200-240V
			
			if (EK_regFound(s_mlfb, '6SL53101BE(104|108|110|115|120|135|150|170)(CF0|DF1)')  || EK_regFound(s_mlfb, '6SL53101BE104(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE115(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE120(CF0|DF1)'))
			{
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_EXT_S210");
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_INT_S210");
			}
			
			if (EK_regFound(s_mlfb, '6SL53101BE108(CF0|DF1)')  || EK_regFound(s_mlfb, '6SL53101BE110(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE135(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE150(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE170(CF0|DF1)'))
			{
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_EXT_S210");
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_INT_S210");
			}
			
			if (EK_regFound(s_mlfb, '6SL53101BE108(CF0|DF1)')  || EK_regFound(s_mlfb, '6SL53101BE110(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE135(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE150(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE170(CF0|DF1)'))
			{
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_EXT_S210");
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_INT_S210");
			}
		}
		else if (supplySystem == '2' || supplySystem == '3' || supplySystem == '4' || supplySystem == '9' || supplySystem == '10' || supplySystem == '11' || supplySystem == '12' || supplySystem == '13' || supplySystem=="18")
		{
			// 3AC 400V

			if (EK_regFound(s_mlfb, '6SL53101BE(104|108|110|115|120|135|150|170)(CF0|DF1)')  || EK_regFound(s_mlfb, '6SL53101BE104(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE115(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE120(CF0|DF1)'))
			{
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_INT_S210");
			}
			
			if (EK_regFound(s_mlfb, '6SL53101BE104(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE115(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE120(CF0|DF1)'))
			{
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_EXT_S210");
			}
			
			if (EK_regFound(s_mlfb, '6SL53101BE108(CF0|DF1)')  || EK_regFound(s_mlfb, '6SL53101BE110(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE135(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE150(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE170(CF0|DF1)'))
			{
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_EXT_S210");
			}
			
			if (EK_regFound(s_mlfb, '6SL53101BE108(CF0|DF1)')  || EK_regFound(s_mlfb, '6SL53101BE110(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE135(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE150(CF0|DF1)') || EK_regFound(s_mlfb, '6SL53101BE170(CF0|DF1)'))
			{
				ECL_ActivateValue("A_ZKK_BW_S210","V_ZKK_BW_EXT_S210");
			}
		}
		else
		{
			// Fehler
			// Spannung wird nicht unterstützt
			ECL_SelectValue("ECSI_STATUS", "E");
			ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_MLFB_VOLTAGE_NOT_SUPPORTED"));
			return;
		}
		
		getpossible_SEC_MLFBs_BR(s_mlfb, supplySystem);
		
		// Netzphasen aus MLFB bestimmen
		// @@@ wir könnten (!) jetzt einen Abgleich mit netzPhaseFromContext vornehmen und 
		// einen Fehler generieren wenn ungleich. Man kann die Netzphasen vom Kontext nicht einfach
		// übernehmen, weil sich dadurch die vorgegebene Grund-MLFB ändern würde
		if(s_mlfb !== "")
		{
			if(isValidChar(s_mlfb, "B", 9))
			{
				ECL_SetValue("ECSI_CX_NP_S210", "1");
				ECL_SetValue("A_NETZFILTER_INT_S210", "V_KAT_INT_C2_S210");
			}
			if(isValidChar(s_mlfb, "E", 9))
			{
				ECL_SetValue("ECSI_CX_NP_S210", "3");
				ECL_SetValue("A_NETZFILTER_INT_S210", "V_KAT_INT_C3_S210");
			}
		}

		//------------------------------
		// Auswahllisten auswerten - mögliche Werte einschränken / erlauben
		// Evaluate selection lists - restrict / allow possible values
		filterValues(s_mlfb);

		s_mlfb = applyDependencies(ca, s_mlfb, s_mlfb_sec)

		// Die mit den Zubehör-(Sekundär-) MLFBs verknüpften Attribute setzen
		//------------------------------
		evalAccParts(s_mlfb, s_mlfb_sec);
		
		//Braking Resistor SEC_MLFB's setzen
		check_SEC_MLFB_forBR(s_mlfb, s_mlfb_sec);

		// Haupt MLFB - Anpassungen Dialog : Werte und Auswahllisten setzen
		s_mlfb = dlgSettings(s_mlfb);
	}
	else
	{
		// Auswahllisten nach dem Setzen eines Werts nochmal auswerten
		// Evaluate selection lists again after setting a value
		filterValues(s_mlfb);

		s_mlfb = applyDependencies(ca, s_mlfb, s_mlfb_sec)
	}
	//------------------------------
	// filterValues(mflb) is handling the return value of generation dependent getAccConditions() 
	// wrongly. This is a fix for that (disabling generation-unique attribute values)
	// acceptable: 3,2; 5; 8; 10; 12,5; 16; 25; 28; 32
	ECL_DeactivateValue("A_EO_LS_S210","V_EO_LS_040_S210"); // 4	A
	ECL_DeactivateValue("A_EO_LS_S210","V_EO_LS_063_S210"); // 6,3	A

	// handle A_OPC_UA_SE option
	// determine if the option is checked and update s_mlfb_sec accordingly
	if (ca === "A_CU_SD_S210" && !v.includes("V_CU_SD_FW64")) {
		ECL_SetValue("A_OPC_UA_SE_S210", "");

	} else if ((ca === "A_OPC_UA_SE_S210" && v === "") && (s_mlfb_sec.indexOf("H80") > -1)) {
		ECL_SetValue("A_OPC_UA_SE_S210", "");
		if (s_mlfb_sec.indexOf("F01") > -1) {
			s_mlfb_sec = s_mlfb_sec.replace("6SL53700GE000AA0-Z F01+H80", "6SL53700GE000AA0-Z F01")
		} else {
			s_mlfb_sec = s_mlfb_sec.replace("6SL53700GE000AA0-Z H80", "6SL53700GE000AA0")
		}

	} else if ((ca === "A_OPC_UA_SE_S210" && v === "T") || (s_mlfb_sec.indexOf("H80") > -1))  {
		ECL_SetValue("A_OPC_UA_SE_S210", "T");
		
	} else {
		ECL_SetValue("A_OPC_UA_SE_S210", "");
	}

	// determine witch FW to use
	if (ECL_ValueSelected("A_OPC_UA_SE_S210", "T")) {
		if (!ECL_GetValue("A_CU_SD_S210").includes("V_CU_SD_FW64")) {
			ECL_SetValue("A_CU_SD_S210", s_mlfb_sec.includes("F01") ? "V_CU_SD_FW64_SAFETY_S210_3" : "V_CU_SD_FW64_S210_3");
		}
	}

	// Basis - MLFB nochmal lesen
	//var base_mlfb = ECL_GetUserVariable("ORIGINAL_MLFB");	// kann hier benutzt werden weil kein Punkt drin ist
	// @@@ hack, weil nach einem Sprachwechsel z.B. die gespeicherte MLFB direkt schon mit Kurzangabe ist ...:
	//if (base_mlfb.length > 16)
	//	base_mlfb = base_mlfb.left(16);	
		
	//Default Wert für Braking Resistor setzen
	var apossibleBR=ECL_GetAllActiveAttributeValues("A_ZKK_BW_S210");
	
	var btest=false;
	for(var i=0;i<apossibleBR.length;i++)
	{
		if(apossibleBR[i]==ECL_GetValue("A_ZKK_BW_S210"))
			btest=true;
	}
	
	if(!btest || ECL_GetValue("A_ZKK_BW_S210")=="")
	{
		if (supplySystem == '0' || supplySystem == '1' || supplySystem == '7' || supplySystem == '8' || supplySystem == '2' || supplySystem == '3' || supplySystem == '4' || supplySystem == '9' || supplySystem == '10' || supplySystem == '11' || supplySystem == '12' || supplySystem == '13' || supplySystem=="18")
			ECL_SetValue("A_ZKK_BW_S210", "V_ZKK_BW_INT_S210");
		else
			ECL_SetValue("A_ZKK_BW_S210","V_ZKK_BW_EXT_S210");
}
	
	if(ECL_ValueSelected("A_ZKK_BW_S210", "V_ZKK_BW_EXT_S210"))
	{
		//externe BR's
		ECL_ActivateAttribute("A_ZKK_BW_EXTERN_S210");
		var apossibleBR=ECL_GetAllActiveAttributeValues("A_ZKK_BW_EXTERN_S210");
		
		var btest=false;
		for(var i=0;i<apossibleBR.length;i++)
		{
			var aktValue=ECL_GetValue("A_ZKK_BW_EXTERN_S210");
			if(apossibleBR[i]==aktValue)
				btest=true;
		}
		
		if(!btest || ECL_GetValue("A_ZKK_BW_EXTERN_S210")=="")
		{
			ECL_SetValue("A_ZKK_BW_EXTERN_S210",apossibleBR[0]);
		}
	}
	else
	{
		ECL_DeactivateAttribute("A_ZKK_BW_EXTERN_S210");
	}

	// CONSEQUENCES auswerten und Interface-Attribute setzen
	//------------------------------------------------------
	evalCC(s_mlfb)

	// Neue Liste der Sekundär-(Zubehör-)MLFB's bestimmen
	//------------------------------------------------------
	
	var allMlfb = evalAccConditions(s_mlfb);
	
	//Sekundär MLFB für Bremswiderstand	
	var strBrakeResistorID="";
	var selectedBrakingResistor = ECL_GetValue("A_ZKK_BW_S210");
	
	if(selectedBrakingResistor === "V_ZKK_BW_EXT_S210")
	{
		allMlfb=allMlfb+ECL_GetValue("A_ZKK_BW_EXTERN_S210")+";";
	}
	
	if(selectedBrakingResistor !== "custom")
	{
		// BR ID aus DB
		var strSelect="SELECT DISTINCT SZ_BR_ID FROM TBR_BrakingResistors WHERE ";
		var externalResistor = ECL_GetValue("A_ZKK_BW_EXTERN_S210");
		
		strSelect = strSelect + PRODUCT_GENERATION +"='"+s_mlfb+"' AND ";
		strSelect = strSelect + "SZ_BR_Artnum='"+externalResistor+"' AND ";
		
		if(supplySystem=="0" || supplySystem=="7")
			strSelect = strSelect + "Bemerkung='1AC230V' ";
		else if(supplySystem=="1" || supplySystem=="8")
			strSelect = strSelect + "Bemerkung='3AC240V' ";	
		else if(supplySystem=="2" || supplySystem=="3" || supplySystem=="4" || supplySystem=="9" || supplySystem=="10" || supplySystem=="11" || supplySystem=="12" || supplySystem=="13")
			strSelect = strSelect + "Bemerkung='3AC400V' ";		
			
		var aResult=Object.fromDatabase("S210_BR_DB", strSelect);
		if(aResult.length==1)
		{
			//Passt
			strBrakeResistorID=aResult[0].SZ_BR_ID;
		}
		else
		{
			logtraceln("Fehler bei Bestimmung der BR ID!; SQL="+strSelect);
			ECL_SelectValue("ECSI_STATUS", "E");
			ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_BRAKINGRESISTOR"));
		}
	}

	SetMlfbSec(allMlfb);

	// Kurzangaben an die Primär-MLFB generieren
	//------------------------------------------------------
	//s_mlfb = evalShortDescriptions(s_mlfb, base_mlfb);
	
	// Primär-MLFB updaten
	//------------------------------------------------------
	ECL_SetValue("ECSI_MLFB", s_mlfb);		// die Primär-MLFB wird hier geupdated

	if(s_mlfb.indexOf(".") > -1)	// wenn am Ende des Prozesses noch ein Punkt in der MLFB ist - Fehler: MLFB nicht voll spezifiziert
	{
		ECL_SelectValue("ECSI_STATUS", "E");
		ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_MLFB_INCOMPLETE"));
		return;
	}

	// ---------- Consequence erzeugen:
	
	if(ECL_ValueSelected("A_ZKK_BW_S210","custom"))
	{
		ECL_SetValue("ECSI_CC_BrakingResistorID", "custom");	// hier soll die ID für den Bremswiderstand rein
		ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "True");
	}
	else
	{
		ECL_SetValue("ECSI_CC_BrakingResistorID", strBrakeResistorID);	// hier soll die ID für den Bremswiderstand rein
		ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", "False");
	}

	ECL_SetValue("ECSI_CC_Selected_CU", "S210");
	// Zum debuggen: Zeige Fehlerstatus
	// manageGenerationDependentAttributes();

}

/**
    Abhängige Stellen der Primär-MLFB bei einem Ereignis ändern
    Kontext auswerten

    @param ca		das Ereignis
    @param mlfb		die aktuelle MLFB, wird evtl. geändert

    @return geänderte mlfb 
*/

function applyDependencies(ca, mlfb, mlfb_sec)
{
	var i;
	var bValue = false;

	// Feldbus-Schnittstelle (Kommunikation):
	if(ca === "ECSI_MLFB" || ca === "A_CU_FS_S210")
	{
		// Hier ist nur Profinet möglich, sonst gibt es nichts anderes
		var cu_fs = ECL_GetValue("A_CU_FS_S210");

		if(cu_fs == "V_CU_FS_PROFINET_S210")
			mlfb = replaceChar(mlfb, "F", 14);
		// else
		// 	mlfb = replaceChar(mlfb, ".", 14);

		if(ca !== "ECSI_MLFB")
			return mlfb;
	}
	// SD-Karte:
	// Hier kann aus dem Kontext eine Vorgabe bzgl. Safety - Funktionen kommen, die die
	// Zahl verfügbarer Karten einschränkt.
	// Diese Einschränkung muss immer gemacht werden, da FilterValues auch bei jedem Wertesetzen vorkommt
	if(true /* ca === "ECSI_MLFB" */)
	{
		
		var productSuffix = ""

		productSuffix = "S210_3"
		var cu_sd = ECL_GetValue("A_CU_SD_S210");

		var freshFirmwareVersions = [
			"V_OHNE",
			"V_CU_SD_FW64_SAFETY_S210_3",
			"V_CU_SD_FW64_S210_3",
			"V_CU_SD_J_S210_3",
			"V_CU_SD_J_SAFETY_S210_3",
			"V_CU_SD_J_S210",
			"V_CU_SD_J_SAFETY_S210",
			"V_CU_SD_FW52_SP3_S210",
			"V_CU_SD_FW52_SP3_SAFETY_S210"
		];

		if (!freshFirmwareVersions.includes(cu_sd)) {
			ECL_SelectValue("ECSI_STATUS", "WARNING");
			ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("WARNING_OUTDATED_FIRMWARE"));
		}

		// Vorgabe aus dem Kontext:
		// Wenn ECSI_CX_SafetyFunctions = 2,3,4,5,6,7,12 : nur V_CU_SD_FW51_SP_SAFETY_S210 oder V_CU_SD_FW52_SAFETY_S210
		var safety   = ECL_GetValue("ECSI_CX_SafetyFunctions");		// kann z.B. 0;1;2 sein
		var a_values = ECL_GetAllAttributeValues("A_CU_SD_S210");
		
		for(i=0; i < a_values.length; i++)
		{
			if(a_values[i].right(6) !== "S210_3")
			{
				ECL_DeactivateValue("A_CU_SD_S210", a_values[i]);
			}
		}
		ECL_ActivateValue("A_CU_SD_S210", "V_OHNE");
		
		if (safety != '') {
			var aSafetySplit = safety.split(';');
			var bRestrictSafety = false;
			for (var j = 0; j < aSafetySplit.length; ++j) {
				if (isValidChar(aSafetySplit[j], "234567") || (aSafetySplit[j] === "12") || (aSafetySplit[j] === "14")) {
					bRestrictSafety = true;
					break;
				}
			}
			if(bRestrictSafety)
			{
				//if we have safety, a gen 3 s210 and also V_CU_SD_FW52_SAFETY_S210 comes then we set it to V_CU_SD_FW64_SAFETY_S210_3
                if (ECL_GetValue("A_CU_SD_S210") == "V_CU_SD_FW52_SAFETY_S210") {
                    ECL_SelectValue("A_CU_SD_S210", "V_CU_SD_FW64_SAFETY_S210_3");
                }

				for(i=0; i < a_values.length; i++)
				{
					// 5.6.2019, Hr Hartmann: V_OHNE soll hier  nicht mehr erlaubt sein 
					bValue = (/*a_values[i] === "V_OHNE" || */ a_values[i].indexOf("SAFETY") > -1);
					// @@@ Achtung: hier noch ein check ob die Karte vorher durch den Filter nicht schon eliminiert wurde (FW 5.1 / 5.2)
					// applyCond("A_CU_SD_S210", a_values[i], bValue);
					if (! bValue)
					{
						//if(PRODUCT_GENERATION === "S210_3" && a_values[i].right(6) === "S210_3")
						ECL_DeactivateValue("A_CU_SD_S210", a_values[i]);
					}
				}
				// Auswahl ändern, weil die bisher gewählte Karte vielleicht nicht mehr dabei ist
				if(/*cu_sd !== "V_OHNE" &&*/ cu_sd.indexOf("SAFETY") == -1) {
					if (mlfb_sec == '') {	
						ECL_SetValue("A_CU_SD_S210", "V_CU_SD_FW64_SAFETY_S210_3");
					}
					else {  // im anderen Fall hat der Anwender während der Auswahl die Preference verschärft - Fehler; sonst würde im nachfolgenden Schritt 
							// bei der Analyse der Zubehör-MLFB's wieder der alte Wert gesetzt werden
							ECL_SelectValue("ECSI_STATUS", "E");
							ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_CONTEXT_TO_MLFB_MISMATCH"));
							return mlfb;						
					}
				}
			} 
		}
		
		/* Im anderen Fall werden bei Default schon alle angezeigt
		else if (ca === "ECSI_CX_SafetyFunctions")
		{
			for(i=0; i < a_values.length; i++)
				applyCond("A_CU_SD_S210", a_values[i], true);
		}
		*/

	}

	return mlfb;
}

function manageGenerationDependentAttributes()
{
	// supplementary disabling/enabling of attributes 
	// and options for which we need to know generation already
	/*
	if(PRODUCT_GENERATION === "S210_2")
	{
		var sdCardAttributeValues = ECL_GetAllAttributeValues("A_CU_SD_S210");
		ECL_ActivateAllAttributeValues("A_CU_SD_S210");
		for(var i=0; i < sdCardAttributeValues.length; i++)
		{
			var genIdentifier = sdCardAttributeValues[i].right(6);
			if(genIdentifier === "S210_3")
			{
				ECL_DeactivateValue("A_CU_SD_S210", sdCardAttributeValues[i]);
			}
		}
	}
	
	else if(PRODUCT_GENERATION === "S210_3")
	{
		var sdCardAttributeValues = ECL_GetAllAttributeValues("A_CU_SD_S210");
		ECL_DeactivateAllAttributeValues("A_CU_SD_S210");
		ECL_ActivateValue("A_CU_SD_S210", "V_OHNE");
		for(var i=0; i < sdCardAttributeValues.length; i++)
		{
			var genIdentifier = sdCardAttributeValues[i].right(6);
			if(genIdentifier === "S210_3")
			{
				ECL_ActivateValue("A_CU_SD_S210", sdCardAttributeValues[i]);
			}
		}
		
	}*/
}

/**
    Anpassungen Dialog abh. von MLFB
    geänderte MLFB zurückliefern
*/
function dlgSettings(mlfb)
{

    return mlfb;
}

/**
    zulässige Werte bei MLFB Positionen prüfen
        - abh. von festgelegtem integriertem Netzfilter A, B oder C
        - zulässige Eingabe an best. Positionen ( ohne Abhängigkeit von anderen Positionen ! )
        - wenn Netzfilter = . (isValidChar() liefert true) dann auf passenden Wert setzen
*/
function isMlfbPosValid(s_mlfb)
{
	if(! isValidChar(s_mlfb, "F", 14))
        return false;
    return true;
}


/* Evaluiere Patterns, die zusätzliche Kurzangaben an die Grund-MLFB generieren 
    Es wird hierfür eine eigene Datenstruktur benutzt (getAccConditionsSD())
    @@@ Aktuell wird die einzige Kurzangabe die hier generiert werden kann, nicht beim Parsen analysiert.
    Dies ist unkritisch, weil _gleichzeitig_ auch eine Zubehör-MLFB für das fragliche Merkmal erzeugt wird
    und dies beim Parsen ausreicht.
    
    @param mlfb			die aktuell konfigurierte komplette mlfb (gegebenenfalls mit Kurzangabe)
    @param base_mlfb	die aktuelle Grund-mlfb, d.h. die ersten 16 Stellen

    @return 			geänderte komplette mlfb (gegebenenfalls mit Kurzangabe)
*/
function evalShortDescriptions(mlfb, base_mlfb)
{
	var accArray = getAccConditionsSD();
	var sdArray = [];
	var andModus = true;
	var i, j;
	var bRet = true;
	for(i = 0; i < accArray.length; i++)
	{
		// passt RegEx ?
		if(! EK_regFound(mlfb, accArray[i][1]))
			continue;

		// keine Bedingung
		if(accArray[i][3].length <= 1)
			continue;

		for(j = 1; j < accArray[i][3].length; j++)
		{
			var numValue = accArray[i][3][j][1];
			bRet = ECL_ValueSelected(accArray[i][3][j][0], numValue);
			// kein Treffer - evtl. Nummer mit . statt ,
			if(! bRet && numValue.indexOf(",") > -1)
			{
				numValue = numValue.replace(",", ".")
				bRet = ECL_ValueSelected(accArray[i][3][j][0], numValue);
			}
			// selektiert - bei OR Ende da gültig
			if(bRet && ! andModus)
				break;
			// nicht selektiert - bei AND Ende da nicht gültig
			else if(! bRet && andModus)
				break;
		}
		if (bRet)
			sdArray.push(accArray[i][0]);		// wir sorgen vor, dass auch mehrere KA's an eine MLFB gehängt werden können
	}
	
	if (sdArray.length > 0) {
		mlfb = base_mlfb + '-Z';
		for (var i = 0; i < sdArray.length; ++i)
			mlfb += ' ' +  sdArray[i];
	}
	else
		mlfb = base_mlfb;
	
	return mlfb;
}



/**
    die Bestimmungen zusätzlicher MLFBs

    Array mit den Zeilen aus einem mehr-dimensionalen Array
    [
        MLFB des zusätzlichen Artikels,
        RegEx einer gültigen MLFB ( ! die Daten aus der Excel_Datei konvertieren ),
        [ "AND"|"OR",
            [ Attribut, Value ]
            , ...
        ]
    ]
*/
function getAccConditions()
{
	return [
	/*
		["mlfb of article", 								allow this accessory
			"regex for which its okay", 					with this device
			["CX attr cond.", "CX value cond."], 			if this context is present with this value
			["AND"|"OR", 									
				["attr", "val"]								sets this attribute to this value
			]
		],
	*/
		// SD CARD
		["6SL59700AA000AA0", // SD card 8gb empty
			"6SL53101B.......", 
			[], 
			["AND", 
				["A_CU_SD_S210", "V_CU_SD_J_S210_3"]
			]
		],
		["6SL59700AA000AA0-Z F01", // SD card 8gb empty, incl. safety
			"6SL53101B.......", 
			[],
			["AND", 
				["A_CU_SD_S210", "V_CU_SD_J_SAFETY_S210_3"]
			]
		],
		["6SL53700GB000AA0", // SD card 8gb fw 6.1
			"6SL53101B.......", 
			[],
			["AND", 
				["A_CU_SD_S210", "V_CU_SD_FW61_S210_3"]
			]
		],
		["6SL53700GB000AA0-Z F01", // SD card 8gb fw 6.1, incl. safety
			"6SL53101B.......", 
			[],
			["AND", 
				["A_CU_SD_S210", "V_CU_SD_FW61_SAFETY_S210_3"]
			]
		],
		["6SL53700GD000AA0", // SD card 8gb fw 6.3
			"6SL53101B.......", 
			[],
			["AND", 
				["A_CU_SD_S210", "V_CU_SD_FW63_S210_3"]
			]
		],
		["6SL53700GD000AA0-Z F01", // SD card 8gb fw 6.3, incl. safety
			"6SL53101B.......", 
			[],
			["AND", 
				["A_CU_SD_S210", "V_CU_SD_FW63_SAFETY_S210_3"]
			]
		],
		[ ECL_ValueSelected("A_OPC_UA_SE_S210", "T") ? "6SL53700GE000AA0-Z H80" : "6SL53700GE000AA0", // SD card 6.4
			"6SL53101B.......", 
			[],
			["AND", 
				["A_CU_SD_S210", "V_CU_SD_FW64_S210_3"]
			]
		],
		[ ECL_ValueSelected("A_OPC_UA_SE_S210", "T") ? "6SL53700GE000AA0-Z F01+H80" : "6SL53700GE000AA0-Z F01", // SD card 6.4 SAFETY
			"6SL53101B.......", 
			[],
			["AND", 
				["A_CU_SD_S210", "V_CU_SD_FW64_SAFETY_S210_3"]
			]
		],
		// Leistungsschalter 1 AC
		["3RV20111DA10", // Leistungsschalter 3,2A
			"6SL53101BB101CF0", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (CF0, DF1)
			["ECSI_CX_NP_S210", "1"], // StandardSupplySystem 0 7
			["AND", 
				["A_EO_LS_S210","V_EO_LS_032_S210"]
			],
		],
		["3RV20111FA10", // Leistungsschalter 5A
			"6SL53101BB102CF0", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (CF0, DF1)
			["ECSI_CX_NP_S210", "1"], // StandardSupplySystem 0 7
			["AND", 
				["A_EO_LS_S210","V_EO_LS_050_S210"]
			],
		],
		["3RV20111JA10", // Leistungsschalter 10A
			"6SL53101BB104CF0", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (CF0, DF1)
			["ECSI_CX_NP_S210", "1"], // StandardSupplySystem 0 7
			["AND", 
				["A_EO_LS_S210","V_EO_LS_100_S210"]
			],
		],
		["3RV20111KA10", // Leistungsschalter 12,5A
			"6SL53101BB108CF0", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (CF0, DF1)
			["ECSI_CX_NP_S210", "1"], // StandardSupplySystem 0 7
			["AND", 
				["A_EO_LS_S210","V_EO_LS_125_S210"]
			],
		],

		// Leistungsschalter 3 AC
		["3RV20111DA10", // Leistungsschalter 3,2A
			"6SL53101BE104DF1", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (only CF0, DF1)
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_LS_S210","V_EO_LS_032_S210"]
			],
		],
		["3RV20111FA10", // Leistungsschalter 5A
			"6SL53101BE108DF1", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (only CF0, DF1)
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_LS_S210","V_EO_LS_050_S210"]
			],
		],
		["3RV20111HA10", // Leistungsschalter 8A
			"6SL53101BE110DF1", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (only CF0, DF1)
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_LS_S210","V_EO_LS_080_S210"]
			],
		],
		["3RV20111JA10", // Leistungsschalter 10A
			"6SL53101BE115DF1", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (only CF0, DF1)
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_LS_S210","V_EO_LS_100_S210"]
			],
		],
		["3RV20114AA10", // Leistungsschalter 16A
			"6SL53101BE120DF1", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (only CF0, DF1)
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_LS_S210","V_EO_LS_160_S210"]
			],
		],
		["3RV20214DA10", // Leistungsschalter 25A
			"6SL53101BE135DF1", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (only CF0, DF1)
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_LS_S210","V_EO_LS_250_S210"]
			],
		],
		["3RV20214NA10", // Leistungsschalter 28A
			"6SL53101BE150DF1", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (only CF0, DF1)
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_LS_S210","V_EO_LS_280_S210"]
			],
		],
		["3RV20214EA10", // Leistungsschalter 32A
			"6SL53101BE170DF1", // supposedly this should end with UF0, but never seen an order number for 3rd gen S210 ending with that (only CF0, DF1)
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_LS_S210","V_EO_LS_320_S210"]
			],
		],
		
		// Interner netzfilter 1 AC
		["", 
			"6SL53101BB......",
			["ECSI_CX_NP_S210", "1"], // StandardSupplySystem 0 7
			["AND", 
				["A_NETZFILTER_INT_S210","V_KAT_INT_C2_S210"]
			],
		],
		
		// Interner netzfilter 3 AC
		["", // Leistungsschalter 32A
			"6SL53101BE......",
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_NETZFILTER_INT_S210","V_KAT_INT_C3_S210"]
			],
		],
		
		// Externer netzfilter 1 AC
		["6SL32030BB218VA1", 
			"6SL53101BB......",
			["ECSI_CX_NP_S210", "1"], // StandardSupplySystem 0 7
			["AND", 
				["A_NETZFILTER_EXT_S210","V_KAT_EXT_C2_S210"]
			],
		],
		
		//Externer netzfiter 3 AC
		["6SL32030BE235HA0", // Kategorie C2, 35A
			"6SL53101BE(104|108|110)...",
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_NETZFILTER_EXT_S210","V_KAT_EXT_C2_6SL32030BE235HA0_S210"]
			],
		],
		["6SL32030BE265HA0", // Kategorie C2, 65A
			"6SL53101BE......",
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_NETZFILTER_EXT_S210","V_KAT_EXT_C2_6SL32030BE265HA0_S210"]
			],
		],
		
		// Sicherung 1 AC
		["3NA3804", // NH-Sicherung (IEC) 4A
			"6SL53101BB101CF0",
			["ECSI_CX_NP_S210", "1"], // StandardSupplySystem 0 7
			["AND", 
				["A_EO_SS_S210","V_EO_SS_004_S210"]
			],
		],
		["3NA3801", // NH-Sicherung (IEC) 6A
			"6SL53101BB102CF0",
			["ECSI_CX_NP_S210", "1"], // StandardSupplySystem 0 7
			["AND", 
				["A_EO_SS_S210","V_EO_SS_006_S210"]
			],
		],
		["3NA3803", // NH-Sicherung (IEC) 10A
			"6SL53101BB104CF0",
			["ECSI_CX_NP_S210", "1"], // StandardSupplySystem 0 7
			["AND", 
				["A_EO_SS_S210","V_EO_SS_010_S210"]
			],
		],
		["3NA3805", // NH-Sicherung (IEC) 16A
			"6SL53101BB108CF0",
			["ECSI_CX_NP_S210", "1"], // StandardSupplySystem 0 7
			["AND", 
				["A_EO_SS_S210","V_EO_SS_016_S210"]
			],
		],
		["3NA3812", // NH-Sicherung (IEC) 32A for a group
			"6SL53101BB......",
			["ECSI_CX_NP_S210", "1"], // StandardSupplySystem 0 7
			["AND", 
				["A_EO_SS_S210","V_EO_SS_032_eine_Gruppe_S210"]
			],
		],
		
		// ["ECSI_CX_ANZ_S210", "3"],
		// Sicherung 3 AC
		["3NA3804", // NH-Sicherung (IEC) 4A
			"6SL53101BE104DF1",
			["ECSI_CX_ANZ_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_SS_S210","V_EO_SS_004_S210"]
			],
		],
		["3NA3801", // NH-Sicherung (IEC) 6A
			"6SL53101BE108DF1",
			["ECSI_CX_ANZ_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_SS_S210","V_EO_SS_006_S210"]
			],
		],
		["3NA3803", // NH-Sicherung (IEC) 10A
			"6SL53101BE(110|115)DF1",
			["ECSI_CX_ANZ_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_SS_S210","V_EO_SS_010_S210"]
			],
		],
		["3NA3805", // NH-Sicherung (IEC) 16A
			"6SL53101BE120DF1", 
			["ECSI_CX_ANZ_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_SS_S210","V_EO_SS_016_S210"]
			],
		],
		["3NA3810", // NH-Sicherung (IEC) 25A
			"6SL53101BE135DF1",
			["ECSI_CX_ANZ_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_SS_S210","V_EO_SS_025_S210"]
			],
		],
		["3NA3812", // NH-Sicherung (IEC) 32A
			"6SL53101BE(150|170)DF1",
			["ECSI_CX_ANZ_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_SS_S210","V_EO_SS_032_S210"]
			],
		],
		["3NA3830", // NH-Sicherung (IEC) 100A DC-Link, per group
			"6SL53101BE......",
			["ECSI_CX_ANZ_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_EO_SS_S210","V_EO_SS_100_S210"]
			],
		],
		
		// Steckersatz
		["6SL32602DC000AA0", // Steckersatz AC/DC
			"6SL53101BE......",
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_AT_ZKP_S210","V_AT_ZKP_STECKER_6SL32602DC000AA0_S210"]
			]
		],
		
		["6SL32602DC100AA0", // Steckersatz nur AC
			"6SL53101BE......",
			["ECSI_CX_NP_S210", "3"], // StandardSupplySystem 1 2 3 4 5 6 8 9 10 11 12 13 14 15
			["AND", 
				["A_AT_ZKP_S210","V_AT_ZKP_STECKER_6SL32602DC100AA0_S210"]
			],
		],
	]
}

/**
    die Bedingungen für Einträge in den Auswahllisten

    Array mit den Zeilen
    [
        RegEx einer gültigen MLFB ( ! die Daten aus der Excel_Datei konvertieren ),
        [ Attribut, Value ]
    ]
*/
function getAttributValueConditions()
{
    var a_cond = [];
    return a_cond;
}

/**
    die Bestimmungen von Kurzangaben für die Primär-MLFB
*/
function getAccConditionsSD()
{
    var a_cond = [];
    /* Primär-MLFB hat keine Kurzangabe, die KA sitzt am Zubehör 
    a_cond.push(
        [ "F01",
            "6SL32105HB......",
            ["ECSI_CX_ANZ_S210", "1"],
            ["AND",
                ["A_CU_SD_S210", "V_CU_SD_FW51_SP_SAFETY_S210"] ]
        ]);
    a_cond.push(
        [ "F01",
            "6SL32105H.......",
            ["ECSI_CX_ANZ_S210", "1"],
            ["AND",
                ["A_CU_SD_S210", "V_CU_SD_FW52_SAFETY_S210"] ]
        ]);
    */
    return a_cond;
}

/**
    Consequences setzen abh. von diversen Attributen
*/
function evalCC(mlfb)
{
    // immer diese Werte gem. Vorgabe
    ECL_SetValue("ECSI_CC_ControlMode", "3");
    ECL_SetValue("ECSI_CC_IpProtectionLevelFrequencyConverter", "20");
    
    if(ECL_GetValue("A_NETZFILTER_INT_S210")=="V_KAT_INT_C2_S210")
        ECL_SetValue("ECSI_CC_InputFilterType", "2");
    else if(ECL_GetValue("A_NETZFILTER_INT_S210")=="V_KAT_INT_C3_S210")
        ECL_SetValue("ECSI_CC_InputFilterType", "3");
    else
        ECL_SetValue("ECSI_CC_InputFilterType", "0");
    
    if(ECL_GetValue("A_NETZFILTER_EXT_S210")=="V_KAT_EXT_C2_S210"||ECL_GetValue("A_NETZFILTER_EXT_S210")=="V_KAT_EXT_C2_6SL32030BE235HA0_S210"||ECL_GetValue("A_NETZFILTER_EXT_S210")=="V_KAT_EXT_C2_6SL32030BE265HA0_S210")
        ECL_SetValue("ECSI_CC_ExternalFilterType", "2");
    else if(ECL_GetValue("A_NETZFILTER_EXT_S210") == "V_OHNE")
        ECL_SetValue("ECSI_CC_ExternalFilterType", "0");

    return mlfb;
}

function check_SEC_MLFB_forBR(s_mlfb, mlfb_sec)
{
	var CustomBrakingResistor = ECL_GetValue("ECSI_CX_CustomBrakingResistor");
	
	if(CustomBrakingResistor=="True" || CustomBrakingResistor=="1")
	{
		ECL_SetValue("A_ZKK_BW_S210", "custom");
	}
	else if (mlfb_sec === '') 
	{
		var supplySystem = ECL_GetValue("ECSI_CX_StandardSupplySystem");

		strSelect="SELECT F2,SZ_BR_Artnum FROM TBR_BrakingResistors WHERE ";
		strSelect=strSelect + "SZ_BR_Artnum='' AND ";
		
		if(supplySystem=="0" || supplySystem=="7")
			strSelect = strSelect + "Bemerkung='1AC230V' AND ";
		else if(supplySystem=="1" || supplySystem=="8")
			strSelect = strSelect + "Bemerkung='3AC240V' AND ";	
		else if(supplySystem=="2" || supplySystem=="3" || supplySystem=="4" || supplySystem=="9" || supplySystem=="10" || supplySystem=="11" || supplySystem=="12" || supplySystem=="13")
			strSelect = strSelect + "Bemerkung='3AC400V' AND ";

		strSelect=strSelect + PRODUCT_GENERATION +"='"+s_mlfb+"' ";
		
		var aResult=Object.fromDatabase("S210_BR_DB",strSelect);
		if(aResult.length==1)
		{
			if(aResult[0].F2=="built-in")
				ECL_SetValue("A_ZKK_BW_S210","V_ZKK_BW_INT_S210");
		}
		else
		{
			logtraceln("Fehler bei Auflösung der SEC MLFB bei Bremswiderstand!");
			ECL_SelectValue("ECSI_STATUS", "E");
			ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_BRAKINGRESISTOR"));
		}
	}	
	else
	{
		mlfb_sec = trimright(mlfb_sec, ";");
		var mlfbArray = mlfb_sec.split(";");

		var strSelect="";
		
		for(i = 0; i < mlfbArray.length; i++)
		{
			if( left(mlfbArray[i],3)=="GXK" || left(mlfbArray[i],3)=="KOC")
			{
				strSelect="SELECT F2,SZ_BR_Artnum FROM TBR_BrakingResistors WHERE ";
				strSelect=strSelect + "SZ_BR_Artnum='"+mlfbArray[i]+"' AND ";
				strSelect=strSelect + PRODUCT_GENERATION +"='"+s_mlfb+"' ";
				
				var aResult=Object.fromDatabase("S210_BR_DB",strSelect);
				if(aResult.length==1)
				{
					if(aResult[0].F2=="built-in")
						ECL_SetValue("A_ZKK_BW_S210","V_ZKK_BW_INT_S210");
					else if(aResult[0].F2=="external")
					{
						ECL_SetValue("A_ZKK_BW_S210","V_ZKK_BW_EXT_S210");	
					}
					
					ECL_SetValue("A_ZKK_BW_EXTERN_S210",aResult[0].SZ_BR_ARTNUM);
				}
				else
				{
					
					logtraceln("Fehler bei Auflösung der SEC MLFB bei Bremswiderstand!");
					ECL_SelectValue("ECSI_STATUS", "E");
					ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_BRAKINGRESISTOR"));
					
				}
			}
		}
	}
}

function getpossible_SEC_MLFBs_BR(s_mlfb, supplySystem)
{
	var strCertificates=ECL_GetValue("ECSI_CX_Certificates");
	
	// Logik:
	// Wenn kein Zertifikat gewählt ==> alle anzeigen (0)
	// Wenn nur CE gewählt ==> CE und UL anzeigen (1)
	// Wenn nur UL gewählt => nur UL anzeigen (2)
	// Wenn UL und CE gewählt ==> nur UL anzeigen (2)
	
	var iCert=0;
	var aCertificates = strCertificates.split("|");
	if(aCertificates.length == 1)
	{
		if(aCertificates[0]=="None")
			iCert=0;
	}
	else if(aCertificates.length == 2)
	{
		if(aCertificates[1]=="CE")
			iCert=1;
		else if(aCertificates[1]=="ULR_CSA")
			iCert=2;
	}
	else if(aCertificates.length == 3)
	{
		if(aCertificates[1]=="CE")
		{	
			if(aCertificates[2]=="ULR_CSA")
				iCert=2;
			else
				iCert=1;
		}
		else if(aCertificates[1]=="ULR_CSA")
			iCert=2;
	}
		
	var strSelect="";
	if(supplySystem=="1" || supplySystem=="8")
	{
		//zuerst den ohne CE oder UL-R
		strSelect="SELECT DISTINCT SZ_BR_Artnum FROM TBR_BrakingResistors WHERE ";
		
		strSelect = strSelect + PRODUCT_GENERATION +"='"+s_mlfb+"' AND ";
		strSelect = strSelect + "(SZ_BR_artnum not like '%UL' AND SZ_BR_artnum not like '%CE') AND ";
		strSelect = strSelect + "Bemerkung='3AC240V' UNION ";	
	}	
	
	//aus DB
	strSelect=strSelect+"SELECT DISTINCT SZ_BR_Artnum FROM TBR_BrakingResistors WHERE ";
	
	strSelect = strSelect + PRODUCT_GENERATION +"='"+s_mlfb+"' AND ";
			
	if(iCert==1)
		strSelect = strSelect + "(SZ_BR_artnum like '%UL' OR SZ_BR_artnum like '%CE') AND ";
	else if(iCert==2)
		strSelect = strSelect + "SZ_BR_artnum like '%UL' AND ";

	
	if(supplySystem=="0" || supplySystem=="7")
		strSelect = strSelect + "Bemerkung='1AC230V' ";
	else if(supplySystem=="1" || supplySystem=="8")
		strSelect = strSelect + "Bemerkung='3AC240V' ";	
	else if(supplySystem=="2" || supplySystem=="3" || supplySystem=="4" || supplySystem=="9" || supplySystem=="10" || supplySystem=="11" || supplySystem=="12" || supplySystem=="13")
		strSelect = strSelect + "Bemerkung='3AC400V' ";		
		
	var aResult=Object.fromDatabase("S210_BR_DB", strSelect);
	if(aResult.length>0)
	{
		for(var i=0;i<aResult.length;i++)
			ECL_ActivateValue("A_ZKK_BW_EXTERN_S210",aResult[i].SZ_BR_ARTNUM);
		
	}
	else
	{
		//Es gibt keine UL oder CE Bremswiderstände
		
		var strSelect="SELECT DISTINCT SZ_BR_Artnum FROM TBR_BrakingResistors WHERE ";
	
		strSelect = strSelect + PRODUCT_GENERATION +"='"+s_mlfb+"' AND ";
		strSelect = strSelect + "SZ_BR_artnum <> '' AND ";
		
		if(supplySystem=="0" || supplySystem=="7")
			strSelect = strSelect + "Bemerkung='1AC230V' ";
		else if(supplySystem=="1" || supplySystem=="8")
			strSelect = strSelect + "Bemerkung='3AC240V' ";	
		else if(supplySystem=="2" || supplySystem=="3" || supplySystem=="4" || supplySystem=="9" || supplySystem=="10" || supplySystem=="11" || supplySystem=="12" || supplySystem=="13" || supplySystem=="18")
			strSelect = strSelect + "Bemerkung='3AC400V' ";		
			
		var aResult=Object.fromDatabase("S210_BR_DB", strSelect);
		if(aResult.length>0)
		{
			for(var i=0;i<aResult.length;i++)
				ECL_ActivateValue("A_ZKK_BW_EXTERN_S210",aResult[i].SZ_BR_ARTNUM);
		
		}
		else
		{
			logtraceln("Fehler bei Bestimmung der SEC MLFB und BR ID!; SQL="+strSelect);
			ECL_SelectValue("ECSI_STATUS", "E");
			ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("ERROR___S210_BRAKINGRESISTOR"));
		}
	}
}

function manageKeepconfig(s_mlfb)
{
    var isStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    var strBaseTypeMLFB=ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    
    if(isStartConfiguration=="1" && s_mlfb!=strBaseTypeMLFB)
    {		
        var aBaseTypeMLFB=strBaseTypeMLFB.split('');
        var as_mlfb=s_mlfb.split('');
        for (var i=0;i<aBaseTypeMLFB.length;i++)
        {
            if(aBaseTypeMLFB[i] != ".")
            {
                as_mlfb[i]=aBaseTypeMLFB[i];
            }
        }
        
        s_mlfb="";
        for (var i=0;i<as_mlfb.length;i++)
            s_mlfb=s_mlfb+as_mlfb[i];
        
        return s_mlfb;
    }
    else if(isStartConfiguration=="1")
        return strBaseTypeMLFB;
    else
        return s_mlfb;
}
