//@legacy
/**
*		Script for configuration object CFG_SIEMENS_V20
*
*		Achtung! 		MLFB darf nicht auf den ersten 10 oder 13 Stellen geändert werden
*					 !		bisher nur AND bei Bedingungen umgesetzt
*
* 	Date: 2019-02-01
* 	User: Hans Martin Bauer, Plan Software GmbH
*
*		Mod:	2019-02-15 mb	Namenskonventionen umgesetzt
*													A_ --> ECSI_
*		Mod:	2019-02-21 mb	mehrere Bedingungen definieren und auswerten (ECSI_CX_abc)
*												alle Bedingungen erfasst (ECSI_CX_ANZAHL, ECSI_CX_INDUK, ECSI_CX_NP, ECSI_CX_VERLU)
*												Bedingungen aus der Excel Datei können bei EK_regFound() benutzt werden
*													6SL32105BB{112;125;137;155;175;211;215}???
*												wird umgeformt
*													6SL32105BB(112|125|137|155|175|211|215)...
*		Mod:	2019-02-22 mb	in der MLFB "." statt "?" setzen
*												Combo Netzfilter anpassen : hat max. 2 Einträge, abh. von MLFB
*		Mod:	2019-02-25 mb	"feste" Werte
*		Mod:	2019-02-26 mb	Analyse Zubehör bei Fortsetzung der Konfiguration
*													Übergabe in ECSI_MLFB_CHECK_SEC
*												MLFB wird nur in Großbuchstaben gewandelt, ansonsten muss sie korrekt sein (Länge!)
*		Mod:	2019-02-27 mb	Namenskonventionen korrigiert
*		Mod:	2019-02-28 mb	ECSI_CX_StandardSupplySystem liefert den kodierten Wert der Phasen -> ECSI_CX_NP_V20
*												ECSI_CX_NP_V20 nicht ändern bei Validierung
*												ECSI_CX_ANZ_V20 -> Anzahl des jeweiligen Zubehörteils, MLFB wird entsprechend oft in ECSI_MLFB_SEC aufgenommen
*		Mod:	2019-03-01 mb	Mindestanforderung an eine evt. gültige MLFB
*		Mod:	2019-04-02 mb	nur Comboboxen; defaults gesetzt
*		Mod:	2019-05-13 mb	Auswahllisten filtern : abh. von MLFB nur mögliche Werte anzeigen
*/

//@import "SIZER_simplecfg_utils.js"

//@import "SIZER_general_functions.js"


//#mode(full-ecma)




globalThis.OnChangeConfiguration = function main() {
    /*
        // erlaubte MLFBs aus Katalog D31.1 06/2018
        6SL32105BB112.V1
        6SL32105BB125.V1
        6SL32105BB137.V1
        6SL32105BB155.V1
        6SL32105BB175.V1
        6SL32105BB211.V1
        6SL32105BB215.V1
        6SL32105BB222.V0
        6SL32105BB230.V0
        6SL32105BE137.V0
        6SL32105BE155.V0
        6SL32105BE175.V0
        6SL32105BE211.V0
        6SL32105BE215.V0
        6SL32105BE222.V0
        6SL32105BE230.V0
        6SL32105BE240.V0
        6SL32105BE255.V0
        6SL32105BE275.V0
        6SL32105BE311.V0
        6SL32105BE315.V0
        6SL32105BE318.V0
        6SL32105BE322.V0

        6SL32165B.......
        
        // Basis MLFBs aus TIA Selection Tool
        6SL32105........ wie oben!
        6SL32165BE175.V0

        Positionen 1 - 16
        6SL32105B.....V0
        6SL32105B.....V1
        6SL32165B.....V0
        6SL32165B.....V1
    */

    SetAttributesFromMlfb();
    

    // RegEx für eine Mindestanforderung an eine evt. gültige MLFB
    // vesch. Kombinationen sind dennoch falsch
    var s_regMlfb = "{6SL32105B;6SL32165B}{B;E}{112;125;137;155;175;211;215;222;230;240;255;275;311;315;318;322}{A;B;C;U}V{0;1}";

    var ca 	 = ECL_GetCurrentAttribute();
    var v 	 = ECL_GetValue(ca);

    // Daten wurden zum Test in das Feld geschrieben
    if(ca === "ECSI_MLFB_CHECK_SEC" && v === "")
        return;

    var s_mlfb = ECL_GetValue("ECSI_MLFB");
    var s_mlfb_sec 	= GetMlfbSec();
    if ((s_mlfb === '') && (ca != "@INIT@"))
        return;
    s_mlfb = s_mlfb.replace("?", ".").toUpperCase();
    
    // die Original einmal MLFB speichern
    saveMlfb(s_mlfb);
    ECL_SetValue("ECSI_MLFB_CHECK_SEC", s_mlfb_sec);	

    ECL_SelectValue("ECSI_STATUS", "OK");
    ECL_ResetAttribute("ECSI_STATUS_MESSAGE");

    var context_RegenMode = ECL_GetValue("ECSI_CX_RegenerativeMode");	// New Context Variable for selecting a brake resistor
    

    if(ca === "@INIT@")
    {
        ECL_SetUserVariable("MLFB", "");
        ECL_SetUserVariable("ORIGINAL_MLFB", "");
        ECL_DisableAttribute("ECSI_STATUS");
        ECL_DisableAttribute("ECSI_STATUS_MESSAGE");
        SetMlfbSec("");
        ECL_DisableAttribute("ECSI_MLFB_SEC");
        ECL_SetValue("ECSI_CX_StandardSupplySystem", "0");
        ECL_SetValue("ECSI_CX_NP_V20", "1");
        ECL_DisableAttribute("ECSI_CX_NP_V20");
        ECL_DisableAttribute("A_SA_SA_V20");

        // Consequences: ----------------- by Katrin--------------
        ECL_DisableAttribute("ECSI_CC_ControlUnit");
        ECL_DisableAttribute("ECSI_CC_BrakeRelays");
        // defaults
        ECL_SetValue("ECSI_CC_ControlUnit", "");    // -------------by Katrin-----------
        ECL_SetValue("ECSI_CC_BrakeRelays", "");
        ECL_SetValue("A_NETZFILTER_INT_V20", "V_KAT_NONE_V20");
        ECL_SetValue("A_CU_SD_V20", "V_OHNE");
        
        
        // als Combobox:
        //ECL_SetValue("A_CU_BOP_V20", "V_NEIN");
        //ECL_SetValue("A_CU_BOPI_V20", "V_NEIN");
        //ECL_SetValue("A_CU_PL_V20", "V_NEIN");
        //ECL_SetValue("A_CU_WM_V20", "V_NEIN");
        //ECL_SetValue("A_CU_IOEM_V20", "V_NEIN");
        //ECL_SetValue("A_ZB_SSS_V20", "V_NEIN");
        //ECL_SetValue("A_EO_LS_V20", "V_NEIN");
        //ECL_SetValue("A_EO_SS_V20", "V_NEIN");
        //ECL_SetValue("A_EO_ND_V20", "V_NEIN");
        //ECL_SetValue("A_ZKK_BW_V20", "V_NEIN");
        //ECL_SetValue("A_ZKK_BM_V20", "V_NEIN");
        //ECL_SetValue("A_AO_MD_V20", "V_NEIN");	
        
        // Als Checkbox
        ECL_DeselectAttribute ("A_CU_BOP_V20");
        ECL_DeselectAttribute ("A_CU_BOPI_V20");
        ECL_DeselectAttribute ("A_CU_PL_V20");
        ECL_DeselectAttribute ("A_CU_WM_V20");
        ECL_DeselectAttribute ("A_CU_WM_V20");
        ECL_DeselectAttribute ("A_ZB_SSS_V20");
        ECL_DeselectAttribute ("A_EO_MMK_V20");
        ECL_DeselectAttribute ("A_EO_LS_V20");
        ECL_DeselectAttribute ("A_EO_SS_V20");
        ECL_DeselectAttribute ("A_EO_ND_V20");
        ECL_DeselectAttribute ("A_ZKK_BW_V20");
        ECL_DeselectAttribute ("A_ZKK_BM_V20");
        ECL_DeselectAttribute ("A_AO_MD_V20");
        
        // Als Combobox				
        ECL_SetValue("A_NETZFILTER_EXT_V20", "V_KAT_EXT_NONE_V20");
        
            
        
        
        return;
    }
    else if(ca === "ECSI_MLFB")	// Übergabe Kontext, Primär und Sekundär-MLFB in einem Schritt
    {
        //Keep config if necessary
        manageKeepConfiguration(s_mlfb);
        s_mlfb = ECL_GetValue("ECSI_MLFB");
        s_mlfb_sec 	= GetMlfbSec();
        
        // MLFB auf Korrektheit prüfen:
        if(s_mlfb.length != 16)
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", "MLFB_LENGTH_INVALID");
            return;
        }

        if(left(s_mlfb, 9) !== "6SL32105B" && left(s_mlfb, 9) !== "6SL32165B")
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", "MLFB_SERIES_INVALID");
            return;
        }

        if(s_mlfb.indexOf(".") == -1 && ! EK_regFound(s_mlfb, s_regMlfb))
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", "MLFB_PATTERN_INVALID");
            return;
        }

        // IMMER
        s_mlfb = replaceChar(s_mlfb, "V", 14);

        //------------------------------
        // Kontext-Information auswerten:
        // Netzphasen ableiten aus ID, Zubehör neu berechnen
        var supplySystem = ECL_GetValue("ECSI_CX_StandardSupplySystem");
        if(supplySystem === "0" || supplySystem === "5")
            ECL_SetValue("ECSI_CX_NP_V20", "1");
        else
            ECL_SetValue("ECSI_CX_NP_V20", "3");

        //------------------------------
        // Auswahllisten auswerten - mögliche Werte einschränken / erlauben
        // Die Primär-MLFB muss vervollständigt werden bevor die Filterbedingungen laufen, weil
        // diese auf der primär-MLFB aufbauen
        s_mlfb = applyDependencies(ca, s_mlfb);
       
        filterValues(s_mlfb);


        // aus MLFBs Zubehöre - Anpassungen Dialog : Werte und Auswahllisten setzen
        // wird nur bei setzen der Haupt MLFB angestoßen
        //------------------------------
        evalAccParts(s_mlfb, s_mlfb_sec);

        // Haupt MLFB - Anpassungen Dialog : Werte und Selektion in Auswahllisten setzen
        s_mlfb = dlgSettings(s_mlfb);
    }
    else
    {
        // Auswahllisten auswerten - mögliche Werte einschränken / erlauben	
        s_mlfb = applyDependencies(ca, s_mlfb);		// Zuerst die Primär-MLFB aktualisieren
        filterValues(s_mlfb);
    }

    // Wert externer Netzfilter zurücksetzen, wenn nur noch ohne zulässig
    var v = ECL_GetAllActiveAttributeValues("A_NETZFILTER_EXT_V20");
    if (v.length == 1)
        ECL_SetValue("A_NETZFILTER_EXT_V20", "V_KAT_EXT_NONE_V20");
    

    // CONSEQUENCES auswerten und Interface-Attribute setzen - nicht bei V20
    //------------------------------------------------------
    // evalCC(s_mlfb)
    
    // Filter Types
    // internal
    ECL_SetValue("ECSI_CC_InputFilterType", "0");
    if (ECL_ValueSelected("A_NETZFILTER_INT_V20", "V_KAT_C1_V20"))
    {
        ECL_SetValue("ECSI_CC_InputFilterType", "1");
    }
    else if (ECL_ValueSelected("A_NETZFILTER_INT_V20", "V_KAT_C2_V20"))
    {
        ECL_SetValue("ECSI_CC_InputFilterType", "2");
    }
    else if (ECL_ValueSelected("A_NETZFILTER_INT_V20", "V_KAT_C3_V20"))
    {
        ECL_SetValue("ECSI_CC_InputFilterType", "3");
    }
    else
    {
        ECL_SetValue("ECSI_CC_InputFilterType", "0");
    }
    
    //external
    ECL_SetValue("ECSI_CC_ExternalFilterType", "0");
    if (ECL_ValueSelected("A_NETZFILTER_EXT_V20", "V_KAT_EXT_C1_V20"))
    {
        ECL_SetValue("ECSI_CC_ExternalFilterType", "1");
    }
    else if (ECL_ValueSelected("A_NETZFILTER_EXT_V20", "V_KAT_EXT_C2_V20"))
    {
        ECL_SetValue("ECSI_CC_ExternalFilterType", "2");
    }
    else
    {
        ECL_SetValue("ECSI_CC_ExternalFilterType", "0");
    }
    
    ECL_SetValue("ECSI_CC_BrakingModuleID", "");	// hier soll die MLFB für Attribut A_ZKK_BM_V20 rein
    var enabled;
    if (ECL_ValueSelected("A_ZKK_BM_V20", "T")) {
        
        var a_filter = getAccConditions();
        for(var i = 0; i < a_filter.length; i++)
        {
            enabled = EK_regFound(s_mlfb, a_filter[i][1]);
            if (enabled && (a_filter[i][3][1][0] == "A_ZKK_BM_V20")) {	// @@@ Hack 
                var acc_mlfb = a_filter[i][0];
                ECL_SetValue("ECSI_CC_BrakingModuleID", acc_mlfb);
            }
        }
    }
    ECL_SetValue("ECSI_CC_BrakingResistorID", "");	// hier soll die MLFB für Attribut A_ZKK_BW_V20 rein
    if (ECL_ValueSelected("A_ZKK_BW_V20", "T")) {
        
        var a_filter = getAccConditions();
        for(var i = 0; i < a_filter.length; i++)
        {
            enabled = EK_regFound(s_mlfb, a_filter[i][1]);
            if (enabled && (a_filter[i][3][1][0] == "A_ZKK_BW_V20")) {	// @@@ Hack 
                var acc_mlfb = a_filter[i][0];
                ECL_SetValue("ECSI_CC_BrakingResistorID", acc_mlfb);
            }
        }
    }
    
    // -----------------------------------------------------

    if(left(s_mlfb, 9) === "6SL32165B")
    {
        s_mlfb = replaceChar(s_mlfb, "C", 13);

        ECL_DeactivateAllAttributeValues("A_NETZFILTER_INT_V20");
        ECL_ActivateValue("A_NETZFILTER_INT_V20", "V_KAT_C3_V20");
        ECL_SetValue("A_NETZFILTER_INT_V20", "V_KAT_C3_V20");

        ECL_DeactivateAllAttributeValues("A_NETZFILTER_EXT_V20");
        ECL_ActivateValue("A_NETZFILTER_EXT_V20", "V_KAT_EXT_NONE_V20");
        ECL_SelectValue("A_NETZFILTER_EXT_V20", "V_KAT_EXT_NONE_V20");
    }

    // Neue Liste der Sekundär-(Zubehör-)MLFB's bestimmen
    //------------------------------------------------------
    var allMlfb = evalAccConditions(s_mlfb);
    SetMlfbSec(allMlfb);

    // Kurzangaben an die Primär-MLFB generieren - nicht bei V20
    //------------------------------------------------------
    // var base_mlfb = ECL_GetUserVariable("ORIGINAL_MLFB");	// kann hier benutzt werden weil kein Punkt drin ist
    // s_mlfb = evalShortDescriptions(s_mlfb, base_mlfb);

    // Primär-MLFB updaten
    //------------------------------------------------------
    ECL_SetValue("ECSI_MLFB", s_mlfb);		// die Primär-MLFB wird hier geupdated

    // einzelne MLFB Positionen prüfen
    //------------------------------------------------------
    if(! isMlfbPosValid(s_mlfb))
    {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", "MLFB_POS_INVALID");
        return;
    }

    if(s_mlfb.indexOf(".") > -1)
    {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", "MLFB_INCOMPLETE");
        return;
    }
    
    
    var motorTechnology = ECL_GetValue("ECSI_CX_MotorTechnology");
    if(motorTechnology === "1" || motorTechnology === "2")
    {
        //A_AO_MD_V20 deselect T, deactivate
        ECL_DeselectValue("A_AO_MD_V20");
        ECL_DeactivateAttribute("A_AO_MD_V20");
    }
}

/**
    Abhängige Stellen der Primär-MLFB bei einem Ereignis ändern
    Kontext auswerten

    @param ca		das Ereignis
    @param s_mlfb	die aktuelle MLFB, wird evtl. geändert

    @return geänderte mlfb 
*/
function applyDependencies(ca, s_mlfb)
{
    // Auswahllisten auswerten und MLFB anpassen
    var nf_int 	= ECL_GetValue("A_NETZFILTER_INT_V20");
    var bop 	= ECL_GetValue("A_CU_BOP_V20");
    
    
    //neue Abhängiigkeiten für Release 2021.04
    if(ca=="A_ZKK_BW_V20")
    {
        if(ECL_ValueSelected("A_ZKK_BW_V20", "T"))
        {
            ECL_SelectValue("A_ZKK_BM_V20", "T") 
        }
        else
        {
            ECL_DeselectValue("A_ZKK_BM_V20", "T") 
        }
    }
    else if(ca=="A_ZKK_BM_V20")
    {
        if(ECL_ValueSelected("A_ZKK_BM_V20", "T"))
        {
            ECL_SelectValue("A_ZKK_BW_V20", "T") 
        }
        else
        {
            ECL_DeselectValue("A_ZKK_BW_V20", "T") 
        }
    }
    
    // Bei einer neuen MLFB-Analyse darf die Primär-MLFB aber nur geändert werden,
    // wenn sie einen Punkt enthält
    if (((ca === "ECSI_MLFB") && isValidChar(s_mlfb, ".", 13)) 
        || (ca === "A_NETZFILTER_INT_V20"))
    {
        if(nf_int == "V_KAT_C2_V20")
            s_mlfb = replaceChar(s_mlfb, "A", 13);
        else if(nf_int == "V_KAT_C1_V20")
            s_mlfb = replaceChar(s_mlfb, "B", 13);
        else if(nf_int == "V_KAT_C3_V20")
            s_mlfb = replaceChar(s_mlfb, "C", 13);
        else if(nf_int == "V_KAT_NONE_V20")
            s_mlfb = replaceChar(s_mlfb, "U", 13);
        else
            s_mlfb = replaceChar(s_mlfb, ".", 13);
    }

    if(ca === "ECSI_MLFB" || ca === "A_CU_BOP_V20")
    {
        //if(bop == "V_CU_BOP_J_V20") {
        if(bop == "T") {
            
            //ECL_SelectValue("A_CU_BOPI_V20","V_CU_BOPI_J_V20");
            //ECL_DisableAttribute("A_CU_BOPI_V20");
            
            //Checkbox
            ECL_SelectValue("A_CU_BOPI_V20", "T") 
            ECL_DisableAttribute("A_CU_BOPI_V20");
            
        }
        else {
            ECL_EnableAttribute("A_CU_BOPI_V20");
        }
    }

    return s_mlfb;
}

/**
    Anpassungen Dialog abh. von MLFB
    geänderte MLFB zurückliefern
*/
function dlgSettings(mlfb)
{
    // Combowert selektieren
    if(isValidChar(mlfb, "A", 13))
        ECL_SelectValue("A_NETZFILTER_INT_V20", "V_KAT_C2_V20");
    else if(isValidChar(mlfb, "B", 13))
        ECL_SelectValue("A_NETZFILTER_INT_V20", "V_KAT_C1_V20");
    else if(isValidChar(mlfb, "C", 13))
        ECL_SelectValue("A_NETZFILTER_INT_V20", "V_KAT_C3_V20");
    else if(isValidChar(mlfb, "U", 13))
        ECL_SelectValue("A_NETZFILTER_INT_V20", "V_KAT_NONE_V20");
    else
    {
        ECL_SelectValue("A_NETZFILTER_INT_V20", "V_KAT_NONE_V20");
        mlfb = replaceChar(mlfb, "U", 13);
    }
        
    return mlfb;
}

/**
    zulässige Werte bei MLFB Positionen prüfen
      - abh. von festgelegtem integriertem Netzfilter A, B oder C
      - zulässige Eingabe an best. Positionen ( ohne Abhängigkeit von anderen Positionen ! )
        - wenn Netzfilter = . dann auf passenden Wert setzen
*/
function isMlfbPosValid(mlfb)
{
    var bRet = false;
    var sReg;

    // wenn A dann muss die MLFB so lauten
    if(isValidChar(mlfb, "A", 13))
    {
        sReg = EK_regPrep("6SL32105BB{222;230}??0");
        bRet = EK_regFound(mlfb, sReg);
        if(bRet)
        {
            mlfb = replaceChar(mlfb, "A", 13);
            ECL_SetUserVariable("MLFB", mlfb);
        }
    }
    // wenn B dann ...
    if(! bRet && isValidChar(mlfb, "B", 13))
    {
        sReg = EK_regPrep("6SL32105BB{112;125;137;155;175;211;215;222;230}??1");
        bRet = EK_regFound(mlfb, sReg);
        if(bRet)
        {
            mlfb = replaceChar(mlfb, "B", 13);
            ECL_SetUserVariable("MLFB", mlfb);
        }
    }
    // wenn C dann ...
    if(! bRet && isValidChar(mlfb, "C", 13))
    {
        sReg = EK_regPrep("{6SL32105BE;6SL32165BE}??????");
        bRet = EK_regFound(mlfb, sReg);
        if(bRet)
        {
            mlfb = replaceChar(mlfb, "C", 13);
            ECL_SetUserVariable("MLFB", mlfb);
        }
    }
    // wenn U dann ...
    if(! bRet && isValidChar(mlfb, "U", 13))
    {
        // Change wegen 6SL32165BE175.V0
        // sReg = EK_regPrep("6SL32105B???????");
        bRet = true; // EK_regFound(mlfb, sReg);
        if(bRet)
        {
            mlfb = replaceChar(mlfb, "U", 13);
            ECL_SetUserVariable("MLFB", mlfb);
        }
    }
    // nicht richtig - setze U
    if(! bRet)
    {
        mlfb = replaceChar(mlfb, "U", 13);
        ECL_SelectValue("A_NETZFILTER_INT_V20", "V_KAT_NONE_V20");
        ECL_SetUserVariable("MLFB", mlfb);
    }

    if(! isValidChar(mlfb, "BE", 9))
        return false;
    if(! isValidChar(mlfb, "0123456789", 10))
        return false;
    if(! isValidChar(mlfb, "0123456789", 11))
        return false;
    if(! isValidChar(mlfb, "0123456789", 12))
        return false;
    if(! isValidChar(mlfb, ".ABCU", 13))
        return false;
    if(! isValidChar(mlfb, ".01", 15))
        return false;

    return bRet;
}


/**
    die Bestimmungen zusätzlicher MLFBs
    2 Möglichkeiten:
    - neue MLFB aus aktueller mit Zusatz
    - andere MLFB
*/
function getAllAccConditions(mlfb)
{
    var i;
    var a_cond = getAccConditions();
    var aZusatz = getAccConditionsMlfb(mlfb);
    for(var i = 0; i < aZusatz.length; i++)
    {
        a_cond.push(aZusatz[i]);
    }
    return a_cond;
}

/**
    die Bestimmungen zusätzlicher MLFBs
    gleichzeitg werden die A/V Einträge (Arrayindex 3) in den Auswahllisten de-/aktiviert,
    wenn die MLFB zu dem RegEx in Array[1] passt
    
    Array mit den Zeilen
    [
        MLFB des zusätzlichen Artikels,
        RegEx einer gültigen MLFB ( ! die Daten aus der Excel_Datei konvertieren ),
        Anzahl der in ECSI_MLFB_SEC einzufügenden MLFBs
        [ "AND"|"OR",
            [ Attribut, Value ]
            , ...
        ]
    ]
*/
function getAccConditions()
{
    return [
        [	"6SL32550VE000UA1",
            "(6SL32105B.|6SL32165B.)......",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_CU_PL_V20","T"] ]
        ],
        [	"6SL30544AG002AA0",
            "(6SL32105B.|6SL32165B.)......",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_CU_SD_V20","V_CU_SD_J_V20"] ]
        ],
        [	"6SL32550VA004BA1",
            "(6SL32105B.|6SL32165B.)......",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_CU_BOP_V20","T"] ]
        ],
        [	"6SL32550VA002AA1",
            "(6SL32105B.|6SL32165B.)......",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_CU_BOPI_V20","T"] ]
        ],
        [	"6SL32550VA005AA0",
            "(6SL32105B.|6SL32165B.)......",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_CU_WM_V20","T"] ]
        ],
        [	"6SL32560VE006AA0",
            "(6SL32105BE|6SL32165BE)......",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_CU_IOEM_V20","T"] ]
        ],
        [ "6SL32012AD208VA0",
            "6SL32105BE(137|155|175|211|215|222|230|240|255)...",
            ["ECSI_CX_ANZ_V20","1"],
            ["AND",
                ["A_ZKK_BM_V20","T"] ]
        ],
        [ "6SL32012AD208VA0",
          "6SL32165BE175...",
          ["ECSI_CX_ANZ_V20","1"],
          ["AND",
              ["A_ZKK_BM_V20","T"] ]
        ],
        [ "6SL32012AD208VA0",
          "6SL32105BB(112|125|137|155|175|211|215|222|230)...",
          ["ECSI_CX_ANZ_V20","1"],
          ["AND",
              ["A_ZKK_BM_V20","T"] ]
        ],
        [	"6SE64004BC050AA0",
            "6SL32105BB(112|125|137|155|175)...",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_ZKK_BW_V20","T"] ]
        ],
        [	"JJY:023151720007",
            "6SL32105BB(211|215)...",
            ["ECSI_CX_ANZ_V20","1"], 	
            ["AND",
                ["A_ZKK_BW_V20","T"] ]
        ],
        [	"JJY:023163720018",
            "6SL32105BB(222|230)...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_ZKK_BW_V20","T"] ]
        ],
        [	"6SL32010BE143AA0",
            "6SL32105BE(137|155|175|211|215)...",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_ZKK_BW_V20","T"] ]
        ],
        [	"6SL32010BE143AA0",
            "6SL32165BE175...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_ZKK_BW_V20","T"] ]
        ],
        [	"6SL32010BE210AA0",
            "6SL32105BE(222|230|240)...",
            ["ECSI_CX_ANZ_V20","1"], 	
            ["AND",
                ["A_ZKK_BW_V20","T"] ]
        ],
        [	"6SL32010BE218AA0",
            "6SL32105BE(255|275)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_ZKK_BW_V20","T"] ]
        ],
        [	"6SL32010BE238AA0",
            "6SL32105BE(311|315)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_ZKK_BW_V20","T"] ]
        ],
        [	"6SE64004BD212DA0",
            "6SL32105BE(318|322)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_ZKK_BW_V20","T"] ]
        ],
        [	"6SE64003CC004AB3",
            "6SL32105BB(112|125)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_EO_ND_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"6SE64003CC010AB3",
            "6SL32105BB(137|155|175)...",
            ["ECSI_CX_ANZ_V20","1"], 	
            ["AND",
                ["A_EO_ND_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"6SE64003CC026BB3",
            "6SL32105BB(211|215|222)...",
            ["ECSI_CX_ANZ_V20","1"], 	
            ["AND",
                ["A_EO_ND_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"6SE64003CC035CB3",
            "6SL32105BB230...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_EO_ND_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"6SL32030CE132AA0",
            "6SL32105BE(137|155|175|211)...",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_EO_ND_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32030CE132AA0",
            "6SL32165BE175...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_EO_ND_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32030CE210AA0",
            "6SL32105BE(215|222|230|240)...",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_EO_ND_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32030CE218AA0",
            "6SL32105BE(255|275)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_EO_ND_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32030CE238AA0",
            "6SL32105BE(311|315)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_EO_ND_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32030CJ245AA0",
            "6SL32105BE318...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_EO_ND_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32030CD253AA0",
            "6SL32105BE322...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_EO_ND_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3RV20111CA10",
            "6SL32105BE137...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3RV20111DA10",
            "6SL32105BE155...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3RV20111EA10",
            "(6SL32105BE|6SL32165BE)175...",
            ["ECSI_CX_ANZ_V20","1"], 		
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3RV20111FA10",
            "6SL32105BE211...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3RV20111HA10",
            "6SL32105BE215...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3RV20111JA10",
            "6SL32105BE222...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3RV20111KA10",
            "6SL32105BE230...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3RV20214AA10",
            "6SL32105BE240...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3RV20214BA10",
            "6SL32105BE255...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3VL11031KM300AA0",
            "6SL32105BE275...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3VL11041KM300AA0",
            "6SL32105BE311...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3VL11051KM300AA0",
            "6SL32105BE315...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3VL11081KM300AA0",
            "6SL32105BE(318|322)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3RV20111DA10",
            "6SL32105BB112...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3RV20111FA10",
            "6SL32105BB125...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3RV20111HA10",
            "6SL32105BB137...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3RV20111JA10",
            "6SL32105BB155...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3RV20111KA10",
            "6SL32105BB175...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3RV20214BA10",
            "6SL32105BB211...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3RV20214CA10",
            "6SL32105BB215...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3RV20214EA10",
            "6SL32105BB222...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3RV10314FA10",
            "6SL32105BB230...",
            ["ECSI_CX_ANZ_V20","1"], 								
            ["AND",
                ["A_EO_LS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"6SL32030BB218VA0",
            "6SL32105BB(112|125|137|155|175)U..",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_NETZFILTER_EXT_V20","V_KAT_EXT_C1_V20"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"6SE64002FL026BB0",
            "6SL32105BB(211|215|222)U..",
            ["ECSI_CX_ANZ_V20","1"], 	
            ["AND",
                ["A_NETZFILTER_EXT_V20","V_KAT_EXT_C2_V20"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"6SL32030BE177BA0",
            "6SL32105BE(137|155|175|211|215|222)U..",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_NETZFILTER_EXT_V20","V_KAT_EXT_C2_V20"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32030BE218BA0",
            "6SL32105BE(230|240|255)U..",
            ["ECSI_CX_ANZ_V20","1"], 	
            ["AND",
                ["A_NETZFILTER_EXT_V20","V_KAT_EXT_C2_V20"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32030BE238BA0",
            "6SL32105BE(275|311|315)U..",
            ["ECSI_CX_ANZ_V20","1"], 	
            ["AND",
                ["A_NETZFILTER_EXT_V20","V_KAT_EXT_C2_V20"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32030BE275BA0",
            "6SL32105BE(318|322)U..",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_NETZFILTER_EXT_V20","V_KAT_EXT_C2_V20"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3NA3803",
            "6SL32105BB(112|125|137|155)...",
            ["ECSI_CX_ANZ_V20","1"], 				
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3NA3805",
            "6SL32105BB175...",
            ["ECSI_CX_ANZ_V20","1"], 											
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3NA3807",
            "6SL32105BB211...",
            ["ECSI_CX_ANZ_V20","1"], 											
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3NA3812",
            "6SL32105BB215...",
            ["ECSI_CX_ANZ_V20","1"], 											
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3NA3814",
            "6SL32105BB222...",
            ["ECSI_CX_ANZ_V20","1"], 											
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3NA3820",
            "6SL32105BB230...",
            ["ECSI_CX_ANZ_V20","1"], 											
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"3NA3801",
            "6SL32105BE(137|155|175|211)...",
            ["ECSI_CX_ANZ_V20","3"], 				
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3NA3801",
            "6SL32165BE175...",
            ["ECSI_CX_ANZ_V20","3"], 											
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3NA3803",
            "6SL32105BE215...",
            ["ECSI_CX_ANZ_V20","3"], 											
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3NA3805",
            "6SL32105BE(222|230)...",
            ["ECSI_CX_ANZ_V20","3"], 								
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3NA3807",
            "6SL32105BE240...",
            ["ECSI_CX_ANZ_V20","3"], 											
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3NA3812",
            "6SL32105BE255...",
            ["ECSI_CX_ANZ_V20","3"], 											
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3NA3822",
            "6SL32105BE(275|311|315)...",
            ["ECSI_CX_ANZ_V20","3"], 						
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"3NA3824",
            "6SL32105BE(318|322)...",
            ["ECSI_CX_ANZ_V20","3"], 								
            ["AND",
                ["A_EO_SS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32020AE161CA0",
            "6SL32105BB(112|125|137|155|175|211)...",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_AO_MD_V20","T"] ]
        ],
        [	"6SL32020AE188CA0",
            "6SL32105BB(215)...",
            ["ECSI_CX_ANZ_V20","1"], 	
            ["AND",
                ["A_AO_MD_V20","T"] ]
        ],
        [	"6SL32020AE218CA0",
            "6SL32105BB(222|230)...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_AO_MD_V20","T"] ]
        ],
        [	"6SL32020AE161CA0",
            "6SL32105BE(137|155|175|211|215)...",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_AO_MD_V20","T"] ]
        ],
        [	"6SL32020AE161CA0",
            "6SL32165BE175...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_AO_MD_V20","T"] ]
        ],
        [	"6SL32020AE188CA0",
            "6SL32105BE(222|230)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_AO_MD_V20","T"] ]
        ],
        [	"6SL32020AE218CA0",
            "6SL32105BE(240|255)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_AO_MD_V20","T"] ]
        ],
        [	"6SL32020AE238CA0",
            "6SL32105BE(275|311|315)...",
            ["ECSI_CX_ANZ_V20","1"], 	
            ["AND",
                ["A_AO_MD_V20","T"] ]
        ],
        [	"6SE64003TC038DD0",
            "6SL32105BE318...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_AO_MD_V20","T"] ]
        ],
        [	"6SE64003TC054DD0",
            "6SL32105BE322...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_AO_MD_V20","T"] ]
        ],
        [	"6SL32661AR000VA0",
            "6SL32105BB(112|125|137|155|175)...",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_ZB_SSS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"6SL32661AC000VA0",
            "6SL32105BB(211|215)..0",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_ZB_SSS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"6SL32661AV000VA0",
            "6SL32105BB(222|230)..1",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_ZB_SSS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"6SL32661AC000VA0",
            "6SL32105BB(222|230)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_ZB_SSS_V20","T"],
                ["ECSI_CX_NP_V20","1"] ]
        ],
        [	"6SL32661AA000VA0",
            "6SL32105BE(137|155|175|211|215|222)...",
            ["ECSI_CX_ANZ_V20","1"], 
            ["AND",
                ["A_ZB_SSS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32661AA000VA0",
            "6SL32165BE175...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_ZB_SSS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32661AB000VA0",
            "6SL32105BE(230|240)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_ZB_SSS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32661AC000VA0",
            "6SL32105BE255...",
            ["ECSI_CX_ANZ_V20","1"], 						
            ["AND",
                ["A_ZB_SSS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32661AD000VA0",
            "6SL32105BE(275|311|315)...",
            ["ECSI_CX_ANZ_V20","1"], 	
            ["AND",
                ["A_ZB_SSS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32661AE000VA0",
            "6SL32105BE(318|322)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_ZB_SSS_V20","T"],
                ["ECSI_CX_NP_V20","3"] ]
        ],
        [	"6SL32661ER000VA0",
            "6SL32105BB(112|125|137|155|175)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_EO_MMK_V20","T"] ]
        ],
        [	"6SL32661EB000VA0",
            "6SL32105BB(211|215)...",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_EO_MMK_V20","T"] ]
        ],
        [	"6SL32661EV000VA0",
            "6SL32105BB(222|230)..1",
            ["ECSI_CX_ANZ_V20","1"], 			
            ["AND",
                ["A_EO_MMK_V20","T"] ]
        ]
    ]
}

/**
    die Bedingungen für Einträge in den Auswahllisten

    Array mit den Zeilen
    [
        RegEx einer gültigen MLFB ( ! die Daten aus der Excel_Datei konvertieren ),
        [ Attribut, Value ]
    ]
*/
function getAttributValueConditions()
{
    return [
        [	"6SL32105BB(222|230)..0",
            ["A_NETZFILTER_INT_V20", "V_KAT_C2_V20"]
        ],
        [	"6SL32105BB(112|125|137|155|175|211|215|222|230)..1",
            ["A_NETZFILTER_INT_V20", "V_KAT_C1_V20"]
        ],
        [	"(6SL32105BE|6SL32165BE)......",
            ["A_NETZFILTER_INT_V20", "V_KAT_C3_V20"]
        ],
        [	"6SL32105B.......",
            ["A_NETZFILTER_INT_V20", "V_KAT_NONE_V20"]
        ],
        [	"(6SL32105B.|6SL32165B.)......",
            ["A_CU_PL_V20", "V_NEIN"]
        ],
        [	"(6SL32105B.|6SL32165B.)......",
            ["A_CU_SD_V20", "V_OHNE"]
        ],
        [	"(6SL32105B.|6SL32165B.)......",
            ["A_CU_BOP_V20", "V_NEIN"]
        ],
        [	"(6SL32105B.|6SL32165B.)......",
            ["A_CU_BOPI_V20", "V_NEIN"]
        ],
        [	"(6SL32105B.|6SL32165B.)......",
            ["A_CU_WM_V20", "V_NEIN"]
        ],
        [	"(6SL32105B.|6SL32165B.)......",
            ["A_CU_IOEM_V20", "V_NEIN"]
        ],
        [	"(6SL32105B.(112|125|137|155|175|211|215|222|230|240|255)...|6SL32165BE175...)",
            ["A_ZKK_BM_V20", "V_NEIN"]
        ],
        [	"(6SL32105B.|6SL32165B.)......",
            ["A_ZKK_BW_V20", "V_NEIN"]
        ],
        [	"(6SL32105BE|6SL32105BB)(112|125|137|155|175|211|215|222|230|240|255|275|311|315|318|322)...",
            ["A_NETZFILTER_EXT_V20", "V_KAT_EXT_NONE_V20"]
        ],
        [	"(6SL32105B.|6SL32165B.)......",
            ["A_EO_SS_V20", "V_NEIN"]
        ],
        [	"(6SL32105B.|6SL32165B.)......",
            ["A_AO_MD_V20", "V_NEIN"]
        ],
        [	"(6SL32105B.|6SL32165B.)......",
            ["A_ZB_SSS_V20", "V_NEIN"]
        ],
        [	"(6SL32105BB)......",
            ["A_EO_MMK_V20", "V_NEIN"]
        ]
    ];
}

/**
    die Bestimmungen von MLFBs, welche die aktuelle MLFB mit einem Zusatz erweitern
*/
function getAccConditionsMlfb(mlfb)
{
    var a_cond = [];
    return a_cond;
}

function manageKeepConfiguration(strMlfb)
{
    var keepConfig = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    
    if(keepConfig === "1")
    {
        var strBaseTypeMlfb = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
        var strNewMlfb = "";
        var sec = ECL_GetValue("ECSI_MLFB_SEC");
        var accessoryMlfbs = ECL_GetValue("ECSI_MLFB_CHECK_SEC");
        for(i = 0; i < strBaseTypeMlfb.length; i++)
        {
            if(strBaseTypeMlfb[i] !== ".")
            {
                var character = strBaseTypeMlfb[i];
                strNewMlfb += character;
            }
            else
            {
                var character = strMlfb[i];
                strNewMlfb += character;
            }
        }
        ECL_SetValue("ECSI_MLFB", strNewMlfb);
        ECL_SetValue("ECSI_MLFB_CHECK_SEC", accessoryMlfbs);
    }
}
