//@legacy
/**
*   Main script for configuration object CFG_SIEMENS_V70
*
*		Date:	2019-09-02
*		User:	Hans Martin Bauer, Plan Software GmbH
*		Mod: 	2019-09-02 mb	
*				 	2019-11-06 mb		Optonen aus Zubehör
*/


// ECL.es is currently not full ecma
//#mode(full-ecma)


//@import "CFG_SIEMENS_V70_DB.js"

//@import "SIZER_simplecfg_utils.js"

//@import "SIZER_general_functions.js"


/*
    V70 system introdcution 2016.pptx
        es wird immer eine komplette MLFB übergeben, da bis auf die Stellen 11-13 alles fix ist
        diese kodieren wohl den Bemessungsstrom

        Vorschubachse
            6SL32105DE124UA0	1.2   FSA
            6SL32105DE135UA0	3.0   FSA
            6SL32105DE160UA0	4.6   FSB
            6SL32105DE178UA0	5.3   FSB
            6SL32105DE210UA0	7.8   FSB
            6SL32105DE214UA0	12.9  FSC
            6SL32105DE218UA0	13.2  FSC
        Spindelachse
            6SL32105DE211UA0	10.5  FSB
            6SL32105DE213UA0	11.0  FSC
            6SL32105DE220UA0	19.6  FSC
            6SL32105DE230UA0	29.8  FSD
            6SL32105DE240UA0	37.6  FSD

    hierdurch ist alles andere feststehen:
        Anwendungsart		Spindel-/Vorschubachse
        Bauform					FSA FSB FSC FSD
        Phasenzahl			immer 3AC
        Netzspannung		immer 400V
        Kommunikation		immer Antriebsbus

    siehe VT_V70_M00004
        PMD_AAC494_001_000_V70
        HMK_ANWENDUNGSART_V70 : 00001 Spindel ; 00002 Vorschubachse
        PMD_ABW171_001_000_V70 : Z0001 FSA ; Z0002 FSB ; Z0003 FSC ; Z0004 FSD

        PMD_AAC494_001_000_V70 ist Index zu den Einträgen in
            VT_V70_M00007				MLFB-Leistungsschalter
            VT_V70_M00008				MLFB Sicherung
            VT_V70_M00012				MLFB-Netzfilter

    // erlaubte MLFBs aus TIA Selection Tool
    Servoantrieb
        6SL32105DE124UA0	6SL32105DE135UA0	6SL32105DE160UA0	6SL32105DE178UA0	6SL32105DE210UA0	6SL32105DE214UA0	6SL32105DE218UA0
        FSA	FSB	FSC
    Spindelantrieb
        6SL32105DE211UA0	6SL32105DE213UA0	6SL32105DE220UA0	6SL32105DE230UA0	6SL32105DE240UA0	
        FSB	FSC	FSD

    Beispiel
        6SL32105DE211UA0		SINAMICS V70 IP20 FSB 3AC 380-480V 3,70kW
        3RV2021-4DA10				SIRIUS Leistungsschalter 18,0...25,0A
        3NA3810							NH-Sicherungseinsatz 25A AC 500V/ DC 250V
        6SL32030BE212VA0		Netzfilter A 12,0A

    DTK Tabellenbeschreibung
        VT_V70_M00004				MLFB Struktur
        VT_V70_M00005				Leistung Min-Max
        VT_V70_M00006				Strom MIn-Max
        VT_V70_M00007				MLFB-Leistungsschalter
        VT_V70_M00008				MLFB Sicherung
        VT_V70_M00012				MLFB-Netzfilter
*/

globalThis.OnChangeConfiguration = function main()
{

    SetAttributesFromMlfb();

    // Suffix bei MSSQL Tabellennamen (evtl. abhängig von Release/Export ?)
    if(!ECL_GetUserVariable("TAB_SUFFIX")){
        ECL_SetUserVariable("TAB_SUFFIX", "_26854");
    }
    // RegEx für eine Mindestanforderung an eine evt. gültige MLFB
    // vesch. Kombinationen sind dennoch falsch
    var s_regMlfb = "6SL32105DE{124;135;160;178;210;214;218;211;213;220;230;240}UA0";

    var ek_status = {
        "s_OK": "OK",
        "s_ERR": "E",
        "s_DEFAULT_CX_SSS": "0",
        "s_PAT": "MLFB_PATTERN_INVALID",
        "s_POS": "MLFB_POS_INVALID",
        "s_LEN": "MLFB_LENGTH_INVALID",
        "s_SER": "MLFB_SERIES_INVALID",
        "s_INC": "MLFB_INCOMPLETE",
        "s_ACC": "MLFB_ACC_INVALID",
        "s_ACC_DIFF": "MLFB_ACC_DIFFERENT"
    }
    
    var currentAttribute = ECL_GetCurrentAttribute();
    var primaryMlfb      = ECL_GetValue("ECSI_MLFB");
    var secondaryMlfbs   = GetMlfbSec();

    // Dummy Aufrufe von SIZER unterdrücken
    if (currentAttribute == ''){
        return;
    }

    // Daten wurden zum Test in das Feld geschrieben
    if(currentAttribute === "ECSI_MLFB_CHECK_SEC"){
        return;
    }

    if ((primaryMlfb === '') && (currentAttribute != "@INIT@")){
        return;
    }
    //primaryMlfb = primaryMlfb.replace("?", ".").toUpperCase();    // die Original einmal MLFB speichern
    var replacedMlfb = primaryMlfb.replace("?",".").toUpperCase();
	primaryMlfb = manageKeepconfig(replacedMlfb)
    
    saveMlfb(primaryMlfb);

    ECL_SetValue("ECSI_MLFB_CHECK_SEC", secondaryMlfbs);	

    ECL_SelectValue("ECSI_STATUS", "OK");
    ECL_ResetAttribute("ECSI_STATUS_MESSAGE");

    if(currentAttribute === "@INIT@")
    {
        ECL_DisableAttribute("ECSI_STATUS");
        ECL_SetUserVariable("ORIGINAL_MLFB", "");
        ECL_DisableAttribute("ECSI_STATUS_MESSAGE");
        SetMlfbSec("");
        ECL_DisableAttribute("ECSI_MLFB_SEC");
         //ECL_SetValue("A_ANWENDUNGSART_V70", "V_AA_VS_V70");
        ECL_DisableAttribute("A_ANWENDUNGSART_V70");
        //ECL_SetValue("A_BAUFORM_V70", "V_BF_FSA_V70");
        ECL_DisableAttribute("A_BAUFORM_V70");

        // Consequences: 
        ECL_DisableAttribute("ECSI_CC_ControlUnit");
        ECL_DisableAttribute("ECSI_CC_BrakeRelays");

        // DEFAULTS
        ECL_SetValue("ECSI_CC_ControlUnit", "");  
        ECL_SetValue("ECSI_CC_BrakeRelays", ""); 		
        
        
        ECL_SetValue("A_ZKK_BW_V70", "V_ZKK_BW_INT_V70");
        ECL_SetValue("A_KOMMUNIKATION_V70", "V_KOMM_AB_V70");
        ECL_DisableAttribute("A_KOMMUNIKATION_V70");
        
        // Als Combobox:
        //ECL_SetValue("A_LS_V70", "V_NEIN");
        //ECL_SetValue("A_SI_V70", "V_NEIN");
        //ECL_SetValue("A_EN_V70", "V_NEIN");
        
        // Als Checkbox:
        ECL_DeselectAttribute("A_LS_V70");
        ECL_DeselectAttribute("A_SI_V70");
        ECL_DeselectAttribute("A_EN_V70");
        
        ECL_SetValue("A_SS_V70","OHNE");
        ECL_DisableAttribute("A_SP_V70");

        return;
    }

    if(currentAttribute === "ECSI_MLFB")	// Übergabe Kontext, Primär und Sekundär-MLFB in einem Schritt
    {
        // MLFB auf Korrektheit prüfen:
        if(primaryMlfb.length != 16)
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("MLFB_LENGTH_INVALID"));
            resetDlg();
            return;
        }

        if(left(primaryMlfb, 10) !== "6SL32105DE")
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("MLFB_SERIES_INVALID"));
            resetDlg();
            return;
        }

        if(primaryMlfb.indexOf(".") == -1 && ! EK_regFound(primaryMlfb, s_regMlfb))
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("MLFB_PATTERN_INVALID"));
            resetDlg();
            return;
        }

        //------------------------------
        // Auswahllisten auswerten - mögliche Werte einschränken / erlauben
        filterValues(primaryMlfb);

        //primaryMlfb = applyDependencies(currentAttribute, primaryMlfb)

        // aus MLFBs Zubehöre - Anpassungen Dialog : Werte und Auswahllisten setzen
        // wird nur bei setzen der Haupt MLFB angestoßen
        //------------------------------
        //evalAccParts(primaryMlfb, secondaryMlfbs);

        // Haupt MLFB - Anpassungen Dialog : Werte und Selektion in Auswahllisten setzen
        primaryMlfb = dlgSettings(primaryMlfb, secondaryMlfbs);

        // Haupt MLFB - Anpassungen Dialog : Werte und Selektion in Auswahllisten setzen
        dlgSettingsFromSecondary(secondaryMlfbs);

    }
    else
    {
        // Auswahllisten auswerten - mögliche Werte einschränken / erlauben
        filterValues(primaryMlfb);

        //primaryMlfb = applyDependencies(currentAttribute, primaryMlfb)
    }

    // Neue Liste der Sekundär-(Zubehör-)MLFB's bestimmen
    //------------------------------------------------------
    var allMlfb = getAcc_Leistungsschalter(primaryMlfb) +
        getAcc_Sicherung(primaryMlfb) +
        getAcc_ExternerNetzfilter(primaryMlfb);
        
    if(ECL_GetValue("A_SS_V70") != "OHNE")
        allMlfb=allMlfb+getAcc_ServiceSchutz(primaryMlfb);

    if(ECL_GetValue("A_SP_V70") == "T")
        allMlfb=allMlfb+getAcc_ShieldPlate();
    
    SetMlfbSec(allMlfb);

    // Kurzangaben an die Primär-MLFB generieren - nicht bei V20
    //------------------------------------------------------
    // var base_mlfb = ECL_GetUserVariable("ORIGINAL_MLFB");	// kann hier benutzt werden weil kein Punkt drin ist
    // primaryMlfb = evalShortDescriptions(primaryMlfb, base_mlfb);

    // Primär-MLFB updaten
    //------------------------------------------------------
    ECL_SetValue("ECSI_MLFB", primaryMlfb);		// die Primär-MLFB wird hier geupdated

    // einzelne MLFB Positionen prüfen
    //------------------------------------------------------
    if(! isMlfbPosValid(primaryMlfb))
    {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("MLFB_POS_INVALID"));
        resetDlg();
        return;
    }

    if(primaryMlfb.indexOf(".") > -1)
    {
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("MLFB_INCOMPLETE"));
        resetDlg();
        return;
    }
    
    // ---------- Consequence erzeugen:
    var strBrakeResistorID = '';
    var aBRIDs = [
        ['6SL32105DE124UA0','V70_1'],
        ['6SL32105DE135UA0','V70_2'],
        ['6SL32105DE160UA0','V70_3'],
        ['6SL32105DE178UA0','V70_4'],
        ['6SL32105DE210UA0','V70_5'],
        ['6SL32105DE214UA0','V70_6'],
        ['6SL32105DE218UA0','V70_7'],
        ['6SL32105DE211UA0','V70_8'],
        ['6SL32105DE213UA0','V70_9'],
        ['6SL32105DE220UA0','V70_10'],
        ['6SL32105DE230UA0','V70_11'],
        ['6SL32105DE240UA0','V70_12']
        ];
    for (var i = 0; i < aBRIDs.length; i++) {
        if (EK_regFound(primaryMlfb, aBRIDs[i][0]))
            strBrakeResistorID = aBRIDs[i][1];		
    }
    ECL_SetValue("ECSI_CC_BrakingResistorID", strBrakeResistorID);	// hier soll die ID für den Bremswiderstand rein
    
    
    
    //Filter
    if(ECL_ValueSelected("A_EN_V70", "T"))
    {
        ECL_SetValue("ECSI_CC_ExternalFilterType", "2");
    }
    else
    {
        ECL_SetValue("ECSI_CC_ExternalFilterType", "0");
    }
    
    ECL_SetValue("ECSI_CC_InputFilterType", "0");
    
}

//------------------------------
//------------------------------

/**
    Anpassungen Dialog abh. von MLFB
    geänderte MLFB zurückliefern
*/
function dlgSettings(mlfb)
{
    ECL_DeselectAttribute("A_BAUFORM_V70");

    // Vorschub
    ECL_SelectValue("A_ANWENDUNGSART_V70", "V_AA_VS_V70");

    if(mlfb=="6SL32105DE124UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSA_V70");
        return mlfb;
    }
    if(mlfb=="6SL32105DE135UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSA_V70");
        return mlfb
    }
    if(mlfb=="6SL32105DE160UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSB_V70");
        return mlfb
    }
    if(mlfb=="6SL32105DE178UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSB_V70");
        return mlfb
    }
    if(mlfb=="6SL32105DE210UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSB_V70");
        return mlfb
    }
    if(mlfb=="6SL32105DE214UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSC_V70");
        return mlfb
    }
    if(mlfb=="6SL32105DE218UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSC_V70");
        return mlfb
    }

    // Spindel
    ECL_SelectValue("A_ANWENDUNGSART_V70", "V_AA_SA_V70");

    if(mlfb=="6SL32105DE211UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSB_V70");
        return mlfb
    }
    if(mlfb=="6SL32105DE213UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSC_V70");
        return mlfb
    }
    if(mlfb=="6SL32105DE220UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSC_V70");
        return mlfb
    }
    if(mlfb=="6SL32105DE230UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSD_V70");
        ECL_EnableAttribute("A_SP_V70");
        return mlfb
    }
    if(mlfb=="6SL32105DE240UA0"){
        ECL_SelectValue("A_BAUFORM_V70", "V_BF_FSD_V70");
        ECL_EnableAttribute("A_SP_V70");
        return mlfb
    }

    ECL_DeselectAttribute("A_ANWENDUNGSART_V70");

    return mlfb;
}

/**
    Anpassungen Dialog abh. von MLFB
    geänderte MLFB zurückliefern
*/
function dlgSettingsFromSecondary(mlfbSec)
{
    //ECL_SetValue("A_LS_V70", "V_NEIN");
    //ECL_SetValue("A_SI_V70", "V_NEIN");
    //ECL_SetValue("A_EN_V70", "V_NEIN");
    
    ECL_DeselectAttribute("A_LS_V70");
    ECL_DeselectAttribute("A_SI_V70");
    ECL_DeselectAttribute("A_EN_V70");
    ECL_SetValue("A_SS_V70","OHNE");

    if(mlfbSec == "")
        return;
    
    if(isAcc_Leistungsschalter(mlfbSec))
        //ECL_SetValue("A_LS_V70", "V_JA");
        ECL_SetValue("A_LS_V70", "T");
    
    if(isAcc_Sicherung(mlfbSec))
        //ECL_SetValue("A_SI_V70", "V_JA");
        ECL_SetValue("A_SI_V70", "T");
    
    if(isAcc_ExternerNetzfilter(mlfbSec))
        //ECL_SetValue("A_EN_V70", "V_JA");
        ECL_SetValue("A_EN_V70", "T");

    if(isAcc_ShieldPlate(mlfbSec))
        ECL_SetValue("A_SP_V70", "T");
    
        
    var strServiceSchutz = GetAcc_ServiceSchutz(mlfbSec)
    ECL_SetValue("A_SS_V70", strServiceSchutz);
}

/**
    zulässige Werte bei MLFB Positionen prüfen
*/
function resetDlg()
{
    ECL_DeselectAttribute("A_BAUFORM_V70");
    ECL_DeselectAttribute("A_ANWENDUNGSART_V70");
    return true;
}

/**
    zulässige Werte bei MLFB Positionen prüfen
*/
function isMlfbValid(mlfb)
{
    return true;
}

/**
    zulässige Werte bei MLFB Positionen prüfen
*/
function isMlfbPosValid(mlfb, value, pos)
{
    // diese MLFB Position darf geändert werden
    if(! isMlfbPosFix())
        return true;
    // keine Änderung erlaubt, aber der neue Wert muss identisch mit aktuellem sein
    if(isValidChar(mlfb, "."+value, pos))
        return true;
    // Fehlerstatus setzen
    ECL_SelectValue("ECSI_STATUS", ek_status.s_ERR);
    ECL_SetValue("ECSI_STATUS_MESSAGE", ek_status.s_POS);
    return false;
}

/**
    die Bestimmungen zusätzlicher MLFBs
    Array mit den Zeilen
    [
        MLFB des zusätzlichen Artikels,
        RegEx einer gültigen MLFB ( ! die Daten aus der Excel_Datei konvertieren ),
        [ "AND"|"OR",
            [ Attribut, Value ]
            , ...
        ]
    ]
    Index
    1,2		1	2	4
    3			1	3	5
    4,6		1	6	0
    5,3		1	7	8
    7,8		2	1	0
    11		2	1	4
    13,2	2	1	8
    10,5	2	1	1
    12,9	2	1	3
    19,6	2	2	0
    29,8	2	3	0
    37,6	2	4	0
*/
function getAccConditions()
{
    return [];
}

/**
    die Bedingungen für Einträge in den Auswahllisten

    Array mit den Zeilen
    [
        RegEx einer gültigen MLFB ( ! die Daten aus der Excel_Datei konvertieren ),
        [ Attribut, Value ]
    ]
*/
function getAttributValueConditions()
{
    return [];
/*
    // Beispiel
    return [
        [	"6SL3210.........",
            ["A_CU_SD_V90", "V_OHNE"]
        ],
        [	"6SL32105F.......",
            ["A_NETZFILTER_EXT_V90", "V_KAT_EXT_NONE_V90"]
        ],
        [	"6SL32105F.......",
            ["A_EO_LS_V90", "V_NEIN"]
        ],
        [	"6SL3210.........",
            ["A_EO_SS_V90", "V_NEIN"]
        ]
    ];
*/
}

function manageKeepconfig(s_mlfb)
{
	var isStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
	var strBaseTypeMLFB=ECL_GetValue("ECSI_MLFB_BASE_TYPE");
	
	if(isStartConfiguration=="1" && s_mlfb!=strBaseTypeMLFB)
	{		
		var aBaseTypeMLFB=strBaseTypeMLFB.split('');
		var as_mlfb=s_mlfb.split('');
		for (var i=0;i<aBaseTypeMLFB.length;i++)
		{
			if(aBaseTypeMLFB[i] != ".")
			{
				as_mlfb[i]=aBaseTypeMLFB[i];
			}
		}
		
		s_mlfb="";
		for (var i=0;i<as_mlfb.length;i++)
			s_mlfb=s_mlfb+as_mlfb[i];

		return s_mlfb;
	}
	else if(isStartConfiguration=="1")
		return strBaseTypeMLFB;
	else
		return s_mlfb;
}
