//@legacy
/**
* 	Script for database functions V70
*
* 	Date: 2019-09-06
* 	User: Hans Martin Bauer, Plan Software GmbH
*		Mod:	2019-11-06 mb		Optonen aus Zubehr
*/

 // include easyKAT Configuration Library
//#mode(full-ecma)



/**
    Tabellennamen mit Suffix
*/
function getTab(tab)
{
    return tab + ECL_GetUserVariable("TAB_SUFFIX");
}

/**
    Tabellennamen mit Suffix
*/
function getTrueFalse(attribute, trueVal)
{
    if (ECL_ValueSelected(attribute, trueVal) )
        return "T";
    return "F";
}

// aus Primr-MLFB Positionen 11-13 den Key ermitteln, der in anderen Tabellen benutzt wird
// VT_V70_M00004
function getKeyValue(primaryMlfb)
{
    var sQuery = "SELECT PMD_AAC494_001_000_V70" +
        " FROM "+getTab("VT_V70_M00004") +
        " WHERE MLFB11_V70 || MLFB12_V70 || MLFB13_V70 = ?;";
    var aParam = [primaryMlfb.substr(10, 3)];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    if (aDbResult && aDbResult.length == 1)
            return aDbResult[0].PMD_AAC494_001_000_V70;

    return "";
}

// aus Sekundr-MLFBs eine Liste fr SQL machen
// mlfb1;mlfb2;mlfb3;mlfb4 --> 'mlfb1','mlfb2','mlfb3','mlfb4'
function getList(secondaryMlfbs)
{
    if(secondaryMlfbs=="")
        return "''";
    return "'"+replace(secondaryMlfbs, ";", "','")+"'";
}

/*
SELECT DISTINCT [PMD_AAC494_001_000_V70]
      ,[HMK_LEIST_SCHALTER_V70]
      ,[MLFB_LEIST_SCHALTER_V70]
  FROM [DTK_V70].[dbo].[VT_V70_M00007_13919]
  order by [HMK_LEIST_SCHALTER_V70], [PMD_AAC494_001_000_V70];

SELECT DISTINCT TOP 1000 [HMK_SICHERUNG_V70]
      ,[MLFB_SICHERUNG_V70]
      ,concat('6SL32105DE',[MLFB11_V70],[MLFB12_V70],[MLFB13_V70],'UA0') as mlfb
  FROM [DTK_V70].[dbo].[VT_V70_M00008_13919]
  join [DTK_V70].[dbo].[VT_V70_M00004_13919] on ([DTK_V70].[dbo].[VT_V70_M00004_13919].[PMD_AAC494_001_000_V70]=[DTK_V70].[dbo].[VT_V70_M00008_13919].[PMD_AAC494_001_000_V70])
  order by [MLFB_SICHERUNG_V70], [HMK_SICHERUNG_V70], mlfb;

SELECT TOP 1000 [PMD_AAC494_001_000_V70]
      ,[HMK_NETZFILTER_V70]
      ,[MLFB_NETZFILTER_V70]
  FROM [DTK_V70].[dbo].[VT_V70_M00009_13919]
  order by [HMK_NETZFILTER_V70], [PMD_AAC494_001_000_V70]
*/

// Leistungsschalter aus Primr-MLFB ermitteln
// VT_V70_M00007
function getAcc_Leistungsschalter(primaryMlfb)
{
    var sLS = getTrueFalse("A_LS_V70", "T");
    var sQuery = "SELECT MLFB_LEIST_SCHALTER_V70" +
        " FROM "+getTab("VT_V70_M00007") +
        " WHERE HMK_LEIST_SCHALTER_V70 = 'T' AND PMD_AAC494_001_000_V70 = ? AND HMK_LEIST_SCHALTER_V70 = ?;";
    var aParam = [getKeyValue(primaryMlfb), sLS];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    var sMlfb = "";
    for (var i = 0; i < aDbResult.length; i++)
    {
            sMlfb += aDbResult[i].MLFB_LEIST_SCHALTER_V70+";";
    }
    return sMlfb;
}

// Sicherung aus Primr-MLFB ermitteln
// VT_V70_M00008
function getAcc_Sicherung(primaryMlfb)
{
    var sLS = getTrueFalse("A_SI_V70", "T");
    var sQuery = "SELECT MLFB_SICHERUNG_V70" +
        " FROM "+getTab("VT_V70_M00008") +
        " WHERE HMK_SICHERUNG_V70 = 'T' AND PMD_AAC494_001_000_V70 = ? AND HMK_SICHERUNG_V70 = ?;";
    var aParam = [getKeyValue(primaryMlfb), sLS];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    var sMlfb = "";
    for (var i = 0; i < aDbResult.length; i++)
    {
        // Da der V70 immer im dreiphasigen Netz betrieben wird, werden immer 3 Sicherungen bentigt:
        var mlfbFuse = aDbResult[i].MLFB_SICHERUNG_V70;
        sMlfb += mlfbFuse+";"+mlfbFuse+";"+mlfbFuse+";";
    }
    return sMlfb;
}

// Externer Netzfilter aus Primr-MLFB ermitteln
// VT_V70_M00012
function getAcc_ExternerNetzfilter(primaryMlfb)
{
    var sLS = getTrueFalse("A_EN_V70", "T");
    var sQuery = "SELECT MLFB_NETZFILTER_V70" +
        " FROM "+getTab("VT_V70_M00012") +
        " WHERE HMK_NETZFILTER_V70 = 'T' AND PMD_AAC494_001_000_V70 = ? AND HMK_NETZFILTER_V70 = ?;";
    var aParam = [getKeyValue(primaryMlfb), sLS];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    var sMlfb = "";
    for (var i = 0; i < aDbResult.length; i++)
    {
            sMlfb += aDbResult[i].MLFB_NETZFILTER_V70+";";
    }
    return sMlfb;
}

// Service Schutz aus Primr-MLFB ermitteln
// VT_V70_M00014
function getAcc_ServiceSchutz(primaryMlfb)
{
    var sLS =ECL_GetValue("A_SS_V70");
    var strMLFB = primaryMlfb.substr(10, 3);
    var sQuery = "SELECT HMK_MLFB_DSEE_V70" +
        " FROM "+getTab("VT_V70_M00014") +
        " WHERE HMK_DSEE_V70 = '"+sLS+"' AND MLFB11_V70 || MLFB12_V70 || MLFB13_V70 = '"+strMLFB+"';";
    
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery);

    var sMlfb = "";
    if(aDbResult.length > 0)
    {
        sMlfb += aDbResult[0].HMK_MLFB_DSEE_V70+";";
    }
    return sMlfb;
}
//============================================================//

// Service Schutz aus Primr-MLFB ermitteln
// VT_V70_M00010
function getAcc_ShieldPlate()
{
    var frameSizeText = ECL_GetValue("A_BAUFORM_V70").split("_")[2];

    var frameSize;
    
    switch(frameSizeText) {
        case("FSA"):
            frameSize = "Z0001"
            break;
        case("FSB"):
            frameSize = "Z0002"    
            break;
        case("FSC"):
            frameSize = "Z0003"
            break;
        case("FSD"):
            frameSize = "Z0004"    
            break;
    }

    shiel_plate = ECL_GetValue("A_SP_V70");
    var sQuery = "SELECT MLFB_SCHIRMBLECH_V70" +
        " FROM "+getTab("VT_V70_M00013") +
        " WHERE PMD_ABW171_001_000_V70 = '"+frameSize+"' AND HMK_SCHIRMBLECH_V70 = '"+shiel_plate+"';";
    
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery);
    
    var sMlfb = "";
    if(aDbResult.length > 0)
    {
        sMlfb += aDbResult[0].MLFB_SCHIRMBLECH_V70+";";
    }
    return sMlfb;
}
//============================================================//

// Leistungsschalter wurde als Option gewhlt
// VT_V70_M00007
function isAcc_Leistungsschalter(secondaryMlfbs)
{
    var sQuery = "SELECT HMK_LEIST_SCHALTER_V70" +
        " FROM "+getTab("VT_V70_M00007") +
        " WHERE HMK_LEIST_SCHALTER_V70 = 'T'" +
        " AND MLFB_LEIST_SCHALTER_V70 in ("+getList(secondaryMlfbs)+");";
    var aParam = [getList(secondaryMlfbs)];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    return aDbResult.length > 0;
}

// Sicherung wurde als Option gewhlt
// VT_V70_M00008
function isAcc_Sicherung(secondaryMlfbs)
{
    var sQuery = "SELECT HMK_SICHERUNG_V70" +
        " FROM "+getTab("VT_V70_M00008") +
        " WHERE HMK_SICHERUNG_V70 = 'T'" +
        " AND MLFB_SICHERUNG_V70 in ("+getList(secondaryMlfbs)+");";
    var aParam = [getList(secondaryMlfbs)];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    return aDbResult.length > 0;
}

// Externer Netzfilter wurde als Option gewhlt
// VT_V70_M00012
function isAcc_ExternerNetzfilter(secondaryMlfbs)
{
    var sQuery = "SELECT HMK_NETZFILTER_V70" +
        " FROM "+getTab("VT_V70_M00012") +
        " WHERE HMK_NETZFILTER_V70 = 'T'" +
        " AND MLFB_NETZFILTER_V70 in ("+getList(secondaryMlfbs)+");";
    var aParam = [getList(secondaryMlfbs)];
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);

    return aDbResult.length > 0;
}

// Service Schutz wurde als Option gewhlt
// VT_V70_M00014
function GetAcc_ServiceSchutz(secondaryMlfbs)
{
    var sQuery = "SELECT HMK_DSEE_V70" +
        " FROM "+getTab("VT_V70_M00014") +
        " WHERE HMK_DSEE_V70 in ('DSEE3','DSEE5') " +
        " AND HMK_MLFB_DSEE_V70 in ("+getList(secondaryMlfbs)+");";
    var aParam = [getList(secondaryMlfbs)];
    
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    if(aDbResult.length > 0)
        return aDbResult[0].HMK_DSEE_V70;
    else
        return "OHNE";
}

function isAcc_ShieldPlate(secondaryMlfbs)
{
    var sQuery = "SELECT HMK_SCHIRMBLECH_V70" +
        " FROM "+getTab("VT_V70_M00013") +
        " WHERE HMK_SCHIRMBLECH_V70 = 'T' AND MLFB_SCHIRMBLECH_V70 in (" + getList(secondaryMlfbs) + ");";
    var aParam = [getList(secondaryMlfbs)];
    
    var aDbResult = Object.fromDatabase("EXTERNAL_DATA", sQuery, aParam);
    
    return aDbResult.length > 0;
}