//@legacy
/**
*		Script for configuration object CFG_SIEMENS_V90
*
*		Achtung! 		MLFB darf nicht auf den ersten 9 Stellen geändert werden
*					 !		bisher nur AND bei Bedingungen umgesetzt
*
*		Date:	2019-02-22
*		User:	Hans Martin Bauer, Plan Software GmbH
*		Mod: 	2019-02-25 mb	Namenskonventionen umgesetzt Suffix _V90
*												in der MLFB "." statt "?" setzen
*												"feste" Werte
*		Mod:	2019-02-26 mb	Analyse Zubehör bei Fortsetzung der Konfiguration
*													Übergabe in ECSI_MLFB_CHECK_SEC
*												MLFB wird nur in Großbuchstaben gewandelt, ansonsten muss sie korrekt sein (Länge!)
*		Mod:	2019-02-27 mb	Namenskonventionen korrigiert
*		Mod:	2019-02-28 mb	ECSI_CX_StandardSupplySystem liefert den kodierten Wert der Phasen -> ECSI_CX_NP_V90
*												ECSI_CX_NP_V90 nicht ändern bei Validierung
*												ECSI_CX_ANZ_V90 -> Anzahl des jeweiligen Zubehörteils, MLFB wird entsprechend oft in ECSI_MLFB_SEC aufgenommen
*		Mod:	2019-03-01 mb	Mindestanforderung an eine evt. gültige MLFB
*		Mod:	2019-04-02 mb	nur Comboboxen; Defaults gesetzt
*/

 // include easyKAT Configuration Library
//@import "SIZER_simplecfg_utils.js"

//@import "SIZER_general_functions.js"


//#mode(full-ecma)


var versionSuffix = "_" + "26345"; // 23980

// context variables
var ECSI_CX_StandardSupplySystem	= "ECSI_CX_StandardSupplySystem";
var ECSI_CX_ConverterRatedCurrent 	= "ECSI_CX_ConverterRatedCurrent";
var ECSI_CX_CustomBrakingResistor 	= "ECSI_CX_CustomBrakingResistor";
var ECSI_CX_FieldbusInterface		= "ECSI_CX_FieldbusInterface";

// config variables
var HMK_PHASEN_V90 			= "HMK_PHASEN_V90";
var HMK_SPANNUNG_V90 		= "HMK_SPANNUNG_V90";
var RATED_CURRENT 			= "PMD_AAC494_001_000_V90";
var FRAME_SIZE				= "PMD_ABW171_001_000_V90";
var FUSE					= "A_EO_SS_V90";
var CIRCUIT_BREAKER 		= "A_EO_LS_V90";
var ECSI_STATUS 			= "ECSI_STATUS";
var ECSI_STATUS_MESSAGE 	= "ECSI_STATUS_MESSAGE";
var HMK_KOMMUNIKATION_V90 	= "HMK_KOMMUNIKATION_V90";
var A_NETZFILTER_EXT_V90	= "A_NETZFILTER_EXT_V90";
var HMK_SPEICHERKARTE_V90	= "HMK_SPEICHERKARTE_V90";
var HMK_POINT_CABLE_V90		= "HMK_POINT_CABLE_V90";
var HMK_POINT_CABLE_2_V90	= "HMK_POINT_CABLE_2_V90";
var HMK_IO_CONNECTOR_V90 	= "HMK_IO_CONNECTOR_V90";
var HMK_IO_CABLE_V90		= "HMK_IO_CABLE_V90";
var HMK_RJ45_CONNECTOR_V90	= "HMK_RJ45_CONNECTOR_V90";
var HMK_RJ45_CABLE_V90		= "HMK_RJ45_CABLE_V90";
var HMK_BUS_CABLE_V90 		= "HMK_BUS_CABLE_V90";
var HMK_DSEE_V90			= "HMK_DSEE_V90";
var FRAME_SIZE				= "PMD_ABW171_001_000_V90";
var BRAKING_RESISTOR 		= "A_ZKK_BW_V90";
var ECSI_MLFB				= "ECSI_MLFB";

//
var MEMORYCARD_MLFB 		= "6SL30544AG002AA0";
var MLFB10_V90				= "MLFB10_V90";
var MLFB12_V90 				= "MLFB12_V90";
var MLFB13_V90 				= "MLFB13_V90";
var MLFB15_V90 				= "MLFB15_V90";
var HMK_VALUE_VALID_V90		= "HMK_VALUE_VALID_V90";
var ERRORS					= [];
var WARNINGS				= [];


globalThis.OnChangeConfiguration = function main() {
    /*
        // erlaubte MLFBs aus Katalog D33 Mai 2018
        Impulsfolge-Version:	6SL3210-5F... B10-1UA1 B10-2UA1 B10-4UA1 B10-8UA0 B11-0UA1 B11-5UA0 B12-0UA0
        PROFINET-Version:			6SL3210-5F... B10-1UF1 B10-2UF1 B10-4UF1 B10-8UF0 B11-0UF1 B11-5UF0 B12-0UF0

        Impulsfolge-Version:	6SL3210-5F... E10-4UA0 E10-8UA0 E11-0UA0 E11-5UA0 E12-0UA0 E13-5UA0 E15-0UA0 E17-0UA0
        PROFINET-Version:			6SL3210-5F... E10-4UF0 E10-8UF0 E11-0UF0 E11-5UF0 E12-0UF0 E13-5UF0 E15-0UF0 E17-0UF0

        // Basis MLFBs aus TIA Selection Tool

        Positionen 1 - 16
        6SL32105F.1..UA0
        6SL32105F.1..UA1
        6SL32105F.1..UF0
        6SL32105F.1..UF1
        6SL32105FB101UF2
        6SL32105FB101UA2
    */
    
    var USE_OLD_CONFIG = false;
    var ca = ECL_GetCurrentAttribute();
    var v = ECL_GetValue(ca);


    SetAttributesFromMlfb();
    
    var mlfb = ECL_GetValue("ECSI_MLFB");
    var replacedMlfb = mlfb.replace("?",".").toUpperCase();
	mlfb = manageKeepconfig(replacedMlfb)
    
    if(ca === "@INIT@")
    {
        setDefaultValues();
        SetMlfbSec("");
    }
    
    else if(ca === "ECSI_MLFB")
    {
        setAttributesFromContext();
        determineFrameSize(mlfb);
        parseMlfb(mlfb); 
        var secondaryMlfbs = GetMlfbSec();
        setAttributesFromSecondaryMlfbs(secondaryMlfbs);
        // MLFB auf Korrektheit prüfen:
        if(mlfb.length != 16)
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            ERRORS.push( ECL_Translate("MLFB_LENGTH_INVALID"));
            //ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("MLFB_LENGTH_INVALID"));
            return;
        }

        if(left(mlfb, 9) !== "6SL32105F")
        {
            ECL_SelectValue("ECSI_STATUS", "E");
            ERRORS.push(ECL_Translate("MLFB_SERIES_INVALID"));
            //ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("MLFB_SERIES_INVALID"));
            return;
        }
        
        if(secondaryMlfbs.indexOf("6SL32030BB218VA0") >= 0) // if project is loaded with old filter MLFB
        {
            ECL_ActivateValue("A_NETZFILTER_EXT_V90","V_KAT_EXT_C2_V90_EOF");
            ECL_SelectValue("A_NETZFILTER_EXT_V90","V_KAT_EXT_C2_V90_EOF");
            ECL_SelectValue("ECSI_STATUS", "WARNING");
            WARNINGS.push(ECL_Translate("WARNING__V90_FILTER_MLFB_OUTDATED"));
            //ECL_SetValue("ECSI_STATUS_MESSAGE", ECL_Translate("WARNING__V90_FILTER_MLFB_OUTDATED"));
        }
        else
        {
            ECL_DeactivateValue("A_NETZFILTER_EXT_V90","V_KAT_EXT_C2_V90_EOF");
            ECL_DeselectValue("A_NETZFILTER_EXT_V90","V_KAT_EXT_C2_V90_EOF");
        }
    }
    
    if(ca === "A_NETZFILTER_EXT_V90")
    {
        var filterValue = ECL_GetValue("A_NETZFILTER_EXT_V90");
        if(filterValue !== "V_KAT_EXT_C2_V90_EOF")
        {
            ECL_DeactivateValue("A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90_EOF");
        }
    }
    
    if(ca === HMK_KOMMUNIKATION_V90)
    {
        var communicationValue = ECL_GetValue(HMK_KOMMUNIKATION_V90);
        if(communicationValue === "00003")
        {
            ECL_DeselectValue("HMK_POINT_CABLE_V90", "T");
            ECL_DisableAttribute("HMK_POINT_CABLE_V90");
            
            ECL_DeselectValue("HMK_POINT_CABLE_2_V90", "T");
            ECL_DisableAttribute("HMK_POINT_CABLE_2_V90");
            
            ECL_EnableAttribute("HMK_IO_CABLE_V90");
        }
        else
        {
            ECL_DeselectValue("HMK_IO_CABLE_V90", "T");
            ECL_DisableAttribute("HMK_IO_CABLE_V90");
            
            ECL_EnableAttribute("HMK_POINT_CABLE_V90");
            ECL_EnableAttribute("HMK_POINT_CABLE_2_V90");
        }
    }
    
    if(ca === "HMK_POINT_CABLE_V90")
    {
        var pointCableValue = ECL_GetValue("HMK_POINT_CABLE_V90");
        if(pointCableValue === "T")
        {
            ECL_DeselectValue("HMK_POINT_CABLE_2_V90", "T");
            ECL_DisableAttribute("HMK_POINT_CABLE_2_V90");
        }
        else
        {
            ECL_EnableAttribute("HMK_POINT_CABLE_V90");
            ECL_EnableAttribute("HMK_POINT_CABLE_2_V90");
        }
    }
    
    if(ca === "HMK_POINT_CABLE_2_V90")
    {
        var pointCableValue = ECL_GetValue("HMK_POINT_CABLE_2_V90");
        if(pointCableValue === "T")
        {
            ECL_DeselectValue("HMK_POINT_CABLE_V90", "T");
            ECL_DisableAttribute("HMK_POINT_CABLE_V90");
        }
        else
        {
            ECL_EnableAttribute("HMK_POINT_CABLE_2_V90");
            ECL_EnableAttribute("HMK_POINT_CABLE_V90");
        }
    }
    
    var generatedMlfb = generateMlfb(mlfb);
    ECL_SetValue(ECSI_MLFB, generatedMlfb);
    
    var generatedSecondaryMlfbs = generateSecondaryMlfbs();
    SetMlfbSec(generatedSecondaryMlfbs);
    
    setConsequences(generatedMlfb);
    
    if(ERRORS.length === 0 && WARNINGS.length === 0)
    {
        ECL_SelectValue("ECSI_STATUS", "OK");
        ECL_SetValue("ECSI_STATUS_MESSAGE", "");
    }
    
    else if (ERRORS.length > 0)
    {
        var err = ERRORS.join("; ");
        ECL_SelectValue("ECSI_STATUS", "E");
        ECL_SetValue("ECSI_STATUS_MESSAGE", err);
    }
    
    else if (WARNINGS.length > 0)
    {
        var warn = WARNINGS.join("; ");
        ECL_SelectValue("ECSI_STATUS", "WARNING");
        ECL_SelectValue("ECSI_STATUS_MESSAGE", warn);
    }
}

function setConsequences(mlfb)
{
    // brakeid
    var brakeValue = ECL_GetValue("A_ZKK_BW_V90");
    if(brakeValue === "CUSTOM_BW_V90")
    {
        ECL_SetValue("ECSI_CC_BrakingResistorID", "custom");
        ECL_SetValue("ECSI_CC_CustomBrakingResistor", 1);
        ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", 1);
    }
    else
    {
        ECL_SetValue("ECSI_CC_CustomBrakingResistor", 0);
        ECL_SetValue("ECSI_CC_SelectedCustomBrakingResistor", 0);
        var strBrakeResistorID = '';
        var aBRIDs = [
            ['6SL32105FB102U.2','V90_1'],
            ['6SL32105FB104U.1','V90_2'],
            ['6SL32105FB108U.0','V90_3'],
            ['6SL32105FB110U.1','V90_4'],
            ['6SL32105FB115U.0','V90_5'],
            ['6SL32105FB120U.0','V90_6'],
            ['6SL32105FE104U.0','V90_7'],
            ['6SL32105FE108U.0','V90_8'],
            ['6SL32105FE110U.0','V90_9'],
            ['6SL32105FE115U.0','V90_10'],
            ['6SL32105FE120U.0','V90_11'],
            ['6SL32105FE135U.0','V90_12'],
            ['6SL32105FE150U.0','V90_13'],
            ['6SL32105FE170U.0','V90_14']
            ];
        for (var i = 0; i < aBRIDs.length; i++) 
        {
            if (EK_regFound(mlfb, aBRIDs[i][0]))
            {
                strBrakeResistorID = aBRIDs[i][1];		
            }
        }
        ECL_SetValue("ECSI_CC_BrakingResistorID", strBrakeResistorID);
    }

    // CU
    ECL_SetValue("ECSI_CC_ControlUnit", "");
    
    // BrakeRelay
    ECL_SetValue("ECSI_CC_BrakeRelays","");
}

function setAttributesFromSecondaryMlfbs(secondaryMlfbs)
{
    // Service Protect
    var serviceProtectSelection = selectedServiceProtect(secondaryMlfbs);
    if(serviceProtectSelection)
    {
        ECL_SelectValue(HMK_DSEE_V90, serviceProtectSelection);
    }
    
    // Memory Card
    var memoryCardSelection = selectedMemoryCard(secondaryMlfbs);
    if(memoryCardSelection && ECL_GetValue(ECSI_CX_StandardSupplySystem) !== "0" && ECL_GetValue(ECSI_CX_StandardSupplySystem) !== "7")
    {
        ECL_SelectValue(HMK_SPEICHERKARTE_V90, memoryCardSelection);
    } else {
        secondaryMlfbs = secondaryMlfbs.replace(`${MEMORYCARD_MLFB};`, "");
    }
    
    // Circuit breaker
    var circuitBreakerSelection = selectedCircuitBreaker(secondaryMlfbs);
    if(circuitBreakerSelection)
    {
        ECL_SelectValue(CIRCUIT_BREAKER, circuitBreakerSelection);
    }
    
    // Fuse
    var fuseSelection = selectedFuse(secondaryMlfbs);
    if(fuseSelection)
    {
        ECL_SelectValue(FUSE, fuseSelection);
    }
    
    // I/O Cable 20-pole (PROFINET)
    var ioCable = selectedIoCable(secondaryMlfbs);
    if(ioCable)
    {
        ECL_SelectValue("HMK_IO_CABLE_V90","T");
    }
    
    // setpoint cables (Modbus | USS)
    var setpointCable = selectedSetpointCable(secondaryMlfbs);
    if(setpointCable)
    {
        ECL_SelectValue(setpointCable[0],setpointCable[1]);
    }
    
    // Filter
    var filter = selectedFilter(secondaryMlfbs);
    if(filter)
    {
        if(filter === "V_KAT_EXT_C2_V90_EOF")
        {
            ECL_EnableValue("A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90_EOF");
            ECL_SelectValue("A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90_EOF");
        }
        
        else if(filter === "V_KAT_EXT_C2_V90")
        {
            ECL_DisableValue("A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90_EOF");
            ECL_SelectValue("A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90");
        }
    }

    //Attribute mit viewlevel 0 deactivieren
    ECL_DeactivateAttribute("A_CU_SD_V90");
    ECL_DeactivateAttribute("A_CU_FS_V90");
    ECL_DeactivateAttribute(HMK_PHASEN_V90);
    ECL_DeactivateAttribute(HMK_SPANNUNG_V90);
    ECL_DeactivateAttribute("PMD_ABW171_001_000_V90");

}

function selectedFilter(secondaryMlfbs)
{
    // Old filter 	6SL32030BB218VA0
    // New filter	6SL32030BB218VA1
    
    /*
	and other filters:
		6SL32030BE150VA0
		6SL32030BE212VA0
		6SL32030BE220VA0
	*/
    var oldFilter = "6SL32030BB218VA0";
    var newFilter = "6SL32030BB218VA1"; 
    
    var pos = find(secondaryMlfbs, newFilter);
    if(pos !== -1)
    {
        return "V_KAT_EXT_C2_V90";
    }
    
    pos = find(secondaryMlfbs, oldFilter);
    if(pos !== -1)
    {
        return "V_KAT_EXT_C2_V90_EOF";
    }
    
    pos = find(secondaryMlfbs, "6SL32030BE150VA0");
	if(pos !== -1)
	{
		return "V_KAT_EXT_C2_V90";
	}
	
	pos = find(secondaryMlfbs, "6SL32030BE212VA0");
	if(pos !== -1)
	{
		return "V_KAT_EXT_C2_V90";
	}
	
	pos = find(secondaryMlfbs, "6SL32030BE220VA0");
	if(pos !== -1)
	{
		return "V_KAT_EXT_C2_V90";
	}
    return null;
}

function selectedSetpointCable(secondaryMlfbs)
{
    // HMK_POINT_CABLE_V90	6SL3260-4NA00-1VB0	(1m)
    // HMK_POINT_CABLE_2_V90	6SL3260-4NA00-1VA5 (0,5m)
    var setpointCableMlfb_1_m =  "6SL32604NA001VB0";
    
    var pos = find(secondaryMlfbs, setpointCableMlfb_1_m);
    if(pos !== -1)
    {
        return ["HMK_POINT_CABLE_V90", "T"];
    }
    
    var setpointCableMlfb_05_m = "6SL32604NA001VA5";
    pos = find(secondaryMlfbs, setpointCableMlfb_05_m);
    if(pos !== -1)
    {
        return ["HMK_POINT_CABLE_2_V90","T"];
    }
    return null;
}

function selectedIoCable(secondaryMlfbs)
{
    var ioCableMlfb =  "6SL32604MA001VB0";
    var pos = find(secondaryMlfbs, ioCableMlfb);
    if(pos !== -1)
    {
        return "T";
    }
    return null;
}

function selectedFuse(secondaryMlfbs)
{
    var dbContents = getDbResults("EXTERNAL_DATA", "VT_V90_M00024", "HMK_MLFB_SICHERUNG_V90", null);
    for(var i=0; i < dbContents.length; i++)
    {	
        var pos = find(secondaryMlfbs, dbContents[i]["HMK_MLFB_SICHERUNG_V90"]);
        if(pos !== -1)
        {
            return "T";
        }
    }
    return null;
}

function selectedCircuitBreaker(secondaryMlfbs)
{
    var dbContents = getDbResults("EXTERNAL_DATA", "VT_V90_M00023", "HMK_MLFB_CIRCUIT_BR_V90", null);
    for(var i=0; i < dbContents.length; i++)
    {	
        var pos = find(secondaryMlfbs, dbContents[i]["HMK_MLFB_CIRCUIT_BR_V90"]);
        if(pos !== -1)
        {
            return "T";
        }
    }
    return null;
}

function selectedMemoryCard(secondaryMlfbs)
{
    var pos = find(secondaryMlfbs, MEMORYCARD_MLFB);
    if(pos !== -1)
    {
        return "T"
    }
    return null
}

function selectedServiceProtect(secondaryMlfbs)
{
    var dbContents = getDbResults("EXTERNAL_DATA", "VT_V90_M00040", "HMK_MLFB_DSEE_V90, HMK_DSEE_V90", null);
    for(var i=0; i < dbContents.length; i++)
    {	
        var pos = find(secondaryMlfbs, dbContents[i]["HMK_MLFB_DSEE_V90"]);
        if(pos !== -1)
        {
            return dbContents[i][HMK_DSEE_V90];
        }
    }
    return null;
}

function parseMlfb(mlfb)
{
    var mlfb_15 = mlfb[14];
    var conditions = [
        [MLFB15_V90, mlfb_15]
    ];
    var results = getDbResults("EXTERNAL_DATA", "VT_V90_M00031", HMK_KOMMUNIKATION_V90, conditions);
    if(results.length > 0)
    {
        ECL_SelectValue(HMK_KOMMUNIKATION_V90, results[0][HMK_KOMMUNIKATION_V90]);

        var communicationValue = ECL_GetValue(HMK_KOMMUNIKATION_V90);
		if(communicationValue === "00003")
		{
			ECL_DeselectValue("HMK_POINT_CABLE_V90", "T");
			ECL_DisableAttribute("HMK_POINT_CABLE_V90");
			
			ECL_DeselectValue("HMK_POINT_CABLE_2_V90", "T");
			ECL_DisableAttribute("HMK_POINT_CABLE_2_V90");
			
			ECL_EnableAttribute("HMK_IO_CABLE_V90");
		}
		else
		{
			ECL_DeselectValue("HMK_IO_CABLE_V90", "T");
			ECL_DisableAttribute("HMK_IO_CABLE_V90");
			
			ECL_EnableAttribute("HMK_POINT_CABLE_V90");
			ECL_EnableAttribute("HMK_POINT_CABLE_2_V90");
		}
		
		var pointCableValue = ECL_GetValue("HMK_POINT_CABLE_V90");
		var pointCable2Value = ECL_GetValue("HMK_POINT_CABLE_2_V90");
		var ioCableValue = ECL_GetValue("HMK_IO_CABLE_V90");
		
		if(pointCableValue === "T")
		{
			ECL_DeselectValue("HMK_IO_CABLE_V90", "T");
			ECL_DisableAttribute("HMK_IO_CABLE_V90");
			ECL_DeselectValue("HMK_POINT_CABLE_2_V90", "T");
			ECL_DisableAttribute("HMK_POINT_CABLE_2_V90");
		}
		if(pointCable2Value === "T")
		{
			ECL_DeselectValue("HMK_IO_CABLE_V90", "T");
			ECL_DisableAttribute("HMK_IO_CABLE_V90");
			ECL_DeselectValue("HMK_POINT_CABLE_V90", "T");
			ECL_DisableAttribute("HMK_POINT_CABLE_V90");
		}
		if(ioCableValue === "T")
		{
			ECL_DeselectValue("HMK_POINT_CABLE_2_V90", "T");
			ECL_DisableAttribute("HMK_POINT_CABLE_2_V90");
			ECL_DeselectValue("HMK_POINT_CABLE_V90", "T");
			ECL_DisableAttribute("HMK_POINT_CABLE_V90");
		}
    }
}

function generateMlfb(mlfb)
{
    for(var i = 0; i < mlfb.length; i++)
    {
        if(i === 14)
        {
            var communication = ECL_GetValue(HMK_KOMMUNIKATION_V90);
            var query = "SELECT MLFB15_V90 FROM VT_V90_M00031" + versionSuffix + " WHERE HMK_KOMMUNIKATION_V90='"+ communication +"';";
            var result = Object.fromDatabase("EXTERNAL_DATA", query);
            
            // only a single result should be available
            if(result.length === 1)
            {
                var mlfb_15 = result[0]["MLFB15_V90"];
                var characters = mlfb.split("");
                characters[i] = mlfb_15
                return characters.join("");
            }	
        }
    }
}

function generateSecondaryMlfbs()
{
    var secondaryMlfbs = [];
    var mlfb = ECL_GetValue(ECSI_MLFB);
    
    var mlfb_10 = mlfb[9];
    var mlfb_12 = mlfb[11];
    var mlfb_13 = mlfb[12];
    var mlfb_15 = mlfb[14];
    
    var voltage = ECL_GetValue(HMK_SPANNUNG_V90);
    var phase = ECL_GetValue(HMK_PHASEN_V90);
    
    var frameSize = ECL_GetValue(FRAME_SIZE);
    
    // Service Protect
    var serviceProtect = ECL_GetValue(HMK_DSEE_V90);
    if(serviceProtect !== "OHNE")
    {
        var serviceProtectConditions = [
            [MLFB10_V90, mlfb_10],
            [MLFB12_V90, mlfb_12],
            [MLFB13_V90, mlfb_13],
            [MLFB15_V90, mlfb_15],
            [HMK_DSEE_V90, serviceProtect],
            [HMK_VALUE_VALID_V90, "T"]
        ];
        var results = getDbResults("EXTERNAL_DATA", "VT_V90_M00040", "HMK_MLFB_DSEE_V90", serviceProtectConditions);
        if(results.length > 0)
        {
            secondaryMlfbs.push(results[0]["HMK_MLFB_DSEE_V90"]);
        }
    }

    // Memory card 6SL30544AG002AA0
    var memoryCard = ECL_GetValue(HMK_SPEICHERKARTE_V90);
    if(memoryCard === "T")
    {
        secondaryMlfbs.push(MEMORYCARD_MLFB);
    }
    
    // Circuit Breaker
    var circuitBreaker = ECL_GetValue(CIRCUIT_BREAKER);
    if(circuitBreaker === "T")
    {
        var circuitBreakerConditions = [
            [HMK_SPANNUNG_V90, voltage],
            [MLFB12_V90, mlfb_12],
            [MLFB13_V90, mlfb_13],
            [HMK_VALUE_VALID_V90, "T"]
        ];
        var results = getDbResults("EXTERNAL_DATA", "VT_V90_M00023", "HMK_MLFB_CIRCUIT_BR_V90", circuitBreakerConditions);
        if(results.length > 0)
        {
            secondaryMlfbs.push(results[0]["HMK_MLFB_CIRCUIT_BR_V90"]);
        }
    }
    
    // Fuse
    var fuse = ECL_GetValue(FUSE);
    if(fuse === "T")
    {
        var fuseConditions = [
            [HMK_SPANNUNG_V90, voltage],
            [MLFB12_V90, mlfb_12],
            [MLFB13_V90, mlfb_13],
            [HMK_VALUE_VALID_V90, "T"]
        ];
        var results = getDbResults("EXTERNAL_DATA", "VT_V90_M00024", "HMK_MLFB_SICHERUNG_V90", fuseConditions);
        if(results.length > 0)
        {
            secondaryMlfbs.push(results[0]["HMK_MLFB_SICHERUNG_V90"]);
        }
    }
    
    // iocable
    var ioCable = ECL_GetValue("HMK_IO_CABLE_V90")
    if(ioCable === "T")
    {
        secondaryMlfbs.push("6SL32604MA001VB0");
    }
    
    // setpoint cables
    var setpoint1m = ECL_GetValue("HMK_POINT_CABLE_V90"); // 1m
    if(setpoint1m === "T")
    {
        secondaryMlfbs.push("6SL32604NA001VB0");
    }
    
    var setpoint05m = ECL_GetValue("HMK_POINT_CABLE_2_V90");
    if(setpoint05m === "T")
    {
        secondaryMlfbs.push("6SL32604NA001VA5");
    }
    
	// filter
	// Old filter 	6SL32030BB218VA0
	// New filter	6SL32030BB218VA1
    var threePhase = ECL_GetUserVariable("THREE_PHASE_V90");
	var filter = ECL_GetValue("A_NETZFILTER_EXT_V90");
	var phase = ECL_GetValue(HMK_PHASEN_V90);
	var voltage = ECL_GetValue("ECSI_CX_LowestSupplyVoltage");
	var framesize = ECL_GetValue(FRAME_SIZE);
	if(filter === "V_KAT_EXT_C2_V90_EOF")
	{
		secondaryMlfbs.push("6SL32030BB218VA0");
	}
	if(filter === "V_KAT_EXT_C2_V90" && phase === "00001" && voltage >= 200 && voltage <= 240 && threePhase != "1")
	{
		secondaryMlfbs.push("6SL32030BB218VA1");
	}
	if(filter === "V_KAT_EXT_C2_V90" && phase === "00001" && voltage >= 200 && voltage <= 240 && threePhase == "1")
	{
		if(frameSize === "Z0001" || frameSize === "Z0002" || frameSize === "Z0003")
		{
			secondaryMlfbs.push("6SL32030BE150VA0");
		}
		if(frameSize === "Z0004")
		{
			secondaryMlfbs.push("6SL32030BE212VA0");
		}
	}
	if(filter === "V_KAT_EXT_C2_V90" && phase === "00002" && voltage >= 380)
	{
		// FSA/FSAA
		if(frameSize === "00005" || frameSize === "Z0001")
		{
			secondaryMlfbs.push("6SL32030BE150VA0");
		}
		// FSB
		else if(frameSize === "Z0002")
		{
			secondaryMlfbs.push("6SL32030BE212VA0");
		}
		// FSC
		else if(frameSize === "Z0003")
		{
			secondaryMlfbs.push("6SL32030BE220VA0");
		}
	}

    if(filter === "V_KAT_EXT_C2_V90" && phase === "00001" && voltage >= 380)
	{
		// FSA/FSAA
		if(frameSize === "00005" || frameSize === "Z0001")
		{
			secondaryMlfbs.push("6SL32030BE150VA0");
		}
		// FSB
		else if(frameSize === "Z0002")
		{
			secondaryMlfbs.push("6SL32030BE212VA0");
		}
		// FSC
		else if(frameSize === "Z0003")
		{
			secondaryMlfbs.push("6SL32030BE220VA0");
		}
	}
	
    return secondaryMlfbs.join(";");
}

function getDbResults(database, table, requestedField, conditions)
{
    var query = "";
    
    if(requestedField === null)
    {
        requestedField = "*";
    }
    if(database === null)
    {
        database = "EXTERNAL_DATA";
    }
    
    var queryBase = "SELECT " + requestedField + " FROM " + table + versionSuffix;
    
    if(conditions)
    {
        var conditionString = " WHERE ";
        for(var i=0; i < conditions.length; i++)
        {
            if(i !== 0)
            {
                conditionString += "AND ";
            }
            
            conditionString += (conditions[i][0] + "='" + conditions[i][1] + "' ");
            
            if(i === conditions.length-1)
            {
                conditionString += ";";
            }
        }
        query = queryBase + conditionString;
    }
    else
    {
        query = queryBase;
    }
    
    var results = Object.fromDatabase(database, query);
    return results;
}

function completeMlfb(mlfb)
{
    // only pos 15(14) is not set in the basetype, but we will check it anyways so
    if(mlfb.indexOf(".") === 14)
    {
        var communication = ECL_GetValue(HMK_KOMMUNIKATION_V90);
        var query = "SELECT MLFB15_V90 FROM VT_V90_M00031" + versionSuffix + " WHERE HMK_KOMMUNIKATION_V90='"+ communication +"';";
        var result = Object.fromDatabase("EXTERNAL_DATA", query);
        
        // only a single result should be available
        if(result.length === 1)
        {
            var mlfb_15 = result[0]["MLFB15_V90"];
            
            var mlfbElements = mlfb.split(".");
            var updatedMlfb = mlfbElements[0] + mlfb_15 + mlfbElements[1];
            return updatedMlfb;
        }	
    }
    else
    {
        return mlfb;
    }
}

function determineFrameSize(mlfb)
{
    var mlfb_12 = mlfb[11];
    var mlfb_13 = mlfb[12];
    var mlfb_15	= mlfb[14];
    var phase = ECL_GetValue(HMK_PHASEN_V90);
    var voltage = ECL_GetValue(HMK_SPANNUNG_V90);
    var query = "SELECT PMD_ABW171_001_000_V90 FROM VT_V90_M00032" + versionSuffix + " WHERE " +
                "MLFB12_V90='"+ mlfb_12 +"' AND " + 
                "MLFB13_V90='"+ mlfb_13 +"' AND " +
                "MLFB15_V90='"+ mlfb_15 +"' AND " +
                "(HMK_PHASEN_V90='00001' OR HMK_PHASEN_V90='00002') AND " + 
                "HMK_SPANNUNG_V90='"+ voltage +"';";
    var result = Object.fromDatabase("EXTERNAL_DATA", query);
    if(result.length > 0)
    {
        ECL_SelectValue(FRAME_SIZE, result[0][FRAME_SIZE]);
    }
}

function setDefaultValues()
{
    // Communication PROFINET
    ECL_SelectValue(HMK_KOMMUNIKATION_V90, "00003");
    
    // Deselect Circuit breaker
    ECL_DeselectValue(CIRCUIT_BREAKER, "T");
    
    // Deselect Fuse
    ECL_DeselectValue(FUSE, "T");
    
    // Without filter
    ECL_SelectValue(A_NETZFILTER_EXT_V90, "V_KAT_EXT_NONE_V90");
    
    // Without memory card
    ECL_DeselectValue(HMK_SPEICHERKARTE_V90, "T");
    
    // Communication PROFINET
    ECL_SelectValue(HMK_KOMMUNIKATION_V90, "00003");
    
    // HMK_POINT_CABLE_V90
    ECL_DeselectValue(HMK_POINT_CABLE_V90, "T");
    
    // HMK_POINT_CABLE_2_V90
    ECL_DeselectValue(HMK_POINT_CABLE_2_V90, "T");
    
    // HMK_IO_CONNECTOR_V90
    ECL_DeselectValue(HMK_IO_CONNECTOR_V90, "T");
    
    // HMK_IO_CABLE_V90
    ECL_DeselectValue(HMK_IO_CABLE_V90, "T");
    
    // HMK_RJ45_CONNECTOR_V90
    ECL_DeselectValue(HMK_RJ45_CONNECTOR_V90, "T");
    
    // HMK_RJ45_CABLE_V90
    ECL_DeselectValue(HMK_RJ45_CABLE_V90, "T");
    
    // HMK_BUS_CABLE_V90
    ECL_DeselectValue(HMK_BUS_CABLE_V90, "T");
    
    // Without service protect
    ECL_SelectValue(HMK_DSEE_V90, "OHNE");
    
    //integrated braking resistor
    ECL_SetValue(BRAKING_RESISTOR, "V_ZKK_BW_INT_V90");
    
    // enable disable
    // // cables
    ECL_DeselectValue("HMK_POINT_CABLE_V90", "T");
    ECL_DisableAttribute("HMK_POINT_CABLE_V90");
    
    ECL_DeselectValue("HMK_POINT_CABLE_2_V90", "T");
    ECL_DisableAttribute("HMK_POINT_CABLE_2_V90");
    
    ECL_EnableAttribute("HMK_IO_CABLE_V90");
    
    // deactivate
    ECL_DeactivateAttribute("HMK_RJ45_CABLE_V90");
    ECL_DeactivateAttribute("HMK_BUS_CABLE_V90");
    ECL_DeactivateAttribute("HMK_RJ45_CONNECTOR_V90");
    ECL_DeactivateAttribute("HMK_IO_CONNECTOR_V90");
}

function setAttributesFromContext()
{
    // Supply voltage and phase
    var supplySystem = ECL_GetValue(ECSI_CX_StandardSupplySystem);
    if(supplySystem == "0")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00001");
		ECL_SetValue(HMK_SPANNUNG_V90, "00001");
        ECL_SetUserVariable("THREE_PHASE_V90", "0");
        ECL_SelectValue(HMK_SPEICHERKARTE_V90, "");
        ECL_DisableAttribute(HMK_SPEICHERKARTE_V90);
	}
	else if(supplySystem == "1")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00001");
		ECL_SetValue(HMK_SPANNUNG_V90, "00001");
        ECL_SetUserVariable("THREE_PHASE_V90", "1");
	}

    else if(supplySystem == "2")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00001");
		ECL_SetValue(HMK_SPANNUNG_V90, "00001");
		ECL_SetUserVariable("THREE_PHASE_V90", "1");
	}

	else if(supplySystem == "3")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00002");
		ECL_SetValue(HMK_SPANNUNG_V90, "00002");
	}

    else if(supplySystem == "4")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00002");
		ECL_SetValue(HMK_SPANNUNG_V90, "00002");
	}
	else if(supplySystem == "7")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00001");
		ECL_SetValue(HMK_SPANNUNG_V90, "00001");
        ECL_SelectValue(HMK_SPEICHERKARTE_V90, "");
        ECL_DisableAttribute(HMK_SPEICHERKARTE_V90);
	}
	else if(supplySystem == "8")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00001");
		ECL_SetValue(HMK_SPANNUNG_V90, "00001");
		ECL_SetUserVariable("THREE_PHASE_V90", "1");
	}
	else if(supplySystem == "9")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00002");
		ECL_SetValue(HMK_SPANNUNG_V90, "00002");
	}
	else if(supplySystem == "10")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00002");
		ECL_SetValue(HMK_SPANNUNG_V90, "00002");
	}
	else if(supplySystem == "11")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00002");
		ECL_SetValue(HMK_SPANNUNG_V90, "00002");
	}
	else if(supplySystem == "12")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00002");
		ECL_SetValue(HMK_SPANNUNG_V90, "00002");
	}
	else if(supplySystem == "13")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00002");
		ECL_SetValue(HMK_SPANNUNG_V90, "00002");
	}
    else if(supplySystem == "18")
	{
		ECL_SetValue(HMK_PHASEN_V90, "00002");
		ECL_SetValue(HMK_SPANNUNG_V90, "00002");
	}
	else if(supplySystem != "")
	{
		ECL_SelectValue(ECSI_STATUS, "E");
		ECL_SetValue(ECSI_STATUS_MESSAGE, ECL_Translate("MSG_ERROR_V90_UNEXPECTED_CONTEXT_STANDARD_SUPPLY_SYSTEM"));
	}

    // Rated current
    var ratedCurrent = ECL_GetValue(ECSI_CX_ConverterRatedCurrent);
    ECL_SetValue(RATED_CURRENT, ratedCurrent);
    
    // Custom braking resistor
    var ratedPower = ECL_GetValue("ECSI_CX_ConverterRatedPower");
    var customBrakingResistor = ECL_GetValue(ECSI_CX_CustomBrakingResistor);
    if(ratedPower === "0.1" || (customBrakingResistor !== "0" && customBrakingResistor !== ""))
    {
        var resistorSelection = "CUSTOM_BW_V90";
    }
    else
    {
        var resistorSelection = "V_ZKK_BW_INT_V90";
    }
    ECL_SelectValue(BRAKING_RESISTOR, resistorSelection);
    if(ratedPower === "0.1")
    {
        ECL_DisableAttribute(BRAKING_RESISTOR);
    }
    
    // Fieldbus interface
    var fieldbusInterface = ECL_GetValue(ECSI_CX_FieldbusInterface);
    switch(fieldbusInterface)
    {
        case "0":
            ECL_SelectValue(HMK_KOMMUNIKATION_V90, "00003");
        break;
        
        case "3":
            ECL_SelectValue(HMK_KOMMUNIKATION_V90, "00001");
        break;
    }
}

/**
    Abhängige Stellen der Primär-MLFB bei einem Ereignis ändern
    Kontext auswerten

    @param ca		das Ereignis
    @param mlfb		die aktuelle MLFB, wird evtl. geändert

    @return geänderte mlfb 
*/

function applyDependencies(ca, mlfb)
{
    // Auswahllisten auswerten und MLFB anpassen
    var cu_fs = ECL_GetValue("A_CU_FS_V90");

    //8.6.19: In der Primär-MLFB wird der Feldbus nicht mehr übergeben.
    //	Wenn dieser nicht zum Kontext passt, müssten wir einen
    //	Fehler ausgeben: ECSI_CX_FieldbusInterface

    if (((ca === "ECSI_MLFB") && (mlfb.indexOf(".") > -1)) || (ca === "A_CU_FS_V90"))
    {
        if(cu_fs == "V_CU_FS_PROFINET_V90")
            mlfb = replaceChar(s_mlfb, "F", 14);
        else if(cu_fs == "V_CU_FS_USS_V90")
            mlfb = replaceChar(s_mlfb, "A", 14);
        else
            mlfb = replaceChar(s_mlfb, ".", 14);
    }

    return mlfb;
}


//	Anpassungen Dialog abh. von MLFB
//	geänderte MLFB zurückliefern

function dlgSettings(mlfb)
{
    // A_CU_FS_V90
    // -mw- 1.6.2019: Der Feldbus ist hier bereits in der Dimensionierung fix, d.h. wir bekommen
    // immer eine vollqualifizierte MLFB, und die dürfen wir nicht ändern ...
    // 8.6.19: In der Primär-MLFB wird der Feldbus nicht mehr übergeben.
    // var bFix = false; 

    // Combowert selektieren
    if(isValidChar(mlfb, "F", 14))
        ECL_SelectValue("A_CU_FS_V90", "V_CU_FS_PROFINET_V90");
    else if(isValidChar(mlfb, "A", 14))
        ECL_SelectValue("A_CU_FS_V90", "V_CU_FS_USS_V90");
    else
    {
        //ECL_DeselectAttribute("A_CU_FS_V90");
        //mlfb = replaceChar(mlfb, ".", 14);
        ECL_SelectValue("A_CU_FS_V90", "V_CU_FS_PROFINET_V90");
        mlfb = replaceChar(s_mlfb, "F", 14);
    }

    /* 
    if (bFix)
        ECL_DisableAttribute("A_CU_FS_V90");
    else
        ECL_EnableAttribute("A_CU_FS_V90");
    */
    return mlfb;
}

/**
    zulässige Werte bei MLFB Positionen prüfen
        - abh. von festgelegtem integriertem Netzfilter A, B oder C
        - zulässige Eingabe an best. Positionen ( ohne Abhängigkeit von anderen Positionen ! )
        - wenn Netzfilter = . (isValidChar() liefert true) dann auf passenden Wert setzen
*/
function isMlfbPosValid(mlfb)
{
    /*
    if(! isValidChar(mlfb, "BE", 9))
        return false;
    if(! isValidChar(mlfb, "01", 15))
        return false;
    */
    return true;
}




/**
    die Bestimmungen zusätzlicher MLFBs
    Array mit den Zeilen
    [
        MLFB des zusätzlichen Artikels,
        RegEx einer gültigen MLFB ( ! die Daten aus der Excel_Datei konvertieren ),
        [ "AND"|"OR",
            [ Attribut, Value ]
            , ...
        ]
    ]
*/
function getAccConditions()
{
    return [
        [ "6SL30544AG002AA0",
            "6SL3210..E......",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",				
                ["A_CU_SD_V90", "V_CU_SD_J_V90"] ]
        ],
        [ "3RV20111EA10",
            "6SL32105FB(101|102)U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "1"] ]
        ],
        [ "3RV20111EA10",
            "6SL32105FB(101|102)U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20111EA10",
            "6SL32105FB104U.1",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20111HA10",
            "6SL32105FB104U.1",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "1"] ]
        ],
        [ "3RV20111HA10",
            "6SL32105FB108U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20111JA10",
            "6SL32105FB110U.1",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20111KA10",
            "6SL32105FB108U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "1"] ]
        ],
        [ "3RV20114AA10",
            "6SL32105FB115U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20114AA10",
            "6SL32105FB120U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20211DA10",
            "6SL32105FE104U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20211EA10",
            "6SL32105FE108U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20211FA10",
            "6SL32105FE110U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20211HA10",
            "6SL32105FE115U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20214AA10",
            "6SL32105FE120U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20214BA10",
            "6SL32105FE135U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20214BA10",
            "6SL32105FE150U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3RV20214DA10",
            "6SL32105FE170U.0",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_LS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "6SL32030BB218VA0",
            "6SL32105FB(101|102|104|108)...",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90_EOF"], ["ECSI_CX_NP_V90", "1"] ]
        ],
        [ "6SL32030BB218VA1",
            "6SL32105FB(101|102|104|108)...",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90"], ["ECSI_CX_NP_V90", "1"] ]
        ],
        [ "6SL32030BE150VA0",
            "6SL32105FB(101|102|104|108)...",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "6SL32030BE150VA0",
            "6SL32105FE(104|108|110)...",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "6SL32030BE212VA0",
            "6SL32105FB(110|115|120)...",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "6SL32030BE212VA0",
            "6SL32105FE(115|120)...",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "6SL32030BE220VA0",
            "6SL32105FE(135|150|170)...",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_NETZFILTER_EXT_V90", "V_KAT_EXT_C2_V90"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3NA3801",
            "6SL32105FB(101|102)U.2",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "1"] ]
        ],
        [ "3NA3801",
            "6SL32105FB(101|102)U.2",
            ["ECSI_CX_ANZ_V90", "3"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3NA38016",
            "6SL32105FE(104|108)U.0",
            ["ECSI_CX_ANZ_V90", "3"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3NA3803",
            "6SL32105FB104U.1",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "1"] ]
        ],
        [ "3NA3803",
            "6SL32105FB104U.1",
            ["ECSI_CX_ANZ_V90", "3"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3NA38036",
            "6SL32105FE(110|115)U.0",
            ["ECSI_CX_ANZ_V90", "3"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3NA3805",
            "6SL32105FB(108|110)U.(0|1)",
            ["ECSI_CX_ANZ_V90", "1"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "1"] ]
        ],
        [ "3NA3805",
            "6SL32105FB(108|110)U.(0|1)",
            ["ECSI_CX_ANZ_V90", "3"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3NA38056",
            "6SL32105FE120U.0",
            ["ECSI_CX_ANZ_V90", "3"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3NA38076",
            "6SL32105FE(135|150)U.0",
            ["ECSI_CX_ANZ_V90", "3"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3NA3810",
            "6SL32105FB(115|120)U.0",
            ["ECSI_CX_ANZ_V90", "3"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ],
        [ "3NA38106",
            "6SL32105FE170U.0",
            ["ECSI_CX_ANZ_V90", "3"],
            ["AND",
                ["A_EO_SS_V90", "T"], ["ECSI_CX_NP_V90", "3"] ]
        ]
    ];
}

/**
    die Bedingungen für Einträge in den Auswahllisten

    Array mit den Zeilen
    [
        RegEx einer gültigen MLFB ( ! die Daten aus der Excel_Datei konvertieren ),
        [ Attribut, Value ]
    ]
*/
function getAttributValueConditions()
{
    return [

        [	"6SL3210.........",
            ["A_CU_SD_V90", "V_OHNE"]
        ],
        [	"6SL32105F.......",
            ["A_NETZFILTER_EXT_V90", "V_KAT_EXT_NONE_V90"]
        ],
        [	"(6SL32105F......0|6SL32105F......1)",
            ["A_EO_LS_V90", "V_NEIN"]
        ]
    ];
}

function manageKeepconfig(s_mlfb)
{
	var isStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
	var strBaseTypeMLFB=ECL_GetValue("ECSI_MLFB_BASE_TYPE");
	
	if(isStartConfiguration=="1" && s_mlfb!=strBaseTypeMLFB)
	{		
		var aBaseTypeMLFB=strBaseTypeMLFB.split('');
		var as_mlfb=s_mlfb.split('');
		for (var i=0;i<aBaseTypeMLFB.length;i++)
		{
			if(aBaseTypeMLFB[i] != ".")
			{
				as_mlfb[i]=aBaseTypeMLFB[i];
			}
		}
		
		s_mlfb="";
		for (var i=0;i<as_mlfb.length;i++)
			s_mlfb=s_mlfb+as_mlfb[i];

		return s_mlfb;
	}
	else if(isStartConfiguration=="1")
		return strBaseTypeMLFB;
	else
		return s_mlfb;
}

